---
title: "Compiler Error CS1041 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1041"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1041"
ms.assetid: 9f62c058-cd28-4cb5-835c-d0f25f4fd08e
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1041
Identifier expected, 'keyword' is a keyword  
  
 A reserved word for the C# language was found where an identifier was expected. Replace the [keyword](../../csharp/language-reference/keywords/index.md) with a user-specified identifier.  
  
## Example  
 The following sample generates CS1041:  
  
```  
// CS1041a.cs  
class MyClass  
{  
    public void f(int long)   // CS1041  
    // Try the following instead:  
    // public void f(int i)  
    {  
    }  
  
    public static void Main()  
    {  
    }  
}  
```  
  
## Example  
 When you are importing from another programming language that does not have the same set of reserved words, you can modify the reserved identifier with the @ prefix, as demonstrated in the following sample.  
  
 An identifier with an `@` prefix is called a verbatim identifier.  
  
```  
// CS1041b.cs  
class MyClass  
{  
    public void f(int long)   // CS1041  
    // Try the following instead:  
    // public void f(int @long)  
    {  
    }  
  
    public static void Main()  
    {  
    }  
}  
```