---
title: "Compiler Error CS1638 | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-csharp"

ms.topic: "article"
f1_keywords: 
  - "CS1638"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS1638"
ms.assetid: 5279c060-5be3-4c29-80cc-21326d4cffdb
caps.latest.revision: 7
author: "BillWagner"
ms.author: "wiwagn"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Compiler Error CS1638
'identifier' is a reserved identifier and cannot be used when ISO language version mode is used  
  
 When the ISO language compatibility option is specified by the **/langversion** compiler switch, any identifier with double underscores anywhere in the identifier will produce this error. To avoid this error, eliminate any identifiers with double underscores, or do not use the ISO-1 language version option.  
  
## Example  
 The following sample generates CS1638:  
  
```  
// CS1638.cs  
// compile with: /langversion:ISO-1  
class bad__identifer // CS1638 (double underscores are not ISO compliant)  
{  
}  
  
// Try this instead:  
//class GoodIdentifier  
//{  
//}  
  
class CMain  
{  
    public static void Main() { }  
}  
```  
  
## See Also  
 [/langversion (C# Compiler Options)](../../csharp/language-reference/compiler-options/langversion-compiler-option.md)