---
title: "As Clause (Visual Basic) | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net
ms.reviewer: ""
ms.suite: ""
ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vb.as"
dev_langs: 
  - "VB"
helpviewer_keywords: 
  - "constraints, Visual Basic generic types"
  - "As keyword, statement syntax"
  - "As keyword"
ms.assetid: b4281ec8-2be5-49f7-aae8-ae0a96265b0d
caps.latest.revision: 19
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# As Clause (Visual Basic)
Introduces an `As` clause, which identifies a data type in a declaration statement or a constraint list on a generic type parameter.  
  
## Remarks  
 The `As` keyword can be used in these contexts:  
  
 [Aggregate Clause](../../../visual-basic/language-reference/queries/aggregate-clause.md)  
  
 [Class Statement](../../../visual-basic/language-reference/statements/class-statement.md)  
  
 [Const Statement](../../../visual-basic/language-reference/statements/const-statement.md)  
  
 [Declare Statement](../../../visual-basic/language-reference/statements/declare-statement.md)  
  
 [Delegate Statement](../../../visual-basic/language-reference/statements/delegate-statement.md)  
  
 [Dim Statement](../../../visual-basic/language-reference/statements/dim-statement.md)  
  
 [Enum Statement](../../../visual-basic/language-reference/statements/enum-statement.md)  
  
 [Event Statement](../../../visual-basic/language-reference/statements/event-statement.md)  
  
 [For...Next Statements](../../../visual-basic/language-reference/statements/for-next-statement.md)  
  
 [For Each...Next Statements](../../../visual-basic/language-reference/statements/for-each-next-statement.md)  
  
 [From Clause](../../../visual-basic/language-reference/queries/from-clause.md)  
  
 [Function Statement](../../../visual-basic/language-reference/statements/function-statement.md)  
  
 [Group Join Clause](../../../visual-basic/language-reference/queries/group-join-clause.md)  
  
 [Interface Statement](../../../visual-basic/language-reference/statements/interface-statement.md)  
  
 [Operator Statement](../../../visual-basic/language-reference/statements/operator-statement.md)  
  
 [Property Statement](../../../visual-basic/language-reference/statements/property-statement.md)  
  
 [Structure Statement](../../../visual-basic/language-reference/statements/structure-statement.md)  
  
 [Sub Statement](../../../visual-basic/language-reference/statements/sub-statement.md)  
  
 [Try...Catch...Finally Statements](../../../visual-basic/language-reference/statements/try-catch-finally-statement.md)  
  
## See Also  
 [How to: Create a New Variable](../../../visual-basic/programming-guide/language-features/variables/how-to-create-a-new-variable.md)   
 [Data Types](../../../visual-basic/programming-guide/language-features/data-types/index.md)   
 [Variable Declaration](../../../visual-basic/programming-guide/language-features/variables/variable-declaration.md)   
 [Type List](../../../visual-basic/language-reference/statements/type-list.md)   
 [Generic Types in Visual Basic](../../../visual-basic/programming-guide/language-features/data-types/generic-types.md)   
 [Keywords](../../../visual-basic/language-reference/keywords/index.md)