---
title: "&#39;TryCast&#39; operand must be reference type, but &#39;&lt;typename&gt;&#39; is a value type | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "BC30792"
  - "vbc30792"
helpviewer_keywords: 
  - "BC30792"
ms.assetid: 3325fce5-dbc0-4d1d-9530-31f4720bfe6e
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# &#39;TryCast&#39; operand must be reference type, but &#39;&lt;typename&gt;&#39; is a value type
The `TryCast` operator is used with a value type for at least one of the arguments.  
  
 `TryCast` tests for an inheritance or implementation relationship between the two arguments. Therefore, it allows only reference types for the arguments. For more information, see [Value Types and Reference Types](../../visual-basic/programming-guide/language-features/data-types/value-types-and-reference-types.md).  
  
 **Error ID:** BC30792  
  
## To correct this error  
  
-   Use `DirectCast` or `CType` to perform the conversion. They both allow value types.  
  
## See Also  
 [TryCast Operator](../../visual-basic/language-reference/operators/trycast-operator.md)   
 [DirectCast Operator](../../visual-basic/language-reference/operators/directcast-operator.md)   
 [CType Function](../../visual-basic/language-reference/functions/ctype-function.md)   
 [Value Types and Reference Types](../../visual-basic/programming-guide/language-features/data-types/value-types-and-reference-types.md)