---
title: "Enum types cannot be nullable | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "vbc32129"
  - "bc32129"
helpviewer_keywords: 
  - "BC32129"
ms.assetid: 9e0fe5c9-72c7-4905-b177-d00cc3469ea9
caps.latest.revision: 6
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Enum types cannot be nullable
The underlying type that is used to declare an enumeration cannot be nullable. For example, the following code causes this error:  
  
```vb  
'' Not valid.  
' Enum exampleEnum As Integer?  
'     Member declarations.  
' End Enum  
```  
  
 **Error ID:** BC32129  
  
## To correct this error  
  
-   Do not use a nullable underlying type in an `Enum` declaration.  
  
## See Also  
 [Nullable Value Types](../../visual-basic/programming-guide/language-features/data-types/nullable-value-types.md)   
 [Enum Statement](../../visual-basic/language-reference/statements/enum-statement.md)