---
title: "Only conversion operators can be declared &#39;&lt;keyword&gt;&#39; | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
f1_keywords: 
  - "bc33019"
  - "vbc33019"
helpviewer_keywords: 
  - "BC33019"
ms.assetid: 946266fe-a909-41b1-aad4-f85dc8050b88
caps.latest.revision: 9
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Only conversion operators can be declared &#39;&lt;keyword&gt;&#39;
An [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md) specifies [Widening](../../visual-basic/language-reference/modifiers/widening.md) or [Narrowing](../../visual-basic/language-reference/modifiers/narrowing.md) when the operator is not a conversion operator.  
  
 Every operator must be declared as both [Public](../../visual-basic/language-reference/modifiers/public.md) and [Shared](../../visual-basic/language-reference/modifiers/shared.md). However, only a conversion operator can be declared with [Widening](../../visual-basic/language-reference/modifiers/widening.md) or [Narrowing](../../visual-basic/language-reference/modifiers/narrowing.md), but not both.  
  
 An operator definition can optionally include the [Overloads](../../visual-basic/language-reference/modifiers/overloads.md) and [Shadows](../../visual-basic/language-reference/modifiers/shadows.md) keywords. No other keywords are permitted in an [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md).  
  
 **Error ID:** BC33019  
  
## To correct this error  
  
1.  Remove the `Widening` or `Narrowing` keyword from the operator definition. These do not apply, because no type conversion is taking place.  
  
## See Also  
 [Operator Procedures](../../visual-basic/programming-guide/language-features/procedures/operator-procedures.md)   
 [Operator Statement](../../visual-basic/language-reference/statements/operator-statement.md)   
 [How to: Define an Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-an-operator.md)   
 [How to: Define a Conversion Operator](../../visual-basic/programming-guide/language-features/procedures/how-to-define-a-conversion-operator.md)   
 [Type Conversions in Visual Basic](../../visual-basic/programming-guide/language-features/data-types/type-conversions.md)