---
title: "Visual Basic Run-Time Messages | Microsoft Docs"

ms.date: "2015-07-20"
ms.prod: .net


ms.technology: 
  - "devlang-visual-basic"

ms.topic: "article"
helpviewer_keywords: 
  - "errors [Visual Basic], run-time"
  - "run-time errors, Visual Basic"
ms.assetid: 130f7c2b-8eb1-4a6e-81aa-e30e27d3d4f7
caps.latest.revision: 8
author: "stevehoag"
ms.author: "shoag"

translation.priority.ht: 
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "ru-ru"
  - "zh-cn"
  - "zh-tw"
translation.priority.mt: 
  - "cs-cz"
  - "pl-pl"
  - "pt-br"
  - "tr-tr"
---
# Visual Basic Run-Time Messages
This section contains the [!INCLUDE[vbprvb](../../csharp/programming-guide/concepts/linq/includes/vbprvb_md.md)] error messages that occur at run time.  
  
 [\<address> is not a valid remote file address](../../visual-basic/misc/address-is-not-a-valid-remote-file-address.md)  
  
 [A delimiter cannot be Nothing or an empty String](../../visual-basic/misc/a-delimiter-cannot-be-nothing-or-an-empty-string.md)  
  
 [A double quote is not a valid comment token for delimited fields where EscapeQuote is set to True](../../visual-basic/language-reference/error-messages/a-double-quote-is-not-a-valid-comment-token-for-delimited-fields.md)  
  
 [A log has already been created with this name on this machine](../../visual-basic/misc/a-log-has-already-been-created-with-this-name-on-this-machine.md)  
  
 [A property or method call cannot include a reference to a private object, either as an argument or as a return value](../../visual-basic/language-reference/error-messages/a-property-or-method-call-cannot-include-a-reference-to-a-private-object.md)  
  
 [A startup form has not been specified](../../visual-basic/language-reference/error-messages/a-startup-form-has-not-been-specified.md)  
  
 [Access denied to '\<name>'](../../visual-basic/misc/access-denied-to-name.md)  
  
 [Add failed. Duplicate key value supplied](../../visual-basic/misc/add-failed-duplicate-key-value-supplied.md)  
  
 [All field widths, except the last element, must be greater than zero](../../visual-basic/misc/all-field-widths-except-the-last-element-must-be-greater-than-zero.md)  
  
 [An invalid name was specified for the event log](../../visual-basic/misc/an-invalid-name-was-specified-for-the-event-log.md)  
  
 [An unexpected error has occurred because an operating system resource required for single instance startup cannot be acquired](../../visual-basic/language-reference/error-messages/an-unexpected-error-has-occurred.md)  
  
 [Another event log has already registered a source with this name](../../visual-basic/misc/another-event-log-has-already-registered-a-source-with-this-name.md)  
  
 [Application-defined or object-defined error](../../visual-basic/misc/application-defined-or-object-defined-error.md)  
  
 [Argument '\<argument1>' must be less than or equal to the length of argument '\<argument2>'](../../visual-basic/misc/argument-argument1-must-be-less-than-or-equal-to-the-length-of-argument2.md)  
  
 [Argument '\<argumentname>' cannot be a multidimensional array](../../visual-basic/misc/argument-argumentname-cannot-be-a-multidimensional-array.md)  
  
 [Argument \<argumentname> cannot be an empty string or Nothing](../../visual-basic/misc/argument-argumentname-cannot-be-an-empty-string-or-nothing.md)  
  
 [Argument '\<argumentname>' cannot be converted to a numeric value](../../visual-basic/misc/argument-argumentname-cannot-be-converted-to-a-numeric-value.md)  
  
 [Argument '\<argumentname>' cannot be converted to type '\<typename>'](../../visual-basic/misc/argument-argumentname-cannot-be-converted-to-type-typename.md)  
  
 [Argument '\<argumentname>' cannot be converted to type 'Date'](../../visual-basic/misc/argument-argumentname-cannot-be-converted-to-type-date.md)  
  
 [Argument '\<argumentname>' is not a valid value](../../visual-basic/misc/argument-argumentname-is-not-a-valid-value.md)  
  
 [Argument '\<argumentname>' is not valid for the array](../../visual-basic/misc/argument-argumentname-is-not-valid-for-the-array.md)  
  
 [Argument '\<argumentname>' is Nothing](../../visual-basic/misc/argument-argumentname-is-nothing.md)  
  
 [Argument '\<argumentname>' is Nothing or empty](../../visual-basic/misc/argument-argumentname-is-nothing-or-empty.md)  
  
 [Argument '\<argumentname>' must be greater than 0 or equal to -1](../../visual-basic/misc/argument-argumentname-must-be-greater-than-0-or-equal-to-1.md)  
  
 [Argument '\<argumentname>' must be greater than or equal to 1](../../visual-basic/misc/argument-argumentname-must-be-greater-than-or-equal-to-1.md)  
  
 [Argument '\<argumentname>' must be greater than or equal to -1](../../visual-basic/misc/argument-argumentname-must-be-greater-than-or-equal-to-1-1.md)  
  
 [Argument \<argumentname> must be greater than or equal to zero](../../visual-basic/misc/argument-argumentname-must-be-greater-than-or-equal-to-zero-1.md)  
  
 [Argument '\<argumentname>' must be greater than or equal to zero](../../visual-basic/misc/argument-argumentname-must-be-greater-than-or-equal-to-zero.md)  
  
 [Argument '\<argumentname>' must be greater than zero](../../visual-basic/misc/argument-argumentname-must-be-greater-than-zero.md)  
  
 [Argument '\<argumentname>' must be in the range of -32768 to 65535](../../visual-basic/misc/argument-argumentname-must-be-in-the-range-of-32768-to-65535.md)  
  
 [Argument '\<argumentname>' must be within the range 0 to 99](../../visual-basic/misc/argument-argumentname-must-be-within-the-range-0-to-99.md)  
  
 [Argument '\<argumentname>' must be within the range 1 to 255](../../visual-basic/misc/argument-argumentname-must-be-within-the-range-1-to-255.md)  
  
 [Argument '\<argumentname1>' must be less than or equal the length of argument '\<argumentname2>'](../../visual-basic/misc/argument-argumentname1-must-be-less-than-or-equal-the-length-of-argumentname2.md)  
  
 [Argument 'Access' is not valid. Valid values for Append mode are 'OpenAccess.Write' and 'OpenAccess.Default'](../../visual-basic/misc/argument-access-is-not-valid-append-mode.md)  
  
 [Argument 'Access' is not valid. Valid values for Input mode are 'OpenAccess.Read' and 'OpenAccess.Default'](../../visual-basic/misc/argument-access-is-not-valid-input-mode.md)  
  
 [Argument 'Access' is not valid. Valid values for Output mode are 'OpenAccess.Write' and 'OpenAccess.Default'](../../visual-basic/misc/argument-access-is-not-valid.md)  
  
 [Argument BasePath must be a path to a folder](../../visual-basic/misc/argument-basepath-must-be-a-path-to-a-folder.md)  
  
 [Argument cannot be an empty string](../../visual-basic/misc/argument-cannot-be-an-empty-string.md)  
  
 [Argument cannot be less than zero](../../visual-basic/misc/argument-cannot-be-less-than-zero.md)  
  
 [Argument cannot be Nothing](../../visual-basic/misc/argument-cannot-be-nothing.md)  
  
 [Argument 'Conversion' is not valid](../../visual-basic/misc/argument-conversion-is-not-valid.md)  
  
 [Argument 'Life' cannot be zero](../../visual-basic/misc/argument-life-cannot-be-zero.md)  
  
 [Argument not optional (Visual Basic)](../../visual-basic/language-reference/error-messages/argument-not-optional.md)  
  
 [Argument 'NPer' must be greater than zero](../../visual-basic/misc/argument-nper-must-be-greater-than-zero.md)  
  
 [Argument 'Path' is Nothing or empty](../../visual-basic/misc/argument-path-is-nothing-or-empty.md)  
  
 [Argument 'Per' is not valid](../../visual-basic/misc/argument-per-is-not-valid.md)  
  
 [Argument 'Period' must be less than or equal to argument 'Life'](../../visual-basic/misc/argument-period-must-be-less-than-or-equal-to-argument-life.md)  
  
 [Argument value '\<pathname>' contains characters that are not valid in a path name](../../visual-basic/misc/argument-value-pathname-contains-characters-that-are-not-valid-in-a-path-name.md)  
  
 [Arguments are not valid](../../visual-basic/misc/arguments-are-not-valid.md)  
  
 [Array dimensions do not match those specified in the 'VBFixedArray' attribute](../../visual-basic/misc/array-dimensions-do-not-match-those-specified-in-the-vbfixedarray-attribute.md)  
  
 [Automation error](../../visual-basic/language-reference/error-messages/automation-error.md)  
  
 [Automation object does not have a default value](../../visual-basic/misc/automation-object-does-not-have-a-default-value.md)  
  
 [Bad DLL calling convention](../../visual-basic/language-reference/error-messages/bad-dll-calling-convention.md)  
  
 [Bad file mode](../../visual-basic/language-reference/error-messages/bad-file-mode.md)  
  
 [Bad file name or number](../../visual-basic/language-reference/error-messages/bad-file-name-or-number.md)  
  
 [Bad record length](../../visual-basic/language-reference/error-messages/bad-record-length.md)  
  
 [Bad record number](../../visual-basic/misc/bad-record-number.md)  
  
 [BaseLogName cannot be Nothing or an empty String](../../visual-basic/misc/baselogname-cannot-be-nothing-or-an-empty-string.md)  
  
 [BaudRate must be greater than 0](../../visual-basic/misc/baudrate-must-be-greater-than-0.md)  
  
 ['Before' and 'After' arguments cannot be combined](../../visual-basic/misc/before-and-after-arguments-cannot-be-combined.md)  
  
 [Cannot calculate number of periods using the arguments provided](../../visual-basic/misc/cannot-calculate-number-of-periods-using-the-arguments-provided.md)  
  
 [Cannot calculate rate using the arguments provided](../../visual-basic/misc/cannot-calculate-rate-using-the-arguments-provided.md)  
  
 [Cannot call friend function on object which is not an instance of defining class](../../visual-basic/misc/cannot-call-friend-function-on-object-which-is-not-instance-of-defining-class.md)  
  
 [Cannot convert argument '\<argumentname>' of type '\<type1>' to type '\<type2>'](../../visual-basic/misc/cannot-convert-argument-argumentname-of-type-type1-to-type-type2.md)  
  
 [Cannot convert start value of type '\<type1>' and step value of type '\<type2>' to a common type](../../visual-basic/misc/cannot-convert-start-value-of-type1-and-step-value-of-type2-to-a-common-type.md)  
  
 [Cannot convert start value of type '\<type1>', limit value of '\<type2>' and step value of '\<type3>' to a common type](../../visual-basic/misc/cannot-convert-start-value-to-a-common-type.md)  
  
 [Cannot create ActiveX Component](../../visual-basic/language-reference/error-messages/cannot-create-activex-component.md)  
  
 [Cannot delete a registry hive](../../visual-basic/misc/cannot-delete-a-registry-hive.md)  
  
 [Cannot determine array type because it is Nothing](../../visual-basic/misc/cannot-determine-array-type-because-it-is-nothing.md)  
  
 [Cannot rename with different drive](../../visual-basic/misc/cannot-rename-with-different-drive.md)  
  
 [Cannot save file to TEMP](../../visual-basic/misc/cannot-save-file-to-temp.md)  
  
 [Can't create necessary temporary file](../../visual-basic/language-reference/error-messages/can-t-create-necessary-temporary-file.md)  
  
 [Can't perform requested operation (Visual Basic)](../../visual-basic/misc/cant-perform-requested-operation.md)  
  
 [Cast from string "\<string>" to type '\<typename>' is not valid](../../visual-basic/misc/cast-from-string-string-to-type-typename-is-not-valid.md)  
  
 [Cast from type '\<typename1>' to type '\<typename2>' is not valid](../../visual-basic/misc/cast-from-type-typename1-to-type-typename2-is-not-valid.md)  
  
 [Class '\<classname>' does not implement the System.Collections.ICollection interface](../../visual-basic/misc/class-classname-does-not-implement-the-system-collections-icollection-interface.md)  
  
 [Class does not support Automation or does not support expected interface](../../visual-basic/language-reference/error-messages/class-does-not-support-automation-or-does-not-support-expected-interface.md)  
  
 [Class not registered on local machine](../../visual-basic/misc/class-not-registered-on-local-machine.md)  
  
 [Clipboard format is not valid](../../visual-basic/language-reference/error-messages/clipboard-format-is-not-valid.md)  
  
 [Code resource lock error](../../visual-basic/misc/code-resource-lock-error.md)  
  
 [Code resource not found](../../visual-basic/misc/code-resource-not-found.md)  
  
 [Collection index must be in the range 1 to the size of the collection](../../visual-basic/misc/collection-index-must-be-in-the-range-1-to-the-size-of-the-collection.md)  
  
 [Connection to type library or object library for remote process has been lost](../../visual-basic/misc/connection-to-type-library-or-object-library-for-remote-process-has-been-lost.md)  
  
 [Could not complete operation since target directory is under source directory](../../visual-basic/misc/could-not-complete-operation-since-target-directory-is-under-source-directory.md)  
  
 [Could not obtain full operation system name due to internal error](../../visual-basic/misc/could-not-obtain-full-operation-system-name-due-to-internal-error.md)  
  
 [Could not obtain memory information due to internal error](../../visual-basic/misc/could-not-obtain-memory-information-due-to-internal-error.md)  
  
 [DataBits must be greater than 0](../../visual-basic/misc/databits-must-be-greater-than-0.md)  
  
 [Device I/O error](../../visual-basic/language-reference/error-messages/device-i-o-error.md)  
  
 [Device unavailable](../../visual-basic/misc/device-unavailable.md)  
  
 ['Dir' function must first be called with a 'PathName' argument](../../visual-basic/language-reference/error-messages/dir-function-must-first-be-called-with-a-pathname-argument.md)  
  
 [Disk full (Visual Basic)](../../visual-basic/misc/disk-full.md)  
  
 [Disk not ready](../../visual-basic/misc/disk-not-ready.md)  
  
 [Division by zero (Visual Basic Error)](../../visual-basic/misc/division-by-zero-error.md)  
  
 [Division by zero (Visual Basic Run-Time Error)](../../visual-basic/misc/division-by-zero-run-time-error.md)  
  
 [Drive '\<drivename>' not found](../../visual-basic/misc/drive-drivename-not-found.md)  
  
 [Encoding cannot be set to Nothing](../../visual-basic/misc/encoding-cannot-be-set-to-nothing.md)  
  
 [Error in loading DLL (Visual Basic)](../../visual-basic/language-reference/error-messages/error-in-loading-dll.md)  
  
 [Error number must be within the range 0 and 65535](../../visual-basic/misc/error-number-must-be-within-the-range-0-and-65535.md)  
  
 [Expression '\<name>' is not a procedure, but occurs as the target of a procedure call](../../visual-basic/misc/expression-name-is-not-a-procedure-but-occurs-as-the-target-of-a-procedure-call.md)  
  
 [Expression too complex](../../visual-basic/language-reference/error-messages/expression-too-complex.md)  
  
 [Feature not yet implemented](../../visual-basic/misc/feature-not-yet-implemented.md)  
  
 [Field '\<fieldname>' of type '\<typename>' is 'ReadOnly'](../../visual-basic/misc/field-fieldname-of-type-typename-is-readonly.md)  
  
 [File '\<filename>' cannot be deleted because it is open](../../visual-basic/misc/file-filename-cannot-be-deleted-because-it-is-open.md)  
  
 [File '\<filename>' is write protected](../../visual-basic/misc/file-filename-is-write-protected.md)  
  
 [File '\<filename>' not found](../../visual-basic/misc/file-filename-not-found.md)  
  
 [File already exists](../../visual-basic/misc/file-already-exists.md)  
  
 [File already open](../../visual-basic/language-reference/error-messages/file-already-open.md)  
  
 [File format not valid](../../visual-basic/misc/file-format-not-valid.md)  
  
 [File I/O of a structure with field '\<fieldname>' of type '\<typename>' is not valid](../../visual-basic/misc/file-io-of-a-structure-with-field-fieldname-of-type-typename-is-not-valid.md)  
  
 [File I/O with type '\<typename>' is not valid](../../visual-basic/misc/file-i-o-with-type-typename-is-not-valid.md)  
  
 [File information cannot be queried if the file does not exist](../../visual-basic/misc/file-information-cannot-be-queried-if-the-file-does-not-exist.md)  
  
 [File information cannot be queried while open for writing](../../visual-basic/misc/file-information-cannot-be-queried-while-open-for-writing.md)  
  
 [File is too large to read into a byte array](../../visual-basic/language-reference/error-messages/file-is-too-large-to-read-into-a-byte-array.md)  
  
 [File name or class name not found during Automation operation (Visual Basic)](../../visual-basic/language-reference/error-messages/file-name-or-class-name-not-found-during-automation-operation.md)  
  
 [File not found (Visual Basic Run-Time Error)](../../visual-basic/language-reference/error-messages/file-not-found-visual-basic-run-time-error.md)  
  
 [File specified by FileName does not use the encoding specified by FileEncoding](../../visual-basic/misc/file-specified-by-filename-does-not-use-the-encoding-specified-by-fileencoding.md)  
  
 [File specified in FileName is not a valid XML file](../../visual-basic/misc/file-specified-in-filename-is-not-a-valid-xml-file.md)  
  
 [File's open mode wasn't set to a valid value](../../visual-basic/misc/file-s-open-mode-wasn-t-set-to-a-valid-value.md)  
  
 [For loop not initialized (Visual Basic)](../../visual-basic/misc/for-loop-not-initialized.md)  
  
 [Format not valid in resource file](../../visual-basic/misc/format-not-valid-in-resource-file.md)  
  
 [Get not supported (write-only property)](../../visual-basic/misc/get-not-supported-write-only-property.md)  
  
 [Get not supported at run time](../../visual-basic/misc/get-not-supported-at-run-time.md)  
  
 [Implicit reference to object under construction is not valid when calling another constructor](../../visual-basic/misc/bc31096.md)  
  
 [Input past end of file](../../visual-basic/language-reference/error-messages/input-past-end-of-file.md)  
  
 [Insufficient security permissions to set the system date](../../visual-basic/misc/insufficient-security-permissions-to-set-the-system-date.md)  
  
 [Insufficient security permissions to set the system time](../../visual-basic/misc/insufficient-security-permissions-to-set-the-system-time.md)  
  
 [Internal error (Visual Basic)](../../visual-basic/misc/internal-error.md)  
  
 [Internal error happened at \<location>](../../visual-basic/language-reference/error-messages/internal-error-happened-at-location.md)  
  
 [Internal error in the Microsoft Visual Basic runtime](../../visual-basic/misc/internal-error-in-the-microsoft-visual-basic-runtime.md)  
  
 [Invalid pattern string](../../visual-basic/misc/invalid-pattern-string.md)  
  
 [Key cannot be deleted because it has subkeys](../../visual-basic/misc/key-cannot-be-deleted-because-it-has-subkeys.md)  
  
 [Late-bound assignment to a field of value type '\<typename>' is not valid when '\<name>' is the result of a late-bound expression](../../visual-basic/misc/late-bound-assignment-to-a-field-of-value-type-typename-is-not-valid.md)  
  
 [Length of argument '\<argumentname>' must be greater than zero](../../visual-basic/misc/length-of-argument-argumentname-must-be-greater-than-zero.md)  
  
 [Line \<number> cannot be parsed using the current Delimiters](../../visual-basic/misc/line-number-cannot-be-parsed-using-the-current-delimiters.md)  
  
 [Line \<number> cannot be parsed using the current FieldWidths](../../visual-basic/misc/line-number-cannot-be-parsed-using-the-current-fieldwidths.md)  
  
 [Line \<number> cannot be read because it exceeds the maximum line size.](../../visual-basic/misc/line-number-cannot-be-read-because-it-exceeds-the-maximum-line-size.md)  
  
 [Locale ID '\<name>' is not supported on this system](../../visual-basic/misc/locale-id-name-is-not-supported-on-this-system.md)  
  
 [Loop control variable of type '\<typename>' does not implement the 'System.IComparable' interface](../../visual-basic/misc/loop-control-variable-of-type-typename-does-not-implement-system-icomparable.md)  
  
 [Managed classes derived from a COM class cannot be called late-bound.](../../visual-basic/misc/managed-classes-derived-from-a-com-class-cannot-be-called-late-bound.md)  
  
 [Method '\<methodname>' cannot be called with \<number> arguments](../../visual-basic/misc/method-methodname-cannot-be-called-with-number-arguments.md)  
  
 [Method '\<methodname>' has no parameter named '\<parametername>'](../../visual-basic/misc/method-methodname-has-no-parameter-named-parametername.md)  
  
 [Method or data member not found](../../visual-basic/misc/method-or-data-member-not-found.md)  
  
 [My.Application.Log cannot determine the amount of free disk space](../../visual-basic/misc/my-application-log-cannot-determine-the-amount-of-free-disk-space.md)  
  
 [Named argument '\<argumentname>' specified multiple times](../../visual-basic/misc/named-argument-argumentname-specified-multiple-times.md)  
  
 [Named argument not found (Visual Basic)](../../visual-basic/misc/named-argument-not-found.md)  
  
 [Named arguments cannot match ParamArray parameters](../../visual-basic/misc/named-arguments-cannot-match-paramarray-parameters.md)  
  
 [Need property array index](../../visual-basic/language-reference/error-messages/need-property-array-index.md)  
  
 [No accessible overloaded '\<methodname>' can be called with these arguments without a narrowing conversion](../../visual-basic/misc/no-accessible-overloaded-methodname-can-be-called-with-these-arguments.md)  
  
 [No accessible overloaded '\<methodname>' can be called with these arguments without a narrowing conversion: \<list>](../../visual-basic/misc/no-accessible-overloaded-methodname-can-be-called-with-these-arguments-list-2.md)  
  
 [No accessible overloaded '\<methodname>' can be called with these arguments without a widening conversion: \<list>](../../visual-basic/misc/no-accessible-overloaded-methodname-can-be-called-without-widening.md)  
  
 [No accessible overloaded '\<methodname>' can be called with these arguments: \<list>](../../visual-basic/misc/no-accessible-overloaded-methodname-can-be-called-with-these-arguments-list.md)  
  
 [No default member found for type '\<typename>'](../../visual-basic/misc/no-default-member-found-for-type-typename.md)  
  
 [No files found matching '\<filename>'](../../visual-basic/misc/no-files-found-matching-filename.md)  
  
 [No method '\<methodname>' can accept an argument of type '\<typename>' for parameter '\<parametername>'](../../visual-basic/misc/no-method-methodname-can-accept-an-argument-of-type-typename-for-parameter.md)  
  
 [No mouse is present](../../visual-basic/misc/no-mouse-is-present.md)  
  
 [No mouse wheel is present](../../visual-basic/misc/no-mouse-wheel-is-present.md)  
  
 [NumberOfChars must be greater than zero](../../visual-basic/misc/numberofchars-must-be-greater-than-zero.md)  
  
 [Object doesn't support current locale setting (Visual Basic)](../../visual-basic/misc/object-doesn-t-support-current-locale-setting.md)  
  
 [Object doesn't support named arguments](../../visual-basic/misc/object-doesn-t-support-named-arguments.md)  
  
 [Object doesn't support this action (Visual Basic)](../../visual-basic/misc/object-doesn-t-support-this-action.md)  
  
 [Object doesn't support this property or method (Visual Basic)](../../visual-basic/misc/object-doesn-t-support-this-property-or-method.md)  
  
 [Object or class does not support the set of events](../../visual-basic/language-reference/error-messages/object-or-class-does-not-support-the-set-of-events.md)  
  
 [Object required](../../visual-basic/language-reference/error-messages/object-required.md)  
  
 [Object variable or With block variable not set](../../visual-basic/language-reference/error-messages/object-variable-or-with-block-variable-not-set.md)  
  
 [One or more folders in the target path do not exist](../../visual-basic/misc/one-or-more-folders-in-the-target-path-do-not-exist.md)  
  
 [Only the first eight characters of a custom log name are significant](../../visual-basic/misc/only-the-first-eight-characters-of-a-custom-log-name-are-significant.md)  
  
 [Operator is not valid for '\<name1>' and '\<name2>'](../../visual-basic/misc/operator-is-not-valid-for-name1-and-name2.md)  
  
 [Operator is not valid for type '\<typename>'](../../visual-basic/misc/operator-is-not-valid-for-type-typename.md)  
  
 [Ordinal is not valid](../../visual-basic/language-reference/error-messages/ordinal-is-not-valid.md)  
  
 [Out of memory (Visual Basic Run-Time Error)](../../visual-basic/misc/out-of-memory-run-time-error.md)  
  
 [Out of stack space (Visual Basic)](../../visual-basic/language-reference/error-messages/out-of-stack-space.md)  
  
 [Out of string space (Visual Basic)](../../visual-basic/language-reference/error-messages/out-of-string-space.md)  
  
 [Overflow (Visual Basic Run-Time Error)](../../visual-basic/language-reference/error-messages/overflow-visual-basic-run-time-error.md)  
  
 [Path '\<pathname>' not found](../../visual-basic/misc/path-pathname-not-found.md)  
  
 [Path not found](../../visual-basic/language-reference/error-messages/path-not-found.md)  
  
 [Path/File access error](../../visual-basic/language-reference/error-messages/path-file-access-error.md)  
  
 [Permission denied (Visual Basic)](../../visual-basic/language-reference/error-messages/permission-denied.md)  
  
 [Picture is not valid](../../visual-basic/misc/picture-is-not-valid.md)  
  
 [Printer error](../../visual-basic/misc/printer-error.md)  
  
 [Procedure call or argument is not valid (Visual Basic)](../../visual-basic/language-reference/error-messages/procedure-call-or-argument-is-not-valid.md)  
  
 [Process '\<processname>' was not found](../../visual-basic/misc/process-processname-was-not-found.md)  
  
 [Property \<propertyname> cannot be set to an empty string or Nothing](../../visual-basic/misc/property-propertyname-cannot-be-set-to-an-empty-string-or-nothing.md)  
  
 [Property \<propertyname> cannot be set to Nothing](../../visual-basic/misc/property-propertyname-cannot-be-set-to-nothing.md)  
  
 [Property array index is not valid](../../visual-basic/language-reference/error-messages/property-array-index-is-not-valid.md)  
  
 [Property let procedure not defined and property get procedure did not return an object](../../visual-basic/language-reference/error-messages/property-let-procedure-not-defined-and-property-get-procedure-did-not-return.md)  
  
 [Property not found](../../visual-basic/language-reference/error-messages/property-not-found.md)  
  
 [Property or method not found](../../visual-basic/language-reference/error-messages/property-or-method-not-found.md)  
  
 [Property value is not valid](../../visual-basic/misc/property-value-is-not-valid.md)  
  
 [Public member '\<membername>' on type '\<typename>' not found](../../visual-basic/misc/public-member-membername-on-type-typename-not-found.md)  
  
 ['ReDim' can only change the right-most dimension](../../visual-basic/misc/redim-can-only-change-the-right-most-dimension.md)  
  
 ['ReDim' cannot change the number of dimensions](../../visual-basic/misc/redim-cannot-change-the-number-of-dimensions.md)  
  
 ['ReDim' Preserve operand cannot be Nothing](../../visual-basic/misc/redim-preserve-operand-cannot-be-nothing.md)  
  
 [Registry key '\<keyname>' could not be created](../../visual-basic/misc/registry-key-keyname-could-not-be-created.md)  
  
 [Registry key '\<keyname>' could not be found](../../visual-basic/misc/registry-key-keyname-could-not-be-found.md)  
  
 [Replacements too long](../../visual-basic/misc/replacements-too-long.md)  
  
 [Resume without error](../../visual-basic/language-reference/error-messages/resume-without-error.md)  
  
 [Root folder cannot be renamed](../../visual-basic/misc/root-folder-cannot-be-renamed.md)  
  
 [Search text not found](../../visual-basic/misc/search-text-not-found.md)  
  
 [Set not permitted](../../visual-basic/misc/set-not-permitted.md)  
  
 [Set not supported (read-only property)](../../visual-basic/misc/set-not-supported-read-only-property.md)  
  
 [Set not supported at run time](../../visual-basic/misc/set-not-supported-at-run-time.md)  
  
 [SimplifiedChinese and VbStrConv.TraditionalChinese cannot be combined](../../visual-basic/misc/simplifiedchinese-and-vbstrconv-traditionalchinese-cannot-be-combined.md)  
  
 [Some files and folders caused exceptions during the operation](../../visual-basic/misc/some-files-and-folders-caused-exceptions-during-the-operation.md)  
  
 [Some subkeys cannot be deleted](../../visual-basic/language-reference/error-messages/some-subkeys-cannot-be-deleted.md)  
  
 [Source folder and target folder are the same](../../visual-basic/misc/source-folder-and-target-folder-are-the-same.md)  
  
 [Source name specified in EventLogSource is registered to a log other than that specified in EventLogName](../../visual-basic/misc/source-name-specified-in-eventlogsource-is-registered-to-another-log.md)  
  
 [Specified DLL function not found](../../visual-basic/misc/specified-dll-function-not-found.md)  
  
 [Specified event log does not exist on this machine](../../visual-basic/misc/specified-event-log-does-not-exist-on-this-machine.md)  
  
 [Specified registry key does not exist](../../visual-basic/misc/specified-registry-key-does-not-exist.md)  
  
 [Specified registry key is not valid because it contains two or more consecutive backslashes](../../visual-basic/misc/specified-registry-key-is-not-valid.md)  
  
 [Specified registry path does not start with a valid hive name](../../visual-basic/misc/specified-registry-path-does-not-start-with-a-valid-hive-name.md)  
  
 [Stop statement encountered](../../visual-basic/misc/stop-statement-encountered.md)  
  
 ['StrConv.LinguisticCasing' requires 'StrConv.LowerCase' or 'StrConv.UpperCase'](../../visual-basic/misc/strconv-linguisticcasing-requires-strconv-lowercase-or-strconv-uppercase.md)  
  
 [String length exceeds maximum length of 32767 characters for 'FileSystem' APIs](../../visual-basic/misc/string-length-exceeds-maximum-length-of-32767-characters-for-filesystem-apis.md)  
  
 [Sub or Function not defined (Visual Basic)](../../visual-basic/language-reference/error-messages/sub-or-function-not-defined.md)  
  
 [Subscript out of range (Visual Basic)](../../visual-basic/language-reference/error-messages/subscript-out-of-range.md)  
  
 [System event log cannot be deleted](../../visual-basic/misc/system-event-log-cannot-be-deleted.md)  
  
 [Target folder is a file](../../visual-basic/misc/target-folder-is-a-file.md)  
  
 [TargetFilePath specifies an existing folder](../../visual-basic/misc/targetfilepath-specifies-an-existing-folder.md)  
  
 [TextFieldParser does not support comment tokens that contain whitespace](../../visual-basic/misc/textfieldparser-does-not-support-comment-tokens-that-contain-whitespace.md)  
  
 [TextFieldParser does not support delimiters that contain endline characters](../../visual-basic/misc/textfieldparser-does-not-support-delimiters-that-contain-endline-characters.md)  
  
 [TextFieldParser is unable to complete the read operation because maximum buffer size has been exceeded](../../visual-basic/language-reference/error-messages/textfieldparser-is-unable-to-complete-read-operation.md)  
  
 [The address for UploadFile needs to include a filename](../../visual-basic/misc/the-address-for-uploadfile-needs-to-include-a-filename.md)  
  
 [The ConnectionTimeout must be greater than 0](../../visual-basic/misc/the-connectiontimeout-must-be-greater-than-0.md)  
  
 [The file is already open](../../visual-basic/misc/the-file-is-already-open.md)  
  
 [The file is currently closed](../../visual-basic/misc/the-file-is-currently-closed.md)  
  
 [The file is currently open for reading](../../visual-basic/misc/the-file-is-currently-open-for-reading.md)  
  
 [The file is currently open for writing](../../visual-basic/misc/the-file-is-currently-open-for-writing.md)  
  
 [The folder cannot be created since a file already exists with the same path](../../visual-basic/misc/the-folder-cannot-be-created-since-a-file-already-exists-with-the-same-path.md)  
  
 [The input path refers to a file but ends with a directory separator character](../../visual-basic/misc/the-input-path-refers-to-a-file-but-ends-with-a-directory-separator-character.md)  
  
 [The path has not been set](../../visual-basic/misc/the-path-has-not-been-set.md)  
  
 [The remote server machine does not exist or is unavailable (Visual Basic)](../../visual-basic/misc/the-remote-server-machine-does-not-exist-or-is-unavailable.md)  
  
 [The source folder does not exist](../../visual-basic/misc/the-source-folder-does-not-exist.md)  
  
 [The specified path does not exist](../../visual-basic/misc/the-specified-path-does-not-exist.md)  
  
 [The stream passed to TextFieldParser cannot be read](../../visual-basic/misc/the-stream-passed-to-textfieldparser-cannot-be-read.md)  
  
 [The value of \<argumentname> must be a positive number](../../visual-basic/misc/the-value-of-argumentname-must-be-a-positive-number.md)  
  
 [The value of \<argumentname> must be greater than or equal to 1000](../../visual-basic/misc/the-value-of-argumentname-must-be-greater-than-or-equal-to-1000.md)  
  
 [This array is fixed or temporarily locked (Visual Basic)](../../visual-basic/language-reference/error-messages/this-array-is-fixed-or-temporarily-locked.md)  
  
 [This key is already associated with an element of this collection](../../visual-basic/language-reference/error-messages/this-key-is-already-associated-with-an-element-of-this-collection.md)  
  
 [This operation can only be done when the File is closed](../../visual-basic/misc/this-operation-can-only-be-done-when-the-file-is-closed.md)  
  
 [This single-instance application could not connect to the original instance](../../visual-basic/misc/this-single-instance-application-could-not-connect-to-the-original-instance.md)  
  
 [This system does not contain support for the Japanese locale](../../visual-basic/misc/this-system-does-not-contain-support-for-the-japanese-locale.md)  
  
 [This system does not contain support for the Locale specified](../../visual-basic/misc/this-system-does-not-contain-support-for-the-locale-specified.md)  
  
 [This system does not contain support for the SimplifiedChinese locale](../../visual-basic/misc/this-system-does-not-contain-support-for-the-simplifiedchinese-locale.md)  
  
 [This system does not contain support for the Traditional Chinese locale](../../visual-basic/misc/this-system-does-not-contain-support-for-the-traditional-chinese-locale.md)  
  
 [Too many DLL application clients](../../visual-basic/misc/too-many-dll-application-clients.md)  
  
 [Too many files](../../visual-basic/language-reference/error-messages/too-many-files.md)  
  
 [Type mismatch (Visual Basic)](../../visual-basic/language-reference/error-messages/type-mismatch.md)  
  
 [Type of argument '\<argumentname>' is '\<typename>', which is not numeric](../../visual-basic/misc/type-of-argument-argumentname-is-typename-which-is-not-numeric.md)  
  
 [Unable to get serial port names because of an internal system error](../../visual-basic/language-reference/error-messages/unable-to-get-serial-port-names-because-of-an-internal-system-error.md)  
  
 [Unable to obtain a stream for the log](../../visual-basic/misc/unable-to-obtain-a-stream-for-the-log.md)  
  
 [Unable to ping because a network connection is not available](../../visual-basic/misc/unable-to-ping-because-a-network-connection-is-not-available.md)  
  
 [Unable to read delimited fields because a double quote is not a legal delimiter when EscapeQuotes is set to True](../../visual-basic/misc/unable-to-read-delimited-fields.md)  
  
 [Unable to read delimited fields because Delimiters is Nothing or empty](../../visual-basic/misc/unable-to-read-delimited-fields-because-delimiters-is-nothing-or-empty.md)  
  
 [Unable to read fixed width fields because FieldWidths is Nothing or empty](../../visual-basic/misc/unable-to-read-fixed-width-fields-because-fieldwidths-is-nothing-or-empty.md)  
  
 [Unable to sink events of object because the object is already firing events to the maximum number of event receivers it supports](../../visual-basic/misc/unable-to-sink-events-of-object.md)  
  
 [Unable to write to log file because writing to it would cause it to exceed MaximumSize value](../../visual-basic/misc/unable-to-write-to-log-file-it-would-cause-it-to-exceed-maximumsize-value.md)  
  
 [Unable to write to log file because writing to it would reduce free disk space below ReservedSpace value](../../visual-basic/misc/unable-to-write-to-log-file-because-reduce-free-disk-space-below-reservedspace.md)  
  
 [Use 'FileGetObject' instead of 'FileGet' when using argument of type 'Object'](../../visual-basic/misc/use-filegetobject-instead-of-fileget-when-using-argument-of-type-object.md)  
  
 [Use 'FilePutObject' instead of 'FilePut' when using argument of type 'Object'](../../visual-basic/misc/use-fileputobject-instead-of-fileput-when-using-argument-of-type-object.md)  
  
 [Use of Default Instance of a class in the class constructor could lead to infinite recursive call](../../visual-basic/misc/use-of-default-instance-of-a-class-in-the-class-constructor.md)  
  
 [User interrupt occurred](../../visual-basic/misc/user-interrupt-occurred.md)  
  
 [Variable uses an Automation type not supported in Visual Basic](../../visual-basic/language-reference/error-messages/variable-uses-an-automation-type-not-supported.md)  
  
 [VbStrConv.Wide and VbStrConv.Narrow are not applicable to the locale specified](../../visual-basic/misc/vbstrconv-wide-and-vbstrconv-narrow-are-not-applicable-to-the-locale-specified.md)  
  
 [VbStrConv.Wide and VbStrConv.Narrow cannot be combined](../../visual-basic/misc/vbstrconv-wide-and-vbstrconv-narrow-cannot-be-combined.md)  
  
 [Wrong number of arguments or property assignment not valid](../../visual-basic/misc/wrong-number-of-arguments-or-property-assignment-not-valid.md)  
  
 [You must specify a file name](../../visual-basic/misc/you-must-specify-a-file-name.md)  
  
 [You must specify a name](../../visual-basic/misc/you-must-specify-a-name.md)  
  
 [You must specify a path that is under the current folder or one of its sub-folders](../../visual-basic/misc/you-must-specify-path-that-is-under-the-current-folder-or-one-of-sub-folders.md)  
  
## See Also  
 [NOTINBUILD How to: Get Information about Visual Basic Run-Time Errors](http://msdn.microsoft.com/en-us/22a7d0a6-b7d7-4c5d-971c-52ff0583c656)   
 [Error Messages](../../visual-basic/language-reference/error-messages/index.md)