/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.flink.cep;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.TypeExtractor;

import java.util.Objects;

/**
 * Exemplary event for usage in tests of CEP. See also {@link SubEvent}
 */
public class Event {
	private String name;
	private double price;
	private int id;

	public Event(int id, String name, double price) {
		this.id = id;
		this.name = name;
		this.price = price;
	}

	public double getPrice() {
		return price;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	@Override
	public String toString() {
		return "Event(" + id + ", " + name + ", " + price + ")";
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Event) {
			Event other = (Event) obj;

			return name.equals(other.name) && price == other.price && id == other.id;
		} else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return Objects.hash(name, price, id);
	}

	public static TypeSerializer<Event> createTypeSerializer() {
		TypeInformation<Event> typeInformation = (TypeInformation<Event>) TypeExtractor.createTypeInfo(Event.class);

		return typeInformation.createSerializer(new ExecutionConfig());
	}
}
