# Guides

```{eval-rst}
.. toctree::
  :maxdepth: 2
  :hidden:

  overview
  reactivity
  interactivity
  outputs
  editor_features
  dataframes
  plotting
  state
  apps
  scripts
  wasm
  best_practices
  deploying/index
```

These guides cover marimo's core concepts.

|                        |                                                         |
| :--------------------- | :------------------------------------------------------ |
| {doc}`overview`        | An overview of basic concepts                           |
| {doc}`reactivity`      | How reactive execution works                            |
| {doc}`interactivity`   | Using interactive UI elements                           |
| {doc}`outputs`         | Markdown, plots, and other visual outputs               |
| {doc}`editor_features` | View variables, cell dependencies, errors, and more     |
| {doc}`dataframes`      | Working with dataframes                                 |
| {doc}`plotting`        | Interactive and reactive plots                          |
| {doc}`state`           | Mutable, reactive state                                 |
| {doc}`apps`            | Running notebooks as apps                               |
| {doc}`scripts`         | Running notebooks as scripts                            |
| {doc}`best_practices`  | Best practices when working with marimo                 |
| {doc}`wasm`            | Running notebooks in the browser (no backend required!) |
| {doc}`deploying/index` | Deploying marimo notebooks and apps                     |

```{admonition} Learn by doing!
:class: tip

Prefer a hands-on learning experience? marimo comes packaged with interactive
tutorials that you can launch with `marimo tutorial` at the command line.
```
