Introduction
============
PAMI means PHP Asterisk Manager Interface. As its name suggests its just a
set of php classes that will let you issue commands to an ami and/or receive
events, using an observer-listener pattern.

The idea behind this, is to easily implement operator consoles, monitors, etc.
either via SOA or ajax.

A port for nodejs is available at: http://marcelog.github.com/Nami
A port for erlang is available at: https://github.com/marcelog/erlami

-------------------------------------------------------------------------------

Contact me
----------
If you have any questions, issues, feature requests, or just want to report
your "success story", or maybe even say hi, please send an email to
marcelog@gmail.com

Also, checkout the [Complete PAGI/PAMI talk for the PHP Conference Argentina 2013](http://www.slideshare.net/mgornstein/phpconf-2013). Check the slide notes for the complete text :)

-------------------------------------------------------------------------------

PHP Versions
------------
Note: PAMI Requires PHP 5.3+. PHP versions 5.3.9 and 5.3.10 WILL NOT WORK due
to a bug introduced in stream_get_line() in 5.3.9. Please use 5.3.11+ or up
to 5.3.8 (see README.PHP-5.3.9-and-5.3.10).

-------------------------------------------------------------------------------

CI Server
---------
Take a look at the Jenkins CI Server (http://ci.marcelog.name/) to check out
the docs, metrics, and pear and phar packages available.

-------------------------------------------------------------------------------

Available via Composer
----------------------
Just add the package "marcelog/pami":
```
    "require": {
        "marcelog/pami": "dev-master"
    }
```
Packagist URL: http://packagist.org/packages/marcelog/pami

-------------------------------------------------------------------------------

Available via PEAR
------------------
You can now easily install PAMI by issuing:
```
# pear channel-discover pear.marcelog.name
# pear install marcelog/PAMI
```

or
```
# pear install marcelog/PAMI-1.71
```
just replace 1.71 by the release version you'd like to install :)
See: http://pear.marcelog.name/

-------------------------------------------------------------------------------

Available as PHAR
-----------------
Just go to the Jenkins server at http://ci.marcelog.name and grab the latest
phar distribution from the PAMI job.

-------------------------------------------------------------------------------

Asterisk versions supported
===========================
PAMI is tested in asterisk 1.6, 1.4, and 1.8 versions, just because this are
the versions I use in my boxes. If you need support for other versions, please
contact me.

-------------------------------------------------------------------------------

QuickStart
==========
For an in-depth tutorial: http://marcelog.github.com/articles/pami_introduction_tutorial_how_to_install.html

```
$options = array(
    'log4php.properties' =>
         RESOURCES_DIR . DIRECTORY_SEPARATOR . 'log4php.properties',
    'host' => '2.3.4.5',
    'scheme' => 'tcp://',
    'port' => 9999,
    'username' => 'asd',
    'secret' => 'asd',
    'connect_timeout' => 10,
    'read_timeout' => 10
);
$client = new \PAMI\Client\Impl\ClientImpl($options);

// Registering a closure
$client->registerEventListener(function ($event) {
});

// Register a specific method of an object for event listening
$client->registerEventListener(array($listener, 'handle'));

// Register an IEventListener:
$client->registerEventListener($listener);
```

-------------------------------------------------------------------------------

Using Predicates
================
A second (optional) argument can be used when registering the event listener: a
closure that will be evaluated before calling the callback. The callback will 
be called only if this predicate returns true:

```
use PAMI\Message\Event\DialEvent;

$client->registerEventListener(
    array($listener, 'handleDialStart'),
    function ($event) {
        return $event instanceof DialEvent && $event->getSubEvent() == 'Begin';
    })
);
```

-------------------------------------------------------------------------------

Example
=======
Please see docs/examples/quickstart/example.php for a very basic example.

AsterTrace is a full application: https://github.com/marcelog/AsterTrace.

Also, you might want to look at this article: http://marcelog.github.com/articles/php_asterisk_listener_example_using_pami_and_ding.html

For an example of using asynchronous AGI with PAMI, see docs/examples/asyncagi

The [march edition](http://sdjournal.org/a-practical-introduction-to-functional-programming-with-php-sdj-issue-released/) of [Software Developer Journal](http://sdjournal.org/) features a complete article about writing telephony applications with PAMI and PAGI.

-------------------------------------------------------------------------------

Currently Supported Events
==========================
More events will be added with time. I can only add the ones I can test for and
use, so your contributions may make the difference! ;)

Unknown (not yet implemented) events will be reported as UnknownEvent, so you
can still catch them. If you catch one of these, please report it!

* AgentsComplete
* AgentConnect
* Agentlogin
* Agentlogoff
* AGIExec
* AsyncAGI
* Bridge
* CEL
* ChannelUpdate
* CoreShowChannel
* CoreShowChannelComplete
* DAHDIShowChannel
* DAHDIShowChannelsComplete
* FullyBooted
* DongleSMSStatus
* DongleUSSDStatus
* DongleNewUSSD
* DongleNewUSSDBase64
* DongleNewCUSD
* DongleStatus
* DongleDeviceEntry
* DongleShowDevicesComplete
* DBGetResponse
* Dial
* DTMF
* Extension
* Hangup
* Hold
* JabberEvent
* Join
* Leave
* Link
* ListDialplan
* Masquerade
* MessageWaiting
* MusicOnHold
* NewAccountCode
* NewCallerid
* Newchannel
* Newexten
* Newstate
* OriginateResponse
* ParkedCall
* ParkedCallsComplete
* PeerEntry
* PeerlistComplete
* PeerStatus
* QueueMember
* QueueMemberAdded
* QueueMemberRemoved
* QueueMemberPause
* QueueMemberStatus
* QueueParams
* QueueStatusComplete
* QueueSummaryComplete
* RegistrationsComplete
* Registry
* Rename
* RTCPReceived
* RTCPReceiver
* RTCPSent
* RTPReceiverStat
* RTPSenderStat
* ShowDialPlanComplete
* Status
* StatusComplete
* Transfer
* Unlink
* UnParkedCall
* UserEvent
* VarSet
* vgsm_me_state
* vgsm_net_state
* vgsm_sms_rx
* VoicemailUserEntry
* VoicemailUserEntryComplete

-------------------------------------------------------------------------------

Currently Supported Actions
===========================
* AbsoluteTimeout
* AGI
* Agents
* AgentLogoff
* Atxfer (asterisk 1.8?)
* Bridge
* ChangeMonitor
* Command
* ConfbridgeMute
* ConfbridgeUnmute
* CoreSettings
* CoreShowChannels
* CoreStatus
* DAHDIDialOffHookAction
* DAHDIHangup
* DAHDIRestart
* DAHDIShowChannels
* DAHDIDNDOn
* DAHDIDNDOff
* DBGet
* DBPut
* DBDel
* DBDelTree
* DongleSendSMS
* DongleSendUSSD
* DongleSendPDU
* DongleReload
* DongleStop
* DongleStart
* DongleRestart
* DongleReset
* DongleShowDevices
* ExtensionState
* CreateConfig
* GetConfig
* GetConfigJSON
* GetVar
* Hangup
* JabberSend
* LocalOptimizeAway
* Login
* Logoff
* ListCategories
* ListCommands
* MailboxCount
* MailboxStatus
* MeetmeList
* MeetmeMute
* MeetmeUnmute
* MixMonitor
* ModuleCheck
* ModuleLoad (split in ModuleLoad, ModuleUnload, and ModuleReload)
* Monitor
* Originate
* ParkedCalls
* PauseMonitor
* Ping
* PlayDTMF
* Queues
* QueueAdd
* Queue
* QueueLog
* QueuePause
* QueuePenalty
* QueueReload
* QueueRemove
* QueueReset
* QueueRule
* QueueSummary
* QueueStatus
* QueueUnpause
* Redirect
* Reload
* SendText
* SetVar
* ShowDialPlan
* Sipnotify
* Sippeers
* Sipqualifypeer
* Sipshowpeer
* Sipshowregistry
* Status
* StopMixMonitor
* StopMonitor
* UnpauseMonitor
* VGSM_SMS_TX
* VoicemailUsersList

-------------------------------------------------------------------------------

Developers
==========

* build.xml is a phing build file, not ant.
* It's very possible that you may need to edit build.properties and change
php.bin and pear.bin properties.
* Available main targets: all, build, test, report.
* Tools run: phpdoc, phploc, phpcs, phpmd, phpcpd, phpdepend, phpunit.
* Setup your installation by editing pear and php paths in build.properties
* Run phing install-dependencies this will install pear and everything needed
to run phing tests and metrics.
* Copy resources/php.ini.example to resources/php.ini and edit it.
* Run phing all
* Check the API at http://marcelog.github.com/PAMI/api.html

-------------------------------------------------------------------------------

Debugging, logging
==================

You need log4php (http://logging.apache.org/log4php/). Just make sure you copy
it to the include_path and PAMI will pick it up from there.

-------------------------------------------------------------------------------

LICENSE
=======
Copyright 2011 Marcelo Gornstein <marcelog@gmail.com>

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-------------------------------------------------------------------------------

Thanks To
=========

* Jason Blank <rumpled at github> for helping in the debugging of the queue
functionality and some other ami inconsistencies.

* Francesco Usseglio Gaudi, for help in debugging the Originate action.

* Matías Barletta, for the vgms support.

* Eli Hunter, for helping in bringing in tls compatibility.

* Freddy dafredmail at googlemail, for his help and testing environment to add
dongle support.

* Joshua Elson for his help in trying and debugging in loaded asterisk servers.

* Jacob Kiers for his help in bringing in and testing async agi functionality,
and CEL event
support.

* Richard Baar for noticing the lack of eof support when reading from socket,
the JabberEvent, and the ScreenName in JabberAction.

* Scot Opell for helping in debugging stream_get_line() in 5.3.9 and 5.3.10

* Brian (wormling) for trying and fixing bugs on asyncagi

* Henning Bragge for helping with newstate event and queues.

* mbonneau for ParkedCall and UnParkedCall events.
