/**
 * This file is part of alf.io.
 *
 * alf.io is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * alf.io is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with alf.io.  If not, see <http://www.gnu.org/licenses/>.
 */
package alfio.repository.user;

import alfio.datamapper.AutoGeneratedKey;
import alfio.datamapper.Bind;
import alfio.datamapper.Query;
import alfio.datamapper.QueryRepository;
import alfio.model.user.User;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;

@QueryRepository
public interface UserRepository {
    @Query("SELECT * FROM ba_user")
    List<User> findAll();

    @Query("SELECT * FROM ba_user WHERE id = :userId")
    User findById(@Bind("userId") int userId);

    @Query("select * from ba_user where username = :username")
    User getByUsername(@Bind("username") String username);

    @Query("select * from ba_user where username = :username")
    List<User> findByUsername(@Bind("username") String username);

    @Query("INSERT INTO ba_user(username, password, first_name, last_name, email_address, enabled) VALUES"
            + " (:username, :password, :first_name, :last_name, :email_address, :enabled)")
    @AutoGeneratedKey("id")
    Pair<Integer, Integer> create(@Bind("username") String username, @Bind("password") String password,
               @Bind("first_name") String firstname, @Bind("last_name") String lastname,
               @Bind("email_address") String emailAddress, @Bind("enabled") boolean enabled);

}
