This directory contains supporting code and tools for Mono AST checker analysis.

This tool uses [CppSharp](https://github.com/mono/CppSharp) to read the source code of Mono
into an AST. It is a work-in-progress and in development.

Right now the tool is OSX-specific but should easily work on other OS's provided you
compile the dependencies for your platform. Contact @tritao if you need assistance.

It relies on the presence of a compile_commands.json file which is a JSON compilation
database. I have provided a sample database generated by using [Bear](https://github.com/rizsotto/Bear)
on my machine.

## Building

First you'll need to build the tool by running `make`.

It will first clone the needed CppSharp binaries from the [CppSharpBinaries](https://github.com/tritao/CppSharpBinaries)
repository and then build the tool which should look like this:

```
mac:mono joao$ make
mcs MonoChecker.cs -r:CppSharp/CppSharp.dll -r:CppSharp/CppSharp.AST.dll -r:CppSharp/CppSharp.Parser.CSharp.dll -r:CppSharp/CppSharp.Generator.dll -r:Newtonsoft.Json.6.0.8/lib/net45/Newtonsoft.Json.dll
```

## Debugging

For easier debugging we can generate a Xamarin Studio project by running `make gen-proj`.

If everything works correctly, you should get an output like:

```
mac:aot joao$ make gen-proj
CppSharp/premake5 vs2012
Building configurations...
Running action 'vs2012'...
Generating MonoChecker.sln...
Generating MonoChecker.csproj...
Generating MonoChecker.csproj.user...
Done.
```

Then just load the solution in Xamarin Studio and you should be able to put breakpoints
and debug the code.