// Copyright 2010 the V8 project authors. All rights reserved.
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//     * Neither the name of Google Inc. nor the names of its
//       contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

// This file contains 100.000 decimal representations of random doubles. They
// have been generated using Gay's dtoa to produce the fixed representation:
//         dtoa(v, 3, number_digits, &decimal_point, &sign, nullptr);

#include "src/init/v8.h"

#include "test/cctest/gay-fixed.h"

namespace v8 {
namespace base {

static const PrecomputedFixed kFixedTestNumbers[] = {
  {3.3831671815188012695312500e+12, 2, "33831671815188", 13},
  {6.6336520115995179509212087e-08, 13, "663365", -7},
  {9.5272682545672953764716918e-12, 12, "1", -10},
  {4.9841402988132226055635983e-17, 18, "5", -16},
  {5.5567065195971976208966225e+04, 10, "55567065195972", 5},
  {4.9104496948979206577675857e-06, 16, "49104496949", -5},
  {3.3201849526148178100585938e+10, 15, "33201849526148178100585938", 11},
  {1.0763823300509811087977141e+05, 5, "10763823301", 6},
  {5.7566658010014374078778435e-21, 7, "", -7},
  {4.4522053704113441692420585e-22, 11, "", -11},
  {2.9987655603737279307097197e+05, 7, "2998765560374", 6},
  {4.8003206570135421886612002e-22, 2, "", -2},
  {3.5264274092038518750000000e+14, 3, "352642740920385188", 15},
  {1.7950381905756516482839877e-06, 5, "", -5},
  {1.5223827362137477393844165e+04, 19, "152238273621374773938442", 5},
  {6.9000318153219332254467145e-25, 0, "", 0},
  {1.7189048239317447630547520e-01, 17, "17189048239317448", 0},
  {6.3839563615044511854648590e+07, 12, "63839563615044511855", 8},
  {9.1193616301674545152000000e+19, 0, "91193616301674545152", 20},
  {3.8742733030609424531576224e+03, 14, "387427330306094245", 4},
  {2.9632075676930808341943013e-16, 13, "", -13},
  {1.0214690802570292136458585e-03, 1, "", -1},
  {1.2002490160553595699200000e+20, 11, "120024901605535956992", 21},
  {1.2532714671596547392068421e-03, 15, "125327146716", -2},
  {5.5607379380725792307349389e-18, 6, "", -6},
  {1.0906117333419780000000000e+16, 18, "1090611733341978", 17},
  {2.5283417241664493934893199e-22, 6, "", -6},
  {3.6174597185439385817340239e-12, 5, "", -5},
  {2.7264001074276206986698439e-16, 18, "273", -15},
  {5.4516442391198194827293386e-23, 11, "", -11},
  {3.7960824607766062761653904e-12, 10, "", -10},
  {3.9237910537314860871315020e-20, 11, "", -11},
  {7.5599098753701514521530572e-06, 10, "75599", -5},
  {9.5479706420957142967015363e-05, 2, "", -2},
  {2.2408351583231838149748279e-12, 0, "", 0},
  {2.1213945654234204503946545e-14, 5, "", -5},
  {3.0134079464150507428592409e-25, 20, "", -20},
  {5.4040956719115788800000000e+17, 10, "540409567191157888", 18},
  {1.9473073693308637605405601e-10, 16, "1947307", -9},
  {4.1501939700379796326160431e+07, 6, "4150193970038", 8},
  {3.4608659167475043332007356e-05, 10, "346087", -4},
  {2.8901046914596528529214133e-06, 11, "28901", -5},
  {2.2917399895460568631695837e-24, 4, "", -4},
  {1.4190629332123970380052924e+05, 2, "14190629", 6},
  {3.5270798938471071464452046e-24, 7, "", -7},
  {1.4206078795880712000000000e+17, 8, "14206078795880712", 18},
  {4.5281297678439813120000000e+18, 6, "4528129767843981312", 19},
  {3.1224513642477845954022186e-05, 10, "312245", -4},
  {4.8184662102767651659096515e-04, 19, "4818466210276765", -3},
  {2.3994634581213830680848642e-05, 5, "2", -4},
  {8.8542098092391940955536711e-02, 18, "88542098092391941", -1},
  {5.3723698087028667187200000e+20, 18, "537236980870286671872", 21},
  {1.4124481890311051874892408e-05, 13, "141244819", -4},
  {1.2560868646257232157234815e-08, 2, "", -2},
  {3.2969008954989711360000000e+18, 3, "3296900895498971136", 19},
  {1.2897899252746862617333836e-11, 14, "129", -10},
  {1.5851808323022507871829358e-24, 18, "", -18},
  {3.6044438440996938152238727e+05, 13, "3604443844099693815", 6},
  {7.3834019095011149680374274e-01, 15, "738340190950111", 0},
  {1.8534457765231180800000000e+18, 0, "185344577652311808", 19},
  {1.3036086798096085555602984e-14, 5, "", -5},
  {6.8366806754097264640000000e+18, 20, "6836680675409726464", 19},
  {1.8097184247068291443049085e-09, 6, "", -6},
  {1.7217755406130052309794443e-15, 20, "172178", -14},
  {3.5882578140235449704223259e-24, 15, "", -15},
  {6.1335653680739776000000000e+17, 17, "61335653680739776", 18},
  {9.1022946537954569986230862e-21, 8, "", -8},
  {7.3131970558145258110016584e+04, 7, "731319705581", 5},
  {1.2113449620203359309629696e-25, 12, "", -12},
  {1.5798859598969343664975895e+00, 3, "158", 1},
  {5.0813068520260342252731732e-06, 4, "", -4},
  {1.2542380640419709108825076e-06, 1, "", -1},
  {2.5234102601179311991432374e-17, 1, "", -1},
  {1.4121549845416071987200000e+20, 6, "141215498454160719872", 21},
  {4.7882613737425489100800000e+20, 15, "478826137374254891008", 21},
  {2.1626350759996771761862586e-17, 11, "", -11},
  {1.6414006087460717431270041e+00, 19, "16414006087460717431", 1},
  {4.5361128636816219539998116e-23, 3, "", -3},
  {7.2735863867313000000000000e+15, 17, "72735863867313", 16},
  {8.0304628746085993107328704e-01, 17, "80304628746085993", 0},
  {1.7635161128880073550274639e-07, 0, "", 0},
  {2.6595496455345386813597399e-11, 12, "27", -10},
  {2.4101037841260125248068991e-17, 15, "", -15},
  {4.1107717582186380237048047e-13, 10, "", -10},
  {8.8995580590833796406736514e-19, 4, "", -4},
  {2.0914671392174199127111933e+01, 11, "2091467139217", 2},
  {2.0009613495402837554659747e-03, 15, "200096134954", -2},
  {1.6938779113170488939078514e-16, 2, "", -2},
  {5.8952117497404695312500000e+13, 19, "589521174974046953125", 14},
  {3.8570274835217771530151367e+09, 20, "385702748352177715301513671875", 10},
  {4.1471840195422703017086694e-13, 5, "", -5},
  {2.0993395069684979772905997e-03, 13, "2099339507", -2},
  {5.5766955004207104679172822e-09, 7, "", -7},
  {6.6931607225485343951731920e+05, 14, "66931607225485343952", 6},
  {1.6032543002557476856541661e-18, 13, "", -13},
  {1.0952163279330218159657306e-01, 4, "1095", 0},
  {5.9115686770881026983261108e+07, 4, "591156867709", 8},
  {1.4611977142167729581956337e+01, 19, "14611977142167729582", 2},
  {1.8403884352113170755887048e-17, 7, "", -7},
  {6.1593329939462579200000000e+17, 8, "615933299394625792", 18},
  {5.7047053101680171489715576e+08, 4, "5704705310168", 9},
  {1.3261286743920106000000000e+16, 4, "13261286743920106", 17},
  {1.0929164126882341537645069e-24, 12, "", -12},
  {7.6140695873445726203974923e-25, 4, "", -4},
  {8.4354388134942532717116778e-19, 13, "", -13},
  {1.7705045161451824844582371e-10, 12, "177", -9},
  {1.4880751226717142051628936e-21, 9, "", -9},
  {1.3964327111550966789292362e-14, 7, "", -7},
  {2.2144802189819714523244532e-03, 18, "2214480218981971", -2},
  {9.5948768656345468480139971e+05, 6, "959487686563", 6},
  {1.2503288376063125042492175e+02, 17, "12503288376063125042", 3},
  {3.9972488070634699941496848e-03, 1, "", -1},
  {4.7255968912832667375282580e-14, 2, "", -2},
  {1.1299384774525735863903719e+00, 9, "1129938477", 1},
  {9.2628617333939845629077729e-10, 0, "", 0},
  {5.9858471663241181928011292e-04, 13, "5985847166", -3},
  {1.2463762619502296356500913e-19, 14, "", -14},
  {1.0680175344129960983991623e+07, 8, "1068017534412996", 8},
  {5.4352221854741964489221573e+06, 16, "54352221854741964489222", 7},
  {1.9305774853762348910422960e-25, 4, "", -4},
  {1.3213268824321876312297703e-11, 10, "", -10},
  {5.2640143935748890000000000e+15, 9, "5264014393574889", 16},
  {6.6142638526627683639526367e+08, 18, "661426385266276836395263672", 9},
  {3.1368662210752113342285156e+10, 18, "3136866221075211334228515625", 11},
  {1.1582551737676625920000000e+18, 6, "1158255173767662592", 19},
  {1.6254431310797307904000000e+19, 1, "16254431310797307904", 20},
  {5.7862282353719001154294943e-05, 6, "58", -4},
  {2.0169260185533577500000000e+15, 10, "201692601855335775", 16},
  {9.4052052008856257445284494e-25, 15, "", -15},
  {1.2642910662179308864459630e-05, 10, "126429", -4},
  {1.4507307446793091366998851e+05, 3, "145073074", 6},
  {1.3561940461288199519162671e-11, 10, "", -10},
  {7.0141472478594906192483904e+01, 3, "70141", 2},
  {1.4424311556076677500000000e+15, 2, "144243115560766775", 16},
  {2.6624630288203108768104088e-17, 2, "", -2},
  {1.9672898210650612792968750e+12, 10, "19672898210650612792969", 13},
  {6.0451363370732295152265579e+04, 18, "60451363370732295152266", 5},
  {2.0221778386268979624262876e-04, 18, "20221778386269", -3},
  {3.3373938250735634937882423e+05, 16, "3337393825073563493788", 6},
  {1.7118396920196160678281526e-06, 7, "17", -5},
  {6.6182791405781114008277655e+05, 14, "66182791405781114008", 6},
  {1.0045733935141063309630930e-07, 13, "1004573", -6},
  {1.0116919511705794199623708e-25, 2, "", -2},
  {3.4004358044233266854282968e-06, 9, "34", -5},
  {5.2617685342884970703125000e+12, 11, "52617685342884970703125", 13},
  {6.4921701091538345610920186e-09, 15, "649217", -8},
  {2.5778852871242243410864273e-05, 0, "", 0},
  {2.8246582215737890518550396e-10, 10, "3", -9},
  {1.5135758529656283258158617e-07, 7, "2", -6},
  {1.3343025399887900774365890e-20, 3, "", -3},
  {2.8278155616716954880284878e-11, 1, "", -1},
  {5.6378829490276199942755397e-02, 0, "", 0},
  {1.2868269024563838266408552e-25, 0, "", 0},
  {3.6166256007503268750000000e+14, 14, "3616625600750326875", 15},
  {1.2928764000372916052583605e+05, 13, "1292876400037291605", 6},
  {1.0676395469783407500000000e+15, 5, "106763954697834075", 16},
  {4.9954954330023173270092229e+02, 20, "49954954330023173270092", 3},
  {4.6444597190569909409139053e-11, 16, "464446", -10},
  {1.5480660915963378491890141e-06, 6, "2", -5},
  {1.4514592337731665000000000e+15, 13, "14514592337731665", 16},
  {4.0505605256757553710937500e+12, 5, "405056052567575537", 13},
  {6.3806276212447906494140625e+10, 11, "6380627621244790649414", 11},
  {6.8553398114291289062500000e+13, 20, "685533981142912890625", 14},
  {1.9031459984169772949218750e+12, 3, "1903145998416977", 13},
  {2.0874315309021840213311050e-22, 6, "", -6},
  {1.9692844090873872397466595e-10, 1, "", -1},
  {3.8893196328943255000000000e+15, 14, "38893196328943255", 16},
  {9.8324604625011558532714844e+09, 20, "9832460462501155853271484375", 10},
  {2.8771219339319028222234920e+04, 10, "28771219339319", 5},
  {7.3457474264623248000000000e+16, 10, "73457474264623248", 17},
  {3.7273775361248293658978065e-11, 12, "37", -10},
  {2.9130692671725196305487771e+03, 20, "291306926717251963054878", 4},
  {1.6431834096448312276805837e+00, 14, "164318340964483", 1},
  {4.9356541931380421417032509e-17, 18, "49", -16},
  {4.2731741486511391401290894e+08, 19, "4273174148651139140129089355", 9},
  {8.4546040861937177734375000e+12, 13, "84546040861937177734375", 13},
  {1.2951736554037045316689908e-14, 10, "", -10},
  {8.9771194677615917968750000e+11, 7, "8977119467761591797", 12},
  {5.3226887919510871134643956e-06, 6, "5", -5},
  {1.4207285173359171630567012e-16, 9, "", -9},
  {6.3787190685416415333747864e+07, 20, "6378719068541641533374786377", 8},
  {2.1888004928833254238427763e-09, 6, "", -6},
  {7.4145695027005315913048512e-08, 17, "7414569503", -7},
  {6.3774948173026490585399991e-25, 2, "", -2},
  {2.4649784218832827775713668e+01, 2, "2465", 2},
  {4.3941934218409529600000000e+17, 16, "439419342184095296", 18},
  {2.7985286096439249863339367e-20, 20, "3", -19},
  {1.1402300461518555323025160e-07, 18, "114023004615", -6},
  {1.2210797779666126428462330e-20, 1, "", -1},
  {3.2467848990623744000000000e+19, 15, "32467848990623744", 20},
  {1.8002495001504619231980087e+00, 20, "18002495001504619232", 1},
  {8.9936094972024887500000000e+14, 14, "899360949720248875", 15},
  {7.2990991639792275303146894e-13, 19, "7299099", -12},
  {6.1424251973058772992000000e+19, 6, "61424251973058772992", 20},
  {3.0991608445670382812500000e+13, 19, "309916084456703828125", 14},
  {3.6834034437956632153208939e-07, 6, "", -6},
  {1.0501779976355870737446294e-16, 14, "", -14},
  {7.3140995548782427210832664e-09, 8, "1", -7},
  {1.3813354552642654400000000e+17, 2, "138133545526426544", 18},
  {1.0142048016450877102923291e-23, 4, "", -4},
  {6.5438725968370177979272920e-13, 19, "6543873", -12},
  {3.6967369327857186201563566e-04, 16, "3696736932786", -3},
  {7.2828404557714341888000000e+19, 15, "72828404557714341888", 20},
  {1.2212108055027883911132812e+11, 13, "1221210805502788391113281", 12},
  {1.3401053941016547454978536e+01, 7, "134010539", 2},
  {2.1724905024900357033978970e-03, 18, "2172490502490036", -2},
  {8.0803951093300856882706285e+03, 19, "80803951093300856882706", 4},
  {4.5969500923253701785142766e+02, 15, "459695009232537018", 3},
  {1.3868155087243519045843509e-14, 15, "14", -13},
  {1.2359729902963124166802604e-07, 8, "12", -6},
  {1.5818447566466890595682600e-19, 8, "", -8},
  {4.7651086083820712381173263e-13, 8, "", -8},
  {7.3969147645907158203125000e+12, 2, "739691476459072", 13},
  {2.1188426160157262500000000e+15, 3, "211884261601572625", 16},
  {6.8529487180597614681687446e+00, 10, "68529487181", 1},
  {2.0660268075938550604549156e-09, 2, "", -2},
  {1.3433242572017365811200000e+20, 12, "134332425720173658112", 21},
  {2.9002890347293918327623241e-17, 17, "3", -16},
  {1.1279459380144599869603835e-16, 4, "", -4},
  {2.1070726795590904355049133e+08, 19, "210707267955909043550491333", 9},
  {7.5267764089994978904724121e+08, 2, "7526776409", 9},
  {3.6097454332913807360000000e+19, 7, "3609745433291380736", 20},
  {5.2926805003219556944316082e-01, 16, "5292680500321956", 0},
  {8.9363677329360468191263078e-09, 9, "9", -8},
  {2.8222931466159600116107255e-22, 20, "", -20},
  {1.4546040920223487765022797e-20, 13, "", -13},
  {1.8589410713265433739182569e-11, 7, "", -7},
  {1.2084295498025406701003703e+01, 12, "12084295498025", 2},
  {4.3401521679778678475258857e+00, 5, "434015", 1},
  {4.2852574152516575978211222e-01, 16, "4285257415251658", 0},
  {1.1260860143722513071235979e-09, 1, "", -1},
  {2.9167677798337560576000000e+20, 15, "29167677798337560576", 21},
  {4.4272500418027791267737559e-25, 11, "", -11},
  {8.3947115097384701768623167e-21, 4, "", -4},
  {1.0343380279944637644800000e+20, 5, "103433802799446376448", 21},
  {6.5402105087171250374922238e+01, 17, "6540210508717125037", 2},
  {3.1025406722371033538365737e+04, 15, "31025406722371033538", 5},
  {5.3963389836780800000000000e+18, 13, "539633898367808", 19},
  {2.1795959610932865235213848e-18, 8, "", -8},
  {6.2167530047603133425582200e+04, 7, "621675300476", 5},
  {2.0818189944930562048000000e+19, 7, "20818189944930562048", 20},
  {1.1334484383814122766011686e-13, 8, "", -8},
  {3.5405135100601997274390662e-15, 20, "354051", -14},
  {1.0968314815521232330475243e-01, 17, "10968314815521232", 0},
  {9.0383771555964514160156250e+11, 13, "9038377155596451416015625", 12},
  {1.2510522082259552105145731e-23, 1, "", -1},
  {9.9544404864834694188658205e-22, 1, "", -1},
  {5.0628146207835304085165262e+05, 18, "506281462078353040851653", 6},
  {1.1186933259374121005921885e-13, 9, "", -9},
  {1.0976726590655720000000000e+17, 14, "1097672659065572", 18},
  {2.8022216332446113586425781e+10, 12, "28022216332446113586426", 11},
  {7.1934307994897493967930029e-25, 5, "", -5},
  {5.5291432217254227281902864e-09, 4, "", -4},
  {1.1929516930900315745297508e-11, 4, "", -4},
  {7.6108877727559904000000000e+16, 19, "76108877727559904", 17},
  {1.5016564647649209976196289e+10, 3, "15016564647649", 11},
  {1.6066177601408008014525277e-25, 14, "", -14},
  {6.1618894565902694400000000e+18, 8, "616188945659026944", 19},
  {5.3562535282045684644630645e-05, 12, "53562535", -4},
  {1.3489031213176578703251586e-20, 16, "", -16},
  {1.5711695240513652152003488e+03, 4, "15711695", 4},
  {2.5122660050106903125000000e+14, 12, "25122660050106903125", 15},
  {2.0221030889363189945918116e-25, 11, "", -11},
  {1.1303024599909523925781250e+12, 8, "113030245999095239258", 13},
  {2.7903529772880277282470497e-17, 13, "", -13},
  {2.5121592915444268000000000e+16, 12, "25121592915444268", 17},
  {1.8048932996675591037873237e-12, 9, "", -9},
  {3.2226438096721920967102051e+09, 19, "32226438096721920967102050781", 10},
  {3.5147466372419680000000000e+16, 5, "3514746637241968", 17},
  {9.0135298952772956382880432e-18, 2, "", -2},
  {6.3266457307088434696197510e+07, 19, "632664573070884346961975098", 8},
  {1.4406496436364404507912695e+05, 9, "144064964363644", 6},
  {1.4048067471615732259952259e-14, 10, "", -10},
  {2.9319085253905223680000000e+19, 20, "2931908525390522368", 20},
  {1.3329477284912236366235759e-14, 0, "", 0},
  {1.7026555641068125000000000e+12, 12, "17026555641068125", 13},
  {8.2651115310402929687500000e+11, 16, "826511153104029296875", 12},
  {5.5492375565887810020337740e-11, 20, "5549237557", -10},
  {5.2100294487580758868716657e+03, 7, "52100294488", 4},
  {4.0139643139973952168422826e-10, 1, "", -1},
  {2.8674611869754667816843301e-22, 0, "", 0},
  {1.0453866711057700000000000e+16, 17, "104538667110577", 17},
  {3.5532073414203446399733964e-21, 10, "", -10},
  {2.8981256166572560661301612e-06, 20, "289812561665726", -5},
  {2.7486824389362219721078873e+07, 1, "274868244", 8},
  {3.6201696821935169435256875e-22, 16, "", -16},
  {2.8058107970984572602901608e+04, 2, "2805811", 5},
  {8.8321877347744512500000000e+14, 19, "883218773477445125", 15},
  {2.2155126434192637952000000e+20, 8, "22155126434192637952", 21},
  {5.1567392078515772332434909e-19, 10, "", -10},
  {5.0513022116504699707031250e+11, 10, "5051302211650469970703", 12},
  {3.7597560279127286803917860e-10, 8, "", -8},
  {1.9918607403922733798466954e-08, 16, "199186074", -7},
  {4.4234861458519274112308677e-11, 9, "", -9},
  {1.9023164229540652612705182e-23, 8, "", -8},
  {7.1021989711764663835586035e-17, 0, "", 0},
  {3.6661956748787194459993088e-03, 11, "366619567", -2},
  {4.9881566722141451464267448e+03, 6, "4988156672", 4},
  {4.4707644314334054706349725e-18, 14, "", -14},
  {5.4215846449332083523131587e+01, 7, "542158464", 2},
  {8.6593847936715371093750000e+12, 20, "8659384793671537109375", 13},
  {8.9829444141474144158342862e-13, 4, "", -4},
  {1.2428552364439995936840696e-23, 6, "", -6},
  {2.0166248952875683020800000e+20, 14, "201662489528756830208", 21},
  {3.7327184170362130051641231e-10, 3, "", -3},
  {1.9396181842743126511052765e-01, 10, "1939618184", 0},
  {3.5826922897186040000000000e+15, 3, "3582692289718604", 16},
  {2.7997315854645470000000000e+15, 14, "2799731585464547", 16},
  {1.1716597516408188382752709e-03, 11, "117165975", -2},
  {6.1882081648340598286333083e-12, 6, "", -6},
  {4.7370998762520938329956266e-01, 14, "47370998762521", 0},
  {4.4423933102435251285555751e+00, 6, "4442393", 1},
  {2.4957876235100876254256602e-13, 2, "", -2},
  {4.9401969802917692648337084e-21, 12, "", -12},
  {4.2151799896157845246123103e-05, 11, "421518", -4},
  {2.4330919434329737782718439e+02, 10, "2433091943433", 3},
  {3.9704848760294156174359833e-12, 6, "", -6},
  {6.5113509688550708007812500e+11, 9, "651135096885507080078", 12},
  {2.0201107491561449606421665e-23, 6, "", -6},
  {2.6003917513806278638625986e-23, 5, "", -5},
  {5.0313319321305721556240123e-20, 4, "", -4},
  {1.9240049601829819039267022e+03, 1, "1924", 4},
  {6.3442694622108669906036630e-19, 8, "", -8},
  {2.0557491959316193970153108e+03, 19, "20557491959316193970153", 4},
  {1.4668421724264454678632319e+05, 5, "14668421724", 6},
  {3.1382428850300479739043880e-02, 16, "313824288503005", -1},
  {1.5369430639587627812077865e-25, 4, "", -4},
  {3.4450899741885118216139212e-23, 10, "", -10},
  {3.0911588760980589389647070e-06, 14, "309115888", -5},
  {5.9404363317825529446400000e+20, 16, "594043633178255294464", 21},
  {1.0857475716345135636849922e-19, 20, "11", -18},
  {3.8383232743368286832286174e-03, 13, "38383232743", -2},
  {1.4248749471152849662394563e-24, 2, "", -2},
  {2.0089993582817679967922331e-03, 0, "", 0},
  {3.5166231882836703125000000e+13, 19, "35166231882836703125", 14},
  {1.7140450352925487923200000e+20, 4, "171404503529254879232", 21},
  {3.2313165658527839975219013e-12, 11, "", -11},
  {1.3290330898952539062500000e+12, 8, "132903308989525390625", 13},
  {2.0158316345631235866342479e-01, 11, "20158316346", 0},
  {2.0251250657297560785223673e-17, 9, "", -9},
  {3.5216352032369835037977929e-06, 12, "3521635", -5},
  {1.5477908597039305438336498e-01, 15, "154779085970393", 0},
  {3.8765938532090029581303166e-07, 0, "", 0},
  {3.2509338468973143939918862e-08, 13, "325093", -7},
  {6.2581518574031498426888197e-22, 1, "", -1},
  {5.0432161912984668742865324e+05, 7, "5043216191298", 6},
  {9.6059655990911452239089385e-01, 2, "96", 0},
  {1.1244083027408466250000000e+15, 5, "1124408302740846625", 16},
  {5.3601666644035825729370117e+09, 3, "5360166664404", 10},
  {3.3127818916477214545011520e+07, 1, "331278189", 8},
  {2.4908086930109192280724528e+02, 13, "2490808693010919", 3},
  {3.4779094857233305848609461e-01, 11, "34779094857", 0},
  {3.3572755934667378664016724e+08, 4, "3357275593467", 9},
  {1.9700038127631859585015404e-23, 20, "", -20},
  {7.0715094103144121510498532e-10, 10, "7", -9},
  {6.7037630116271845703125000e+12, 7, "67037630116271845703", 13},
  {1.1294460364897787094116211e+10, 10, "112944603648977870941", 11},
  {2.6737449213299253902593328e-06, 20, "267374492132993", -5},
  {1.5092206282517178280423561e-25, 13, "", -13},
  {3.4006989646044941122404737e-02, 3, "34", -1},
  {2.8111487221637728326893389e-13, 18, "281115", -12},
  {3.3781298583464045000000000e+15, 19, "33781298583464045", 16},
  {2.0016679896775639040000000e+18, 15, "2001667989677563904", 19},
  {1.4597094942281232769765165e-05, 10, "145971", -4},
  {4.8414051366454500000000000e+15, 4, "484140513664545", 16},
  {1.7739354377277198433876038e+08, 16, "1773935437727719843387604", 9},
  {3.7697954983919595682092819e-08, 12, "37698", -7},
  {8.4591744140055547662350276e-23, 8, "", -8},
  {1.6701760624616502669922589e-07, 0, "", 0},
  {4.5469943845790237188339233e+08, 18, "454699438457902371883392334", 9},
  {1.4754293744614287109375000e+13, 8, "1475429374461428710938", 14},
  {1.4963498919564651844921199e-03, 8, "149635", -2},
  {7.6466410401813972493203345e-13, 3, "", -3},
  {4.2381940527961081766968194e-20, 8, "", -8},
  {6.2854523843617129348328318e-18, 17, "1", -16},
  {1.2737541989685046552542302e-19, 19, "1", -18},
  {4.6196666564184898138046265e+08, 16, "4619666656418489813804626", 9},
  {2.8953766720828063744000000e+19, 11, "28953766720828063744", 20},
  {1.0162813924779992000000000e+16, 8, "10162813924779992", 17},
  {1.9599596534796953457442637e-07, 7, "2", -6},
  {8.3021846385465843200000000e+17, 7, "830218463854658432", 18},
  {1.4624248110616019900782450e-08, 5, "", -5},
  {1.2715287496333471679687500e+11, 2, "12715287496333", 12},
  {6.8027550113978083805126029e-05, 8, "6803", -4},
  {1.0981062031294560432434082e+09, 14, "109810620312945604324341", 10},
  {1.0734438619766858537036273e-22, 13, "", -13},
  {1.4132567191936884075403214e+07, 13, "141325671919368840754", 8},
  {1.5904224504531770518546239e-19, 0, "", 0},
  {2.4535972468695058101850748e-02, 16, "245359724686951", -1},
  {1.5601068380432108719197678e-25, 9, "", -9},
  {9.4978590368356121600000000e+17, 15, "949785903683561216", 18},
  {2.0706122814619420482871761e-18, 11, "", -11},
  {1.1526018485517715308715826e-05, 3, "", -3},
  {6.2402039265004006238472082e-22, 20, "", -20},
  {1.2145622298653942217061541e-01, 4, "1215", 0},
  {3.1360207022830924383576760e-06, 1, "", -1},
  {2.0903682178737230401566194e+02, 4, "2090368", 3},
  {6.8236005557543791873404286e-09, 20, "682360055575", -8},
  {1.1601601555390701105352491e+05, 1, "116016", 6},
  {2.1875218169481468882819897e-02, 8, "2187522", -1},
  {4.5972064065543524858311040e-12, 1, "", -1},
  {6.2553419557858422851562500e+11, 16, "625534195578584228515625", 12},
  {3.2966393741860024414062500e+12, 6, "3296639374186002441", 13},
  {5.6680567511992276576782010e-23, 14, "", -14},
  {1.2468383853738613900888840e-09, 2, "", -2},
  {1.3516183239875930940931958e-02, 17, "1351618323987593", -1},
  {1.4629096926763364422947094e-10, 2, "", -2},
  {9.3005408780297322664409876e+05, 15, "930054087802973226644", 6},
  {1.1529918172478498816000000e+19, 11, "11529918172478498816", 20},
  {4.1294372464822801449272813e-09, 8, "", -8},
  {1.0652815658147843150223105e-14, 12, "", -12},
  {1.0635569818699313327670097e+07, 18, "10635569818699313327670097", 8},
  {3.7580988683046307414770126e+05, 12, "375809886830463074", 6},
  {4.5857820827792426143787452e+02, 17, "45857820827792426144", 3},
  {2.9212956460630989568016957e+03, 1, "29213", 4},
  {2.6276323897159130000000000e+15, 1, "2627632389715913", 16},
  {2.7576598371538500178642983e-04, 9, "275766", -3},
  {1.8156829540410031250000000e+13, 20, "1815682954041003125", 14},
  {6.0690729978642972672000000e+19, 4, "60690729978642972672", 20},
  {2.1545222814755082725630899e-19, 20, "22", -18},
  {6.2024521141395034707240936e-18, 18, "6", -17},
  {2.4396751930476269531250000e+11, 3, "243967519304763", 12},
  {3.1078669709725926955610271e-11, 20, "3107866971", -10},
  {8.1545725581179377232175041e-13, 5, "", -5},
  {1.1618790914057837871226501e-18, 20, "116", -17},
  {2.6046821088380256174972241e-17, 14, "", -14},
  {2.8418526195341197312000000e+20, 15, "28418526195341197312", 21},
  {4.5585073586198306250000000e+14, 12, "4558507358619830625", 15},
  {5.0996252363668905359535798e-06, 14, "509962524", -5},
  {6.4209197762026025390625000e+12, 15, "64209197762026025390625", 13},
  {6.1386540264423591613769531e+10, 2, "6138654026442", 11},
  {1.5901378535836493167727811e-22, 16, "", -16},
  {5.4579315266585999779636040e+03, 9, "5457931526659", 4},
  {1.2544567961879360724719261e-19, 13, "", -13},
  {1.5726122819958073548134890e-10, 3, "", -3},
  {6.7892777701670213325729764e-04, 16, "6789277770167", -3},
  {1.4169809676321635923737215e-22, 2, "", -2},
  {6.5176922380697329664000000e+19, 20, "65176922380697329664", 20},
  {5.5595451528948190748782970e-14, 1, "", -1},
  {2.9557912637578951944306027e+03, 6, "2955791264", 4},
  {7.2804775134548956743238107e-14, 6, "", -6},
  {4.1622415121078927313647000e+02, 3, "416224", 3},
  {4.8737064570386013429015293e+02, 17, "48737064570386013429", 3},
  {1.7498415755518933164186024e-06, 7, "17", -5},
  {2.2160805224873369729673253e-17, 8, "", -8},
  {9.9265578616519537168307897e-12, 6, "", -6},
  {6.6758215277996143860236308e-12, 16, "66758", -11},
  {5.1455371830973781754892116e+01, 0, "51", 2},
  {2.3075746794683029187132683e-04, 14, "23075746795", -3},
  {6.4945848324870469859236566e-08, 3, "", -3},
  {6.0802847387444488704204559e+06, 17, "608028473874444887042046", 7},
  {4.4425197752128814387972966e-01, 1, "4", 0},
  {1.4934964441781190132421138e-11, 12, "15", -10},
  {2.4031131480610081752047336e+01, 16, "240311314806100818", 2},
  {8.3281476308039543710037833e+01, 1, "833", 2},
  {8.1973746018195646706808177e-05, 11, "8197375", -4},
  {4.3535772344454751873854548e+04, 16, "435357723444547518739", 5},
  {2.8755564450912231250000000e+14, 10, "2875556445091223125", 15},
  {4.4918701600850165899382182e-07, 1, "", -1},
  {2.6366858934475584419487859e+02, 14, "26366858934475584", 3},
  {5.1431268805072780800000000e+17, 1, "514312688050727808", 18},
  {8.8938194097586913280000000e+19, 14, "8893819409758691328", 20},
  {8.0147414624415674211377336e+01, 14, "8014741462441567", 2},
  {1.2879068417818787500000000e+15, 10, "128790684178187875", 16},
  {2.2218672530926345643820241e+04, 11, "2221867253092635", 5},
  {3.1017827311573439836502075e+08, 16, "3101782731157343983650208", 9},
  {4.6805104189323446917114779e+02, 12, "468051041893234", 3},
  {1.0556482317454627685546875e+12, 11, "105564823174546276855469", 13},
  {2.3913654765548638999462128e+07, 19, "239136547655486389994621277", 8},
  {1.1925126244955090805888176e+07, 10, "119251262449550908", 8},
  {1.0833732148616976737976074e+09, 15, "1083373214861697673797607", 10},
  {1.1287157303072798000000000e+16, 2, "11287157303072798", 17},
  {1.0362533438151604633600000e+20, 5, "103625334381516046336", 21},
  {7.2161202121139090000000000e+15, 4, "7216120212113909", 16},
  {2.5346680067095468984916806e+05, 3, "253466801", 6},
  {8.9627245238208430080000000e+18, 14, "8962724523820843008", 19},
  {2.3665350448230400085449219e+09, 18, "2366535044823040008544921875", 10},
  {1.2374610579226049367207452e+02, 6, "123746106", 3},
  {3.5448098652618561945600000e+20, 17, "354480986526185619456", 21},
  {2.5817473351112571435805876e+03, 5, "258174734", 4},
  {4.5546401398805186344631579e-01, 8, "45546401", 0},
  {1.2914906099985468316280681e-10, 13, "1291", -9},
  {5.1813111936968350410461426e+08, 5, "51813111936968", 9},
  {2.8751314218348569869995117e+09, 3, "2875131421835", 10},
  {6.7538805627191125791064508e-02, 10, "675388056", -1},
  {4.2316070478339520377630834e+02, 1, "4232", 3},
  {3.0755848678420653343200684e+09, 4, "30755848678421", 10},
  {8.9311194754829756448089029e+01, 19, "893111947548297564481", 2},
  {2.5635322913220988000000000e+16, 15, "25635322913220988", 17},
  {5.1344959677535087500000000e+14, 20, "513449596775350875", 15},
  {4.5481702647512625148351617e+00, 7, "45481703", 1},
  {4.0198903458776960000000000e+16, 13, "4019890345877696", 17},
  {3.0620773098517361371362355e-02, 15, "30620773098517", -1},
  {1.7845519018708885111924403e-17, 8, "", -8},
  {5.3036536346217483511161772e-04, 19, "5303653634621748", -3},
  {1.7089428267341041922655620e-02, 10, "170894283", -1},
  {1.5807414247286351562500000e+13, 1, "158074142472864", 14},
  {2.4002650960294847438489863e-19, 1, "", -1},
  {1.2732752944365720358124801e-24, 3, "", -3},
  {1.7831984146947735552000000e+19, 10, "17831984146947735552", 20},
  {1.3809582421010034838569465e-14, 7, "", -7},
  {7.9343878040550280761718750e+11, 4, "7934387804055028", 12},
  {1.7277451890719719511506527e-16, 7, "", -7},
  {8.0903795948917157910679201e-11, 0, "", 0},
  {1.6637015661079619174400000e+20, 17, "166370156610796191744", 21},
  {3.0740431082850804164085363e-19, 1, "", -1},
  {3.3365763449652551560662869e-16, 16, "3", -15},
  {4.4683629156000673735353676e-13, 11, "", -11},
  {6.5678354263822395946548181e-17, 8, "", -8},
  {1.0244415058360816452487536e-06, 0, "", 0},
  {8.9199577753000795767914271e-13, 3, "", -3},
  {7.7002722543322809206210042e-23, 16, "", -16},
  {3.8537044548224612254337059e-25, 3, "", -3},
  {4.3809531541275278071484210e-11, 20, "4380953154", -10},
  {6.0548416510883020240867685e-14, 12, "", -12},
  {5.8513966989801442396445652e-15, 10, "", -10},
  {9.4441417174617753879094542e-18, 14, "", -14},
  {1.7150618308992182272000000e+19, 1, "17150618308992182272", 20},
  {4.6590061150223489676136523e+04, 15, "46590061150223489676", 5},
  {2.3991155984836840154823923e-11, 18, "23991156", -10},
  {1.1693714649575429687500000e+12, 18, "116937146495754296875", 13},
  {5.3142513230907159442262267e-12, 7, "", -7},
  {2.6234513296017294682429595e-20, 5, "", -5},
  {1.6775188267406185294028376e-01, 4, "1678", 0},
  {2.0545325166979831250000000e+14, 7, "2054532516697983125", 15},
  {2.3477850437737580800000000e+17, 5, "234778504377375808", 18},
  {1.6746562547338615587523725e-13, 14, "17", -12},
  {3.1992844795375771484375000e+12, 19, "31992844795375771484375", 13},
  {1.6322309160756851240767563e-19, 15, "", -15},
  {1.4717323521441390039399266e+05, 4, "1471732352", 6},
  {2.9338003399460665931997028e+00, 15, "2933800339946067", 1},
  {4.8882409864959196842413692e-14, 8, "", -8},
  {7.7474024189719434829726197e+00, 18, "7747402418971943483", 1},
  {2.7394167583550237210196954e-24, 0, "", 0},
  {3.5491065734487854284800000e+20, 15, "354910657344878542848", 21},
  {3.2273005278925408985433751e-24, 0, "", 0},
  {2.2748201134157911670782309e-23, 9, "", -9},
  {1.1187230024700825820168099e-19, 7, "", -7},
  {2.6464701651782462400730456e-03, 9, "264647", -2},
  {3.5549134182392484375000000e+13, 2, "3554913418239248", 14},
  {7.1869766956845566596712160e+00, 5, "718698", 1},
  {1.0457889076600547879934311e+07, 1, "104578891", 8},
  {3.0958654498165975000000000e+15, 17, "30958654498165975", 16},
  {4.2482082145085106258952656e-03, 16, "42482082145085", -2},
  {2.8182394704751627468800000e+20, 7, "281823947047516274688", 21},
  {5.4567495002765526805887930e+03, 13, "54567495002765527", 4},
  {4.7101557647059033584469034e+00, 14, "47101557647059", 1},
  {7.2728072939563989825741205e-15, 2, "", -2},
  {5.8801389749660546875000000e+13, 7, "58801389749660546875", 14},
  {6.5434519988339303540238342e-08, 10, "654", -7},
  {1.1654999231858433625849595e-14, 14, "1", -13},
  {1.0305446899115753961769912e-18, 10, "", -10},
  {2.4399192471098435364656742e-17, 1, "", -1},
  {5.1666471813051129856000000e+19, 10, "51666471813051129856", 20},
  {5.1857907386066163808941666e-22, 8, "", -8},
  {6.6290770971275501251220703e+09, 14, "662907709712755012512207", 10},
  {2.5609660479275934632939840e-05, 1, "", -1},
  {3.4764707250538327888616579e-15, 12, "", -12},
  {3.6204142199881157226562500e+12, 17, "362041421998811572265625", 13},
  {4.7365898389561859375000000e+13, 3, "47365898389561859", 14},
  {2.7125037836954752000000000e+18, 15, "27125037836954752", 19},
  {4.0715218235387645661830902e+07, 12, "40715218235387645662", 8},
  {1.7896673646689995257385293e-18, 4, "", -4},
  {4.1292688804550480563193560e+05, 12, "412926888045504806", 6},
  {4.7268772538939495849609375e+11, 15, "47268772538939495849609375", 12},
  {1.0136288370225407370031981e-10, 13, "1014", -9},
  {1.3454480118600272553875868e-21, 11, "", -11},
  {5.1492383031008296394071032e-07, 0, "", 0},
  {2.1869120606993481652283886e-12, 17, "218691", -11},
  {1.4982234624039090023495113e-02, 2, "1", -1},
  {2.3091277642309661865234375e+10, 15, "23091277642309661865234375", 11},
  {3.2204003438956257280000000e+19, 12, "3220400343895625728", 20},
  {7.0445823002634375000000000e+12, 6, "70445823002634375", 13},
  {1.2008040763842884916812181e+06, 17, "120080407638428849168122", 7},
  {3.3766410502443477731332539e-18, 1, "", -1},
  {3.6535187096868762647438427e-25, 14, "", -14},
  {8.3614291401061514203491714e-13, 11, "", -11},
  {5.0413424658121818112000000e+20, 10, "50413424658121818112", 21},
  {1.6403712425855234375000000e+14, 14, "16403712425855234375", 15},
  {3.7035573652199532261874992e+03, 10, "370355736522", 4},
  {3.4444785167628771972656250e+11, 5, "34444785167628772", 12},
  {4.0001616779831927269697189e+06, 10, "40001616779831927", 7},
  {2.8191886058159255981445312e+09, 5, "281918860581593", 10},
  {2.2490241319744193773691711e-20, 3, "", -3},
  {1.1029971985293119432877362e-18, 5, "", -5},
  {2.5932241623977885000000000e+15, 2, "25932241623977885", 16},
  {9.8210069797071468082186788e-11, 12, "98", -10},
  {6.8523899167447853088378906e+10, 3, "68523899167448", 11},
  {3.4833078224026580755889881e+03, 4, "34833078", 4},
  {1.5734344522524808593750000e+13, 17, "1573434452252480859375", 14},
  {3.8323737787152717393368562e-01, 8, "38323738", 0},
  {5.3033735681927307128906250e+10, 11, "5303373568192730712891", 11},
  {8.7205422658864894386310240e-03, 11, "872054227", -2},
  {4.2216856639087631209925067e-04, 16, "4221685663909", -3},
  {1.7662866167148281856000000e+20, 12, "17662866167148281856", 21},
  {4.2449464885037991285656679e-18, 14, "", -14},
  {6.8538443488680549721715766e-15, 18, "6854", -14},
  {1.1389686360622924610197515e+02, 17, "1138968636062292461", 3},
  {1.7483623880465403510661579e-22, 9, "", -9},
  {9.4159344393932246930489782e+02, 10, "9415934439393", 3},
  {2.5134290975200053978736228e-05, 0, "", 0},
  {3.1001816322408470169482025e-12, 6, "", -6},
  {8.6894933558228300800000000e+17, 10, "868949335582283008", 18},
  {1.7492413494784801453528409e-19, 12, "", -12},
  {2.1358826288442295751516360e-07, 14, "21358826", -6},
  {1.8960878043872732201348953e-20, 20, "2", -19},
  {5.6739007826950241947239206e-03, 20, "567390078269502419", -2},
  {7.8799484994733310298086565e-25, 17, "", -17},
  {1.0424287262168321910316138e-01, 16, "1042428726216832", 0},
  {1.8378417988923802040517330e+06, 12, "1837841798892380204", 7},
  {1.6321783798851461408001183e-17, 1, "", -1},
  {5.1816255484930211305618286e+08, 0, "518162555", 9},
  {8.8114761321990729514569869e-19, 5, "", -5},
  {1.3534580666738778020885547e+00, 8, "135345807", 1},
  {1.8688278068068344593048096e+09, 3, "1868827806807", 10},
  {1.4970096431896634987516709e-18, 20, "15", -17},
  {2.7561365037595989529583141e-06, 1, "", -1},
  {8.8597437276339700611858938e-20, 7, "", -7},
  {1.9450542411517362539908986e-17, 12, "", -12},
  {8.0410681583273947878940310e-10, 15, "804107", -9},
  {1.7001505802483025000000000e+15, 20, "17001505802483025", 16},
  {1.3848834414228553338355177e-02, 15, "13848834414229", -1},
  {9.8043308139340728521347046e+07, 0, "98043308", 8},
  {1.0885376298682442575227469e+05, 2, "10885376", 6},
  {3.5822690369937854497814595e-13, 9, "", -9},
  {3.6793146456481655934100962e-09, 13, "36793", -8},
  {3.2962677662953288049152434e-01, 16, "3296267766295329", 0},
  {1.4393296773850427500000000e+15, 8, "143932967738504275", 16},
  {1.0877386439574270000000000e+15, 17, "1087738643957427", 16},
  {4.4869023373854445002243363e-20, 15, "", -15},
  {4.8539220896200668750000000e+14, 16, "4853922089620066875", 15},
  {1.4686227229050292968750000e+10, 3, "1468622722905", 11},
  {9.8008350909250880000000000e+15, 3, "9800835090925088", 16},
  {2.0926715160486664956124458e-12, 10, "", -10},
  {9.5001935915099990367889404e+08, 16, "950019359150999903678894", 9},
  {3.4947107445084969719042064e-23, 8, "", -8},
  {8.2504501209905766882002354e+05, 16, "82504501209905766882", 6},
  {1.4047042904241477501159352e+01, 16, "140470429042414775", 2},
  {1.8349612076560081250000000e+14, 16, "1834961207656008125", 15},
  {6.9937578160056000000000000e+17, 12, "69937578160056", 18},
  {5.1852901126232713371888572e-03, 12, "5185290113", -2},
  {3.7278370837297530697440617e-04, 3, "", -3},
  {8.7513256367916198996681487e+01, 6, "87513256", 2},
  {1.4293551861526340436385485e-04, 10, "1429355", -3},
  {1.5172522676527982184779830e+04, 5, "1517252268", 5},
  {4.7249028476047632598454939e-10, 2, "", -2},
  {1.2093781086040714112250782e-02, 6, "12094", -1},
  {2.1888574464815261308103800e+04, 6, "21888574465", 5},
  {6.4108247849902505439759537e-14, 11, "", -11},
  {6.1126718192864075263059931e+01, 12, "61126718192864", 2},
  {4.1713893609774554960267778e+00, 8, "417138936", 1},
  {5.1040422024326233729427395e-10, 1, "", -1},
  {2.5005219675540663715272976e-19, 20, "25", -18},
  {1.1536360883960134968151401e-02, 4, "115", -1},
  {8.5370188857210814952850342e+08, 16, "8537018885721081495285034", 9},
  {1.3671879106543010937500000e+14, 4, "1367187910654301094", 15},
  {4.8758073972733228629294899e+02, 2, "48758", 3},
  {4.7457153105472720477052417e-05, 16, "474571531055", -4},
  {9.6881042339286434997985831e-04, 8, "96881", -3},
  {8.1300930837243213716690640e-17, 6, "", -6},
  {3.4505742591270232200622559e+08, 6, "345057425912702", 9},
  {4.7445042065697271507906047e-13, 8, "", -8},
  {1.8762731656955754927507130e-02, 9, "18762732", -1},
  {1.0998061336694069362253511e-15, 15, "1", -14},
  {7.7035440660781198534502348e-24, 9, "", -9},
  {4.1673486594549575556811760e+02, 7, "4167348659", 3},
  {1.6044954202024231641928775e-16, 12, "", -12},
  {5.1494873731001011406895637e-22, 15, "", -15},
  {8.1887273265700465046961440e-19, 7, "", -7},
  {2.4976604692390242234978359e+02, 16, "2497660469239024223", 3},
  {6.6620648959411733138982853e-16, 17, "67", -15},
  {3.5810304435982015467034383e-24, 19, "", -19},
  {1.2628466335209436355487000e-04, 13, "1262846634", -3},
  {6.9091594708094034027467956e-03, 14, "690915947081", -2},
  {8.8986844273515766718664564e-13, 14, "89", -12},
  {4.6763792380275818934409672e-24, 3, "", -3},
  {1.3130206257524946045067142e-21, 20, "", -20},
  {8.8507772162968835449218750e+11, 6, "885077721629688354", 12},
  {1.5745185366897158767975854e-06, 7, "16", -5},
  {9.8952378453471148823570951e-14, 17, "9895", -13},
  {5.2502470470783702218383127e-16, 10, "", -10},
  {8.4042755736084362792968750e+11, 7, "8404275573608436279", 12},
  {1.4768687205760766758203879e-09, 3, "", -3},
  {3.3276536174725720659828276e-03, 6, "3328", -2},
  {1.7589050934504477893453460e-11, 10, "", -10},
  {4.1339767288338470458984375e+08, 10, "4133976728833847046", 9},
  {5.9823531422649844913053130e-02, 13, "598235314226", -1},
  {5.5171659525707023620605469e+10, 12, "55171659525707023620605", 11},
  {1.9776168230884040527343750e+12, 0, "1977616823088", 13},
  {1.0990423248036367655176598e-14, 8, "", -8},
  {4.1467382549651870249363128e+02, 20, "41467382549651870249363", 3},
  {1.3508081183146977863112664e-09, 0, "", 0},
  {4.5294641562329785263634266e-06, 18, "4529464156233", -5},
  {2.2559119800193832257306280e-25, 10, "", -10},
  {4.1834736333573849376500131e-24, 1, "", -1},
  {2.4667914269831240089600000e+20, 15, "246679142698312400896", 21},
  {3.1118609655335848350714919e-25, 12, "", -12},
  {1.6083517028854200616478920e+06, 1, "16083517", 7},
  {2.4278838034854328937589193e-18, 11, "", -11},
  {3.0888949024312742039910518e+03, 4, "30888949", 4},
  {2.7885172028766710311174393e+07, 11, "2788517202876671031", 8},
  {2.4004235224723505237598431e-01, 5, "24004", 0},
  {2.7729909318065744638442993e+08, 5, "27729909318066", 9},
  {1.0612026351338697816029111e-03, 2, "", -2},
  {3.9610015398094952106475830e+08, 1, "396100154", 9},
  {2.4239501004941855297558637e-12, 20, "24239501", -11},
  {2.3720604005336354311449687e-14, 4, "", -4},
  {1.4883291451819890844482375e-04, 6, "149", -3},
  {3.2115853937263472062113578e+02, 2, "32116", 3},
  {3.1871067303438463363198737e-23, 7, "", -7},
  {1.4178210153362953662872314e+09, 19, "14178210153362953662872314453", 10},
  {1.3533633535823966553834907e+02, 14, "13533633535823967", 3},
  {4.6250696638119732961058617e+05, 2, "46250697", 6},
  {4.3666471884947684884537011e+04, 10, "436664718849477", 5},
  {2.1056183379767147090397713e-14, 1, "", -1},
  {7.9228390989314257240039296e+03, 10, "79228390989314", 4},
  {9.4110535356864525706082562e-20, 8, "", -8},
  {1.4712866191741521835327148e+10, 1, "147128661917", 11},
  {1.1847133517513772235659788e-20, 9, "", -9},
  {4.0026784400423979229965780e-10, 2, "", -2},
  {6.3148063574041334504727274e+03, 1, "63148", 4},
  {1.6962448457788511264517187e-21, 12, "", -12},
  {2.3900693894325259602074828e-06, 17, "239006938943", -5},
  {1.3860762824902351850357607e-24, 13, "", -13},
  {9.8520660425305834627122423e-18, 13, "", -13},
  {2.2869247580852769315242767e+06, 16, "22869247580852769315243", 7},
  {6.3803537780441718041402055e+02, 1, "638", 3},
  {1.8412544531117088000000000e+17, 3, "18412544531117088", 18},
  {1.7776908766615158583590528e+03, 18, "1777690876661515858359", 4},
  {5.4351023950463787500000000e+14, 14, "543510239504637875", 15},
  {6.8658881818589908172800000e+20, 13, "686588818185899081728", 21},
  {2.9494585632809057235717773e+09, 0, "2949458563", 10},
  {3.6545577159534293370298647e-07, 20, "36545577159534", -6},
  {6.5526675467397988541051745e+04, 18, "65526675467397988541052", 5},
  {1.7242830649181970799231419e-10, 7, "", -7},
  {6.5639944669509546315566695e+01, 19, "656399446695095463156", 2},
  {1.3156608464108407452464178e-01, 16, "1315660846410841", 0},
  {1.2963919749964332368108444e+04, 3, "1296392", 5},
  {7.4894923110693805866008854e-05, 16, "748949231107", -4},
  {1.0888074151891450887856709e-15, 6, "", -6},
  {1.2301403127947672544451052e+01, 6, "12301403", 2},
  {3.8945245867053290567127988e+03, 12, "3894524586705329", 4},
  {7.8750805495133032285337724e-21, 5, "", -5},
  {2.0258224546475161488785752e-08, 2, "", -2},
  {1.7581992138894326880816173e-24, 18, "", -18},
  {1.2218910953381130099296570e+08, 12, "122189109533811300993", 9},
  {4.2411828323146371891069867e-23, 13, "", -13},
  {4.1188705410900964678789291e-14, 8, "", -8},
  {3.5041538991843825812111390e+00, 15, "3504153899184383", 1},
  {6.9939825339778212890625000e+12, 17, "69939825339778212890625", 13},
  {1.2604357096145542883580049e-14, 4, "", -4},
  {1.3618112230571125000000000e+14, 16, "13618112230571125", 15},
  {1.5426824998575691965421426e-06, 8, "154", -5},
  {6.4802012644741805532224698e-25, 19, "", -19},
  {6.5434939826304223388433456e+06, 17, "654349398263042233884335", 7},
  {2.8593196098489642333984375e+11, 12, "285931960984896423339844", 12},
  {3.6395924367265995000000000e+15, 1, "36395924367265995", 16},
  {9.9450235071871048204853252e-06, 2, "", -2},
  {1.8028582003601691759135957e-13, 8, "", -8},
  {6.8491170370267743020766969e-08, 6, "", -6},
  {2.8418488268429373340382029e-08, 1, "", -1},
  {1.6058523696864046505401735e-04, 15, "160585236969", -3},
  {2.0204048673917219275608659e+04, 11, "2020404867391722", 5},
  {1.0641148619533082500000000e+15, 4, "106411486195330825", 16},
  {1.1490012212951497113600000e+20, 15, "114900122129514971136", 21},
  {3.9303075613940547053539542e-23, 15, "", -15},
  {2.3365797618258078049339357e-13, 5, "", -5},
  {6.8055753141123428344726562e+10, 18, "680557531411234283447265625", 11},
  {2.9466628744340115000000000e+15, 17, "29466628744340115", 16},
  {1.1171292917846032418882333e-13, 1, "", -1},
  {6.8856058519301601705819849e+00, 8, "688560585", 1},
  {2.9919256687993507385253906e+10, 19, "2991925668799350738525390625", 11},
  {4.2384542059898598400000000e+17, 1, "423845420598985984", 18},
  {1.5277977544427925226310991e-05, 3, "", -3},
  {4.4452305734866932034492493e+07, 4, "444523057349", 8},
  {6.5546531491364749312000000e+19, 0, "65546531491364749312", 20},
  {1.9842672424587858159370710e-12, 4, "", -4},
  {2.9075601794879745646930924e-05, 4, "", -4},
  {2.2410325424521251989062876e+03, 7, "22410325425", 4},
  {1.5876167931261899414062500e+12, 12, "158761679312618994140625", 13},
  {7.2915824924726416015625000e+11, 5, "72915824924726416", 12},
  {6.0490382570772591347778295e-11, 13, "605", -10},
  {3.8944305553351275936645242e-17, 13, "", -13},
  {2.9148237575325779857848829e+01, 13, "291482375753258", 2},
  {2.0210978880658891282527658e-23, 0, "", 0},
  {7.3526308801384485695974545e-20, 12, "", -12},
  {1.3658656241786268718437013e-11, 15, "13659", -10},
  {1.8126222156524613174813396e-12, 19, "18126222", -11},
  {5.6254876168808987131342292e+03, 0, "5625", 4},
  {6.6882034415542034432000000e+19, 18, "66882034415542034432", 20},
  {6.8210058358683609600000000e+17, 13, "682100583586836096", 18},
  {1.0239489841935416105118316e-25, 10, "", -10},
  {6.4885530802579514682292938e+07, 14, "6488553080257951468229", 8},
  {4.6831130092816418889796811e-11, 15, "46831", -10},
  {2.7411837319155561600000000e+17, 18, "274118373191555616", 18},
  {9.6050524824558010368000000e+19, 19, "96050524824558010368", 20},
  {9.2768174103640237500000000e+14, 15, "927681741036402375", 15},
  {2.6781929928089680671691895e+09, 15, "2678192992808968067169189", 10},
  {1.1046304602372358205620261e-05, 11, "110463", -4},
  {1.0841960471643238830566406e+11, 5, "10841960471643239", 12},
  {2.6298793785197580963018625e-11, 12, "26", -10},
  {3.5106538053044732805574313e+03, 9, "3510653805304", 4},
  {4.2735983858635887596764252e-11, 13, "427", -10},
  {5.3007529384454594560000000e+19, 11, "5300752938445459456", 20},
  {3.6627230212689530849456787e+08, 6, "366272302126895", 9},
  {6.3444042930495486633002715e-07, 8, "63", -6},
  {3.5100531800601215062677986e-14, 8, "", -8},
  {1.7286776468325945610438055e-01, 1, "2", 0},
  {2.9467144324665499648000000e+19, 12, "29467144324665499648", 20},
  {2.4075011043657265368295950e-14, 2, "", -2},
  {2.5022998586714197196800000e+20, 15, "250229985867141971968", 21},
  {4.4003794398566061916691624e-17, 7, "", -7},
  {2.3423233464175251632517880e-24, 15, "", -15},
  {2.4521081548063623500866015e+00, 11, "245210815481", 1},
  {1.6722093550107796744441657e+01, 20, "1672209355010779674444", 2},
  {1.5383165351761283522953959e-09, 15, "1538317", -8},
  {7.0092804024077781250000000e+13, 15, "7009280402407778125", 14},
  {1.3322274046342386100150179e+00, 11, "133222740463", 1},
  {1.9025988459395125665880699e-10, 11, "19", -9},
  {2.7309308556335416320000000e+18, 4, "2730930855633541632", 19},
  {4.9530533186694964027652066e-04, 14, "49530533187", -3},
  {3.4480953504032777345855720e+03, 4, "34480954", 4},
  {7.3181776721744760627022704e-06, 17, "731817767217", -5},
  {7.3559657425321643212800000e+20, 14, "735596574253216432128", 21},
  {1.2412295595365066056111728e-14, 4, "", -4},
  {8.7697253663625735961494544e-08, 16, "876972537", -7},
  {2.2699582135102709667950904e-02, 1, "", -1},
  {4.2529222202524316346631772e-10, 13, "4253", -9},
  {5.9819377324581878951903491e+01, 9, "59819377325", 2},
  {4.4109863875065528320000000e+19, 8, "4410986387506552832", 20},
  {4.4731766697893267822265625e+11, 2, "44731766697893", 12},
  {1.5401217392608513869803196e-13, 20, "15401217", -12},
  {1.7951936368179281250000000e+13, 9, "1795193636817928125", 14},
  {2.1829691697830064000000000e+17, 12, "21829691697830064", 18},
  {1.5909596501424949676532114e-14, 18, "1591", -13},
  {5.4099197193774011086321337e-25, 2, "", -2},
  {6.9242442431238749118500644e-21, 18, "", -18},
  {9.2196686858616040000000000e+15, 5, "9219668685861604", 16},
  {3.7675814609568682857403604e-09, 13, "37676", -8},
  {7.1034765852635580813512206e+04, 13, "710347658526355808", 5},
  {2.1403397077492739009052514e-01, 15, "214033970774927", 0},
  {2.7701031177007259391790669e-06, 15, "2770103118", -5},
  {2.9478547696164588559630815e-02, 11, "294785477", -1},
  {9.8829877680244670464000000e+19, 4, "98829877680244670464", 20},
  {6.5059737427122506956800000e+20, 1, "650597374271225069568", 21},
  {1.2368063411364548863820201e-10, 6, "", -6},
  {3.4869431419309659184536037e-08, 10, "349", -7},
  {2.4936581684364624000000000e+17, 10, "24936581684364624", 18},
  {9.8114476206485559509966970e-20, 10, "", -10},
  {4.1025023707394424916405049e-19, 14, "", -14},
  {1.7634002265096694463863969e+05, 12, "176340022650966945", 6},
  {7.6497765877147115520000000e+18, 5, "7649776587714711552", 19},
  {1.3087152273935693063008895e-19, 6, "", -6},
  {1.8195267016330175702595965e-19, 8, "", -8},
  {7.9374857953483275356889887e-07, 11, "79375", -6},
  {1.9383514842742362585193781e-10, 16, "1938351", -9},
  {7.0779474772986286506016959e-22, 6, "", -6},
  {1.1495473374695556238293648e+07, 11, "1149547337469555624", 8},
  {5.5055657308194036333803085e-08, 5, "", -5},
  {2.7852820511326191406250000e+12, 20, "2785282051132619140625", 13},
  {9.5823552717485662500000000e+14, 19, "958235527174856625", 15},
  {5.7615109537071903545701163e-24, 10, "", -10},
  {4.7342526369214909644800000e+20, 3, "473425263692149096448", 21},
  {1.2562254158337033658979271e-08, 19, "125622541583", -7},
  {1.4802542139968126733151621e+00, 11, "1480254214", 1},
  {5.0638737484134515625000000e+13, 10, "50638737484134515625", 14},
  {1.3592777121960071251832017e-21, 7, "", -7},
  {8.8390426511071667004882722e-10, 7, "", -7},
  {1.4043213577062855861553314e-05, 1, "", -1},
  {1.2151254397241963774601442e-04, 19, "1215125439724196", -3},
  {3.5315572342564691603143939e-06, 4, "", -4},
  {2.3326678644170604115699874e-05, 9, "23327", -4},
  {1.0861797296891001356171849e-16, 0, "", 0},
  {1.8710943560782242566347122e+07, 9, "18710943560782243", 8},
  {1.6244984276745969238281250e+12, 18, "1624498427674596923828125", 13},
  {3.9417413418522492051124573e+07, 12, "39417413418522492051", 8},
  {1.1445411083918325424194336e+10, 5, "1144541108391833", 11},
  {5.7237525903208702802658081e+06, 16, "57237525903208702802658", 7},
  {2.9784940910460998460262960e-03, 9, "2978494", -2},
  {1.6914379697127038996664781e-07, 5, "", -5},
  {5.4455612727104390400000000e+17, 8, "544556127271043904", 18},
  {5.2019886390219737600000000e+17, 2, "520198863902197376", 18},
  {8.2863646359445989131927490e+08, 0, "828636464", 9},
  {2.0558064885994301162558782e-24, 11, "", -11},
  {3.4992116082573336832695077e+00, 9, "3499211608", 1},
  {4.0203247113518275320529938e+07, 20, "4020324711351827532052993774", 8},
  {4.5270794923097397986934800e-07, 19, "452707949231", -6},
  {1.7176252873964098010865281e-25, 12, "", -12},
  {5.0261906139138740539550781e+10, 18, "5026190613913874053955078125", 11},
  {7.1481562517751414322309650e-11, 14, "7148", -10},
  {8.7281765927491912841796875e+10, 1, "872817659275", 11},
  {1.9541466886643892224000000e+20, 6, "19541466886643892224", 21},
  {2.4610302704998766421340406e+05, 14, "24610302704998766421", 6},
  {5.5123777635746188056536473e-18, 8, "", -8},
  {2.4928214717947334051132202e+07, 3, "24928214718", 8},
  {3.3226582281614020466804504e+07, 13, "332265822816140204668", 8},
  {6.2072012586622351463245565e-21, 11, "", -11},
  {4.5056698751514278942892183e-15, 19, "45057", -14},
  {4.3970925100077403340800000e+20, 5, "439709251000774033408", 21},
  {3.0851338961425274976127514e-24, 12, "", -12},
  {5.8359358944206739646107865e-13, 1, "", -1},
  {3.1787063701593344637432248e-10, 7, "", -7},
  {2.5909266012162019822201313e-14, 12, "", -12},
  {6.6087793641703175380825996e+06, 15, "6608779364170317538083", 7},
  {2.7606710141689967934468009e-09, 5, "", -5},
  {9.4241244366368280000000000e+15, 0, "9424124436636828", 16},
  {1.6946301135649606860800000e+20, 14, "169463011356496068608", 21},
  {1.1633778535846001409866942e-10, 10, "1", -9},
  {8.7370588406131942350402951e-16, 17, "87", -15},
  {2.5261077139618090188800000e+20, 19, "252610771396180901888", 21},
  {6.4204835963286673968983785e-06, 20, "642048359632867", -5},
  {5.1132165601358985107006971e-05, 11, "5113217", -4},
  {1.6661669314435270794989134e-15, 4, "", -4},
  {3.0939146368062910898657803e-08, 4, "", -4},
  {1.1788804193679672753904478e-06, 5, "", -5},
  {2.2258206753076657346927802e-05, 6, "22", -4},
  {3.1689207094414674400427438e-21, 18, "", -18},
  {1.2077597747447968487843905e-07, 6, "", -6},
  {8.7305702781782993738073102e-17, 20, "8731", -16},
  {8.5839582307966081806789369e-23, 19, "", -19},
  {6.4195037716659086868276063e+01, 13, "641950377166591", 2},
  {6.8094721563524294827354005e-14, 20, "6809472", -13},
  {1.3497058415056765170447761e+03, 2, "134971", 4},
  {6.2157220865387843585982682e-22, 6, "", -6},
  {4.0667476120535902964821945e-05, 7, "407", -4},
  {2.7443459063225157024135115e+02, 11, "27443459063225", 3},
  {1.0210280291049479764198286e-21, 15, "", -15},
  {8.4623169154827225065833998e-15, 5, "", -5},
  {9.0379104578354190414953347e-24, 1, "", -1},
  {1.0178039752907980978488922e+08, 17, "10178039752907980978488922", 9},
  {3.9328276391966760412659848e-13, 18, "393283", -12},
  {1.5693085798287499852185124e-21, 11, "", -11},
  {1.7549893820738936126880925e-04, 18, "175498938207389", -3},
  {3.2969031476469676971435547e+10, 16, "329690314764696769714355469", 11},
  {1.1074978118120412017911161e-09, 4, "", -4},
  {1.4949843615328078253844051e-08, 9, "15", -7},
  {2.5320604848073559570312500e+11, 20, "253206048480735595703125", 12},
  {5.0088305271920396943841070e-01, 16, "500883052719204", 0},
  {1.1672709000476220703125000e+13, 18, "11672709000476220703125", 14},
  {7.9270804309913904333091523e-18, 16, "", -16},
  {1.4656956192078695450874619e-17, 2, "", -2},
  {5.9176968707453587725808575e+00, 20, "591769687074535877258", 1},
  {2.6632456385956746455858530e-21, 20, "", -20},
  {8.8910205055289922779215850e-04, 4, "9", -3},
  {1.1383168644297999572753906e+11, 16, "1138316864429799957275390625", 12},
  {1.5873838069057359945190910e+00, 18, "1587383806905735995", 1},
  {6.2048690998854036580907166e-19, 20, "62", -18},
  {6.0243428916704624976496931e-13, 0, "", 0},
  {1.4113606110846559360538777e+01, 6, "14113606", 2},
  {2.2980332330713289613057389e-16, 16, "2", -15},
  {6.4407712171390029296875000e+12, 13, "64407712171390029296875", 13},
  {2.3314190694870136212557554e+05, 19, "2331419069487013621255755", 6},
  {1.3430408310358017187500000e+14, 6, "134304083103580171875", 15},
  {1.7523999633198167430236936e+05, 14, "1752399963319816743", 6},
  {1.2779523625280151367187500e+12, 12, "127795236252801513671875", 13},
  {4.9237880877891928292403883e-18, 0, "", 0},
  {5.6987021703943800000000000e+15, 17, "569870217039438", 16},
  {6.9443875068581306209125614e+01, 7, "694438751", 2},
  {1.1437059899241757392883301e+09, 14, "114370598992417573928833", 10},
  {4.3847185549378956539562516e-13, 8, "", -8},
  {1.4938268218607690869248472e+03, 8, "149382682186", 4},
  {2.9051342859610294346845748e-09, 12, "2905", -8},
  {8.8992459877740567684331863e-18, 11, "", -11},
  {2.8182953222292413814065171e-02, 18, "28182953222292414", -1},
  {2.6941036307872906250000000e+14, 7, "2694103630787290625", 15},
  {1.2786627566899886718750000e+13, 15, "1278662756689988671875", 14},
  {7.4760548248557870465447195e+02, 7, "7476054825", 3},
  {2.0808903278641173005744941e-19, 3, "", -3},
  {1.3675577564048088088834859e-06, 10, "13676", -5},
  {9.0314818930726431744915317e+01, 12, "90314818930726", 2},
  {1.2637940381002242187500000e+13, 1, "126379403810022", 14},
  {6.2898404226945890964108274e-13, 15, "629", -12},
  {2.7096055920233681036126094e-18, 12, "", -12},
  {2.2400915495900110213271687e-24, 12, "", -12},
  {1.1916670164356988281250000e+13, 3, "11916670164356988", 14},
  {2.3625749985895959472656250e+11, 10, "2362574998589595947266", 12},
  {6.4096945917386077344417572e+07, 10, "640969459173860773", 8},
  {1.0288156592379195988178253e+08, 3, "102881565924", 9},
  {2.4914143675061010269056183e-05, 14, "2491414368", -4},
  {2.1806993712021089843750000e+13, 12, "2180699371202108984375", 14},
  {6.4497571429801403286115174e-25, 14, "", -14},
  {4.2397460719371648000000000e+17, 4, "42397460719371648", 18},
  {7.3671485757890977353052685e-09, 1, "", -1},
  {5.2590283508103025989893197e-17, 7, "", -7},
  {1.5295266445534963159480490e-02, 0, "", 0},
  {8.0980423292442119418410584e+03, 7, "80980423292", 4},
  {1.3496362955090356550158504e+01, 17, "1349636295509035655", 2},
  {1.6789689243310512392781675e+05, 0, "167897", 6},
  {3.6914158304578734259848716e+01, 8, "369141583", 2},
  {3.0187540777596878765507249e-20, 13, "", -13},
  {2.7638631280263869716716355e-12, 9, "", -9},
  {1.4497982429677158594131470e+07, 4, "144979824297", 8},
  {1.5036175336625990625000000e+14, 17, "15036175336625990625", 15},
  {1.3242598863494831085205078e+10, 12, "13242598863494831085205", 11},
  {2.5695863591886435983724368e+01, 10, "256958635919", 2},
  {7.9115417097347208165659297e-20, 16, "", -16},
  {2.1149997306580013312308082e-20, 20, "2", -19},
  {3.3026673447749831016156952e-04, 1, "", -1},
  {5.3503303421835358226421384e-17, 9, "", -9},
  {3.8831254347078791835265926e-18, 9, "", -9},
  {4.7567957893639957673345003e-05, 8, "4757", -4},
  {8.1707666473813178017735481e+06, 19, "81707666473813178017735481", 7},
  {1.6683344748855767039044893e-17, 5, "", -5},
  {4.5021961994715490341186523e+09, 11, "450219619947154903412", 10},
  {1.6107496358885451660156250e+12, 8, "161074963588854516602", 13},
  {5.8385589949200648000000000e+16, 15, "58385589949200648", 17},
  {7.8318206826911029860838198e-01, 6, "783182", 0},
  {4.9622049137181640922491605e-14, 0, "", 0},
  {1.4378956657306312000000000e+16, 14, "14378956657306312", 17},
  {1.8049411292578543264397695e+00, 11, "180494112926", 1},
  {9.4612947207965114368000000e+20, 2, "94612947207965114368", 21},
  {1.4370027736554941810709352e+01, 15, "14370027736554942", 2},
  {9.0053138015373294051477073e-09, 20, "900531380154", -8},
  {1.8129318212242679295759077e-13, 12, "", -12},
  {3.6556116517026299904000000e+20, 17, "36556116517026299904", 21},
  {3.6644643458493050880000000e+19, 5, "3664464345849305088", 20},
  {2.8152889402261430518007498e-06, 14, "281528894", -5},
  {8.3283083892446570098400116e+05, 20, "83283083892446570098400116", 6},
  {2.2661217256252738560000000e+18, 18, "2266121725625273856", 19},
  {4.2917205376219216164986152e-12, 8, "", -8},
  {5.5092300080573593139648438e+10, 3, "55092300080574", 11},
  {2.6595744001830953298028204e-20, 12, "", -12},
  {1.3250886292356894552211232e-25, 8, "", -8},
  {4.1380622625061248779296875e+10, 5, "4138062262506125", 11},
  {1.9398605768909324979176745e+04, 5, "1939860577", 5},
  {1.7443014783548167591016528e-13, 5, "", -5},
  {4.0314889972364077917213075e-15, 9, "", -9},
  {4.8877837161900931613536803e-05, 10, "488778", -4},
  {1.4638030286503930000000000e+16, 5, "1463803028650393", 17},
  {1.1524420738001751873813561e-01, 5, "11524", 0},
  {8.4652385404623579233884811e+04, 13, "846523854046235792", 5},
  {6.0220579812021087855100632e+06, 4, "60220579812", 7},
  {1.0701946041039131250000000e+15, 2, "107019460410391313", 16},
  {4.7823816788611670405904570e-11, 10, "", -10},
  {7.4530166572716260390413234e-04, 14, "74530166573", -3},
  {5.6520202124764686857361085e+01, 5, "565202", 2},
  {3.7948207646837112119766874e-15, 17, "379", -14},
  {3.5202783002279891560317444e-14, 13, "", -13},
  {7.2773137506371057270371239e+01, 10, "727731375064", 2},
  {5.5947230123447582172957482e+01, 15, "55947230123447582", 2},
  {5.8730508358888007700443268e+07, 1, "587305084", 8},
  {9.2930694929375841362162447e-03, 11, "929306949", -2},
  {7.1398558534035156952768375e+00, 4, "71399", 1},
  {3.1512476363439206232877621e-05, 13, "315124764", -4},
  {7.1427226984130737989634267e-09, 15, "7142723", -8},
  {4.0496915700094192671592753e-25, 2, "", -2},
  {1.1366821577444322348476012e-21, 3, "", -3},
  {7.0692445057512618653489962e-21, 18, "", -18},
  {1.8771838307312936782836914e+09, 5, "187718383073129", 10},
  {1.4624501735454128609865783e-25, 8, "", -8},
  {9.7592076026378738233135265e-23, 11, "", -11},
  {3.5540383417775919951964170e+04, 7, "355403834178", 5},
  {2.6071255376172006130218506e+08, 20, "26071255376172006130218505859", 9},
  {2.7556489960406188000000000e+16, 2, "27556489960406188", 17},
  {2.3270608663029260857015360e-07, 13, "2327061", -6},
  {1.9809674824468212688532761e-22, 3, "", -3},
  {2.1691642655829796240141150e+03, 11, "216916426558298", 4},
  {2.1695953449070249023437500e+12, 6, "2169595344907024902", 13},
  {1.1089352899635693434909900e-03, 4, "11", -2},
  {6.0979904920805606816092137e-02, 12, "60979904921", -1},
  {7.6813002386500807479023933e+06, 19, "76813002386500807479023933", 7},
  {1.3562346900285739049709059e-18, 20, "136", -17},
  {1.7435274851516845537491001e-15, 8, "", -8},
  {2.4579859491280314448975162e-14, 6, "", -6},
  {7.2683778342362960565165020e-04, 13, "7268377834", -3},
  {4.8569612326585259288549423e+06, 20, "485696123265852592885494232", 7},
  {3.5358855158619100057618940e-21, 11, "", -11},
  {1.0503082522542129135369380e-18, 11, "", -11},
  {3.6273148704706104103288924e-20, 0, "", 0},
  {1.1071824053947776250000000e+15, 20, "1107182405394777625", 16},
  {6.6010138378270921677426486e-01, 13, "6601013837827", 0},
  {5.4231781740024906484458752e-20, 0, "", 0},
  {2.4522252196243520000000000e+15, 9, "2452225219624352", 16},
  {7.0572586924891684864000000e+19, 12, "70572586924891684864", 20},
  {1.0217880666364892385900021e+06, 14, "102178806663648923859", 7},
  {2.9483900880936243200000000e+19, 3, "294839008809362432", 20},
  {7.9878013466025644197287051e-06, 6, "8", -5},
  {3.7826642848138164360226610e-10, 1, "", -1},
  {8.4088506148627129022088411e+00, 15, "8408850614862713", 1},
  {1.7579433817248296808774533e-04, 1, "", -1},
  {1.9332656158268485069274902e+09, 17, "193326561582684850692749023", 10},
  {1.0403176789442682983924042e-16, 14, "", -14},
  {1.0039795503757281601428986e+08, 13, "1003979550375728160143", 9},
  {9.3825035422446403646147984e-07, 4, "", -4},
  {5.8385795804492416381835938e+09, 3, "5838579580449", 10},
  {6.3052164543062208398046758e-19, 19, "6", -18},
  {5.5638673354365340228815914e-12, 12, "6", -11},
  {1.2375543973901499683609728e-01, 2, "12", 0},
  {1.0388203474253015715414821e-20, 3, "", -3},
  {5.5815137228740052727327467e-11, 7, "", -7},
  {2.9210798127081980000000000e+15, 18, "2921079812708198", 16},
  {8.3667295895441738281250000e+12, 10, "8366729589544173828125", 13},
  {1.9514433010172419165455245e-16, 17, "2", -15},
  {1.9408517677553081512451172e+09, 7, "19408517677553082", 10},
  {1.7459723380316277945717429e-04, 14, "1745972338", -3},
  {8.3958274229548547363281250e+11, 20, "8395827422954854736328125", 12},
  {6.9979939257808521389961243e+07, 19, "699799392578085213899612427", 8},
  {2.9239129463333117023570108e-17, 20, "2924", -16},
  {9.9330093747916874682011823e-22, 2, "", -2},
  {1.0264881069397820100570507e-25, 19, "", -19},
  {1.5492955179411303932386819e-07, 8, "15", -6},
  {7.5046157999691821289062500e+11, 6, "750461579996918213", 12},
  {1.3777210283011610000000000e+15, 1, "1377721028301161", 16},
  {8.5151852716647343905445362e-11, 1, "", -1},
  {7.9101844159273750551014186e-13, 5, "", -5},
  {3.4329945146335640000000000e+15, 7, "3432994514633564", 16},
  {1.0737463285769835520000000e+18, 19, "1073746328576983552", 19},
  {1.2648848470801468487362757e-16, 3, "", -3},
  {4.2860328809981107711791992e+07, 7, "428603288099811", 8},
  {2.5308797972437164800000000e+17, 6, "253087979724371648", 18},
  {1.4920734339808508438112361e-08, 4, "", -4},
  {9.4244828912744553657543367e-04, 2, "", -2},
  {1.0440167959861879040000000e+18, 10, "1044016795986187904", 19},
  {1.6165825072797622396599662e-08, 18, "16165825073", -7},
  {1.4095927061552210908186180e-08, 20, "1409592706155", -7},
  {3.5930300901099404624348974e-19, 6, "", -6},
  {9.5350829151924259008410445e+00, 10, "95350829152", 1},
  {1.3266042908134572542167007e+01, 18, "13266042908134572542", 2},
  {1.2505779997544516640190365e-20, 7, "", -7},
  {2.4411385205625170179165266e-23, 16, "", -16},
  {1.3427571834893564313600000e+20, 17, "134275718348935643136", 21},
  {1.5514916860739866256713867e+10, 12, "15514916860739866256714", 11},
  {4.4761933288478442526462110e-15, 13, "", -13},
  {4.6670100663251985750868137e-21, 17, "", -17},
  {4.6867516200407752704000000e+19, 3, "46867516200407752704", 20},
  {2.1422698771055137534347068e+00, 7, "21422699", 1},
  {1.0069574991620120272273198e+04, 18, "10069574991620120272273", 5},
  {8.8071627514532712500000000e+14, 19, "880716275145327125", 15},
  {2.3416074584341656949397839e-07, 8, "23", -6},
  {9.2145135388155586042557843e+02, 4, "9214514", 3},
  {2.3320314294564871093750000e+13, 12, "2332031429456487109375", 14},
  {2.0138075315929729472261383e-14, 4, "", -4},
  {1.3746535877606321760902374e-14, 4, "", -4},
  {1.2046624723722257920000000e+18, 11, "1204662472372225792", 19},
  {2.1381819584608907256695356e-10, 0, "", 0},
  {2.9877557911704147215035967e-13, 10, "", -10},
  {5.2493269257968401368674716e-04, 3, "1", -2},
  {7.0369357829532071622196960e-07, 7, "7", -6},
  {2.4091509279909659177064896e+07, 6, "2409150927991", 8},
  {1.7420226369002229606380129e-12, 0, "", 0},
  {1.4055556131200024552576949e-08, 4, "", -4},
  {1.1268918654124698056721050e-19, 3, "", -3},
  {3.1378745976460263900752613e-08, 6, "", -6},
  {1.0185455813338465625000000e+14, 7, "10185455813338465625", 15},
  {9.9683118726912641432136297e+05, 18, "996831187269126414321363", 6},
  {5.6424470191210487683665720e-18, 15, "", -15},
  {2.7332242682392950230515263e-08, 7, "", -7},
  {8.0755449435455170288247241e-18, 12, "", -12},
  {9.7926247921589979470759213e-05, 18, "9792624792159", -4},
  {1.9180673661630423794122180e+03, 1, "19181", 4},
  {5.3884212904267129600000000e+17, 20, "538842129042671296", 18},
  {2.2067475480970882890312869e-16, 14, "", -14},
  {5.0906779322999614477157593e+08, 15, "509067793229996144771576", 9},
  {1.5244589326805431365966797e+10, 3, "15244589326805", 11},
  {2.6017930908040876050134766e-21, 1, "", -1},
  {1.3397829608974264934659004e+07, 19, "133978296089742649346590042", 8},
  {6.2584997926966548509319921e-02, 0, "", 0},
  {1.3745084680488884288660076e-11, 8, "", -8},
  {1.5302107820164911292400083e-08, 1, "", -1},
  {4.0165460960767061898508793e-19, 12, "", -12},
  {2.1800953435681326293945312e+11, 8, "21800953435681326294", 12},
  {7.2482982365771144241137076e-11, 18, "72482982", -10},
  {9.6695954617001570295542479e+05, 17, "96695954617001570295542", 6},
  {4.8551736065936390573938297e-01, 16, "4855173606593639", 0},
  {2.3083129384150553252595278e-17, 11, "", -11},
  {4.5956664587413411936722696e+04, 19, "459566645874134119367227", 5},
  {2.6562829003886464238166809e+08, 10, "2656282900388646424", 9},
  {2.3153160739698577880859375e+10, 16, "23153160739698577880859375", 11},
  {2.0743663059321265791368205e+03, 7, "20743663059", 4},
  {7.9778815096415944704000000e+19, 6, "79778815096415944704", 20},
  {7.9202669996697339229285717e+05, 4, "7920267", 6},
  {2.2910275576813303198988241e-10, 9, "", -9},
  {3.9826872010429713792933890e-23, 11, "", -11},
  {8.7575758813337866710981839e-22, 5, "", -5},
  {1.2500140920750840017872108e-02, 14, "1250014092075", -1},
  {4.1523940709664266649600000e+20, 20, "415239407096642666496", 21},
  {1.8426902163968474468447312e+01, 2, "1843", 2},
  {1.4664929010305235990152539e-02, 14, "1466492901031", -1},
  {1.3430939669966327217914192e-14, 7, "", -7},
  {1.7885467935446170972824120e+00, 18, "1788546793544617097", 1},
  {6.1572403987769829109311104e+06, 13, "61572403987769829109", 7},
  {2.0858756207549614080000000e+18, 1, "2085875620754961408", 19},
  {9.6845009787048584257718176e+03, 20, "968450097870485842577182", 4},
  {2.7422947418611045662586046e-06, 16, "27422947419", -5},
  {1.9030613668382666752000000e+19, 16, "19030613668382666752", 20},
  {1.3986334173998022579988164e-13, 18, "139863", -12},
  {1.0592197175545956352000000e+19, 14, "10592197175545956352", 20},
  {1.9000656608576905216000000e+19, 5, "19000656608576905216", 20},
  {1.5983822127791475712493829e-06, 14, "159838221", -5},
  {3.4121521674972580512985587e+05, 20, "34121521674972580512985587", 6},
  {2.3884879951577621093750000e+13, 4, "238848799515776211", 14},
  {2.1336350293456572265625000e+12, 9, "2133635029345657226563", 13},
  {1.4127166486490305331200000e+20, 14, "141271664864903053312", 21},
  {1.6551219233402093286083655e-08, 18, "16551219233", -7},
  {3.8734187956834180926015201e-06, 16, "38734187957", -5},
  {4.8989057503797421744545824e-23, 3, "", -3},
  {1.4146823799731721305205600e-20, 12, "", -12},
  {3.7400973088678200000000000e+16, 15, "374009730886782", 17},
  {3.7105483193160687129242912e-25, 0, "", 0},
  {7.0704638895917332774843089e+03, 19, "70704638895917332774843", 4},
  {6.3863283293138116608000000e+19, 10, "63863283293138116608", 20},
  {2.1947866349965835429608810e-05, 3, "", -3},
  {7.7063357205621762895575717e-16, 20, "77063", -15},
  {5.2712237913733312957034706e-07, 20, "52712237913733", -6},
  {2.8521065630777724087238312e+07, 18, "28521065630777724087238312", 8},
  {8.5127933220389826645194131e-05, 17, "8512793322039", -4},
  {5.1171392672293978921895107e-20, 12, "", -12},
  {9.6825379599818892800000000e+17, 15, "968253795998188928", 18},
  {2.1859623205065857188064577e-16, 11, "", -11},
  {1.1176846923760185600000000e+17, 8, "111768469237601856", 18},
  {8.9446919108853339843750000e+12, 9, "8944691910885333984375", 13},
  {5.6484962735923469066619873e+08, 15, "564849627359234690666199", 9},
  {2.3114872945805229912648277e-11, 12, "23", -10},
  {4.8419619999746541976928711e+09, 12, "4841961999974654197693", 10},
  {4.1741044362541973876953125e+11, 13, "4174104436254197387695313", 12},
  {1.2842726232477462069103000e-14, 6, "", -6},
  {1.4844018836151946978683097e-20, 16, "", -16},
  {3.9674906119813930724946590e-17, 5, "", -5},
  {3.5793181112977778823847075e-01, 12, "35793181113", 0},
  {2.0217755011600096153492908e-22, 10, "", -10},
  {8.2853506262891836211200000e+20, 18, "828535062628918362112", 21},
  {6.1570573092367588279704145e-17, 20, "6157", -16},
  {6.1710286794014686837849578e-14, 8, "", -8},
  {2.1879869172834505422212015e-18, 8, "", -8},
  {3.2915664745123698989180681e-18, 19, "33", -17},
  {1.4191652367644458000000000e+16, 6, "14191652367644458", 17},
  {4.5303109246118714379475358e-08, 4, "", -4},
  {7.3561246057884979165919503e+00, 18, "7356124605788497917", 1},
  {6.4739152532596521563506252e-06, 17, "647391525326", -5},
  {2.1123795009726179798748289e-17, 3, "", -3},
  {1.3754178687814373376000000e+19, 7, "13754178687814373376", 20},
  {2.2502273472308165482427211e-25, 13, "", -13},
  {8.1687708698884364810766101e-02, 19, "816877086988843648", -1},
  {4.5105286041726825248502297e-16, 17, "45", -15},
  {2.3296137238125655130716041e+04, 7, "232961372381", 5},
  {2.4845200835806627840000000e+18, 6, "2484520083580662784", 19},
  {9.5447120319222461500795281e-14, 20, "9544712", -13},
  {2.8419498818817801173478677e-08, 9, "28", -7},
  {1.9442923679421440091852347e-03, 10, "19442924", -2},
  {5.7625909468933464959263802e+06, 3, "5762590947", 7},
  {4.5356331591176751357389956e-24, 14, "", -14},
  {2.2353238346924636092017541e-05, 18, "22353238346925", -4},
  {4.1774911976017218750000000e+13, 13, "4177491197601721875", 14},
  {7.8967481461883443833585377e-25, 6, "", -6},
  {4.3467810557033428558465703e-12, 10, "", -10},
  {1.0219261155240843598896979e-06, 17, "102192611552", -5},
  {1.9268561063729546731337905e+04, 15, "19268561063729546731", 5},
  {4.6153679094323860204198383e-06, 11, "461537", -5},
  {5.2355398554833298549056053e+06, 10, "52355398554833299", 7},
  {1.0000109816749733898655350e-02, 15, "1000010981675", -1},
  {3.2461403361300879947974571e-21, 3, "", -3},
  {6.0065009246980714863184403e+01, 11, "6006500924698", 2},
  {2.8652415636629203800112009e+05, 10, "286524156366292", 6},
  {1.0237571524511597817763686e+05, 4, "1023757152", 6},
  {9.4347870265524040000000000e+15, 17, "9434787026552404", 16},
  {6.1089052364081552734375000e+12, 6, "6108905236408155273", 13},
  {1.3465887890832430452518753e-04, 3, "", -3},
  {4.7701802810479230880737305e+09, 8, "477018028104792309", 10},
  {7.8466624900829666137695312e+10, 18, "784666249008296661376953125", 11},
  {4.5955336586689809029861002e-06, 1, "", -1},
  {1.0280868281388611649163067e+03, 6, "1028086828", 4},
  {6.7824355295925112000000000e+16, 0, "67824355295925112", 17},
  {1.9438838527844801451597882e-16, 1, "", -1},
  {2.2908351851677105878479779e+05, 6, "229083518517", 6},
  {2.9773286768951846087572653e-20, 1, "", -1},
  {3.6011734079579116215798164e-24, 9, "", -9},
  {2.4722229495932343750000000e+13, 9, "2472222949593234375", 14},
  {1.8758746223249948120117188e+11, 1, "1875874622325", 12},
  {1.3628143545901791015625000e+13, 11, "13628143545901791015625", 14},
  {1.2643968980621496093750000e+13, 4, "126439689806214961", 14},
  {1.0311291776893462853332825e-24, 12, "", -12},
  {1.4756014338206860091506506e-12, 10, "", -10},
  {1.3542155985897763724747266e-23, 19, "", -19},
  {5.4718441817998855551104496e-18, 10, "", -10},
  {3.1010486471397972581920350e-22, 5, "", -5},
  {5.4809672470231857620073822e-19, 11, "", -11},
  {2.5012456301560271875000000e+14, 16, "25012456301560271875", 15},
  {2.3031893579985160613432527e+04, 7, "2303189358", 5},
  {1.2999129082195677334864679e-05, 18, "12999129082196", -4},
  {3.1379322565645478515625000e+12, 11, "31379322565645478515625", 13},
  {2.0207986736066949218750000e+13, 16, "2020798673606694921875", 14},
  {1.0929192001993539929389954e+08, 9, "109291920019935399", 9},
  {4.8200567955289291573374519e-10, 16, "4820057", -9},
  {1.0422193008441468521137497e-20, 11, "", -11},
  {3.8464675857038846728254742e-22, 0, "", 0},
  {6.2610116634218735702966004e-06, 7, "63", -5},
  {5.2827811129572734868658829e-23, 7, "", -7},
  {4.3929705555689770000000000e+15, 3, "4392970555568977", 16},
  {3.2035736747763416290283203e+10, 17, "3203573674776341629028320313", 11},
  {2.9886807890500572160000000e+18, 1, "2988680789050057216", 19},
  {6.2274129148879024745324601e-22, 2, "", -2},
  {6.0200114408756249223368413e-08, 19, "602001144088", -7},
  {3.3968109401211580000000000e+16, 18, "3396810940121158", 17},
  {3.7660995502656894207803464e-15, 11, "", -11},
  {2.2254285487129292042500495e-05, 15, "22254285487", -4},
  {4.8501148121516310000000000e+15, 3, "4850114812151631", 16},
  {1.0205372947668609188239219e-23, 8, "", -8},
  {4.1754517829310583465485252e+02, 14, "41754517829310583", 3},
  {5.8418083474626976153600000e+20, 12, "584180834746269761536", 21},
  {1.1115990488321564043872058e+04, 18, "11115990488321564043872", 5},
  {9.0047204298634020996093750e+11, 13, "9004720429863402099609375", 12},
  {9.5837608667421234076577718e-02, 6, "95838", -1},
  {1.7011462737808134988881648e+05, 15, "170114627378081349889", 6},
  {4.6943889397480583284050226e+05, 4, "469438894", 6},
  {1.7701515794881252206049375e-10, 7, "", -7},
  {4.0681174013149328179200000e+20, 14, "406811740131493281792", 21},
  {7.3824306027238539851254018e-01, 9, "73824306", 0},
  {6.5089871970185909356670022e-25, 19, "", -19},
  {2.2730454069477787613868713e+08, 15, "227304540694777876138687", 9},
  {4.6179264447683790000000000e+15, 10, "4617926444768379", 16},
  {6.4439810371496805466559208e-25, 19, "", -19},
  {3.3172337702431712772344909e-07, 13, "3317234", -6},
  {2.4260783728431939421099628e-01, 16, "2426078372843194", 0},
  {2.6910900461496378524125912e-12, 13, "27", -11},
  {1.1745522614666376113891602e+10, 0, "11745522615", 11},
  {2.9607995281359308362586783e-10, 13, "2961", -9},
  {1.7753402665862819200000000e+17, 17, "177534026658628192", 18},
  {4.9094023250605408102273941e+06, 4, "49094023251", 7},
  {4.3179001320631958007812500e+10, 7, "43179001320631958", 11},
  {1.3448644310758428648114204e+07, 8, "1344864431075843", 8},
  {3.6518792036498042286041255e+00, 19, "36518792036498042286", 1},
  {4.7059399441841475427530450e-16, 4, "", -4},
  {4.0045106119043561629951000e+06, 18, "40045106119043561629951", 7},
  {1.7300156805402426880000000e+18, 11, "1730015680540242688", 19},
  {2.5427166489342479895292392e-18, 15, "", -15},
  {2.0713584906369666560000000e+18, 9, "2071358490636966656", 19},
  {1.2148722958385307788848877e+09, 15, "1214872295838530778884888", 10},
  {3.8317264883830483751150458e-22, 4, "", -4},
  {1.3212808496217354203849936e-01, 13, "1321280849622", 0},
  {1.5318421678431096540685223e-12, 7, "", -7},
  {7.9861911377493264913795615e-16, 1, "", -1},
  {1.3780532107680482918400000e+20, 9, "137805321076804829184", 21},
  {5.0976531746312867840000000e+18, 1, "5097653174631286784", 19},
  {1.3148618748897606709142604e-25, 5, "", -5},
  {7.1029512329205114880000000e+18, 7, "7102951232920511488", 19},
  {1.6514648561088941406250000e+13, 7, "165146485610889414063", 14},
  {1.2411483389376910813073351e-01, 3, "124", 0},
  {4.0037086924741744657373082e-25, 12, "", -12},
  {2.0660017113570886718750000e+13, 7, "206600171135708867188", 14},
  {2.9056773961582075430976906e-15, 9, "", -9},
  {6.8885542636595664678367257e-01, 0, "1", 1},
  {2.1287173604489491117419063e-16, 7, "", -7},
  {1.2989662076110181435084634e-04, 12, "129896621", -3},
  {4.0815034070974049712053182e-16, 12, "", -12},
  {1.8951103089389017645876885e-11, 8, "", -8},
  {1.0743894382672733625534363e-17, 6, "", -6},
  {7.7090164811308400640000000e+20, 3, "7709016481130840064", 21},
  {1.0661256161275256090448238e+04, 11, "1066125616127526", 5},
  {1.4678460782702787500000000e+14, 14, "146784607827027875", 15},
  {5.9941701821597744000000000e+16, 15, "59941701821597744", 17},
  {6.4479703340719367987536806e-22, 4, "", -4},
  {7.9200649393024218558254090e-06, 4, "", -4},
  {1.0784025908342499881471482e-20, 14, "", -14},
  {2.1050238906345041468739510e+06, 18, "2105023890634504146873951", 7},
  {1.0442475597236828542737810e-13, 10, "", -10},
  {4.2228743461454400716800000e+20, 11, "422287434614544007168", 21},
  {4.0305597091900063476562500e+12, 15, "403055970919000634765625", 13},
  {1.0426004934830555889155851e-16, 0, "", 0},
  {1.3402020530514745712280273e+09, 14, "134020205305147457122803", 10},
  {3.9021468552008825000000000e+15, 4, "39021468552008825", 16},
  {6.3661876705338240000000000e+16, 10, "6366187670533824", 17},
  {1.4170009947421766810515820e-02, 19, "141700099474217668", -1},
  {2.4092814061131308000000000e+16, 14, "24092814061131308", 17},
  {1.2288194168592822443336738e-20, 10, "", -10},
  {4.7170474219975105887189588e-17, 4, "", -4},
  {2.5743551593931171200000000e+17, 4, "257435515939311712", 18},
  {2.7879705425308327071258824e-12, 1, "", -1},
  {2.4150902046834609375000000e+14, 0, "241509020468346", 15},
  {1.1513564546468284532920734e+00, 5, "115136", 1},
  {1.8526974128076677537922638e-17, 12, "", -12},
  {2.5439032570822884493334326e-13, 7, "", -7},
  {1.0217163412339367732250332e-14, 7, "", -7},
  {4.4414723864769061279296875e+11, 5, "44414723864769061", 12},
  {1.1061969932721356800000000e+18, 2, "110619699327213568", 19},
  {3.7675114388685986011642614e-17, 4, "", -4},
  {2.4344116949901097827988504e-17, 2, "", -2},
  {2.4636167843818389504000000e+20, 13, "24636167843818389504", 21},
  {9.4744955788806439755944666e-01, 0, "1", 1},
  {2.6708411442687462693083584e-06, 6, "3", -5},
  {1.7097822990721099358779611e+03, 16, "17097822990721099359", 4},
  {3.9688641678535440005362034e+06, 20, "396886416785354400053620338", 7},
  {2.1969814553703183593750000e+12, 9, "2196981455370318359375", 13},
  {7.7312754509979422432031093e-03, 12, "7731275451", -2},
  {9.6075561676284996875449655e-16, 4, "", -4},
  {6.5462140066607776000000000e+16, 7, "65462140066607776", 17},
  {6.5250011798997270897408190e-10, 20, "65250011799", -9},
  {4.5041790464352424519511864e-03, 5, "45", -2},
  {2.0263606382951727136969566e+06, 2, "202636064", 7},
  {1.3963341175526164623517585e-21, 16, "", -16},
  {2.7564092582179585763889069e-08, 0, "", 0},
  {9.0077958790474864000000000e+16, 4, "90077958790474864", 17},
  {7.5159842664882252263186535e-05, 18, "75159842664882", -4},
  {1.7677330816079808543939134e-03, 17, "176773308160798", -2},
  {9.4509524712389464015652859e-22, 13, "", -13},
  {2.9066154289605129236451209e-03, 17, "290661542896051", -2},
  {3.6772495366384844760331983e-07, 9, "368", -6},
  {4.7027522520425826865297490e-17, 16, "", -16},
  {4.2843117431143936529869265e-03, 19, "42843117431143937", -2},
  {6.0301186171997398584223443e-06, 20, "603011861719974", -5},
  {3.3751715425176166400000000e+18, 18, "337517154251761664", 19},
  {9.0076915165702312500000000e+13, 14, "900769151657023125", 14},
  {5.3927929262510786412545867e-18, 0, "", 0},
  {2.7317684123466448896000000e+20, 8, "27317684123466448896", 21},
  {2.8456234076593320184733093e-08, 8, "3", -7},
  {6.3336133639221341582015157e+04, 5, "6333613364", 5},
  {9.5603896441437099173663028e-05, 3, "", -3},
  {4.1488241152511728865808763e-24, 12, "", -12},
  {2.2490949201855401992797852e+09, 8, "22490949201855402", 10},
  {1.5366671571317684720270336e+05, 10, "1536667157131768", 6},
  {2.3577844303381419153319381e-17, 8, "", -8},
  {9.9117537533501322035200000e+20, 6, "991175375335013220352", 21},
  {1.8067367152375425620736138e-02, 15, "18067367152375", -1},
  {7.0826867882340783000891075e-06, 18, "7082686788234", -5},
  {9.1942687727739803588066141e-21, 5, "", -5},
  {9.6258973326279417825901419e-02, 0, "", 0},
  {3.3818136433060360000000000e+16, 8, "3381813643306036", 17},
  {3.0306501212592766976000000e+19, 12, "30306501212592766976", 20},
  {1.5324704181975670158863068e+07, 6, "15324704181976", 8},
  {1.8563563841609636302175476e-24, 5, "", -5},
  {1.7755710024314521433552727e+02, 12, "177557100243145", 3},
  {1.2264418524892205987582749e-23, 10, "", -10},
  {8.7553676871707000732421875e+09, 15, "8755367687170700073242188", 10},
  {3.0435633429921060000000000e+15, 3, "3043563342992106", 16},
  {8.6055819421805606400000000e+17, 3, "860558194218056064", 18},
  {8.7995541328212844261883811e-11, 16, "879955", -10},
  {7.5480696325120959500054596e+02, 6, "754806963", 3},
  {1.7909274529309957120000000e+18, 15, "1790927452930995712", 19},
  {2.9392868604071693159555511e-06, 5, "", -5},
  {3.3084278364964251522906125e+04, 8, "3308427836496", 5},
  {7.8506625312818237580358982e+05, 3, "785066253", 6},
  {5.5269132925925349837979270e-18, 10, "", -10},
  {3.1130458330303985000000000e+15, 19, "31130458330303985", 16},
  {2.8117577165284388595352975e-25, 18, "", -18},
  {4.4223470110949714064352972e-05, 5, "4", -4},
  {1.8253812245820285952711798e-19, 3, "", -3},
  {3.9606364614922142125235581e-23, 16, "", -16},
  {3.5050949001917409787967317e-20, 6, "", -6},
  {1.6800610864975184527431032e-06, 15, "1680061086", -5},
  {1.6755274069899731445312500e+12, 1, "167552740699", 13},
  {3.9488778187909285000000000e+15, 10, "39488778187909285", 16},
  {3.9403950729249091736966872e-07, 10, "394", -6},
  {5.7668807235671025544082591e-04, 9, "576688", -3},
  {3.1028475596113472420256585e+04, 12, "31028475596113472", 5},
  {1.0583912590114386667422523e-20, 17, "", -17},
  {4.6072284885702541280469435e-05, 10, "460723", -4},
  {1.5030661272108300181571394e+03, 14, "150306612721083002", 4},
  {6.6179355839817423839122057e+05, 10, "6617935583981742", 6},
  {4.6475959964555851877676673e-01, 19, "4647595996455585188", 0},
  {1.3911748770266370501440603e-05, 1, "", -1},
  {1.9949570458716196299064904e+04, 6, "19949570459", 5},
  {2.2752119954040899568736833e-03, 12, "2275211995", -2},
  {2.1389434248341132500000000e+15, 11, "213894342483411325", 16},
  {2.1689503653450956427908708e-11, 16, "216895", -10},
  {1.0582347256855563305762310e-17, 12, "", -12},
  {3.1645639806013519113037091e+00, 2, "316", 1},
  {1.1415836468103174317079151e-01, 7, "1141584", 0},
  {9.5316159592160493568000000e+19, 10, "95316159592160493568", 20},
  {1.9218455319331437132580424e-10, 5, "", -5},
  {2.0740087040163858911780479e-16, 0, "", 0},
  {4.1462062283668431261878725e-16, 12, "", -12},
  {3.6950877310006241538431482e-01, 8, "36950877", 0},
  {9.7752530121145966002171826e-20, 7, "", -7},
  {7.8495736888542013168334961e+09, 18, "7849573688854201316833496094", 10},
  {1.2967880769686474000000000e+16, 13, "12967880769686474", 17},
  {9.7256269133981447794212727e+02, 19, "9725626913398144779421", 3},
  {1.8324380803950522880000000e+18, 9, "1832438080395052288", 19},
  {2.5793335561161849975585938e+11, 12, "257933355611618499755859", 12},
  {3.0268767913488343358039856e+07, 4, "302687679135", 8},
  {3.1596230154029089026153088e+06, 6, "3159623015403", 7},
  {2.7760196202313617522706296e-05, 9, "2776", -4},
  {3.4990287075203659495007643e-22, 11, "", -11},
  {3.5913236308734706745918637e-09, 5, "", -5},
  {2.0039527723853205280296342e-22, 3, "", -3},
  {1.1799441587187557220458984e+09, 9, "1179944158718755722", 10},
  {2.5930069021090019226074219e+10, 0, "25930069021", 11},
  {5.1561831450972832739353180e+07, 18, "5156183145097283273935318", 8},
  {3.7419668228519681250000000e+14, 14, "3741966822851968125", 15},
  {3.6127657147279223632812500e+11, 0, "361276571473", 12},
  {2.7327128251651947021484375e+11, 17, "27327128251651947021484375", 12},
  {5.0915918195694269930695608e-04, 10, "5091592", -3},
  {2.5410522488305178815657557e-11, 2, "", -2},
  {2.6966600021667669352609664e+04, 13, "269666000216676694", 5},
  {7.3485758016410537109375000e+12, 4, "73485758016410537", 13},
  {4.9317281215721112060546875e+11, 2, "49317281215721", 12},
  {2.3927899522246500954669782e-23, 8, "", -8},
  {4.7825839934098590688904551e+00, 9, "4782583993", 1},
  {3.1773470685101837053574671e-15, 11, "", -11},
  {2.2920177385986234403232318e-14, 14, "2", -13},
  {9.3504078666179469396785838e-14, 2, "", -2},
  {2.7941144024908697600000000e+19, 15, "279411440249086976", 20},
  {4.5364557069380516186356544e+06, 17, "453645570693805161863565", 7},
  {2.0037080523224821777343750e+12, 10, "20037080523224821777344", 13},
  {7.1471024262765058665536344e+02, 12, "714710242627651", 3},
  {2.1749123293395473480224609e+10, 7, "217491232933954735", 11},
  {8.1922998481270190080000000e+18, 11, "8192299848127019008", 19},
  {6.8671810238230088663941020e-04, 6, "687", -3},
  {9.1754359772165312000000000e+17, 4, "91754359772165312", 18},
  {4.8230777937018858680549505e-15, 20, "482308", -14},
  {1.4657678877777640244396950e-13, 8, "", -8},
  {2.5230319240287378351904268e-14, 10, "", -10},
  {2.3698390254992500872139182e-10, 11, "24", -9},
  {6.8244303756456656134667300e-17, 1, "", -1},
  {9.3596372402875660661034342e-22, 8, "", -8},
  {1.5732746841888122706462235e-18, 0, "", 0},
  {6.0880612434691712000000000e+17, 14, "60880612434691712", 18},
  {1.5568406274291263224895943e-02, 15, "15568406274291", -1},
  {1.3120540037931876257061958e+07, 14, "1312054003793187625706", 8},
  {1.1923711191847757493150056e-06, 1, "", -1},
  {1.2011929093741720199584961e+10, 19, "120119290937417201995849609375", 11},
  {7.0311259263059279410203767e-16, 11, "", -11},
  {4.9798166532432087500000000e+14, 4, "497981665324320875", 15},
  {5.8339136448869619369506836e+09, 5, "583391364488696", 10},
  {1.5723427792259531121190632e-11, 1, "", -1},
  {4.4357462579336642211958776e-06, 18, "4435746257934", -5},
  {2.7341543809970674940125065e-16, 7, "", -7},
  {4.2595387156623510236386210e+04, 10, "425953871566235", 5},
  {2.9068085921157535481432716e-13, 14, "29", -12},
  {1.0834116069747547588156944e-16, 15, "", -15},
  {3.1900217616396497888331396e-02, 14, "319002176164", -1},
  {3.8662169127026337890625000e+12, 18, "38662169127026337890625", 13},
  {2.6326855115071419747520989e-11, 19, "263268551", -10},
  {5.4101784362375322603367705e-19, 0, "", 0},
  {1.7817892740829945312500000e+13, 2, "1781789274082995", 14},
  {4.9695842127193248271942139e+08, 14, "49695842127193248271942", 9},
  {3.3856750414859216000000000e+16, 12, "33856750414859216", 17},
  {4.9979519803477975940568400e-19, 0, "", 0},
  {2.9259585505354924000000000e+16, 8, "29259585505354924", 17},
  {4.5803283376903687340586657e+00, 12, "458032833769", 1},
  {1.0747470892287106474214913e-20, 18, "", -18},
  {6.2407621752713715590488164e-01, 11, "62407621753", 0},
  {4.2750791733755795000000000e+15, 2, "42750791733755795", 16},
  {8.2639048480507085514545906e+01, 7, "826390485", 2},
  {4.0310205198198404243688925e-05, 7, "403", -4},
  {2.2518478220604214843750000e+13, 0, "22518478220604", 14},
  {8.5633511086708956875045353e-20, 0, "", 0},
  {1.2679307222656448737863055e-03, 6, "1268", -2},
  {8.0356554162948976640000000e+18, 6, "8035655416294897664", 19},
  {1.9948924334444372653961182e+09, 7, "19948924334444373", 10},
  {1.0713690946815651840000000e+19, 16, "1071369094681565184", 20},
  {2.2908794866270958779010740e-08, 0, "", 0},
  {2.4718952862641342079581924e-21, 19, "", -19},
  {5.7425302344918050483260857e-21, 8, "", -8},
  {5.6744011901121896128562121e-24, 7, "", -7},
  {1.1515578905079348385334015e+08, 0, "115155789", 9},
  {6.9483977099169235229492188e+09, 11, "694839770991692352295", 10},
  {1.2701407800724625000000000e+13, 20, "12701407800724625", 14},
  {1.4143238491661804800969549e+00, 2, "141", 1},
  {3.9025114489378207299069556e-04, 14, "39025114489", -3},
  {3.1244018409082660675048828e+09, 2, "312440184091", 10},
  {2.1962574807950438942919208e-14, 13, "", -13},
  {4.5905741444661989212036133e+09, 14, "459057414446619892120361", 10},
  {2.2113856720568126355859326e-15, 16, "22", -14},
  {1.0827635525839054427793455e-20, 7, "", -7},
  {2.2330578619593596800791576e-21, 4, "", -4},
  {4.9099903088125747672165744e+03, 14, "490999030881257477", 4},
  {1.1039000363868740350881126e+02, 5, "11039", 3},
  {1.0397447505814711524175493e-24, 2, "", -2},
  {1.1976415997107145376503468e+06, 5, "119764159971", 7},
  {8.0154571288654866070797008e-14, 12, "", -12},
  {5.8142443413159140830348548e-02, 7, "581424", -1},
  {1.5645296918974438000000000e+16, 20, "15645296918974438", 17},
  {2.7669531420479096667230934e-02, 13, "276695314205", -1},
  {5.3813081050233995264000000e+19, 3, "53813081050233995264", 20},
  {1.5062931601145148742944002e+06, 20, "150629316011451487429440022", 7},
  {4.2019561256667280273437500e+12, 9, "4201956125666728027344", 13},
  {1.3192109132898519787802237e-12, 3, "", -3},
  {1.4557812310929508253696520e-19, 8, "", -8},
  {1.2255913084699156673186206e-17, 4, "", -4},
  {1.4848632061615601642544652e-12, 19, "14848632", -11},
  {9.0370572297810963097175474e-03, 1, "", -1},
  {2.7907112011829785000000000e+15, 9, "27907112011829785", 16},
  {5.2947243916676333568000000e+20, 9, "52947243916676333568", 21},
  {3.2937689574260883091483265e+04, 0, "32938", 5},
  {9.5840100598603843362671716e-16, 9, "", -9},
  {3.4063856028459179687500000e+12, 19, "340638560284591796875", 13},
  {2.5695032124525006848000000e+19, 6, "25695032124525006848", 20},
  {7.6127997322040750205474069e+00, 17, "761279973220407502", 1},
  {9.9472220443697649385869230e-13, 9, "", -9},
  {6.0111599507715052255995993e-16, 4, "", -4},
  {1.9605167932166167040000000e+18, 0, "1960516793216616704", 19},
  {1.7709441024052687667200000e+20, 19, "177094410240526876672", 21},
  {4.4969077555630117465821977e-12, 17, "449691", -11},
  {4.2566500322265499323228436e-18, 12, "", -12},
  {1.3340645645849633293374597e-24, 19, "", -19},
  {1.5957562316576290396061382e-10, 14, "15958", -9},
  {1.0025970816907990723848343e+07, 18, "10025970816907990723848343", 8},
  {2.6145217749165638170413002e-17, 4, "", -4},
  {1.5476863566557703955073322e-02, 8, "1547686", -1},
  {8.5660070566548878087882566e-17, 15, "", -15},
  {3.3437313138697280453065907e-16, 5, "", -5},
  {2.3272926643558037281036377e+08, 18, "23272926643558037281036377", 9},
  {5.7247015270080261230468750e+10, 0, "5724701527", 11},
  {1.1291465519480243201453431e-13, 20, "11291466", -12},
  {2.5155996156000190464000000e+19, 15, "25155996156000190464", 20},
  {2.2861600222342855000000000e+15, 19, "22861600222342855", 16},
  {1.4361015863763879679027013e+04, 3, "14361016", 5},
  {3.1010012218209111651927338e-12, 11, "", -11},
  {3.5333837461430870165324610e-15, 16, "35", -14},
  {9.4834107866966937600000000e+18, 15, "948341078669669376", 19},
  {5.6436778404031591489911079e+06, 8, "564367784040316", 7},
  {2.4532727861937198638916016e+09, 8, "245327278619371986", 10},
  {2.2750504027909566391529231e-16, 4, "", -4},
  {4.2685536327068744000000000e+16, 12, "42685536327068744", 17},
  {7.6196732021937742829322815e+06, 18, "7619673202193774282932281", 7},
  {8.7178335905921760572379270e-09, 4, "", -4},
  {2.7500176026346495000000000e+15, 0, "275001760263465", 16},
  {1.1269931892665484800000000e+18, 18, "112699318926654848", 19},
  {1.4138856252108090000000000e+15, 5, "1413885625210809", 16},
  {4.7318345496912794113159180e+09, 2, "473183454969", 10},
  {1.1393549611100917760000000e+19, 9, "1139354961110091776", 20},
  {8.1223088425882686554833795e-15, 9, "", -9},
  {1.0747184431105767046815301e-07, 0, "", 0},
  {3.9078377642290012160000000e+19, 6, "3907837764229001216", 20},
  {4.2771637555810336914062500e+12, 7, "42771637555810336914", 13},
  {1.7904925759447877087666295e-19, 15, "", -15},
  {4.2576575332447979052585829e-03, 7, "42577", -2},
  {5.2369257911019813036546111e+03, 10, "5236925791102", 4},
  {1.4672701899108440532893638e-09, 16, "14672702", -8},
  {3.8936601865325534043518250e-18, 13, "", -13},
  {6.5523034214357033371925354e+07, 9, "65523034214357033", 8},
  {2.2809213347359297536000000e+19, 2, "22809213347359297536", 20},
  {7.0634791273364544475295839e-12, 7, "", -7},
  {3.2594832704196089868956129e-15, 2, "", -2},
  {7.3437581894479606318821442e-09, 5, "", -5},
  {8.2546067005987022402132593e-07, 15, "82546067", -6},
  {1.0434592258482924804687500e+12, 2, "104345922584829", 13},
  {2.2730247877289205789566040e+07, 18, "2273024787728920578956604", 8},
  {3.0409299647337244000000000e+16, 8, "30409299647337244", 17},
  {3.5799929132577067694853085e-22, 17, "", -17},
  {2.5796443930027699200000000e+17, 10, "257964439300276992", 18},
  {8.9658040371076807379722595e+07, 20, "8965804037107680737972259521", 8},
  {9.4929521632220125198364258e+08, 3, "949295216322", 9},
  {2.9713466489192148856091080e+02, 17, "29713466489192148856", 3},
  {1.5350218965786919107481892e-05, 5, "2", -4},
  {9.7875536066193152000000000e+16, 5, "97875536066193152", 17},
  {2.7318924524709753417968750e+11, 5, "27318924524709753", 12},
  {2.2487163058027573531508225e-04, 1, "", -1},
  {2.7963330878265036800000000e+19, 1, "279633308782650368", 20},
  {5.9491753440634090329677886e-22, 9, "", -9},
  {5.0762826376365047008907624e-23, 20, "", -20},
  {8.8279652461920861816406250e+11, 0, "882796524619", 12},
  {4.7906738677500632827354058e-15, 3, "", -3},
  {1.6680770212663001774984281e-13, 18, "166808", -12},
  {1.1625203524944260425399989e+05, 11, "1162520352494426", 6},
  {5.9001753166334783313249881e-08, 10, "59", -7},
  {4.8328121225640857940833119e-11, 7, "", -7},
  {2.4253711142428140258789062e+11, 17, "242537111424281402587890625", 12},
  {3.2975109928313906604501281e-21, 9, "", -9},
  {9.0058006482876972784502900e-08, 10, "901", -7},
  {2.8796045977320622438089127e-21, 19, "", -19},
  {2.9899838569628964251023717e+03, 4, "29899839", 4},
  {3.1389466362934825036714760e-12, 14, "314", -11},
  {1.2293763955171330962912180e+04, 14, "1229376395517133096", 5},
  {1.2082814123553148988321482e+02, 6, "120828141", 3},
  {5.2164658967928405067528742e-20, 20, "5", -19},
  {8.7460907103805739566833052e-11, 17, "8746091", -10},
  {1.8938659788528833538293839e+07, 17, "1893865978852883353829384", 8},
  {2.9031180414304096251726151e+07, 10, "290311804143040963", 8},
  {2.1280184960550312500000000e+15, 3, "212801849605503125", 16},
  {3.2679307399256408928067685e+01, 12, "32679307399256", 2},
  {2.4307782783964637651763496e+00, 19, "24307782783964637652", 1},
  {3.6648629635671526193618774e+07, 7, "366486296356715", 8},
  {2.0684336381122385014750874e-16, 14, "", -14},
  {9.1574687104362660318169253e-17, 15, "", -15},
  {8.5919568985666306398266743e-10, 16, "8591957", -9},
  {4.1225958761294747035012591e-16, 14, "", -14},
  {8.1180842836389899253845215e+08, 7, "811808428363899", 9},
  {1.7000432290983027200000000e+17, 13, "170004322909830272", 18},
  {2.5758779877661306880000000e+19, 20, "2575877987766130688", 20},
  {7.2557379952801278679790214e-14, 3, "", -3},
  {6.9772104286543906023881126e-17, 0, "", 0},
  {2.8958634428111841280000000e+18, 10, "2895863442811184128", 19},
  {2.3111378662604281250000000e+13, 15, "2311137866260428125", 14},
  {3.5287984375369222834706306e+05, 15, "352879843753692228347", 6},
  {4.4043139278709175091200000e+20, 9, "440431392787091750912", 21},
  {1.0014829656999489800039971e-03, 14, "10014829657", -2},
  {9.0131110403521102905273438e+10, 13, "901311104035211029052734", 11},
  {4.3366248550564647989053294e-20, 19, "", -19},
  {4.3419187905794242221448748e-05, 11, "4341919", -4},
  {3.5657522652189467884942253e-03, 19, "35657522652189468", -2},
  {6.8933210502820053384534018e-22, 14, "", -14},
  {7.8318344845401555073394508e-16, 18, "783", -15},
  {2.1120222406448810306556692e-24, 9, "", -9},
  {1.1559786542058739873649955e-14, 2, "", -2},
  {1.8026568383709716726246916e-05, 3, "", -3},
  {3.5150689101348371688043892e-06, 9, "3515", -5},
  {6.9904871416709399301904674e-22, 17, "", -17},
  {2.5858485110685735380853245e-02, 16, "258584851106857", -1},
  {8.1883751060935709015220496e-04, 4, "8", -3},
  {2.5615769586232768340039456e+00, 10, "25615769586", 1},
  {2.6454502872255424102400000e+20, 9, "264545028722554241024", 21},
  {7.5004695506004247818054864e+02, 12, "750046955060042", 3},
  {1.8592941893647339353249143e-11, 6, "", -6},
  {5.3316365640130242158734119e-22, 0, "", 0},
  {5.5310747541282569885253906e+10, 9, "55310747541282569885", 11},
  {1.4759909754971481388174936e-01, 6, "147599", 0},
  {7.0206221421887746508019883e-25, 16, "", -16},
  {4.0220461007646277463256359e-09, 4, "", -4},
  {2.6116452822225144636547611e-01, 7, "2611645", 0},
  {1.1301369954072899848274147e-01, 10, "1130136995", 0},
  {1.1425388216050690048941618e-01, 20, "11425388216050690049", 0},
  {3.6293046065851888859477015e-02, 3, "36", -1},
  {4.9057039837434785228281620e-10, 15, "49057", -9},
  {1.0100739437503611923373993e-25, 2, "", -2},
  {8.7374421858241429377714053e-21, 19, "", -19},
  {2.7132951003660877965864159e-19, 8, "", -8},
  {2.0409685285363592600253822e-06, 4, "", -4},
  {2.7354792116589781250000000e+13, 7, "2735479211658978125", 14},
  {2.4684836897147886455059052e+07, 6, "24684836897148", 8},
  {3.7422903563926743218782966e-12, 9, "", -9},
  {2.7714887483691550521630001e-21, 18, "", -18},
  {3.1192647988093116468138117e-19, 2, "", -2},
  {4.1499764710399743229858605e-05, 11, "4149976", -4},
  {7.0597265064568642532105759e-15, 6, "", -6},
  {1.2773601895675492914915733e-22, 12, "", -12},
  {8.4924629058342615585781236e-09, 19, "84924629058", -8},
  {5.0992457962451764862008377e-11, 0, "", 0},
  {2.6904956287761641835020785e-14, 9, "", -9},
  {3.1731631957923548766804372e-23, 7, "", -7},
  {3.0567571950329106766730547e+05, 3, "30567572", 6},
  {6.4268242876940828327904431e-25, 5, "", -5},
  {1.4345201436649947500000000e+15, 14, "143452014366499475", 16},
  {1.7460305494506673795740426e+00, 6, "1746031", 1},
  {1.1559556754130952634769801e-10, 17, "11559557", -9},
  {3.9312594724589180989402411e-16, 0, "", 0},
  {6.9739070849292727416468551e+02, 5, "69739071", 3},
  {2.9588754413425802340498194e+04, 4, "295887544", 5},
  {6.1503279075441329956054688e+10, 1, "615032790754", 11},
  {5.5212335631050145792000000e+19, 7, "55212335631050145792", 20},
  {1.5318998938788370000000000e+16, 2, "1531899893878837", 17},
  {2.3412052319218637497222346e-01, 17, "23412052319218637", 0},
  {1.0914866369745625268570051e-20, 14, "", -14},
  {7.2503896054145146880000000e+18, 19, "7250389605414514688", 19},
  {9.7948704013958013092633337e+03, 13, "97948704013958013", 4},
  {8.9312466755143235510460340e-25, 14, "", -14},
  {3.4218895717399418557325141e-03, 3, "3", -2},
  {3.0190755467233208384849930e-17, 18, "3", -16},
  {1.4457584376803029689275546e-22, 10, "", -10},
  {1.1280402290613017578125000e+12, 15, "11280402290613017578125", 13},
  {1.7942717868446851712388446e-03, 20, "179427178684468517", -2},
  {2.3020263211239046899044845e-12, 11, "", -11},
  {3.7880784607430973665032070e+02, 16, "3788078460743097367", 3},
  {2.1938515822711807634582629e-06, 1, "", -1},
  {1.1712907620608472131019515e-19, 14, "", -14},
  {4.0903143414877358208238708e-14, 8, "", -8},
  {1.1866538020214766430281896e-21, 10, "", -10},
  {4.3324311899549576194854089e-07, 20, "4332431189955", -6},
  {5.5855284469287784683555476e-04, 14, "55855284469", -3},
  {1.2394303997900632064000000e+19, 8, "12394303997900632064", 20},
  {2.1139796715505287500000000e+14, 20, "211397967155052875", 15},
  {2.0161986334419105352084312e-21, 0, "", 0},
  {4.0649094339497790718920019e-09, 7, "", -7},
  {1.1449763804229599273298845e+01, 18, "11449763804229599273", 2},
  {3.4199429099323820312500000e+13, 11, "341994290993238203125", 14},
  {7.4512321266093031424000000e+19, 12, "74512321266093031424", 20},
  {1.6907520169980821504000000e+19, 11, "16907520169980821504", 20},
  {8.1386884985753738419589354e+01, 1, "814", 2},
  {5.3123923838457303645554930e+04, 6, "53123923838", 5},
  {5.4391191791257613875193444e-04, 11, "54391192", -3},
  {1.6595925001239966745223667e-09, 17, "16595925", -8},
  {4.3323645069028129577636719e+09, 3, "4332364506903", 10},
  {3.4184552151499212474528022e-03, 20, "341845521514992125", -2},
  {5.8125990570687270653227330e-02, 12, "58125990571", -1},
  {2.2960193669362541410537725e-11, 7, "", -7},
  {2.3997056925026168832000000e+19, 4, "23997056925026168832", 20},
  {5.3796241631718338012695312e+10, 8, "5379624163171833801", 11},
  {4.3476243097479034679853570e-10, 20, "43476243097", -9},
  {3.8589324349167785000000000e+15, 14, "38589324349167785", 16},
  {4.0966698529934519878992205e-01, 5, "40967", 0},
  {1.7452225485651799768041712e-22, 12, "", -12},
  {2.5689330919457551567020085e-18, 2, "", -2},
  {3.4392426510518696960000000e+18, 19, "3439242651051869696", 19},
  {3.9198258668668917380273342e+04, 15, "3919825866866891738", 5},
  {1.9702977330975002256963080e-01, 9, "197029773", 0},
  {5.7802943138317596094566397e+03, 17, "578029431383175960946", 4},
  {9.3031995941172125916480901e-17, 11, "", -11},
  {1.1383874822203025867392178e-14, 10, "", -10},
  {3.3237109953383812500000000e+13, 4, "332371099533838125", 14},
  {6.2630668967551430687308311e+06, 8, "626306689675514", 7},
  {4.2987470712228727665743522e-04, 5, "43", -3},
  {5.9439811127329399805066579e-10, 9, "1", -8},
  {1.4198521512724720849973892e+01, 11, "1419852151272", 2},
  {2.2384209247511567289837277e-24, 20, "", -20},
  {1.7615651455378775832523862e-14, 12, "", -12},
  {3.1937153973747902343750000e+13, 4, "319371539737479023", 14},
  {5.8209751614429723143642748e-05, 1, "", -1},
  {8.8279721094005844842136185e-23, 9, "", -9},
  {1.1318328844296812327795150e-21, 6, "", -6},
  {5.5312161130730082732043229e+03, 9, "5531216113073", 4},
  {1.1472849693175560235977173e+08, 12, "11472849693175560236", 9},
  {4.8984557359342395885579552e-20, 11, "", -11},
  {6.7177325565754043845689836e-03, 3, "7", -2},
  {8.4717304836602911353111267e+07, 18, "84717304836602911353111267", 8},
  {1.0403409530760938662670781e-06, 9, "104", -5},
  {4.7298842443490371865157803e-21, 0, "", 0},
  {1.1628540653871779889973193e-04, 14, "11628540654", -3},
  {9.9949449648407476254341475e-03, 14, "999494496484", -2},
  {9.4764820183609319356731378e-10, 13, "9476", -9},
  {9.6318879007453883644984671e+00, 14, "963188790074539", 1},
  {6.8341601622078600305684737e-06, 14, "683416016", -5},
  {2.7589022641496063360118600e-09, 13, "27589", -8},
  {6.6212022591775732421875000e+12, 4, "66212022591775732", 13},
  {1.0259321030463138000000000e+16, 18, "10259321030463138", 17},
  {2.0896796110635173320770264e+08, 19, "2089679611063517332077026367", 9},
  {1.9952458643733884375000000e+14, 7, "19952458643733884375", 15},
  {8.2403048954338916026268258e-22, 10, "", -10},
  {5.5284104482870300000000000e+14, 11, "552841044828703", 15},
  {1.5941142008063031880737981e+03, 14, "159411420080630319", 4},
  {4.0023240464922804741568406e-10, 18, "400232405", -9},
  {5.5553871810680623089444801e-21, 5, "", -5},
  {1.6100825623385717115088254e-11, 11, "2", -10},
  {1.0436137628995463583501157e-19, 1, "", -1},
  {1.9284439573817578125000000e+13, 18, "19284439573817578125", 14},
  {4.3797108757199100890446019e-08, 1, "", -1},
  {4.6981428618483636633600000e+20, 1, "469814286184836366336", 21},
  {2.0132937188850169889098784e-16, 12, "", -12},
  {7.7809342445181228637695312e+10, 2, "7780934244518", 11},
  {3.6744142636215947277378291e+04, 6, "36744142636", 5},
  {3.2596684924810412500000000e+14, 13, "325966849248104125", 15},
  {9.9358537611361895687878132e+05, 16, "9935853761136189568788", 6},
  {6.2887838536116510850451079e-13, 11, "", -11},
  {2.1585629697038006353583512e-21, 15, "", -15},
  {2.2376594508862894245360517e-09, 13, "22377", -8},
  {1.0463596266105423439774036e-14, 16, "105", -13},
  {8.1084137476312267978073578e-01, 3, "811", 0},
  {3.1303207259899667319613670e-05, 1, "", -1},
  {6.2020093811528488458861830e+02, 14, "62020093811528488", 3},
  {2.8726771164306672289967537e+06, 19, "28726771164306672289967537", 7},
  {5.6914700988096472678400000e+20, 16, "569147009880964726784", 21},
  {3.6583383011757421073238920e-22, 6, "", -6},
  {3.6390555406197486263408791e+03, 12, "3639055540619749", 4},
  {1.8475642616847024048495713e-15, 11, "", -11},
  {6.1510763145829972295538721e-06, 2, "", -2},
  {3.2339085388619987161134528e-15, 19, "32339", -14},
  {7.2146154277897820494753497e-16, 12, "", -12},
  {2.7573894067209706449854742e-18, 7, "", -7},
  {3.7374044547867001953125000e+12, 6, "3737404454786700195", 13},
  {2.4018058278828355669975281e+08, 16, "2401805827882835566997528", 9},
  {2.4905713814017728967886388e-10, 18, "249057138", -9},
  {5.4346803715955081216000000e+19, 0, "54346803715955081216", 20},
  {3.8260507734555721282958984e+09, 19, "38260507734555721282958984375", 10},
  {1.3285433783693560019553919e-11, 12, "13", -10},
  {1.3840318637094407509227130e-08, 3, "", -3},
  {2.1781517269955985830165446e+05, 7, "2178151726996", 6},
  {3.5137969526528945922851562e+10, 13, "351379695265289459228516", 11},
  {3.2870774615580681711435318e+07, 12, "32870774615580681711", 8},
  {5.0738150250176834480536150e-14, 19, "507382", -13},
  {2.6156122264350034528998534e-24, 15, "", -15},
  {7.0996086534444620141925952e+00, 7, "70996087", 1},
  {5.6832009387290999293327332e+06, 10, "56832009387290999", 7},
  {6.1913322042782795362385987e-24, 15, "", -15},
  {6.4062163708919820687294213e-24, 11, "", -11},
  {2.2023390281924488000000000e+16, 12, "22023390281924488", 17},
  {1.2278451746586351562500000e+14, 13, "122784517465863515625", 15},
  {1.0599480761523379825341225e-15, 1, "", -1},
  {1.4479655399029241202857321e-02, 12, "14479655399", -1},
  {1.8128512610686992000000000e+17, 16, "18128512610686992", 18},
  {9.6779584152757584594016927e-09, 8, "1", -7},
  {3.6019357031324988211200000e+20, 6, "360193570313249882112", 21},
  {5.5329096218342041015625000e+12, 18, "55329096218342041015625", 13},
  {3.7302821384673216000000000e+17, 5, "37302821384673216", 18},
  {6.4617711628926928710937500e+11, 13, "646177116289269287109375", 12},
  {2.5368641714133047498762608e+06, 6, "2536864171413", 7},
  {3.7307063908736899371376694e+00, 13, "37307063908737", 1},
  {2.1695008629519194073509425e+04, 4, "216950086", 5},
  {2.2584913380624184012413025e+08, 13, "2258491338062418401241", 9},
  {3.7674210958820453386023720e-22, 10, "", -10},
  {1.2852875221943702669792435e-16, 0, "", 0},
  {2.1024098675936229228973389e+09, 0, "2102409868", 10},
  {3.2373667091566708982081774e-05, 13, "323736671", -4},
  {1.5142592704566179199218750e+12, 4, "15142592704566179", 13},
  {1.2876831818482388507443660e-16, 6, "", -6},
  {1.4064669758166377895332441e-15, 0, "", 0},
  {1.3743510021155728978795644e-13, 3, "", -3},
  {6.3225746070976811461150646e+05, 6, "63225746071", 6},
  {2.2360291649695181250000000e+14, 2, "22360291649695181", 15},
  {9.2236091585062244543682732e-10, 17, "92236092", -9},
  {1.0393610400750548828125000e+13, 18, "10393610400750548828125", 14},
  {1.6390867249976237087685983e-24, 19, "", -19},
  {3.8026352397697452707573448e-06, 5, "", -5},
  {3.8931233063322668737291809e-12, 16, "38931", -11},
  {2.6535327324424472123901876e-09, 17, "265353273", -8},
  {2.6125776131469295169696099e-20, 19, "", -19},
  {4.5623224566847723091803576e-10, 10, "5", -9},
  {3.3019580760637912899255753e+07, 13, "330195807606379128993", 8},
  {1.0888078295550796800000000e+17, 9, "108880782955507968", 18},
  {1.0730884063120095799854936e-12, 16, "10731", -11},
  {6.3163559858463584000000000e+16, 12, "63163559858463584", 17},
  {4.9368416738929847037373087e-11, 11, "5", -10},
  {1.9311292647003587926394454e-13, 10, "", -10},
  {3.1366730704406122640648391e+03, 19, "31366730704406122640648", 4},
  {7.0762811940181975839926636e-16, 16, "7", -15},
  {1.3178249442886448821593559e-03, 8, "131782", -2},
  {3.5287800368760415000000000e+15, 0, "3528780036876042", 16},
  {1.0758675018925866699218750e+12, 3, "1075867501892587", 13},
  {3.3726238015122411520000000e+19, 6, "3372623801512241152", 20},
  {2.5607937088234578125000000e+13, 10, "25607937088234578125", 14},
  {2.0954966378774279356002808e+08, 9, "209549663787742794", 9},
  {9.3098199468015133586791223e-25, 1, "", -1},
  {5.1066996291528150564431598e+00, 7, "51066996", 1},
  {2.1254608536793450000000000e+14, 1, "2125460853679345", 15},
  {3.5171540288806289626564731e-09, 19, "35171540289", -8},
  {1.5486165651188191997450483e-04, 15, "154861656512", -3},
  {3.6364833295084268705021913e-02, 2, "4", -1},
  {1.2420803830343741580577444e+01, 17, "1242080383034374158", 2},
  {2.6741812814789593000897647e-19, 0, "", 0},
  {7.6269227392606639168349149e-20, 11, "", -11},
  {1.7458828595111912582069635e+06, 5, "174588285951", 7},
  {1.0605061344372394547470782e-18, 11, "", -11},
  {1.1998725107770975562004878e+00, 13, "11998725107771", 1},
  {2.3162777740852183970637886e-21, 19, "", -19},
  {1.3995347366911261679309462e-20, 9, "", -9},
  {1.0811374691612471875000000e+14, 10, "10811374691612471875", 15},
  {5.5489385331368184779421426e+03, 7, "55489385331", 4},
  {8.9520667995418770000000000e+15, 19, "8952066799541877", 16},
  {1.1857517011927326677778183e+02, 3, "118575", 3},
  {2.5442683974923718305291220e-15, 9, "", -9},
  {2.7582821164649601319851513e-01, 3, "276", 0},
  {7.2498044193293386335385406e-12, 17, "72498", -11},
  {1.0019664938585176562500000e+14, 11, "100196649385851765625", 15},
  {1.0755540341664763733041427e-11, 14, "1076", -10},
  {3.3050096843867600502785245e-12, 10, "", -10},
  {1.8887602656111335907613792e-10, 17, "18887603", -9},
  {1.3919965559251779785156250e+12, 17, "1391996555925177978515625", 13},
  {7.3080116060689824888409183e-05, 4, "1", -3},
  {1.0713244348338534400000000e+19, 20, "107132443483385344", 20},
  {1.1111565004166510742538050e-06, 11, "111116", -5},
  {6.8849657518677551269531250e+11, 6, "688496575186775513", 12},
  {1.2594293432015229797363281e+11, 19, "1259429343201522979736328125", 12},
  {5.1520765269856643676757812e+08, 12, "515207652698566436768", 9},
  {7.2592481875482621874196507e-13, 15, "726", -12},
  {8.3843023646121195520000000e+18, 6, "8384302364612119552", 19},
  {2.5277874441495979309082031e+10, 20, "2527787444149597930908203125", 11},
  {4.0371485739027521146007473e-17, 15, "", -15},
  {5.8247403279078087456337654e-16, 2, "", -2},
  {6.1476740804186314967583193e-03, 18, "6147674080418631", -2},
  {4.6548311978082498535513878e+06, 18, "4654831197808249853551388", 7},
  {8.4859418941061587793768657e-13, 17, "84859", -12},
  {1.1045792582990229667565666e-16, 10, "", -10},
  {5.1141033395040651036989043e-04, 20, "51141033395040651", -3},
  {6.3786292307601621942581005e+00, 2, "638", 1},
  {1.8121519677877856884151697e+06, 11, "181215196778778569", 7},
  {1.2574353750188328550400000e+20, 8, "125743537501883285504", 21},
  {6.9928089975844593048095703e+09, 20, "69928089975844593048095703125", 10},
  {1.1418686189763155561186722e-12, 11, "", -11},
  {1.9595278795290460000000000e+16, 8, "1959527879529046", 17},
  {1.7075212309630870733019592e-04, 18, "170752123096309", -3},
  {3.3167502523206255000000000e+15, 20, "33167502523206255", 16},
  {3.0379781134689220428466797e+10, 3, "30379781134689", 11},
  {1.6833521431340039165179535e-09, 6, "", -6},
  {4.4590004912764260000000000e+15, 10, "4459000491276426", 16},
  {2.4051667492436962890625000e+12, 9, "2405166749243696289063", 13},
  {4.3438752975905633386223240e-09, 20, "434387529759", -8},
  {5.4160930004407044066438617e-21, 8, "", -8},
  {2.8890647004872651758477765e-15, 13, "", -13},
  {2.1614581242724824218750000e+13, 16, "2161458124272482421875", 14},
  {1.7602919428576265913760635e-03, 15, "1760291942858", -2},
  {3.0087370369103737175464630e+06, 19, "3008737036910373717546463", 7},
  {2.3536597943072568685869759e-13, 17, "23537", -12},
  {2.7646408400089149426394214e-24, 0, "", 0},
  {3.9515359129029485506833912e-18, 6, "", -6},
  {4.7125876414886000640000000e+18, 10, "4712587641488600064", 19},
  {3.9603753686876769550711578e-11, 5, "", -5},
  {4.0772438745034387913282198e-21, 20, "", -20},
  {6.5564911240561779427534777e-11, 12, "66", -10},
  {5.5335173217487907543210568e-03, 10, "55335173", -2},
  {1.6220098612301042303442955e+07, 3, "16220098612", 8},
  {3.3243090760291609775992739e-18, 15, "", -15},
  {5.7490834683337447407571130e-14, 10, "", -10},
  {4.7187972014782667429244611e+02, 0, "472", 3},
  {1.4908280340064610669514877e+01, 10, "149082803401", 2},
  {1.0991161607093725440000000e+18, 17, "1099116160709372544", 19},
  {2.7002603921007826500658661e-14, 8, "", -8},
  {5.1678142273294205610366600e-12, 7, "", -7},
  {2.4934867572446441045030951e+05, 3, "249348676", 6},
  {6.5300031766245160797678919e-16, 11, "", -11},
  {3.0708976207752276639275777e-22, 0, "", 0},
  {2.7239252134617378234863281e+10, 4, "272392521346174", 11},
  {1.8668674456670339843750000e+13, 11, "1866867445667033984375", 14},
  {1.6528296381693936175351369e-13, 18, "165283", -12},
  {2.5536101415325489933631288e-25, 20, "", -20},
  {3.6857913751945621504000000e+19, 13, "36857913751945621504", 20},
  {8.0144003634091708944409138e-04, 0, "", 0},
  {7.3011074517306485052177581e-16, 11, "", -11},
  {1.6901410265945379651775227e-01, 8, "1690141", 0},
  {1.6311189107647326720000000e+18, 9, "1631118910764732672", 19},
  {1.0994107844775469949366714e-15, 0, "", 0},
  {1.5897687030426013795807749e-12, 6, "", -6},
  {3.7970254267782686657981479e-25, 12, "", -12},
  {8.7747390257055437500000000e+13, 3, "87747390257055438", 14},
  {7.5651420975488750264048576e+06, 14, "75651420975488750264", 7},
  {5.0856357180450332625096581e-10, 8, "", -8},
  {2.5517609782011654963200000e+20, 18, "255176097820116549632", 21},
  {3.9037979287763440771456532e-20, 5, "", -5},
  {7.0285017059032559201547929e-04, 2, "", -2},
  {1.4519938342386639317133652e-13, 9, "", -9},
  {1.2289887487921949504534146e-24, 0, "", 0},
  {1.9709980671490354003906250e+12, 3, "1970998067149035", 13},
  {2.4755536540788121474138227e-20, 3, "", -3},
  {8.9618262786173623095462839e-17, 18, "9", -16},
  {1.0218949941338265049653585e-07, 6, "", -6},
  {8.2458973747637663036584854e+06, 15, "8245897374763766303658", 7},
  {3.6042828233241487300591556e-24, 14, "", -14},
  {1.0101993536962226033210754e+08, 16, "1010199353696222603321075", 9},
  {7.2879800652328456635586917e+04, 12, "72879800652328457", 5},
  {1.9082872630856186901837646e+01, 6, "19082873", 2},
  {9.1332584741845337500000000e+14, 16, "913325847418453375", 15},
  {6.4841162213237907858914014e-18, 5, "", -5},
  {1.2353288768874725002113182e-11, 19, "123532888", -10},
  {1.2326551051418933248000000e+19, 5, "12326551051418933248", 20},
  {2.9526781528672984000000000e+16, 18, "29526781528672984", 17},
  {1.3421655211319321665541793e+02, 3, "134217", 3},
  {5.7062580133503135529360328e-03, 19, "57062580133503136", -2},
  {1.9922385790164198748897206e-01, 8, "19922386", 0},
  {5.8296986899253645075621899e-21, 2, "", -2},
  {1.4156445087204838628736070e+01, 12, "14156445087205", 2},
  {1.9857636421438640831673168e-24, 16, "", -16},
  {1.6142083632101116438343368e-13, 19, "1614208", -12},
  {3.7117620316329263150691986e+06, 0, "3711762", 7},
  {5.5956274531926310912000000e+19, 20, "55956274531926310912", 20},
  {3.3019051773615051281751676e+00, 12, "3301905177362", 1},
  {2.3974921483744280963860268e-05, 1, "", -1},
  {3.6228499520012570624000000e+19, 20, "36228499520012570624", 20},
  {1.6125558113412521436813210e-21, 13, "", -13},
  {6.6836602771073182793770684e+02, 16, "6683660277107318279", 3},
  {1.4493531629008475857415172e-16, 1, "", -1},
  {6.3749294739552846422725452e+00, 14, "637492947395528", 1},
  {5.9108233676405540245253926e-07, 14, "59108234", -6},
  {4.9261451821080497741699219e+10, 9, "49261451821080497742", 11},
  {3.1210413344458334960937500e+12, 8, "312104133444583349609", 13},
  {1.6788644443358992669928853e-19, 3, "", -3},
  {6.4913244463667706440901384e+03, 10, "64913244463668", 4},
  {6.2111880454509500000000000e+13, 17, "621118804545095", 14},
  {1.3252526132214672760298135e-21, 0, "", 0},
  {1.1100226710051176960000000e+18, 20, "1110022671005117696", 19},
  {1.8406191303487967161345296e+03, 8, "184061913035", 4},
  {3.0868396772973979823291302e+06, 8, "30868396772974", 7},
  {5.3012948978159698046330739e-03, 5, "53", -2},
  {1.0002470299206788218554454e-10, 13, "1", -9},
  {3.2685151384856835938990116e+06, 13, "32685151384856835939", 7},
  {1.7085437370485278715305888e-15, 10, "", -10},
  {4.1187768850366912374738604e+04, 6, "4118776885", 5},
  {4.6405396861990429897559807e+03, 4, "46405397", 4},
  {1.0673667612099758090688181e-10, 9, "", -9},
  {1.5784385258028511718750000e+13, 16, "1578438525802851171875", 14},
  {4.7245141308387506250000000e+14, 0, "472451413083875", 15},
  {3.7151877568156216000000000e+16, 4, "37151877568156216", 17},
  {9.0343777160615599155426025e+08, 14, "90343777160615599155426", 9},
  {1.8402656757664208412170410e+09, 13, "1840265675766420841217", 10},
  {3.3211763056855862297558901e-04, 17, "33211763056856", -3},
  {1.8474726394967591426266198e-15, 16, "18", -14},
  {8.6095336947798960943296871e-10, 8, "", -8},
  {6.0867239837537348093490872e-11, 12, "61", -10},
  {1.0023737709048580689805458e-24, 20, "", -20},
  {6.7366753848417554307472370e-12, 12, "7", -11},
  {2.2668501068117832499200000e+20, 17, "226685010681178324992", 21},
  {9.2212494061418183264322579e+03, 18, "9221249406141818326432", 4},
  {9.7061668745065843916800000e+20, 15, "970616687450658439168", 21},
  {8.3944789541339958960147402e-06, 11, "839448", -5},
  {3.4291916584262291200000000e+17, 5, "342919165842622912", 18},
  {6.6901251043050776769454541e-06, 4, "", -4},
  {8.1707120247900917826633312e-09, 0, "", 0},
  {3.6895988342559618750000000e+14, 17, "3689598834255961875", 15},
  {2.9264973444098634729415692e-21, 4, "", -4},
  {8.8788217777675362652486583e-18, 17, "1", -16},
  {4.0834150183215586413232323e-03, 15, "4083415018322", -2},
  {1.8906510027482252000000000e+16, 1, "18906510027482252", 17},
  {4.0596497123004544000000000e+18, 1, "40596497123004544", 19},
  {3.7710695736852431766823586e-25, 14, "", -14},
  {3.4617015987457637749002970e+00, 14, "346170159874576", 1},
  {3.8236500417026800000000000e+14, 9, "382365004170268", 15},
  {1.8611098987917417968750000e+13, 13, "1861109898791741796875", 14},
  {3.6248182429923958323117697e-11, 20, "3624818243", -10},
  {1.3393689462619308471679688e+11, 6, "133936894626193085", 12},
  {8.5579155096988130147437402e-23, 6, "", -6},
  {4.9723544598874370177321948e-11, 9, "", -9},
  {1.1862559087627356710359372e-02, 18, "11862559087627357", -1},
  {9.0184606190207118015163764e-10, 11, "9", -9},
  {3.9166307145638250553076887e+00, 8, "391663071", 1},
  {9.0666268740716819405415774e-13, 0, "", 0},
  {4.4884040420429542902509201e-15, 17, "449", -14},
  {1.0541352250386428357274724e-23, 7, "", -7},
  {1.6844078828214140034187109e-22, 19, "", -19},
  {2.7613103698985325172543526e+06, 11, "276131036989853252", 7},
  {7.4716586415308375000000000e+13, 20, "74716586415308375", 14},
  {1.8086109779381565199786183e-10, 1, "", -1},
  {2.9474849792358729826692576e-08, 0, "", 0},
  {2.5375598169882237447002305e-08, 11, "2538", -7},
  {2.8549732198557959961249253e+00, 1, "29", 1},
  {9.1714299621440195426018329e-10, 7, "", -7},
  {1.4453497210356772484374233e+01, 5, "144535", 2},
  {2.0073806945444487346141047e-23, 2, "", -2},
  {1.1103939522346225788525113e-14, 18, "11104", -13},
  {7.2429222900409130552039686e-21, 9, "", -9},
  {4.3650668869479782710620620e-10, 9, "", -9},
  {2.5099858052296088969387351e-18, 4, "", -4},
  {5.5929150014894351271463393e-11, 14, "5593", -10},
  {5.9258157427033735231702849e+00, 3, "5926", 1},
  {5.5904403447809168000000000e+16, 14, "55904403447809168", 17},
  {8.3421947235193101732875220e+02, 12, "834219472351931", 3},
  {1.2094540678213097576750166e-08, 15, "12094541", -7},
  {2.4388489369204455350188462e-05, 1, "", -1},
  {1.5984362720736183109693229e+05, 0, "159844", 6},
  {2.2877160566520640000000000e+16, 7, "2287716056652064", 17},
  {1.1325984678876765960099041e-13, 8, "", -8},
  {1.1963000608524398592000000e+19, 15, "11963000608524398592", 20},
  {7.4255980390433229398894355e-01, 7, "7425598", 0},
  {3.6153674089343906350304393e-18, 15, "", -15},
  {1.9360450314766665542265400e+04, 15, "19360450314766665542", 5},
  {1.2766965273456169292330742e+07, 3, "12766965273", 8},
  {1.6407096335556155000000000e+15, 1, "16407096335556155", 16},
  {1.7361639939470710491953298e-01, 12, "173616399395", 0},
  {4.3961693597694245783102929e-01, 15, "439616935976942", 0},
  {4.7318177774159086990124479e-02, 17, "4731817777415909", -1},
  {1.1848669442535916097120161e-23, 6, "", -6},
  {4.4901927144628538578164091e-11, 17, "4490193", -10},
  {6.0909720409301360694032113e-04, 11, "6090972", -3},
  {1.4969972171393148448360013e-08, 1, "", -1},
  {3.3182908478330245018005371e+09, 19, "33182908478330245018005371094", 10},
  {3.1734238940782900848855154e-09, 9, "3", -8},
  {5.6496936399553216512000000e+19, 16, "56496936399553216512", 20},
  {3.1451846727957612124012181e-24, 17, "", -17},
  {3.8209354465781500236054580e-03, 13, "38209354466", -2},
  {1.8983589112823771365854525e-25, 0, "", 0},
  {1.6048772113192394076637933e-21, 10, "", -10},
  {2.2139464736712464849291081e-10, 4, "", -4},
  {9.3494421711367863281338941e+00, 13, "93494421711368", 1},
  {1.5130302955506492413604311e-13, 15, "151", -12},
  {3.0887059709661553175141790e-02, 16, "308870597096616", -1},
  {1.9059645911678256225585938e+11, 2, "19059645911678", 12},
  {9.5159081711885992862639267e-17, 13, "", -13},
  {1.6865748211031368000000000e+16, 3, "16865748211031368", 17},
  {3.4318761173323413107700262e-08, 9, "34", -7},
  {3.8773229518383635623984241e-11, 0, "", 0},
  {6.4105248104150195323847228e-15, 9, "", -9},
  {8.0977019956951410202085368e-19, 10, "", -10},
  {3.6952123401035087585449219e+10, 20, "3695212340103508758544921875", 11},
  {9.2756734560136666354712760e-13, 17, "92757", -12},
  {1.2932760463415865160641260e+04, 13, "129327604634158652", 5},
  {8.7668468225056396484375000e+10, 9, "87668468225056396484", 11},
  {9.4650315628480241603170953e-01, 6, "946503", 0},
  {1.1468381696667340831325183e-10, 9, "", -9},
  {2.9085881654530050582252443e+04, 14, "2908588165453005058", 5},
  {1.3745294587295036800000000e+17, 17, "137452945872950368", 18},
  {1.6247233088001759824692272e+04, 6, "16247233088", 5},
  {8.4301934133304199165831056e-19, 14, "", -14},
  {5.1124074405979189350546221e+02, 1, "5112", 3},
  {2.7692306110630796875000000e+14, 17, "27692306110630796875", 15},
  {2.3013463988943880762914802e-11, 9, "", -9},
  {1.3613253747344265276899539e-12, 0, "", 0},
  {3.0795627280228687358423418e-16, 12, "", -12},
  {1.5927695704202792087701918e-25, 10, "", -10},
  {2.0922149636177346560000000e+18, 4, "2092214963617734656", 19},
  {1.7836984774986569972609928e-23, 17, "", -17},
  {1.0389015268945060859604456e-20, 9, "", -9},
  {2.7346483173483580350875854e+07, 14, "2734648317348358035088", 8},
  {2.7179765987348860800000000e+17, 0, "271797659873488608", 18},
  {5.0729498272216547386169802e-24, 2, "", -2},
  {2.3580307439318185000000000e+15, 3, "23580307439318185", 16},
  {3.7511604165149605250917375e+04, 9, "3751160416515", 5},
  {1.0166849436735596000483178e-06, 17, "101668494367", -5},
  {1.3519120707693706493036314e-12, 5, "", -5},
  {2.3661859864381034496000000e+19, 20, "23661859864381034496", 20},
  {4.0534948194605430165289801e-21, 1, "", -1},
  {1.1077034065457284577674268e-22, 11, "", -11},
  {4.8928911930282559478655457e+05, 7, "4892891193028", 6},
  {4.1632820345634931250000000e+14, 4, "4163282034563493125", 15},
  {9.9344279383368080269289212e-13, 10, "", -10},
  {9.4583043505220325871117896e-07, 3, "", -3},
  {5.9548266712876812500000000e+13, 5, "595482667128768125", 14},
  {2.2024580830256130901444673e-11, 2, "", -2},
  {3.0962204735789929726166086e-10, 2, "", -2},
  {7.8004393462152772934450174e-10, 8, "", -8},
  {1.7697113211929275512695312e+11, 4, "1769711321192928", 12},
  {1.5056745769143293294285040e-07, 16, "1505674577", -6},
  {7.7875469931003198620799771e-22, 5, "", -5},
  {1.2857702119176041015625000e+13, 2, "1285770211917604", 14},
  {1.2988133313069871104386864e-12, 0, "", 0},
  {2.0262165701112122500000000e+15, 11, "202621657011121225", 16},
  {2.2623853343968100310729923e-11, 14, "2262", -10},
  {2.3781108884334375538812062e-15, 8, "", -8},
  {4.2888949979820900880178998e-08, 8, "4", -7},
  {2.0531265913316492778557525e-11, 7, "", -7},
  {5.6278858436970086768269539e+05, 18, "562788584369700867682695", 6},
  {4.9027472546289055741277921e-14, 1, "", -1},
  {1.1551631984003850000000000e+16, 0, "1155163198400385", 17},
  {3.6755011551471689017489552e+04, 13, "36755011551471689", 5},
  {5.6468936367137180394797165e-11, 11, "6", -10},
  {1.4190289949964208334498870e-24, 13, "", -13},
  {9.9901284748448224000000000e+16, 4, "99901284748448224", 17},
  {5.7421297975238398066721857e+04, 1, "574213", 5},
  {1.8117735023286052246093750e+12, 12, "1811773502328605224609375", 13},
  {1.0444259859163618244295551e-20, 7, "", -7},
  {1.1876053292610263498384025e-16, 14, "", -14},
  {2.9973783536106732800000000e+17, 19, "299737835361067328", 18},
  {2.2823360595027383533306420e+05, 20, "2282336059502738353330642", 6},
  {1.5011808129555785431102340e-11, 19, "150118081", -10},
  {3.1335157119373585627490894e-12, 3, "", -3},
  {2.8479432629044060058461767e-18, 8, "", -8},
  {6.8550435199888370974008467e+00, 16, "68550435199888371", 1},
  {1.5338726600080451051288932e-03, 1, "", -1},
  {2.6983742061205832007636471e-17, 4, "", -4},
  {8.5188629256406205603409860e-10, 14, "85189", -9},
  {7.5786320189612842797462211e-05, 9, "75786", -4},
  {5.7664952395713340444926593e-18, 20, "577", -17},
  {6.2914240566946136616175740e-22, 9, "", -9},
  {1.1862838735450281250000000e+14, 18, "1186283873545028125", 15},
  {8.9599668213721376000000000e+16, 14, "89599668213721376", 17},
  {4.4713187380476746514492124e-14, 16, "447", -13},
  {1.2620129204270280456542969e+11, 0, "126201292043", 12},
  {7.0036051660539242220693268e+03, 0, "7004", 4},
  {5.2700655302767717585478435e-05, 2, "", -2},
  {8.3025684252289488911628723e+07, 5, "8302568425229", 8},
  {6.1246615743074057223528440e-24, 13, "", -13},
  {2.0699270225822471680000000e+18, 10, "2069927022582247168", 19},
  {1.1653358976170320000000000e+16, 1, "1165335897617032", 17},
  {4.1635432983958588312122470e-13, 4, "", -4},
  {9.0038509713720293348160340e+02, 6, "900385097", 3},
  {6.2234962276506412375694785e-25, 15, "", -15},
  {1.7642533059359362020868867e-21, 10, "", -10},
  {4.2853870753610471833600000e+20, 6, "428538707536104718336", 21},
  {3.7191947434386618597074853e-13, 15, "372", -12},
  {2.5611058027842934335795123e-23, 14, "", -14},
  {7.4408571500422120000000000e+15, 1, "7440857150042212", 16},
  {4.7058971698326806720206237e-21, 16, "", -16},
  {8.1468076907559707251493819e+03, 3, "8146808", 4},
  {3.2597161694567374713472015e-15, 8, "", -8},
  {6.4518012923785811677640354e-10, 16, "6451801", -9},
  {1.8762446845458869356662035e+06, 3, "1876244685", 7},
  {2.9362911887537028126462459e-22, 5, "", -5},
  {7.7229145415689312008855504e-25, 3, "", -3},
  {2.2820947046010084024102952e-06, 8, "228", -5},
  {6.2043565999484136700630188e+06, 6, "6204356599948", 7},
  {4.9837003509374739787656241e-14, 5, "", -5},
  {5.2435618483887472000000000e+16, 19, "52435618483887472", 17},
  {3.7813088672293830000000000e+15, 14, "3781308867229383", 16},
  {4.0146770665741257171333309e-19, 6, "", -6},
  {5.1671096647586716907839255e-05, 14, "5167109665", -4},
  {5.7555818198267705547545198e-21, 10, "", -10},
  {2.4189988813980871012492875e-08, 10, "242", -7},
  {2.3612996445319793565431610e+04, 12, "23612996445319794", 5},
  {4.2639364438141894656000000e+20, 4, "42639364438141894656", 21},
  {3.8304805529762160088417457e-23, 6, "", -6},
  {2.1176570428403045041254248e-23, 14, "", -14},
  {3.5767015680405671409328260e-17, 8, "", -8},
  {4.6722119164843038720000000e+18, 8, "4672211916484303872", 19},
  {1.6126577309317615864448623e-24, 9, "", -9},
  {1.5302027919537112116813660e+07, 6, "15302027919537", 8},
  {8.8606717980414664061802827e-12, 0, "", 0},
  {1.1745583017380422808708823e-10, 3, "", -3},
  {2.5676131118599740957345455e-22, 4, "", -4},
  {2.9322624669696704864501953e+10, 20, "29322624669696704864501953125", 11},
  {2.3314270115921737270396676e-17, 5, "", -5},
  {1.6065478097032301951593261e-23, 7, "", -7},
  {1.1596082246999772894007147e-07, 10, "116", -6},
  {5.3861689484736891100195296e-14, 7, "", -7},
  {4.3594463162472333456459034e-05, 16, "435944631625", -4},
  {1.6320197284521879405449302e-13, 0, "", 0},
  {7.3884516401099716186523438e+10, 10, "738845164010997161865", 11},
  {3.7302017669353344726562500e+12, 13, "373020176693533447265625", 13},
  {3.7307600695597442630457863e-01, 4, "3731", 0},
  {7.6882852004231980709046113e-23, 14, "", -14},
  {2.6270153988101187230195320e-17, 9, "", -9},
  {2.6138246772824269197573198e-12, 18, "2613825", -11},
  {1.1272327683676309259108023e-04, 5, "11", -3},
  {4.9313761518869156526799491e-05, 13, "493137615", -4},
  {1.6896228048567634687060490e+04, 8, "1689622804857", 5},
  {2.8491523226368133836055915e-09, 2, "", -2},
  {4.5012247227265327059259737e-24, 18, "", -18},
  {4.7566018843354040552696777e-18, 16, "", -16},
  {2.1526753519678945119871297e-05, 8, "2153", -4},
  {2.0532605945127073209732771e+05, 13, "2053260594512707321", 6},
  {7.9411318402712177485227585e+06, 18, "7941131840271217748522758", 7},
  {8.5922094327161291336991992e-08, 16, "859220943", -7},
  {5.4830124131519412597479679e-04, 10, "5483012", -3},
  {1.4172357570026389381873111e-04, 6, "142", -3},
  {5.1526838937225054931640625e+11, 2, "51526838937225", 12},
  {3.0264589035761501305816443e-20, 4, "", -4},
  {8.4681657518834070000000000e+15, 16, "8468165751883407", 16},
  {4.2844134925058998954117596e-21, 0, "", 0},
  {4.1691671104552325000000000e+15, 14, "41691671104552325", 16},
  {1.3393163625172166245508613e-07, 14, "13393164", -6},
  {3.0621523522986240000000000e+17, 19, "3062152352298624", 18},
  {3.1834905271474170262990810e+01, 15, "3183490527147417", 2},
  {3.3644127653343738056719303e+06, 8, "336441276533437", 7},
  {5.3158469248193604528296419e+01, 9, "53158469248", 2},
  {2.6937669123414634835692782e-14, 7, "", -7},
  {8.8814256537054260000000000e+15, 19, "8881425653705426", 16},
  {2.5879377337715283059153600e-14, 13, "", -13},
  {1.4883380706477847231021688e-14, 18, "14883", -13},
  {2.2059427252746415138244629e+08, 16, "2205942725274641513824463", 9},
  {3.8103683539664210012830825e-24, 14, "", -14},
  {6.3469131266783070564270020e+08, 14, "6346913126678307056427", 9},
  {4.6089760951626226621186122e-04, 14, "46089760952", -3},
  {2.0384084584324654142685113e-21, 11, "", -11},
  {1.2756284600185991439502686e+05, 11, "12756284600185991", 6},
  {8.5349098790144333750043082e-16, 17, "85", -15},
  {4.8272876601105195312500000e+13, 17, "482728766011051953125", 14},
  {6.1784085563088910930673592e+03, 1, "61784", 4},
  {2.2181176907457123200000000e+17, 7, "221811769074571232", 18},
  {4.2795267193182927363114381e-14, 0, "", 0},
  {2.7295119920323483550438764e-15, 14, "", -14},
  {1.5477591618698537198633601e-06, 8, "155", -5},
  {6.1697916083320112000000000e+16, 5, "61697916083320112", 17},
  {7.5189214961770519491150126e-17, 2, "", -2},
  {1.7776845150151278643376244e-25, 2, "", -2},
  {8.7797892646411484375000000e+12, 20, "87797892646411484375", 13},
  {5.5881995869615437667932850e-19, 11, "", -11},
  {1.2201572592465456542968750e+12, 14, "1220157259246545654296875", 13},
  {1.2275989447567418194617872e-02, 5, "1228", -1},
  {8.6544060418093841552734375e+10, 2, "8654406041809", 11},
  {3.5992985502553131103515625e+10, 18, "35992985502553131103515625", 11},
  {4.5054557350372349520470095e-08, 7, "", -7},
  {3.7543558856723259407872203e-25, 12, "", -12},
  {2.9188831898046232674856170e-17, 14, "", -14},
  {7.5929146925581803007077042e-01, 15, "759291469255818", 0},
  {1.9214680484515866965011810e+00, 0, "2", 1},
  {3.1899415146460151672363281e+10, 10, "318994151464601516724", 11},
  {4.6229899116950007045528894e-21, 14, "", -14},
  {1.2846852850390671875000000e+13, 0, "12846852850391", 14},
  {9.8318432579991936683654785e+08, 10, "9831843257999193668", 9},
  {8.3243240373382420216330502e+01, 19, "832432403733824202163", 2},
  {1.4617952498148690101015540e-22, 17, "", -17},
  {1.2185284821699769963743165e+03, 9, "121852848217", 4},
  {5.4607768018633539584000000e+19, 13, "54607768018633539584", 20},
  {1.0086454779118355998482749e-07, 17, "10086454779", -6},
  {4.3990210827154978268094254e-02, 10, "439902108", -1},
  {2.9227134018981301862977041e-16, 0, "", 0},
  {3.7075049874464457367099425e-22, 9, "", -9},
  {6.8101439512780418527861060e-07, 0, "", 0},
  {5.2900705826500093750000000e+14, 5, "5290070582650009375", 15},
  {2.9213660393890356445312500e+11, 4, "2921366039389036", 12},
  {8.0960619651855433786280546e-08, 10, "81", -7},
  {2.3853821063860116730064068e-17, 4, "", -4},
  {1.2877504844477369021537981e-16, 19, "1288", -15},
  {3.1835424277857477770823422e-12, 13, "32", -11},
  {1.1554222247419628906250000e+13, 14, "1155422224741962890625", 14},
  {1.5328565248636435476609519e-07, 8, "15", -6},
  {5.7051256221783541437007388e-09, 9, "6", -8},
  {1.4086857850144975574685925e-06, 5, "", -5},
  {4.8343962342485623843875722e-22, 5, "", -5},
  {1.4131720903748165544990106e-24, 2, "", -2},
  {2.5897092577987820316316756e-18, 12, "", -12},
  {4.7734036197128746902109571e-13, 3, "", -3},
  {2.6975326486610327199989303e-09, 7, "", -7},
  {2.0313239229168217006181105e-05, 10, "203132", -4},
  {6.7402815504599608551001770e-18, 3, "", -3},
  {2.0624459201929494528000000e+20, 5, "20624459201929494528", 21},
  {5.9703605212903015136718750e+11, 11, "59703605212903015136719", 12},
  {1.4393761777722238619540377e-06, 17, "143937617777", -5},
  {2.4145337504019652343750000e+13, 2, "2414533750401965", 14},
  {5.1234733616965170019843811e-11, 18, "51234734", -10},
  {1.8670799065612291451273798e-08, 20, "1867079906561", -7},
  {1.4821777215665145777165890e+06, 10, "14821777215665146", 7},
  {4.1801104822676599724218249e+04, 2, "418011", 5},
  {9.5205402157969840000000000e+16, 1, "9520540215796984", 17},
  {6.5442520532171755576200667e+01, 11, "6544252053217", 2},
  {2.4244173203441549682617188e+11, 3, "242441732034415", 12},
  {8.5947835487121364521391478e-23, 1, "", -1},
  {3.3857073165152558049581754e-11, 6, "", -6},
  {1.2345569445573188309774014e-24, 1, "", -1},
  {9.5768836602143198251724243e+07, 12, "95768836602143198252", 8},
  {1.5977398208834606409072876e+08, 10, "1597739820883460641", 9},
  {1.2388463966596067200000000e+17, 0, "123884639665960672", 18},
  {1.1453060583017155761718750e+12, 5, "114530605830171558", 13},
  {7.8970823555786752000000000e+18, 19, "78970823555786752", 19},
  {1.3352802502993071077810887e-20, 1, "", -1},
  {9.2730252922950253906250000e+12, 14, "9273025292295025390625", 13},
  {2.5049745614186907927134484e-02, 15, "25049745614187", -1},
  {1.0323757305580692513445346e-06, 1, "", -1},
  {7.4900380389608470198179414e-15, 16, "75", -14},
  {3.6579896696784763336181641e+09, 19, "36579896696784763336181640625", 10},
  {2.6449673534564442566413617e-23, 16, "", -16},
  {3.2926525542719055038840860e-06, 7, "33", -5},
  {6.2510536571003076608000000e+19, 14, "62510536571003076608", 20},
  {2.0688860486206250878792497e-21, 3, "", -3},
  {5.3355970359078438400000000e+17, 11, "533559703590784384", 18},
  {2.3386545155536668750000000e+14, 18, "2338654515553666875", 15},
  {3.3797496321766656000000000e+16, 20, "33797496321766656", 17},
  {1.1381665890394864603877068e+07, 20, "1138166589039486460387706757", 8},
  {1.4474838758640916907881479e-08, 0, "", 0},
  {3.6638462398819124698638916e+08, 0, "366384624", 9},
  {6.6726078987207092285156250e+11, 15, "6672607898720709228515625", 12},
  {6.3395943559796007073265284e-16, 20, "63396", -15},
  {7.3990565569185942629282238e-02, 18, "73990565569185943", -1},
  {4.2888985841774032097138394e-23, 8, "", -8},
  {5.4939397044142128379018430e-02, 14, "5493939704414", -1},
  {6.8810715911624600257302955e-15, 18, "6881", -14},
  {9.2130296802787465113652870e-23, 1, "", -1},
  {1.9869807681550384452495717e-03, 11, "198698077", -2},
  {1.0922068473298561314101739e-07, 20, "10922068473299", -6},
  {1.3625920509424172343908118e-21, 16, "", -16},
  {9.2327964763746746368000000e+19, 6, "92327964763746746368", 20},
  {4.6671896665321778397902963e-04, 18, "466718966653218", -3},
  {5.7587558932410695312500000e+13, 18, "575875589324106953125", 14},
  {3.4396396637535186889646193e-13, 8, "", -8},
  {1.6618646101510418933155933e-02, 18, "16618646101510419", -1},
  {1.0152428635809653297770830e-13, 10, "", -10},
  {3.5847455846495910461821849e-17, 10, "", -10},
  {1.1423094580757342519916619e+00, 17, "114230945807573425", 1},
  {2.0847004755709212161947572e-24, 15, "", -15},
  {6.4568463497647884651087224e+04, 7, "645684634976", 5},
  {4.7356769434149937952324238e-12, 12, "5", -11},
  {1.6040955800164672851562500e+10, 18, "160409558001646728515625", 11},
  {2.5809301660036560953744500e-07, 19, "2580930166004", -6},
  {6.6210959980919178633484989e+03, 8, "662109599809", 4},
  {1.6655342126841083687687063e-24, 3, "", -3},
  {3.3567137756972432136535645e+09, 14, "335671377569724321365356", 10},
  {7.7516900566244067158550024e+05, 10, "7751690056624407", 6},
  {2.5340151340681809186935425e+08, 3, "253401513407", 9},
  {7.6649706869093063354492188e+10, 0, "76649706869", 11},
  {1.0574588390371523797512054e+07, 17, "1057458839037152379751205", 8},
  {5.5303305185469600000000000e+17, 6, "553033051854696", 18},
  {1.8098545604146177301383306e-16, 3, "", -3},
  {2.2385464740438784930219813e-13, 12, "", -12},
  {1.2074237273280176000000000e+16, 3, "12074237273280176", 17},
  {2.0332737012537847517107334e-23, 19, "", -19},
  {3.6318844477527995051602261e-01, 1, "4", 0},
  {3.1765042476937053205489984e-10, 6, "", -6},
  {1.9429532570615683104370622e-05, 10, "194295", -4},
  {3.2453237884298898624775887e-12, 14, "325", -11},
  {3.4214365087803710937500000e+13, 19, "342143650878037109375", 14},
  {1.2569777356410278609943600e-18, 18, "1", -17},
  {3.6012694735673896840496642e-16, 5, "", -5},
  {1.1167943403973187590967215e-09, 18, "111679434", -8},
  {1.4083236663245229480434998e-10, 19, "1408323666", -9},
  {1.3759388358966452500000000e+15, 2, "137593883589664525", 16},
  {2.7416410866811028480000000e+18, 14, "2741641086681102848", 19},
  {1.4335748831691273959616347e-08, 11, "1434", -7},
  {4.2853925000337730407714844e+10, 16, "428539250003377304077148438", 11},
  {2.5296060167741587930075071e-22, 11, "", -11},
  {2.8838559590765640988641039e-02, 5, "2884", -1},
  {8.4829626903526014976000000e+19, 0, "84829626903526014976", 20},
  {6.8775893394638845596543332e-18, 9, "", -9},
  {4.8356651044828955046529310e-21, 19, "", -19},
  {5.8816280779331318359375000e+12, 9, "5881628077933131835938", 13},
  {1.6812373939739435659948016e-16, 13, "", -13},
  {1.0775962652074699125312933e-18, 5, "", -5},
  {7.2368191746866455092762953e-11, 5, "", -5},
  {3.5694644464910251468059040e-17, 10, "", -10},
  {1.0573997773139094670415485e-10, 7, "", -7},
  {6.4987860687523254200120633e-17, 10, "", -10},
  {1.4133104312510192874553099e-21, 9, "", -9},
  {2.8084829603349396875000000e+14, 3, "280848296033493969", 15},
  {6.9859064951340101562500000e+13, 18, "698590649513401015625", 14},
  {6.3339518312102728994019731e-20, 3, "", -3},
  {1.0915520671578118750000000e+14, 2, "10915520671578119", 15},
  {6.4495872939608163889943974e-13, 17, "64496", -12},
  {1.6763754472388359834100768e-02, 16, "167637544723884", -1},
  {1.5437129273268739780178294e+04, 15, "1543712927326873978", 5},
  {3.7691189067197873704531743e-22, 0, "", 0},
  {4.4471105878391910000000000e+15, 15, "4447110587839191", 16},
  {9.7374583815110184140800000e+20, 1, "973745838151101841408", 21},
  {8.8746408936277113112628828e-14, 10, "", -10},
  {9.8577652498335437849164009e+05, 5, "98577652498", 6},
  {4.9470302781660669213724453e-20, 12, "", -12},
  {1.9803101072091922746354342e-02, 18, "19803101072091923", -1},
  {1.4900399771497355172478194e-01, 12, "149003997715", 0},
  {1.0702681301238348158876283e-10, 17, "10702681", -9},
  {2.7751258006229400634765625e+10, 17, "27751258006229400634765625", 11},
  {7.5081360172831549944054419e-05, 8, "7508", -4},
  {4.8017615412389183044433594e+08, 14, "48017615412389183044434", 9},
  {9.8787784822113906534233806e-23, 16, "", -16},
  {2.5315422014002368927001953e+10, 2, "25315422014", 11},
  {1.2497801599024280997484755e-15, 6, "", -6},
  {1.9380681590860356615835193e-24, 10, "", -10},
  {1.4547103818814195071366219e-07, 2, "", -2},
  {4.7342949831325519084930420e+08, 18, "473429498313255190849304199", 9},
  {1.0310828943311864191965450e-19, 5, "", -5},
  {1.0869771192704101562500000e+11, 6, "108697711927041016", 12},
  {2.7069801041964715576171875e+11, 1, "2706980104196", 12},
  {3.0419079410371751109318031e-18, 2, "", -2},
  {1.4005212481303518870845437e+04, 2, "1400521", 5},
  {1.1244046334262368256000000e+19, 12, "11244046334262368256", 20},
  {1.4848263607781430930660174e-22, 5, "", -5},
  {3.4170623523990510000000000e+15, 3, "3417062352399051", 16},
  {1.5728282922936352539062500e+11, 15, "157282829229363525390625", 12},
  {1.5531884467593986328125000e+13, 8, "1553188446759398632813", 14},
  {3.1334364940089967603853438e+03, 8, "313343649401", 4},
  {2.2850354132050101907402961e-01, 11, "22850354132", 0},
  {2.1905550815706141293048859e+07, 2, "2190555082", 8},
  {1.9198401973745592385967029e+02, 5, "19198402", 3},
  {4.9722154853814528905786574e+04, 10, "497221548538145", 5},
  {1.6186558090100970908054023e+00, 3, "1619", 1},
  {4.5962164933882570266723633e+08, 15, "459621649338825702667236", 9},
  {3.4689027809860734086200296e-01, 9, "346890278", 0},
  {1.0555850350300073727139083e-23, 6, "", -6},
  {3.8506567305516483656901983e+02, 11, "38506567305516", 3},
  {1.8043501575723522093325873e-17, 9, "", -9},
  {2.4546283879993420839309692e+08, 10, "2454628387999342084", 9},
  {3.5969727078420326016328090e+00, 19, "35969727078420326016", 1},
  {1.2223699592470585728419028e-19, 11, "", -11},
  {1.3501144527186534105567262e+03, 20, "135011445271865341055673", 4},
  {1.0562975838305750000000000e+15, 16, "1056297583830575", 16},
  {2.6411095994298296481890686e-23, 7, "", -7},
  {3.4636538360472073350138089e+00, 8, "346365384", 1},
  {2.9749191866138609801253077e-19, 1, "", -1},
  {2.1610399748192112000000000e+16, 4, "21610399748192112", 17},
  {3.7814448103091552943685882e-05, 19, "378144481030916", -4},
  {1.8008041181448165542547390e-05, 8, "1801", -4},
  {9.2688340275765240192413330e+07, 8, "9268834027576524", 8},
  {5.8880398613230742153567422e-09, 6, "", -6},
  {8.7675244523912939520000000e+18, 0, "8767524452391293952", 19},
  {2.1177875438892728320000000e+19, 9, "2117787543889272832", 20},
  {1.6749716988340285971948370e-13, 3, "", -3},
  {5.9624692099898710000000000e+15, 20, "5962469209989871", 16},
  {4.4598211114563617187500000e+13, 4, "445982111145636172", 14},
  {1.3940203420357130781326305e+01, 1, "139", 2},
  {1.8231068007872465625000000e+14, 16, "18231068007872465625", 15},
  {1.8167917984424674510955811e+08, 15, "181679179844246745109558", 9},
  {1.3778547612793373628906719e-06, 17, "137785476128", -5},
  {4.7173823441643520000000000e+17, 9, "4717382344164352", 18},
  {5.0354888875429527544520328e-14, 16, "504", -13},
  {2.0449619203067912167171016e+04, 9, "20449619203068", 5},
  {1.3831979182023453873144484e-08, 19, "13831979182", -7},
  {5.9269413697946978145821142e-09, 7, "", -7},
  {1.8615220356143298200141402e-16, 7, "", -7},
  {2.0422533648415752395521849e+04, 13, "204225336484157524", 5},
  {8.8046317963694102292191292e-11, 3, "", -3},
  {1.8595436003527481716446346e+03, 15, "1859543600352748172", 4},
  {2.3471101808016654615177913e-06, 7, "23", -5},
  {3.7900637756217261085112114e+03, 4, "37900638", 4},
  {3.7128834534649471010297969e-13, 14, "37", -12},
  {6.5837500580923421837513427e-13, 15, "658", -12},
  {2.0621363810916295051314849e-18, 15, "", -15},
  {4.9718789694920837973768357e+02, 0, "497", 3},
  {4.3878188207930080592632294e+07, 20, "438781882079300805926322937", 8},
  {5.6687579073184468143153936e+04, 4, "566875791", 5},
  {2.9350775942009491376639066e-11, 18, "29350776", -10},
  {7.2658123816037730473305185e-19, 5, "", -5},
  {4.8967942273763452752050806e-18, 8, "", -8},
  {1.7279723993338347873595584e-16, 16, "2", -15},
  {4.9550789394806900000000000e+14, 13, "495507893948069", 15},
  {3.8239444980937120601669721e-23, 4, "", -4},
  {2.8978287926661902336000000e+19, 16, "28978287926661902336", 20},
  {4.4384547121046543121337891e+08, 2, "44384547121", 9},
  {1.8648603813475064320000000e+18, 9, "1864860381347506432", 19},
  {4.0818691570774780273437500e+10, 2, "4081869157077", 11},
  {3.2364900702068098493510273e-19, 8, "", -8},
  {1.1265009789585065600000000e+17, 17, "112650097895850656", 18},
  {1.2282748044842711994133672e-15, 0, "", 0},
  {1.4854044978786967723394241e-01, 14, "14854044978787", 0},
  {9.0265389979746278400000000e+17, 14, "902653899797462784", 18},
  {1.0518603876217048437500000e+14, 2, "10518603876217048", 15},
  {1.6261273459981009364128113e+08, 16, "1626127345998100936412811", 9},
  {2.4726157459737908903793817e-07, 12, "247262", -6},
  {2.7797203387861547525972128e+05, 6, "277972033879", 6},
  {7.0539076162218020044800000e+20, 17, "705390761622180200448", 21},
  {3.8085997887445630967743093e-20, 18, "", -18},
  {1.7969266177854607500000000e+15, 4, "179692661778546075", 16},
  {1.0085645268992627854648442e-23, 8, "", -8},
  {1.5943890092992346520922586e-05, 17, "1594389009299", -4},
  {5.0077715574111193894255845e-21, 5, "", -5},
  {6.5355374412248310303891833e-24, 4, "", -4},
  {3.2818871334333645000000000e+15, 7, "32818871334333645", 16},
  {1.6235815612209183593750000e+13, 5, "1623581561220918359", 14},
  {6.9242859534068116727605654e-16, 5, "", -5},
  {5.2228840232341718673706055e+09, 7, "52228840232341719", 10},
  {4.9840122459014388945705347e-18, 13, "", -13},
  {4.2816987544313178659649566e+03, 3, "4281699", 4},
  {7.9486907543101925502707084e-05, 19, "794869075431019", -4},
  {1.2221776758589177645345571e-23, 6, "", -6},
  {1.2461577034201087815970967e-20, 13, "", -13},
  {2.9636593741971324220076025e-06, 0, "", 0},
  {4.9778088097151130797348285e-16, 5, "", -5},
  {2.3839008887817799738301293e-25, 12, "", -12},
  {8.2783636740199032866835613e-14, 1, "", -1},
  {4.1365277780736818503612429e-04, 20, "41365277780736819", -3},
  {2.7255577329522065722743805e-21, 12, "", -12},
  {1.0021112529893257812500000e+13, 17, "100211125298932578125", 14},
  {9.0013179382814601063728333e+07, 17, "9001317938281460106372833", 8},
  {1.6445910065679491007936284e-20, 16, "", -16},
  {4.2464770280860538880000000e+18, 4, "4246477028086053888", 19},
  {1.9102394989000097656250000e+13, 7, "191023949890000976563", 14},
  {6.8785743922697420202894136e+03, 16, "68785743922697420203", 4},
  {3.4299774106737867187500000e+13, 16, "342997741067378671875", 14},
  {4.4951616577262682190063728e-23, 16, "", -16},
  {2.7381277402820007324218750e+11, 17, "2738127740282000732421875", 12},
  {4.1651714303950597241055220e+04, 2, "4165171", 5},
  {1.7738818502127488497225338e-14, 12, "", -12},
  {2.9436671068608860000000000e+16, 3, "2943667106860886", 17},
  {1.5458781356140104543175975e-16, 16, "2", -15},
  {4.3505227163972586801432841e-14, 17, "4351", -13},
  {2.5456596901161123150610403e-08, 9, "25", -7},
  {1.2274837431911259458596528e-14, 17, "1227", -13},
  {1.7962692645495701753150291e-21, 18, "", -18},
  {1.1715920362498962727768686e-25, 10, "", -10},
  {2.2635342759737396240234375e+09, 20, "22635342759737396240234375", 10},
  {1.3807682492042373046875000e+12, 11, "13807682492042373046875", 13},
  {9.4467534358959732344374061e+04, 14, "9446753435895973234", 5},
  {8.9386326024918901743779850e-18, 11, "", -11},
  {1.3335676263490667020505871e-21, 5, "", -5},
  {3.0713943627589813945011343e-02, 6, "30714", -1},
  {1.2782162070094787597656250e+11, 11, "12782162070094787597656", 12},
  {9.9985131709497444361934083e-18, 16, "", -16},
  {8.2446557253358562747970380e-17, 8, "", -8},
  {4.3585295448496045000000000e+15, 17, "43585295448496045", 16},
  {1.0860879372254847764157084e-12, 16, "10861", -11},
  {2.7143812003566046875000000e+14, 6, "27143812003566046875", 15},
  {2.6381876202736155079264790e+01, 10, "263818762027", 2},
  {2.1000745251997171515317268e-25, 8, "", -8},
  {5.9465997829750639591923717e-25, 1, "", -1},
  {1.7176656719171121165776476e-09, 12, "1718", -8},
  {1.9696445056223161282143115e-14, 20, "1969645", -13},
  {3.3725054226639711673450150e-25, 13, "", -13},
  {8.6001344555184318300530547e-12, 16, "86001", -11},
  {1.9423887662825178267667070e+04, 4, "194238877", 5},
  {2.9460748873317458423892745e-02, 20, "2946074887331745842", -1},
  {6.2756091433538822457194328e+06, 6, "6275609143354", 7},
  {7.8833674465687042509642879e-01, 10, "7883367447", 0},
  {1.4617840140768390827486648e-14, 10, "", -10},
  {3.2198269147885890625000000e+13, 10, "32198269147885890625", 14},
  {4.7430840405846411743923780e-08, 15, "4743084", -7},
  {9.0928267778993507411007694e-11, 8, "", -8},
  {1.5724291118406795249029528e+03, 1, "15724", 4},
  {5.4936010383294848725199699e+05, 4, "5493601038", 6},
  {1.7126181896914343116833379e+00, 14, "171261818969143", 1},
  {6.7983834009183784509422997e-07, 1, "", -1},
  {9.7878679829380274964077723e-19, 2, "", -2},
  {6.5017314999581458323518746e+03, 11, "650173149995815", 4},
  {2.1262237222816751723401818e-04, 16, "2126223722282", -3},
  {8.5497264307497944271340556e-06, 14, "854972643", -5},
  {1.2601834287161556480000000e+18, 4, "1260183428716155648", 19},
  {6.4706786728327098801688011e-16, 6, "", -6},
  {5.4561812493227614966517965e-06, 19, "54561812493228", -5},
  {2.5988684391766441984000000e+19, 15, "25988684391766441984", 20},
  {2.1895382354851899292524919e-02, 0, "", 0},
  {6.3067082935646638806824549e-11, 1, "", -1},
  {1.6663912148957980546290026e-07, 18, "16663912149", -6},
  {3.7368301368776015819765100e-20, 4, "", -4},
  {2.6697890083928493831777473e-01, 8, "2669789", 0},
  {4.2854763491725452248656478e-09, 5, "", -5},
  {3.1549457465124457489416858e-21, 13, "", -13},
  {2.7535013675013190926532891e-25, 9, "", -9},
  {3.8996058496234386657432696e-25, 9, "", -9},
  {4.8821850209749766400000000e+17, 8, "488218502097497664", 18},
  {5.0781161427727749738013160e-11, 7, "", -7},
  {7.1941655472717700000000000e+14, 2, "719416554727177", 15},
  {2.0648257816631895293356449e-10, 6, "", -6},
  {1.6443891873017856478691101e+08, 13, "1644389187301785647869", 9},
  {2.8583447704710155595716375e-25, 9, "", -9},
  {5.1191408000235783820883012e-09, 17, "51191408", -8},
  {9.9726059066040165235200732e-03, 11, "997260591", -2},
  {1.9040961646283086458955749e-13, 16, "1904", -12},
  {1.1069662688896234900802182e-14, 9, "", -9},
  {1.7620874425257560325435812e-16, 19, "1762", -15},
  {8.3393472398607923423696775e+02, 16, "8339347239860792342", 3},
  {1.2341438721912999145619017e-04, 2, "", -2},
  {2.1419729370310812979079390e-25, 16, "", -16},
  {1.6730580223600516343026186e-20, 15, "", -15},
  {1.4797882196798561542763889e-19, 7, "", -7},
  {7.8914920681340425258930078e-14, 0, "", 0},
  {8.2403924274861159253967313e-05, 20, "8240392427486116", -4},
  {8.0889988924491225600000000e+17, 9, "808899889244912256", 18},
  {1.3640437570525609771721065e+04, 9, "13640437570526", 5},
  {7.6441257145068741696292136e-01, 8, "76441257", 0},
  {7.3113202917205986908211202e-03, 20, "731132029172059869", -2},
  {4.3438777312173648048045761e-13, 6, "", -6},
  {3.1354418687645824181942089e-02, 4, "314", -1},
  {8.2524905728280668258666992e+09, 2, "825249057283", 10},
  {2.3178802600952419510349500e-01, 12, "23178802601", 0},
  {6.9013359417969329535208489e-05, 18, "69013359417969", -4},
  {1.1782930239133537500000000e+14, 5, "117829302391335375", 15},
  {2.6006498009757758007867297e-09, 15, "260065", -8},
  {6.9732533869414061587000033e-19, 4, "", -4},
  {3.6776532323982093811035156e+10, 15, "36776532323982093811035156", 11},
  {1.7042551360110125789722926e-18, 9, "", -9},
  {1.4144610189153305254876614e+06, 16, "14144610189153305254877", 7},
  {1.0037425836075190090923570e+03, 19, "10037425836075190090924", 4},
  {1.7809975239542432245798409e+05, 20, "17809975239542432245798409", 6},
  {2.9674990970972746093750000e+13, 5, "2967499097097274609", 14},
  {8.1923823553480275450056070e+01, 16, "819238235534802755", 2},
  {2.4470056028983423795200000e+20, 13, "244700560289834237952", 21},
  {3.2456982212848952024130452e-06, 17, "324569822128", -5},
  {1.9083442760284968921227909e-20, 4, "", -4},
  {4.4214811642740733921527863e+07, 15, "44214811642740733921528", 8},
  {2.6653554288542371243238449e+07, 2, "2665355429", 8},
  {3.1728630570459022007165700e-23, 17, "", -17},
  {4.0116418032616347773000598e+05, 3, "40116418", 6},
  {2.2964725954505747070312500e+12, 13, "229647259545057470703125", 13},
  {8.9777697009610450242159981e-11, 18, "89777697", -10},
  {1.5865403351200376215083832e-18, 9, "", -9},
  {6.9466382212358993920000000e+18, 4, "6946638221235899392", 19},
  {6.1414879753187467947839195e-01, 19, "6141487975318746795", 0},
  {1.1736820709685522597283125e+06, 4, "1173682071", 7},
  {8.2400089777732500000000000e+13, 5, "824000897777325", 14},
  {1.8620314488254969080536064e-20, 12, "", -12},
  {4.3464130657736590364947915e+04, 2, "4346413", 5},
  {2.3918080806075814819335938e+11, 13, "2391808080607581481933594", 12},
  {4.4959782658397781449914661e-22, 6, "", -6},
  {6.4173027977245832000000000e+16, 10, "64173027977245832", 17},
  {3.6031996458583501656722213e-19, 6, "", -6},
  {1.3251347298930184543132782e+08, 1, "132513473", 9},
  {6.2574692718918530964917393e-18, 15, "", -15},
  {1.5430543601847778771990877e-13, 14, "15", -12},
  {1.5959258993296041870117188e+11, 20, "159592589932960418701171875", 12},
  {2.4442857340021314615369219e-04, 8, "24443", -3},
  {2.0482639297377173788845539e+06, 5, "204826392974", 7},
  {1.1245098212865036000000000e+16, 0, "11245098212865036", 17},
  {6.3982637955111904659588618e+01, 15, "63982637955111905", 2},
  {1.6573327787354461303583778e-23, 16, "", -16},
  {7.8452331107566103339195251e+07, 8, "784523311075661", 8},
  {1.9857459743711594910564600e+03, 12, "1985745974371159", 4},
  {1.7224770288261640871496638e+03, 0, "1722", 4},
  {3.5997731257309944435162084e-23, 18, "", -18},
  {7.4638761461345528909890993e-20, 18, "", -18},
  {8.5854531017206034483860496e-23, 1, "", -1},
  {3.9844039043052581396814338e-04, 16, "3984403904305", -3},
  {3.8769643362977774907196515e-03, 0, "", 0},
  {9.4103896724667420000000000e+15, 8, "9410389672466742", 16},
  {7.5717331712501341158461546e-12, 18, "7571733", -11},
  {4.1194578488514610290527344e+10, 6, "4119457848851461", 11},
  {2.7130683126277413219213486e+07, 16, "271306831262774132192135", 8},
  {1.7881247839780792128294706e+06, 0, "1788125", 7},
  {4.6010440716483800299686174e-18, 15, "", -15},
  {1.6157522414504644984845072e+04, 13, "16157522414504645", 5},
  {2.5124973509159681645229342e-13, 10, "", -10},
  {9.1041147767938375000000000e+14, 18, "91041147767938375", 15},
  {5.7569751997995048761367798e+07, 16, "575697519979950487613678", 8},
  {9.4457175770233645084594798e-02, 4, "945", -1},
  {1.6238764070110268630198704e-16, 9, "", -9},
  {1.6555060875372414550781250e+12, 4, "16555060875372415", 13},
  {2.9282542904992471040000000e+18, 14, "2928254290499247104", 19},
  {4.3244009096801413178123702e-22, 4, "", -4},
  {3.2840278398514085000000000e+15, 19, "32840278398514085", 16},
  {3.4158268759461978912353516e+10, 1, "341582687595", 11},
  {9.7446859802761806394380303e-19, 6, "", -6},
  {5.8083000662163129845794174e+01, 13, "580830006621631", 2},
  {1.9890827570526545549246459e-18, 12, "", -12},
  {2.2673181544486649130476508e+01, 6, "22673182", 2},
  {7.0768724081614204084351993e-05, 2, "", -2},
  {1.7016167816073057665604562e-03, 13, "17016167816", -2},
  {2.2961288224376665366206125e-25, 20, "", -20},
  {1.5708383152978917779831261e-05, 19, "157083831529789", -4},
  {4.1182479210914993286132812e+09, 2, "411824792109", 10},
  {1.8130671941229146931200000e+20, 6, "181306719412291469312", 21},
  {8.5853095766441729352891343e+00, 9, "8585309577", 1},
  {4.4995763599030081250000000e+14, 1, "4499576359903008", 15},
  {2.1100082550131958214478800e+01, 5, "2110008", 2},
  {3.9500566215727461171200000e+20, 6, "395005662157274611712", 21},
  {5.6501798423545992328120846e-03, 12, "5650179842", -2},
  {1.1407057899150473531335592e+04, 12, "11407057899150474", 5},
  {2.1689132831161753906250000e+13, 1, "216891328311618", 14},
  {5.9376728946526291963436961e+01, 1, "594", 2},
  {5.2036202097183635839085539e-10, 18, "520362021", -9},
  {1.1605194668471363671947183e-16, 6, "", -6},
  {1.5904499649179144398658536e+04, 8, "1590449964918", 5},
  {1.3956014295472651107540866e-17, 8, "", -8},
  {2.4255056783225358230993152e+04, 13, "242550567832253582", 5},
  {8.8801305678949352118145555e-02, 16, "888013056789494", -1},
  {1.8244931029325716000000000e+16, 16, "18244931029325716", 17},
  {3.1692391661967690956800000e+20, 12, "316923916619676909568", 21},
  {1.2252316715915118400000000e+17, 13, "122523167159151184", 18},
  {8.5721607621156038246400000e+20, 0, "857216076211560382464", 21},
  {1.4165164660405714109475683e-03, 5, "142", -2},
  {3.8194401784654651321242349e-17, 2, "", -2},
  {8.4403505470443520000000000e+18, 18, "8440350547044352", 19},
  {7.7973415799441376806402579e-06, 16, "77973415799", -5},
  {1.3137180427565850317478180e+08, 19, "1313718042756585031747817993", 9},
  {2.0659539581646260000000000e+15, 20, "2065953958164626", 16},
  {2.6914611593174818685007905e-08, 15, "26914612", -7},
  {8.8333209532844982147216797e+09, 4, "88333209532845", 10},
  {2.9884519887187025233288296e+02, 19, "2988451988718702523329", 3},
  {5.4797988613487614202313125e+03, 8, "547979886135", 4},
  {8.8289774198348504078065074e-25, 2, "", -2},
  {1.2020148467665010688000000e+20, 14, "12020148467665010688", 21},
  {6.9316355895138923857871410e-22, 18, "", -18},
  {2.9486616987898988000000000e+16, 2, "29486616987898988", 17},
  {5.5318502783411768177757040e+03, 20, "55318502783411768177757", 4},
  {1.9604954286170394863848268e-21, 8, "", -8},
  {2.3794258226922439579022394e-14, 20, "2379426", -13},
  {4.4862980897863495446081583e-17, 3, "", -3},
  {7.7575732950881408313030821e-19, 6, "", -6},
  {1.9125416004651100365663297e+02, 4, "1912542", 3},
  {4.4347074464845981367489003e-01, 4, "4435", 0},
  {1.9603385674914034483200000e+20, 3, "196033856749140344832", 21},
  {7.0726540074339434522731198e-18, 0, "", 0},
  {6.2387062008957291254773736e+04, 20, "6238706200895729125477374", 5},
  {7.9295619797538352170777730e-16, 11, "", -11},
  {2.6942778731942826191501458e-21, 15, "", -15},
  {1.9802246549562896528194050e-13, 11, "", -11},
  {6.9267226433670387066993687e-14, 0, "", 0},
  {8.0139031669218058639824742e-13, 14, "8", -12},
  {1.0127546467430818136013357e-17, 7, "", -7},
  {1.3879567442149294584047732e-22, 3, "", -3},
  {1.9366061554761425941251218e+05, 12, "193660615547614259", 6},
  {8.1870140761354477945133112e+03, 11, "818701407613545", 4},
  {2.5955560182295025883734166e-08, 0, "", 0},
  {2.0658768838240191340446472e+08, 15, "206587688382401913404465", 9},
  {4.9772939385687252447269075e-07, 16, "4977293939", -6},
  {1.5066551990533496500988125e-06, 10, "15067", -5},
  {9.6387242416084859542024788e+00, 18, "9638724241608485954", 1},
  {5.5112059775884374017650746e-11, 15, "55112", -10},
  {5.8798784556151096991565373e-13, 19, "5879878", -12},
  {1.9468844568875060065066482e-22, 6, "", -6},
  {4.4948716897457857589378986e-21, 10, "", -10},
  {1.2179283066358402252800000e+20, 8, "121792830663584022528", 21},
  {1.1454281671409871450034787e-12, 16, "11454", -11},
  {5.7900994850021869102144698e-24, 19, "", -19},
  {6.5510964028421650167894271e-16, 11, "", -11},
  {1.1679054459420565504000000e+19, 10, "11679054459420565504", 20},
  {2.0847283715350682526252539e-15, 18, "2085", -14},
  {1.6836273842557624700676894e-25, 7, "", -7},
  {7.1530742842810096979696823e-17, 0, "", 0},
  {2.2272170791700535117054692e-23, 5, "", -5},
  {8.7299507880688989194209845e-15, 15, "9", -14},
  {8.8240689555430504298350058e-02, 15, "88240689555431", -1},
  {7.6362966910334161294556941e-14, 3, "", -3},
  {3.4054022684735396666052571e-25, 15, "", -15},
  {2.0708257400292173766587212e-01, 12, "207082574003", 0},
  {4.8728595617487571040049588e-03, 7, "48729", -2},
  {1.3856025026019746000000000e+16, 13, "13856025026019746", 17},
  {6.8766240574953744801919393e-17, 9, "", -9},
  {4.7516675890828851200000000e+18, 9, "475166758908288512", 19},
  {1.7747142563037956700814231e-12, 14, "177", -11},
  {3.0220425230844838166535955e-25, 16, "", -16},
  {2.5689792570996914818011126e-24, 9, "", -9},
  {1.0931797856678371864201768e-22, 12, "", -12},
  {6.0681209056134863217517851e-24, 10, "", -10},
  {2.2325915928877993155950435e-17, 2, "", -2},
  {1.3879279766514665472000000e+19, 20, "13879279766514665472", 20},
  {4.4016295082886518443380045e-19, 2, "", -2},
  {9.6274785509785216000000000e+16, 18, "96274785509785216", 17},
  {4.4885544097526048000000000e+16, 15, "44885544097526048", 17},
  {1.1966610962442822126643562e-07, 11, "11967", -6},
  {7.6531748642620868114394561e-03, 2, "1", -1},
  {2.9694502423389308387413621e+05, 16, "2969450242338930838741", 6},
  {2.2621375319178394996911311e-17, 6, "", -6},
  {1.2469372638823003285324376e+01, 2, "1247", 2},
  {1.6487601217487679150508484e+03, 1, "16488", 4},
  {7.9381186005750298500061035e+06, 6, "7938118600575", 7},
  {8.8036511114571728012800558e-15, 4, "", -4},
  {7.1939383119861738281250000e+12, 6, "7193938311986173828", 13},
  {6.7478107069270660000000000e+15, 10, "6747810706927066", 16},
  {4.3140619362566467285156250e+11, 14, "4314061936256646728515625", 12},
  {3.5946654681458972725635310e-24, 11, "", -11},
  {2.9616429166385566359195363e-18, 6, "", -6},
  {1.1722290967949940132530884e-01, 5, "11722", 0},
  {6.4941198562311070862501650e-04, 17, "64941198562311", -3},
  {4.5133908656220332945622413e-23, 9, "", -9},
  {1.0143035407519000000000000e+15, 20, "10143035407519", 16},
  {7.2042326648965288000000000e+16, 15, "72042326648965288", 17},
  {1.6694582585584085558161579e-14, 18, "16695", -13},
  {9.4980266949423143151104930e-08, 2, "", -2},
  {1.9666247478213633466165187e-20, 9, "", -9},
  {1.2942152055515446136269020e+03, 11, "129421520555154", 4},
  {1.4968080095969136747513571e-22, 3, "", -3},
  {2.2092812806185227500000000e+15, 16, "220928128061852275", 16},
  {1.8604726632826671178619877e-12, 9, "", -9},
  {1.0099792435107621131464839e+06, 14, "100997924351076211315", 7},
  {1.0219960966035602041301900e+03, 2, "1022", 4},
  {1.7275129384769539214698386e-17, 14, "", -14},
  {6.8190784367061199432933158e-19, 15, "", -15},
  {1.3839799720349387678527524e-24, 15, "", -15},
  {4.0851379176957203125000000e+13, 0, "40851379176957", 14},
  {1.0196561983036783764617378e-14, 4, "", -4},
  {4.7697688196812262199026429e-08, 15, "47697688", -7},
  {3.6878725901612415313720703e+09, 2, "368787259016", 10},
  {5.2557974951884009190959400e-24, 5, "", -5},
  {8.5458631224993646342921486e-12, 3, "", -3},
  {9.0699129366852463237619125e-24, 15, "", -15},
  {1.9959707534310933851884329e+02, 8, "19959707534", 3},
  {3.0593742641053178623057304e-18, 0, "", 0},
  {3.6988096024912087551358180e-16, 19, "3699", -15},
  {8.3601926968297027051448822e+06, 17, "836019269682970270514488", 7},
  {3.0965614540807800292968750e+10, 7, "309656145408078003", 11},
  {1.1387077179235354687500000e+14, 8, "113870771792353546875", 15},
  {5.4579225328160364697654271e-11, 14, "5458", -10},
  {2.6052662550333428000000000e+16, 6, "26052662550333428", 17},
  {3.4312094371137871872000000e+19, 7, "34312094371137871872", 20},
  {1.9842145047945143332412954e+00, 9, "1984214505", 1},
  {2.8624485963489355468750000e+13, 20, "2862448596348935546875", 14},
  {4.7797297561289535882365909e-05, 19, "477972975612895", -4},
  {7.8780863251508731842041016e+09, 20, "78780863251508731842041015625", 10},
  {4.2888220654928419124651828e-04, 18, "428882206549284", -3},
  {8.3820051124294374400000000e+17, 5, "838200511242943744", 18},
  {2.2298852295194603502750397e+06, 15, "2229885229519460350275", 7},
  {1.6854550572874393251781651e-12, 12, "2", -11},
  {1.0443182758094417187500000e+14, 13, "104431827580944171875", 15},
  {3.7567280932267807656899095e+04, 8, "3756728093227", 5},
  {2.5364269725512319267569964e-19, 20, "25", -18},
  {3.4211974719867777824401855e+09, 10, "34211974719867777824", 10},
  {3.3620269000806577148437500e+12, 2, "336202690008066", 13},
  {1.5247884034077011877572154e-13, 16, "1525", -12},
  {1.1843615969060773982049027e-19, 15, "", -15},
  {1.4555840659886487911678365e-02, 5, "1456", -1},
  {6.7777815208751754760742188e+09, 5, "677778152087518", 10},
  {1.2161967656345366606274183e+02, 14, "12161967656345367", 3},
  {3.5952168763397020057600000e+20, 8, "359521687633970200576", 21},
  {3.2401836829058667517480846e-19, 3, "", -3},
  {9.9281912818453568747578686e-02, 16, "992819128184536", -1},
  {7.5380116600345374744420090e-19, 6, "", -6},
  {2.0112771132706009666435421e+05, 5, "20112771133", 6},
  {1.0866525455276408839358081e-08, 15, "10866525", -7},
  {2.4375902960262405797138563e-04, 10, "243759", -3},
  {1.2320491407520540652066360e-16, 2, "", -2},
  {3.8201254097692950000000000e+15, 6, "3820125409769295", 16},
  {1.5069540098032950936612906e+02, 18, "150695400980329509366", 3},
  {2.7116596259417451619810890e+02, 17, "2711659625941745162", 3},
  {2.3660839684827644531250000e+13, 10, "2366083968482764453125", 14},
  {4.6864709408518794225528836e+05, 6, "468647094085", 6},
  {4.5249014445905730826780200e+05, 13, "4524901444590573083", 6},
  {2.5524911847515016000000000e+16, 7, "25524911847515016", 17},
  {9.0709671849330869155794877e-18, 15, "", -15},
  {2.1664636760781410156250000e+13, 14, "2166463676078141015625", 14},
  {1.4673668683422710937500000e+13, 3, "14673668683422711", 14},
  {1.4126929999716221875000000e+14, 11, "14126929999716221875", 15},
  {7.1689258769812820170813108e-13, 11, "", -11},
  {8.5754832613839042186737061e+08, 9, "857548326138390422", 9},
  {4.3432326849783745740935762e-08, 19, "434323268498", -7},
  {4.8296231624284742498716400e-17, 15, "", -15},
  {1.3608010603527845959058624e-05, 13, "136080106", -4},
  {8.7394177261364507951238291e-18, 2, "", -2},
  {6.0916499394900831587684730e-09, 9, "6", -8},
  {2.1291450281879938525226592e-19, 15, "", -15},
  {5.2458551447838573455810547e+09, 5, "524585514478386", 10},
  {7.1238490611223840000000000e+16, 12, "7123849061122384", 17},
  {2.4590122752745658764787845e-25, 19, "", -19},
  {1.9482408817953582031250000e+13, 16, "1948240881795358203125", 14},
  {1.2487093325780434109923894e-20, 8, "", -8},
  {5.8862369378146809162235238e-20, 2, "", -2},
  {3.5373509928215851169327027e-19, 19, "4", -18},
  {9.2544556467326437500000000e+13, 0, "92544556467326", 14},
  {3.6184497577970356615648106e-04, 15, "36184497578", -3},
  {7.0740587033806925136369628e-24, 18, "", -18},
  {1.2755856439016371200000000e+18, 11, "127558564390163712", 19},
  {2.0249658877497602867200000e+20, 13, "202496588774976028672", 21},
  {5.4258401562801529600000000e+17, 16, "542584015628015296", 18},
  {1.8021566643919020199084935e-22, 2, "", -2},
  {7.6778310973493484198115766e+04, 11, "7677831097349348", 5},
  {2.9249359256748695372600130e-24, 15, "", -15},
  {3.5347629095954052013309468e-12, 10, "", -10},
  {4.7590068143288248545923263e-19, 12, "", -12},
  {1.6589754855475962917824277e-16, 8, "", -8},
  {1.3782997652500473122927360e+04, 20, "1378299765250047312292736", 5},
  {7.2240249234377037500000000e+14, 20, "722402492343770375", 15},
  {1.4231585827406917233020067e+06, 10, "14231585827406917", 7},
  {3.2268624382841293171181708e-22, 4, "", -4},
  {6.5348936860635760126569949e+01, 16, "653489368606357601", 2},
  {4.9320448187303829803984634e-03, 20, "493204481873038298", -2},
  {9.9111272737530790453005562e-22, 0, "", 0},
  {1.8279875656027103850848059e-03, 8, "182799", -2},
  {1.8917484026606533831227352e+01, 3, "18917", 2},
  {3.4669581497865224000000000e+16, 3, "34669581497865224", 17},
  {1.3407651951570475520000000e+18, 14, "1340765195157047552", 19},
  {2.4919630980240992696142687e-16, 5, "", -5},
  {1.4057983542484916667372038e-08, 16, "140579835", -7},
  {1.5603855590518553225186684e-24, 14, "", -14},
  {3.6065112974811417586744963e-09, 2, "", -2},
  {1.3080892394647175495047214e-17, 2, "", -2},
  {7.0748876841783267927461719e-23, 10, "", -10},
  {9.4630988385068899546308545e-25, 16, "", -16},
  {7.5787841147755691145588936e-12, 0, "", 0},
  {1.1621148225828153954353184e+04, 0, "11621", 5},
  {4.2941149307332005378011008e-21, 3, "", -3},
  {3.8974998150441536903381348e+09, 14, "389749981504415369033813", 10},
  {3.9021994229045673273503780e+06, 15, "390219942290456732735", 7},
  {3.1640020314294849543182447e-16, 5, "", -5},
  {2.6854130500549102003458457e-11, 9, "", -9},
  {1.3496196855721421112643512e-20, 20, "1", -19},
  {3.0107008765109312534332275e+08, 12, "301070087651093125343", 9},
  {2.7436847398368725553154945e+06, 9, "2743684739836873", 7},
  {1.0914414233128566741943359e+10, 15, "10914414233128566741943359", 11},
  {5.4109300816950917120000000e+18, 20, "5410930081695091712", 19},
  {4.7396779957817268371582031e+08, 12, "473967799578172683716", 9},
  {1.8919400951164111328125000e+12, 2, "189194009511641", 13},
  {1.6026605315509418925386383e-10, 2, "", -2},
  {1.9464110479342087637633085e+05, 18, "194641104793420876376331", 6},
  {6.5683093450501239984249269e-19, 2, "", -2},
  {2.3884464492849702257252632e-17, 1, "", -1},
  {2.6028639764601891511119902e+05, 4, "2602863976", 6},
  {6.5279481495197542400000000e+17, 4, "652794814951975424", 18},
  {5.0308751520161658632446233e+00, 1, "5", 1},
  {3.4931246996633846680319621e-21, 17, "", -17},
  {1.5912685082093768650525801e-08, 13, "159127", -7},
  {1.5659609996971668243408203e+10, 14, "156596099969716682434082", 11},
  {2.6445819309109371453114830e-19, 20, "26", -18},
  {1.4688644292654487715638068e-04, 4, "1", -3},
  {5.7831987410769118056284160e-06, 2, "", -2},
  {3.8813060436710040085017681e+05, 10, "3881306043671004", 6},
  {4.9975776444927440240742341e-17, 10, "", -10},
  {2.2699672566438133122794792e-14, 1, "", -1},
  {2.8039001672601219200000000e+17, 13, "280390016726012192", 18},
  {1.8268002010113628160000000e+19, 13, "1826800201011362816", 20},
  {2.5852390122985739182505247e-24, 11, "", -11},
  {1.5397032076744860219605449e-12, 12, "2", -11},
  {1.2260142662461742401123047e+10, 2, "1226014266246", 11},
  {3.0945916337873733520507812e+10, 14, "3094591633787373352050781", 11},
  {6.9522085135879559859976686e-10, 10, "7", -9},
  {4.7679618449601567705467316e-09, 0, "", 0},
  {2.1036207734558060856552711e-19, 5, "", -5},
  {2.1127911597528015183821888e-09, 15, "2112791", -8},
  {3.7216437404809971667418722e+03, 8, "372164374048", 4},
  {6.0927228497508464498047556e-22, 5, "", -5},
  {4.7596208738146000000000000e+15, 18, "47596208738146", 16},
  {7.8482640412790220800000000e+17, 6, "784826404127902208", 18},
  {1.1343374485835668497198114e-04, 1, "", -1},
  {1.4114819089339304508635368e-06, 18, "1411481908934", -5},
  {6.5787673063837556838989258e+09, 12, "6578767306383755683899", 10},
  {6.5538532978445448087623632e-19, 5, "", -5},
  {7.0868562428656482696533203e+09, 11, "708685624286564826965", 10},
  {2.1051886441891347656250000e+12, 2, "210518864418913", 13},
  {5.2726857487803500081770673e-11, 6, "", -6},
  {3.2305521791583453250495950e+02, 12, "323055217915835", 3},
  {4.2571610341385483741760254e+07, 20, "4257161034138548374176025391", 8},
  {3.4335311111086182400000000e+19, 19, "343353111110861824", 20},
  {2.2209347940576866340119657e-24, 15, "", -15},
  {5.9877892801644506632556002e-23, 7, "", -7},
  {7.5965207659383249913959438e-22, 10, "", -10},
  {4.1893391607547212500000000e+14, 16, "418933916075472125", 15},
  {3.5742044368140150900625684e-02, 11, "3574204437", -1},
  {2.8999472282480873858157011e-02, 8, "2899947", -1},
  {2.8062194342710307104482581e+00, 0, "3", 1},
  {1.2220962758518369355442701e+03, 5, "122209628", 4},
  {4.5337544992169225000000000e+14, 13, "45337544992169225", 15},
  {8.7219963600430288076800000e+20, 10, "872199636004302880768", 21},
  {2.3644367856665096750496894e-09, 17, "236443679", -8},
  {1.1725906673025229687500000e+14, 9, "117259066730252296875", 15},
  {1.3640811214952157592773438e+11, 9, "136408112149521575928", 12},
  {1.2445247289163789972121776e+00, 12, "1244524728916", 1},
  {1.0375991433836759980719180e-20, 9, "", -9},
  {3.3699429006828198763783612e-24, 17, "", -17},
  {5.3459351172306065661616811e-06, 4, "", -4},
  {3.8150668507227714507860743e-06, 11, "381507", -5},
  {4.9812244360020184496314760e-05, 18, "4981224436002", -4},
  {1.4668966757384481022031613e-21, 15, "", -15},
  {2.2539801519481514091386264e-17, 12, "", -12},
  {5.0282395508406345476660448e-12, 11, "1", -10},
  {9.4444366743897231360000000e+18, 15, "9444436674389723136", 19},
  {2.8997421843022431250000000e+14, 5, "2899742184302243125", 15},
  {7.9277038409481687040000000e+18, 12, "7927703840948168704", 19},
  {5.6536564576278902638506452e-01, 5, "56537", 0},
  {2.5490697846702617600000000e+17, 8, "254906978467026176", 18},
  {4.8792259234164431225266867e-01, 3, "488", 0},
  {5.3673025089390944256000000e+19, 12, "53673025089390944256", 20},
  {1.8156312500696619152599859e-25, 7, "", -7},
  {5.6962974308201545715332031e+10, 17, "5696297430820154571533203125", 11},
  {1.6711288440649452209472656e+10, 1, "167112884406", 11},
  {5.7168808440148778133679083e-18, 5, "", -5},
  {8.4704535086762590408325195e+09, 6, "8470453508676259", 10},
  {5.8592367935654497343172441e-11, 11, "6", -10},
  {1.0370414055550800811935909e-07, 3, "", -3},
  {1.9715830556077007500000000e+15, 10, "197158305560770075", 16},
  {4.5498610771978629741665932e-07, 4, "", -4},
  {3.1660394385156622130992658e-14, 16, "317", -13},
  {2.1089821203267175000000000e+15, 5, "21089821203267175", 16},
  {4.0432589826118729728000000e+19, 15, "40432589826118729728", 20},
  {5.7517083629607896000379696e+02, 12, "575170836296079", 3},
  {2.3828431857060152343750000e+13, 9, "2382843185706015234375", 14},
  {1.3616866645913600223138928e+05, 7, "1361686664591", 6},
  {2.1063105693572995218900730e-23, 11, "", -11},
  {1.8451001653215994592756033e+06, 6, "1845100165322", 7},
  {2.1579405497705618569990456e-24, 12, "", -12},
  {8.6860738800630590000000000e+15, 18, "8686073880063059", 16},
  {1.7224224826974234677705398e-06, 18, "1722422482697", -5},
  {3.0181093099926056960000000e+19, 5, "3018109309992605696", 20},
  {2.4686793619750156998634338e+07, 2, "2468679362", 8},
  {1.4586615853346473574400000e+20, 10, "145866158533464735744", 21},
  {2.1129704445358296875000000e+13, 16, "21129704445358296875", 14},
  {1.3077865357664621363200000e+20, 11, "130778653576646213632", 21},
  {6.9239790495567125000000000e+14, 8, "69239790495567125", 15},
  {1.6624012250185145933482287e-12, 11, "", -11},
  {5.4881660099664934682347182e-06, 15, "548816601", -5},
  {1.0103132375890919430333481e-03, 15, "1010313237589", -2},
  {1.1716323015515098975632829e-04, 2, "", -2},
  {4.7147075824871078125000000e+13, 0, "47147075824871", 14},
  {4.9636425419400014648432769e-17, 16, "", -16},
  {7.6051659801207798959539373e-17, 0, "", 0},
  {3.6706532560906984102855333e-03, 15, "3670653256091", -2},
  {7.7848563533968457231769081e-21, 0, "", 0},
  {7.9219442279025793141045142e+02, 19, "7921944227902579314105", 3},
  {1.1694532785740200872548478e-02, 7, "116945", -1},
  {3.7320586665764367945470486e-25, 18, "", -18},
  {6.8067254484044111189552409e-09, 8, "1", -7},
  {5.4389434215073576573544355e-19, 8, "", -8},
  {5.9304299334566621837439016e+02, 2, "59304", 3},
  {9.1673664342468641529281524e-21, 16, "", -16},
  {3.7575508769314425772780170e-18, 0, "", 0},
  {7.3733144938004951040000000e+18, 7, "7373314493800495104", 19},
  {8.3590362162616224420797839e-07, 11, "8359", -6},
  {6.4045650402221498964649982e-01, 1, "6", 0},
  {8.1094173223452269769242024e-11, 19, "810941732", -10},
  {1.2150607883100178696622606e+01, 10, "121506078831", 2},
  {6.8619456585961963520000000e+19, 9, "6861945658596196352", 20},
  {1.3591100941419091075658798e+07, 18, "13591100941419091075658798", 8},
  {5.8847301599955877097479452e-13, 2, "", -2},
  {8.7064201418646788965816086e+01, 18, "87064201418646788966", 2},
  {2.7597741607768679017453906e+01, 0, "28", 2},
  {5.2357296378405685288726090e+01, 16, "523572963784056853", 2},
  {1.1640283891311801937035544e-20, 19, "", -19},
  {6.5342040719553955078125000e+10, 9, "65342040719553955078", 11},
  {1.2009169664389918290595157e-12, 14, "12", -11},
  {3.6379964302257149960880721e-08, 10, "364", -7},
  {4.0542262426069358825683594e+10, 1, "405422624261", 11},
  {2.8144882739499686373781430e-23, 9, "", -9},
  {2.4540282610744534901774452e-05, 8, "2454", -4},
  {2.7766234951901472349802607e-16, 13, "", -13},
  {2.0498785604023388451366827e+00, 3, "205", 1},
  {1.0994193690419075927734375e+12, 13, "10994193690419075927734375", 13},
  {1.1316113702502496052468411e-11, 8, "", -8},
  {2.2193417167040902422735803e-23, 2, "", -2},
  {5.8079513520447233076993143e+02, 10, "5807951352045", 3},
  {4.3546916622878639221191406e+10, 12, "43546916622878639221191", 11},
  {5.0135334953486348967999220e+05, 20, "5013533495348634896799922", 6},
  {1.9645657788703926086425781e+10, 9, "19645657788703926086", 11},
  {2.1585033537904135218682349e-19, 0, "", 0},
  {8.0144931063802630117726279e-14, 4, "", -4},
  {1.2300507659122111801826897e-14, 17, "123", -13},
  {3.4677299988716610833500631e-17, 20, "3468", -16},
  {1.7645987673238653223961592e+05, 12, "176459876732386532", 6},
  {2.1562376756774080512000000e+19, 3, "21562376756774080512", 20},
  {2.1406549878021856689453125e+11, 5, "21406549878021857", 12},
  {9.3412355200653338389610658e-21, 7, "", -7},
  {1.8285970354942405209391669e-20, 13, "", -13},
  {9.4116361053802903138800973e-13, 1, "", -1},
  {1.8559646002350773734102094e-21, 8, "", -8},
  {5.4456045683300178527832031e+10, 2, "544560456833", 11},
  {7.8970938387237891997738615e-03, 6, "7897", -2},
  {4.5789764583182107626768698e-01, 12, "457897645832", 0},
  {4.4619766324138573824000000e+20, 0, "44619766324138573824", 21},
  {1.9791070834149281781888519e-02, 1, "", -1},
  {2.5793088304339482692519125e-19, 17, "", -17},
  {1.9026394395469680108700084e-09, 13, "19026", -8},
  {8.9691157802704195948091106e-07, 9, "897", -6},
  {9.3220991357297007198212668e+03, 7, "93220991357", 4},
  {3.1828547565788956973137379e-25, 4, "", -4},
  {1.0301138287478507110400000e+20, 18, "103011382874785071104", 21},
  {8.5938912877775528405220352e-23, 20, "", -20},
  {4.5117875970482768069493463e-17, 1, "", -1},
  {1.5531166743335281906246948e-15, 19, "15531", -14},
  {4.3873858708392473636195064e+05, 3, "438738587", 6},
  {6.4754706278686792640568536e-25, 6, "", -6},
  {1.6803538248046895861625671e+08, 19, "1680353824804689586162567139", 9},
  {5.0891939195546508800000000e+17, 11, "508919391955465088", 18},
  {5.5832444525745067713962816e-05, 0, "", 0},
  {8.7119768445148620800000000e+17, 16, "871197684451486208", 18},
  {3.9807146863168231272661211e-10, 18, "398071469", -9},
  {1.7177906066367641843910559e-08, 8, "2", -7},
  {5.6922771369589699375194451e-10, 16, "5692277", -9},
  {1.2026933189694645737772818e-16, 7, "", -7},
  {9.3766068689258204926773033e+01, 1, "938", 2},
  {4.6504388098474674180168864e-04, 4, "5", -3},
  {1.3706959202970900381892474e-08, 10, "137", -7},
  {3.7152532225837153320312500e+12, 14, "371525322258371533203125", 13},
  {1.5979230158572774642011660e-09, 10, "16", -8},
  {5.9007637480373377344570093e-22, 6, "", -6},
  {5.9849121946210279464721680e+09, 1, "59849121946", 10},
  {5.3665713563335397338960320e+04, 9, "53665713563335", 5},
  {4.3246599232972093840598502e-14, 16, "432", -13},
  {1.0319274596929202394068772e-16, 14, "", -14},
  {1.2322054676878014650398523e-17, 20, "1232", -16},
  {1.3506388292499191089106754e-15, 19, "13506", -14},
  {5.7210282826406846923283922e-03, 9, "5721028", -2},
  {9.8913725161900815155200000e+20, 6, "989137251619008151552", 21},
  {3.2660550908126947080185299e-24, 3, "", -3},
  {4.4556721811371007812500000e+13, 0, "44556721811371", 14},
  {3.2545903897560113780783850e-20, 13, "", -13},
  {8.1766299052500203251838684e+06, 10, "81766299052500203", 7},
  {1.6266165781026309253946010e-10, 6, "", -6},
  {1.0067351109487674122210377e-10, 9, "", -9},
  {6.0778591632173518144393656e-18, 17, "1", -16},
  {7.9719617375712041015625000e+12, 13, "79719617375712041015625", 13},
  {1.4675977718318465647939774e+01, 2, "1468", 2},
  {9.0071909450587496156516443e-05, 18, "90071909450587", -4},
  {1.6293957924901412963867188e+10, 10, "162939579249014129639", 11},
  {1.3759228261890457361005247e+03, 18, "1375922826189045736101", 4},
  {1.4898246445572727918624878e+08, 13, "1489824644557272791862", 9},
  {8.0572998816786237500000000e+14, 20, "805729988167862375", 15},
  {1.2391382539783359255310411e-19, 6, "", -6},
  {9.8084808365864125742329947e-18, 20, "981", -17},
  {3.3533061081068124619709603e-24, 14, "", -14},
  {2.3936760081565815467262081e-17, 5, "", -5},
  {3.4716333313074324877688684e-16, 0, "", 0},
  {3.7564149530803456250000000e+14, 20, "3756414953080345625", 15},
  {9.3243223404621087500000000e+14, 1, "9324322340462109", 15},
  {1.1292064685722723942400000e+20, 5, "112920646857227239424", 21},
  {7.7140321361852586291775537e-17, 19, "771", -16},
  {2.5270583911070518493652344e+10, 1, "252705839111", 11},
  {2.2341632529465689934798098e-09, 2, "", -2},
  {3.5136643245832198542753451e-09, 8, "", -8},
  {8.9162587654340136140800000e+20, 14, "891625876543401361408", 21},
  {8.0989905139870125847936864e-08, 16, "809899051", -7},
  {3.6206197978168579769103126e-09, 11, "362", -8},
  {4.0711048552189445217663888e+03, 5, "407110486", 4},
  {1.0530559828578270400000000e+17, 8, "105305598285782704", 18},
  {9.0350900221121466238116682e-01, 4, "9035", 0},
  {1.1164594479980616395405507e-17, 2, "", -2},
  {1.0825889030014803200000000e+17, 1, "108258890300148032", 18},
  {5.1226766453540462073458623e-11, 17, "5122677", -10},
  {5.2746505553253374451397294e-10, 11, "53", -9},
  {8.2037893346435590928204219e-13, 5, "", -5},
  {1.4606071402505772344199573e-16, 9, "", -9},
  {4.2820197377212689815451085e+00, 19, "42820197377212689815", 1},
  {1.4144042410086013487324174e-18, 14, "", -14},
  {3.8585780891802795622425037e+02, 3, "385858", 3},
  {3.4998627665644012451171875e+11, 0, "349986276656", 12},
  {9.5682699464220647561640831e-03, 11, "956826995", -2},
  {1.5994479609432376410730232e-16, 1, "", -1},
  {2.2957235340171348854561130e-12, 15, "2296", -11},
  {3.6597700494540354355200000e+20, 15, "365977004945403543552", 21},
  {1.6806408696125638564738783e-15, 16, "17", -14},
  {1.4559251213500221100090253e-19, 7, "", -7},
  {8.9659658609607745935930998e-10, 1, "", -1},
  {4.4304266096004952000000000e+16, 4, "44304266096004952", 17},
  {9.2530795106833920000000000e+17, 2, "9253079510683392", 18},
  {1.3142112054497027581101239e-12, 12, "1", -11},
  {1.2863735792161703575402498e+06, 11, "128637357921617036", 7},
  {5.2527944740028629302978516e+09, 18, "5252794474002862930297851563", 10},
  {7.2363078545206680893898010e+07, 5, "7236307854521", 8},
  {1.8057427803481884000000000e+16, 11, "18057427803481884", 17},
  {5.4937556382259006059860375e-14, 3, "", -3},
  {7.2304014607050897615186935e-04, 5, "72", -3},
  {1.1426903770897923968732357e+06, 1, "11426904", 7},
  {4.5757101916882913792505860e+05, 13, "4575710191688291379", 6},
  {1.0800692908585853576660156e+10, 19, "1080069290858585357666015625", 11},
  {1.3874389166099085346495201e-01, 16, "1387438916609909", 0},
  {1.5631369986346571050192116e-24, 14, "", -14},
  {7.0174084447827437698284713e-10, 11, "7", -9},
  {8.3770682196993772250184381e-17, 8, "", -8},
  {2.7670749015853979280166186e+00, 6, "2767075", 1},
  {1.0792610992056122049689293e+07, 12, "1079261099205612205", 8},
  {2.3533367946201786994934082e+09, 14, "235333679462017869949341", 10},
  {1.5675496875031274215025788e-21, 18, "", -18},
  {1.7435106027210074165767484e-03, 5, "174", -2},
  {9.1932180962111046498720375e-14, 10, "", -10},
  {8.1549789365206242060292704e-21, 12, "", -12},
  {8.7608422999146125978905285e-11, 6, "", -6},
  {6.0559346946490493115635550e-09, 17, "605593469", -8},
  {4.8967919299375175512523128e+01, 1, "49", 2},
  {2.9546192175757153280000000e+18, 5, "2954619217575715328", 19},
  {7.7127047691502725879075797e-01, 17, "77127047691502726", 0},
  {2.3443028214505116724540004e-09, 9, "2", -8},
  {6.8480987634419246006022355e-06, 0, "", 0},
  {8.3541482140252162173853528e-15, 2, "", -2},
  {1.0774892445444825088000000e+20, 0, "10774892445444825088", 21},
  {2.7177436447506831538721417e-23, 20, "", -20},
  {2.5303962070968025088000000e+20, 6, "25303962070968025088", 21},
  {4.2696293923854406400000000e+17, 3, "426962939238544064", 18},
  {4.2148535885240383148193359e+09, 7, "42148535885240383", 10},
  {8.5505838205193672329187393e+06, 19, "85505838205193672329187393", 7},
  {9.8298606354134259200000000e+17, 5, "982986063541342592", 18},
  {6.5674302628709203968000000e+20, 15, "65674302628709203968", 21},
  {2.0148949617386275771128656e-16, 6, "", -6},
  {3.3760782809988775000000000e+15, 0, "3376078280998878", 16},
  {1.4494075145411168672673301e-25, 0, "", 0},
  {4.9874556596823944091796875e+10, 1, "498745565968", 11},
  {1.8214698911135129383493270e-22, 11, "", -11},
  {4.5136623205858552502457112e-20, 10, "", -10},
  {3.6080383059799409246315049e-25, 7, "", -7},
  {1.7791613140044412434740916e-09, 19, "1779161314", -8},
  {3.1989996420974721908569336e+09, 0, "3198999642", 10},
  {6.2045448207788660763416747e-14, 3, "", -3},
  {3.3732242399715364038676152e-19, 16, "", -16},
  {1.7618813125716670464000000e+19, 3, "17618813125716670464", 20},
  {2.0302071792673848688744061e-24, 18, "", -18},
  {3.2226488842932794796070084e+04, 5, "3222648884", 5},
  {8.2970697009982440000000000e+15, 1, "8297069700998244", 16},
  {2.9708712039543257790581996e-25, 8, "", -8},
  {7.7416903546686746674442811e-19, 18, "1", -17},
  {2.1036598250946941375732422e+09, 7, "21036598250946941", 10},
  {4.6904622472341663635288104e-19, 9, "", -9},
  {2.6986881636000055930004164e-17, 16, "", -16},
  {3.8547461916072707176208496e+09, 3, "3854746191607", 10},
  {3.0236101826876071037601923e-15, 13, "", -13},
  {6.2724622231861346304000000e+19, 11, "62724622231861346304", 20},
  {4.3438205585091781616210938e+09, 17, "434382055850917816162109375", 10},
  {4.7824453665748096000000000e+17, 17, "47824453665748096", 18},
  {9.5168688833685025572776794e+07, 19, "951686888336850255727767944", 8},
  {1.5624496169581877657600000e+20, 16, "156244961695818776576", 21},
  {1.1611079492687256518889706e-05, 12, "11611079", -4},
  {7.9825473638830376007409995e-10, 15, "798255", -9},
  {3.9541937236578915000000000e+15, 5, "39541937236578915", 16},
  {2.5702828135379502177238464e+08, 5, "2570282813538", 9},
  {2.4906859247006876975114671e-21, 13, "", -13},
  {4.1824764846316680000000000e+16, 17, "4182476484631668", 17},
  {1.7900001487223579406738281e+10, 0, "17900001487", 11},
  {3.1134897937317019047405686e-22, 17, "", -17},
  {3.0028676764777380973100662e+07, 18, "30028676764777380973100662", 8},
  {3.6836406684473376000000000e+17, 6, "36836406684473376", 18},
  {1.1352219698836990013238151e-13, 12, "", -12},
  {2.1330367078622693988165793e+00, 3, "2133", 1},
  {1.1096407104261525296535991e-07, 20, "11096407104262", -6},
  {8.0881356895192562500000000e+14, 5, "808813568951925625", 15},
  {7.2323080168236672751727776e-25, 0, "", 0},
  {1.0191286210267131317645505e-22, 2, "", -2},
  {5.0111115692853803396265757e-07, 1, "", -1},
  {4.4929460194704461205787029e-12, 14, "449", -11},
  {7.4810551303246542848888538e-25, 15, "", -15},
  {3.4645010139396790194155074e+00, 9, "3464501014", 1},
  {5.6156486253998564235359544e-12, 15, "5616", -11},
  {8.0271229723704194560071536e-07, 10, "8027", -6},
  {2.7247489186792942047119141e+10, 17, "2724748918679294204711914063", 11},
  {5.0014712384966505854491249e-16, 13, "", -13},
  {1.5010531861794427037239075e+08, 19, "1501053186179442703723907471", 9},
  {7.0814484907780741737667997e-12, 17, "708145", -11},
  {1.1472390850048241019248962e+08, 4, "1147239085005", 9},
  {3.3785013673128512343877678e-14, 8, "", -8},
  {5.2338326879455909779181866e-01, 15, "523383268794559", 0},
  {6.4109709105699739666306414e+03, 13, "6410970910569974", 4},
  {1.0016756020727975845336914e+10, 6, "10016756020727976", 11},
  {2.0918335681049077350400000e+20, 2, "209183356810490773504", 21},
  {1.9572183322060892581939697e+09, 9, "1957218332206089258", 10},
  {4.5065757701249902056488035e-15, 9, "", -9},
  {5.5004049802297982995712336e-24, 18, "", -18},
  {7.6121566256150754783981544e-16, 19, "7612", -15},
  {2.6131412844519998905923330e+00, 0, "3", 1},
  {1.7131737301912288614799152e-19, 6, "", -6},
  {8.8952307770598579200000000e+17, 18, "889523077705985792", 18},
  {1.7510833863878761881838209e-03, 17, "175108338638788", -2},
  {2.2600290902208228000000000e+16, 3, "22600290902208228", 17},
  {2.6815043413300755999948342e-23, 11, "", -11},
  {9.2455372359371170043945312e+10, 18, "924553723593711700439453125", 11},
  {7.8505275313930564148171206e-15, 8, "", -8},
  {9.4464962867860887508166539e-11, 7, "", -7},
  {3.0609966857479654252529144e+07, 1, "306099669", 8},
  {2.5306240201935329437255859e+10, 15, "25306240201935329437255859", 11},
  {3.2456644962323362825159280e-24, 0, "", 0},
  {4.8215041432266173936868048e-13, 11, "", -11},
  {2.6930505972871893644332886e+08, 16, "2693050597287189364433289", 9},
  {2.8582068998426013696000000e+19, 0, "28582068998426013696", 20},
  {2.6999276534030882438283190e-18, 9, "", -9},
  {5.6484337243149003906250000e+12, 0, "5648433724315", 13},
  {3.1264403040820558089762926e+04, 13, "312644030408205581", 5},
  {9.5369582423932538889182375e-15, 5, "", -5},
  {4.9605350074803839574967643e-07, 0, "", 0},
  {2.1988600724699107105579367e-17, 19, "22", -16},
  {3.6502241898267515625000000e+13, 4, "365022418982675156", 14},
  {3.7647219607076952000000000e+16, 1, "37647219607076952", 17},
  {1.3107883161693098068237305e+10, 10, "131078831616930980682", 11},
  {3.2930569656191340000000000e+16, 0, "3293056965619134", 17},
  {1.5738507879082956800000000e+17, 13, "157385078790829568", 18},
  {1.7197624727139367634393956e-11, 19, "171976247", -10},
  {3.6560373250792760000000000e+15, 17, "3656037325079276", 16},
  {1.8085101415562000870704651e+08, 14, "18085101415562000870705", 9},
  {3.0036489861643476562500000e+13, 17, "300364898616434765625", 14},
  {5.6854448708717725807613189e-08, 17, "5685444871", -7},
  {3.7838727556558581365493647e-24, 16, "", -16},
  {7.9329973486014216201323647e-10, 20, "79329973486", -9},
  {2.8195698091738374355631445e-09, 8, "", -8},
  {1.6834933592102734718792210e-21, 5, "", -5},
  {5.4888159325389675000000000e+14, 8, "54888159325389675", 15},
  {3.7488121478116110665723681e+05, 16, "3748812147811611066572", 6},
  {3.7055988478531053098574688e-02, 16, "370559884785311", -1},
  {3.1145164887141573784997110e-23, 19, "", -19},
  {5.5747497932375809177756310e+06, 3, "5574749793", 7},
  {2.6441064508597980416992304e-21, 0, "", 0},
  {1.4048685472608611235045828e+04, 0, "14049", 5},
  {1.1716663185351689159870148e+08, 5, "11716663185352", 9},
  {5.7185061632879326171875000e+12, 5, "571850616328793262", 13},
  {2.4253866327565520896000000e+19, 8, "24253866327565520896", 20},
  {7.6026488861172177734375000e+12, 5, "760264888611721777", 13},
  {1.0411326954595790848000000e+19, 5, "10411326954595790848", 20},
  {2.1029053197794414537346685e-07, 13, "2102905", -6},
  {1.0056473534447659397680698e-12, 7, "", -7},
  {1.6540249608351352124970890e-21, 0, "", 0},
  {9.9128490464120848115087939e-22, 15, "", -15},
  {2.0697887688267889225353133e-20, 13, "", -13},
  {4.1165393087912639202841092e+02, 6, "411653931", 3},
  {2.0016592987361805344857099e-13, 2, "", -2},
  {9.5670902120473496422721566e-23, 4, "", -4},
  {4.6072275630861357421875000e+12, 18, "46072275630861357421875", 13},
  {8.4383437138188529014587402e+08, 15, "843834371381885290145874", 9},
  {6.0336311383489072907335482e-13, 13, "6", -12},
  {1.2835038351271707597334171e+03, 12, "1283503835127171", 4},
  {7.9868510065475156807224266e+03, 19, "79868510065475156807224", 4},
  {3.2699596020337455175321500e-18, 3, "", -3},
  {7.0766899919974891520000000e+19, 6, "7076689991997489152", 20},
  {2.6150879806445555692288324e-18, 4, "", -4},
  {3.5858502397499603200000000e+17, 4, "358585023974996032", 18},
  {1.2162020643243856430053711e+09, 5, "121620206432439", 10},
  {2.8487628543604402343750000e+13, 12, "2848762854360440234375", 14},
  {4.6191601332679943197191512e-06, 2, "", -2},
  {4.6934418150286447887110313e-15, 3, "", -3},
  {2.5889251271668100363830086e-16, 20, "25889", -15},
  {3.3575405817329638987020541e-22, 8, "", -8},
  {6.5758256785579037386924028e+05, 17, "65758256785579037386924", 6},
  {9.0382838578366929936647178e-04, 17, "90382838578367", -3},
  {5.2957653982146834711897121e-03, 17, "529576539821468", -2},
  {2.7782466318129907938392800e-18, 15, "", -15},
  {1.2804281108628621875000000e+14, 11, "12804281108628621875", 15},
  {1.3911805741406307344724516e-08, 13, "139118", -7},
  {3.6157283395579426157460284e-09, 0, "", 0},
  {1.8627486231558933854103088e+08, 11, "18627486231558933854", 9},
  {3.6063047662773235863564758e-07, 10, "3606", -6},
  {1.7383073709377477891096886e-11, 7, "", -7},
  {2.2457757957993123909545830e+01, 8, "2245775796", 2},
  {4.3604213737358674649007028e-24, 15, "", -15},
  {9.1330072584808779911174500e-23, 12, "", -12},
  {1.1336674975845288966461900e-25, 6, "", -6},
  {8.0457838871904406773086429e-13, 16, "8046", -12},
  {1.7721904056617515743710101e+05, 1, "177219", 6},
  {5.0906500513547906250000000e+14, 19, "5090650051354790625", 15},
  {5.6827531277433438208000000e+20, 6, "56827531277433438208", 21},
  {1.5721074484029734833577014e-13, 15, "157", -12},
  {7.1974819507706110435774072e-03, 17, "719748195077061", -2},
  {4.6234737621270179748535156e+09, 6, "4623473762127018", 10},
  {1.0210188887185790720000000e+18, 1, "1021018888718579072", 19},
  {7.5019020800702763865447726e-19, 1, "", -1},
  {7.5380104077624340057373047e+09, 19, "75380104077624340057373046875", 10},
  {9.8878240191541441617140151e-02, 8, "9887824", -1},
  {1.6321125092491881744376371e-16, 14, "", -14},
  {7.8193630213449522852897644e+07, 13, "781936302134495228529", 8},
  {2.1009349978721797500000000e+15, 12, "210093499787217975", 16},
  {9.0102068480790857731141039e-06, 0, "", 0},
  {2.6608788486403990878240148e-16, 3, "", -3},
  {1.2469001117384763765123885e-12, 18, "12469", -11},
  {2.8562745971976835384224452e-10, 13, "2856", -9},
  {1.4034799261310615129029922e-25, 14, "", -14},
  {4.2895845487840180297011794e-13, 7, "", -7},
  {1.0000066130859136250000000e+15, 4, "1000006613085913625", 16},
  {9.1337983500723947116739510e+00, 4, "91338", 1},
  {1.2641411154411150933457586e-03, 5, "126", -2},
  {5.1197836414971641856000000e+20, 10, "51197836414971641856", 21},
  {5.3306210968711466193781234e+03, 2, "533062", 4},
  {2.3997241119556002318859100e+07, 13, "239972411195560023189", 8},
  {8.5395932998722912323158213e-19, 2, "", -2},
  {1.6794703717507111773166173e-01, 11, "16794703718", 0},
  {4.1748877712521224975585938e+10, 13, "417488777125212249755859", 11},
  {5.2856098794309504330158234e+07, 8, "528560987943095", 8},
  {4.3660332176719472477794797e-13, 9, "", -9},
  {6.5262223430555887520313263e+07, 11, "6526222343055588752", 8},
  {3.3387573767871600832369478e-23, 11, "", -11},
  {1.9114678894224001776298849e-04, 6, "191", -3},
  {1.0044343006516250365514914e-10, 15, "100443", -9},
  {7.6163906149102449417114258e+07, 8, "7616390614910245", 8},
  {4.7496154157886562500000000e+12, 20, "474961541578865625", 13},
  {2.2486206276670280159162824e-20, 15, "", -15},
  {2.9549407615747303962707520e+09, 14, "295494076157473039627075", 10},
  {1.5785516064446952095753935e-24, 7, "", -7},
  {1.7002502200037701313856120e-03, 19, "17002502200037701", -2},
  {4.2012781094323479437575736e-17, 16, "", -16},
  {2.1815564600265339031543147e-20, 11, "", -11},
  {4.3069709127689881250000000e+14, 4, "4306970912768988125", 15},
  {1.6469835547930358041992587e-11, 0, "", 0},
  {1.3624476808534758165478706e+07, 7, "136244768085348", 8},
  {2.0398428793651024193422927e+02, 8, "20398428794", 3},
  {1.5804153287783274496000000e+19, 12, "15804153287783274496", 20},
  {1.5811455786030194715454514e-12, 5, "", -5},
  {7.9264513508161530063650778e-12, 5, "", -5},
  {2.0102204127676434375000000e+14, 0, "201022041276764", 15},
  {3.6645925642556006131565554e-08, 2, "", -2},
  {2.1418341798995312000000000e+16, 12, "21418341798995312", 17},
  {6.5834626244890205383300781e+10, 2, "6583462624489", 11},
  {6.6674603250732120000000000e+15, 16, "6667460325073212", 16},
  {9.3213048846971213242807442e-16, 4, "", -4},
  {3.0510222512508395187909496e-24, 14, "", -14},
  {4.5975689840721343986074798e-17, 3, "", -3},
  {1.4872475209643442541760736e-12, 10, "", -10},
  {3.3550045733837581865601790e-17, 14, "", -14},
  {6.5872907156634845184000000e+19, 20, "65872907156634845184", 20},
  {4.3286897471692264080047607e+06, 17, "432868974716922640800476", 7},
  {4.3485895276876151951815621e-15, 13, "", -13},
  {4.6323271793081927490234375e+11, 18, "46323271793081927490234375", 12},
  {2.3340896156193737226002688e-05, 20, "2334089615619374", -4},
  {1.5519186007061312000000000e+16, 16, "15519186007061312", 17},
  {1.0563818135795658454298973e+06, 10, "10563818135795658", 7},
  {5.5525875142701681648766739e-24, 5, "", -5},
  {2.6862922258306812586803325e-03, 20, "268629222583068126", -2},
  {1.7300451876344110351055861e+06, 9, "1730045187634411", 7},
  {8.1014282990318397440000000e+18, 1, "8101428299031839744", 19},
  {3.3027063396972000000000000e+14, 0, "33027063396972", 15},
  {6.5421514117325320839881897e+07, 18, "65421514117325320839881897", 8},
  {3.1152302205736155826798495e+01, 8, "3115230221", 2},
  {2.1340045252405365964800000e+20, 3, "213400452524053659648", 21},
  {7.6500833431663590306331252e-06, 15, "7650083343", -5},
  {4.4937476098970477775784244e-10, 16, "4493748", -9},
  {3.0752543854772307200000000e+17, 16, "307525438547723072", 18},
  {1.1374189761309317768405752e-24, 1, "", -1},
  {9.1438990866658836603164673e+07, 15, "91438990866658836603165", 8},
  {3.9905293179640944194764768e-09, 17, "399052932", -8},
  {2.9111138221231711714631629e-02, 8, "2911114", -1},
  {5.6474529604702868178748007e-12, 18, "5647453", -11},
  {3.2534544581902085850136212e-08, 10, "325", -7},
  {2.1029767126091103633342763e-24, 7, "", -7},
  {1.3680762412654642202623686e-10, 12, "137", -9},
  {2.7997125193522175471431726e-22, 2, "", -2},
  {7.1978342352826929505724610e-12, 9, "", -9},
  {1.4254995417805338409067417e+00, 19, "14254995417805338409", 1},
  {6.3690694029486245142379630e+01, 12, "63690694029486", 2},
  {1.8458284289842423917854066e-24, 0, "", 0},
  {1.0098362469705021484375000e+13, 1, "10098362469705", 14},
  {4.7804925235341918043452218e-06, 16, "47804925235", -5},
  {3.2356641444580150693277609e-03, 6, "3236", -2},
  {1.7921097923985031461514384e-20, 13, "", -13},
  {1.6681977394030142283353921e-14, 9, "", -9},
  {4.8097901034546724864000000e+20, 12, "48097901034546724864", 21},
  {1.8583483086832616497296720e-16, 13, "", -13},
  {1.8449724655789569556098643e-17, 15, "", -15},
  {8.0146902026535737917356528e+00, 13, "80146902026536", 1},
  {6.0900409441995725501328707e+03, 6, "6090040944", 4},
  {6.3531038983459020528243855e+03, 10, "63531038983459", 4},
  {1.0187908267616740707142177e-05, 17, "1018790826762", -4},
  {1.8428562816925117052767596e-22, 17, "", -17},
  {1.8905140352513169636949897e+05, 6, "189051403525", 6},
  {3.9794286052083869265061367e+01, 0, "4", 2},
  {1.0523086823712764160000000e+18, 15, "1052308682371276416", 19},
  {1.5199920421013373480340070e-03, 3, "2", -2},
  {2.7679671388016945119173590e-17, 17, "3", -16},
  {8.5577567258063201904296875e+09, 6, "855775672580632", 10},
  {1.2671207999058164978027344e+11, 14, "12671207999058164978027344", 12},
  {2.5939315846672277450561523e+09, 16, "25939315846672277450561523", 10},
  {7.7096731813243435205995129e-23, 0, "", 0},
  {4.8165407384531370828352478e-10, 17, "48165407", -9},
  {1.4511390255998575238294279e+00, 6, "1451139", 1},
  {2.8555669279233846813440323e+07, 14, "2855566927923384681344", 8},
  {1.6217450540969672228698788e-18, 11, "", -11},
  {4.0757500463818313596320309e-01, 11, "40757500464", 0},
  {7.6660184070591889916339496e-09, 7, "", -7},
  {2.0290158575483159937874433e-25, 10, "", -10},
  {1.9044035993065421052961028e+01, 15, "19044035993065421", 2},
  {1.6277335750116390408948064e+05, 4, "1627733575", 6},
  {1.0998089468417659931700299e-12, 10, "", -10},
  {1.8715871323807761229807145e-03, 16, "18715871323808", -2},
  {8.7754144009249117225408554e+06, 13, "87754144009249117225", 7},
  {1.1768687048914203643798828e+10, 14, "1176868704891420364379883", 11},
  {8.2601053041136511197505036e-13, 19, "8260105", -12},
  {2.3294430564104643683794168e-09, 9, "2", -8},
  {4.2461747672331119283077560e-19, 9, "", -9},
  {9.5551533449048520196811296e+00, 5, "955515", 1},
  {3.7311571305923354811966419e+06, 13, "37311571305923354812", 7},
  {8.0030184046427588206995551e-02, 0, "", 0},
  {1.9795781280219658613374873e-08, 1, "", -1},
  {3.8484537934212833642959595e+07, 1, "384845379", 8},
  {2.3585657991647044000000000e+16, 1, "23585657991647044", 17},
  {1.2597665323214278400000000e+17, 20, "125976653232142784", 18},
  {3.9563071580047987508416130e-05, 3, "", -3},
  {4.8749798413684949689575150e-14, 8, "", -8},
  {1.2513346422682070988230407e+05, 15, "125133464226820709882", 6},
  {1.2896182999500911403600867e+00, 12, "128961829995", 1},
  {7.1629274583448067129066127e-06, 3, "", -3},
  {3.2775315573400983122642760e-03, 3, "3", -2},
  {5.1052150808003846400000000e+17, 10, "510521508080038464", 18},
  {2.3471683503447247020300137e-04, 8, "23472", -3},
  {4.3621227566777314166301949e+00, 13, "43621227566777", 1},
  {3.3579351628634320714531783e-07, 4, "", -4},
  {1.3564441431917015343468063e-14, 1, "", -1},
  {6.3402840366375567391514778e+06, 16, "63402840366375567391515", 7},
  {5.3584588763646472755999167e-14, 12, "", -12},
  {1.4134066534809769984000000e+19, 5, "14134066534809769984", 20},
  {2.6631732378368434906005859e+10, 15, "26631732378368434906005859", 11},
  {2.3846086059013005358663171e-13, 15, "238", -12},
  {4.1031764678102172760887356e-01, 5, "41032", 0},
  {1.1961788677608889728194253e-15, 5, "", -5},
  {1.1788617496140839821621362e-13, 1, "", -1},
  {1.9083975616237022765453446e-02, 18, "19083975616237023", -1},
  {1.0157361829884038000000000e+16, 12, "10157361829884038", 17},
  {2.6851156743636832236663320e-17, 14, "", -14},
  {1.2492717202133060681096566e-21, 16, "", -16},
  {5.3656824014187109375000000e+13, 14, "53656824014187109375", 14},
  {5.5950820079534182127645181e+01, 14, "5595082007953418", 2},
  {2.5168741897146166109683009e-17, 1, "", -1},
  {1.9358463681806690794770731e-16, 12, "", -12},
  {3.8744255041258335000000000e+15, 19, "38744255041258335", 16},
  {9.6761408851099762210648345e-18, 19, "97", -17},
  {1.0978808729525822999495871e-07, 2, "", -2},
  {5.4254842423397473990917206e+07, 19, "542548424233974739909172058", 8},
  {8.1017696361252189952523641e-21, 13, "", -13},
  {2.6509370962347260501701385e+04, 15, "26509370962347260502", 5},
  {3.7177163806220560628090418e-23, 19, "", -19},
  {4.3250581564553832536953845e-23, 3, "", -3},
  {8.2827514512102834915516366e-08, 8, "8", -7},
  {3.0193544580082340530515097e-08, 19, "301935445801", -7},
  {5.3233034078751457280000000e+20, 17, "5323303407875145728", 21},
  {1.2402713801066206359863281e+11, 20, "1240271380106620635986328125", 12},
  {6.6100936135994701180607080e+05, 19, "6610093613599470118060708", 6},
  {1.7085319783212064000000000e+16, 12, "17085319783212064", 17},
  {3.9545352819843210849711105e-22, 15, "", -15},
  {8.3123965821253625563258538e+02, 10, "8312396582125", 3},
  {3.9232901673504454083740711e+06, 10, "39232901673504454", 7},
  {2.2707278047462176365235405e-07, 20, "22707278047462", -6},
  {7.6758606413930840790271759e+05, 3, "767586064", 6},
  {1.7327696826191175602776412e-05, 1, "", -1},
  {3.6256395200397850036621094e+10, 19, "3625639520039785003662109375", 11},
  {2.9050299663052068523141746e-15, 4, "", -4},
  {6.3150573486449253834962292e+01, 20, "6315057348644925383496", 2},
  {3.2907253987587956736000000e+19, 15, "32907253987587956736", 20},
  {1.7481306174331816759643097e-12, 0, "", 0},
  {1.9255640770579847753651848e+02, 4, "1925564", 3},
  {5.9881258264865266809592713e-17, 2, "", -2},
  {5.0083130522532171033262016e-08, 11, "5008", -7},
  {3.9144203632873047259871379e-16, 18, "391", -15},
  {5.2734408555228623046875000e+12, 20, "52734408555228623046875", 13},
  {2.5921624366000389370008875e-15, 20, "259216", -14},
  {7.9257350618678140625000000e+13, 18, "79257350618678140625", 14},
  {5.5528746056370416989914768e-05, 1, "", -1},
  {3.0319494733414318847656250e+11, 15, "3031949473341431884765625", 12},
  {1.8027106900829877170654523e-11, 14, "1803", -10},
  {4.4680217696294134946639581e-19, 6, "", -6},
  {4.2902751421274256706237793e+08, 7, "4290275142127426", 9},
  {8.8456056299758468312914806e-16, 6, "", -6},
  {1.7024198115299527293391323e-15, 15, "2", -14},
  {1.2549619793121970581784019e-04, 4, "1", -3},
  {6.0257125333025726689683502e-07, 0, "", 0},
  {3.0672998375410651306083309e+02, 19, "3067299837541065130608", 3},
  {5.2004433163127032506486183e-19, 15, "", -15},
  {1.7444260057671244800000000e+17, 20, "174442600576712448", 18},
  {8.5870510410714225145056844e+04, 6, "85870510411", 5},
  {1.2174593183881941135180926e-17, 19, "122", -16},
  {2.5932532205201216000000000e+16, 7, "25932532205201216", 17},
  {3.6747904957092386744733187e-08, 15, "36747905", -7},
  {6.4503270400854851434394228e-24, 15, "", -15},
  {2.5948854619402457031250000e+13, 16, "2594885461940245703125", 14},
  {1.6113068360923190887150358e-05, 11, "1611307", -4},
  {2.8014683824169046566510133e+00, 5, "280147", 1},
  {8.0432305155471783564280486e+02, 7, "8043230516", 3},
  {2.8319096675617572600458516e+02, 17, "283190966756175726", 3},
  {1.2369935057438841852217593e+02, 2, "1237", 3},
  {4.6751587507141102417515078e-13, 15, "468", -12},
  {2.8016548362316332290983890e-10, 6, "", -6},
  {1.4270214234258040941317389e-09, 7, "", -7},
  {8.7043075447380623360000000e+19, 18, "8704307544738062336", 20},
  {1.9026097112473558809142560e+04, 20, "1902609711247355880914256", 5},
  {8.1196666593219910230833374e-09, 4, "", -4},
  {8.0156744113986628701110893e-14, 12, "", -12},
  {2.9349787373580658015049407e-17, 3, "", -3},
  {4.2178594038276106875720984e-12, 7, "", -7},
  {9.5289298050208984375000000e+10, 14, "95289298050208984375", 11},
  {1.4981462917204797946624240e+01, 10, "149814629172", 2},
  {2.0168513529620644303766763e-10, 13, "2017", -9},
  {1.5104691837910016116112294e-05, 15, "15104691838", -4},
  {1.4275526811454340165041149e-19, 18, "", -18},
  {1.1107105512649222241907459e-11, 19, "111071055", -10},
  {3.3491035092315224854300770e-05, 3, "", -3},
  {2.4084439116610599739942700e+04, 10, "240844391166106", 5},
  {5.8280123012721024110336183e-21, 1, "", -1},
  {3.9171534419417796134948730e+09, 14, "391715344194177961349487", 10},
  {4.6919548983374528448517249e-04, 8, "4692", -3},
  {3.4243144294314611193394415e-04, 16, "3424314429431", -3},
  {4.3778767271763998270034790e+08, 14, "43778767271763998270035", 9},
  {3.9743969386715548256725170e-10, 8, "", -8},
  {2.6916386206712389270030649e-15, 1, "", -1},
  {6.7927001534180645625520716e-07, 3, "", -3},
  {3.0448036117011725000000000e+15, 5, "30448036117011725", 16},
  {4.2032935261390669488061723e-10, 15, "420329", -9},
  {2.1216532111002720415996540e-18, 9, "", -9},
  {1.5744253146555321875000000e+14, 7, "15744253146555321875", 15},
  {3.3445949290944154691236474e-16, 17, "33", -15},
  {2.1170335639152146875000000e+14, 9, "21170335639152146875", 15},
  {9.5686272306900638533660815e-23, 0, "", 0},
  {6.2870462719332603454589844e+10, 19, "6287046271933260345458984375", 11},
  {2.8387250504549657264314816e-23, 11, "", -11},
  {8.7370815180355344000000000e+16, 12, "87370815180355344", 17},
  {5.2218025869490276136275497e+01, 15, "52218025869490276", 2},
  {6.2775097938807226666818995e-13, 4, "", -4},
  {2.2906778927354620726208384e-25, 7, "", -7},
  {4.3596019923141625000000000e+14, 12, "43596019923141625", 15},
  {4.8747615945632037698735562e-21, 4, "", -4},
  {1.5566021949221704803235675e-16, 10, "", -10},
  {1.2026628154571328415691454e-05, 18, "12026628154571", -4},
  {1.3624378722124531250000000e+12, 4, "13624378722124531", 13},
  {2.5557314505706171875000000e+12, 17, "25557314505706171875", 13},
  {2.4226141872279244315890878e-01, 13, "2422614187228", 0},
  {3.6609782540150905600000000e+17, 5, "366097825401509056", 18},
  {2.2603774250820295000000000e+15, 19, "22603774250820295", 16},
  {6.9758490074447953125000000e+13, 7, "69758490074447953125", 14},
  {6.4014668065976064453125000e+12, 12, "64014668065976064453125", 13},
  {7.5083719188615148887038231e+06, 9, "7508371918861515", 7},
  {5.1823087359515742187500000e+12, 7, "51823087359515742188", 13},
  {6.3525685317785025984489746e-13, 11, "", -11},
  {1.5202629684828333118653313e-21, 16, "", -16},
  {1.6684432564301256090402603e+07, 14, "166844325643012560904", 8},
  {3.2701123039387103271484375e+11, 9, "327011230393871032715", 12},
  {4.0819290811550099085103227e-02, 11, "4081929081", -1},
  {2.3792141501692906377154521e-15, 18, "2379", -14},
  {6.3583245925236450195312500e+11, 11, "63583245925236450195313", 12},
  {3.0876802469551068774530168e-08, 10, "309", -7},
  {1.4941303365891663736920132e-23, 18, "", -18},
  {1.1765675605920751616000000e+19, 4, "11765675605920751616", 20},
  {2.4432499309669654846191406e+10, 1, "244324993097", 11},
  {7.0115651649649947881698608e+07, 16, "701156516496499478816986", 8},
  {6.0620007087362505495548248e+07, 16, "606200070873625054955482", 8},
  {7.8334843807884180932887830e+02, 2, "78335", 3},
  {1.9315243339510839160055866e+00, 15, "1931524333951084", 1},
  {2.6291193080490974199519395e-15, 3, "", -3},
  {1.0601282380497278931593265e-09, 7, "", -7},
  {1.6980818856189761536000000e+19, 15, "16980818856189761536", 20},
  {2.2175282962674859375000000e+13, 18, "22175282962674859375", 14},
  {1.2250604562118597412109375e+11, 14, "12250604562118597412109375", 12},
  {1.9227122523853982030694887e-03, 15, "1922712252385", -2},
  {8.0387776297644584756539154e-09, 3, "", -3},
  {2.5206984518437347645117871e-19, 14, "", -14},
  {3.6245863610424381440000000e+19, 18, "3624586361042438144", 20},
  {1.8871819416907812113310456e-09, 15, "1887182", -8},
  {3.2363738755246865234375000e+12, 14, "32363738755246865234375", 13},
  {5.1558695435092730712890625e+11, 8, "51558695435092730713", 12},
  {1.1497530736982160100905259e-13, 12, "", -12},
  {2.3147649193298294647419544e-04, 4, "2", -3},
  {1.3430374071324780135729426e-23, 13, "", -13},
  {1.4689827073656479797263784e-16, 12, "", -12},
  {6.3043317498766240234375000e+12, 13, "63043317498766240234375", 13},
  {4.5244301446011689904480590e+00, 1, "45", 1},
  {9.2082618795188946089817615e-12, 11, "1", -10},
  {5.9094079752529421833517724e-06, 13, "5909408", -5},
  {3.1994716184972503327660354e-04, 2, "", -2},
  {4.6029053916371118975803256e+05, 1, "4602905", 6},
  {4.6546855289482396684802404e-10, 7, "", -7},
  {6.1427977035373060310519122e-02, 2, "6", -1},
  {8.7368368450170603129027917e-13, 12, "1", -11},
  {1.0974624678535650018602610e+06, 6, "1097462467854", 7},
  {8.5408079833518187627263772e-12, 9, "", -9},
  {1.3643639117929227650165558e+07, 0, "13643639", 8},
  {3.8562326268107135009765625e+11, 0, "385623262681", 12},
  {3.9381838110576173056000000e+19, 9, "39381838110576173056", 20},
  {3.0123308923776519804960117e+04, 7, "301233089238", 5},
  {4.8125160277951436800000000e+18, 20, "481251602779514368", 19},
  {4.7457050182603804687500000e+13, 3, "47457050182603805", 14},
  {1.4446594787475042500000000e+15, 19, "144465947874750425", 16},
  {1.0313349110427178955078125e+11, 8, "10313349110427178955", 12},
  {1.0402657924590909268804574e-17, 17, "1", -16},
  {6.4289273144388396174575078e-24, 19, "", -19},
  {6.5122142020346207193492180e-07, 1, "", -1},
  {2.1155835795454689280000000e+19, 0, "2115583579545468928", 20},
  {2.5200748437188115200000000e+17, 11, "252007484371881152", 18},
  {7.2421416048039577600000000e+17, 6, "724214160480395776", 18},
  {1.8421323129305495975466072e-25, 16, "", -16},
  {7.4276326158693752288818359e+09, 15, "7427632615869375228881836", 10},
  {2.2062797845434061962532760e-08, 13, "220628", -7},
  {5.7269319002960473299026489e+06, 8, "572693190029605", 7},
  {4.8081926042634048000000000e+17, 11, "48081926042634048", 18},
  {3.6141873631828161887824535e+05, 1, "3614187", 6},
  {4.8543666778787520000000000e+17, 4, "4854366677878752", 18},
  {1.0474292450225521949213444e-17, 0, "", 0},
  {3.5610195691047242139582601e-06, 2, "", -2},
  {6.9261622092492244269154023e-16, 13, "", -13},
  {6.7633973178412299988484905e-08, 5, "", -5},
  {1.8596480337004643200000000e+17, 13, "185964803370046432", 18},
  {3.5419494346030028000000000e+16, 1, "35419494346030028", 17},
  {1.9501639689583382991817928e-06, 9, "195", -5},
  {8.4317976294089158147502376e-21, 19, "", -19},
  {5.7418361393585382757009938e+03, 6, "5741836139", 4},
  {8.3766078662594796423032332e-22, 3, "", -3},
  {1.4075330606076582000000000e+16, 9, "14075330606076582", 17},
  {7.0098735851056398437500000e+13, 1, "700987358510564", 14},
  {3.0286241143841000614500934e-22, 10, "", -10},
  {5.3292409257051406770663386e-25, 13, "", -13},
  {3.3178460681076516261556186e-03, 5, "332", -2},
  {6.9077494341791113281250000e+11, 7, "6907749434179111328", 12},
  {3.6470583198520228778301178e-23, 9, "", -9},
  {1.3377884404403086662122042e-14, 5, "", -5},
  {1.1924822660907456464381248e-09, 13, "11925", -8},
  {8.3169183057573693440000000e+18, 14, "8316918305757369344", 19},
  {1.5294402112462189765537484e-20, 11, "", -11},
  {6.0485232557009306487233043e-15, 1, "", -1},
  {6.8293545128189343261718750e+11, 3, "682935451281893", 12},
  {5.9361097030081600678386167e+02, 7, "5936109703", 3},
  {1.0291865637572959375000000e+14, 19, "10291865637572959375", 15},
  {3.4402186748625862656000000e+19, 15, "34402186748625862656", 20},
  {6.5721695339148795062179280e-07, 3, "", -3},
  {1.3722964721364835470343745e-11, 20, "1372296472", -10},
  {1.8221876115942862033843994e+09, 10, "18221876115942862034", 10},
  {4.0201994092058002934209071e+03, 13, "40201994092058003", 4},
  {3.7672902636510738894060069e+00, 13, "37672902636511", 1},
  {6.5358451062243037500000000e+14, 9, "653584510622430375", 15},
  {2.4084669557124812059199543e-14, 4, "", -4},
  {5.3626236691598250000000000e+14, 13, "5362623669159825", 15},
  {6.1202482348499745445913334e-02, 19, "612024823484997454", -1},
  {1.3319441148701086425781250e+12, 15, "1331944114870108642578125", 13},
  {3.6311394393437394334113074e-12, 14, "363", -11},
  {6.8491577617386345799834243e-20, 18, "", -18},
  {3.2143903896283681049008007e-15, 5, "", -5},
  {8.3381958580868625203200000e+20, 9, "833819585808686252032", 21},
  {2.6658922836780119687318802e+07, 11, "2665892283678011969", 8},
  {1.9282039689922015531919897e+05, 6, "192820396899", 6},
  {5.8633857123205776214599609e+09, 3, "5863385712321", 10},
  {2.3670918211668185889720917e+07, 1, "236709182", 8},
  {2.4515830556245971526489229e-20, 19, "", -19},
  {1.6479417354675169950735717e-07, 20, "16479417354675", -6},
  {2.2166305298431685120000000e+18, 6, "2216630529843168512", 19},
  {1.8309408540271476736000000e+20, 17, "18309408540271476736", 21},
  {9.6475488428030082843633863e+00, 1, "96", 1},
  {1.7011202213105636182888247e-01, 14, "17011202213106", 0},
  {1.0110184599537375767602207e-10, 9, "", -9},
  {9.4166485589318653369960048e-09, 16, "94166486", -8},
  {1.8182544130054129061235813e-04, 1, "", -1},
  {2.9890474209534266930775618e-24, 15, "", -15},
  {1.9372646801969614028800000e+20, 17, "193726468019696140288", 21},
  {5.0014971168293188476562500e+11, 19, "500149711682931884765625", 12},
  {1.5149027468483156739863628e-06, 16, "15149027468", -5},
  {1.5281690961006144472525681e-19, 7, "", -7},
  {1.4967798404366547200000000e+17, 19, "149677984043665472", 18},
  {1.7350567972810859375000000e+12, 0, "1735056797281", 13},
  {4.6833203579329951704579571e-01, 2, "47", 0},
  {1.7573282462028050422668457e+09, 15, "1757328246202805042266846", 10},
  {5.7000509510496025211701010e-02, 6, "57001", -1},
  {1.2988436697754738660711098e-18, 2, "", -2},
  {1.6565431607485993243605899e-19, 17, "", -17},
  {3.0654104813603125000000000e+11, 4, "3065410481360313", 12},
  {8.3602225007712229727728070e-07, 10, "836", -6},
  {1.5519698096124500162725572e-19, 15, "", -15},
  {2.7066198361220249600000000e+17, 18, "270661983612202496", 18},
  {7.4402578450987648000000000e+17, 18, "74402578450987648", 18},
  {5.1096506928361002904722538e-05, 2, "", -2},
  {2.2808292802742088233922634e-22, 2, "", -2},
  {1.9783187140574667500000000e+15, 7, "197831871405746675", 16},
  {1.1083299424806839369436751e-20, 9, "", -9},
  {1.0369421656816567910400000e+20, 4, "103694216568165679104", 21},
  {8.1150486855145179419370265e-22, 16, "", -16},
  {4.2417439949291318337554917e-07, 3, "", -3},
  {4.6889226747629725000000000e+14, 6, "46889226747629725", 15},
  {2.9598032173056342652225373e-23, 2, "", -2},
  {2.2461248724756599403917789e+06, 20, "224612487247565994039177895", 7},
  {2.8466561763864612579345703e+10, 20, "28466561763864612579345703125", 11},
  {7.9221829918568265045027172e-21, 19, "", -19},
  {8.7810687422174005885078382e-17, 9, "", -9},
  {1.2303048473181591856264524e-07, 4, "", -4},
  {1.5088461338988473529202578e-18, 9, "", -9},
  {1.0229178139638235136000000e+20, 13, "10229178139638235136", 21},
  {7.6519978670393515687020928e-25, 1, "", -1},
  {3.8902282450475527175395461e-25, 18, "", -18},
  {5.4589373839426136303387693e-02, 4, "546", -1},
  {3.1379063309497233481644143e-12, 6, "", -6},
  {2.2314432141520507131149528e-08, 10, "223", -7},
  {2.6172860910975800822554365e-09, 4, "", -4},
  {2.5258470714525506710301392e-22, 4, "", -4},
  {7.4260849870435724761701529e-20, 8, "", -8},
  {2.3647813202944640625000000e+13, 20, "23647813202944640625", 14},
  {1.1403553952453425152000000e+19, 18, "11403553952453425152", 20},
  {5.5105386357616734094300170e-02, 2, "6", -1},
  {1.7507748891429837528589434e-22, 17, "", -17},
  {6.1685939167848599483249053e-06, 0, "", 0},
  {3.4653577916387860688608854e-07, 12, "346536", -6},
  {8.8678182792842421875000000e+12, 5, "886781827928424219", 13},
  {4.7922777900236108268236523e-04, 16, "4792277790024", -3},
  {3.0468065944426457600000000e+17, 11, "304680659444264576", 18},
  {1.7679769469506838504457846e+04, 14, "176797694695068385", 5},
  {1.6913174935649394114989263e+01, 14, "1691317493564939", 2},
  {1.2906791945924137065272335e-21, 4, "", -4},
  {9.1745325054565198464526499e-13, 0, "", 0},
  {1.1684025819786164537829412e-11, 3, "", -3},
  {7.5902549848539872179285100e-11, 3, "", -3},
  {8.1658202606281216073824680e-01, 13, "8165820260628", 0},
  {5.9515155756362050000000000e+14, 15, "5951515575636205", 15},
  {6.3339643670872215270996094e+10, 12, "63339643670872215270996", 11},
  {1.3592641426460803222656250e+11, 7, "1359264142646080322", 12},
  {7.8186549718047056319568389e-05, 16, "78186549718", -4},
  {2.5188110656723129068268463e+04, 17, "2518811065672312906827", 5},
  {5.3597890122982015659314214e-02, 14, "5359789012298", -1},
  {9.3154312810429251712207588e-01, 9, "931543128", 0},
  {7.2881252533738168320000000e+18, 8, "7288125253373816832", 19},
  {3.2822421971414886150640988e-15, 20, "328224", -14},
  {7.5770508196256599744493721e-10, 15, "757705", -9},
  {1.9533585268314903974533081e+08, 13, "1953358526831490397453", 9},
  {7.9317332130628943674396656e-24, 4, "", -4},
  {1.7890621005508234890633515e-08, 1, "", -1},
  {3.7969603709555847167968750e+11, 17, "3796960370955584716796875", 12},
  {8.2279042091281577944755554e+07, 3, "82279042091", 8},
  {1.1009951469065237790346146e+07, 20, "1100995146906523779034614563", 8},
  {2.1692419305603181290543826e-14, 14, "2", -13},
  {1.0582689346318113621236989e+03, 0, "1058", 4},
  {1.6533434713188456448000000e+19, 15, "16533434713188456448", 20},
  {4.1739965026994972630003389e-02, 12, "41739965027", -1},
  {2.1059543272442152500000000e+15, 14, "210595432724421525", 16},
  {3.9068225742753853212387765e-25, 17, "", -17},
  {1.5331455606240752430452364e-15, 15, "2", -14},
  {1.2911723437705859375000000e+13, 3, "12911723437705859", 14},
  {1.1958099769304634471528463e-11, 15, "11958", -10},
  {6.2807040602877893066406250e+11, 20, "6280704060287789306640625", 12},
  {2.8051488437596947200000000e+17, 1, "280514884375969472", 18},
  {2.6279557548729557363089864e-12, 1, "", -1},
  {2.0310237767928435200000000e+18, 12, "203102377679284352", 19},
  {8.5967626829402190935446733e-16, 5, "", -5},
  {6.3190125651105132217778939e-10, 11, "63", -9},
  {4.0542531221944377861632347e+00, 8, "405425312", 1},
  {5.3591526763066560000000000e+16, 0, "5359152676306656", 17},
  {1.0442551731208916340978995e-08, 13, "104426", -7},
  {3.6967157920925717917270958e+04, 5, "3696715792", 5},
  {3.5373660163695614290003868e-12, 7, "", -7},
  {2.5202733883094115299172699e+05, 0, "252027", 6},
  {3.5840354882323073593131113e-02, 11, "3584035488", -1},
  {4.3723204458977681105738301e-22, 3, "", -3},
  {1.7027909059330668117837604e+00, 11, "170279090593", 1},
  {2.2260658696097132544000000e+19, 6, "22260658696097132544", 20},
  {4.6918435387744931250000000e+14, 13, "4691843538774493125", 15},
  {8.8108856018942764282226562e+10, 13, "881088560189427642822266", 11},
  {4.1088373378243487500000000e+14, 19, "410883733782434875", 15},
  {6.6680967532695164062500000e+13, 15, "666809675326951640625", 14},
  {1.6918513292394063219835880e-12, 9, "", -9},
  {4.3716746405545868626229614e-21, 11, "", -11},
  {1.0996607010001362425555271e+00, 0, "1", 1},
  {4.4192778028573932647705078e+09, 5, "441927780285739", 10},
  {1.1845230729026155520000000e+18, 17, "1184523072902615552", 19},
  {6.8670375274203232000000000e+16, 17, "68670375274203232", 17},
  {1.2031911212813716360869876e+02, 2, "12032", 3},
  {6.5104973971603465080261230e+08, 9, "651049739716034651", 9},
  {2.3183176637019705570967773e-09, 0, "", 0},
  {2.4536444734684599097818136e+05, 1, "2453644", 6},
  {1.1578246652286845993815146e-14, 5, "", -5},
  {7.6817183890557604980468750e+11, 12, "768171838905576049804688", 12},
  {1.9473096391296518207838015e-18, 11, "", -11},
  {1.1194592285238928998400000e+20, 12, "111945922852389289984", 21},
  {1.3423616487541723332728336e-09, 10, "13", -8},
  {9.1363620662222530560000000e+18, 19, "9136362066222253056", 19},
  {8.9653362898857770747960558e-22, 6, "", -6},
  {9.2063176192856383499440322e-25, 9, "", -9},
  {2.0210962998907014448910516e-25, 4, "", -4},
  {1.8120544957941092808172134e-04, 5, "18", -3},
  {2.4272415495564871533660714e-13, 14, "24", -12},
  {2.0658100820385715365409851e+08, 20, "20658100820385715365409851074", 9},
  {2.1593727479625658281883162e-23, 16, "", -16},
  {1.0054424983709468018965277e-19, 8, "", -8},
  {3.6668503365345165440070119e-03, 12, "3666850337", -2},
  {1.5021244223936624640000000e+19, 18, "1502124422393662464", 20},
  {8.5075196157956641136808776e-23, 13, "", -13},
  {3.7902336737178804766508354e-10, 11, "38", -9},
  {1.8178897256463262266379388e+00, 1, "18", 1},
  {1.2335290576392110046052770e-23, 9, "", -9},
  {1.4379602965217103057804952e-14, 1, "", -1},
  {1.0246421381670327857136726e+07, 12, "10246421381670327857", 8},
  {7.5964088406460208000000000e+16, 20, "75964088406460208", 17},
  {5.7028325287657707116374642e-21, 10, "", -10},
  {1.5018473207775699903488940e-22, 15, "", -15},
  {2.9220097253948530273437500e+12, 19, "292200972539485302734375", 13},
  {1.0087272551054381880100665e-14, 14, "1", -13},
  {1.6350242660618358000000000e+16, 16, "16350242660618358", 17},
  {2.4749034666319702400000000e+17, 6, "247490346663197024", 18},
  {2.1614144053149824950424156e-21, 15, "", -15},
  {1.8356837780287011840000000e+18, 9, "1835683778028701184", 19},
  {1.1214432398254167051189248e-24, 13, "", -13},
  {1.7086126274307182484335499e+03, 15, "1708612627430718248", 4},
  {5.7786491393914521600000000e+18, 20, "577864913939145216", 19},
  {2.9313197848523277154664767e-17, 8, "", -8},
  {7.7084521819517699270741513e-20, 5, "", -5},
  {6.8437929981551273574400000e+20, 1, "684379299815512735744", 21},
  {8.6772002934071689678280943e-12, 16, "86772", -11},
  {1.0641097709232636048950630e-09, 9, "1", -8},
  {8.9413903567328559133995335e-12, 9, "", -9},
  {1.5416887908491971875000000e+14, 7, "15416887908491971875", 15},
  {2.8943998973202155866601970e+03, 20, "28943998973202155866602", 4},
  {6.6476977478370269499596476e-20, 8, "", -8},
  {6.9842806984678219350826112e+01, 14, "6984280698467822", 2},
  {1.9215176896084549371153116e+06, 16, "19215176896084549371153", 7},
  {1.0703893709299154155760529e-13, 2, "", -2},
  {5.4225858287307482910156250e+11, 16, "5422585828730748291015625", 12},
  {7.5751453535010850429534912e+08, 20, "75751453535010850429534912109", 9},
  {1.0956946259609673764156893e-11, 1, "", -1},
  {2.4146968024198564000000000e+16, 3, "24146968024198564", 17},
  {1.0717905026033842409705077e-04, 0, "", 0},
  {1.1944651097293543424000000e+19, 10, "11944651097293543424", 20},
  {8.3971026875613581528786507e-12, 15, "8397", -11},
  {2.1796822612306191974400000e+20, 5, "217968226123061919744", 21},
  {5.6107180903137057612184435e+04, 7, "561071809031", 5},
  {3.7366654285603358178083555e-16, 14, "", -14},
  {1.5469057746251000000000000e+13, 11, "15469057746251", 14},
  {2.7087984187564093356470127e-22, 16, "", -16},
  {1.2366218461254063700101302e-04, 2, "", -2},
  {3.9072060564307038392255141e-13, 7, "", -7},
  {5.6543005398837804794311523e+09, 8, "565430053988378048", 10},
  {8.3949668360508961565777130e-14, 3, "", -3},
  {1.6880261998147613182256394e-11, 4, "", -4},
  {8.8456925160595621801649125e-20, 1, "", -1},
  {1.6752561427966165180656662e-10, 1, "", -1},
  {3.3911512301275093750000000e+13, 4, "339115123012750938", 14},
  {8.1251866618296197941617720e+00, 4, "81252", 1},
  {2.4290882712387186156705737e-05, 4, "", -4},
  {1.0216960633993057500000000e+15, 16, "102169606339930575", 16},
  {5.3106436311396606250000000e+14, 17, "5310643631139660625", 15},
  {6.0335507119180149736204471e-16, 17, "6", -15},
  {1.6849701934253633909588507e-22, 18, "", -18},
  {7.7654759833967316419472529e-22, 8, "", -8},
  {7.5169834266751274009995014e-07, 19, "7516983426675", -6},
  {3.2605364479878734540463370e-01, 1, "3", 0},
  {3.4810852002360990239526045e-05, 16, "348108520024", -4},
  {5.3093495481248723905444203e-08, 2, "", -2},
  {6.6365652565418347716331482e+07, 11, "6636565256541834772", 8},
  {6.7760087666562352176451156e-05, 8, "6776", -4},
  {1.9061359904545462834784464e-24, 18, "", -18},
  {2.9832024411603837506845593e+04, 5, "2983202441", 5},
  {5.4410183260037557843183637e-23, 4, "", -4},
  {1.0006522749296056130784007e-23, 5, "", -5},
  {1.6418375357175707579583497e-14, 12, "", -12},
  {3.8413730332458758311986458e+03, 7, "38413730332", 4},
  {1.3927623778603835105895996e+09, 4, "13927623778604", 10},
  {1.4448263804661054143551941e-22, 16, "", -16},
  {2.6086250559607219696044922e+10, 15, "26086250559607219696044922", 11},
  {1.0743916290197452483442642e-17, 4, "", -4},
  {4.8383807931225257812500000e+13, 11, "483838079312252578125", 14},
  {2.7619716104534241390977556e-03, 4, "28", -2},
  {1.4772394377051994120884717e-25, 1, "", -1},
  {1.4899446693878274757590245e-16, 0, "", 0},
  {1.0195724445715735782869160e+05, 4, "1019572445", 6},
  {1.2573088322335102020588238e+03, 19, "12573088322335102020588", 4},
  {7.4254197635171609801135899e-25, 17, "", -17},
  {1.1462610660994928638460312e-17, 18, "11", -16},
  {1.3192949374988534924104678e-19, 1, "", -1},
  {8.3767676668843188414470546e-02, 19, "837676766688431884", -1},
  {1.1266355035004446506500244e+09, 6, "1126635503500445", 10},
  {3.5136301353978085376000000e+19, 8, "35136301353978085376", 20},
  {9.0671000725847713791349631e-17, 20, "9067", -16},
  {4.6224405584201101889534894e-20, 6, "", -6},
  {4.4761928803869881008488997e-25, 5, "", -5},
  {2.8595198802475792169570923e+08, 18, "285951988024757921695709229", 9},
  {4.8713808386976581443761347e-01, 19, "4871380838697658144", 0},
  {7.8981907651228280437284758e-09, 16, "78981908", -8},
  {2.4848272828517594713051587e-21, 2, "", -2},
  {8.5161896521068975000000000e+14, 17, "85161896521068975", 15},
  {2.2273616797727772791404277e+03, 17, "222736167977277727914", 4},
  {9.5410691479143616000000000e+17, 4, "95410691479143616", 18},
  {1.1044033120803114109463079e-11, 11, "1", -10},
  {6.5779192363902245232790353e-19, 4, "", -4},
  {8.8710190457305505871772766e+07, 6, "88710190457306", 8},
  {9.4774750478337909953552298e+02, 20, "94774750478337909953552", 3},
  {2.7164923016853746483200000e+20, 2, "271649230168537464832", 21},
  {8.0053542342514803200000000e+17, 8, "800535423425148032", 18},
  {5.4006169636868983544348866e-08, 10, "54", -7},
  {1.7739192969413401600000000e+17, 9, "177391929694134016", 18},
  {5.3369756399431190936568353e-21, 6, "", -6},
  {2.8842495503496449228800000e+20, 14, "288424955034964492288", 21},
  {1.4079289657922802734375000e+12, 20, "14079289657922802734375", 13},
  {3.6848493010322143750000000e+14, 0, "368484930103221", 15},
  {5.9497875463322789062500000e+13, 5, "5949787546332278906", 14},
  {2.7384066006676213156367794e+00, 6, "2738407", 1},
  {1.4822378790428837765487833e-19, 1, "", -1},
  {1.2672860241711598994062557e-13, 4, "", -4},
  {2.8195973521316477009013290e-03, 15, "2819597352132", -2},
  {5.2385509213958808257747797e-07, 14, "52385509", -6},
  {1.9411616994718026670604244e-06, 8, "194", -5},
  {1.8099487373066823270400000e+20, 13, "180994873730668232704", 21},
  {2.3810706009366828800000000e+17, 5, "238107060093668288", 18},
  {7.8359106733645979987201278e-17, 12, "", -12},
  {4.6033438708460352000000000e+16, 20, "46033438708460352", 17},
  {9.2024698114618523955295743e-07, 20, "92024698114619", -6},
  {2.4333013346844263310844836e-08, 6, "", -6},
  {1.6156515788679194000000000e+16, 10, "16156515788679194", 17},
  {3.3835563275675073491299827e-01, 20, "33835563275675073491", 0},
  {3.9924038712625068564543440e-04, 18, "399240387126251", -3},
  {8.1610689933697734129057147e-20, 5, "", -5},
  {5.4086739672275070852397479e-21, 19, "", -19},
  {3.8094508001254739010873075e-06, 20, "380945080012547", -5},
  {2.1909354832889493554830551e+06, 1, "21909355", 7},
  {2.4337091733096518632081915e-07, 4, "", -4},
  {2.4659710771458013916015625e+11, 3, "24659710771458", 12},
  {5.6117625400939657537368217e-24, 13, "", -13},
  {1.1074412129587141162545549e+00, 3, "1107", 1},
  {5.5629654901098888886617541e-15, 2, "", -2},
  {5.4431384936429623312071955e-11, 19, "544313849", -10},
  {2.5094990368544492187500000e+12, 5, "250949903685444922", 13},
  {1.7383363524285263407298530e-02, 3, "17", -1},
  {6.4116475497562161487647584e-11, 12, "64", -10},
  {2.9233992973303870536442795e-17, 0, "", 0},
  {1.0406113497500576145007574e-20, 12, "", -12},
  {2.0360221687278585409642225e-08, 11, "2036", -7},
  {1.1022257843086503924481310e-23, 1, "", -1},
  {5.9235767847438721024000000e+19, 13, "59235767847438721024", 20},
  {8.8840660847232643716071684e-15, 18, "8884", -14},
  {2.7084912602081376462592743e+03, 4, "27084913", 4},
  {3.4428089962960420000000000e+16, 6, "3442808996296042", 17},
  {3.5950575546896258553875025e-03, 6, "3595", -2},
  {1.7799557117310648320000000e+20, 7, "1779955711731064832", 21},
  {5.0815055514843414130154997e+04, 15, "5081505551484341413", 5},
  {6.5356856873559571977686758e-08, 4, "", -4},
  {5.3821774000264800254873972e-07, 6, "1", -5},
  {5.6201446979310343277091988e-02, 4, "562", -1},
  {1.4424191223808620000000000e+16, 15, "1442419122380862", 17},
  {5.1802117710504520000000000e+16, 5, "5180211771050452", 17},
  {5.0713971852468987838074080e-06, 12, "5071397", -5},
  {1.7559705688966713555570837e-21, 10, "", -10},
  {6.6992667561607144411675266e-15, 5, "", -5},
  {1.5716037550578482520635681e-03, 0, "", 0},
  {3.0547664512650101603652431e-02, 12, "30547664513", -1},
  {6.2782051166842103004455566e+08, 11, "62782051166842103004", 9},
  {1.1463577905968041051780811e-20, 0, "", 0},
  {2.7669142784546348829169617e-17, 3, "", -3},
  {1.2232239526881520450115204e+08, 1, "1223223953", 9},
  {2.2847194559943626780580059e-22, 11, "", -11},
  {4.6945613937555077427532524e+04, 5, "4694561394", 5},
  {3.7639270337095994782968685e-20, 14, "", -14},
  {7.3221758331291487500000000e+14, 17, "732217583312914875", 15},
  {2.0135296164318873253197600e-21, 14, "", -14},
  {3.0506014539738571329507977e+04, 2, "3050601", 5},
  {4.5463741663887623515194327e-09, 11, "455", -8},
  {1.2244006959675931386512730e-11, 6, "", -6},
  {1.5830773905868503333930347e-07, 7, "2", -6},
  {1.0242450687591407430352076e-21, 15, "", -15},
  {4.8944383387989097841892762e-13, 4, "", -4},
  {2.7120186572080950906818517e-08, 8, "3", -7},
  {2.0964404508447634277343750e+12, 18, "2096440450844763427734375", 13},
  {2.4551989734312644217093120e-11, 16, "24552", -10},
  {1.7461353235773503154599336e-25, 13, "", -13},
  {1.4303456913025783691406250e+12, 16, "1430345691302578369140625", 13},
  {3.6453749578217689020220860e+01, 2, "3645", 2},
  {5.3580024832025134833153874e-09, 9, "5", -8},
  {7.7281947260407213215812154e-22, 16, "", -16},
  {5.0143723604607405140995979e+06, 15, "50143723604607405141", 7},
  {5.9443509236722464650612831e-20, 6, "", -6},
  {1.0935655824101365490058072e-11, 8, "", -8},
  {1.2186527428568891657255212e-11, 0, "", 0},
  {2.0984521938167679024928125e-10, 19, "2098452194", -9},
  {3.0091501939928399872000000e+19, 13, "30091501939928399872", 20},
  {3.6655070291798859834671021e+07, 8, "3665507029179886", 8},
  {3.9431283322456377744674683e+08, 3, "394312833225", 9},
  {1.3988697407902476213863525e-22, 19, "", -19},
  {1.3089782965318470087368041e+05, 13, "1308978296531847009", 6},
  {1.0525673555727852000000000e+16, 5, "10525673555727852", 17},
  {9.3682033199504224356791183e-22, 17, "", -17},
  {3.5730188004849656416096093e-24, 6, "", -6},
  {2.3924633844079199218750000e+13, 12, "2392463384407919921875", 14},
  {3.8382124307277204480000000e+18, 10, "3838212430727720448", 19},
  {1.8716730812794024372711317e-23, 20, "", -20},
  {1.1079782282902344933106506e-16, 1, "", -1},
  {2.7472773717547328000000000e+16, 12, "27472773717547328", 17},
  {3.2644568389934367587557063e+04, 2, "3264457", 5},
  {8.7357797134859752655029297e+08, 2, "87357797135", 9},
  {7.0521949752670180000000000e+15, 5, "7052194975267018", 16},
  {1.5583375286344724893569946e+08, 10, "1558337528634472489", 9},
  {1.6222089647342800896000000e+19, 9, "16222089647342800896", 20},
  {5.6819071490239021056000000e+19, 0, "56819071490239021056", 20},
  {2.6970034929304933593750000e+13, 2, "2697003492930493", 14},
  {1.4120946171899913679226302e+03, 10, "141209461719", 4},
  {3.7902897673931103099138201e-06, 6, "4", -5},
  {5.9423128349473525855852299e-06, 15, "5942312835", -5},
  {6.6795495646514118433703261e-24, 20, "", -20},
  {5.0479746562884104000000000e+16, 14, "50479746562884104", 17},
  {3.0684340012854603381992523e-10, 13, "3068", -9},
  {8.6447224343849247956921286e-22, 18, "", -18},
  {7.9694518312936617933444080e-23, 8, "", -8},
  {4.0489382478144557502214700e-18, 3, "", -3},
  {1.3797751394086966939332712e-20, 18, "", -18},
  {3.7117459616024595000000000e+15, 2, "37117459616024595", 16},
  {1.6522638548566082560000000e+18, 10, "1652263854856608256", 19},
  {1.0844027939415507200000000e+18, 9, "108440279394155072", 19},
  {3.3802247880136384000000000e+17, 2, "33802247880136384", 18},
  {2.2922414688348396875000000e+14, 1, "229224146883484", 15},
  {3.1685859529405399040000000e+18, 13, "3168585952940539904", 19},
  {2.1479817176895879001592357e-05, 10, "214798", -4},
  {2.2394668312676241951227110e-19, 16, "", -16},
  {1.7053048495909703680000000e+19, 3, "1705304849590970368", 20},
  {1.6818260570618347796902532e-15, 3, "", -3},
  {6.0601709970604222127432692e-03, 17, "606017099706042", -2},
  {2.2711986160361107456000000e+19, 11, "22711986160361107456", 20},
  {1.4206841451290272500000000e+15, 8, "142068414512902725", 16},
  {2.3622977453453484733276028e-15, 19, "23623", -14},
  {9.0162327831395744359710420e-02, 8, "9016233", -1},
  {5.4419513876566788005819290e-09, 3, "", -3},
  {1.5227336442078412604100456e-10, 4, "", -4},
  {2.8866289592293624000000000e+16, 18, "28866289592293624", 17},
  {2.5874722929508725770284809e-23, 1, "", -1},
  {2.7502661138433877378702164e+07, 10, "275026611384338774", 8},
  {1.3344582290776807833600000e+20, 1, "133445822907768078336", 21},
  {3.5678089597391422236877635e-22, 18, "", -18},
  {2.6714434920630768000000000e+17, 7, "26714434920630768", 18},
  {3.1426012371334252293308964e+02, 19, "3142601237133425229331", 3},
  {4.8998326903685253906250000e+11, 9, "489983269036852539063", 12},
  {5.0030782270251642294847332e-13, 0, "", 0},
  {3.1202341240386400000000000e+16, 7, "312023412403864", 17},
  {3.3049350212040731200602295e+00, 7, "3304935", 1},
  {4.9170954409763089643092826e+02, 14, "4917095440976309", 3},
  {3.1782408492391990180620463e-10, 12, "318", -9},
  {3.0487938408545906250000000e+14, 5, "3048793840854590625", 15},
  {2.3722603004045285785600000e+20, 2, "237226030040452857856", 21},
  {4.5241624132594513471149894e-05, 2, "", -2},
  {3.2325075228680680959897232e-15, 1, "", -1},
  {3.0960680532338820264963927e-16, 18, "31", -15},
  {4.4553194660228043159471577e-14, 12, "", -12},
  {2.9345997026756340649983185e-25, 10, "", -10},
  {1.1859988120382186402410225e-08, 10, "119", -7},
  {6.0807595194456408691406250e+11, 7, "6080759519445640869", 12},
  {2.9175922070564367073923815e-25, 4, "", -4},
  {1.8376464965580546487557705e-11, 5, "", -5},
  {4.7691485752258668713818662e-13, 0, "", 0},
  {4.0603467118659913860189219e-12, 15, "406", -11},
  {3.2352793320479820426429328e-06, 14, "323527933", -5},
  {9.5926656407622461126518960e-13, 19, "9592666", -12},
  {1.0409397929328559340156346e-03, 5, "104", -2},
  {2.4516300072218388805822542e-01, 14, "24516300072218", 0},
  {6.6822919833404540000000000e+15, 0, "6682291983340454", 16},
  {3.3159016802810964977948441e-14, 3, "", -3},
  {6.6541048510610024297870707e-19, 16, "", -16},
  {2.1852994055473935527054536e-22, 8, "", -8},
  {2.2668305170252474579269899e-23, 9, "", -9},
  {6.1212616361484720000000000e+15, 11, "6121261636148472", 16},
  {3.8317778998880271450510584e-13, 9, "", -9},
  {4.2940788248709484800000000e+17, 13, "429407882487094848", 18},
  {2.3639140889013189697265625e+11, 19, "23639140889013189697265625", 12},
  {2.4230352096715757070910513e-01, 4, "2423", 0},
  {8.2422801519395932555198669e+06, 12, "8242280151939593256", 7},
  {2.3280141006241353807126870e+02, 2, "2328", 3},
  {3.0341692752308637696000000e+19, 0, "30341692752308637696", 20},
  {6.2867661560922884558810786e-04, 17, "62867661560923", -3},
  {4.8084725246727668750000000e+14, 5, "4808472524672766875", 15},
  {1.1854086277165171899901601e-25, 6, "", -6},
  {2.8523780286012684800000000e+17, 13, "285237802860126848", 18},
  {9.7541756185040226108859114e-08, 4, "", -4},
  {5.9962279593597252717724678e-17, 15, "", -15},
  {7.2849625756009963369004859e-19, 5, "", -5},
  {3.0751363171272797468469573e-03, 16, "30751363171273", -2},
  {5.5506371460803017704363678e-18, 0, "", 0},
  {5.7646487002111380391638389e-08, 0, "", 0},
  {1.4128041813920596868323578e-15, 3, "", -3},
  {2.2232819714167118071692259e-10, 15, "222328", -9},
  {6.5561042407482794658335479e+00, 4, "65561", 1},
  {8.5169103163928762025998753e-23, 20, "", -20},
  {1.3208363564883509533926600e-08, 10, "132", -7},
  {4.2123367932219254374400000e+20, 3, "421233679322192543744", 21},
  {5.7347102413276134029729292e+03, 11, "573471024132761", 4},
  {4.2530381343121853205957450e+03, 0, "4253", 4},
  {1.4490725263462699508198310e-23, 20, "", -20},
  {3.9259937019130993840834720e-04, 6, "393", -3},
  {6.2935973320301153877100751e-21, 14, "", -14},
  {6.4380968915866601531838853e-02, 8, "6438097", -1},
  {2.8241104559705513182206986e-12, 11, "", -11},
  {1.4924958265712311913375743e+04, 6, "14924958266", 5},
  {1.1444186373450826171875000e+13, 14, "11444186373450826171875", 14},
  {3.9423607562692893679923145e+01, 6, "39423608", 2},
  {1.0936426425621247060515628e-01, 3, "109", 0},
  {7.5587770581232302902208176e+02, 0, "756", 3},
  {5.0940132250875153760562314e-20, 15, "", -15},
  {4.7622611111882092285156250e+11, 4, "4762261111188209", 12},
  {5.0947775289997907469120634e-11, 19, "509477753", -10},
  {4.4528410203234752417350562e-04, 3, "", -3},
  {2.9365402610288139465010478e-08, 11, "2937", -7},
  {9.3712748128094172477722168e+08, 0, "937127481", 9},
  {9.7194393173179183254006830e-01, 3, "972", 0},
  {4.1615665717254496000000000e+17, 0, "41615665717254496", 18},
  {1.3387379212685134000000000e+16, 1, "13387379212685134", 17},
  {1.6832821791370593750000000e+13, 2, "1683282179137059", 14},
  {4.7813419788538531065569259e+03, 2, "478134", 4},
  {8.0588168333223721563018059e-15, 9, "", -9},
  {7.5312297947221862792968750e+11, 16, "7531229794722186279296875", 12},
  {3.2522567124200281625523434e-03, 4, "33", -2},
  {1.7744354874719048591936740e-11, 5, "", -5},
  {1.2182045991747022102580349e-20, 0, "", 0},
  {1.4938051855349742553292533e-11, 15, "14938", -10},
  {2.4070519375284521484375000e+12, 10, "24070519375284521484375", 13},
  {4.0992546443814869538421962e-15, 5, "", -5},
  {6.7469506456161954186928326e-16, 5, "", -5},
  {1.2125617667913251259602598e-06, 8, "121", -5},
  {1.2603114182471921667456627e+07, 7, "126031141824719", 8},
  {2.5836397172143296000000000e+16, 10, "25836397172143296", 17},
  {1.1321046034186477080751585e-11, 0, "", 0},
  {4.7849450003653210931200000e+20, 8, "478494500036532109312", 21},
  {1.4974014256798693898070362e-18, 18, "1", -17},
  {5.1115511802659769058227539e+09, 10, "51115511802659769058", 10},
  {1.2268988005497951660156250e+12, 7, "1226898800549795166", 13},
  {4.7472044151909063065600000e+20, 7, "474720441519090630656", 21},
  {9.9166377003408215387025848e+03, 10, "99166377003408", 4},
  {2.6719997666800210746349887e-08, 14, "2672", -7},
  {1.4209942641027873371207907e-15, 7, "", -7},
  {4.1184142542846468750000000e+13, 10, "4118414254284646875", 14},
  {2.3024497294857666560000000e+19, 7, "2302449729485766656", 20},
  {6.0973759751727441325783730e+06, 17, "609737597517274413257837", 7},
  {8.3859714876551987500000000e+14, 8, "838597148765519875", 15},
  {6.6749550713665100097656250e+10, 2, "6674955071367", 11},
  {1.0580503646310431582276699e-22, 18, "", -18},
  {1.4082798989501181495143101e+04, 10, "140827989895012", 5},
  {9.4326967455902928184580415e-09, 9, "9", -8},
  {1.1991609231697130000000000e+16, 9, "1199160923169713", 17},
  {3.6301416565232400165858401e-08, 13, "363014", -7},
  {1.7197930768838848903748535e-17, 9, "", -9},
  {2.7483380997249740040899724e-01, 12, "274833809972", 0},
  {6.2099614230329287052154541e+08, 9, "620996142303292871", 9},
  {5.8677025804960176183716972e-07, 3, "", -3},
  {1.4515197857087091051764283e-03, 5, "145", -2},
  {1.0534300944669065438306301e-22, 6, "", -6},
  {5.1131555048219739150321923e-11, 15, "51132", -10},
  {2.7411923432473095927405634e-21, 5, "", -5},
  {3.3337783408560331017698594e-21, 13, "", -13},
  {2.3429167617727029369585970e-05, 6, "23", -4},
  {1.9843832951927007632012435e-07, 3, "", -3},
  {1.1005052932843583897600000e+20, 6, "110050529328435838976", 21},
  {3.7973238975292773437500000e+13, 16, "379732389752927734375", 14},
  {1.3245678358420480309773586e-19, 17, "", -17},
  {9.0735266049772836267948151e+06, 11, "907352660497728363", 7},
  {1.5833253477791340628755279e+04, 19, "158332534777913406287553", 5},
  {1.4145550615638541103180614e+01, 10, "141455506156", 2},
  {9.2822766023387536000000000e+16, 1, "92822766023387536", 17},
  {1.5097185250352816865415662e+02, 1, "151", 3},
  {4.0177510368718799746491439e-17, 6, "", -6},
  {1.9819158522981259751016331e-13, 2, "", -2},
  {3.6704494139350384784847847e+02, 5, "36704494", 3},
  {2.4288036892451578751206398e+05, 6, "242880368925", 6},
  {5.0354324101486760412171861e+01, 9, "50354324101", 2},
  {9.0591721766818809555843472e+04, 10, "905917217668188", 5},
  {1.1562308087671661057069032e-24, 13, "", -13},
  {1.8339115855145728588104248e+09, 12, "183391158551457285881", 10},
  {3.4342659982817630437423873e-01, 18, "343426599828176304", 0},
  {7.9678856156812881417206285e-03, 3, "8", -2},
  {8.3197981525545076485900209e-04, 0, "", 0},
  {5.9176763046150030277203768e+04, 0, "59177", 5},
  {1.3801454197972431011482764e-24, 16, "", -16},
  {3.9739193519759787319213386e-22, 11, "", -11},
  {5.6199833525869720458984375e+10, 17, "56199833525869720458984375", 11},
  {2.6340575698885797528703279e+00, 19, "26340575698885797529", 1},
  {5.0811993130153017600000000e+17, 18, "508119931301530176", 18},
  {1.2187071608461001493053589e-20, 13, "", -13},
  {1.5452219542807416992187500e+12, 14, "154522195428074169921875", 13},
  {5.0523419100473747046400000e+20, 10, "505234191004737470464", 21},
  {1.5510758451153721744261468e-21, 2, "", -2},
  {6.4348793663567241206241786e-23, 19, "", -19},
  {4.7715800676687621720270545e-21, 9, "", -9},
  {9.8801596351331512500000000e+14, 20, "988015963513315125", 15},
  {8.5577653154792400000000000e+14, 11, "855776531547924", 15},
  {4.3174990145442845480828487e-16, 18, "432", -15},
  {3.4077960122774010000000000e+15, 5, "3407796012277401", 16},
  {3.4757805540694962447939830e-12, 20, "347578055", -11},
  {9.8238274952819262500000000e+14, 17, "982382749528192625", 15},
  {3.4333725672013905294566172e-04, 20, "34333725672013905", -3},
  {1.1246075815932692949485160e-18, 10, "", -10},
  {2.3620256563606887500000000e+14, 11, "236202565636068875", 15},
  {2.8696647232245936574288794e-24, 5, "", -5},
  {2.1465498161655263299695386e-09, 18, "2146549816", -8},
  {1.0650716678374348841615293e-04, 14, "10650716678", -3},
  {3.0723351438984648205986459e-12, 19, "30723351", -11},
  {2.6696660871900375366210938e+10, 6, "26696660871900375", 11},
  {1.1186617451796408814930495e-06, 14, "111866175", -5},
  {2.3945894676040355200000000e+17, 10, "239458946760403552", 18},
  {1.4335792028125103463892021e-19, 6, "", -6},
  {4.4564704519107376000000000e+16, 20, "44564704519107376", 17},
  {1.4583167244148499281166001e-24, 15, "", -15},
  {7.2391138531763474079622022e-24, 20, "", -20},
  {3.6637215053420962869187528e-20, 7, "", -7},
  {1.6245947462529795046748404e+00, 4, "16246", 1},
  {2.3623522658255634234992481e-19, 0, "", 0},
  {1.2085507543661926562500000e+14, 6, "120855075436619265625", 15},
  {3.7517301043415018924065407e-01, 16, "3751730104341502", 0},
  {1.2475604360510568202613513e+00, 9, "1247560436", 1},
  {1.4082286600624641869217157e+06, 5, "140822866006", 7},
  {5.7297064176683187152609246e-09, 0, "", 0},
  {1.9639216969649157945338467e-19, 3, "", -3},
  {3.0638511532671345776179805e+03, 1, "30639", 4},
  {3.3151113717144816406250000e+13, 0, "33151113717145", 14},
  {1.2658836857406442082004853e-23, 16, "", -16},
  {1.0276278736833437696000000e+19, 8, "10276278736833437696", 20},
  {1.5023846862504505000000000e+15, 16, "15023846862504505", 16},
  {4.2460196603266197443008423e+08, 19, "4246019660326619744300842285", 9},
  {4.8228569136996612548828125e+10, 3, "48228569136997", 11},
  {1.7981334148809003829956055e+08, 1, "1798133415", 9},
  {2.3029926820916876558590757e-06, 8, "23", -5},
  {1.5313277471745742500000000e+15, 20, "153132774717457425", 16},
  {1.5039409162420059204101562e+11, 5, "15039409162420059", 12},
  {2.4945428137537858384620111e-08, 5, "", -5},
  {1.4997418720103411200000000e+18, 7, "149974187201034112", 19},
  {6.6811409529770011901855469e+09, 17, "668114095297700119018554688", 10},
  {1.6045195848700580243395564e-01, 5, "16045", 0},
  {2.6675688846371864318847656e+10, 4, "266756888463719", 11},
  {3.5314324401336458638547392e-21, 7, "", -7},
  {2.3618982917403974533081055e+09, 15, "2361898291740397453308105", 10},
  {1.2326185865795574036814524e-10, 14, "12326", -9},
  {1.3954972280846799667200000e+20, 20, "139549722808467996672", 21},
  {4.4044643678300570322899629e-10, 5, "", -5},
  {3.8437159910778376954954347e-23, 5, "", -5},
  {4.4544658369877748191356659e+07, 5, "4454465836988", 8},
  {2.1693502339670125977910686e-01, 13, "2169350233967", 0},
  {1.0319209930639383024634815e-07, 9, "103", -6},
  {1.0988516150172840296807145e-06, 8, "11", -5},
  {5.3837488472301738529434622e-14, 14, "5", -13},
  {2.0117431744871123403678448e-04, 8, "20117", -3},
  {2.5485139069554380000000000e+16, 8, "2548513906955438", 17},
  {1.4322325689764474174504500e-19, 7, "", -7},
  {2.5104748238848531189770715e-19, 3, "", -3},
  {8.5450792776928432000000000e+16, 10, "85450792776928432", 17},
  {3.3883509537682272860781296e-02, 8, "3388351", -1},
  {6.5149327868111126008443534e+04, 3, "65149328", 5},
  {2.7383853080875372252163302e-12, 4, "", -4},
  {2.1333175315231984805419065e-11, 10, "", -10},
  {7.6421758737831992187500000e+12, 13, "764217587378319921875", 13},
  {1.4605625165912616252899170e+08, 20, "14605625165912616252899169922", 9},
  {6.7157886072065004233807663e-16, 8, "", -8},
  {9.9994513043133326846145792e+02, 5, "99994513", 3},
  {3.0801499976590428068382604e-15, 6, "", -6},
  {6.2369516020947094249117385e-18, 12, "", -12},
  {2.6805711293081301264464855e+06, 20, "268057112930813012644648552", 7},
  {1.2360238146870263671875000e+11, 17, "12360238146870263671875", 12},
  {9.7360193819669377803802490e+08, 10, "973601938196693778", 9},
  {1.2170838276982411116478033e+04, 17, "1217083827698241111648", 5},
  {1.8243447403459936051481185e-17, 4, "", -4},
  {1.2365236031517429227122307e-01, 2, "12", 0},
  {2.1992543979594743397863077e-16, 9, "", -9},
  {1.3078724093013034444809163e-23, 5, "", -5},
  {1.3843329976047656889718092e-13, 10, "", -10},
  {3.2276183009428835923512735e-04, 11, "32276183", -3},
  {7.4045078396916527707638522e-02, 20, "7404507839691652771", -1},
  {2.9310005687767224000000000e+16, 13, "29310005687767224", 17},
  {6.6148545749870159011978414e-16, 4, "", -4},
  {7.2803078305387733722718027e-17, 19, "728", -16},
  {4.7651025996581982353888563e-11, 0, "", 0},
  {5.1164523464769312500000000e+14, 20, "511645234647693125", 15},
  {2.7810822791424105474475698e-13, 19, "2781082", -12},
  {4.2217887974015146493911743e+07, 15, "42217887974015146493912", 8},
  {1.1074039269648629094447423e-04, 11, "11074039", -3},
  {1.5752148198477467389011508e+01, 13, "157521481984775", 2},
  {3.7607670547954059044982606e-23, 14, "", -14},
  {8.0952390374604778237060334e-16, 3, "", -3},
  {2.0726975991498875020008444e-24, 10, "", -10},
  {1.0895534249240156873849220e-05, 3, "", -3},
  {1.9637724448877402986358980e-20, 13, "", -13},
  {9.7481819760900415526572171e-04, 20, "97481819760900416", -3},
  {4.1837135918924454017542303e+04, 0, "41837", 5},
  {7.1077344130868075335590112e-22, 3, "", -3},
  {2.5680396034746675290924299e-20, 7, "", -7},
  {1.1307889995490607360000000e+18, 0, "1130788999549060736", 19},
  {1.0968709127664112665685161e-07, 16, "1096870913", -6},
  {5.9048316139932134400000000e+17, 7, "590483161399321344", 18},
  {4.3146415485406739570573009e-04, 16, "4314641548541", -3},
  {2.5342906608846560360559639e-25, 8, "", -8},
  {2.1153272330208761559333652e+04, 11, "2115327233020876", 5},
  {3.1678951658645251686400000e+20, 2, "316789516586452516864", 21},
  {2.9699400938044989440000000e+18, 6, "2969940093804498944", 19},
  {1.6334571136790063117238958e-01, 1, "2", 0},
  {8.3575579531999267769107770e-20, 12, "", -12},
  {2.3685897696197231250000000e+14, 20, "2368589769619723125", 15},
  {1.5257119440252831551713071e-19, 6, "", -6},
  {1.3252549905619184755778406e+02, 18, "132525499056191847558", 3},
  {4.9720299538853020282491713e-02, 15, "49720299538853", -1},
  {1.0355651695924907306519158e-19, 12, "", -12},
  {1.6981394964046277835587051e-04, 20, "16981394964046278", -3},
  {4.6112045395777283216784414e-20, 16, "", -16},
  {7.8972371357427095063030720e+04, 1, "789724", 5},
  {1.2590472743512148736044765e+05, 0, "125905", 6},
  {3.3191780502812322000036948e-21, 8, "", -8},
  {7.8760344887448203074777678e-11, 5, "", -5},
  {8.2101830556196351401920661e-09, 19, "82101830556", -8},
  {1.5259432938141715625000000e+14, 8, "15259432938141715625", 15},
  {1.8070798600617099508446430e-19, 6, "", -6},
  {4.9946311045549644526827274e-21, 19, "", -19},
  {2.1466936661865384960000000e+18, 5, "2146693666186538496", 19},
  {1.2239837137473972167968750e+12, 4, "12239837137473972", 13},
  {8.6622046551067472000000000e+16, 5, "86622046551067472", 17},
  {2.8672367475270903180994964e-02, 19, "286723674752709032", -1},
  {4.0381381747068102400000000e+17, 4, "403813817470681024", 18},
  {1.7121783389217847138693591e-22, 19, "", -19},
  {5.2313160611983299255371094e+10, 7, "523131606119832993", 11},
  {7.0388747297872929746777248e-19, 6, "", -6},
  {9.0214704588318920135498047e+08, 2, "90214704588", 9},
  {1.2989309890572291848748069e-06, 1, "", -1},
  {1.5571923357635215360000000e+20, 20, "1557192335763521536", 21},
  {4.3465168038694379504249810e-03, 16, "43465168038694", -2},
  {1.5978378314231109140369698e-12, 7, "", -7},
  {2.1961698039362939096827863e-20, 2, "", -2},
  {1.0140246154878158308638645e-20, 16, "", -16},
  {1.8100939680670436925433101e-21, 12, "", -12},
  {1.0612695458927575295307855e-16, 4, "", -4},
  {6.1304425691271679583127172e-06, 8, "613", -5},
  {3.2088278747223768130186761e-04, 15, "320882787472", -3},
  {1.3528405263159006834030151e+07, 1, "135284053", 8},
  {2.4412995894253893278094896e-11, 19, "244129959", -10},
  {3.6670837958683027296266243e-20, 10, "", -10},
  {5.8448081852269378691751686e-15, 3, "", -3},
  {1.3918275580601597204804420e+07, 20, "1391827558060159720480442047", 8},
  {8.4468407302488034474663436e+04, 2, "8446841", 5},
  {2.2719646337528793324537710e-05, 12, "22719646", -4},
  {3.8573196302353597057972247e-06, 11, "385732", -5},
  {2.2045060588630802500000000e+15, 5, "220450605886308025", 16},
  {1.6905197198179851562500000e+13, 15, "169051971981798515625", 14},
  {1.4878383967551047372081613e-13, 5, "", -5},
  {4.9205663256144152000000000e+16, 2, "49205663256144152", 17},
  {4.9083421989787320312500000e+13, 16, "490834219897873203125", 14},
  {9.5335482993734949457272361e-24, 13, "", -13},
  {2.4305556171214124800000000e+17, 15, "243055561712141248", 18},
  {1.9586408044729489817600000e+20, 5, "195864080447294898176", 21},
  {1.1321491497350606112367601e-07, 4, "", -4},
  {1.0050639252227060000000000e+16, 10, "1005063925222706", 17},
  {3.1873341860676817595958710e+07, 1, "318733419", 8},
  {4.0598632021365569216926846e-17, 18, "41", -16},
  {1.0876861005475991443086636e-03, 5, "109", -2},
  {9.1295572905391280894491206e-07, 20, "91295572905391", -6},
  {7.4627649305400518642272800e+02, 5, "74627649", 3},
  {8.4169417423617226968753827e-20, 2, "", -2},
  {1.8835045662955913692712784e+07, 17, "1883504566295591369271278", 8},
  {8.1919692614865794078995649e-13, 19, "8191969", -12},
  {1.7750282944560172557830811e+09, 10, "17750282944560172558", 10},
  {5.5771879309251623624277272e+01, 0, "56", 2},
  {8.5851594715694742551183316e-05, 12, "85851595", -4},
  {1.0341929372560403753667899e-10, 17, "10341929", -9},
  {4.3234692766650588989257812e+10, 5, "4323469276665059", 11},
  {1.2559757281694852309134973e-25, 16, "", -16},
  {3.9661838867396270751953125e+10, 10, "39661838867396270752", 11},
  {5.2904904330782832208037561e-21, 16, "", -16},
  {3.8464468538785836800000000e+17, 4, "384644685387858368", 18},
  {2.7080542897851746175774679e+01, 18, "27080542897851746176", 2},
  {5.3795762187532487505311172e-21, 8, "", -8},
  {2.1280851813012727689056192e+03, 4, "21280852", 4},
  {1.6297000098281155628670533e-11, 4, "", -4},
  {2.1269957651237782158110269e-15, 13, "", -13},
  {2.2141491222063495422274829e-16, 18, "221", -15},
  {2.4604617757853148418689671e+01, 15, "24604617757853148", 2},
  {1.8733686158243553875260443e-25, 0, "", 0},
  {6.6356575660316217190140033e-08, 2, "", -2},
  {1.6559818571256595731711059e+01, 13, "165598185712566", 2},
  {8.5947339452906444668769836e+07, 9, "85947339452906445", 8},
  {3.6491668331784873962402344e+10, 14, "3649166833178487396240234", 11},
  {9.3302868995806054197572621e-01, 0, "1", 1},
  {7.0676149191627406250000000e+13, 11, "7067614919162740625", 14},
  {9.4728725485408026519231585e-11, 17, "9472873", -10},
  {1.1754294096111905000000000e+15, 10, "11754294096111905", 16},
  {3.4782876009685305407348466e-02, 14, "3478287600969", -1},
  {8.6840605954729166437999766e-01, 5, "86841", 0},
  {2.0217962737304739654064178e+07, 15, "20217962737304739654064", 8},
  {2.0987324839767822789830809e-04, 5, "21", -3},
  {2.8093263558156866941121406e-14, 3, "", -3},
  {2.0517461218092498434198956e-19, 12, "", -12},
  {7.3197686593697887380560729e-04, 12, "731976866", -3},
  {4.4704573529147512545023346e+02, 3, "447046", 3},
  {2.3439773286482764524407685e+05, 17, "23439773286482764524408", 6},
  {1.0098934164993715286254883e+08, 3, "10098934165", 9},
  {3.7730049147983553820883036e-20, 0, "", 0},
  {2.1737911863199181969373878e-21, 10, "", -10},
  {8.2118060591933117393637076e+03, 9, "8211806059193", 4},
  {9.4754429582737221986182660e-21, 10, "", -10},
  {3.7033712091617716766211998e-03, 4, "37", -2},
  {7.8261438337752458854400000e+20, 19, "782614383377524588544", 21},
  {1.6567664359961554120491412e-05, 0, "", 0},
  {7.1055421502368041992187500e+10, 6, "71055421502368042", 11},
  {1.1418229053649499402534745e-05, 18, "11418229053649", -4},
  {1.1930785616485616730165246e-14, 7, "", -7},
  {3.9929726333265270000000000e+15, 11, "3992972633326527", 16},
  {3.9464497064474375472304406e-21, 0, "", 0},
  {6.3375139666462462628260255e+04, 3, "6337514", 5},
  {3.8225519357377596472691346e-14, 7, "", -7},
  {2.1031005000805510007921839e+02, 8, "21031005001", 3},
  {6.2803580029567338078198201e-25, 13, "", -13},
  {5.1954305745881441680467105e+00, 8, "519543057", 1},
  {6.6204695404885124206542969e+10, 3, "66204695404885", 11},
  {2.9658030575074800339052672e+01, 19, "296580305750748003391", 2},
  {1.6178772349851762157868507e+01, 14, "1617877234985176", 2},
  {3.7713333807240416000000000e+16, 9, "37713333807240416", 17},
  {5.8755188866430712890625000e+12, 20, "58755188866430712890625", 13},
  {3.7131473156979198646521212e-02, 8, "3713147", -1},
  {1.5918127993366679717723855e+00, 1, "16", 1},
  {2.3180495355754918444056230e-13, 11, "", -11},
  {5.6058685283759783517543118e-23, 15, "", -15},
  {2.5899097751218748092651367e+08, 8, "25899097751218748", 9},
  {1.2780438772766771596853079e-05, 17, "1278043877277", -4},
  {8.8452049336827854858711362e+04, 19, "884520493368278548587114", 5},
  {2.9264533664944482276256248e-08, 2, "", -2},
  {5.3283586553668313350112798e-10, 0, "", 0},
  {5.1687463342427556675403113e-21, 14, "", -14},
  {1.1316598164175896814162708e-11, 9, "", -9},
  {6.3723163851118105327486774e+00, 13, "63723163851118", 1},
  {2.0780635692650475943032973e-01, 8, "20780636", 0},
  {5.6534643466778765288911298e-11, 6, "", -6},
  {2.7738350850458468750000000e+14, 6, "2773835085045846875", 15},
  {5.0054795167512639758052036e-12, 4, "", -4},
  {4.4202702734080407180388778e-16, 8, "", -8},
  {1.1432993820634079687500000e+14, 4, "1143299382063407969", 15},
  {1.6779647318634466799064202e-06, 20, "167796473186345", -5},
  {3.8825658852910867398938616e-17, 9, "", -9},
  {2.9371608106548128489521332e+03, 17, "293716081065481284895", 4},
  {4.7253111046586469301916092e-07, 12, "472531", -6},
  {3.2421785953643373298142785e-25, 4, "", -4},
  {1.0915378328658414027445895e-14, 9, "", -9},
  {1.3896263558395831872463021e-10, 5, "", -5},
  {8.4926027130833931377099144e-20, 2, "", -2},
  {1.5302188253845516729967358e+00, 16, "15302188253845517", 1},
  {2.0845485133336575861605847e-10, 15, "208455", -9},
  {6.6281073000995990000000000e+15, 15, "6628107300099599", 16},
  {1.1060354167003712275388167e-12, 6, "", -6},
  {4.8058768799536499023437500e+10, 9, "48058768799536499023", 11},
  {2.2720383059920575888723718e-23, 14, "", -14},
  {7.6623555246956980374116839e-16, 9, "", -9},
  {1.5527230163480277061462402e+09, 2, "155272301635", 10},
  {5.2715243539820425212383270e+07, 1, "527152435", 8},
  {6.0907083222238322491448870e-15, 20, "609071", -14},
  {4.0310085535440209891788754e-01, 1, "4", 0},
  {1.5928828380652612686157227e+10, 13, "159288283806526126861572", 11},
  {5.9457923342923586426667093e-03, 4, "59", -2},
  {6.4347551921352188489250710e-18, 9, "", -9},
  {2.4051054153226404048963446e-21, 3, "", -3},
  {5.1658321910387163811151368e+00, 11, "516583219104", 1},
  {3.6002030007336248000000000e+16, 5, "36002030007336248", 17},
  {4.5837870571010119218730315e-15, 11, "", -11},
  {7.3546974659142444646400000e+20, 9, "735469746591424446464", 21},
  {4.3549525959271626618374285e+01, 8, "4354952596", 2},
  {6.2201372010136865234375000e+11, 15, "62201372010136865234375", 12},
  {9.0228322790377204603146060e-17, 5, "", -5},
  {2.6879110822144605208450230e+02, 14, "26879110822144605", 3},
  {1.1360526241818654114013043e+01, 3, "11361", 2},
  {3.7522068174883709268385701e+00, 10, "37522068175", 1},
  {6.4751874703259013593196869e+07, 4, "647518747033", 8},
  {2.5830771697614368109353628e-18, 12, "", -12},
  {7.0026811162865860387682915e+05, 11, "7002681116286586", 6},
  {4.9197330070736390038896139e-06, 20, "491973300707364", -5},
  {2.5594287682257457152000000e+19, 9, "25594287682257457152", 20},
  {5.6586323944334298502510090e-11, 18, "56586324", -10},
  {3.5122071344279241766894728e-02, 1, "", -1},
  {4.0093974693729013125675920e+00, 5, "40094", 1},
  {3.9929039321151161149309867e-08, 3, "", -3},
  {3.5367498268454435840000000e+18, 0, "3536749826845443584", 19},
  {4.2163525304313234984874725e+07, 12, "42163525304313234985", 8},
  {1.2706435044283027097033917e-22, 17, "", -17},
  {1.5047649632731150835752487e+07, 8, "1504764963273115", 8},
  {1.5302866729252458330354515e-17, 18, "15", -16},
  {1.7722149944860104000000000e+16, 13, "17722149944860104", 17},
  {1.2782705592930053826421499e+06, 2, "127827056", 7},
  {7.3021473633440132459395882e-13, 19, "7302147", -12},
  {7.4124333873487383008569886e-20, 14, "", -14},
  {1.7530998187465988096000000e+19, 17, "17530998187465988096", 20},
  {4.3074770333569780273437500e+12, 5, "430747703335697803", 13},
  {1.2725310705779941218629372e-13, 5, "", -5},
  {3.1805309274019514305109624e+03, 13, "31805309274019514", 4},
  {1.6149318055970227952012970e-12, 10, "", -10},
  {1.5242149349547427840000000e+19, 5, "1524214934954742784", 20},
  {2.3830232502046653628349304e+08, 18, "238302325020466536283493042", 9},
  {6.8387866967435664773314980e-07, 12, "683879", -6},
  {7.9938828582997640000000000e+15, 1, "7993882858299764", 16},
  {8.1084227406439572630033636e-13, 16, "8108", -12},
  {8.3432110495644537009698088e-19, 1, "", -1},
  {9.6776751036073292199752472e-18, 20, "968", -17},
  {4.1372155344144394273353527e-02, 3, "41", -1},
  {6.2104978648768050033649759e-08, 8, "6", -7},
  {2.3991831255946182225253359e-19, 0, "", 0},
  {1.1500586207522167360624431e-16, 9, "", -9},
  {1.2287068922949362814733831e+01, 7, "122870689", 2},
  {1.8873963467338989233312851e-03, 10, "18873963", -2},
  {4.0025044232089578314856548e-04, 14, "40025044232", -3},
  {1.4038605627372968555058343e-24, 16, "", -16},
  {5.7488874365434475243091583e+07, 4, "574888743654", 8},
  {7.2979941284639296729352893e-10, 16, "7297994", -9},
  {1.0139172751081727500000000e+15, 5, "101391727510817275", 16},
  {2.3468920145414850977429165e-22, 1, "", -1},
  {7.0207002023479310424578733e-12, 13, "7", -11},
  {5.8394150707306179768729824e-18, 4, "", -4},
  {2.6019055169204500480000000e+18, 14, "2601905516920450048", 19},
  {6.3535830166906416159159071e-22, 17, "", -17},
  {2.3967132271444709777832031e+10, 11, "2396713227144470977783", 11},
  {3.2911978410446394702766994e-08, 3, "", -3},
  {3.3842600585413766838521229e-18, 6, "", -6},
  {1.8082894975006194027145057e+00, 18, "1808289497500619403", 1},
  {1.4049495082273812788825070e-14, 17, "1405", -13},
  {1.5485710474075367424000000e+19, 9, "15485710474075367424", 20},
  {2.8328504028515200307979503e-21, 4, "", -4},
  {3.9332654311793967187443086e-09, 19, "39332654312", -8},
  {1.1996051642856927857902817e-14, 18, "11996", -13},
  {5.0857586708658902874274734e-15, 4, "", -4},
  {1.4503182494017952000000000e+17, 4, "14503182494017952", 18},
  {8.5392586539536010444800000e+20, 15, "853925865395360104448", 21},
  {2.2204371974528460502624512e+09, 9, "222043719745284605", 10},
  {1.2172498848275654879300920e-15, 10, "", -10},
  {1.0894034882679391846400000e+20, 10, "108940348826793918464", 21},
  {3.2519537925071414062500000e+13, 16, "325195379250714140625", 14},
  {8.1950070233270890625000000e+13, 2, "8195007023327089", 14},
  {3.9919268634841909179687500e+12, 19, "399192686348419091796875", 13},
  {2.6027256423684276523999870e+05, 7, "2602725642368", 6},
  {1.0917427507683326978299691e-13, 14, "11", -12},
  {1.3824833717611072000000000e+16, 15, "13824833717611072", 17},
  {5.4326663086256886885756431e-06, 12, "5432666", -5},
  {5.0310352069398602470755577e+06, 9, "503103520693986", 7},
  {3.7379474725231012625008328e-17, 14, "", -14},
  {3.2239470048134033715554965e-09, 19, "32239470048", -8},
  {6.5989378325644160438214374e-10, 4, "", -4},
  {3.1470135800670275688171387e+09, 5, "314701358006703", 10},
  {4.3938494740437668376620395e-17, 15, "", -15},
  {1.1167564358942919700537058e-20, 5, "", -5},
  {5.5532737467483701248658463e-09, 4, "", -4},
  {9.9638979244751296997070312e+10, 17, "996389792447512969970703125", 11},
  {1.0749377749801322931058327e-24, 0, "", 0},
  {6.8272377053319833908778618e-12, 15, "6827", -11},
  {1.4805270043283552169799805e+10, 0, "14805270043", 11},
  {1.1029133131061007552136191e-05, 6, "11", -4},
  {2.6804110828355467096558886e-09, 2, "", -2},
  {1.9461184619822939453125000e+12, 7, "19461184619822939453", 13},
  {1.4779492770138248252631545e-24, 5, "", -5},
  {6.4692119355144337500000000e+14, 7, "646921193551443375", 15},
  {1.7386758717901058197021484e+10, 5, "1738675871790106", 11},
  {5.7013629133703111524311145e-14, 7, "", -7},
  {1.3676914100846183337182257e-24, 18, "", -18},
  {8.4261196448238828305861503e-12, 20, "842611964", -11},
  {3.8070114361120817193295807e+04, 17, "380701143611208171933", 5},
  {1.1290671930925441971714651e-11, 5, "", -5},
  {4.0685496438059318761786940e-18, 15, "", -15},
  {7.1851108628702921263001433e-12, 14, "719", -11},
  {1.3463262607318119917506324e-09, 0, "", 0},
  {2.7443362741328933683200000e+20, 20, "274433627413289336832", 21},
  {5.7920165997761374293311755e-13, 17, "5792", -12},
  {1.2982795752996041255800118e-12, 1, "", -1},
  {1.6550139863138515031291089e-08, 2, "", -2},
  {2.2030064935551070491999666e-16, 12, "", -12},
  {4.6800170829645429648735444e+02, 11, "46800170829645", 3},
  {2.2832586999367973327636719e+10, 2, "2283258699937", 11},
  {1.5204689134326092440521767e-22, 7, "", -7},
  {2.3258527568006329956739928e-13, 5, "", -5},
  {4.3331460410107802599668503e+06, 5, "433314604101", 7},
  {1.0418890555056955634588661e-14, 13, "", -13},
  {1.6711692328133475273569113e-08, 17, "1671169233", -7},
  {1.2929826177991945000000000e+15, 20, "12929826177991945", 16},
  {8.6380805964872099840000000e+18, 0, "8638080596487209984", 19},
  {7.0854330112748291015625000e+11, 4, "7085433011274829", 12},
  {1.3782860063366413505444695e-10, 13, "1378", -9},
  {7.6031897080985729076019197e+01, 0, "76", 2},
  {3.6820989164198088642424234e-21, 11, "", -11},
  {1.6551908719882100375797160e-18, 0, "", 0},
  {1.9224256994957345581054688e+11, 16, "192242569949573455810546875", 12},
  {3.4638687892542027052765197e-17, 6, "", -6},
  {2.0237693533363996614185669e-25, 19, "", -19},
  {5.5998279426136141274147201e-05, 6, "56", -4},
  {8.2162137262308140625000000e+13, 1, "821621372623081", 14},
  {1.3739724266251737705424318e-03, 1, "", -1},
  {2.3076755315727512989649431e-19, 2, "", -2},
  {7.0826874178265952583490590e-22, 0, "", 0},
  {2.4168728409492936916649342e+06, 16, "24168728409492936916649", 7},
  {1.2227491010998119136399254e-01, 14, "12227491010998", 0},
  {1.5337385381305689600000000e+17, 14, "153373853813056896", 18},
  {3.4469429769392109233533800e-24, 11, "", -11},
  {2.8586705341951427780787401e-08, 6, "", -6},
  {3.5420238109860298299323068e-13, 0, "", 0},
  {2.3653150272344686527503654e+04, 4, "236531503", 5},
  {1.3867891748025431350189939e-15, 18, "1387", -14},
  {1.6897859813836523887665022e-12, 7, "", -7},
  {1.3238176834997805847416417e-06, 4, "", -4},
  {1.4831088783455064453125000e+13, 16, "14831088783455064453125", 14},
  {2.4705624086515232790395156e-08, 5, "", -5},
  {1.3062585612331349693704396e+05, 15, "130625856123313496937", 6},
  {1.3601791958277037338120863e+04, 14, "1360179195827703734", 5},
  {2.2136435790894974250612779e-10, 14, "22136", -9},
  {3.3433350348063226318359375e+11, 2, "33433350348063", 12},
  {1.9916777754279259370826574e-19, 15, "", -15},
  {2.2723474716861887311857859e-23, 2, "", -2},
  {8.2741286988445798128433140e-03, 14, "827412869884", -2},
  {3.2262559384780423954452999e+01, 0, "32", 2},
  {3.7949618767228368750000000e+14, 5, "3794961876722836875", 15},
  {8.7412590529096950000000000e+15, 18, "8741259052909695", 16},
  {1.1693431384870868225509582e-16, 14, "", -14},
  {6.7594310519057013056366885e-21, 1, "", -1},
  {3.0323096568533621982407161e-23, 14, "", -14},
  {5.6139101213345393714959641e-02, 7, "561391", -1},
  {1.5878490451927645965568558e-01, 2, "16", 0},
  {1.6689591296541275503806647e-16, 1, "", -1},
  {1.8626411583896353931777412e+03, 10, "18626411583896", 4},
  {5.4286938383056668062750550e-12, 10, "", -10},
  {4.4465017591249553029524646e-16, 20, "44465", -15},
  {3.1748667923722463846206665e+08, 6, "317486679237225", 9},
  {1.1800796117784115963570551e-04, 18, "118007961177841", -3},
  {6.4318834878002480515200683e-06, 8, "643", -5},
  {1.0500349212709018554687500e+12, 7, "10500349212709018555", 13},
  {8.4194376171521255493164062e+10, 11, "8419437617152125549316", 11},
  {3.1382371587547795000000000e+15, 5, "31382371587547795", 16},
  {6.9235909753928569236315210e-21, 8, "", -8},
  {3.1288695117896450028638355e+03, 14, "3128869511789645", 4},
  {3.2457899338452280857315728e-12, 16, "32458", -11},
  {1.0670587543290056456836770e-05, 19, "106705875432901", -4},
  {5.5802954213456859775791159e-06, 6, "6", -5},
  {1.0356991163497382076457143e+06, 2, "103569912", 7},
  {4.3640474099293815000000000e+15, 11, "43640474099293815", 16},
  {5.1435954367291085363543920e-20, 4, "", -4},
  {1.1126301567206007741171536e-07, 5, "", -5},
  {7.0875622159995080437511206e+05, 15, "708756221599950804375", 6},
  {1.6697834437831109171535726e-15, 1, "", -1},
  {3.1947051732073927981795261e-18, 17, "", -17},
  {8.6214869789742110128827335e+01, 19, "862148697897421101288", 2},
  {1.0867337443109704033947808e-09, 0, "", 0},
  {1.8318949570764079689979553e+08, 15, "183189495707640796899796", 9},
  {1.7596008296258846720000000e+19, 2, "1759600829625884672", 20},
  {2.6530786337999010086059570e+08, 15, "265307863379990100860596", 9},
  {1.3659149620643108367919922e+10, 4, "136591496206431", 11},
  {3.7916747181708535156250000e+12, 0, "3791674718171", 13},
  {3.9530588672225426628184529e-25, 5, "", -5},
  {2.2782782624723289161920547e+07, 9, "22782782624723289", 8},
  {5.6544668928873034753726989e-24, 20, "", -20},
  {9.7459672539133337500000000e+14, 6, "974596725391333375", 15},
  {2.0267032107372040528048274e+00, 20, "20267032107372040528", 1},
  {7.4672805895164146017251028e-02, 8, "7467281", -1},
  {1.0143153341716431431462908e-02, 11, "1014315334", -1},
  {1.2280859485421216708907963e-10, 0, "", 0},
  {2.2518204788686881684396155e-08, 18, "22518204789", -7},
  {3.2627073776326340157538652e+05, 14, "32627073776326340158", 6},
  {6.6044528341596289500328739e-10, 6, "", -6},
  {2.6512737805488801503043721e-13, 18, "265127", -12},
  {1.6231529228229128743783043e-07, 2, "", -2},
  {3.5353085267259979248046875e+09, 10, "35353085267259979248", 10},
  {2.2064481943109329583263198e-05, 2, "", -2},
  {5.6653537541470986240000000e+19, 0, "5665353754147098624", 20},
  {3.7597435293817371129989624e+06, 6, "3759743529382", 7},
  {1.7998451389261549051103932e-14, 12, "", -12},
  {1.2342430779694690825366637e-06, 3, "", -3},
  {3.5029353581771571200000000e+17, 18, "350293535817715712", 18},
  {7.0354821042501269531250000e+12, 1, "70354821042501", 13},
  {2.2563397002717311384018058e-13, 2, "", -2},
  {5.8601502692765938123953262e-04, 17, "58601502692766", -3},
  {8.0782322764059252222068608e+04, 3, "80782323", 5},
  {2.1244873717185614013671875e+11, 13, "2124487371718561401367188", 12},
  {2.8192166972655736047455157e-18, 12, "", -12},
  {2.0823817354022657871246338e+09, 6, "2082381735402266", 10},
  {1.9967549706197777404326799e-18, 1, "", -1},
  {8.4459906715397399902343750e+10, 18, "8445990671539739990234375", 11},
  {5.4528031841331876466857106e-25, 7, "", -7},
  {1.2378851781853251584000000e+19, 18, "12378851781853251584", 20},
  {8.8350271175668616721165377e-06, 18, "8835027117567", -5},
  {4.1776933230324120173552077e-13, 4, "", -4},
  {1.9947526640269042537077530e-14, 17, "1995", -13},
  {1.4198086523350664773382563e-15, 14, "", -14},
  {5.8776735707085153990192339e+03, 17, "587767357070851539902", 4},
  {3.9149506641792664436924412e-06, 4, "", -4},
  {1.7373277810091609536071562e-12, 9, "", -9},
  {3.0350437627181557936453360e-21, 17, "", -17},
  {4.1879658643352228809354649e-20, 0, "", 0},
  {4.3029007039816813406929441e-01, 2, "43", 0},
  {6.0878537595144706173901911e-22, 17, "", -17},
  {1.7116372296851121533721451e-09, 18, "171163723", -8},
  {8.7566393472574305075200000e+20, 19, "875663934725743050752", 21},
  {7.1129232501455024087294299e-12, 19, "71129233", -11},
  {1.1760158951523640751838684e+08, 3, "117601589515", 9},
  {8.0151917232310464000000000e+16, 16, "80151917232310464", 17},
  {5.1724799199232141932054539e-08, 7, "1", -6},
  {2.7162671627575915520000000e+18, 20, "2716267162757591552", 19},
  {3.2942015621242625000000000e+14, 10, "32942015621242625", 15},
  {7.9942242145083489025375425e-20, 5, "", -5},
  {4.9937334236200145106982645e-06, 0, "", 0},
  {1.3957674587296154785156250e+12, 8, "139576745872961547852", 13},
  {1.8193559092436942455257920e-21, 18, "", -18},
  {2.1326264531687796787042522e-13, 7, "", -7},
  {5.7415006127143260528100654e+02, 16, "5741500612714326053", 3},
  {7.0008837821461536000000000e+16, 17, "70008837821461536", 17},
  {1.6956795683757294829343506e-16, 14, "", -14},
  {4.8558638273325131740421057e+05, 7, "4855863827333", 6},
  {5.5898871077710018560000000e+18, 1, "5589887107771001856", 19},
  {1.9068734548821446299552917e+08, 5, "19068734548821", 9},
  {8.9166177406476349198092158e-17, 20, "8917", -16},
  {2.8507866923940660150550445e-09, 7, "", -7},
  {7.6852184881441131234169006e+07, 0, "76852185", 8},
  {1.6989641506232989032931391e-13, 2, "", -2},
  {6.0598388807882518768310547e+09, 8, "605983888078825188", 10},
  {1.8493677911946769266278089e-20, 12, "", -12},
  {3.1957549974212899002168342e+01, 0, "32", 2},
  {6.5814996792475083070544810e-09, 18, "6581499679", -8},
  {1.9640443832526588073724195e-25, 14, "", -14},
  {1.0239130176949302471728430e-14, 11, "", -11},
  {5.0491445606121568371754433e-08, 7, "1", -6},
  {1.1673114155613031021846039e-16, 10, "", -10},
  {2.5623087720955836000000000e+16, 16, "25623087720955836", 17},
  {7.6766163620431876077355891e-20, 13, "", -13},
  {8.7294971596541634560000000e+18, 7, "8729497159654163456", 19},
  {3.3013277162261196800000000e+18, 13, "330132771622611968", 19},
  {1.5520556397078947840000000e+18, 1, "1552055639707894784", 19},
  {1.4296402883801119969575666e+03, 0, "143", 4},
  {3.1408337135598484284672816e-22, 1, "", -1},
  {1.7857483197231207583399737e+00, 3, "1786", 1},
  {1.6941773448248849874945052e-23, 9, "", -9},
  {1.1096436328790047129600000e+20, 20, "110964363287900471296", 21},
  {2.8122880455445562500000000e+14, 9, "281228804554455625", 15},
  {1.2104659984401708706875790e-23, 19, "", -19},
  {3.1016302111968566406250000e+13, 5, "3101630211196856641", 14},
  {5.1643813387638013329171262e-13, 3, "", -3},
  {2.3527137587158909142276375e-14, 5, "", -5},
  {2.5456979927964129828145989e-11, 9, "", -9},
  {4.7080515490471676446323427e-20, 15, "", -15},
  {5.1339690010092672617126716e-25, 11, "", -11},
  {8.2569781046648220126671263e-24, 4, "", -4},
  {1.5078603582993297334865872e-05, 15, "15078603583", -4},
  {1.0398677845022587122250774e-12, 11, "", -11},
  {1.3971192245427228256453918e-14, 12, "", -12},
  {3.8629475813132952355978815e-25, 18, "", -18},
  {8.9482149991609802246093750e+09, 4, "8948214999161", 10},
  {8.9747287828973253454023506e+02, 7, "8974728783", 3},
  {2.8901564429595820312500000e+13, 10, "289015644295958203125", 14},
  {1.5072286629208894737530500e+04, 4, "150722866", 5},
  {9.1616587152378615428460762e+03, 16, "91616587152378615428", 4},
  {3.5415416725896637440000000e+18, 1, "3541541672589663744", 19},
  {4.8333473940143445793382604e-03, 3, "5", -2},
  {5.2682940364749179743587695e-16, 16, "5", -15},
  {1.6153789035913044286201229e-10, 17, "16153789", -9},
  {7.0267508212654938443790839e-20, 9, "", -9},
  {1.2461165278465194393600000e+20, 16, "124611652784651943936", 21},
  {1.4020110962288070351563296e-22, 20, "", -20},
  {1.5001486697463248896000000e+19, 17, "15001486697463248896", 20},
  {5.8237481772949632000000000e+17, 2, "58237481772949632", 18},
  {1.0589238903148622810840607e+08, 3, "105892389031", 9},
  {8.9434391891563361047637565e-19, 7, "", -7},
  {8.9812716885817423462867737e+07, 12, "89812716885817423463", 8},
  {5.3739308242564351598896958e-14, 17, "5374", -13},
  {1.6843270081133510788602768e-25, 8, "", -8},
  {3.6766650892663790851934369e-13, 14, "37", -12},
  {2.5184086176356884571133932e-11, 17, "2518409", -10},
  {3.9686086563383778321165600e-10, 0, "", 0},
  {3.8069020171822820312500000e+13, 8, "380690201718228203125", 14},
  {7.6568367246384484681804796e-25, 17, "", -17},
  {9.6673923772692622151225805e+05, 13, "9667392377269262215", 6},
  {3.0413399567846319233862237e-24, 13, "", -13},
  {9.3806833812197121247322684e-02, 13, "938068338122", -1},
  {6.0078802782279382605940004e-19, 0, "", 0},
  {6.1855004454622774315726694e-18, 13, "", -13},
  {3.4888058895687372285010497e+01, 0, "35", 2},
  {1.1017609138503662849065774e-24, 1, "", -1},
  {2.3410736066780591284576193e-07, 9, "234", -6},
  {1.5959595577534063437497025e+01, 18, "15959595577534063437", 2},
  {1.3762774207371576000000000e+16, 4, "13762774207371576", 17},
  {1.1183033164851590135221913e-10, 3, "", -3},
  {5.0079506720879137500000000e+14, 17, "500795067208791375", 15},
  {1.1609537335042878796388794e-08, 14, "1160954", -7},
  {1.5113016432298297323589417e-25, 4, "", -4},
  {7.5349024802105780690908432e+06, 0, "7534902", 7},
  {2.6405803784367681250000000e+14, 2, "26405803784367681", 15},
  {5.9401974430435420799767599e+03, 8, "594019744304", 4},
  {6.0767881939533712000000000e+16, 14, "60767881939533712", 17},
  {1.5587578011413079082103650e+01, 10, "155875780114", 2},
  {1.9904116557969854601596750e-22, 2, "", -2},
  {4.4579933411517448706988140e-19, 10, "", -10},
  {9.0455201351233478635549545e+05, 14, "90455201351233478636", 6},
  {1.6189807111372521972656250e+12, 14, "1618980711137252197265625", 13},
  {2.2692804907846440960000000e+18, 17, "2269280490784644096", 19},
  {6.9615971558681798163580410e-22, 14, "", -14},
  {6.1869458918148139553450093e-03, 6, "6187", -2},
  {3.1758227574941501016112015e-15, 19, "31758", -14},
  {1.4302334480497835159301758e+10, 14, "1430233448049783515930176", 11},
  {1.2035311335627140588711015e-02, 19, "120353113356271406", -1},
  {6.4937055923273538143454777e-15, 20, "649371", -14},
  {3.8814078423759568750000000e+14, 13, "3881407842375956875", 15},
  {2.7834798796856592726452120e-06, 9, "2783", -5},
  {1.4865193323650272507601829e-20, 9, "", -9},
  {4.4446387531716960000000000e+15, 10, "4444638753171696", 16},
  {2.2919242940453401600000000e+18, 14, "229192429404534016", 19},
  {3.6676753018420461753233498e-10, 20, "36676753018", -9},
  {1.1722176406171501159667969e+11, 0, "117221764062", 12},
  {6.4759756506251989746093750e+11, 13, "6475975650625198974609375", 12},
  {2.7129293336347610473632812e+10, 12, "27129293336347610473633", 11},
  {1.3566225454012169393536169e+01, 11, "1356622545401", 2},
  {1.8908647695083069627418765e-10, 12, "189", -9},
  {1.0656806087688594345853910e-04, 11, "10656806", -3},
  {2.2745709776256677508354187e+08, 13, "2274570977625667750835", 9},
  {4.0344461099297559414367242e+00, 10, "40344461099", 1},
  {5.1261150063593089768547784e-14, 17, "5126", -13},
  {3.6357698890900207519531250e+10, 6, "36357698890900208", 11},
  {3.8038124569211085201914102e+01, 11, "3803812456921", 2},
  {3.7556270161142555236816406e+10, 1, "375562701611", 11},
  {8.2898552805078054461773718e+01, 13, "828985528050781", 2},
  {1.8526207010871363759130933e-21, 18, "", -18},
  {2.3464755367576693803632813e-12, 16, "23465", -11},
  {4.9156472250176512000000000e+18, 19, "49156472250176512", 19},
  {1.5959531757902164706597375e-19, 5, "", -5},
  {2.7250133987338145402645750e+01, 0, "27", 2},
  {1.7271432972060420655462457e-05, 2, "", -2},
  {5.5987167489698124405220602e-22, 20, "", -20},
  {5.9521333131901033031141424e-01, 18, "59521333131901033", 0},
  {6.4535730171630200889563818e-11, 13, "645", -10},
  {3.4702526364342650258563766e-08, 7, "", -7},
  {7.3437509790056124329566956e+07, 2, "7343750979", 8},
  {5.9559926595512459264000000e+19, 5, "59559926595512459264", 20},
  {2.5704012835222460800000000e+17, 12, "257040128352224608", 18},
  {1.0145982848969683982431889e+06, 6, "1014598284897", 7},
  {7.1576626022243203125000000e+13, 8, "71576626022243203125", 14},
  {2.2837789044466741760000000e+18, 11, "2283778904446674176", 19},
  {6.1981640873697862442034375e-18, 17, "1", -16},
  {1.2558598893432388082146645e+07, 11, "1255859889343238808", 8},
  {5.2277576026131267547607422e+09, 9, "5227757602613126755", 10},
  {1.8252565326337580384824728e-07, 9, "183", -6},
  {1.8423971952932472049724311e+04, 17, "1842397195293247204972", 5},
  {1.0436764966148903699405537e+00, 20, "104367649661489036994", 1},
  {4.5010967912368480000000000e+16, 20, "4501096791236848", 17},
  {5.1105352954650513827800751e+07, 16, "511053529546505138278008", 8},
  {8.5430377471384079065587491e-05, 8, "8543", -4},
  {6.7167459633017871093750000e+11, 13, "6716745963301787109375", 12},
  {4.4660237765019334852695465e+07, 0, "44660238", 8},
  {1.9859706571958012000000000e+16, 9, "19859706571958012", 17},
  {1.8296935931053246107875052e-21, 6, "", -6},
  {2.5248236894340749418457760e-12, 13, "25", -11},
  {2.0772676192289169412106276e+06, 20, "207726761922891694121062756", 7},
  {7.0812273458903182442340841e-25, 6, "", -6},
  {2.0385765419573184000000000e+16, 12, "20385765419573184", 17},
  {5.6564453381645086886496147e-12, 10, "", -10},
  {2.1419856195843490422703326e+05, 20, "21419856195843490422703326", 6},
  {2.0487538064838647842407227e+06, 6, "2048753806484", 7},
  {7.2083850198219454341597157e+02, 5, "7208385", 3},
  {2.5386274829779460278225414e-15, 1, "", -1},
  {1.8797824042012808745704566e-20, 11, "", -11},
  {4.9033268432739744042773788e-17, 9, "", -9},
  {9.7120753274270171875000000e+13, 10, "97120753274270171875", 14},
  {9.2281248910752572119235992e+06, 5, "922812489108", 7},
  {4.0339070134909746911944239e+02, 4, "4033907", 3},
  {3.1571575844964771270751953e+10, 11, "3157157584496477127075", 11},
  {1.7797870345745839260054311e-01, 2, "18", 0},
  {8.0920016480900318254660047e-19, 4, "", -4},
  {4.8253916014964219430307262e-20, 4, "", -4},
  {1.5204907557345004253044530e-14, 0, "", 0},
  {1.2859105403167239372800000e+20, 7, "128591054031672393728", 21},
  {4.2583726007407083511352539e+09, 13, "42583726007407083511353", 10},
  {1.0425596527775319373176899e+03, 12, "1042559652777532", 4},
  {2.7803189405100356759725777e-04, 18, "278031894051004", -3},
  {5.4008774478855371711806580e-20, 13, "", -13},
  {1.9496626447799310483988229e-13, 2, "", -2},
  {5.4135864535777900800000000e+17, 2, "541358645357779008", 18},
  {9.6236822153017785410326854e-11, 7, "", -7},
  {1.8806320705677292023307807e-25, 15, "", -15},
  {9.7944574994330940246582031e+09, 7, "9794457499433094", 10},
  {1.9233907216873419407810603e-05, 9, "19234", -4},
  {3.5330034092767486981756520e+03, 1, "3533", 4},
  {1.1346119753487123150773338e-16, 14, "", -14},
  {8.3996926314059522392893334e-22, 3, "", -3},
  {1.9671901306359139871733632e-04, 3, "", -3},
  {9.3227524540903115980800000e+20, 18, "932275245409031159808", 21},
  {5.3174869177631578125000000e+13, 10, "53174869177631578125", 14},
  {4.3015994562294653320312500e+12, 13, "430159945622946533203125", 13},
  {1.5642817099627249842842876e-10, 4, "", -4},
  {2.0301907199487765000000000e+15, 1, "20301907199487765", 16},
  {2.3761601882669764535332042e-24, 15, "", -15},
  {5.1233849975274425858629002e-01, 5, "51234", 0},
  {2.7517624105546821289062500e+12, 7, "27517624105546821289", 13},
  {1.3644676801624605060692012e-14, 2, "", -2},
  {2.6786412152369136030049396e-05, 18, "26786412152369", -4},
  {1.0573725432776535052231217e-24, 19, "", -19},
  {1.1027530491490714677910168e-03, 1, "", -1},
  {1.6732913363178449869155884e+08, 7, "1673291336317845", 9},
  {7.7770272377389530649117981e-12, 18, "7777027", -11},
  {3.3432824955257416000000000e+16, 6, "33432824955257416", 17},
  {1.3676699272329308513423088e-11, 1, "", -1},
  {2.3162830481557915618395782e+02, 10, "2316283048156", 3},
  {1.5645963762080907468342750e-08, 15, "15645964", -7},
  {9.0852174490780736104487361e-14, 11, "", -11},
  {9.1288093817776800000000000e+16, 6, "912880938177768", 17},
  {3.2855747834905419982833038e-25, 6, "", -6},
  {6.3690982030275100178422221e-05, 16, "636909820303", -4},
  {3.4765923240652572631835938e+10, 5, "3476592324065257", 11},
  {1.1800636822789508618060188e-20, 11, "", -11},
  {4.8282733191148788712882797e-14, 0, "", 0},
  {1.5979393308333816528320312e+11, 4, "1597939330833382", 12},
  {1.1778730218726487457752228e+08, 11, "11778730218726487458", 9},
  {8.2356893592933088541030884e+07, 10, "823568935929330885", 8},
  {1.4862751037898046875000000e+12, 0, "148627510379", 13},
  {5.0979779449793561241222051e+01, 13, "509797794497936", 2},
  {8.5848729359097993029499305e-09, 8, "1", -7},
  {4.6991819438794487687579204e-07, 13, "4699182", -6},
  {2.0999075057579467054489362e-22, 5, "", -5},
  {2.0652697120212378906250000e+13, 16, "2065269712021237890625", 14},
  {1.0479811075870921967430338e-04, 10, "1047981", -3},
  {2.1981254023063150133974621e-22, 5, "", -5},
  {1.7691254385869906644202263e-09, 7, "", -7},
  {1.2341790342273780940800000e+20, 7, "123417903422737809408", 21},
  {4.1544100774078226240048640e-09, 4, "", -4},
  {9.0717416185916621707008289e-01, 20, "90717416185916621707", 0},
  {2.7248062847580036835632491e-19, 18, "", -18},
  {2.9893720928370163200000000e+17, 1, "298937209283701632", 18},
  {1.5919531580491777522645691e-01, 19, "1591953158049177752", 0},
  {3.0414842699075387500000000e+14, 5, "304148426990753875", 15},
  {1.6239953675571475251200000e+20, 14, "162399536755714752512", 21},
  {9.7795642406178368199780457e-20, 15, "", -15},
  {3.0908301125789905920000000e+18, 10, "3090830112578990592", 19},
  {1.7370654544789995998144150e+06, 15, "1737065454478999599814", 7},
  {5.6492713542371971726860358e-05, 10, "564927", -4},
  {1.3161916974477410304000000e+19, 6, "13161916974477410304", 20},
  {1.2998345916919477531337179e+04, 2, "1299835", 5},
  {2.8261987683904868140040477e-08, 8, "3", -7},
  {1.3290600882736104000000000e+16, 18, "13290600882736104", 17},
  {9.4425153884020440742119717e-01, 0, "1", 1},
  {2.4629053755570808117896165e-08, 15, "24629054", -7},
  {1.1957128574133832253368008e-18, 10, "", -10},
  {6.0442436462443611642498491e-25, 17, "", -17},
  {8.8285982320469140625000000e+12, 8, "88285982320469140625", 13},
  {4.3650672112977237500000000e+14, 14, "436506721129772375", 15},
  {6.1872958206493212672000000e+19, 4, "61872958206493212672", 20},
  {6.2559274570735595512590848e-24, 17, "", -17},
  {8.9674028875475537500000000e+14, 4, "896740288754755375", 15},
  {1.8016993732871479492187500e+12, 15, "180169937328714794921875", 13},
  {8.7653876171080150936392285e-12, 6, "", -6},
  {8.1330024065306718256029615e-22, 14, "", -14},
  {4.5526353522422343809288003e-15, 8, "", -8},
  {1.2334210654870488033265198e-06, 5, "", -5},
  {5.5682681842855250835418701e+08, 15, "556826818428552508354187", 9},
  {3.7707589568650213623046875e+11, 7, "3770758956865021362", 12},
  {4.0681043783195766207342708e-20, 13, "", -13},
  {1.1696476755314793359080494e-12, 14, "117", -11},
  {8.1764686060646980000000000e+15, 12, "8176468606064698", 16},
  {1.1200300893973007564800000e+20, 9, "112003008939730075648", 21},
  {1.9921018375555603125000000e+14, 0, "199210183755556", 15},
  {3.8206780131887535389978439e+04, 20, "3820678013188753538997844", 5},
  {1.2662925185757312120277527e-14, 17, "1266", -13},
  {2.1968780971572742324350591e-04, 6, "22", -3},
  {2.3178824646449389158214277e-18, 5, "", -5},
  {1.4939207754546931982160420e-16, 17, "15", -15},
  {2.5021988161088398783249431e+02, 9, "250219881611", 3},
  {2.6339992616941498368000000e+19, 13, "26339992616941498368", 20},
  {2.6614191150853218078613281e+10, 12, "26614191150853218078613", 11},
  {3.3616257608429933658988256e-23, 6, "", -6},
  {5.3732816148293058931019861e-13, 14, "54", -12},
  {1.4471003580226962890625000e+13, 17, "14471003580226962890625", 14},
  {6.9760709653338770844244188e-03, 4, "7", -2},
  {3.7365595876326413931866037e-14, 0, "", 0},
  {1.4726174650329557849707085e-21, 1, "", -1},
  {3.1641994933141858696779158e-09, 19, "31641994933", -8},
  {1.3056546315857486724853516e+10, 9, "13056546315857486725", 11},
  {3.3347656215328566406250000e+13, 4, "333476562153285664", 14},
  {1.4888764200042638924005343e-19, 20, "15", -18},
  {1.3516306378916656538713426e-01, 2, "14", 0},
  {1.3372341257045643404126167e+07, 4, "13372341257", 8},
  {6.3908557781451281738281250e+11, 14, "6390855778145128173828125", 12},
  {3.5141497005636096000000000e+17, 19, "35141497005636096", 18},
  {7.5742921070993543346444070e-25, 3, "", -3},
  {2.8223338832916519541776575e-09, 15, "2822334", -8},
  {4.3579899234629792000000000e+17, 2, "43579899234629792", 18},
  {4.1132635359401598572731018e+07, 8, "411326353594016", 8},
  {3.7867640748727456426242975e-19, 19, "4", -18},
  {1.0719540368487409027771824e-09, 16, "1071954", -8},
  {1.2916587188759123816517160e-01, 3, "129", 0},
  {6.0118816045830917358398438e+09, 15, "6011881604583091735839844", 10},
  {6.8293402560535021972656250e+11, 8, "68293402560535021973", 12},
  {3.7030996870791092590025073e+01, 14, "3703099687079109", 2},
  {9.9915312593501172200663191e-07, 6, "1", -5},
  {7.5732606384159089429886080e+03, 9, "7573260638416", 4},
  {3.3725580313052609671142790e-02, 2, "3", -1},
  {1.7306678774451635742187500e+11, 6, "173066787744516357", 12},
  {9.8616465533875909132977000e-03, 16, "98616465533876", -2},
  {4.5150458153153877338681355e-01, 8, "45150458", 0},
  {8.4489221944447502028197050e+05, 0, "844892", 6},
  {1.0994225200274720249948857e-02, 7, "109942", -1},
  {4.0610828010776229914248230e-21, 0, "", 0},
  {1.6781777534572892578125000e+13, 7, "167817775345728925781", 14},
  {2.8414869848353439010679722e+06, 6, "2841486984835", 7},
  {7.2700950357005620000000000e+15, 15, "7270095035700562", 16},
  {1.6000600162986502144000000e+19, 6, "16000600162986502144", 20},
  {5.4671945741246098830715002e-10, 15, "546719", -9},
  {4.4558811282537527388960876e-24, 6, "", -6},
  {2.4458470148620943585681465e-17, 10, "", -10},
  {2.4694562219351599452465962e+01, 6, "24694562", 2},
  {2.3419137679143264829662030e-01, 2, "23", 0},
  {3.7893419419425633520859265e+01, 8, "3789341942", 2},
  {1.1666603806020626562500000e+14, 4, "1166660380602062656", 15},
  {5.5636700701303171162219597e-10, 19, "556367007", -9},
  {1.4000507656815141222014228e-08, 10, "14", -7},
  {7.9609822295055165886878967e+07, 6, "79609822295055", 8},
  {1.8798445308063667520436726e-24, 2, "", -2},
  {3.1553199385009805000000000e+15, 17, "31553199385009805", 16},
  {7.4376533030223554305848666e+03, 20, "743765330302235543058487", 4},
  {7.3283411706797625390940599e-09, 1, "", -1},
  {1.0803940160878352519067784e-18, 3, "", -3},
  {1.7199507428158730717608213e-18, 8, "", -8},
  {7.1949629780973307533690347e-06, 17, "71949629781", -5},
  {3.2326447410177525099150841e-02, 10, "323264474", -1},
  {2.1615433132729160909998753e-19, 18, "", -18},
  {7.1286633565004312913515605e+03, 7, "71286633565", 4},
  {7.6571531052105776000000000e+16, 13, "76571531052105776", 17},
  {1.3764288893546150575275533e+04, 15, "13764288893546150575", 5},
  {2.5491812142514000960602516e+00, 6, "2549181", 1},
  {1.1310937010119646181046586e-20, 17, "", -17},
  {2.8830044319460307200000000e+17, 13, "288300443194603072", 18},
  {7.2487319782517239451408386e+07, 20, "7248731978251723945140838623", 8},
  {7.8781652631238382309675217e+05, 5, "78781652631", 6},
  {9.3068169146558936847225767e-21, 3, "", -3},
  {9.3426831340322804555706404e-05, 9, "93427", -4},
  {4.9690195825583149398912030e-24, 8, "", -8},
  {2.7607533939871835571011616e+00, 12, "2760753393987", 1},
  {3.0747815206603412628173828e+09, 12, "3074781520660341262817", 10},
  {9.8569628787732721519887491e+00, 13, "98569628787733", 1},
  {1.0640517126646589481809916e-13, 20, "10640517", -12},
  {4.6434258386103080492395872e-19, 16, "", -16},
  {9.1793828373818681575357914e+05, 5, "91793828374", 6},
  {1.4572320175474813542214336e-04, 20, "14572320175474814", -3},
  {2.0099712090441684704273939e+06, 15, "2009971209044168470427", 7},
  {1.4635950639963019084364374e-17, 14, "", -14},
  {1.2831321582611105468750000e+13, 20, "1283132158261110546875", 14},
  {1.2902713247436594963073730e+09, 12, "1290271324743659496307", 10},
  {1.1691218567131622184974839e-25, 17, "", -17},
  {3.8661352485606206659824099e-24, 12, "", -12},
  {1.4605197869352794248775401e-09, 1, "", -1},
  {4.4532665953153160095214844e+10, 11, "4453266595315316009521", 11},
  {1.9711901782810058950806686e-04, 17, "1971190178281", -3},
  {1.1370583897735646132787224e+03, 20, "113705838977356461327872", 4},
  {3.5652892052501446643255664e-09, 12, "3565", -8},
  {4.4405075921643284431183929e+00, 12, "4440507592164", 1},
  {1.6928145196071704705895507e-12, 17, "169281", -11},
  {2.2505438187961127609014511e+07, 5, "2250543818796", 8},
  {4.0426480431997988489456475e+03, 10, "40426480431998", 4},
  {1.0141742997498828793290215e-01, 20, "10141742997498828793", 0},
  {5.7482083582182809600000000e+17, 4, "574820835821828096", 18},
  {4.3401072298915941320820792e-12, 10, "", -10},
  {4.0853571982522503276413772e+03, 12, "408535719825225", 4},
  {9.2379601074391516165696247e-24, 14, "", -14},
  {8.3720497243058097362518311e+08, 5, "83720497243058", 9},
  {5.2021522245690660000000000e+15, 17, "5202152224569066", 16},
  {4.4279296137903635000000000e+15, 6, "44279296137903635", 16},
  {3.1913649438120340000000000e+15, 5, "3191364943812034", 16},
  {3.6754673815884707840000000e+18, 15, "3675467381588470784", 19},
  {8.5251651007309875488281250e+09, 11, "852516510073098754883", 10},
  {3.4215337248978760957678497e-08, 6, "", -6},
  {1.0768268371683453548358356e-05, 5, "1", -4},
  {1.4368906238468021487472444e-23, 16, "", -16},
  {3.5902803398586430000000000e+15, 2, "3590280339858643", 16},
  {1.2045663543761788787378464e+03, 16, "12045663543761788787", 4},
  {4.2733294194715507444999070e-14, 1, "", -1},
  {1.3682676657840632036048752e-25, 1, "", -1},
  {3.0600307462661960601806641e+10, 4, "30600307462662", 11},
  {2.1846321731320720971325500e+01, 11, "2184632173132", 2},
  {5.7648966713890150400000000e+18, 11, "576489667138901504", 19},
  {1.1047663439635713600000000e+17, 8, "110476634396357136", 18},
  {4.9151657586463671400992123e-10, 6, "", -6},
  {1.0953557419366362981826966e-18, 19, "11", -17},
  {2.3664348007498985679113168e-04, 16, "236643480075", -3},
  {1.8777445041406931516142498e-03, 9, "1877745", -2},
  {3.8527470537511453125000000e+13, 17, "38527470537511453125", 14},
  {2.5544588477671382852862989e-11, 12, "26", -10},
  {7.7096864765968675110626465e-11, 7, "", -7},
  {3.4788792128609257812500000e+12, 9, "347887921286092578125", 13},
  {3.9646624204808909557863780e-12, 20, "396466242", -11},
  {5.7901336919258770963292449e-03, 19, "57901336919258771", -2},
  {1.7327845172914464706237850e-06, 9, "1733", -5},
  {2.4327336485918279495793210e-14, 6, "", -6},
  {3.3951502284968427520000000e+18, 7, "3395150228496842752", 19},
  {1.7899135031306202322703363e-10, 1, "", -1},
  {4.0160603455130499267578125e+11, 3, "401606034551305", 12},
  {5.5279565147039169323555513e-05, 0, "", 0},
  {5.0493168183708898437500000e+13, 16, "504931681837088984375", 14},
  {1.8273223578260466456413269e+06, 15, "1827322357826046645641", 7},
  {1.3938901267143726644562507e-18, 11, "", -11},
  {4.2571141550773808148733224e+02, 17, "42571141550773808149", 3},
  {2.2980618159631355904000000e+19, 4, "22980618159631355904", 20},
  {9.5958956064588862844288997e-01, 13, "9595895606459", 0},
  {3.0063072556974282488226891e+06, 17, "300630725569742824882269", 7},
  {8.5271136614109333604574203e+06, 0, "8527114", 7},
  {2.9515861316121736024342681e+01, 19, "295158613161217360243", 2},
  {1.5151590720849206661569042e+01, 18, "15151590720849206662", 2},
  {1.3193386310254834483200000e+20, 5, "131933863102548344832", 21},
  {3.5828929612040615211299155e+03, 9, "3582892961204", 4},
  {2.8913368745651029101395579e+00, 14, "28913368745651", 1},
  {3.9845306437828204800000000e+17, 12, "398453064378282048", 18},
  {2.0635309616395545890554786e+05, 20, "20635309616395545890554786", 6},
  {2.3352641872834714598106132e-01, 15, "233526418728347", 0},
  {4.7452845039216350701577277e-22, 1, "", -1},
  {2.7836670870867428125000000e+14, 14, "27836670870867428125", 15},
  {1.0617597323501392647604280e-19, 4, "", -4},
  {1.1428229348121068323962390e+05, 1, "1142823", 6},
  {1.3860850930894663570098084e-24, 1, "", -1},
  {3.8859587989586898387940665e-22, 13, "", -13},
  {5.0440948281057017102731775e-10, 8, "", -8},
  {6.7538390371767221949994564e+04, 2, "6753839", 5},
  {1.3904641652352923486546388e+01, 12, "13904641652353", 2},
  {9.7259701565851353066705087e-01, 14, "97259701565851", 0},
  {4.9217479673230856817878427e-20, 17, "", -17},
  {4.6736709890019119007512549e-07, 18, "4673670989", -6},
  {2.1433099563493766881644773e-22, 18, "", -18},
  {1.5514310094619210289579314e-01, 6, "155143", 0},
  {1.8214158290377698866912446e-09, 0, "", 0},
  {1.2947241274211059570312500e+10, 5, "1294724127421106", 11},
  {2.8341658947111253121016442e-20, 6, "", -6},
  {1.7514697771454498116614545e-13, 18, "175147", -12},
  {3.8668166037542938926310861e-24, 6, "", -6},
  {1.1638741718377404687500000e+14, 6, "116387417183774046875", 15},
  {2.9085028093658267039202739e-08, 0, "", 0},
  {1.3830205224102185685135930e-05, 5, "1", -4},
  {3.3145417141004214286804199e+09, 17, "331454171410042142868041992", 10},
  {2.4204001253639351452124455e-09, 12, "242", -8},
  {2.1413352681047940625000000e+14, 2, "21413352681047941", 15},
  {1.2666403498252008935169688e-21, 6, "", -6},
  {2.7215826067946567535400391e+09, 13, "272158260679465675354", 10},
  {8.8490138338526876138082342e-22, 6, "", -6},
  {3.7857796115533611990228244e-06, 4, "", -4},
  {3.2784418976339833322188938e-09, 1, "", -1},
  {6.8037066903297864000000000e+16, 19, "68037066903297864", 17},
  {1.4201271647644665790721774e+05, 14, "14201271647644665791", 6},
  {1.3947998757273379055732221e+02, 18, "139479987572733790557", 3},
  {1.6958698916768006892397125e+00, 5, "169587", 1},
  {1.1601140850885964027838781e+04, 5, "1160114085", 5},
  {5.2733014036855406250000000e+14, 1, "5273301403685541", 15},
  {3.0700755014825780000000000e+15, 9, "3070075501482578", 16},
  {2.5411565070194812518400000e+20, 16, "254115650701948125184", 21},
  {2.7284619464752349853515625e+10, 14, "2728461946475234985351563", 11},
  {1.6185382917458988354304263e-06, 12, "1618538", -5},
  {6.5565287075491638212488732e-24, 17, "", -17},
  {4.1641557733231437943288711e-01, 19, "4164155773323143794", 0},
  {3.8832301402350333519279957e+06, 13, "38832301402350333519", 7},
  {4.8051873168103558992317846e-06, 14, "480518732", -5},
  {1.1035835134978958129882812e+11, 11, "11035835134978958129883", 12},
  {2.9200798584000649311597181e-08, 1, "", -1},
  {2.3671861619671896640867171e-23, 3, "", -3},
  {3.3036224246761222936707332e-18, 9, "", -9},
  {7.1819520236600021573344879e-25, 0, "", 0},
  {3.2504542494667013292557106e-12, 10, "", -10},
  {2.4176435964382338994482780e+01, 0, "24", 2},
  {9.2668443612788598632812500e+11, 17, "926684436127885986328125", 12},
  {1.0348627625267955850615831e-24, 20, "", -20},
  {1.3420453164664861105848104e+04, 5, "1342045316", 5},
  {5.0370424187002181440168946e-06, 20, "503704241870022", -5},
  {1.2855371670206220288000000e+19, 19, "12855371670206220288", 20},
  {4.9975711825703641807194799e+04, 15, "49975711825703641807", 5},
  {8.5832973041262080000000000e+16, 7, "8583297304126208", 17},
  {1.1263337221421314648223642e-05, 16, "112633372214", -4},
  {4.4093602190949744640000000e+18, 5, "4409360219094974464", 19},
  {2.0126765709543333176911748e-21, 1, "", -1},
  {2.8279768616230866760426199e-23, 1, "", -1},
  {1.3992491304675511500800000e+20, 19, "139924913046755115008", 21},
  {3.7698504109642555339810318e-06, 16, "3769850411", -5},
  {5.1510534520682797019300346e-18, 15, "", -15},
  {8.0811703475920620778124182e-13, 12, "1", -11},
  {2.4911990199912805377277924e-20, 15, "", -15},
  {5.5509991671740308996557671e-12, 15, "5551", -11},
  {5.1656905546619718734291382e+03, 17, "516569055466197187343", 4},
  {4.8456993186824445952000000e+19, 16, "48456993186824445952", 20},
  {6.8837059036814057799702482e-02, 6, "68837", -1},
  {7.7131561713734930000000000e+15, 6, "7713156171373493", 16},
  {1.1311247954627078791217906e-10, 1, "", -1},
  {4.1319502549556188022994441e-03, 19, "41319502549556188", -2},
  {2.7764203573311983936040126e-19, 12, "", -12},
  {2.1960143038501691306232219e-25, 13, "", -13},
  {2.5627914281446280396800000e+20, 8, "256279142814462803968", 21},
  {1.2475593883643504640000000e+19, 5, "1247559388364350464", 20},
  {8.1002395973944180227084566e-05, 13, "81002396", -4},
  {6.8125031912567320009309245e-24, 3, "", -3},
  {1.1950232287235890045204549e-12, 11, "", -11},
  {1.4856969111664605529928579e-19, 13, "", -13},
  {3.2191216059397197004800000e+20, 12, "321912160593971970048", 21},
  {1.3377327312982770939932264e-04, 8, "13377", -3},
  {2.8631274999739964026934415e-14, 13, "", -13},
  {2.3088000282869333545932022e+02, 9, "230880002829", 3},
  {3.0963623362454048156738281e+10, 17, "3096362336245404815673828125", 11},
  {3.9681578945738721327189742e-18, 13, "", -13},
  {1.7345452092024371581844034e-14, 13, "", -13},
  {1.9356811555291265625000000e+13, 16, "19356811555291265625", 14},
  {1.3400143089452641024275333e-07, 6, "", -6},
  {1.6109347919759485611233199e-16, 2, "", -2},
  {7.3884013971850460797188460e-25, 0, "", 0},
  {1.8210814322825882434844971e+09, 13, "18210814322825882434845", 10},
  {1.4103030065999600000000000e+14, 8, "141030300659996", 15},
  {1.0848579682990028750000000e+15, 5, "1084857968299002875", 16},
  {4.9285817627275374519513207e-01, 10, "4928581763", 0},
  {4.5954169020930002963198913e-04, 1, "", -1},
  {6.8990333657294755950210380e-09, 4, "", -4},
  {1.9347536464407175781250000e+13, 4, "193475364644071758", 14},
  {1.6662672455936829010170186e+03, 3, "1666267", 4},
  {8.6487929032643169035647921e-18, 12, "", -12},
  {2.6819417982062990413497098e-16, 3, "", -3},
  {3.7091826705705012347181875e-18, 20, "371", -17},
  {1.4271053684154327129363082e+04, 0, "14271", 5},
  {5.9831146477574808427938676e-13, 10, "", -10},
  {2.8891867533887715459090493e-20, 11, "", -11},
  {7.5165490294559263948800000e+20, 1, "751654902945592639488", 21},
  {1.3309331764889487104142063e-01, 16, "1330933176488949", 0},
  {1.1904084708203923170799499e+01, 17, "1190408470820392317", 2},
  {4.7098911124256341096590305e-07, 4, "", -4},
  {1.2901757698397238281250000e+13, 0, "12901757698397", 14},
  {1.8415932712865937501192093e+07, 18, "18415932712865937501192093", 8},
  {1.7233687646281046875000000e+14, 1, "1723368764628105", 15},
  {1.7943657411682915687561035e+09, 19, "17943657411682915687561035156", 10},
  {3.2482109626891296166707370e-12, 10, "", -10},
  {4.8706042103843017578125000e+10, 20, "48706042103843017578125", 11},
  {7.5559493061380326253129169e+03, 12, "7555949306138033", 4},
  {3.1085307133709964306507931e-22, 18, "", -18},
  {9.4875917874499829277021099e-25, 14, "", -14},
  {4.2253422222974137600000000e+17, 6, "422534222229741376", 18},
  {7.8722042474989196046083335e-12, 9, "", -9},
  {1.8820798712953933105468750e+12, 20, "1882079871295393310546875", 13},
  {2.3993922847073614890156534e-01, 4, "2399", 0},
  {1.3336557814811888093926909e-17, 18, "13", -16},
  {9.5197150704115295410156250e+11, 7, "9519715070411529541", 12},
  {2.4356698591566790363864872e-20, 18, "", -18},
  {1.3868514155008765524941032e-22, 6, "", -6},
  {4.5750094945586150063741165e-09, 1, "", -1},
  {1.0198234813803499937057495e+09, 8, "101982348138034999", 10},
  {1.1090646921513773188678061e-13, 11, "", -11},
  {6.6232822628969012293964624e+05, 17, "66232822628969012293965", 6},
  {5.3716269767817631250000000e+14, 7, "5371626976781763125", 15},
  {6.7477600155594336683861911e+03, 10, "67477600155594", 4},
  {4.3749344040847423392019878e-08, 7, "", -7},
  {2.8699077448841320163729196e-12, 20, "286990774", -11},
  {5.1094277047468304000000000e+16, 2, "51094277047468304", 17},
  {7.1320482884710193015670662e-25, 7, "", -7},
  {1.6289919992469683289527893e+07, 11, "1628991999246968329", 8},
  {1.2935595570164290353365508e-14, 7, "", -7},
  {1.1349573224939089418637514e-21, 14, "", -14},
  {9.2611324623969867388950661e+03, 17, "92611324623969867389", 4},
  {3.0331642507814243164062500e+12, 13, "303316425078142431640625", 13},
  {1.4452551085896189952000000e+19, 16, "14452551085896189952", 20},
  {5.6527910614115220840570222e-18, 3, "", -3},
  {2.6432627718564749574881034e-03, 5, "264", -2},
  {1.8052500737984458331993486e-25, 13, "", -13},
  {1.3572797775490226562500000e+14, 0, "135727977754902", 15},
  {1.5507850057839678000000000e+16, 5, "15507850057839678", 17},
  {4.3133313058945987073010925e-24, 17, "", -17},
  {6.1280323915738460000000000e+15, 6, "6128032391573846", 16},
  {3.0994792015888606329099275e+02, 7, "3099479202", 3},
  {2.5658025474930528899352930e-05, 10, "25658", -4},
  {3.4508568615903844000000000e+16, 16, "34508568615903844", 17},
  {1.4988084581740406250000000e+13, 13, "1498808458174040625", 14},
  {2.0280856043172256153600000e+20, 3, "202808560431722561536", 21},
  {1.1513940774321922560000000e+18, 4, "1151394077432192256", 19},
  {3.5231659599932779376092879e-12, 16, "35232", -11},
  {1.3865389451670445453146385e+01, 8, "1386538945", 2},
  {6.0916073461521418721531518e+03, 7, "60916073462", 4},
  {3.7430459400997582791337066e-23, 15, "", -15},
  {2.6111847147877817475393074e-24, 19, "", -19},
  {1.6718487092424250022304477e+03, 14, "1671848709242425", 4},
  {7.7166326057186678091866607e-25, 19, "", -19},
  {1.8056059260140621093750000e+13, 16, "1805605926014062109375", 14},
  {3.8824294999212205484596674e-23, 15, "", -15},
  {2.0020483012348590636644488e-09, 4, "", -4},
  {4.4276503707679818750000000e+14, 9, "4427650370767981875", 15},
  {8.4318087298922332763671875e+10, 0, "84318087299", 11},
  {2.6081735977425926860190852e-08, 10, "261", -7},
  {1.1183741760708354413509369e+07, 8, "1118374176070835", 8},
  {2.8595072822225732803344727e+09, 14, "285950728222257328033447", 10},
  {1.0201644317069098178762943e+05, 8, "10201644317069", 6},
  {2.4095214305638784880625565e-24, 4, "", -4},
  {2.9424420739213851073230906e-06, 15, "2942442074", -5},
  {2.0328989277946105136590054e-14, 18, "20329", -13},
  {7.1257536477621703817741972e-12, 10, "", -10},
  {4.5083719409008722323051188e+01, 15, "45083719409008722", 2},
  {7.6440908515976548229878508e-17, 2, "", -2},
  {2.2896889334055316567173577e+01, 11, "2289688933406", 2},
  {5.9934329321310215732410143e+00, 8, "599343293", 1},
  {2.9600945057943982080000000e+19, 15, "2960094505794398208", 20},
  {6.4003427411126459391080886e-07, 15, "640034274", -6},
  {4.3110158010940491379869854e-01, 20, "4311015801094049138", 0},
  {4.6824881116832445418593934e-07, 19, "4682488111683", -6},
  {1.1065299225814154482350204e+01, 1, "111", 2},
  {6.6082870982496760752307126e-24, 6, "", -6},
  {5.3319028958259157864218363e-09, 9, "5", -8},
  {7.5193581441029341184000000e+19, 19, "75193581441029341184", 20},
  {2.0805240175525154204149889e-07, 5, "", -5},
  {6.1807701576783093760000000e+19, 0, "6180770157678309376", 20},
  {1.1217952350837352960000000e+18, 13, "1121795235083735296", 19},
  {3.4906228835483435008000000e+19, 19, "34906228835483435008", 20},
  {1.5894356499650735855102539e+09, 7, "15894356499650736", 10},
  {1.4893019405478351128149105e-15, 12, "", -12},
  {6.6851006302712600985600000e+20, 3, "668510063027126009856", 21},
  {2.0281844160398636241739494e-16, 17, "2", -15},
  {2.6687192683583070902386680e+03, 17, "266871926835830709024", 4},
  {3.0921873668364211936248497e-15, 10, "", -10},
  {7.0485095216748312500000000e+14, 2, "70485095216748313", 15},
  {2.6150318108027416747063398e+05, 18, "261503181080274167470634", 6},
  {2.0973618943240895418157191e-12, 15, "2097", -11},
  {7.2847426528616784000000000e+16, 9, "72847426528616784", 17},
  {3.9200915929890724249600000e+20, 8, "392009159298907242496", 21},
  {1.0872104242757860800000000e+17, 18, "108721042427578608", 18},
  {6.6146821281760570312500000e+13, 1, "661468212817606", 14},
  {1.8363625837602547500000000e+15, 3, "183636258376025475", 16},
  {2.0721802682568259200000000e+17, 2, "207218026825682592", 18},
  {2.7725459327389537356793880e+06, 20, "277254593273895373567938805", 7},
  {6.5987985705802320000000000e+16, 13, "6598798570580232", 17},
  {7.8785280426522476738046942e-07, 14, "7878528", -6},
  {2.0613600232184390876498857e-22, 18, "", -18},
  {5.7225928583509236737933679e-22, 2, "", -2},
  {4.0585317297674458199442309e-10, 5, "", -5},
  {1.3410896012082308800000000e+17, 0, "134108960120823088", 18},
  {6.5497148359331816693187321e-14, 1, "", -1},
  {3.8245903192157990997657180e+05, 6, "382459031922", 6},
  {1.6195135482659581612097099e+04, 4, "161951355", 5},
  {3.6428414623109888204055551e+00, 20, "364284146231098882041", 1},
  {9.6796235789564687500000000e+13, 19, "967962357895646875", 14},
  {4.0158623791449535644915159e+01, 6, "40158624", 2},
  {4.7961159513435588451102376e+05, 10, "4796115951343559", 6},
  {3.3760774127242632675915956e+05, 2, "33760774", 6},
  {4.6419836062684052521916164e-11, 9, "", -9},
  {1.3476121603060423406739154e-02, 17, "1347612160306042", -1},
  {1.1455528242614980535929540e-14, 12, "", -12},
  {1.7471772883815811700326584e-19, 15, "", -15},
  {2.1602219543986569960658528e-02, 18, "2160221954398657", -1},
  {5.2552795050492059090174735e+04, 5, "5255279505", 5},
  {2.6643628837024519069587303e-03, 17, "266436288370245", -2},
  {4.2597771452537432312965393e+07, 13, "42597771452537432313", 8},
  {8.0950781114479364308778031e-01, 11, "80950781114", 0},
  {1.3488320640418134145621654e-03, 6, "1349", -2},
  {2.7901354308398667036783536e+00, 17, "27901354308398667", 1},
  {3.4468119195225954148844027e-25, 16, "", -16},
  {6.4096115616650648893343201e-04, 18, "640961156166506", -3},
  {1.0316838105656138402377309e-01, 6, "103168", 0},
  {1.0455459381692288443446159e+07, 19, "104554593816922884434461594", 8},
  {7.4625773325376226785023148e-06, 9, "7463", -5},
  {2.4303943740978770542913693e-13, 11, "", -11},
  {2.2295336605912312500000000e+14, 8, "222953366059123125", 15},
  {5.7592265291010401949838025e-09, 3, "", -3},
  {2.2126299186193900021824010e-04, 12, "221262992", -3},
  {4.1578234522330389383304450e-03, 18, "4157823452233039", -2},
  {8.5381461029067070000000000e+15, 15, "8538146102906707", 16},
  {4.1138317803804855000000000e+15, 4, "41138317803804855", 16},
  {2.6953883874594981510620705e-22, 12, "", -12},
  {1.8338663461931643699200000e+20, 3, "183386634619316436992", 21},
  {2.7482029156442051200000000e+17, 9, "274820291564420512", 18},
  {1.0872521174689859151840210e+08, 7, "1087252117468986", 9},
  {4.2357051831846576929092407e+08, 20, "42357051831846576929092407227", 9},
  {6.2661157849905301020498882e+01, 2, "6266", 2},
  {3.1450601800227594555173894e-12, 16, "31451", -11},
  {2.6032832173516099674290614e-11, 12, "26", -10},
  {6.3560216730336498212292377e-07, 2, "", -2},
  {5.7286534669606643043710116e-24, 17, "", -17},
  {3.3096584197510252715413125e-24, 13, "", -13},
  {1.9071131436163709622633178e+03, 12, "1907113143616371", 4},
  {5.7427703130337804506409458e-13, 6, "", -6},
  {3.7693443386953658031200160e-13, 1, "", -1},
  {7.1323044974976295278304751e-23, 13, "", -13},
  {2.1894673029380757517975809e-19, 3, "", -3},
  {1.0506354341733748713307766e-12, 5, "", -5},
  {2.0567384659888646058086621e-13, 1, "", -1},
  {4.2931955498474156484007835e+06, 1, "42931955", 7},
  {2.4977365207924990909467247e-17, 20, "2498", -16},
  {6.7196188288789202347108591e-19, 11, "", -11},
  {1.1505337474272364544000000e+19, 17, "11505337474272364544", 20},
  {4.3329871976390408170752765e-16, 7, "", -7},
  {2.6766934117094087500000000e+14, 19, "267669341170940875", 15},
  {1.3521438516406845703125000e+13, 20, "13521438516406845703125", 14},
  {1.5874660623549867630657795e-16, 7, "", -7},
  {1.3750999364434151051028721e+00, 17, "137509993644341511", 1},
  {1.8887828668181290176422617e-24, 10, "", -10},
  {9.3901408206973227833758676e-08, 9, "94", -7},
  {8.0527463743053721600000000e+18, 13, "805274637430537216", 19},
  {6.1072669582699820399284363e+07, 15, "61072669582699820399284", 8},
  {5.6761645033570647721083282e-14, 0, "", 0},
  {2.7902338556548347696661949e+03, 6, "2790233856", 4},
  {4.1304973682158451663008639e-11, 8, "", -8},
  {6.7569760381877091391562110e-15, 14, "1", -13},
  {2.4928736626115127623928609e-19, 0, "", 0},
  {1.9855659061741582031250000e+13, 3, "19855659061741582", 14},
  {1.9547106766356652229887914e+00, 0, "2", 1},
  {9.9371474272811624828538055e-14, 7, "", -7},
  {1.9567154190767265511971500e-18, 2, "", -2},
  {1.6182226925333270337432623e+06, 5, "161822269253", 7},
  {5.7846890968330467218532371e-09, 12, "5785", -8},
  {6.7952600096120928226816287e-24, 6, "", -6},
  {2.7935659052505016014697979e-23, 19, "", -19},
  {1.6482248880339871414662940e-14, 10, "", -10},
  {7.1101399780676071847605109e-19, 7, "", -7},
  {1.6074025179814833394069364e-24, 3, "", -3},
  {2.5284627162627683738410410e-11, 18, "25284627", -10},
  {1.9799640139887120574712753e+07, 20, "197996401398871205747127533", 8},
  {3.4562455012690309701898111e-10, 4, "", -4},
  {2.2614831346804262466321234e+03, 0, "2261", 4},
  {6.0710730503297693765753335e-19, 0, "", 0},
  {7.7057315033952263547689654e+03, 17, "770573150339522635477", 4},
  {7.1306295226450202380308932e-14, 17, "7131", -13},
  {6.5351630282618196633807631e-15, 11, "", -11},
  {8.6724719473845245456839620e-06, 14, "867247195", -5},
  {2.2982578960561186926845041e-19, 15, "", -15},
  {6.5182153038696453125000000e+13, 6, "65182153038696453125", 14},
  {1.5808868906265836430940124e-14, 15, "16", -13},
  {9.1075762537035215011919920e-05, 14, "9107576254", -4},
  {1.2402114813354125583165259e-09, 7, "", -7},
  {1.2513558071428703125000000e+14, 6, "12513558071428703125", 15},
  {3.2650691521427394710309562e-24, 7, "", -7},
  {6.0124379154437491916800000e+20, 7, "601243791544374919168", 21},
  {1.9838256186293799158746027e-11, 5, "", -5},
  {9.2926436613234693595586577e+02, 0, "929", 3},
  {2.6463839507536615625000000e+14, 5, "26463839507536615625", 15},
  {2.9421813114806387587664892e-25, 18, "", -18},
  {2.8472001562004040578938484e-23, 14, "", -14},
  {1.3479456993914366077363942e-04, 15, "134794569939", -3},
  {2.0136792015792664729334762e-08, 7, "", -7},
  {1.5724897345368328125000000e+14, 16, "15724897345368328125", 15},
  {1.5133166786057663962915548e-09, 17, "151331668", -8},
  {4.6555473792439930977185656e-08, 3, "", -3},
  {8.5341387525562211521901190e+04, 18, "85341387525562211521901", 5},
  {3.3359618119719248046875000e+12, 9, "3335961811971924804688", 13},
  {8.1429154207383927273885419e-22, 9, "", -9},
  {6.0234642284145400000000000e+16, 19, "602346422841454", 17},
  {2.0003963864009735971194459e+03, 18, "2000396386400973597119", 4},
  {5.3331595117443667014776259e-11, 12, "53", -10},
  {1.4409243018000712055481927e+01, 19, "144092430180007120555", 2},
  {1.5305351482713564453125000e+12, 20, "15305351482713564453125", 13},
  {1.4559561941942440647238521e-12, 13, "15", -11},
  {2.0954176232292898021114524e+03, 9, "2095417623229", 4},
  {8.2358804051285106688737869e+06, 19, "82358804051285106688737869", 7},
  {2.8769761574427041984630202e-08, 3, "", -3},
  {8.4549610719685167045613747e-24, 11, "", -11},
  {1.9754241663919603411159187e+02, 16, "1975424166391960341", 3},
  {7.5733242128670494670659734e-23, 3, "", -3},
  {3.4745120714887700000000000e+16, 12, "347451207148877", 17},
  {1.6905433941517298844682419e-06, 12, "1690543", -5},
  {5.7021784346833417657762766e+05, 8, "57021784346833", 6},
  {6.6964719649267030839759621e-21, 1, "", -1},
  {2.5395550982721779194328793e-03, 12, "2539555098", -2},
  {8.4375473405226855538785458e+05, 11, "84375473405226856", 6},
  {8.2124566690870712500000000e+14, 11, "821245666908707125", 15},
  {2.3110813223256049364039411e-14, 19, "231108", -13},
  {1.1487442216350916608000000e+20, 11, "11487442216350916608", 21},
  {1.5346788253301923047362261e-21, 13, "", -13},
  {7.7193974725616970000000000e+15, 3, "7719397472561697", 16},
  {6.1866827470561879920296633e+01, 11, "6186682747056", 2},
  {3.1998289761553165382306635e-05, 2, "", -2},
  {8.8271081724482247896518836e-07, 3, "", -3},
  {3.7680921762613276951014996e+05, 4, "3768092176", 6},
  {7.4561729862234327040000000e+18, 16, "7456172986223432704", 19},
  {1.1905206115332798155748151e+00, 12, "1190520611533", 1},
  {2.4940914618897177805736629e-13, 12, "", -12},
  {3.8270523710817232486400000e+20, 14, "382705237108172324864", 21},
  {7.9506703018293863355942612e-09, 19, "79506703018", -8},
  {7.7899059592253862940014572e-23, 2, "", -2},
  {1.0805218960248114541172981e+07, 4, "108052189602", 8},
  {2.9249487017450808027051655e-25, 14, "", -14},
  {5.6418992896604548150207847e+04, 1, "56419", 5},
  {6.2675336278971294754375513e-07, 12, "626753", -6},
  {6.3213654516212298473988584e-05, 8, "6321", -4},
  {1.3523338303582505805791089e-24, 12, "", -12},
  {2.4736458393268001554332614e-01, 9, "247364584", 0},
  {6.0519298471300584507193640e-14, 6, "", -6},
  {2.5429012272345169920000000e+20, 5, "2542901227234516992", 21},
  {1.1384384252114860740338491e-07, 11, "11384", -6},
  {3.3103281286631609211856211e-11, 18, "33103281", -10},
  {3.7924498194933602434130906e-09, 10, "38", -8},
  {1.2227159273914078125000000e+13, 13, "12227159273914078125", 14},
  {3.9960866036318669319152832e+09, 4, "39960866036319", 10},
  {3.6112148698103924861058676e-24, 4, "", -4},
  {6.2455966866486315999280012e-25, 18, "", -18},
  {1.0474050611754850822168989e-14, 19, "104741", -13},
  {1.1543132504231497226626517e-20, 5, "", -5},
  {3.9781652180076096641386796e-04, 3, "", -3},
  {6.5602974152025702400000000e+20, 12, "656029741520257024", 21},
  {3.7411343427957788420949411e-09, 15, "3741134", -8},
  {5.1129177549103023442697493e-12, 12, "5", -11},
  {5.2053373742109158205702913e-15, 15, "5", -14},
  {2.2354617494449731893837452e+06, 2, "223546175", 7},
  {5.6777576640382348800000000e+17, 0, "567775766403823488", 18},
  {3.8915676761061308827948033e-21, 2, "", -2},
  {5.6642638229714204038272097e-14, 12, "", -12},
  {5.7021702242386182576568798e-17, 18, "57", -16},
  {2.6639221497088773100309781e-20, 0, "", 0},
  {2.6319886334679754327225965e+03, 9, "2631988633468", 4},
  {1.3382355059893258153361963e-12, 9, "", -9},
  {3.1342354501739801951609461e-06, 0, "", 0},
  {2.5540087744097646670140265e-12, 17, "255401", -11},
  {6.0327212604689906250000000e+13, 8, "6032721260468990625", 14},
  {4.3823634747591195312500000e+13, 7, "438236347475911953125", 14},
  {2.0632604871973697593604642e-14, 12, "", -12},
  {6.7568414488871200718200782e-02, 1, "1", 0},
  {1.5695581864379201889038086e+10, 9, "15695581864379201889", 11},
  {2.0963078912085460615344346e+04, 15, "20963078912085460615", 5},
  {2.0613536079734768868831907e+00, 0, "2", 1},
  {1.3599953664079918526113033e+06, 14, "135999536640799185261", 7},
  {2.7394669793405985132142199e-17, 18, "27", -16},
  {1.4665732966491989791393280e+06, 3, "1466573297", 7},
  {6.4646679044044912109375000e+12, 13, "64646679044044912109375", 13},
  {1.6774331478034059993393272e-08, 20, "1677433147803", -7},
  {1.1929827207837151957509617e-08, 20, "1192982720784", -7},
  {1.9180786475218024141249119e-06, 19, "19180786475218", -5},
  {9.0150062431929002817654125e-25, 9, "", -9},
  {3.0020187463010950467331103e-20, 8, "", -8},
  {2.6236728099132009887695312e+11, 18, "262367280991320098876953125", 12},
  {1.6400119228186941455760461e+01, 16, "164001192281869415", 2},
  {4.1452275600809951232000000e+19, 1, "41452275600809951232", 20},
  {1.1091918685505900573730469e+11, 17, "1109191868550590057373046875", 12},
  {2.9184758833502768001375175e-14, 0, "", 0},
  {3.2163471043502562679350376e+05, 0, "321635", 6},
  {2.9983651513458300000000000e+14, 18, "299836515134583", 15},
  {1.6711467550830041503906250e+11, 15, "1671146755083004150390625", 12},
  {3.6909449098850141603861408e-04, 9, "369094", -3},
  {1.1832044485907748635783918e-20, 8, "", -8},
  {6.8965286717466090552884250e-23, 5, "", -5},
  {3.9827347339584784347010782e-01, 19, "3982734733958478435", 0},
  {3.0207613322804838400000000e+19, 13, "302076133228048384", 20},
  {7.7888116998738828060092144e-11, 8, "", -8},
  {4.1609366422411727361533180e-08, 8, "4", -7},
  {5.3693916043691463055619638e-11, 8, "", -8},
  {1.0007296173706091771404836e-03, 14, "100072961737", -2},
  {1.0600599652764627075195312e+11, 18, "106005996527646270751953125", 12},
  {2.3014668408770464886528558e-19, 11, "", -11},
  {1.6821541490304317287915049e-09, 5, "", -5},
  {1.2260208476658345124040914e-05, 14, "1226020848", -4},
  {1.8517740834477467615215573e+02, 20, "18517740834477467615216", 3},
  {2.1800535402538032125896450e-01, 18, "218005354025380321", 0},
  {8.9006044251097168307751417e+05, 8, "89006044251097", 6},
  {4.9494360620655222196984796e-05, 7, "495", -4},
  {1.0161916302226157526595525e-14, 16, "102", -13},
  {2.3331257844495052800000000e+19, 5, "233312578444950528", 20},
  {1.9149121739719487839548030e-24, 9, "", -9},
  {4.5189836652609052533111079e-22, 15, "", -15},
  {5.9079500179269975000000000e+14, 11, "59079500179269975", 15},
  {1.3704677655470851686400000e+20, 19, "137046776554708516864", 21},
  {1.6081337132086593318031830e-22, 6, "", -6},
  {3.7344828717127987828041738e-22, 3, "", -3},
  {2.0383873183308237791061401e+08, 19, "2038387318330823779106140137", 9},
  {1.2790356625895702683166910e-05, 11, "1279036", -4},
  {2.4306144526101882381561133e-12, 2, "", -2},
  {1.1757804255760751983829119e-23, 9, "", -9},
  {1.3987012831471747920495839e-24, 17, "", -17},
  {2.8701018988391677856445312e+10, 9, "28701018988391677856", 11},
  {9.0502915290437101702991640e+02, 3, "905029", 3},
  {1.9824826796817450191678175e-24, 6, "", -6},
  {1.1079822381003967795754356e-17, 11, "", -11},
  {7.4763626781424001699124711e-19, 16, "", -16},
  {5.3617214860557720828164141e-14, 5, "", -5},
  {5.8829096447534602240000000e+18, 12, "5882909644753460224", 19},
  {1.3927726956550342213480762e-07, 0, "", 0},
  {4.9691542829752474790439010e+05, 20, "4969154282975247479043901", 6},
  {2.0614009582094224169850349e+06, 6, "2061400958209", 7},
  {1.5734560225342777589468412e-11, 13, "157", -10},
  {2.0107900307840950272000000e+19, 17, "20107900307840950272", 20},
  {1.2793859423709583142936867e-11, 18, "12793859", -10},
  {6.2067200511946456909179688e+10, 8, "6206720051194645691", 11},
  {1.5391439294613847906255432e-07, 0, "", 0},
  {2.3241005025356007429593319e+00, 12, "2324100502536", 1},
  {3.5645653148478642863270643e-05, 15, "35645653148", -4},
  {4.8175064894908973656129092e+03, 6, "4817506489", 4},
  {5.2281595667410249710083008e+09, 5, "522815956674102", 10},
  {3.1400921140600585208816553e-19, 9, "", -9},
  {1.2031638142161902721609159e-09, 10, "12", -8},
  {9.1782614389005870819091797e+09, 8, "917826143890058708", 10},
  {5.0073178618522658406400000e+20, 8, "500731786185226584064", 21},
  {6.5204883316009684376850168e-16, 18, "652", -15},
  {6.2199183059632970000000000e+15, 18, "6219918305963297", 16},
  {3.0581026396083949814299680e-11, 20, "305810264", -10},
  {3.3677119596347974400000000e+17, 5, "336771195963479744", 18},
  {1.3229464252372854219568302e-05, 4, "", -4},
  {3.4105367397460902623151924e+01, 10, "341053673975", 2},
  {3.7290094761045294334993637e-15, 13, "", -13},
  {1.8808932512701315431513649e+02, 9, "188089325127", 3},
  {5.0177636953751911642029881e+05, 7, "5017763695375", 6},
  {9.4943703173238727867040874e-17, 1, "", -1},
  {4.2660719560137387695312500e+12, 6, "426607195601373877", 13},
  {5.0755176009393502406519261e-03, 16, "50755176009394", -2},
  {1.3939985858735923200000000e+17, 2, "139399858587359232", 18},
  {7.8434904828829074552309919e-02, 6, "78435", -1},
  {6.5282211304051152023220084e-01, 10, "652822113", 0},
  {3.6401123184871410449542667e-17, 11, "", -11},
  {3.3888765662406420926232320e-08, 18, "33888765662", -7},
  {3.1326239862920451741956640e+03, 4, "3132624", 4},
  {3.8309579025075776610234307e-25, 9, "", -9},
  {3.8108107497018664062500000e+13, 5, "3810810749701866406", 14},
  {1.0638448724955473285351884e-06, 18, "1063844872496", -5},
  {2.0693496039115614257752895e+05, 7, "2069349603912", 6},
  {2.6512932724419083546826129e-25, 20, "", -20},
  {4.6229361665489496581469845e-20, 12, "", -12},
  {2.9296064395194463259031181e+00, 8, "292960644", 1},
  {8.0797205256680845867803353e-22, 16, "", -16},
  {2.3235183627884085143709952e-25, 11, "", -11},
  {2.7144342128519624767452656e-17, 4, "", -4},
  {3.5274777637996032827776736e-13, 18, "352748", -12},
  {1.9344086828336812811102163e+00, 7, "19344087", 1},
  {1.4840814813321405365303951e-03, 3, "1", -2},
  {1.5046543057043444824218750e+12, 9, "1504654305704344482422", 13},
  {2.1471928636881918864886363e-13, 15, "215", -12},
  {1.4582652849571131145526834e-24, 11, "", -11},
  {1.1448769499681795025480824e+02, 9, "114487694997", 3},
  {1.3734315486566528502833525e-13, 19, "1373432", -12},
  {4.1176888753754492440294102e-10, 20, "41176888754", -9},
  {2.5331559404060432810941450e-05, 10, "253316", -4},
  {1.0808019326348530739778653e+04, 14, "1080801932634853074", 5},
  {5.8260959700665949977192032e-06, 9, "5826", -5},
  {8.3949515800518900059416642e-18, 2, "", -2},
  {1.3744343382596136960000000e+18, 12, "1374434338259613696", 19},
  {3.0919156900999629466577783e-20, 15, "", -15},
  {7.2926953121282123149171639e+00, 20, "729269531212821231492", 1},
  {1.3862998525220179557800293e+08, 12, "138629985252201795578", 9},
  {2.6169055098998741296337732e-25, 1, "", -1},
  {1.5768786878949046572161317e-20, 6, "", -6},
  {5.2165225836741381883621216e+08, 10, "5216522583674138188", 9},
  {1.8321530047323307578976996e-22, 15, "", -15},
  {8.1477509004104378570521765e-22, 3, "", -3},
  {3.2213532522332007094331500e-12, 11, "", -11},
  {7.5756484297984361120370522e-01, 6, "757565", 0},
  {4.7431434057038469472900033e+05, 9, "474314340570385", 6},
  {4.8261558558653279612900012e-10, 4, "", -4},
  {3.4406570733521614856841245e-24, 10, "", -10},
  {3.2649737403832906901257616e-01, 19, "326497374038329069", 0},
  {2.3737823884949306957423687e+06, 20, "23737823884949306957423687", 7},
  {1.1761736602909628906250000e+13, 8, "1176173660290962890625", 14},
  {1.0004210290638703680785833e-17, 5, "", -5},
  {2.7207388761213835780714664e-19, 1, "", -1},
  {2.4699220910867578880000000e+18, 11, "2469922091086757888", 19},
  {5.8078995888902169614991995e-17, 18, "58", -16},
  {2.0149776386777259124046818e-14, 14, "2", -13},
  {3.1919615936805713965666409e-07, 15, "319196159", -6},
  {2.4925399298421034812927246e+09, 20, "249253992984210348129272460938", 10},
  {4.2732143904946146006906815e-02, 15, "42732143904946", -1},
  {4.3716968542036573465184800e-07, 8, "44", -6},
  {5.1607183205689664882057197e-08, 2, "", -2},
  {3.9629094401787980617706155e-13, 14, "4", -12},
  {3.2005686268895301818847656e+09, 13, "32005686268895301818848", 10},
  {7.9999675173243800909694442e-22, 3, "", -3},
  {5.7782966777757122560000000e+18, 19, "5778296677775712256", 19},
  {6.0327210318401363053908426e+01, 20, "6032721031840136305391", 2},
  {2.0195934300225772094726562e+11, 2, "20195934300226", 12},
  {7.7613233365642027185802843e-23, 9, "", -9},
  {6.0789394535679479607215831e-10, 7, "", -7},
  {8.9827887400663921131606159e-16, 11, "", -11},
  {2.3658290708292314547250978e-12, 20, "236582907", -11},
  {9.0731709415394845772233969e-23, 14, "", -14},
  {2.1707359244294702946222478e-17, 4, "", -4},
  {4.5555276050927981002320048e-17, 9, "", -9},
  {1.0688371795742580838695091e-01, 20, "10688371795742580839", 0},
  {5.1172932799321424681693316e+04, 8, "5117293279932", 5},
  {1.0678186003476516427451856e-06, 10, "10678", -5},
  {3.6188947069768656370544516e-19, 14, "", -14},
  {8.3600556530298490880000000e+18, 17, "8360055653029849088", 19},
  {5.7065699868289763469068881e-21, 16, "", -16},
  {2.2181956405323290103930948e-23, 3, "", -3},
  {1.5123054983061800271570974e+02, 7, "1512305498", 3},
  {1.7106717993756875161600000e+20, 17, "171067179937568751616", 21},
  {2.8755441428692296875000000e+13, 16, "28755441428692296875", 14},
  {1.0186555201656734570860863e+07, 1, "101865552", 8},
  {2.0005764637144631706178188e+05, 5, "20005764637", 6},
  {1.9123413171604804574599257e+03, 8, "191234131716", 4},
  {4.7366550273463356018066406e+10, 2, "4736655027346", 11},
  {1.1001783458749217987060547e+10, 2, "1100178345875", 11},
  {1.5349736040908942992849116e-13, 17, "1535", -12},
  {4.1649624303140752588800000e+20, 9, "416496243031407525888", 21},
  {3.0438770471087019890546799e+07, 5, "3043877047109", 8},
  {3.6221472712286755923067971e-23, 19, "", -19},
  {3.4164106462840019128446306e-24, 8, "", -8},
  {1.4815639247507183616000000e+19, 7, "14815639247507183616", 20},
  {3.7028019076348634569528784e-04, 0, "", 0},
  {4.2214567131485921436251374e+02, 12, "422145671314859", 3},
  {2.0609849959487391946074525e-07, 10, "2061", -6},
  {8.0403495090789005780061249e-08, 11, "804", -7},
  {1.2573602358838618669043920e-14, 3, "", -3},
  {4.2127458029365295976809757e-10, 5, "", -5},
  {3.8600978866720761646226436e-22, 8, "", -8},
  {1.3112480751316110000000000e+15, 2, "1311248075131611", 16},
  {1.3053426644455600640000000e+18, 14, "1305342664445560064", 19},
  {3.2474109292505243272930946e-25, 18, "", -18},
  {3.1669120831805356702099370e-14, 4, "", -4},
  {1.0589846431815138979464809e-05, 9, "1059", -4},
  {6.8765285016629477876512215e-23, 7, "", -7},
  {6.8308372662066253980131351e-06, 7, "68", -5},
  {1.5331413347337881457744357e-17, 17, "2", -16},
  {1.6277845109065023198599087e-06, 16, "16277845109", -5},
  {1.7805863660669106231002133e-10, 12, "178", -9},
  {2.6825211004246830103644325e-23, 8, "", -8},
  {3.0716878461251215399686366e-10, 13, "3072", -9},
  {1.6005853302569105955704527e-22, 11, "", -11},
  {1.2206190795036278706486079e-19, 19, "1", -18},
  {5.8241261481700302673125344e-07, 3, "", -3},
  {9.8246589059109317173002507e-13, 7, "", -7},
  {1.4414187473595058657827556e-24, 4, "", -4},
  {1.9198327479304064802079210e+00, 8, "191983275", 1},
  {4.4833659739542892202734947e+06, 9, "4483365973954289", 7},
  {1.1460346865430069527011841e-15, 4, "", -4},
  {3.4920379407889665600815687e-05, 2, "", -2},
  {3.8332179038134784000000000e+16, 3, "38332179038134784", 17},
  {4.9682855533761966503453189e-08, 7, "", -7},
  {1.8039375656625677947886288e+04, 20, "1803937565662567794788629", 5},
  {3.9582015406423855527507815e-14, 11, "", -11},
  {1.4952219247210324345021965e-10, 15, "149522", -9},
  {7.1353099396513552742916354e-21, 9, "", -9},
  {5.0017571951608419418334961e+07, 15, "50017571951608419418335", 8},
  {7.4577962150845012500000000e+14, 8, "745779621508450125", 15},
  {2.1059462780963716612607842e-05, 1, "", -1},
  {6.6437269446889749082322857e-22, 10, "", -10},
  {8.1988062869455407714843750e+11, 0, "819880628695", 12},
  {1.4315451880034865668240750e-15, 10, "", -10},
  {2.1471092390771921875000000e+14, 14, "21471092390771921875", 15},
  {8.7358487122216864972800000e+20, 12, "873584871222168649728", 21},
  {1.1312249266218897536528942e-01, 3, "113", 0},
  {8.4113606426113197812810540e+04, 3, "84113606", 5},
  {4.9282397754322023731737577e-25, 6, "", -6},
  {2.7107718028263463440984265e-21, 2, "", -2},
  {3.9068843698991311717164317e-25, 13, "", -13},
  {1.3875139057202799245715141e+07, 7, "138751390572028", 8},
  {8.1537652411311073525086688e-17, 9, "", -9},
  {9.0804968275435736343729242e-14, 2, "", -2},
  {3.6653449205973884582519531e+10, 9, "36653449205973884583", 11},
  {3.1194066832303951872000000e+19, 4, "31194066832303951872", 20},
  {1.3413399036783144628179506e-10, 13, "1341", -9},
  {2.3785977739644317696000000e+19, 19, "23785977739644317696", 20},
  {4.4956851374396219392000000e+19, 12, "44956851374396219392", 20},
  {2.6762617924323368612249396e+00, 16, "26762617924323369", 1},
  {3.3411578852280524642992532e+02, 20, "33411578852280524642993", 3},
  {5.2971425978965119406999262e-04, 16, "5297142597897", -3},
  {1.6002060790338537117349915e+04, 19, "160020607903385371173499", 5},
  {1.1070198035903735808000000e+19, 12, "11070198035903735808", 20},
  {6.0981799569747988480000000e+18, 3, "6098179956974798848", 19},
  {1.4150317365350326272000000e+19, 8, "14150317365350326272", 20},
  {2.3291798262818208606147111e-18, 17, "", -17},
  {1.4167313013642467467434471e+03, 3, "1416731", 4},
  {1.8712299196085839397772610e-07, 9, "187", -6},
  {2.0476817114031069278717041e+09, 17, "20476817114031069278717041", 10},
  {9.0816545245909554440732956e-16, 12, "", -12},
  {4.1028994914649456743536646e-11, 2, "", -2},
  {1.3990149703226228885405424e-03, 9, "1399015", -2},
  {1.2720932021844374815416095e-20, 15, "", -15},
  {1.5435379921674218797338212e-18, 10, "", -10},
  {2.0074165129068721588619653e-10, 11, "2", -9},
  {1.9465569777964554309705903e-19, 14, "", -14},
  {3.0086663462748780606718316e-06, 12, "3008666", -5},
  {2.1599602986290080601435267e-25, 3, "", -3},
  {1.0809596328747049620352091e-13, 11, "", -11},
  {7.8816978567268249600000000e+17, 4, "788169785672682496", 18},
  {6.0782842616161060822631453e-12, 1, "", -1},
  {1.3860848833429008722305298e+07, 17, "138608488334290087223053", 8},
  {1.7606952238120246079233766e+02, 16, "1760695223812024608", 3},
  {2.9660938304743445250253198e-21, 17, "", -17},
  {5.5940338859167928000000000e+16, 6, "55940338859167928", 17},
  {5.7888668570227526117416561e-04, 20, "57888668570227526", -3},
  {7.1664383372259663181270050e-08, 20, "7166438337226", -7},
  {7.5066093466333939200000000e+17, 8, "750660934663339392", 18},
  {2.4910339977085378560000000e+18, 15, "2491033997708537856", 19},
  {8.7588463452202696353197098e+06, 18, "875884634522026963531971", 7},
  {1.5196862501106551870261319e-04, 2, "", -2},
  {4.0706357790966105461120605e+08, 13, "4070635779096610546112", 9},
  {6.1319995109440728000000000e+16, 10, "61319995109440728", 17},
  {9.2234238580815456134964769e-04, 15, "922342385808", -3},
  {6.3989022294578844594070688e+03, 19, "63989022294578844594071", 4},
  {2.0334042666540460586547852e+09, 6, "2033404266654046", 10},
  {1.9083781361349542400000000e+18, 15, "190837813613495424", 19},
  {2.5362244955902896281594867e-15, 8, "", -8},
  {8.4478206610168306523774336e-13, 8, "", -8},
  {2.7890373556737722537945956e+04, 12, "27890373556737723", 5},
  {4.5795522863486318750000000e+14, 1, "4579552286348632", 15},
  {1.4539246869766134877781354e-10, 4, "", -4},
  {8.2700281392258005142211914e+09, 17, "827002813922580051422119141", 10},
  {2.9234959275140853796060014e-01, 4, "2923", 0},
  {4.0855443373821966951384052e-08, 13, "408554", -7},
  {3.0239847210921809164574370e+04, 19, "302398472109218091645744", 5},
  {1.7704084160309274258362563e-22, 5, "", -5},
  {2.7103312135017165740435985e-01, 10, "2710331214", 0},
  {4.0448823377493493652343750e+11, 13, "4044882337749349365234375", 12},
  {7.3116713146498810260709433e+01, 0, "73", 2},
  {2.5481434046427793094748460e-23, 9, "", -9},
  {3.2118659330337786528275501e+00, 17, "321186593303377865", 1},
  {1.3497569435791885480284691e+06, 14, "134975694357918854803", 7},
  {2.6403814345824426269531250e+11, 12, "264038143458244262695313", 12},
  {1.1347630209898757324218750e+12, 18, "1134763020989875732421875", 13},
  {1.2288828820664968750000000e+13, 14, "1228882882066496875", 14},
  {1.0725227450482191603001992e-10, 10, "1", -9},
  {6.9780303477059399414062500e+11, 3, "697803034770594", 12},
  {3.3099892782300663808000000e+19, 12, "33099892782300663808", 20},
  {5.1140265448755636184304668e-05, 7, "511", -4},
  {3.7484744417309673887143243e-20, 19, "", -19},
  {2.0079945619257735631908713e-10, 13, "2008", -9},
  {1.7762823801912360000000000e+15, 15, "1776282380191236", 16},
  {4.7158521342324599708961501e-06, 12, "4715852", -5},
  {1.1696787633007594711988806e-07, 12, "116968", -6},
  {6.9507464499550285339355469e+09, 14, "695074644995502853393555", 10},
  {4.7426507186156232658785054e-08, 19, "474265071862", -7},
  {1.0417651542446853333429691e-08, 11, "1042", -7},
  {2.2604364269199863331131664e-13, 8, "", -8},
  {2.9224712243495367475200000e+20, 19, "292247122434953674752", 21},
  {2.6165627414194353786685426e-05, 7, "262", -4},
  {1.8016615657983189868751595e-01, 10, "1801661566", 0},
  {2.4804104362867399680000000e+18, 15, "2480410436286739968", 19},
  {8.9665665503052801644547076e-05, 10, "896657", -4},
  {5.8495219079908376576000000e+19, 18, "58495219079908376576", 20},
  {4.5234130300258876953125000e+12, 0, "4523413030026", 13},
  {1.0128850256946252248377769e-10, 14, "10129", -9},
  {8.7162262790328002697278938e-20, 4, "", -4},
  {1.1723098983213882446289062e+09, 10, "11723098983213882446", 10},
  {5.6404010053173071065346633e-03, 17, "564040100531731", -2},
  {5.1555362653608582945707894e+01, 15, "51555362653608583", 2},
  {9.6327440195133566856384277e+08, 8, "96327440195133567", 9},
  {7.5227289983047780990600586e+09, 2, "75227289983", 10},
  {2.0966042868092715000000000e+15, 18, "20966042868092715", 16},
  {7.4711913780047511934867543e+00, 13, "74711913780048", 1},
  {3.1323119127681937365695070e-06, 17, "313231191277", -5},
  {2.9553454915926469920295361e-02, 14, "2955345491593", -1},
  {1.6547032715460610855076357e-14, 19, "16547", -13},
  {1.4006781171865111756800000e+20, 11, "140067811718651117568", 21},
  {1.4130045366870423728666850e-02, 17, "1413004536687042", -1},
  {1.1756980209367375000000000e+14, 8, "11756980209367375", 15},
  {1.5525798267954517159181078e-11, 6, "", -6},
  {4.9127426599525544000000000e+16, 0, "49127426599525544", 17},
  {3.0071258214917872658147532e-06, 13, "30071258", -5},
  {1.5698355953917262795016541e+01, 14, "1569835595391726", 2},
  {3.6921408265424654735438535e-07, 4, "", -4},
  {7.6068027424509842819718917e-23, 1, "", -1},
  {1.8396453601007151603698730e+08, 13, "183964536010071516037", 9},
  {1.1753152180722195147538368e-14, 9, "", -9},
  {1.8279416752421213665513733e+00, 17, "182794167524212137", 1},
  {1.5611113587933069229291005e-05, 10, "156111", -4},
  {3.7724869464297037299077564e-04, 8, "37725", -3},
  {1.6155114073821219304294745e-12, 12, "2", -11},
  {1.0484368496347926330566406e+11, 9, "104843684963479263306", 12},
  {2.6569433512528343869220231e-20, 11, "", -11},
  {3.3971959641701785060267813e-23, 6, "", -6},
  {7.2481758452696720684826914e-01, 4, "7248", 0},
  {3.0410963686336227197722707e-16, 3, "", -3},
  {1.4190568607782905101776123e+09, 6, "1419056860778291", 10},
  {7.5012668920255196641669153e-06, 1, "", -1},
  {7.3905772679766293436176767e-15, 3, "", -3},
  {8.2435078704540193080902100e+07, 10, "824350787045401931", 8},
  {3.9552555810690254820800947e-08, 20, "3955255581069", -7},
  {4.0288135177752494812011719e+07, 16, "402881351777524948120117", 8},
  {1.2084927802347627698467805e-16, 6, "", -6},
  {6.0923987770454523437500000e+13, 3, "60923987770454523", 14},
  {2.1062676431297855644464629e-07, 18, "210626764313", -6},
  {1.7099968768839587500000000e+15, 11, "170999687688395875", 16},
  {6.2604760757957703680000000e+18, 10, "6260476075795770368", 19},
  {1.1636788691138475766175523e-10, 11, "12", -9},
  {8.4189300953210277969618325e-04, 0, "", 0},
  {9.0719679282390841557059957e-01, 11, "90719679282", 0},
  {6.3010084999864559297510304e-17, 9, "", -9},
  {4.8518949022088820938466495e-17, 3, "", -3},
  {2.5336874777830901799002827e-03, 6, "2534", -2},
  {9.9163657237818132157101134e-09, 19, "99163657238", -8},
  {5.7360814362427975739588311e-18, 16, "", -16},
  {4.0655589458186786044890937e-02, 14, "4065558945819", -1},
  {2.3827875511321441584229248e-09, 18, "2382787551", -8},
  {1.3297006295395271081360988e+04, 19, "13297006295395271081361", 5},
  {1.7045634620739787522865049e-25, 14, "", -14},
  {1.0835515153846163070509518e-16, 1, "", -1},
  {2.5064651495892080816566571e-09, 5, "", -5},
  {3.2371957939574985504150391e+09, 7, "32371957939574986", 10},
  {7.1319171533149191024435093e-22, 7, "", -7},
  {4.4665233516329411941114813e+04, 14, "4466523351632941194", 5},
  {1.3111742274871346354484558e+08, 16, "1311174227487134635448456", 9},
  {4.3613576127345660383527989e-22, 15, "", -15},
  {4.6537334841620247347200000e+20, 1, "465373348416202473472", 21},
  {6.4177728941607580184936523e+09, 17, "641777289416075801849365234", 10},
  {2.3104593128788082688000000e+20, 19, "23104593128788082688", 21},
  {4.5325197211241776858905954e-17, 13, "", -13},
  {9.0494782565491671875000000e+13, 6, "90494782565491671875", 14},
  {3.9397480371053971719365131e-11, 15, "39397", -10},
  {1.9218672683036957989243594e-17, 14, "", -14},
  {5.6571818600240403611678630e+04, 6, "565718186", 5},
  {4.5546154765339102596044540e+06, 16, "45546154765339102596045", 7},
  {2.6281552494990128058475337e-05, 0, "", 0},
  {4.5869217290422531250000000e+14, 19, "4586921729042253125", 15},
  {6.2429510760972176179217939e-09, 0, "", 0},
  {1.2852686814278480032867616e-13, 1, "", -1},
  {1.1280193461612807197529891e-08, 6, "", -6},
  {2.1409766474512941824299006e-13, 2, "", -2},
  {3.1035941337250871658325195e+09, 18, "3103594133725087165832519531", 10},
  {4.4560808537133579984355038e-22, 13, "", -13},
  {2.0911321865856773220002651e+06, 1, "20911322", 7},
  {5.7389683035882500000000000e+15, 16, "573896830358825", 16},
  {2.2203856997613280110675872e-17, 20, "222", -16},
  {4.5589145679303015213020575e-08, 9, "46", -7},
  {1.0887254900122185410221709e-04, 19, "1088725490012219", -3},
  {5.1051285219630155245844618e-21, 1, "", -1},
  {1.0938605570212458068100080e-14, 20, "1093861", -13},
  {5.2490101344047552490234375e+11, 15, "52490101344047552490234375", 12},
  {1.1440824155421620074639286e-25, 14, "", -14},
  {6.5080419956050516936541103e-08, 12, "6508", -7},
  {2.5301563334854262695312500e+12, 8, "253015633348542626953", 13},
  {1.3700328702214582743190230e-06, 9, "137", -5},
  {1.1159001503081652832031250e+12, 19, "1115900150308165283203125", 13},
  {2.4070029223669770240000000e+18, 16, "2407002922366977024", 19},
  {1.4795915613505537807869998e-24, 4, "", -4},
  {2.6065827431607296465765423e-20, 14, "", -14},
  {2.2559875127263549930895815e-06, 8, "226", -5},
  {2.0070612325107393677127919e-22, 3, "", -3},
  {4.5392588141885834573940883e+00, 10, "45392588142", 1},
  {1.3146699694998565532926492e-14, 6, "", -6},
  {5.6795682060365098297406107e-13, 12, "1", -11},
  {3.8489332111651529494079387e-19, 5, "", -5},
  {2.5374538127375535774553182e-15, 14, "", -14},
  {2.7179931996343768219048798e+01, 17, "2717993199634376822", 2},
  {8.3389415972905353216000000e+20, 15, "83389415972905353216", 21},
  {1.2277787874413659375000000e+14, 14, "12277787874413659375", 15},
  {4.9078159329841971200000000e+20, 14, "490781593298419712", 21},
  {1.2388665049412596037467166e-19, 2, "", -2},
  {5.3873123255905248640829086e+00, 3, "5387", 1},
  {2.2894165563083535371474609e-11, 18, "22894166", -10},
  {3.3846956791205468073613361e-01, 7, "3384696", 0},
  {1.8227999011911665481820387e-12, 11, "", -11},
  {7.3821279086880285831284709e+03, 16, "73821279086880285831", 4},
  {8.5971388183619216084480286e+07, 7, "859713881836192", 8},
  {5.3049696619065086199975526e-07, 19, "5304969661907", -6},
  {8.2885248525910205346251531e-22, 0, "", 0},
  {8.8445628073336950942935312e-24, 4, "", -4},
  {4.2504900276672500489012296e-20, 6, "", -6},
  {2.1257426374086919582795061e-11, 16, "212574", -10},
  {3.2354626740102446547098225e+02, 10, "323546267401", 3},
  {4.8276111962865420000000000e+15, 1, "4827611196286542", 16},
  {1.1385667179922389062500000e+14, 2, "11385667179922389", 15},
  {2.1787919674786021756716986e-17, 4, "", -4},
  {1.9199917317284023777443153e-16, 15, "", -15},
  {2.7680343299790639134535971e-20, 11, "", -11},
  {5.4652211262598660392909855e-05, 14, "5465221126", -4},
  {6.5742532805480064000000000e+17, 16, "65742532805480064", 18},
  {3.0503365499372890502782674e-24, 18, "", -18},
  {7.1693324589485809326171875e+10, 19, "71693324589485809326171875", 11},
  {2.4937824809605837799608707e+04, 13, "249378248096058378", 5},
  {1.7921590290968688964843750e+11, 12, "179215902909686889648438", 12},
  {6.0462009846024608612060547e+08, 16, "6046200984602460861206055", 9},
  {1.1458969361878016002265213e+02, 12, "11458969361878", 3},
  {2.1956313029631364663885051e+00, 0, "2", 1},
  {4.7728042106190618028260047e-10, 2, "", -2},
  {1.9728470503268022429033124e-02, 6, "19728", -1},
  {2.4905853940379212306593443e-21, 0, "", 0},
  {1.7279465293476594006177082e-15, 7, "", -7},
  {4.2247269900865800445899367e+05, 13, "4224726990086580045", 6},
  {2.6520066968387782400000000e+17, 13, "265200669683877824", 18},
  {2.7433410565574346923828125e+11, 15, "27433410565574346923828125", 12},
  {4.3395400652306591796875000e+12, 13, "43395400652306591796875", 13},
  {2.4552456342574605514528230e+04, 4, "245524563", 5},
  {1.2834161901826916431415922e-13, 15, "128", -12},
  {2.5786142427789054636377841e+04, 4, "257861424", 5},
  {3.6803883200903161154917847e-18, 20, "368", -17},
  {2.3308266990253192879239971e-23, 5, "", -5},
  {8.2397467062358893454074860e+06, 1, "82397467", 7},
  {1.3565447026506930455075090e-06, 6, "1", -5},
  {1.4776935831604850292205811e+08, 18, "147769358316048502922058105", 9},
  {9.6341886011815129313617945e+05, 12, "963418860118151293", 6},
  {1.2149230648764497082545518e-16, 18, "121", -15},
  {6.0054463405216627497771482e-23, 14, "", -14},
  {1.5791441487092243683898336e-23, 1, "", -1},
  {8.2984373721461279296875000e+11, 14, "82984373721461279296875", 12},
  {6.9203016349155490161138005e+01, 18, "69203016349155490161", 2},
  {3.9415985544001787275192328e+03, 6, "3941598554", 4},
  {1.0247508156002011762205474e-18, 0, "", 0},
  {4.7521478174199829120345724e-08, 13, "475215", -7},
  {8.7202195100307830000000000e+15, 9, "8720219510030783", 16},
  {7.2148868531016479045007764e-25, 13, "", -13},
  {1.2259921955504413104698358e-01, 14, "12259921955504", 0},
  {2.6838528146956401474284568e-17, 1, "", -1},
  {9.2573935477011785797454997e-20, 19, "1", -18},
  {2.8955995550850663334131241e+07, 7, "289559955508507", 8},
  {8.1999164302334491703035812e-14, 11, "", -11},
  {2.3085112426355217096762829e-01, 12, "230851124264", 0},
  {5.6506052174709126454643457e-09, 14, "565061", -8},
  {6.8476633187633401499653883e-16, 8, "", -8},
  {1.2892103474987672184382369e-19, 15, "", -15},
  {6.6776858889694372772572544e-14, 4, "", -4},
  {3.1042506540418420755353814e-21, 12, "", -12},
  {3.8722651954872330403957008e-11, 8, "", -8},
  {2.1252389319406906724907458e+05, 11, "21252389319406907", 6},
  {1.8111396204412776976823807e+07, 11, "1811139620441277698", 8},
  {3.2671021428686535664764889e-03, 12, "3267102143", -2},
  {7.6466042748973921385419894e-15, 2, "", -2},
  {8.9882343985324112622947723e+01, 11, "8988234398532", 2},
  {2.4428604069536641471561426e-09, 16, "24428604", -8},
  {5.9891992291817367076873779e+07, 11, "5989199229181736708", 8},
  {9.6977904460060670999155263e+01, 15, "96977904460060671", 2},
  {7.6659143693345851988674156e-02, 13, "766591436933", -1},
  {6.1945676506440308046875399e-22, 15, "", -15},
  {8.7811219412733872960527185e-18, 17, "1", -16},
  {8.1792235029297747464629206e-16, 8, "", -8},
  {1.1459505192668271359008711e-18, 0, "", 0},
  {1.6199326533208730438673228e+02, 14, "1619932653320873", 3},
  {1.9903892936820602389998147e-04, 7, "199", -3},
  {2.0967567360374098667254218e-08, 1, "", -1},
  {7.8997005855717597805312748e-23, 9, "", -9},
  {6.2224606768403260502964258e+05, 19, "6222460676840326050296426", 6},
  {1.0874465502727455804869234e-10, 4, "", -4},
  {1.1543150598938202165300027e+04, 15, "11543150598938202165", 5},
  {6.9288807210142158155008474e+00, 17, "692888072101421582", 1},
  {2.8419000814386643469333649e+05, 16, "2841900081438664346933", 6},
  {4.3997497344848515625000000e+12, 8, "43997497344848515625", 13},
  {1.6977881304825535695168792e-03, 3, "2", -2},
  {3.3562011097610336352321911e-07, 13, "3356201", -6},
  {6.7672298189830980845727026e+03, 7, "6767229819", 4},
  {1.8099096150228248048953905e-19, 8, "", -8},
  {1.4101071001474457999208116e-17, 6, "", -6},
  {1.5143320633734966000000000e+16, 1, "15143320633734966", 17},
  {1.8278206012849235411627561e-25, 15, "", -15},
  {3.5989158035404468708656290e-15, 10, "", -10},
  {2.3052021538838935157400556e+03, 14, "230520215388389352", 4},
  {2.4419368781977849756046277e-11, 19, "244193688", -10},
  {8.5345646792250946164131165e+06, 10, "85345646792250946", 7},
  {4.4515802504268839681453289e-25, 10, "", -10},
  {5.4336904313543222144744504e+01, 9, "54336904314", 2},
  {8.6059426507901965332031250e+11, 20, "8605942650790196533203125", 12},
  {8.1104603069603069458853105e-09, 5, "", -5},
  {2.1181334133228546405351410e-16, 6, "", -6},
  {1.4544138164132676228554926e-18, 20, "145", -17},
  {3.2783937119583476056014103e-12, 2, "", -2},
  {2.8595451046684215811008235e-21, 9, "", -9},
  {2.1510245379885761718750000e+12, 19, "2151024537988576171875", 13},
  {3.8883179594210345680791118e-22, 13, "", -13},
  {5.8607496897551882266998291e+08, 16, "5860749689755188226699829", 9},
  {1.5174792532942984253168106e+06, 13, "15174792532942984253", 7},
  {5.2926453669738201352654004e-11, 6, "", -6},
  {7.0799192199929205191616128e-07, 7, "7", -6},
  {3.0033967462910593894775957e+04, 10, "300339674629106", 5},
  {1.8764350830070992000000000e+17, 12, "18764350830070992", 18},
  {5.3224986934251795251200000e+20, 13, "532249869342517952512", 21},
  {4.4328927010057650000000000e+15, 12, "4432892701005765", 16},
  {1.3164352141207261936983741e+01, 8, "1316435214", 2},
  {1.5659125344120243994439079e+02, 10, "1565912534412", 3},
  {1.7322725245144726746546150e-22, 19, "", -19},
  {3.7636574263150195200000000e+17, 16, "376365742631501952", 18},
  {7.6175623809584882550893781e+00, 3, "7618", 1},
  {1.9362922168363352284359280e+03, 14, "193629221683633523", 4},
  {1.1484353423719544738587415e-24, 5, "", -5},
  {3.7567063357438293616659929e-07, 11, "37567", -6},
  {5.8566507484160005714552529e-21, 0, "", 0},
  {1.4488462763934922693688614e-19, 15, "", -15},
  {7.1589039271371200000000000e+14, 15, "715890392713712", 15},
  {9.1064425734692238620482385e+04, 8, "9106442573469", 5},
  {8.2354480311561080012800000e+20, 14, "823544803115610800128", 21},
  {1.9778689975383694171905518e+09, 7, "19778689975383694", 10},
  {1.6074021297700531431473792e+05, 2, "16074021", 6},
  {1.2030669560538835200000000e+17, 10, "120306695605388352", 18},
  {6.6481578747213787955200000e+20, 3, "664815787472137879552", 21},
  {8.6895141696445366189744284e-16, 18, "869", -15},
  {1.4227185854179676298723955e-21, 5, "", -5},
  {3.3504734282805507064040285e+03, 20, "335047342828055070640403", 4},
  {3.4722124188174537266604602e+04, 18, "34722124188174537266605", 5},
  {3.1152739796240913244900770e-19, 0, "", 0},
  {7.5053426434337812500000000e+12, 6, "750534264343378125", 13},
  {1.3630191345254643042750331e+00, 3, "1363", 1},
  {2.3719849840650383043794136e+02, 3, "237198", 3},
  {1.7798344467296698528935295e-03, 9, "1779834", -2},
  {3.6924200070697295872000000e+19, 14, "36924200070697295872", 20},
  {1.0359062721174585419703362e+02, 5, "10359063", 3},
  {3.1254189977015761625622758e-02, 19, "312541899770157616", -1},
  {4.0333818834807110917591953e-23, 8, "", -8},
  {3.3477905209982105600000000e+18, 15, "334779052099821056", 19},
  {3.9105024450849114584845983e-09, 8, "", -8},
  {8.0926395719614927656948566e+05, 0, "809264", 6},
  {1.7345984311211763671875000e+13, 12, "17345984311211763671875", 14},
  {1.9653341063210564646506594e-17, 0, "", 0},
  {1.6744904021271209414570177e-13, 14, "17", -12},
  {2.6524058270470077421088195e-03, 0, "", 0},
  {5.9589578523167261892012903e+01, 2, "5959", 2},
  {1.5928264243252366781234741e+08, 6, "159282642432524", 9},
  {1.5729742976848516913648676e-12, 19, "15729743", -11},
  {4.9092601399020426511331556e-09, 3, "", -3},
  {3.6351444423005337600000000e+18, 5, "363514444230053376", 19},
  {3.8602304015409937754171828e-25, 0, "", 0},
  {6.9377143666445812058509087e-16, 7, "", -7},
  {1.5599101523650274641032472e-23, 7, "", -7},
  {6.3032438914775566406250000e+12, 0, "6303243891478", 13},
  {1.5825061043691681799956908e-19, 0, "", 0},
  {7.7280676513347825000000000e+14, 2, "77280676513347825", 15},
  {3.4309345930336328293124296e-16, 7, "", -7},
  {1.5445057126955308914184570e+10, 7, "154450571269553089", 11},
  {1.3361702849121507737600000e+20, 11, "133617028491215077376", 21},
  {5.8235202761697038909005641e+01, 14, "5823520276169704", 2},
  {1.0740788417317840952591723e+01, 12, "10740788417318", 2},
  {6.1587143807291136409600000e+20, 14, "615871438072911364096", 21},
  {7.3842817622222879655679462e-13, 13, "7", -12},
  {8.3071146188040770444873315e-22, 19, "", -19},
  {2.0862336375033339843750000e+13, 3, "2086233637503334", 14},
  {5.8306057194642613705387092e-08, 9, "58", -7},
  {3.1549626548620111283317291e-18, 6, "", -6},
  {9.8007765352497665405273438e+10, 17, "980077653524976654052734375", 11},
  {7.3643821153109863188395246e-24, 20, "", -20},
  {1.3325739345003440386450144e-02, 11, "1332573935", -1},
  {2.4637735059065583170800906e-02, 16, "246377350590656", -1},
  {3.7789344949511528280127442e-11, 6, "", -6},
  {7.1339894685892540612191489e-08, 8, "7", -7},
  {6.2081010036524062911666988e+01, 5, "6208101", 2},
  {6.7482689832345997766627503e-08, 14, "6748269", -7},
  {5.4017554761165670167144537e-04, 13, "5401755476", -3},
  {5.3561754612678136000000000e+16, 5, "53561754612678136", 17},
  {4.5831240911523392009274680e-03, 9, "4583124", -2},
  {1.2338327202849744097815518e-21, 11, "", -11},
  {7.1580759510494327930930206e-16, 4, "", -4},
  {1.2631930842098865509033203e+09, 13, "12631930842098865509033", 10},
  {7.3265166499950485229492188e+09, 3, "7326516649995", 10},
  {5.6557951240964932007601189e-14, 4, "", -4},
  {2.7671559322542000561952591e+07, 1, "276715593", 8},
  {1.3098459601361009063680285e+01, 15, "13098459601361009", 2},
  {1.4306358721923555521764631e-15, 18, "1431", -14},
  {4.1403038130861784595234179e-23, 10, "", -10},
  {2.2964759094992752075195312e+11, 11, "22964759094992752075195", 12},
  {1.5759439058861080522112614e-07, 20, "15759439058861", -6},
  {9.6406184232462067157030106e+06, 8, "964061842324621", 7},
  {2.1898481344653189695191311e-15, 16, "22", -14},
  {3.2625693324475716799497604e+06, 2, "326256933", 7},
  {3.2813886905034728205771699e-15, 11, "", -11},
  {2.8297916142274528000000000e+17, 18, "28297916142274528", 18},
  {4.2106570196904229419487820e+00, 15, "4210657019690423", 1},
  {1.4029782542394108540019227e-14, 6, "", -6},
  {1.7068799910798902500000000e+15, 15, "170687999107989025", 16},
  {5.6364054506811074917503994e-20, 12, "", -12},
  {3.3349000824070016602159588e-19, 16, "", -16},
  {4.9959680873975522395757931e-04, 16, "4995968087398", -3},
  {2.1485772597813232640000000e+18, 18, "2148577259781323264", 19},
  {1.0009509461569780273437500e+12, 1, "1000950946157", 13},
  {6.2917625672671234130859375e+10, 2, "6291762567267", 11},
  {5.5922172849705756372514278e-21, 8, "", -8},
  {5.4924173960967444032734722e-18, 20, "549", -17},
  {2.5856141249364857600000000e+17, 1, "258561412493648576", 18},
  {8.3220429160003558338010175e-10, 17, "83220429", -9},
  {2.3601840846869317829259671e+03, 17, "236018408468693178293", 4},
  {2.2941272370603034338326642e-04, 7, "2294", -3},
  {5.9860253420847660475231155e-21, 0, "", 0},
  {1.7325179439612246811685352e-22, 11, "", -11},
  {1.4751195494854761550354925e-21, 5, "", -5},
  {3.9439168139659459996277899e-13, 19, "3943917", -12},
  {4.4246609750252155890849808e-24, 2, "", -2},
  {8.5318266753796517655576420e-23, 12, "", -12},
  {4.7944116073845417575482359e-23, 2, "", -2},
  {9.0735841649570672522561205e-20, 15, "", -15},
  {2.5103627264456345126990677e-13, 6, "", -6},
  {1.2247948755094733996884315e+02, 11, "12247948755095", 3},
  {5.2709025464178811963612829e-18, 16, "", -16},
  {2.1072554317379766376091840e-18, 4, "", -4},
  {3.6550189134263677703755823e-25, 9, "", -9},
  {4.3876963170300644556800000e+20, 4, "438769631703006445568", 21},
  {4.8202181121846901493282294e-18, 5, "", -5},
  {2.0629148602656297500000000e+15, 1, "20629148602656298", 16},
  {3.8915897271266383726073118e-05, 10, "389159", -4},
  {1.3412734570750708133994829e-14, 4, "", -4},
  {2.5143045847048486905225011e-25, 20, "", -20},
  {3.3958504324673381528920668e-03, 10, "33958504", -2},
  {2.2915532855255646609293763e+03, 5, "229155329", 4},
  {3.9525728647497966885566711e+06, 11, "395257286474979669", 7},
  {6.5826477826495392691821352e-11, 1, "", -1},
  {2.7344185459222507668343091e-05, 11, "2734419", -4},
  {2.0321070804796129465103149e+07, 17, "2032107080479612946510315", 8},
  {1.1427320121389236362574593e+02, 13, "1142732012138924", 3},
  {2.2162985119923231673751129e-04, 10, "2216299", -3},
  {3.9971578127921066755090509e-24, 15, "", -15},
  {5.8516776942045256935153053e-12, 10, "", -10},
  {8.1505035371696745727376765e+00, 10, "81505035372", 1},
  {1.0440239049139274541177233e-25, 9, "", -9},
  {5.4901161423281756591796875e+11, 11, "54901161423281756591797", 12},
  {5.8424667551828561803230568e-17, 16, "1", -15},
  {8.3094774669334160836850582e-24, 8, "", -8},
  {2.7700898939970621093750000e+13, 11, "2770089893997062109375", 14},
  {5.0343847640534915820737938e-20, 4, "", -4},
  {7.0151784162893432000000000e+16, 8, "70151784162893432", 17},
  {5.4959738899428864000000000e+17, 14, "54959738899428864", 18},
  {1.0520109677855455676858729e-16, 5, "", -5},
  {4.3248733436764615680000000e+18, 4, "4324873343676461568", 19},
  {6.9405486607262945175170898e+09, 6, "6940548660726295", 10},
  {8.7540318500603365350292385e-23, 2, "", -2},
  {4.1874325912167170000000000e+15, 7, "4187432591216717", 16},
  {2.6354060682734996173211924e-23, 14, "", -14},
  {2.5572666988333152649537834e-17, 5, "", -5},
  {4.9254915074093432000000000e+16, 17, "49254915074093432", 17},
  {6.1502325153259096110249971e-14, 0, "", 0},
  {6.3584749227753316056609486e-19, 3, "", -3},
  {6.2235074845632308651894149e-09, 20, "622350748456", -8},
  {3.6290077848884137347340584e+06, 18, "3629007784888413734734058", 7},
  {5.4489028228463976120110601e+04, 2, "5448903", 5},
  {2.4076668999312571811390823e-15, 13, "", -13},
  {8.3894928849640138460896190e-11, 8, "", -8},
  {8.5884408047073477684985043e-04, 5, "86", -3},
  {1.7088624586211582788841486e-18, 17, "", -17},
  {1.4536861562210423061698772e-10, 18, "145368616", -9},
  {7.5448984214836869078209385e-16, 16, "8", -15},
  {5.9406642424725609370970374e-14, 4, "", -4},
  {1.2766820110675933451755521e-07, 1, "", -1},
  {5.6259058034538196686065589e-11, 7, "", -7},
  {3.5876735662534889472000000e+19, 6, "35876735662534889472", 20},
  {7.9561496652085722072716662e-13, 17, "79561", -12},
  {9.8681000980936038723760967e-20, 2, "", -2},
  {7.8727178079712775797815993e+03, 5, "787271781", 4},
  {3.6854322071595238964926991e-17, 8, "", -8},
  {4.9551638202792708413549480e-07, 19, "4955163820279", -6},
  {1.0714477856224377319449559e+04, 17, "1071447785622437731945", 5},
  {1.4229869894420508558141591e+02, 18, "142298698944205085581", 3},
  {6.1187552404076334119216679e-08, 15, "61187552", -7},
  {1.3960242990902782398023665e-24, 6, "", -6},
  {1.4982988855063694000000000e+16, 18, "14982988855063694", 17},
  {9.8990785642276354905355618e-02, 3, "99", -1},
  {1.2441653885924398769650204e-16, 14, "", -14},
  {1.7640189168344631742984386e-19, 3, "", -3},
  {7.5959777611037387847900391e+09, 20, "75959777611037387847900390625", 10},
  {2.5452466931623476000000000e+16, 11, "25452466931623476", 17},
  {5.6686496020370482081675816e-09, 3, "", -3},
  {1.6825913792769856040168334e-08, 3, "", -3},
  {2.3587691502905817548787759e-21, 17, "", -17},
  {1.6888935266684065572917461e+05, 6, "168889352667", 6},
  {4.2476578618806955548345915e-07, 5, "", -5},
  {1.5009826163438880148164476e-16, 8, "", -8},
  {1.6104848175033421284751967e+03, 2, "161048", 4},
  {9.3894391633190576171875000e+11, 8, "93894391633190576172", 12},
  {7.3616143500269073203200000e+20, 0, "736161435002690732032", 21},
  {5.8120004842740622755005059e-17, 4, "", -4},
  {1.5052903839262660000000000e+15, 10, "1505290383926266", 16},
  {6.1301516547731322880000000e+18, 6, "6130151654773132288", 19},
  {9.0277256108586671507626464e-04, 0, "", 0},
  {9.3248813842165438137490896e-05, 0, "", 0},
  {6.1497888879624719502118715e-11, 11, "6", -10},
  {1.8800473108875601920000000e+18, 3, "1880047310887560192", 19},
  {6.2159000996166947761482414e-17, 7, "", -7},
  {2.3963391608434704000000000e+16, 9, "23963391608434704", 17},
  {5.4684635324959410176276497e-05, 16, "54684635325", -4},
  {4.9161498510830792954525500e-08, 9, "49", -7},
  {7.7855504908134531974792480e+08, 15, "778555049081345319747925", 9},
  {3.1241057788611946105957031e+10, 8, "3124105778861194611", 11},
  {3.9292787874055864320000000e+19, 14, "3929278787405586432", 20},
  {1.8009546437049912877621641e-25, 15, "", -15},
  {1.6870341556334128466143708e-18, 18, "2", -17},
  {1.4390162981986987988000081e-13, 17, "1439", -12},
  {7.0467496594879423342031076e-16, 18, "705", -15},
  {5.6512712320650630039619184e-24, 14, "", -14},
  {1.8183821098913761973381042e+08, 4, "1818382109891", 9},
  {1.1372553607030604325700551e+04, 2, "1137255", 5},
  {4.6729000772791366400000000e+17, 0, "467290007727913664", 18},
  {2.1368600056323890000000000e+15, 11, "2136860005632389", 16},
  {1.0929815331635416015625000e+13, 10, "10929815331635416015625", 14},
  {3.3059420374180584572555698e-20, 11, "", -11},
  {9.9615752845443870895498204e-09, 1, "", -1},
  {2.9083890851357632102400000e+20, 17, "290838908513576321024", 21},
  {1.6864432953531597296362513e-05, 20, "168644329535316", -4},
  {1.6406098255554749965667725e+09, 9, "1640609825555474997", 10},
  {1.9876437939791928320000000e+18, 0, "1987643793979192832", 19},
  {2.2134865570511513600000000e+18, 15, "221348655705115136", 19},
  {8.6527103718628768547205254e+03, 19, "86527103718628768547205", 4},
  {3.7930496030397262074984610e+03, 5, "37930496", 4},
  {2.6912803095417097210884094e+05, 15, "269128030954170972109", 6},
  {1.0084727912919158153025261e-14, 10, "", -10},
  {2.2302465305878402257455662e-01, 20, "22302465305878402257", 0},
  {4.6018692196898100000000000e+14, 1, "460186921968981", 15},
  {2.1228697530891039967536926e+08, 10, "2122869753089103997", 9},
  {2.2223862129332555000000000e+15, 15, "22223862129332555", 16},
  {3.6296362622788332402706146e+07, 3, "36296362623", 8},
  {7.5814010746899188940800000e+20, 5, "758140107468991889408", 21},
  {8.3893125048558683798383129e-03, 12, "8389312505", -2},
  {3.6923936752326780000000000e+15, 1, "3692393675232678", 16},
  {2.7883556133329571615467593e-11, 16, "278836", -10},
  {6.2374368028785000205971301e+04, 4, "62374368", 5},
  {3.3165994403958905000000000e+15, 7, "33165994403958905", 16},
  {4.2613630468625784851610661e+05, 0, "426136", 6},
  {1.9202082158849202400579101e-25, 4, "", -4},
  {8.1650600226306018885225058e+05, 5, "81650600226", 6},
  {7.6183537342866864055395126e+06, 6, "7618353734287", 7},
  {4.5551913539912999340231181e+02, 1, "4555", 3},
  {1.5145393889072298538906076e-05, 19, "151453938890723", -4},
  {7.7936546516927282937103882e+03, 20, "779365465169272829371039", 4},
  {1.6583497031151449055329560e-11, 16, "165835", -10},
  {5.0267846262802144007909102e-14, 19, "502678", -13},
  {1.1594454516926563664247154e-14, 10, "", -10},
  {2.2038432472714869760000000e+18, 10, "2203843247271486976", 19},
  {3.3929303109593054199218750e+11, 4, "3392930310959305", 12},
  {3.2971057152960851641032750e-15, 16, "33", -14},
  {4.4445202773894820769129410e-01, 15, "444452027738948", 0},
  {8.5291947553985278782280339e-07, 10, "8529", -6},
  {5.2338386377764663696289062e+09, 1, "52338386378", 10},
  {3.5171860948139672779777509e-03, 14, "351718609481", -2},
  {1.5065277474483487372365891e-22, 6, "", -6},
  {7.4305588476405361630538950e-17, 18, "74", -16},
  {3.1942299026091186523437500e+12, 3, "3194229902609119", 13},
  {2.9177402536444333236431703e+02, 11, "29177402536444", 3},
  {4.5944717711462168097114045e+01, 18, "45944717711462168097", 2},
  {3.8029410216532173153239743e-16, 1, "", -1},
  {8.5084202885075504041504141e-09, 12, "8508", -8},
  {1.1104006045542950400000000e+18, 14, "111040060455429504", 19},
  {7.9433701468066669804102276e+02, 18, "794337014680666698041", 3},
  {8.1552441759345031250000000e+13, 12, "8155244175934503125", 14},
  {1.4586132858045695271319818e-05, 20, "145861328580457", -4},
  {5.5518567573158472706422588e-24, 16, "", -16},
  {3.9120226115701950000000000e+15, 10, "3912022611570195", 16},
  {6.8502525513950981130714036e-15, 6, "", -6},
  {4.9901454694911971533138067e-12, 18, "4990145", -11},
  {1.7380881342122024813025825e-07, 2, "", -2},
  {6.1595849997448676731437445e+03, 7, "61595849997", 4},
  {1.2172431016789206400000000e+17, 19, "121724310167892064", 18},
  {1.1899106926484855669942765e-22, 19, "", -19},
  {9.1806181177329617545065143e-25, 20, "", -20},
  {3.0268692960319367805944980e-08, 3, "", -3},
  {1.3506865496394751593470573e+07, 13, "135068654963947515935", 8},
  {3.9149402310720343711736291e-01, 12, "391494023107", 0},
  {3.5276042134588549120000000e+18, 16, "3527604213458854912", 19},
  {9.3162609846829651932820227e-06, 1, "", -1},
  {1.3061954093197935468631239e-21, 14, "", -14},
  {4.9020942001383854309870214e-14, 6, "", -6},
  {4.3258752921691171716362068e-21, 18, "", -18},
  {9.3713797761988928414211841e+02, 19, "9371379776198892841421", 3},
  {7.5399184766618080082457590e-15, 14, "1", -13},
  {2.8006587853447461128234863e+09, 12, "2800658785344746112823", 10},
  {1.0479300230565323543469953e-10, 20, "10479300231", -9},
  {3.9942978369585549831390381e+08, 2, "3994297837", 9},
  {5.9510138990927800536155701e+07, 8, "595101389909278", 8},
  {2.0446870421357063680000000e+18, 9, "2044687042135706368", 19},
  {2.5930094157677488000000000e+16, 6, "25930094157677488", 17},
  {8.0340116203197019243921595e-16, 20, "8034", -15},
  {5.8714133171338221846704249e-13, 8, "", -8},
  {1.4750370605677289739626762e-12, 8, "", -8},
  {4.4300671244514127332120995e-05, 17, "4430067124451", -4},
  {1.0609533189502722481751190e-17, 15, "", -15},
  {1.4028459097511473152000000e+19, 15, "14028459097511473152", 20},
  {9.1531067321204332642992085e+01, 6, "91531067", 2},
  {1.7075403505854441872435301e-06, 18, "1707540350585", -5},
  {4.7445354511674007913538426e-14, 6, "", -6},
  {3.3934360309079957504000000e+19, 7, "33934360309079957504", 20},
  {8.7541070682823840520825343e-01, 0, "1", 1},
  {3.4358071411719832031250000e+13, 2, "3435807141171983", 14},
  {2.9397222870960552960000000e+18, 4, "2939722287096055296", 19},
  {3.8339374859988703727722168e+09, 3, "3833937485999", 10},
  {4.6567133846158204928000000e+19, 0, "46567133846158204928", 20},
  {2.9945839028817238425600000e+20, 11, "299458390288172384256", 21},
  {4.3543436653011936595994414e-07, 19, "4354343665301", -6},
  {1.3953058639075218826272365e-17, 20, "1395", -16},
  {7.2820353066765403024140498e-13, 5, "", -5},
  {4.9811670529965274942507862e-09, 5, "", -5},
  {2.6505939030563285156250000e+13, 8, "2650593903056328515625", 14},
  {1.4116465148160822053642632e-21, 10, "", -10},
  {3.1098001645706657415424154e-15, 18, "311", -14},
  {7.7886982678760385513305664e+08, 17, "77886982678760385513305664", 9},
  {1.1771624230201232433319092e+08, 5, "11771624230201", 9},
  {3.2795457588457064628601074e+09, 1, "32795457588", 10},
  {1.6845873651434170000000000e+16, 8, "1684587365143417", 17},
  {3.4609224246089597284384721e-06, 7, "35", -5},
  {1.1610615305268306732177734e+10, 12, "11610615305268306732178", 11},
  {3.4199744356734496000000000e+17, 13, "34199744356734496", 18},
  {1.2002006571279215859249234e+05, 10, "1200200657127922", 6},
  {3.3490529050794961778408904e-08, 15, "33490529", -7},
  {7.4069714763477634278387995e-01, 20, "74069714763477634278", 0},
  {1.2606493448112439637043281e+02, 10, "1260649344811", 3},
  {1.2396233027910629084339085e-07, 13, "1239623", -6},
  {2.8952293280653947591781616e+08, 6, "289522932806539", 9},
  {2.4750385771399024265049249e-02, 4, "248", -1},
  {1.2282292274880883805913360e-15, 0, "", 0},
  {7.0534992538044170240000000e+18, 17, "7053499253804417024", 19},
  {2.3295173625027982780011371e+03, 12, "2329517362502798", 4},
  {5.0791520473613824000000000e+16, 7, "50791520473613824", 17},
  {5.4380398683332642413730474e-14, 2, "", -2},
  {3.4866663663781259765625000e+12, 6, "3486666366378125977", 13},
  {1.4622821935442441701889038e+08, 17, "14622821935442441701889038", 9},
  {6.5430750638474617004394531e+09, 10, "65430750638474617004", 10},
  {2.2841594131475736022805247e-07, 9, "228", -6},
  {1.0375430732857269962416304e-23, 5, "", -5},
  {5.2129398809419767808000000e+19, 1, "52129398809419767808", 20},
  {9.6642276936615134421604828e-23, 15, "", -15},
  {1.4660935300684003522569036e-18, 20, "147", -17},
  {1.8614299014260727562941611e+05, 15, "186142990142607275629", 6},
  {7.2242820033324481919407845e+06, 2, "7224282", 7},
  {1.3788914560670936917336334e-24, 0, "", 0},
  {1.7838141748055535187557147e-10, 4, "", -4},
  {2.6065536375767662500000000e+14, 5, "260655363757676625", 15},
  {1.3473848633730203805392023e-01, 6, "134738", 0},
  {1.1715749250399924014098829e-03, 17, "117157492503999", -2},
  {5.0323248910024401535744543e-23, 2, "", -2},
  {6.0242543751617025904465663e+00, 8, "602425438", 1},
  {9.3778553042448541815501173e-03, 10, "93778553", -2},
  {1.6622869963906188317537271e+00, 9, "1662286996", 1},
  {4.6016695199172398133669049e+04, 6, "46016695199", 5},
  {1.0252695901483003050088882e+07, 0, "10252696", 8},
  {6.4588014752761869910460281e-13, 14, "65", -12},
  {8.0762226948011663421600481e-04, 0, "", 0},
  {5.2782437638538049965578814e-20, 10, "", -10},
  {2.0438832360296491547123690e-05, 4, "", -4},
  {3.2514071851033141768421165e-19, 18, "", -18},
  {1.0987838452915668684365680e-22, 4, "", -4},
  {4.9111216316731289600000000e+18, 1, "491112163167312896", 19},
  {3.5495804424620965000000000e+15, 13, "35495804424620965", 16},
  {1.2469622970154047012329102e+07, 8, "1246962297015405", 8},
  {1.1292045781423135757446289e+10, 16, "112920457814231357574462891", 11},
  {9.5491322419140605926513672e+09, 13, "95491322419140605926514", 10},
  {1.6039554804717039062500000e+13, 14, "160395548047170390625", 14},
  {2.1574283420911254438578908e+02, 20, "21574283420911254438579", 3},
  {9.0961537774818419788136481e-04, 0, "", 0},
  {6.3461642787206096446353893e-09, 18, "6346164279", -8},
  {1.2143687737154838000000000e+16, 14, "12143687737154838", 17},
  {6.3204745086689383381440587e-15, 18, "632", -14},
  {1.2438506439565463273865626e-06, 16, "1243850644", -5},
  {2.3171159026556991181178269e-03, 15, "2317115902656", -2},
  {1.4860402559826682136190357e+03, 1, "1486", 4},
  {1.8157658019971527310064844e-15, 5, "", -5},
  {1.6802619356257324095038246e-22, 17, "", -17},
  {1.9530504391960491456947304e-16, 1, "", -1},
  {3.4293584345317524000000000e+16, 2, "34293584345317524", 17},
  {2.1858778272630345895777282e+02, 20, "21858778272630345895777", 3},
  {2.7024725932733267968000000e+20, 16, "27024725932733267968", 21},
  {9.6708937657488771458633282e-18, 20, "967", -17},
  {2.6780722960552746086590445e-17, 14, "", -14},
  {4.5627321575320168173286128e-11, 6, "", -6},
  {2.0456687843545576715442382e-25, 12, "", -12},
  {1.2103163945125172631378518e+03, 0, "121", 4},
  {1.6647925005325765814632177e+06, 17, "166479250053257658146322", 7},
  {5.6890195823711412224000000e+19, 19, "56890195823711412224", 20},
  {1.7280726487309859977483578e-16, 6, "", -6},
  {1.1323960666092096971624414e+02, 17, "11323960666092096972", 3},
  {1.0830152734454212500000000e+15, 15, "108301527344542125", 16},
  {3.2291358814818582382186908e-18, 18, "3", -17},
  {2.7134537145528046314486084e-13, 17, "27135", -12},
  {1.8476003558607706996871223e-09, 12, "1848", -8},
  {1.8997073943900059916136145e-20, 9, "", -9},
  {3.2240585956658951893533370e-13, 18, "322406", -12},
  {7.5494980976876268386840820e+09, 5, "754949809768763", 10},
  {2.3450712225828678125000000e+14, 15, "23450712225828678125", 15},
  {9.2373499502791702614523149e-14, 9, "", -9},
  {1.9264688340480698449172407e-25, 2, "", -2},
  {8.5475928990912439147682964e-23, 12, "", -12},
  {8.4130382306069759789169720e-12, 10, "", -10},
  {1.0107301462685789062500000e+14, 15, "101073014626857890625", 15},
  {1.6063725628904150710353826e-18, 10, "", -10},
  {2.3419107352912982147551249e-18, 6, "", -6},
  {5.9358795958103194622332986e-14, 1, "", -1},
  {5.7495313902803270000000000e+15, 4, "5749531390280327", 16},
  {1.9237326680416069183863440e-06, 0, "", 0},
  {4.4121584681238957159621350e+01, 4, "441216", 2},
  {6.4022239330841647461056709e+06, 1, "64022239", 7},
  {1.8083136591348864746093750e+12, 7, "18083136591348864746", 13},
  {6.3488300600206557825927803e-16, 10, "", -10},
  {5.1355769585732322460578426e-17, 16, "1", -15},
  {2.2605218329641348266601562e+11, 15, "226052183296413482666015625", 12},
  {1.1206550074602435547800515e-13, 8, "", -8},
  {3.3796692977300623360000000e+18, 6, "3379669297730062336", 19},
  {1.3286535642243484289792832e+02, 18, "132865356422434842898", 3},
  {1.5393344271723916892113759e-21, 20, "", -20},
  {1.1735147274010302307820607e-05, 0, "", 0},
  {3.7443730459713943697008191e-06, 7, "37", -5},
  {1.6452945641263556630917719e+00, 15, "1645294564126356", 1},
  {7.7855368120881068842634031e-22, 6, "", -6},
  {3.1595935240417669120000000e+19, 3, "3159593524041766912", 20},
  {2.4297602375809214729342761e-08, 3, "", -3},
  {5.8702190620163123200000000e+17, 6, "587021906201631232", 18},
  {2.0158197482368054687500000e+13, 2, "2015819748236805", 14},
  {5.2146351678003666944000000e+19, 4, "52146351678003666944", 20},
  {1.9925154381039515137672424e+08, 10, "1992515438103951514", 9},
  {4.6731874310405068229101744e+00, 2, "467", 1},
  {1.1468600317677435000000000e+15, 18, "11468600317677435", 16},
  {3.3162742100783320724508084e-20, 14, "", -14},
  {5.8143261794857007771497592e+03, 13, "58143261794857008", 4},
  {3.6448704347273562306080454e-06, 14, "364487043", -5},
  {2.3623604813260180856904213e-03, 8, "236236", -2},
  {2.6565719352805252899955139e-16, 3, "", -3},
  {5.4436232684465816419105977e+04, 11, "5443623268446582", 5},
  {3.1133380372438194274902344e+10, 8, "3113338037243819427", 11},
  {3.1650906577927344518191034e-16, 8, "", -8},
  {5.6237709575923753771152719e-19, 19, "6", -18},
  {5.1046741047505483948043548e+03, 6, "5104674105", 4},
  {8.1251278326414402656946944e-13, 11, "", -11},
  {1.7726965573310967275473976e-19, 4, "", -4},
  {7.2585455129004254008068253e-04, 17, "72585455129004", -3},
  {2.0866110595502553222875611e-22, 18, "", -18},
  {2.2743446774422106180202891e-25, 20, "", -20},
  {1.5551103310941424570046365e+05, 11, "15551103310941425", 6},
  {1.6989172682371156264808529e-16, 6, "", -6},
  {9.1917453637881469726562500e+09, 5, "919174536378815", 10},
  {4.2030663602092272311617423e-10, 2, "", -2},
  {1.5533779502407414851682159e-12, 16, "15534", -11},
  {1.1298060469810059200000000e+17, 1, "112980604698100592", 18},
  {2.7848691249331245422363281e+09, 5, "278486912493312", 10},
  {5.1852580317102456452138699e-06, 1, "", -1},
  {1.1152851209707839719165179e-02, 17, "1115285120970784", -1},
  {2.9691197046016089818808957e-12, 3, "", -3},
  {2.7644478187039164800000000e+17, 15, "276444781870391648", 18},
  {5.8062221893341110501296498e+00, 14, "580622218933411", 1},
  {3.3931944667345384026543104e-22, 6, "", -6},
  {1.7645834322834734998284636e-23, 5, "", -5},
  {2.5506579349440875000000000e+14, 18, "25506579349440875", 15},
  {3.7533447989898194371026181e-22, 3, "", -3},
  {4.2953486028577982159674475e-12, 0, "", 0},
  {1.0643868359648432922363281e+11, 2, "10643868359648", 12},
  {6.0276823897007226691957775e-24, 8, "", -8},
  {6.9911349614154618130508478e-05, 2, "", -2},
  {2.3710384802261066283790569e+02, 6, "237103848", 3},
  {4.6926706354102578340271072e-17, 6, "", -6},
  {7.4632611423440067998778416e-16, 8, "", -8},
  {3.0829946438079650878906250e+11, 3, "308299464380797", 12},
  {3.8835020321743164062500000e+09, 6, "3883502032174316", 10},
  {4.1378383873837494111999973e-17, 18, "41", -16},
  {1.8517519696243330560000000e+18, 8, "1851751969624333056", 19},
  {1.6589693002713121194879875e-01, 19, "1658969300271312119", 0},
  {1.8974314647933966625714675e+04, 11, "1897431464793397", 5},
  {1.2471660424772452000000000e+16, 19, "12471660424772452", 17},
  {6.3736169183177743107080460e+06, 12, "6373616918317774311", 7},
  {2.6085476825032553710937500e+12, 13, "260854768250325537109375", 13},
  {6.4536540999833610596595408e-18, 10, "", -10},
  {1.9945381569042571875000000e+14, 9, "19945381569042571875", 15},
  {4.9564773164483003216771394e-08, 12, "49565", -7},
  {4.4167064816192755927204416e+01, 18, "44167064816192755927", 2},
  {1.0176574369649164089322627e-16, 15, "", -15},
  {9.1184211076875269879223583e-08, 18, "91184211077", -7},
  {2.8021475761160272668348625e+04, 7, "280214757612", 5},
  {8.8580530543439947506862114e-08, 18, "88580530543", -7},
  {5.2759145732525397071113004e-25, 18, "", -18},
  {1.5746971436859053028456401e+03, 16, "15746971436859053028", 4},
  {2.6964425677740850000000000e+15, 11, "2696442567774085", 16},
  {8.0909286577900263447041780e-17, 8, "", -8},
  {2.2688997160905977068523498e+00, 19, "22688997160905977069", 1},
  {5.3330759766044303894042969e+10, 10, "53330759766044303894", 11},
  {2.1200142916553223887410340e-02, 18, "21200142916553224", -1},
  {8.5132507757398066945746404e-11, 13, "851", -10},
  {5.7207162585920121460669729e-16, 9, "", -9},
  {2.2067038749996135266195907e-02, 10, "220670387", -1},
  {2.1717309018740484949260786e-19, 10, "", -10},
  {7.3198810325418170189760555e-21, 2, "", -2},
  {6.8503265748881863849155567e-06, 16, "68503265749", -5},
  {1.1012288494412427200000000e+17, 5, "110122884944124272", 18},
  {5.5655113792876321609299065e-17, 13, "", -13},
  {4.1983846071370717254467309e+04, 1, "419838", 5},
  {3.5875687220105710439383984e+06, 5, "358756872201", 7},
  {1.1936177816454704301636679e-15, 12, "", -12},
  {5.6814728592395946638049509e-02, 19, "568147285923959466", -1},
  {5.0407821085489488905295730e+05, 13, "5040782108548948891", 6},
  {1.0256147518796781881178504e+01, 19, "102561475187967818812", 2},
  {8.5344557958917700508622344e-23, 14, "", -14},
  {4.9385242568911369462317021e-13, 20, "49385243", -12},
  {1.1981053090606510400000000e+17, 8, "119810530906065104", 18},
  {5.2084636418300152048741163e-10, 14, "52085", -9},
  {1.1127489699501688750000000e+15, 8, "1112748969950168875", 16},
  {7.9507106237453903198242188e+10, 12, "79507106237453903198242", 11},
  {2.0116125383174510207027197e+06, 9, "2011612538317451", 7},
  {2.8488593879626193266007425e-13, 0, "", 0},
  {1.2479451115752768609209533e-19, 17, "", -17},
  {7.4712908897639194037765265e+05, 16, "7471290889763919403777", 6},
  {1.1510506511870980000000000e+16, 10, "1151050651187098", 17},
  {2.3549126170880221875000000e+14, 20, "23549126170880221875", 15},
  {7.9931204245741208799958581e-25, 6, "", -6},
  {1.8788019955383856028841564e-16, 0, "", 0},
  {3.5399123092053240000000000e+15, 15, "3539912309205324", 16},
  {1.0762958855413844480000000e+18, 7, "1076295885541384448", 19},
  {3.2881115163637070509139448e+04, 6, "32881115164", 5},
  {3.5505384999804325068800000e+20, 17, "355053849998043250688", 21},
  {1.4994072940295395840000000e+18, 12, "1499407294029539584", 19},
  {4.1759552141922119140625000e+10, 10, "417595521419221191406", 11},
  {7.6974752568052085674356289e-21, 18, "", -18},
  {2.2635333466963047976605594e+05, 1, "2263533", 6},
  {3.2224045873507699104532076e-03, 19, "32224045873507699", -2},
  {3.8215230487120852400390015e-12, 4, "", -4},
  {4.6884467862780576622758805e-10, 8, "", -8},
  {3.9817007049011281161326743e-07, 8, "4", -6},
  {9.9199109191324169921875000e+11, 4, "9919910919132417", 12},
  {1.6073575697347305504575528e-06, 9, "1607", -5},
  {3.4739014800718551635742188e+10, 20, "347390148007185516357421875", 11},
  {3.1806626481541017126275506e-01, 6, "318066", 0},
  {1.1380901563398510380127919e-06, 13, "11380902", -5},
  {6.4656765246954490430653095e+05, 8, "64656765246954", 6},
  {2.4850574405439043723653469e-02, 4, "249", -1},
  {9.1941693092748050000000000e+14, 1, "9194169309274805", 15},
  {1.8216962095775061203807366e-18, 0, "", 0},
  {7.4396618468658718005394739e-18, 1, "", -1},
  {3.4265291316897410177557033e-25, 1, "", -1},
  {4.1163449276187530307507313e-23, 8, "", -8},
  {6.9229724520615096000000000e+16, 6, "69229724520615096", 17},
  {1.4216150246786626000000000e+16, 16, "14216150246786626", 17},
  {3.5219760071271293750000000e+14, 10, "3521976007127129375", 15},
  {3.8352039358048605295379454e-25, 16, "", -16},
  {9.4939164733464726562500000e+12, 1, "94939164733465", 13},
  {2.9253799730306591796875000e+12, 1, "29253799730307", 13},
  {2.0477102529870488415544340e-07, 20, "2047710252987", -6},
  {2.1728321626293865847401321e+05, 5, "21728321626", 6},
  {3.8814012457629491289847249e-07, 7, "4", -6},
  {1.2357309563052959607259644e-20, 20, "1", -19},
  {7.8823044756797061120000000e+18, 8, "7882304475679706112", 19},
  {3.5459744180141496729600000e+20, 3, "354597441801414967296", 21},
  {1.1058006919402362487769419e-16, 8, "", -8},
  {1.0007570567660653125000000e+14, 17, "10007570567660653125", 15},
  {4.2147208259058306250000000e+14, 19, "4214720825905830625", 15},
  {3.2227875179831814815567537e-03, 6, "3223", -2},
  {1.2924055676414706000000000e+16, 6, "12924055676414706", 17},
  {1.2758963867038506379003593e+01, 5, "1275896", 2},
  {1.3277513796626178722882542e-18, 8, "", -8},
  {8.4406526940503700000000000e+14, 4, "844065269405037", 15},
  {4.8753407236662832000000000e+16, 13, "48753407236662832", 17},
  {5.9551472967710876878455865e-22, 15, "", -15},
  {8.8816324448554387110619775e-09, 14, "888163", -8},
  {9.8923363002210040750838971e-01, 16, "9892336300221004", 0},
  {1.5544614253799282834113176e-18, 6, "", -6},
  {3.2668368927527327886561914e-14, 20, "3266837", -13},
  {8.7798641563922177734375000e+12, 18, "87798641563922177734375", 13},
  {4.7302843614041872546231173e-07, 6, "", -6},
  {7.6403656224673462945962131e-19, 7, "", -7},
  {1.7784236746289682006835938e+11, 1, "1778423674629", 12},
  {1.0014835870144476562500000e+13, 10, "100148358701444765625", 14},
  {2.0438286862018421292304993e+07, 18, "20438286862018421292304993", 8},
  {5.2435569091072574410272722e-02, 5, "5244", -1},
  {5.3976873267593838079392299e+01, 5, "5397687", 2},
  {1.6022430263555001388336958e-17, 6, "", -6},
  {3.9811687355615727174549482e-16, 16, "4", -15},
  {1.5134235437024886400000000e+17, 14, "151342354370248864", 18},
  {1.7339322797911192741704411e-02, 5, "1734", -1},
  {4.3657093384739526823969844e-19, 0, "", 0},
  {4.8219123098855477262906361e-05, 9, "48219", -4},
  {3.1621761966954597656250000e+13, 4, "316217619669545977", 14},
  {3.1170912164433862304687500e+11, 15, "311709121644338623046875", 12},
  {1.7615576941760598241789065e-14, 6, "", -6},
  {2.3512901533582502400000000e+17, 20, "235129015335825024", 18},
  {6.5213598247337082979132802e-06, 3, "", -3},
  {5.2539611020720284814689016e-03, 12, "5253961102", -2},
  {5.1856227746866648000000000e+16, 19, "51856227746866648", 17},
  {2.8976807559896484017372131e+06, 1, "28976808", 7},
  {2.9175030317781004978068549e-05, 7, "292", -4},
  {1.1375214700728785828687251e+05, 10, "1137521470072879", 6},
  {3.3843586258047420501708984e+10, 17, "3384358625804742050170898438", 11},
  {3.0703343141327618997874407e-09, 18, "3070334314", -8},
  {2.2232793966405785062495686e-08, 17, "2223279397", -7},
  {1.6895926897656135199445090e-20, 12, "", -12},
  {2.7490021524566028361549206e-25, 12, "", -12},
  {1.9101061401241894888293969e-09, 0, "", 0},
  {4.8778163087760778378814933e-10, 14, "48778", -9},
  {5.3903786919952430000000000e+15, 19, "5390378691995243", 16},
  {1.8325500090840826032945188e+03, 7, "18325500091", 4},
  {2.1516912249234931413130424e-07, 13, "2151691", -6},
  {1.1767933782628838604800000e+20, 10, "117679337826288386048", 21},
  {1.5120966984777768057949690e-23, 1, "", -1},
  {6.2406185066169071525003034e-22, 10, "", -10},
  {6.9639770273619166756268639e-14, 13, "1", -12},
  {3.2225462447120066826755647e+03, 20, "322254624471200668267556", 4},
  {1.2495921019982722473144531e+11, 7, "1249592101998272247", 12},
  {3.1455878918498763985048201e-25, 0, "", 0},
  {1.8332351634904697479012428e-17, 8, "", -8},
  {9.2900696965239230378620780e-15, 8, "", -8},
  {1.3628644381190252779172385e-15, 13, "", -13},
  {2.0706752863489756000000000e+16, 9, "20706752863489756", 17},
  {3.4068631506258476080792284e-22, 7, "", -7},
  {2.1643910116336697237650214e-07, 1, "", -1},
  {7.7361383450637113412540202e+00, 5, "773614", 1},
  {1.0554225296115908000000000e+16, 5, "10554225296115908", 17},
  {7.3732497611683166046881098e-17, 17, "7", -16},
  {3.2840378910702126080000000e+18, 11, "3284037891070212608", 19},
  {9.0548268470037232000000000e+16, 5, "90548268470037232", 17},
  {1.7734420956530538635173166e-15, 7, "", -7},
  {1.2704446860045175071718404e+03, 11, "127044468600452", 4},
  {2.1593285789322806543029751e-13, 16, "2159", -12},
  {4.8408877459996678597539189e-11, 19, "484088775", -10},
  {4.8812952543539830513945190e-10, 15, "48813", -9},
  {1.2902579833699492694210323e-09, 16, "1290258", -8},
  {3.1363966242473151346814575e+00, 15, "3136396624247315", 1},
  {2.3005211525123636922152831e-05, 14, "2300521153", -4},
  {1.8370035700639616204800000e+20, 19, "183700357006396162048", 21},
  {2.9809423214619750976562500e+10, 5, "2980942321461975", 11},
  {1.3566193407737208642282490e-24, 18, "", -18},
  {4.0405959145751407959323842e+03, 20, "404059591457514079593238", 4},
  {2.0658683469988948495709477e-22, 20, "", -20},
  {7.6633038470342440996319056e+05, 10, "7663303847034244", 6},
  {1.2153495574050022798787781e-23, 14, "", -14},
  {4.1013859996172401462324886e-04, 13, "4101386", -3},
  {3.3393193228019867092370987e+04, 10, "333931932280199", 5},
  {5.6307221991416292966400000e+20, 10, "563072219914162929664", 21},
  {2.4684272335590576171875000e+11, 19, "24684272335590576171875", 12},
  {7.9406386136748397827148438e+10, 1, "794063861367", 11},
  {6.1280673118215810097279642e-24, 18, "", -18},
  {1.9986456132605369930388406e+04, 16, "199864561326053699304", 5},
  {5.0411032388422811031341553e+08, 9, "50411032388422811", 9},
  {1.2613818177975690916546667e-06, 3, "", -3},
  {7.9460772600908810465090111e-22, 0, "", 0},
  {8.1736908977418733000376171e-21, 15, "", -15},
  {1.2873920474912085853969046e-02, 2, "1", -1},
  {1.1896224654076350754627889e-02, 15, "11896224654076", -1},
  {7.9797320608779037500000000e+14, 16, "797973206087790375", 15},
  {1.9339844910418337500000000e+14, 4, "193398449104183375", 15},
  {2.1018940854376528816179273e-05, 15, "21018940854", -4},
  {3.9153943292449143326221563e-22, 5, "", -5},
  {3.5448536170745384765723429e+01, 10, "354485361707", 2},
  {1.2223523878165648437500000e+14, 0, "122235238781656", 15},
  {1.1566318837147938816000000e+19, 8, "11566318837147938816", 20},
  {5.7371265803348681640625000e+11, 11, "57371265803348681640625", 12},
  {3.4862338670089800857231506e-10, 12, "349", -9},
  {2.6822814577484246433933549e-13, 4, "", -4},
  {2.5045991760047056629012729e-02, 3, "25", -1},
  {3.5604977934162658452987671e+08, 12, "35604977934162658453", 9},
  {7.5257389309455147152760901e-01, 1, "8", 0},
  {3.6013776962999264696918544e+02, 9, "36013776963", 3},
  {2.2802068302203714997191796e-06, 15, "228020683", -5},
  {3.8884250047372953600000000e+17, 11, "388842500473729536", 18},
  {2.4733363732791567360000000e+18, 0, "2473336373279156736", 19},
  {2.3380773034726546875000000e+14, 3, "233807730347265469", 15},
  {1.9397544151926912000000000e+18, 11, "19397544151926912", 19},
  {2.5987264231994699776000000e+19, 2, "25987264231994699776", 20},
  {2.4794998819839340800000000e+17, 17, "247949988198393408", 18},
  {2.6891458047840205507834755e-25, 3, "", -3},
  {2.7519923035733979758800728e-18, 14, "", -14},
  {1.6455917106716401576995850e+09, 0, "1645591711", 10},
  {2.9297167805876044800000000e+18, 17, "292971678058760448", 19},
  {2.6265324659307095040000000e+18, 12, "2626532465930709504", 19},
  {3.3862686387107360521394798e-18, 4, "", -4},
  {2.0505615672603657912986819e+03, 13, "20505615672603658", 4},
  {4.3885428966861576890609218e-24, 14, "", -14},
  {1.9027900048637440422400610e-08, 11, "1903", -7},
  {9.3518130351659714391356166e-20, 20, "9", -19},
  {4.7163520299684719109134129e-14, 16, "472", -13},
  {2.2727862103968034121320002e-13, 16, "2273", -12},
  {5.8158228733669954689412161e-14, 17, "5816", -13},
  {2.7689620788002948000000000e+16, 16, "27689620788002948", 17},
  {4.9179036953990068686029571e-09, 10, "49", -8},
  {8.7589914614703644450875383e-18, 11, "", -11},
  {9.5526840662095469092207622e-01, 11, "95526840662", 0},
  {7.6124342771408064930229764e-25, 4, "", -4},
  {1.3447602981214602967120522e-12, 9, "", -9},
  {5.6164767091475087070666719e-08, 11, "5616", -7},
  {5.1039727464736464092052141e-14, 4, "", -4},
  {9.7310927308364416000000000e+17, 14, "97310927308364416", 18},
  {2.4924856789656310866121203e+04, 15, "24924856789656310866", 5},
  {4.2003388616830571311359267e-22, 15, "", -15},
  {5.8088977566522984974280011e-13, 18, "58089", -12},
  {8.1745545805232553482055664e+09, 19, "81745545805232553482055664063", 10},
  {1.0127770748340192540536383e-25, 15, "", -15},
  {3.9597865289746737289533485e+03, 12, "3959786528974674", 4},
  {9.7005813193337070312500000e+12, 2, "970058131933371", 13},
  {6.1416974120274033310045189e-21, 10, "", -10},
  {2.0857515628226578594655116e-13, 18, "208575", -12},
  {1.4428766164468270147900001e-15, 11, "", -11},
  {1.2463938418615971778365041e-16, 6, "", -6},
  {3.4349486242098494106535839e-14, 18, "34349", -13},
  {8.9897102424915046724879231e-04, 0, "", 0},
  {3.7987885597513497693000772e+00, 3, "3799", 1},
  {3.1486455199376344882567466e-09, 17, "314864552", -8},
  {1.4136656301713912577502642e-21, 10, "", -10},
  {4.4729104247725409503288986e-08, 17, "4472910425", -7},
  {1.1538326058965357523634259e-06, 11, "115383", -5},
  {1.2187480636930314478793080e-17, 6, "", -6},
  {1.7071394445544876816711621e+02, 16, "1707139444554487682", 3},
  {8.7454287096993350000000000e+14, 12, "8745428709699335", 15},
  {5.7174495960970682625413337e-24, 2, "", -2},
  {2.1348469761224235839843750e+12, 1, "21348469761224", 13},
  {2.1253429571826777600000000e+17, 15, "212534295718267776", 18},
  {1.5951121318387291178428358e-18, 2, "", -2},
  {2.6181022976492485351562500e+12, 1, "26181022976492", 13},
  {1.6832752913931867969864016e-24, 11, "", -11},
  {1.8137649394846890936605632e+05, 11, "18137649394846891", 6},
  {2.3631722363340027343750000e+13, 9, "2363172236334002734375", 14},
  {7.5384421331478025579241996e-18, 10, "", -10},
  {8.1622894953325012465938926e+03, 14, "816228949533250125", 4},
  {5.6509222124570079957145419e-04, 17, "5650922212457", -3},
  {8.2309132379971044921875000e+12, 14, "82309132379971044921875", 13},
  {2.1481184907972288000000000e+16, 14, "21481184907972288", 17},
  {2.7491445619600131835937500e+12, 13, "274914456196001318359375", 13},
  {4.2551795962192702293395996e+08, 20, "42551795962192702293395996094", 9},
  {3.4902874446607246456189310e-12, 3, "", -3},
  {1.1873908781924628480000000e+19, 11, "1187390878192462848", 20},
  {1.3058856266080427488418536e+00, 9, "1305885627", 1},
  {3.1178803001984483562409878e+06, 19, "31178803001984483562409878", 7},
  {5.4623331494658729061484337e+06, 2, "546233315", 7},
  {2.9235698902078015921138610e-11, 2, "", -2},
  {2.2187538829420596004751210e-08, 10, "222", -7},
  {6.4575106791918363571166992e+09, 16, "64575106791918363571166992", 10},
  {1.1907890069176095823583726e-15, 5, "", -5},
  {4.5854158482066959423600542e-16, 8, "", -8},
  {1.3543248471304952320000000e+18, 7, "1354324847130495232", 19},
  {2.3119923127297323712075824e-16, 0, "", 0},
  {1.1870797528140486767265328e-08, 20, "1187079752814", -7},
  {9.4305702298633699596835597e-06, 11, "943057", -5},
  {3.2459161993855525240991341e-13, 12, "", -12},
  {7.4508355100282551430890265e-04, 20, "74508355100282551", -3},
  {1.8363441762059007305651903e+06, 13, "18363441762059007306", 7},
  {2.1391588071835032979356516e-14, 10, "", -10},
  {1.8256719160017344099618497e-08, 14, "1825672", -7},
  {9.3997113669656093750000000e+13, 14, "9399711366965609375", 14},
  {1.4498413885592120219277946e-16, 14, "", -14},
  {3.5835194833769537508487701e+07, 17, "358351948337695375084877", 8},
  {7.4324150969250437626101302e+00, 13, "7432415096925", 1},
  {8.6277837490030779091226284e-09, 18, "8627783749", -8},
  {7.8760787302665699865372728e-05, 2, "", -2},
  {2.5951937363790819328000000e+19, 18, "25951937363790819328", 20},
  {4.7245283316226498613021166e-17, 9, "", -9},
  {5.1700360388857301285892021e-02, 3, "52", -1},
  {7.7210651764862326024446405e-19, 5, "", -5},
  {2.4382766069101488774363255e-17, 19, "244", -16},
  {1.9028552673052289854940117e-05, 6, "19", -4},
  {1.2710827134509967663137212e-19, 12, "", -12},
  {1.4145731018050035517324287e-05, 4, "", -4},
  {6.4497435741775433707539955e-04, 2, "", -2},
  {2.4842487165258716583251953e+10, 0, "24842487165", 11},
  {3.1704482732555409428472497e-18, 8, "", -8},
  {1.4137513597174002127293967e-11, 5, "", -5},
  {4.2447945918921730202439117e-10, 10, "4", -9},
  {2.2226616506120673619577298e-18, 13, "", -13},
  {6.6692364122495043277740479e+08, 11, "66692364122495043278", 9},
  {9.1173818414931651204824448e+04, 13, "911738184149316512", 5},
  {8.3957391834754492187500000e+12, 8, "839573918347544921875", 13},
  {5.2156990302316087375832141e-23, 15, "", -15},
  {2.0198493433471755981445312e+11, 17, "201984934334717559814453125", 12},
  {1.0922907185006070137023926e+09, 13, "10922907185006070137024", 10},
  {3.1638236946105060100678519e-04, 13, "3163823695", -3},
  {2.6862775505365663860838940e-20, 18, "", -18},
  {6.4797815932525027164956555e+03, 12, "6479781593252503", 4},
  {1.0922038453071197458299300e-13, 8, "", -8},
  {5.8814101438068822971701823e-20, 18, "", -18},
  {5.7583376246266246790050175e-17, 8, "", -8},
  {5.4337066770734131133475541e-17, 20, "5434", -16},
  {1.4092354444633941515669255e-18, 12, "", -12},
  {3.4824054062634897196748064e-10, 17, "34824054", -9},
  {2.0018282805829662720498163e+03, 2, "200183", 4},
  {8.9517059494448425292968750e+11, 2, "89517059494448", 12},
  {2.7813187290368455251154955e+03, 19, "27813187290368455251155", 4},
  {2.4219217876777633967302648e-21, 12, "", -12},
  {1.1798673707308959010485926e-23, 20, "", -20},
  {8.1842772193144517669559422e-17, 17, "8", -16},
  {4.2176984909076374769210815e+08, 19, "4217698490907637476921081543", 9},
  {2.6035906022511492919921875e+11, 19, "26035906022511492919921875", 12},
  {1.0965734825949606020003557e+06, 7, "1096573482595", 7},
  {6.7136998286208963394165039e+08, 19, "6713699828620896339416503906", 9},
  {4.5630322945912433788180351e+06, 10, "45630322945912434", 7},
  {1.2649034042343457184820465e-01, 10, "1264903404", 0},
  {1.6959254029085816993350685e-12, 11, "", -11},
  {7.6894077849569063186645508e+09, 3, "7689407784957", 10},
  {1.8365498974601239235513464e-23, 17, "", -17},
  {2.2777461870050125414400000e+20, 7, "227774618700501254144", 21},
  {1.4122207849675308257540809e-10, 2, "", -2},
  {9.2178923659118978863741267e-04, 5, "92", -3},
  {2.0318924658853359382915116e-03, 11, "203189247", -2},
  {1.3576057641040877543143589e-08, 13, "135761", -7},
  {1.4401056149414600804448128e+06, 3, "1440105615", 7},
  {1.2754159023678817038569951e-23, 1, "", -1},
  {5.3006436828646888732910156e+09, 5, "530064368286469", 10},
  {1.0995218360882163324276917e+03, 14, "109952183608821633", 4},
  {6.0283403554898722376265141e+00, 10, "60283403555", 1},
  {2.2061573571119603363573439e-07, 1, "", -1},
  {6.2861962716175667311149583e-16, 11, "", -11},
  {2.2332604690456090122652677e-10, 17, "22332605", -9},
  {1.2963943071028284800000000e+17, 6, "129639430710282848", 18},
  {3.8943830798571162500000000e+14, 5, "389438307985711625", 15},
  {2.1741564110525146503661376e-23, 14, "", -14},
  {9.9427010960257568446647890e-17, 14, "", -14},
  {1.2483937039355675000000000e+15, 5, "12483937039355675", 16},
  {1.0217717498427839077401472e-16, 11, "", -11},
  {4.2863171939313068949788132e-12, 9, "", -9},
  {4.5903647239264540047543051e+00, 2, "459", 1},
  {5.6280888287761458790400000e+20, 2, "562808882877614587904", 21},
  {2.0866185757826868965186320e-21, 2, "", -2},
  {3.4785499198654954433607145e+00, 11, "347854991987", 1},
  {3.9950664811029075000000000e+14, 19, "39950664811029075", 15},
  {2.2737508160111285000000000e+15, 11, "22737508160111285", 16},
  {2.8414376100321119267277936e+00, 20, "284143761003211192673", 1},
  {7.5048538563970535993576050e+07, 3, "75048538564", 8},
  {2.3242103685355960977233702e-11, 1, "", -1},
  {5.2876022241772140841931105e+05, 12, "528760222417721408", 6},
  {9.5399821471044065209586631e-23, 8, "", -8},
  {1.3168303671569048189485336e-25, 6, "", -6},
  {1.2379694375554468295987713e-24, 20, "", -20},
  {2.5759724742020452381726448e-21, 2, "", -2},
  {1.3028110667202775806241677e-19, 12, "", -12},
  {3.4310490053493363258501689e-18, 12, "", -12},
  {1.3305123464339874516331370e-20, 10, "", -10},
  {4.6333458794234074721186262e-07, 2, "", -2},
  {1.4793046610589587403462993e-15, 0, "", 0},
  {4.2319952875771232604980469e+10, 6, "42319952875771233", 11},
  {5.2404900142517442873213440e+04, 6, "52404900143", 5},
  {7.8357810031529118077742169e+02, 4, "7835781", 3},
  {2.5591918844494153401368563e-07, 4, "", -4},
  {1.3321984111447192382812500e+12, 0, "1332198411145", 13},
  {3.1728639925391986659828335e-17, 15, "", -15},
  {2.1453402055573780882191670e-01, 13, "2145340205557", 0},
  {1.1541273348138810644902819e-02, 19, "115412733481388106", -1},
  {7.4624630663630068738711998e+02, 11, "7462463066363", 3},
  {8.8956775385185986757278442e+07, 5, "8895677538519", 8},
  {5.5101231576417810802742427e-10, 0, "", 0},
  {3.5128240249641958127856222e-09, 0, "", 0},
  {5.0117943587036348879337311e+07, 5, "5011794358704", 8},
  {8.0078121575412727808000000e+19, 1, "80078121575412727808", 20},
  {1.6413295538495632600072601e-06, 2, "", -2},
  {1.9324553613318195920738281e-10, 12, "193", -9},
  {1.4306447888773488746894103e-02, 19, "143064478887734887", -1},
  {1.4940918857864456284136014e-11, 14, "1494", -10},
  {3.1996839204600132011339339e-25, 9, "", -9},
  {1.2916345078379104505117425e-01, 15, "129163450783791", 0},
  {8.2220681120484811159494948e-15, 20, "822207", -14},
  {1.1311088484237593600000000e+18, 17, "113110884842375936", 19},
  {5.6312027999779251856315022e-20, 8, "", -8},
  {2.5109512486761771008000000e+19, 2, "25109512486761771008", 20},
  {2.9816175214459633243647987e-22, 1, "", -1},
  {7.7903129302427328000000000e+17, 13, "77903129302427328", 18},
  {9.5710935665405902925476078e-05, 2, "", -2},
  {1.5902386454585965257138014e+06, 13, "15902386454585965257", 7},
  {2.3195704236154761747457087e+05, 11, "23195704236154762", 6},
  {1.0471155884181998771964572e+04, 9, "10471155884182", 5},
  {3.1495463967505475569399994e-16, 19, "315", -15},
  {1.7079920677935429011995438e+03, 7, "17079920678", 4},
  {1.1110732996414954189701857e-04, 2, "", -2},
  {5.9591608035868988131437962e-05, 18, "59591608035869", -4},
  {6.4245564080618592001960254e-05, 14, "6424556408", -4},
  {3.2270081664110126953125000e+12, 13, "32270081664110126953125", 13},
  {9.3530106022090357990328819e-11, 17, "9353011", -10},
  {1.0657099583832227783203125e+12, 9, "106570995838322277832", 13},
  {3.1937917056648887228220701e+05, 7, "3193791705665", 6},
  {8.4772106592199577600000000e+17, 16, "847721065921995776", 18},
  {1.0122216878330844735955907e+02, 6, "101222169", 3},
  {5.3038738905111943580133511e-08, 0, "", 0},
  {1.8476548812387047833600000e+20, 11, "184765488123870478336", 21},
  {2.8377037292541945312500000e+13, 12, "283770372925419453125", 14},
  {1.5522710352171779296875000e+13, 6, "15522710352171779297", 14},
  {2.9166384763774043875628195e+01, 9, "29166384764", 2},
  {2.9256848621561476461224043e-21, 14, "", -14},
  {1.4627414470213798480813239e+01, 6, "14627414", 2},
  {4.2677339695477975000000000e+14, 20, "42677339695477975", 15},
  {3.8531518554203023360000000e+18, 17, "3853151855420302336", 19},
  {8.9095534221079153621821396e-18, 3, "", -3},
  {2.6330510355234641697043374e-08, 18, "26330510355", -7},
  {1.7989071210637945000000000e+15, 4, "17989071210637945", 16},
  {1.1284620167596198792026030e-01, 6, "112846", 0},
  {1.2082047396474573761224747e+07, 7, "120820473964746", 8},
  {2.0466051276033011413479912e-02, 19, "204660512760330114", -1},
  {5.3647376885936466740286835e-18, 20, "536", -17},
  {1.6896458227875145671367437e-23, 13, "", -13},
  {2.2430276885330509394407272e+07, 10, "224302768853305094", 8},
  {5.4611823508388219343849141e-19, 1, "", -1},
  {1.3886223824466724629514078e-06, 9, "1389", -5},
  {1.0628709059976656000000000e+17, 16, "10628709059976656", 18},
  {6.5677901758310333251953125e+10, 13, "656779017583103332519531", 11},
  {1.3846501525635656547038102e-05, 11, "138465", -4},
  {2.3239503311297983856320570e+01, 13, "23239503311298", 2},
  {1.7090622882896491315200000e+20, 3, "170906228828964913152", 21},
  {1.7720351755897794838692795e-22, 19, "", -19},
  {9.0410895477144253253936768e+08, 14, "90410895477144253253937", 9},
  {5.2689609985087071846400000e+20, 14, "526896099850870718464", 21},
  {6.1436059436238400000000000e+14, 2, "614360594362384", 15},
  {4.2535577126016931152343750e+11, 7, "4253557712601693115", 12},
  {1.1174774686172224846814061e+03, 10, "11174774686172", 4},
  {2.3218157876931758422937598e-13, 8, "", -8},
  {2.9425100954478704551320334e+01, 3, "29425", 2},
  {1.6384909377562406912000000e+19, 17, "16384909377562406912", 20},
  {8.4546808342023405378771977e-10, 0, "", 0},
  {1.8348559078815367823223070e-02, 3, "18", -1},
  {3.6951323570760755003732299e-14, 10, "", -10},
  {1.7720339137146655676333107e-05, 9, "1772", -4},
  {1.0953195018428047180175781e+11, 6, "109531950184280472", 12},
  {1.8910163273346060886979103e+06, 3, "1891016327", 7},
  {3.8303393082685300479253709e-06, 17, "383033930827", -5},
  {1.1032517626465307078453826e-02, 13, "110325176265", -1},
  {1.0882256774403428658843040e+07, 10, "108822567744034287", 8},
  {7.6365223158064243855897013e-04, 17, "76365223158064", -3},
  {1.2319132179759590604800000e+20, 10, "123191321797595906048", 21},
  {7.6654520402965206144626737e-24, 10, "", -10},
  {1.9907054120113767567090690e+04, 17, "1990705412011376756709", 5},
  {5.5809163210172512774821785e-11, 3, "", -3},
  {7.1626276494108994140625000e+12, 13, "71626276494108994140625", 13},
  {2.1562804391753344307014039e-06, 3, "", -3},
  {3.3858811909506485353695954e-11, 9, "", -9},
  {2.4795853182227352133640080e-15, 16, "25", -14},
  {9.0999291271167695522308350e+08, 20, "90999291271167695522308349609", 9},
  {1.0360449936500542163848877e+09, 8, "103604499365005422", 10},
  {2.1741888985692771410684357e-20, 14, "", -14},
  {2.6950923321825317543698475e+04, 14, "2695092332182531754", 5},
  {3.4748502327155860000000000e+15, 20, "3474850232715586", 16},
  {1.3166722249648454542696077e-07, 6, "", -6},
  {1.3649796556857769600000000e+17, 13, "136497965568577696", 18},
  {1.1036586103200356077279142e-07, 0, "", 0},
  {3.2353250794894972596223268e-07, 7, "3", -6},
  {4.7409024483331077135517262e+03, 4, "47409024", 4},
  {7.5606471515399252893985249e+03, 12, "7560647151539925", 4},
  {1.2048384500440090797623890e-10, 2, "", -2},
  {6.4989317929305660000000000e+15, 12, "6498931792930566", 16},
  {2.8280017986673768000000000e+16, 7, "28280017986673768", 17},
  {6.4789583253811944959269623e-22, 7, "", -7},
  {1.2101538200760085937500000e+14, 10, "121015382007600859375", 15},
  {2.9041979721021696610008272e-20, 14, "", -14},
  {1.7662743464887109472123477e-06, 15, "1766274346", -5},
  {3.3752241311865963685597285e-25, 12, "", -12},
  {2.6838418788368730108132896e-15, 3, "", -3},
  {2.0601388597187307003572542e-16, 12, "", -12},
  {2.2711415085038762190414225e-18, 3, "", -3},
  {8.3688121754411318118421178e-16, 6, "", -6},
  {3.0509247915038723945617676e+09, 13, "30509247915038723945618", 10},
  {3.4756784010209107894083584e-12, 12, "3", -11},
  {2.0918794591224500958041877e-18, 7, "", -7},
  {1.8014007320496684375000000e+14, 6, "18014007320496684375", 15},
  {7.0402383055163537597656250e+11, 18, "7040238305516353759765625", 12},
  {7.0523961313452093691012124e+02, 20, "70523961313452093691012", 3},
  {3.3123022700414259200000000e+19, 8, "331230227004142592", 20},
  {1.3477442962521527767160570e-11, 1, "", -1},
  {1.5195680500946430638358766e-09, 14, "151957", -8},
  {1.6370989058325329589843750e+11, 0, "163709890583", 12},
  {3.2501179636280721751973033e+04, 6, "32501179636", 5},
  {4.3872124333457973248000000e+19, 11, "43872124333457973248", 20},
  {5.4752057292690782249758710e-17, 13, "", -13},
  {2.0412741176677004800000000e+18, 8, "204127411766770048", 19},
  {8.7590649595612129115929890e-17, 6, "", -6},
  {6.7511399690618591308593750e+10, 3, "67511399690619", 11},
  {1.8428530348054767608642578e+10, 10, "184285303480547676086", 11},
  {4.4134041770057472000000000e+18, 3, "44134041770057472", 19},
  {6.0382468015061099834022159e-23, 14, "", -14},
  {1.0914389325615175186911987e-18, 9, "", -9},
  {9.5922842116864546875000000e+13, 1, "959228421168645", 14},
  {6.7414397317150228858273486e-03, 2, "1", -1},
  {9.0454309424785162718762876e+02, 17, "90454309424785162719", 3},
  {1.7247638412421916015625000e+13, 14, "17247638412421916015625", 14},
  {1.3478258295115678653229574e-04, 7, "1348", -3},
  {1.2270926663477252077427693e+04, 6, "12270926663", 5},
  {2.7187988312974026484880596e+04, 19, "271879883129740264848806", 5},
  {1.6709838997696748492752577e-18, 5, "", -5},
  {4.0124287672395355224609375e+11, 6, "401242876723953552", 12},
  {3.8904379149683988889600000e+20, 20, "389043791496839888896", 21},
  {3.7917178711894959605991685e-24, 6, "", -6},
  {5.2326781514926425856304244e-12, 12, "5", -11},
  {1.9891197491018045750066010e-06, 3, "", -3},
  {9.6386103426616983824715135e+01, 2, "9639", 2},
  {1.0450012005201659864313290e-24, 14, "", -14},
  {8.1274053642873248000000000e+16, 2, "81274053642873248", 17},
  {2.4469860244495827067167204e-17, 10, "", -10},
  {1.2278848539036514731886547e-24, 4, "", -4},
  {2.9843106899979407291290112e-03, 19, "29843106899979407", -2},
  {1.6687687520487260742187500e+12, 16, "166876875204872607421875", 13},
  {2.9118865915681180905894010e-02, 15, "29118865915681", -1},
  {3.0098897225284433364868164e+08, 16, "3009889722528443336486816", 9},
  {3.8942234409976171520000000e+18, 8, "3894223440997617152", 19},
  {1.1747234227923772733495626e-09, 1, "", -1},
  {7.4919608271807607726259819e-17, 11, "", -11},
  {1.2524845812881114715093950e-24, 3, "", -3},
  {2.3619862912188771072651233e-08, 18, "23619862912", -7},
  {2.9592583452050728985929044e-19, 7, "", -7},
  {1.2421491317357771200000000e+17, 1, "124214913173577712", 18},
  {1.1776639707263435844427641e-18, 0, "", 0},
  {4.1056786484322265600000000e+17, 6, "410567864843222656", 18},
  {2.2828568416201441619121076e-11, 4, "", -4},
  {1.8677424581010044800000000e+17, 1, "186774245810100448", 18},
  {2.3547285601269785696745033e-17, 0, "", 0},
  {1.1521056753037674624806641e+01, 6, "11521057", 2},
  {2.3289928854523935797260492e+01, 10, "232899288545", 2},
  {4.5532729915357135714610167e-15, 11, "", -11},
  {2.8040009068642397460937500e+12, 0, "2804000906864", 13},
  {2.4549456897228164672851562e+11, 19, "245494568972281646728515625", 12},
  {2.1303782404388960000000000e+15, 1, "2130378240438896", 16},
  {3.0615464720978065490722656e+10, 14, "3061546472097806549072266", 11},
  {5.2106987785639116800000000e+18, 1, "521069877856391168", 19},
  {3.0338499728065989584693611e-18, 15, "", -15},
  {3.7334276891887124304760637e-08, 13, "373343", -7},
  {1.3517091191015639167052926e-11, 7, "", -7},
  {4.5347603526762195200000000e+17, 3, "453476035267621952", 18},
  {6.1688687329467958544759786e-07, 5, "", -5},
  {2.1660472576472181760000000e+18, 20, "2166047257647218176", 19},
  {1.0986284140193456261536834e-12, 6, "", -6},
  {3.8056596298863915698622821e-16, 1, "", -1},
  {4.4806215089300594688000000e+19, 19, "44806215089300594688", 20},
  {6.7235603739103440260765389e-06, 16, "67235603739", -5},
  {2.6038658556828027343750000e+12, 13, "2603865855682802734375", 13},
  {2.5441996892978872218785247e-08, 18, "25441996893", -7},
  {2.4619749313296363509061104e-25, 5, "", -5},
  {3.8570042270101654522935701e-12, 20, "385700423", -11},
  {1.6763307978294840951448971e-11, 8, "", -8},
  {7.9914903742521024000000000e+17, 15, "79914903742521024", 18},
  {4.0186368991644030761718750e+11, 10, "4018636899164403076172", 12},
  {4.0611528372049345634877682e+06, 9, "4061152837204935", 7},
  {1.7531563745343681494952886e-21, 0, "", 0},
  {2.7644223493107879209781376e-09, 18, "2764422349", -8},
  {1.8738919926780662499368191e+06, 8, "187389199267807", 7},
  {3.0864849018900270462036133e+09, 12, "3086484901890027046204", 10},
  {3.7137698402340998977295986e-17, 17, "4", -16},
  {2.4414832538914252072572708e+07, 13, "244148325389142520726", 8},
  {7.4854868677056161973062953e-06, 4, "", -4},
  {1.4588741940399044324294664e+04, 14, "1458874194039904432", 5},
  {2.5494816845938739202637180e-03, 17, "254948168459387", -2},
  {1.0869014012008990903268568e+04, 18, "10869014012008990903269", 5},
  {1.0060620725022614351473749e+05, 6, "10060620725", 6},
  {2.2705066659605780005811872e-17, 10, "", -10},
  {2.1898212046994387728119386e-21, 18, "", -18},
  {3.5908827156397225832673570e-02, 7, "359088", -1},
  {2.5424953454062686810386099e-05, 7, "254", -4},
  {1.6993684711300159051461378e+03, 12, "1699368471130016", 4},
  {1.0798342822291263427734375e+12, 15, "10798342822291263427734375", 13},
  {8.5962804309089478811169160e-05, 3, "", -3},
  {3.4430943941104550781250000e+13, 5, "3443094394110455078", 14},
  {8.3923458819887119701599119e-15, 10, "", -10},
  {2.7742384436434819481600000e+20, 9, "277423844364348194816", 21},
  {3.1028565532276332000000000e+16, 0, "31028565532276332", 17},
  {2.1889070727143452499396859e-22, 7, "", -7},
  {8.8799115457210498835927824e-25, 10, "", -10},
  {7.2592624451762690000000000e+15, 4, "7259262445176269", 16},
  {1.2176057478318070983886719e+11, 2, "12176057478318", 12},
  {1.1758416433892945884842618e-01, 3, "118", 0},
  {8.3431537949181911455087649e-09, 13, "83432", -8},
  {4.6304719853157177567481995e+07, 15, "46304719853157177567482", 8},
  {3.9167576084420922633956097e-08, 0, "", 0},
  {6.3015489773494677858373347e-15, 1, "", -1},
  {7.7376658363579296875000000e+13, 17, "77376658363579296875", 14},
  {9.0218853471959437500000000e+13, 7, "902188534719594375", 14},
  {3.1899217453764730468750000e+13, 6, "31899217453764730469", 14},
  {1.9002197256499108249600000e+20, 16, "190021972564991082496", 21},
  {3.4337977644789693243171639e-13, 5, "", -5},
  {6.1336998376090296875000000e+13, 14, "61336998376090296875", 14},
  {2.2833939234701100809844211e-22, 9, "", -9},
  {4.7258581924117227211767922e-04, 16, "4725858192412", -3},
  {1.0511118807574756049694198e-03, 18, "1051111880757476", -2},
  {2.6104207868379164514394120e-03, 5, "261", -2},
  {9.2510375399520410372205181e-09, 6, "", -6},
  {4.2047910491404046250815268e-22, 6, "", -6},
  {1.8537358330866621875000000e+14, 8, "18537358330866621875", 15},
  {2.9525645899816946315930011e-02, 0, "", 0},
  {7.7802112021756594640811143e-24, 12, "", -12},
  {2.7043035133783199851465840e-24, 16, "", -16},
  {3.1607122960112636340501008e-05, 19, "316071229601126", -4},
  {3.2095647396317605881677082e-01, 1, "3", 0},
  {6.6660316788301923196513599e+00, 7, "66660317", 1},
  {6.7301975373456976000000000e+16, 16, "67301975373456976", 17},
  {1.1022090125286579589843750e+12, 10, "11022090125286579589844", 13},
  {5.0937284017379313993956202e-01, 11, "50937284017", 0},
  {4.0795085723746706250000000e+14, 1, "4079508572374671", 15},
  {4.8913034835615001600000000e+17, 7, "489130348356150016", 18},
  {9.0881608899430544815602589e-16, 15, "1", -14},
  {4.1905973207725584885664796e-16, 10, "", -10},
  {4.4827656740811310220998264e-07, 4, "", -4},
  {3.7871161013802869721360551e-23, 17, "", -17},
  {1.5890857156312330200620409e+00, 1, "16", 1},
  {2.7402352084723094758209960e-12, 11, "", -11},
  {1.8782857018873188820418324e-06, 2, "", -2},
  {3.3264238356262671550588539e-12, 14, "333", -11},
  {7.5962663242314010858535767e+07, 5, "7596266324231", 8},
  {5.3301229844685821955599706e-12, 17, "533012", -11},
  {6.1854081707155413459986448e+05, 6, "618540817072", 6},
  {3.8052543254595407127421902e-04, 10, "3805254", -3},
  {1.0679848314969671107758551e-23, 19, "", -19},
  {2.7878693456980049926851601e-14, 19, "278787", -13},
  {2.7870473213578657792000000e+19, 8, "27870473213578657792", 20},
  {4.5257113052980732917785645e+08, 15, "452571130529807329177856", 9},
  {2.6358468352803015680000000e+18, 2, "2635846835280301568", 19},
  {3.9886067181987278678365906e-17, 5, "", -5},
  {2.3270682789001023779459943e-13, 12, "", -12},
  {2.7140994610240509033203125e+10, 4, "271409946102405", 11},
  {1.6980003518217495184217114e+03, 6, "1698000352", 4},
  {2.6849734072521096095442772e+06, 19, "26849734072521096095442772", 7},
  {6.6618239329823178107199630e-25, 8, "", -8},
  {1.8355215372296044499395018e-03, 14, "183552153723", -2},
  {5.2086734703050400000000000e+15, 3, "520867347030504", 16},
  {3.2014160733301714856224862e+01, 18, "32014160733301714856", 2},
  {1.8152843246656754353567188e-13, 13, "2", -12},
  {2.1772455555788963101804256e+05, 5, "21772455556", 6},
  {4.0738205060041988376841892e-16, 7, "", -7},
  {1.0507234528536652222878162e-18, 20, "105", -17},
  {1.5829632792788724000000000e+16, 10, "15829632792788724", 17},
  {3.5403487649500286156800000e+20, 20, "354034876495002861568", 21},
  {1.2892579370836414906172952e-05, 10, "128926", -4},
  {1.8306345443741242826436115e-07, 2, "", -2},
  {3.3220953156279330141842365e+05, 15, "332209531562793301418", 6},
  {4.7232689127945818663781297e-04, 20, "47232689127945819", -3},
  {6.8439206376986717456070185e-20, 18, "", -18},
  {1.3514998226985468932070944e+02, 10, "1351499822699", 3},
  {3.8414752152930201387900222e-12, 15, "3841", -11},
  {3.5474923138269326696182089e-11, 14, "3547", -10},
  {2.3719140240562304000000000e+18, 19, "23719140240562304", 19},
  {7.9077879288466538496000000e+19, 9, "79077879288466538496", 20},
  {1.4891929019944359520396798e-12, 16, "14892", -11},
  {1.7755690658258124745024492e-12, 9, "", -9},
  {1.5994209906678685097128564e-16, 19, "1599", -15},
  {1.6276783121583668067249029e-25, 9, "", -9},
  {2.6529121784462445261256521e-15, 18, "2653", -14},
  {2.7083908627513145900289615e-02, 18, "27083908627513146", -1},
  {2.9657071199689830780029297e+10, 1, "296570711997", 11},
  {5.2037029959468472952721640e+03, 8, "520370299595", 4},
  {1.3868899120413833475336587e-22, 5, "", -5},
  {2.6321528752943852467736267e-09, 20, "263215287529", -8},
  {1.7547462939439111328125000e+13, 20, "17547462939439111328125", 14},
  {3.0095899150378310000000000e+15, 13, "3009589915037831", 16},
  {2.7115007382644935607910156e+10, 14, "2711500738264493560791016", 11},
  {1.4314180958050015202098070e-09, 1, "", -1},
  {1.2764049284840739628711714e-25, 5, "", -5},
  {1.3166571108056272006864296e-03, 2, "", -2},
  {2.3544577664157459139823914e+08, 12, "235445776641574591398", 9},
  {1.0476329294517525148044967e-01, 11, "10476329295", 0},
  {3.7379411288423888618126512e+05, 12, "373794112884238886", 6},
  {1.0897341177246054224414641e-12, 15, "109", -11},
  {7.4132380924545421600341797e+09, 0, "7413238092", 10},
  {3.8204588650995886080000000e+18, 12, "3820458865099588608", 19},
  {1.8692816988418682553982776e-08, 7, "", -7},
  {2.2070112092052268605232856e-04, 1, "", -1},
  {1.2407208495714156800000000e+17, 6, "124072084957141568", 18},
  {1.7154136231591710720000000e+18, 15, "1715413623159171072", 19},
  {5.0543003347710683271956897e-12, 15, "5054", -11},
  {7.0080430744862634277343750e+11, 0, "700804307449", 12},
  {2.4999211220962086867428131e-04, 19, "2499921122096209", -3},
  {4.2676918254295989990234375e+10, 11, "4267691825429598999023", 11},
  {1.8714417156938281600000000e+17, 9, "187144171569382816", 18},
  {1.0744964350319107434511732e-10, 3, "", -3},
  {2.1333211707667395379200000e+20, 14, "213332117076673953792", 21},
  {3.1552870856235580600031731e-12, 16, "31553", -11},
  {5.1735694195030579200000000e+17, 7, "517356941950305792", 18},
  {1.7497002875548503275056605e-14, 13, "", -13},
  {2.3464868456857800704000000e+19, 5, "23464868456857800704", 20},
  {1.1426965603528632317575919e-02, 18, "11426965603528632", -1},
  {7.2959100617781136000000000e+16, 6, "72959100617781136", 17},
  {2.9087252649092865415134218e-17, 11, "", -11},
  {1.7522529740472449024000000e+19, 13, "17522529740472449024", 20},
  {4.5274385170832008000000000e+16, 9, "45274385170832008", 17},
  {4.9171537278921003529015826e-14, 5, "", -5},
  {4.3770018097825968750000000e+14, 4, "4377001809782596875", 15},
  {4.1886764364889979019745444e-14, 2, "", -2},
  {6.2838371183099290000000000e+15, 18, "6283837118309929", 16},
  {4.5030641063715723393379164e-03, 4, "45", -2},
  {8.2318502107634858952355953e-14, 0, "", 0},
  {3.5946544046454725107734408e-25, 5, "", -5},
  {2.6234514215724729292115977e-15, 2, "", -2},
  {2.0896378982787873610504903e+03, 10, "20896378982788", 4},
  {8.7620532964549153109520829e-05, 11, "8762053", -4},
  {3.8808970728867076610023551e-22, 11, "", -11},
  {1.8261469781865514032048502e-10, 1, "", -1},
  {6.6898156067826275830157101e+04, 9, "66898156067826", 5},
  {3.1723477662170751045778161e+02, 7, "3172347766", 3},
  {1.2568008557681841454478726e-15, 18, "1257", -14},
  {1.7464968751067149815093170e-25, 4, "", -4},
  {7.4510270961683305529583855e-24, 18, "", -18},
  {1.2419382754355095326900482e+07, 2, "1241938275", 8},
  {3.3173168110202413797378540e+08, 3, "331731681102", 9},
  {1.7934798915122797851562500e+12, 16, "179347989151227978515625", 13},
  {1.8015272298635763439454234e-11, 14, "1802", -10},
  {3.7123065278170469955869630e-11, 5, "", -5},
  {7.8232939802355632000000000e+16, 8, "78232939802355632", 17},
  {1.1500838812220400952240906e-03, 15, "1150083881222", -2},
  {1.5138936575195731702329118e-18, 17, "", -17},
  {1.4658198993629957471454877e-18, 6, "", -6},
  {3.6757933793481049723053323e-15, 12, "", -12},
  {7.6108472250759790000000000e+15, 13, "7610847225075979", 16},
  {2.7493563846532650319452739e-17, 9, "", -9},
  {9.3525060938226233457632231e-21, 12, "", -12},
  {1.6640677868697117708560878e-11, 6, "", -6},
  {2.0411082739470581879952520e-14, 5, "", -5},
  {2.9178502504526664733886719e+10, 10, "291785025045266647339", 11},
  {5.5092663163466191291809082e+08, 1, "5509266316", 9},
  {4.1471682880017630168367759e+02, 9, "4147168288", 3},
  {4.5617034316700079114737901e-17, 10, "", -10},
  {4.3749917112061033006243153e-19, 4, "", -4},
  {3.1152268184463246093750000e+13, 8, "3115226818446324609375", 14},
  {6.6549242101265970963091274e-21, 1, "", -1},
  {6.8469004973041148437500000e+13, 17, "684690049730411484375", 14},
  {3.8879209022324616135425353e-07, 2, "", -2},
  {2.3027656012001499853752239e-10, 6, "", -6},
  {2.4264789700474262400000000e+17, 18, "242647897004742624", 18},
  {1.3079581353438642578125000e+13, 7, "130795813534386425781", 14},
  {1.6123051047752250000000000e+16, 19, "1612305104775225", 17},
  {1.6980867421600206911344718e-06, 11, "169809", -5},
  {1.1236161506953844480000000e+18, 17, "1123616150695384448", 19},
  {7.9557125567535703329390024e-17, 16, "1", -15},
  {1.5117806714464793366259488e-11, 4, "", -4},
  {7.9445863809939345742997755e-07, 11, "79446", -6},
  {1.1393723728155554059379037e-10, 2, "", -2},
  {8.5788742393594677772951807e-22, 2, "", -2},
  {2.2669974815672999718418287e-23, 19, "", -19},
  {4.1772640302046090364456177e+06, 6, "4177264030205", 7},
  {5.3325227601514768680990492e-08, 13, "533252", -7},
  {2.6014031345460656738281250e+11, 3, "260140313454607", 12},
  {5.4643231573416187529801391e+01, 10, "546432315734", 2},
  {4.2675432774799825392260804e-10, 10, "4", -9},
  {1.0314151807946926269531250e+12, 11, "103141518079469262695313", 13},
  {1.6506720351096933593750000e+13, 10, "1650672035109693359375", 14},
  {1.5498112988919174298644066e+07, 15, "15498112988919174298644", 8},
  {4.8277964220349491200000000e+17, 6, "482779642203494912", 18},
  {5.5027227425052171863254252e-17, 14, "", -14},
  {5.2410617912232055664062500e+10, 8, "5241061791223205566", 11},
  {8.3803507685593197736225614e-21, 8, "", -8},
  {2.9684320816000383301551220e-20, 7, "", -7},
  {9.2961267113026846720000000e+20, 13, "9296126711302684672", 21},
  {4.9252188038395311453498948e-01, 10, "4925218804", 0},
  {7.4326043481389403343200684e+08, 18, "743260434813894033432006836", 9},
  {3.1319743918037391949837911e+02, 17, "3131974391803739195", 3},
  {2.1612336516242158852883207e-10, 17, "21612337", -9},
  {2.8734877806913309900800000e+20, 13, "287348778069133099008", 21},
  {2.4131530227713598919867449e-15, 6, "", -6},
  {1.6640616939917165756225586e+10, 10, "166406169399171657562", 11},
  {1.2150938363267812292178860e+01, 8, "1215093836", 2},
  {6.7138611691658811597704926e-01, 12, "671386116917", 0},
  {2.7463188313633557708800000e+20, 10, "274631883136335577088", 21},
  {3.7999498815615309911509177e-06, 15, "3799949882", -5},
  {4.8514016455044469764984129e-11, 13, "485", -10},
  {6.1613595347878543360000000e+18, 1, "6161359534787854336", 19},
  {4.9695637440830490000000000e+15, 3, "4969563744083049", 16},
  {3.0834484485356276253147740e-22, 1, "", -1},
  {4.7894719072209141348369157e-07, 19, "4789471907221", -6},
  {6.5157400456032662500000000e+14, 8, "651574004560326625", 15},
  {4.5972114805199436800000000e+17, 8, "459721148051994368", 18},
  {4.2541514947031936313374006e-25, 8, "", -8},
  {1.0066406372943053489881682e-11, 10, "", -10},
  {6.0906395921548689924103454e-15, 14, "1", -13},
  {3.8567417877923564910888672e+09, 17, "385674178779235649108886719", 10},
  {8.5078644512008962048000000e+19, 17, "85078644512008962048", 20},
  {1.6650550429334719266760509e-25, 1, "", -1},
  {2.0080574594561208320000000e+18, 13, "2008057459456120832", 19},
  {3.8824200184704868750000000e+14, 15, "3882420018470486875", 15},
  {9.9495458379112156046182865e-23, 10, "", -10},
  {1.9288407563126543439369764e-10, 3, "", -3},
  {3.0389770313836266010248306e-15, 5, "", -5},
  {1.7234961566264391744779383e-03, 20, "172349615662643917", -2},
  {4.0013550105087525000000000e+15, 7, "40013550105087525", 16},
  {3.0838024458655090332031250e+10, 13, "308380244586550903320313", 11},
  {3.3409370209656707763671875e+10, 13, "334093702096567077636719", 11},
  {2.0746267738452314688402112e+02, 20, "20746267738452314688402", 3},
  {1.4792633583113643646240234e+10, 17, "1479263358311364364624023438", 11},
  {8.5151508001834040304323355e-16, 5, "", -5},
  {2.3158892948303221505265359e-13, 2, "", -2},
  {2.6014819522497265664000000e+20, 12, "26014819522497265664", 21},
  {1.5404589843636518441034581e-21, 4, "", -4},
  {4.7119836020175220621906866e-16, 16, "5", -15},
  {1.4414824985345767611425998e-20, 6, "", -6},
  {6.2408688637692439442616887e+03, 8, "624086886377", 4},
  {6.0271612733174721075762440e-21, 2, "", -2},
  {3.4786026086938734447590896e-10, 12, "348", -9},
  {1.7713830483379106000000000e+16, 14, "17713830483379106", 17},
  {5.0901198323514444552492937e-25, 7, "", -7},
  {6.2284450131953058914998420e-09, 0, "", 0},
  {8.3088427099120160000000000e+15, 16, "8308842709912016", 16},
  {7.6473434450541437500000000e+13, 12, "764734344505414375", 14},
  {1.2687017388368786621093750e+11, 7, "1268701738836878662", 12},
  {9.6453630141459941718106091e-22, 16, "", -16},
  {2.2904875172227049835343212e-07, 3, "", -3},
  {2.8004069589801321591983276e-23, 16, "", -16},
  {1.7681300182619719314758289e-03, 13, "17681300183", -2},
  {6.8213587721807235822953953e-18, 14, "", -14},
  {9.5414111660477294099328046e-18, 5, "", -5},
  {4.1108599902087336509941442e-18, 7, "", -7},
  {1.4795172902264841468422674e+04, 1, "147952", 5},
  {3.5956075890621357432076508e-23, 7, "", -7},
  {1.2108345280098891037962353e-11, 2, "", -2},
  {6.3757487408567993164062500e+11, 10, "6375748740856799316406", 12},
  {9.2726713249304066537075097e-05, 18, "92726713249304", -4},
  {4.3860248872067333984375000e+11, 14, "43860248872067333984375", 12},
  {7.5430843463857152799562078e-04, 8, "75431", -3},
  {9.7801992821918062500000000e+13, 1, "978019928219181", 14},
  {2.6749760503985688941952503e+00, 17, "267497605039856889", 1},
  {1.2806873472555519640445709e+08, 4, "1280687347256", 9},
  {2.8662251756337055994154354e-08, 7, "", -7},
  {4.9472396902134005358675495e+03, 2, "494724", 4},
  {2.3898666037221602376054447e-06, 2, "", -2},
  {1.9435638674897266796167666e-16, 12, "", -12},
  {1.4233642025898380859375000e+13, 7, "142336420258983808594", 14},
  {2.5579269245722265625000000e+11, 13, "25579269245722265625", 12},
  {2.3539645063791328125000000e+13, 1, "235396450637913", 14},
  {8.8969430875183154305180498e-17, 14, "", -14},
  {3.1878162158576145657207235e+02, 5, "31878162", 3},
  {4.6047281935949432373046875e+11, 14, "46047281935949432373046875", 12},
  {1.1828359335776502566451902e-25, 20, "", -20},
  {1.2918437371338731587670554e-19, 2, "", -2},
  {1.9424609949701800649717609e-20, 6, "", -6},
  {3.1772856626803763901989441e+02, 9, "317728566268", 3},
  {5.9455749593865246297287944e-06, 2, "", -2},
  {2.3433498800909465495839433e-24, 13, "", -13},
  {6.8341050892965518540394921e-16, 1, "", -1},
  {8.9874226835727739626236144e+01, 14, "8987422683572774", 2},
  {3.5358247375943835937500000e+13, 7, "353582473759438359375", 14},
  {1.5265563259005383371322618e-14, 18, "15266", -13},
  {1.4824438485589753913191188e-16, 8, "", -8},
  {3.1047768645227776000000000e+17, 2, "31047768645227776", 18},
  {3.8276461772705030400000000e+17, 15, "382764617727050304", 18},
  {7.2225705286669479683041573e+06, 6, "7222570528667", 7},
  {4.1437414263793413869723626e-18, 13, "", -13},
  {8.8077518529085024531766202e-04, 5, "88", -3},
  {3.8371547013955969810485840e+09, 8, "383715470139559698", 10},
  {6.0225919414986499311748247e-02, 11, "6022591941", -1},
  {2.6295430716040507472262112e-18, 5, "", -5},
  {9.8172828037262200020902356e-14, 15, "98", -13},
  {6.5179802980526568151331546e-03, 10, "65179803", -2},
  {6.5497748623112250908472418e-25, 12, "", -12},
  {5.2265602443980806343790144e-20, 14, "", -14},
  {5.8601094220958806225291603e-21, 20, "1", -19},
  {1.1774476997247113366999033e-05, 7, "118", -4},
  {1.4444241715835657302591244e+01, 16, "144442417158356573", 2},
  {4.3462594768642153191667843e-04, 3, "", -3},
  {5.4539661682973678595113070e-09, 7, "", -7},
  {1.1666334875581979751586914e+07, 20, "1166633487558197975158691406", 8},
  {3.1812729438141499116454725e+01, 0, "32", 2},
  {1.5539464788784004000000000e+16, 11, "15539464788784004", 17},
  {6.4290411256164150390625000e+12, 1, "64290411256164", 13},
  {8.3675049259286572331316288e-20, 9, "", -9},
  {1.4003913950175971488741145e-07, 13, "1400391", -6},
  {2.4746024604493984222412109e+10, 19, "24746024604493984222412109375", 11},
  {1.6046041654835740700946189e+04, 9, "16046041654836", 5},
  {1.1805756492153409453749191e+03, 12, "1180575649215341", 4},
  {5.7964835929522847740392810e-20, 10, "", -10},
  {5.6744341032206540800000000e+19, 13, "567443410322065408", 20},
  {1.0756016173821379119433222e-25, 5, "", -5},
  {6.5912269594018906354904175e+06, 1, "6591227", 7},
  {1.1711134259464951556364405e-22, 19, "", -19},
  {1.7292702488192741583361567e+00, 4, "17293", 1},
  {3.1766315904132414289051667e+04, 0, "31766", 5},
  {4.1655979298835091200000000e+17, 15, "416559792988350912", 18},
  {4.6643761811762591838933096e-08, 0, "", 0},
  {2.1845666486519243839339583e-11, 3, "", -3},
  {2.5165928413684118323200000e+20, 15, "251659284136841183232", 21},
  {7.0093163428762493595181676e-23, 17, "", -17},
  {4.3233236582095641642808914e+06, 1, "43233237", 7},
  {2.2221210480019761598668993e+05, 11, "22221210480019762", 6},
  {1.0810915979562988852909344e-25, 3, "", -3},
  {6.6761732657088844980462052e-12, 13, "67", -11},
  {1.0263236090046956787109375e+12, 6, "1026323609004695679", 13},
  {6.8005211363659080775935647e-08, 13, "680052", -7},
  {6.2606282357885072000000000e+16, 17, "62606282357885072", 17},
  {4.1988915941200175285339355e+09, 17, "419889159412001752853393555", 10},
  {1.7260178361226485479733303e-21, 1, "", -1},
  {1.9040731986097971191406250e+12, 1, "19040731986098", 13},
  {5.0978188668965668739474495e+02, 3, "509782", 3},
  {1.5024418446085451585960587e-11, 20, "1502441845", -10},
  {6.2943410801908031282358991e-02, 18, "62943410801908031", -1},
  {1.9839214397466889986800270e-13, 2, "", -2},
  {4.8124905099675658240000000e+18, 12, "4812490509967565824", 19},
  {1.3969930048920768545808459e-25, 18, "", -18},
  {3.4327227983014400688532188e-18, 3, "", -3},
  {2.2480976988578498642950646e-17, 18, "22", -16},
  {9.9468167794737814801919740e+02, 3, "994682", 3},
  {5.0393392248176563200000000e+17, 3, "503933922481765632", 18},
  {6.6558962452327800832000000e+19, 15, "66558962452327800832", 20},
  {5.8090588160465005124302863e-09, 1, "", -1},
  {2.7129281785430862328212243e+02, 11, "27129281785431", 3},
  {1.3429192858676510400000000e+17, 10, "134291928586765104", 18},
  {6.8485780395341315918863291e-16, 5, "", -5},
  {2.8739928093432064315493335e+02, 7, "2873992809", 3},
  {6.1781818413875907936017029e+03, 0, "6178", 4},
  {1.7719065492243441541087420e-11, 8, "", -8},
  {7.1862106066127861444845317e-09, 8, "1", -7},
  {6.7952370297794444486498833e+06, 18, "6795237029779444448649883", 7},
  {1.7090214617138794750417219e+00, 19, "1709021461713879475", 1},
  {7.4853855303844156685827171e-18, 20, "749", -17},
  {1.5701716492508174761663642e-04, 2, "", -2},
  {2.4026483374813164400896071e-02, 7, "240265", -1},
  {8.4447450770301117563450266e-07, 9, "844", -6},
  {3.7522915250224137500000000e+14, 15, "375229152502241375", 15},
  {1.8063169233012729600000000e+17, 14, "180631692330127296", 18},
  {3.2948421275110273409580941e-01, 2, "33", 0},
  {1.3499062077481117542396652e-14, 7, "", -7},
  {1.1546879114708381890630137e-05, 20, "1154687911470838", -4},
  {1.9376674438212465494871140e+07, 9, "19376674438212465", 8},
  {6.3936280036437112500000000e+14, 4, "639362800364371125", 15},
  {5.4555172504539470672607422e+09, 4, "54555172504539", 10},
  {2.3258933255165851116180420e+08, 4, "2325893325517", 9},
  {1.8506480334907625469651910e-25, 15, "", -15},
  {1.0588236009979838476419654e-15, 4, "", -4},
  {1.3469564281222797851562500e+12, 13, "134695642812227978515625", 13},
  {2.8715638473738758520323265e-11, 4, "", -4},
  {2.5716690043300301227180427e-02, 12, "25716690043", -1},
  {8.8538046484450915123200000e+20, 19, "885380464844509151232", 21},
  {6.4965481100621430784000000e+19, 8, "64965481100621430784", 20},
  {3.8050248326655206400000000e+17, 5, "380502483266552064", 18},
  {1.8564618938125348416440241e-03, 7, "18565", -2},
  {1.3488877800957536218229293e-02, 16, "134888778009575", -1},
  {2.6677942186411894531250000e+13, 16, "2667794218641189453125", 14},
  {6.3030166451577222114233123e-03, 7, "6303", -2},
  {1.2227091500435516855174733e-04, 4, "1", -3},
  {3.7394916253221110673621297e+05, 15, "373949162532211106736", 6},
  {1.6322629633483903712819303e-10, 9, "", -9},
  {6.3365887843639789147598218e-19, 16, "", -16},
  {6.3148457829739650000000000e+14, 6, "6314845782973965", 15},
  {3.6828206930501288734376431e+06, 13, "36828206930501288734", 7},
  {1.0150422489275714714004138e-21, 20, "", -20},
  {2.2366394074105758720000000e+18, 11, "2236639407410575872", 19},
  {6.8977890210504037772515045e-09, 17, "689778902", -8},
  {6.7544044910068398228588104e-14, 8, "", -8},
  {1.4131970536990795808543354e-24, 2, "", -2},
  {2.5442112222032396539110526e-21, 3, "", -3},
  {1.6072631512763721402734518e+06, 15, "1607263151276372140273", 7},
  {3.2697995207297318400000000e+17, 17, "326979952072973184", 18},
  {3.2745644242510394406053820e+01, 0, "33", 2},
  {3.1463179672815881347656250e+11, 20, "3146317967281588134765625", 12},
  {2.2430225385694845750264234e-05, 18, "22430225385695", -4},
  {5.3610579293033156466032117e-12, 13, "54", -11},
  {1.5925872138310197753906250e+12, 1, "1592587213831", 13},
  {3.1650146387336799568031664e-09, 8, "", -8},
  {8.9577655937440872192382812e+08, 14, "89577655937440872192383", 9},
  {4.3042152399386791336558198e-23, 5, "", -5},
  {1.5355109754804844851605594e+05, 16, "1535510975480484485161", 6},
  {2.3284150596155716403200000e+20, 3, "232841505961557164032", 21},
  {5.4765666570646380932885222e+03, 2, "547657", 4},
  {7.3965628639809046476865281e-20, 18, "", -18},
  {3.2265867711474738121032715e+09, 12, "3226586771147473812103", 10},
  {5.8711852046113996719896997e-21, 2, "", -2},
  {1.3794779083282195549402626e-22, 3, "", -3},
  {3.4111785750292883046400000e+20, 20, "341117857502928830464", 21},
  {1.9605498340230258236260852e+02, 19, "1960549834023025823626", 3},
  {8.1715970085334907507938821e-21, 19, "", -19},
  {3.8771150039023080657862863e-02, 6, "38771", -1},
  {2.3592929290331342387669264e-05, 2, "", -2},
  {9.6874428965312300715595484e+05, 2, "96874429", 6},
  {3.3372214557686419689094929e-25, 15, "", -15},
  {1.5761156965412499476060920e-09, 20, "157611569654", -8},
  {3.5801210839645702573986379e-18, 3, "", -3},
  {3.3856680948557640625000000e+13, 20, "33856680948557640625", 14},
  {2.5620074142743661999702454e+08, 5, "25620074142744", 9},
  {4.4401620842480883437969003e-22, 9, "", -9},
  {2.0606020806165302500000000e+15, 6, "206060208061653025", 16},
  {2.7734065783622322082519531e+10, 7, "277340657836223221", 11},
  {9.6073382296749894491746235e-20, 10, "", -10},
  {8.3172323572385334121512598e-20, 2, "", -2},
  {1.1167924786611424759030342e+07, 0, "11167925", 8},
  {5.3766859634029883380787820e-06, 0, "", 0},
  {2.0964997147761569023132324e+09, 8, "20964997147761569", 10},
  {8.5691047019522922018660687e-10, 14, "85691", -9},
  {9.9983286747112847425018516e-16, 17, "1", -14},
  {5.1051292577644204720854759e+06, 3, "5105129258", 7},
  {3.8141489261722099781036377e+08, 0, "381414893", 9},
  {9.1117839700605995042686172e-15, 1, "", -1},
  {7.9589982168294064128000000e+19, 5, "79589982168294064128", 20},
  {2.1047337277493240320000000e+18, 7, "2104733727749324032", 19},
  {1.2736750723337549799132324e-15, 17, "127", -14},
  {6.7679129248068781166125518e-01, 1, "7", 0},
  {3.3606717469573625875813423e-13, 5, "", -5},
  {6.4162058624042019592337593e-12, 7, "", -7},
  {1.6140108212576733902096748e+07, 1, "161401082", 8},
  {4.2604619659713442453361302e-13, 20, "4260462", -12},
  {5.7199214040431312078283099e-01, 20, "57199214040431312078", 0},
  {4.5121605743433972319452307e-20, 6, "", -6},
  {5.6896111289809127667227109e-15, 15, "6", -14},
  {4.7098783202098241687755080e-07, 12, "470988", -6},
  {2.1666143643133331089486392e-09, 9, "2", -8},
  {1.2336359209166625957860644e-19, 15, "", -15},
  {7.0616937073386944022498554e-06, 1, "", -1},
  {4.2123886841674222028077347e-19, 1, "", -1},
  {1.3935343618681616500838159e-15, 9, "", -9},
  {4.4849474126869004976470023e+04, 1, "448495", 5},
  {1.4760841270552815895462310e-22, 16, "", -16},
  {4.1738205210246630400000000e+18, 11, "417382052102466304", 19},
  {3.5555291744251520140096545e+05, 8, "35555291744252", 6},
  {3.9210445777937810487907567e-13, 12, "", -12},
  {4.6101950678545125583696063e+02, 15, "461019506785451256", 3},
  {1.3369879982572362899780273e+10, 17, "1336987998257236289978027344", 11},
  {5.0892409611661240458488464e+07, 14, "5089240961166124045849", 8},
  {2.8030263929456882178783417e+06, 17, "280302639294568821787834", 7},
  {6.1456014561597743104000000e+19, 2, "61456014561597743104", 20},
  {7.9853912836090860000000000e+15, 10, "7985391283609086", 16},
  {1.1334499952325343420910049e-25, 16, "", -16},
  {3.9950900284562369292346712e-05, 5, "4", -4},
  {9.2782375346855402431194148e-17, 0, "", 0},
  {2.6219056840141755342483521e+08, 14, "26219056840141755342484", 9},
  {3.7480170446110685489315983e+00, 7, "3748017", 1},
  {1.5328242781531789302825928e+09, 0, "1532824278", 10},
  {8.2513383356874712875134878e-14, 4, "", -4},
  {1.2134351423231271837721579e+04, 14, "1213435142323127184", 5},
  {3.0652340582255772969900900e-08, 18, "30652340582", -7},
  {3.0449882898377752348554862e-25, 10, "", -10},
  {1.6038360473405439279304119e+03, 12, "1603836047340544", 4},
  {2.0480816976560597533165729e-14, 19, "204808", -13},
  {5.0426768979985993535036609e-14, 8, "", -8},
  {1.0089709129428205078125000e+13, 5, "1008970912942820508", 14},
  {1.6647412409706132812500000e+12, 15, "166474124097061328125", 13},
  {2.5026531075510486487392581e-18, 7, "", -7},
  {1.6493319940894430160522461e+10, 7, "164933199408944302", 11},
  {4.8009099375414956968251749e-23, 9, "", -9},
  {1.5013882486233320220315547e-17, 18, "15", -16},
  {8.6913296781355722231410255e+00, 7, "86913297", 1},
  {1.1485372017015082687918515e-02, 8, "1148537", -1},
  {1.3161453532943869052638684e-24, 12, "", -12},
  {2.6618704913446231824503130e-03, 20, "266187049134462318", -2},
  {1.4184910232655200797718151e-18, 18, "1", -17},
  {9.5719547044610013095464263e-13, 7, "", -7},
  {1.5450929911528783360000000e+18, 17, "1545092991152878336", 19},
  {2.3487290145975513458251953e+09, 9, "2348729014597551346", 10},
  {2.6179686119242234099147026e+01, 3, "2618", 2},
  {1.1901421917137593600000000e+17, 5, "119014219171375936", 18},
  {3.0851447045022915359460406e-22, 3, "", -3},
  {2.6664168404842936320000000e+18, 17, "2666416840484293632", 19},
  {6.8741162933078091366400000e+20, 17, "687411629330780913664", 21},
  {2.3384724056217656250000000e+12, 5, "233847240562176563", 13},
  {9.4180782434098964106539142e-01, 11, "94180782434", 0},
  {1.7539446662787719105836004e+04, 5, "1753944666", 5},
  {2.6516366269360492893607931e-25, 10, "", -10},
  {2.5565623020347388723200000e+20, 9, "255656230203473887232", 21},
  {3.7023791154634767360000000e+18, 10, "3702379115463476736", 19},
  {2.0203378485066801703988334e-13, 4, "", -4},
  {6.6790130739350826177660786e-08, 13, "667901", -7},
  {8.1777595748602107050828636e+03, 1, "81778", 4},
  {3.7518124518687192940624708e-04, 20, "37518124518687193", -3},
  {1.4257016783471459120447784e-18, 15, "", -15},
  {2.0828283978765104025452916e-22, 12, "", -12},
  {6.4266861818164710379280642e-22, 19, "", -19},
  {1.1436765044376786093494047e+01, 9, "11436765044", 2},
  {3.6245777181095804875265998e-02, 3, "36", -1},
  {3.9320467248662278382521345e-19, 11, "", -11},
  {1.2891206458886365916075885e-25, 17, "", -17},
  {3.6937337318302376765188910e-01, 11, "36937337318", 0},
  {1.7225735867147186539051615e-09, 9, "2", -8},
  {5.0671207786730910003883813e-19, 19, "5", -18},
  {9.7241893066881521608781665e-23, 8, "", -8},
  {1.3588321409225363621521065e-22, 18, "", -18},
  {5.7041745998929010400164963e-05, 8, "5704", -4},
  {9.4768476307876531404800000e+20, 8, "947684763078765314048", 21},
  {2.3326535641341028510210322e-10, 8, "", -8},
  {8.2410591601041293312000000e+19, 10, "82410591601041293312", 20},
  {3.1748440074798413918847047e-12, 4, "", -4},
  {2.9241512168894854802395078e-04, 6, "292", -3},
  {1.2632205212569868280070295e+01, 12, "1263220521257", 2},
  {3.2315108749481953718796691e-16, 10, "", -10},
  {4.5403891109116113755650446e-02, 17, "4540389110911611", -1},
  {8.2104769014288672224211041e+02, 3, "821048", 3},
  {3.3280048663230541489442072e-07, 5, "", -5},
  {3.3559814420884750000000000e+14, 9, "3355981442088475", 15},
  {7.1608620812772683853150486e-09, 6, "", -6},
  {1.6708406337534005288034678e+06, 11, "167084063375340053", 7},
  {8.1030037736590911521882908e-07, 4, "", -4},
  {2.3214729081944053567555797e-04, 18, "232147290819441", -3},
  {7.7095943383417325094342232e+05, 20, "77095943383417325094342232", 6},
  {1.2895768657881098875843117e-18, 17, "", -17},
  {1.6600300358839172000000000e+16, 18, "16600300358839172", 17},
  {9.3841790060012157237321618e-22, 5, "", -5},
  {3.2813421642199134582937856e-09, 20, "328134216422", -8},
  {3.3481669453769333374909780e-21, 14, "", -14},
  {1.0188495351237505225284571e-16, 13, "", -13},
  {3.3914633373634389415470877e-13, 10, "", -10},
  {8.2584132532529185803994569e-19, 8, "", -8},
  {7.8347585710013770837756297e-03, 10, "78347586", -2},
  {9.0672646146372730286591527e-21, 16, "", -16},
  {3.8028259446727031329459628e-23, 9, "", -9},
  {8.7276848069317734241485596e+08, 16, "872768480693177342414856", 9},
  {3.2605043979342189105705381e-20, 17, "", -17},
  {4.8893310100356529801501893e+02, 11, "48893310100357", 3},
  {1.0845288452971626818180084e+08, 16, "1084528845297162681818008", 9},
  {1.5680364935750359088366940e-09, 7, "", -7},
  {2.2568791915346868355252425e-18, 17, "", -17},
  {8.2249067444522647857666016e+09, 14, "82249067444522647857666", 10},
  {3.2856769253473609765154876e-10, 7, "", -7},
  {2.8189950494914800000000000e+15, 9, "281899504949148", 16},
  {1.0162511633965209140325302e-05, 13, "101625116", -4},
  {1.5764823682850853049329970e-22, 8, "", -8},
  {5.6405763016227795200000000e+17, 20, "564057630162277952", 18},
  {1.0933457564504227832458128e+02, 18, "109334575645042278325", 3},
  {1.4387040609464482000000000e+16, 20, "14387040609464482", 17},
  {6.4405817903138463020389838e-24, 10, "", -10},
  {2.8665539962519312336536133e-24, 0, "", 0},
  {2.4724331880723446341896476e-01, 15, "247243318807234", 0},
  {1.2544090793830946726017136e-16, 7, "", -7},
  {9.4764959078006643200000000e+17, 2, "947649590780066432", 18},
  {2.4538243380518078851082464e+01, 8, "2453824338", 2},
  {1.1920075890870906586832545e-05, 7, "119", -4},
  {1.0550910602437870572378742e-02, 12, "10550910602", -1},
  {1.1400235321810431180800000e+20, 13, "114002353218104311808", 21},
  {2.8518834937930229861402509e-02, 6, "28519", -1},
  {1.1035877470983136369470784e-04, 1, "", -1},
  {1.5921948203301458624973203e-05, 11, "1592195", -4},
  {4.7167084004909545183181763e+06, 0, "4716708", 7},
  {1.2419636546136482812500000e+14, 16, "124196365461364828125", 15},
  {7.3922591619338973156771999e-01, 2, "74", 0},
  {2.7934179577275599786263628e-08, 14, "2793418", -7},
  {1.6983156748409881497269280e-03, 2, "", -2},
  {5.5566302945262997792230664e-02, 20, "5556630294526299779", -1},
  {6.7142773462525100000000000e+14, 18, "671427734625251", 15},
  {1.1662782838653578948940771e-25, 17, "", -17},
  {3.2578841945816339843750000e+13, 10, "3257884194581633984375", 14},
  {1.0416251171600900467546967e-08, 18, "10416251172", -7},
  {8.2488782008632868182197801e-19, 5, "", -5},
  {1.0920361082708176863534497e-15, 9, "", -9},
  {5.2962052342686291200000000e+17, 11, "529620523426862912", 18},
  {4.1207567022296245117187500e+12, 2, "412075670222962", 13},
  {7.8512167010649415680000000e+18, 9, "7851216701064941568", 19},
  {2.6621772222208442145818894e-06, 4, "", -4},
  {7.6064211538609655150569086e-19, 6, "", -6},
  {8.1338683868410244031110778e+03, 0, "8134", 4},
  {7.9909777815442237440000000e+18, 9, "7990977781544223744", 19},
  {1.3706977751469328573231085e-11, 11, "1", -10},
  {3.4127247595845760264279699e-13, 11, "", -11},
  {1.0156095497697385935317795e-09, 19, "10156095498", -8},
  {3.7427749677379850240000000e+18, 14, "3742774967737985024", 19},
  {1.8418936254648145792220447e-13, 11, "", -11},
  {4.3108500219717580534757257e-17, 1, "", -1},
  {4.3172868350043951905530027e-21, 5, "", -5},
  {3.6081715224135291805035441e-04, 0, "", 0},
  {2.1001671225804573900800000e+20, 0, "210016712258045739008", 21},
  {2.6077872267503948933153879e+02, 17, "26077872267503948933", 3},
  {1.1803216824891442165884741e-23, 20, "", -20},
  {3.0683421929747442015445902e-03, 19, "30683421929747442", -2},
  {1.7066664641518501888000000e+20, 7, "17066664641518501888", 21},
  {3.2687283450147391704376787e+04, 7, "326872834501", 5},
  {2.3913007906964069366455078e+10, 8, "2391300790696406937", 11},
  {2.0868099162703698062007214e-09, 14, "208681", -8},
  {1.3863208594445670899197076e-08, 11, "1386", -7},
  {3.3335890043936514366229671e-07, 11, "33336", -6},
  {5.8332051844466896727681160e+05, 2, "58332052", 6},
  {2.2511209048154863715171814e+08, 20, "22511209048154863715171813965", 9},
  {5.5263939530270611448786432e-21, 3, "", -3},
  {5.0919312719224625644848744e-16, 16, "5", -15},
  {3.3812289197114092000000000e+16, 2, "33812289197114092", 17},
  {3.7678783995904138240000000e+18, 5, "3767878399590413824", 19},
  {7.0036442396684530568677640e-05, 0, "", 0},
  {8.3560775831448336248286068e+02, 4, "8356078", 3},
  {6.1232708719482091520000000e+18, 19, "6123270871948209152", 19},
  {4.5442628312795257568359375e+08, 15, "454426283127952575683594", 9},
  {2.5388134620492011890746653e+04, 14, "2538813462049201189", 5},
  {2.8441581337312613335218189e-08, 19, "284415813373", -7},
  {1.0486279120896789929317829e-23, 16, "", -16},
  {1.2122559424951545036800000e+20, 3, "121225594249515450368", 21},
  {1.8760765357146770838880911e+04, 4, "187607654", 5},
  {4.6497290203001007604798230e-06, 3, "", -3},
  {8.1532137060150028800000000e+17, 19, "815321370601500288", 18},
  {8.6647561817044281250000000e+13, 7, "8664756181704428125", 14},
  {1.4622812776400842844111533e-12, 5, "", -5},
  {1.3322718149873990641190828e-05, 2, "", -2},
  {3.8714525050276042893528938e+06, 11, "387145250502760429", 7},
  {9.5876093315687747654192004e-25, 16, "", -16},
  {5.7721766199309443301501688e-01, 10, "577217662", 0},
  {1.5392743238462583410530726e-02, 10, "153927432", -1},
  {1.9491855594413860000000000e+15, 11, "1949185559441386", 16},
  {2.1558408558991393988435448e+02, 12, "215584085589914", 3},
  {4.9809859423398198559880257e+06, 9, "498098594233982", 7},
  {6.0017318167528219055384398e+05, 0, "600173", 6},
  {3.2080286659968429294123107e-14, 16, "321", -13},
  {2.8246465484605726264216575e-20, 20, "3", -19},
  {5.7324110035040225385421946e-19, 4, "", -4},
  {2.6031153129858375400571254e-08, 11, "2603", -7},
  {3.5849570769200424450985848e-07, 1, "", -1},
  {1.0000295589066172941006272e-01, 9, "100002956", 0},
  {3.2837744660622230529785156e+10, 8, "3283774466062223053", 11},
  {6.5526830324523532535746026e-16, 3, "", -3},
  {3.2551422678121652988848886e-13, 14, "33", -12},
  {2.5445172078697325196117163e+05, 4, "2544517208", 6},
  {1.6344691110582198000000000e+16, 12, "16344691110582198", 17},
  {5.2929281995580677175894380e+04, 15, "52929281995580677176", 5},
  {2.8933002075156782479781176e-09, 16, "28933002", -8},
  {2.4096911241780608892440796e+07, 8, "2409691124178061", 8},
  {1.7093904515721605017586202e-20, 19, "", -19},
  {7.8518087370522767170669693e-10, 15, "785181", -9},
  {2.0444359774199641450689284e-14, 9, "", -9},
  {5.2542882333518838811624666e-18, 18, "5", -17},
  {1.9539627851907204603776336e+05, 10, "195396278519072", 6},
  {1.3096146648908685598475254e-06, 20, "130961466489087", -5},
  {1.6728561752572828903794289e+07, 15, "16728561752572828903794", 8},
  {3.0613986134714730724226683e+04, 16, "306139861347147307242", 5},
  {8.9246681888517805352617485e-04, 19, "8924668188851781", -3},
  {4.6304716150720606250000000e+14, 6, "4630471615072060625", 15},
  {3.3238327351853357016775448e-02, 4, "332", -1},
  {1.6925190817591427366180880e-08, 18, "16925190818", -7},
  {8.6459640129142206410635611e-21, 7, "", -7},
  {2.0684906951850498432700018e-05, 17, "2068490695185", -4},
  {1.4223442652912012344807955e-14, 8, "", -8},
  {7.6875065996317593750000000e+13, 8, "7687506599631759375", 14},
  {2.3595825415483890537871048e+04, 16, "235958254154838905379", 5},
  {2.0205329500749260773773130e+02, 4, "2020533", 3},
  {8.5118876167699773801530080e-10, 13, "8512", -9},
  {6.5686976502315581440000000e+18, 3, "6568697650231558144", 19},
  {1.0255588830989194250743705e-21, 19, "", -19},
  {1.7065519070532321280000000e+19, 2, "1706551907053232128", 20},
  {4.7865104610341250527399959e-04, 8, "47865", -3},
  {7.1156874404342953229636564e-19, 15, "", -15},
  {2.7050475964603655902617797e-06, 11, "270505", -5},
  {2.7358185749211044122388911e-05, 8, "2736", -4},
  {1.0994226407344309082031250e+12, 9, "1099422640734430908203", 13},
  {7.3613475851134143066406250e+11, 1, "7361347585113", 12},
  {5.2037255813966887071728706e+06, 13, "52037255813966887072", 7},
  {1.6616070759958073541564315e-24, 0, "", 0},
  {2.1324753402614293388119340e-06, 19, "21324753402614", -5},
  {6.8873796174609303727409682e-03, 13, "68873796175", -2},
  {1.9005527767964291338154343e-22, 10, "", -10},
  {1.3264010403142822611565575e-16, 3, "", -3},
  {5.2504434830751544949889912e-11, 3, "", -3},
  {3.0656023917921431699851187e-03, 9, "3065602", -2},
  {9.6049795049720874344145933e-09, 1, "", -1},
  {4.7171173568716449737548828e+09, 2, "471711735687", 10},
  {3.7376462385705798864364624e+07, 11, "3737646238570579886", 8},
  {2.9929709018693991375614850e-12, 12, "3", -11},
  {2.3935809673968544602394104e+08, 0, "239358097", 9},
  {1.5562871077417095680000000e+18, 10, "1556287107741709568", 19},
  {3.3372270464389392000000000e+16, 15, "33372270464389392", 17},
  {1.0193119739278273357635210e-18, 19, "1", -17},
  {1.0451905414085273995818064e-08, 15, "10451905", -7},
  {4.7380945603390289761591703e+04, 12, "4738094560339029", 5},
  {2.7669772356208071510506601e-24, 4, "", -4},
  {3.9763052039465321286115795e+04, 0, "39763", 5},
  {3.2209723648858104314585508e-13, 0, "", 0},
  {7.6086212933022677898406982e+06, 10, "76086212933022678", 7},
  {5.2861182636420615474359685e-03, 8, "528612", -2},
  {1.3102508556020462075396814e-11, 18, "13102509", -10},
  {8.8560827369712324941275483e-02, 3, "89", -1},
  {3.9116425465865710398016830e-02, 13, "391164254659", -1},
  {3.3694174721874498534756344e-25, 20, "", -20},
  {7.5618488792130004882812500e+11, 0, "756184887921", 12},
  {6.7095688014637062224210240e+01, 15, "67095688014637062", 2},
  {9.7225783904410764679759893e-02, 2, "1", 0},
  {2.1425500367524610290369021e-16, 3, "", -3},
  {1.0804571290183687493235845e-13, 7, "", -7},
  {2.5064275204450676310949462e-21, 19, "", -19},
  {3.6138899517922478166815096e-18, 20, "361", -17},
  {8.7013630766958037109375000e+12, 8, "870136307669580371094", 13},
  {2.3378287687809634192615427e-07, 6, "", -6},
  {3.5404371703577752610962291e-23, 16, "", -16},
  {5.3682100656840156250000000e+13, 5, "5368210065684015625", 14},
  {2.8600571079149947763653472e+04, 14, "2860057107914994776", 5},
  {1.0727669922730501854439254e-14, 7, "", -7},
  {5.4356565563045596171805761e-22, 2, "", -2},
  {2.8818728789294404180054698e+01, 13, "288187287892944", 2},
  {1.1713249493119182481068292e-24, 8, "", -8},
  {8.6735614028643682339901545e-08, 14, "8673561", -7},
  {2.3874159099445609821425918e-14, 9, "", -9},
  {1.3432396756894529342651367e+10, 16, "134323967568945293426513672", 11},
  {2.1679353632788907736539841e+07, 5, "2167935363279", 8},
  {1.5909213232970377151317043e-07, 8, "16", -6},
  {4.1504728685157590000000000e+15, 20, "4150472868515759", 16},
  {3.0586376998244965077986961e-22, 7, "", -7},
  {6.2803284216090426994583140e+00, 9, "6280328422", 1},
  {2.3922391057427318700116008e-14, 9, "", -9},
  {2.4163037059957585828140481e-02, 18, "24163037059957586", -1},
  {3.3501306416521616977422334e-10, 6, "", -6},
  {1.0426782604505304000000000e+17, 12, "10426782604505304", 18},
  {2.8938510429371518969421412e-12, 6, "", -6},
  {9.6587079662960387000780055e-06, 10, "96587", -5},
  {2.6873002507326819443544963e-02, 1, "", -1},
  {4.2384149459283784499200000e+20, 20, "423841494592837844992", 21},
  {6.1562742440924100000000000e+15, 1, "615627424409241", 16},
  {1.3630068608829742579735919e-11, 3, "", -3},
  {1.4126846936258037500000000e+14, 8, "141268469362580375", 15},
  {9.7888104274876497920000000e+18, 4, "9788810427487649792", 19},
  {2.8083679142926438063757042e-16, 10, "", -10},
  {8.0061076130090383360000000e+18, 4, "8006107613009038336", 19},
  {1.8028603979457308800000000e+17, 5, "180286039794573088", 18},
  {6.4248836333792593396773904e-06, 11, "642488", -5},
  {7.8548050297859689072160760e-05, 14, "785480503", -4},
  {7.2751937488831288646906614e+04, 10, "727519374888313", 5},
  {7.4992911522053672960000000e+18, 15, "7499291152205367296", 19},
  {1.3247909751108377240598202e+06, 8, "132479097511084", 7},
  {1.1516826422820538311977237e-22, 0, "", 0},
  {2.6443784995505559012374065e-19, 8, "", -8},
  {1.6723686648131019533841668e-03, 17, "16723686648131", -2},
  {2.1867846146160030364990234e+08, 18, "218678461461600303649902344", 9},
  {4.8645613864386873245239258e+09, 16, "48645613864386873245239258", 10},
  {3.9380801488008120025963166e-02, 13, "39380801488", -1},
  {1.2356939778773742727935314e+05, 9, "123569397787737", 6},
  {1.8915010521848789443573495e-18, 16, "", -16},
  {8.1100815015973435760000697e-21, 11, "", -11},
  {3.2323367206943247360000000e+18, 17, "3232336720694324736", 19},
  {1.0327754048712695837020874e+09, 0, "1032775405", 10},
  {6.7483862611166427225026746e-19, 3, "", -3},
  {4.0569489281736451387405396e+08, 18, "405694892817364513874053955", 9},
  {1.8629480299108489569411690e-05, 20, "1862948029910849", -4},
  {1.1214198634841042803600430e+04, 14, "112141986348410428", 5},
  {7.3953565686005299539829139e+02, 16, "7395356568600529954", 3},
  {2.8803643943810710442710032e-03, 14, "288036439438", -2},
  {1.5834844061124225905138208e-07, 12, "158348", -6},
  {1.7721595169298512309312421e-04, 15, "177215951693", -3},
  {4.5955958104940128034284391e-25, 20, "", -20},
  {5.9390807240621698692137126e-07, 9, "594", -6},
  {1.0666465637012925071758218e+04, 14, "1066646563701292507", 5},
  {3.8701255657624878729272384e-11, 6, "", -6},
  {4.9672758049855943829830121e-24, 8, "", -8},
  {2.9121578607641317506053187e-10, 7, "", -7},
  {1.2393817800779108045283927e-13, 19, "1239382", -12},
  {5.1502960766462513220176334e+02, 19, "5150296076646251322018", 3},
  {9.2734493609525619200000000e+17, 5, "927344936095256192", 18},
  {3.9497627151649775286769901e-17, 17, "4", -16},
  {7.5104447459341504000000000e+16, 16, "75104447459341504", 17},
  {3.4262313099858748843828948e-02, 16, "342623130998587", -1},
  {1.4799520158037438959331093e-23, 9, "", -9},
  {1.4934417887459132500000000e+15, 2, "149344178874591325", 16},
  {6.7305228719201792000000000e+17, 20, "67305228719201792", 18},
  {1.7870711946430847167968750e+10, 10, "17870711946430847168", 11},
  {3.8791225013366378698355307e-19, 6, "", -6},
  {4.9249488925853313406322265e-04, 14, "49249488926", -3},
  {1.2597894553505982359756508e-11, 11, "1", -10},
  {4.0760328915439583249968680e-23, 20, "", -20},
  {2.1267172480678733828801229e-06, 8, "213", -5},
  {3.2463948348687849085670047e-11, 8, "", -8},
  {4.1928308354372934530804388e-20, 15, "", -15},
  {4.9105689951122515057857498e-02, 4, "491", -1},
  {1.0341269953286616000000000e+17, 3, "10341269953286616", 18},
  {6.8802022996506631446853811e-25, 9, "", -9},
  {8.0638666307958774642667469e-15, 5, "", -5},
  {4.4125066133846792313646756e-10, 11, "44", -9},
  {1.7480696859824333841970656e+03, 9, "1748069685982", 4},
  {1.3851624856342976695252765e-07, 4, "", -4},
  {1.2253759452806129912321581e-05, 13, "122537595", -4},
  {5.6565435376432410991557296e-20, 11, "", -11},
  {1.3054674626604227082159642e-15, 18, "1305", -14},
  {1.0903546005892915005119903e+01, 16, "10903546005892915", 2},
  {3.5633699214530700902400000e+20, 15, "356336992145307009024", 21},
  {8.3471804521394285525381918e-02, 13, "834718045214", -1},
  {4.3256248872636299431528569e-23, 7, "", -7},
  {3.2383067136015330000000000e+15, 12, "3238306713601533", 16},
  {1.2669184077097484841942787e+06, 10, "12669184077097485", 7},
  {8.4181935926149326616824164e-08, 5, "", -5},
  {1.0020972369526395806538233e-01, 4, "1002", 0},
  {4.9017856523403403116390109e+04, 5, "4901785652", 5},
  {7.9786759839378229751704876e-25, 15, "", -15},
  {2.3945561858861845708800000e+20, 8, "239455618588618457088", 21},
  {1.6223579802128291200000000e+17, 7, "162235798021282912", 18},
  {2.6138964525872302924505659e-21, 20, "", -20},
  {9.1161707194984546889958059e-25, 19, "", -19},
  {4.4194844631368804196158556e-13, 3, "", -3},
  {1.6438842601607435494789597e-22, 9, "", -9},
  {6.3835105452026154188800000e+20, 3, "638351054520261541888", 21},
  {1.5710093452747361797428027e-01, 6, "157101", 0},
  {5.3905690846020036133268150e+01, 5, "5390569", 2},
  {6.3282745157259458874086933e-05, 10, "632827", -4},
  {3.8400764541700787901845615e+01, 14, "3840076454170079", 2},
  {1.6418896609775965059643767e-20, 12, "", -12},
  {7.1224714053979516029357910e+08, 20, "71224714053979516029357910156", 9},
  {1.0002259520114426049788154e-09, 6, "", -6},
  {1.4258274526213514527194323e-12, 3, "", -3},
  {2.4216273400346502685546875e+11, 9, "242162734003465026855", 12},
  {3.2550387943155981445312500e+11, 2, "32550387943156", 12},
  {7.0444790172332131862640381e+08, 4, "7044479017233", 9},
  {3.2291302965940110736298152e-01, 1, "3", 0},
  {6.9352357423578953125000000e+13, 6, "69352357423578953125", 14},
  {2.6548339031756610107421875e+11, 20, "26548339031756610107421875", 12},
  {2.0751443296796796377043569e-19, 0, "", 0},
  {9.1551336358267993600000000e+17, 20, "915513363582679936", 18},
  {3.8410765912537218891298352e-04, 17, "38410765912537", -3},
  {1.3214940794890561536000000e+19, 16, "13214940794890561536", 20},
  {3.2526066914587318750000000e+14, 7, "3252606691458731875", 15},
  {2.6686514131069810629171002e-01, 18, "266865141310698106", 0},
  {3.6681584338366489309957250e-06, 8, "367", -5},
  {4.7354614966596488952636719e+09, 0, "4735461497", 10},
  {8.8429084602073819865869497e-04, 3, "1", -2},
  {1.8822887158527337305713445e+03, 7, "18822887159", 4},
  {2.6621013042968106816120672e-08, 18, "26621013043", -7},
  {1.4447824323120145513144113e-24, 14, "", -14},
  {5.8806783774881829216278274e-13, 3, "", -3},
  {7.5888217762069608917746979e-20, 18, "", -18},
  {4.5909335185961058089821099e-10, 6, "", -6},
  {1.6948045563808916514087585e-12, 15, "1695", -11},
  {2.1520031935942270706618729e+02, 18, "215200319359422707066", 3},
  {7.0995075214163829113998732e-15, 18, "71", -14},
  {2.8719807727869896754805987e-11, 12, "29", -10},
  {1.6974288088428501401600000e+20, 17, "169742880884285014016", 21},
  {1.5129342949975891307198242e-08, 13, "151293", -7},
  {5.9834713711879823360000000e+19, 14, "5983471371187982336", 20},
  {1.6626309372756232957848810e-15, 14, "", -14},
  {2.7817389625511713027954102e+09, 18, "2781738962551171302795410156", 10},
  {5.0938992253220025230301848e-21, 0, "", 0},
  {4.7302777965578457407573182e-11, 10, "", -10},
  {3.3165337142047337256371975e+06, 1, "33165337", 7},
  {1.1698341132736780334511195e+00, 16, "1169834113273678", 1},
  {2.0333505835121510330054662e+01, 20, "2033350583512151033005", 2},
  {1.3881762544930793344974518e+07, 17, "1388176254493079334497452", 8},
  {8.1004589046126895774486859e-24, 20, "", -20},
  {2.4739257285177912563085556e+07, 0, "24739257", 8},
  {1.4649087954417968423666382e-24, 8, "", -8},
  {1.2594143582155129600000000e+17, 19, "125941435821551296", 18},
  {4.2791469074281305000000000e+15, 12, "42791469074281305", 16},
  {5.4064662620902839660644531e+10, 10, "540646626209028396606", 11},
  {2.7566908129128242324272030e-19, 15, "", -15},
  {2.1924322974585658880000000e+18, 20, "2192432297458565888", 19},
  {1.3213492154072859240207543e-21, 9, "", -9},
  {1.8305565429146570157953727e-18, 9, "", -9},
  {4.5682723044281953125000000e+12, 1, "45682723044282", 13},
  {9.1878111857773234831785087e-10, 3, "", -3},
  {4.2829618086298704147338867e+08, 0, "428296181", 9},
  {1.4186690529862841905123112e-08, 19, "141866905299", -7},
  {4.4474165129749502394038846e-05, 1, "", -1},
  {3.9032320987031328000000000e+17, 17, "39032320987031328", 18},
  {2.1940147242488565564347772e-18, 15, "", -15},
  {7.7655190890731091712950729e+00, 1, "78", 1},
  {1.1273457960424628096964607e-16, 6, "", -6},
  {1.0412152580609003520000000e+19, 5, "1041215258060900352", 20},
  {4.2192234611489334321942737e-15, 17, "422", -14},
  {6.2997977826824487304687500e+11, 7, "629979778268244873", 12},
  {5.0747288929042638302813351e-17, 3, "", -3},
  {1.5962233202315028480000000e+19, 5, "1596223320231502848", 20},
  {8.3547604058962500385279238e-09, 7, "", -7},
  {3.6227605928890617856000000e+19, 5, "36227605928890617856", 20},
  {7.6305863804804164533118760e-04, 20, "76305863804804165", -3},
  {2.1126905130808671538922404e-16, 2, "", -2},
  {1.8566421767632766113281250e+12, 16, "1856642176763276611328125", 13},
  {1.3852467127834692597389221e+07, 11, "138524671278346926", 8},
  {1.4494878169723257075232197e-25, 9, "", -9},
  {2.4798760956287875755280006e-24, 20, "", -20},
  {1.0813909809689181217101393e-08, 15, "1081391", -7},
  {9.9409208477742273335897042e-18, 10, "", -10},
  {1.0203663524081900675771761e-03, 20, "102036635240819007", -2},
  {2.6328396679094393034707275e-09, 1, "", -1},
  {1.3142496423900397530815098e+03, 17, "131424964239003975308", 4},
  {1.1765260399646316363941878e+05, 8, "11765260399646", 6},
  {1.8346269943954785000000000e+15, 14, "18346269943954785", 16},
  {1.7306662144957855842999403e-23, 6, "", -6},
  {1.0493955211716353122589074e-04, 4, "1", -3},
  {2.5570558037051858264021575e+04, 18, "25570558037051858264022", 5},
  {5.0900735422131852488426075e-10, 4, "", -4},
  {5.3402617603201644492625950e-11, 14, "534", -10},
  {3.1033072194547885742187500e+12, 3, "3103307219454789", 13},
  {1.4566050971560917678292567e-08, 6, "", -6},
  {2.2692076614497879933781661e-20, 4, "", -4},
  {1.9058639671292239800095558e+06, 6, "1905863967129", 7},
  {1.1072184667921796119571809e+01, 6, "11072185", 2},
  {1.9121855863435790535673314e-24, 18, "", -18},
  {9.5817688938185224610364068e-22, 20, "", -20},
  {3.7496268276125355948646262e-05, 12, "37496268", -4},
  {7.2024527363438219817242679e-19, 8, "", -8},
  {3.1951737517719881742639387e-02, 20, "3195173751771988174", -1},
  {7.7637217129107657672590669e-18, 14, "", -14},
  {4.1428027921139001846313477e+06, 4, "41428027921", 7},
  {1.5501843045813895761966705e+07, 4, "155018430458", 8},
  {1.1998058469100136846918758e+01, 4, "119981", 2},
  {6.4595885270171842737309257e-22, 8, "", -8},
  {5.0127066967863426194540466e-02, 18, "50127066967863426", -1},
  {1.0918179192989773412208527e-16, 3, "", -3},
  {4.7250912100807333836392093e-05, 19, "472509121008073", -4},
  {1.2949166990228093254700070e+01, 17, "1294916699022809325", 2},
  {1.9924208506631916000000000e+16, 19, "19924208506631916", 17},
  {1.2788999613621288497353163e-25, 12, "", -12},
  {1.7391016742126472294330597e+07, 1, "173910167", 8},
  {1.4929324059319857287420064e+00, 2, "149", 1},
  {8.3192828140921183103851700e-08, 0, "", 0},
  {1.1382053095569673010997222e-15, 7, "", -7},
  {6.7039437791216012800000000e+17, 17, "670394377912160128", 18},
  {1.3508367104552423257411535e-05, 6, "14", -4},
  {8.0884392140718413200870160e-22, 4, "", -4},
  {5.5183956465173332214355469e+10, 11, "5518395646517333221436", 11},
  {7.8200653830137982484839858e-15, 17, "782", -14},
  {1.5136394604350077005796198e-18, 4, "", -4},
  {2.0596414867817488914005338e-08, 10, "206", -7},
  {2.1119925279694664262187226e-16, 15, "", -15},
  {3.9840058854229213865585923e-06, 18, "3984005885423", -5},
  {1.7643826777533282304000000e+19, 1, "17643826777533282304", 20},
  {4.4469397215059030835200000e+20, 1, "444693972150590308352", 21},
  {4.2625582486166978047161139e-23, 10, "", -10},
  {3.8645946190653895913058591e-02, 8, "3864595", -1},
  {1.0098777696335548044871515e-06, 8, "101", -5},
  {9.3340488846427187087522557e-09, 15, "9334049", -8},
  {4.9027226474934962931057425e-24, 4, "", -4},
  {2.2762010296760074218750000e+13, 13, "2276201029676007421875", 14},
  {9.0926408690864411480765585e-09, 16, "90926409", -8},
  {3.5577735820393123840000000e+19, 1, "3557773582039312384", 20},
  {3.5649225890104497693755548e+02, 17, "35649225890104497694", 3},
  {3.8804740988046935000000000e+15, 5, "38804740988046935", 16},
  {8.6854403585971193930102829e-05, 5, "9", -4},
  {1.5255595231119970703125000e+13, 11, "15255595231119970703125", 14},
  {8.5987229543776000692924602e-06, 20, "85987229543776", -5},
  {2.4523984251066289837329439e-12, 14, "245", -11},
  {2.7283012369135954920042597e-11, 7, "", -7},
  {4.7874548564426106167957187e+04, 2, "4787455", 5},
  {6.3926005566151942938344613e-24, 16, "", -16},
  {2.2674904519535764814213159e-23, 3, "", -3},
  {7.6625990132473742961883545e+08, 13, "7662599013247374296188", 9},
  {1.1676612150456027508934318e-20, 14, "", -14},
  {8.6015422020478212500000000e+14, 2, "86015422020478213", 15},
  {1.1136952045706440000000000e+17, 17, "1113695204570644", 18},
  {7.0096471270162144204240934e-19, 7, "", -7},
  {1.5500737178996802837779377e-25, 3, "", -3},
  {3.7005339241498912060413365e-13, 9, "", -9},
  {6.1329516567479108028166860e-20, 2, "", -2},
  {3.2574799761222827911376953e+10, 3, "32574799761223", 11},
  {1.9560774905621153376552145e-13, 14, "2", -12},
  {1.4960597631772779372224100e-10, 14, "14961", -9},
  {4.8741059058940344739241368e-01, 18, "487410590589403447", 0},
  {1.4771094522137126912000000e+19, 10, "14771094522137126912", 20},
  {1.4564788040486516980778001e-13, 2, "", -2},
  {1.4485697915712097814993718e-22, 20, "", -20},
  {2.1692434584025149552251321e-04, 5, "22", -3},
  {2.3707348606007341468206810e-14, 0, "", 0},
  {1.5495960481383895040000000e+19, 5, "1549596048138389504", 20},
  {2.5937879431624895930492678e-15, 1, "", -1},
  {9.6189257179703758723378348e-05, 11, "9618926", -4},
  {3.2467969140237512588500977e+09, 18, "3246796914023751258850097656", 10},
  {3.6380293843680533427686896e+03, 19, "36380293843680533427687", 4},
  {1.3918272489682134297395763e-18, 15, "", -15},
  {6.3481990211835346944000000e+19, 13, "63481990211835346944", 20},
  {4.6837128045072524460857836e-23, 18, "", -18},
  {4.4136162078513501910492778e+04, 14, "4413616207851350191", 5},
  {1.2837813896759368940351347e-22, 7, "", -7},
  {7.2533292892077346817411565e-19, 1, "", -1},
  {1.6687748799475522246211767e+06, 16, "16687748799475522246212", 7},
  {1.1430452025013055298588873e-25, 14, "", -14},
  {8.6244317766091583135543959e-19, 5, "", -5},
  {1.5921523530154925603914094e-09, 8, "", -8},
  {5.1869329897137020000000000e+15, 19, "5186932989713702", 16},
  {8.2431981628661143961600000e+20, 15, "824319816286611439616", 21},
  {7.8169292769404032000000000e+17, 0, "78169292769404032", 18},
  {5.9060981018906525696000000e+20, 17, "59060981018906525696", 21},
  {8.9848464667864997459883380e-25, 9, "", -9},
  {6.0568195254604469299316406e+10, 9, "60568195254604469299", 11},
  {4.7581720579639663388259725e-11, 0, "", 0},
  {6.7718347928444810185961384e-24, 4, "", -4},
  {3.4115163463069352281189695e-13, 18, "341152", -12},
  {2.0919317892350861430168152e+08, 13, "2091931789235086143017", 9},
  {7.7642067596425647735595703e+09, 8, "776420675964256477", 10},
  {2.4494977818438814135780150e-18, 14, "", -14},
  {4.1952597344029551012226835e-08, 15, "41952597", -7},
  {1.2341250501392832666169852e+05, 18, "123412505013928326661699", 6},
  {3.0648950179041195644408683e-24, 12, "", -12},
  {9.4387884944144040000000000e+15, 12, "9438788494414404", 16},
  {1.2092900203188602925585826e-01, 20, "12092900203188602926", 0},
  {7.2734434743221200000000000e+14, 19, "727344347432212", 15},
  {3.0235061430300805120000000e+18, 13, "3023506143030080512", 19},
  {1.5371731485861244928000000e+19, 4, "15371731485861244928", 20},
  {8.4305557634600976562500000e+11, 11, "843055576346009765625", 12},
  {2.6857573002436824798583984e+10, 5, "2685757300243682", 11},
  {4.3265804862707571984670776e-15, 9, "", -9},
  {2.0142663145022395000000000e+15, 2, "20142663145022395", 16},
  {2.1332645361855623168000000e+19, 17, "21332645361855623168", 20},
  {1.0331020175819742266140697e-06, 14, "103310202", -5},
  {4.9275199050559382385472418e+02, 11, "49275199050559", 3},
  {7.2969886478957608245965449e-05, 13, "729698865", -4},
  {2.6246849848308840942382812e+11, 3, "262468498483088", 12},
  {1.0582998307409998437500000e+14, 8, "105829983074099984375", 15},
  {5.5421683034336867117597357e-23, 1, "", -1},
  {7.1369225378130491482957494e-15, 10, "", -10},
  {2.2356547658087869741139778e-23, 6, "", -6},
  {2.5003866006203512936673397e-23, 7, "", -7},
  {7.2546811617282917710689558e-07, 10, "7255", -6},
  {6.6925300975276920669958915e-12, 17, "669253", -11},
  {1.4731167098106037597656250e+12, 12, "1473116709810603759765625", 13},
  {1.8381705655524040924014223e-10, 20, "18381705656", -9},
  {1.8168635319628100481455155e-18, 5, "", -5},
  {1.0832686613142710196910912e+00, 17, "108326866131427102", 1},
  {7.7747914713123174400000000e+17, 4, "777479147131231744", 18},
  {1.2212975816494864821082356e-03, 3, "1", -2},
  {6.8443945281358286738395691e+06, 12, "6844394528135828674", 7},
  {5.1446179816407445854753444e-04, 2, "", -2},
  {8.3698507513346930863917805e+02, 15, "836985075133469309", 3},
  {9.3749715584062375000000000e+14, 10, "93749715584062375", 15},
  {1.0594769026533422851562500e+11, 20, "105947690265334228515625", 12},
  {7.3544169290668854867316645e-20, 17, "", -17},
  {1.5931371939552312255727884e+02, 9, "159313719396", 3},
  {1.1344813074167509460449219e+11, 5, "11344813074167509", 12},
  {4.7099704180187793444807456e-25, 4, "", -4},
  {3.2463219890995569998219891e-25, 4, "", -4},
  {7.9423425444093758284874754e-15, 7, "", -7},
  {1.4259378267726328242373509e-15, 10, "", -10},
  {2.3538288449721134375000000e+14, 2, "23538288449721134", 15},
  {6.0221568955650955681367832e-15, 6, "", -6},
  {1.4527070599708558000000000e+16, 15, "14527070599708558", 17},
  {5.3276025810079861988466376e-02, 8, "5327603", -1},
  {3.2696565113502547242234830e-13, 14, "33", -12},
  {5.1094271237441378878035112e-11, 5, "", -5},
  {1.7741929422126573626883328e+04, 17, "1774192942212657362688", 5},
  {2.4906173511867721318400000e+20, 12, "249061735118677213184", 21},
  {4.2789416152104914062500000e+13, 20, "427894161521049140625", 14},
  {3.7129905741769364690041573e-06, 14, "371299057", -5},
  {7.2233454837715660445951471e-01, 4, "7223", 0},
  {2.0994569684500551610358256e-08, 19, "209945696845", -7},
  {5.2206906153572990527378352e-18, 18, "5", -17},
  {2.0304123560847635801057984e-13, 14, "2", -12},
  {1.8692055110945140190274511e-11, 7, "", -7},
  {6.5123120693520396212859975e-23, 1, "", -1},
  {1.0640316011606779479980469e+11, 19, "1064031601160677947998046875", 12},
  {3.2543732092699306085705757e+06, 2, "325437321", 7},
  {6.5624669560682184994220734e+07, 9, "65624669560682185", 8},
  {2.9041529692727540772916495e-08, 14, "2904153", -7},
  {4.4148879394014921188354492e+09, 0, "4414887939", 10},
  {2.1743083733958816938202649e-19, 7, "", -7},
  {1.1110731681127236224710941e+06, 13, "11110731681127236225", 7},
  {8.6309893119963150024414062e+09, 1, "8630989312", 10},
  {1.5320197465086259087983342e-24, 7, "", -7},
  {1.5970496357607998943792436e-09, 5, "", -5},
  {1.2626108866120730467308420e-01, 10, "1262610887", 0},
  {2.5255092605679070155342530e-12, 20, "252550926", -11},
  {1.6536983781974416699884914e-06, 3, "", -3},
  {4.9704988350794521185331006e-16, 0, "", 0},
  {4.1486847471049696000000000e+16, 13, "41486847471049696", 17},
  {3.3593286033069578166987412e+00, 12, "3359328603307", 1},
  {4.1381257697497485351562500e+12, 10, "41381257697497485351563", 13},
  {1.0248499689761132800000000e+17, 12, "102484996897611328", 18},
  {1.5446124532358927734375000e+13, 6, "15446124532358927734", 14},
  {8.8430970960269354045637957e-10, 4, "", -4},
  {5.1990688304033111572265625e+11, 10, "5199068830403311157227", 12},
  {3.8791841112584325192147450e-03, 13, "38791841113", -2},
  {1.9472005256108525372837903e+02, 0, "195", 3},
  {8.5836128630040476536588103e-09, 2, "", -2},
  {8.1895429816077331202372994e-22, 10, "", -10},
  {2.6359705912769517688332144e+00, 3, "2636", 1},
  {3.8802503759054239651504759e+01, 19, "388025037590542396515", 2},
  {8.9674985731235301301437757e-23, 10, "", -10},
  {1.8669675954395199557467322e+00, 15, "186696759543952", 1},
  {1.9308770757174651892290340e-10, 18, "193087708", -9},
  {8.5076172011365906425804860e-11, 9, "", -9},
  {4.2049479660082275390625000e+11, 8, "42049479660082275391", 12},
  {9.4707740793332182989761793e-20, 19, "1", -18},
  {1.2942978542920184071215724e-07, 6, "", -6},
  {3.1344633008041557993062810e-10, 19, "3134463301", -9},
  {1.1827992514530467224121094e+11, 17, "1182799251453046722412109375", 12},
  {6.6079785896871434240000000e+18, 8, "6607978589687143424", 19},
  {1.3460682353810147701689282e-03, 20, "134606823538101477", -2},
  {7.2308862613139584000000000e+16, 3, "72308862613139584", 17},
  {4.2492960026400483911857009e+05, 18, "42492960026400483911857", 6},
  {1.4166919431233015060424805e+09, 11, "141669194312330150604", 10},
  {2.7347518084898182020789815e-17, 10, "", -10},
  {2.8468795007916201184388921e-23, 4, "", -4},
  {3.3097830252633081089980709e-24, 6, "", -6},
  {1.1866909131966079371522937e+02, 6, "118669091", 3},
  {1.7817651647066938102177496e-18, 18, "2", -17},
  {3.7378564310409067263201160e-08, 9, "37", -7},
  {1.6370745423623044490814209e+09, 5, "16370745423623", 10},
  {2.0566343250202085937500000e+13, 1, "205663432502021", 14},
  {2.5388381114686776271027228e-20, 20, "3", -19},
  {1.2034966905788146972656250e+12, 8, "120349669057881469727", 13},
  {1.1833928645314670357845562e-11, 11, "1", -10},
  {8.5687890658910303438030918e-16, 3, "", -3},
  {4.5081045705040770000000000e+15, 0, "4508104570504077", 16},
  {2.9278683976321752929687500e+11, 9, "292786839763217529297", 12},
  {2.8733156312058974057435989e+07, 13, "287331563120589740574", 8},
  {3.2578275195312078125000000e+13, 5, "3257827519531207813", 14},
  {3.4680641869269229252366314e-20, 17, "", -17},
  {5.6431525775370444800000000e+18, 7, "564315257753704448", 19},
  {2.2270042585745042918844764e-17, 17, "2", -16},
  {1.4832501370913281407455375e-22, 2, "", -2},
  {2.9673565293652762500000000e+14, 13, "296735652936527625", 15},
  {7.7712836677561106410041515e-22, 3, "", -3},
  {1.8875820905674547813047964e-11, 19, "188758209", -10},
  {5.7628279009746391763763240e-04, 9, "576283", -3},
  {3.0683033057028765711038432e+00, 2, "307", 1},
  {2.1819970435744671412303664e-03, 13, "21819970436", -2},
  {2.2498306341213172564313412e-12, 7, "", -7},
  {1.0281445924000768765899962e-06, 18, "10281445924", -5},
  {9.3516332793057189987084854e-03, 8, "935163", -2},
  {1.7062769201968174449772219e-16, 17, "17", -15},
  {3.6089348806472643475649354e-11, 8, "", -8},
  {2.0467453568051511049270630e+08, 17, "2046745356805151104927063", 9},
  {1.0714753210883623978588730e+05, 4, "1071475321", 6},
  {1.2408561614630720271179598e+02, 11, "12408561614631", 3},
  {4.4839574397126274007977414e-18, 19, "45", -17},
  {4.1623214454615400000000000e+14, 14, "416232144546154", 15},
  {6.2462369291623570024967194e+07, 6, "62462369291624", 8},
  {6.8127004559479756311171205e-07, 9, "681", -6},
  {1.1509135232776157677635688e-23, 18, "", -18},
  {1.2817689789625347245324069e-11, 6, "", -6},
  {4.8901960536488965153694153e+06, 15, "4890196053648896515369", 7},
  {1.2495600723452714709558663e-19, 17, "", -17},
  {1.0504008036705202727048666e-25, 14, "", -14},
  {1.2480549758460064928153217e-20, 6, "", -6},
  {5.9926388039084566017322686e-01, 15, "599263880390846", 0},
  {4.7090729653604217197493398e-02, 6, "47091", -1},
  {8.3503985841031523425234206e-15, 14, "1", -13},
  {5.7650131394242933647241310e-11, 16, "576501", -10},
  {5.2078151772066497691461573e-05, 2, "", -2},
  {1.4566486573542769544786779e+00, 1, "15", 1},
  {2.6423956890070915481600000e+20, 9, "264239568900709154816", 21},
  {6.8539138300019290931200000e+20, 5, "685391383000192909312", 21},
  {2.8049372480220866203308105e+09, 14, "280493724802208662033081", 10},
  {1.6894457736775440548463744e-09, 17, "168944577", -8},
  {1.5729456693251420788213184e-14, 6, "", -6},
  {1.3946434743644896769865227e+01, 6, "13946435", 2},
  {5.3695324555327292404994263e-13, 12, "1", -11},
  {3.6175176747018664379113413e-25, 15, "", -15},
  {4.2821507803173417639830758e-06, 14, "428215078", -5},
  {1.2986637768210984000000000e+17, 16, "12986637768210984", 18},
  {6.8049894161373829841613770e+08, 12, "680498941613738298416", 9},
  {2.4898360774017106387522672e-22, 9, "", -9},
  {5.3252212259073261565715591e-14, 8, "", -8},
  {5.5794017955158600228641741e-14, 8, "", -8},
  {2.8968135684564698031923393e-18, 20, "29", -17},
  {2.5570000814171949854842748e-18, 12, "", -12},
  {2.7249027949514009058475494e+07, 6, "27249027949514", 8},
  {3.8951485740905846469104290e+06, 15, "389514857409058464691", 7},
  {4.4750750604018522906167222e-15, 6, "", -6},
  {6.7806117739392034406400000e+20, 15, "678061177393920344064", 21},
  {6.2803270978204295039176941e+07, 9, "62803270978204295", 8},
  {1.2571274025690080319601239e-18, 11, "", -11},
  {7.7249553584436664029927897e-13, 5, "", -5},
  {5.8450950067987207740263442e-10, 3, "", -3},
  {1.8939225212649710010737181e+05, 2, "18939225", 6},
  {5.8231549181166828132417921e-15, 3, "", -3},
  {1.8507511493680527781642217e-05, 20, "1850751149368053", -4},
  {5.5540889287552446139579511e-06, 16, "55540889288", -5},
  {1.7412081960989336142965468e-13, 18, "174121", -12},
  {1.0370893958292548473935260e-10, 3, "", -3},
  {4.2172534762164053745436831e+02, 11, "42172534762164", 3},
  {5.9550051066682176386518632e-04, 16, "5955005106668", -3},
  {4.1328606912083775387008343e-19, 4, "", -4},
  {8.2328246234933050000000000e+14, 2, "8232824623493305", 15},
  {1.0553200691754044846142300e-23, 1, "", -1},
  {7.1720523083800653482700049e-03, 16, "71720523083801", -2},
  {1.1691522292099405730822664e-08, 10, "117", -7},
  {5.3917354014745329766284815e-17, 20, "5392", -16},
  {1.9719784953282566419829891e+01, 19, "197197849532825664198", 2},
  {2.7793233947511193600000000e+17, 4, "277932339475111936", 18},
  {8.4547297458564414085826627e-22, 10, "", -10},
  {1.8013443196457824669778347e+06, 14, "180134431964578246698", 7},
  {2.5550090775266978895038854e-22, 17, "", -17},
  {1.5838123992457874826353584e-24, 12, "", -12},
  {1.8756437275250621839092804e-09, 17, "187564373", -8},
  {3.1153095600775757824000000e+20, 1, "31153095600775757824", 21},
  {1.8932816988302163036446415e-19, 6, "", -6},
  {1.4449566107164056686839536e-20, 18, "", -18},
  {1.0868169462631189928301240e-04, 2, "", -2},
  {2.3209580009129676172224812e-11, 16, "232096", -10},
  {1.2554288090742182617187500e+12, 9, "1255428809074218261719", 13},
  {3.9499262457472388458938893e-22, 16, "", -16},
  {4.8875422484560000000000000e+13, 10, "4887542248456", 14},
  {2.0000819711198049481026828e+05, 12, "200008197111980495", 6},
  {5.0419045505832214230240718e-04, 4, "5", -3},
  {2.8388026100251176394522190e+06, 15, "2838802610025117639452", 7},
  {8.1361028135596029642329086e+00, 9, "8136102814", 1},
  {9.3506617900483571595438015e-04, 17, "93506617900484", -3},
  {4.5338088592218410603578403e-06, 18, "4533808859222", -5},
  {4.4662799264394301146374744e-02, 7, "446628", -1},
  {7.1167006637549374615560327e-05, 17, "7116700663755", -4},
  {1.5805215355085242068265807e-15, 10, "", -10},
  {1.3842127856410161152000000e+19, 6, "13842127856410161152", 20},
  {9.1198027474162577096499011e-20, 4, "", -4},
  {2.3104116668067715067991230e+02, 17, "23104116668067715068", 3},
  {1.1192738149427091229881626e+03, 6, "1119273815", 4},
  {5.0604747527805442457600000e+20, 6, "506047475278054424576", 21},
  {2.0977193395043800174453683e-25, 11, "", -11},
  {1.5529765096845244443102274e+03, 1, "1553", 4},
  {1.0901631698612046419277766e-03, 10, "10901632", -2},
  {3.8082750966065407097725648e-05, 1, "", -1},
  {2.1156537013636816501041234e-13, 20, "21156537", -12},
  {1.5392731458393601431002885e-20, 4, "", -4},
  {6.2572839426167578125000000e+13, 9, "62572839426167578125", 14},
  {2.0895216699478804480000000e+18, 19, "2089521669947880448", 19},
  {5.8598238449318850040435791e+08, 2, "58598238449", 9},
  {4.0647258552134893750000000e+14, 14, "4064725855213489375", 15},
  {5.0228089810064837364748808e-14, 5, "", -5},
  {3.7668189039328754397217836e+00, 3, "3767", 1},
  {3.1523802974104171426006360e+00, 10, "31523802974", 1},
  {1.7102674481387472038562692e+00, 4, "17103", 1},
  {2.2094660790204076125653465e-03, 1, "", -1},
  {2.5745831727598175372388051e-18, 6, "", -6},
  {3.5509470956399905462036459e-04, 14, "35509470956", -3},
  {8.3508281824090882365779980e-24, 11, "", -11},
  {1.6751686221409597396850586e+10, 6, "16751686221409597", 11},
  {6.9848520302631013302848751e-08, 6, "", -6},
  {1.7743210423307046294212341e+07, 9, "17743210423307046", 8},
  {5.0538096726826534566980675e-23, 6, "", -6},
  {1.2892644109548018604982644e+05, 20, "12892644109548018604982644", 6},
  {4.4969373183540167519822717e+05, 14, "4496937318354016752", 6},
  {4.2532577140727152640000000e+19, 14, "4253257714072715264", 20},
  {7.5387830862313518001063933e-13, 2, "", -2},
  {1.6396622197812215000000000e+15, 15, "16396622197812215", 16},
  {4.2297895290555006025147844e-22, 9, "", -9},
  {7.7058003544887723401188850e+06, 5, "770580035449", 7},
  {1.2808851425024139235215876e-07, 3, "", -3},
  {3.5628450277932184371200000e+20, 17, "356284502779321843712", 21},
  {1.2894544621491708484290872e-06, 12, "1289454", -5},
  {6.3177265142141333314093453e-11, 18, "63177265", -10},
  {1.4382286658545410048000000e+19, 9, "14382286658545410048", 20},
  {2.4662982925547871130876914e-14, 4, "", -4},
  {8.9940831887733787500000000e+14, 18, "899408318877337875", 15},
  {8.9929364574093395940594230e-07, 16, "8992936457", -6},
  {6.7291543951269886578369950e-22, 19, "", -19},
  {4.6823375308642519221978838e-13, 14, "47", -12},
  {5.6373719956219370942562819e+04, 16, "563737199562193709426", 5},
  {5.4645014940231003508312995e-07, 11, "54645", -6},
  {2.8694724403511275239943899e-19, 12, "", -12},
  {5.8464871940000982318514722e-07, 20, "58464871940001", -6},
  {4.3925647194533447265625000e+12, 2, "439256471945334", 13},
  {5.6420277357079802362116821e-20, 12, "", -12},
  {1.8010508352159033545741788e-25, 2, "", -2},
  {3.9015418328065413788863225e+02, 2, "39015", 3},
  {1.4775295468220653643508254e-19, 0, "", 0},
  {1.3715439057658268000000000e+16, 4, "13715439057658268", 17},
  {1.6070563529621596000000000e+16, 1, "16070563529621596", 17},
  {6.9904293813400130375157460e+01, 6, "69904294", 2},
  {4.5041420040976805312667584e-10, 0, "", 0},
  {1.1391212863785983691675369e-21, 8, "", -8},
  {1.0410776149459430000000000e+15, 9, "1041077614945943", 16},
  {9.4900288628536499935250959e-02, 8, "9490029", -1},
  {4.8894835438564718750000000e+13, 3, "48894835438564719", 14},
  {4.8814287414670199155807495e+08, 6, "488142874146702", 9},
  {2.3106692576588564406847581e+04, 11, "2310669257658856", 5},
  {2.8585790824668048174138884e-14, 18, "28586", -13},
  {4.6485016085762853622436523e+09, 20, "464850160857628536224365234375", 10},
  {1.1538221833625118238427092e-18, 3, "", -3},
  {7.8068024747850675200000000e+17, 15, "780680247478506752", 18},
  {7.2781351792329759983007598e-15, 11, "", -11},
  {3.5421086797400397339075084e-01, 11, "35421086797", 0},
  {9.2614991574635144655237659e-16, 7, "", -7},
  {5.0508943214714050095803090e-17, 6, "", -6},
  {1.9874912881066632500000000e+15, 12, "198749128810666325", 16},
  {4.2481427821701129150390625e+11, 8, "4248142782170112915", 12},
  {5.6928249777225747704505920e+07, 12, "56928249777225747705", 8},
  {2.0653620964068792817402986e-03, 9, "2065362", -2},
  {1.1198972856304427235413146e-11, 4, "", -4},
  {1.5766049046184409179687500e+12, 19, "157660490461844091796875", 13},
  {8.2705631666871699218750000e+12, 7, "82705631666871699219", 13},
  {2.1932608456519869788436949e-01, 1, "2", 0},
  {2.8535976062715955200000000e+18, 8, "285359760627159552", 19},
  {1.3641116238585741769159906e-15, 5, "", -5},
  {9.3309963955688940448349225e-14, 19, "9331", -13},
  {7.3373098734616638183593750e+10, 17, "7337309873461663818359375", 11},
  {7.9616163167033228313716840e-08, 15, "79616163", -7},
  {3.1773209711407860814851841e-24, 16, "", -16},
  {1.6284773584091167819565271e+00, 16, "16284773584091168", 1},
  {4.1532770655897739257812500e+12, 7, "41532770655897739258", 13},
  {4.7276251772247187310690004e-08, 5, "", -5},
  {9.3058686719445304902365024e-01, 5, "93059", 0},
  {1.5104789266640873270553201e-14, 3, "", -3},
  {5.7293679551033984000000000e+16, 10, "57293679551033984", 17},
  {6.4033827165840335937500000e+13, 17, "640338271658403359375", 14},
  {2.8647919444957388179773261e+00, 19, "2864791944495738818", 1},
  {6.4705721607580471038818359e+08, 8, "64705721607580471", 9},
  {1.1186319831747548580169678e+09, 11, "111863198317475485802", 10},
  {6.3891638644960439282454523e-18, 2, "", -2},
  {4.4369242373901187193041551e+01, 17, "4436924237390118719", 2},
  {7.4736224239566150000000000e+14, 0, "747362242395662", 15},
  {3.3514325468216131584000000e+20, 8, "33514325468216131584", 21},
  {2.3925204370417223515663305e-20, 6, "", -6},
  {2.6518547242000594463408257e-17, 16, "", -16},
  {5.7947469799247424715187187e-25, 1, "", -1},
  {9.6929230236906837671995163e+06, 11, "969292302369068377", 7},
  {7.1546681232369680348420760e-04, 2, "", -2},
  {5.6228605010505686707906548e-08, 2, "", -2},
  {7.3553685711076060016466727e+00, 20, "735536857110760600165", 1},
  {1.8601070120965769092435949e+03, 20, "186010701209657690924359", 4},
  {4.5018904713183349370956421e+08, 18, "450189047131833493709564209", 9},
  {1.1995378084334013357470724e-09, 5, "", -5},
  {1.0611073921505371764339998e+00, 4, "10611", 1},
  {7.0564948209130043323966675e+03, 0, "7056", 4},
  {6.1550250167675757406726689e-01, 14, "61550250167676", 0},
  {1.6163028123383357888087630e+05, 2, "16163028", 6},
  {1.7602833327348701184000000e+19, 19, "17602833327348701184", 20},
  {2.5977936840321019639102214e-23, 6, "", -6},
  {3.7242734871353076636583211e-16, 8, "", -8},
  {5.3952223255602378731929253e-10, 6, "", -6},
  {1.1276285610027979687500000e+14, 15, "112762856100279796875", 15},
  {4.0071117772923070532442580e-01, 12, "400711177729", 0},
  {1.7925066484926694094063906e-12, 12, "2", -11},
  {1.9304008656479350491963487e+01, 3, "19304", 2},
  {1.2017946829080996096195122e+01, 1, "12", 2},
  {5.9610054362461732864000000e+19, 20, "59610054362461732864", 20},
  {5.5240576694699733858652336e-18, 11, "", -11},
  {2.6047250166179805669131385e-22, 3, "", -3},
  {2.1380073969647664979675695e-19, 1, "", -1},
  {6.8328743182776495814323425e+07, 8, "683287431827765", 8},
  {2.4616433080447582208000000e+20, 9, "24616433080447582208", 21},
  {6.0393479980253523535793647e+03, 19, "60393479980253523535794", 4},
  {1.2053002067505825310945511e+07, 6, "12053002067506", 8},
  {1.3565652580775054687500000e+14, 20, "135656525807750546875", 15},
  {2.8653988890639309528481497e-24, 16, "", -16},
  {5.3035417295227838464000000e+19, 3, "53035417295227838464", 20},
  {8.3027559313691257240050388e-17, 4, "", -4},
  {1.3632881680357863962704812e-01, 11, "1363288168", 0},
  {2.1709811150164100527763367e+08, 6, "217098111501641", 9},
  {4.0255397556925224559306096e-08, 6, "", -6},
  {4.4492090381816584103554068e-11, 6, "", -6},
  {7.6183981133502099609375000e+12, 12, "76183981133502099609375", 13},
  {2.7212565579504241943359375e+10, 19, "27212565579504241943359375", 11},
  {1.2133060707507019042968750e+11, 17, "1213306070750701904296875", 12},
  {5.2338437311717838848479367e-03, 18, "5233843731171784", -2},
  {2.7025780873566342052072287e+05, 12, "270257808735663421", 6},
  {5.4059239538068432578762394e-20, 12, "", -12},
  {3.0567295732818148020855419e-12, 3, "", -3},
  {4.3333607179898828337812002e-21, 10, "", -10},
  {1.2237258118616738816752942e-02, 8, "1223726", -1},
  {5.5245427334327094383292778e-06, 11, "552454", -5},
  {1.8347853614182216796875000e+12, 12, "18347853614182216796875", 13},
  {5.0668784240900938137600000e+20, 9, "506687842409009381376", 21},
  {1.4858612085577576160430908e+09, 9, "1485861208557757616", 10},
  {2.2296282988788464665412903e+08, 14, "22296282988788464665413", 9},
  {1.8831431916032364135415562e-10, 13, "1883", -9},
  {2.8568710584523721507030358e-04, 4, "3", -3},
  {1.3980099863772657812500000e+14, 5, "13980099863772657813", 15},
  {6.9334524903741879972072581e-24, 18, "", -18},
  {1.5678925769411210909012343e-15, 20, "156789", -14},
  {2.1677752293501055908203125e+11, 10, "216777522935010559082", 12},
  {6.5882511340352243323081893e+00, 0, "7", 1},
  {2.8383441382182735052800000e+20, 10, "283834413821827350528", 21},
  {3.2365563086752060000000000e+15, 1, "3236556308675206", 16},
  {1.3316784820808184627200000e+20, 3, "133167848208081846272", 21},
  {3.9373768492657213596830346e-03, 13, "39373768493", -2},
  {1.6342392116619748776429333e+01, 11, "1634239211662", 2},
  {1.9190227514749532800000000e+17, 2, "191902275147495328", 18},
  {3.6365468713277200232005301e-15, 2, "", -2},
  {3.5359464890446122725623126e-16, 14, "", -14},
  {2.9926478023326594666286837e+03, 9, "2992647802333", 4},
  {1.1242395667410307214595377e+05, 3, "112423957", 6},
  {1.1602698880086765882008182e-03, 11, "116026989", -2},
  {7.1004124655484116542903504e-16, 2, "", -2},
  {1.4430444718333755493164062e+11, 0, "144304447183", 12},
  {1.8128438954526182482900311e-25, 3, "", -3},
  {2.5845882868950979798388755e-25, 0, "", 0},
  {3.2167396954092273343020735e-21, 11, "", -11},
  {2.9651014850434432000000000e+16, 11, "29651014850434432", 17},
  {7.6792382500219041826248576e-14, 10, "", -10},
  {9.3446754587143059271186031e-19, 18, "1", -17},
  {6.4007598196826551331294930e-19, 0, "", 0},
  {2.2196248330543643416449159e-17, 2, "", -2},
  {1.1183437323583618319561099e-12, 0, "", 0},
  {2.8825840145233008808589552e-15, 18, "2883", -14},
  {3.5827003620318747033600000e+20, 19, "358270036203187470336", 21},
  {2.3167522418162688250219128e-04, 16, "2316752241816", -3},
  {3.7867349682170607736609818e-19, 6, "", -6},
  {4.4593196882743283200000000e+17, 18, "445931968827432832", 18},
  {3.4699563119087236000000000e+16, 1, "34699563119087236", 17},
  {8.9545369169657229671652261e-16, 19, "8955", -15},
  {2.6753724626386112000000000e+17, 2, "26753724626386112", 18},
  {2.1096947090921855000000000e+15, 20, "21096947090921855", 16},
  {1.0460431677003945515025407e+05, 3, "104604317", 6},
  {2.3153550247526320163160563e+04, 12, "2315355024752632", 5},
  {5.9863198957027496938110289e-01, 12, "59863198957", 0},
  {1.8539912815775475502014160e+09, 12, "1853991281577547550201", 10},
  {2.2407226183669510400000000e+17, 11, "224072261836695104", 18},
  {5.7298079129712239077009891e-14, 17, "573", -13},
  {4.8548035952653317208055204e-08, 16, "48548036", -7},
  {7.6838277156472312157120541e+00, 18, "7683827715647231216", 1},
  {2.1098451485930935084267546e-03, 14, "210984514859", -2},
  {1.6036844640263920640000000e+18, 10, "1603684464026392064", 19},
  {2.0635326809810427246093750e+12, 11, "206353268098104272460938", 13},
  {1.1159762866615188727122121e-04, 0, "", 0},
  {5.1280858364549714646447225e-08, 17, "5128085836", -7},
  {1.6013068715222778000000000e+16, 14, "16013068715222778", 17},
  {1.9964212768793382357657151e-01, 11, "19964212769", 0},
  {8.5073032946701963332141599e-07, 12, "85073", -6},
  {3.1548030376165658861253860e-02, 14, "3154803037617", -1},
  {1.6370580837084014487114128e-10, 19, "1637058084", -9},
  {2.3112873519047957088837164e-09, 6, "", -6},
  {3.2165974897769253840696832e-18, 11, "", -11},
  {2.3938838188585725000000000e+14, 13, "23938838188585725", 15},
  {1.2449132204070522000000000e+16, 19, "12449132204070522", 17},
  {1.0964000044871685645673270e-13, 7, "", -7},
  {1.4753684161164255745255114e-15, 10, "", -10},
  {4.4348141919593991877590611e-02, 5, "4435", -1},
  {1.2558640507326531174400000e+20, 13, "125586405073265311744", 21},
  {5.1119553048680839128792286e+05, 18, "511195530486808391287923", 6},
  {4.4150026023786637097146013e+01, 11, "4415002602379", 2},
  {2.8669700753060755406923140e-09, 19, "28669700753", -8},
  {3.9511600016431134700316689e-22, 0, "", 0},
  {8.1745949107950835200000000e+17, 12, "817459491079508352", 18},
  {6.1260515467195895325858146e+04, 18, "61260515467195895325858", 5},
  {8.2861449062947983845717204e-04, 12, "828614491", -3},
  {1.9276948471940897888998734e+00, 12, "1927694847194", 1},
  {1.8307022312615007500000000e+15, 7, "183070223126150075", 16},
  {1.6855545787292359087800683e-15, 4, "", -4},
  {5.1282812109303132946527902e-08, 17, "5128281211", -7},
  {2.9269294254959912500000000e+14, 1, "2926929425495991", 15},
  {2.2623998868934555214726342e-14, 12, "", -12},
  {4.2389656180227434086400000e+20, 3, "423896561802274340864", 21},
  {2.8221467781985123738953812e-15, 14, "", -14},
  {3.5935236281017396322567947e+03, 9, "3593523628102", 4},
  {3.1025875227403914032729692e-16, 16, "3", -15},
  {9.7884627275768775689357426e+02, 9, "978846272758", 3},
  {2.2549047250360149872314518e-11, 10, "", -10},
  {9.9760163985403593023186651e-10, 0, "", 0},
  {1.0504939371069406743314556e-22, 15, "", -15},
  {2.4282772480282466176504386e+02, 8, "2428277248", 3},
  {7.4379531161003205377558461e-22, 19, "", -19},
  {3.6222709512179558158570131e-12, 2, "", -2},
  {6.0114281125014383633242687e+02, 9, "60114281125", 3},
  {2.2889790624195962819293350e-15, 10, "", -10},
  {6.2605615746152614882936205e-12, 4, "", -4},
  {2.7240227153606347965631800e-19, 19, "3", -18},
  {8.2953735335257081314921379e+06, 17, "829537353352570813149214", 7},
  {6.3379583029751586914062500e+08, 4, "6337958302975", 9},
  {5.6159887352150911655858740e-10, 17, "56159887", -9},
  {1.1474609301742500377940814e+01, 5, "1147461", 2},
  {7.1415999369711530568756441e-05, 10, "71416", -4},
  {8.5361462360422591874598020e-04, 5, "85", -3},
  {2.9718002495758622828747608e-03, 13, "29718002496", -2},
  {6.9690026006732255859375000e+12, 14, "69690026006732255859375", 13},
  {2.6196584477789580658324553e-02, 1, "", -1},
  {5.0635193057916242187500000e+13, 20, "506351930579162421875", 14},
  {6.8402666473872446980559140e-24, 17, "", -17},
  {2.1154156855462363362312317e+08, 16, "2115415685546236336231232", 9},
  {7.6876111729681478242103866e-07, 14, "76876112", -6},
  {2.7478121006054426108057070e-14, 5, "", -5},
  {2.9686760827561789466422226e-02, 9, "29686761", -1},
  {3.0555304833098358427281459e-23, 3, "", -3},
  {3.9802490214592344273114577e+03, 19, "39802490214592344273115", 4},
  {6.4734689316685448193435836e-18, 20, "647", -17},
  {4.0886775774523516702174675e+03, 3, "4088678", 4},
  {1.3585182798487982080000000e+19, 0, "1358518279848798208", 20},
  {1.1483462018055014062500000e+14, 5, "11483462018055014063", 15},
  {3.8287913634360183715820312e+10, 11, "3828791363436018371582", 11},
  {5.6586736058607798579777712e-25, 15, "", -15},
  {1.3178589128660960495471954e+08, 7, "1317858912866096", 9},
  {1.4291408238498702950400000e+20, 17, "142914082384987029504", 21},
  {4.8343769595720372158601291e-13, 20, "4834377", -12},
  {1.5928427800841364516037997e-18, 15, "", -15},
  {4.1269855294106058352099353e+01, 18, "41269855294106058352", 2},
  {3.5270612675022834446281195e+05, 4, "3527061268", 6},
  {7.0386760523132095336914062e+10, 12, "70386760523132095336914", 11},
  {1.0025379338678106478783335e-19, 3, "", -3},
  {2.3275154456808381724884837e-16, 3, "", -3},
  {2.5308637106967071920590462e-12, 3, "", -3},
  {1.1524815309995094583794817e-03, 9, "1152482", -2},
  {1.0824657243432075015006733e-18, 15, "", -15},
  {1.0639419958331783376080016e-09, 14, "106394", -8},
  {6.6519861897003373929493364e-04, 18, "665198618970034", -3},
  {1.7474971045359221769898935e-16, 4, "", -4},
  {2.0506331395976972281323514e-12, 10, "", -10},
  {3.0464305733470399550899543e-02, 8, "3046431", -1},
  {2.6082265665625836354549770e-19, 3, "", -3},
  {1.8893601014827471226453781e+07, 3, "18893601015", 8},
  {2.1340857456765026304000000e+19, 4, "21340857456765026304", 20},
  {5.0906137038690845280921992e-23, 8, "", -8},
  {9.0888880439333952381275594e+04, 10, "90888880439334", 5},
  {2.1750015899267019089934174e-10, 5, "", -5},
  {4.2514542299643829464912415e+06, 1, "42514542", 7},
  {3.5600884254710576497018337e+06, 16, "35600884254710576497018", 7},
  {1.8972549177527838037349284e+05, 6, "189725491775", 6},
  {1.5297433067048593624548403e-01, 13, "1529743306705", 0},
  {1.0835398064237097278237343e+06, 19, "10835398064237097278237343", 7},
  {5.1711720216475632696528919e+03, 4, "5171172", 4},
  {1.1584843704352085113525391e+10, 11, "1158484370435208511353", 11},
  {3.9119610915777529256333091e-10, 12, "391", -9},
  {1.8401256011834732436870023e-06, 18, "1840125601183", -5},
  {5.0783843249776918196071554e-11, 2, "", -2},
  {1.5239219432668133544921875e+11, 20, "15239219432668133544921875", 12},
  {5.1545400651677346217766870e-11, 9, "", -9},
  {3.3595919880019125053237889e-09, 14, "335959", -8},
  {6.0686271754825310335330126e-19, 5, "", -5},
  {4.0596529528376621093750000e+12, 2, "405965295283766", 13},
  {1.7554784181992092635482550e+05, 9, "175547841819921", 6},
  {1.1527700511520632320000000e+18, 2, "1152770051152063232", 19},
  {6.1799113112800219083427676e-14, 9, "", -9},
  {1.7867183744319513789378107e+05, 18, "178671837443195137893781", 6},
  {2.5799768609590033057938566e-23, 10, "", -10},
  {5.4975644567263020690006670e+02, 2, "54976", 3},
  {1.7389009919271632896000000e+20, 7, "17389009919271632896", 21},
  {4.5012911677909733256251130e-15, 18, "4501", -14},
  {1.3462575418912686550645209e-11, 1, "", -1},
  {9.0220711553893443247096798e-10, 19, "9022071155", -9},
  {1.3880981126460427856445312e+11, 12, "138809811264604278564453", 12},
  {7.7904623834681114624000000e+19, 10, "77904623834681114624", 20},
  {9.8138447196188938193017748e-01, 13, "9813844719619", 0},
  {6.7121242415261140809579210e-03, 19, "67121242415261141", -2},
  {2.1017565684412287038279260e-23, 19, "", -19},
  {7.8120563379376620000000000e+15, 5, "7812056337937662", 16},
  {1.1111945053722836026426166e-06, 3, "", -3},
  {8.7906996577169721991075315e-13, 14, "88", -12},
  {1.2475936056320569012001442e-01, 14, "12475936056321", 0},
  {4.6175576461252819626679411e+02, 12, "461755764612528", 3},
  {2.8207342344304429503639873e-11, 18, "28207342", -10},
  {4.1233131844771056000000000e+16, 15, "41233131844771056", 17},
  {3.7662935224789111072642004e-08, 6, "", -6},
  {1.2408623177839521924040873e-11, 13, "124", -10},
  {6.4343026702923476725452094e-17, 8, "", -8},
  {2.0409947337157114257812500e+12, 9, "2040994733715711425781", 13},
  {3.1923105037674690135497522e-23, 8, "", -8},
  {2.1701982362912580984552200e-23, 11, "", -11},
  {2.1096785697573138432000000e+19, 20, "21096785697573138432", 20},
  {6.9110251987735654400000000e+17, 5, "691102519877356544", 18},
  {3.2730145245695821124318311e-24, 19, "", -19},
  {5.5416676906145057728281245e+03, 14, "554166769061450577", 4},
  {1.7150625327370722425892116e-05, 12, "17150625", -4},
  {1.9982915284772112445177826e-14, 18, "19983", -13},
  {3.3409607037916129002041998e+02, 19, "3340960703791612900204", 3},
  {1.5662634825286891930602448e-15, 17, "157", -14},
  {1.8109877665064022342040060e-19, 18, "", -18},
  {1.2825337033272974202776267e-18, 10, "", -10},
  {8.9901091052661233717201339e-10, 20, "89901091053", -9},
  {4.8999226735579859206343886e-18, 16, "", -16},
  {8.3521635559226621952000000e+19, 9, "83521635559226621952", 20},
  {1.1238133912328951565743479e-04, 9, "112381", -3},
  {4.4764968983032554388046265e+08, 10, "4476496898303255439", 9},
  {4.3368781215046024934057997e-18, 14, "", -14},
  {2.8252019304140589971997453e-22, 14, "", -14},
  {1.4886513969231297509290044e-14, 18, "14887", -13},
  {5.1712931996786953629599198e-12, 0, "", 0},
  {6.6832528573922132144103151e-22, 6, "", -6},
  {1.8408894975227190431183359e-22, 6, "", -6},
  {6.5688889081019783101160156e-18, 13, "", -13},
  {5.4053786473339475916261263e-18, 11, "", -11},
  {1.7533830849719560845444378e-09, 16, "17533831", -8},
  {3.5747692032513823006537373e-13, 8, "", -8},
  {1.9607042618728543166071177e+06, 0, "1960704", 7},
  {1.8773986990415155590161689e-02, 10, "18773987", -1},
  {1.5648873852568648706536998e-22, 11, "", -11},
  {8.3868342369859764183845809e-24, 11, "", -11},
  {2.2839406028942328943387316e-08, 8, "2", -7},
  {2.3680528804721855558454990e+06, 19, "2368052880472185555845499", 7},
  {1.4163397995776424068026245e+04, 13, "141633979957764241", 5},
  {6.7741190557826863613233057e-09, 17, "677411906", -8},
  {1.3010528751278982812500000e+14, 20, "130105287512789828125", 15},
  {7.5247895319895446300506592e+07, 6, "75247895319895", 8},
  {3.8994526632715616710462278e-24, 13, "", -13},
  {3.6382243175042826240000000e+18, 0, "3638224317504282624", 19},
  {2.0767102107141718750000000e+12, 9, "2076710210714171875", 13},
  {1.6934334278419246498247443e-09, 16, "16934334", -8},
  {9.9404173464894337500000000e+14, 0, "994041734648943", 15},
  {8.3459682991739748558757128e+02, 13, "8345968299173975", 3},
  {6.0030690361011123623080777e-14, 13, "1", -12},
  {4.7396082367499232945208532e-05, 6, "47", -4},
  {9.0844410463656970478041330e+00, 16, "9084441046365697", 1},
  {4.6090063897216354502016173e-17, 8, "", -8},
  {2.5103448034671276613847071e-05, 0, "", 0},
  {9.7804836825438295955350148e-21, 0, "", 0},
  {4.7433508094488229835405946e+05, 4, "4743350809", 6},
  {6.0031404516809469861902080e-12, 4, "", -4},
  {1.1763501387585452198982239e+08, 4, "1176350138759", 9},
  {1.4996970882285186089575291e+06, 5, "149969708823", 7},
  {6.1104644056802152000000000e+16, 19, "61104644056802152", 17},
  {8.2965942592229593316194985e-06, 0, "", 0},
  {1.5405954780349361448100511e-25, 19, "", -19},
  {1.5411324703137612342834473e+09, 9, "1541132470313761234", 10},
  {1.3922655867104754687500000e+14, 8, "139226558671047546875", 15},
  {2.9851973037962132098699364e-03, 19, "29851973037962132", -2},
  {8.2822456638993879040000000e+18, 14, "8282245663899387904", 19},
  {3.9199128194825666560000000e+19, 7, "3919912819482566656", 20},
  {8.7648647007398200000000000e+15, 6, "876486470073982", 16},
  {2.0692144212883775294615934e-18, 18, "2", -17},
  {3.2640760119338369369506836e+09, 0, "3264076012", 10},
  {4.8381898568187707596850225e-22, 17, "", -17},
  {2.5720154791795420123889926e+02, 19, "2572015479179542012389", 3},
  {1.2094320558896013788316034e-20, 9, "", -9},
  {7.9555466566078165827581353e-10, 13, "7956", -9},
  {6.1136899767684544713119976e+03, 7, "61136899768", 4},
  {4.9072718543380151601240868e+00, 11, "490727185434", 1},
  {7.5804042231796896085143089e+06, 14, "758040422317968960851", 7},
  {3.2878020714788905991106526e-23, 9, "", -9},
  {2.0159940009154248785257771e-09, 9, "2", -8},
  {2.0968493980632240000000000e+15, 13, "2096849398063224", 16},
  {1.6707207405216276514385116e-14, 1, "", -1},
  {1.0929179834562842187149333e-06, 8, "109", -5},
  {4.2301894531547510996460915e+05, 15, "423018945315475109965", 6},
  {1.7768949092194767232503184e-09, 10, "18", -8},
  {2.2760230008690759555723954e-09, 1, "", -1},
  {2.4184631128558831735161175e-19, 8, "", -8},
  {5.1315465627372420000000000e+15, 13, "5131546562737242", 16},
  {1.8306491446718669612891972e+05, 16, "1830649144671866961289", 6},
  {7.7713929055648235287919360e-10, 10, "8", -9},
  {1.8878090228812993084595495e-06, 2, "", -2},
  {9.3201550910294164089214689e-24, 7, "", -7},
  {2.7350145782227928137331219e+00, 7, "27350146", 1},
  {7.1300189359439435065723956e+04, 12, "71300189359439435", 5},
  {2.9105980395629891500331884e-11, 10, "", -10},
  {3.1551286715856798960525180e-14, 18, "31551", -13},
  {5.2655314358497280409210362e+03, 18, "5265531435849728040921", 4},
  {3.6157203010894021741502637e-18, 13, "", -13},
  {5.0266256869194919580849879e-08, 2, "", -2},
  {2.3015503642409821701202692e-18, 1, "", -1},
  {5.7690536321983595592673459e-12, 8, "", -8},
  {3.9853372248271618616399792e+01, 20, "398533722482716186164", 2},
  {1.5429918247322820246125730e+00, 1, "15", 1},
  {1.8385952379170927883933473e+02, 12, "183859523791709", 3},
  {2.4110131851649202406406403e+07, 6, "24110131851649", 8},
  {5.9858617792740999362713047e-16, 11, "", -11},
  {5.0642303212785931707582534e-22, 19, "", -19},
  {2.4128839652351062774658203e+10, 16, "241288396523510627746582031", 11},
  {1.1526716796271675109863281e+11, 6, "115267167962716751", 12},
  {2.9650608064238612480000000e+18, 20, "2965060806423861248", 19},
  {2.2396230641667078109513511e-01, 15, "223962306416671", 0},
  {2.9247297416229503630938298e-25, 7, "", -7},
  {1.0171114445711473600000000e+17, 20, "101711144457114736", 18},
  {4.3304775357952534402504374e-18, 9, "", -9},
  {2.3135455187866718915756792e+03, 4, "23135455", 4},
  {1.2093253332348833373967227e-24, 12, "", -12},
  {8.2477743744818019866943359e+08, 11, "82477743744818019867", 9},
  {6.2541938919947051545022987e+02, 10, "6254193891995", 3},
  {7.8031641296067305935242037e-13, 18, "780316", -12},
  {5.9248890412273481984596597e-13, 6, "", -6},
  {1.0973355878742670413585755e-12, 0, "", 0},
  {2.3191061690721083984375000e+12, 13, "23191061690721083984375", 13},
  {1.6264958971601835013842674e+00, 2, "163", 1},
  {2.9075272801645708084106445e+08, 7, "2907527280164571", 9},
  {7.0697155117986665118223755e+02, 11, "70697155117987", 3},
  {2.5158097761335946230060917e-23, 0, "", 0},
  {1.5344899973813182115554810e+08, 0, "153449", 9},
  {1.9129071720315366216808527e-23, 16, "", -16},
  {6.3767798697633784000000000e+16, 10, "63767798697633784", 17},
  {2.5523441402685988271948755e-13, 6, "", -6},
  {1.3444034610689980399638875e-22, 15, "", -15},
  {9.1687530503063852105327669e-01, 18, "916875305030638521", 0},
  {5.4432587671916263012733734e-08, 0, "", 0},
  {5.7976446384694224486400000e+20, 3, "579764463846942244864", 21},
  {7.2766969702266395092010498e+08, 12, "72766969702266395092", 9},
  {9.4021856488334448242187500e+11, 10, "9402185648833444824219", 12},
  {5.0690680602031538990922573e-23, 15, "", -15},
  {3.9363317644431610631272633e+01, 9, "39363317644", 2},
  {2.0787460049457229329813553e-14, 6, "", -6},
  {4.5252762668144090878122732e-20, 4, "", -4},
  {1.2095680804390394687652588e+08, 7, "1209568080439039", 9},
  {1.6532554894580285030590094e-11, 3, "", -3},
  {1.5132513886741307377815247e+08, 18, "151325138867413073778152466", 9},
  {1.9347077744811971931199190e-03, 10, "19347078", -2},
  {1.0900379758353357209600000e+20, 15, "109003797583533572096", 21},
  {6.5090515605046582031250000e+12, 10, "6509051560504658203125", 13},
  {1.7884973728166893124580383e+07, 8, "1788497372816689", 8},
  {3.2351404568942100524902344e+10, 5, "323514045689421", 11},
  {7.7012312793779802322387695e+09, 11, "770123127937798023224", 10},
  {2.9348638848261886231096072e-23, 14, "", -14},
  {4.2918903460222106745343781e-25, 10, "", -10},
  {4.0910080244297020168886547e-01, 3, "409", 0},
  {5.1470968588533623915282078e+03, 20, "514709685885336239152821", 4},
  {8.8386730213350740768644964e-05, 1, "", -1},
  {4.0451668951332756841800356e-22, 11, "", -11},
  {5.1011722469729779052734375e+11, 19, "51011722469729779052734375", 12},
  {1.5714611640715193750000000e+14, 11, "1571461164071519375", 15},
  {3.3360113252784008678301406e-23, 13, "", -13},
  {5.6400029546965812683105469e+10, 14, "5640002954696581268310547", 11},
  {2.1290134842449540212925595e-19, 0, "", 0},
  {1.4485583793331175424000000e+20, 1, "14485583793331175424", 21},
  {3.7915286641022221374441870e+03, 6, "3791528664", 4},
  {1.5166444005281136640000000e+20, 11, "1516644400528113664", 21},
  {2.3186546301170730544072285e+02, 1, "2319", 3},
  {1.1418214579772582556949590e-24, 5, "", -5},
  {1.3334968159011762589216232e+07, 11, "1333496815901176259", 8},
  {2.7347651709167068774400000e+20, 7, "273476517091670687744", 21},
  {5.7844798548791382927447557e+05, 9, "578447985487914", 6},
  {4.2181864862747107545928177e-05, 7, "422", -4},
  {3.6241949974860545207144713e-13, 13, "4", -12},
  {9.0768879803691840000000000e+15, 1, "9076887980369184", 16},
  {4.4054131687729936039943368e-01, 1, "4", 0},
  {1.3008881204512643481600000e+20, 20, "130088812045126434816", 21},
  {1.9867179659996537565428764e-20, 11, "", -11},
  {1.2495596028918804165641632e+02, 14, "12495596028918804", 3},
  {1.8901989025044440000000000e+16, 14, "1890198902504444", 17},
  {8.0539823964998155917559134e-19, 16, "", -16},
  {1.0467850482914892578125000e+13, 2, "1046785048291489", 14},
  {8.8165542718000922089714501e-22, 12, "", -12},
  {6.3324396205030986095607659e-01, 8, "63324396", 0},
  {4.1881970865123851291944462e-19, 20, "42", -18},
  {1.2087792221374403815389864e-04, 4, "1", -3},
  {1.2320731099253312878364786e-18, 12, "", -12},
  {3.7069600006951980351834460e-17, 15, "", -15},
  {2.0910878022660535002995006e-17, 7, "", -7},
  {3.6030148272073993177735257e-05, 3, "", -3},
  {2.0407546770712835788726807e+09, 4, "20407546770713", 10},
  {1.3356922702982762518608695e-01, 9, "133569227", 0},
  {6.1959614894048092992306920e+02, 11, "61959614894048", 3},
  {2.6724482336174748906939042e-18, 14, "", -14},
  {1.7529800658735210897466817e-10, 6, "", -6},
  {1.8884333876331582031250000e+12, 12, "1888433387633158203125", 13},
  {6.0477654593505627724390196e-14, 2, "", -2},
  {9.9211792252581765120000000e+18, 7, "9921179225258176512", 19},
  {1.2761006505453401007471603e-03, 7, "12761", -2},
  {8.4410932659352147311437875e+03, 1, "84411", 4},
  {1.6344678000716391804997502e-10, 16, "1634468", -9},
  {2.7509377880776102465176791e+00, 11, "275093778808", 1},
  {3.3060075458601665256941827e-22, 3, "", -3},
  {7.2972869209961812513411199e-17, 1, "", -1},
  {2.2007353546928432605280763e-21, 9, "", -9},
  {3.6081863178757269633933902e+05, 2, "36081863", 6},
  {1.0606753028891187113913475e+03, 11, "106067530288912", 4},
  {4.8197957520340783521533012e+06, 12, "4819795752034078352", 7},
  {8.8801445717858058988629262e-15, 12, "", -12},
  {1.6169742107938478437034746e-01, 13, "1616974210794", 0},
  {1.3810242946127669885754585e+07, 15, "13810242946127669885755", 8},
  {5.8263791197455061521282005e-02, 9, "58263791", -1},
  {7.3108024087969464320000000e+18, 0, "7310802408796946432", 19},
  {1.4368692944577606038264133e-10, 20, "14368692945", -9},
  {1.4889764443500566855912242e-23, 4, "", -4},
  {7.0042322566352364988690078e-07, 4, "", -4},
  {9.4164764535194269915731451e-24, 15, "", -15},
  {3.9108228803235329429837002e-20, 3, "", -3},
  {2.0477878248797751203902351e-02, 0, "", 0},
  {1.6711597836468450546264648e+10, 10, "167115978364684505463", 11},
  {9.5590509968633647076785564e+04, 17, "9559050996863364707679", 5},
  {1.0755193299938018753891811e+04, 2, "1075519", 5},
  {3.7655843136607830368524462e-09, 9, "4", -8},
  {5.1504979517734435073519085e-09, 2, "", -2},
  {1.1362171071511921907213393e-20, 8, "", -8},
  {2.8196606638832783360000000e+18, 7, "2819660663883278336", 19},
  {6.1007119976687438964843750e+10, 3, "61007119976687", 11},
  {4.2259486954762655603289053e-22, 10, "", -10},
  {1.0352905072881138073600000e+20, 2, "103529050728811380736", 21},
  {2.4667640086764881014823914e+08, 16, "2466764008676488101482391", 9},
  {1.0065004335275751145672984e+04, 3, "10065004", 5},
  {8.0323839629546612498695035e-04, 19, "8032383962954661", -3},
  {2.0209151666941322326660156e+10, 17, "2020915166694132232666015625", 11},
  {3.3256138489805489727516571e-12, 19, "33256138", -11},
  {9.4640238145430564275961695e-25, 10, "", -10},
  {7.1122933075537218750000000e+13, 9, "7112293307553721875", 14},
  {3.5416842045630118750000000e+14, 13, "3541684204563011875", 15},
  {7.0205355150201171636581421e+06, 12, "7020535515020117164", 7},
  {6.7563793465238460339605808e+05, 0, "675638", 6},
  {1.7930236626596591415762035e-07, 3, "", -3},
  {1.1355873128682003906850251e-04, 3, "", -3},
  {1.3164191159903992911495152e+00, 20, "131641911599039929115", 1},
  {1.7585999620085597487972328e-16, 15, "", -15},
  {7.2379682453526433865463337e-20, 6, "", -6},
  {5.4165711175644095105831575e-18, 5, "", -5},
  {6.6782995109479594975709915e+06, 15, "6678299510947959497571", 7},
  {2.6099058263522555405761194e-04, 8, "26099", -3},
  {1.9691800837629337752009296e-25, 4, "", -4},
  {9.2242247640378579497337341e+07, 13, "922422476403785794973", 8},
  {7.7786194558008036914362139e-07, 12, "777862", -6},
  {1.0154047453595022583007812e+11, 15, "101540474535950225830078125", 12},
  {3.2203897410888429168141209e-15, 3, "", -3},
  {1.7590337995379858398437500e+11, 15, "175903379953798583984375", 12},
  {1.1796002943341540625000000e+14, 8, "11796002943341540625", 15},
  {7.2909505964716150562507146e-16, 12, "", -12},
  {9.2080837542416230400000000e+18, 2, "920808375424162304", 19},
  {1.2950538046241865231422707e+04, 14, "1295053804624186523", 5},
  {1.8345695045918173006133600e-17, 14, "", -14},
  {6.0597471744165709063578706e-04, 20, "60597471744165709", -3},
  {2.3013479524387767910957336e+08, 4, "2301347952439", 9},
  {1.1654472753701808684922980e+01, 3, "11654", 2},
  {4.0197110845260654059529770e+03, 1, "40197", 4},
  {1.7356237817776408276226885e-03, 11, "173562378", -2},
  {9.5639377451524055040000000e+18, 3, "9563937745152405504", 19},
  {3.7320949859158952000000000e+16, 6, "37320949859158952", 17},
  {7.8598172902416075878055616e-24, 1, "", -1},
  {2.4003659072990006469573838e-23, 13, "", -13},
  {4.5661181775404195785522461e+09, 10, "45661181775404195786", 10},
  {4.5649112989476539683533000e-23, 2, "", -2},
  {9.5880660105561779850002141e-22, 2, "", -2},
  {7.7347376903149242934887297e+03, 14, "773473769031492429", 4},
  {2.2150184175133483886718750e+11, 12, "221501841751334838867188", 12},
  {1.4073018133214882795615913e-22, 7, "", -7},
  {1.0694370528699487304687500e+12, 6, "106943705286994873", 13},
  {6.3703219843083620071411133e+09, 2, "637032198431", 10},
  {4.0496259140303246676921844e+06, 7, "40496259140303", 7},
  {3.3770532521957279059615275e-13, 17, "33771", -12},
  {7.7215931060278526487650197e+00, 6, "7721593", 1},
  {5.6503646480313027495867573e+03, 1, "56504", 4},
  {1.9861171806170235073078947e-18, 10, "", -10},
  {1.6719673512274586483904389e-14, 14, "2", -13},
  {1.0907912733613704040180892e+05, 4, "1090791273", 6},
  {6.7803273190190904966961893e-04, 15, "678032731902", -3},
  {1.8024393800629112500000000e+14, 1, "1802439380062911", 15},
  {7.1351631947615683078765869e+08, 7, "7135163194761568", 9},
  {2.0913705591180495769066533e-05, 7, "209", -4},
  {1.0186460525534383851631315e-03, 13, "10186460526", -2},
  {1.7032057269404947757720947e+07, 8, "1703205726940495", 8},
  {7.1628792658466080000000000e+16, 12, "7162879265846608", 17},
  {6.1270025882251086425781250e+11, 6, "612700258822510864", 12},
  {4.3301326987132418196965099e-09, 13, "43301", -8},
  {3.2523075207463336514468874e-15, 6, "", -6},
  {6.4048014709991007292755327e-04, 3, "1", -2},
  {4.0022616586648611658461050e+00, 19, "40022616586648611658", 1},
  {1.8456224383924731116735162e-12, 0, "", 0},
  {1.1665721517950447616000000e+19, 18, "11665721517950447616", 20},
  {9.6706950702710251789540052e+04, 9, "9670695070271", 5},
  {1.3308593111809293775028851e-04, 4, "1", -3},
  {6.6801841876599912643432617e+09, 5, "668018418765999", 10},
  {2.1437213820286331156239612e+02, 5, "21437214", 3},
  {1.4840916402877211616283484e-15, 3, "", -3},
  {1.6331723285425789654254913e+07, 18, "16331723285425789654254913", 8},
  {6.1789968684903583296099629e-20, 7, "", -7},
  {5.2112194765587109941407107e+03, 16, "52112194765587109941", 4},
  {4.4150887868455136718750000e+12, 17, "4415088786845513671875", 13},
  {4.5120044109045538330078125e+11, 8, "4512004410904553833", 12},
  {9.2376948944863093470095299e-17, 5, "", -5},
  {8.1351998533587746816000000e+19, 4, "81351998533587746816", 20},
  {8.0115095632037757228252707e-16, 7, "", -7},
  {5.0968776949694536426704872e+01, 13, "509687769496945", 2},
  {1.4135372206255070061104971e-22, 18, "", -18},
  {3.4378976048768120117187500e+12, 2, "343789760487681", 13},
  {2.3488415978771053005402791e+02, 14, "23488415978771053", 3},
  {1.3214093236240899984089548e-13, 5, "", -5},
  {3.6847587833340070000000000e+15, 16, "3684758783334007", 16},
  {5.1822440105886646843913468e-01, 16, "5182244010588665", 0},
  {1.2119742957697342000000000e+16, 0, "12119742957697342", 17},
  {5.3456449303178374066192191e+02, 2, "53456", 3},
  {5.1785285276046273135015842e-25, 12, "", -12},
  {9.9008537866941048743996134e-01, 16, "9900853786694105", 0},
  {3.6458479195065245440088297e-03, 12, "364584792", -2},
  {7.8948121921424496173858643e+08, 8, "78948121921424496", 9},
  {5.0795870438881723029581755e-05, 11, "5079587", -4},
  {2.5396285802879293826879140e-19, 6, "", -6},
  {1.6402768886488065835103640e-20, 9, "", -9},
  {7.9624385550777063602807815e-05, 19, "796243855507771", -4},
  {2.9068666265744631971301715e+01, 2, "2907", 2},
  {4.7230830831075180656398281e-09, 10, "47", -8},
  {4.8261986200718865490431973e-07, 15, "482619862", -6},
  {8.1644711394197456684196368e+03, 12, "8164471139419746", 4},
  {1.9037678324653802690743414e-18, 13, "", -13},
  {6.8803562284198528000000000e+16, 15, "68803562284198528", 17},
  {9.5138978668254687500000000e+13, 17, "951389786682546875", 14},
  {7.1560165984352862040412946e-04, 7, "7156", -3},
  {4.1098030956002276070648804e+01, 1, "411", 2},
  {6.3422897546637031250000000e+12, 7, "6342289754663703125", 13},
  {1.8355101384719513802741984e-10, 7, "", -7},
  {2.0552228621574968334529445e-25, 4, "", -4},
  {4.9534987917689099546868350e-08, 1, "", -1},
  {5.2725244732625378674129024e+02, 0, "527", 3},
  {1.9816500570584681676800000e+20, 13, "198165005705846816768", 21},
  {9.5942194480766384000000000e+16, 3, "95942194480766384", 17},
  {1.5266609123368765625000000e+13, 10, "15266609123368765625", 14},
  {3.4277816789221429871759028e+02, 3, "342778", 3},
  {2.5056123804039463256181770e-12, 19, "25056124", -11},
  {3.8954719552428015616000000e+19, 5, "38954719552428015616", 20},
  {1.4618553464731080499579480e-20, 19, "", -19},
  {3.1341032263292856185898927e-01, 15, "313410322632929", 0},
  {2.6894240257970532000000000e+16, 6, "26894240257970532", 17},
  {1.4964472238711828012275307e-03, 7, "14964", -2},
  {5.3647702687086792024708626e-08, 19, "536477026871", -7},
  {5.1252520333580154146546626e-04, 16, "5125252033358", -3},
  {3.0699675106980691504575913e-16, 3, "", -3},
  {2.5103787715926501201745816e-17, 18, "25", -16},
  {7.2468788595245273600000000e+17, 15, "724687885952452736", 18},
  {1.5513480378903249740600586e+10, 6, "1551348037890325", 11},
  {4.3672722434282761241775006e+04, 7, "436727224343", 5},
  {1.7190861544703231502185428e-23, 8, "", -8},
  {6.8635529248233984000000000e+18, 15, "68635529248233984", 19},
  {7.2002999969361282348632812e+10, 13, "720029999693612823486328", 11},
  {9.3887468845344227800142025e-13, 0, "", 0},
  {5.4477812185432039424000000e+19, 1, "54477812185432039424", 20},
  {7.2962558185144046406585687e-16, 16, "7", -15},
  {2.7389302503208021177805165e-02, 18, "27389302503208021", -1},
  {1.5645340263416388682405234e-07, 6, "", -6},
  {8.0692311454064973344476335e-19, 9, "", -9},
  {1.6045531527467994019389153e+07, 12, "16045531527467994019", 8},
  {2.0710348317371836402501960e-24, 14, "", -14},
  {2.8237002674505699375939810e-20, 16, "", -16},
  {1.0521022091878352165222168e+09, 0, "1052102209", 10},
  {4.0430272290150648098829578e-15, 17, "404", -14},
  {3.2448489739871078400000000e+17, 7, "324484897398710784", 18},
  {2.8987240439412736802481967e-22, 5, "", -5},
  {1.8463508875654069046928550e-13, 13, "2", -12},
  {1.5194775687976503372192383e+08, 12, "151947756879765033722", 9},
  {6.5851440428630275000000000e+14, 18, "65851440428630275", 15},
  {1.0944401636178081871353385e-01, 0, "", 0},
  {2.0645619078815037355315043e-07, 12, "206456", -6},
  {4.5787003113953329955145705e-06, 13, "45787003", -5},
  {3.6634960289792088614069202e-22, 1, "", -1},
  {3.5764754076637373762464417e-16, 18, "358", -15},
  {3.3694849445806451618026349e-13, 11, "", -11},
  {4.8014388270805273473403307e-16, 15, "", -15},
  {1.1308954191030207679646846e-03, 16, "1130895419103", -2},
  {7.9448778774098716831675304e-03, 2, "1", -1},
  {1.1672274543609254840686722e-23, 20, "", -20},
  {7.7896430949322548838400000e+20, 16, "778964309493225488384", 21},
  {7.8579487249277762739338044e-11, 18, "78579487", -10},
  {1.0307994260133783448463163e-01, 5, "10308", 0},
  {9.1169030163860940529407028e-10, 8, "", -8},
  {7.2625475148736552960000000e+18, 14, "7262547514873655296", 19},
  {4.6750800213498209891341793e-08, 5, "", -5},
  {4.9583553818114599707531501e-14, 3, "", -3},
  {2.1196860294013131920110027e+02, 13, "2119686029401313", 3},
  {7.6760821725717349648767403e-23, 16, "", -16},
  {1.0987170573303682804107666e+09, 10, "10987170573303682804", 10},
  {1.0536684493432214000000000e+16, 5, "10536684493432214", 17},
  {1.6771583538741094000000000e+16, 15, "16771583538741094", 17},
  {1.1704441782449018210172653e+07, 0, "11704442", 8},
  {1.9396986431632745079696178e+06, 8, "193969864316327", 7},
  {2.0065600583069896697998047e+09, 17, "200656005830698966979980469", 10},
  {2.1283064967879846875000000e+14, 9, "21283064967879846875", 15},
  {7.2889704363328276480000000e+18, 7, "7288970436332827648", 19},
  {1.1088040410704603681940141e-09, 3, "", -3},
  {7.1329871144619691645848223e-08, 14, "7132987", -7},
  {3.7706356910209089983254671e+05, 9, "377063569102091", 6},
  {1.7806187360948021701501087e-03, 19, "17806187360948022", -2},
  {7.5740399430179250000000000e+13, 11, "7574039943017925", 14},
  {9.6012963128062824447878087e-04, 19, "9601296312806282", -3},
  {2.1002811118091241242633997e-08, 17, "2100281112", -7},
  {7.7611301631975420506348584e-03, 18, "7761130163197542", -2},
  {3.7652198227642777600000000e+20, 0, "376521982276427776", 21},
  {4.2466520730411523254588246e+05, 2, "42466521", 6},
  {5.1042753379053678956006591e-20, 12, "", -12},
  {3.1373182765339335000000000e+15, 16, "31373182765339335", 16},
  {1.3684695787935041266791814e+02, 17, "13684695787935041267", 3},
  {6.0140397802084489490420660e-04, 7, "6014", -3},
  {8.5146003010776951566180206e-21, 3, "", -3},
  {1.1280284614101147200000000e+17, 16, "112802846141011472", 18},
  {4.3662398993299002540879883e+03, 10, "43662398993299", 4},
  {1.2495453648227487519761780e+02, 10, "1249545364823", 3},
  {8.8002358546697260523183903e-04, 2, "", -2},
  {3.3124762244029461669921875e+11, 2, "33124762244029", 12},
  {1.1004627808993163520000000e+18, 12, "1100462780899316352", 19},
  {4.1511598626803603906409990e+01, 16, "415115986268036039", 2},
  {3.0781280392841913271695375e+05, 12, "307812803928419133", 6},
  {9.9591208590378210245066467e-17, 17, "1", -15},
  {3.8796506526817974680020504e-20, 11, "", -11},
  {3.0603622716445397600182332e+03, 12, "306036227164454", 4},
  {9.8134213668205548385819765e-07, 11, "98134", -6},
  {2.0358008801537392199566103e-21, 12, "", -12},
  {5.4732624900531678946435932e+00, 15, "5473262490053168", 1},
  {5.3050910394572929382324219e+10, 18, "5305091039457292938232421875", 11},
  {1.5632928271492087808000000e+19, 13, "15632928271492087808", 20},
  {6.3768870867916965794464090e-03, 5, "638", -2},
  {2.3094256966103356331586838e+07, 7, "230942569661034", 8},
  {5.8053746912239961186675486e-19, 0, "", 0},
  {5.8926893277970931200000000e+17, 18, "589268932779709312", 18},
  {6.4434324371418396136022609e-14, 18, "64434", -13},
  {3.2911035016900622997743654e-21, 6, "", -6},
  {1.9316439025749533276050690e-16, 2, "", -2},
  {1.0692294786289331054687500e+12, 3, "1069229478628933", 13},
  {1.9534715010760842976433871e-04, 13, "1953471501", -3},
  {6.2089306133628784078070114e-24, 2, "", -2},
  {1.0246263867985315812458857e-02, 9, "10246264", -1},
  {7.7673172344460770000000000e+15, 19, "7767317234446077", 16},
  {8.4207171234126433431012186e-21, 16, "", -16},
  {2.3855861532593282313145286e-12, 5, "", -5},
  {1.5806129258991408960994952e-20, 12, "", -12},
  {3.9573903158932990466993124e-21, 4, "", -4},
  {1.4564545393651786000000000e+16, 5, "14564545393651786", 17},
  {2.6441133120183843750000000e+14, 19, "2644113312018384375", 15},
  {5.9507908317059622599221580e-10, 15, "595079", -9},
  {5.3496839210085980198527977e+00, 20, "534968392100859801985", 1},
  {2.1665427864651860000000000e+16, 17, "2166542786465186", 17},
  {2.2508449936416921764949490e-23, 5, "", -5},
  {6.1540902919935762882232666e+07, 16, "615409029199357628822327", 8},
  {6.5541117624650268554687500e+11, 0, "655411176247", 12},
  {9.6133392593596543862434065e-19, 14, "", -14},
  {2.1681845370920153855560979e-20, 0, "", 0},
  {7.4680391064207148944572156e-12, 14, "747", -11},
  {1.0335183597800746264146726e-25, 10, "", -10},
  {1.2835687357410909312565551e-12, 0, "", 0},
  {2.8808490656808887910400000e+20, 10, "288084906568088879104", 21},
  {1.2333511402263678000000000e+16, 17, "12333511402263678", 17},
  {2.3264829573176985600000000e+17, 2, "232648295731769856", 18},
  {6.9781667711188684282705711e-22, 1, "", -1},
  {1.0968470473679261440000000e+18, 12, "1096847047367926144", 19},
  {9.0066246190006343536743616e-04, 3, "1", -2},
  {1.4337997569076676198400000e+20, 20, "143379975690766761984", 21},
  {2.1562648571599133816463489e-04, 2, "", -2},
  {3.4317764068319746187145194e-15, 18, "3432", -14},
  {5.7210980322456852480000000e+18, 7, "5721098032245685248", 19},
  {2.0177427612382771200000000e+18, 20, "201774276123827712", 19},
  {7.0442036290161995566450059e+03, 10, "70442036290162", 4},
  {1.2815953970624203491210938e+11, 10, "1281595397062420349121", 12},
  {5.8759636221463011906962493e+01, 1, "588", 2},
  {6.0879469393691742187500000e+13, 2, "6087946939369174", 14},
  {1.5459914148867985839843750e+12, 5, "154599141488679858", 13},
  {4.0956035674387205643441104e-24, 0, "", 0},
  {3.3975262709013285058091432e-08, 4, "", -4},
  {1.2389770876194833545014262e+05, 10, "1238977087619483", 6},
  {6.6204752850537828635424376e+04, 14, "6620475285053782864", 5},
  {4.6179949896920151315656044e-08, 9, "46", -7},
  {3.3399886449999835937500000e+13, 18, "333998864499998359375", 14},
  {1.4301944200670361518859863e+08, 0, "143019442", 9},
  {2.6009003990224033203125000e+12, 19, "26009003990224033203125", 13},
  {3.0308388909052143571898341e+05, 20, "30308388909052143571898341", 6},
  {4.3897058536674561974431309e-21, 15, "", -15},
  {1.2987739333380030099632497e-24, 13, "", -13},
  {2.0068524414840272635872587e-19, 10, "", -10},
  {3.2913615530909318750000000e+14, 9, "3291361553090931875", 15},
  {3.0688552561736306688000000e+19, 20, "30688552561736306688", 20},
  {1.4353541155853903462400000e+20, 4, "143535411558539034624", 21},
  {1.0097758554048263671875000e+13, 17, "10097758554048263671875", 14},
  {1.8595828515911231250000000e+14, 9, "1859582851591123125", 15},
  {1.8765568366725603336516316e-06, 13, "18765568", -5},
  {7.0183685682354319360000000e+18, 17, "7018368568235431936", 19},
  {4.1210557884198768000000000e+16, 19, "41210557884198768", 17},
  {4.0318115737968537359847687e+02, 0, "403", 3},
  {2.3874873159254805798923371e-01, 14, "23874873159255", 0},
  {8.7210122193119638808524960e-15, 15, "9", -14},
  {1.1483313574910477715060320e-04, 17, "1148331357491", -3},
  {1.4194527602709522398072295e+03, 7, "14194527603", 4},
  {8.5803969569054592284373939e+04, 4, "858039696", 5},
  {5.6478106623803675174713135e+07, 9, "56478106623803675", 8},
  {4.2141265886612365907852195e-25, 15, "", -15},
  {2.1410017422243032226562500e+12, 20, "214100174222430322265625", 13},
  {4.6096773989324011158640547e-07, 4, "", -4},
  {1.9940582748132077944265170e-22, 15, "", -15},
  {3.2964133659017245072382851e-08, 2, "", -2},
  {2.8533745593064531931304373e+02, 19, "285337455930645319313", 3},
  {5.6303365357193903921378195e-16, 8, "", -8},
  {9.7717686302158684899347996e-05, 19, "977176863021587", -4},
  {1.0864575885722042846679688e+11, 12, "108645758857220428466797", 12},
  {7.3880774144218326268673813e-03, 8, "738808", -2},
  {1.8723776661567217670381069e+06, 6, "1872377666157", 7},
  {9.5572406448316664506529662e-18, 6, "", -6},
  {1.5053158303835853990137327e-25, 7, "", -7},
  {1.4185474376731108544996367e-25, 8, "", -8},
  {2.0445028977627451194866892e-07, 11, "20445", -6},
  {3.8582530786909160175994550e-09, 14, "385825", -8},
  {7.2672721073851215839385986e+08, 16, "7267272107385121583938599", 9},
  {2.0739823035397804808568911e-04, 3, "", -3},
  {1.0147934705007595893928889e-08, 3, "", -3},
  {8.6751732605769879226644241e-17, 2, "", -2},
  {2.9437240487415014400000000e+17, 20, "294372404874150144", 18},
  {5.3575250141150332987308502e+07, 16, "535752501411503329873085", 8},
  {3.6587145281890804713728793e-15, 14, "", -14},
  {2.6434049476725508753816030e+01, 6, "26434049", 2},
  {9.2874367232736259232283235e-23, 8, "", -8},
  {5.2912431651540418560000000e+18, 20, "5291243165154041856", 19},
  {3.2228948489067503339108173e-05, 1, "", -1},
  {1.5391583837275300817009488e-05, 19, "153915838372753", -4},
  {1.3573228226216859949857135e-14, 13, "", -13},
  {6.4349114156398582458496094e+08, 6, "643491141563986", 9},
  {2.2327515263846631210498117e-03, 17, "223275152638466", -2},
  {8.2961782973798022836884781e-10, 1, "", -1},
  {1.2982809191329628811217844e+05, 18, "129828091913296288112178", 6},
  {4.2394867874243790374516077e-11, 3, "", -3},
  {6.3694675201012431772679340e-18, 1, "", -1},
  {5.3414296347410543750000000e+14, 14, "5341429634741054375", 15},
  {6.1502873641951718458077691e-05, 9, "61503", -4},
  {4.8845310127596289385110140e+05, 8, "48845310127596", 6},
  {9.7991906067989487581658227e-13, 9, "", -9},
  {1.8945581263760376000000000e+16, 5, "18945581263760376", 17},
  {9.3790822057431432767771184e+04, 14, "9379082205743143277", 5},
  {2.4604086777405501585704920e-11, 14, "246", -10},
  {2.3475722641151376592461020e+04, 6, "23475722641", 5},
  {1.2548505537222991515489134e-02, 8, "1254851", -1},
  {1.2271867380788103814085671e-22, 17, "", -17},
  {2.6028114712611322402954102e+09, 17, "260281147126113224029541016", 10},
  {5.5378175353255310058593750e+11, 17, "5537817535325531005859375", 12},
  {3.9434804493767680664062500e+12, 18, "394348044937676806640625", 13},
  {4.2555355123319765454712101e-10, 15, "425554", -9},
  {4.9118202738133087711812827e-18, 14, "", -14},
  {9.7113558158721728515625000e+11, 4, "9711355815872173", 12},
  {1.6941066721924967789988936e-07, 17, "16941066722", -6},
  {9.6286085499619102704480635e-22, 3, "", -3},
  {6.8877895377126548969622490e-25, 18, "", -18},
  {2.5837982020269224173802605e-08, 6, "", -6},
  {3.2506598382371433079242706e+07, 2, "3250659838", 8},
  {2.5697820964639501571655273e+09, 2, "256978209646", 10},
  {2.8825993538404761600000000e+20, 11, "288259935384047616", 21},
  {1.8872263478834606350785846e-11, 16, "188723", -10},
  {3.7754175441245589256286621e+09, 2, "377541754412", 10},
  {5.0850391572032069276154687e-02, 7, "508504", -1},
  {2.5397739823054280000000000e+16, 7, "2539773982305428", 17},
  {1.0120957483933493652343750e+12, 7, "10120957483933493652", 13},
  {1.7617933437365920356837473e-20, 12, "", -12},
  {2.2239356244942541503906250e+11, 13, "2223935624494254150390625", 12},
  {6.1528657980265390625000000e+13, 7, "61528657980265390625", 14},
  {3.3809776884516429901123047e+08, 20, "33809776884516429901123046875", 9},
  {1.5650248631653203013058828e+00, 2, "157", 1},
  {5.2869442402159538829664598e+00, 8, "528694424", 1},
  {3.5137034533691973686218262e+09, 14, "351370345336919736862183", 10},
  {4.2641147004612996507085026e-16, 13, "", -13},
  {1.6960416630363131919491566e-23, 16, "", -16},
  {2.6383355001140051205796300e-04, 14, "26383355001", -3},
  {2.7927813252112240634928526e-07, 20, "27927813252112", -6},
  {8.7679150191171671261883471e-18, 2, "", -2},
  {1.5240117337679855821092813e-09, 9, "2", -8},
  {4.4698343033841015625000000e+11, 16, "44698343033841015625", 12},
  {2.0429893303847317500000000e+15, 8, "204298933038473175", 16},
  {1.3905490825716838836669922e+10, 0, "13905490826", 11},
  {5.1044036546250603275357878e-08, 15, "51044037", -7},
  {7.2850810080827043194173775e-03, 1, "", -1},
  {7.5472457933724160228372568e-02, 8, "7547246", -1},
  {3.3481882230987534250812971e-18, 1, "", -1},
  {1.1861663429991425289244944e+02, 4, "1186166", 3},
  {2.1580799740433689870577894e-01, 15, "215807997404337", 0},
  {8.9520106063535139648257953e-17, 10, "", -10},
  {2.9695489878925258146084422e-21, 11, "", -11},
  {4.2364285729268729686737061e+07, 2, "4236428573", 8},
  {1.3682839916743686201649195e-24, 12, "", -12},
  {5.9504515629636005859375000e+12, 4, "59504515629636006", 13},
  {2.4699340161040544850132202e-23, 5, "", -5},
  {8.4348103245375414255682838e-21, 0, "", 0},
  {3.8045326653747609816491604e+05, 8, "38045326653748", 6},
  {1.2885703642328067943106386e-07, 8, "13", -6},
  {2.4304098158616702921779127e-06, 18, "2430409815862", -5},
  {6.4532498352827276800000000e+17, 11, "645324983528272768", 18},
  {1.0941964741675163101255898e-23, 20, "", -20},
  {2.1528339798460540771484375e+10, 8, "2152833979846054077", 11},
  {5.6405867871693945109749619e-15, 2, "", -2},
  {1.2809807854106261229983688e-08, 5, "", -5},
  {4.9100554346638917922973633e+06, 8, "491005543466389", 7},
  {1.2628592723341287424000000e+19, 13, "12628592723341287424", 20},
  {7.6086280225215479731559753e+05, 3, "760862802", 6},
  {2.7918676280673371490973185e-21, 15, "", -15},
  {1.0489958161288945004343987e+07, 19, "104899581612889450043439865", 8},
  {1.1105104253428260338565359e-02, 7, "111051", -1},
  {4.8803682986933793586104002e+01, 14, "4880368298693379", 2},
  {2.8986363257325276312112047e-16, 7, "", -7},
  {5.2093767030230910819454948e+00, 12, "5209376703023", 1},
  {1.7485317483771727085113525e+09, 1, "17485317484", 10},
  {1.5124162767604626332690470e-16, 4, "", -4},
  {2.1508428418615523014523205e+01, 18, "21508428418615523015", 2},
  {5.7268765349250662500000000e+14, 13, "572687653492506625", 15},
  {2.7917144869798754536205365e-01, 18, "279171448697987545", 0},
  {4.5275827912431492245746211e-20, 8, "", -8},
  {2.0072436434980386718750000e+13, 8, "2007243643498038671875", 14},
  {6.4784705020593156277186608e+00, 1, "65", 1},
  {2.9666789235342854169630300e+01, 1, "297", 2},
  {7.3537483235069335937500000e+11, 19, "735374832350693359375", 12},
  {2.5462466988340843272453640e+03, 11, "254624669883408", 4},
  {3.9249083481558381847350580e-20, 8, "", -8},
  {2.5820051998217789531273837e-09, 10, "26", -8},
  {1.6072417190867342197481721e-09, 12, "1607", -8},
  {2.9202871759701941630740040e-23, 14, "", -14},
  {2.0443272914793807872000000e+20, 20, "20443272914793807872", 21},
  {1.1966939547662200754157011e-06, 16, "11966939548", -5},
  {1.2640864116390432567411050e-25, 20, "", -20},
  {7.6043380654959859609829920e-22, 2, "", -2},
  {1.1878878457362371093750000e+13, 16, "1187887845736237109375", 14},
  {2.6102719524973518694267162e-09, 9, "3", -8},
  {5.0266073114344829747200000e+20, 14, "502660731143448297472", 21},
  {1.1901698537167132160000000e+18, 14, "1190169853716713216", 19},
  {4.7536102040581626370698553e-11, 10, "", -10},
  {5.4923593310593525000000000e+14, 17, "54923593310593525", 15},
  {6.4762124940817402343750000e+12, 19, "6476212494081740234375", 13},
  {6.4893756815404785156250000e+11, 4, "6489375681540479", 12},
  {2.5023530875724340148735791e+04, 20, "2502353087572434014873579", 5},
  {1.9733612818558304687500000e+13, 12, "197336128185583046875", 14},
  {4.5533131308950722969600000e+20, 18, "455331313089507229696", 21},
  {1.3503774128417052570230875e-08, 18, "13503774128", -7},
  {1.4854247866661325638238333e-10, 1, "", -1},
  {2.0268378299842398661629792e-07, 4, "", -4},
  {3.1786447174284357970464043e+03, 5, "317864472", 4},
  {3.9524076960689821035316744e-21, 14, "", -14},
  {3.5304754547224634098464443e-16, 13, "", -13},
  {1.0663877071203846196023601e-03, 10, "10663877", -2},
  {3.6749153576261205883053097e-22, 3, "", -3},
  {6.9234099657084642001502714e-23, 5, "", -5},
  {8.1745838769978249073028564e+08, 7, "8174583876997825", 9},
  {8.8163695951401480000000000e+15, 11, "8816369595140148", 16},
  {2.4024147063751372800000000e+18, 1, "240241470637513728", 19},
  {1.7128397908546229755056410e-12, 4, "", -4},
  {1.3125397506274301090952613e-20, 15, "", -15},
  {5.0937297401829270682149797e-03, 7, "50937", -2},
  {3.1215543799506710052490234e+10, 1, "312155437995", 11},
  {2.3073737077996620535850525e+08, 5, "23073737077997", 9},
  {1.6753538429413107223808765e+04, 9, "16753538429413", 5},
  {1.1750634405319179375190163e-11, 14, "1175", -10},
  {2.0841109289787878205215280e-23, 4, "", -4},
  {4.4545553601315034029539675e+04, 15, "4454555360131503403", 5},
  {1.2314549662103223873608655e-23, 17, "", -17},
  {5.6234589785157584000000000e+16, 8, "56234589785157584", 17},
  {2.4351056509702352483387957e-15, 20, "243511", -14},
  {2.1118696318940533274144400e+02, 2, "21119", 3},
  {6.3357236954665226348137214e-17, 9, "", -9},
  {1.6462471438488400963251479e+03, 11, "164624714384884", 4},
  {2.4302616063616761600000000e+17, 6, "243026160636167616", 18},
  {9.4420844057489793833526020e-17, 8, "", -8},
  {7.7629418483726657064991281e-06, 2, "", -2},
  {9.4665602400259194447451616e-05, 5, "9", -4},
  {8.8830326845725518514207408e-02, 5, "8883", -1},
  {1.7119178604140400000000000e+17, 7, "171191786041404", 18},
  {4.5966188751302262724607075e-11, 16, "459662", -10},
  {3.4024504241497754119336605e+06, 8, "340245042414978", 7},
  {4.4941206722229283914414079e-06, 15, "4494120672", -5},
  {1.0358590674830632284283638e+07, 7, "103585906748306", 8},
  {1.1721593265629662500000000e+15, 1, "11721593265629663", 16},
  {2.0510352775903229041558739e-16, 7, "", -7},
  {1.6686337837633427854381094e-23, 1, "", -1},
  {2.2366745709450007950636063e+01, 13, "2236674570945", 2},
  {1.8381471047219635200000000e+17, 2, "183814710472196352", 18},
  {2.7761763608950656134766177e+02, 20, "27761763608950656134766", 3},
  {1.0488343116579418873385547e-18, 16, "", -16},
  {6.5706342737623739242553711e+08, 9, "657063427376237392", 9},
  {1.0206391055227532966910689e-11, 11, "1", -10},
  {1.3147592943631805644800000e+20, 20, "131475929436318056448", 21},
  {2.4991817279487730728249843e-06, 5, "", -5},
  {1.4676629162589980293063263e+00, 11, "146766291626", 1},
  {4.0154467062919646649724117e-17, 8, "", -8},
  {1.9093571496090707369148731e+06, 5, "190935714961", 7},
  {2.7867491130199777346013271e-24, 4, "", -4},
  {1.2229409573944353600000000e+17, 20, "122294095739443536", 18},
  {1.7087446371059050795844241e-19, 6, "", -6},
  {2.3839880185961117575743629e+00, 4, "2384", 1},
  {2.1963690374677866995549380e-18, 1, "", -1},
  {1.5752775568825018448482211e-03, 16, "15752775568825", -2},
  {8.8979852969339217995457629e-07, 19, "8897985296934", -6},
  {4.5579104005952992187500000e+13, 0, "45579104005953", 14},
  {7.1523724054712297715299198e-12, 20, "715237241", -11},
  {2.3607589421545789809897542e+05, 5, "23607589422", 6},
  {4.4512126050799423637727159e+02, 7, "4451212605", 3},
  {8.6720231626725442617862824e-07, 3, "", -3},
  {1.5196387930302080270813183e-19, 6, "", -6},
  {1.3222763601241168748199493e-10, 5, "", -5},
  {1.8745596710565374110046832e+02, 17, "1874559671056537411", 3},
  {1.3151595984599192095762414e-16, 17, "13", -15},
  {5.6907722572025049885269254e+04, 6, "56907722572", 5},
  {4.8429452457794624000000000e+16, 1, "48429452457794624", 17},
  {3.7360437929282020296453009e-07, 12, "373604", -6},
  {3.4027118640655487775802612e+08, 0, "340271186", 9},
  {2.7938068881807332038879395e+09, 9, "2793806888180733204", 10},
  {1.6732410331069989887749563e-05, 18, "1673241033107", -4},
  {1.8831545723301291465759277e+07, 13, "188315457233012914658", 8},
  {4.3029898387994211361728958e+02, 19, "4302989838799421136173", 3},
  {1.2959453870910602563526481e+05, 1, "1295945", 6},
  {1.3464238972758977740800000e+20, 2, "134642389727589777408", 21},
  {3.5153677394496596497367537e-15, 13, "", -13},
  {8.7711882288961540665102060e-13, 11, "", -11},
  {9.0599683392728500000000000e+13, 20, "905996833927285", 14},
  {7.3191015955530224609375000e+11, 19, "73191015955530224609375", 12},
  {7.6274591830128373760000000e+18, 20, "7627459183012837376", 19},
  {2.6074561834497664000000000e+16, 9, "26074561834497664", 17},
  {6.9499886674530136663985556e-16, 16, "7", -15},
  {6.9058408689373778179287910e+05, 1, "6905841", 6},
  {3.0492306047849758458651009e-25, 7, "", -7},
  {3.3373493573851989331730439e-08, 1, "", -1},
  {4.7326656989386673855139984e-11, 12, "47", -10},
  {1.2667313904832785600000000e+17, 8, "126673139048327856", 18},
  {3.2776891719098799512721598e+04, 3, "32776892", 5},
  {1.7280274209219608306884766e+09, 10, "17280274209219608307", 10},
  {1.7100672848896132990763754e-23, 7, "", -7},
  {3.4543515572770869731903076e+08, 6, "345435155727709", 9},
  {2.0947369058304143505231399e-13, 19, "2094737", -12},
  {8.0346084186629681971200000e+20, 19, "803460841866296819712", 21},
  {2.5474488340224027141392373e-07, 17, "2547448834", -6},
  {8.4349448868318428936742439e-08, 16, "843494489", -7},
  {7.7776617824213334015381882e-04, 13, "7777661782", -3},
  {1.2232010106522064208984375e+11, 10, "1223201010652206420898", 12},
  {1.4403476457822275775800814e-11, 19, "144034765", -10},
  {6.2450510210255953360925740e-14, 19, "624505", -13},
  {4.5874656932181036800000000e+17, 2, "458746569321810368", 18},
  {1.8000667815427792106675042e+02, 8, "18000667815", 3},
  {1.6619425091932068791632380e-25, 12, "", -12},
  {9.8217619296627894920348467e-02, 20, "9821761929662789492", -1},
  {2.8575610830664475483771456e-06, 3, "", -3},
  {1.7354588523779497677423933e+02, 12, "173545885237795", 3},
  {6.2237914154087858875641359e-02, 1, "1", 0},
  {3.0242656617719913055225922e-18, 1, "", -1},
  {5.2415765660209107442049905e-15, 14, "1", -13},
  {1.6616383663257433765215083e-09, 3, "", -3},
  {3.3166285126971608576695871e+00, 12, "3316628512697", 1},
  {1.9944409840771150366212083e-03, 13, "19944409841", -2},
  {1.9705054978377958561600228e-18, 8, "", -8},
  {8.8982086685388187161321969e-08, 7, "1", -6},
  {3.4059770664148573923351909e-18, 0, "", 0},
  {3.0101159195928666740655899e+07, 3, "30101159196", 8},
  {7.2628841941932131473920475e-17, 3, "", -3},
  {7.4458774218609576219483903e-05, 20, "7445877421860958", -4},
  {8.0721613863343362500000000e+14, 2, "80721613863343363", 15},
  {4.2995005321545020954450422e-06, 12, "4299501", -5},
  {2.2288506590700604020373332e-04, 0, "", 0},
  {2.3092255432986478805541992e+09, 15, "2309225543298647880554199", 10},
  {8.3015855105025060378665103e-01, 19, "8301585510502506038", 0},
  {6.0752193093038520999016328e+01, 14, "6075219309303852", 2},
  {3.3197996549112873077392578e+09, 0, "3319799655", 10},
  {8.0802197596549429084931742e-20, 7, "", -7},
  {2.3580232563627661485083920e-02, 4, "236", -1},
  {4.2615235324443461253918208e-03, 3, "4", -2},
  {2.0560296188052152072823465e-16, 4, "", -4},
  {2.9728886697037954687176203e-17, 11, "", -11},
  {1.3795218452808704000000000e+18, 0, "13795218452808704", 19},
  {4.2646774340934651263523847e+04, 11, "4264677434093465", 5},
  {2.9173936395650795204176776e-06, 16, "29173936396", -5},
  {3.5506520936709209463068684e-11, 14, "3551", -10},
  {6.3335033674671594467774605e-18, 13, "", -13},
  {9.6509700923070669174194336e+07, 17, "9650970092307066917419434", 8},
  {3.3316286814730481697808748e-06, 10, "33316", -5},
  {2.8388772480441020352320836e-04, 20, "2838877248044102", -3},
  {4.9793719988546414062500000e+13, 17, "497937199885464140625", 14},
  {3.5274872641309450240000000e+18, 19, "3527487264130945024", 19},
  {5.0520061137726832231972872e-11, 14, "5052", -10},
  {6.0384237767153823226062451e-22, 0, "", 0},
  {1.8988025762591855816197040e+00, 5, "18988", 1},
  {1.9391679977898901367187500e+11, 7, "1939167997789890137", 12},
  {1.5057400898776254565512855e-05, 19, "150574008987763", -4},
  {3.5637949764400010582333500e-15, 14, "", -14},
  {3.1793593761542812347412109e+10, 8, "3179359376154281235", 11},
  {1.5281675101622469501998132e-12, 5, "", -5},
  {9.3970758004475585937500000e+10, 2, "9397075800448", 11},
  {5.3048422683140898925557849e+01, 4, "530484", 2},
  {7.0069934439341962337493896e+08, 19, "7006993443934196233749389648", 9},
  {1.9834829732520029296875000e+12, 16, "19834829732520029296875", 13},
  {1.9162228802810975141724039e-10, 8, "", -8},
  {4.1552631206144959888165006e-12, 1, "", -1},
  {3.1099415051650626499655516e-10, 0, "", 0},
  {3.1859084540374569116771958e-17, 13, "", -13},
  {3.2735441483128069339869626e-02, 13, "327354414831", -1},
  {1.9131137501232676864000000e+19, 19, "19131137501232676864", 20},
  {6.7591812843030667132376961e-15, 6, "", -6},
  {1.1257760026656277760000000e+18, 8, "1125776002665627776", 19},
  {1.4654895015192196296993643e+04, 20, "1465489501519219629699364", 5},
  {5.2492388864194267988204956e+08, 3, "524923888642", 9},
  {5.2205497739294830322265625e+11, 11, "52205497739294830322266", 12},
  {1.4278244399995488414808762e-09, 14, "142782", -8},
  {4.3368177651007541896042844e-08, 9, "43", -7},
  {5.0214071538279893047729274e+02, 11, "5021407153828", 3},
  {5.8663531065089490944000000e+19, 9, "58663531065089490944", 20},
  {5.9666551832781691289600000e+20, 11, "596665518327816912896", 21},
  {7.6993340763303373573967054e-25, 10, "", -10},
  {7.9244944180033058955814340e+00, 11, "7924494418", 1},
  {1.1951325861665612500000000e+15, 7, "119513258616656125", 16},
  {2.4760346174247344579317415e-19, 13, "", -13},
  {1.2145744580829764345253352e+03, 8, "121457445808", 4},
  {3.9278860605593440122902393e+06, 11, "392788606055934401", 7},
  {6.2493917016268329955863692e-03, 2, "1", -1},
  {2.0899782966952261957704665e-15, 3, "", -3},
  {6.6268359795732011915627140e-10, 13, "6627", -9},
  {5.8993955877023433467304023e-08, 9, "59", -7},
  {5.4074200749064857600000000e+18, 16, "540742007490648576", 19},
  {5.6848433706535144000000000e+16, 13, "56848433706535144", 17},
  {1.8700867769471202980935441e-14, 18, "18701", -13},
  {1.9526024822353819277760305e-09, 4, "", -4},
  {8.5201790453985205385833979e+05, 14, "85201790453985205386", 6},
  {5.7695359280242450950026978e+02, 19, "5769535928024245095003", 3},
  {1.6865595194941332337769466e-13, 19, "168656", -12},
  {1.0495496270939649597193867e-10, 14, "10495", -9},
  {2.2759384289460496000000000e+16, 6, "22759384289460496", 17},
  {8.4174182655647692977092703e-11, 1, "", -1},
  {1.0885817071102198679000139e+06, 16, "10885817071102198679", 7},
  {7.7839613166948715475279563e-03, 6, "7784", -2},
  {1.3442437548513529677052247e+01, 2, "1344", 2},
  {1.6084184684834739176295670e+00, 2, "161", 1},
  {4.0739660606356912634321734e-25, 12, "", -12},
  {1.2744618353085976094007492e+07, 20, "1274461835308597609400749207", 8},
  {1.9037599402703049316406250e+12, 16, "1903759940270304931640625", 13},
  {8.6536886747150909036220044e-14, 16, "865", -13},
  {1.3435078649645422832387954e-14, 6, "", -6},
  {7.8171545844296898926947238e-17, 12, "", -12},
  {3.0597141616190042495727539e+09, 5, "3059714161619", 10},
  {1.1208437492087583988904953e+07, 1, "112084375", 8},
  {1.2288542156186130482979011e-12, 3, "", -3},
  {3.0213147317724218700597844e-15, 11, "", -11},
  {3.9594067533628943819045894e-10, 15, "395941", -9},
  {1.1207998084904122464578596e-07, 14, "11207998", -6},
  {6.4023485816834529689600000e+20, 17, "640234858168345296896", 21},
  {3.2096800362934180839147302e+02, 5, "320968", 3},
  {1.6326822237676981603726745e+05, 20, "16326822237676981603726745", 6},
  {1.6718952763840092160000000e+19, 6, "1671895276384009216", 20},
  {6.0796041281186550059066696e-08, 0, "", 0},
  {4.0679346452363614570806099e-25, 17, "", -17},
  {7.4476730616100352940160502e-18, 4, "", -4},
  {1.4203290415784807222020622e-22, 8, "", -8},
  {7.6179272982333798859127258e-08, 0, "", 0},
  {2.6036376708138957158933380e-02, 10, "260363767", -1},
  {5.2734986943459556250000000e+14, 16, "5273498694345955625", 15},
  {4.1846812984664916162783172e-21, 14, "", -14},
  {1.9529390959218368740394605e-19, 7, "", -7},
  {3.9276208970767368000000000e+16, 12, "39276208970767368", 17},
  {8.3298266020550730172544718e+05, 10, "8329826602055073", 6},
  {1.0762001678653272753528810e-13, 2, "", -2},
  {4.1442430522597492187500000e+13, 10, "414424305225974921875", 14},
  {7.1078477184389069301043843e-12, 2, "", -2},
  {5.1962853052609329551202307e-19, 0, "", 0},
  {4.5418251326292393190026842e-10, 14, "45418", -9},
  {2.1436819748302365382742093e-15, 15, "2", -14},
  {4.1188006930732866210937500e+12, 13, "411880069307328662109375", 13},
  {2.3652011782448660278320312e+11, 17, "236520117824486602783203125", 12},
  {2.5577096518607933593750000e+13, 0, "25577096518608", 14},
  {3.9556110334756626577070479e-07, 3, "", -3},
  {5.1669552733134523632962173e-22, 9, "", -9},
  {3.1317718299169866943359375e+11, 5, "31317718299169867", 12},
  {7.9399123267824782015818387e-15, 7, "", -7},
  {7.4716245136263256426900625e+05, 4, "7471624514", 6},
  {1.4394268644541125000000000e+13, 9, "14394268644541125", 14},
  {1.0746232918512095277918661e+00, 9, "1074623292", 1},
  {4.5859058887581877601597294e-19, 1, "", -1},
  {1.0572848364503746150400000e+20, 6, "105728483645037461504", 21},
  {1.1415375088055161759257317e+06, 7, "11415375088055", 7},
  {2.6965063276054087561381533e-23, 5, "", -5},
  {9.8547901405594392364110239e-20, 6, "", -6},
  {1.2776498373544483427043967e-12, 2, "", -2},
  {1.9989811848593153064230694e-10, 5, "", -5},
  {2.3807013802818391923210584e+02, 2, "23807", 3},
  {2.0276133013071453571319580e+09, 6, "2027613301307145", 10},
  {2.1688687153154693078249693e+05, 20, "21688687153154693078249693", 6},
  {2.6534006066573926827228264e-05, 17, "2653400606657", -4},
  {3.1228922467409200180554762e+04, 3, "31228922", 5},
  {1.5506162064776326587889344e+04, 2, "1550616", 5},
  {9.7974661804209458790260179e-04, 13, "979746618", -3},
  {1.0992628989944555483011757e-22, 5, "", -5},
  {5.6457838217937398101358885e-08, 4, "", -4},
  {2.5727085758835287902834680e-22, 11, "", -11},
  {2.8641573492285038592000000e+19, 1, "28641573492285038592", 20},
  {9.1196309316136352717876434e+06, 1, "91196309", 7},
  {7.3823555702203199261474442e-13, 4, "", -4},
  {3.5433941046169369416433282e-14, 9, "", -9},
  {7.4879296882163491914582987e-07, 15, "748792969", -6},
  {3.0370641867353188238733343e-10, 6, "", -6},
  {2.0672286502938119372800000e+20, 4, "206722865029381193728", 21},
  {2.0931313466846375822465534e-06, 1, "", -1},
  {1.3390648995628082752227783e+09, 14, "133906489956280827522278", 10},
  {1.7402614238404427338084289e-07, 3, "", -3},
  {1.8868036980911762695312500e+12, 5, "188680369809117627", 13},
  {1.7956303922029337286949158e+08, 8, "17956303922029337", 9},
  {1.3387322748340096348852207e-23, 7, "", -7},
  {2.1650452723495112102100458e-22, 11, "", -11},
  {1.1701133315560000017285347e+07, 14, "1170113331556000001729", 8},
  {6.8061094785322951594763459e-20, 15, "", -15},
  {4.6542646988046215694723173e-01, 18, "465426469880462157", 0},
  {1.8077653034486479053342955e-04, 6, "181", -3},
  {1.2663936060920146751655131e-10, 10, "1", -9},
  {2.0610591667595330339221060e-17, 17, "2", -16},
  {9.6325694306629415798789804e-21, 20, "1", -19},
  {1.0008714713735299798803350e-13, 11, "", -11},
  {2.9591843870798753636063214e-08, 4, "", -4},
  {4.4913781357128325929801805e-12, 19, "44913781", -11},
  {3.3747090281320700887590647e+05, 10, "337470902813207", 6},
  {2.1239483756565852500000000e+15, 2, "212394837565658525", 16},
  {1.4344982932364850019467601e-21, 16, "", -16},
  {4.1249990412678120346702575e-11, 15, "4125", -10},
  {1.4472987603728169575333595e+07, 10, "144729876037281696", 8},
  {1.9334640705455073596178784e-10, 3, "", -3},
  {2.9594633259404585588246213e-14, 15, "3", -13},
  {1.6340610664517978442124680e-16, 12, "", -12},
  {3.2437564347588195312500000e+13, 7, "324375643475881953125", 14},
  {1.5138125337516382842295570e+03, 17, "151381253375163828423", 4},
  {1.0312073080347731132980697e-19, 13, "", -13},
  {1.9051709840289178521377522e-02, 9, "1905171", -1},
  {1.4566748733067679418050292e-14, 12, "", -12},
  {1.6563797494441462061082193e-03, 6, "1656", -2},
  {1.9685087351022876100614667e+05, 4, "1968508735", 6},
  {1.9634038698194644564478514e-15, 2, "", -2},
  {1.9192119678271665528025913e-25, 7, "", -7},
  {3.0942353246263514073217168e-06, 2, "", -2},
  {7.3334518370570464518287679e-03, 4, "73", -2},
  {2.7538041249386496000000000e+18, 17, "27538041249386496", 19},
  {4.6553915532886735870665360e-06, 12, "4655392", -5},
  {1.7923520263880002498626709e+08, 7, "1792352026388", 9},
  {1.9491567987358293656541264e-01, 11, "19491567987", 0},
  {1.1546390511388062535965174e-23, 14, "", -14},
  {6.0394601697659217927172883e-15, 18, "6039", -14},
  {4.3759940307943174018820069e-18, 9, "", -9},
  {1.6499488718281972687691450e+06, 1, "16499489", 7},
  {2.1038254005542893191372549e-14, 12, "", -12},
  {8.6113119593198510742187500e+11, 4, "8611311959319851", 12},
  {2.2075033548123756051063538e+08, 12, "220750335481237560511", 9},
  {8.4226624090092221316467564e-23, 8, "", -8},
  {1.1739956977199209053885909e-01, 20, "11739956977199209054", 0},
  {2.0786852244369483450194913e-18, 7, "", -7},
  {7.2068439035790408511075459e-18, 0, "", 0},
  {2.8638995544527541953462185e-20, 9, "", -9},
  {1.0081004392742236065622147e-18, 13, "", -13},
  {2.5515670836659512133337557e+05, 20, "25515670836659512133337557", 6},
  {4.2181331656412139892578125e+11, 16, "42181331656412139892578125", 12},
  {2.1914178093001858635742892e-24, 2, "", -2},
  {9.5600619296979064023826203e-23, 8, "", -8},
  {1.6607988547714128494262695e+10, 17, "1660798854771412849426269531", 11},
  {1.9549987102902802311170150e-08, 3, "", -3},
  {9.4881731901484087643439125e+00, 9, "948817319", 1},
  {1.8447708920638807972052561e-16, 3, "", -3},
  {6.8072460600425494263763990e-17, 6, "", -6},
  {2.8069828954069215853905916e+00, 12, "2806982895407", 1},
  {2.3128586316176553445676739e-17, 2, "", -2},
  {1.0954601870634263369154936e-07, 20, "10954601870634", -6},
  {1.5544080227404085557060747e-20, 4, "", -4},
  {2.1570848429281669855117798e+08, 17, "21570848429281669855117798", 9},
  {5.1493841552447321719554333e-07, 10, "5149", -6},
  {9.9029285264116765574726742e+01, 9, "99029285264", 2},
  {1.6257239864218719915811562e+00, 11, "162572398642", 1},
  {3.1118544323815463576465845e+05, 19, "3111854432381546357646585", 6},
  {5.2743366773911572296237670e-13, 17, "52743", -12},
  {7.4395863248291718750000000e+12, 7, "7439586324829171875", 13},
  {3.9313939575857838080000000e+18, 19, "3931393957585783808", 19},
  {7.4389215954525891113281250e+11, 5, "74389215954525891", 12},
  {6.7923505343092869120000000e+18, 11, "6792350534309286912", 19},
  {2.5407515121246439218521118e+08, 19, "2540751512124643921852111816", 9},
  {5.2816871799627258300781250e+11, 20, "5281687179962725830078125", 12},
  {2.0544780662602775878906250e+12, 5, "205447806626027759", 13},
  {2.8078071580092861178067375e-15, 16, "28", -14},
  {3.7983638093791222889154967e-19, 0, "", 0},
  {4.2934469352561117200659574e-15, 11, "", -11},
  {1.2300455664575367565084459e-22, 19, "", -19},
  {4.5358719511874237060546875e+10, 16, "45358719511874237060546875", 11},
  {6.5084872179800766730134188e-17, 14, "", -14},
  {3.8868901031259461831268709e-01, 10, "3886890103", 0},
  {3.8127119605135327577590942e+08, 15, "381271196051353275775909", 9},
  {4.6857375233623790740966797e+09, 9, "4685737523362379074", 10},
  {2.9620324341910785802484476e-05, 13, "296203243", -4},
  {3.5653461265074865167251980e-13, 2, "", -2},
  {2.8257635384399944298433605e-07, 9, "283", -6},
  {1.7003431562384832161807249e-19, 0, "", 0},
  {1.9622137215034174406724787e-01, 10, "1962213722", 0},
  {2.8968792176766710579200000e+20, 2, "289687921767667105792", 21},
  {1.1573737192107222959691626e+00, 8, "115737372", 1},
  {6.2615484202887916564941406e+08, 3, "626154842029", 9},
  {6.5762140906069326311103339e-13, 9, "", -9},
  {6.1259416026510025825911389e-15, 15, "6", -14},
  {6.3890217964038048972800000e+20, 8, "638902179640380489728", 21},
  {1.0521966721372320548773954e-04, 8, "10522", -3},
  {4.9433584662339818896725774e+05, 3, "494335847", 6},
  {6.8131126900748768000000000e+16, 10, "68131126900748768", 17},
  {7.9070622323303861395167724e-21, 12, "", -12},
  {3.1488860520645708618303615e+01, 2, "3149", 2},
  {5.9131060760145487560094874e-15, 14, "1", -13},
  {2.2137093396896779304289074e-13, 3, "", -3},
  {5.6013160357153648000000000e+16, 10, "56013160357153648", 17},
  {6.8654671630906683276407421e+04, 9, "68654671630907", 5},
  {6.5655119273033450000000000e+14, 9, "6565511927303345", 15},
  {8.1294032943913898345772295e-10, 12, "813", -9},
  {4.1173502882913303887175268e-24, 17, "", -17},
  {1.1198199817598812444430223e+01, 10, "111981998176", 2},
  {3.9103435808093903180981954e-03, 17, "391034358080939", -2},
  {4.7865743532087124740426947e-11, 14, "4787", -10},
  {2.9348035799319764919346198e+04, 2, "2934804", 5},
  {1.6530611410826843439281220e+03, 8, "165306114108", 4},
  {1.5089725549158995971083641e+07, 6, "15089725549159", 8},
  {2.3357423830912376658494096e-12, 12, "2", -11},
  {1.4521263597276274000000000e+16, 18, "14521263597276274", 17},
  {1.6505850279359687072721416e-11, 6, "", -6},
  {5.5745429080018080625258226e-21, 16, "", -16},
  {7.3054817921954241766689664e-05, 20, "7305481792195424", -4},
  {1.3851263608223440647125244e+09, 15, "1385126360822344064712524", 10},
  {1.8464904896875488870400000e+20, 8, "184649048968754888704", 21},
  {4.9506052398347999421446275e-01, 8, "49506052", 0},
  {9.9696916387636163931967663e-23, 7, "", -7},
  {1.1165509483451236328125000e+13, 1, "111655094834512", 14},
  {2.2137081861381464843750000e+12, 6, "2213708186138146484", 13},
  {6.2871707734723041830111889e-05, 3, "", -3},
  {6.2287207922395870784981753e-01, 15, "622872079223959", 0},
  {1.3955498794062707039397138e-21, 13, "", -13},
  {3.6539969155062246015233927e-24, 17, "", -17},
  {3.9810951747121367914581794e-15, 3, "", -3},
  {1.1718583637536909375000000e+14, 3, "117185836375369094", 15},
  {2.8748307478589392211164769e-13, 16, "2875", -12},
  {6.8032939894135256000000000e+16, 9, "68032939894135256", 17},
  {9.7716834315452775331360439e-23, 15, "", -15},
  {1.3644852592993957822800621e-04, 1, "", -1},
  {1.5277439903827260971069336e+10, 10, "152774399038272609711", 11},
  {2.5535144879358845784234986e-19, 11, "", -11},
  {1.6322095758258283358143667e-15, 2, "", -2},
  {1.5518402593007454208000000e+19, 13, "15518402593007454208", 20},
  {5.4734346731091379200000000e+17, 12, "547343467310913792", 18},
  {1.0655241952359400996899974e-07, 17, "10655241952", -6},
  {1.0742282589630551592603770e-20, 14, "", -14},
  {9.6039562437275476074218750e+11, 8, "96039562437275476074", 12},
  {1.2806015777705051200000000e+17, 18, "128060157777050512", 18},
  {2.4609608548422613178998500e-11, 2, "", -2},
  {4.1173010955548006723442524e-23, 0, "", 0},
  {1.2744168431471707500000000e+15, 12, "127441684314717075", 16},
  {7.3981729671169205175829120e+03, 15, "7398172967116920518", 4},
  {2.7462306433617803864042936e-15, 13, "", -13},
  {3.9210133701170528878522314e-10, 2, "", -2},
  {2.1333054530240953376172051e-25, 16, "", -16},
  {1.4891620161175253987312317e+08, 12, "148916201611752539873", 9},
  {2.4289714429623504638671875e+10, 1, "242897144296", 11},
  {4.7019673442693400440117041e-05, 8, "4702", -4},
  {7.0733159019161234027706087e+04, 18, "70733159019161234027706", 5},
  {7.0920276636954110927035799e+02, 10, "7092027663695", 3},
  {1.4849185743397351074218750e+12, 13, "1484918574339735107421875", 13},
  {1.6264814261134734375000000e+13, 8, "16264814261134734375", 14},
  {4.2143007344929400422400000e+20, 5, "421430073449294004224", 21},
  {3.6571157202709188164049814e-04, 8, "36571", -3},
  {7.2918848621809679003185007e-07, 11, "72919", -6},
  {8.7425193514729703125000000e+13, 11, "87425193514729703125", 14},
  {1.6500832263833940000000000e+16, 7, "1650083226383394", 17},
  {1.3512015689636436093778690e-16, 18, "135", -15},
  {2.6325871264086201511966934e-03, 2, "", -2},
  {6.9054454394297327616000000e+19, 8, "69054454394297327616", 20},
  {1.2782646909804193600000000e+17, 17, "127826469098041936", 18},
  {1.1920108726993356704711914e+10, 6, "11920108726993357", 11},
  {3.3316342812764372825622559e+09, 5, "333163428127644", 10},
  {4.8644270425374237060546875e+11, 6, "486442704253742371", 12},
  {4.7030981184597377024000000e+19, 12, "47030981184597377024", 20},
  {2.0672640851557775568039105e-05, 10, "206726", -4},
  {1.4424352883349044740290426e-14, 0, "", 0},
  {5.0208839321920176128000000e+20, 11, "50208839321920176128", 21},
  {3.4541489728633684164194051e-01, 1, "3", 0},
  {3.5761646629861004953454540e+01, 1, "358", 2},
  {8.8750760826629637723073074e-02, 9, "88750761", -1},
  {3.5797653021492225295075930e-09, 20, "357976530215", -8},
  {2.4331341950595870720000000e+18, 12, "2433134195059587072", 19},
  {3.5740190971590166015625000e+12, 7, "35740190971590166016", 13},
  {1.1830237771239843368530273e+10, 14, "1183023777123984336853027", 11},
  {8.3720921077196589976665564e+02, 7, "8372092108", 3},
  {3.8314905847785810432963398e-18, 6, "", -6},
  {2.0636465923607346415519714e+08, 10, "2063646592360734642", 9},
  {8.9180890144937273733501253e-20, 5, "", -5},
  {8.3438313076948994140625000e+12, 6, "8343831307694899414", 13},
  {2.5332735726098735540290363e+02, 10, "253327357261", 3},
  {1.1483124262379464676095672e-25, 12, "", -12},
  {3.2571526904707766118807211e-04, 11, "32571527", -3},
  {6.6359107147050512535797582e-25, 20, "", -20},
  {3.3712613940692029406793122e-18, 17, "", -17},
  {2.0813746022652609375000000e+13, 6, "20813746022652609375", 14},
  {2.7257498220017929687500000e+13, 15, "272574982200179296875", 14},
  {2.1575688301357853521547401e-10, 2, "", -2},
  {2.3685158758096837718151327e-08, 11, "2369", -7},
  {1.1079559699986871040000000e+18, 19, "1107955969998687104", 19},
  {1.1753498263101927936077118e+07, 5, "117534982631", 8},
  {3.1717542026005228830709548e-04, 12, "31717542", -3},
  {1.7875179923870089597008864e-07, 4, "", -4},
  {6.4063866038474604544000000e+19, 16, "64063866038474604544", 20},
  {2.2978544698135158017194857e-19, 11, "", -11},
  {6.6202359875256546395482193e-09, 1, "", -1},
  {6.3966224453169810183761346e-04, 14, "63966224453", -3},
  {2.7881696685059621327397493e-08, 13, "278817", -7},
  {3.2108295258904403453925624e+04, 18, "32108295258904403453926", 5},
  {1.1174448619769648303190479e+03, 2, "111744", 4},
  {9.5465372132938840000000000e+15, 14, "9546537213293884", 16},
  {8.3713546823269563188322441e-23, 11, "", -11},
  {5.4646034589115449158528414e-09, 16, "54646035", -8},
  {1.4343609742845755188099964e-09, 18, "1434360974", -8},
  {5.7371758615287272217025949e-04, 16, "5737175861529", -3},
  {6.1129422255228660129469953e-19, 20, "61", -18},
  {2.9118020449345229369848932e-25, 11, "", -11},
  {1.6025455563198415000000000e+15, 2, "16025455563198415", 16},
  {3.3435451311825131250000000e+14, 1, "3343545131182513", 15},
  {2.4400119460819110870361328e+09, 19, "24400119460819110870361328125", 10},
  {9.8531399985850259781727800e+02, 10, "9853139998585", 3},
  {4.1434444243471332924855233e+01, 20, "4143444424347133292486", 2},
  {1.7051367600004261833229717e-17, 5, "", -5},
  {1.4521231823767570000000000e+16, 3, "1452123182376757", 17},
  {4.9307256877558461176616514e-08, 16, "493072569", -7},
  {6.2383454543451259368494228e-08, 9, "62", -7},
  {6.0770111714557820407688583e-14, 2, "", -2},
  {1.9244101979998712320000000e+18, 19, "1924410197999871232", 19},
  {1.2228251831940225795140615e-06, 11, "122283", -5},
  {1.9131827392462178771671584e-21, 12, "", -12},
  {6.4214291917909257812500000e+12, 7, "64214291917909257813", 13},
  {5.3660942458131572152524313e+01, 16, "536609424581315722", 2},
  {4.6074260775228790216220861e-10, 19, "4607426078", -9},
  {3.5425262500490963393063831e-23, 1, "", -1},
  {1.0690289286495554979516044e-10, 4, "", -4},
  {1.7491524057115199228301089e-08, 4, "", -4},
  {2.2918724338561473187025723e-06, 11, "229187", -5},
  {4.3109361557362024797157574e+00, 2, "431", 1},
  {2.6576190889522163161018398e+03, 5, "265761909", 4},
  {1.3868451314309819711306020e-09, 10, "14", -8},
  {1.2370173109698665935507678e-20, 2, "", -2},
  {6.4721804927459364989772439e+04, 5, "6472180493", 5},
  {4.9744134414529908327859847e-19, 10, "", -10},
  {1.1777439695670780320235771e-02, 7, "117774", -1},
  {2.4906479329599580210501599e-18, 14, "", -14},
  {1.1073410657685851562500000e+14, 7, "110734106576858515625", 15},
  {7.1046314120776028430601077e-11, 9, "", -9},
  {1.1582446889327441264478908e-10, 8, "", -8},
  {1.9436293647481012158095837e+06, 18, "1943629364748101215809584", 7},
  {2.9066938845675581054687500e+12, 3, "2906693884567558", 13},
  {3.4869674612828010559082031e+10, 9, "34869674612828010559", 11},
  {6.3429920274216296775892556e-19, 14, "", -14},
  {2.8998051763929097533945492e-22, 3, "", -3},
  {1.0898954066370515823364258e+09, 18, "1089895406637051582336425781", 10},
  {2.3627609107276661859486921e+01, 5, "2362761", 2},
  {2.7194900307254949951171875e+11, 3, "271949003072549", 12},
  {4.4723158602436217442556473e-22, 20, "", -20},
  {2.9387484373369472667736346e-02, 4, "294", -1},
  {1.4130730110082587563374646e-16, 2, "", -2},
  {2.2898261205757741265642835e+01, 14, "2289826120575774", 2},
  {4.3548637691857209607561152e-09, 3, "", -3},
  {3.7635201215201010427335859e+02, 15, "376352012152010104", 3},
  {4.6201017219933647155761719e+10, 13, "462010172199336471557617", 11},
  {1.6960703947442212104797363e+09, 15, "1696070394744221210479736", 10},
  {5.2835224967438180742359582e-20, 7, "", -7},
  {7.1586151919545752149494507e-08, 4, "", -4},
  {7.2721992882720462512224913e+05, 2, "72721993", 6},
  {4.7031181604978335997202521e+00, 3, "4703", 1},
  {4.4372173143160394228539327e-08, 0, "", 0},
  {4.5452685927999925613403320e+08, 10, "4545268592799992561", 9},
  {4.5318754786925225658267280e-03, 20, "453187547869252257", -2},
  {3.2949590481063132286071777e+09, 1, "32949590481", 10},
  {5.1490778341989987154647679e+01, 3, "51491", 2},
  {2.6361074617744177217491524e-21, 4, "", -4},
  {3.3264003140136978231566900e+01, 5, "33264", 2},
  {3.9018058296030271990983585e-15, 9, "", -9},
  {7.3417615589921868800000000e+17, 2, "734176155899218688", 18},
  {1.3055470123403878704437808e-02, 17, "1305547012340388", -1},
  {2.7458137289320722222328186e+07, 7, "274581372893207", 8},
  {4.1719493698169354333537433e-14, 4, "", -4},
  {2.1537168268525420881858657e-12, 10, "", -10},
  {1.5878701469939558235314110e-09, 16, "15878701", -8},
  {2.7811422287706832000000000e+16, 9, "27811422287706832", 17},
  {1.9672036651968612670898438e+09, 1, "19672036652", 10},
  {2.1110153896002043038606644e+06, 2, "211101539", 7},
  {4.0946673120884294509887695e+09, 7, "40946673120884295", 10},
  {1.1088908105063390720000000e+18, 3, "1108890810506339072", 19},
  {5.2377504962476774326329214e-19, 0, "", 0},
  {9.7752835159486273817836367e-12, 18, "9775284", -11},
  {1.3457183768978182525030175e-05, 17, "1345718376898", -4},
  {7.7105607650743793490281253e-10, 4, "", -4},
  {1.5120784569644828824513896e-21, 13, "", -13},
  {7.4610394291574320000000000e+15, 5, "7461039429157432", 16},
  {1.1482653759264032722678395e-05, 14, "1148265376", -4},
  {4.4609518419527053833007812e+09, 14, "446095184195270538330078", 10},
  {1.0490572754168570542163371e-23, 0, "", 0},
  {1.9218289964746518743764098e-08, 3, "", -3},
  {2.7548980785734403946503603e-14, 9, "", -9},
  {3.5948861121557213366031647e+07, 19, "359488611215572133660316467", 8},
  {3.5120607667332659303761574e-07, 18, "351206076673", -6},
  {1.1049886376622744137421250e+04, 19, "110498863766227441374213", 5},
  {2.2054526434663863042970553e-08, 10, "221", -7},
  {6.5522148377485876835635281e+01, 14, "6552214837748588", 2},
  {1.1881674986624412000000000e+16, 19, "11881674986624412", 17},
  {3.9998329114719772338867188e+09, 15, "3999832911471977233886719", 10},
  {3.8765649966813034500960729e-09, 19, "38765649967", -8},
  {6.6092253659409912500000000e+14, 20, "660922536594099125", 15},
  {7.7132833754962591439912687e-16, 18, "771", -15},
  {6.5920730578935690000000000e+15, 11, "6592073057893569", 16},
  {1.9758008116053239175457026e-05, 16, "197580081161", -4},
  {4.9859784930304205177859040e-21, 10, "", -10},
  {6.8024309029376663602306508e+03, 14, "680243090293766636", 4},
  {2.2928056087968478003200000e+20, 6, "229280560879684780032", 21},
  {2.3760489513494774400000000e+17, 16, "237604895134947744", 18},
  {9.0701482000729121093750000e+12, 1, "90701482000729", 13},
  {5.1071596404541121124625931e-21, 17, "", -17},
  {5.3250198875169462500000000e+14, 1, "5325019887516946", 15},
  {1.1243840600330171529678456e-18, 4, "", -4},
  {2.1765195480197719271432145e-20, 14, "", -14},
  {1.2096656300654533566785176e+00, 18, "1209665630065453357", 1},
  {6.5560208381625065202558628e-15, 1, "", -1},
  {1.9834129969172029128474395e-11, 9, "", -9},
  {2.3383857824183126831054688e+11, 12, "233838578241831268310547", 12},
  {1.4887346325475941406250000e+13, 1, "148873463254759", 14},
  {9.6830273576314229710959580e-01, 16, "9683027357631423", 0},
  {1.7285520645854391713645499e-12, 15, "1729", -11},
  {3.2547438851408766982552157e-13, 5, "", -5},
  {7.2141107270511327193298954e-09, 7, "", -7},
  {2.6797451342280153767205775e+04, 8, "2679745134228", 5},
  {2.0785470882546570000000000e+15, 6, "2078547088254657", 16},
  {8.1443481082411776109089595e-17, 16, "1", -15},
  {2.6716816567181855468750000e+12, 0, "2671681656718", 13},
  {8.2053659144902087518858025e+02, 7, "8205365914", 3},
  {6.8085947103125077869593129e-24, 10, "", -10},
  {1.4167191495038576456729422e-24, 6, "", -6},
  {2.9337204482528336427370227e-23, 7, "", -7},
  {5.3766389271520025634765625e+11, 7, "5376638927152002563", 12},
  {2.5474920534577963593088692e-05, 8, "2547", -4},
  {1.3023779327600214728022365e+01, 1, "13", 2},
  {4.4713053390395436213748421e-11, 1, "", -1},
  {1.4358418251045645476856566e-12, 14, "144", -11},
  {6.8942998876123993600000000e+17, 10, "689429988761239936", 18},
  {8.7111104901055856000000000e+16, 6, "87111104901055856", 17},
  {1.6041315310567675515200512e-15, 14, "", -14},
  {6.3294287397164695739746094e+10, 17, "6329428739716469573974609375", 11},
  {9.2862722430958609918401680e-14, 16, "929", -13},
  {6.3380946141905079773554155e-04, 11, "63380946", -3},
  {8.2473855598635717282645112e-07, 1, "", -1},
  {1.3379753588473186030342023e-25, 9, "", -9},
  {2.6548565335096929300056897e-10, 13, "2655", -9},
  {1.2124045055366164862478826e-23, 11, "", -11},
  {7.9113945904863035041809278e-09, 5, "", -5},
  {1.4317959123187730087975822e-12, 10, "", -10},
  {8.5548707130790606606751680e+05, 12, "855487071307906066", 6},
  {4.0433281724336467277680640e+01, 14, "4043328172433647", 2},
  {7.7560452284403140765789431e+01, 13, "775604522844031", 2},
  {5.5304959242459008055686764e-04, 18, "55304959242459", -3},
  {6.0897866549161697280000000e+19, 4, "6089786654916169728", 20},
  {1.8778899384077497553588650e-17, 16, "", -16},
  {2.9929126686862581636405446e-13, 10, "", -10},
  {3.7544414968138327654400000e+20, 15, "375444149681383276544", 21},
  {8.2679795584666395187377930e+09, 7, "82679795584666395", 10},
  {1.0143548251826253128760215e-08, 5, "", -5},
  {9.3010882869877666234970093e+07, 12, "93010882869877666235", 8},
  {2.4140376213430287797681439e-14, 8, "", -8},
  {1.3236712311774797520467860e-09, 13, "13237", -8},
  {2.1318554847728197728244954e-10, 16, "2131855", -9},
  {3.1927731543884751985729054e-01, 3, "319", 0},
  {8.9815576950211696000000000e+16, 15, "89815576950211696", 17},
  {1.1262503690084032394154167e-24, 0, "", 0},
  {1.0794439627417051200000000e+17, 15, "107944396274170512", 18},
  {2.6484838787357944250106812e+08, 11, "2648483878735794425", 9},
  {5.4034354106701357354082128e-18, 10, "", -10},
  {2.9691482448747115927651182e-08, 17, "2969148245", -7},
  {1.8545381451527993051064075e-18, 20, "185", -17},
  {3.4181585969806069652012197e-07, 11, "34182", -6},
  {3.4960182943897439855618359e+00, 20, "349601829438974398556", 1},
  {3.3434423513193102905916021e+01, 20, "3343442351319310290592", 2},
  {1.1222140161899527099452763e-15, 16, "11", -14},
  {1.1062227757363382606939750e-14, 7, "", -7},
  {3.6189596216556712148827056e-10, 5, "", -5},
  {7.4723370310432350379414856e+04, 13, "747233703104323504", 5},
  {6.4180808228737905027126926e-15, 17, "642", -14},
  {3.8667815552487852093684794e-12, 20, "386678156", -11},
  {7.0577666882619750400000000e+17, 0, "705776668826197504", 18},
  {2.1728201652210337048705764e-20, 7, "", -7},
  {5.7470033501214753536993770e-13, 11, "", -11},
  {8.0063129286653862445183096e-13, 10, "", -10},
  {2.4924532295567584224045277e+06, 18, "2492453229556758422404528", 7},
  {3.1553926913003853069429711e-14, 3, "", -3},
  {5.2309304696632995994317965e-08, 16, "523093047", -7},
  {3.1723155226842999026229551e-24, 13, "", -13},
  {6.0885455157477627620218473e-08, 6, "", -6},
  {5.8950009222647950082318857e+03, 16, "58950009222647950082", 4},
  {2.1465451213899729074861562e-06, 10, "21465", -5},
  {2.2128277625109282755744289e-01, 15, "221282776251093", 0},
  {6.7075247229200613219290972e+03, 10, "67075247229201", 4},
  {4.1686977997090508800000000e+17, 8, "416869779970905088", 18},
  {2.4337356107966596679687500e+12, 2, "243373561079666", 13},
  {1.6410595362375390097219516e-21, 14, "", -14},
  {5.4063021988213248000000000e+16, 19, "54063021988213248", 17},
  {4.0486799267322482774034142e+05, 4, "4048679927", 6},
  {6.7583347618288037117688012e-18, 11, "", -11},
  {3.1123067526199999265372753e+06, 16, "31123067526199999265373", 7},
  {5.6398176431039964778726578e-24, 18, "", -18},
  {5.2951248755871569429132251e+00, 0, "5", 1},
  {8.9717272070208012288000000e+19, 13, "89717272070208012288", 20},
  {5.0974748230155179044231772e+04, 20, "5097474823015517904423177", 5},
  {4.3108722694504568703825704e-13, 4, "", -4},
  {1.7346877196074840000000000e+15, 0, "1734687719607484", 16},
  {6.6145846674575890000000000e+15, 4, "6614584667457589", 16},
  {1.4260957454726355675411753e-01, 0, "", 0},
  {8.6275048868894273820101537e-04, 6, "863", -3},
  {7.9143058366678631864488125e+05, 9, "791430583666786", 6},
  {7.2170823959275686192433926e-17, 19, "722", -16},
  {3.4927348481844781250000000e+14, 1, "3492734848184478", 15},
  {3.2479230387030037785489611e-02, 19, "324792303870300378", -1},
  {3.5571410018671905890587952e-23, 9, "", -9},
  {4.4479665730843115703717723e-20, 5, "", -5},
  {7.3266629397703563602526875e-14, 20, "7326663", -13},
  {5.5808806185742735397070646e+05, 6, "558088061857", 6},
  {5.7350997053402745612444551e-17, 17, "6", -16},
  {9.1273724228159539200000000e+18, 6, "912737242281595392", 19},
  {5.3700253506918525090441108e+04, 20, "5370025350691852509044111", 5},
  {2.9477182430026953490327550e-11, 13, "295", -10},
  {7.9163974451913236407563090e+02, 19, "7916397445191323640756", 3},
  {8.1051374056048190686851740e+05, 12, "810513740560481907", 6},
  {1.6582156579082242089950843e-09, 16, "16582157", -8},
  {4.3192895746980556800000000e+17, 19, "431928957469805568", 18},
  {1.4587921442989846691489220e+07, 20, "1458792144298984669148921967", 8},
  {5.6444811081301611328125000e+12, 1, "56444811081302", 13},
  {1.6647637690863688474947452e-13, 16, "1665", -12},
  {2.2093957898682650546054776e-24, 19, "", -19},
  {9.7853223007387626171112061e+08, 5, "97853223007388", 9},
  {1.3266998289777892800000000e+17, 11, "132669982897778928", 18},
  {6.2249864321452134639989916e-17, 9, "", -9},
  {1.4118587001627598023177207e-11, 20, "14118587", -10},
  {2.4521654762138127816867229e-13, 12, "", -12},
  {1.3859863817446371804260103e-18, 13, "", -13},
  {4.2557970603943465000000000e+15, 14, "42557970603943465", 16},
  {1.0224882281310046377576252e-12, 0, "", 0},
  {8.5763142584536947166107268e-02, 12, "85763142585", -1},
  {2.4744850470643207031250000e+13, 14, "2474485047064320703125", 14},
  {9.7124967688179495593721328e-25, 7, "", -7},
  {3.7617230399208401763092351e-13, 2, "", -2},
  {1.7567317854075085000000000e+15, 8, "17567317854075085", 16},
  {2.5678849158509933658933733e+02, 9, "256788491585", 3},
  {2.4546574367289408780123949e-01, 20, "2454657436728940878", 0},
  {1.2071280113488833979646590e-10, 5, "", -5},
  {1.0869676766826391250000000e+15, 2, "108696767668263913", 16},
  {1.5670239141603499379771102e-21, 9, "", -9},
  {2.0382777821558947753906250e+11, 17, "2038277782155894775390625", 12},
  {8.9432641759483222385232534e-20, 17, "", -17},
  {1.1548445625868082320408803e+00, 19, "1154844562586808232", 1},
  {1.2322429418162376242269504e-18, 6, "", -6},
  {4.2205470562737286414046697e-07, 19, "4220547056274", -6},
  {8.6888235003129982948303223e+08, 13, "868882350031299829483", 9},
  {2.4776260265081574487775956e-14, 6, "", -6},
  {1.7371181954573781695216894e+04, 20, "1737118195457378169521689", 5},
  {8.0427928778350233187666163e+03, 1, "80428", 4},
  {2.5966579436349438178253035e-14, 3, "", -3},
  {9.1282930640675249370913358e-04, 10, "9128293", -3},
  {2.3094731332315055624349043e+04, 14, "2309473133231505562", 5},
  {5.1331909479243171215057373e+08, 11, "51331909479243171215", 9},
  {4.6429443821222270882601333e-23, 15, "", -15},
  {5.7907888325871444659473544e-12, 17, "579079", -11},
  {3.0913429859161671251058578e+07, 8, "3091342985916167", 8},
  {4.5554707700279928000000000e+16, 10, "45554707700279928", 17},
  {3.9940687224968507299470704e-12, 4, "", -4},
  {7.4026011621319627031969713e-07, 9, "74", -6},
  {3.4699938171234555664062500e+12, 4, "34699938171234556", 13},
  {4.1868950164109958606830850e-07, 15, "418689502", -6},
  {1.6195960229473273437500000e+13, 0, "16195960229473", 14},
  {5.1629950874541528175780378e-23, 15, "", -15},
  {2.1769092462400943522021074e-05, 6, "22", -4},
  {4.7757185537258642682445497e+01, 13, "477571855372586", 2},
  {5.7910912811223649171443739e-03, 2, "1", -1},
  {9.1366805713961201922017597e-20, 3, "", -3},
  {5.3070408237881241952926814e-02, 2, "5", -1},
  {1.5788657213551164000376868e-25, 5, "", -5},
  {3.3307450024581909179687500e+07, 5, "3330745002458", 8},
  {1.5082904882584784030914307e+09, 12, "1508290488258478403091", 10},
  {9.1036705836724465410400112e-09, 14, "910367", -8},
  {4.4589100803212774811480253e-19, 4, "", -4},
  {1.4229861105597036589060945e-24, 6, "", -6},
  {2.2781853244094549815201844e+00, 14, "227818532440945", 1},
  {8.4987752557452353515625000e+12, 6, "8498775255745235352", 13},
  {1.5447867320857719103032259e-23, 18, "", -18},
  {9.1009929282771296656096016e-04, 14, "91009929283", -3},
  {9.0395559793545599623713064e-14, 5, "", -5},
  {5.8947279992473574250350846e-25, 17, "", -17},
  {5.1672445263117949337600000e+20, 20, "516724452631179493376", 21},
  {1.1501807263397553469985723e+05, 14, "1150180726339755347", 6},
  {1.1777613158606086144000000e+20, 16, "11777613158606086144", 21},
  {2.2114318141162737602857028e-20, 14, "", -14},
  {1.6518634984544192295207351e-10, 5, "", -5},
  {1.2893766092551422038642591e-09, 15, "1289377", -8},
  {6.1977040292128578585106879e+04, 7, "619770402921", 5},
  {9.3917328805884799957275391e+09, 12, "9391732880588479995728", 10},
  {5.5085024147855862763911716e-02, 6, "55085", -1},
  {1.0847692208293832464308894e-14, 3, "", -3},
  {3.7399535374143238543258299e-13, 4, "", -4},
  {1.7995521481538545799719331e-04, 20, "17995521481538546", -3},
  {9.4625506212959842322618442e-02, 9, "94625506", -1},
  {5.4234386034583380000000000e+15, 0, "5423438603458338", 16},
  {1.5386400134719289667373232e+02, 13, "1538640013471929", 3},
  {2.5344360712937396940110895e-09, 17, "253443607", -8},
  {2.6753772989256776781985536e+02, 9, "267537729893", 3},
  {6.4552967919040438182776143e-01, 6, "64553", 0},
  {1.5486435706884529395210848e+02, 8, "15486435707", 3},
  {1.2321590571453554630279541e+09, 12, "1232159057145355463028", 10},
  {2.3449962508676256984472275e+07, 11, "2344996250867625698", 8},
  {1.1726540084410057573904851e+01, 6, "1172654", 2},
  {9.4015014123602011894181420e-09, 6, "", -6},
  {3.6435549639120377833023667e+05, 6, "364355496391", 6},
  {2.8491620465259942244970374e-25, 16, "", -16},
  {1.4861697021530707381067462e-25, 12, "", -12},
  {1.4701986650699098990724423e-02, 5, "147", -1},
  {2.3803354873206332771871963e-20, 20, "2", -19},
  {3.2537457074302297085523605e+07, 4, "325374570743", 8},
  {7.3283710665797906043895202e-16, 17, "73", -15},
  {1.2976076289919794384901326e-25, 7, "", -7},
  {4.5672735394166695312500000e+13, 19, "456727353941666953125", 14},
  {2.6858525140686715815263597e+01, 19, "268585251406867158153", 2},
  {1.0734262283922126562500000e+14, 8, "107342622839221265625", 15},
  {3.1630884765726977991755039e-19, 0, "", 0},
  {2.8422493010547012090682983e+08, 15, "28422493010547012090683", 9},
  {2.3511461922529371947687000e-16, 19, "2351", -15},
  {9.2356229941188285380869695e-11, 11, "9", -10},
  {4.8719230144912422447199959e-15, 15, "5", -14},
  {3.1665247118536049767886602e-10, 15, "316652", -9},
  {5.6929906929950718744261495e-09, 15, "5692991", -8},
  {6.2244574261782940952759209e-07, 12, "622446", -6},
  {3.9816916911249279564799508e+01, 18, "39816916911249279565", 2},
  {1.7704377472423857693651847e-05, 12, "17704377", -4},
  {8.9087161132904081403501045e-14, 16, "891", -13},
  {1.9420435755910444259643555e+08, 18, "194204357559104442596435547", 9},
  {2.3595205569052839853419067e-07, 14, "23595206", -6},
  {1.8568214823472962598316371e+05, 11, "18568214823472963", 6},
  {7.3402941601910263061523438e+10, 4, "734029416019103", 11},
  {1.3072537892075102305966539e+01, 3, "13073", 2},
  {8.1502983847967774523502648e-10, 16, "8150298", -9},
  {3.4238194360659791534717833e-04, 8, "34238", -3},
  {1.4955032446788819170917926e-12, 18, "1495503", -11},
  {1.8922210871182261371359346e+02, 12, "189222108711823", 3},
  {1.2083927175419373866130217e-14, 5, "", -5},
  {1.1956933632957939149659521e-22, 20, "", -20},
  {1.1653021568965139350099857e-20, 0, "", 0},
  {2.7514467591680228710174561e+07, 6, "2751446759168", 8},
  {1.4851534793217409024000000e+20, 2, "14851534793217409024", 21},
  {1.8215538115081770342840173e+01, 4, "182155", 2},
  {4.1897690225000387698184312e-02, 20, "418976902250003877", -1},
  {9.8544327468216647014642717e-02, 1, "1", 0},
  {7.7649399931959062500000000e+12, 13, "776493999319590625", 13},
  {1.3477951405085173262531301e-07, 5, "", -5},
  {1.7111083106171608283637545e-12, 3, "", -3},
  {4.6670811244030494146538789e-21, 14, "", -14},
  {5.5993591813257865607738495e+07, 8, "5599359181325787", 8},
  {9.3739283448943691141484700e-16, 2, "", -2},
  {6.9997938053351536000000000e+16, 14, "69997938053351536", 17},
  {7.6755110667516803741455078e+08, 20, "76755110667516803741455078125", 9},
  {1.4039039518891864327081035e-19, 5, "", -5},
  {1.1180369758021656888136113e-17, 10, "", -10},
  {9.2779480459692102158442140e+04, 6, "9277948046", 5},
  {2.5935942975726632812500000e+13, 5, "2593594297572663281", 14},
  {5.5754862865690935080920099e+00, 2, "558", 1},
  {4.6262456301309880192211214e-17, 5, "", -5},
  {1.5059058757426598302572262e-25, 14, "", -14},
  {3.2002459072346201171875000e+12, 14, "32002459072346201171875", 13},
  {6.1413886859493749216198921e+06, 20, "614138868594937492161989212", 7},
  {1.3123578664037660211873661e-25, 18, "", -18},
  {1.4006101204475887842578873e-06, 8, "14", -5},
  {6.8313489465870193160347536e-22, 3, "", -3},
  {5.8802782517825644258454065e-16, 18, "588", -15},
  {1.4172741592487884765625000e+13, 13, "14172741592487884765625", 14},
  {1.9887242720444444978999326e-25, 12, "", -12},
  {6.9384455238942923024296761e+06, 11, "69384455238942923", 7},
  {4.6868607144216084634535946e+03, 10, "46868607144216", 4},
  {1.4474547660756372500000000e+15, 7, "144745476607563725", 16},
  {1.4065946478405236147380663e-21, 15, "", -15},
  {1.5645363132672436000000000e+16, 0, "15645363132672436", 17},
  {2.7476127393400597572326660e+09, 6, "274761273934006", 10},
  {2.5246990557438974609375000e+12, 9, "2524699055743897460938", 13},
  {3.8768651180403910246400000e+20, 9, "387686511804039102464", 21},
  {5.6077738529647922405274585e+03, 14, "560777385296479224", 4},
  {1.1162655979120410183351590e-10, 7, "", -7},
  {7.6359452196078093750000000e+13, 18, "7635945219607809375", 14},
  {1.9802502546710362828213660e-20, 13, "", -13},
  {4.8441045610711704000000000e+16, 4, "48441045610711704", 17},
  {2.8955437955296380000000000e+16, 7, "2895543795529638", 17},
  {1.6593152935445211791992188e+11, 6, "165931529354452118", 12},
  {4.2747567239249410455488310e-12, 3, "", -3},
  {7.5588143937106687500000000e+13, 5, "755881439371066875", 14},
  {3.0081961000314347520000000e+18, 7, "3008196100031434752", 19},
  {2.2073710577763773587158423e-14, 5, "", -5},
  {2.1785476995537944043543506e-20, 14, "", -14},
  {2.3552690502463006851030514e+04, 14, "2355269050246300685", 5},
  {9.6818130180549900978803635e+06, 7, "9681813018055", 7},
  {1.4867448185331834881914401e-18, 14, "", -14},
  {1.7058646698186543148260258e-05, 8, "1706", -4},
  {2.3709436226670870159460859e-15, 6, "", -6},
  {2.4306524806656150758499280e+04, 8, "2430652480666", 5},
  {6.9676618183512990799973804e-19, 8, "", -8},
  {1.1558928207471136718750000e+13, 12, "1155892820747113671875", 14},
  {6.4827930549907824863984363e-10, 5, "", -5},
  {6.8402456614527732266610269e-24, 1, "", -1},
  {2.2833913800066690820268473e-23, 11, "", -11},
  {1.3706004032654663822879960e-18, 6, "", -6},
  {2.2451354539723135689446838e-13, 1, "", -1},
  {3.6987956826139670940071535e-13, 8, "", -8},
  {3.8660885210843764648437500e+12, 2, "386608852108438", 13},
  {1.3898896618632124023437500e+12, 12, "138988966186321240234375", 13},
  {1.5012170607937034240000000e+19, 18, "1501217060793703424", 20},
  {3.2776930532728455632471086e-21, 15, "", -15},
  {7.9498159547779330750927329e+04, 4, "794981595", 5},
  {1.8742389845931781661954092e-15, 1, "", -1},
  {1.8669208863984569199584199e-21, 2, "", -2},
  {1.6299070960006028153135442e-22, 19, "", -19},
  {1.8603720115800043397099152e-12, 10, "", -10},
  {9.1785169039532215419551278e-06, 0, "", 0},
  {7.6839904165177472000000000e+17, 19, "76839904165177472", 18},
  {2.6556787537224439965655165e+00, 0, "3", 1},
  {2.3743115202061895741003639e-01, 3, "237", 0},
  {4.7389642278847385337137155e-02, 2, "5", -1},
  {1.0149952637716506617659995e-02, 5, "1015", -1},
  {4.0200490512502747587859631e+06, 16, "4020049051250274758786", 7},
  {1.9614762938124812500000000e+15, 20, "196147629381248125", 16},
  {7.3312683067457887500000000e+14, 1, "7331268306745789", 15},
  {5.0514302498366760253906250e+10, 2, "5051430249837", 11},
  {8.1441981006710604819508285e-09, 7, "", -7},
  {9.8465043308867893437288981e-25, 18, "", -18},
  {3.3175328694115202576853108e-01, 16, "331753286941152", 0},
  {1.3200893473553135137876779e+01, 6, "13200893", 2},
  {2.1579584180638192230181740e-10, 5, "", -5},
  {1.0280865715363756103515625e+12, 8, "102808657153637561035", 13},
  {1.1610157921160711481832047e-14, 14, "1", -13},
  {3.2842315397820794487968057e-09, 11, "328", -8},
  {3.8272696331864607351698861e-08, 7, "", -7},
  {1.1162018649762285873293877e+07, 9, "11162018649762286", 8},
  {5.2599036220100997015833855e+06, 16, "52599036220100997015834", 7},
  {2.1647884541081478814051159e-15, 10, "", -10},
  {1.2733019575812478148227600e-20, 0, "", 0},
  {6.1295752977626109123229980e+08, 11, "61295752977626109123", 9},
  {3.9632843698619709890684781e-03, 11, "396328437", -2},
  {2.1333610435167896492497830e-21, 4, "", -4},
  {2.5567775466213433593750000e+13, 1, "255677754662134", 14},
  {8.8040436755020572979638161e-25, 10, "", -10},
  {9.3429931537583446502685547e+08, 1, "9342993154", 9},
  {1.5887881173090105056762695e+09, 19, "15887881173090105056762695313", 10},
  {2.0341056725704312500000000e+15, 19, "203410567257043125", 16},
  {8.8019736420194217099602607e-09, 5, "", -5},
  {1.0226754875231781687271523e-07, 19, "1022675487523", -6},
  {8.7218008336687740000000000e+15, 15, "8721800833668774", 16},
  {8.3101393427719050000000000e+15, 13, "8310139342771905", 16},
  {1.3421121513737062400000000e+17, 0, "134211215137370624", 18},
  {4.7344768909517564956606406e-13, 16, "4734", -12},
  {3.6606792855663475036621094e+10, 19, "3660679285566347503662109375", 11},
  {4.5018368329451949674813171e-03, 0, "", 0},
  {6.1188054493888354045338929e+04, 5, "6118805449", 5},
  {7.7063958504541818442354423e-15, 8, "", -8},
  {1.4626664786672273408000000e+19, 15, "14626664786672273408", 20},
  {1.5696261716893004631856456e+04, 9, "15696261716893", 5},
  {2.0210333909442588980224163e-20, 11, "", -11},
  {1.3001407030724948800000000e+17, 4, "130014070307249488", 18},
  {2.4739574726680228000000000e+16, 13, "24739574726680228", 17},
  {2.9735814756678908000000000e+16, 11, "29735814756678908", 17},
  {9.7623924762673359509790316e+03, 9, "9762392476267", 4},
  {9.4236943008713199313945386e-12, 17, "942369", -11},
  {9.0165727722306656090415491e-07, 9, "902", -6},
  {2.3332198815774500208486408e-03, 9, "233322", -2},
  {1.5830111798889751932443760e-17, 14, "", -14},
  {5.2631815629989577214953907e-07, 2, "", -2},
  {1.0759976910790482812500000e+14, 13, "107599769107904828125", 15},
  {7.9509573455797022720000000e+18, 16, "7950957345579702272", 19},
  {1.5194678038667924525338228e-15, 4, "", -4},
  {4.0815689148784306598827243e+05, 9, "408156891487843", 6},
  {5.6838768711238745675838784e-11, 3, "", -3},
  {1.0430632856970049715528148e+01, 10, "10430632857", 2},
  {3.1123031285232881664000000e+19, 2, "31123031285232881664", 20},
  {1.0645700245590202227918239e-18, 5, "", -5},
  {5.8642322770403861893596103e-15, 12, "", -12},
  {9.9957077134793757977604400e+02, 11, "99957077134794", 3},
  {1.3588534797739460630028319e-02, 6, "13589", -1},
  {5.3025769533227221108973026e+05, 0, "530258", 6},
  {2.2127187727444725760000000e+19, 10, "2212718772744472576", 20},
  {1.8709705123329680000000000e+15, 13, "1870970512332968", 16},
  {1.5199346889026423916220665e+07, 18, "15199346889026423916220665", 8},
  {2.2744616851857139004339443e-24, 4, "", -4},
  {1.4314858252837515264000000e+19, 5, "14314858252837515264", 20},
  {6.0872264663091262259200000e+20, 7, "608722646630912622592", 21},
  {1.6199388040635980701154040e+02, 3, "161994", 3},
  {3.6722852885237990697047675e-19, 15, "", -15},
  {5.7418244590960480000000000e+16, 0, "5741824459096048", 17},
  {2.1427181382282851263880730e+06, 2, "214271814", 7},
  {4.8937331609807071481564429e-11, 9, "", -9},
  {2.5969728368438850000000000e+14, 13, "2596972836843885", 15},
  {2.6622778734790812500000000e+13, 14, "266227787347908125", 14},
  {2.3817711142797949835921243e-07, 4, "", -4},
  {1.6817211052537356567382812e+11, 7, "1681721105253735657", 12},
  {8.6735902191369240576000000e+19, 0, "86735902191369240576", 20},
  {7.6439674239356222367384804e-15, 18, "7644", -14},
  {5.1275889842032840171270891e-01, 0, "1", 1},
  {4.6581319906784852767685375e-07, 2, "", -2},
  {1.4266813634892492700600997e+04, 0, "14267", 5},
  {4.3324853149563219830982668e-23, 5, "", -5},
  {8.2009693540437648425584991e-08, 16, "820096935", -7},
  {1.1103759457104429244995117e+10, 15, "11103759457104429244995117", 11},
  {8.9462872363474345563243014e-25, 4, "", -4},
  {3.5892378035120607648877922e+01, 7, "35892378", 2},
  {1.6448452247407881583164159e-10, 12, "164", -9},
  {2.9736895772352534192145405e-18, 3, "", -3},
  {1.7763683565410997970493704e-22, 6, "", -6},
  {4.1576737907001577463189867e-19, 8, "", -8},
  {4.3756017837257050781250000e+12, 20, "4375601783725705078125", 13},
  {1.1452744291827007337329674e-24, 7, "", -7},
  {7.2084458211830924954478557e-10, 12, "721", -9},
  {8.6526773485758068847656250e+11, 19, "8652677348575806884765625", 12},
  {1.5571583284925952500000000e+15, 7, "155715832849259525", 16},
  {1.1247878079413196178958090e-04, 2, "", -2},
  {5.7714917741093813674524426e+03, 15, "5771491774109381367", 4},
  {4.7108812914665915139167396e-01, 14, "47108812914666", 0},
  {1.1024809353156456448000000e+19, 0, "11024809353156456448", 20},
  {1.7285726129314521131163929e+03, 8, "172857261293", 4},
  {3.3244966696196823613718152e+05, 19, "3324496669619682361371815", 6},
  {4.4188529923152117919921875e+11, 20, "44188529923152117919921875", 12},
  {4.5672224718054867494698778e-17, 17, "5", -16},
  {4.9489917613783614387567528e-20, 13, "", -13},
  {5.8554164496084197476748874e-16, 12, "", -12},
  {5.8279859477545400320000000e+18, 2, "5827985947754540032", 19},
  {1.9816373463415335863828659e+06, 13, "19816373463415335864", 7},
  {1.1385413809846479344954547e-07, 3, "", -3},
  {1.6376853497181931403605202e-17, 7, "", -7},
  {3.5734879386533792130649090e+06, 11, "357348793865337921", 7},
  {4.5814596241184102609622641e+02, 5, "45814596", 3},
  {3.2745063283798912500000000e+14, 16, "327450632837989125", 15},
  {2.2261754249350687584474429e-01, 7, "2226175", 0},
  {9.4856631096046851325809257e+02, 7, "948566311", 3},
  {9.5237037630263040000000000e+17, 6, "9523703763026304", 18},
  {1.5816035015129489472444612e-08, 16, "15816035", -7},
  {1.6082732961443390697240829e+07, 14, "1608273296144339069724", 8},
  {1.9104120401392209362851640e-07, 7, "2", -6},
  {2.1464626839534810351577081e-15, 17, "215", -14},
  {2.6561316000409191171024656e-05, 16, "265613160004", -4},
  {5.9558684874537422028800000e+20, 6, "595586848745374220288", 21},
  {2.6267823111934957513167916e-13, 9, "", -9},
  {2.0188129295524532224000000e+19, 3, "20188129295524532224", 20},
  {3.2015672444113172429491689e-06, 10, "32016", -5},
  {5.3777369823954860330608383e-16, 17, "54", -15},
  {5.1989437846341120000000000e+18, 6, "5198943784634112", 19},
  {4.4748211776018092576223499e-07, 10, "4475", -6},
  {3.0301258311981727649037840e-09, 6, "", -6},
  {2.9262418918105858808842434e-03, 17, "292624189181059", -2},
  {6.2587419883446561554710900e-24, 1, "", -1},
  {1.7947081068809219661200696e-12, 12, "2", -11},
  {9.1237885553307051622400000e+20, 15, "912378855533070516224", 21},
  {4.0988885828033499427564042e-17, 17, "4", -16},
  {6.6071665555466842651367188e+08, 17, "66071665555466842651367188", 9},
  {5.1562019246889898437500000e+13, 9, "515620192468898984375", 14},
  {4.9439822811594603990670294e+04, 19, "494398228115946039906703", 5},
  {1.2488705244893642562019208e-09, 1, "", -1},
  {6.4793368639893718063831329e+07, 5, "6479336863989", 8},
  {1.2443672197855056000000000e+16, 5, "12443672197855056", 17},
  {2.6252705102951472326822113e+03, 9, "2625270510295", 4},
  {4.1472877112095076881814748e+04, 6, "41472877112", 5},
  {6.6897388387060172930348686e-25, 4, "", -4},
  {1.5417614168204347606661031e+03, 11, "154176141682043", 4},
  {1.3339742988620174097805322e-10, 11, "13", -9},
  {4.4498392686956276520504616e+02, 17, "44498392686956276521", 3},
  {5.1540611119946937600000000e+17, 9, "515406111199469376", 18},
  {6.1825315929031318086681449e-10, 15, "618253", -9},
  {1.6287720305450757000370020e-22, 2, "", -2},
  {3.5283700742930768799961226e-08, 12, "35284", -7},
  {1.1266125836200100000000000e+15, 2, "112661258362001", 16},
  {3.0545081927760732173919678e+08, 20, "30545081927760732173919677734", 9},
  {4.4854967836444150727759273e-14, 13, "", -13},
  {1.6038130094526408294400000e+20, 17, "160381300945264082944", 21},
  {2.8998383564674350000000000e+14, 13, "2899838356467435", 15},
  {1.1305387165603260346546932e-01, 20, "11305387165603260347", 0},
  {1.1524952416576327232178301e+05, 7, "1152495241658", 6},
  {2.4944779636231893281170273e-23, 17, "", -17},
  {1.9256868681805361376291330e-01, 14, "19256868681805", 0},
  {6.3740810823200062529281240e+00, 13, "637408108232", 1},
  {1.5110844525007358779555844e-02, 19, "151108445250073588", -1},
  {1.8783923631563737354184025e-25, 16, "", -16},
  {1.1488856050990690710023046e+05, 2, "11488856", 6},
  {2.4814287335865665088766895e-19, 10, "", -10},
  {1.2686360677392823143881858e-21, 8, "", -8},
  {2.0251642710549209827515893e-24, 2, "", -2},
  {1.0972281171308837510736112e+00, 12, "1097228117131", 1},
  {6.4573274955585675264000000e+19, 16, "64573274955585675264", 20},
  {1.1735279989276570267975330e+05, 14, "11735279989276570268", 6},
  {1.5770666573210195272983529e-06, 5, "", -5},
  {7.3771346948202919960021973e+08, 1, "7377134695", 9},
  {5.0789824700235668569803238e+06, 2, "507898247", 7},
  {1.6066526445654621966241393e+03, 17, "160665264456546219662", 4},
  {5.8679834105087394714355469e+09, 1, "58679834105", 10},
  {1.1775513992702586364746094e+11, 15, "117755139927025863647460938", 12},
  {2.9470073472194052756189112e-18, 2, "", -2},
  {9.4230308222892350229187292e-11, 7, "", -7},
  {6.0186949700962450000000000e+15, 4, "6018694970096245", 16},
  {8.2233833459058047754552945e-01, 15, "82233833459058", 0},
  {4.3507683827866475145818015e-03, 10, "43507684", -2},
  {5.2039498478292998553600000e+20, 13, "520394984782929985536", 21},
  {1.5368436920063862846652647e-02, 19, "153684369200638628", -1},
  {5.7171911089628078125000000e+13, 9, "57171911089628078125", 14},
  {1.9111463325771924575509006e-05, 6, "19", -4},
  {1.1226956235352230000000000e+16, 19, "1122695623535223", 17},
  {4.2546048894043744000000000e+16, 1, "42546048894043744", 17},
  {1.9225667169493031232387873e-19, 6, "", -6},
  {1.2416278938057132977772358e-24, 4, "", -4},
  {2.0013659637665544047055719e-23, 0, "", 0},
  {1.2522701515103930916801350e-21, 6, "", -6},
  {3.1723949395906480079179992e-16, 3, "", -3},
  {6.8255851032967705600000000e+17, 19, "682558510329677056", 18},
  {5.1970869952793936896728866e-02, 10, "5197087", -1},
  {4.0555070353968823357315721e-03, 13, "40555070354", -2},
  {1.8323374213588848522449713e-09, 9, "2", -8},
  {9.9901414314568015129225387e+01, 20, "9990141431456801512923", 2},
  {9.1044233928760479725811794e-12, 14, "91", -11},
  {4.3073890954766171875000000e+13, 19, "43073890954766171875", 14},
  {1.4864914908590223241446893e+00, 10, "14864914909", 1},
  {4.8328328479473205553086753e-17, 9, "", -9},
  {2.2959554482672842823376413e+01, 0, "23", 2},
  {7.1317949209954701347390015e-14, 18, "71318", -13},
  {3.3693710419208684925251873e+02, 20, "33693710419208684925252", 3},
  {3.1841457802895451895892620e+06, 14, "318414578028954518959", 7},
  {5.0062227297734240849536036e-01, 2, "5", 0},
  {4.5001580068468456374830566e+02, 9, "450015800685", 3},
  {1.2396777849323967529926449e+05, 7, "1239677784932", 6},
  {6.3748396011881601962586095e-17, 8, "", -8},
  {9.8417125558137440681457520e+08, 13, "9841712555813744068146", 9},
  {3.6833354288903950792162523e-05, 8, "3683", -4},
  {6.3960242674195587824215181e+03, 16, "63960242674195587824", 4},
  {9.6051550474200340316160984e-04, 9, "960516", -3},
  {6.2912590869003393554687500e+11, 11, "62912590869003393554688", 12},
  {4.6734332268890213012695312e+10, 6, "46734332268890213", 11},
  {5.9663828807215270996093750e+09, 9, "59663828807215271", 10},
  {1.7299510157360707793298428e-15, 1, "", -1},
  {3.1906434182565235137939453e+10, 20, "31906434182565235137939453125", 11},
  {7.8484500077827797187804212e-25, 14, "", -14},
  {1.2585236688087058628760590e-12, 13, "13", -11},
  {1.4753794858421324800000000e+18, 0, "147537948584213248", 19},
  {7.5480563025054334629717645e-20, 5, "", -5},
  {1.9980158853093031585651907e-23, 10, "", -10},
  {2.6606128995117303125000000e+14, 5, "26606128995117303125", 15},
  {1.3511721670843888013580607e-17, 8, "", -8},
  {2.4832974137080177451721552e-21, 13, "", -13},
  {2.9133168597856396809220314e+05, 1, "2913317", 6},
  {6.1998537563254328028770383e-14, 5, "", -5},
  {1.0885643835615585160052130e-16, 14, "", -14},
  {6.8508602102112483578366664e+00, 4, "68509", 1},
  {1.7746534770173145716398722e+03, 12, "1774653477017315", 4},
  {2.4647020511193201570343657e-20, 13, "", -13},
  {1.1231542684114822400000000e+18, 8, "112315426841148224", 19},
  {2.8461184800940930274473254e-15, 14, "", -14},
  {5.4095891458193712896176462e-14, 17, "541", -13},
  {3.6480103524771231288813880e-13, 2, "", -2},
  {8.7131955955120727542057481e-16, 14, "", -14},
  {8.1598632995442009059222939e-25, 18, "", -18},
  {2.1053402464608641024000000e+19, 17, "21053402464608641024", 20},
  {4.4027649361618884277343750e+11, 4, "4402764936161888", 12},
  {6.2071012946839327923953533e+04, 13, "620710129468393279", 5},
  {3.2345615360273027420043945e+08, 4, "3234561536027", 9},
  {1.2340713525110145565122366e+05, 5, "12340713525", 6},
  {6.1646788738752750878434512e-06, 15, "6164678874", -5},
  {7.4260859524215852236800000e+20, 20, "742608595242158522368", 21},
  {4.8316986701947502213030927e-04, 16, "4831698670195", -3},
  {1.6844678886569992000000000e+16, 0, "16844678886569992", 17},
  {6.7750141346364364624023438e+09, 14, "677501413463643646240234", 10},
  {2.9878752049378906097772446e-24, 12, "", -12},
  {1.2935023528349601280000000e+18, 7, "1293502352834960128", 19},
  {3.8303011363947204948181232e-12, 20, "383030114", -11},
  {2.0486641082268344872652451e-22, 15, "", -15},
  {7.2148167892730485126494063e-20, 16, "", -16},
  {1.2084483442435217881438803e+01, 6, "12084483", 2},
  {1.0080728531500665664672852e+10, 14, "1008072853150066566467285", 11},
  {4.3912837101092779564333714e-12, 12, "4", -11},
  {8.5153186736376582643970323e+00, 6, "8515319", 1},
  {1.5331143814163190167040661e-25, 5, "", -5},
  {8.1738601183649718761444092e+07, 18, "81738601183649718761444092", 8},
  {6.0784837322298394982158230e-20, 6, "", -6},
  {1.0416443239096279613364436e-21, 12, "", -12},
  {2.7251290456525855064392090e+09, 6, "2725129045652586", 10},
  {1.4846650668348693216103129e+03, 16, "14846650668348693216", 4},
  {1.9863160817998433826414077e-24, 17, "", -17},
  {3.5488866061238791255804435e-21, 13, "", -13},
  {1.2712476062298858000000000e+16, 17, "12712476062298858", 17},
  {2.6946249647699999397990148e-24, 12, "", -12},
  {1.1024631415088777725079329e-23, 10, "", -10},
  {2.2029225650573647581040859e+06, 19, "22029225650573647581040859", 7},
  {4.1926362245044187600179096e-15, 18, "4193", -14},
  {1.8807676360555126768122707e-16, 2, "", -2},
  {5.4613845926128052155443016e-08, 20, "5461384592613", -7},
  {4.9599441758684786117055782e-25, 10, "", -10},
  {1.0956633913693863680000000e+18, 6, "1095663391369386368", 19},
  {2.0394907607051520996093750e+12, 3, "2039490760705152", 13},
  {4.3152726153859520000000000e+15, 9, "4315272615385952", 16},
  {4.7116735919363775253295898e+09, 10, "47116735919363775253", 10},
  {1.2220615102108627319335938e+10, 15, "12220615102108627319335938", 11},
  {3.0666505851934748026668615e-18, 3, "", -3},
  {4.9196267899095505386472024e-22, 0, "", 0},
  {1.6260527973547241600000000e+17, 0, "162605279735472416", 18},
  {1.1202376435469258170082860e-20, 13, "", -13},
  {1.9712225755207121009014715e-05, 14, "1971222576", -4},
  {1.2643057600744368000000000e+16, 17, "12643057600744368", 17},
  {2.0238094178346356201171875e+11, 0, "202380941783", 12},
  {5.1872406514901712171194959e+01, 3, "51872", 2},
  {2.1229066773888800000000000e+14, 17, "212290667738888", 15},
  {1.9235167653148948075741904e-17, 6, "", -6},
  {1.5866100996054704808102542e+01, 8, "15866101", 2},
  {2.1279192801757780714452600e-07, 2, "", -2},
  {5.4894390084589801025390625e+11, 13, "5489439008458980102539063", 12},
  {4.0040273364969750976562500e+12, 4, "40040273364969751", 13},
  {5.3301742380015135213660361e-10, 19, "5330174238", -9},
  {3.9122855466309375000000000e+11, 5, "39122855466309375", 12},
  {6.9322233365664609375000000e+12, 2, "693222333656646", 13},
  {3.1591872649263596534729004e+09, 3, "3159187264926", 10},
  {1.2011256638595515119059560e-06, 18, "120112566386", -5},
  {3.8236450700580338919049028e-04, 9, "382365", -3},
  {1.5540448129458321408000000e+19, 9, "15540448129458321408", 20},
  {4.0469469496956087084527098e+01, 13, "404694694969561", 2},
  {1.4036240359858133025293608e-21, 8, "", -8},
  {5.5042900846070046720000000e+19, 17, "5504290084607004672", 20},
  {1.8877769114443083771577033e-23, 12, "", -12},
  {8.5685404195484688000000000e+16, 17, "85685404195484688", 17},
  {4.1235975640795984691200000e+20, 9, "412359756407959846912", 21},
  {9.1273840034119154060832817e-15, 16, "91", -14},
  {5.0472828681321969727475577e-13, 11, "", -11},
  {7.3778717345307983398437500e+10, 6, "73778717345307983", 11},
  {8.1736857995882736206054688e+10, 13, "817368579958827362060547", 11},
  {1.2862414211575945588981169e-17, 7, "", -7},
  {5.5253097527053396333940327e+04, 4, "552530975", 5},
  {4.7562104151303116259026128e-11, 12, "48", -10},
  {4.2299527032994559558971560e-12, 5, "", -5},
  {1.3568447377191054838835305e-04, 2, "", -2},
  {5.6550646915719051912391361e-11, 2, "", -2},
  {1.6259462065256512165069580e+08, 20, "16259462065256512165069580078", 9},
  {1.3921077540759821844127403e-24, 17, "", -17},
  {4.7549618601669867769828990e-10, 17, "47549619", -9},
  {1.1740744350527917480468750e+11, 2, "11740744350528", 12},
  {7.2457455784810084286836577e-14, 11, "", -11},
  {2.5648752993175407688397627e+00, 2, "256", 1},
  {4.8235633052242534163334985e-12, 4, "", -4},
  {6.2129785586127908900380135e+06, 6, "6212978558613", 7},
  {3.4909667597677828426106056e-22, 17, "", -17},
  {1.7833978062657700820947269e-09, 5, "", -5},
  {1.4042601476917396000000000e+16, 7, "14042601476917396", 17},
  {2.4498826142669777254923247e+03, 15, "2449882614266977725", 4},
  {1.1195978416326566040515900e+08, 11, "11195978416326566041", 9},
  {3.5738902433818352488754052e-11, 20, "3573890243", -10},
  {1.4425407167520742559164559e-06, 1, "", -1},
  {2.6146542701295495680913206e-02, 14, "261465427013", -1},
  {5.0623886831211642950702450e-08, 16, "506238868", -7},
  {4.3381056993311446136232616e-07, 15, "43381057", -6},
  {5.0993541547195064000000000e+16, 2, "50993541547195064", 17},
  {5.8595422642967660067370161e+03, 14, "585954226429676601", 4},
  {2.2298955712874470691531315e+02, 20, "22298955712874470691531", 3},
  {3.0495852793849693245717011e-21, 19, "", -19},
  {5.5736089837518666397029460e-06, 19, "55736089837519", -5},
  {4.7544856344444050917706190e-12, 12, "5", -11},
  {8.0678535556181325912475586e+09, 2, "806785355562", 10},
  {4.1511301884042318147469858e-18, 20, "415", -17},
  {1.2616911500371898569028417e+02, 8, "126169115", 3},
  {2.0661426687328732299804688e+11, 18, "206614266873287322998046875", 12},
  {3.6674072089709153221548377e-01, 14, "36674072089709", 0},
  {7.0068838876341022793570179e-04, 0, "", 0},
  {2.4347745899555722656250000e+13, 3, "24347745899555723", 14},
  {4.4331427475743461772188303e-18, 5, "", -5},
  {2.2606335016437595353266943e-01, 20, "22606335016437595353", 0},
  {2.1190074156220065502588308e-20, 14, "", -14},
  {1.0647273042621474123792880e-14, 9, "", -9},
  {7.6018162816938424671128784e-14, 7, "", -7},
  {8.7815726271115414732800000e+20, 14, "878157262711154147328", 21},
  {9.9301233070971097600000000e+17, 9, "993012330709710976", 18},
  {8.8178879115784634168162115e-20, 10, "", -10},
  {2.5703927108277380703790120e-18, 17, "", -17},
  {1.7657502340114091520000000e+18, 1, "1765750234011409152", 19},
  {7.3847826094029438976000000e+19, 8, "73847826094029438976", 20},
  {1.8002508717350415579083744e-01, 6, "180025", 0},
  {9.5347236633172449961248405e-09, 5, "", -5},
  {8.2045860328006074979612094e+00, 2, "82", 1},
  {1.3730331324954749261832670e-07, 11, "1373", -6},
  {1.2926879201603631130979011e+01, 3, "12927", 2},
  {1.0701410286229667968750000e+13, 20, "1070141028622966796875", 14},
  {3.0739369238156094357853390e-16, 20, "30739", -15},
  {1.8333157767128834537556919e-07, 20, "18333157767129", -6},
  {1.2887309790831481901701716e-03, 0, "", 0},
  {8.8554905967204240369028412e+02, 5, "88554906", 3},
  {5.0831682538502448795564935e-12, 16, "50832", -11},
  {4.3139407518372974770338944e-23, 12, "", -12},
  {5.1844710666185114218878602e-21, 3, "", -3},
  {6.4141904168947937432676554e+05, 4, "6414190417", 6},
  {3.8951693165878904085220512e-08, 14, "3895169", -7},
  {2.2301770954397428000000000e+16, 7, "22301770954397428", 17},
  {7.0333778189410212089427432e-01, 18, "703337781894102121", 0},
  {4.2709566878890376539137090e-19, 12, "", -12},
  {2.6043367000297052569600000e+20, 14, "260433670002970525696", 21},
  {1.7676028161616178652204567e-02, 9, "17676028", -1},
  {7.5731204549415730931864570e-06, 3, "", -3},
  {1.2519612801793166883505819e-17, 16, "", -16},
  {1.6252603605640609748661518e+06, 11, "162526036056406097", 7},
  {1.8452752473583334765806774e-04, 10, "1845275", -3},
  {7.1303149001995641225799169e-23, 7, "", -7},
  {3.6157274336781411450125745e-03, 12, "3615727434", -2},
  {9.4979561935076651479903376e+02, 14, "94979561935076651", 3},
  {1.4221955466438941959434888e-19, 11, "", -11},
  {1.4361043897661888671875000e+13, 11, "14361043897661888671875", 14},
  {3.7203963467877339236396168e-17, 9, "", -9},
  {1.6515830245997902343750000e+13, 15, "1651583024599790234375", 14},
  {6.3507327801857197841079959e-21, 17, "", -17},
  {3.6574090804959126903153047e-09, 1, "", -1},
  {1.5520235056346991821564849e-10, 11, "16", -9},
  {8.5815824954204135151875558e-11, 6, "", -6},
  {2.1126128250583352041758189e+02, 1, "2113", 3},
  {9.4374627892944426619907528e-05, 16, "943746278929", -4},
  {6.2708149745444917374292479e-21, 17, "", -17},
  {9.9027124578356197252996841e-19, 8, "", -8},
  {2.5543021695224567501740299e-09, 14, "25543", -8},
  {2.8311853872885785511661619e-13, 7, "", -7},
  {1.6313392722156866181152334e-07, 19, "1631339272216", -6},
  {1.0545786746610655212402344e+11, 11, "10545786746610655212402", 12},
  {3.6364326849536545341834426e+05, 2, "36364327", 6},
  {1.5638499436346471309661865e+09, 10, "1563849943634647131", 10},
  {1.1304252159201454033896767e-04, 20, "11304252159201454", -3},
  {1.3847526921976490381803804e-12, 11, "", -11},
  {2.2500211133943305647961940e-06, 20, "225002111339433", -5},
  {3.1794548209904465000000000e+15, 4, "31794548209904465", 16},
  {1.3310962271372365689049244e-07, 19, "1331096227137", -6},
  {6.6663873040667059831321239e+05, 20, "66663873040667059831321239", 6},
  {3.1550798485936185898026451e+04, 16, "31550798485936185898", 5},
  {1.8504287851285068800000000e+17, 9, "185042878512850688", 18},
  {2.0045254887546942734743993e-01, 15, "200452548875469", 0},
  {3.9383872290107865410391241e+03, 12, "3938387229010787", 4},
  {6.3700710396996554879695286e-14, 0, "", 0},
  {1.3288569996475881250000000e+14, 7, "1328856999647588125", 15},
  {7.0790815481488600450011615e-24, 2, "", -2},
  {7.2237195364910047501325607e+06, 14, "722371953649100475013", 7},
  {6.4372268419351253509521484e+09, 16, "64372268419351253509521484", 10},
  {3.8171488834203402240000000e+19, 8, "3817148883420340224", 20},
  {2.5974080285491948015987873e+06, 8, "259740802854919", 7},
  {2.3400622802905467987060547e+10, 4, "234006228029055", 11},
  {2.8767612099619184320195789e-20, 2, "", -2},
  {1.1626451420333038000000000e+16, 8, "11626451420333038", 17},
  {5.1789668698699586391694407e-16, 19, "5179", -15},
  {5.3946237012012773437500000e+12, 8, "539462370120127734375", 13},
  {7.1051342207745126845196052e-14, 13, "1", -12},
  {2.4605110513933309816478422e-10, 7, "", -7},
  {1.5983719591145750448918397e-15, 16, "16", -14},
  {5.5512933245854820251464844e+10, 11, "5551293324585482025146", 11},
  {5.6383976471352548599243164e+09, 0, "5638397647", 10},
  {4.4220998330525302932869636e+00, 5, "44221", 1},
  {5.9247565295074888137605279e-12, 14, "592", -11},
  {9.8041756337838091894809622e+02, 1, "9804", 3},
  {3.2928793573353153188067061e-16, 16, "3", -15},
  {1.5320177859712386453463368e-23, 5, "", -5},
  {1.0057932395499026000000000e+16, 3, "10057932395499026", 17},
  {8.2639721264193836860589143e-06, 16, "82639721264", -5},
  {7.5896656973965990400000000e+17, 0, "758966569739659904", 18},
  {1.8049215330847853772800000e+20, 6, "180492153308478537728", 21},
  {1.0237867120528889094896429e-11, 13, "102", -10},
  {2.8519051983003496265041996e-18, 0, "", 0},
  {6.4442685639299090408612649e-21, 20, "1", -19},
  {5.9760553740462754035434045e+01, 3, "59761", 2},
  {1.4026732530409305789489901e-16, 1, "", -1},
  {4.3930822265727293440000000e+18, 6, "4393082226572729344", 19},
  {5.1693609525211347512742658e-09, 13, "51694", -8},
  {1.0058517336765225369600000e+20, 4, "100585173367652253696", 21},
  {4.8956243761448089599609375e+11, 18, "48956243761448089599609375", 12},
  {2.0401856878038240000000000e+17, 7, "2040185687803824", 18},
  {5.8673640058308141056000000e+19, 16, "58673640058308141056", 20},
  {2.2001170644905996288000000e+19, 10, "22001170644905996288", 20},
  {3.2531829760848766343098681e-12, 6, "", -6},
  {2.3491128356391946851999819e+01, 4, "234911", 2},
  {5.0719992760687204696640796e-23, 9, "", -9},
  {9.0023208058095485945486618e-11, 2, "", -2},
  {2.2044000925979145090982490e-14, 0, "", 0},
  {4.5500858671839673374352309e-24, 17, "", -17},
  {4.8753151489065458073600000e+20, 0, "487531514890654580736", 21},
  {1.5470585062415660490675457e-11, 4, "", -4},
  {7.4466016589329897139076450e-06, 14, "744660166", -5},
  {3.6825464016619913280010223e+07, 19, "368254640166199132800102234", 8},
  {1.0377323336918678896848453e-09, 15, "1037732", -8},
  {1.2335752608878943271169645e-13, 14, "12", -12},
  {5.8913568875043182515582885e+01, 20, "5891356887504318251558", 2},
  {1.2036723634296875424318974e-10, 14, "12037", -9},
  {5.7926074450623326825022402e-05, 14, "5792607445", -4},
  {6.6416958333348974609375000e+12, 16, "66416958333348974609375", 13},
  {3.9341608085588701982003741e-11, 0, "", 0},
  {1.3959293371286746829580681e-20, 7, "", -7},
  {1.4209085718287175402038988e-15, 9, "", -9},
  {1.6071336647675468767282325e-01, 16, "1607133664767547", 0},
  {7.9192622778696358203887939e+08, 16, "7919262277869635820388794", 9},
  {1.6480275133083414400000000e+17, 18, "164802751330834144", 18},
  {1.7989656845038563840000000e+18, 15, "1798965684503856384", 19},
  {2.3522857034009687500000000e+12, 7, "235228570340096875", 13},
  {1.7493388373379812622070312e+11, 17, "174933883733798126220703125", 12},
  {3.5342119151766760000000000e+16, 14, "3534211915176676", 17},
  {1.2547518760024716755197005e+02, 4, "1254752", 3},
  {5.2083706687392616000000000e+16, 11, "52083706687392616", 17},
  {6.3765641730025134980678558e+07, 9, "63765641730025135", 8},
  {2.7379924116941305756401122e-08, 15, "27379924", -7},
  {1.0404095881510988772338712e-13, 1, "", -1},
  {1.1622389139050994140625000e+13, 6, "11622389139050994141", 14},
  {8.2501797634956016000000000e+16, 12, "82501797634956016", 17},
  {2.5821974171977477573744573e-07, 20, "25821974171977", -6},
  {1.7283092206916440503693309e-08, 4, "", -4},
  {8.0526505769359186291694641e+07, 12, "80526505769359186292", 8},
  {2.5479042419692492675781250e+11, 11, "25479042419692492675781", 12},
  {4.0227380092295799108804064e-14, 1, "", -1},
  {5.1579732045354109715162849e-01, 8, "51579732", 0},
  {1.8513878026501513600000000e+17, 7, "185138780265015136", 18},
  {4.2065647560660966400000000e+17, 4, "420656475606609664", 18},
  {6.3005408653622880000000000e+15, 12, "6300540865362288", 16},
  {4.1653058849252098949644818e-02, 9, "41653059", -1},
  {4.8850995783591065581117572e-20, 5, "", -5},
  {1.0485023771007753600000000e+17, 20, "104850237710077536", 18},
  {6.1181201728024241504044767e+00, 6, "611812", 1},
  {6.6359707170061976648867130e+05, 16, "6635970717006197664887", 6},
  {7.0919400322261863038875163e+03, 14, "70919400322261863", 4},
  {6.4036832857680924738211057e-22, 15, "", -15},
  {6.8308362504833177600000000e+18, 13, "683083625048331776", 19},
  {5.6521198109565212500000000e+14, 7, "565211981095652125", 15},
  {1.3393220575007208341993270e-16, 3, "", -3},
  {5.1510402167282691955566406e+10, 2, "5151040216728", 11},
  {5.3138511185264298692345619e+06, 4, "53138511185", 7},
  {1.2090853172243418884277344e+11, 20, "1209085317224341888427734375", 12},
  {3.9698815477046103193467060e-25, 18, "", -18},
  {3.9300588278036453993991017e+05, 17, "39300588278036453993991", 6},
  {2.1679712635939926400000000e+17, 11, "216797126359399264", 18},
  {2.3963891334855675057519120e-04, 1, "", -1},
  {9.0754981327359828924272733e+01, 19, "907549813273598289243", 2},
  {1.0817121220185560302734375e+12, 13, "10817121220185560302734375", 13},
  {4.7615742126394318134430250e+00, 6, "4761574", 1},
  {1.3029633733901970983591217e-25, 5, "", -5},
  {7.9476477422568505062372424e+03, 11, "794764774225685", 4},
  {9.2617573637450065736353988e-05, 20, "9261757363745007", -4},
  {2.9046649257244287500000000e+14, 10, "290466492572442875", 15},
  {7.5658669577253522505015658e-18, 2, "", -2},
  {1.1615863569244215178461649e-21, 14, "", -14},
  {3.9455789198306369536000000e+19, 12, "39455789198306369536", 20},
  {2.8153498349675107448319977e+01, 9, "2815349835", 2},
  {1.1374062340202323542078103e-16, 17, "11", -15},
  {5.2336976207828411133959889e+03, 16, "52336976207828411134", 4},
  {8.8249812914106188964843750e+11, 2, "88249812914106", 12},
  {1.7569465261432727857027203e+04, 13, "175694652614327279", 5},
  {9.5515231261933362343905926e-14, 0, "", 0},
  {2.8534790720767408628635864e-04, 9, "285348", -3},
  {1.5890585133954701294165254e-24, 14, "", -14},
  {9.2645229875191579315357511e-14, 16, "926", -13},
  {3.9467978030113749809970614e+02, 16, "3946797803011374981", 3},
  {9.3612833932867305287906481e-25, 0, "", 0},
  {2.8444490556779390981101270e-09, 9, "3", -8},
  {1.3389576989838040000000000e+17, 15, "1338957698983804", 18},
  {3.3896191789429173208201940e-12, 4, "", -4},
  {4.5005642821284651756286621e+08, 18, "450056428212846517562866211", 9},
  {2.3446349821271067140207936e-05, 17, "2344634982127", -4},
  {5.9221101189462033857620847e-08, 7, "1", -6},
  {1.0597929648852944856522867e-14, 14, "1", -13},
  {1.3510138345224629211425781e+11, 6, "135101383452246292", 12},
  {5.1850317471604879196240324e-16, 17, "52", -15},
  {8.5039153575688588492800000e+20, 5, "850391535756885884928", 21},
  {2.0338336315231295897600000e+20, 13, "203383363152312958976", 21},
  {7.4550601093548358618060837e-14, 1, "", -1},
  {6.1900115431706137769651832e+02, 0, "619", 3},
  {4.1369746586715999436800000e+20, 10, "413697465867159994368", 21},
  {9.7190843557104848000000000e+16, 2, "97190843557104848", 17},
  {1.4460405622411373890721536e-12, 19, "14460406", -11},
  {8.9474975742263200118031818e+02, 10, "8947497574226", 3},
  {2.4574531018570363281872115e-03, 7, "24575", -2},
  {6.1636666472558422088623047e+09, 5, "616366664725584", 10},
  {9.3103882396183800697326660e+08, 2, "93103882396", 9},
  {2.0403241439373138161709650e-18, 9, "", -9},
  {1.2832299597834323437500000e+14, 6, "128322995978343234375", 15},
  {2.7447600250735468455190952e-18, 10, "", -10},
  {3.1635081401521062906002144e-14, 2, "", -2},
  {4.2227040351308810485906806e-07, 5, "", -5},
  {1.5735895886519455366681086e+00, 10, "15735895887", 1},
  {3.4101730640231597465404234e-12, 8, "", -8},
  {4.0960346483590171365139234e-21, 1, "", -1},
  {2.2198949798132341428492982e-21, 0, "", 0},
  {3.3895038010826385580003262e+06, 19, "33895038010826385580003262", 7},
  {2.4631188708117188190804825e-01, 11, "24631188708", 0},
  {4.8918083766503673791885376e+08, 20, "48918083766503673791885375977", 9},
  {5.7741535939081948217531667e-11, 4, "", -4},
  {3.0533020937569827679108700e-21, 0, "", 0},
  {1.2262163172308858383185992e-01, 11, "12262163172", 0},
  {8.1729584925889453125000000e+13, 3, "81729584925889453", 14},
  {1.1009883194653142385321942e-02, 12, "11009883195", -1},
  {1.8251527270154022216796875e+11, 8, "18251527270154022217", 12},
  {6.7530112911599582403709974e-01, 8, "67530113", 0},
  {1.8288642786583582031250000e+13, 17, "1828864278658358203125", 14},
  {9.3917500123314866678631008e-04, 9, "939175", -3},
  {5.4777578207426902172789743e-25, 18, "", -18},
  {9.7623770237182483673095703e+09, 20, "97623770237182483673095703125", 10},
  {5.8675364466287087849963051e-15, 10, "", -10},
  {2.5535870821599180612352341e-06, 7, "26", -5},
  {1.9779394355416212480000000e+18, 1, "1977939435541621248", 19},
  {1.0071542106908491659415038e-23, 14, "", -14},
  {1.2669933962805061970539729e-23, 1, "", -1},
  {2.0229256600190723575658294e-05, 16, "202292566002", -4},
  {4.1435513811295583364228778e-18, 16, "", -16},
  {2.8666542690562672047607747e-12, 8, "", -8},
  {2.8982126838765268808336906e-18, 20, "29", -17},
  {1.5333340226345115625000000e+14, 4, "1533334022634511563", 15},
  {2.3611275123185394707296239e-23, 12, "", -12},
  {8.5182451799266444800000000e+17, 2, "851824517992664448", 18},
  {2.9690132070212025642395020e+09, 5, "29690132070212", 10},
  {2.2373651973664375000000000e+13, 20, "22373651973664375", 14},
  {1.2318425394233544436370943e-11, 15, "12318", -10},
  {1.5067052980512509630759857e-16, 15, "", -15},
  {1.1190318407857713732172803e-13, 3, "", -3},
  {1.4829527685770154375790547e-20, 5, "", -5},
  {5.6529853772731015625000000e+12, 19, "56529853772731015625", 13},
  {1.4483865617677072063088417e+07, 13, "144838656176770720631", 8},
  {1.5261268409673947037657357e-18, 0, "", 0},
  {1.0484631664691227369950472e-10, 17, "10484632", -9},
  {1.4334697387654815603497127e-01, 7, "143347", 0},
  {1.6197411965670733201466894e-11, 10, "", -10},
  {1.4795992779989680128000000e+20, 2, "14795992779989680128", 21},
  {9.1922992871399997440000000e+19, 15, "9192299287139999744", 20},
  {4.3491293609974253177642822e+08, 4, "4349129360997", 9},
  {2.9602321443776732879608199e-05, 18, "29602321443777", -4},
  {6.8850674794992435200000000e+20, 14, "688506747949924352", 21},
  {3.9014449393826771200000000e+17, 14, "390144493938267712", 18},
  {1.5091308272393798828125000e+11, 8, "15091308272393798828", 12},
  {1.7381693593986030440270665e-24, 1, "", -1},
  {1.4063798783446035156250000e+13, 16, "1406379878344603515625", 14},
  {2.7542321753343733914620267e-08, 0, "", 0},
  {7.1745453875103804773504413e-09, 15, "7174545", -8},
  {1.0027386845230542185076170e-17, 8, "", -8},
  {1.0104347313771916105906712e+02, 12, "101043473137719", 3},
  {1.1777329142550058662891388e+07, 3, "11777329143", 8},
  {8.4435020128630920000000000e+15, 7, "8443502012863092", 16},
  {6.5917017092307016719132662e+05, 11, "65917017092307017", 6},
  {1.3903647131304745869010407e-07, 4, "", -4},
  {1.6489209243823575394614446e-13, 11, "", -11},
  {2.9935252464204910679721958e-05, 10, "299353", -4},
  {1.4995573112503832206130028e+07, 15, "1499557311250383220613", 8},
  {2.1344794649936863085123675e-12, 16, "21345", -11},
  {8.2737412729783936701844053e-22, 7, "", -7},
  {3.3175937101335298620718994e-03, 16, "33175937101335", -2},
  {6.1723433393060639882976570e-04, 0, "", 0},
  {1.0596235340847448787891689e-10, 20, "10596235341", -9},
  {4.2012443995218877627287387e-11, 10, "", -10},
  {1.0694128924400445482418818e-14, 18, "10694", -13},
  {5.1493254239729155385951742e-02, 8, "5149325", -1},
  {1.0132776727413394732280061e-02, 17, "1013277672741339", -1},
  {3.5825454060512306482946230e-25, 11, "", -11},
  {4.1109267281227209878124995e+02, 10, "4110926728123", 3},
  {2.3430879631815128028392792e+07, 5, "2343087963182", 8},
  {2.5562529409383959524970642e-03, 1, "", -1},
  {4.8515324793622298216178024e+01, 6, "48515325", 2},
  {2.8412846299970393574327136e-06, 20, "284128462999704", -5},
  {1.4940882572995673172044917e+02, 9, "14940882573", 3},
  {4.7191456453919131308794022e+06, 6, "4719145645392", 7},
  {4.6898058181384680906502359e-19, 7, "", -7},
  {1.4889376498403061760000000e+19, 2, "1488937649840306176", 20},
  {3.2450600609953377107428159e-20, 13, "", -13},
  {2.2024749998034698350579674e+00, 3, "2202", 1},
  {2.6698132689908330496000000e+19, 1, "26698132689908330496", 20},
  {2.4712723638814216542414215e+02, 16, "2471272363881421654", 3},
  {3.4019450185793975727222005e+00, 15, "3401945018579398", 1},
  {7.1620528602201236186250453e-17, 6, "", -6},
  {4.3242721181151363072000000e+20, 20, "43242721181151363072", 21},
  {5.1955379084882348023027736e-21, 6, "", -6},
  {5.9574267830319354288803879e+02, 11, "59574267830319", 3},
  {1.5011714609267891200000000e+17, 14, "150117146092678912", 18},
  {1.0094590681134784610002481e-17, 5, "", -5},
  {2.7193280044396953877302658e-16, 6, "", -6},
  {2.0041379351753670932537749e-24, 17, "", -17},
  {6.6707776261575214240182950e-21, 4, "", -4},
  {1.0483426780257300237053641e+01, 4, "104834", 2},
  {7.6002353127160754995200000e+20, 10, "760023531271607549952", 21},
  {5.3267037242751851677894592e+07, 0, "53267037", 8},
  {3.0839425009291431933888816e+02, 13, "3083942500929143", 3},
  {1.6328191867664758300781250e+12, 11, "163281918676647583007813", 13},
  {3.7369759306164955399376475e-25, 9, "", -9},
  {3.0733627373342314870185987e-01, 14, "30733627373342", 0},
  {2.1528277213992596435546875e+11, 16, "21528277213992596435546875", 12},
  {2.5777819263550066947937012e+08, 18, "257778192635500669479370117", 9},
  {7.1261884907909384000000000e+16, 12, "71261884907909384", 17},
  {4.6239715758183773437500000e+13, 11, "462397157581837734375", 14},
  {2.0230381682537332177162170e+08, 17, "2023038168253733217716217", 9},
  {2.1122689775740910076179597e-24, 10, "", -10},
  {3.8710357234043651526631009e-22, 10, "", -10},
  {7.8624408951451262500000000e+14, 4, "786244089514512625", 15},
  {6.1924596479857075337349670e+02, 6, "619245965", 3},
  {3.9382200131912444670692568e-11, 4, "", -4},
  {2.0064155937856195639303775e-21, 11, "", -11},
  {4.5281459090617963558260426e-22, 4, "", -4},
  {5.9887029547533582318763479e-03, 4, "6", -2},
  {5.0228335817595242741330497e-05, 13, "502283358", -4},
  {1.6197583065628164966653912e+00, 7, "16197583", 1},
  {1.6020819687093194261251483e+02, 7, "1602081969", 3},
  {2.0220792810433337688446045e+09, 11, "202207928104333376884", 10},
  {8.2209824790111923828125000e+12, 10, "82209824790111923828125", 13},
  {5.9745837395145118424921340e-24, 4, "", -4},
  {1.2759806370866349650576707e-10, 8, "", -8},
  {6.3303537141159874155477150e-04, 20, "63303537141159874", -3},
  {6.5987463650554700488396363e-19, 19, "7", -18},
  {1.0019127874473169715200000e+20, 0, "100191278744731697152", 21},
  {3.5617668006870007812500000e+13, 5, "3561766800687000781", 14},
  {7.6934132414933471679687500e+10, 7, "769341324149334717", 11},
  {9.4810316486845125361071496e-01, 18, "948103164868451254", 0},
  {1.1349940874830415055548655e-07, 16, "1134994087", -6},
  {1.3342308034923484922702485e-18, 12, "", -12},
  {5.8477244721539634300513692e-09, 4, "", -4},
  {5.1124315000149423828125000e+12, 17, "51124315000149423828125", 13},
  {8.1715926287528976589170979e-12, 2, "", -2},
  {6.0175058787231625989210676e-05, 0, "", 0},
  {1.3887445889914229457673400e-01, 15, "138874458899142", 0},
  {2.6780054899996974006973875e-16, 18, "268", -15},
  {1.4692065370194903550782328e+01, 19, "146920653701949035508", 2},
  {1.6850483553022032824946985e-16, 10, "", -10},
  {5.8622781518787675781250000e+12, 6, "5862278151878767578", 13},
  {1.0352893702815987200000000e+17, 9, "103528937028159872", 18},
  {1.9168630475894221643073934e+00, 5, "191686", 1},
  {5.2929888962312904771113088e-14, 10, "", -10},
  {2.2129553687209242993754803e-14, 5, "", -5},
  {4.1700205084561664000000000e+18, 9, "41700205084561664", 19},
  {2.4024012951531943038482227e-18, 11, "", -11},
  {3.7381612109949113600000000e+17, 12, "373816121099491136", 18},
  {3.4320524984185391804203391e+05, 8, "34320524984185", 6},
  {2.7994557340208268787218755e-12, 15, "2799", -11},
  {1.1085812378753590836222792e-15, 20, "110858", -14},
  {4.1036758929114801415551744e-25, 11, "", -11},
  {7.2397892752148037109375000e+12, 4, "72397892752148037", 13},
  {4.0535998840140195765018963e-15, 0, "", 0},
  {4.1622230502396053811869236e-08, 7, "", -7},
  {7.5024205441084638671875000e+12, 20, "75024205441084638671875", 13},
  {2.5276349961839616298675537e+04, 5, "2527634996", 5},
  {1.1889265963025728023970890e-14, 16, "119", -13},
  {7.7134344076623610752482915e-11, 6, "", -6},
  {2.7412806098619764918477407e-16, 0, "", 0},
  {1.1572533707044190199760786e-16, 9, "", -9},
  {4.2248992667136336942590447e-01, 0, "", 0},
  {4.5788009862008467316627502e+06, 4, "45788009862", 7},
  {3.6405061215395357643962386e-25, 10, "", -10},
  {1.7639970220616740803620814e-01, 13, "1763997022062", 0},
  {3.8769488922669030998641252e-14, 5, "", -5},
  {5.0751904022741360000000000e+15, 17, "5075190402274136", 16},
  {6.9333846522900062253578484e-20, 10, "", -10},
  {3.2412568532468367458122279e-20, 5, "", -5},
  {4.6233421498981046676635742e+09, 4, "46233421498981", 10},
  {7.3309014470831298828125000e+12, 2, "733090144708313", 13},
  {1.8329501073203586041927338e+07, 9, "18329501073203586", 8},
  {9.0635389094054051840000000e+18, 3, "9063538909405405184", 19},
  {4.4201453633247553144375614e-14, 8, "", -8},
  {1.8747222908433855811398549e-17, 0, "", 0},
  {2.7612130918966296386718750e+11, 20, "2761213091896629638671875", 12},
  {1.0824747963231270313262939e+09, 9, "1082474796323127031", 10},
  {1.5124169008190355300903320e+10, 6, "15124169008190355", 11},
  {1.4686570345823023608931244e-25, 12, "", -12},
  {6.3383432435725605029010060e-16, 17, "63", -15},
  {6.4912611287019099408287654e-17, 17, "6", -16},
  {2.1481219011756825657738132e-10, 1, "", -1},
  {1.9879098403850758592998791e-19, 10, "", -10},
  {1.3679352052799358222754334e-22, 16, "", -16},
  {5.8451929973907684326171875e+10, 3, "58451929973908", 11},
  {2.1751107679125480353832245e+07, 4, "217511076791", 8},
  {3.2249846318769378662109375e+10, 5, "3224984631876938", 11},
  {1.2022618958613278707103778e-03, 17, "120226189586133", -2},
  {4.0075303097142102196812630e+06, 9, "400753030971421", 7},
  {1.4879067427283508215363206e-03, 8, "148791", -2},
  {6.6928632747153177859202354e-14, 6, "", -6},
  {3.1621932258690318207072778e+01, 20, "3162193225869031820707", 2},
  {1.4088744428895156392570961e-05, 4, "", -4},
  {4.5603894970273443603515625e+11, 12, "456038949702734436035156", 12},
  {1.8447707756412334080000000e+18, 10, "1844770775641233408", 19},
  {2.4212483339552307128906250e+11, 13, "2421248333955230712890625", 12},
  {6.8205590724864434176000000e+19, 20, "68205590724864434176", 20},
  {1.3832053780395564620412175e-24, 15, "", -15},
  {1.2215045836626478080000000e+18, 16, "1221504583662647808", 19},
  {1.2981274164796521852771605e-01, 4, "1298", 0},
  {1.7824215999285591749412561e+01, 15, "17824215999285592", 2},
  {4.7875338375519223463552012e-22, 0, "", 0},
  {3.2709390774430295654400000e+20, 7, "327093907744302956544", 21},
  {7.3503920304656176085700281e+03, 5, "735039203", 4},
  {3.6709553862974230038342113e-16, 16, "4", -15},
  {1.1883583904762438159213693e-05, 16, "118835839048", -4},
  {1.0032756000549027343750000e+13, 4, "100327560005490273", 14},
  {6.2045638808385802392300755e-10, 16, "6204564", -9},
  {1.3792931959191319981146107e-24, 11, "", -11},
  {7.1641192962391896681428362e-07, 0, "", 0},
  {8.6153935464807174438530100e-23, 19, "", -19},
  {6.2559465867568400000000000e+14, 17, "625594658675684", 15},
  {1.7003592062902101288943310e-12, 19, "17003592", -11},
  {2.3161345643995203971862793e+09, 19, "23161345643995203971862792969", 10},
  {1.8605224865514980000000000e+16, 18, "1860522486551498", 17},
  {3.3154288830329028314736206e+03, 10, "33154288830329", 4},
  {1.8342169055934270938124087e-01, 4, "1834", 0},
  {2.8268515560030613492814164e-13, 18, "282685", -12},
  {1.4153025798578784952748781e-16, 3, "", -3},
  {5.1348193571771187707781792e+06, 16, "51348193571771187707782", 7},
  {5.3131464888565401368610260e-09, 20, "531314648886", -8},
  {2.3407957560596276000000000e+16, 1, "23407957560596276", 17},
  {1.6877457673276127316057682e+06, 19, "16877457673276127316057682", 7},
  {1.2350516557344991264155709e-01, 6, "123505", 0},
  {7.1337792093476230000000000e+15, 9, "7133779209347623", 16},
  {3.1437623754113459200000000e+17, 5, "314376237541134592", 18},
  {2.0756262793882775878906250e+12, 2, "207562627938828", 13},
  {1.4836344939863306603638913e-22, 3, "", -3},
  {5.6949502901424675447162715e-07, 7, "6", -6},
  {1.0795041991602663244975702e+02, 13, "1079504199160266", 3},
  {2.0261094576998366974294186e+06, 18, "2026109457699836697429419", 7},
  {4.6519275662841224267359907e-19, 15, "", -15},
  {4.4695664618041923551116465e-15, 18, "447", -14},
  {2.3394198984064653721600000e+20, 3, "233941989840646537216", 21},
  {7.2647190438063598632812500e+10, 14, "726471904380635986328125", 11},
  {1.2515563881754650268061414e-05, 18, "12515563881755", -4},
  {2.7950931681174785221677202e-13, 5, "", -5},
  {6.3227699149073124457257590e-22, 11, "", -11},
  {1.3215611447541187921411227e-17, 0, "", 0},
  {5.4708373967604234814643860e+07, 1, "54708374", 8},
  {3.3114155494037310668800000e+20, 18, "331141554940373106688", 21},
  {3.7540404083055349364339559e-03, 20, "375404040830553494", -2},
  {2.3146379950221329701090522e-04, 18, "231463799502213", -3},
  {5.6637864962598000000000000e+14, 13, "56637864962598", 15},
  {2.8988228950344933741592804e-05, 11, "2898823", -4},
  {1.0032445306615201135401922e-25, 18, "", -18},
  {2.2791188980893635080204012e-24, 10, "", -10},
  {6.4547363820449339982587844e+04, 0, "64547", 5},
  {4.4243471094101018081801158e+01, 4, "442435", 2},
  {1.4445547706840062569745811e-11, 8, "", -8},
  {1.6614816255181520770391113e-23, 2, "", -2},
  {3.8928938796661849564490465e-15, 16, "39", -14},
  {9.7733857835886675000000000e+14, 1, "9773385783588668", 15},
  {2.7287845851530601493095674e+01, 7, "272878459", 2},
  {4.6108913390723031618928244e-25, 15, "", -15},
  {1.0081669624965612364064782e+00, 17, "100816696249656124", 1},
  {2.3013034749004053125000000e+14, 14, "23013034749004053125", 15},
  {5.1371648036235059538549226e-22, 3, "", -3},
  {7.8854565859864172563418370e-12, 0, "", 0},
  {2.8595028431658639794037349e-21, 4, "", -4},
  {5.5918305494274746160954237e+05, 6, "559183054943", 6},
  {3.1871434843641137704253197e+06, 3, "3187143484", 7},
  {5.3090305540237914035698845e-24, 14, "", -14},
  {4.5643312106217253971394648e-09, 8, "", -8},
  {4.6533856090809018724030466e+02, 5, "46533856", 3},
  {8.4031277567637787500000000e+14, 9, "840312775676377875", 15},
  {4.8721747754104462751966035e-15, 10, "", -10},
  {1.8491643008742844004471673e-03, 4, "18", -2},
  {1.1297904813879146768218590e-22, 6, "", -6},
  {5.1462626979436418398756830e-14, 10, "", -10},
  {1.1215679464069258980776413e-13, 4, "", -4},
  {3.2805123672556102225328356e-04, 16, "3280512367256", -3},
  {7.0635468540744310000000000e+15, 18, "7063546854074431", 16},
  {3.3410839063509635925292969e+09, 13, "33410839063509635925293", 10},
  {6.9658892477016742400000000e+17, 0, "696588924770167424", 18},
  {1.7834975546340525150299072e+09, 6, "1783497554634053", 10},
  {3.3155443628999792640000000e+18, 13, "3315544362899979264", 19},
  {7.9291582355015282519161701e+05, 14, "79291582355015282519", 6},
  {1.2778642919653989429551350e-22, 11, "", -11},
  {9.2292952293925078810384500e-19, 2, "", -2},
  {1.1459421949252543945312500e+12, 12, "114594219492525439453125", 13},
  {1.2526691199485598212005250e-15, 3, "", -3},
  {5.8906938235967995904000000e+19, 12, "58906938235967995904", 20},
  {2.8215000693445971322415861e-22, 11, "", -11},
  {5.5499376173931515625000000e+13, 3, "55499376173931516", 14},
  {7.9335624135383172109148298e-04, 4, "8", -3},
  {2.4164374354300540289841592e+04, 19, "241643743543005402898416", 5},
  {1.1308639246609742258442566e+04, 20, "1130863924660974225844257", 5},
  {9.1515713845035443200000000e+17, 9, "915157138450354432", 18},
  {1.2963457743139601562500000e+14, 2, "12963457743139602", 15},
  {6.8409454313364816599451526e-09, 0, "", 0},
  {3.3581720402598376223229134e-07, 4, "", -4},
  {2.6616216294655677440000000e+18, 1, "2661621629465567744", 19},
  {3.2098540936158135890116317e-22, 8, "", -8},
  {3.5709613206139515699200000e+20, 5, "357096132061395156992", 21},
  {2.2099380648076796800000000e+17, 0, "220993806480767968", 18},
  {1.5285117488390049402369186e+04, 19, "152851174883900494023692", 5},
  {3.8581745621522198774755452e+00, 18, "3858174562152219877", 1},
  {3.6475467351836266517639160e+09, 4, "36475467351836", 10},
  {7.7705324649129277336800925e-03, 16, "77705324649129", -2},
  {5.6536291306972834147938183e-08, 18, "56536291307", -7},
  {6.0765881960117333694965400e-16, 18, "608", -15},
  {2.3527698169886966400000000e+17, 19, "235276981698869664", 18},
  {5.0119370426837605191394687e+05, 18, "501193704268376051913947", 6},
  {2.7787256146004533176102277e-05, 10, "277873", -4},
  {1.1372295662789770221844272e-05, 11, "113723", -4},
  {8.6869644716334678841845873e-04, 1, "", -1},
  {1.1656105072164636182554703e-12, 6, "", -6},
  {9.0156007550074759785317959e-10, 14, "90156", -9},
  {8.5296383117497365233816708e-01, 18, "852963831174973652", 0},
  {6.6348682698125148160000000e+18, 17, "6634868269812514816", 19},
  {2.0922062962857269001704054e-07, 10, "2092", -6},
  {4.1495178170156796113587916e+04, 10, "414951781701568", 5},
  {5.1477529348350844052609538e-18, 6, "", -6},
  {5.1811845086105621536084808e-25, 11, "", -11},
  {9.4402669599172315195720786e-20, 7, "", -7},
  {1.7952509705060291889796177e-24, 7, "", -7},
  {3.9164920746127299217169740e-07, 10, "3916", -6},
  {8.6528818334939280977373779e-23, 1, "", -1},
  {1.8324430030326748800000000e+17, 13, "183244300303267488", 18},
  {2.2446886994460615895097689e-14, 1, "", -1},
  {1.8636860489769324633613223e-01, 9, "186368605", 0},
  {4.0571572990206120029182685e-13, 12, "", -12},
  {1.4044221695713654863591954e-18, 15, "", -15},
  {1.0749219851060483332805262e-03, 5, "107", -2},
  {2.2222242019020614305970459e-08, 10, "222", -7},
  {5.9069464271713784000000000e+16, 5, "59069464271713784", 17},
  {2.6661534200503269858018029e+03, 16, "26661534200503269858", 4},
  {1.6027843406344184186309576e+06, 10, "16027843406344184", 7},
  {7.7487514321481984000000000e+16, 11, "77487514321481984", 17},
  {7.0898986407610884569035089e-18, 9, "", -9},
  {3.0754661918173940016174583e+00, 1, "31", 1},
  {6.1969208857956005859375000e+11, 20, "61969208857956005859375", 12},
  {1.0124956752840671800800259e-20, 2, "", -2},
  {3.1766446515994410937366865e+00, 5, "317664", 1},
  {6.6162765840173661338087518e-06, 20, "661627658401737", -5},
  {4.1944013948131603948476459e-11, 13, "419", -10},
  {7.6005629054096070648437722e-19, 0, "", 0},
  {3.2282080725918415979591725e-03, 6, "3228", -2},
  {1.0163727711151226633355042e-16, 1, "", -1},
  {4.3424639639771599957279170e-11, 19, "434246396", -10},
  {1.1096656795988109334510085e-09, 2, "", -2},
  {2.7046978267396813631057739e+08, 17, "27046978267396813631057739", 9},
  {7.5958662288745681762695312e+10, 9, "75958662288745681763", 11},
  {3.1880838214187936782836914e+09, 11, "318808382141879367828", 10},
  {5.2922726395238656000000000e+16, 12, "52922726395238656", 17},
  {1.6661242987473519860941451e+02, 13, "1666124298747352", 3},
  {7.0692512567912087162130681e-11, 18, "70692513", -10},
  {2.6786777789099720792354020e-02, 18, "26786777789099721", -1},
  {3.3100353402848249620785555e-08, 1, "", -1},
  {1.3054792135208036750555038e+07, 14, "1305479213520803675056", 8},
  {1.5781770384617774327413476e-17, 18, "16", -16},
  {9.9528118002772638342138288e-24, 4, "", -4},
  {6.3635055471855927315814636e-15, 14, "1", -13},
  {3.1133253713291351318359375e+11, 18, "31133253713291351318359375", 12},
  {1.5270733697313438251712748e-13, 6, "", -6},
  {1.0536835827208061218261719e+10, 14, "1053683582720806121826172", 11},
  {3.5379780399155715221856795e-14, 2, "", -2},
  {1.8739757898926737500000000e+15, 4, "187397578989267375", 16},
  {1.0781012563777347984184805e-09, 17, "107810126", -8},
  {7.8579403115636619315251442e-15, 0, "", 0},
  {1.7479167887200917967470658e-24, 13, "", -13},
  {1.5043051787654523110404625e+01, 9, "15043051788", 2},
  {1.0661339325011793377484537e+01, 14, "1066133932501179", 2},
  {2.9445899463000415607893956e+01, 12, "29445899463", 2},
  {1.2521852906111782073974609e+10, 15, "12521852906111782073974609", 11},
  {1.4440987161676565753267488e-11, 8, "", -8},
  {7.2475166759913849830627441e+08, 14, "72475166759913849830627", 9},
  {9.6760431925224363803863525e+06, 20, "967604319252243638038635254", 7},
  {3.9871437099373167975758946e-18, 16, "", -16},
  {3.1190822896820148000000000e+16, 2, "31190822896820148", 17},
  {5.1210918063452500492076861e-16, 19, "5121", -15},
  {1.2282794450603361366161754e-11, 2, "", -2},
  {1.3468081082013928000000000e+16, 12, "13468081082013928", 17},
  {1.9583107932965686248660830e-02, 4, "196", -1},
  {7.1285583513601340000000000e+15, 13, "7128558351360134", 16},
  {1.1355110982848997497558594e+11, 19, "1135511098284899749755859375", 12},
  {7.3473954447433281182422244e-14, 2, "", -2},
  {1.1906149056874531555175781e+11, 20, "1190614905687453155517578125", 12},
  {1.0704924167451702562460503e-04, 2, "", -2},
  {2.3334034223341761929426105e-22, 1, "", -1},
  {1.6314505234639789705397561e+04, 20, "1631450523463978970539756", 5},
  {1.9283848015045338856503952e-20, 10, "", -10},
  {4.3598386128593267360937566e-23, 1, "", -1},
  {5.5821650566183125125041542e-05, 12, "55821651", -4},
  {1.6452999979327625184646925e-15, 4, "", -4},
  {2.3108027229628710937500000e+12, 15, "231080272296287109375", 13},
  {6.7039053435815416000000000e+16, 4, "67039053435815416", 17},
  {5.5345488720339587704766943e-05, 6, "55", -4},
  {1.7348159746334800000000000e+16, 19, "173481597463348", 17},
  {3.5137038660215206444263458e+07, 11, "3513703866021520644", 8},
  {1.1709310819861266850239190e+02, 5, "11709311", 3},
  {1.9544833960688942712516022e-06, 15, "1954483396", -5},
  {7.2440497024620288000000000e+17, 17, "72440497024620288", 18},
  {4.5627280337212741224547185e-25, 0, "", 0},
  {2.5497293101209270169339240e-14, 14, "3", -13},
  {3.7311022982928351232000000e+19, 14, "37311022982928351232", 20},
  {9.8512852884424203848473601e-23, 6, "", -6},
  {7.6197251634250445777899155e-10, 15, "761973", -9},
  {3.2149328659636124968528748e+07, 2, "3214932866", 8},
  {4.5329675402483032842226862e-01, 16, "4532967540248303", 0},
  {2.2913136704738213840008797e-18, 7, "", -7},
  {2.1568936122932519383610384e-01, 13, "2156893612293", 0},
  {3.5548225673666671017692793e-21, 4, "", -4},
  {4.6239734109586132005335275e-09, 16, "46239734", -8},
  {1.8561049670274893750000000e+14, 12, "1856104967027489375", 15},
  {3.8292672113425145226802624e-12, 11, "", -11},
  {3.9462831191935762232668111e-16, 10, "", -10},
  {5.0894832346327380494938053e-04, 20, "5089483234632738", -3},
  {5.5917811853613590000000000e+15, 2, "5591781185361359", 16},
  {7.6682982689692601561546326e+06, 14, "766829826896926015615", 7},
  {5.5677812236010434620335856e-11, 15, "55678", -10},
  {2.5512614289922416210174561e+07, 20, "2551261428992241621017456055", 8},
  {1.0030051342394882813248391e-16, 12, "", -12},
  {1.9843965601313671864225037e-21, 20, "", -20},
  {1.7288050417638967500228234e-05, 8, "1729", -4},
  {1.7389652789265560371200000e+20, 11, "173896527892655603712", 21},
  {3.9685189410533998592000000e+20, 16, "39685189410533998592", 21},
  {1.1975042249353845788091987e-25, 7, "", -7},
  {9.8504954032932219442076690e-20, 20, "1", -18},
  {3.1493884777071437565609813e+05, 14, "31493884777071437566", 6},
  {1.0706576118028424680233002e+06, 18, "10706576118028424680233", 7},
  {2.6490482579218208789825439e+08, 5, "26490482579218", 9},
  {1.8848358571293525003132882e-25, 15, "", -15},
  {3.1248731989363229611661720e-08, 9, "31", -7},
  {1.9167245800229784635781982e-01, 6, "191672", 0},
  {2.2796748524080170898437500e+12, 20, "227967485240801708984375", 13},
  {1.3851263481030105140234809e+03, 3, "1385126", 4},
  {8.9042301699781093750000000e+13, 15, "8904230169978109375", 14},
  {3.7561672239726977318128340e-07, 5, "", -5},
  {9.2901774517383153845638514e-09, 3, "", -3},
  {5.9789610608538779956688813e+01, 20, "5978961060853877995669", 2},
  {7.2760906484244362218305469e+04, 13, "727609064842443622", 5},
  {1.1487409840760183105468750e+12, 10, "11487409840760183105469", 13},
  {4.3200553034667493737289481e-13, 0, "", 0},
  {1.3935323097039591521024704e+06, 4, "13935323097", 7},
  {6.4122266684134590148925781e+10, 3, "64122266684135", 11},
  {4.1194231305734936144056857e-15, 9, "", -9},
  {3.5962790145026364326477051e+09, 10, "35962790145026364326", 10},
  {5.6562302070061317924021260e-03, 12, "5656230207", -2},
  {6.8299704621635664000000000e+16, 4, "68299704621635664", 17},
  {1.5216937598475618362426758e+09, 17, "152169375984756183624267578", 10},
  {3.4368240231289646710588492e-03, 18, "3436824023128965", -2},
  {7.3226345311167590293288468e-16, 10, "", -10},
  {2.7931970020246225768248244e-10, 10, "3", -9},
  {1.2703535922846790613333440e-25, 0, "", 0},
  {2.6959798512242645263671875e+10, 16, "26959798512242645263671875", 11},
  {4.3758124981945805000000000e+15, 12, "43758124981945805", 16},
  {1.8903970058089859375000000e+13, 19, "18903970058089859375", 14},
  {6.1521844325970826890714470e-13, 13, "6", -12},
  {5.7694160027823848224670655e+01, 2, "5769", 2},
  {1.0764467022008814500687451e-19, 18, "", -18},
  {3.6987003322859001345932484e+06, 14, "369870033228590013459", 7},
  {3.4194453921349691308491286e-17, 18, "34", -16},
  {1.0641706491769839616000000e+20, 9, "10641706491769839616", 21},
  {4.8543041956042529250225925e+01, 7, "48543042", 2},
  {8.1077059894130132387939012e-10, 3, "", -3},
  {6.6765244375325506553053856e+05, 19, "6676524437532550655305386", 6},
  {1.5038345765076435368618428e-21, 15, "", -15},
  {1.0973772142684196778932709e-04, 5, "11", -3},
  {5.0372853195588161172715589e-14, 14, "5", -13},
  {8.1312161599681576085174584e-02, 9, "81312162", -1},
  {5.7120296464382866397500038e+06, 4, "57120296464", 7},
  {4.2660480538579159004159603e-15, 3, "", -3},
  {6.3108584879588424636589641e-12, 8, "", -8},
  {2.1920510685007419433593750e+12, 13, "2192051068500741943359375", 13},
  {7.0222694631491884619286146e-15, 7, "", -7},
  {3.6349459924845946261484642e+03, 18, "3634945992484594626148", 4},
  {3.7436890768284826139045649e-15, 5, "", -5},
  {1.8501042496164912500000000e+14, 0, "185010424961649", 15},
  {4.6905371180836686935987670e-11, 16, "469054", -10},
  {5.9452172919127231967562075e-03, 19, "59452172919127232", -2},
  {9.4242031144884175208886745e-01, 3, "942", 0},
  {8.1507702787394133654107740e-08, 9, "82", -7},
  {1.5128829946336120735749571e-22, 5, "", -5},
  {2.2855350209261521639841240e-22, 0, "", 0},
  {6.2097530510318639518363426e-02, 9, "62097531", -1},
  {4.1372943148869228363037109e+09, 5, "413729431488692", 10},
  {1.4763831010548790836911515e-02, 18, "14763831010548791", -1},
  {1.1240172310059476545752758e-20, 20, "1", -19},
  {1.4276161598053795430400000e+20, 20, "142761615980537954304", 21},
  {5.9866756320417380266007967e+03, 10, "59866756320417", 4},
  {3.8935513231620185497628729e-14, 0, "", 0},
  {6.6400848048389861360192299e+06, 17, "664008480483898613601923", 7},
  {2.7993072965576559305191040e+07, 0, "27993073", 8},
  {2.5148674110688324652930365e-14, 13, "", -13},
  {1.2108598702835938930511475e+09, 6, "1210859870283594", 10},
  {6.5922308234093950000000000e+15, 7, "6592230823409395", 16},
  {1.7615981989498755335807800e+08, 13, "1761598198949875533581", 9},
  {6.8765965273981493248000000e+19, 0, "68765965273981493248", 20},
  {2.4949701484568591687406217e-09, 11, "249", -8},
  {6.8743103161081291532837013e-22, 10, "", -10},
  {2.3281131770649934003753624e-15, 10, "", -10},
  {3.1070114557974255876615644e+05, 20, "31070114557974255876615644", 6},
  {1.1060690884595605760000000e+18, 14, "1106069088459560576", 19},
  {4.2500044575898065443947707e-10, 15, "425", -9},
  {5.1550889048794116806137880e-15, 17, "516", -14},
  {5.2391141350856650000000000e+14, 18, "5239114135085665", 15},
  {3.3313625291299648437500000e+13, 9, "333136252912996484375", 14},
  {1.8403306903140237101891563e-04, 19, "1840330690314024", -3},
  {8.5467898825982054502057060e-17, 12, "", -12},
  {5.9784441603667574419939017e-12, 2, "", -2},
  {6.4498908167953934591307036e-25, 6, "", -6},
  {7.6192034983675466719432734e+03, 10, "76192034983675", 4},
  {2.0591412652780089177794227e-16, 14, "", -14},
  {4.6851715434039795398712158e+08, 16, "4685171543403979539871216", 9},
  {3.5593724531056991577148438e+10, 14, "3559372453105699157714844", 11},
  {2.9739706000534290313720703e+10, 14, "297397060005342903137207", 11},
  {4.3220152053186859712609022e-17, 8, "", -8},
  {1.8072563076755595349981023e-09, 20, "180725630768", -8},
  {4.2625974111241804465066707e+00, 11, "426259741112", 1},
  {8.2913258564771642714113153e-07, 8, "83", -6},
  {1.0125937925291454867878990e-06, 19, "10125937925291", -5},
  {1.5834395826924361600000000e+17, 13, "158343958269243616", 18},
  {1.6279534210955970542013828e-23, 18, "", -18},
  {8.9849651680690206081574464e-24, 5, "", -5},
  {2.6867450191178603515625000e+12, 8, "268674501911786035156", 13},
  {5.4551987902139734425600000e+20, 10, "545519879021397344256", 21},
  {2.5513645074169285637795647e-09, 4, "", -4},
  {1.4735121892758279500412755e+04, 18, "14735121892758279500413", 5},
  {6.0239699074584867868753416e-09, 7, "", -7},
  {1.3328394316437944274833342e-05, 4, "", -4},
  {9.2099802063308748800000000e+17, 12, "920998020633087488", 18},
  {1.5014189448400976000000000e+17, 13, "15014189448400976", 18},
  {1.4839647976864682006835938e+11, 5, "14839647976864682", 12},
  {3.8747671075048394501209259e+07, 2, "3874767108", 8},
  {2.6765181221371782012283802e+06, 3, "2676518122", 7},
  {3.1248694265151454279869013e-18, 4, "", -4},
  {1.7613049563099670000000000e+15, 8, "1761304956309967", 16},
  {2.0923042008691489002103481e+01, 15, "20923042008691489", 2},
  {5.0521662237592494080000000e+18, 18, "5052166223759249408", 19},
  {1.7792770935472091136000000e+19, 13, "17792770935472091136", 20},
  {7.3290624794518777207485982e-01, 10, "7329062479", 0},
  {4.6415476821906138211488724e+06, 18, "4641547682190613821148872", 7},
  {1.7135975251602066040039062e+11, 0, "171359752516", 12},
  {2.8133325487368503296000000e+19, 2, "28133325487368503296", 20},
  {1.6068375047012596041895449e+03, 16, "16068375047012596042", 4},
  {1.9731824240852045224950059e-06, 14, "197318242", -5},
  {4.9677804978388650956334229e-22, 15, "", -15},
  {2.1651945031337190000000000e+15, 10, "2165194503133719", 16},
  {3.8847055232095429673790932e+06, 18, "3884705523209542967379093", 7},
  {1.5288056179614570496000000e+19, 1, "15288056179614570496", 20},
  {9.1705444343324871063232422e+09, 0, "9170544434", 10},
  {3.2956677004655068685678998e+02, 1, "3296", 3},
  {1.4829173500056806460634107e+03, 3, "1482917", 4},
  {4.6106952002601105555216973e-18, 18, "5", -17},
  {4.0500604899507495204602492e+00, 8, "405006049", 1},
  {1.0291022821415954716095520e-02, 7, "10291", -1},
  {4.2166657354396164096000000e+19, 8, "42166657354396164096", 20},
  {1.1789908469377369371581957e-06, 3, "", -3},
  {4.9515701401039416000000000e+16, 4, "49515701401039416", 17},
  {1.5238815458663137629628181e+07, 18, "15238815458663137629628181", 8},
  {1.3357201305833404541015625e+10, 18, "13357201305833404541015625", 11},
  {3.1644725390179241180419922e+10, 0, "3164472539", 11},
  {2.5886927056115241006783735e-12, 13, "26", -11},
  {1.2615416343132400305238024e-11, 3, "", -3},
  {2.1676493732866728125000000e+14, 6, "21676493732866728125", 15},
  {3.6225001567741215710348961e-08, 15, "36225002", -7},
  {7.0508029235893216308087521e-25, 6, "", -6},
  {1.5745171287380576171875000e+12, 6, "1574517128738057617", 13},
  {5.0635474218091871164817140e-17, 11, "", -11},
  {1.5573889672981221643488150e-22, 8, "", -8},
  {5.9451380814414727687835693e+08, 11, "59451380814414727688", 9},
  {4.6150557000201833807442247e-18, 9, "", -9},
  {7.8136527350118290632963181e+05, 2, "78136527", 6},
  {3.5912621811371339912731197e-24, 14, "", -14},
  {2.3768420503580487862684131e-07, 14, "23768421", -6},
  {2.8780593460531942877463920e-11, 19, "287805935", -10},
  {4.4141585797070894080000000e+18, 15, "4414158579707089408", 19},
  {4.3959668588296502145240652e-02, 9, "43959669", -1},
  {6.7081338143572484676688106e-13, 5, "", -5},
  {8.4139753870282152185822167e-04, 7, "8414", -3},
  {1.2930900802106126690205201e+00, 6, "129309", 1},
  {9.1181828784300949504000000e+20, 0, "91181828784300949504", 21},
  {1.5306176431752116803657309e-07, 14, "15306176", -6},
  {1.1712593382882408203125000e+13, 13, "11712593382882408203125", 14},
  {3.1898863415154074832871379e-12, 10, "", -10},
  {1.0574922357012005522847176e+07, 18, "10574922357012005522847176", 8},
  {4.7334937634694506250000000e+14, 8, "4733493763469450625", 15},
  {6.1682319209923072000000000e+17, 0, "61682319209923072", 18},
  {2.7927858816256270858111084e-20, 20, "3", -19},
  {2.2589973415049150586128235e+08, 10, "2258997341504915059", 9},
  {1.1800759742287121178352632e-10, 7, "", -7},
  {1.7435677319999938011169434e+09, 9, "1743567731999993801", 10},
  {2.0158553212815513752026184e-25, 20, "", -20},
  {3.0267113339953057027376104e-02, 1, "", -1},
  {2.4068895669026688204800000e+20, 20, "240688956690266882048", 21},
  {1.9869455778555574943311512e+05, 14, "19869455778555574943", 6},
  {1.1055423839420790970325470e+08, 10, "1105542383942079097", 9},
  {3.7759197671644963149766790e-18, 7, "", -7},
  {1.5338691903677082822215721e-17, 8, "", -8},
  {3.1596477309256080358218835e-08, 6, "", -6},
  {1.6142687249961296114264542e-01, 12, "1614268725", 0},
  {5.9231048890636838972568512e+07, 3, "59231048891", 8},
  {4.8519300637080397022306018e-20, 7, "", -7},
  {2.2614719752682754984559265e-12, 20, "226147198", -11},
  {1.4751916474717458349380532e-22, 14, "", -14},
  {3.9751808119618393626483281e-10, 9, "", -9},
  {2.9412145406409388669999316e+04, 20, "2941214540640938866999932", 5},
  {1.1851732140443518400000000e+17, 20, "118517321404435184", 18},
  {1.1244659921989772446737539e-10, 19, "1124465992", -9},
  {3.2988116050546735525131226e+07, 3, "32988116051", 8},
  {1.9461195878258067750721239e+03, 13, "19461195878258068", 4},
  {1.3314544416390821425011382e+04, 14, "1331454441639082143", 5},
  {2.1076926340527718151065964e-07, 6, "", -6},
  {4.6570543859816346235073094e-10, 18, "465705439", -9},
  {1.8726883846648755073547363e+09, 5, "187268838466488", 10},
  {1.2589865873000552586715389e-12, 9, "", -9},
  {8.2038691257403861817088951e-12, 17, "820387", -11},
  {2.1253102990914453959518660e-04, 6, "213", -3},
  {1.0253094982258292429384989e-17, 9, "", -9},
  {4.0774840318751259360396944e+01, 2, "4077", 2},
  {5.6844099812833987980797978e-04, 13, "5684409981", -3},
  {1.8710416498135540308567215e-04, 5, "19", -3},
  {1.3413311183729785369678211e+01, 19, "134133111837297853697", 2},
  {1.6680574742224246263504028e+07, 7, "166805747422242", 8},
  {3.7089288676330218124349646e-11, 5, "", -5},
  {5.5925999149755248799920082e+06, 4, "5592599915", 7},
  {2.4050829621111679687500000e+12, 15, "240508296211116796875", 13},
  {3.1222145733713333322093454e-11, 8, "", -8},
  {8.5389112532206689710410604e-08, 7, "1", -6},
  {1.0864612856856013876471340e-04, 1, "", -1},
  {1.4859125266443176269531250e+12, 13, "1485912526644317626953125", 13},
  {8.8497288823830900000000000e+15, 9, "884972888238309", 16},
  {1.4998363457298150000000000e+14, 9, "1499836345729815", 15},
  {2.0973811979180460912175477e+05, 9, "209738119791805", 6},
  {1.8814489713476464970501323e-04, 12, "188144897", -3},
  {9.6406009572255816989033583e-17, 16, "1", -15},
  {1.7765441694624206542968750e+10, 7, "177654416946242065", 11},
  {1.6361541945018830299377441e+09, 12, "1636154194501883029938", 10},
  {2.1410929487358106250000000e+14, 12, "2141092948735810625", 15},
  {1.0967624425620635200000000e+17, 15, "109676244256206352", 18},
  {7.3471741839340191744000000e+19, 20, "73471741839340191744", 20},
  {4.7583341657062804675255477e-19, 19, "5", -18},
  {3.8045206197208902011163288e-13, 2, "", -2},
  {3.7546695015620731237616638e-25, 7, "", -7},
  {1.2813944573474386569283376e-12, 18, "1281394", -11},
  {1.5157252514244940784374563e-05, 5, "2", -4},
  {4.5097187825469367723763003e-04, 9, "450972", -3},
  {6.7415600422382931277797409e-13, 9, "", -9},
  {5.9371647110245493876108789e-21, 14, "", -14},
  {2.3113587817229102938654250e+01, 1, "231", 2},
  {4.8717407558484106445312500e+11, 4, "4871740755848411", 12},
  {2.7369232481448957246842920e-11, 2, "", -2},
  {1.0935258548436646725173006e-17, 16, "", -16},
  {2.1138834453434057500000000e+15, 1, "21138834453434058", 16},
  {1.0837605795934904000000000e+17, 9, "10837605795934904", 18},
  {2.5961107761646665030070562e-14, 12, "", -12},
  {4.8536144213930484499999332e-24, 16, "", -16},
  {2.4340384693194121920719155e-12, 5, "", -5},
  {4.5204255023893047109595500e+03, 9, "4520425502389", 4},
  {7.2093764790641698911504282e-12, 14, "721", -11},
  {2.9071961210760826880000000e+19, 15, "2907196121076082688", 20},
  {1.6721284210065401700830157e-04, 6, "167", -3},
  {2.3535406357508500996287251e-20, 11, "", -11},
  {1.0212767231586317421848991e-25, 14, "", -14},
  {5.2934612176599779422243428e-13, 7, "", -7},
  {1.3094243141747617628425360e+06, 14, "130942431417476176284", 7},
  {8.3852773327347499178872973e-25, 11, "", -11},
  {7.7095702373145955502276367e-19, 10, "", -10},
  {1.8514046848165377500000000e+15, 5, "185140468481653775", 16},
  {1.0842764422897082181156584e-13, 11, "", -11},
  {3.2432241534895754966894010e-03, 19, "32432241534895755", -2},
  {6.2697156409568859089631587e+04, 15, "6269715640956885909", 5},
  {2.1387396956978075206279755e+07, 1, "21387397", 8},
  {1.5956861808283915138417797e+02, 16, "1595686180828391514", 3},
  {3.5085887083789978871059347e-14, 9, "", -9},
  {1.4354284473087197682161786e-01, 7, "1435428", 0},
  {1.4859542808623191829042119e-21, 7, "", -7},
  {2.7912489881126758400000000e+18, 8, "279124898811267584", 19},
  {5.1836552027400053906545714e-19, 16, "", -16},
  {1.7574440401543194102157421e-11, 19, "175744404", -10},
  {4.7831288800530890262371585e-20, 3, "", -3},
  {1.0982828696208705139160156e+11, 0, "109828286962", 12},
  {2.9402937168474035685867351e-25, 6, "", -6},
  {8.9429256628110795281827450e+05, 3, "894292566", 6},
  {1.3166875094522785473508817e-22, 9, "", -9},
  {1.0956087630389196800000000e+17, 0, "109560876303891968", 18},
  {5.6868267078376269531250000e+12, 4, "5686826707837627", 13},
  {7.5070132128858030642871968e-21, 3, "", -3},
  {1.8689478605484085208617226e-22, 15, "", -15},
  {3.8830895474373255856335163e+06, 17, "388308954743732558563352", 7},
  {9.9116964888700058739591922e-23, 13, "", -13},
  {4.1186910808037190400000000e+17, 4, "411869108080371904", 18},
  {2.4084039625859493750000000e+14, 0, "240840396258595", 15},
  {4.1038581032467067732926805e-20, 11, "", -11},
  {1.1721695101019472529707759e-24, 19, "", -19},
  {1.1531542614420800418884028e+01, 0, "12", 2},
  {4.9753482872136046353261918e+04, 16, "497534828721360463533", 5},
  {5.0438704177266503173944936e-17, 8, "", -8},
  {5.6129145696529400348663330e+08, 5, "56129145696529", 9},
  {6.6099723755240891409268418e-18, 6, "", -6},
  {2.5558439288527580160000000e+18, 18, "2555843928852758016", 19},
  {4.9680342766775771323750632e+00, 15, "4968034276677577", 1},
  {1.6539039048371583318510282e-13, 10, "", -10},
  {2.9378726898822008164668370e-12, 7, "", -7},
  {3.6271999907748048164179977e-01, 9, "362719999", 0},
  {9.1143725351051405835290610e-17, 16, "1", -15},
  {5.1535311447228205242401107e-14, 1, "", -1},
  {1.1729749758783727365807211e-24, 3, "", -3},
  {9.0776679673489834445123500e-16, 17, "91", -15},
  {8.0657716769073706054687500e+11, 2, "80657716769074", 12},
  {3.2617635765270168304443359e+10, 10, "326176357652701683044", 11},
  {2.8996781175646668874649916e-13, 2, "", -2},
  {5.6601127278500087559223175e+06, 2, "566011273", 7},
  {2.7711672428681522800627653e-13, 6, "", -6},
  {3.2199152484456182271544637e-06, 1, "", -1},
  {1.3644631776454036931402093e-23, 15, "", -15},
  {1.5737650826429646848000000e+19, 16, "15737650826429646848", 20},
  {1.0257960675266902228486288e+02, 1, "1026", 3},
  {1.8454653276126475334167480e+09, 7, "18454653276126475", 10},
  {3.2062645852741174316406250e+11, 14, "3206264585274117431640625", 12},
  {8.2812196050066887291431555e-18, 9, "", -9},
  {7.6239603887861025476599744e-07, 15, "762396039", -6},
  {2.5544921193362327176146209e+05, 2, "25544921", 6},
  {9.6241170089668272424388911e-22, 6, "", -6},
  {1.8244002698690137684921785e-10, 16, "18244", -9},
  {1.0990909840112603759765625e+11, 9, "109909098401126037598", 12},
  {1.7033000574373040000000000e+17, 15, "1703300057437304", 18},
  {7.3629792751661571610672518e-19, 15, "", -15},
  {6.5270076632757440416449102e-04, 17, "65270076632757", -3},
  {1.3323980770085892689070899e-05, 12, "13323981", -4},
  {3.9239328177926074658898870e+02, 4, "3923933", 3},
  {3.0310073280295495411544129e-20, 7, "", -7},
  {2.9071825172499647049910768e-08, 11, "2907", -7},
  {4.2579042889819871279340376e-06, 9, "4258", -5},
  {3.7003859146710068810031766e-10, 10, "4", -9},
  {1.7284971482845181938050561e-23, 16, "", -16},
  {1.7375779337346514239470707e+03, 13, "17375779337346514", 4},
  {3.2084680433157766237854958e+06, 10, "32084680433157766", 7},
  {1.3344196401297342464000000e+19, 11, "13344196401297342464", 20},
  {3.5191571262015637101827625e-03, 1, "", -1},
  {3.9059800303981704928446561e+04, 14, "3905980030398170493", 5},
  {2.2228063955342309594648386e-11, 17, "2222806", -10},
  {1.4274455660853324996518929e-11, 17, "1427446", -10},
  {6.0213692293817972180879553e-12, 20, "602136923", -11},
  {3.7715060284252536183008916e-12, 6, "", -6},
  {1.3349176563565235298369771e+01, 3, "13349", 2},
  {3.2005293518014808654785156e+10, 5, "3200529351801481", 11},
  {2.3680954524139184504747391e+06, 15, "2368095452413918450475", 7},
  {1.0578712985174210000000000e+16, 2, "1057871298517421", 17},
  {7.2113974104302897005780437e-02, 7, "72114", -1},
  {1.4409050597638704640000000e+18, 9, "1440905059763870464", 19},
  {7.0148870881932339216291439e+01, 12, "70148870881932", 2},
  {8.6083606267497840542883914e-14, 4, "", -4},
  {1.1788871649719776257825288e+02, 6, "117888716", 3},
  {4.1703981049384275200000000e+17, 16, "417039810493842752", 18},
  {7.4829680146170028482552590e-19, 17, "", -17},
  {1.2306272633267703808000000e+19, 3, "12306272633267703808", 20},
  {2.0603987940275281920000000e+19, 10, "2060398794027528192", 20},
  {7.1500652548993481323122978e+06, 8, "715006525489935", 7},
  {5.0570484252890503617924644e-15, 19, "5057", -14},
  {1.0230570598661402063118345e-19, 2, "", -2},
  {2.6664137539132596543822729e+01, 13, "266641375391326", 2},
  {2.0196183634982968750000000e+13, 3, "20196183634982969", 14},
  {5.6021576055424564401619136e+04, 18, "56021576055424564401619", 5},
  {5.2046555760845541167555122e-23, 3, "", -3},
  {1.2993496686741738100706817e-06, 4, "", -4},
  {5.8995900213206616129776698e-06, 1, "", -1},
  {7.9349328234771318359375000e+12, 19, "79349328234771318359375", 13},
  {1.2317169983379185664000000e+19, 6, "12317169983379185664", 20},
  {5.4631021395350984448668896e+01, 15, "54631021395350984", 2},
  {3.4834964421315198705997318e+03, 6, "3483496442", 4},
  {5.5738536483467336817492844e-07, 19, "5573853648347", -6},
  {2.6528755889340203008000000e+19, 14, "26528755889340203008", 20},
  {2.0481139120635394047483316e-05, 6, "2", -4},
  {3.7448306799346760000000000e+15, 10, "3744830679934676", 16},
  {2.3919170354078491283852963e-09, 20, "239191703541", -8},
  {4.3590345772652926825685427e+02, 5, "43590346", 3},
  {4.2809792338546857354790200e-23, 20, "", -20},
  {9.9756745259792444874237180e-07, 15, "997567453", -6},
  {1.0006547642840727272632410e-05, 9, "10007", -4},
  {9.8181844708433968480676413e+05, 7, "9818184470843", 6},
  {6.7094624378565912718942459e-19, 16, "", -16},
  {2.8480148578930527966691692e-12, 10, "", -10},
  {6.2547045496385800000000000e+16, 5, "625470454963858", 17},
  {2.2447370310867917642271262e-10, 8, "", -8},
  {2.7198111966181405639648438e+11, 18, "271981119661814056396484375", 12},
  {4.8368873311742258468533209e-15, 8, "", -8},
  {3.2413701982962110184727602e-10, 19, "3241370198", -9},
  {8.8084957238135484658414498e+03, 9, "8808495723814", 4},
  {2.7892329969672788000000000e+16, 11, "27892329969672788", 17},
  {1.3583624385676671968996023e-10, 7, "", -7},
  {1.5201831444793913397006691e+05, 18, "152018314447939133970067", 6},
  {6.1021982963779486886043038e-20, 8, "", -8},
  {6.1383101454726582369381863e-09, 12, "6138", -8},
  {1.7558489780255807813195978e-04, 1, "", -1},
  {8.8223276791331672668457031e+08, 9, "882232767913316727", 9},
  {5.7597238463875477521014545e+01, 20, "5759723846387547752101", 2},
  {1.0355755911125740206303082e-07, 19, "1035575591113", -6},
  {4.0283124085977020656379466e-02, 18, "40283124085977021", -1},
  {8.4063389116826865536669100e-04, 11, "84063389", -3},
  {1.3311279914332754560746253e+05, 4, "1331127991", 6},
  {4.6942135119788447136552216e-23, 0, "", 0},
  {7.8111037688703681851620786e+03, 10, "78111037688704", 4},
  {2.2187847286809560500842053e+03, 16, "22187847286809560501", 4},
  {2.8582773092770885625668598e-01, 0, "", 0},
  {2.1491609035294379282277077e+04, 18, "21491609035294379282277", 5},
  {8.3680497463499050000000000e+15, 1, "8368049746349905", 16},
  {2.1827558811606192128000000e+19, 3, "21827558811606192128", 20},
  {5.7891513262988250055851144e-13, 7, "", -7},
  {4.8604301606467756800000000e+17, 16, "486043016064677568", 18},
  {2.0071033690494891316777813e-17, 16, "", -16},
  {9.6570589460827814400000000e+17, 8, "965705894608278144", 18},
  {1.8774591376803355109191863e-19, 13, "", -13},
  {1.3337338358729917178146762e-15, 17, "133", -14},
  {6.0140173858787673950195312e+10, 5, "6014017385878767", 11},
  {2.8680800450464944839477539e+09, 15, "2868080045046494483947754", 10},
  {6.5083297876082060125536671e-19, 7, "", -7},
  {8.8580386787786172553722026e-23, 17, "", -17},
  {5.7607009527075321600000000e+17, 11, "576070095270753216", 18},
  {2.1434918552139847305898145e-19, 2, "", -2},
  {3.2428471473696256000000000e+18, 7, "32428471473696256", 19},
  {2.9577980776337047252866341e+00, 19, "29577980776337047253", 1},
  {2.8321451168751201750890827e-16, 20, "28321", -15},
  {3.6320068604682419966538201e-15, 20, "363201", -14},
  {9.5498915007703180890530348e+04, 3, "95498915", 5},
  {1.4858588995394152722998981e-06, 6, "1", -5},
  {3.8026760656155674578373575e-07, 9, "38", -6},
  {3.3940274094112069639960867e-22, 5, "", -5},
  {6.4335341973825665995434520e-01, 0, "1", 1},
  {3.2358231252159333437642642e-12, 19, "32358231", -11},
  {3.8934544995626888000000000e+16, 4, "38934544995626888", 17},
  {2.8779396208577267825603485e+06, 9, "2877939620857727", 7},
  {2.4305240079978096000000000e+17, 1, "24305240079978096", 18},
  {2.9076154846928776998016275e-02, 19, "29076154846928777", -1},
  {1.6448542252119852229952812e+07, 17, "1644854225211985222995281", 8},
  {5.0451605163695949913798929e-20, 10, "", -10},
  {1.4081662454469238784000000e+20, 0, "14081662454469238784", 21},
  {2.1967800742113851562500000e+13, 10, "219678007421138515625", 14},
  {9.7599121630006125012457563e-04, 11, "97599122", -3},
  {6.2342285269428119324130674e-06, 12, "6234229", -5},
  {6.6575652703179528000000000e+16, 14, "66575652703179528", 17},
  {4.1227189722806119796892158e-21, 5, "", -5},
  {1.4647741986931709952000000e+19, 17, "14647741986931709952", 20},
  {6.6429193731298283309705255e-02, 14, "664291937313", -1},
  {1.6701880928042490265600000e+20, 19, "167018809280424902656", 21},
  {1.6571528880357202148437500e+11, 11, "16571528880357202148438", 12},
  {1.0960799333802334277379611e-14, 16, "11", -13},
  {3.3492685517372674784244756e-10, 8, "", -8},
  {2.3013932455839685120000000e+18, 1, "2301393245583968512", 19},
  {6.7975667933611232533253933e-07, 2, "", -2},
  {9.0400573469405642752000000e+19, 12, "90400573469405642752", 20},
  {2.1861591464314553782827897e-10, 12, "219", -9},
  {9.5710361040067765625000000e+13, 20, "95710361040067765625", 14},
  {6.8807668153066176512000000e+19, 18, "68807668153066176512", 20},
  {5.3576682250860640000000000e+16, 8, "5357668225086064", 17},
  {2.8717870713771810000000000e+15, 12, "2871787071377181", 16},
  {1.5040008677746787840000000e+18, 14, "1504000867774678784", 19},
  {1.9121143973429256481448395e-17, 9, "", -9},
  {4.4720400719703167676925659e+07, 15, "44720400719703167676926", 8},
  {2.8839207332210569381713867e+09, 9, "2883920733221056938", 10},
  {1.4184311382253783733929005e-13, 12, "", -12},
  {2.2422061489855852775370813e-25, 18, "", -18},
  {2.8683907189722701907157898e+07, 8, "286839071897227", 8},
  {7.4652070607354023437500000e+12, 15, "746520706073540234375", 13},
  {1.6639822128882147955764026e-01, 12, "166398221289", 0},
  {6.3477693144102522158525942e-25, 3, "", -3},
  {3.6704084070260178023753564e-22, 11, "", -11},
  {9.9994258315273601630921303e-15, 10, "", -10},
  {1.4778393200472599609375000e+13, 14, "14778393200472599609375", 14},
  {2.3485195289759947918355465e+06, 13, "23485195289759947918", 7},
  {5.2285566041642148604751128e+01, 18, "52285566041642148605", 2},
  {8.7066972940030624158680439e+05, 11, "87066972940030624", 6},
  {1.7449106965460113715380430e+06, 6, "1744910696546", 7},
  {1.6374382281555473804473877e+07, 5, "1637438228156", 8},
  {4.5282385586254310607910156e+10, 11, "4528238558625431060791", 11},
  {6.2137079885470483398437500e+11, 18, "621370798854704833984375", 12},
  {3.8403825930991979475948028e+03, 9, "3840382593099", 4},
  {2.5209780131692896247841418e+04, 6, "25209780132", 5},
  {2.0572559873596466305016529e-08, 7, "", -7},
  {9.6420445930247497545728663e-02, 4, "964", -1},
  {1.1296853906454166281037033e+05, 20, "11296853906454166281037033", 6},
  {1.4878116878695774039087496e-01, 2, "15", 0},
  {7.2132395274609064017568016e+02, 11, "72132395274609", 3},
  {7.8900288208941158400000000e+17, 14, "789002882089411584", 18},
  {1.3523236074896454811096191e+09, 6, "1352323607489645", 10},
  {8.0832276247624088227894390e+02, 13, "8083227624762409", 3},
  {1.2908907081189569687128018e-20, 0, "", 0},
  {2.8003455495408753530423018e-04, 18, "280034554954088", -3},
  {2.8959552571773090798259206e-23, 10, "", -10},
  {1.3756522036756912231445312e+10, 14, "1375652203675691223144531", 11},
  {1.0669409933474710693359375e+12, 1, "10669409933475", 13},
  {1.4446167089690438842808362e+03, 4, "14446167", 4},
  {4.1270283525891162109375000e+12, 1, "41270283525891", 13},
  {5.7826979238981728515625000e+12, 13, "57826979238981728515625", 13},
  {2.7397701578282444427544894e-22, 7, "", -7},
  {9.9542536063634350080000000e+18, 20, "9954253606363435008", 19},
  {6.7849228926391097301100325e-19, 3, "", -3},
  {1.9630186983355598750156093e-23, 8, "", -8},
  {6.0395218024487772527389057e-14, 7, "", -7},
  {4.7003698548916226610115905e-15, 13, "", -13},
  {6.2321134794826966914369998e-13, 14, "62", -12},
  {4.5176370681274248648357663e-25, 5, "", -5},
  {3.8463122822464242708941092e-16, 5, "", -5},
  {3.5292709957976016448810697e+05, 14, "35292709957976016449", 6},
  {1.9040467681620307499756104e-21, 18, "", -18},
  {2.5022664807593316352000000e+19, 0, "25022664807593316352", 20},
  {5.4696458533246953807672085e-17, 0, "", 0},
  {7.6846813107797964800000000e+17, 0, "768468131077979648", 18},
  {4.0296682260183467087509058e-07, 16, "4029668226", -6},
  {1.9775464708349413163518589e-08, 17, "1977546471", -7},
  {1.1129474467348275356926024e+05, 8, "11129474467348", 6},
  {1.3527893562734438400000000e+18, 14, "135278935627344384", 19},
  {1.6311906821511716524385695e-23, 17, "", -17},
  {2.5490598812517635781502037e-08, 4, "", -4},
  {4.2280567214677734375000000e+10, 6, "42280567214677734", 11},
  {2.1468399603446174095378041e-02, 11, "214683996", -1},
  {4.0469370659535481848934069e+00, 2, "405", 1},
  {6.4588319026058600000000000e+16, 19, "645883190260586", 17},
  {1.3677689392775615283200000e+20, 10, "136776893927756152832", 21},
  {2.0877111579704794165658415e-22, 0, "", 0},
  {2.6270687944901965558528900e+07, 8, "2627068794490197", 8},
  {3.9749382823488485392435335e-09, 2, "", -2},
  {2.1895352369157545873411264e-04, 6, "219", -3},
  {4.3844064070811011002073373e-21, 1, "", -1},
  {2.4361839445390707407296382e-08, 9, "24", -7},
  {4.2938252234338722900484908e-05, 9, "42938", -4},
  {2.9727394340791204617455899e-08, 15, "29727394", -7},
  {2.2382788522328148294999977e-23, 8, "", -8},
  {1.0594056681948954702760098e-21, 16, "", -16},
  {6.1415386500923626816573506e-11, 9, "", -9},
  {3.8389808410728150533941516e+01, 1, "384", 2},
  {9.3457791332320529509107862e-21, 15, "", -15},
  {3.2450249907803988492826846e-07, 16, "3245024991", -6},
  {3.7026552858069660744527487e-09, 17, "370265529", -8},
  {3.9433999974592298269271851e+07, 6, "39433999974592", 8},
  {1.1696989253160171529088984e+02, 5, "11696989", 3},
  {4.1954782606093567665084265e+02, 1, "4195", 3},
  {1.9178501479808257500000000e+15, 7, "191785014798082575", 16},
  {1.5343998989620664833731562e-24, 20, "", -20},
  {1.3876216127553205755031892e-09, 1, "", -1},
  {1.7918021493039722015702497e-10, 18, "179180215", -9},
  {2.9067904792668356160606204e-09, 20, "290679047927", -8},
  {3.4055286635985372123257295e-16, 20, "34055", -15},
  {4.8327759795026912689208984e+09, 4, "48327759795027", 10},
  {1.0035812751025766400000000e+18, 6, "100358127510257664", 19},
  {7.9511341737864466267637908e+04, 18, "79511341737864466267638", 5},
  {1.7407672956187439865889319e-05, 20, "1740767295618744", -4},
  {7.4377367245849931257539872e-12, 0, "", 0},
  {1.2690267338870899051691637e-16, 12, "", -12},
  {3.1136010681192806400000000e+18, 5, "311360106811928064", 19},
  {2.5245369253308459472656250e+11, 3, "252453692533085", 12},
  {1.2394500179651390681101475e+02, 17, "12394500179651390681", 3},
  {2.0758288078521095290120135e-04, 1, "", -1},
  {7.8532233788771027474937389e-19, 20, "79", -18},
  {5.2952186969533903159121095e-14, 19, "529522", -13},
  {1.7877015650455266911750263e-03, 2, "", -2},
  {1.2447779110535109046503764e-23, 9, "", -9},
  {4.6685179930189801025390625e+11, 2, "4668517993019", 12},
  {1.3281137448353157713343745e-24, 2, "", -2},
  {3.1222061741737650919503722e+01, 20, "312220617417376509195", 2},
  {3.0553288566605638840882844e-23, 9, "", -9},
  {6.0476152083670312000000000e+16, 0, "60476152083670312", 17},
  {4.4225148164893645069409107e-21, 14, "", -14},
  {5.2598178493920768750000000e+14, 16, "5259817849392076875", 15},
  {6.0401144975886099244293273e-18, 5, "", -5},
  {3.3092911236502044699918311e-21, 18, "", -18},
  {1.8655065029120871995423396e-11, 5, "", -5},
  {1.2864021762900685406294614e-08, 18, "12864021763", -7},
  {2.1086417431931329003276347e-13, 13, "2", -12},
  {1.1317947903721689726808108e+04, 3, "11317948", 5},
  {8.4510198450598907470703125e+08, 20, "84510198450598907470703125", 9},
  {1.6513868006423638835200000e+20, 4, "165138680064236388352", 21},
  {9.9549490509655603200000000e+17, 19, "995494905096556032", 18},
  {9.6414951020222937011718750e+11, 18, "9641495102022293701171875", 12},
  {3.3230763762286251654560867e-09, 0, "", 0},
  {5.5458159242532041389495134e+05, 18, "554581592425320413894951", 6},
  {3.4576885653830231603933498e+01, 3, "34577", 2},
  {1.3677877029059900283813477e+10, 14, "1367787702905990028381348", 11},
  {2.3732148353737320035186006e-16, 4, "", -4},
  {5.7617953697123399233385579e-13, 20, "57617954", -12},
  {1.2736356444143651562500000e+14, 12, "127363564441436515625", 15},
  {1.2863230346428422927856445e+10, 2, "1286323034643", 11},
  {1.1610141870204186034243321e+03, 17, "116101418702041860342", 4},
  {1.1429058289800923359506069e-24, 19, "", -19},
  {5.1785406685728175000000000e+14, 18, "51785406685728175", 15},
  {2.6897931146185317993164062e+10, 20, "268979311461853179931640625", 11},
  {7.8285090344972938988798994e-04, 7, "7829", -3},
  {4.7141272713704104000000000e+16, 11, "47141272713704104", 17},
  {1.3023508864632571411132812e+11, 14, "13023508864632571411132813", 12},
  {2.4037440229861589614301920e+05, 5, "2403744023", 6},
  {3.2570090423866389755858108e+04, 1, "325701", 5},
  {5.8991785013037320000000000e+16, 2, "5899178501303732", 17},
  {2.1050180723432192694811671e-10, 15, "210502", -9},
  {2.2576954415862783339230926e-07, 8, "23", -6},
  {3.0276712821974234671358773e-24, 4, "", -4},
  {1.0785000763266789376000000e+19, 14, "10785000763266789376", 20},
  {1.1455285773872427917168498e-10, 16, "1145529", -9},
  {3.4181135792292836050876303e+00, 16, "34181135792292836", 1},
  {2.7290095143876515506917266e-07, 13, "272901", -6},
  {2.6156096381605264955538814e-01, 15, "261560963816053", 0},
  {2.8448924087501242756843567e+06, 17, "284489240875012427568436", 7},
  {2.5967734123364460964305947e-09, 19, "25967734123", -8},
  {7.9939950368464817651842658e-24, 1, "", -1},
  {9.1482030354775387500000000e+14, 19, "914820303547753875", 15},
  {1.2956008341913501612230331e-03, 11, "129560083", -2},
  {3.0694854829554691401941941e-08, 12, "30695", -7},
  {8.9265704080101100000000000e+14, 14, "892657040801011", 15},
  {7.1279041773570706936880015e+03, 7, "71279041774", 4},
  {1.4185696701492083171558534e+00, 20, "141856967014920831716", 1},
  {1.5686920679950358765445639e-18, 12, "", -12},
  {6.4931669829116375000000000e+13, 6, "64931669829116375", 14},
  {1.7868993638706289231777191e+07, 18, "17868993638706289231777191", 8},
  {1.5051699847159787924704727e-17, 1, "", -1},
  {2.8229067900750493060313243e-16, 18, "282", -15},
  {1.0999436610118364114896394e+03, 20, "109994366101183641148964", 4},
  {1.3231639300412681195405655e-25, 19, "", -19},
  {6.5141390744089844311304205e-01, 2, "65", 0},
  {3.5734631974776520180279299e-06, 7, "36", -5},
  {8.8662562412105341280721404e+00, 15, "8866256241210534", 1},
  {1.2663703979350664913239299e-02, 19, "126637039793506649", -1},
  {5.4298850795994990000000000e+15, 3, "5429885079599499", 16},
  {1.4489515210002292619625470e-16, 10, "", -10},
  {2.3263032553363776464388107e-16, 10, "", -10},
  {3.8768082237819139181796283e-10, 1, "", -1},
  {4.9691077895658294437453151e+04, 4, "496910779", 5},
  {7.5053649816573542400000000e+19, 6, "750536498165735424", 20},
  {1.4080769994462659040399317e-22, 2, "", -2},
  {1.1170828235713854796073690e-21, 14, "", -14},
  {3.2515218059272289101427073e-13, 7, "", -7},
  {6.0438540165171269327402115e+06, 5, "604385401652", 7},
  {8.9395966405308880000000000e+16, 18, "8939596640530888", 17},
  {2.7880872215111023986170826e-25, 6, "", -6},
  {1.6199600422807162976823747e+05, 20, "16199600422807162976823747", 6},
  {2.8515550829059086815353557e-09, 18, "2851555083", -8},
  {1.5613169598495639038085938e+11, 6, "15613169598495639", 12},
  {1.0339246892396788338791172e-09, 20, "103392468924", -8},
  {3.6747873200406328320000000e+18, 7, "3674787320040632832", 19},
  {1.9568893903302355001448797e-25, 15, "", -15},
  {6.0289066197663490053333104e-07, 9, "603", -6},
  {1.7349138626202300781250000e+13, 2, "173491386262023", 14},
  {6.8344224048340921898897505e-15, 17, "683", -14},
  {5.7439453280043674460137349e-14, 5, "", -5},
  {7.6267512596068674432525647e-03, 11, "762675126", -2},
  {4.6077659742023884800000000e+17, 7, "460776597420238848", 18},
  {3.5380435214066173097224736e-12, 15, "3538", -11},
  {5.6253680257653143008151390e-09, 10, "56", -8},
  {4.9214406127764985535508061e-07, 20, "49214406127765", -6},
  {1.1545979281738458155359695e+02, 12, "115459792817385", 3},
  {3.9886319018083003014845214e-22, 18, "", -18},
  {9.3358672872904469386412529e+02, 16, "9335867287290446939", 3},
  {7.8647821503424169921875000e+11, 15, "78647821503424169921875", 12},
  {1.6845484411213638782501221e+09, 3, "1684548441121", 10},
  {1.2699532595353874778605955e-20, 18, "", -18},
  {8.3993933441438134765625000e+11, 14, "83993933441438134765625", 12},
  {8.2913890050318750368774090e-01, 1, "8", 0},
  {2.7310563666109043866865761e-23, 17, "", -17},
  {1.9764923279997409280000000e+18, 10, "1976492327999740928", 19},
  {5.0428614995575438184676555e-08, 16, "50428615", -7},
  {4.0615074979664170381307177e-19, 11, "", -11},
  {6.2663681181366340381780758e-21, 7, "", -7},
  {1.8414988855774325568395824e-20, 0, "", 0},
  {2.9842397190388858795166016e+10, 1, "298423971904", 11},
  {6.5143369782189190387725830e+08, 4, "6514336978219", 9},
  {8.1543092157709826651488489e-17, 4, "", -4},
  {2.4830085497786077796235696e-05, 15, "24830085498", -4},
  {7.2804722483557983218897416e-19, 16, "", -16},
  {5.2671276426063353600000000e+17, 17, "526712764260633536", 18},
  {3.1126895811626589249954122e+00, 12, "3112689581163", 1},
  {6.0147576675178201804587962e-09, 9, "6", -8},
  {5.3635890848729789257049561e+08, 7, "5363589084872979", 9},
  {9.7740488798806304358400000e+20, 20, "977404887988063043584", 21},
  {4.5194291898788250000000000e+13, 8, "4519429189878825", 14},
  {4.6284912107093197164431331e+02, 4, "4628491", 3},
  {1.5500519062155167351757722e-16, 8, "", -8},
  {5.3251564918790784000000000e+17, 19, "53251564918790784", 18},
  {1.7209500591844944087799958e-17, 2, "", -2},
  {1.3945503171519634000000000e+16, 9, "13945503171519634", 17},
  {8.9733327741030514492997590e-15, 7, "", -7},
  {4.2484102381433126912000000e+20, 2, "42484102381433126912", 21},
  {1.8584308263697527503462495e-05, 2, "", -2},
  {7.4194252313545500000000000e+14, 3, "741942523135455", 15},
  {4.9367767198685058338642788e-17, 18, "49", -16},
  {5.6879048442145469308614811e-12, 1, "", -1},
  {2.2239495030216699775601208e-08, 15, "22239495", -7},
  {2.3929424656896853347738674e-05, 5, "2", -4},
  {8.5334351863067880028150822e-21, 15, "", -15},
  {1.5407001171383249212061426e-21, 18, "", -18},
  {1.8845252680146074853837490e+06, 19, "1884525268014607485383749", 7},
  {5.6103575214309049770236015e+06, 0, "5610358", 7},
  {1.1242483453882526345246617e-02, 3, "11", -1},
  {2.4687826212825505933778913e+01, 18, "24687826212825505934", 2},
  {1.2931321506371682176703142e-04, 11, "12931322", -3},
  {7.1525086008809164800000000e+17, 19, "715250860088091648", 18},
  {3.6902499880909471744000000e+19, 7, "36902499880909471744", 20},
  {2.5524504400831618457876510e-14, 4, "", -4},
  {2.1340507101790321336098820e-22, 14, "", -14},
  {1.8628141564903704586735625e-08, 17, "1862814156", -7},
  {3.6834211350007665160960491e-05, 20, "3683421135000767", -4},
  {1.8967001214362053120000000e+18, 1, "1896700121436205312", 19},
  {7.4034144166042472099065378e-10, 17, "74034144", -9},
  {1.0229258889916648444695182e-21, 15, "", -15},
  {6.8784646864216785972968592e-19, 12, "", -12},
  {1.1661247098616206000000000e+16, 17, "11661247098616206", 17},
  {1.6679940291573170176000000e+19, 17, "16679940291573170176", 20},
  {1.9562673636185287762145890e+01, 7, "195626736", 2},
  {5.0731238748456979337220218e+00, 9, "5073123875", 1},
  {2.9799991103877579410095290e-15, 17, "298", -14},
  {3.1682278498756866455078125e+10, 11, "3168227849875686645508", 11},
  {2.2243002300645465625000000e+14, 5, "22243002300645465625", 15},
  {3.2565990576048909489585443e-07, 13, "3256599", -6},
  {5.0385151461898252838779251e-17, 12, "", -12},
  {5.2540289419130570499280276e-21, 6, "", -6},
  {4.0034458059709139347240085e-24, 18, "", -18},
  {5.8124453987610137600000000e+17, 4, "581244539876101376", 18},
  {3.9220242211627328349311357e-22, 5, "", -5},
  {2.2118495539071182065526955e+02, 19, "2211849553907118206553", 3},
  {4.0113344621941821044330823e-01, 19, "4011334462194182104", 0},
  {7.3779428826795801149064090e-11, 3, "", -3},
  {5.0776564678175112931057811e+05, 0, "507766", 6},
  {3.4288124243386262685859458e-16, 1, "", -1},
  {1.0211019481864949035644531e+11, 7, "1021101948186494904", 12},
  {1.0814392717821612358093262e+09, 4, "10814392717822", 10},
  {8.9609219704449329102491362e-03, 20, "896092197044493291", -2},
  {2.6247392732224530692446739e-21, 15, "", -15},
  {2.1388260480265696048736572e+09, 0, "2138826048", 10},
  {3.2803532757442008005455136e+02, 19, "3280353275744200800546", 3},
  {1.4137949232091645127077562e-25, 18, "", -18},
  {1.0684149164364717756654070e-21, 2, "", -2},
  {2.0718498673630890039021324e+01, 4, "207185", 2},
  {1.8310793908171055316925049e+09, 3, "1831079390817", 10},
  {4.0003428256806347462770646e+02, 13, "4000342825680635", 3},
  {2.2264218199080435311998372e+01, 17, "2226421819908043531", 2},
  {5.9061484707914769806132639e-15, 17, "591", -14},
  {1.2960124230657733120000000e+18, 0, "1296012423065773312", 19},
  {9.0677832260075474923866068e-02, 10, "906778323", -1},
  {1.0659589649566657500000000e+15, 17, "106595896495666575", 16},
  {1.5096505590518936514854431e+05, 15, "150965055905189365149", 6},
  {1.8398446201253125000000000e+11, 17, "18398446201253125", 12},
  {3.1043360961167176803598977e+00, 6, "3104336", 1},
  {9.9234911773954975874860241e-19, 16, "", -16},
  {8.7495800505435236135587814e-18, 11, "", -11},
  {1.2024587248423813434783369e+02, 15, "120245872484238134", 3},
  {1.8813437971693444648016618e-17, 3, "", -3},
  {1.0509602066545460641311394e-01, 4, "1051", 0},
  {2.2784545341179656982421875e+10, 2, "2278454534118", 11},
  {4.2093037705321513175741257e-09, 3, "", -3},
  {6.0736651642119092866778374e+05, 0, "607367", 6},
  {9.8039322584203697526639762e-21, 2, "", -2},
  {1.4721738256989872000000000e+16, 9, "14721738256989872", 17},
  {5.5297139206219962500000000e+14, 6, "552971392062199625", 15},
  {3.1049219034311190601935829e-25, 11, "", -11},
  {1.3567929055260645225644112e+07, 17, "1356792905526064522564411", 8},
  {2.3354871255223847925662994e+07, 16, "23354871255223847925663", 8},
  {1.6069018745057781112628437e-03, 9, "1606902", -2},
  {1.1468929550801956402039226e-19, 3, "", -3},
  {5.8251569689124703407287598e+08, 6, "582515696891247", 9},
  {2.1244814119010192000000000e+16, 3, "21244814119010192", 17},
  {1.4109917308698070885838626e-08, 11, "1411", -7},
  {1.1116483508809373859094194e+01, 6, "11116484", 2},
  {6.0124008285301120620353038e-10, 3, "", -3},
  {1.7557802891946753393037639e-02, 11, "1755780289", -1},
  {4.1870905942943640053272247e+07, 18, "41870905942943640053272247", 8},
  {6.7540755743272355175577104e+04, 15, "67540755743272355176", 5},
  {1.4003044496692082248046063e+04, 19, "140030444966920822480461", 5},
  {6.9375883635454703125000000e+13, 11, "69375883635454703125", 14},
  {2.7259778284300990489844724e-05, 4, "", -4},
  {1.7838101346535392000000000e+17, 14, "17838101346535392", 18},
  {2.1049817106744765000000000e+15, 7, "21049817106744765", 16},
  {2.2924144264422843116335571e+05, 8, "22924144264423", 6},
  {9.0190378976831021095954526e-07, 20, "90190378976831", -6},
  {4.4982151555210308016552467e-03, 4, "45", -2},
  {5.6800061137755251200000000e+17, 12, "568000611377552512", 18},
  {1.5504569571411855061909835e-03, 11, "155045696", -2},
  {4.5549965771630696002107686e-08, 18, "45549965772", -7},
  {9.5224004627067316925377647e-18, 14, "", -14},
  {6.1224726601915655717378074e-06, 18, "6122472660192", -5},
  {1.5395748706368367671966553e+09, 3, "1539574870637", 10},
  {3.6789269449447249043030905e-04, 15, "367892694494", -3},
  {3.6917066751366594535057027e-11, 15, "36917", -10},
  {2.2060321976136707171565115e-21, 11, "", -11},
  {6.9110292850489952000000000e+16, 1, "69110292850489952", 17},
  {8.1105889048900505600000000e+17, 10, "811058890489005056", 18},
  {1.4027084292993030548095703e+10, 16, "140270842929930305480957031", 11},
  {5.5219900341375406250000000e+14, 9, "5521990034137540625", 15},
  {6.6109065577548778054244394e-16, 13, "", -13},
  {1.4847879775309191165157165e-08, 18, "14847879775", -7},
  {1.0151280078680915625000000e+14, 18, "10151280078680915625", 15},
  {8.7856672581370815995560546e-12, 0, "", 0},
  {4.2640316529475742052257559e-03, 18, "4264031652947574", -2},
  {2.4217619106923408139207875e-09, 9, "2", -8},
  {6.8111344969378203153610229e+07, 9, "68111344969378203", 8},
  {5.1377518449866870579845722e-06, 18, "5137751844987", -5},
  {4.7755652165036554240000000e+18, 4, "4775565216503655424", 19},
  {1.2722261504116075000000000e+15, 14, "12722261504116075", 16},
  {2.7580740810021122867200000e+20, 9, "275807408100211228672", 21},
  {6.7149053356254351360000000e+18, 13, "6714905335625435136", 19},
  {1.7980989503819956250000000e+14, 6, "1798098950381995625", 15},
  {3.8939188602515775710344315e+06, 13, "3893918860251577571", 7},
  {2.1737105396404888000000000e+16, 13, "21737105396404888", 17},
  {9.7478334231430405765195246e+00, 20, "974783342314304057652", 1},
  {5.1292819872148777242954924e-20, 8, "", -8},
  {7.1411153298074005861387394e-11, 15, "71411", -10},
  {6.4352730253697314765304327e+04, 9, "64352730253697", 5},
  {1.3704082403318202767529034e-05, 19, "137040824033182", -4},
  {1.5675041560467746000000000e+16, 16, "15675041560467746", 17},
  {1.8933463331093343118283201e+00, 0, "2", 1},
  {1.1066057770801813760000000e+18, 7, "1106605777080181376", 19},
  {2.4909254141958087680000000e+18, 12, "2490925414195808768", 19},
  {2.2562652477215586088732380e+01, 18, "22562652477215586089", 2},
  {8.4368724090663604897599726e+00, 7, "84368724", 1},
  {1.5419500474372061157226562e+11, 18, "154195004743720611572265625", 12},
  {1.3122755465016076171875000e+13, 13, "13122755465016076171875", 14},
  {9.4353002666542625427246094e+09, 17, "943530026665426254272460938", 10},
  {1.8408311460734567737653141e-18, 20, "184", -17},
  {1.2490671153043258446234161e-17, 12, "", -12},
  {2.4904388142961844368656905e-06, 20, "249043881429618", -5},
  {1.1622816274682970112000000e+20, 14, "11622816274682970112", 21},
  {9.0336913148772388696670532e+07, 15, "90336913148772388696671", 8},
  {2.0293276840095367674621230e+02, 10, "202932768401", 3},
  {1.6803293639532192610204220e+06, 15, "168032936395321926102", 7},
  {1.0356504784627160870025264e-02, 6, "10357", -1},
  {2.5679986677287307705093058e-23, 10, "", -10},
  {1.0755483517957285983807775e-04, 16, "1075548351796", -3},
  {8.7473827408999455129600000e+20, 10, "874738274089994551296", 21},
  {5.5164316345383641183555066e-12, 0, "", 0},
  {2.0686173991092880047881764e-02, 2, "2", -1},
  {2.1576258565087197639398453e-17, 13, "", -13},
  {2.0248440299190471191406250e+12, 5, "202484402991904712", 13},
  {6.5894324897548362494151171e-18, 14, "", -14},
  {2.6199897785391574096679688e+11, 6, "261998977853915741", 12},
  {1.4224692459985749214005160e-05, 12, "14224692", -4},
  {8.7478470172108347595443499e-10, 8, "", -8},
  {1.1775073359845559689141559e-19, 3, "", -3},
  {1.0346854323220210147837861e+01, 1, "103", 2},
  {5.5378907185499895468297323e-19, 17, "", -17},
  {1.1173020435395764072780931e-10, 9, "", -9},
  {1.4343989943490418750000000e+14, 16, "1434398994349041875", 15},
  {4.2359275926506687500000000e+14, 2, "42359275926506688", 15},
  {6.1064481915141619712000000e+19, 4, "61064481915141619712", 20},
  {6.4151076346961479953516898e-15, 13, "", -13},
  {2.9881210099477157928049564e+05, 2, "2988121", 6},
  {4.7943083485461868674393227e-05, 13, "479430835", -4},
  {1.5563889070778337500000000e+15, 16, "155638890707783375", 16},
  {2.7049121558063671112060547e+10, 5, "2704912155806367", 11},
  {1.3184720369821047973632812e+11, 9, "131847203698210479736", 12},
  {4.3059802109384010831601283e-23, 11, "", -11},
  {2.2121965359899093375013532e-18, 20, "221", -17},
  {1.6063476527563652489334345e+06, 8, "160634765275637", 7},
  {2.9281534576683079550477300e-06, 12, "2928153", -5},
  {9.7639327178710420308827000e-04, 1, "", -1},
  {3.7318654791504182815551758e+09, 16, "37318654791504182815551758", 10},
  {1.8311533118562708000000000e+16, 17, "18311533118562708", 17},
  {5.7925473384353947648000000e+19, 11, "57925473384353947648", 20},
  {1.3987098720013992902977407e+01, 8, "1398709872", 2},
  {7.5253685636916000000000000e+13, 14, "75253685636916", 14},
  {8.0455763615835785458330065e+03, 13, "80455763615835785", 4},
  {1.6492242639196890162886907e-14, 20, "1649224", -13},
  {6.9083967361077087402343750e+10, 19, "6908396736107708740234375", 11},
  {3.2907729110149704002674555e-25, 1, "", -1},
  {1.3543796942929311381008588e-14, 9, "", -9},
  {4.8720613850488779368976717e-14, 8, "", -8},
  {2.0474007597396896000000000e+16, 11, "20474007597396896", 17},
  {1.7344025794465915532782674e+05, 7, "1734402579447", 6},
  {5.7922100190700982165511921e-19, 19, "6", -18},
  {1.6191268154027586250109607e-25, 0, "", 0},
  {3.0766471127925592222013430e-21, 0, "", 0},
  {6.8891053886569826104283814e-13, 5, "", -5},
  {8.0235599228920935058593750e+11, 8, "80235599228920935059", 12},
  {1.4232334157353216171264648e+10, 11, "1423233415735321617126", 11},
  {3.0929873267267124901991338e+04, 4, "309298733", 5},
  {2.1070384231116442992675364e-08, 18, "21070384231", -7},
  {3.2851783355097451964128189e-24, 10, "", -10},
  {6.8118816567192125320434570e+09, 14, "681188165671921253204346", 10},
  {3.1106419554832873153718299e-21, 4, "", -4},
  {3.5848524221991445070628472e-07, 10, "3585", -6},
  {2.1408776511799043546655615e-21, 9, "", -9},
  {6.0907749908093811262027595e-05, 14, "6090774991", -4},
  {2.6589986383330781245604157e+05, 20, "26589986383330781245604157", 6},
  {4.0927389981381468160000000e+19, 7, "4092738998138146816", 20},
  {4.0961337391618144465610385e+00, 5, "409613", 1},
  {1.7729961122717910238048596e-23, 19, "", -19},
  {1.8397529919896316030758499e-01, 13, "183975299199", 0},
  {5.3964646871826928664637601e-24, 2, "", -2},
  {1.5978614568419069051742554e+07, 15, "15978614568419069051743", 8},
  {6.8072486706387243270874023e+09, 3, "6807248670639", 10},
  {6.1121966918369874203624840e-07, 12, "61122", -6},
  {1.5256625811712885725396286e-22, 19, "", -19},
  {1.8038036751633003815587730e-20, 2, "", -2},
  {8.5650436518683680333197117e+05, 13, "8565043651868368033", 6},
  {1.1307331972582497410069431e-14, 0, "", 0},
  {8.6412470569535620502389650e-05, 0, "", 0},
  {1.7060536093078955066917640e-18, 6, "", -6},
  {1.4037796841761959966320229e-22, 19, "", -19},
  {6.3491532702644027709960938e+10, 0, "63491532703", 11},
  {2.1912633150756661848390650e+00, 15, "2191263315075666", 1},
  {7.1424022135082373046875000e+12, 4, "71424022135082373", 13},
  {3.1142038911279366400000000e+17, 6, "311420389112793664", 18},
  {9.6610405879446947574615479e+08, 12, "966104058794469475746", 9},
  {2.3287413454182038846516350e-08, 0, "", 0},
  {1.5944639807135458795528393e+03, 6, "1594463981", 4},
  {6.1032523983429181575775146e+08, 20, "61032523983429181575775146484", 9},
  {7.4527044116227547654318641e-01, 1, "7", 0},
  {1.7226702426059989359252711e-02, 2, "2", -1},
  {1.7220863053740825000000000e+15, 12, "17220863053740825", 16},
  {2.8304479502021677792072296e+07, 3, "28304479502", 8},
  {5.2070548040663993358612061e+08, 12, "520705480406639933586", 9},
  {3.2441382760657584803795032e-08, 14, "3244138", -7},
  {8.8644766702678271488115140e-23, 9, "", -9},
  {4.2087064865712485000000000e+15, 4, "42087064865712485", 16},
  {1.4977442818508762911733356e+02, 2, "14977", 3},
  {9.0006491234002775980544897e-23, 8, "", -8},
  {7.5205556683635389804840088e+08, 1, "7520555668", 9},
  {1.9323245884142002068983857e+03, 17, "19323245884142002069", 4},
  {6.1586065426323537920000000e+20, 1, "6158606542632353792", 21},
  {2.3562038439840922121565162e-21, 18, "", -18},
  {1.0776431253000891211550911e-14, 19, "107764", -13},
  {1.5957772694620015940757998e-18, 10, "", -10},
  {8.9758922469284750000000000e+13, 15, "8975892246928475", 14},
  {2.3831297710250088464425588e-24, 4, "", -4},
  {4.0259182477887043205555528e+04, 14, "4025918247788704321", 5},
  {5.5361095546489364616201886e-06, 19, "55361095546489", -5},
  {1.8936010839698685952000000e+19, 2, "18936010839698685952", 20},
  {2.1588446032870483398437500e+11, 5, "21588446032870483", 12},
  {1.2142976395630368513511854e-02, 3, "12", -1},
  {5.4333498956944767822180298e-04, 16, "5433349895694", -3},
  {2.9002081244394688000000000e+16, 1, "29002081244394688", 17},
  {1.2679817380447483446914703e+05, 19, "126798173804474834469147", 6},
  {2.2477362501894929920000000e+18, 12, "2247736250189492992", 19},
  {8.1557655288690948509611189e+04, 3, "81557655", 5},
  {1.9082588949939312744140625e+11, 3, "190825889499393", 12},
  {6.1546210408237840000000000e+16, 18, "6154621040823784", 17},
  {2.1846809218497457264357519e-18, 0, "", 0},
  {9.4705831952662527561187744e+07, 4, "947058319527", 8},
  {5.3978431178546360000000000e+15, 8, "5397843117854636", 16},
  {7.9787281997038788294843354e-08, 18, "79787281997", -7},
  {6.2170932707857419363343410e-10, 9, "1", -8},
  {2.4648194566919522094726562e+11, 5, "24648194566919522", 12},
  {4.4323727922306970228305545e+00, 16, "4432372792230697", 1},
  {3.9122253691417929656105767e-22, 8, "", -8},
  {1.2786554686828864047928404e-19, 1, "", -1},
  {8.2626626202917119456969886e+00, 4, "82627", 1},
  {2.3921752289950739941559732e+05, 12, "239217522899507399", 6},
  {3.6302821615599336216094706e-08, 1, "", -1},
  {1.7249732436720448344164413e-09, 7, "", -7},
  {1.2503273607317031412833330e+00, 11, "125032736073", 1},
  {8.5277169206818509846925735e+06, 2, "852771692", 7},
  {9.6303636606545550691294011e-01, 4, "963", 0},
  {2.2921074808726504216495609e-10, 6, "", -6},
  {1.4204526740721461705158523e-14, 19, "142045", -13},
  {3.4887706366237072300238718e-10, 9, "", -9},
  {2.5918114855436805823686922e-20, 2, "", -2},
  {1.0562422493728299618507714e-09, 10, "11", -8},
  {4.1967596783235537109375000e+12, 8, "419675967832355371094", 13},
  {4.4191834658251713859407273e-14, 12, "", -12},
  {2.2688174457529263436160596e-22, 6, "", -6},
  {6.9026309958674266934394836e+07, 19, "690263099586742669343948364", 8},
  {1.1935123744065979539752695e-23, 9, "", -9},
  {1.5852207036947619200000000e+17, 16, "158522070369476192", 18},
  {1.0742925912356020312500000e+14, 18, "107429259123560203125", 15},
  {4.2276871406034742492803305e-15, 6, "", -6},
  {7.9487653998108876800000000e+18, 14, "794876539981088768", 19},
  {3.2255319493379044385882953e-19, 10, "", -10},
  {8.2315290590499329281826135e-03, 10, "82315291", -2},
  {5.0525945433820828611715115e+02, 19, "5052594543382082861172", 3},
  {1.6207800420227389592142731e-10, 3, "", -3},
  {4.3302882028201734400000000e+17, 9, "433028820282017344", 18},
  {1.4035785574225906682799270e-03, 15, "1403578557423", -2},
  {3.7814080112624720575453807e-01, 18, "378140801126247206", 0},
  {3.7696521810768523118252617e-06, 6, "4", -5},
  {2.9083567798847440339581271e-25, 9, "", -9},
  {2.0742904835423155200000000e+17, 11, "207429048354231552", 18},
  {1.9567919844020251066499250e-04, 6, "196", -3},
  {1.2096986957080836148589222e-06, 12, "1209699", -5},
  {4.1064383888863846400000000e+17, 13, "410643838888638464", 18},
  {1.0968777538567896250000000e+15, 17, "1096877753856789625", 16},
  {8.1950295567471592696881955e-18, 12, "", -12},
  {4.8530681205882528000000000e+17, 3, "48530681205882528", 18},
  {9.4507729112718992998400000e+20, 0, "945077291127189929984", 21},
  {7.8158270809180076616698310e-17, 8, "", -8},
  {1.1128553786305586470462003e+02, 7, "1112855379", 3},
  {6.2831058327603255509749026e-10, 0, "", 0},
  {7.7029354623300855564593803e+02, 7, "7702935462", 3},
  {3.0801257873962866142392159e+06, 20, "308012578739628661423921585", 7},
  {4.4270991352742632812500000e+13, 11, "442709913527426328125", 14},
  {1.0857789937865583648886407e-20, 8, "", -8},
  {2.1712707421591880847699940e+05, 4, "2171270742", 6},
  {1.4387088878772298508622790e-25, 17, "", -17},
  {1.7625503937574285018285991e+00, 3, "1763", 1},
  {1.9984680594322946944885189e+03, 12, "1998468059432295", 4},
  {1.1270772568937313065734972e-07, 4, "", -4},
  {2.2361985002338833595200308e-25, 0, "", 0},
  {5.8201222297924174927175045e+05, 1, "5820122", 6},
  {3.5425866722533089214763891e-01, 7, "3542587", 0},
  {1.0227598732652234403417424e+00, 15, "1022759873265223", 1},
  {1.5217021350254080971353687e+04, 14, "1521702135025408097", 5},
  {1.0964787177223688960000000e+18, 15, "1096478717722368896", 19},
  {9.7647126090142842320075884e-08, 3, "", -3},
  {1.3147808785873150300352984e-25, 16, "", -16},
  {3.1050500143714643200000000e+17, 2, "310505001437146432", 18},
  {3.6093630057110442487661173e-05, 1, "", -1},
  {3.9215007745719082574949342e-20, 4, "", -4},
  {3.4209285045346365065999686e-22, 6, "", -6},
  {4.2109296474462571495678276e+03, 5, "421092965", 4},
  {6.4814330322232510483683163e-11, 0, "", 0},
  {1.4759330555172489600000000e+17, 10, "147593305551724896", 18},
  {1.5867719470469540128910247e-11, 3, "", -3},
  {4.5740584775283468262175586e-16, 1, "", -1},
  {7.9342351669076581563741382e-17, 4, "", -4},
  {2.4305707174695525721807819e-15, 12, "", -12},
  {8.3142942841185713186860085e+06, 7, "83142942841186", 7},
  {3.6374725348870867919921875e+11, 15, "36374725348870867919921875", 12},
  {3.3004691115001230468750000e+12, 20, "3300469111500123046875", 13},
  {3.5815600908227678347839351e-03, 3, "4", -2},
  {1.5563425189753792210467509e+02, 16, "1556342518975379221", 3},
  {1.0786810613431680394569412e+04, 3, "10786811", 5},
  {2.0026148020666385000000000e+15, 7, "20026148020666385", 16},
  {4.8802792114031552734375000e+12, 2, "488027921140316", 13},
  {4.9660236959885807461820159e-12, 6, "", -6},
  {2.3908657975244106250000000e+14, 2, "23908657975244106", 15},
  {4.6989207399030372619628906e+10, 15, "46989207399030372619628906", 11},
  {5.5699550713118655412958408e-20, 2, "", -2},
  {3.4124148369181893218908108e-25, 13, "", -13},
  {3.4300365825470601312802497e-15, 5, "", -5},
  {9.6612554896687745656304326e-18, 2, "", -2},
  {2.5333478787577516800000000e+17, 9, "253334787875775168", 18},
  {1.9445095683624746829565311e-01, 16, "1944509568362475", 0},
  {1.0025666542670158727645902e-03, 18, "1002566654267016", -2},
  {6.4453805905124650008075626e-03, 13, "64453805905", -2},
  {3.5359706077335614225222562e-20, 4, "", -4},
  {4.9099419678690289306640625e+11, 1, "4909941967869", 12},
  {1.3695379188336230000000000e+16, 3, "1369537918833623", 17},
  {1.9519138135137677153969678e-22, 16, "", -16},
  {4.8580501453683569459200000e+20, 7, "485805014536835694592", 21},
  {2.4323485017542015307334680e-01, 8, "24323485", 0},
  {1.6690552250292933064477566e-24, 8, "", -8},
  {1.4054815088327732155448757e+03, 8, "140548150883", 4},
  {1.1646599078337454687500000e+14, 12, "116465990783374546875", 15},
  {3.1213038632598500754511406e+01, 17, "3121303863259850075", 2},
  {4.1769221798975529670715332e+09, 16, "41769221798975529670715332", 10},
  {6.4607092669870882816000000e+19, 19, "64607092669870882816", 20},
  {3.9246804655726642930269179e-08, 9, "39", -7},
  {6.0292228493791311452754123e-03, 17, "602922284937913", -2},
  {1.7142609213663420192612797e-07, 8, "17", -6},
  {1.6462291785769078899986522e-24, 5, "", -5},
  {6.2597955315201725992669097e-20, 7, "", -7},
  {3.8908166813610487500000000e+14, 18, "389081668136104875", 15},
  {2.0137049800907712325200530e-23, 6, "", -6},
  {6.4508399349981944000000000e+16, 18, "64508399349981944", 17},
  {1.9150624782279043579101562e+11, 11, "19150624782279043579102", 12},
  {3.1394527858641554755869674e-03, 11, "313945279", -2},
  {1.1957093264855197954677407e-18, 10, "", -10},
  {4.7072573321306643967233642e-07, 11, "47073", -6},
  {3.8731481478579012798529237e-10, 18, "387314815", -9},
  {2.5116913520941218374016302e-02, 19, "251169135209412184", -1},
  {1.0228450749841984661510363e-04, 1, "", -1},
  {1.4633313896165545000000000e+15, 7, "14633313896165545", 16},
  {7.4748286220818199217319489e+06, 19, "74748286220818199217319489", 7},
  {3.8405006111609002461548812e-01, 19, "3840500611160900246", 0},
  {2.0045511599964821124190536e-08, 5, "", -5},
  {4.5263611637610819889232516e+05, 0, "452636", 6},
  {9.2185520214808702468872070e+07, 16, "921855202148087024688721", 8},
  {1.0652541717231612564235023e-18, 14, "", -14},
  {2.7971005895976083456000000e+19, 6, "27971005895976083456", 20},
  {1.6313258576054083715976481e-07, 14, "16313259", -6},
  {2.4493623532208918578004375e-15, 5, "", -5},
  {3.9245464603820898204923270e-13, 16, "3925", -12},
  {1.3122130208790156990289688e+07, 2, "1312213021", 8},
  {5.6939462228144748823915979e-09, 4, "", -4},
  {2.4283225640051369704141768e-05, 7, "243", -4},
  {1.0151740766038998700995111e-19, 6, "", -6},
  {4.8085014297357172241273546e-12, 13, "48", -11},
  {6.0639924546739028718376744e-18, 3, "", -3},
  {3.9004576416527228944347572e-04, 4, "4", -3},
  {1.6991305682076662109375000e+13, 17, "16991305682076662109375", 14},
  {2.8428698519255658973868721e-17, 15, "", -15},
  {1.7961188211218551329825386e-12, 11, "", -11},
  {2.0839870154177084771163209e+00, 4, "2084", 1},
  {2.9379298861145890953139315e+01, 6, "29379299", 2},
  {3.5150768129893770240000000e+18, 19, "3515076812989377024", 19},
  {1.4130790804035065377775027e+01, 17, "1413079080403506538", 2},
  {1.0073616106732678765478539e-01, 15, "100736161067327", 0},
  {2.5564288477111853685509000e-08, 7, "", -7},
  {6.2216671976749113344000000e+19, 11, "62216671976749113344", 20},
  {2.2847901481537559293896224e-06, 15, "2284790148", -5},
  {4.5282548633256079360000000e+18, 9, "4528254863325607936", 19},
  {2.1624212864512684131057059e-17, 10, "", -10},
  {1.9409324435168647774753201e-19, 17, "", -17},
  {3.1990668483899867136000000e+19, 12, "31990668483899867136", 20},
  {1.4988517751821091625548324e-25, 8, "", -8},
  {9.8574481918257408352701532e+00, 20, "985744819182574083527", 1},
  {6.1510816902441515625000000e+13, 5, "6151081690244151563", 14},
  {4.5269525119573461266762724e-19, 6, "", -6},
  {3.5196720803439025682864149e-07, 7, "4", -6},
  {4.1143328487166680451636580e-01, 4, "4114", 0},
  {4.5872016195774449442978948e+04, 5, "458720162", 5},
  {7.0639016374458503723144531e+08, 20, "7063901637445850372314453125", 9},
  {4.0685533904895444334039590e-14, 4, "", -4},
  {2.9546323570638687669998035e+04, 12, "29546323570638688", 5},
  {3.5332588611418002877108171e-24, 13, "", -13},
  {1.0293644382124537338264042e-17, 18, "1", -16},
  {2.6185804945098819732666016e+10, 12, "26185804945098819732666", 11},
  {5.3364208484544574384589311e-04, 0, "", 0},
  {6.7890496859551618603708290e-19, 0, "", 0},
  {3.6664737298482641601562500e+11, 16, "366647372984826416015625", 12},
  {2.1658461248649109375000000e+14, 3, "216584612486491094", 15},
  {9.6477023388752888877206715e+02, 18, "964770233887528888772", 3},
  {2.1946515324006353609633289e-09, 9, "2", -8},
  {1.3111772207609459200000000e+18, 15, "131117722076094592", 19},
  {6.9728888799243588566406649e-04, 2, "", -2},
  {9.8274173400633650922572949e-17, 16, "1", -15},
  {8.8549443035604992000000000e+17, 10, "88549443035604992", 18},
  {7.8224871746022853295895350e-22, 7, "", -7},
  {1.8548829623577485068440560e-20, 4, "", -4},
  {4.6286556608259087272772072e-20, 19, "", -19},
  {9.1831596183349082092957874e-12, 17, "918316", -11},
  {9.3525448797227109375000000e+13, 7, "93525448797227109375", 14},
  {1.0667002462898892895296586e-05, 1, "", -1},
  {1.6190695400235660800000000e+17, 1, "161906954002356608", 18},
  {1.6900706889208275890522228e-19, 8, "", -8},
  {4.4486260549579965538520565e-05, 10, "444863", -4},
  {1.4280214292138723144531250e+12, 15, "1428021429213872314453125", 13},
  {3.3476223022513230108676357e-14, 4, "", -4},
  {1.2191773028217423302521638e+02, 20, "12191773028217423302522", 3},
  {2.6650523175180756000000000e+16, 15, "26650523175180756", 17},
  {3.0439058466508476864716109e-22, 0, "", 0},
  {3.7815773678192733787000179e+06, 19, "37815773678192733787000179", 7},
  {5.2440330917383366252843278e-17, 8, "", -8},
  {1.3302600619975715644479062e-15, 6, "", -6},
  {6.4222642452713619456000000e+19, 6, "64222642452713619456", 20},
  {3.3300538850260788178991866e-03, 3, "3", -2},
  {6.1878089478939809793378491e-11, 17, "6187809", -10},
  {6.2757916952193765517738889e-16, 6, "", -6},
  {6.6413115542421326041221619e+07, 16, "664131155424213260412216", 8},
  {4.5285684187771324538118733e-01, 3, "453", 0},
  {2.0204631919967578141950071e+04, 8, "2020463191997", 5},
  {1.7083342784914440917968750e+12, 16, "1708334278491444091796875", 13},
  {9.1248827422806630949025930e+00, 7, "91248827", 1},
  {3.8058600894744973629713058e+04, 7, "380586008947", 5},
  {2.4957378943897911296000000e+20, 20, "24957378943897911296", 21},
  {2.3067631818967822584438373e-24, 18, "", -18},
  {1.4983959231871845551944046e-19, 19, "1", -18},
  {2.2818877790495652042287756e-21, 9, "", -9},
  {2.5455875278489640913903713e+06, 13, "25455875278489640914", 7},
  {1.1141855531549304873497295e-11, 7, "", -7},
  {1.1016214601197985677547378e-18, 14, "", -14},
  {1.0530231200728764658015706e-20, 13, "", -13},
  {1.3181246990811955765821040e+05, 7, "1318124699081", 6},
  {1.1595339785939325000000000e+14, 0, "115953397859393", 15},
  {8.3912085034227986845989092e-19, 4, "", -4},
  {1.6604529558518986881163681e-24, 4, "", -4},
  {5.7797869734357123072000000e+19, 5, "57797869734357123072", 20},
  {2.7217783227538968750000000e+13, 2, "2721778322753897", 14},
  {1.1223473027640005767868042e-04, 20, "11223473027640006", -3},
  {2.1016060759053592000000000e+16, 9, "21016060759053592", 17},
  {4.7660829986155396909452975e+04, 16, "476608299861553969095", 5},
  {9.7325830758316099643707275e+07, 3, "97325830758", 8},
  {1.5597327335338460000000000e+15, 5, "1559732733533846", 16},
  {1.7658810706443125026190112e-10, 7, "", -7},
  {3.8617879391276190000000000e+15, 6, "3861787939127619", 16},
  {6.6378566169373681640625000e+11, 4, "6637856616937368", 12},
  {1.7542336067460958222191178e-25, 5, "", -5},
  {2.5320322571872763563253512e-20, 8, "", -8},
  {1.7556238029864372102147386e-11, 6, "", -6},
  {2.3665154797208324052372604e-25, 9, "", -9},
  {5.7331005769742052759622985e-12, 18, "5733101", -11},
  {1.4176564848001771422067636e-23, 1, "", -1},
  {4.3704770614149256834345689e-07, 4, "", -4},
  {1.7202749129949939949774107e-04, 0, "", 0},
  {4.2917415903284916877746582e+09, 7, "42917415903284917", 10},
  {7.5744614518274018038287383e-18, 0, "", 0},
  {4.6425283798362270012460206e-08, 17, "464252838", -7},
  {6.9464277591640975952148438e+10, 20, "694642775916409759521484375", 11},
  {2.1743091466012148456467083e-07, 2, "", -2},
  {1.6176431571958464504319681e-14, 12, "", -12},
  {7.0841563901375606656074524e+05, 10, "7084156390137561", 6},
  {1.3007848389529011910781264e+04, 7, "130078483895", 5},
  {1.3766775909864418208599091e+06, 10, "13766775909864418", 7},
  {2.6105162971905660924676340e+03, 0, "2611", 4},
  {2.4320627882057037089702984e-22, 5, "", -5},
  {9.0619072599238332152794736e-14, 13, "1", -12},
  {7.9953500939742438495159149e+06, 0, "799535", 7},
  {2.3417746567785227101921463e-24, 6, "", -6},
  {1.7793034684025751630542800e+04, 2, "1779303", 5},
  {3.3699528768187699317932129e+09, 13, "33699528768187699317932", 10},
  {1.3843760075063560009002686e+09, 3, "1384376007506", 10},
  {4.0504959107745727539062500e+12, 9, "4050495910774572753906", 13},
  {1.3669601183026949059385239e-11, 10, "", -10},
  {7.8643486868757075253233424e-03, 10, "78643487", -2},
  {5.3067050226949892812544512e-18, 9, "", -9},
  {4.4345600054639311426996073e-01, 19, "4434560005463931143", 0},
  {3.0073905453799291316539391e-18, 17, "", -17},
  {8.3244495185191631317138672e+06, 4, "83244495185", 7},
  {1.4582137757938136333732893e-18, 6, "", -6},
  {8.9461745050553297407741195e-09, 8, "1", -7},
  {4.5256945972273226368523535e-04, 15, "452569459723", -3},
  {1.1877827687455382812749103e-14, 7, "", -7},
  {2.7303911411322954609680672e-05, 14, "2730391141", -4},
  {5.2315653945297893750000000e+14, 12, "5231565394529789375", 15},
  {1.5354274981791312500000000e+14, 0, "153542749817913", 15},
  {1.6758755992509277343750000e+13, 15, "1675875599250927734375", 14},
  {3.6961256260225131250000000e+14, 12, "3696125626022513125", 15},
  {5.5909616324107353515625000e+12, 12, "55909616324107353515625", 13},
  {1.5664112360907689398713595e-14, 2, "", -2},
  {7.8561830915178143994997376e-22, 3, "", -3},
  {4.7054894413382760210536791e-13, 16, "4705", -12},
  {4.1921258736064956250000000e+14, 19, "4192125873606495625", 15},
  {4.4767650461304093750000000e+13, 3, "44767650461304094", 14},
  {2.7229986051526330411434174e+07, 19, "272299860515263304114341736", 8},
  {2.7400537318705820716736686e-11, 12, "27", -10},
  {1.3585900723314929008483887e+08, 5, "13585900723315", 9},
  {2.3490564048088665443368031e-11, 20, "2349056405", -10},
  {2.3031830304047047680000000e+18, 2, "2303183030404704768", 19},
  {1.4137783794371902246211903e+01, 13, "141377837943719", 2},
  {4.0625085136902539302899490e-08, 9, "41", -7},
  {9.4351360973917187500000000e+13, 20, "943513609739171875", 14},
  {2.7026153722256634355539931e-21, 11, "", -11},
  {3.3100533201763278752157585e-17, 5, "", -5},
  {1.7447469033882309759064810e+03, 18, "1744746903388230975906", 4},
  {3.1042519841522044298696834e-22, 9, "", -9},
  {1.0202250176067795255244527e-25, 5, "", -5},
  {5.7237278224627043528016657e+04, 6, "57237278225", 5},
  {4.4187120477037711566299247e-23, 14, "", -14},
  {7.5507112438713154018440273e-14, 3, "", -3},
  {1.8671832693696198326310798e-03, 14, "186718326937", -2},
  {1.3550820473126900942056083e-20, 4, "", -4},
  {1.5103345199098964834810363e-06, 7, "15", -5},
  {1.9055829906438787500000000e+14, 15, "190558299064387875", 15},
  {1.8826428882475336475327866e-21, 2, "", -2},
  {1.0582218070771472307020807e-06, 8, "106", -5},
  {1.5282072971703256109675799e-21, 19, "", -19},
  {8.1286328429986816000000000e+18, 7, "81286328429986816", 19},
  {1.8924719933577258904749963e-03, 0, "", 0},
  {2.1040369588361094170253942e-16, 15, "", -15},
  {3.1764061244213282506337769e-11, 7, "", -7},
  {1.4819516392571884393692017e+08, 13, "1481951639257188439369", 9},
  {7.1449034920074788734822846e-02, 7, "71449", -1},
  {5.7680465314907827253919367e-12, 19, "57680465", -11},
  {2.0885297847900050781250000e+13, 5, "2088529784790005078", 14},
  {9.7230262609198925272124825e-03, 13, "97230262609", -2},
  {6.4031697504517644119914621e+04, 13, "640316975045176441", 5},
  {5.0504569771108563200000000e+17, 10, "505045697711085632", 18},
  {2.1394028502413840033113956e+05, 13, "2139402850241384003", 6},
  {2.8565262003034304000000000e+16, 0, "28565262003034304", 17},
  {1.7536181877248959541320801e+09, 8, "175361818772489595", 10},
  {3.6773989875818826729169139e-19, 15, "", -15},
  {1.7927795776514729253679130e-23, 15, "", -15},
  {1.1397729818828596800000000e+17, 1, "113977298188285968", 18},
  {6.1153711521067042732741070e-04, 4, "6", -3},
  {3.6667219659167460554251220e-24, 11, "", -11},
  {1.5641037558623442237148993e+04, 14, "1564103755862344224", 5},
  {7.1623986078167642439779430e-24, 9, "", -9},
  {4.6592058042874249216000000e+19, 5, "46592058042874249216", 20},
  {4.1958372473821078892797232e+05, 0, "419584", 6},
  {4.3183043146446320435200000e+20, 15, "431830431464463204352", 21},
  {1.5654033921967461537860800e+03, 12, "1565403392196746", 4},
  {9.2151313858592140415559868e-02, 3, "92", -1},
  {1.0712913060987937104912433e-13, 11, "", -11},
  {1.0314638818620048254867181e-23, 5, "", -5},
  {1.8626092860554448068798413e-23, 18, "", -18},
  {2.0425090758455159872660444e-07, 6, "", -6},
  {4.5774727845108941650390625e+11, 6, "457747278451089417", 12},
  {4.1701075826912226928081906e-08, 10, "417", -7},
  {3.3082864326784224065291653e-11, 9, "", -9},
  {1.0949299001605866823283200e-15, 14, "", -14},
  {8.8256611654477052422391266e-08, 1, "", -1},
  {5.7936504909527006826398255e-12, 18, "579365", -11},
  {3.6167614582323491210937500e+12, 2, "361676145823235", 13},
  {1.1595432655861771697645111e-05, 11, "1159543", -4},
  {5.1547132594625146565668411e-12, 5, "", -5},
  {5.5096793085452294553600000e+20, 8, "550967930854522945536", 21},
  {5.9903605077155618816000000e+19, 16, "59903605077155618816", 20},
  {5.6787013384408750000000000e+12, 1, "56787013384409", 13},
  {2.4167533410977348710437589e-19, 16, "", -16},
  {6.1073364418480673339217901e+05, 0, "610734", 6},
  {1.5574531714611359587715122e-12, 7, "", -7},
  {1.9575887855678563942400000e+20, 8, "195758878556785639424", 21},
  {3.8666113473102208818762797e-06, 5, "", -5},
  {1.0457056373895393894318015e-16, 10, "", -10},
  {4.9675094040187554931640625e+11, 16, "49675094040187554931640625", 12},
  {3.6112175922919778021136681e-24, 7, "", -7},
  {3.7802323095365095000000000e+15, 2, "37802323095365095", 16},
  {9.7134421471275039948523045e+04, 5, "9713442147", 5},
  {4.4282174697527312673628330e+05, 1, "4428217", 6},
  {4.1281594090725523233413696e+08, 11, "41281594090725523233", 9},
  {2.3066272510856652800000000e+18, 16, "230662725108566528", 19},
  {8.8970577691245239257812500e+10, 2, "8897057769125", 11},
  {4.4374706892975807059897875e-01, 7, "4437471", 0},
  {3.6639145561491537287285784e-11, 7, "", -7},
  {6.2621291799785714578620638e-25, 20, "", -20},
  {1.0556522452755800823123528e-08, 0, "", 0},
  {1.3367364616980473810274171e-11, 4, "", -4},
  {1.4170968815475926385261118e+05, 19, "1417096881547592638526112", 6},
  {6.4664975882793018779892691e-04, 16, "6466497588279", -3},
  {1.4080972848980880058105732e-14, 17, "1408", -13},
  {2.6029429937725113349905036e-20, 10, "", -10},
  {7.9389413259181984375000000e+13, 15, "79389413259181984375", 14},
  {2.8275285679182413097340777e-15, 16, "28", -14},
  {5.4245237445593507840000000e+18, 17, "5424523744559350784", 19},
  {4.6871934543458264599280483e+00, 15, "4687193454345826", 1},
  {7.7011207252646033034372552e-05, 18, "77011207252646", -4},
  {3.6471573028959450000000000e+15, 1, "3647157302895945", 16},
  {2.3831309218377986418818187e-09, 8, "", -8},
  {3.8160151082237187155038806e-09, 0, "", 0},
  {9.4761799177689885254949331e+05, 5, "94761799178", 6},
  {4.6020424727127965525141917e+03, 4, "46020425", 4},
  {2.0860092582700108465587618e+01, 1, "209", 2},
  {2.6732414518832470425600000e+20, 6, "267324145188324704256", 21},
  {6.2744618138747384364251047e+04, 15, "62744618138747384364", 5},
  {1.1430587800411423415880563e+02, 3, "114306", 3},
  {6.4750244780347342662797655e-24, 1, "", -1},
  {2.6679306873573139569089108e+01, 13, "266793068735731", 2},
  {5.2913845939310510857467307e+02, 8, "52913845939", 3},
  {2.4577132124982674032357029e-08, 20, "2457713212498", -7},
  {8.3471780520657548828125000e+12, 13, "83471780520657548828125", 13},
  {2.8944569627556838095188141e+07, 7, "289445696275568", 8},
  {1.3448040444846254097555072e-03, 18, "1344804044484625", -2},
  {5.9591703025759793817996979e+07, 19, "595917030257597938179969788", 8},
  {6.2015056324323119971370435e-06, 3, "", -3},
  {1.3804897975350788439950467e-24, 4, "", -4},
  {2.9763424719717427251453046e+03, 18, "2976342471971742725145", 4},
  {3.2988794152152306995757614e-14, 12, "", -12},
  {1.5821676722097888045936998e+02, 15, "15821676722097888", 3},
  {5.5352915530590958239780189e-25, 9, "", -9},
  {4.1341160430002771945109542e-11, 7, "", -7},
  {2.0306207814023621567816168e-24, 16, "", -16},
  {1.5058488582900262400000000e+17, 13, "150584885829002624", 18},
  {9.2505986965583292226764297e-18, 7, "", -7},
  {2.1350504598331678125000000e+14, 16, "21350504598331678125", 15},
  {1.4921054094271986052017143e-03, 20, "149210540942719861", -2},
  {8.6320880559333956760781348e-02, 20, "8632088055933395676", -1},
  {6.4846920867619968750000000e+13, 11, "6484692086761996875", 14},
  {3.8221116280534437768465206e-04, 1, "", -1},
  {1.3251602199267183222207172e-08, 13, "132516", -7},
  {2.5777145024153496302489876e-22, 0, "", 0},
  {2.1222911906840576036870506e-13, 19, "2122291", -12},
  {2.7183454594891539062258242e-14, 6, "", -6},
  {4.5632262618233906301704975e-17, 12, "", -12},
  {1.1020595624847036800000000e+17, 6, "110205956248470368", 18},
  {1.3716039349195001005241035e-04, 3, "", -3},
  {8.3314478600921625600000000e+17, 14, "833144786009216256", 18},
  {1.2446306467407347516815024e-13, 16, "1245", -12},
  {3.0667352437883471138775349e+06, 1, "30667352", 7},
  {8.8248546056453720296198552e-21, 1, "", -1},
  {1.8567067175758638161751765e-16, 17, "19", -15},
  {3.9197723536645431518554688e+09, 13, "39197723536645431518555", 10},
  {9.8100414616536700214940453e-11, 8, "", -8},
  {5.3186975572886134614236653e+04, 16, "531869755728861346142", 5},
  {9.6534132161353562500000000e+14, 3, "965341321613535625", 15},
  {1.3193850617365143261849880e+05, 9, "131938506173651", 6},
  {3.0316338670870342400000000e+17, 4, "303163386708703424", 18},
  {4.0230760136890035937540233e+04, 3, "4023076", 5},
  {4.2515651676067393261822171e-08, 0, "", 0},
  {8.7484720625012800000000000e+16, 11, "874847206250128", 17},
  {2.5519626752640355993856380e-13, 1, "", -1},
  {3.2899429133704034004466824e-24, 0, "", 0},
  {8.2274327459165360778570175e+03, 7, "82274327459", 4},
  {6.5424582590142236328125000e+12, 20, "65424582590142236328125", 13},
  {2.0650027583043117187500000e+13, 20, "206500275830431171875", 14},
  {2.3652494632892959375000000e+14, 18, "23652494632892959375", 15},
  {4.1360740491572421810984800e-16, 9, "", -9},
  {4.2441000450514173952000000e+19, 2, "42441000450514173952", 20},
  {3.3189653675041136741638184e+09, 14, "331896536750411367416382", 10},
  {1.0671605840898713953211330e-18, 5, "", -5},
  {2.3487325216928579152408929e+02, 10, "2348732521693", 3},
  {4.6733495067854411900043488e+06, 18, "4673349506785441190004349", 7},
  {5.4724680729167421875000000e+13, 0, "54724680729167", 14},
  {5.0545465862892444112944067e-17, 15, "", -15},
  {3.2580651490352842502487751e-13, 18, "325807", -12},
  {3.8043357666312179687500000e+13, 18, "380433576663121796875", 14},
  {7.2992655895198679040000000e+18, 16, "7299265589519867904", 19},
  {1.1983124936444959655243288e-18, 6, "", -6},
  {9.9110276094294384828773939e-18, 15, "", -15},
  {1.6149371515525719188287102e-12, 17, "161494", -11},
  {5.8792698366281785291032058e-03, 19, "58792698366281785", -2},
  {2.9938199217998813837766647e+06, 9, "2993819921799881", 7},
  {8.3292694351844050086808779e-07, 4, "", -4},
  {1.0321080440964163816283604e-19, 8, "", -8},
  {3.7946888623322651105940206e-03, 6, "3795", -2},
  {2.6939795516460786635713805e-10, 0, "", 0},
  {2.1765535376885704852486999e-15, 0, "", 0},
  {6.3795793132786464691162109e+08, 16, "6379579313278646469116211", 9},
  {2.0627134514199353125000000e+14, 19, "20627134514199353125", 15},
  {2.4900845811650361333388369e-23, 3, "", -3},
  {3.5660688855316060160000000e+18, 6, "3566068885531606016", 19},
  {4.4503407500566889600006284e-14, 4, "", -4},
  {3.6389070270471670496545953e-10, 19, "3638907027", -9},
  {7.8375320793805321955005638e+03, 11, "783753207938053", 4},
  {7.7390838414298084399105464e-15, 15, "8", -14},
  {2.7005651938625476311074380e-14, 4, "", -4},
  {2.3441475606650672793009063e-22, 20, "", -20},
  {5.8174051862817043137694085e-22, 12, "", -12},
  {6.8880688727205336086386276e-11, 17, "6888069", -10},
  {4.9944986705424116713760286e-08, 20, "4994498670542", -7},
  {1.0045426998252603684422917e-20, 3, "", -3},
  {5.1924159323445800000000000e+14, 20, "519241593234458", 15},
  {1.6928413142262338624277618e+03, 11, "169284131422623", 4},
  {7.0198249910747433335931931e-12, 19, "7019825", -11},
  {3.7306712617107888218015432e+05, 8, "37306712617108", 6},
  {4.1717706128769763745367527e+05, 11, "41717706128769764", 6},
  {5.7178618274998378300660873e-04, 8, "57179", -3},
  {7.1953333784140608000000000e+17, 8, "71953333784140608", 18},
  {5.7135726863414946514350010e-10, 1, "", -1},
  {9.4267968212249368662014604e+04, 16, "94267968212249368662", 5},
  {3.3687280523852057723449650e-24, 9, "", -9},
  {1.5076443552561588603566634e+03, 15, "150764435525615886", 4},
  {1.7199598483258070518533200e-20, 13, "", -13},
  {2.5007632052113377721980214e+05, 7, "2500763205211", 6},
  {5.8662631719816030538105534e-25, 20, "", -20},
  {5.6205950251440321153495461e+04, 13, "562059502514403212", 5},
  {7.8173790906302560000000000e+15, 4, "7817379090630256", 16},
  {1.1861824197035386880000000e+19, 8, "1186182419703538688", 20},
  {8.6126991844301050111385421e-21, 5, "", -5},
  {4.1126933441533712793600000e+20, 15, "411269334415337127936", 21},
  {6.7006071980815568368739342e-09, 0, "", 0},
  {6.2328639284476917760000000e+18, 11, "6232863928447691776", 19},
  {2.2149696017348026063512098e-10, 18, "22149696", -9},
  {2.0083834976859984375000000e+13, 1, "2008383497686", 14},
  {2.2984018954555079412428229e-23, 15, "", -15},
  {2.7836088843330480813165195e+03, 5, "278360888", 4},
  {2.4287371625150698008221983e-03, 2, "", -2},
  {2.5016182091269513480746993e-11, 2, "", -2},
  {1.2079699533772873110137880e+02, 9, "120796995338", 3},
  {6.6769055397732425297381886e-23, 10, "", -10},
  {1.0463725796750349139596636e-01, 6, "104637", 0},
  {7.4593916719822791382411717e-22, 6, "", -6},
  {1.1305267040734693088570625e-25, 18, "", -18},
  {2.9785774080301575362682343e+07, 19, "297857740803015753626823425", 8},
  {7.3902651627479146742918936e-06, 11, "739027", -5},
  {2.2842959048496015625000000e+12, 9, "22842959048496015625", 13},
  {1.6742596691970901279233885e+00, 8, "167425967", 1},
  {6.5696557574659731522378514e-25, 8, "", -8},
  {3.7557017036045434880000000e+18, 9, "3755701703604543488", 19},
  {2.7359626947303094780466965e-19, 8, "", -8},
  {8.8376673739685985162597642e-20, 2, "", -2},
  {4.0812379388862519819281055e-11, 12, "41", -10},
  {1.0936424275885265625000000e+13, 6, "10936424275885265625", 14},
  {5.0056732769278791679021878e-15, 14, "1", -13},
  {1.8748166564695478521405700e-08, 11, "1875", -7},
  {1.6737431326010287500000000e+14, 16, "167374313260102875", 15},
  {3.9235199942056809847140686e-04, 10, "392352", -3},
  {1.3775864505655778715779020e-17, 5, "", -5},
  {6.8641981068471559410681948e+03, 16, "68641981068471559411", 4},
  {1.0005276716495604460988034e+01, 0, "1", 2},
  {5.0701734523692674636840820e+09, 12, "5070173452369267463684", 10},
  {6.5694683829712124477683672e-23, 15, "", -15},
  {1.0434472448939876630902290e+06, 7, "1043447244894", 7},
  {7.3459983869120972638233624e-03, 6, "7346", -2},
  {1.3100425298125890915727455e-12, 20, "131004253", -11},
  {4.3670887312026583822444081e+05, 13, "4367088731202658382", 6},
  {1.0589619137458867895260767e-05, 14, "1058961914", -4},
  {2.5954220508215835748391104e-05, 16, "259542205082", -4},
  {6.5209521648465302573059905e-06, 13, "65209522", -5},
  {1.8704590916962067145834503e-03, 7, "18705", -2},
  {1.5759047167497228225663264e-01, 2, "16", 0},
  {1.1432089893989047500000000e+15, 14, "114320898939890475", 16},
  {4.0194176711588929086774765e-25, 19, "", -19},
  {3.1578973950304233599015126e-07, 7, "3", -6},
  {2.2100363055206183225949729e-21, 20, "", -20},
  {1.4332194281650598707200000e+20, 18, "143321942816505987072", 21},
  {5.4463919507115587913362239e-12, 20, "544639195", -11},
  {3.5849404384835450478041796e-03, 7, "35849", -2},
  {3.5705095226728569030761719e+10, 13, "357050952267285690307617", 11},
  {2.0076214280567462486647758e-18, 17, "", -17},
  {3.3624977840481125442266651e-18, 17, "", -17},
  {8.0545596473059034434061537e-11, 11, "8", -10},
  {2.8263834388425207031250000e+13, 16, "2826383438842520703125", 14},
  {1.8556917077241173386573792e+08, 6, "185569170772412", 9},
  {2.8570044444865546655641868e-22, 14, "", -14},
  {1.0581591151417747001370324e-23, 18, "", -18},
  {6.1497470261161932800000000e+18, 11, "614974702611619328", 19},
  {2.1103618559975242237066060e-09, 12, "211", -8},
  {3.3490269778006550679345269e-15, 11, "", -11},
  {8.1879951677041826171875000e+12, 9, "8187995167704182617188", 13},
  {2.2173430735632382593498570e-14, 3, "", -3},
  {2.2366193236681749838506378e-11, 10, "", -10},
  {1.8127165426744249664554594e-16, 8, "", -8},
  {2.2035510801054100000000000e+14, 5, "220355108010541", 15},
  {1.5064983385282965567088511e-09, 3, "", -3},
  {9.2584498022624564683706768e-08, 3, "", -3},
  {2.8944919334625913293068677e-02, 10, "289449193", -1},
  {1.5683559123123021875000000e+14, 14, "15683559123123021875", 15},
  {2.0529603272674157299348963e-01, 10, "2052960327", 0},
  {4.0110800968200806260188784e-02, 5, "4011", -1},
  {9.3982296779157180786132812e+09, 18, "939822967791571807861328125", 10},
  {7.8377997694012375725444828e-14, 16, "784", -13},
  {3.6019708701215008000000000e+17, 11, "36019708701215008", 18},
  {1.2516326074731750000000000e+14, 14, "1251632607473175", 15},
  {3.2258179346377358065467433e-01, 11, "32258179346", 0},
  {1.5510742520477598905563354e+08, 19, "1551074252047759890556335449", 9},
  {5.1781732122358129495029303e-15, 15, "5", -14},
  {4.8821148630170017792000000e+19, 0, "48821148630170017792", 20},
  {3.3093171728629864000000000e+16, 5, "33093171728629864", 17},
  {1.7506438551479825203200000e+20, 10, "175064385514798252032", 21},
  {2.3949478105666846036911011e+08, 18, "239494781056668460369110107", 9},
  {1.5085915765364029373457709e-09, 2, "", -2},
  {2.5713484353978601631984802e-02, 19, "257134843539786016", -1},
  {5.2409307198749046875000000e+13, 6, "52409307198749046875", 14},
  {1.4731747098182289408000000e+19, 10, "14731747098182289408", 20},
  {1.7698289741716431281208574e-17, 17, "2", -16},
  {2.1609229512222566400000000e+17, 12, "216092295122225664", 18},
  {1.9379559038432598878226587e-03, 5, "194", -2},
  {7.2100502053708439120782714e+01, 5, "721005", 2},
  {6.4630732482269760131835938e+10, 9, "64630732482269760132", 11},
  {2.4036474728281136192230824e-21, 10, "", -10},
  {6.1379127628238428160000000e+18, 19, "6137912762823842816", 19},
  {3.0383343366412031464278698e+06, 10, "30383343366412031", 7},
  {4.3850105527638418406053535e-18, 19, "44", -17},
  {2.4547576797024044973439877e-07, 5, "", -5},
  {8.1443646872621411336723440e-01, 12, "814436468726", 0},
  {9.8386378526961106944000000e+20, 7, "98386378526961106944", 21},
  {1.9068844844962441406250000e+13, 4, "190688448449624414", 14},
  {7.4075176255356665856000000e+19, 19, "74075176255356665856", 20},
  {1.5386846422844817500000000e+15, 20, "153868464228448175", 16},
  {8.5853948542536238496891967e-09, 17, "858539485", -8},
  {3.6908172849974441538659979e-23, 12, "", -12},
  {4.2439527375827270104879050e-10, 15, "424395", -9},
  {8.3932227873336177420957773e-10, 6, "", -6},
  {6.6190038535512265625000000e+12, 6, "6619003853551226563", 13},
  {4.8724824734921843997006996e-04, 17, "48724824734922", -3},
  {1.8645378413357698179426635e-25, 16, "", -16},
  {3.8844110111157935000000000e+15, 2, "38844110111157935", 16},
  {1.0039307841771947200000000e+17, 19, "100393078417719472", 18},
  {2.1110496353889702148437500e+12, 8, "211104963538897021484", 13},
  {1.5997720005230906637755163e-12, 3, "", -3},
  {3.7995682026880367187500000e+13, 17, "379956820268803671875", 14},
  {9.6639469722232631182295623e-06, 20, "966394697222326", -5},
  {3.4598448051676015425892619e-03, 1, "", -1},
  {1.0223297997862289608978765e-22, 3, "", -3},
  {2.8479850965383865758794368e-14, 4, "", -4},
  {3.7514732041276465430085276e-25, 15, "", -15},
  {7.6088928542975444793701172e+09, 2, "76088928543", 10},
  {2.8410271379577049970772872e-18, 15, "", -15},
  {1.4109490798479945600000000e+17, 7, "141094907984799456", 18},
  {2.9195854677178259865600000e+20, 10, "291958546771782598656", 21},
  {1.7373017899758841183778502e-18, 4, "", -4},
  {6.8348806291418227200000000e+17, 19, "683488062914182272", 18},
  {2.0597644164532433537398003e-06, 3, "", -3},
  {1.0609892874587445068359375e+11, 8, "10609892874587445068", 12},
  {2.4019347746109046959271067e-23, 12, "", -12},
  {2.6991909527719722665850329e-24, 1, "", -1},
  {8.0772175918803990000000000e+15, 19, "8077217591880399", 16},
  {8.9391651564166168875302346e-25, 14, "", -14},
  {3.5634322110233609564602375e+06, 8, "356343221102336", 7},
  {3.7311141706102235259284562e-19, 2, "", -2},
  {8.7286401592444248601117349e-13, 13, "9", -12},
  {2.2280968983503409375000000e+14, 15, "22280968983503409375", 15},
  {2.1983447491821643017539945e-04, 14, "21983447492", -3},
  {9.0474960343529610170466752e-17, 13, "", -13},
  {1.3378837901995092526941100e-02, 14, "13378837902", -1},
  {5.1665286016623702693999422e-14, 20, "5166529", -13},
  {2.5249052642926002343978890e-13, 8, "", -8},
  {8.9744066905104973824000000e+20, 10, "89744066905104973824", 21},
  {3.5247359482435332611203194e+06, 15, "352473594824353326112", 7},
  {8.7936090702904093691448094e-08, 19, "879360907029", -7},
  {2.2630454519465733458798878e-18, 9, "", -9},
  {1.1690946418493465890971221e-20, 8, "", -8},
  {9.9175491562664810180664062e+10, 10, "991754915626648101807", 11},
  {3.1371587235524736000000000e+16, 14, "31371587235524736", 17},
  {2.3069298027173315591899780e-22, 20, "", -20},
  {3.8174863210730900480000000e+18, 15, "3817486321073090048", 19},
  {1.5766653534039753675460815e+08, 12, "157666535340397536755", 9},
  {3.3701227675083944964220788e-18, 1, "", -1},
  {4.1985163681066822814145001e-23, 5, "", -5},
  {3.2165833386444212356361574e-17, 3, "", -3},
  {1.3271185561920478000000000e+16, 0, "13271185561920478", 17},
  {9.7115817857253957771034138e-18, 14, "", -14},
  {2.7195336861938957214355469e+10, 13, "271953368619389572143555", 11},
  {3.0893680049233041322532331e-12, 1, "", -1},
  {8.6660326377527852059756697e+01, 8, "8666032638", 2},
  {6.2177596766365255144839682e-13, 18, "621776", -12},
  {1.3649025534575664000000000e+16, 13, "13649025534575664", 17},
  {1.4668049103543119052800000e+20, 2, "146680491035431190528", 21},
  {7.6566258390474235056899488e+04, 14, "7656625839047423506", 5},
  {5.6175957015113351644686190e+02, 4, "5617596", 3},
  {6.0150672639367584793035348e+01, 5, "6015067", 2},
  {8.1425905988753738711238839e+03, 18, "8142590598875373871124", 4},
  {3.5300992511320891664716726e-02, 3, "35", -1},
  {2.3825737885808206250000000e+14, 15, "2382573788580820625", 15},
  {8.1696931818838143883550879e-17, 10, "", -10},
  {5.6859494852512154614335681e-06, 7, "57", -5},
  {8.3158965451003770880000000e+18, 10, "8315896545100377088", 19},
  {9.3918870422012848062087720e-04, 6, "939", -3},
  {2.3381397520836472656250000e+13, 2, "2338139752083647", 14},
  {2.3765202502619178938091673e-11, 14, "2377", -10},
  {1.5068403814622889478778631e-06, 11, "150684", -5},
  {1.3317415215125680827412680e+00, 9, "1331741522", 1},
  {2.4442932023409707583323168e-20, 2, "", -2},
  {5.2294488970892142202702918e-22, 19, "", -19},
  {1.2450196020896557641331622e-25, 9, "", -9},
  {4.1857934283314682543277740e+06, 14, "418579342833146825433", 7},
  {1.6707892018695731390504067e-03, 10, "16707892", -2},
  {3.3619100795415141069710785e-01, 3, "336", 0},
  {1.3031076339962950441986322e+06, 10, "1303107633996295", 7},
  {7.3263950026155482065993706e-15, 7, "", -7},
  {3.2471478775863826199481602e-19, 8, "", -8},
  {3.5592875741705198003238508e-15, 0, "", 0},
  {3.3792883800949825286865234e+10, 5, "3379288380094983", 11},
  {4.4214788402431787206481317e-02, 4, "442", -1},
  {1.8803878370360657679150052e-01, 14, "18803878370361", 0},
  {1.7556919141668972294822550e-25, 0, "", 0},
  {1.8902617994137479098884289e-19, 18, "", -18},
  {1.1199323779021208232573071e-11, 1, "", -1},
  {2.0995120217463396393789421e-06, 2, "", -2},
  {6.4272866222135320413144655e+01, 5, "6427287", 2},
  {1.2142519773108599590027978e-01, 17, "121425197731086", 0},
  {2.9068362529719423488895870e-14, 4, "", -4},
  {4.3228064821072765000000000e+15, 10, "43228064821072765", 16},
  {1.9098024449061878710150358e-19, 9, "", -9},
  {3.5388621681321752515255136e-07, 12, "353886", -6},
  {2.0830494885474521251679525e-04, 17, "20830494885475", -3},
  {1.5245876725182709240935530e-02, 12, "15245876725", -1},
  {2.7822464100314925698180526e-22, 15, "", -15},
  {3.0003120615888060747024827e-14, 3, "", -3},
  {2.1296278862341389656066895e+09, 16, "21296278862341389656066895", 10},
  {1.2709520542459287500000000e+14, 0, "127095205424593", 15},
  {4.7658749365333198547363281e+10, 2, "4765874936533", 11},
  {3.1425851356400759652669976e-24, 10, "", -10},
  {1.7520939259765733186924308e+00, 19, "17520939259765733187", 1},
  {8.5952315578962743282318115e+08, 1, "8595231558", 9},
  {3.7607218509377163085937500e+12, 4, "37607218509377163", 13},
  {2.8427849409446142282014310e-23, 0, "", 0},
  {1.5810852370156672641043231e-19, 17, "", -17},
  {4.0209769684726066828300077e-12, 3, "", -3},
  {1.0947546276806964800000000e+17, 19, "109475462768069648", 18},
  {7.7135497675703445434570312e+10, 12, "7713549767570344543457", 11},
  {8.8853846402346684973692610e-13, 10, "", -10},
  {7.5001265299878558105138169e-14, 20, "7500127", -13},
  {2.5076204462295895609713625e+03, 5, "250762045", 4},
  {3.8003215696971487380650956e-02, 13, "38003215697", -1},
  {1.0015639781982347656250000e+13, 19, "1001563978198234765625", 14},
  {1.1060440143029435977560600e-18, 7, "", -7},
  {1.9365961472682084147383794e-16, 9, "", -9},
  {9.9620960440000726521247998e+03, 1, "99621", 4},
  {9.2550527289282011598403274e-08, 20, "9255052728928", -7},
  {2.2703545004997924272593934e-02, 11, "22703545", -1},
  {1.0701477085603928385508540e-18, 13, "", -13},
  {1.6580298963964196672819816e-12, 10, "", -10},
  {1.7376293217711496981792152e+05, 15, "173762932177114969818", 6},
  {8.7372235402549713878528337e-01, 20, "87372235402549713879", 0},
  {1.8859705559224683195331982e-07, 3, "", -3},
  {9.2445215695972179914541300e-02, 6, "92445", -1},
  {7.3170564725044071368502494e-07, 0, "", 0},
  {6.1672882809146096080653865e-19, 7, "", -7},
  {1.0398184094527138000000000e+16, 5, "10398184094527138", 17},
  {7.0566103649526048684492707e+04, 19, "705661036495260486844927", 5},
  {3.5469435302920606645216139e+00, 17, "354694353029206066", 1},
  {1.0867920972467355989844762e-13, 3, "", -3},
  {1.2561283993894040371200000e+20, 5, "125612839938940403712", 21},
  {8.1448868700920650137600000e+20, 6, "814488687009206501376", 21},
  {2.9297845885134264135678716e-22, 6, "", -6},
  {2.5234315002836169285179112e-21, 11, "", -11},
  {3.5111103287523016704000000e+20, 7, "35111103287523016704", 21},
  {1.0005695516967872745780872e-19, 0, "", 0},
  {4.4608019086503372818697244e+02, 20, "44608019086503372818697", 3},
  {3.8770916046039955386616973e-22, 20, "", -20},
  {2.7463059720413734128900942e-15, 3, "", -3},
  {3.8063631530887824714408238e-17, 12, "", -12},
  {1.1943328981327859375000000e+13, 10, "11943328981327859375", 14},
  {8.4535435952766025628226992e-14, 10, "", -10},
  {3.3372279131184488221926009e-24, 4, "", -4},
  {2.0043796378670532461310110e-18, 13, "", -13},
  {3.1253595777348332322055777e-19, 14, "", -14},
  {2.0558787729748841661055228e-13, 7, "", -7},
  {9.1999245322163265942546396e-23, 9, "", -9},
  {1.2938541255473569586049866e-17, 4, "", -4},
  {1.0499909828400104672141424e+00, 16, "10499909828400105", 1},
  {2.6200258334515574146935821e-25, 3, "", -3},
  {8.9780512751270451200000000e+18, 5, "897805127512704512", 19},
  {7.5896090722702769562602043e+05, 19, "7589609072270276956260204", 6},
  {2.0140124631471190452575684e+09, 1, "20140124631", 10},
  {5.1696372240469206206352864e-17, 18, "52", -16},
  {1.9318878106668502271459115e-25, 7, "", -7},
  {5.4953539837197209916384881e-10, 20, "54953539837", -9},
  {6.0476159464183978887400622e-05, 16, "604761594642", -4},
  {2.0135331830804239959589836e-13, 6, "", -6},
  {2.4691490559306814134288288e+01, 13, "246914905593068", 2},
  {1.7617623349515142231736265e-10, 18, "176176233", -9},
  {2.5881342010180809572935667e-25, 11, "", -11},
  {1.4069947322233104187823204e-12, 2, "", -2},
  {2.2565512651614747173994243e-25, 13, "", -13},
  {3.5923294009540813444063198e-21, 8, "", -8},
  {1.2697455504083707685206884e-24, 7, "", -7},
  {4.4101353971447884084070322e-16, 8, "", -8},
  {2.9894470763026650000000000e+14, 12, "2989447076302665", 15},
  {1.7156998537378962537101459e-10, 5, "", -5},
  {1.1908048674355672331719635e-07, 11, "11908", -6},
  {1.8904957069257597766105637e-13, 18, "18905", -12},
  {1.0093056557015590086023219e-25, 17, "", -17},
  {6.3731427048284136768418541e-21, 20, "1", -19},
  {3.9553696644296867840000000e+18, 11, "3955369664429686784", 19},
  {2.4173359000478487461805344e+07, 12, "24173359000478487462", 8},
  {1.6108360861640200614929199e+09, 18, "1610836086164020061492919922", 10},
  {1.8944417559921600286237662e-25, 3, "", -3},
  {2.0827632648570600657281227e-04, 0, "", 0},
  {2.2374778010072058571391563e-09, 16, "22374778", -8},
  {8.5463499266849134585415483e-07, 15, "854634993", -6},
  {2.4995701570708401817455524e+00, 12, "2499570157071", 1},
  {2.2520936042210143492489845e-10, 6, "", -6},
  {1.9725621506972475192543730e-10, 13, "1973", -9},
  {1.3512206032614427185058594e+11, 16, "1351220603261442718505859375", 12},
  {1.0457218697986237704753876e+08, 0, "104572187", 9},
  {4.1872287804740244610002264e+03, 20, "418722878047402446100023", 4},
  {8.6755299943348579108715057e+06, 9, "8675529994334858", 7},
  {1.5067384012802779674530029e+07, 16, "1506738401280277967453", 8},
  {2.5095818084018570370972157e+06, 10, "2509581808401857", 7},
  {5.2274838747854816822790980e-02, 9, "52274839", -1},
  {4.1359540578058579299086100e-22, 7, "", -7},
  {1.4006501903462867054733232e-20, 20, "1", -19},
  {1.2766774517016181813341275e-05, 11, "1276677", -4},
  {1.0642811674168402622355292e-05, 12, "10642812", -4},
  {5.8600793037234779198968339e-09, 8, "1", -7},
  {1.2811096011803735000000000e+15, 15, "12811096011803735", 16},
  {8.5329132428628606438324696e-19, 20, "85", -18},
  {1.2470545470079038609390043e-04, 7, "1247", -3},
  {8.4248990613003210176693531e-20, 18, "", -18},
  {9.3292121815427076353591059e-21, 1, "", -1},
  {3.7190420291474649275187403e+04, 18, "37190420291474649275187", 5},
  {6.0101767834185989024349394e-15, 19, "60102", -14},
  {2.0434693834216227648070685e-01, 17, "20434693834216228", 0},
  {1.1283272054241440855548717e+04, 18, "11283272054241440855549", 5},
  {9.8754018995574694126844406e+06, 10, "98754018995574694", 7},
  {1.1747793460528861328125000e+13, 5, "1174779346052886133", 14},
  {8.7992673939733971010145355e-24, 10, "", -10},
  {2.5176921950501087189479047e-18, 20, "252", -17},
  {5.8635795187181931328826885e-16, 2, "", -2},
  {7.7193031473966608485792874e-17, 18, "77", -16},
  {5.5718812134915581021194463e-07, 15, "557188121", -6},
  {2.5660471805209661422253475e-01, 13, "2566047180521", 0},
  {1.6351316471512384315330688e-23, 20, "", -20},
  {8.4172076445080448327168811e-15, 11, "", -11},
  {1.7205590210909832746599507e-09, 9, "2", -8},
  {8.0484577718574926257133484e+06, 10, "80484577718574926", 7},
  {1.8530110242352187499710117e-10, 8, "", -8},
  {1.1834911310224293172359467e+08, 8, "11834911310224293", 9},
  {4.1157621549519524191795511e-19, 17, "", -17},
  {1.9213459446567070652913769e-22, 9, "", -9},
  {1.0540598569704781084510614e+02, 18, "105405985697047810845", 3},
  {2.6172708273246956578767868e-16, 9, "", -9},
  {2.4877828098873972892761230e+08, 5, "24877828098874", 9},
  {1.0799302577951253848034113e-04, 9, "107993", -3},
  {1.7845869179881229511204784e-25, 12, "", -12},
  {1.9067754951930072000000000e+16, 13, "19067754951930072", 17},
  {2.9369857489970851299743160e-02, 20, "293698574899708513", -1},
  {3.6312138134928624000000000e+16, 8, "36312138134928624", 17},
  {1.3715342472516576526686549e+05, 7, "1371534247252", 6},
  {2.1534017933576312500000000e+14, 14, "215340179335763125", 15},
  {3.3218954480212080996091646e-23, 7, "", -7},
  {3.5591228375825869956696097e-18, 8, "", -8},
  {3.0258494320172531483529949e-18, 2, "", -2},
  {2.3540512157989902737596700e-14, 10, "", -10},
  {3.6194157794119651043729391e+03, 20, "361941577941196510437294", 4},
  {6.5042808347723439510446042e+02, 20, "65042808347723439510446", 3},
  {9.0580832899394392967224121e+08, 10, "9058083289939439297", 9},
  {7.6903690501515675000000000e+14, 15, "76903690501515675", 15},
  {2.0219547409159590625000000e+14, 18, "20219547409159590625", 15},
  {7.7583393789192086842376739e+01, 7, "775833938", 2},
  {3.5346862958294758159591420e-06, 6, "4", -5},
  {3.4035819603917194173248184e-03, 18, "3403581960391719", -2},
  {2.0866041929275823057755437e-19, 11, "", -11},
  {2.6163384291168339801333216e-24, 17, "", -17},
  {6.5338808128096236517830020e-23, 3, "", -3},
  {9.9465141405438340000000000e+15, 11, "9946514140543834", 16},
  {1.3999061767902964970033963e-01, 8, "13999062", 0},
  {1.8568633581807828774752613e-12, 19, "18568634", -11},
  {6.2397715007308313531441683e-10, 0, "", 0},
  {1.2896168278507504146546125e+05, 16, "1289616827850750414655", 6},
  {1.9381494148459283447265625e+11, 20, "19381494148459283447265625", 12},
  {9.4924517304279396253416254e-16, 5, "", -5},
  {1.0648795034838120639324188e+08, 3, "106487950348", 9},
  {9.5189676094295826425936158e-19, 19, "1", -17},
  {1.0993519517084112167358398e+10, 13, "109935195170841121673584", 11},
  {1.6720092046663480297946277e-21, 4, "", -4},
  {3.2292862481493601539251726e-09, 0, "", 0},
  {2.7844713125661593600000000e+19, 10, "278447131256615936", 20},
  {6.9517481787860386788224787e+00, 16, "69517481787860387", 1},
  {7.1343937111885021972656250e+11, 16, "7134393711188502197265625", 12},
  {3.3077876175268485200051509e-10, 20, "33077876175", -9},
  {3.5260085035469385639122115e-24, 4, "", -4},
  {1.0750054861985361640108749e+04, 17, "1075005486198536164011", 5},
  {3.0007732033281116746366024e+06, 16, "30007732033281116746366", 7},
  {1.1892558186415678355842829e+06, 16, "11892558186415678355843", 7},
  {3.8347127179799517238123485e-02, 7, "383471", -1},
  {2.1397893659718895191762349e-07, 6, "", -6},
  {1.0264790082026440488792425e-25, 20, "", -20},
  {4.1679171915558317778049968e+03, 5, "416791719", 4},
  {3.0269432009705100200536165e-03, 2, "", -2},
  {9.3608157667154362945664813e-20, 15, "", -15},
  {2.0873532343486917968750000e+13, 9, "2087353234348691796875", 14},
  {3.1200025131430917968750000e+13, 6, "31200025131430917969", 14},
  {7.2490987247835224151356393e-09, 14, "72491", -8},
  {8.0713392875699224312020124e-08, 13, "807134", -7},
  {1.4850011764047914743423462e+08, 3, "14850011764", 9},
  {1.6056831090345040775832316e-20, 19, "", -19},
  {4.3087935138826999542996377e-05, 18, "43087935138827", -4},
  {3.1642537547903386596741007e-21, 2, "", -2},
  {1.0689348663923647464457645e+01, 17, "1068934866392364746", 2},
  {3.0733794566067440844800000e+20, 20, "307337945660674408448", 21},
  {1.1407387324898799896240234e+10, 20, "11407387324898799896240234375", 11},
  {5.7195606808850336586063482e-18, 14, "", -14},
  {1.5232467434619674438744185e-14, 14, "2", -13},
  {2.7396296699705416000000000e+16, 5, "27396296699705416", 17},
  {3.1056443052498426880000000e+18, 1, "3105644305249842688", 19},
  {1.7243462714961078450053314e-19, 11, "", -11},
  {2.0079816424550758778071949e-25, 8, "", -8},
  {8.5478968934662515352553920e-19, 7, "", -7},
  {1.2900811650574619263959768e-19, 1, "", -1},
  {4.0973149476556985195708061e-13, 17, "40973", -12},
  {1.8532867856943847656250000e+13, 4, "185328678569438477", 14},
  {8.5581365964416410000000000e+15, 8, "8558136596441641", 16},
  {1.3604451830532902092800000e+20, 4, "136044518305329020928", 21},
  {7.1042654104022118222161453e-01, 2, "71", 0},
  {5.8746622686046731472015381e+08, 0, "587466227", 9},
  {1.0172715385628785393800853e-20, 2, "", -2},
  {4.6177163668926307678222656e+10, 18, "4617716366892630767822265625", 11},
  {4.3322705134593200637027621e+05, 3, "433227051", 6},
  {2.9483364144796271324157715e+09, 20, "294833641447962713241577148438", 10},
  {7.0826912072511119850642135e-24, 11, "", -11},
  {3.3116302013007911022001754e-14, 1, "", -1},
  {1.9860511440421396000000000e+16, 12, "19860511440421396", 17},
  {3.2499997168268468750000000e+13, 14, "3249999716826846875", 14},
  {1.3174090982000919265856708e-11, 4, "", -4},
  {3.4164059329801034182310104e+06, 5, "341640593298", 7},
  {2.1909626266432460917066294e-01, 12, "219096262664", 0},
  {2.2209207388168916172800000e+20, 13, "222092073881689161728", 21},
  {7.8697929146597400684726153e-02, 13, "786979291466", -1},
  {6.3722074640413226562500000e+13, 17, "637220746404132265625", 14},
  {1.1730354638025775551795959e+08, 0, "117303546", 9},
  {1.1322698920240714240000000e+18, 8, "1132269892024071424", 19},
  {1.0033054862076470549389431e-22, 20, "", -20},
  {6.8984441147926577286852989e+02, 2, "68984", 3},
  {5.3312556839479266357421875e+11, 8, "53312556839479266357", 12},
  {9.2950687653601989825202164e-18, 15, "", -15},
  {1.2831881708918111424102338e-21, 1, "", -1},
  {2.3605517721953616513871177e-09, 13, "23606", -8},
  {1.1946991048227951992544149e+01, 19, "119469910482279519925", 2},
  {8.3795152825919087475780108e-25, 3, "", -3},
  {1.3449849693439373598881044e-11, 4, "", -4},
  {5.5537958868358461434990074e-08, 12, "55538", -7},
  {1.3468705772750663718362318e-01, 6, "134687", 0},
  {2.6244940461316750076001280e-07, 4, "", -4},
  {1.2607517133783356800000000e+17, 17, "126075171337833568", 18},
  {5.1739500957162521505374348e-08, 18, "51739500957", -7},
  {4.1677657037045389383044721e-13, 5, "", -5},
  {5.0682149528240592667102660e-05, 5, "5", -4},
  {1.4413820712705773925781250e+12, 17, "1441382071270577392578125", 13},
  {2.1385323362558432563673705e+04, 9, "21385323362558", 5},
  {5.0881034567664568768284296e-08, 7, "1", -6},
  {9.1435644197300847135778668e-01, 14, "91435644197301", 0},
  {1.2873902019736361299327396e-20, 3, "", -3},
  {6.3496203893120295134284598e-22, 17, "", -17},
  {2.1584632850671713768974184e-25, 13, "", -13},
  {1.3638741470049731141500615e-01, 10, "1363874147", 0},
  {3.2745654756309243750000000e+14, 16, "3274565475630924375", 15},
  {3.6200105277022521608323601e-19, 9, "", -9},
  {1.8112433801128056049346924e+09, 0, "181124338", 10},
  {1.6132220733846174424641602e-13, 14, "16", -12},
  {1.4270464792879304885864258e+09, 20, "142704647928793048858642578125", 10},
  {6.6391747622672277504000000e+19, 11, "66391747622672277504", 20},
  {5.6472654951277174043962846e-20, 13, "", -13},
  {1.6782627260533002910847244e+00, 13, "16782627260533", 1},
  {2.4759256725081512500000000e+14, 10, "247592567250815125", 15},
  {8.0105031484352797081600000e+20, 6, "801050314843527970816", 21},
  {4.5617124615755865729311728e-21, 19, "", -19},
  {4.5944856003428273177566785e-23, 7, "", -7},
  {2.1186387397905479896166950e-21, 16, "", -16},
  {1.0418649749329738750000000e+15, 9, "1041864974932973875", 16},
  {8.9389232693249771520000000e+18, 20, "8938923269324977152", 19},
  {2.5772300927565240999683738e+05, 8, "25772300927565", 6},
  {6.3028843047389181904118315e-15, 16, "63", -14},
  {5.0048605489239288000000000e+16, 8, "50048605489239288", 17},
  {1.2264118848546197637915611e+07, 15, "12264118848546197637916", 8},
  {2.6794978884663440287113190e+07, 12, "26794978884663440287", 8},
  {2.6779243249608975447183249e-10, 13, "2678", -9},
  {1.6290523132599285000000000e+15, 7, "16290523132599285", 16},
  {3.1168461660921279283200000e+20, 13, "311684616609212792832", 21},
  {4.1335884723785545347141124e+00, 8, "413358847", 1},
  {5.9113608463355503574958213e-13, 7, "", -7},
  {4.3851742438720782421136531e-14, 5, "", -5},
  {2.0099432066060711754573731e+00, 14, "200994320660607", 1},
  {7.4897487504911598868921152e-20, 14, "", -14},
  {4.6258032981738118400000000e+17, 6, "462580329817381184", 18},
  {2.6164553058816924691200256e+08, 4, "2616455305882", 9},
  {9.3636514152432143006718754e-17, 5, "", -5},
  {2.2999302515251259859856166e-12, 6, "", -6},
  {8.4907903274977365981612820e+02, 18, "849079032749773659816", 3},
  {1.1952478312919996416000000e+19, 15, "11952478312919996416", 20},
  {1.0058012722716307162994662e-18, 11, "", -11},
  {1.1576267489611673834477880e-11, 1, "", -1},
  {8.2468965135555313979000246e-24, 18, "", -18},
  {7.3984561518078315724800000e+20, 7, "739845615180783157248", 21},
  {8.6414625167085552584469717e-21, 14, "", -14},
  {3.3224611114563953481683325e-07, 9, "332", -6},
  {5.1563768740956259765625000e+12, 13, "51563768740956259765625", 13},
  {1.3823608554291402956970547e-03, 14, "138236085543", -2},
  {2.1290928937734939300541029e-18, 2, "", -2},
  {1.4891359209856196770988868e-10, 4, "", -4},
  {6.5360214787528548340754523e-25, 9, "", -9},
  {1.1237337308536257457422571e-11, 13, "112", -10},
  {6.7872679547979218944000000e+19, 2, "67872679547979218944", 20},
  {2.7423321423701386240000000e+18, 6, "2742332142370138624", 19},
  {4.8704964862733260527976990e-06, 11, "48705", -5},
  {9.6229166073838350634947133e-24, 0, "", 0},
  {5.1146169751622153398784576e+01, 3, "51146", 2},
  {8.8912501845521645480404518e-11, 20, "8891250185", -10},
  {1.2698149514984857430532905e-02, 11, "1269814951", -1},
  {3.2936389362753933593750000e+13, 17, "3293638936275393359375", 14},
  {1.9785592038635338215256097e-08, 20, "1978559203864", -7},
  {8.2862901261947550562201681e-13, 0, "", 0},
  {1.9456236180579804000000000e+16, 13, "19456236180579804", 17},
  {4.6794452322800828847224270e-07, 18, "467944523228", -6},
  {5.1679654936693906784057617e+06, 14, "516796549366939067841", 7},
  {6.9167969787322475353234449e-06, 6, "7", -5},
  {5.0735788105523229891274939e-04, 15, "507357881055", -3},
  {2.8056480878715169165193988e-03, 14, "280564808787", -2},
  {6.6001197203926479239691109e-16, 12, "", -12},
  {9.2813740878895611974286339e-01, 3, "928", 0},
  {6.3495523799856699160982554e-15, 0, "", 0},
  {1.4310717771702331421588995e-17, 1, "", -1},
  {3.9565817052267734375000000e+12, 8, "39565817052267734375", 13},
  {5.6202589435469126328825951e+03, 9, "5620258943547", 4},
  {1.0836784743781391732266918e-25, 18, "", -18},
  {8.0532551124238005435529431e-01, 9, "805325511", 0},
  {2.1400347807660798567596261e-19, 12, "", -12},
  {3.5826900300419068693899198e-23, 9, "", -9},
  {1.5809016832224119217699614e-22, 20, "", -20},
  {4.2887757170350421875000000e+13, 19, "42887757170350421875", 14},
  {1.9767346713033289749141257e-25, 3, "", -3},
  {8.2960869548096070810765844e-25, 3, "", -3},
  {4.2109171499052677120000000e+18, 9, "4210917149905267712", 19},
  {8.9433085317535117164915447e-09, 2, "", -2},
  {1.9979570627188218750000000e+14, 15, "1997957062718821875", 15},
  {3.4679142162727148333825817e-07, 18, "346791421627", -6},
  {1.5759893162550689697265625e+11, 12, "157598931625506896972656", 12},
  {5.1441600055893340979200000e+20, 4, "514416000558933409792", 21},
  {8.1178301706383307009308459e-05, 7, "812", -4},
  {6.2810616296467173924611416e+02, 4, "6281062", 3},
  {1.9607995259857684375000000e+14, 18, "19607995259857684375", 15},
  {1.3464147834047332812500000e+14, 15, "134641478340473328125", 15},
  {2.5165797763779880550400000e+20, 13, "251657977637798805504", 21},
  {5.7488546508909024298191071e+07, 11, "574885465089090243", 8},
  {5.1648137729564031982421875e+11, 17, "51648137729564031982421875", 12},
  {7.6955690622030616891008359e-04, 10, "7695569", -3},
  {3.0011575769715267329424153e-10, 12, "3", -9},
  {6.8428779521386768857336459e-06, 0, "", 0},
  {4.5027390017778752313755641e-17, 20, "4503", -16},
  {1.4831005514472700212991185e+01, 17, "1483100551447270021", 2},
  {3.1636625551140066560373842e-03, 0, "", 0},
  {3.9322193293133717191794457e-05, 17, "3932219329313", -4},
  {2.3133994562565765143941139e-23, 10, "", -10},
  {6.4118512104533606400000000e+17, 10, "641185121045336064", 18},
  {3.4880449558822929859161377e+08, 7, "3488044955882293", 9},
  {7.2578876523698775080209882e-16, 20, "72579", -15},
  {4.2241792565974717440000000e+18, 5, "4224179256597471744", 19},
  {1.9389067359313885390292853e+03, 12, "1938906735931389", 4},
  {4.2356145335708339843750000e+12, 16, "4235614533570833984375", 13},
  {1.7600990957447852800000000e+17, 7, "176009909574478528", 18},
  {2.7212691287163121884229149e-14, 7, "", -7},
  {1.2399443195569321909825030e-12, 6, "", -6},
  {9.9408250783686970572800000e+20, 13, "994082507836869705728", 21},
  {2.5637450913500005348803809e-25, 17, "", -17},
  {1.3758472871236639850384825e-07, 6, "", -6},
  {8.4127449037308193359375000e+12, 3, "8412744903730819", 13},
  {1.1123386806194348428727868e-09, 1, "", -1},
  {3.7528592639616403792146571e-01, 0, "", 0},
  {2.2680654062601370233831561e-12, 8, "", -8},
  {1.1049622058834256313275546e+05, 9, "110496220588343", 6},
  {6.6966285324068441471346994e-20, 2, "", -2},
  {5.8432039132394362413445546e-09, 6, "", -6},
  {8.1577315276122462617600000e+20, 8, "815773152761224626176", 21},
  {1.0973817255354608167010865e-15, 1, "", -1},
  {3.1009297183323143005371094e+10, 11, "3100929718332314300537", 11},
  {7.1093138859238941288422759e-13, 15, "711", -12},
  {9.9293607621434957045822731e-13, 1, "", -1},
  {3.8240006301132753920000000e+18, 2, "3824000630113275392", 19},
  {1.2687582930849760870400000e+20, 10, "126875829308497608704", 21},
  {4.2385867756839321600000000e+18, 8, "423858677568393216", 19},
  {8.9246666705533884729136130e-17, 19, "892", -16},
  {6.9779051786862272512000000e+19, 16, "69779051786862272512", 20},
  {1.6157933257094929920000000e+18, 12, "1615793325709492992", 19},
  {2.4223558777033284000000000e+16, 1, "24223558777033284", 17},
  {1.0760278413031024392694235e+06, 12, "1076027841303102439", 7},
  {4.8109352585754230973984031e-18, 16, "", -16},
  {6.4903589944723098393144296e-15, 2, "", -2},
  {3.8380904988862852033016827e-18, 4, "", -4},
  {4.1179836638341087465504614e-14, 20, "4117984", -13},
  {1.2794993041412761808659171e-08, 7, "", -7},
  {3.2209878387647104900498585e-04, 2, "", -2},
  {5.9801133186634620666503906e+10, 14, "5980113318663462066650391", 11},
  {8.8495894316570873391464123e-11, 5, "", -5},
  {1.2661724700694374553394672e-04, 10, "1266172", -3},
  {5.5428926781077890023599570e-12, 5, "", -5},
  {1.3205359366137915869970368e-14, 0, "", 0},
  {1.7972210557058845097344602e+03, 18, "1797221055705884509734", 4},
  {5.6405931464292280320000000e+18, 19, "5640593146429228032", 19},
  {4.0836506273097920417785645e+09, 16, "40836506273097920417785645", 10},
  {1.3259602531101017187500000e+14, 7, "132596025311010171875", 15},
  {1.2765579113140540197491646e+07, 4, "127655791131", 8},
  {4.5206968523391052800000000e+18, 11, "452069685233910528", 19},
  {1.0140417634757144021897396e-04, 18, "101404176347571", -3},
  {1.8597014670363498309200918e-09, 11, "186", -8},
  {8.4271425453148484230041504e+06, 0, "8427143", 7},
  {1.6154851074906429275870323e+07, 1, "161548511", 8},
  {1.4796562742307577124228187e-22, 8, "", -8},
  {1.6238033317332035168643302e-17, 1, "", -1},
  {4.3109099412085361216049500e-08, 18, "43109099412", -7},
  {3.1598398116240210867776056e-25, 16, "", -16},
  {8.2517316044994560000000000e+17, 14, "8251731604499456", 18},
  {3.8209325971452195312500000e+13, 13, "382093259714521953125", 14},
  {2.9864055980856455538478104e-15, 1, "", -1},
  {7.8245288299843245408939800e-10, 5, "", -5},
  {5.7634054139107841491699219e+10, 10, "576340541391078414917", 11},
  {2.5109923044718536376953125e+11, 1, "2510992304472", 12},
  {5.7590804500481419827467824e-11, 20, "575908045", -10},
  {2.2127952197663705604693555e-20, 8, "", -8},
  {6.9875326579459839704310323e-06, 2, "", -2},
  {1.7701998616776244861985984e-06, 14, "177019986", -5},
  {1.8379276029967423693629099e-20, 8, "", -8},
  {2.7263435771142763286434274e-02, 11, "2726343577", -1},
  {1.8431562460213641658135150e-06, 13, "18431562", -5},
  {6.4507660033507726562500000e+13, 12, "645076600335077265625", 14},
  {6.3928635943830144426263056e-13, 3, "", -3},
  {1.8075358597229927545413375e+05, 15, "180753585972299275454", 6},
  {1.2997581152340381357999219e-14, 4, "", -4},
  {2.4898213519666690262965858e+05, 10, "2489821351966669", 6},
  {1.6192393221883166000000000e+16, 20, "16192393221883166", 17},
  {5.9141753601264351317699803e-18, 3, "", -3},
  {3.2807805062045140266418457e+09, 9, "3280780506204514027", 10},
  {6.2759990815509770240000000e+18, 7, "6275999081550977024", 19},
  {1.4238812007824381763998467e-02, 17, "1423881200782438", -1},
  {7.7520353230874287500000000e+14, 15, "775203532308742875", 15},
  {2.8420327411112184853319612e-11, 12, "28", -10},
  {4.0967128548046974245681212e-07, 6, "", -6},
  {1.7799280119103500897916855e-11, 6, "", -6},
  {1.4681664782311323616900320e-10, 7, "", -7},
  {2.6195778165161367505788803e+06, 11, "261957781651613675", 7},
  {2.5105048600147249204805888e-02, 6, "25105", -1},
  {1.0596199596310429034105860e-04, 17, "1059619959631", -3},
  {6.5448087961271818161483414e-16, 1, "", -1},
  {2.0472497985202166445060172e-20, 12, "", -12},
  {8.2821696399589680000000000e+15, 12, "8282169639958968", 16},
  {2.0588302703674823760949360e-25, 18, "", -18},
  {6.1219328869273967394592610e-12, 12, "6", -11},
  {1.2604439953362725000000000e+15, 5, "12604439953362725", 16},
  {4.3668202881921793334640824e+01, 11, "4366820288192", 2},
  {1.3731981622327262878417969e+11, 7, "1373198162232726288", 12},
  {4.0699176037065498845742432e-19, 7, "", -7},
  {1.4429568143209065667065261e+01, 1, "144", 2},
  {1.5724790120178718755160404e-17, 12, "", -12},
  {2.5391311530458128000000000e+16, 16, "25391311530458128", 17},
  {5.7145170442591007586852214e-02, 20, "5714517044259100759", -1},
  {2.2952548698793322386191296e-04, 18, "229525486987933", -3},
  {9.4474072920697275664372872e-05, 17, "944740729207", -4},
  {9.8925604810127512942332165e-06, 3, "", -3},
  {3.5620851183893102047926745e-25, 16, "", -16},
  {1.3877025814049554432000000e+20, 2, "13877025814049554432", 21},
  {1.2256957058096547541481414e+02, 4, "1225696", 3},
  {2.1919956107984443424707699e-03, 6, "2192", -2},
  {2.1640899929516296021345668e-15, 5, "", -5},
  {1.5404389700891659231274389e+04, 14, "1540438970089165923", 5},
  {2.8338681710216665407701208e-13, 0, "", 0},
  {1.3207726000138947963714600e+09, 17, "132077260001389479637145996", 10},
  {1.0688661469189322087913752e+05, 8, "10688661469189", 6},
  {8.5483578334656326908020215e-24, 5, "", -5},
  {7.9687183617568192062920334e-23, 19, "", -19},
  {1.2447042812220825762832834e-19, 1, "", -1},
  {2.4027375160298480224609375e+11, 8, "24027375160298480225", 12},
  {2.2041341814928879454160732e-10, 6, "", -6},
  {3.2899630722052848815917969e+10, 18, "3289963072205284881591796875", 11},
  {4.3324805863571611841659045e-18, 13, "", -13},
  {2.3821481005267748000000000e+16, 14, "23821481005267748", 17},
  {1.9166626861150840303067314e-25, 1, "", -1},
  {1.2144787041505117342055087e-01, 14, "12144787041505", 0},
  {6.8185139838412122034029083e-13, 18, "681851", -12},
  {6.5758845703950859962416491e-14, 1, "", -1},
  {1.0315401603492091894149780e+09, 16, "1031540160349209189414978", 10},
  {1.8170420644164924621582031e+09, 6, "1817042064416492", 10},
  {6.8846250813096860743505211e-22, 11, "", -11},
  {1.3692833140795422626324074e-19, 9, "", -9},
  {6.8977400330964107264000000e+20, 5, "68977400330964107264", 21},
  {1.8256165363853031396865845e+08, 5, "18256165363853", 9},
  {6.5744764855738304912594496e-14, 9, "", -9},
  {2.9411361968219806554574498e-16, 0, "", 0},
  {1.1302016484825907503189215e-15, 4, "", -4},
  {1.9525297012590367290907483e-23, 11, "", -11},
  {4.9771478624035578966140747e+08, 1, "4977147862", 9},
  {1.0201268167547566400000000e+17, 11, "102012681675475664", 18},
  {6.9342452881406220850511423e-09, 10, "69", -8},
  {4.9671542589913020293579393e+00, 20, "496715425899130202936", 1},
  {5.6661022273784122232909155e-03, 9, "5666102", -2},
  {1.5570443382642776309103736e-09, 4, "", -4},
  {6.9737898232592476562500000e+13, 7, "697378982325924765625", 14},
  {2.5210037979565436216944363e+03, 16, "25210037979565436217", 4},
  {5.4117205307214617729187012e+08, 19, "5411720530721461772918701172", 9},
  {3.3379214586975618000649901e-04, 16, "3337921458698", -3},
  {1.9265665639629129322090165e-22, 11, "", -11},
  {3.5226228934091547567118603e-17, 20, "3523", -16},
  {2.2265984207066339593643709e-18, 1, "", -1},
  {2.3409869921056686401367188e+11, 1, "2340986992106", 12},
  {2.6537219328727863418282418e-03, 8, "265372", -2},
  {5.4365970270725266951337610e-24, 20, "", -20},
  {2.1175085275936709185347534e-14, 19, "211751", -13},
  {2.1879861625477728000000000e+16, 6, "21879861625477728", 17},
  {1.9840246632117245229564755e-13, 9, "", -9},
  {2.8883958078233780777683420e-05, 2, "", -2},
  {5.2735230428684991277332728e-02, 2, "5", -1},
  {1.0723851516137614212510060e-04, 5, "11", -3},
  {2.4108564744795160576000000e+20, 4, "24108564744795160576", 21},
  {5.6770125060317760757254945e-11, 10, "1", -9},
  {1.3517743746856758370995522e+07, 17, "1351774374685675837099552", 8},
  {8.6104852515947452047839761e+04, 20, "8610485251594745204783976", 5},
  {3.9055160801520838464995222e-01, 8, "39055161", 0},
  {1.5741854619324753284454346e+09, 16, "15741854619324753284454346", 10},
  {2.3724969907492515932612416e-14, 6, "", -6},
  {1.8989393620685970829485340e-20, 18, "", -18},
  {2.4382026688066843671143184e-18, 9, "", -9},
  {2.1843759623551339821290185e-01, 12, "218437596236", 0},
  {3.4300389477524826049804688e+10, 19, "343003894775248260498046875", 11},
  {5.5286522073489057439276502e-13, 3, "", -3},
  {3.0766255027964538875782268e-08, 3, "", -3},
  {2.9049507946345886011840776e+04, 4, "290495079", 5},
  {2.1651997760391023667425614e-02, 2, "2", -1},
  {6.5752023876384775000000000e+14, 6, "65752023876384775", 15},
  {9.9204619703298973831806506e+01, 5, "9920462", 2},
  {1.5500522942106036931170232e-03, 16, "15500522942106", -2},
  {4.4264802873942740604319913e-12, 18, "442648", -11},
  {7.6629747370173072000000000e+16, 15, "76629747370173072", 17},
  {8.3828275891834229230880737e+07, 2, "8382827589", 8},
  {2.6653564221447641497600000e+20, 9, "266535642214476414976", 21},
  {1.7512257090029447681445163e+03, 16, "17512257090029447681", 4},
  {2.4242852034742232564453674e-23, 5, "", -5},
  {5.4343050737077801513671875e+11, 15, "54343050737077801513671875", 12},
  {5.3771824267793018016302993e-07, 8, "54", -6},
  {1.7127600703868381184000000e+19, 8, "17127600703868381184", 20},
  {3.8131603256583875131396714e-16, 7, "", -7},
  {1.9008532899054367065429688e+11, 2, "19008532899054", 12},
  {1.2755036639634035236667842e+05, 13, "1275503663963403524", 6},
  {1.4611921808346644596677050e-12, 13, "15", -11},
  {8.8545129986053978894369720e-15, 5, "", -5},
  {1.1833485319612641717412771e+01, 20, "1183348531961264171741", 2},
  {2.7611661973949413176265011e-08, 9, "28", -7},
  {8.9231522025954537093639374e+05, 16, "8923152202595453709364", 6},
  {5.7838270456797468662261963e+08, 13, "5783827045679746866226", 9},
  {7.5161939679919032020194436e-01, 8, "7516194", 0},
  {2.7577155142821656308438349e-02, 3, "28", -1},
  {4.7551663319393581292748987e-21, 15, "", -15},
  {1.3038064471483410748048144e-21, 17, "", -17},
  {3.1082724835589394461168779e-06, 0, "", 0},
  {7.4869842518595712500000000e+14, 14, "748698425185957125", 15},
  {1.0160256864652938384097070e+05, 1, "1016026", 6},
  {3.5026005099557746842037220e-04, 18, "350260050995577", -3},
  {1.2304480523352562073600000e+20, 10, "123044805233525620736", 21},
  {6.9984538736040366347879171e+05, 14, "69984538736040366348", 6},
  {3.5304939468846813184000000e+19, 10, "35304939468846813184", 20},
  {9.8544028823386711469790776e-21, 14, "", -14},
  {5.0231772505704062500000000e+13, 8, "502317725057040625", 14},
  {6.4020729699242319838958792e+03, 7, "64020729699", 4},
  {1.2833523534131708738782212e-19, 14, "", -14},
  {6.8720740045045504000000000e+18, 4, "68720740045045504", 19},
  {6.1068847225006236987181817e-10, 19, "6106884723", -9},
  {5.8234113084472571841843092e-01, 2, "58", 0},
  {1.0746886557648647601314498e-11, 4, "", -4},
  {4.3507822703570825113167375e-05, 13, "435078227", -4},
  {8.4581158991173012241009674e-21, 10, "", -10},
  {8.9402574512579533429937264e-24, 2, "", -2},
  {1.3625373452120683520000000e+18, 17, "1362537345212068352", 19},
  {7.5991061892496942646543529e-09, 5, "", -5},
  {1.4356230129954623488000000e+19, 2, "14356230129954623488", 20},
  {7.7317218078483112500000000e+14, 9, "773172180784831125", 15},
  {1.5604935503669649650682784e-18, 6, "", -6},
  {2.6644759497398541725488030e+02, 15, "266447594973985417", 3},
  {4.0936511846168652176856995e+07, 13, "409365118461686521769", 8},
  {2.8275046386737119239688371e-06, 6, "3", -5},
  {1.3872303537761148431749391e-14, 12, "", -12},
  {1.6204118189696243653443452e-17, 4, "", -4},
  {2.4984940551404063589870930e+06, 4, "24984940551", 7},
  {5.0784619653101184082031250e+11, 15, "5078461965310118408203125", 12},
  {4.7033311669992958175659445e-14, 10, "", -10},
  {3.0848321886020717415913613e-18, 7, "", -7},
  {3.7041768547704996308311820e+03, 7, "37041768548", 4},
  {2.2691142004408132004792563e-21, 1, "", -1},
  {1.1838071026431060546875000e+13, 5, "1183807102643106055", 14},
  {2.2072917224652272238927253e+02, 8, "22072917225", 3},
  {1.1669750889493071462400000e+20, 3, "116697508894930714624", 21},
  {6.8837819206571602262556553e+05, 18, "688378192065716022625566", 6},
  {3.6120575129597573618830964e-13, 3, "", -3},
  {3.8950570072206014394760132e+08, 3, "389505700722", 9},
  {4.0954308813251338823837175e-16, 19, "4095", -15},
  {1.7119554726468658000000000e+16, 3, "17119554726468658", 17},
  {1.1385323305949799804687500e+12, 1, "1138532330595", 13},
  {9.4403868863439169681554226e-15, 15, "9", -14},
  {6.9398477869764714919238311e-10, 10, "7", -9},
  {4.5168097545457836531568319e+04, 8, "4516809754546", 5},
  {1.2274984658052165242150747e-10, 18, "122749847", -9},
  {8.7567559113809478876788717e-03, 3, "9", -2},
  {1.6297674476806180976495853e+00, 3, "163", 1},
  {1.7322339017780059074874677e-03, 5, "173", -2},
  {1.5695407430109059132398996e-04, 17, "15695407430109", -3},
  {3.6323184272139002359836013e+01, 0, "36", 2},
  {1.0596796313356027603149414e+10, 15, "10596796313356027603149414", 11},
  {8.4779830778141422342741862e+02, 2, "8478", 3},
  {1.5924697134590207519531250e+12, 0, "1592469713459", 13},
  {4.2493735565431087104000000e+19, 7, "42493735565431087104", 20},
  {1.2089107024152015762736155e-18, 8, "", -8},
  {2.0858744141072972970173214e-22, 20, "", -20},
  {6.1334788346095733642578125e+10, 12, "61334788346095733642578", 11},
  {5.2510691042254319357595857e-17, 9, "", -9},
  {2.3073426766139725572792628e-17, 3, "", -3},
  {4.1533373882127967230673128e-14, 9, "", -9},
  {1.6368110092418085683200000e+20, 1, "163681100924180856832", 21},
  {2.5338879984589714556932449e+07, 7, "253388799845897", 8},
  {2.1029186768144251390433297e-02, 11, "2102918677", -1},
  {1.1816557610849842187500000e+14, 7, "118165576108498421875", 15},
  {8.1296592441105716177196516e-04, 15, "812965924411", -3},
  {3.5248552520622627745422862e-21, 0, "", 0},
  {1.5952078939434321597218513e+07, 14, "1595207893943432159722", 8},
  {9.2401611567414951936000000e+19, 4, "92401611567414951936", 20},
  {2.2648183591852177193315399e-02, 0, "", 0},
  {5.8628425374985988194201794e-12, 13, "59", -11},
  {1.7912557633991424615440685e-20, 16, "", -16},
  {6.0995608105054884617857169e+01, 20, "6099560810505488461786", 2},
  {2.0026610413374949265158547e-10, 5, "", -5},
  {1.3386347050985810546875000e+12, 18, "13386347050985810546875", 13},
  {7.3630445439401123840000000e+19, 2, "7363044543940112384", 20},
  {6.1291347168680638433623085e-14, 12, "", -12},
  {1.3739794825470590976000000e+20, 12, "13739794825470590976", 21},
  {1.8877288485679435000000000e+15, 20, "18877288485679435", 16},
  {2.7164813353831395943416283e+03, 15, "2716481335383139594", 4},
  {6.9921394013628140000000000e+15, 7, "6992139401362814", 16},
  {5.8568606233930916021129061e-14, 13, "1", -12},
  {3.5378667467791906346974429e+03, 2, "353787", 4},
  {4.1290971476060680358453053e-13, 10, "", -10},
  {7.1486841155644054168760704e-01, 4, "7149", 0},
  {6.3421631258056834340095520e+07, 19, "6342163125805683434009552", 8},
  {1.1924762026690601788483980e-17, 7, "", -7},
  {5.1130921002510307502919407e-22, 20, "", -20},
  {1.8852414004856491520000000e+18, 20, "1885241400485649152", 19},
  {5.1494672125712567138671875e+11, 16, "51494672125712567138671875", 12},
  {4.9630805801460636330810346e-17, 16, "", -16},
  {2.5180580376527881852238063e-06, 8, "252", -5},
  {1.5216702814955103427594129e-25, 12, "", -12},
  {1.8995860234399777255021036e+04, 19, "18995860234399777255021", 5},
  {4.7656820090217285407510102e-24, 6, "", -6},
  {8.2239993618510926936298188e-12, 16, "8224", -11},
  {2.6532263955608716607093811e+08, 1, "2653226396", 9},
  {5.8445681356254950745546847e-08, 10, "584", -7},
  {3.5562565270664354102336802e+03, 4, "35562565", 4},
  {3.4638959323401453748494608e-12, 3, "", -3},
  {7.5620351179983028224000000e+19, 14, "75620351179983028224", 20},
  {8.0442651455054381056000000e+19, 1, "80442651455054381056", 20},
  {2.4616173782780174119285901e-14, 3, "", -3},
  {5.9833248126415619626641273e+06, 14, "598332481264156196266", 7},
  {8.4875900997140075571241228e-11, 17, "848759", -10},
  {5.1049908268033265948583480e-19, 4, "", -4},
  {1.2330843342741638387342245e-06, 10, "12331", -5},
  {8.9829008299946940496738534e+02, 6, "898290083", 3},
  {7.8218482621561658679754103e-03, 7, "78218", -2},
  {2.1649907497949845878037288e-24, 12, "", -12},
  {2.8593875944933072000000000e+17, 6, "28593875944933072", 18},
  {2.0950768734296322092519586e-18, 18, "2", -17},
  {3.2573439051612355000000000e+15, 11, "32573439051612355", 16},
  {1.0877038838210163001973729e-25, 11, "", -11},
  {2.1908641054254963899374750e-20, 7, "", -7},
  {6.6408869901557200000000000e+15, 4, "664088699015572", 16},
  {2.5692063019943103427067399e+05, 20, "25692063019943103427067399", 6},
  {1.9395921189832110080000000e+19, 18, "1939592118983211008", 20},
  {6.4292302422936924267560244e+05, 2, "64292302", 6},
  {1.4283873792328954661105791e-24, 19, "", -19},
  {7.1402336153989697265625000e+11, 6, "714023361539896973", 12},
  {4.1495151549163769230208214e-19, 8, "", -8},
  {2.3555040309975307621925822e+01, 0, "24", 2},
  {1.5639840382096632003784180e+10, 5, "1563984038209663", 11},
  {4.7721521020901716838125139e+04, 12, "47721521020901717", 5},
  {1.7520552117122272666422683e-22, 7, "", -7},
  {2.5627943407932954476506445e-17, 7, "", -7},
  {2.6938617937766978125000000e+14, 12, "26938617937766978125", 15},
  {9.7859588371661663288572294e-06, 17, "978595883717", -5},
  {2.7225516463172924804687500e+11, 14, "272255164631729248046875", 12},
  {1.1050156413566735000000000e+15, 12, "11050156413566735", 16},
  {6.7911578993271593112226305e-16, 1, "", -1},
  {3.0264080457827063948269387e-12, 15, "3026", -11},
  {6.2485766844562052880346573e-12, 10, "", -10},
  {7.5453114594539218151769688e-05, 1, "", -1},
  {4.1056834946491475752713975e-13, 0, "", 0},
  {5.9500238689486333477224322e-04, 7, "595", -3},
  {2.0166943864367122046136278e-08, 13, "201669", -7},
  {8.0327766704507066057330870e-20, 12, "", -12},
  {3.1169596722443617568063276e-23, 11, "", -11},
  {1.5072567612354922154943618e-23, 14, "", -14},
  {1.8336268454389570425888678e-01, 2, "18", 0},
  {7.1870575228973363479667569e+00, 14, "718705752289734", 1},
  {1.0168558173108863281250000e+13, 13, "1016855817310886328125", 14},
  {6.3272762000126609802246094e+09, 5, "632727620001266", 10},
  {2.2018870011111503709813619e-04, 17, "22018870011112", -3},
  {1.4346806658691770280711353e+04, 13, "143468066586917703", 5},
  {1.0252996520999323750000000e+15, 13, "1025299652099932375", 16},
  {3.8610156364720634883269668e+05, 10, "3861015636472063", 6},
  {2.0997639597444544783645090e-21, 16, "", -16},
  {1.4378590923049530029296875e+10, 6, "1437859092304953", 11},
  {6.2749616792113528832000000e+19, 10, "62749616792113528832", 20},
  {2.3845924550890448823103895e-01, 13, "2384592455089", 0},
  {6.4821620228119069608582834e-08, 11, "6482", -7},
  {8.7147344219829171868626075e-23, 5, "", -5},
  {2.4326756041643279604613781e+05, 14, "24326756041643279605", 6},
  {3.0969976961358636800000000e+17, 17, "309699769613586368", 18},
  {4.5709438360773032000000000e+16, 6, "45709438360773032", 17},
  {1.0817430455222670400000000e+17, 18, "108174304552226704", 18},
  {4.5275544587886112179704291e-11, 18, "45275545", -10},
  {1.0168849909256275254004345e-19, 5, "", -5},
  {2.2598664081204111425904557e+04, 16, "225986640812041114259", 5},
  {2.0910700831190081987187579e-03, 4, "21", -2},
  {4.6207787574809067520000000e+18, 13, "4620778757480906752", 19},
  {5.8331086494846704101562500e+11, 20, "583310864948467041015625", 12},
  {1.3041043394851742007189976e-02, 9, "13041043", -1},
  {9.3797278378638196736000000e+19, 2, "93797278378638196736", 20},
  {6.0285377861415512911591361e-16, 19, "6029", -15},
  {9.7250565471267581135750291e-04, 13, "9725056547", -3},
  {6.5953501693992868249600000e+20, 13, "659535016939928682496", 21},
  {1.3925071499014663526543579e-09, 2, "", -2},
  {3.1522363117734393792641070e-15, 8, "", -8},
  {3.7256529755669323382907148e-07, 5, "", -5},
  {9.4922765645325291520000000e+18, 10, "9492276564532529152", 19},
  {5.4484457955164848283469148e-04, 1, "", -1},
  {2.7188536010078228480000000e+18, 13, "2718853601007822848", 19},
  {2.3056426159037629258818924e+05, 6, "23056426159", 6},
  {2.1267560169180950800869504e-12, 9, "", -9},
  {9.8693853232720614050348501e-11, 19, "986938532", -10},
  {8.5259048667871717293671732e-13, 2, "", -2},
  {1.0580127979670218750000000e+13, 7, "1058012797967021875", 14},
  {2.8359696995822504528295127e-03, 7, "2836", -2},
  {7.2159791994237148437500000e+12, 6, "7215979199423714844", 13},
  {6.7467285010711724209034033e-19, 0, "", 0},
  {3.3748008312725850902685511e-25, 0, "", 0},
  {1.7314924374321305600000000e+17, 2, "173149243743213056", 18},
  {2.6812893585125544700017500e-08, 10, "268", -7},
  {5.7438949609104424960000000e+19, 5, "5743894960910442496", 20},
  {4.4567228201531708929074294e-06, 19, "44567228201532", -5},
  {5.0127144509789780165533660e-23, 1, "", -1},
  {2.4615498181955187200000000e+17, 6, "246154981819551872", 18},
  {1.5503874157471582293510437e+03, 8, "155038741575", 4},
  {5.0086886700622055010965833e-10, 19, "500868867", -9},
  {1.9517470853900596499443054e+08, 12, "195174708539005964994", 9},
  {1.3757261822461342671886086e+05, 3, "137572618", 6},
  {1.4093832455909162197798921e-22, 16, "", -16},
  {7.1197777426577758789062500e+08, 4, "7119777742658", 9},
  {8.8717425183867788314819336e+08, 8, "88717425183867788", 9},
  {8.9813721325781189649737392e-20, 8, "", -8},
  {6.9307910184500137599339694e-19, 16, "", -16},
  {5.2911223601367544730747321e-20, 6, "", -6},
  {2.4296885049432245676902426e-24, 12, "", -12},
  {2.3385312724514442379586399e+05, 1, "2338531", 6},
  {5.0775285843735976781809782e-03, 7, "50775", -2},
  {9.9363417708423436800000000e+17, 6, "993634177084234368", 18},
  {3.7393463736309328737661417e+01, 18, "37393463736309328738", 2},
  {1.3855978983531632935319620e-13, 0, "", 0},
  {1.7103354679057030066497011e-14, 7, "", -7},
  {3.8288393830618344247341156e+07, 16, "382883938306183442473412", 8},
  {4.1938277011248509040797217e+01, 17, "4193827701124850904", 2},
  {3.9860090567140327300170235e-13, 13, "4", -12},
  {2.4117553288164881250000000e+14, 3, "241175532881648813", 15},
  {2.4565575249085984311038767e-13, 14, "25", -12},
  {6.1615645096627312709640553e-11, 8, "", -8},
  {1.5145720696149083769835050e-15, 3, "", -3},
  {4.6560573069270678388420492e+04, 18, "4656057306927067838842", 5},
  {8.9257713493920672943350569e-05, 2, "", -2},
  {4.9180522634591806096894560e-16, 19, "4918", -15},
  {8.0676807254452720000000000e+15, 6, "8067680725445272", 16},
  {6.9636121888770355200000000e+17, 1, "696361218887703552", 18},
  {4.3435741898664437500000000e+14, 15, "434357418986644375", 15},
  {4.3554528314056709055706378e-09, 5, "", -5},
  {4.0474841970679285561026219e-08, 12, "40475", -7},
  {3.9368191190692177565003724e-20, 20, "4", -19},
  {2.9436129965402750000000000e+13, 9, "2943612996540275", 14},
  {6.5737272864021190077465917e-01, 7, "6573727", 0},
  {7.3620221255823093750000000e+13, 10, "7362022125582309375", 14},
  {3.9654474862807421410438649e-16, 16, "4", -15},
  {4.8634190222949874877929688e+10, 19, "486341902229498748779296875", 11},
  {3.5389889100735913962125778e+05, 12, "35389889100735914", 6},
  {3.0999899915568598709689995e-22, 10, "", -10},
  {1.5632214178228409672219342e-11, 6, "", -6},
  {4.8704826203795856387766916e-24, 8, "", -8},
  {1.9182736751196343500800000e+20, 5, "191827367511963435008", 21},
  {2.6058164543521068990230560e+06, 5, "260581645435", 7},
  {3.6707577165873508453369141e+09, 10, "36707577165873508453", 10},
  {7.0357306507501068800000000e+17, 16, "703573065075010688", 18},
  {2.6440883814715388000000000e+16, 19, "26440883814715388", 17},
  {1.5411953397090069367610824e-23, 8, "", -8},
  {8.2037985722139943071569499e-16, 9, "", -9},
  {1.7315111071312002563476562e+11, 8, "17315111071312002563", 12},
  {2.7358184148980797192571455e-11, 5, "", -5},
  {2.9217235068167292377783184e-02, 6, "29217", -1},
  {6.7414977806495401946307311e-01, 19, "6741497780649540195", 0},
  {5.9473917271829579735919263e-10, 10, "6", -9},
  {9.6649665363401034956800000e+20, 19, "966496653634010349568", 21},
  {8.4964939326594834251293875e-03, 3, "8", -2},
  {1.7918832586459287995239720e+04, 4, "179188326", 5},
  {6.3264271025237491744702689e-04, 10, "6326427", -3},
  {9.0602011692251232570327930e-21, 0, "", 0},
  {2.9468500957476656185463071e+05, 10, "2946850095747666", 6},
  {8.8927036864032944000000000e+16, 3, "88927036864032944", 17},
  {7.7225882479181002793211519e+00, 15, "77225882479181", 1},
  {2.1932939146753639009235215e-02, 18, "21932939146753639", -1},
  {6.6725351727355017517279503e-06, 7, "67", -5},
  {1.4489655517232393293079850e-11, 12, "14", -10},
  {4.4735207857336314332067501e-05, 8, "4474", -4},
  {9.5819237002346960009163866e-21, 11, "", -11},
  {2.3915523868203382613917274e-03, 15, "239155238682", -2},
  {2.0676225487592150724446092e-06, 12, "2067623", -5},
  {6.6183865064355021563372954e-22, 1, "", -1},
  {2.2374117851589587402343750e+11, 19, "2237411785158958740234375", 12},
  {1.4178436040570169702756725e-17, 12, "", -12},
  {2.4793251667018094712077736e-04, 7, "2479", -3},
  {8.6571476797705078125000000e+08, 4, "8657147679771", 9},
  {1.3260014636089394000000000e+16, 19, "13260014636089394", 17},
  {3.6834757171893560000000000e+16, 3, "3683475717189356", 17},
  {7.0228338551941156387329102e+07, 7, "702283385519412", 8},
  {3.5997118664920962111621518e-18, 11, "", -11},
  {4.6446748222538780696807867e-18, 0, "", 0},
  {1.9042218678692894202490042e-25, 6, "", -6},
  {2.5928554525554750114679337e+07, 18, "25928554525554750114679337", 8},
  {7.2128385838689669783310802e-24, 13, "", -13},
  {2.2619869167880286884951541e-13, 17, "2262", -12},
  {3.7913267622044934774486885e-05, 1, "", -1},
  {9.4834137853797440941699959e-04, 13, "9483413785", -3},
  {8.3849409434166032000000000e+16, 6, "83849409434166032", 17},
  {3.2097865929566918400000000e+17, 18, "320978659295669184", 18},
  {2.9741135533928563200000000e+17, 9, "297411355339285632", 18},
  {3.6119752012080748380660625e-09, 3, "", -3},
  {1.3004396374075659509755736e-18, 3, "", -3},
  {1.3898523656726911376784525e-21, 8, "", -8},
  {2.9700878759005366447354390e+01, 3, "29701", 2},
  {1.1064561023484785789780179e-16, 20, "11065", -15},
  {1.2125820643354289062500000e+14, 8, "121258206433542890625", 15},
  {3.6132973917883878800516584e-02, 15, "36132973917884", -1},
  {1.9123914168162742187500000e+13, 10, "191239141681627421875", 14},
  {1.6737703478350621756115913e-20, 13, "", -13},
  {3.6602379468576665967702866e+06, 7, "36602379468577", 7},
  {5.5771641353475653632000000e+20, 2, "55771641353475653632", 21},
  {8.6164141973470262682728126e-17, 7, "", -7},
  {2.4175604359897415625000000e+14, 1, "2417560435989742", 15},
  {9.2167513217428363763361263e-06, 11, "921675", -5},
  {1.8152380561232939935317679e-15, 14, "", -14},
  {2.1200857747831413549607828e-06, 5, "", -5},
  {4.6624827588277149364852142e-20, 12, "", -12},
  {5.6439743260285040795214041e-11, 18, "56439743", -10},
  {1.8464632365910928647051437e-04, 11, "18464632", -3},
  {1.7508827130228463240385617e-03, 4, "18", -2},
  {1.8502839752151971264511646e-07, 4, "", -4},
  {3.6433067507749132211806748e-06, 3, "", -3},
  {3.1759579656553924560546875e+10, 11, "3175957965655392456055", 11},
  {7.6699127609600319094505737e-18, 18, "8", -17},
  {5.6394978165589222385278845e+00, 13, "56394978165589", 1},
  {5.1863879088860943750000000e+14, 2, "51863879088860944", 15},
  {1.3187332306660571703105234e+04, 17, "1318733230666057170311", 5},
  {1.8757591583207688934464841e-01, 10, "1875759158", 0},
  {9.2108041710956743653923584e-05, 12, "92108042", -4},
  {7.2601235802826367064236721e-18, 7, "", -7},
  {1.6627851514788996305925038e-12, 3, "", -3},
  {1.2607971093094857838694058e-10, 5, "", -5},
  {2.1004591372208704314061833e+01, 9, "21004591372", 2},
  {3.1721972683480441600000000e+17, 18, "317219726834804416", 18},
  {5.1769199406970492187500000e+13, 2, "5176919940697049", 14},
  {1.1221974755489583230882999e+02, 12, "112219747554896", 3},
  {6.0024764725657496000000000e+16, 1, "60024764725657496", 17},
  {1.3050906951377544535929648e-11, 13, "131", -10},
  {1.2436232088276825600000000e+17, 1, "124362320882768256", 18},
  {7.0242795317579703405499458e+06, 5, "702427953176", 7},
  {3.0020536496380629882812500e+12, 18, "300205364963806298828125", 13},
  {8.2396667913010623306035995e+06, 5, "82396667913", 7},
  {1.2122097569202676756904649e-10, 10, "1", -9},
  {1.0873211689367700195312500e+11, 6, "108732116893677002", 12},
  {6.0785459381361023437500000e+13, 4, "607854593813610234", 14},
  {4.6154403982677993326794175e-04, 0, "", 0},
  {8.0213632064473795890808105e+08, 18, "802136320644737958908081055", 9},
  {3.1190097549449535156250000e+13, 3, "31190097549449535", 14},
  {1.3312220959960505695107713e+01, 20, "1331222095996050569511", 2},
  {5.4976128441533210624000000e+19, 13, "54976128441533210624", 20},
  {5.8663701521114137449330883e+02, 20, "58663701521114137449331", 3},
  {9.2734269183055758476257324e+08, 10, "9273426918305575848", 9},
  {6.7405463914826696972424009e-15, 12, "", -12},
  {1.0222393555819418880000000e+18, 15, "1022239355581941888", 19},
  {9.5589857059876688000000000e+16, 17, "95589857059876688", 17},
  {6.9451917091411244178347377e-14, 18, "69452", -13},
  {1.8390486031128176896222142e-08, 15, "18390486", -7},
  {2.1070428214709966679347903e-25, 4, "", -4},
  {1.4251032581563223148532700e-22, 17, "", -17},
  {1.9457577720720648193359375e+11, 6, "194575777207206482", 12},
  {2.4751331602734627512774068e-01, 1, "2", 0},
  {6.3141579445656112428425757e-13, 7, "", -7},
  {1.5887241386887393409222571e-08, 0, "", 0},
  {3.8380392362408535040000000e+18, 4, "3838039236240853504", 19},
  {2.6249417400151893496513367e+07, 20, "262494174001518934965133667", 8},
  {1.4481506067773405604684130e-08, 1, "", -1},
  {7.8758172013484253109483077e-10, 15, "787582", -9},
  {1.8778802386711965332031250e+12, 13, "1877880238671196533203125", 13},
  {1.2695152216125540236333287e-21, 11, "", -11},
  {4.1768240103449532386620664e-12, 11, "", -11},
  {1.6130129083056635863613337e+03, 10, "16130129083057", 4},
  {5.0159058101852923494400000e+20, 7, "501590581018529234944", 21},
  {1.1469745282936654421922142e-20, 12, "", -12},
  {1.2975461281736358916903759e-20, 5, "", -5},
  {4.8498978476916636282112449e+04, 2, "4849898", 5},
  {8.7187308527026969600000000e+17, 4, "871873085270269696", 18},
  {7.7277201202901619984180250e-25, 13, "", -13},
  {6.6991186051837866803200000e+20, 8, "669911860518378668032", 21},
  {6.6072959414199462890625000e+12, 10, "66072959414199462890625", 13},
  {2.9441915197948019017191078e-21, 16, "", -16},
  {1.7143168097166989472829660e-15, 16, "17", -14},
  {2.0475807330189167677295808e-06, 9, "2048", -5},
  {1.2664502527870983673010939e-08, 12, "12665", -7},
  {2.5702218729144564713351429e+05, 4, "2570221873", 6},
  {5.0811398997911181152535023e-24, 6, "", -6},
  {2.6361482988970223968743282e-17, 11, "", -11},
  {2.0311607338273903727531433e+08, 2, "20311607338", 9},
  {1.0347789183693627500000000e+15, 9, "103477891836936275", 16},
  {1.2595124808498819675151026e+03, 20, "12595124808498819675151", 4},
  {5.1554997071680352091789246e+06, 0, "51555", 7},
  {2.4777495959259513738098231e-23, 6, "", -6},
  {1.0204519029813785213085436e-17, 9, "", -9},
  {1.5177068984611253836192191e+05, 10, "1517706898461125", 6},
  {6.3185633130244207222858677e+02, 19, "6318563313024420722286", 3},
  {1.0268909450452960319593300e-22, 3, "", -3},
  {8.0063728445973408000000000e+16, 16, "80063728445973408", 17},
  {2.3897502967605105368420482e+04, 12, "23897502967605105", 5},
  {1.2958143108774838272000000e+20, 8, "12958143108774838272", 21},
  {2.5711492508712388613352610e-12, 3, "", -3},
  {1.1836553637242385600000000e+17, 20, "118365536372423856", 18},
  {8.5342505276160239736874430e-16, 9, "", -9},
  {6.0229775322116483675353801e-17, 8, "", -8},
  {1.0025258373819193314859056e-22, 16, "", -16},
  {9.6377282924188341439730721e+02, 2, "96377", 3},
  {3.2507650180760689079761505e+07, 13, "325076501807606890798", 8},
  {9.7747239981330384319144702e-23, 14, "", -14},
  {4.7458071483367779541015625e+11, 13, "4745807148336777954101563", 12},
  {6.2642877634810280248473488e-21, 0, "", 0},
  {1.2545188599901095261751095e-05, 2, "", -2},
  {3.8898286800044217670802027e+04, 3, "38898287", 5},
  {1.3444710036788977050781250e+11, 16, "1344471003678897705078125", 12},
  {2.3389857605552353177524014e-23, 19, "", -19},
  {1.5066492842784897423640653e-19, 20, "15", -18},
  {7.0913841542732498623990978e+01, 2, "7091", 2},
  {2.2255474383365631103515625e+11, 12, "222554743833656311035156", 12},
  {5.1935620189369322461425999e-11, 8, "", -8},
  {5.0141664955836720764636993e+04, 7, "501416649558", 5},
  {1.2311699664460437011718750e+12, 12, "1231169966446043701171875", 13},
  {2.0288606349758354918666470e-02, 12, "2028860635", -1},
  {8.6834938667857984000000000e+17, 0, "86834938667857984", 18},
  {4.2678606485693262845343118e-10, 0, "", 0},
  {8.8423736566688384000000000e+16, 4, "88423736566688384", 17},
  {1.7683023616404783607861557e-12, 9, "", -9},
  {1.6473154969674830283565825e-02, 4, "165", -1},
  {1.6082130264775326440923997e-24, 18, "", -18},
  {2.1995874561258855806045176e+02, 10, "2199587456126", 3},
  {3.1932497091641713655544671e-14, 9, "", -9},
  {8.0707728342410497046795215e-06, 14, "807077283", -5},
  {5.7928928882371507757603922e-14, 17, "5793", -13},
  {4.2184784899882254356772750e-06, 15, "421847849", -5},
  {3.4220047961719676000000000e+16, 19, "34220047961719676", 17},
  {1.1159477443266316069053230e-07, 9, "112", -6},
  {5.5860200475317094377608880e-15, 17, "559", -14},
  {2.1314242492057923227548599e+06, 16, "21314242492057923227549", 7},
  {6.8433012926578867435455322e+08, 2, "68433012927", 9},
  {7.8182681850945637500000000e+14, 8, "781826818509456375", 15},
  {7.3378710728875617980957031e+09, 15, "7337871072887561798095703", 10},
  {8.0740298688496923672153270e-18, 2, "", -2},
  {1.9097396838957300186157227e+09, 13, "19097396838957300186157", 10},
  {1.2487548905541060937500000e+14, 4, "1248754890554106094", 15},
  {3.5575588121747456459004450e-22, 16, "", -16},
  {8.8500361455385418312637716e-21, 3, "", -3},
  {3.7023575437490296817114707e-09, 1, "", -1},
  {1.1332815741439048828125000e+13, 11, "11332815741439048828125", 14},
  {3.4264317926918691616135462e-19, 18, "", -18},
  {3.1969571959990702453069389e+04, 19, "319695719599907024530694", 5},
  {3.9355250163379171460541998e-12, 18, "3935525", -11},
  {1.5496763431032436031387078e+01, 6, "15496763", 2},
  {1.1485429808744497600000000e+17, 17, "114854298087444976", 18},
  {2.9105727484761292650346070e-09, 11, "291", -8},
  {9.4654247526275586939458967e-10, 19, "9465424753", -9},
  {2.1614563169326125868785482e-02, 15, "21614563169326", -1},
  {1.3571264642323347500000000e+15, 2, "135712646423233475", 16},
  {4.0952247074327712059020996e+09, 15, "40952247074327712059021", 10},
  {1.1321013939278045654646121e+04, 20, "1132101393927804565464612", 5},
  {2.6680404333662236672000000e+19, 12, "26680404333662236672", 20},
  {9.2251200334403568000000000e+16, 14, "92251200334403568", 17},
  {5.2176045563209797057078592e-08, 20, "5217604556321", -7},
  {4.5467597780601929617950633e-20, 19, "", -19},
  {6.1031982173707997451489460e-06, 5, "1", -4},
  {5.0204003894879791829530568e-20, 18, "", -18},
  {3.4315621687408062500000000e+14, 0, "343156216874081", 15},
  {5.8053853781392076897800108e-22, 1, "", -1},
  {1.0146802946408838000000000e+16, 9, "10146802946408838", 17},
  {2.2657047400806085071100501e-09, 0, "", 0},
  {5.9605433410836025390625000e+12, 4, "59605433410836025", 13},
  {2.6599618698922321319580078e+10, 6, "26599618698922321", 11},
  {5.0288144971080765799342771e+02, 1, "5029", 3},
  {9.1750545016981239314191043e+04, 12, "91750545016981239", 5},
  {3.9556052798760589212179184e+06, 11, "395560527987605892", 7},
  {1.8172479719669887500000000e+14, 17, "181724797196698875", 15},
  {2.1826012565250780433416367e+07, 20, "2182601256525078043341636658", 8},
  {7.6761545161446719021114404e+01, 9, "76761545161", 2},
  {1.7085231559318236292227696e-16, 18, "171", -15},
  {3.4008040108243921164096489e-16, 10, "", -10},
  {8.1178909484928601614228683e+02, 4, "8117891", 3},
  {3.9694295638873345000000000e+15, 14, "39694295638873345", 16},
  {1.3790077895205907660800000e+20, 3, "137900778952059076608", 21},
  {5.2894696624814515727041738e-18, 13, "", -13},
  {1.6728920211741967018493581e-25, 17, "", -17},
  {4.0210507458092548252887379e-21, 20, "", -20},
  {4.4905182711984482421875000e+12, 15, "44905182711984482421875", 13},
  {4.3399031067738775000000000e+15, 2, "43399031067738775", 16},
  {3.7767504601066813386018621e-13, 5, "", -5},
  {3.0548380646017034619310191e-24, 20, "", -20},
  {9.1492310829010806217379242e-19, 9, "", -9},
  {1.1481802179498364005720146e-10, 13, "1148", -9},
  {2.1130206389444414526224136e+04, 5, "2113020639", 5},
  {2.5856485853534880159365628e-02, 3, "26", -1},
  {4.3356781647056775166492239e-13, 18, "433568", -12},
  {2.5484612406293322906390552e-24, 1, "", -1},
  {7.7263934223509649746119976e+05, 12, "772639342235096497", 6},
  {7.6779383404117578125000000e+12, 12, "76779383404117578125", 13},
  {1.6972152973020120212029049e-04, 9, "169722", -3},
  {2.1862255743444440018650102e-14, 17, "2186", -13},
  {8.6125281678881835937500000e+08, 7, "8612528167888184", 9},
  {1.2804083672823746837821091e+03, 18, "1280408367282374683782", 4},
  {1.6189343012928721695973988e-09, 11, "162", -8},
  {1.5156676258389770950429920e+01, 0, "15", 2},
  {2.4722815706014579534530640e+08, 16, "2472281570601457953453064", 9},
  {1.8431235931994777600000000e+17, 17, "184312359319947776", 18},
  {2.2227786088145094306353738e-14, 18, "22228", -13},
  {2.4879780665685720741748810e+06, 9, "2487978066568572", 7},
  {2.7354477947915621551202636e-20, 10, "", -10},
  {9.8988794615219627435263587e-13, 2, "", -2},
  {3.2082436402536836095311656e-02, 5, "3208", -1},
  {8.4625116516740922112692130e-08, 19, "846251165167", -7},
  {4.6993871631124711269909475e-07, 17, "46993871631", -6},
  {6.9694826882647916052600662e-23, 20, "", -20},
  {2.8811250473938211840000000e+18, 9, "2881125047393821184", 19},
  {5.3120247139799683027761371e-06, 20, "531202471397997", -5},
  {1.4497136880936090000000000e+15, 1, "1449713688093609", 16},
  {3.2240010987684987485408783e+07, 2, "3224001099", 8},
  {2.8585189420859713832317553e-22, 19, "", -19},
  {7.1575305182038523904000000e+20, 14, "71575305182038523904", 21},
  {9.8521113911944080000000000e+15, 19, "9852111391194408", 16},
  {3.2221400116850520909006147e-25, 10, "", -10},
  {7.3971132397169885291238201e-04, 17, "7397113239717", -3},
  {6.2081819085173511996416239e-15, 15, "6", -14},
  {2.4498133225514660644531250e+11, 1, "2449813322551", 12},
  {1.5465552334748575943945746e-07, 0, "", 0},
  {7.2047326548236981125228340e+01, 15, "72047326548236981", 2},
  {1.8341182361520758092865435e-01, 4, "1834", 0},
  {4.7247557199058911182899154e-21, 0, "", 0},
  {2.2149858333800209948094562e+04, 6, "22149858334", 5},
  {1.6946141460051052856445312e+11, 0, "169461414601", 12},
  {1.6659350007257408000000000e+18, 7, "16659350007257408", 19},
  {2.2583497883557445526123047e+10, 14, "2258349788355744552612305", 11},
  {5.0610937026404941656065373e-14, 4, "", -4},
  {7.5049194264186653984366724e-17, 15, "", -15},
  {1.5623438706714367582554809e-12, 18, "1562344", -11},
  {1.2355111858186502144000000e+20, 9, "12355111858186502144", 21},
  {9.2914702552004164317622781e+03, 16, "92914702552004164318", 4},
  {1.4131934709183464670258959e-15, 20, "141319", -14},
  {4.2861101113227564070821913e-23, 20, "", -20},
  {1.5893993854711989640636626e-13, 14, "16", -12},
  {3.0978783714898247581004398e+02, 16, "3097878371489824758", 3},
  {1.8651314154009547084569931e+07, 5, "1865131415401", 8},
  {1.3708898159187079869875967e-25, 19, "", -19},
  {1.3463837448412304179200000e+20, 2, "134638374484123041792", 21},
  {4.3267036545076933774007685e-14, 19, "43267", -13},
  {1.4588831794107787067173482e-09, 8, "", -8},
  {1.4053738570512001065010274e-13, 11, "", -11},
  {7.3951213619394913315773010e+07, 12, "73951213619394913316", 8},
  {1.2399160688141358190825613e-23, 1, "", -1},
  {8.2011339767168864000000000e+16, 14, "82011339767168864", 17},
  {5.0565221455952512556680605e-08, 15, "50565221", -7},
  {2.6064526030966234207153320e+08, 12, "260645260309662342072", 9},
  {1.5861002784568461300140411e-19, 1, "", -1},
  {3.4445701221703104191905900e-23, 16, "", -16},
  {7.6292895899271364762268744e-24, 12, "", -12},
  {4.0584063550092368125915527e+09, 19, "40584063550092368125915527344", 10},
  {1.5058029258945768205048743e-08, 19, "150580292589", -7},
  {1.5002664965497828790984577e-09, 6, "", -6},
  {3.6000938986310366334729882e-24, 11, "", -11},
  {1.8562169318681933593750000e+12, 19, "1856216931868193359375", 13},
  {5.8204416539871335345424086e+00, 2, "582", 1},
  {5.5837962503114408469289537e-05, 3, "", -3},
  {1.3484149276951041465175231e-17, 19, "135", -16},
  {7.5905634608290134421521594e-10, 11, "76", -9},
  {8.2115012508323703688262185e-02, 2, "8", -1},
  {3.6172911044390493164062500e+12, 4, "36172911044390493", 13},
  {8.3432845995628376007080078e+09, 12, "8343284599562837600708", 10},
  {8.7123273668141075619959222e-14, 16, "871", -13},
  {3.2841854707527136051200000e+20, 8, "328418547075271360512", 21},
  {3.1040966282394979458558737e+01, 20, "3104096628239497945856", 2},
  {4.6794971471508117100657707e-21, 10, "", -10},
  {6.5275693418234199683070074e+00, 2, "653", 1},
  {3.5109736464111561655643018e-21, 3, "", -3},
  {1.1887644131422156993656931e-06, 19, "11887644131422", -5},
  {1.8260360060955943696639454e-18, 20, "183", -17},
  {2.1098578979020401000976562e+10, 16, "210985789790204010009765625", 11},
  {1.1667814529616634368896484e+10, 19, "11667814529616634368896484375", 11},
  {1.1660957693555084492800000e+20, 12, "116609576935550844928", 21},
  {1.1580358604981756329155296e-02, 20, "1158035860498175633", -1},
  {1.3768753333524664972614637e-14, 17, "1377", -13},
  {2.3237678937754100379918438e-10, 2, "", -2},
  {1.1430495867457747549440078e-04, 2, "", -2},
  {4.5445007841559856524587935e-14, 16, "454", -13},
  {1.8867420763888183981180191e+07, 17, "1886742076388818398118019", 8},
  {5.8256212147307642064899433e-12, 15, "5826", -11},
  {3.3209481411326322725097171e-03, 7, "33209", -2},
  {1.3411728218239231088040886e-04, 11, "13411728", -3},
  {1.1252816354064987890826693e-22, 12, "", -12},
  {2.5031440087523207664489746e+09, 14, "250314400875232076644897", 10},
  {2.2423442811180644413341255e-17, 17, "2", -16},
  {6.7744605427369097014889121e+04, 12, "67744605427369097", 5},
  {1.4541617259381134063005447e+07, 9, "14541617259381134", 8},
  {7.4259214528644250000000000e+14, 12, "7425921452864425", 15},
  {2.4650027026384735107421875e+10, 20, "24650027026384735107421875", 11},
  {2.7754910089130517121630769e-24, 8, "", -8},
  {3.2154404913268507559381780e-21, 18, "", -18},
  {2.5466117667065012922696232e-18, 6, "", -6},
  {1.0539738664236312807905967e-12, 1, "", -1},
  {1.3202688956196427500000000e+15, 13, "132026889561964275", 16},
  {4.6020160508405447006225586e+07, 12, "46020160508405447006", 8},
  {4.1256463279729537378474509e-21, 6, "", -6},
  {5.7145803362971748046875000e+12, 2, "571458033629717", 13},
  {1.2478999917958510650350945e+03, 5, "124789999", 4},
  {4.5801638760356488955238774e-01, 11, "4580163876", 0},
  {1.7252786493401257757795975e+04, 4, "172527865", 5},
  {2.9421189111348912500000000e+14, 5, "294211891113489125", 15},
  {1.5489753611292413475784128e-19, 8, "", -8},
  {1.7669725248518696068080110e-15, 17, "177", -14},
  {9.3770958607223560000000000e+15, 19, "9377095860722356", 16},
  {5.0629162048180121764991276e-11, 0, "", 0},
  {7.0882353713256808448000000e+19, 20, "70882353713256808448", 20},
  {1.1129642190308620000000000e+16, 15, "1112964219030862", 17},
  {2.4701823942915361346666813e-18, 12, "", -12},
  {4.4151889269586659239583466e-13, 12, "", -12},
  {4.9241809745071688908800000e+20, 7, "492418097450716889088", 21},
  {2.0149971563397567749023438e+10, 4, "201499715633976", 11},
  {1.2977830986266149641589381e-05, 10, "129778", -4},
  {3.2414303624120325366675388e+03, 10, "3241430362412", 4},
  {1.5201243304326365184000000e+19, 8, "15201243304326365184", 20},
  {1.9627143858242453542290184e-22, 15, "", -15},
  {1.5175679079454915625000000e+14, 6, "15175679079454915625", 15},
  {4.7969847248586653165602911e+01, 17, "4796984724858665317", 2},
  {4.2018291956651856471709049e-19, 20, "42", -18},
  {1.8044972506398669793270528e+04, 20, "1804497250639866979327053", 5},
  {2.7998783018441758940753061e+03, 13, "27998783018441759", 4},
  {8.1782269821009567749570124e+03, 1, "81782", 4},
  {2.8788900770684440612792969e+10, 16, "287889007706844406127929688", 11},
  {1.8546156811886602749021785e-11, 18, "18546157", -10},
  {5.2748742391171366912000000e+19, 13, "52748742391171366912", 20},
  {7.7684180504218887500000000e+14, 11, "776841805042188875", 15},
  {2.0550846286615911950867996e-01, 11, "20550846287", 0},
  {1.1476220592651372536262742e-25, 13, "", -13},
  {1.0111156710139689019183756e-04, 5, "1", -3},
  {7.2218617165737242286907964e-12, 5, "", -5},
  {5.2848223472638834345488021e-06, 9, "5285", -5},
  {6.1117388285735441968427040e+03, 1, "61117", 4},
  {1.5252978355923087292467244e+03, 6, "1525297836", 4},
  {5.7397677419635055031874038e-05, 8, "574", -4},
  {2.0089361463929114766380213e-03, 8, "200894", -2},
  {1.1306022644173129506784605e-20, 2, "", -2},
  {8.3466392522993351230676479e-21, 2, "", -2},
  {1.5585266220377118437980594e-22, 17, "", -17},
  {1.3224631291378210880793631e+05, 16, "1322463129137821088079", 6},
  {8.2120796103509990400000000e+17, 15, "821207961035099904", 18},
  {1.3191894551266504658621545e-22, 6, "", -6},
  {1.4701383650624342604954266e-18, 5, "", -5},
  {5.9693303104385231545349344e-05, 13, "596933031", -4},
  {6.4861264243900109863281250e+11, 13, "6486126424390010986328125", 12},
  {2.6502783643434088954485110e-06, 15, "2650278364", -5},
  {4.5453735777841831845274424e-25, 17, "", -17},
  {1.9682863716424358700612608e-18, 0, "", 0},
  {2.0328586431753973941858892e-18, 0, "", 0},
  {1.2431362629463807679712772e+06, 13, "1243136262946380768", 7},
  {5.7620785363421360695712483e-11, 0, "", 0},
  {1.1878123810340046472574818e-18, 14, "", -14},
  {3.8221182093266117972371373e-23, 18, "", -18},
  {9.6126653506605080000000000e+15, 6, "9612665350660508", 16},
  {1.9869652994970042527711485e+03, 15, "1986965299497004253", 4},
  {7.5914243429589760000000000e+16, 14, "7591424342958976", 17},
  {9.7630589785557948757834662e-07, 5, "", -5},
  {2.2863857316619536123674916e-24, 19, "", -19},
  {3.0351987642281644800000000e+17, 7, "303519876422816448", 18},
  {7.1064048686198489088000000e+20, 0, "71064048686198489088", 21},
  {1.6606301577813076972961426e+08, 7, "1660630157781308", 9},
  {1.9987576674100438397085657e-24, 2, "", -2},
  {7.1403138849938129035944624e-12, 5, "", -5},
  {6.6252474810430157037231016e-17, 10, "", -10},
  {1.5322803713269876736281859e-21, 4, "", -4},
  {1.0190960017812086412879003e-09, 6, "", -6},
  {1.2771528373039988346333698e-10, 11, "13", -9},
  {9.0903645279008924262598157e+02, 8, "90903645279", 3},
  {1.6688991555796336640000000e+18, 12, "1668899155579633664", 19},
  {2.6180613674801134106025535e-12, 7, "", -7},
  {3.6134626735002872699453746e+00, 10, "36134626735", 1},
  {1.3463812744911098917555137e+01, 10, "134638127449", 2},
  {1.2706473268842393875122070e+10, 14, "1270647326884239387512207", 11},
  {3.2957808096063246239282307e+02, 10, "3295780809606", 3},
  {5.9190798368112369776117276e-02, 13, "591907983681", -1},
  {1.0448838452938567280837972e-19, 0, "", 0},
  {1.3397279713312094728111088e-14, 18, "13397", -13},
  {5.0278133424822965916303172e-19, 9, "", -9},
  {2.4323470692432528734207153e+08, 3, "243234706924", 9},
  {1.4811260499558281153440475e+06, 14, "148112604995582811534", 7},
  {6.7022453299449558095091106e-03, 8, "670225", -2},
  {5.2134358838513195864872998e-08, 13, "521344", -7},
  {8.1178026430110873600000000e+18, 10, "811780264301108736", 19},
  {2.2286964846578469872474670e+08, 4, "2228696484658", 9},
  {2.5831358348027017712593079e+08, 16, "2583135834802701771259308", 9},
  {9.0449318775799231184819860e-02, 7, "904493", -1},
  {2.8762324665946955000000000e+15, 18, "28762324665946955", 16},
  {2.3204094082079283909441491e-15, 1, "", -1},
  {1.0140215365649766044505530e-24, 18, "", -18},
  {3.7940814923011930000000000e+15, 18, "3794081492301193", 16},
  {4.3701684799198842773437500e+12, 14, "437016847991988427734375", 13},
  {1.2862799350545659866108922e-21, 13, "", -13},
  {4.8688859712968874174365830e-03, 19, "48688859712968874", -2},
  {2.2217289960727619302360836e+01, 13, "222172899607276", 2},
  {9.3755984346080172061920166e+08, 12, "937559843460801720619", 9},
  {3.0432040212689995000000000e+15, 8, "30432040212689995", 16},
  {7.2543553410936950683593750e+10, 0, "72543553411", 11},
  {5.1225789806231250622658990e+02, 2, "51226", 3},
  {2.1606106997406089175080279e-05, 12, "21606107", -4},
  {4.7129218069883041742138357e-19, 0, "", 0},
  {8.0193571275269982910156250e+11, 1, "8019357127527", 12},
  {2.8868001707991932577205120e-25, 5, "", -5},
  {2.7835353229700886400000000e+17, 0, "278353532297008864", 18},
  {4.0635591516955108346590792e-15, 7, "", -7},
  {2.9649843047027980846852557e-02, 1, "", -1},
  {2.2192659540250697690691450e-04, 5, "22", -3},
  {1.5568138248676663151570781e-16, 5, "", -5},
  {1.0897373573808406490570633e+03, 17, "108973735738084064906", 4},
  {1.5542964902611972656250000e+12, 0, "1554296490261", 13},
  {6.0246923563500119080987097e-11, 7, "", -7},
  {5.5825891217870310000000000e+15, 5, "5582589121787031", 16},
  {5.6376976831820350433692169e-15, 18, "5638", -14},
  {1.2526160771277307128906250e+12, 6, "1252616077127730713", 13},
  {1.8317483395818977911773509e-10, 9, "", -9},
  {1.5439387713699197769165039e+08, 5, "15439387713699", 9},
  {2.6654008585404179757460952e+05, 10, "2665400858540418", 6},
  {3.0181245873441092000000000e+16, 0, "30181245873441092", 17},
  {1.5754626807738537604478002e-04, 2, "", -2},
  {2.2606309792797438226227937e-13, 5, "", -5},
  {9.2286907047304435200000000e+17, 17, "922869070473044352", 18},
  {8.2244515245857069783011627e-19, 17, "", -17},
  {4.7834482908015382760466813e-24, 5, "", -5},
  {5.2341959348620605468750000e+10, 13, "5234195934862060546875", 11},
  {2.1928670060905756160000000e+18, 7, "2192867006090575616", 19},
  {1.1450679116053910268028286e-16, 4, "", -4},
  {1.6482326014904797193594277e+05, 7, "164823260149", 6},
  {4.0114055627349433374001159e-25, 16, "", -16},
  {5.2923630463758183484016021e-20, 19, "1", -18},
  {2.3204443748620754876333186e-05, 20, "2320444374862075", -4},
  {1.4004422283244090671618707e-18, 4, "", -4},
  {4.9919710325690448371460661e+03, 14, "499197103256904484", 4},
  {1.6238830746488785621899706e-23, 4, "", -4},
  {2.4590871695049682535373289e-06, 10, "24591", -5},
  {2.1472645892629921036132146e+03, 9, "2147264589263", 4},
  {4.7600850337500745660308970e-12, 10, "", -10},
  {6.0329194097310971812270591e-21, 6, "", -6},
  {3.2741768513686200320000000e+19, 12, "3274176851368620032", 20},
  {4.2653865656980884480000000e+18, 17, "4265386565698088448", 19},
  {2.2699375902441441059103433e-13, 13, "2", -12},
  {2.0287118367451817330937797e-17, 0, "", 0},
  {2.0528908377606823191070267e-08, 11, "2053", -7},
  {3.2478909645444306759920483e-03, 4, "32", -2},
  {1.6851171263967803655753701e-19, 3, "", -3},
  {8.7574052004030408329865483e-09, 13, "87574", -8},
  {1.2835216638355732812500000e+14, 6, "128352166383557328125", 15},
  {2.5432124748400128125000000e+14, 1, "2543212474840013", 15},
  {1.0700779755040223232000000e+19, 6, "10700779755040223232", 20},
  {2.6373536349714377990949288e+01, 4, "263735", 2},
  {4.5306383361802722167968750e+11, 14, "4530638336180272216796875", 12},
  {1.6274830232306085205078125e+11, 14, "16274830232306085205078125", 12},
  {2.1707550586760305919218535e-20, 17, "", -17},
  {3.0762824064282352640000000e+18, 8, "3076282406428235264", 19},
  {3.9895994546731050401507829e-25, 13, "", -13},
  {1.3754485711743385723253593e-14, 4, "", -4},
  {1.0876022424979727654281199e-08, 6, "", -6},
  {2.4789976612103779123200000e+20, 14, "247899766121037791232", 21},
  {6.8921794664726769551634789e+06, 4, "68921794665", 7},
  {1.1671557551632228689401204e-11, 12, "12", -10},
  {5.8391222009434707462787628e+07, 15, "58391222009434707462788", 8},
  {4.0621559391018065871088740e-15, 1, "", -1},
  {1.0025169717152894148871822e-22, 8, "", -8},
  {9.6882898788633442358798897e-06, 16, "96882898789", -5},
  {2.1504687222812228931251299e-05, 4, "", -4},
  {5.0947787932998791503906250e+11, 7, "509477879329987915", 12},
  {1.7809083537902451200000000e+17, 11, "178090835379024512", 18},
  {8.4117417017616378826009010e-07, 19, "8411741701762", -6},
  {3.7888265054634260309285310e+01, 3, "37888", 2},
  {3.2410273750704268139882780e-04, 6, "324", -3},
  {2.0322022213667645473833545e+02, 14, "20322022213667645", 3},
  {4.7976800222327278295400442e-11, 17, "479768", -10},
  {9.0937453979062236746205892e-21, 15, "", -15},
  {4.8943349108708776555592837e-08, 10, "489", -7},
  {1.9063585622644642717204988e+05, 7, "1906358562264", 6},
  {4.1206078415617632000000000e+17, 2, "41206078415617632", 18},
  {2.3860193375701582031250000e+12, 2, "238601933757016", 13},
  {6.6874674474240013849479780e-03, 14, "668746744742", -2},
  {2.7020483607869075555128099e-20, 12, "", -12},
  {4.6379523853954720197801874e-21, 1, "", -1},
  {2.6280186823712321589247535e-15, 20, "262802", -14},
  {6.9454982853325322270393372e+07, 3, "69454982853", 8},
  {9.6037723463870066288561726e-14, 2, "", -2},
  {1.2028959002629957442938129e-07, 7, "1", -6},
  {1.6046354397158226562500000e+13, 4, "160463543971582266", 14},
  {1.6865767925960630236659199e+04, 1, "168658", 5},
  {2.7908434564664224154665946e-10, 14, "27908", -9},
  {1.0941842744916466682375060e-22, 5, "", -5},
  {6.1314654757463787767486604e-12, 18, "6131465", -11},
  {1.7192511049368243408203125e+11, 8, "17192511049368243408", 12},
  {8.8728320022774782361600000e+20, 13, "887283200227747823616", 21},
  {2.0431036152588687769600000e+20, 8, "204310361525886877696", 21},
  {1.0968334739587581716477871e+06, 7, "10968334739588", 7},
  {4.1663866754884875605965274e-21, 3, "", -3},
  {4.3890453942315012682229280e+05, 8, "43890453942315", 6},
  {5.5312490244901047389933409e-06, 0, "", 0},
  {6.1904490234501333300221222e-06, 0, "", 0},
  {1.0603883365820800099843524e-01, 10, "1060388337", 0},
  {3.6507044094844028320312500e+12, 10, "36507044094844028320313", 13},
  {5.6330255982655411914100656e-21, 15, "", -15},
  {4.9466572758188567604520358e+02, 1, "4947", 3},
  {3.1679710011185139592271298e+04, 20, "316797100111851395922713", 5},
  {1.3061806234862112175382959e-09, 7, "", -7},
  {1.8572069149018844603997382e-14, 18, "18572", -13},
  {3.6337470947096325457096100e+07, 11, "3633747094709632546", 8},
  {4.4692347102147302400000000e+17, 18, "446923471021473024", 18},
  {1.5133205018241384997963905e+07, 11, "15133205018241385", 8},
  {4.1635313314815129600000000e+18, 0, "416353133148151296", 19},
  {7.2576586953592498779296875e+10, 3, "72576586953592", 11},
  {5.9037540910907112121582031e+10, 7, "590375409109071121", 11},
  {2.4869483140285091679489902e-10, 16, "2486948", -9},
  {7.9522761354527474186859592e-03, 20, "795227613545274742", -2},
  {6.0485299130201033435128011e+00, 12, "604852991302", 1},
  {2.1727204784657206552658421e-16, 14, "", -14},
  {1.0237246393871287074334578e-14, 8, "", -8},
  {1.0434863065861135387131485e-10, 16, "1043486", -9},
  {6.8962576764626476562500000e+13, 13, "689625767646264765625", 14},
  {3.9396744492419498388259793e-14, 17, "394", -13},
  {1.6846428997601897842992164e-21, 19, "", -19},
  {6.4822346222278207833914678e-22, 20, "", -20},
  {3.0609438543373418687764409e-17, 13, "", -13},
  {3.7053448802368002929687500e+12, 2, "37053448802368", 13},
  {7.0447935346109620820570668e-23, 16, "", -16},
  {1.9157809982792808889406899e-01, 7, "1915781", 0},
  {1.7404841537247332532173362e-13, 5, "", -5},
  {2.6771339563344469274312306e-22, 10, "", -10},
  {2.2107721812723375487451730e-05, 17, "2210772181272", -4},
  {7.9794477976478233078331291e-14, 18, "79794", -13},
  {2.7565824214809197187423706e+08, 6, "275658242148092", 9},
  {3.5316340602941789062500000e+13, 0, "35316340602942", 14},
  {6.1139797099408850000000000e+15, 11, "6113979709940885", 16},
  {9.1835861414114981471357169e+02, 0, "918", 3},
  {1.3804182236441448253759512e-04, 14, "13804182236", -3},
  {1.1449752619577033817768097e+08, 5, "11449752619577", 9},
  {2.0405448911613965034484863e+09, 15, "2040544891161396503448486", 10},
  {3.9925758848933873326405655e-23, 15, "", -15},
  {1.3841932428672634181054946e+00, 18, "1384193242867263418", 1},
  {2.7905067053808828998627729e-08, 2, "", -2},
  {1.6140259347220751282402768e-07, 9, "161", -6},
  {7.0108153078663362848137440e-23, 13, "", -13},
  {7.3589528839592390293969718e-06, 8, "736", -5},
  {1.5722219293836167253175518e+02, 20, "15722219293836167253176", 3},
  {4.6341173982824300800000000e+17, 6, "463411739828243008", 18},
  {5.3382142015034748355598905e-06, 14, "53382142", -5},
  {3.4838772700488134441531374e-12, 2, "", -2},
  {3.5721988510578467249097321e-08, 18, "35721988511", -7},
  {4.5416697346269461461623583e-10, 4, "", -4},
  {1.7996991368832950272000000e+19, 6, "17996991368832950272", 20},
  {2.7238556519031262412800000e+20, 12, "272385565190312624128", 21},
  {3.0697950803040515245010592e-10, 2, "", -2},
  {4.1028619490138415104000000e+19, 0, "41028619490138415104", 20},
  {2.8797165358574038085404112e-02, 18, "28797165358574038", -1},
  {6.8287041984488560000000000e+16, 0, "6828704198448856", 17},
  {1.5158695586813653033431137e-01, 18, "15158695586813653", 0},
  {8.4040146529676217707017973e-07, 2, "", -2},
  {2.0339865816000160156250000e+13, 13, "2033986581600016015625", 14},
  {1.2148319735291745000000000e+15, 5, "12148319735291745", 16},
  {1.3103253787446894400000000e+17, 7, "131032537874468944", 18},
  {7.8330158969292002761089584e-11, 3, "", -3},
  {2.2102906515581071289489046e+02, 18, "221029065155810712895", 3},
  {1.5288453807259051848758067e-18, 9, "", -9},
  {5.3099259617803980404460162e+01, 20, "5309925961780398040446", 2},
  {1.1903383445912244360338697e-22, 6, "", -6},
  {6.9853135842183874560000000e+18, 18, "6985313584218387456", 19},
  {1.4384410280155304018213522e-21, 19, "", -19},
  {3.7267528611814722903266751e-23, 0, "", 0},
  {1.3137675453406680246425578e-21, 19, "", -19},
  {1.1959197977433566901909502e-05, 0, "", 0},
  {1.5754768173685007880499021e-19, 14, "", -14},
  {2.6336880865849067118886934e-15, 7, "", -7},
  {4.9647862721933499469161798e-10, 1, "", -1},
  {5.3814978317868652800000000e+17, 18, "538149783178686528", 18},
  {1.2838970959868205711245537e+07, 11, "1283897095986820571", 8},
  {4.7030922068841984895470887e-01, 7, "4703092", 0},
  {2.5983826457914163208007812e+11, 5, "25983826457914163", 12},
  {4.6983599757544865133240819e+05, 17, "46983599757544865133241", 6},
  {7.2531483017396773000099471e-22, 6, "", -6},
  {1.2486427204583140648797013e-01, 7, "1248643", 0},
  {6.6081139655013041780847430e-18, 16, "", -16},
  {7.5725464462868890762329102e+09, 15, "757254644628688907623291", 10},
  {5.2471385425361674278974533e+06, 4, "52471385425", 7},
  {8.9279783482271373721600000e+20, 6, "892797834822713737216", 21},
  {6.5202671565357302156171736e-15, 14, "1", -13},
  {2.4902489742565841951589600e-24, 0, "", 0},
  {9.4486909508658989409468631e+00, 15, "9448690950865899", 1},
  {1.9023685691549786897608307e-25, 9, "", -9},
  {4.8051084433816931840155462e-01, 13, "4805108443382", 0},
  {2.8118096636977427814250377e-18, 13, "", -13},
  {4.0728416486804185581149795e+01, 12, "40728416486804", 2},
  {5.0715803929181655040000000e+18, 10, "5071580392918165504", 19},
  {2.2746630464341101696114687e-25, 1, "", -1},
  {1.1955176879085503693911363e-01, 20, "11955176879085503694", 0},
  {1.9749184650762079436800000e+20, 20, "197491846507620794368", 21},
  {3.6579101886172858569413245e-13, 8, "", -8},
  {6.4737094192026342773437500e+11, 16, "647370941920263427734375", 12},
  {1.2099926094531800259321968e-23, 4, "", -4},
  {3.6251662513048472718472232e-06, 5, "", -5},
  {1.2999719585244573677703078e-22, 16, "", -16},
  {8.8183377829866516073309413e-01, 8, "88183378", 0},
  {2.4893675223100676895144733e-22, 19, "", -19},
  {4.4853209006202335000000000e+15, 3, "44853209006202335", 16},
  {1.5833313875334262266214580e-01, 11, "15833313875", 0},
  {1.5946728799225632320512745e-06, 18, "1594672879923", -5},
  {9.6265489938868438720703125e+10, 9, "96265489938868438721", 11},
  {3.8147763326102475112122647e+00, 2, "381", 1},
  {2.6061000551624824428387228e-01, 14, "26061000551625", 0},
  {6.4580357634290706414503802e+01, 12, "64580357634291", 2},
  {1.3861506469935881221331415e-22, 0, "", 0},
  {1.1644589643966410711042016e-08, 10, "116", -7},
  {1.2903754865375978737271980e-17, 6, "", -6},
  {1.0906141888800407286908012e+03, 12, "1090614188880041", 4},
  {3.0368802249872914771742127e-07, 19, "3036880224987", -6},
  {1.2434117128434615613363278e-21, 1, "", -1},
  {4.0950583417193019028865855e-10, 19, "4095058342", -9},
  {9.9539982738536441075893890e+00, 2, "995", 1},
  {2.7059150500835484136038026e-05, 20, "2705915050083548", -4},
  {2.6677014420101815462112427e+08, 10, "2667701442010181546", 9},
  {5.4154060107587594910639251e-11, 3, "", -3},
  {2.0603142045400350216427521e-06, 16, "20603142045", -5},
  {1.8445653858933726720000000e+18, 11, "1844565385893372672", 19},
  {2.4758584513413080054234336e-11, 20, "2475858451", -10},
  {5.6471603931284008960000000e+18, 18, "5647160393128400896", 19},
  {3.3175466865669857532410319e-16, 6, "", -6},
  {8.0899901588666884765625000e+12, 0, "8089990158867", 13},
  {3.3260299119674854400000000e+17, 12, "332602991196748544", 18},
  {8.3870995540110826492309570e+07, 16, "838709955401108264923096", 8},
  {7.2130005164670741558074951e+08, 19, "7213000516467074155807495117", 9},
  {3.7934152152734986768601710e-07, 3, "", -3},
  {1.5639176332433035093224744e-16, 8, "", -8},
  {1.2045363369776205000000000e+15, 7, "12045363369776205", 16},
  {5.1595844845492199707031250e+11, 14, "5159584484549219970703125", 12},
  {1.6278455908345638991630011e-02, 4, "163", -1},
  {1.5331394578947611153125763e+06, 16, "15331394578947611153126", 7},
  {2.6068964199325101227508786e-07, 3, "", -3},
  {2.9462577133349590003490448e+07, 16, "294625771333495900034904", 8},
  {7.8794531590174045413732529e+05, 19, "7879453159017404541373253", 6},
  {5.2163935606568760115200000e+20, 13, "521639356065687601152", 21},
  {1.6296621919771284864048716e-05, 1, "", -1},
  {5.4056196314829868057124207e-19, 20, "54", -18},
  {1.6120778464083129057747950e-24, 20, "", -20},
  {6.4376017907338319119731170e-20, 5, "", -5},
  {5.1988249256710121408104897e+06, 12, "5198824925671012141", 7},
  {2.8803064816205014648437500e+12, 3, "2880306481620501", 13},
  {3.2481924380521216392517090e+09, 5, "324819243805212", 10},
  {4.0902757796789655961600000e+20, 19, "409027577967896559616", 21},
  {1.6235182981149545600000000e+17, 7, "162351829811495456", 18},
  {1.4327896557945440292358398e+10, 3, "14327896557945", 11},
  {4.6210891259806714445353539e-08, 13, "462109", -7},
  {9.9008072552406867363942409e-16, 15, "1", -14},
  {6.2637263512113565689092432e-07, 9, "626", -6},
  {4.9221543831516572488237557e-22, 20, "", -20},
  {5.7241437246415167864006313e-19, 17, "", -17},
  {2.5530536379820448443872287e-13, 12, "", -12},
  {6.9344918189535961995177819e-12, 9, "", -9},
  {1.9012148465170095214843750e+12, 16, "1901214846517009521484375", 13},
  {3.0506402380246171986886492e-22, 17, "", -17},
  {1.1084335737723253259900957e+05, 6, "110843357377", 6},
  {2.5931237870460019194398336e-22, 11, "", -11},
  {5.4261105734927733982700557e-24, 14, "", -14},
  {1.1508148499715542129706591e+04, 14, "1150814849971554213", 5},
  {5.9560112154890558543867735e-20, 10, "", -10},
  {9.8583376324833834171295166e+08, 4, "9858337632483", 9},
  {9.1633474274607897285926177e-17, 7, "", -7},
  {1.0184130814512689208984375e+12, 19, "10184130814512689208984375", 13},
  {6.6183299047052933952710456e-20, 8, "", -8},
  {7.3976628368414898417881886e+00, 14, "739766283684149", 1},
  {7.6174870810151730158065940e-13, 11, "", -11},
  {2.7561812918164851562500000e+13, 10, "275618129181648515625", 14},
  {2.3173909991284069289401012e-10, 10, "2", -9},
  {2.7823401377757957717964046e-14, 9, "", -9},
  {6.9040595642952847480773926e+08, 18, "690405956429528474807739258", 9},
  {2.3511852108991001732647419e+06, 13, "23511852108991001733", 7},
  {9.3965980952616900000000000e+14, 20, "939659809526169", 15},
  {2.1815664314587616920471191e+08, 4, "2181566431459", 9},
  {3.4580456075086036488682354e-12, 19, "34580456", -11},
  {1.6195588229786828196151764e-09, 9, "2", -8},
  {7.9100512210599920000000000e+16, 14, "7910051221059992", 17},
  {1.4091878867623800747680931e-11, 6, "", -6},
  {1.3415891664843865717197946e-04, 2, "", -2},
  {2.2851669803557589983812390e-14, 11, "", -11},
  {3.1935616465242761373519897e+08, 0, "319356165", 9},
  {1.9389344383337972685694695e+06, 5, "193893443833", 7},
  {2.6108089760310919373869046e-20, 1, "", -1},
  {2.0895596517169550061225891e+06, 17, "208955965171695500612259", 7},
  {3.2018402388373947143554688e+08, 16, "3201840238837394714355469", 9},
  {3.1988120202883812500000000e+14, 2, "31988120202883813", 15},
  {2.3969216419091925621032715e+09, 6, "2396921641909193", 10},
  {3.9020867377113064917720049e-25, 4, "", -4},
  {2.6304212956807966422313761e-16, 15, "", -15},
  {1.0322267446680752708166536e-23, 10, "", -10},
  {1.1515337016211638857671185e-03, 15, "1151533701621", -2},
  {8.8141808740406168976022627e-01, 9, "881418087", 0},
  {2.2090959427102225000000000e+15, 16, "22090959427102225", 16},
  {3.9204168805988799250484563e-21, 4, "", -4},
  {3.8327581739723786158999073e-13, 2, "", -2},
  {8.4930752830468718592000000e+19, 18, "84930752830468718592", 20},
  {4.8780903815021733229069070e-09, 2, "", -2},
  {4.2579873190386479005209441e-04, 2, "", -2},
  {2.6485637881121992704000000e+19, 14, "26485637881121992704", 20},
  {3.2294407620187586924310229e-15, 8, "", -8},
  {1.8009733133036920405906520e-23, 13, "", -13},
  {1.4046759409096215695175736e-04, 16, "140467594091", -3},
  {1.6767607558486684692413378e-25, 13, "", -13},
  {7.8893445523949673915933505e-19, 13, "", -13},
  {1.5229943791916570591256534e-18, 1, "", -1},
  {1.7116861629296222889788952e-20, 4, "", -4},
  {6.1095582098392327243919756e-09, 20, "610955820984", -8},
  {4.6620959687206030242767704e-21, 11, "", -11},
  {1.2892086658040876000000000e+16, 0, "12892086658040876", 17},
  {9.3974930818797906760373611e-16, 1, "", -1},
  {1.2458998645762385427951813e+08, 2, "12458998646", 9},
  {6.0499473437833978445906519e-05, 4, "1", -3},
  {1.1623739153887096405029297e+10, 18, "11623739153887096405029296875", 11},
  {4.1924553180875170000000000e+15, 3, "4192455318087517", 16},
  {8.7037043175683475184700772e-16, 8, "", -8},
  {3.4876628862911463236316910e-17, 11, "", -11},
  {1.4005221431454417705535889e+09, 8, "140052214314544177", 10},
  {1.2046956492724013671875000e+13, 12, "12046956492724013671875", 14},
  {3.2469770477902376380852120e-09, 0, "", 0},
  {1.3398581328250442187500000e+14, 12, "133985813282504421875", 15},
  {6.0115007220128514814082112e-13, 17, "60115", -12},
  {1.6378508601425128960000000e+18, 8, "1637850860142512896", 19},
  {2.8067322872887275480024982e+03, 5, "280673229", 4},
  {1.6257293088105232500000000e+15, 4, "162572930881052325", 16},
  {1.8743062743601397774791174e-08, 2, "", -2},
  {2.8656610366366689807045859e-24, 20, "", -20},
  {9.3157416019318264123479964e-20, 16, "", -16},
  {2.4176074575401865741843162e-06, 13, "24176075", -5},
  {6.9484199870669933618458981e-09, 6, "", -6},
  {5.5913787286331724430609171e-23, 0, "", 0},
  {7.9131253364009957546794066e-09, 15, "7913125", -8},
  {4.9755961117411353371122901e-24, 6, "", -6},
  {1.0350457135315094863640788e-05, 19, "103504571353151", -4},
  {8.6578974475012073526158929e+04, 10, "865789744750121", 5},
  {3.3792277479646759541509482e-01, 2, "34", 0},
  {1.4928521525074655936645958e-18, 12, "", -12},
  {1.1649349718926093033002575e-05, 9, "11649", -4},
  {3.0079565997909600062222568e-05, 3, "", -3},
  {1.6974602226144359352293429e-24, 16, "", -16},
  {7.9551392304170424704413142e-07, 9, "796", -6},
  {8.4583807236214951634595643e-10, 20, "84583807236", -9},
  {1.6371890574990162740096111e-09, 7, "", -7},
  {8.6385439864233148216099423e-03, 11, "863854399", -2},
  {4.0640542651025988161563873e+06, 12, "4064054265102598816", 7},
  {1.0043559694185742336000000e+20, 1, "10043559694185742336", 21},
  {1.2790032796018040625000000e+14, 7, "12790032796018040625", 15},
  {1.6307070738957868750000000e+14, 17, "1630707073895786875", 15},
  {2.3081429959357023063288099e-20, 12, "", -12},
  {1.1512343453992535371550800e-07, 2, "", -2},
  {2.0416476095221639192392460e-07, 0, "", 0},
  {6.0846250100664187590567419e-24, 3, "", -3},
  {9.7433500885687536197110603e+01, 4, "974335", 2},
  {3.8884719889600541549434798e-03, 0, "", 0},
  {7.0494116569786422488164135e+00, 0, "7", 1},
  {1.9840932227758296090003309e-03, 16, "19840932227758", -2},
  {7.2365328964018106045185405e-07, 20, "72365328964018", -6},
  {5.6674367315340946838400111e-21, 6, "", -6},
  {2.0676588019274060058593750e+12, 18, "2067658801927406005859375", 13},
  {1.7551476941679720766842365e+04, 2, "1755148", 5},
  {1.7406257641826785131206577e-06, 1, "", -1},
  {1.2777341430357475579500553e-22, 4, "", -4},
  {1.1249436874161008067875999e-22, 3, "", -3},
  {1.1781453255826151277007085e-23, 10, "", -10},
  {8.5948077096936438403747604e-16, 8, "", -8},
  {2.3933196753820830053882673e+04, 14, "2393319675382083005", 5},
  {3.5345886255758815232000000e+19, 19, "35345886255758815232", 20},
  {1.6993751744383075754625048e-13, 5, "", -5},
  {4.3711740513538383483886719e+10, 3, "43711740513538", 11},
  {1.4154807923121747968000000e+19, 7, "14154807923121747968", 20},
  {6.4428576133835263936048310e-14, 4, "", -4},
  {4.8086953299699512480402457e-09, 1, "", -1},
  {1.6613834497463101148605347e+08, 8, "16613834497463101", 9},
  {1.0800331181827673572115600e+05, 11, "10800331181827674", 6},
  {7.5137252861852743546222655e-01, 1, "8", 0},
  {6.8756412447746626526168257e+00, 8, "687564124", 1},
  {8.1137055679260627306204417e-19, 5, "", -5},
  {7.6565738508050469590671128e+02, 4, "7656574", 3},
  {3.9575066789818437283124402e-25, 19, "", -19},
  {8.5032037733877043471467737e-09, 4, "", -4},
  {3.5709321401727941139735363e-09, 13, "35709", -8},
  {7.0241900507179595889405534e-22, 14, "", -14},
  {6.0750369244337777053327875e-19, 8, "", -8},
  {1.4515960406633732951527923e-11, 12, "15", -10},
  {3.0513891778633830836042762e+05, 18, "305138917786338308360428", 6},
  {3.6215470489347698589260051e-12, 12, "4", -11},
  {1.4960397169751228764653206e+07, 3, "1496039717", 8},
  {4.6050460153274336000000000e+17, 3, "46050460153274336", 18},
  {2.5020021699398638254193799e-14, 8, "", -8},
  {1.9320614014245907706729157e-16, 0, "", 0},
  {3.0174523315169854884539334e-19, 18, "", -18},
  {7.8135760182382633004537799e-22, 17, "", -17},
  {5.5668817760604473600000000e+17, 14, "556688177606044736", 18},
  {1.6992597579338338226079941e+07, 0, "16992598", 8},
  {3.0832077883561404512990442e-16, 8, "", -8},
  {4.3603658581672869873046875e+11, 18, "43603658581672869873046875", 12},
  {4.8243300601546492710128408e-07, 3, "", -3},
  {3.9141117612311074055130156e-10, 12, "391", -9},
  {2.1281027483847438771198901e-25, 11, "", -11},
  {4.9106015998553223823195419e-25, 7, "", -7},
  {1.0091668168941142012375386e-20, 8, "", -8},
  {5.8326486730291763305664062e+10, 0, "5832648673", 11},
  {4.4499253219995261990804720e-06, 8, "445", -5},
  {3.7835682272114387142494872e-16, 11, "", -11},
  {6.8171865772149101303511998e+02, 4, "6817187", 3},
  {4.3390814014627920869315858e+02, 11, "43390814014628", 3},
  {6.0281669223554904815227343e-08, 10, "603", -7},
  {3.8238061589170282480921470e-12, 1, "", -1},
  {2.6797704333654656896186053e-10, 5, "", -5},
  {5.2325096400566689782946788e-18, 13, "", -13},
  {1.0238461376023703750000000e+15, 18, "1023846137602370375", 16},
  {6.0769506917027706062756568e-15, 12, "", -12},
  {1.3778803828526078526778346e-21, 8, "", -8},
  {6.9975064413370262472323564e-06, 8, "7", -5},
  {1.1915464806086109028626652e+00, 7, "11915465", 1},
  {1.4729790927932892247060276e-18, 5, "", -5},
  {8.7840510181792679798579210e-21, 18, "", -18},
  {8.4751060091923992746015815e-05, 12, "8475106", -4},
  {3.0313613695503970058009457e-03, 2, "", -2},
  {1.5858430298914041878255432e-01, 0, "", 0},
  {8.9238441052764677442610264e+05, 0, "892384", 6},
  {2.8102321671237266113099903e-24, 17, "", -17},
  {6.2166375862305740356445312e+10, 14, "6216637586230574035644531", 11},
  {9.9953171117208533312114502e-14, 8, "", -8},
  {2.3530816319097262123705150e+01, 6, "23530816", 2},
  {1.3742367368105323188177974e-23, 3, "", -3},
  {1.3128170262228303125000000e+14, 14, "13128170262228303125", 15},
  {9.1202898899055385600000000e+17, 2, "912028988990553856", 18},
  {2.6916777472294888067397443e-20, 9, "", -9},
  {2.7100617120232139804769655e-03, 7, "27101", -2},
  {6.1526023709473157909060249e-19, 13, "", -13},
  {6.6849410669835931339642028e-09, 0, "", 0},
  {4.2983368815105658880000000e+18, 14, "4298336881510565888", 19},
  {7.6429601168298441916704178e+05, 15, "764296011682984419167", 6},
  {6.7807000056420820358060730e-04, 10, "67807", -3},
  {1.0670077552986169344000000e+20, 18, "10670077552986169344", 21},
  {1.4332399137400899587677494e-12, 10, "", -10},
  {3.0450634371946060997057154e-05, 6, "3", -4},
  {5.5398742500990483533428665e-08, 0, "", 0},
  {5.7542415428902905076588596e-19, 5, "", -5},
  {2.8025460946047443389892578e+10, 0, "28025460946", 11},
  {7.7115480525390813551904115e-14, 17, "7712", -13},
  {8.0858174316061827600388553e-17, 17, "8", -16},
  {3.1322286279141212463378906e+10, 7, "313222862791412125", 11},
  {5.1622938978616501862400000e+20, 6, "516229389786165018624", 21},
  {4.3139478835759663534758613e-10, 10, "4", -9},
  {1.2387072685653800879068817e-06, 6, "1", -5},
  {1.4515184977173319297577578e-09, 17, "14515185", -8},
  {4.4674589050037526435915107e-21, 17, "", -17},
  {9.6927887626056561811107277e-24, 4, "", -4},
  {5.0299898991027010000000000e+15, 7, "5029989899102701", 16},
  {1.2370280179875050781250000e+13, 19, "1237028017987505078125", 14},
  {1.7383255183834301757812500e+12, 6, "1738325518383430176", 13},
  {1.2010362006734631723503526e-01, 2, "12", 0},
  {9.0880440193072856147615823e-02, 13, "908804401931", -1},
  {3.5723687466649766750421012e-09, 14, "357237", -8},
  {5.4851650831528391624327818e-14, 9, "", -9},
  {2.1343941217932715998596460e-17, 5, "", -5},
  {2.0953456137078732139976644e-24, 20, "", -20},
  {1.8619814431271296875000000e+13, 5, "1861981443127129688", 14},
  {1.1246219072123534977436066e+08, 0, "112462191", 9},
  {4.9554740196885207409313157e-16, 9, "", -9},
  {1.6449680613786326721310616e+06, 7, "16449680613786", 7},
  {6.1371881190483990000000000e+15, 8, "6137188119048399", 16},
  {3.3818201033229547647351865e+02, 15, "338182010332295476", 3},
  {1.6986034421148520879719901e-25, 17, "", -17},
  {2.4913086218406536661551149e-14, 20, "2491309", -13},
  {7.8703092156215627229529755e-25, 0, "", 0},
  {2.9082943923883587558520958e+04, 14, "2908294392388358756", 5},
  {6.1377111245680376887321472e+07, 9, "61377111245680377", 8},
  {8.9021080440126590382909910e-02, 15, "89021080440127", -1},
  {1.4140517358751728057861328e+10, 14, "1414051735875172805786133", 11},
  {1.5431787728240124511718750e+12, 7, "15431787728240124512", 13},
  {1.4703619072572972344602417e-18, 1, "", -1},
  {7.1344500842529408000000000e+17, 3, "71344500842529408", 18},
  {1.6321730261750579198219159e-15, 16, "16", -14},
  {3.6143842574311335000000000e+15, 4, "36143842574311335", 16},
  {9.5749540426148280977389029e-19, 2, "", -2},
  {1.8847863721169117769138612e-03, 8, "188479", -2},
  {4.6025053245303728000000000e+16, 7, "46025053245303728", 17},
  {3.5676607241255715489387512e+06, 19, "35676607241255715489387512", 7},
  {1.5881268568401018880000000e+20, 5, "1588126856840101888", 21},
  {2.7733260067403175589601862e-10, 16, "2773326", -9},
  {9.4638875559803936630487442e+05, 10, "9463887555980394", 6},
  {1.0192474243453660800000000e+17, 9, "101924742434536608", 18},
  {6.3975399818302597642210324e-18, 8, "", -8},
  {9.2111740407272800000000000e+14, 6, "921117404072728", 15},
  {1.0120527427040994167327881e+09, 13, "10120527427040994167328", 10},
  {2.8545861072589346463246329e+01, 1, "285", 2},
  {2.3227701899844329600000000e+17, 14, "232277018998443296", 18},
  {1.4648108702107344964742959e-08, 9, "15", -7},
  {6.1039110188061746882983646e-19, 7, "", -7},
  {1.1358328910133733006659895e+05, 1, "1135833", 6},
  {1.5701495843706419691443443e+06, 14, "157014958437064196914", 7},
  {2.9506698168541314667789726e-18, 18, "3", -17},
  {5.7503872466739727495236654e-15, 15, "6", -14},
  {9.1250373050664807128906250e+11, 5, "91250373050664807", 12},
  {3.5084263991724246150674969e-20, 2, "", -2},
  {2.1114290660889661269256588e-24, 8, "", -8},
  {1.4244326129435427924977988e-10, 9, "", -9},
  {9.2901170773719227735916383e-17, 0, "", 0},
  {1.4742311014637691317452464e-20, 12, "", -12},
  {1.4124335108842396736145020e+08, 20, "14124335108842396736145019531", 9},
  {9.9905122686017460937500000e+12, 0, "9990512268602", 13},
  {4.4487163539552816340889125e-08, 19, "444871635396", -7},
  {4.2992970000256107623975966e-21, 3, "", -3},
  {8.3582168055143108367919922e+09, 9, "8358216805514310837", 10},
  {3.3745964814058794203543592e-09, 3, "", -3},
  {9.6081828079111792612820864e+05, 12, "960818280791117926", 6},
  {3.7752516770837028860878632e-20, 5, "", -5},
  {6.9250496269013945701975977e-08, 1, "", -1},
  {6.2514342080277781250000000e+13, 3, "62514342080277781", 14},
  {1.9024027920573127441406250e+12, 17, "1902402792057312744140625", 13},
  {9.1598350351476629769087867e-22, 13, "", -13},
  {3.1477144054570115970126116e-18, 19, "31", -17},
  {2.5472127847283526400000000e+17, 12, "254721278472835264", 18},
  {6.0047135719416493138123059e-02, 2, "6", -1},
  {1.0452988944311756293083635e-24, 20, "", -20},
  {2.0261163692408775680000000e+18, 19, "2026116369240877568", 19},
  {1.2313594004604502500000000e+15, 8, "123135940046045025", 16},
  {1.9844896291350339478784585e-08, 2, "", -2},
  {1.5614961549501705494529165e-15, 13, "", -13},
  {9.1437205467354685440000000e+18, 3, "9143720546735468544", 19},
  {3.8931539927831881250000000e+14, 8, "3893153992783188125", 15},
  {1.3143080318427908420562744e+08, 10, "1314308031842790842", 9},
  {2.6907841486726761650186724e-14, 6, "", -6},
  {6.7415717654061826171875000e+12, 4, "67415717654061826", 13},
  {1.3309136149061501913637429e-02, 9, "13309136", -1},
  {5.0548381013654818511998689e-18, 1, "", -1},
  {9.1441410933280920410311171e-10, 8, "", -8},
  {2.0202731989195457096286646e+00, 4, "20203", 1},
  {6.1698296666998547525260417e-10, 2, "", -2},
  {1.5099270163216893081425951e+01, 10, "150992701632", 2},
  {7.2260515151854693982613753e+00, 17, "72260515151854694", 1},
  {3.0021724516918093750000000e+13, 13, "3002172451691809375", 14},
  {2.1288390146547371212800000e+20, 15, "212883901465473712128", 21},
  {1.8581713954545707661398981e-06, 3, "", -3},
  {7.4717708187859436035156250e+10, 12, "74717708187859436035156", 11},
  {5.2498167629554752530770798e-18, 5, "", -5},
  {2.3671294998776179596688962e+01, 2, "2367", 2},
  {3.4670051808126011394506349e+01, 12, "34670051808126", 2},
  {1.0182806569469903604019346e-22, 7, "", -7},
  {1.4538283928646027485768846e-20, 6, "", -6},
  {4.9529267243080469026392689e-22, 5, "", -5},
  {1.1092700206669185021526859e-10, 0, "", 0},
  {4.7372225648716986993597880e-16, 18, "474", -15},
  {8.9488668183257937016605865e+02, 15, "89488668183257937", 3},
  {4.4137679369575884800000000e+18, 10, "441376793695758848", 19},
  {2.0925392251702914061042837e-04, 13, "2092539225", -3},
  {2.3232627495942026647768319e-03, 6, "2323", -2},
  {4.0906386890713696479797363e+09, 14, "409063868907136964797974", 10},
  {3.9864805596020974218845367e+07, 7, "39864805596021", 8},
  {4.1150078390760208568721623e-01, 16, "4115007839076021", 0},
  {2.0279551731013739109039307e+08, 9, "202795517310137391", 9},
  {8.1431534540181925610208495e-16, 10, "", -10},
  {1.2293514585556486717768644e-08, 20, "1229351458556", -7},
  {4.0956050874139005670274385e-15, 10, "", -10},
  {9.5956162678974049753092486e-21, 17, "", -17},
  {2.7713828714475239394232631e+03, 16, "27713828714475239394", 4},
  {1.9013057765799718912000000e+19, 15, "19013057765799718912", 20},
  {2.5176835791716825000000000e+14, 15, "25176835791716825", 15},
  {1.1455725520185750694408615e-10, 9, "", -9},
  {6.3841599044825668017758538e-24, 15, "", -15},
  {4.1676846082116098841652274e+03, 7, "41676846082", 4},
  {5.1613247349295498046875000e+12, 4, "51613247349295498", 13},
  {3.3456281826074206037446856e+04, 12, "33456281826074206", 5},
  {1.0628985869905660521794744e+01, 7, "106289859", 2},
  {1.3213321627990217374565080e-18, 3, "", -3},
  {1.8448164366356133684876363e-09, 9, "2", -8},
  {8.5037200675774049758911133e+09, 12, "8503720067577404975891", 10},
  {2.0676138449016902117126965e-23, 18, "", -18},
  {2.3175177913797750830875166e-04, 14, "23175177914", -3},
  {1.4922445180683000944554806e+05, 14, "14922445180683000945", 6},
  {2.1495213747138805615577439e+01, 16, "214952137471388056", 2},
  {6.9640877485569702148437500e+11, 10, "6964087748556970214844", 12},
  {1.7829024663534532600522221e-14, 11, "", -11},
  {2.3416992450909148000000000e+16, 7, "23416992450909148", 17},
  {1.6271340083041552734375000e+13, 17, "16271340083041552734375", 14},
  {7.1299135567043828125000000e+12, 2, "712991355670438", 13},
  {3.1121691551863434724509716e+06, 9, "3112169155186343", 7},
  {1.1882073707966466752311639e-07, 16, "1188207371", -6},
  {1.6186173729330668290799690e-15, 5, "", -5},
  {5.0071946602816006433211503e-10, 19, "500719466", -9},
  {2.9541126543831895000000000e+15, 1, "29541126543831895", 16},
  {8.2824762446340982824680734e-19, 10, "", -10},
  {2.5253369131003943418995463e-13, 5, "", -5},
  {3.4475319445620993750000000e+14, 15, "3447531944562099375", 15},
  {3.8111823936157205108821167e-03, 0, "", 0},
  {1.3134875074512420605257756e-04, 17, "13134875074512", -3},
  {4.6387147792002272894684722e-02, 15, "46387147792002", -1},
  {2.4237430210874512791633606e+07, 20, "2423743021087451279163360596", 8},
  {1.0604439291751848068088293e+06, 20, "106044392917518480680882931", 7},
  {5.6296592442721210937500000e+13, 1, "562965924427212", 14},
  {3.8913764207150292349979281e+04, 8, "3891376420715", 5},
  {1.9758415310386854908552957e-23, 20, "", -20},
  {7.0534090668277481745888679e-12, 12, "7", -11},
  {3.9359981355037212779279798e+04, 7, "39359981355", 5},
  {7.2918666298265364389408205e+00, 19, "72918666298265364389", 1},
  {2.7483584600274382812500000e+13, 18, "274835846002743828125", 14},
  {2.0801375144821171760559082e+09, 12, "2080137514482117176056", 10},
  {3.2375418918601753906250000e+13, 12, "3237541891860175390625", 14},
  {2.7171942474468941861068898e-16, 15, "", -15},
  {1.5873952450822270976000000e+19, 11, "15873952450822270976", 20},
  {5.5759433025703103692800000e+20, 6, "557594330257031036928", 21},
  {3.5402638817417880063681242e-07, 18, "354026388174", -6},
  {8.2713831581686824960000000e+19, 1, "8271383158168682496", 20},
  {9.5797390838495006561279297e+09, 16, "95797390838495006561279297", 10},
  {5.5342995689652012354092165e-19, 7, "", -7},
  {2.4674872992787728075202245e-06, 9, "2467", -5},
  {9.5957613026798197713030386e-16, 16, "1", -14},
  {4.8446184356350582784000000e+19, 3, "48446184356350582784", 20},
  {2.2667595505098803710937500e+12, 20, "226675955050988037109375", 13},
  {8.7911896833487368496662384e+00, 3, "8791", 1},
  {2.2160746103669768577089292e-22, 4, "", -4},
  {3.8547359237195947265625000e+12, 11, "38547359237195947265625", 13},
  {1.9731402938848425418483495e-06, 3, "", -3},
  {8.4375249952349230957031250e+11, 2, "84375249952349", 12},
  {7.1162035923483680371903759e-04, 10, "7116204", -3},
  {3.9019837850257949829101562e+09, 11, "390198378502579498291", 10},
  {6.9043605907839193940162659e+07, 10, "690436059078391939", 8},
  {3.0227302032340108416974545e+05, 12, "302273020323401084", 6},
  {1.6693881344768634880000000e+19, 19, "1669388134476863488", 20},
  {8.0556528657622680664062500e+10, 3, "80556528657623", 11},
  {5.7225881332363839786618367e-24, 10, "", -10},
  {1.3133399201249729999673160e-19, 6, "", -6},
  {5.7684239239365950000000000e+15, 12, "5768423923936595", 16},
  {2.2034341624742770363809541e+04, 10, "220343416247428", 5},
  {6.3671102302826099172960994e-01, 10, "636711023", 0},
  {1.3843402354469751536214517e+00, 18, "1384340235446975154", 1},
  {3.2712467388791491290167572e-17, 16, "", -16},
  {1.9774633456907740963727121e-11, 1, "", -1},
  {2.6287925115154278564453125e+11, 4, "2628792511515428", 12},
  {8.3684922647689887744000000e+19, 4, "83684922647689887744", 20},
  {2.2588184095535316806522731e-11, 0, "", 0},
  {5.9620305600546214636982221e-19, 15, "", -15},
  {1.0696550504340115785598755e+09, 3, "1069655050434", 10},
  {2.5375709930867796549123311e-17, 4, "", -4},
  {5.7185738796090346269807014e-02, 8, "5718574", -1},
  {3.0847813788101049457303100e-08, 5, "", -5},
  {3.8745959324711109375000000e+13, 5, "3874595932471110938", 14},
  {3.7196716841528955355133945e-02, 14, "3719671684153", -1},
  {2.6402874895509314537048340e+09, 3, "2640287489551", 10},
  {1.9878996878196485120000000e+18, 11, "1987899687819648512", 19},
  {1.9713314742639484467012778e-01, 6, "197133", 0},
  {6.7777465219665018594241701e+03, 1, "67777", 4},
  {1.1992508561799177169799805e+10, 16, "119925085617991771697998047", 11},
  {7.2816020935898726970658679e-03, 20, "72816020935898727", -2},
  {1.9598534982647768000000000e+16, 9, "19598534982647768", 17},
  {1.6780930479438437500000000e+14, 10, "167809304794384375", 15},
  {2.0495040478033167976563522e-19, 14, "", -14},
  {9.8372954241174409162340453e+02, 18, "983729542411744091623", 3},
  {1.6467003580957192938253507e-18, 14, "", -14},
  {5.3565124108790803118731322e-05, 6, "54", -4},
  {9.4766704154203377499440797e-05, 17, "947667041542", -4},
  {1.7904228868592324966091743e-10, 2, "", -2},
  {7.9108752201565014472006004e-06, 8, "791", -5},
  {1.6268355995653458406856517e-17, 9, "", -9},
  {3.3457974354954571512277273e-03, 4, "33", -2},
  {3.6512883852631011962890625e+11, 9, "365128838526310119629", 12},
  {2.6523880920143424682540252e-24, 9, "", -9},
  {1.3234071579948757774701507e-05, 10, "132341", -4},
  {5.5478326014646348416226273e-16, 9, "", -9},
  {8.5501012377112442501528548e-19, 18, "1", -17},
  {1.8246385109570969779026066e-11, 4, "", -4},
  {1.0838846050069770134670919e-15, 17, "108", -14},
  {4.0370193115857928194741694e-05, 14, "4037019312", -4},
  {5.2453476788802917480468750e+11, 9, "524534767888029174805", 12},
  {9.1054615474886433619395006e-21, 8, "", -8},
  {3.5070364551000978714512257e+00, 5, "350704", 1},
  {1.5299957123195537543396499e-23, 20, "", -20},
  {6.0577822062789546918304406e-04, 3, "1", -2},
  {1.6812632000870242210950766e-15, 12, "", -12},
  {1.4340512455076515197753906e+10, 12, "14340512455076515197754", 11},
  {5.6512244881717593059656355e-19, 7, "", -7},
  {4.4336174789377352225758222e-04, 7, "4434", -3},
  {2.8771623694698062093064679e-08, 5, "", -5},
  {2.5269147922484764724064850e-13, 14, "25", -12},
  {1.3072456843088509129732142e-10, 10, "1", -9},
  {2.5528991561588209151523188e+03, 19, "25528991561588209151523", 4},
  {6.4517777225320536473600000e+20, 10, "645177772253205364736", 21},
  {1.0294659889122846720000000e+19, 17, "1029465988912284672", 20},
  {2.8593139291669134050607681e+07, 20, "2859313929166913405060768127", 8},
  {3.1797263597802359878677933e-24, 20, "", -20},
  {1.8143139233927861328125000e+12, 11, "18143139233927861328125", 13},
  {1.8458864105161031680000000e+18, 16, "1845886410516103168", 19},
  {3.1522655424206390258100991e-24, 6, "", -6},
  {3.9208248466104697627088171e+02, 11, "39208248466105", 3},
  {4.6793800319091953125000000e+13, 1, "46793800319092", 14},
  {9.1773762682375147520000000e+18, 12, "9177376268237514752", 19},
  {5.0244840319850273166592705e-21, 13, "", -13},
  {1.2998918222487658262252808e+08, 6, "129989182224877", 9},
  {5.1494731593166256000000000e+16, 19, "51494731593166256", 17},
  {1.2100500289658289557496399e-06, 1, "", -1},
  {1.0110013134674201751295186e+02, 0, "101", 3},
  {8.4620958457312992062374806e-22, 9, "", -9},
  {1.1107363341142461776733398e+10, 20, "111073633411424617767333984375", 11},
  {8.0333637768505113199353218e+06, 8, "803336377685051", 7},
  {3.2285430922946180216968060e+06, 15, "3228543092294618021697", 7},
  {6.9908072176603929355515552e-25, 4, "", -4},
  {1.1233179000576074421405792e+08, 3, "112331790006", 9},
  {1.0355016748980880688350367e-08, 16, "103550167", -7},
  {1.2854083273024073728000000e+19, 17, "12854083273024073728", 20},
  {3.4379913737732185982167721e+06, 13, "34379913737732185982", 7},
  {2.7149171798041203823382228e-25, 12, "", -12},
  {9.1870889410553026247815979e-12, 17, "918709", -11},
  {6.5264455213130297851562500e+11, 19, "652644552131302978515625", 12},
  {7.5159910758159932555352671e-20, 20, "8", -19},
  {4.2532822340941015000000000e+15, 11, "42532822340941015", 16},
  {3.7618967130255116746631701e-16, 14, "", -14},
  {4.5572867129974592000000000e+17, 17, "45572867129974592", 18},
  {2.1951554255727415296000000e+19, 16, "21951554255727415296", 20},
  {3.8980442557550194166474639e-19, 9, "", -9},
  {2.0317112751722693717443350e-11, 2, "", -2},
  {5.9720661688761040896000000e+19, 6, "59720661688761040896", 20},
  {4.0509180411431378646116716e-15, 6, "", -6},
  {1.6565610743565700683593750e+12, 2, "165656107435657", 13},
  {4.1235242889727483904000000e+19, 8, "41235242889727483904", 20},
  {1.4049549566764782282341055e-11, 0, "", 0},
  {2.0425095458462431674731147e-23, 0, "", 0},
  {6.6792719130395025786128826e+03, 8, "667927191304", 4},
  {7.5761609326757081476575435e-25, 5, "", -5},
  {1.2920996239642518462586386e-22, 3, "", -3},
  {7.2134443372142684936523438e+10, 5, "7213444337214268", 11},
  {1.6990008161792976898141205e+05, 6, "169900081618", 6},
  {3.9523954680840342468250981e-03, 3, "4", -2},
  {1.7310284225300133228302002e+09, 6, "1731028422530013", 10},
  {1.4869104992160291066755745e-23, 12, "", -12},
  {3.8542184116208284549998098e+00, 0, "4", 1},
  {1.0259154107585527557643495e-10, 8, "", -8},
  {5.9334757141013495990510825e-25, 0, "", 0},
  {1.3760349339307054411345177e-04, 9, "137603", -3},
  {1.2256312917378460279746108e-05, 13, "122563129", -4},
  {3.0149040542515195497839595e-05, 19, "301490405425152", -4},
  {9.6829566016976687361020315e-05, 17, "9682956601698", -4},
  {5.5203185981954080000000000e+16, 0, "5520318598195408", 17},
  {2.6893103263696150293888231e-15, 12, "", -12},
  {7.4688785941353462500000000e+14, 15, "746887859413534625", 15},
  {1.3201033334471298371124967e-14, 8, "", -8},
  {8.4996606837114752000000000e+16, 20, "84996606837114752", 17},
  {1.3620393027716996575976107e-23, 7, "", -7},
  {3.0791465518159316000000000e+16, 0, "30791465518159316", 17},
  {2.0009326289214269661018500e-05, 7, "2", -4},
  {6.2602832053491743281483650e+06, 17, "626028320534917432814837", 7},
  {8.3189201351901301677571610e+03, 9, "831892013519", 4},
  {7.8745008293904385610064218e-17, 0, "", 0},
  {6.2242890253237648437500000e+13, 6, "62242890253237648438", 14},
  {4.0288783406584875000000000e+13, 19, "40288783406584875", 14},
  {8.3260999711511107417351401e-20, 19, "1", -18},
  {8.1881183633105730779178089e-02, 4, "819", -1},
  {1.8706496575064141750335693e+09, 8, "187064965750641418", 10},
  {1.1302733526323105952930952e-19, 3, "", -3},
  {2.6352074000141108512669786e-11, 16, "263521", -10},
  {3.5169704760293795630075348e-17, 12, "", -12},
  {6.8108571120679419372777839e-06, 9, "6811", -5},
  {6.2480176498644701526671418e-10, 0, "", 0},
  {1.8369453818262004421199922e-17, 2, "", -2},
  {3.4701576590364109631270395e-02, 1, "", -1},
  {9.8997058166552870534360409e+05, 16, "9899705816655287053436", 6},
  {6.2903809828890308737754822e+07, 17, "6290380982889030873775482", 8},
  {1.3416997378994956054687500e+12, 15, "134169973789949560546875", 13},
  {1.1531031693212227870691385e-10, 7, "", -7},
  {9.5265341755655535962432623e+05, 9, "952653417556555", 6},
  {2.5775240187120899114370243e-03, 1, "", -1},
  {2.0121739935035767219732689e-14, 18, "20122", -13},
  {8.7597986244960767180800000e+20, 1, "875979862449607671808", 21},
  {2.9195940198675259517240368e-05, 14, "291959402", -4},
  {7.8628001788504350000000000e+15, 3, "7862800178850435", 16},
  {5.6777027833781973191733944e-05, 19, "56777027833782", -4},
  {1.3660747893387486379124240e-02, 0, "", 0},
  {1.5630212604257546240000000e+18, 17, "1563021260425754624", 19},
  {6.1121263304038915634155273e+09, 9, "6112126330403891563", 10},
  {3.6418069902427362060546875e+11, 5, "36418069902427362", 12},
  {6.3692743624218460000000000e+15, 19, "6369274362421846", 16},
  {9.1952556496362780000000000e+15, 16, "9195255649636278", 16},
  {9.5470382254132977071805566e-20, 1, "", -1},
  {1.5002870819353468501144988e-03, 18, "1500287081935347", -2},
  {3.2864490633947553988036816e+00, 7, "32864491", 1},
  {1.0005614967716209370809099e-25, 13, "", -13},
  {4.0322825471429187993600000e+20, 1, "403228254714291879936", 21},
  {1.5063069046392702035155648e-07, 4, "", -4},
  {6.5731629519272009277343750e+11, 6, "657316295192720093", 12},
  {8.3782339812296113823464339e-01, 20, "83782339812296113823", 0},
  {6.8437870793999157714843750e+11, 2, "68437870793999", 12},
  {1.9669634805858601600000000e+17, 5, "196696348058586016", 18},
  {4.3169049000857196800000000e+17, 3, "431690490008571968", 18},
  {1.0041069742626801189270829e-19, 10, "", -10},
  {1.0768815608053144531250000e+12, 11, "1076881560805314453125", 13},
  {1.1092193214085999120044335e-02, 13, "110921932141", -1},
  {4.0449066843545744000000000e+16, 14, "40449066843545744", 17},
  {1.6510889394694615040000000e+19, 1, "1651088939469461504", 20},
  {7.9904224284916950000000000e+14, 1, "7990422428491695", 15},
  {1.9810705246922750109861422e-03, 1, "", -1},
  {2.5145963587368897740800000e+20, 6, "251459635873688977408", 21},
  {5.2530512870418661464100296e+01, 1, "525", 2},
  {7.0040979606389412656426430e+06, 19, "7004097960638941265642643", 7},
  {3.5450847410795719727504679e-09, 20, "354508474108", -8},
  {4.2129718984929873461066607e-13, 20, "42129719", -12},
  {1.4356791910547459193284840e-15, 3, "", -3},
  {3.8233209094970229671162087e+03, 5, "382332091", 4},
  {1.2217778643655572800000000e+17, 8, "122177786436555728", 18},
  {1.6255042783076447676648968e+00, 11, "162550427831", 1},
  {1.4820307679286317130256152e-10, 17, "14820308", -9},
  {3.6105580315872159500273458e-16, 4, "", -4},
  {3.7503205189112490234375000e+12, 10, "37503205189112490234375", 13},
  {4.6950619998010264780800000e+20, 7, "469506199980102647808", 21},
  {2.3204366973979934118688107e+06, 4, "23204366974", 7},
  {5.9956640595048862261554601e-22, 10, "", -10},
  {2.2983793721778440475463867e+08, 12, "229837937217784404755", 9},
  {6.5396317858406672000000000e+16, 19, "65396317858406672", 17},
  {2.6196652450226458926511510e-11, 2, "", -2},
  {1.5451627655203680984842161e-06, 19, "15451627655204", -5},
  {4.8819173606842275254764000e-09, 3, "", -3},
  {1.9682341349332340000000000e+16, 19, "1968234134933234", 17},
  {8.5316729313334950769845826e-24, 6, "", -6},
  {1.4489247186092807769775391e+10, 19, "14489247186092807769775390625", 11},
  {4.6861629225283601366675024e-04, 5, "47", -3},
  {4.4234378235033880997436574e-21, 5, "", -5},
  {1.2103530400212459564208984e+09, 3, "1210353040021", 10},
  {4.7345699537837362500000000e+14, 11, "473456995378373625", 15},
  {1.1262310160630024969577789e+08, 19, "1126231016063002496957778931", 9},
  {9.3681181372757280000000000e+15, 10, "9368118137275728", 16},
  {3.8541388409623339112366366e-18, 18, "4", -17},
  {6.3587728900011280309113416e-13, 1, "", -1},
  {1.4545019813727201461791992e+10, 5, "145450198137272", 11},
  {3.5976813588566661175258088e-21, 4, "", -4},
  {2.2738318256831982542509487e-11, 3, "", -3},
  {3.0337071046403287335042588e-23, 19, "", -19},
  {6.0504821902928727084258753e+00, 18, "6050482190292872708", 1},
  {3.3814771059338394449842218e-11, 6, "", -6},
  {4.3294804284300958394265859e-20, 15, "", -15},
  {2.4921137721893585630705816e-22, 14, "", -14},
  {1.0024370857108185600000000e+18, 13, "100243708571081856", 19},
  {9.8107809563344508205773309e+03, 9, "9810780956334", 4},
  {3.1413391470763733119280622e-18, 18, "3", -17},
  {3.6433539323066854476928711e+09, 20, "364335393230668544769287109375", 10},
  {3.4921308503019167133967517e-11, 14, "3492", -10},
  {1.2099701669658411008000000e+19, 11, "12099701669658411008", 20},
  {7.8365105853609181940555573e+05, 19, "7836510585360918194055557", 6},
  {1.0444513250338418597351620e+00, 2, "104", 1},
  {9.9849707993717600820370103e-24, 18, "", -18},
  {2.1807463477846250680643528e-06, 5, "", -5},
  {8.2614708693523844557006931e-07, 15, "826147087", -6},
  {1.3770813732616052500000000e+15, 1, "13770813732616053", 16},
  {6.9269567865258137429893211e-22, 11, "", -11},
  {1.1002053670731314562257166e-20, 12, "", -12},
  {1.5417750124133938965905266e-17, 7, "", -7},
  {1.7998579396398956305347383e+05, 6, "179985793964", 6},
  {9.1629667475862808227539062e+10, 6, "91629667475862808", 11},
  {1.8964382504875948800000000e+17, 4, "189643825048759488", 18},
  {6.3284464895424030721187592e+07, 5, "6328446489542", 8},
  {9.5607924455607136000000000e+16, 17, "95607924455607136", 17},
  {1.0374023912271215976943495e+03, 17, "103740239122712159769", 4},
  {1.5750897003595059300120462e-17, 19, "158", -16},
  {1.0325787340762945038037641e-13, 18, "103258", -12},
  {8.8349640064130981445312500e+11, 19, "883496400641309814453125", 12},
  {1.0542820204920944662940674e-15, 1, "", -1},
  {1.0234721009286011718750000e+13, 17, "1023472100928601171875", 14},
  {1.9407363025637978243276294e-02, 12, "19407363026", -1},
  {1.4341514789256176757812500e+12, 6, "1434151478925617676", 13},
  {9.1512063439169877288037469e-01, 3, "915", 0},
  {1.0296206220718742907047272e+08, 12, "10296206220718742907", 9},
  {6.7925157971261782563487941e+01, 15, "67925157971261783", 2},
  {1.7130488622156023979187012e+09, 16, "17130488622156023979187012", 10},
  {8.4027265802896700625537999e-23, 0, "", 0},
  {2.3683515469996784813702106e+06, 1, "23683515", 7},
  {4.8936072805749281030746759e-18, 11, "", -11},
  {4.7456552452037036510883932e-22, 4, "", -4},
  {5.5230352951426487605468145e-09, 8, "1", -7},
  {6.1584229423329582214355469e+10, 9, "61584229423329582214", 11},
  {2.3591884053618641778943662e-15, 10, "", -10},
  {7.5010942371462773437500000e+12, 1, "75010942371463", 13},
  {2.4460605571628374425600000e+20, 3, "244606055716283744256", 21},
  {1.6722360923809368744626580e-15, 6, "", -6},
  {2.7591801536959252480000000e+18, 7, "2759180153695925248", 19},
  {1.1188891780880613327026367e+09, 13, "11188891780880613327026", 10},
  {1.5880010058075566965127288e-16, 6, "", -6},
  {2.2298864236494828536239675e-06, 5, "", -5},
  {2.5571178688461649915494968e-13, 17, "25571", -12},
  {9.3680542713246814801736351e-04, 6, "937", -3},
  {5.9904774009964132096739137e-17, 1, "", -1},
  {6.9712848617782974714252777e-23, 18, "", -18},
  {4.8983335567815074920654297e+09, 10, "48983335567815074921", 10},
  {4.6672356258828956604003906e+10, 18, "4667235625882895660400390625", 11},
  {5.8387903382345760895098298e-08, 8, "6", -7},
  {1.4513472688730347208538634e-17, 2, "", -2},
  {5.1738288441940620083200000e+20, 2, "517382884419406200832", 21},
  {1.1408150772437892854213715e+07, 18, "11408150772437892854213715", 8},
  {4.2648984782389592895768260e-01, 4, "4265", 0},
  {4.8937566458998683950828086e-09, 7, "", -7},
  {5.0403531691596252886013602e-13, 9, "", -9},
  {2.1059468562157313075243446e-12, 6, "", -6},
  {1.7742841069608025864407933e-16, 6, "", -6},
  {2.1512705637572703602260476e-19, 19, "2", -18},
  {2.6384094737388608776324991e-05, 14, "2638409474", -4},
  {5.5195163495244736000000000e+16, 7, "55195163495244736", 17},
  {5.1091364458556330283012237e-03, 4, "51", -2},
  {2.1331086662171517911022395e-16, 4, "", -4},
  {3.9246928726133853681085874e-22, 20, "", -20},
  {5.2663024054401152446153176e-14, 15, "53", -13},
  {5.7670283038980034498444376e-07, 18, "57670283039", -6},
  {1.1287797795427467115097633e-12, 8, "", -8},
  {1.9369463888402435713942396e+01, 14, "1936946388840244", 2},
  {3.0139288187347972096000000e+19, 5, "30139288187347972096", 20},
  {1.9499125486799596945782529e-25, 11, "", -11},
  {5.5654130084189503691050049e+00, 2, "557", 1},
  {8.4831609234029467659712584e-18, 19, "85", -17},
  {6.7078788169495336000000000e+16, 15, "67078788169495336", 17},
  {6.4619109899568473815917969e+10, 8, "6461910989956847382", 11},
  {5.1607647309823927462209176e-15, 20, "516076", -14},
  {2.5747235348591499030590057e+07, 20, "2574723534859149903059005737", 8},
  {2.7542946374161649774448334e-16, 7, "", -7},
  {7.5578406412894179687500000e+12, 6, "7557840641289417969", 13},
  {3.6222049036883155106387772e-07, 8, "36", -6},
  {5.0873212092819681167602539e+09, 1, "50873212093", 10},
  {3.9247093874065418440799754e-19, 10, "", -10},
  {1.2030402385918361600000000e+20, 9, "120304023859183616", 21},
  {2.4657573124953681119490361e-14, 3, "", -3},
  {7.4415619497246580123901367e+09, 9, "7441561949724658012", 10},
  {1.6802215370455354824067663e-08, 3, "", -3},
  {3.8859531835362730458040314e-11, 12, "39", -10},
  {2.7413133363303297265503587e-17, 16, "", -16},
  {3.1020359049732980065537460e-15, 7, "", -7},
  {6.5443302758361243665063967e-01, 7, "654433", 0},
  {8.1410596708428051293537919e-01, 19, "8141059670842805129", 0},
  {4.0419132972875899299526913e-14, 1, "", -1},
  {4.0126718795575579536868656e-11, 17, "4012672", -10},
  {2.5488483719435695000000000e+15, 0, "254884837194357", 16},
  {1.2991027694906050452943767e-21, 2, "", -2},
  {1.3825851568349053888645215e-15, 4, "", -4},
  {2.0609895515408718996866077e-14, 20, "206099", -13},
  {1.9304317857695543766021729e+09, 8, "193043178576955438", 10},
  {1.2684425482646469026803970e+07, 15, "12684425482646469026804", 8},
  {1.5197001092523738842817270e-22, 7, "", -7},
  {6.2783760263334575574845076e+05, 13, "6278376026333457557", 6},
  {1.8298237826679587555413599e-12, 4, "", -4},
  {3.1125501833748097624265938e+02, 5, "31125502", 3},
  {1.1092609721834597778320312e+11, 9, "110926097218345977783", 12},
  {2.6335676538521673748869507e-19, 8, "", -8},
  {9.0167150166384208316274506e-22, 3, "", -3},
  {2.3239360696413874869653007e-25, 20, "", -20},
  {6.0771300082765726260796018e-15, 2, "", -2},
  {1.7553674770029685546875000e+13, 12, "17553674770029685546875", 14},
  {6.8465349482949321213709482e+01, 18, "68465349482949321214", 2},
  {3.8495262986686771000677254e+02, 14, "38495262986686771", 3},
  {5.7287014939630604478532083e-04, 19, "572870149396306", -3},
  {6.5320246663178056678589201e+02, 1, "6532", 3},
  {8.1496896044037427486728120e+01, 20, "8149689604403742748673", 2},
  {9.9713925890931343065659576e-01, 13, "9971392589093", 0},
  {4.2388512752700400000000000e+15, 18, "423885127527004", 16},
  {1.9383217256616814322843988e-11, 16, "193832", -10},
  {1.5073750914265595657326458e+00, 8, "150737509", 1},
  {2.9480364809025219195349021e-08, 0, "", 0},
  {1.3911828029024460442972762e-12, 14, "139", -11},
  {1.0195472134260203750000000e+15, 18, "1019547213426020375", 16},
  {7.9578910776083436329209064e-02, 12, "79578910776", -1},
  {2.5686574728865770406396387e-11, 7, "", -7},
  {2.3279862518329546915802838e-05, 9, "2328", -4},
  {6.9455948533829911423388573e-07, 15, "694559485", -6},
  {1.2427545421390087604522705e+09, 1, "12427545421", 10},
  {5.5300126238083064556121826e+08, 14, "55300126238083064556122", 9},
  {5.2508690558886237432078698e-23, 4, "", -4},
  {2.6007040305456709375000000e+14, 3, "260070403054567094", 15},
  {7.0277079247496142578125000e+11, 0, "702770792475", 12},
  {8.7924035185569152832031250e+09, 9, "8792403518556915283", 10},
  {5.3873279132638409146253002e-10, 14, "53873", -9},
  {7.1448582819345430088247223e-22, 13, "", -13},
  {3.5560170900424071021566773e-07, 8, "36", -6},
  {3.8870443542629562472257021e+00, 2, "389", 1},
  {2.4874857929393206714136424e-09, 11, "249", -8},
  {1.8905113379796319580078125e+11, 18, "18905113379796319580078125", 12},
  {1.0607953632684494760241023e+00, 11, "106079536327", 1},
  {2.6788342129512422387259060e-05, 20, "2678834212951242", -4},
  {1.7974826396227093937341124e+04, 19, "179748263962270939373411", 5},
  {6.4822480506858832782768332e+00, 4, "64822", 1},
  {2.3790394318867633671743533e+01, 12, "23790394318868", 2},
  {5.3085632200793109130859375e+11, 3, "530856322007931", 12},
  {9.8101617494005151999087679e-18, 3, "", -3},
  {5.2735000230336697218225393e-10, 16, "52735", -9},
  {2.4306669043174510996309107e-07, 19, "2430666904317", -6},
  {2.8058693700521636742766998e-14, 17, "2806", -13},
  {1.6356764030988719602066617e-03, 2, "", -2},
  {3.8768028183808350004255772e+06, 12, "3876802818380835", 7},
  {9.0334496473980392456054688e+10, 7, "903344964739803925", 11},
  {3.3060494030786804687500000e+13, 1, "330604940307868", 14},
  {6.1648595857989136392172262e-09, 10, "62", -8},
  {3.3141761225068667044979520e+03, 6, "3314176123", 4},
  {8.8337644999970524325536424e-25, 4, "", -4},
  {4.7593257137719613893749236e-11, 5, "", -5},
  {6.9934377358498468672223484e-14, 19, "699344", -13},
  {2.2522695733475430301950837e+01, 0, "23", 2},
  {8.3446929574234052218173474e-01, 16, "8344692957423405", 0},
  {4.4902946537072153309757090e-15, 7, "", -7},
  {3.9456217944287118517073529e-21, 9, "", -9},
  {5.2385379938509629357296324e-24, 14, "", -14},
  {7.7444038864057596072143497e-02, 13, "774440388641", -1},
  {1.0893815566860510575508606e-23, 15, "", -15},
  {1.7729402719296558643691242e+01, 2, "1773", 2},
  {2.3714801545163618002932763e-25, 19, "", -19},
  {2.1063765364772090294463695e-17, 7, "", -7},
  {2.5080870557300761342048645e+07, 15, "25080870557300761342049", 8},
  {5.4575564370443702645576066e-24, 13, "", -13},
  {2.3213887428647317630006234e-09, 6, "", -6},
  {9.2398488999712480307380247e-01, 14, "92398488999712", 0},
  {1.6507111218691688091800502e-06, 5, "", -5},
  {8.2651365267764606475830078e+09, 0, "8265136527", 10},
  {1.7621200523304202079089009e+02, 1, "1762", 3},
  {4.7658347155025371780273248e-13, 10, "", -10},
  {2.3371307830168889259647210e-10, 7, "", -7},
  {9.1941725186121830567663559e-11, 12, "92", -10},
  {2.5104903431654268467899150e-20, 3, "", -3},
  {3.1561675797249189034943129e-01, 13, "3156167579725", 0},
  {3.3963062410418601989746094e+10, 5, "339630624104186", 11},
  {2.5752601693161700406759733e-18, 4, "", -4},
  {7.0017618862330600000000000e+15, 6, "700176188623306", 16},
  {6.1345895644549336349278968e-15, 13, "", -13},
  {7.5650511751646804809570312e+09, 11, "756505117516468048096", 10},
  {7.1195783638183364727105917e-21, 8, "", -8},
  {6.2005627929028037298551088e-17, 20, "6201", -16},
  {5.0812764162077879546215363e-21, 9, "", -9},
  {1.2784426699243015900719911e+05, 2, "12784427", 6},
  {8.0861435046993371582031250e+11, 6, "808614350469933716", 12},
  {5.9925988179836110758547107e-02, 8, "5992599", -1},
  {1.1904706267513732018414885e+05, 19, "1190470626751373201841488", 6},
  {5.8161861555717155706823562e-19, 3, "", -3},
  {6.3787704019997968230825603e-09, 3, "", -3},
  {3.3312776460949261474609375e+11, 14, "33312776460949261474609375", 12},
  {7.4259377859948190234717913e+03, 12, "7425937785994819", 4},
  {7.5400093051463889423757792e+05, 6, "754000930515", 6},
  {2.1291301275281489631873919e-05, 19, "212913012752815", -4},
  {3.3014561639836396858375955e-05, 11, "3301456", -4},
  {3.1568612640464646144000000e+19, 5, "31568612640464646144", 20},
  {3.5682960103629892072744636e-25, 6, "", -6},
  {4.4709657140184820982826668e-12, 13, "45", -11},
  {9.4870498242955052852630615e+08, 1, "9487049824", 9},
  {1.0372185120235594496285341e-22, 7, "", -7},
  {4.6909912473921283083966305e-04, 2, "", -2},
  {1.1922657330452927455161893e-08, 10, "119", -7},
  {2.2825563590006645325940079e-25, 19, "", -19},
  {3.5303379236123238400000000e+18, 15, "353033792361232384", 19},
  {3.3221199947516093246337827e-10, 18, "332211999", -9},
  {4.1178337149304000000000000e+16, 19, "41178337149304", 17},
  {2.6063483686918307095766068e+07, 14, "2606348368691830709577", 8},
  {5.7349062183627888288076692e-08, 5, "", -5},
  {4.6424832198534241908194784e-21, 11, "", -11},
  {2.1672949212320832500000000e+15, 15, "216729492123208325", 16},
  {9.3504935287328035007742006e-11, 19, "935049353", -10},
  {3.6467194539640314587813918e+02, 10, "3646719453964", 3},
  {3.3010871159075549030603725e+02, 10, "3301087115908", 3},
  {3.4462705858541951656243441e-23, 6, "", -6},
  {2.0480776969961345346232045e-16, 2, "", -2},
  {2.5477524527213021766294747e-08, 13, "254775", -7},
  {7.1929000831245887279510498e+08, 3, "719290008312", 9},
  {4.4909068921770884547374518e-10, 14, "44909", -9},
  {1.5874641265391363281250000e+13, 2, "1587464126539136", 14},
  {1.2974260494585067033767700e+07, 0, "1297426", 8},
  {1.3735555332151599018939596e-12, 0, "", 0},
  {4.2510670214786203648000000e+19, 8, "42510670214786203648", 20},
  {5.7735153023528553717369505e+01, 16, "577351530235285537", 2},
  {4.8631182869039677440000000e+18, 2, "4863118286903967744", 19},
  {1.2747595714980650754232470e-05, 4, "", -4},
  {6.1631561362553606559186776e-17, 9, "", -9},
  {1.8425425916713230553809764e-25, 5, "", -5},
  {3.8574467011083247264361133e-07, 7, "4", -6},
  {3.8639930232667580867200741e+02, 0, "386", 3},
  {4.1428839012004408836364746e+09, 5, "414288390120044", 10},
  {7.6125017769440244883298874e+06, 18, "7612501776944024488329887", 7},
  {2.8353258526199579919643609e-10, 9, "", -9},
  {7.5671008024862765205359699e-10, 11, "76", -9},
  {1.8833384735179356250000000e+14, 7, "1883338473517935625", 15},
  {7.5252363134872555732727051e+07, 10, "752523631348725557", 8},
  {9.1366743080625779507200000e+20, 7, "913667430806257795072", 21},
  {3.3811622902785052247054409e+02, 14, "33811622902785052", 3},
  {2.3195865929173869864547063e-19, 8, "", -8},
  {9.8596344304976094008452492e+02, 13, "9859634430497609", 3},
  {6.8151263522146085632974741e-20, 5, "", -5},
  {4.2577133422022031561099433e-13, 6, "", -6},
  {1.7328238007544184832000000e+19, 9, "17328238007544184832", 20},
  {1.3206759657341964721679688e+11, 4, "1320675965734196", 12},
  {1.1939889756391712768000000e+19, 4, "11939889756391712768", 20},
  {6.1115798800829941228585085e+02, 1, "6112", 3},
  {3.4458609365164617583094643e-25, 12, "", -12},
  {2.4682648711827916542070932e-09, 5, "", -5},
  {9.3691266761209574043211257e-16, 5, "", -5},
  {2.3723944944857293760691536e-07, 11, "23724", -6},
  {1.0389867182552850409272272e-20, 10, "", -10},
  {8.7830969321928466524065232e-06, 3, "", -3},
  {1.0001670098734984915012092e+00, 12, "1000167009873", 1},
  {3.3161144212647595404760252e-12, 4, "", -4},
  {1.4821889678339162958530884e-06, 14, "148218897", -5},
  {2.5364610977229417767375708e+05, 6, "253646109772", 6},
  {5.2545795717118481960028475e-01, 5, "52546", 0},
  {2.2514868992398031250000000e+14, 0, "22514868992398", 15},
  {1.3412958204439177646676289e-20, 8, "", -8},
  {5.7567252778922473055445153e+01, 8, "5756725278", 2},
  {2.0126769856178587985279043e-20, 10, "", -10},
  {1.7916626233794589323489177e-02, 13, "179166262338", -1},
  {9.8713992468190372164826840e+02, 7, "9871399247", 3},
  {1.5945280902145857860897505e-18, 13, "", -13},
  {1.6315653253117228405760786e-03, 18, "1631565325311723", -2},
  {2.1763687553776548106310204e-23, 20, "", -20},
  {8.2113614714193623040000000e+18, 20, "8211361471419362304", 19},
  {8.0374544521802847157232463e+04, 20, "8037454452180284715723246", 5},
  {3.0014744526724588242682328e-16, 7, "", -7},
  {1.4749485300864872971970954e+00, 12, "1474948530086", 1},
  {3.6821060451003975000000000e+14, 9, "36821060451003975", 15},
  {8.5949605821187110158392942e-15, 11, "", -11},
  {6.0745867853595138549804688e+10, 13, "607458678535951385498047", 11},
  {8.7571583853155170800164342e+04, 3, "87571584", 5},
  {3.7189548109701741486787796e+06, 15, "3718954810970174148679", 7},
  {6.7294634094007247424538818e-09, 14, "672946", -8},
  {4.0967040619114234406238145e-10, 15, "40967", -9},
  {1.5983905139946804771858951e-10, 19, "1598390514", -9},
  {7.0570294519603943798350048e-13, 17, "7057", -12},
  {5.8919683345505008051617296e-05, 15, "58919683346", -4},
  {4.5609181630382687968296098e-09, 6, "", -6},
  {4.8276040190637818166696045e-07, 11, "48276", -6},
  {6.5781317719879327341914177e+06, 11, "657813177198793273", 7},
  {2.5261930030621340870857239e+08, 12, "252619300306213408709", 9},
  {1.5913363621990810546875000e+12, 4, "15913363621990811", 13},
  {2.8096988098012994974851608e+07, 1, "280969881", 8},
  {6.1636486461429842615035576e-07, 10, "6164", -6},
  {8.4247017706620527343750000e+12, 3, "8424701770662053", 13},
  {3.6342380852064757760000000e+18, 19, "3634238085206475776", 19},
  {2.2520839173747443179513308e-05, 19, "225208391737474", -4},
  {3.9955939058215115267103101e+00, 8, "399559391", 1},
  {1.2445442806225590626212352e+00, 1, "12", 1},
  {1.8628430130694465175734110e-18, 9, "", -9},
  {4.9508870893807478142630761e-08, 0, "", 0},
  {4.8032163709176193270179662e-23, 14, "", -14},
  {6.6236173258896174957044423e+04, 2, "6623617", 5},
  {2.3684588466855401251349443e-11, 2, "", -2},
  {5.1213367349530691415075700e-24, 9, "", -9},
  {3.8253935215264502364394830e-12, 1, "", -1},
  {7.0415145120929935651676542e-19, 9, "", -9},
  {3.5037518730242457315585090e-20, 14, "", -14},
  {6.9388925954231070354580879e+06, 20, "693889259542310703545808792", 7},
  {2.1397972173637176000000000e+16, 0, "21397972173637176", 17},
  {2.3226906804299628199485658e-20, 14, "", -14},
  {2.3985501746019613281250000e+13, 16, "2398550174601961328125", 14},
  {4.4734048493004747797385789e+03, 19, "44734048493004747797386", 4},
  {2.2670130142756170000000000e+15, 12, "2267013014275617", 16},
  {3.5660513419036952292850984e-03, 19, "35660513419036952", -2},
  {5.1574025344438964843750000e+10, 2, "5157402534444", 11},
  {5.7401142723504244349896908e+05, 3, "574011427", 6},
  {3.0989177690031510792323388e+01, 14, "3098917769003151", 2},
  {1.6399829579539132873375245e-13, 11, "", -11},
  {1.4068998017006044387817383e+10, 18, "14068998017006044387817382813", 11},
  {1.2493895955804941775189912e-08, 9, "12", -7},
  {4.3292686926297868632573795e-01, 18, "432926869262978686", 0},
  {1.0515509332169208078777700e-02, 5, "1052", -1},
  {1.0615923346079136901920492e-02, 15, "10615923346079", -1},
  {1.1607060441513781250000000e+14, 4, "1160706044151378125", 15},
  {2.6370290451658193383629537e-25, 10, "", -10},
  {3.2712459018361907638555602e-21, 16, "", -16},
  {5.0992334041349553355493088e-14, 20, "5099233", -13},
  {3.3965981580389653136802542e-12, 17, "33966", -11},
  {2.8240048564109619200000000e+17, 15, "282400485641096192", 18},
  {7.9961300239792056320000000e+18, 6, "7996130023979205632", 19},
  {7.3091347748769703684956767e+02, 3, "730913", 3},
  {5.5612297758497497568441759e-01, 17, "55612297758497498", 0},
  {1.2123921846576394521615865e-11, 15, "12124", -10},
  {1.0540047667358406066894531e+10, 10, "105400476673584060669", 11},
  {8.4067387475922156250000000e+13, 5, "8406738747592215625", 14},
  {5.5944556718320423427392996e-02, 19, "559445567183204234", -1},
  {1.2426396974454171875000000e+14, 16, "12426396974454171875", 15},
  {4.0270925960507628360574017e+02, 4, "4027093", 3},
  {1.3999627915823857784271240e+09, 7, "13999627915823858", 10},
  {1.0153180163783223179052584e+04, 9, "10153180163783", 5},
  {7.7937098547687731933593750e+11, 0, "779370985477", 12},
  {1.0771296349825718309016422e-09, 20, "107712963498", -8},
  {6.4560084237039487217724165e-03, 6, "6456", -2},
  {6.8197026376305434796565517e-25, 5, "", -5},
  {5.3524803401837008836953996e-13, 12, "1", -11},
  {9.9221972265698850154876709e+08, 20, "99221972265698850154876708984", 9},
  {1.6647587600786409312014769e-01, 7, "1664759", 0},
  {1.4274568330925843929872317e-13, 4, "", -4},
  {3.0447517246700863324804232e+04, 1, "304475", 5},
  {5.6988599820584956723200000e+20, 5, "569885998205849567232", 21},
  {8.0045570347427840000000000e+18, 9, "8004557034742784", 19},
  {3.7496532554102719877412581e-05, 19, "374965325541027", -4},
  {9.2757460682032946136092738e-17, 9, "", -9},
  {9.5850869816605069771578396e-23, 5, "", -5},
  {9.8268830292672013926400000e+20, 10, "982688302926720139264", 21},
  {2.5578552001515665229687199e-05, 10, "255786", -4},
  {1.7510735398803983967596302e-17, 15, "", -15},
  {4.5654608282523063385561709e-08, 16, "456546083", -7},
  {1.2524354099820182006611490e-18, 15, "", -15},
  {5.2729265632860013113258901e+01, 10, "527292656329", 2},
  {1.0899793547367447469158063e-16, 19, "109", -15},
  {2.9975504402025516000000000e+16, 18, "29975504402025516", 17},
  {1.3707072471710516962252511e-13, 10, "", -10},
  {1.2275345376712405711204337e-08, 18, "12275345377", -7},
  {1.0936859147363820738974027e+04, 10, "109368591473638", 5},
  {1.0494375665996995649751942e-18, 9, "", -9},
  {3.3583671899391742187500000e+13, 5, "3358367189939174219", 14},
  {1.1919441133196829239901216e-23, 9, "", -9},
  {9.8131325518265335808000000e+19, 0, "98131325518265335808", 20},
  {9.1924979371390512505879400e-03, 15, "9192497937139", -2},
  {1.6884373466810106277465820e+10, 11, "1688437346681010627747", 11},
  {7.7292588466074077347698907e-16, 2, "", -2},
  {5.3562896826864436268806458e+07, 3, "53562896827", 8},
  {5.9158391770058288000000000e+16, 7, "59158391770058288", 17},
  {4.4060368734309673906949161e-08, 18, "44060368734", -7},
  {7.9469430533498060702243118e-22, 11, "", -11},
  {3.8136014566376545076309412e+01, 14, "3813601456637655", 2},
  {5.6437255532513935360000000e+19, 16, "5643725553251393536", 20},
  {1.0276586348927793561600000e+20, 15, "102765863489277935616", 21},
  {2.2232231162364429189285547e-19, 3, "", -3},
  {7.2838698606318692951576037e-16, 19, "7284", -15},
  {2.5288741424782742187500000e+13, 6, "25288741424782742188", 14},
  {3.4684448119621925354003906e+09, 7, "34684448119621925", 10},
  {4.6694364874531740095746367e-14, 3, "", -3},
  {7.9842578651594120486834072e+00, 1, "8", 1},
  {1.3471086894850525768282035e-14, 16, "135", -13},
  {1.4893099091508327316623335e-10, 19, "1489309909", -9},
  {5.6247962568919792696027031e-20, 5, "", -5},
  {4.2271550138674360625485027e-12, 6, "", -6},
  {4.6661068260296678807043262e-18, 18, "5", -17},
  {4.4601631126006853152228952e-21, 5, "", -5},
  {1.7754021188682560023153201e+04, 1, "17754", 5},
  {1.7920880300301044553221711e-17, 5, "", -5},
  {5.3262647216542215744455666e-23, 17, "", -17},
  {1.1492097259094862080000000e+18, 3, "1149209725909486208", 19},
  {6.8116239159443283968000000e+19, 6, "68116239159443283968", 20},
  {3.9849842030614837646484375e+10, 10, "398498420306148376465", 11},
  {2.4533531177963293457031250e+11, 3, "245335311779633", 12},
  {1.8958198285900302886962891e+10, 4, "189581982859003", 11},
  {2.1463429544836152343750000e+13, 17, "2146342954483615234375", 14},
  {4.1170333977512431250000000e+14, 6, "4117033397751243125", 15},
  {1.2442853222352394649600000e+20, 19, "124428532223523946496", 21},
  {5.3372303016450332031250000e+12, 19, "5337230301645033203125", 13},
  {9.0418231296580682854776949e-07, 15, "904182313", -6},
  {3.3580578859396809598462771e-22, 13, "", -13},
  {2.9323506105819709599018097e+07, 20, "2932350610581970959901809692", 8},
  {1.5119030667772423437433815e-01, 6, "15119", 0},
  {2.5352285059761045254099928e-17, 14, "", -14},
  {3.2395365716300654296875000e+12, 20, "32395365716300654296875", 13},
  {1.2985129229011459648609161e+08, 4, "1298512922901", 9},
  {1.3691823106231722000000000e+16, 4, "13691823106231722", 17},
  {4.1339879156319287934488583e-09, 17, "413398792", -8},
  {1.0471180735461475677494902e-07, 15, "104711807", -6},
  {4.0430945003635653814572273e-25, 16, "", -16},
  {9.6871441800648208360668681e-21, 3, "", -3},
  {1.2810974378385708762756456e-03, 19, "12810974378385709", -2},
  {2.0427848111366251632490310e-17, 10, "", -10},
  {8.4062189651203124606843205e-08, 13, "840622", -7},
  {2.9373228902870482670550700e+03, 12, "2937322890287048", 4},
  {6.1747129244065448000000000e+16, 14, "61747129244065448", 17},
  {3.3002537258999229408118481e+00, 8, "330025373", 1},
  {1.3070299724075274089112042e-04, 9, "130703", -3},
  {3.1623842287813145048858132e+03, 17, "316238422878131450489", 4},
  {1.8595810255831245924520037e-12, 5, "", -5},
  {1.2455782384981024080161660e+01, 10, "12455782385", 2},
  {6.4185608267899224064000000e+19, 13, "64185608267899224064", 20},
  {6.1846200066026740000000000e+15, 3, "6184620006602674", 16},
  {4.3375300743524058263030837e-16, 11, "", -11},
  {4.2092305031963763758540154e+06, 12, "4209230503196376376", 7},
  {7.2240286794980121229972593e-07, 18, "72240286795", -6},
  {1.9112751316387385767085593e-25, 17, "", -17},
  {1.0210580114867608738471016e-07, 1, "", -1},
  {3.9900161820524269118507234e-25, 19, "", -19},
  {1.2489329773031205531204357e-04, 14, "12489329773", -3},
  {3.5348767167920350118492934e+01, 8, "3534876717", 2},
  {1.2322782843412622783240977e-17, 12, "", -12},
  {7.0310533367320483129902251e-08, 17, "7031053337", -7},
  {8.8674880129589181028800177e-07, 9, "887", -6},
  {4.2793753556937501584915087e-21, 15, "", -15},
  {1.3931107855857484491817778e-19, 0, "", 0},
  {3.9239379339371184999762854e-24, 15, "", -15},
  {1.9702264098439775407314301e+06, 15, "1970226409843977540731", 7},
  {2.3656996805211371978801532e-06, 18, "2365699680521", -5},
  {2.9430876818986735918051442e-09, 16, "29430877", -8},
  {8.2740234866810240000000000e+15, 1, "8274023486681024", 16},
  {1.9376834247779525756835938e+10, 14, "1937683424777952575683594", 11},
  {1.4537020995232148000000000e+16, 16, "14537020995232148", 17},
  {6.3102980562967675871172135e-04, 9, "63103", -3},
  {2.0508927880493887488000000e+19, 5, "20508927880493887488", 20},
  {5.7168446407586917281150818e+07, 3, "57168446408", 8},
  {3.3344480434997305274009705e+07, 6, "33344480434997", 8},
  {1.4878994263578152140800000e+20, 1, "148789942635781521408", 21},
  {1.3386931641168823611308591e-21, 7, "", -7},
  {6.2320010430861851215589022e-21, 18, "", -18},
  {9.3433066573201522943109553e-18, 9, "", -9},
  {2.2247878351094622611999512e+09, 11, "22247878351094622612", 10},
  {2.9491247279808925976785083e-03, 2, "", -2},
  {8.9428974989411167971446165e-22, 1, "", -1},
  {2.6078445366494483591961769e-15, 13, "", -13},
  {5.5057588634382765740156174e+06, 15, "5505758863438276574016", 7},
  {8.7835186293443198976000000e+20, 11, "87835186293443198976", 21},
  {1.1639144926659596200949065e-04, 1, "", -1},
  {6.1035462296418905045344724e-21, 11, "", -11},
  {1.6944272887830051013279000e-16, 7, "", -7},
  {3.2031770184697041511535645e+09, 6, "3203177018469704", 10},
  {2.4025969816273269564696480e-05, 5, "2", -4},
  {1.3375074400994415000000000e+15, 8, "13375074400994415", 16},
  {1.3708223626519819927631490e-07, 6, "", -6},
  {3.5667919067335770574816995e-10, 16, "3566792", -9},
  {1.8855103232626001549848465e-23, 8, "", -8},
  {1.8303264427782210093010936e-09, 1, "", -1},
  {3.0647769713826900734101731e-09, 19, "30647769714", -8},
  {4.4396507067313343952719151e+01, 12, "44396507067313", 2},
  {4.4686417231387289600000000e+18, 18, "446864172313872896", 19},
  {7.7546231103913181367107478e-19, 4, "", -4},
  {9.1284836357690347160813670e-21, 0, "", 0},
  {3.7858873605973258240000000e+18, 16, "3785887360597325824", 19},
  {2.3509132770183550781250000e+13, 14, "2350913277018355078125", 14},
  {1.8468761925990338560000000e+19, 7, "1846876192599033856", 20},
  {2.7577047723021215983624282e-22, 10, "", -10},
  {2.8256389538333176458806406e-02, 15, "28256389538333", -1},
  {2.4379436737047195167325271e-18, 17, "", -17},
  {9.2786240953563519928945173e-10, 2, "", -2},
  {3.8311638925825874018068594e-22, 12, "", -12},
  {4.8007291197291310138467457e-04, 18, "480072911972913", -3},
  {1.1850935062884120576000000e+19, 8, "11850935062884120576", 20},
  {2.3780980637137506771133480e-18, 11, "", -11},
  {2.9672595853771228027343750e+11, 5, "29672595853771228", 12},
  {2.3252078685861491507200000e+20, 8, "232520786858614915072", 21},
  {2.2509095220644166693091393e+06, 15, "2250909522064416669309", 7},
  {1.9992773388477321714162827e+05, 12, "199927733884773217", 6},
  {2.3162652249059543828479946e+05, 11, "23162652249059544", 6},
  {1.9086150641191551045107330e-08, 18, "19086150641", -7},
  {3.7037021422744896487617611e-11, 15, "37037", -10},
  {2.1869483346708555000000000e+15, 13, "21869483346708555", 16},
  {1.0311347279660655216617568e-15, 0, "", 0},
  {2.8412889240119036800000000e+17, 17, "284128892401190368", 18},
  {1.6373201364750501700021225e-24, 9, "", -9},
  {1.2292101867235700988769531e+11, 12, "122921018672357009887695", 12},
  {1.6354845750100547974170695e+01, 6, "16354846", 2},
  {7.5634462959101280256000000e+20, 7, "75634462959101280256", 21},
  {1.5942054574135215740819939e-18, 9, "", -9},
  {2.7593328448440193292239345e-06, 19, "2759332844844", -5},
  {6.6870801151156077294221765e-16, 15, "1", -14},
  {5.6072169986804289590061530e-18, 8, "", -8},
  {1.7357449568610425000000000e+15, 2, "17357449568610425", 16},
  {3.7524251783089222277758515e-15, 3, "", -3},
  {2.2171528728933542760314168e-25, 9, "", -9},
  {1.5572871763389979303332161e-15, 15, "2", -14},
  {9.3525567227608881817890740e-04, 11, "93525567", -3},
  {2.3743592181646291310082656e-14, 15, "24", -13},
  {2.0406396249959609111032888e-22, 17, "", -17},
  {1.0772530061726548671722412e+09, 9, "1077253006172654867", 10},
  {2.8600123368285836800000000e+17, 19, "286001233682858368", 18},
  {2.3739002126754404162056744e+05, 0, "23739", 6},
  {1.1009243400218786306510435e-07, 9, "11", -6},
  {4.7614100829312889795186654e-09, 0, "", 0},
  {5.7313467268500514328479767e+06, 14, "573134672685005143285", 7},
  {2.7198442671087960442361011e-14, 20, "2719844", -13},
  {2.9022320689792342491425403e-07, 8, "29", -6},
  {9.9394280625262182617187500e+11, 18, "993942806252621826171875", 12},
  {4.2146609972719389219930619e-03, 5, "421", -2},
  {2.4179275909676068245293476e-23, 18, "", -18},
  {6.1241129446188264873234253e-14, 5, "", -5},
  {3.2053671838159001600000000e+18, 12, "320536718381590016", 19},
  {2.2263869202881435000000000e+15, 3, "22263869202881435", 16},
  {4.6668026556427612411491207e-16, 18, "467", -15},
  {3.9903074008604529754123152e-20, 14, "", -14},
  {6.4287525200999430058336134e-06, 11, "642875", -5},
  {1.8357720805308467504346481e+01, 10, "183577208053", 2},
  {1.5675001016733449640690195e-10, 17, "15675001", -9},
  {2.0197255603398668599712806e-02, 11, "201972556", -1},
  {6.9900795598626176095571731e-19, 14, "", -14},
  {4.5137137520348313987200233e-19, 1, "", -1},
  {2.4198031506662492187500000e+13, 1, "241980315066625", 14},
  {2.8446004745950873941183090e+07, 8, "2844600474595087", 8},
  {1.1449777330181853983946424e-10, 20, "1144977733", -9},
  {7.3733496900599267664233984e-07, 18, "737334969006", -6},
  {3.1642555148314894202451107e-10, 15, "316426", -9},
  {6.8499251802679994596383559e-14, 13, "1", -12},
  {3.1124389638914786012854896e-04, 5, "31", -3},
  {1.8905052209273245324077187e-16, 17, "19", -15},
  {1.1112220565197720703125000e+13, 20, "11112220565197720703125", 14},
  {5.3031214890111448731020053e-09, 20, "530312148901", -8},
  {2.2561128303743333458397792e-23, 2, "", -2},
  {5.6154901457910720102400000e+20, 7, "561549014579107201024", 21},
  {1.5556332596562612831357881e-22, 8, "", -8},
  {4.6441266514697958642706122e-10, 16, "4644127", -9},
  {4.7265519340269729863244170e-09, 7, "", -7},
  {1.5403375041131537500000000e+15, 0, "1540337504113154", 16},
  {3.0645446134037742614746094e+09, 7, "30645446134037743", 10},
  {3.4292179618838324497299934e-19, 16, "", -16},
  {4.6882374088500390625000000e+11, 4, "4688237408850039", 12},
  {1.7690115716219507157802582e+07, 9, "17690115716219507", 8},
  {1.6855695689149200688916608e+02, 1, "1686", 3},
  {5.3477548778604516929782023e-14, 16, "535", -13},
  {6.0941361606033555456000000e+19, 2, "60941361606033555456", 20},
  {7.3568987541129924921559223e-14, 12, "", -12},
  {2.2260331751400752137268540e-12, 7, "", -7},
  {3.9788548689446176000000000e+17, 14, "39788548689446176", 18},
  {5.5964631249420840607783397e-11, 19, "559646312", -10},
  {3.6497779018138581886887550e+05, 13, "3649777901813858189", 6},
  {1.8970122983992004591302143e-21, 9, "", -9},
  {3.5479932414812942624848802e+03, 6, "3547993241", 4},
  {1.3201873222504377907224697e-23, 8, "", -8},
  {6.1676567647506832000000000e+16, 14, "61676567647506832", 17},
  {6.9978932343124825600000000e+17, 8, "699789323431248256", 18},
  {7.9045951319074232198124152e-19, 18, "1", -17},
  {2.0624491587296920779162202e-16, 6, "", -6},
  {8.3395031476513815818334130e-05, 9, "83395", -4},
  {1.3031264793166525972623049e+00, 19, "13031264793166525973", 1},
  {9.0554602317351559975697691e-23, 1, "", -1},
  {1.5766901707086149632000000e+19, 5, "15766901707086149632", 20},
  {6.7506987782455276384174769e-15, 12, "", -12},
  {8.8893566787390857224265904e-20, 1, "", -1},
  {1.3715023006061707830116291e-20, 20, "1", -19},
  {1.0965537864307543081145272e-10, 8, "", -8},
  {4.1570049365950032761396008e-25, 11, "", -11},
  {6.5704945603160943776166469e-03, 16, "65704945603161", -2},
  {1.7877659712119270630673242e-24, 13, "", -13},
  {1.0383706797865322806999972e-19, 18, "", -18},
  {3.8792499321571260225027800e+04, 1, "387925", 5},
  {7.6205824094247907400131226e+07, 14, "7620582409424790740013", 8},
  {2.7865777235468891124756108e-04, 15, "278657772355", -3},
  {2.7811290342612344829831272e+04, 16, "278112903426123448298", 5},
  {3.7161658599241714138984236e-07, 11, "37162", -6},
  {2.6193587994103903975633692e-11, 5, "", -5},
  {5.8826338760321282467337262e-15, 7, "", -7},
  {2.9973033649514168246241752e+03, 8, "299730336495", 4},
  {5.8272777677088724449276924e+06, 1, "58272778", 7},
  {1.2120787462931041015625000e+13, 10, "12120787462931041015625", 14},
  {1.8606363491364967210630172e-10, 15, "186064", -9},
  {3.5814514565604750926956090e-21, 11, "", -11},
  {7.5938820454941006975583975e-14, 7, "", -7},
  {1.8581796594294163366438075e-06, 16, "18581796594", -5},
  {9.6611120469528424406563326e-23, 5, "", -5},
  {3.7516220860200128299766220e+03, 16, "375162208602001283", 4},
  {1.9847206130769208073616028e+08, 11, "19847206130769208074", 9},
  {4.8605724128737362695532512e-18, 0, "", 0},
  {2.7612461389401878920931354e-10, 7, "", -7},
  {8.4633198776910296828563209e-08, 17, "8463319878", -7},
  {8.8617538497681721949819018e-21, 0, "", 0},
  {8.7428369114502662586649827e-10, 6, "", -6},
  {8.2333167649253356933593750e+10, 6, "82333167649253357", 11},
  {1.8749676899959283408113980e-16, 14, "", -14},
  {1.2277354411454472087743134e-11, 4, "", -4},
  {9.2868776394675650290275966e-21, 13, "", -13},
  {5.3442921972172521472000000e+20, 0, "53442921972172521472", 21},
  {4.6168872690253614284800000e+20, 13, "461688726902536142848", 21},
  {3.7586710758209330000000000e+15, 19, "3758671075820933", 16},
  {8.1823896408579183171247448e-13, 2, "", -2},
  {6.0062630869259100535552040e-06, 8, "601", -5},
  {1.3681095423391854640759430e-20, 3, "", -3},
  {7.2974867394750537350773811e+06, 20, "729748673947505373507738113", 7},
  {6.9710047599196729412764557e-14, 11, "", -11},
  {1.2299228721342963742005383e-22, 17, "", -17},
  {1.0355081426458277564961463e+05, 4, "1035508143", 6},
  {2.1553159677519445835969236e+01, 20, "2155315967751944583597", 2},
  {8.5758697542714267057824687e-22, 5, "", -5},
  {1.1389150752850557661624673e-22, 3, "", -3},
  {1.6358362447555817600000000e+17, 14, "163583624475558176", 18},
  {9.0531362050374664249829948e+03, 9, "9053136205037", 4},
  {3.9756248881934778958259271e-24, 10, "", -10},
  {8.3474506096146600000000000e+14, 10, "834745060961466", 15},
  {7.2212723723667898616351181e-20, 5, "", -5},
  {1.3543317617846210768834254e-09, 19, "13543317618", -8},
  {5.1025316941636003018851828e-22, 8, "", -8},
  {6.7612890312480811361206520e-16, 4, "", -4},
  {1.0996219626128656194664901e-04, 19, "1099621962612866", -3},
  {1.0503003528635716403200000e+20, 19, "105030035286357164032", 21},
  {5.2843088905363587760512866e-18, 9, "", -9},
  {1.3177863556800340880051050e-19, 15, "", -15},
  {1.4723180481792825791131918e+00, 13, "14723180481793", 1},
  {2.1360030301352028121570866e-07, 10, "2136", -6},
  {1.5182501531156018245383166e+04, 2, "151825", 5},
  {1.5623877774004546463024826e-14, 3, "", -3},
  {6.3979281581747392578125000e+12, 4, "63979281581747393", 13},
  {7.0024229616128943476383029e+00, 17, "700242296161289435", 1},
  {1.8284036031658132973648660e-18, 16, "", -16},
  {7.5308901695944872045629381e+00, 11, "753089016959", 1},
  {1.7055409040917913436889648e+10, 19, "170554090409179134368896484375", 11},
  {1.8654703685973497340455651e+05, 4, "1865470369", 6},
  {9.9096785491954053896375030e-08, 19, "99096785492", -7},
  {4.0023215546885114880000000e+18, 0, "4002321554688511488", 19},
  {2.8035818625399893229807751e-19, 15, "", -15},
  {1.0135610620264885073993355e+05, 19, "1013561062026488507399336", 6},
  {1.5741004681434451200000000e+17, 6, "157410046814344512", 18},
  {3.8483370677429425086302217e+03, 3, "3848337", 4},
  {4.1766596879095743588550249e+01, 8, "4176659688", 2},
  {1.7551652974976063868201051e-09, 5, "", -5},
  {3.0035599640433622260320975e-11, 19, "300355996", -10},
  {1.4860890386183604598045349e+08, 12, "14860890386183604598", 9},
  {9.8733871955519774720000000e+18, 15, "9873387195551977472", 19},
  {3.1593979729965154547244310e+04, 3, "3159398", 5},
  {9.4455843255105064599774778e+03, 5, "944558433", 4},
  {3.1437769274050789274419894e-12, 20, "314377693", -11},
  {4.6163310978543992456802147e-14, 12, "", -12},
  {1.8937318530433581542968750e+12, 16, "1893731853043358154296875", 13},
  {7.0014685858574221312000000e+19, 12, "70014685858574221312", 20},
  {6.8065550683583637692208868e+00, 4, "68066", 1},
  {4.1731513482359506436844261e-11, 2, "", -2},
  {1.2016394324360728920502495e-24, 11, "", -11},
  {3.4942838823994073088000000e+19, 8, "34942838823994073088", 20},
  {2.2083403376417070000000000e+15, 12, "2208340337641707", 16},
  {1.5967178946760895898217883e-19, 0, "", 0},
  {6.1376551187819130000000000e+15, 3, "6137655118781913", 16},
  {1.9200735318057176000000000e+16, 5, "19200735318057176", 17},
  {6.5823759485583193640536602e-14, 8, "", -8},
  {1.3783372508046973682560736e-16, 9, "", -9},
  {3.6234946122810652013868093e+05, 15, "362349461228106520139", 6},
  {1.5337936589765418506355288e-24, 8, "", -8},
  {4.2945651164917664265128355e-05, 13, "429456512", -4},
  {6.2297374108606815338134766e+08, 3, "622973741086", 9},
  {5.0925355769334815912203910e-07, 15, "509253558", -6},
  {1.4630241729306459892541170e+06, 9, "1463024172930646", 7},
  {1.4006053792275537920000000e+18, 4, "1400605379227553792", 19},
  {2.3700820284677168755686470e-11, 15, "23701", -10},
  {2.9732697960436032000000000e+16, 4, "29732697960436032", 17},
  {1.0585096635164875070091867e-04, 1, "", -1},
  {5.7829200345111884765625000e+12, 13, "57829200345111884765625", 13},
  {1.7734019853826236121953352e-04, 16, "1773401985383", -3},
  {4.3652824549974174499511719e+09, 7, "43652824549974174", 10},
  {3.5511009120040168713756753e-22, 18, "", -18},
  {1.6552486268300906250000000e+14, 10, "1655248626830090625", 15},
  {4.5564159628006909042596817e+05, 19, "4556415962800690904259682", 6},
  {4.2958086621235237121582031e+10, 4, "429580866212352", 11},
  {1.9231897062803437873680645e-04, 13, "1923189706", -3},
  {1.2433256988975417334586382e+05, 3, "12433257", 6},
  {5.4185496346397828980083175e-09, 17, "541854963", -8},
  {1.8365021688288728301059917e-25, 4, "", -4},
  {6.4741404151310377120971680e+09, 17, "647414041513103771209716797", 10},
  {3.1679242909230729565024376e+06, 1, "31679243", 7},
  {6.2129816800509633903502660e-25, 1, "", -1},
  {6.0840988633601136825745925e+03, 19, "60840988633601136825746", 4},
  {1.3322918563233520217181649e+02, 19, "1332291856323352021718", 3},
  {3.9205790526518368665600000e+20, 9, "392057905265183686656", 21},
  {1.0116303990463903850870037e-16, 12, "", -12},
  {7.4426502829477301927742770e-24, 20, "", -20},
  {5.2768747847877577932800000e+20, 6, "527687478478775779328", 21},
  {1.6716919292743171691894531e+10, 7, "167169192927431717", 11},
  {2.6708393155038167968750000e+13, 19, "2670839315503816796875", 14},
  {3.1562334382571778048000000e+19, 3, "31562334382571778048", 20},
  {8.1479046434216842989181877e-07, 14, "81479046", -6},
  {1.1564379646898309147218242e+04, 2, "1156438", 5},
  {7.5697857331631164257146338e+00, 1, "76", 1},
  {4.6377602375054934389955979e-07, 10, "4638", -6},
  {3.9301701571085828542709351e+08, 5, "39301701571086", 9},
  {3.8644060724266019987086572e-22, 2, "", -2},
  {6.0005493199555541992187500e+10, 12, "60005493199555541992188", 11},
  {1.7155782793202372336904826e-03, 6, "1716", -2},
  {8.6006212573993745555071388e-07, 17, "86006212574", -6},
  {6.3234622490537862777709961e+09, 6, "6323462249053786", 10},
  {4.1603589558438479762688528e-19, 1, "", -1},
  {9.8100125678837392000000000e+16, 0, "98100125678837392", 17},
  {2.8404773535421121778199449e+04, 13, "284047735354211218", 5},
  {5.8247569127310620578610475e-23, 5, "", -5},
  {3.8744591927636433865700383e+03, 14, "387445919276364339", 4},
  {1.3052387047831509950257534e-02, 17, "1305238704783151", -1},
  {3.7368719916969448378482312e-14, 13, "", -13},
  {3.4875823376263984375000000e+12, 13, "34875823376263984375", 13},
  {5.7015133278155395507812500e+11, 0, "570151332782", 12},
  {4.7203671102645980000000000e+15, 2, "4720367110264598", 16},
  {6.8745589911539040141622342e-14, 17, "6875", -13},
  {8.7395678722806107580067803e-03, 17, "873956787228061", -2},
  {4.3361659846773538816000000e+20, 20, "43361659846773538816", 21},
  {5.6259138617685309993101111e-18, 5, "", -5},
  {2.5198473091942927360000000e+18, 13, "2519847309194292736", 19},
  {5.5213221814962207294827113e-21, 16, "", -16},
  {8.6360839696905337514313934e-14, 7, "", -7},
  {2.6155151269423316992000000e+20, 16, "26155151269423316992", 21},
  {3.3011187035359907150268555e+09, 9, "3301118703535990715", 10},
  {1.2767850893595513958080068e-05, 4, "", -4},
  {1.4496146689602163932109543e-23, 18, "", -18},
  {2.8100576620321207854909997e-20, 7, "", -7},
  {4.0872794170764900627546012e+03, 18, "4087279417076490062755", 4},
  {3.0192453151156129750150941e-21, 14, "", -14},
  {4.0009904375332130928252328e-16, 1, "", -1},
  {8.7022764279695965020100523e-04, 14, "8702276428", -3},
  {7.2385225300500009026904991e+00, 18, "7238522530050000903", 1},
  {1.7183133004326375470327548e+01, 16, "171831330043263755", 2},
  {6.2443748702628291015625000e+12, 9, "6244374870262829101563", 13},
  {7.2759073887839281269407365e+02, 4, "7275907", 3},
  {1.0594573604974099522789633e-16, 8, "", -8},
  {3.1181383858641132993668265e-14, 1, "", -1},
  {5.2655895315887322246511948e-05, 18, "52655895315887", -4},
  {9.2488692585894410530716230e-15, 6, "", -6},
  {4.4295818162156082689762115e+05, 18, "442958181621560826897621", 6},
  {5.7625352225490305024000000e+19, 16, "57625352225490305024", 20},
  {4.7024917709878413006663322e+04, 7, "470249177099", 5},
  {1.7285135893492311616432373e-06, 18, "1728513589349", -5},
  {2.0303854394153520126256032e-07, 1, "", -1},
  {2.4563972864847552031278610e+07, 16, "245639728648475520312786", 8},
  {2.6456302423154130944000000e+19, 20, "26456302423154130944", 20},
  {5.7228376881195070000000000e+15, 5, "5722837688119507", 16},
  {3.8101911832240440000000000e+15, 19, "3810191183224044", 16},
  {1.1493934106114968311831960e-23, 7, "", -7},
  {1.7387716380106070425600000e+20, 7, "173877163801060704256", 21},
  {1.9375090447425715027066242e-17, 13, "", -13},
  {1.5994344468287847121246159e+05, 19, "1599434446828784712124616", 6},
  {2.2177691187007075013462437e-17, 15, "", -15},
  {4.7038513579045764160156250e+11, 11, "47038513579045764160156", 12},
  {9.1458634400307295027200000e+20, 2, "914586344003072950272", 21},
  {4.8806807791955777228037894e-04, 6, "488", -3},
  {7.8050271421191394329071045e+07, 19, "780502714211913943290710449", 8},
  {4.6657885267121025663072942e+02, 15, "466578852671210257", 3},
  {5.5286090984854875840117509e-24, 8, "", -8},
  {9.9397028606123640201985836e+03, 2, "99397", 4},
  {1.0625214118256101961389115e-09, 7, "", -7},
  {2.2632761134954593067799178e-10, 9, "", -9},
  {5.2343060553809306640625000e+12, 1, "52343060553809", 13},
  {1.4699709943872413406349401e-08, 17, "1469970994", -7},
  {1.0272227019434651136398315e+09, 8, "102722270194346511", 10},
  {4.9924233497315416897611448e-19, 14, "", -14},
  {2.6373064734940565625000000e+14, 8, "26373064734940565625", 15},
  {2.8618414969327228000000000e+16, 14, "28618414969327228", 17},
  {1.7324173728862681891769171e+06, 2, "173241737", 7},
  {1.2129216241144410168432468e-14, 11, "", -11},
  {5.5868544435162921029714969e-13, 12, "1", -11},
  {1.1518201910770333984375000e+13, 16, "11518201910770333984375", 14},
  {4.0251948215065482476133572e-25, 20, "", -20},
  {2.8336030462661319065600000e+20, 5, "283360304626613190656", 21},
  {1.7101736976902797793972121e-12, 1, "", -1},
  {9.8278083150580108906524401e+00, 18, "9827808315058010891", 1},
  {1.9439516506292196589804516e-14, 13, "", -13},
  {4.6239217593245173338800669e+05, 7, "4623921759325", 6},
  {2.0614275289887230396270752e+09, 16, "20614275289887230396270752", 10},
  {5.8165433916885669355729049e-07, 14, "58165434", -6},
  {1.8471064119105404037271267e-13, 6, "", -6},
  {4.1400992743600582400000000e+17, 6, "414009927436005824", 18},
  {4.9828565383078657760052010e+03, 7, "49828565383", 4},
  {5.0658357958786226562500000e+13, 3, "50658357958786227", 14},
  {6.2864026911917080833212654e-18, 17, "1", -16},
  {3.1776799990037773841597290e-19, 15, "", -15},
  {5.3439631465986109375000000e+13, 8, "53439631465986109375", 14},
  {1.6244075005385520000000000e+16, 14, "1624407500538552", 17},
  {1.8747291365325884360260034e+00, 16, "18747291365325884", 1},
  {3.2872508446008872690686277e-14, 12, "", -12},
  {8.1574799862234470400000000e+18, 2, "815747998622344704", 19},
  {4.9439477678832236026078514e-23, 19, "", -19},
  {4.5203522155358560000000000e+15, 0, "4520352215535856", 16},
  {3.6797164056586877441406250e+11, 12, "367971640565868774414063", 12},
  {3.7650497567851218750000000e+14, 15, "3765049756785121875", 15},
  {5.3798249912035958784000000e+19, 15, "53798249912035958784", 20},
  {2.8334224969960147381693293e-06, 7, "28", -5},
  {2.3319704226851376006379724e+04, 11, "2331970422685138", 5},
  {2.2490837703027529715111198e-11, 5, "", -5},
  {1.4490522785920834536455004e+01, 4, "144905", 2},
  {8.7145432129139458019180531e-05, 5, "9", -4},
  {1.3494119179883516211683252e-14, 12, "", -12},
  {7.1637211764937038421630859e+09, 5, "71637211764937", 10},
  {4.5896117441152666150235582e-19, 8, "", -8},
  {2.7423667249794613258104259e-04, 8, "27424", -3},
  {1.1314346841183286574479296e-11, 13, "113", -10},
  {7.0780871499589617388445684e-10, 14, "70781", -9},
  {1.6950952625209293910302222e+05, 14, "1695095262520929391", 6},
  {1.1429372417569307294656137e-12, 12, "1", -11},
  {2.4331670271018133744876713e-25, 10, "", -10},
  {5.1418632770663175137007606e-09, 7, "", -7},
  {1.2373634864678350447470084e-17, 17, "1", -16},
  {2.5311052374221172183752060e+07, 17, "2531105237422117218375206", 8},
  {4.1510792559325532056391239e+05, 6, "415107925593", 6},
  {1.9291938517194069802298835e-25, 6, "", -6},
  {9.9696477169191631104300869e-15, 4, "", -4},
  {2.6765252250574924630655005e+00, 8, "267652523", 1},
  {3.9313322786334192748824989e+00, 17, "393133227863341927", 1},
  {1.2708895999300755200000000e+17, 1, "127088959993007552", 18},
  {3.9754635731919894293610042e-19, 5, "", -5},
  {2.4308508730654594387488032e+01, 20, "2430850873065459438749", 2},
  {1.0994775315666564062500000e+14, 2, "10994775315666564", 15},
  {3.8652213808953741706823537e-09, 12, "3865", -8},
  {2.3950703720489873057002822e-05, 8, "2395", -4},
  {2.3859695242459926234346312e+00, 1, "24", 1},
  {9.8937532401654251098632812e+10, 12, "98937532401654251098633", 11},
  {1.7544017346529920101165771e+09, 2, "175440173465", 10},
  {1.9042849854662563302554190e+03, 10, "19042849854663", 4},
  {6.9524941022913483868600482e-04, 3, "1", -2},
  {9.9332531337674231605509603e-25, 2, "", -2},
  {1.9349103578857080258968939e-07, 19, "1934910357886", -6},
  {5.4416072546931533813476562e+10, 8, "5441607254693153381", 11},
  {1.3241396356767470360239118e-17, 7, "", -7},
  {2.7949820024906479075365897e-12, 16, "2795", -11},
  {6.9107187559996514636395659e+00, 7, "69107188", 1},
  {1.9469245480623083209494004e-11, 20, "1946924548", -10},
  {2.3195278589321062304902833e-18, 14, "", -14},
  {1.2800947044570537400431931e+04, 8, "1280094704457", 5},
  {2.1148129568653953075408936e+08, 0, "211481296", 9},
  {2.6583409912326884079816769e-04, 16, "2658340991233", -3},
  {4.0891478454953992594574780e-05, 2, "", -2},
  {1.0736168412349632568359375e+12, 5, "107361684123496326", 13},
  {1.0540624474268803125000000e+14, 12, "10540624474268803125", 15},
  {3.9587329131677946245932546e-15, 14, "", -14},
  {6.0572243954229504000000000e+17, 14, "60572243954229504", 18},
  {6.9351441180550502400000000e+17, 11, "693514411805505024", 18},
  {7.3510167791842141014058143e+03, 5, "735101678", 4},
  {4.3925142098499279086354363e+00, 12, "439251420985", 1},
  {7.0680863850833752604591873e-21, 2, "", -2},
  {7.2116685436432051772848162e-03, 11, "721166854", -2},
  {4.2568714386655820414162577e-01, 4, "4257", 0},
  {7.4294536793367201462388039e+06, 1, "74294537", 7},
  {3.5916724959725929091939391e-20, 1, "", -1},
  {1.0290477938974029824000000e+19, 20, "10290477938974029824", 20},
  {1.0131705041848251342773438e+11, 11, "10131705041848251342773", 12},
  {3.7203729864368769995053299e+03, 18, "3720372986436876999505", 4},
  {1.3629564529235437512397766e+06, 10, "13629564529235438", 7},
  {7.3335855624078430992085487e+03, 17, "733358556240784309921", 4},
  {9.0213110010379447436205887e-17, 8, "", -8},
  {1.4115231475530913042570891e-03, 14, "141152314755", -2},
  {7.8305020376419784545898438e+10, 19, "783050203764197845458984375", 11},
  {2.4740225112108522154130696e+01, 19, "247402251121085221541", 2},
  {2.3707288640072952000000000e+16, 4, "23707288640072952", 17},
  {4.7770273021746442240000000e+18, 16, "4777027302174644224", 19},
  {1.9886172669490935802459717e+09, 5, "198861726694909", 10},
  {3.6433871166247973526395391e-13, 12, "", -12},
  {7.9594639121431446075439453e+09, 2, "795946391214", 10},
  {1.1127755935494142799042564e-07, 7, "1", -6},
  {1.6124340509210785614107232e-19, 6, "", -6},
  {1.4137107957770800163201097e-04, 10, "1413711", -3},
  {8.0579051872800037500790080e-15, 11, "", -11},
  {9.4099574425726151272186826e-01, 4, "941", 0},
  {2.0339241231581322145199208e-19, 10, "", -10},
  {5.7298213846552073772324415e-09, 2, "", -2},
  {6.9019932900331322859156490e-21, 13, "", -13},
  {2.2499721000382396800000000e+17, 2, "224997210003823968", 18},
  {1.6941492591617337893694639e+04, 11, "1694149259161734", 5},
  {9.9697580395525187220879188e-15, 13, "", -13},
  {1.4265180164689762977377373e-09, 8, "", -8},
  {6.3684274880032035071053542e+02, 11, "63684274880032", 3},
  {1.2814407654646840000000000e+17, 11, "1281440765464684", 18},
  {6.6390383321801860125997075e-20, 13, "", -13},
  {2.1292185018128549880915099e-21, 1, "", -1},
  {3.1088804176750575252824406e-07, 5, "", -5},
  {2.4726213248674171447753906e+10, 6, "24726213248674171", 11},
  {8.5415174543178321499473195e-23, 5, "", -5},
  {3.6318722708829001224467357e-25, 5, "", -5},
  {1.7791891990480687701925433e-02, 11, "1779189199", -1},
  {4.5626666249933448852971196e+05, 4, "4562666625", 6},
  {3.1877645537211901730252958e-19, 18, "", -18},
  {2.2676608249097202942012874e-03, 4, "23", -2},
  {4.2537460865116580072294028e-05, 11, "4253746", -4},
  {2.2985656813784022233448923e+04, 16, "229856568137840222334", 5},
  {3.3648016404446899894388748e-10, 2, "", -2},
  {1.2517605584996052692225987e-02, 16, "125176055849961", -1},
  {5.3753349465387147359904662e-12, 18, "5375335", -11},
  {9.4712585799000883780506140e-11, 3, "", -3},
  {3.8715543504230872971944960e-11, 13, "387", -10},
  {1.1114492745538392455955385e-23, 4, "", -4},
  {1.7961893004122362338392804e+00, 16, "17961893004122362", 1},
  {1.6583946910864875091852171e-19, 4, "", -4},
  {1.2035217981951319040000000e+18, 20, "1203521798195131904", 19},
  {7.9583036002167120000000000e+16, 14, "7958303600216712", 17},
  {1.6750665070136674929488437e-12, 8, "", -8},
  {4.2287424944878041562867345e-15, 0, "", 0},
  {1.1398228318617398400000000e+17, 18, "113982283186173984", 18},
  {3.3764527138029044875984311e-17, 2, "", -2},
  {3.3383300964802105468750000e+13, 14, "3338330096480210546875", 14},
  {4.6648934872540801763534546e+07, 16, "466489348725408017635345", 8},
  {1.0629877307516786931763419e-15, 2, "", -2},
  {2.2316363343117078766226768e+06, 9, "2231636334311708", 7},
  {1.7824501389936357736587524e+06, 8, "178245013899364", 7},
  {1.9689165786483153541347737e-14, 19, "196892", -13},
  {5.3876643806904561242840823e-22, 17, "", -17},
  {1.8812324395498553797112561e-06, 0, "", 0},
  {1.8475716558496713126658051e+00, 13, "18475716558497", 1},
  {4.8053707203452719841152430e+05, 18, "480537072034527198411524", 6},
  {1.8062721917101083726738599e-22, 20, "", -20},
  {4.8467076249121368164196610e+05, 11, "48467076249121368", 6},
  {6.9527231655897861346602440e+06, 2, "695272317", 7},
  {7.4639497569313620126666543e-15, 9, "", -9},
  {1.9786095086009365167786157e-13, 18, "197861", -12},
  {1.9600991771708361393125597e-04, 7, "196", -3},
  {1.4896187720967071603517251e-03, 3, "1", -2},
  {5.7017553053075059083228578e-16, 4, "", -4},
  {3.7823449607785559154450279e-13, 0, "", 0},
  {1.5620738087445446777343750e+11, 3, "156207380874454", 12},
  {2.3215670425317008924992468e-03, 0, "", 0},
  {3.2587923455271184427651501e-09, 9, "3", -8},
  {8.9268523533607795635035654e-14, 0, "", 0},
  {8.2400505538802031046925261e-14, 15, "82", -13},
  {7.9685397939372251130407676e+00, 10, "79685397939", 1},
  {1.0087032230915708623797400e+03, 5, "100870322", 4},
  {5.3551356874421499014715664e+03, 3, "5355136", 4},
  {5.2493430984794619140625000e+12, 13, "52493430984794619140625", 13},
  {1.1123589482110426642182723e-07, 20, "1112358948211", -6},
  {9.2407963733306460000000000e+15, 17, "9240796373330646", 16},
  {1.9850921307249368012675041e-12, 19, "19850921", -11},
  {3.4943926693433439731597900e+08, 15, "349439266934334397315979", 9},
  {1.5734257427299350173832693e-02, 3, "16", -1},
  {1.1669513142356666607093489e-08, 7, "", -7},
  {2.2436632380629639680000000e+18, 11, "2243663238062963968", 19},
  {5.4710103524425768960000000e+18, 11, "5471010352442576896", 19},
  {2.8178531523722103601745244e-07, 14, "28178532", -6},
  {7.7346806897811177117924020e-04, 20, "77346806897811177", -3},
  {4.9692335412467985153198242e+09, 10, "49692335412467985153", 10},
  {1.1848837514614409763706079e-11, 19, "118488375", -10},
  {9.6681477726427473839976301e+01, 8, "9668147773", 2},
  {8.5227908954550502597866815e-14, 2, "", -2},
  {2.3288775409656805079820329e-07, 14, "23288775", -6},
  {5.9457691148442339897155762e+08, 16, "5945769114844233989715576", 9},
  {5.9259835866241376953125000e+12, 0, "5925983586624", 13},
  {1.6554292314986430464000000e+20, 4, "16554292314986430464", 21},
  {1.0854133345576141844723850e-01, 8, "10854133", 0},
  {8.4837945506995390000000000e+15, 3, "8483794550699539", 16},
  {6.2122222713848537458384718e-25, 16, "", -16},
  {8.5635649492890630000000000e+15, 5, "8563564949289063", 16},
  {2.0839899473070204374142156e-04, 20, "20839899473070204", -3},
  {8.8511289285699248000000000e+16, 14, "88511289285699248", 17},
  {4.3662771044311828039230505e-02, 11, "4366277104", -1},
  {2.7930419840676846504211426e+09, 11, "279304198406768465042", 10},
  {6.3541623842656030000000000e+15, 6, "6354162384265603", 16},
  {3.1354593197642295837402344e+10, 15, "31354593197642295837402344", 11},
  {3.0195004160402980000000000e+16, 1, "3019500416040298", 17},
  {1.7520206453518011995326324e-25, 7, "", -7},
  {4.4078108829699398255051603e-25, 5, "", -5},
  {3.6620787254135254151776735e+00, 16, "36620787254135254", 1},
  {3.0936960194989458007812500e+12, 14, "309369601949894580078125", 13},
  {4.8381348060049227111090175e-02, 14, "4838134806005", -1},
  {2.1303912040981003883644007e+03, 4, "21303912", 4},
  {1.8837256512062856250000000e+14, 2, "18837256512062856", 15},
  {5.4282616188881453126668930e+05, 17, "54282616188881453126669", 6},
  {3.3210902390727608235465595e+02, 4, "332109", 3},
  {3.7766957343558919097366441e-16, 6, "", -6},
  {1.2247007636932963132858276e+08, 9, "122470076369329631", 9},
  {3.5243848278467993736267090e+09, 14, "352438482784679937362671", 10},
  {9.9153302530874861816778916e-14, 8, "", -8},
  {3.5174360533199821969574383e-03, 16, "351743605332", -2},
  {1.7432487669466718000000000e+16, 1, "17432487669466718", 17},
  {4.5751790562830193290203745e-13, 3, "", -3},
  {3.9652139661294019222259521e+08, 11, "39652139661294019222", 9},
  {7.3482299628600098816000000e+20, 2, "73482299628600098816", 21},
  {8.1237694292634396262400000e+20, 3, "812376942926343962624", 21},
  {4.7656759377559552162002239e-19, 16, "", -16},
  {1.2704435424678090494126081e+06, 8, "127044354246781", 7},
  {5.4104775427314680193331686e-05, 6, "54", -4},
  {2.5709892922509254731266992e+01, 2, "2571", 2},
  {1.1576400621373978257179260e+08, 4, "1157640062137", 9},
  {3.1232015450694999040000000e+18, 6, "3123201545069499904", 19},
  {3.9403915660059446679497341e+01, 2, "394", 2},
  {4.8447191614352035733334634e-04, 4, "5", -3},
  {1.4124776634790945509659401e-09, 1, "", -1},
  {9.6805760566812636583300793e-11, 14, "9681", -10},
  {1.1709402135121567174792290e+07, 13, "117094021351215671748", 8},
  {3.6688957223123763365577757e-22, 17, "", -17},
  {1.6534601604236371232545233e-09, 13, "16535", -8},
  {1.5726027800579538162319138e-05, 5, "2", -4},
  {3.2426001544827423022786424e-06, 8, "324", -5},
  {3.1158175589719448238611221e+07, 9, "31158175589719448", 8},
  {5.7394046277713424682617188e+10, 0, "57394046278", 11},
  {1.1875679975867474378777073e-16, 16, "1", -15},
  {2.9148184792397258112381967e-10, 3, "", -3},
  {7.6811732225409887000641235e-21, 4, "", -4},
  {8.6577996472445401600000000e+17, 8, "865779964724454016", 18},
  {8.0045169642522345472000000e+19, 3, "80045169642522345472", 20},
  {1.2598835385379958680433613e-24, 19, "", -19},
  {2.4249596152833379704355507e-08, 18, "24249596153", -7},
  {4.2648564073397017600000000e+18, 16, "426485640733970176", 19},
  {3.8594115076412831513152923e+03, 11, "385941150764128", 4},
  {1.0227122182801589369773865e+08, 0, "102271222", 9},
  {2.8196990742772950274128256e-13, 3, "", -3},
  {3.1805284300541558784000000e+20, 9, "31805284300541558784", 21},
  {3.3202665615503771785722612e-22, 5, "", -5},
  {5.0704860377944358811243302e-08, 4, "", -4},
  {1.3014484527213314535200766e-21, 3, "", -3},
  {3.7093043104717285230266889e-12, 10, "", -10},
  {3.8603765816549092717332681e-24, 6, "", -6},
  {1.9931350336395170508296815e+00, 4, "19931", 1},
  {1.7136079145543708000332117e+06, 6, "1713607914554", 7},
  {4.8949308932511473207724335e-14, 18, "48949", -13},
  {2.2041488352419272289672847e-03, 13, "22041488352", -2},
  {1.2384180624398107877602777e-24, 5, "", -5},
  {9.4803519938826062011718750e+11, 5, "94803519938826062", 12},
  {4.7815971868229913600000000e+17, 10, "478159718682299136", 18},
  {2.8990645841084638671875000e+12, 13, "28990645841084638671875", 13},
  {3.8649919231127619783684735e-06, 16, "38649919231", -5},
  {4.0503070370652690529823303e+07, 3, "40503070371", 8},
  {2.7104406714666692608000000e+19, 9, "27104406714666692608", 20},
  {1.3077315638871783390641212e+07, 0, "13077316", 8},
  {8.4155697059380126953125000e+12, 0, "8415569705938", 13},
  {4.8441102657243355545600000e+20, 11, "484411026572433555456", 21},
  {3.7545668511210550000000000e+14, 7, "3754566851121055", 15},
  {2.1702982955824050000000000e+14, 16, "2170298295582405", 15},
  {4.9212981009111688181703869e-08, 14, "4921298", -7},
  {2.8118446573020159121369943e+04, 1, "281184", 5},
  {8.2509040735886932373046875e+10, 19, "82509040735886932373046875", 11},
  {1.1386080750741424039006233e+07, 13, "11386080750741424039", 8},
  {5.5737794113478386402130127e+08, 1, "5573779411", 9},
  {7.0634102748565950000000000e+14, 8, "7063410274856595", 15},
  {1.2772893182376647949218750e+10, 14, "1277289318237664794921875", 11},
  {1.8651629166540629039575084e-07, 19, "1865162916654", -6},
  {1.6557896874163112492316747e-06, 10, "16558", -5},
  {3.0904903289791868649655755e-16, 9, "", -9},
  {8.6003602286142722732620314e+02, 17, "86003602286142722733", 3},
  {4.3984530305168599287921358e-25, 14, "", -14},
  {2.0079719512664564717852045e+03, 12, "2007971951266456", 4},
  {3.6556681028527278587769638e-17, 20, "3656", -16},
  {4.2210772674369337600000000e+17, 15, "422107726743693376", 18},
  {9.2888695583791300654411316e+07, 11, "9288869558379130065", 8},
  {3.8335529481184033387788518e-11, 3, "", -3},
  {1.7414216274071307068958954e-22, 3, "", -3},
  {2.9892431060981226562500000e+13, 6, "29892431060981226563", 14},
  {1.6674928849214668750000000e+14, 17, "1667492884921466875", 15},
  {1.1021167858988531494140625e+11, 10, "1102116785898853149414", 12},
  {9.6273881049885144809003299e-14, 19, "962739", -13},
  {9.3698853378690984072818537e+01, 14, "9369885337869098", 2},
  {5.6808622535774149000644684e+07, 0, "56808623", 8},
  {4.3270899871833304374965557e-09, 10, "43", -8},
  {3.2733571181988920795907750e-14, 18, "32734", -13},
  {3.3430163717894829745050265e-25, 19, "", -19},
  {1.5146291339191464033355589e-11, 16, "151463", -10},
  {1.9736883203890322547053405e-11, 16, "197369", -10},
  {7.1581961593488520000000000e+15, 7, "7158196159348852", 16},
  {1.6959001360970522576110397e+00, 11, "16959001361", 1},
  {2.2309180544714379310607910e+09, 13, "22309180544714379310608", 10},
  {3.2919119793196910088474216e-16, 1, "", -1},
  {6.7549671649221407593069713e-13, 3, "", -3},
  {1.2728856618534101048591418e-05, 2, "", -2},
  {3.0220190555058666027536338e-22, 16, "", -16},
  {1.3336511058868375925495801e-14, 6, "", -6},
  {7.0700952410284655761718750e+11, 7, "7070095241028465576", 12},
  {1.9361191111579360756262769e-07, 17, "19361191112", -6},
  {1.5381771564652920044301287e-04, 4, "2", -3},
  {8.1145445982028566178634321e-05, 11, "8114545", -4},
  {1.1935993553164186419200000e+20, 19, "119359935531641864192", 21},
  {1.3726170271036064354612527e-04, 5, "14", -3},
  {1.8135407100361089750712160e-20, 14, "", -14},
  {5.7910874874788515269756317e+07, 17, "5791087487478851526975632", 8},
  {4.9889498931103003996514455e-12, 6, "", -6},
  {2.3701886169453072384000000e+19, 6, "23701886169453072384", 20},
  {1.2889491292173838044021750e+00, 9, "1288949129", 1},
  {9.9468456555837440000000000e+16, 16, "9946845655583744", 17},
  {5.1136858738982591603416950e+04, 1, "511369", 5},
  {1.2117169032828537898221447e-15, 2, "", -2},
  {4.0937318198451208041410698e-04, 12, "409373182", -3},
  {6.5274814184612523437500000e+13, 14, "652748141846125234375", 14},
  {4.4137175119405582547187805e+07, 12, "44137175119405582547", 8},
  {1.4695881822001784763675759e-23, 1, "", -1},
  {8.6899564301744084467843399e-04, 14, "86899564302", -3},
  {1.3051859085517569283281227e-14, 12, "", -12},
  {2.2768047738317176832000000e+19, 14, "22768047738317176832", 20},
  {2.4785401234384195713251622e-11, 12, "25", -10},
  {3.0522073811177531155180986e+01, 1, "305", 2},
  {7.3852695632506550711335325e-05, 9, "73853", -4},
  {1.7972160036390643666115023e-20, 17, "", -17},
  {8.8126628840286463499069214e+07, 13, "881266288402864634991", 8},
  {2.3403796664041471667587757e+06, 9, "2340379666404147", 7},
  {1.0786727600424261061671668e-24, 10, "", -10},
  {1.6372405094635365530848503e+07, 11, "1637240509463536553", 8},
  {3.8221212607914274543563504e-03, 12, "3822121261", -2},
  {1.3486427845400562509894371e+06, 1, "13486428", 7},
  {2.7089846482132367605402245e-06, 6, "3", -5},
  {5.3560125479850312357754660e-02, 7, "535601", -1},
  {6.6214392475101592532626699e-15, 10, "", -10},
  {1.2038816453942826038150627e-23, 5, "", -5},
  {6.2081954765887660000000000e+15, 19, "6208195476588766", 16},
  {5.5348773098327140808105469e+09, 1, "55348773098", 10},
  {2.4847659167532918123968775e-10, 6, "", -6},
  {2.4923984142610098998838927e-25, 18, "", -18},
  {3.9195462734958781690959657e-10, 19, "3919546273", -9},
  {9.7006959295369815081357956e+06, 13, "97006959295369815081", 7},
  {8.6481597148005396127700806e+07, 1, "864815971", 8},
  {5.1632348288287213115177922e-20, 5, "", -5},
  {1.0920516991244106554313713e-24, 5, "", -5},
  {1.1484458560760790746257953e-01, 4, "1148", 0},
  {5.0424258357158197021484375e+11, 4, "504242583571582", 12},
  {3.5549225015297123420054959e+00, 8, "35549225", 1},
  {8.0303086702480763196945190e+07, 9, "80303086702480763", 8},
  {3.3679907268168244627304375e+04, 8, "3367990726817", 5},
  {1.5380577900857684235113696e-22, 16, "", -16},
  {6.2925541753575994257980506e-15, 9, "", -9},
  {3.2118239564730325459565802e-16, 15, "", -15},
  {3.3059810735940626022400000e+20, 13, "330598107359406260224", 21},
  {7.6637106517516880000000000e+15, 10, "7663710651751688", 16},
  {7.7649414062952253345883946e+00, 3, "7765", 1},
  {1.1638556344926789940596607e-24, 12, "", -12},
  {1.8147097036133879718063631e-20, 12, "", -12},
  {1.2611834776070795487612486e+05, 15, "126118347760707954876", 6},
  {7.5792609786941390389107226e-20, 5, "", -5},
  {1.5246930328623593179742564e-22, 16, "", -16},
  {6.5810907410622377211668426e-22, 19, "", -19},
  {1.7535953781286467661852668e-04, 0, "", 0},
  {1.4129300218793557075702694e-02, 3, "14", -1},
  {5.1517063638878204608455403e-14, 0, "", 0},
  {5.0604861765375219726562500e+11, 17, "506048617653752197265625", 12},
  {8.6878953648526296019554138e+06, 2, "868789536", 7},
  {1.1072369759793317480835946e-11, 13, "111", -10},
  {1.8075547947641406840182018e-08, 19, "180755479476", -7},
  {2.0175849978557321207053892e-08, 13, "201758", -7},
  {9.4815149991908374005333826e+00, 2, "948", 1},
  {6.8127736584754233344000000e+20, 6, "68127736584754233344", 21},
  {4.4680340673473302740603685e+05, 12, "446803406734733027", 6},
  {7.1627264425625004853682477e-08, 5, "", -5},
  {1.3139986232759784000000000e+17, 5, "13139986232759784", 18},
  {1.2432602242802737180227268e+01, 19, "124326022428027371802", 2},
  {1.1397165960832008000000000e+17, 12, "11397165960832008", 18},
  {1.7678387976045770969382698e-11, 9, "", -9},
  {4.1998695905787020166144430e+00, 17, "419986959057870202", 1},
  {1.1454249073000531196594238e+09, 16, "11454249073000531196594238", 10},
  {1.6855207988156594203390100e-22, 16, "", -16},
  {6.0266593213844420388340950e+06, 14, "602665932138444203883", 7},
  {1.0313908454085521952947602e+04, 6, "10313908454", 5},
  {2.1157773115376867737600000e+20, 8, "211577731153768677376", 21},
  {9.1075339019197766560849081e-06, 20, "910753390191978", -5},
  {2.3450861023537468281574547e+05, 13, "2345086102353746828", 6},
  {1.8062547490847678795922201e-10, 14, "18063", -9},
  {1.0916542796004300180356950e+05, 6, "10916542796", 6},
  {6.8468790713745679855346680e+09, 17, "684687907137456798553466797", 10},
  {3.1401106486077099732115855e-19, 19, "3", -18},
  {2.0957515797006040811538696e+08, 15, "209575157970060408115387", 9},
  {2.2654837801092743258891461e-08, 19, "226548378011", -7},
  {4.4381977729174157748240881e-24, 8, "", -8},
  {3.1912172308369074218750000e+13, 2, "3191217230836907", 14},
  {1.1802381577178545218886896e-02, 14, "1180238157718", -1},
  {4.3108471369882560210056255e-15, 1, "", -1},
  {8.7515750579211299964299542e+00, 12, "8751575057921", 1},
  {5.1681482380904126324588921e-04, 6, "517", -3},
  {2.9148539068332618147505222e-21, 1, "", -1},
  {2.7347745790451560000000000e+16, 4, "2734774579045156", 17},
  {2.0070685037498464830342753e-17, 13, "", -13},
  {6.5190036794890365854371339e+03, 17, "651900367948903658544", 4},
  {5.7208036476355562938156396e-02, 17, "5720803647635556", -1},
  {7.2608467075290821663172246e-12, 1, "", -1},
  {1.5201080734592281341552734e+10, 2, "1520108073459", 11},
  {1.6216735262214740723174522e-03, 2, "", -2},
  {4.0056424380108509063720703e+09, 20, "40056424380108509063720703125", 10},
  {1.0135066887607205643462294e+01, 13, "101350668876072", 2},
  {1.6286837917218370471774272e-18, 14, "", -14},
  {2.8126181330731470117651827e-07, 2, "", -2},
  {2.7481636538521766662597656e+08, 1, "2748163654", 9},
  {2.4317493693809003125000000e+14, 9, "24317493693809003125", 15},
  {1.9190052734318411818835394e-24, 18, "", -18},
  {8.5078640539466035200000000e+18, 16, "850786405394660352", 19},
  {6.0607443296998960937500000e+13, 15, "606074432969989609375", 14},
  {1.3822107509346448932774365e+05, 17, "13822107509346448932774", 6},
  {6.5456032615560262500000000e+14, 18, "654560326155602625", 15},
  {3.5162431067102774977684021e+05, 3, "351624311", 6},
  {1.9294653667630709900507671e-05, 11, "1929465", -4},
  {1.8444550978793723583221436e+09, 5, "184445509787937", 10},
  {2.4921904711171437379488362e-19, 10, "", -10},
  {3.2469543685678529739379883e+09, 2, "324695436857", 10},
  {4.2807879024201199163999358e-16, 15, "", -15},
  {4.9405525076873990295012185e-03, 3, "5", -2},
  {2.6700272607646202231990173e+03, 2, "267003", 4},
  {2.2223329227554393600000000e+18, 16, "222233292275543936", 19},
  {7.4412579269995552403306504e-10, 8, "", -8},
  {1.4833213090462944335937500e+12, 0, "1483321309046", 13},
  {1.2100708510909561859178939e-18, 10, "", -10},
  {3.7520278561338492187500000e+13, 17, "375202785613384921875", 14},
  {3.1701665458710368750000000e+14, 7, "3170166545871036875", 15},
  {9.7650834503414571401324685e-16, 10, "", -10},
  {2.6018772927659274823986024e-02, 3, "26", -1},
  {9.3501319170880377406835280e-20, 13, "", -13},
  {1.3583859635433880612254143e+07, 1, "135838596", 8},
  {5.7378858977266793670948970e-15, 1, "", -1},
  {4.8337866959698022606417567e-02, 5, "4834", -1},
  {4.4742685282858772666259028e+01, 15, "44742685282858773", 2},
  {1.9053872116350346875000000e+14, 0, "190538721163503", 15},
  {7.9424138287892670366868336e-11, 10, "1", -9},
  {3.4260937565210122589428507e-24, 15, "", -15},
  {1.7356287959545448000000000e+16, 6, "17356287959545448", 17},
  {2.5816091718785811199109217e-13, 13, "3", -12},
  {1.9291956365310301780700684e+09, 10, "19291956365310301781", 10},
  {1.3078747943085354563663714e+04, 20, "1307874794308535456366371", 5},
  {6.0057614615354920140800000e+20, 6, "600576146153549201408", 21},
  {1.2700818042289132951816393e-09, 1, "", -1},
  {1.7657066223669792000000000e+17, 3, "17657066223669792", 18},
  {4.9456705165025527609096161e-10, 20, "49456705165", -9},
  {7.2138856303425072837853804e+03, 13, "72138856303425073", 4},
  {2.5055914938915998720000000e+18, 0, "2505591493891599872", 19},
  {2.8212299943773460108786821e+05, 12, "282122999437734601", 6},
  {4.9862760442790699427088498e-11, 18, "4986276", -10},
  {2.1132387585984693125703844e-08, 16, "211323876", -7},
  {3.3391545049912302694613415e-13, 19, "3339155", -12},
  {3.8719703360749366771953001e-08, 10, "387", -7},
  {8.0425364450087909705400246e-05, 13, "804253645", -4},
  {7.0463507777692619711160660e+06, 14, "704635077776926197112", 7},
  {3.0839416149032508995221985e-17, 14, "", -14},
  {1.4342113719344261020243734e-21, 4, "", -4},
  {1.5963745063692107351016602e+02, 0, "16", 3},
  {6.3236141354461173314134552e-19, 16, "", -16},
  {6.0458774165995837392983958e+03, 20, "60458774165995837392984", 4},
  {1.3446661498606767319408215e-08, 18, "13446661499", -7},
  {8.1487036437781762500000000e+14, 20, "814870364377817625", 15},
  {4.9461471915399593750000000e+13, 0, "494614719154", 14},
  {5.8852084726937122642993927e+07, 5, "5885208472694", 8},
  {3.7913674031509570850131952e-04, 15, "379136740315", -3},
  {5.2535946471583863031754812e-24, 16, "", -16},
  {1.1232505078485295371318108e-12, 9, "", -9},
  {2.8700696452316862283815624e-02, 9, "28700696", -1},
  {1.0204351767504763639131368e-18, 5, "", -5},
  {1.6845811552185976282227570e-20, 3, "", -3},
  {1.8534116020862355828285217e+07, 7, "185341160208624", 8},
  {9.9325572680563448629928238e-14, 7, "", -7},
  {3.1405695479851498674861432e+01, 16, "314056954798514987", 2},
  {4.0595424264375390484929085e+06, 17, "405954242643753904849291", 7},
  {1.5279760892806169433593750e+12, 5, "152797608928061694", 13},
  {9.2934810437645874023437500e+10, 14, "929348104376458740234375", 11},
  {2.8883430485617287786573315e-04, 12, "288834305", -3},
  {1.2592011383528071755969440e-15, 11, "", -11},
  {1.0254344954224318063056045e-19, 7, "", -7},
  {3.3928051267615288601798240e-15, 5, "", -5},
  {2.0290577733312361267200000e+20, 11, "202905777333123612672", 21},
  {4.3279203347191119721770747e-01, 1, "4", 0},
  {3.4796128125662101304789772e-10, 7, "", -7},
  {1.0443665066645298380056395e-17, 19, "104", -16},
  {4.8839668381909423260367475e+03, 10, "48839668381909", 4},
  {1.9367176877980103017762303e+05, 16, "1936717687798010301776", 6},
  {1.8164982108252448273392701e-14, 7, "", -7},
  {2.5234158637774160290566519e-21, 13, "", -13},
  {1.0135930720484349165339258e-10, 19, "1013593072", -9},
  {8.1130970530572656699693699e-10, 16, "8113097", -9},
  {3.3735426346837897593200495e-02, 17, "337354263468379", -1},
  {1.5186095298069086336927250e-22, 0, "", 0},
  {5.5323966887432345085340302e-03, 12, "5532396689", -2},
  {2.3792898171292448800118180e-02, 17, "2379289817129245", -1},
  {3.1227586096133422288723125e-04, 15, "312275860961", -3},
  {2.4237899302186351269483566e+05, 12, "242378993021863513", 6},
  {1.0297287288204707403422859e-10, 7, "", -7},
  {2.0307859905382961571363238e-10, 13, "2031", -9},
  {2.4234151769837638510622983e-25, 18, "", -18},
  {6.0142724276927270889282227e+09, 17, "601427242769272708892822266", 10},
  {6.9835939094017788038448530e-15, 4, "", -4},
  {2.6248945116851539611816406e+10, 15, "26248945116851539611816406", 11},
  {1.7451223125463741366568404e-04, 18, "174512231254637", -3},
  {7.5368848960889237160633555e-21, 0, "", 0},
  {5.6646792132420658290943480e-12, 18, "5664679", -11},
  {2.4745429384026114303030178e-17, 20, "2475", -16},
  {3.2735326459808067584000000e+19, 4, "32735326459808067584", 20},
  {1.6868936536133380954538552e+00, 18, "1686893653613338095", 1},
  {2.5921988614659750708019900e-09, 19, "25921988615", -8},
  {3.5607284384099740982055664e+09, 1, "35607284384", 10},
  {1.3638105663927060504647670e+03, 11, "136381056639271", 4},
  {1.4282079611218868255615234e+10, 11, "1428207961121886825562", 11},
  {1.7463419405391212626745612e-12, 19, "17463419", -11},
  {5.3666834128255490213632584e+04, 3, "53666834", 5},
  {1.5891295960631889101932757e+04, 7, "158912959606", 5},
  {2.9357574198498690843992491e-09, 0, "", 0},
  {1.0578148447498961867634529e-14, 0, "", 0},
  {3.4792489114603910138612264e+02, 14, "3479248911460391", 3},
  {1.7741781905533653937618943e-14, 13, "", -13},
  {1.7575194192950498000000000e+16, 6, "17575194192950498", 17},
  {1.3130566757430508000000000e+16, 12, "13130566757430508", 17},
  {1.1510621472616632918425949e-07, 2, "", -2},
  {1.1356463373747397095631399e-17, 10, "", -10},
  {3.4647473857664912500000000e+14, 3, "346474738576649125", 15},
  {6.8780485490087410796987422e-05, 4, "1", -3},
  {1.1267600741092822880295703e-08, 16, "112676007", -7},
  {1.9421767495963782046430879e+00, 8, "194217675", 1},
  {1.0659273457378634643554688e+11, 13, "1065927345737863464355469", 12},
  {1.4998338281902910000000000e+15, 7, "1499833828190291", 16},
  {3.8951214868969143978461034e+00, 12, "3895121486897", 1},
  {2.4104664764008987798082183e-15, 3, "", -3},
  {1.5177657568629399975179695e+04, 19, "151776575686293999751797", 5},
  {1.1214992472263425952405669e+04, 1, "11215", 5},
  {6.5118374006052062500000000e+14, 10, "651183740060520625", 15},
  {1.1034508673394578125000000e+14, 15, "11034508673394578125", 15},
  {1.6930840559438581349738229e-03, 10, "16930841", -2},
  {2.0568225527737143920603557e+02, 9, "205682255277", 3},
  {7.9237386654514093399047852e+09, 2, "792373866545", 10},
  {5.5540723384188225454272809e-22, 18, "", -18},
  {1.7488715904029073023968568e-14, 5, "", -5},
  {1.4725738059032769666778506e-01, 14, "14725738059033", 0},
  {2.1089450317816443171383578e-17, 7, "", -7},
  {2.8182198248282104492187500e+11, 8, "28182198248282104492", 12},
  {2.4604071327012670040130615e+08, 8, "2460407132701267", 9},
  {3.9520856648393644800000000e+17, 12, "395208566483936448", 18},
  {3.6741916371462623232000000e+19, 5, "36741916371462623232", 20},
  {1.7693191747742029185097579e-01, 12, "176931917477", 0},
  {2.5234434314303511834679556e-13, 18, "252344", -12},
  {3.5458154538969877141079486e-07, 11, "35458", -6},
  {3.2653945171675342559814453e+10, 19, "32653945171675342559814453125", 11},
  {2.6215154578975844196975231e+06, 7, "26215154578976", 7},
  {4.3887066126138410027124337e+02, 14, "4388706612613841", 3},
  {7.7595153224745136336835590e-10, 13, "776", -9},
  {6.6875220192905449218750000e+12, 8, "668752201929054492188", 13},
  {1.4199488051165034770965576e+09, 1, "14199488051", 10},
  {2.0025168185163147751712167e-20, 5, "", -5},
  {1.0404177693102189507454134e-10, 19, "1040417769", -9},
  {8.9197942063146264648437500e+11, 2, "89197942063146", 12},
  {2.2282524730140255375540075e-08, 12, "22283", -7},
  {1.0081879265898215424000000e+19, 12, "10081879265898215424", 20},
  {4.3572721599037190357071696e-06, 12, "4357272", -5},
  {4.8069056587730518703693861e-01, 0, "", 0},
  {2.9449035143153691352035532e-13, 1, "", -1},
  {6.2147362460661342993262224e+03, 0, "6215", 4},
  {1.0240747260782319641113281e+11, 4, "1024074726078232", 12},
  {3.6564580009388870239257812e+10, 12, "36564580009388870239258", 11},
  {2.1880860215789812011718750e+12, 7, "21880860215789812012", 13},
  {2.8974230166109533939284085e-05, 20, "2897423016610953", -4},
  {9.1465390499471093750000000e+11, 8, "9146539049947109375", 12},
  {6.4573472558177066966891289e+06, 9, "6457347255817707", 7},
  {9.7504963894715102057375589e-01, 0, "1", 1},
  {9.2072680113410625000000000e+13, 9, "92072680113410625", 14},
  {1.2765110391627958716762651e-08, 4, "", -4},
  {7.2011723959666210787000651e-03, 10, "72011724", -2},
  {4.1429960473930565946328394e-09, 6, "", -6},
  {6.0474457475752198661211878e+04, 1, "604745", 5},
  {4.2516585038243708610534668e+09, 4, "42516585038244", 10},
  {6.5558691492407642304897308e+07, 12, "65558691492407642305", 8},
  {2.1450456517693171200000000e+17, 19, "214504565176931712", 18},
  {7.2312207694528862225105547e-13, 20, "72312208", -12},
  {4.7025642288364252315018681e-22, 17, "", -17},
  {4.9372549463838380400990645e-06, 4, "", -4},
  {5.7913463689722698864792503e-08, 17, "5791346369", -7},
  {6.1018658705581607458311865e-17, 3, "", -3},
  {1.9024594241897469758987427e+08, 17, "19024594241897469758987427", 9},
  {1.2635122987403162849497078e-22, 8, "", -8},
  {2.0432326232577933593750000e+13, 1, "204323262325779", 14},
  {5.3644563371185264004767891e-09, 5, "", -5},
  {3.1425971925069789980611290e-01, 13, "3142597192507", 0},
  {1.6596391993469478903197603e-16, 19, "166", -15},
  {4.9584349480031141888000000e+19, 12, "49584349480031141888", 20},
  {8.4266746051559833984375000e+12, 20, "84266746051559833984375", 13},
  {2.4101702185184015625000000e+13, 11, "24101702185184015625", 14},
  {4.3788880015961003104758842e-05, 19, "43788880015961", -4},
  {5.1079002818350393750000000e+14, 7, "5107900281835039375", 15},
  {1.1044307381147955608103404e-21, 4, "", -4},
  {2.5997770396545592320000000e+18, 0, "2599777039654559232", 19},
  {1.2345953015375187620520592e+07, 9, "12345953015375188", 8},
  {3.1005438042794328182935715e+07, 8, "3100543804279433", 8},
  {9.7076636967616414947146453e-03, 5, "971", -2},
  {7.8180111874898696601600000e+20, 8, "781801118748986966016", 21},
  {6.1893469469519645690917969e+10, 6, "61893469469519646", 11},
  {1.1428708123316656481474414e-10, 5, "", -5},
  {1.1849783869823197750282315e-19, 11, "", -11},
  {4.5560744423650751110223851e-09, 12, "4556", -8},
  {2.6064936034837076975672605e-20, 17, "", -17},
  {4.6066180718353243719320744e+04, 8, "4606618071835", 5},
  {6.8830580165406540000000000e+15, 0, "6883058016540654", 16},
  {1.8233461922747797728794339e-02, 16, "182334619227478", -1},
  {1.6064309719652461082119984e-16, 18, "161", -15},
  {1.1521325274470260937500000e+14, 12, "115213252744702609375", 15},
  {1.6034540631932478064664262e-22, 12, "", -12},
  {9.1669162102534785214186164e-15, 0, "", 0},
  {2.0311220850157763974095965e-08, 10, "203", -7},
  {1.0356434075403326034545898e+10, 2, "103564340754", 11},
  {1.1476526248603515795214588e-23, 12, "", -12},
  {1.5446449608628991246223450e+08, 19, "1544644960862899124622344971", 9},
  {1.3450350226403312640000000e+18, 18, "1345035022640331264", 19},
  {2.3843736761519907460678338e-19, 2, "", -2},
  {6.1851445382941725256387144e+04, 2, "6185145", 5},
  {4.2908893092522365000000000e+15, 17, "42908893092522365", 16},
  {4.1885793322187422025329816e-11, 12, "42", -10},
  {4.1485251751818976000000000e+17, 16, "41485251751818976", 18},
  {1.4075887621990301681313684e-11, 6, "", -6},
  {4.5931187702477445312500000e+13, 4, "459311877024774453", 14},
  {1.1912048805072969720302012e-07, 5, "", -5},
  {6.0771701331842104000000000e+16, 10, "60771701331842104", 17},
  {6.4989906310786088249768392e-20, 4, "", -4},
  {1.2014334936731383799296797e-11, 13, "12", -10},
  {6.1726373098326055333018303e+06, 19, "61726373098326055333018303", 7},
  {7.9559226880955963134765625e+09, 4, "79559226880956", 10},
  {2.5265742609664454400000000e+17, 16, "252657426096644544", 18},
  {1.5007567670869908342139748e-22, 14, "", -14},
  {1.2120713050535560029175031e+01, 3, "12121", 2},
  {7.0161267715422156930355443e-17, 16, "1", -15},
  {4.5097866196449247210080725e-21, 17, "", -17},
  {6.4445880210497995898380684e-18, 15, "", -15},
  {5.3625048807167074735747796e-24, 10, "", -10},
  {1.4209930608821037109375000e+13, 0, "14209930608821", 14},
  {1.1358287082961808977729645e-05, 17, "1135828708296", -4},
  {1.2916756033436351562500000e+13, 5, "1291675603343635156", 14},
  {3.6401701701321849209274063e-11, 14, "364", -10},
  {2.6705451366336294682923835e+01, 12, "26705451366336", 2},
  {1.0285866524056432425027197e+01, 15, "10285866524056432", 2},
  {2.1444627662476386874914169e+07, 1, "214446277", 8},
  {4.8549124536021953125000000e+12, 13, "48549124536021953125", 13},
  {5.9718760724751810187171941e+01, 7, "597187607", 2},
  {8.9396978217036165287323612e-03, 13, "89396978217", -2},
  {3.5660809359413673482036285e-07, 15, "356608094", -6},
  {8.9194253484153649854840820e-19, 8, "", -8},
  {1.7655441368368334428538243e-11, 11, "2", -10},
  {6.8978661562652970000000000e+15, 20, "6897866156265297", 16},
  {2.7467213982865906250000000e+13, 17, "2746721398286590625", 14},
  {9.1961767339288339405690653e-22, 19, "", -19},
  {1.0633505341245697702628388e-14, 3, "", -3},
  {1.1401638029599042236804962e+08, 6, "11401638029599", 9},
  {5.6656144211487025064144518e-01, 2, "57", 0},
  {6.1022379839468874037265778e+07, 13, "610223798394688740373", 8},
  {2.8974881087647463573375717e+03, 0, "2897", 4},
  {4.1164224983504163840000000e+18, 6, "4116422498350416384", 19},
  {7.2238603467829817247571793e-07, 2, "", -2},
  {1.2193634701271523328000000e+19, 3, "12193634701271523328", 20},
  {1.3064494647659703044819877e-09, 16, "13064495", -8},
  {4.4759082146376813398092054e+03, 4, "44759082", 4},
  {6.4668785161154355200000000e+17, 6, "646687851611543552", 18},
  {8.7675222974910879011303973e-07, 18, "876752229749", -6},
  {1.3722302824899146727904951e-16, 5, "", -5},
  {1.5251117187834878617555502e-06, 19, "15251117187835", -5},
  {5.7521651746288117042474316e-21, 16, "", -16},
  {3.3920720690007468750000000e+13, 1, "339207206900075", 14},
  {4.7787375590223287506683762e-18, 13, "", -13},
  {1.6453027215412156622509005e-11, 18, "16453027", -10},
  {5.6599314833443655515959744e-09, 5, "", -5},
  {3.5407111993688631057739258e+08, 2, "35407111994", 9},
  {1.2208144728219310242343888e-16, 7, "", -7},
  {2.7695462895346060795442731e-24, 1, "", -1},
  {2.3792579667189114470400000e+20, 8, "237925796671891144704", 21},
  {3.1298867231126510472793978e-03, 11, "312988672", -2},
  {4.4256195569001389880865153e-20, 7, "", -7},
  {4.3343424766376193019395548e-13, 1, "", -1},
  {3.1443313122119612500000000e+14, 20, "314433131221196125", 15},
  {2.0224309520877491650590513e-16, 8, "", -8},
  {2.5128208946809802752000000e+19, 12, "25128208946809802752", 20},
  {5.7385080475253494391766243e-21, 15, "", -15},
  {5.5777465945455130391070130e-25, 1, "", -1},
  {3.1932189630251837181580785e-07, 13, "3193219", -6},
  {1.0340789455154180132012698e+01, 11, "1034078945515", 2},
  {1.4637090785276247040000000e+18, 16, "1463709078527624704", 19},
  {1.7883929619318364530045073e+03, 7, "17883929619", 4},
  {9.9846524796699100000000000e+14, 18, "998465247966991", 15},
  {2.2029186398549608960000000e+18, 6, "2202918639854960896", 19},
  {1.6173968709200496093750000e+13, 10, "1617396870920049609375", 14},
  {2.5455648024036609058384784e+03, 2, "254556", 4},
  {1.5604858191187917157427556e-02, 1, "", -1},
  {8.2977646034288536117909019e-17, 12, "", -12},
  {2.9966414739713800781250000e+13, 16, "2996641473971380078125", 14},
  {8.8932376255688458240000000e+19, 16, "8893237625568845824", 20},
  {2.1721527034531553517940331e-20, 17, "", -17},
  {1.4644796097443079719094272e-04, 4, "1", -3},
  {3.5485275674199195648000000e+19, 13, "35485275674199195648", 20},
  {8.7643859556667376000000000e+16, 9, "87643859556667376", 17},
  {3.0899067232413417183334303e-03, 9, "3089907", -2},
  {4.7595446311144552230834961e+09, 9, "4759544631114455223", 10},
  {2.5982626810915106567742510e-24, 16, "", -16},
  {9.8622730894707783591002226e+05, 6, "986227308947", 6},
  {9.2091330193405272735976176e-13, 14, "92", -12},
  {1.1186003182107176901590597e-18, 17, "", -17},
  {3.8127489390101257371590293e-02, 3, "38", -1},
  {1.4361134965906476572704330e-07, 20, "14361134965906", -6},
  {1.7265173948447510600090027e+07, 4, "172651739484", 8},
  {1.0958144943400772800000000e+17, 17, "109581449434007728", 18},
  {1.1718882343682250752000000e+19, 13, "11718882343682250752", 20},
  {1.7725053068071666473315418e+01, 4, "177251", 2},
  {2.7673638970651354980468750e+11, 15, "2767363897065135498046875", 12},
  {3.4418923270081140100955963e+07, 16, "34418923270081140100956", 8},
  {8.6301727503051125000000000e+13, 12, "86301727503051125", 14},
  {5.6045794007248967885971069e+07, 20, "5604579400724896788597106934", 8},
  {5.3337368574671307578682899e+06, 20, "533373685746713075786828995", 7},
  {2.1938361613808674812316895e+09, 17, "219383616138086748123168945", 10},
  {2.4286944189100244992000000e+19, 12, "24286944189100244992", 20},
  {2.6214742535661637956049131e-24, 3, "", -3},
  {3.9178787760998874450599216e-04, 5, "39", -3},
  {1.8134935918675017029970539e-21, 11, "", -11},
  {2.3876181428876773793490429e+02, 8, "23876181429", 3},
  {1.5247159605281573448794415e-05, 1, "", -1},
  {1.7515403802922626953125000e+12, 19, "17515403802922626953125", 13},
  {1.6375451324997076034545898e+10, 1, "16375451325", 11},
  {1.9428954590394784837549143e-18, 20, "194", -17},
  {1.5109634599138779784804041e-25, 7, "", -7},
  {4.1395251923456968432511738e-07, 0, "", 0},
  {5.1278318409435859375000000e+12, 19, "51278318409435859375", 13},
  {2.3879095218637151992879808e+05, 7, "2387909521864", 6},
  {6.1024249860580148379085585e+03, 3, "6102425", 4},
  {2.3132366643332326202653348e+05, 20, "23132366643332326202653348", 6},
  {9.8198225110177800059318542e+07, 14, "9819822511017780005932", 8},
  {2.8537539585943148000000000e+16, 19, "28537539585943148", 17},
  {3.3036599667539046087938459e-01, 11, "33036599668", 0},
  {3.7247485659727026367187500e+12, 9, "3724748565972702636719", 13},
  {4.7900300517673522949218750e+11, 3, "479003005176735", 12},
  {6.1883024430806443660912919e+01, 12, "61883024430806", 2},
  {2.4240130440661932685118999e-19, 4, "", -4},
  {2.1554132163776010000000000e+15, 9, "2155413216377601", 16},
  {2.9313661943064228000000000e+16, 18, "29313661943064228", 17},
  {1.0179748423751258000000000e+16, 20, "10179748423751258", 17},
  {1.1460463417633215431123972e+06, 14, "114604634176332154311", 7},
  {4.0518324192263497318400000e+20, 2, "405183241922634973184", 21},
  {1.3640424866450655519726010e-23, 2, "", -2},
  {1.8647631506566386669874191e+06, 9, "1864763150656639", 7},
  {2.3421093948544712676636000e-21, 18, "", -18},
  {4.1668951219305987846511076e-17, 0, "", 0},
  {2.8737096715004728508802145e+00, 15, "2873709671500473", 1},
  {4.3788699604191638529300690e+07, 17, "4378869960419163852930069", 8},
  {1.1297525970594532917302093e-11, 17, "1129753", -10},
  {1.9804015281040189266204834e+09, 9, "1980401528104018927", 10},
  {2.0356640419217681884765625e+11, 18, "20356640419217681884765625", 12},
  {2.3278678603929806034678052e-02, 1, "", -1},
  {6.2056009600922740470502204e-04, 13, "620560096", -3},
  {8.9616340503739133627192359e-01, 18, "896163405037391336", 0},
  {1.8728331126324176025390625e+11, 12, "187283311263241760253906", 12},
  {1.4715723963100392179214962e-18, 19, "15", -17},
  {3.9966195185144773859065026e+04, 0, "39966", 5},
  {1.0705528219782110071728805e-12, 1, "", -1},
  {1.4072073835256595154439220e-09, 4, "", -4},
  {1.1626746699407037866080827e+01, 8, "116267467", 2},
  {2.1804955085522942681564018e+02, 20, "21804955085522942681564", 3},
  {4.1591021096824143388204220e-01, 17, "41591021096824143", 0},
  {1.8676340078280182988800000e+20, 13, "186763400782801829888", 21},
  {3.2172625651193992187500000e+13, 16, "321726256511939921875", 14},
  {1.0209114788102892357191109e-01, 3, "102", 0},
  {1.1137719772330873820465058e+05, 18, "111377197723308738204651", 6},
  {1.5164529436101153819332595e-06, 14, "151645294", -5},
  {6.2231893765649310615428607e-18, 0, "", 0},
  {1.3792257284112247500000000e+15, 20, "137922572841122475", 16},
  {1.8217487412140308480000000e+19, 12, "1821748741214030848", 20},
  {3.2265010326544171448404086e+02, 6, "322650103", 3},
  {1.6848354190771764781704682e-25, 9, "", -9},
  {1.4003282165659489849098007e-04, 10, "1400328", -3},
  {4.3097135328234761839433166e-10, 4, "", -4},
  {7.8471726160760008497163653e+03, 14, "784717261607600085", 4},
  {1.7851102813789595000000000e+15, 17, "17851102813789595", 16},
  {1.5684602239800035765721551e-20, 16, "", -16},
  {1.1071013025736800000000000e+18, 10, "110710130257368", 19},
  {5.4324121029603593754445510e-10, 16, "5432412", -9},
  {4.3337059526491321139200000e+20, 13, "433370595264913211392", 21},
  {3.0920510204480317440000000e+18, 1, "3092051020448031744", 19},
  {4.3001153515738330543003374e-22, 19, "", -19},
  {2.6472204512667077083681945e-10, 20, "26472204513", -9},
  {1.0863975648366983040027378e-01, 7, "1086398", 0},
  {2.8721050909798943373064158e-06, 0, "", 0},
  {1.4787667402670219726562500e+12, 20, "147876674026702197265625", 13},
  {2.3549846151286232043275959e+02, 10, "2354984615129", 3},
  {3.1362939153651367936000000e+20, 16, "31362939153651367936", 21},
  {6.4203215144543555187306438e-03, 11, "642032151", -2},
  {3.6756254672080341701767587e-09, 4, "", -4},
  {3.3332565829944926757812500e+12, 20, "333325658299449267578125", 13},
  {5.2612326454568871451868978e-09, 10, "53", -8},
  {8.8844627179920839843750000e+12, 3, "8884462717992084", 13},
  {5.1747005440414475000000000e+14, 15, "51747005440414475", 15},
  {3.9802898585286710788526519e-24, 19, "", -19},
  {7.7601880375086383104000000e+19, 20, "77601880375086383104", 20},
  {1.8627952178718978881595417e-17, 0, "", 0},
  {2.5912434725336842238903046e+07, 12, "25912434725336842239", 8},
  {3.1011184862477946083197559e-16, 12, "", -12},
  {8.3424139717833800000000000e+15, 2, "834241397178338", 16},
  {4.2507136524983046140140640e-20, 14, "", -14},
  {2.7014210027690493747625695e-14, 13, "", -13},
  {1.2214272508223600685596466e+07, 8, "122142725082236", 8},
  {1.2107902941624680960000000e+18, 3, "1210790294162468096", 19},
  {1.0181718329804390668869019e+08, 19, "1018171832980439066886901855", 9},
  {9.7242080444241412096000000e+20, 9, "97242080444241412096", 21},
  {4.3393053853609224056100263e-05, 12, "43393054", -4},
  {5.8564660504922312611597590e+02, 12, "585646605049223", 3},
  {3.6357479083123586411502304e-04, 5, "36", -3},
  {7.2703335165031043513465579e-15, 2, "", -2},
  {1.2210919717748359107336765e-20, 20, "1", -19},
  {3.5240434896664969216000000e+19, 9, "35240434896664969216", 20},
  {2.3402222900508856895385179e+01, 1, "234", 2},
  {5.9207799711305224000000000e+16, 3, "59207799711305224", 17},
  {4.3287574149609664455056190e+06, 16, "43287574149609664455056", 7},
  {1.0024739393519957464384618e-03, 19, "10024739393519957", -2},
  {1.0608632765726147226814646e+03, 6, "1060863277", 4},
  {4.4376926310603959091594106e-01, 8, "44376926", 0},
  {2.2030746403579643368721008e+08, 3, "220307464036", 9},
  {1.6255350826148764475931330e+00, 20, "162553508261487644759", 1},
  {4.5626079190830777624083093e-16, 15, "", -15},
  {1.5947600661774932086804581e-07, 1, "", -1},
  {6.1586611619169183884855267e-10, 10, "6", -9},
  {3.2236337697579907855394638e-13, 3, "", -3},
  {2.2849672477408841936480990e-14, 5, "", -5},
  {2.9476350006698410083120600e-18, 9, "", -9},
  {8.3792703542782315427169056e-13, 0, "", 0},
  {8.8105568720955044751149114e-20, 8, "", -8},
  {2.3574922203811748769805107e-13, 2, "", -2},
  {2.4880801583976260735653341e+05, 0, "248808", 6},
  {1.3409941444918812521077402e-20, 3, "", -3},
  {8.1587370723875064881493646e-08, 1, "", -1},
  {4.3930071718883424307022866e-25, 18, "", -18},
  {1.7757985213080623025423018e-09, 3, "", -3},
  {4.1327238372106994586792318e-07, 12, "413272", -6},
  {1.0277307957123620951733756e+02, 15, "10277307957123621", 3},
  {7.6396970540500380039563214e-12, 14, "764", -11},
  {1.8987162920766556262969971e+09, 17, "189871629207665562629699707", 10},
  {3.2318821094679114705962636e-11, 14, "3232", -10},
  {3.0063765218473148345947266e+08, 15, "300637652184731483459473", 9},
  {2.5141240522095869140625000e+12, 17, "25141240522095869140625", 13},
  {1.9164725842167792640000000e+18, 17, "1916472584216779264", 19},
  {9.2545144485442342556780204e+03, 16, "92545144485442342557", 4},
  {4.1985654909386627105578515e-22, 14, "", -14},
  {6.0285432340423082844044686e-24, 5, "", -5},
  {1.8016355815406905846688381e-10, 0, "", 0},
  {2.4822291878377494024734823e-24, 11, "", -11},
  {1.3802962981175960540771484e+10, 5, "1380296298117596", 11},
  {2.4356359122896099628618192e-24, 4, "", -4},
  {1.6896751080521366361608671e+02, 2, "16897", 3},
  {1.6677852603347098310913006e-16, 18, "167", -15},
  {2.9232195320794358253479004e+09, 8, "292321953207943583", 10},
  {4.4801860254053371690474705e-01, 5, "44802", 0},
  {2.3738894585195074167461917e-10, 7, "", -7},
  {2.4613739760546751320362091e+07, 16, "246137397605467513203621", 8},
  {5.2220773175079353054070692e-06, 2, "", -2},
  {8.8188803534321930682791071e-24, 0, "", 0},
  {1.9432023222785790039779386e+03, 5, "194320232", 4},
  {5.0066230013334550000000000e+15, 16, "5006623001333455", 16},
  {5.6985798347394305630039542e-20, 4, "", -4},
  {1.0577057374917449600000000e+17, 16, "105770573749174496", 18},
  {1.3056591195411178081629261e-11, 20, "130565912", -10},
  {1.8924283250254353027343750e+12, 11, "189242832502543530273438", 13},
  {1.8658311198114940800000000e+17, 3, "186583111981149408", 18},
  {5.1989183529580615422054064e-21, 1, "", -1},
  {3.1888028202431568270552604e-06, 7, "32", -5},
  {1.1466425903101640670911365e+01, 14, "1146642590310164", 2},
  {3.0394924918301828971925500e-15, 8, "", -8},
  {3.9214686529394792103100829e-25, 10, "", -10},
  {5.9153795223976969718933105e+06, 5, "59153795224", 7},
  {1.2153830541425726586093965e-21, 2, "", -2},
  {6.0328729950738799571990967e+08, 3, "603287299507", 9},
  {1.5006779043816640107213588e-23, 5, "", -5},
  {2.6634161744359789736336097e+04, 7, "266341617444", 5},
  {1.7382772295630796875000000e+14, 9, "17382772295630796875", 15},
  {1.8522761471919433600000000e+17, 8, "185227614719194336", 18},
  {6.4219324056165563964843750e+11, 11, "64219324056165563964844", 12},
  {1.9616851693918362913386836e-22, 12, "", -12},
  {2.2205986710907358743273477e-11, 9, "", -9},
  {1.1475460036228778997910539e-20, 20, "1", -19},
  {8.3973971395491059200000000e+17, 9, "839739713954910592", 18},
  {1.1617898587706540070030314e+02, 14, "1161789858770654", 3},
  {2.0191726610417629527031604e-15, 13, "", -13},
  {2.8201429394776906146536284e-20, 8, "", -8},
  {5.3082097491408821849231258e-18, 2, "", -2},
  {4.7736646400468123164172185e-05, 14, "477366464", -4},
  {4.9964714851008654023895073e-24, 12, "", -12},
  {6.3694201902419821450458405e-22, 2, "", -2},
  {3.3252260988515550781250000e+13, 15, "3325226098851555078125", 14},
  {4.9606600254607557953789865e-02, 10, "496066003", -1},
  {1.4228797017295249059676276e-03, 20, "142287970172952491", -2},
  {2.4028258366105533241352532e+03, 11, "240282583661055", 4},
  {4.3855523385253704696770447e-18, 8, "", -8},
  {2.7880600619182075369439704e-11, 20, "2788060062", -10},
  {8.2180174685342752660606719e-10, 2, "", -2},
  {1.8531422021326695486267977e-04, 4, "2", -3},
  {7.7617445646461001160787418e+03, 20, "776174456464610011607874", 4},
  {5.8817701144604757428169250e+06, 16, "58817701144604757428169", 7},
  {6.0002344400499369949102402e+06, 2, "600023444", 7},
  {4.3372375922584971428801605e-07, 3, "", -3},
  {2.3424417844729390080000000e+18, 4, "2342441784472939008", 19},
  {1.1284779222348857671022415e+07, 17, "1128477922234885767102242", 8},
  {1.2292037166501641622085363e-24, 9, "", -9},
  {4.9994882912373823163505124e-17, 13, "", -13},
  {1.8853758031634529726469100e-17, 2, "", -2},
  {2.0024162019668473311284629e-01, 10, "2002416202", 0},
  {1.6159265812769796848297119e+09, 0, "1615926581", 10},
  {1.5576078843032080213640357e-09, 13, "15576", -8},
  {1.8952348834608674224000424e+03, 16, "18952348834608674224", 4},
  {2.1511533636145919982167182e-13, 16, "2151", -12},
  {4.5350522931831129907330669e-11, 3, "", -3},
  {4.1199842710825287213083357e+04, 15, "41199842710825287213", 5},
  {1.3081350561194369009113646e-05, 15, "13081350561", -4},
  {2.5400541370547511718750000e+13, 18, "2540054137054751171875", 14},
  {1.4825011013349478739836683e-16, 13, "", -13},
  {3.2347750357381698313533720e-14, 7, "", -7},
  {1.8798781539062485694885254e+09, 15, "1879878153906248569488525", 10},
  {5.9735553787450943820612674e-18, 20, "597", -17},
  {4.3906503466121358439893017e-19, 3, "", -3},
  {3.1511289449695797302905509e-16, 15, "", -15},
  {4.8824032600725370242083799e-19, 7, "", -7},
  {3.8935517037728318394291436e-13, 1, "", -1},
  {5.0336989757562627236941948e-17, 1, "", -1},
  {1.1479526588477297011081646e+01, 20, "1147952658847729701108", 2},
  {3.7665762081646052550354398e+00, 2, "377", 1},
  {6.2266466620029021869272438e-15, 6, "", -6},
  {4.9149871356910438400000000e+18, 12, "491498713569104384", 19},
  {5.1341962424218312662560493e+04, 19, "513419624242183126625605", 5},
  {5.0883891170720487379587283e-21, 2, "", -2},
  {3.9452948569822822400000000e+18, 0, "394529485698228224", 19},
  {2.1923836330576756000000000e+16, 0, "21923836330576756", 17},
  {2.9701240610095823929889946e-20, 19, "", -19},
  {2.3223428467233512139371682e-09, 20, "232234284672", -8},
  {2.5653091276824851989746094e+10, 7, "25653091276824852", 11},
  {4.0668937685223674880000000e+18, 1, "4066893768522367488", 19},
  {2.1495424457712502430695167e+02, 18, "214954244577125024307", 3},
  {5.1968893585793020474085194e-23, 6, "", -6},
  {6.0438104587898103438209917e-14, 11, "", -11},
  {1.1096080633399787093319704e-24, 16, "", -16},
  {2.0210718663760987110435963e+06, 15, "2021071866376098711044", 7},
  {3.8373067995604117665087163e-03, 17, "383730679956041", -2},
  {1.7823025942031809082031250e+12, 11, "178230259420318090820313", 13},
  {4.7648754390679696000000000e+16, 3, "47648754390679696", 17},
  {4.5034025399663357818035586e-14, 18, "45034", -13},
  {5.6156900623496213142971101e+01, 0, "56", 2},
  {5.4371041947692824000000000e+16, 4, "54371041947692824", 17},
  {2.6997094647325261981882946e-17, 9, "", -9},
  {8.8784589527015822713919280e-05, 3, "", -3},
  {1.6924395885883038224911224e-09, 5, "", -5},
  {6.3199776526911624618954022e-03, 2, "1", -1},
  {8.1146536553345061838626862e+05, 20, "81146536553345061838626862", 6},
  {1.6011343200547106135900322e+01, 6, "16011343", 2},
  {2.0017534836816680944487945e-25, 3, "", -3},
  {7.4244982797193790632894771e-16, 6, "", -6},
  {4.2065065357998486328125000e+12, 3, "4206506535799849", 13},
  {6.3792361283214459426722123e-21, 10, "", -10},
  {5.5544109091650559833163020e-18, 6, "", -6},
  {4.4046041920845964902400000e+20, 0, "440460419208459649024", 21},
  {5.5071064911685662500000000e+14, 18, "550710649116856625", 15},
  {6.1996107562941066303373936e-23, 6, "", -6},
  {8.1525188917169172375665198e-02, 10, "815251889", -1},
  {1.3742356128882186021655798e+05, 9, "137423561288822", 6},
  {4.7810121377414220963211801e-11, 5, "", -5},
  {4.3166049917003690340591826e-15, 20, "43166", -14},
  {5.5137782422301803588867188e+10, 0, "55137782422", 11},
  {6.9148020167629363200000000e+17, 18, "691480201676293632", 18},
  {3.1898326341624462604522705e+08, 9, "318983263416244626", 9},
  {6.4381418596166431004006354e-06, 0, "", 0},
  {2.5357318613247581447592683e-21, 20, "", -20},
  {9.4488492614346447257600000e+20, 20, "944884926143464472576", 21},
  {1.6831584918468996692479840e-06, 7, "17", -5},
  {2.4727613816893597887405856e-14, 18, "24728", -13},
  {1.8440331793468245358269542e+00, 13, "18440331793468", 1},
  {4.9229832666716383755556308e+03, 8, "492298326667", 4},
  {1.3180174128899596000000000e+16, 6, "13180174128899596", 17},
  {1.2749744742522235028445721e+06, 11, "12749744742522235", 7},
  {4.2285438384025967274095901e-17, 4, "", -4},
  {1.0267925024912824250198293e-24, 16, "", -16},
  {1.5157021347780695318823072e-15, 11, "", -11},
  {2.6229859936312191515069933e-24, 16, "", -16},
  {1.2027231576288853688099612e-22, 16, "", -16},
  {1.0788504945778597646055410e-13, 17, "10789", -12},
  {7.3593594493032665252685547e+09, 12, "7359359449303266525269", 10},
  {1.1552140727081889894607507e-23, 13, "", -13},
  {1.3624801792119183632866524e-09, 12, "1362", -8},
  {8.4756004427375286817550659e+07, 4, "847560044274", 8},
  {1.0103684016956801409140770e-09, 9, "1", -8},
  {1.7033810829477230592000000e+19, 1, "17033810829477230592", 20},
  {2.0546355556941593750000000e+13, 1, "205463555569416", 14},
  {1.7548070089676388622694085e-22, 9, "", -9},
  {2.2763558622512434421080011e-25, 20, "", -20},
  {7.5766696363690555095672607e+07, 15, "75766696363690555095673", 8},
  {5.5439915456689727035755055e-02, 2, "6", -1},
  {1.3898881226551840768000000e+19, 2, "13898881226551840768", 20},
  {7.2949059263951564207673073e+05, 9, "729490592639516", 6},
  {3.1716339291970908729867174e-22, 19, "", -19},
  {5.2243836876072675213408601e-14, 17, "5224", -13},
  {4.8264526466154994579032782e-12, 8, "", -8},
  {3.5463761625338014720000000e+18, 5, "3546376162533801472", 19},
  {2.7304112882626151782202296e-11, 8, "", -8},
  {8.0135243592680969238281250e+10, 18, "8013524359268096923828125", 11},
  {9.4027235332526018609951599e-23, 13, "", -13},
  {6.2665106072107376557926150e-22, 9, "", -9},
  {1.3127467559438291973053941e-17, 14, "", -14},
  {1.4108993137307684375000000e+14, 17, "14108993137307684375", 15},
  {4.2852056754398889839649200e+07, 2, "4285205675", 8},
  {8.7123646287629252277057975e-17, 4, "", -4},
  {1.0099767517912612304687500e+12, 1, "10099767517913", 13},
  {1.7982692395792046080000000e+18, 6, "1798269239579204608", 19},
  {1.4002540866369710769383388e-12, 2, "", -2},
  {9.9663044201721448916941881e+05, 14, "99663044201721448917", 6},
  {4.3864411485078762052580714e+05, 10, "4386441148507876", 6},
  {9.0471072874008998859938461e-17, 18, "9", -16},
  {5.7644025366632220000000000e+15, 9, "5764402536663222", 16},
  {8.1299655089131660800000000e+17, 20, "812996550891316608", 18},
  {7.6276465024005236816406250e+11, 7, "7627646502400523682", 12},
  {4.4115686950012735906057060e+04, 5, "4411568695", 5},
  {6.8325899629264915802195901e+02, 0, "683", 3},
  {6.6180537114251447963014445e-18, 0, "", 0},
  {1.6512534767653985934702202e-23, 11, "", -11},
  {2.1981548955542679278119213e-19, 13, "", -13},
  {8.2714196400511784960000000e+18, 0, "8271419640051178496", 19},
  {1.0156463366112680177468070e-22, 8, "", -8},
  {1.6136899233629230305275911e-18, 16, "", -16},
  {4.9003915319895225524902344e+10, 17, "4900391531989522552490234375", 11},
  {1.7301921044395221542799845e+04, 15, "17301921044395221543", 5},
  {9.4310865214477419207428868e-21, 19, "", -19},
  {1.2111072822598019982365258e+01, 16, "1211107282259802", 2},
  {9.1392107616670760000000000e+15, 13, "9139210761667076", 16},
  {1.8974276127818777613403527e-19, 0, "", 0},
  {8.1478841367380742187500000e+12, 19, "814788413673807421875", 13},
  {1.4908038158728943375908038e-02, 12, "14908038159", -1},
  {2.2251234068727220391747801e-14, 6, "", -6},
  {4.3652368589423464840329343e-11, 16, "436524", -10},
  {1.4131378663151220650053897e-25, 2, "", -2},
  {8.1450076833953943378219265e+01, 15, "81450076833953943", 2},
  {2.0628430462454620800000000e+17, 12, "206284304624546208", 18},
  {1.4848407741254592399677995e-07, 4, "", -4},
  {4.7875233570089690089511697e-13, 20, "47875234", -12},
  {1.7572238346568940414726967e+02, 18, "175722383465689404147", 3},
  {1.5427903371635344034975171e-14, 8, "", -8},
  {9.1427888876243256462523762e-23, 18, "", -18},
  {8.5710599112389529670538141e-09, 3, "", -3},
  {2.0898259250224004972551484e+03, 0, "209", 4},
  {2.1807543195133117999899341e-22, 13, "", -13},
  {3.1915551867964472780384027e-14, 9, "", -9},
  {1.6529775150378785930490604e-08, 12, "1653", -7},
  {1.0802692475814852905273438e+11, 3, "108026924758149", 12},
  {5.0676917539316727250807685e-19, 11, "", -11},
  {6.1332517760818435668945312e+10, 19, "613325177608184356689453125", 11},
  {4.4201275368812957822228782e+02, 10, "4420127536881", 3},
  {3.2477641190051822377427015e+03, 8, "324776411901", 4},
  {3.7169701573277925523105272e-16, 3, "", -3},
  {3.3701160292688734992319801e-10, 4, "", -4},
  {1.1121468180269518388758598e-01, 9, "111214682", 0},
  {7.4864062131505264000000000e+16, 6, "74864062131505264", 17},
  {2.2181388512012146889407216e-04, 3, "", -3},
  {3.9137506757016157226562500e+12, 15, "391375067570161572265625", 13},
  {1.7240791945857744660308697e-03, 11, "172407919", -2},
  {1.0031286616882464504956671e-13, 11, "", -11},
  {2.4668495889535118172682798e-05, 6, "25", -4},
  {1.4675587508654499967485118e-07, 2, "", -2},
  {2.2537382053695349934038794e-04, 3, "", -3},
  {3.0294155448957906250000000e+13, 17, "3029415544895790625", 14},
  {1.1946110028374791145324707e+09, 15, "1194611002837479114532471", 10},
  {9.5089334661081308593750000e+12, 10, "9508933466108130859375", 13},
  {9.1178955631273779296875000e+11, 18, "91178955631273779296875", 12},
  {9.8658845956872964766404266e-03, 18, "9865884595687296", -2},
  {2.4249180443220256986158710e-11, 16, "242492", -10},
  {1.6318713097770792629293403e-17, 16, "", -16},
  {1.4000997169300995691919309e-04, 18, "14000997169301", -3},
  {7.5668082450822362500000000e+14, 15, "756680824508223625", 15},
  {1.5322702912632815551757812e+11, 14, "15322702912632815551757813", 12},
  {5.8292264930753367187500000e+13, 16, "582922649307533671875", 14},
  {1.8564327655924964000000000e+16, 20, "18564327655924964", 17},
  {3.3116109505896494080000000e+18, 7, "3311610950589649408", 19},
  {4.2742963771009650000000000e+14, 3, "4274296377100965", 15},
  {2.1727327367518541995184511e-24, 3, "", -3},
  {4.1510537303465423583984375e+09, 7, "41510537303465424", 10},
  {6.4777041089089810848236084e+07, 12, "64777041089089810848", 8},
  {7.1802177792580770721385622e-19, 0, "", 0},
  {4.2485478658177918566400000e+20, 7, "424854786581779185664", 21},
  {1.3695378943585223433312970e-04, 2, "", -2},
  {2.4089868464186564071196160e-20, 15, "", -15},
  {6.1220200637327838067236019e-10, 2, "", -2},
  {2.2101434356547353157126700e-21, 12, "", -12},
  {4.5689222949881616000000000e+16, 18, "45689222949881616", 17},
  {2.8524475780891962349414825e+06, 3, "2852447578", 7},
  {6.1167836699502412229776382e+06, 19, "61167836699502412229776382", 7},
  {6.3279246627274627137738072e-03, 0, "", 0},
  {1.5571618328267229003358807e+02, 9, "155716183283", 3},
  {9.3251755369245886802673340e+07, 2, "9325175537", 8},
  {1.8882139083314428710937500e+11, 11, "18882139083314428710938", 12},
  {4.4127897048996040760127040e-13, 7, "", -7},
  {5.5018631333956281423208727e-08, 11, "5502", -7},
  {7.0576874162053013606055174e+02, 1, "7058", 3},
  {1.8868426656388664245605469e+08, 15, "188684266563886642456055", 9},
  {3.5845908969641928264581201e-17, 20, "3585", -16},
  {3.2552331777443812461569905e+05, 12, "325523317774438125", 6},
  {2.8207548110699626496000000e+20, 16, "28207548110699626496", 21},
  {6.9159978408142019912219212e-01, 8, "69159978", 0},
  {1.0657261663178864640000000e+19, 0, "1065726166317886464", 20},
  {1.7401538279444015433483628e+00, 3, "174", 1},
  {4.5870816641339234441889509e-24, 11, "", -11},
  {2.3391856208863582611083984e+09, 0, "2339185621", 10},
  {1.8575383915026457692931672e+00, 16, "18575383915026458", 1},
  {5.3584994298794472879184441e-14, 3, "", -3},
  {5.6703681948369136263781438e-14, 8, "", -8},
  {1.9739950516149683323874342e+01, 20, "1973995051614968332387", 2},
  {8.0726316076222190856933594e+09, 13, "80726316076222190856934", 10},
  {6.1302382041503266130763432e-06, 12, "6130238", -5},
  {1.9824013695366271950763174e-08, 4, "", -4},
  {1.9941277943977080211725299e-18, 8, "", -8},
  {5.0546006280099257128313184e+05, 14, "50546006280099257128", 6},
  {2.8458600490124465633657711e-20, 11, "", -11},
  {3.6860070407847480964846909e+04, 11, "3686007040784748", 5},
  {3.8809501211945980787277222e+08, 11, "38809501211945980787", 9},
  {4.8861212346254104331010754e-06, 20, "488612123462541", -5},
  {1.2723404066460919062170354e-20, 0, "", 0},
  {1.2264210649271854608488054e-05, 18, "12264210649272", -4},
  {1.9467311804486402250899708e-25, 20, "", -20},
  {1.2307887444939724699037300e-22, 12, "", -12},
  {1.0076370771813249454379458e-03, 14, "100763707718", -2},
  {4.7262441624007125000000000e+13, 17, "47262441624007125", 14},
  {6.1194023697360664062500000e+13, 6, "61194023697360664063", 14},
  {2.6933664771442543945312500e+12, 4, "26933664771442544", 13},
  {3.7828736183084443758066646e-25, 7, "", -7},
  {3.3530840735083697363734245e+06, 19, "33530840735083697363734245", 7},
  {1.5987391037912234992290905e+02, 13, "1598739103791223", 3},
  {6.0105101106787136814091355e+04, 10, "601051011067871", 5},
  {3.8953238824983422220108831e-07, 6, "", -6},
  {3.5341688732304761600000000e+17, 7, "353416887323047616", 18},
  {7.6184511957817599177360535e+07, 8, "761845119578176", 8},
  {2.6263797392568530995049514e+03, 9, "2626379739257", 4},
  {6.8625371066954803466796875e+10, 20, "68625371066954803466796875", 11},
  {6.6815048236849041153443101e-19, 19, "7", -18},
  {5.1048983241653591394424438e+07, 10, "510489832416535914", 8},
  {1.2463001957277207054630708e+02, 11, "12463001957277", 3},
  {1.0947949885453227847888763e-23, 18, "", -18},
  {3.0132051073811331649869409e-10, 17, "30132051", -9},
  {1.2788444887834303647058585e-07, 6, "", -6},
  {2.5534137532074537587344748e-10, 5, "", -5},
  {5.7738467466682977974414825e+07, 9, "57738467466682978", 8},
  {1.2726931757496764062500000e+14, 0, "127269317574968", 15},
  {2.9673669738375942168448960e-15, 11, "", -11},
  {8.3585778664667404800000000e+17, 9, "835857786646674048", 18},
  {3.4395958041048760077810814e-07, 3, "", -3},
  {4.5898289121606389295848771e-01, 8, "45898289", 0},
  {8.2834476616882384214101486e-16, 6, "", -6},
  {7.1341840348440763247947976e-21, 8, "", -8},
  {2.2671962355950547179928023e-03, 9, "2267196", -2},
  {5.1664683529983683740738343e+01, 12, "51664683529984", 2},
  {2.8485309715372592840871536e-20, 13, "", -13},
  {1.0468697632436029570750151e-09, 6, "", -6},
  {5.6834920022363180081015344e+00, 19, "56834920022363180081", 1},
  {1.5074011374965927004814148e+08, 11, "15074011374965927005", 9},
  {1.3322838939155036740943974e-16, 13, "", -13},
  {3.2294795931601157120000000e+18, 7, "3229479593160115712", 19},
  {8.1767734318524330706538342e-14, 2, "", -2},
  {8.6904877929297274065725820e-05, 4, "1", -3},
  {7.7627926305470421875000000e+13, 13, "77627926305470421875", 14},
  {3.1765495595333599299389635e-12, 0, "", 0},
  {1.4733558483010430566400000e+20, 19, "147335584830104305664", 21},
  {4.2916450385371556764107393e-24, 7, "", -7},
  {6.0572645374895528309626916e-14, 3, "", -3},
  {2.3633647133167227722712452e-23, 7, "", -7},
  {2.3421601342203399699865671e-10, 7, "", -7},
  {1.6201589079036691894531250e+12, 14, "1620158907903669189453125", 13},
  {1.4505862791290762500000000e+15, 2, "145058627912907625", 16},
  {6.7160595273586737152000000e+19, 12, "67160595273586737152", 20},
  {3.6647750646761105599580333e+03, 16, "366477506467611056", 4},
  {1.5798568032227611169219017e+07, 20, "1579856803222761116921901703", 8},
  {7.3419516619537761314973068e-01, 4, "7342", 0},
  {1.6157647526987062500000000e+14, 5, "161576475269870625", 15},
  {4.1645393976055459063848052e-04, 17, "41645393976055", -3},
  {7.1377860153894918976108159e-22, 5, "", -5},
  {2.3701388560152797851562500e+12, 7, "23701388560152797852", 13},
  {2.8292898026148264762014151e+04, 10, "282928980261483", 5},
  {9.4053314360530503767495529e-20, 1, "", -1},
  {2.1531519401327695031100827e-22, 9, "", -9},
  {2.1930788907275531250000000e+13, 9, "2193078890727553125", 14},
  {1.4103888395331726121343801e-11, 16, "141039", -10},
  {4.7807845543985172480000000e+18, 1, "4780784554398517248", 19},
  {1.3847774663907644067085879e-24, 8, "", -8},
  {1.3513379593583353856000000e+19, 4, "13513379593583353856", 20},
  {1.1118560404587492444176695e-11, 2, "", -2},
  {4.5216936522066689008170215e+01, 19, "452169365220666890082", 2},
  {1.8032368600237312136716454e-08, 0, "", 0},
  {3.1061342182744701616871302e-17, 17, "3", -16},
  {2.6212246002574673359550160e-24, 2, "", -2},
  {3.2252836452282890240000000e+18, 12, "3225283645228289024", 19},
  {5.6979180626527866359890492e-17, 14, "", -14},
  {5.4371194445322835235856473e+04, 19, "543711944453228352358565", 5},
  {4.3586900043859890441335515e-11, 16, "435869", -10},
  {1.2185051523435613060885861e-10, 17, "12185052", -9},
  {3.1890494604568681165888966e-05, 16, "318904946046", -4},
  {2.5075130137870785000000000e+15, 18, "25075130137870785", 16},
  {1.9996580966331125819124281e+05, 2, "19996581", 6},
  {4.7245837872909672504989152e-24, 13, "", -13},
  {4.2984244280791850585937500e+12, 9, "4298424428079185058594", 13},
  {1.4783047294392170556420751e+02, 2, "14783", 3},
  {1.2769591707881777775668297e+00, 10, "12769591708", 1},
  {4.6563490642375703901052475e+06, 2, "465634906", 7},
  {2.7282345339622909169419174e-02, 17, "2728234533962291", -1},
  {2.6493184199076793774997035e-24, 8, "", -8},
  {2.2999357966862673759460449e+09, 5, "229993579668627", 10},
  {3.5785535855131072000000000e+16, 18, "35785535855131072", 17},
  {2.4172145438417055744000000e+19, 14, "24172145438417055744", 20},
  {7.0031900174235332541598927e-16, 12, "", -12},
  {8.4613927555344107850517077e-05, 6, "85", -4},
  {3.3338812633032081648707390e+06, 10, "33338812633032082", 7},
  {9.4124764147248202048708893e-25, 11, "", -11},
  {9.8755267419606129272353454e-10, 19, "9875526742", -9},
  {2.4635242318034984080020646e-15, 16, "25", -14},
  {6.0508233940495557042404426e-12, 20, "605082339", -11},
  {7.8053491572305517820495879e+02, 10, "7805349157231", 3},
  {3.1821960183548713369600000e+20, 6, "318219601835487133696", 21},
  {2.4817882625121098131798561e-23, 12, "", -12},
  {6.9241088934041908942162991e+04, 6, "69241088934", 5},
  {2.6672768528209180658450350e+04, 18, "2667276852820918065845", 5},
  {4.6346687808511736229706611e-21, 5, "", -5},
  {1.1120376279104739022493815e-21, 15, "", -15},
  {6.7999540154079854488372803e+08, 8, "67999540154079854", 9},
  {3.2423903366439300748915244e-24, 17, "", -17},
  {6.8902775165308797359466553e+08, 7, "689027751653088", 9},
  {1.3641940983017295167043755e-18, 18, "1", -17},
  {4.0846267559140648550400000e+20, 16, "408462675591406485504", 21},
  {5.9624835778958988881220681e-19, 1, "", -1},
  {6.1993536153285579219030162e-24, 6, "", -6},
  {6.7815817574435704955249093e+03, 19, "67815817574435704955249", 4},
  {4.5710541346659624550400000e+20, 19, "457105413466596245504", 21},
  {4.2874200181991604097220261e+01, 20, "4287420018199160409722", 2},
  {9.3757367223647177446400522e-22, 4, "", -4},
  {3.6727829472278249263763428e+08, 8, "36727829472278249", 9},
  {1.3672278268265788269042969e+11, 7, "1367227826826578827", 12},
  {1.8108161443300355000000000e+15, 5, "18108161443300355", 16},
  {5.0593587786446224000000000e+16, 13, "50593587786446224", 17},
  {1.8575522915093128103762865e+06, 8, "185755229150931", 7},
  {8.4656786436386108398437500e+11, 1, "8465678643639", 12},
  {4.7514642408458285033702850e+07, 16, "475146424084582850337029", 8},
  {1.4299475799384903092459270e-21, 10, "", -10},
  {3.4900378316411840820312500e+11, 6, "349003783164118408", 12},
  {3.2340144740113746147122153e-16, 6, "", -6},
  {1.3771186405450481627022857e-11, 17, "1377119", -10},
  {6.3902161775999123456000000e+20, 1, "63902161775999123456", 21},
  {2.5658299850750179030001163e+06, 15, "2565829985075017903", 7},
  {1.0241786142217767155955083e-19, 20, "1", -18},
  {1.6691445298024867316399877e+00, 1, "17", 1},
  {3.3470938659164756536483765e+08, 7, "3347093865916476", 9},
  {1.6793643489644119935264115e-17, 10, "", -10},
  {6.6451215357040119171142578e+09, 7, "66451215357040119", 10},
  {2.0445706948336321602255339e+03, 4, "20445707", 4},
  {7.3702159644203080191005029e+00, 10, "73702159644", 1},
  {1.5068925657367423176765442e+08, 6, "150689256573674", 9},
  {9.0005707752709533691406250e+11, 10, "9000570775270953369141", 12},
  {2.7305906562315683271051022e-11, 12, "27", -10},
  {2.1273829979143113948569600e-20, 17, "", -17},
  {3.2462691212768710937500000e+13, 8, "324626912127687109375", 14},
  {2.6918784563887198455631733e+06, 4, "26918784564", 7},
  {3.5587586379826929013262703e-14, 6, "", -6},
  {8.1666815667317387722625279e-07, 8, "82", -6},
  {1.2466390827324549661625497e+02, 0, "125", 3},
  {8.2909449446082225196855192e-25, 5, "", -5},
  {7.4901010874608719904352414e-22, 11, "", -11},
  {1.9274393256269600906625424e-20, 17, "", -17},
  {8.5016176027625868695740436e-15, 2, "", -2},
  {2.1769543725331045662515697e-25, 19, "", -19},
  {6.7364506283394081876702980e-22, 17, "", -17},
  {4.7095619070686484480000000e+18, 16, "4709561907068648448", 19},
  {1.0063371253988845222764260e-18, 1, "", -1},
  {1.2832372071860399308800000e+20, 4, "128323720718603993088", 21},
  {3.0626287405736928710937500e+12, 6, "3062628740573692871", 13},
  {4.9252181121777145308154769e-11, 15, "49252", -10},
  {1.9777700949817841546973796e+02, 10, "1977770094982", 3},
  {3.2052805743183382893672093e-18, 13, "", -13},
  {1.1684193275315680855754204e-05, 10, "116842", -4},
  {1.0575563460957818750000000e+15, 10, "1057556346095781875", 16},
  {2.0283585734139194625425359e-22, 20, "", -20},
  {3.5206710702879755263488361e-16, 12, "", -12},
  {9.6141615376952946186065674e+07, 0, "96141615", 8},
  {1.6888913713685315366747890e-25, 12, "", -12},
  {1.1543749451248616960000000e+18, 9, "1154374945124861696", 19},
  {1.2078531547747680610018643e-13, 4, "", -4},
  {3.3771866677754667472748088e-09, 5, "", -5},
  {1.1218710703551152500000000e+15, 15, "112187107035511525", 16},
  {1.1526600269789598720000000e+18, 18, "1152660026978959872", 19},
  {3.5834097166502064969550384e-18, 3, "", -3},
  {7.0602954833385553001789958e+01, 16, "70602954833385553", 2},
  {2.2182058713950301287279312e-17, 1, "", -1},
  {3.8054562203820939520244209e-07, 20, "38054562203821", -6},
  {2.5512723156313945398437730e-06, 3, "", -3},
  {3.3522824119907323531597862e-20, 19, "", -19},
  {1.6105829365994674176000000e+19, 0, "16105829365994674176", 20},
  {1.1510902238986264173510512e-15, 2, "", -2},
  {1.6637501556589819335937500e+11, 17, "166375015565898193359375", 12},
  {9.3680873707031905651092529e+07, 13, "936808737070319056511", 8},
  {5.6589011203430023193359375e+09, 12, "5658901120343002319336", 10},
  {2.6418231004582034631011569e-14, 5, "", -5},
  {3.1115586929849507840000000e+19, 8, "3111558692984950784", 20},
  {1.8080916228099001754475728e-03, 9, "1808092", -2},
  {9.4406664740670562500000000e+13, 3, "94406664740670563", 14},
  {8.3305870947095490992069244e+06, 16, "83305870947095490992069", 7},
  {5.8015752883953047820838615e-14, 14, "6", -13},
  {1.7370478895404465108911497e-12, 19, "17370479", -11},
  {1.4253428325879152000000000e+17, 17, "14253428325879152", 18},
  {1.3949424350005958472014767e-17, 15, "", -15},
  {1.5231350799806303977966309e+09, 12, "1523135079980630397797", 10},
  {1.5379637167929657500000000e+15, 17, "153796371679296575", 16},
  {2.3992279629401499054311420e-04, 3, "", -3},
  {5.1670361972908672788507370e-18, 10, "", -10},
  {1.6399787382614898239398630e-09, 15, "1639979", -8},
  {7.3205368691364991473591317e-01, 12, "732053686914", 0},
  {5.0750229845529766237177682e+00, 13, "5075022984553", 1},
  {5.4721395516991439021140893e-09, 17, "547213955", -8},
  {1.5722667396637576818466187e+08, 12, "157226673966375768185", 9},
  {1.0912162924886312037890159e-13, 16, "1091", -12},
  {2.0832661340519211027604763e-12, 11, "", -11},
  {7.8313086735111584000000000e+16, 6, "78313086735111584", 17},
  {1.5567873841902007500000000e+15, 5, "155678738419020075", 16},
  {6.8925720826623429392823431e-20, 9, "", -9},
  {1.7508208406091093842227302e-03, 5, "175", -2},
  {1.0109551207343458628722511e-20, 12, "", -12},
  {6.7246849235086470289446403e-03, 4, "67", -2},
  {5.9600061764294434349387153e-04, 6, "596", -3},
  {1.3198315591210147792748761e-24, 8, "", -8},
  {6.0503343296071092595221526e-15, 6, "", -6},
  {6.0193077644087634325842373e+02, 17, "60193077644087634326", 3},
  {4.7177881981573259172224079e-06, 6, "5", -5},
  {7.6513820764204320907592773e+09, 13, "76513820764204320907593", 10},
  {1.1151770337292277319686588e-08, 2, "", -2},
  {1.4414670820134010165929794e+07, 1, "144146708", 8},
  {2.0014908065717482164840818e-10, 7, "", -7},
  {6.9123155455905966080000000e+18, 12, "6912315545590596608", 19},
  {1.8510941300893600114130884e-23, 6, "", -6},
  {1.7095081162012891293562263e-24, 17, "", -17},
  {2.8176315154645068105310202e+05, 6, "281763151546", 6},
  {2.5517482984309521883720269e-07, 18, "255174829843", -6},
  {3.5446727035323783755302429e+07, 13, "354467270353237837553", 8},
  {5.7939448716908039062500000e+13, 17, "579394487169080390625", 14},
  {1.0999724441905771520000000e+18, 4, "1099972444190577152", 19},
  {2.7246900924434784400529966e-21, 1, "", -1},
  {1.1308791891731833289484049e-04, 7, "1131", -3},
  {4.1103405199651857669756933e-18, 15, "", -15},
  {1.9294828478763728125000000e+14, 8, "19294828478763728125", 15},
  {1.5073985798511224000000000e+16, 14, "15073985798511224", 17},
  {2.6188701318208765000000000e+15, 2, "26188701318208765", 16},
  {2.0239750052310952000000000e+16, 12, "20239750052310952", 17},
  {2.1182880629857547367032559e-23, 9, "", -9},
  {2.2608227588483481413445599e-08, 14, "2260823", -7},
  {5.9952721069704260253906250e+11, 20, "5995272106970426025390625", 12},
  {1.0982989861994576131110080e+04, 15, "10982989861994576131", 5},
  {1.3655007694196308480000000e+18, 3, "1365500769419630848", 19},
  {1.3264301846084134218732987e-07, 10, "1326", -6},
  {2.0166893372571578311180929e+03, 0, "2017", 4},
  {2.3145416441582079278305173e+05, 13, "2314541644158207928", 6},
  {3.3830854769412501606495589e-09, 2, "", -2},
  {1.5336767820461235046386719e+09, 8, "15336767820461235", 10},
  {1.8083104716075412032659392e-17, 14, "", -14},
  {8.9379857712581527368934931e-06, 17, "893798577126", -5},
  {1.9208546189870548190015108e-18, 17, "", -17},
  {8.0434144313294941406250000e+12, 8, "804341443132949414063", 13},
  {2.9679831740246217250311916e-18, 11, "", -11},
  {3.6248279655091020759374431e-07, 13, "3624828", -6},
  {2.3284435745901450875994243e-02, 15, "23284435745901", -1},
  {1.6257789879527805994913906e-12, 20, "162577899", -11},
  {2.4285626250468332000000000e+16, 14, "24285626250468332", 17},
  {3.8626293439283383789062500e+12, 6, "3862629343928338379", 13},
  {6.7250727517723374387200000e+20, 18, "672507275177233743872", 21},
  {1.4181759967816467451484641e+03, 6, "1418175997", 4},
  {9.6899716166873566412800000e+20, 19, "968997161668735664128", 21},
  {5.7571442300603046537769465e-17, 9, "", -9},
  {9.4142583431354451619482944e-12, 5, "", -5},
  {1.5584553396765825659974296e-25, 20, "", -20},
  {1.9774198319223064423955094e-03, 9, "197742", -2},
  {1.0875108552267381848042849e-21, 12, "", -12},
  {1.5238800586667698621749878e+08, 5, "15238800586668", 9},
  {1.1315022222124198079109192e+08, 18, "113150222221241980791091919", 9},
  {1.2075621153942471292432458e-11, 9, "", -9},
  {2.3115834430292244480000000e+18, 15, "2311583443029224448", 19},
  {4.4991331798549706250000000e+14, 14, "4499133179854970625", 15},
  {3.0507178373854084823043601e-15, 0, "", 0},
  {3.3048937588273431328877576e-08, 8, "3", -7},
  {9.2458209586246773600578308e+07, 11, "924582095862467736", 8},
  {1.5848675472810864968947259e-20, 3, "", -3},
  {3.0904335617890372339688909e-03, 15, "3090433561789", -2},
  {4.8430902403722617600000000e+17, 16, "484309024037226176", 18},
  {8.5463744819475055858912731e-09, 14, "854637", -8},
  {3.0145439268457257999279247e-05, 7, "301", -4},
  {3.0188380556981436000000000e+16, 18, "30188380556981436", 17},
  {6.0261344027102405761932734e-18, 11, "", -11},
  {4.7872891575116538776137989e-10, 4, "", -4},
  {1.1707439318272454510203132e-11, 14, "1171", -10},
  {1.0198470123976684310170163e-17, 16, "", -16},
  {2.8655305193146064453125000e+12, 18, "28655305193146064453125", 13},
  {3.5626814070003438514322447e-03, 11, "356268141", -2},
  {5.6944793276501631980324181e-04, 6, "569", -3},
  {6.4422788156060054687500000e+13, 3, "64422788156060055", 14},
  {1.5674589366960057600000000e+17, 17, "156745893669600576", 18},
  {1.7492634537059886107313034e-03, 11, "174926345", -2},
  {1.5147861574609105834304801e-03, 14, "151478615746", -2},
  {7.5142407013780690051359606e-20, 6, "", -6},
  {7.7210667443742110951920843e-03, 15, "7721066744374", -2},
  {9.4827148209330180251202817e-19, 13, "", -13},
  {3.6041793977609020955841243e-21, 13, "", -13},
  {1.3022405073376001382712275e+04, 3, "13022405", 5},
  {4.0121684476794939510019625e-06, 13, "40121684", -5},
  {1.5870894903275179862976074e+08, 11, "15870894903275179863", 9},
  {2.4233835468543065625000000e+14, 7, "24233835468543065625", 15},
  {3.9049991358453930000000000e+15, 19, "3904999135845393", 16},
  {2.7399330340743933105468750e+11, 20, "2739933034074393310546875", 12},
  {1.7983977381960378123739251e-10, 1, "", -1},
  {3.8042748722024880349636078e+07, 1, "380427487", 8},
  {2.9922437533840554740871553e-02, 2, "3", -1},
  {1.3799914966660860600334843e-24, 14, "", -14},
  {9.8784513495084922851674492e+02, 19, "9878451349508492285167", 3},
  {3.9838217126937425928190351e+05, 18, "398382171269374259281904", 6},
  {4.6816871735208222867521283e-25, 1, "", -1},
  {1.9580921256920450832694769e+06, 12, "1958092125692045083", 7},
  {3.4195971632314955476413723e-19, 2, "", -2},
  {5.2198124045621856689453125e+10, 15, "52198124045621856689453125", 11},
  {2.4426486615517206490039825e+07, 6, "24426486615517", 8},
  {1.2428432689980518484844077e-14, 20, "1242843", -13},
  {1.1741970426691418457031250e+11, 13, "1174197042669141845703125", 12},
  {4.4308455619746416807174683e+07, 8, "4430845561974642", 8},
  {1.3258692163155164413456548e-21, 8, "", -8},
  {1.8014437003446739075538871e-05, 15, "18014437003", -4},
  {5.1167001714541854750478819e-08, 14, "51167", -7},
  {2.3531884734830632805824280e+08, 9, "235318847348306328", 9},
  {4.4261065291241635840000000e+19, 7, "4426106529124163584", 20},
  {1.2325270448171103537668902e-06, 20, "123252704481711", -5},
  {1.0461861392721388750000000e+15, 6, "1046186139272138875", 16},
  {3.1056388243649124101164162e-19, 18, "", -18},
  {8.5825419895207893645786511e-08, 15, "8582542", -7},
  {5.8157983429197881127259345e-12, 1, "", -1},
  {1.3643111032724101992293223e-25, 7, "", -7},
  {9.5626491780484406613323210e-19, 10, "", -10},
  {2.6558655959821535930132086e+01, 14, "2655865595982154", 2},
  {3.3377251165555365150794387e+05, 13, "3337725116555536515", 6},
  {2.6989833069797253906250000e+13, 4, "269898330697972539", 14},
  {6.7362785292714776580324014e-21, 10, "", -10},
  {5.0009941183240038035979746e-20, 20, "5", -19},
  {5.8938059625003179535269737e+06, 8, "589380596250032", 7},
  {1.4307515924841902000000000e+16, 1, "14307515924841902", 17},
  {1.2057058502295262729722691e-04, 19, "1205705850229526", -3},
  {1.7419711714208781719207764e+07, 4, "174197117142", 8},
  {5.4668110744217541068792343e+06, 16, "54668110744217541068792", 7},
  {4.3434504869453125000000000e+11, 17, "43434504869453125", 12},
  {3.4319435635878637562323006e-22, 14, "", -14},
  {7.9606493254947068294313794e+00, 12, "7960649325495", 1},
  {1.2933136270277413725852966e+08, 9, "129331362702774137", 9},
  {1.0002094368603143692016602e+09, 1, "10002094369", 10},
  {1.6966278029466490880000000e+19, 5, "1696627802946649088", 20},
  {6.1682062178305894136428833e+07, 11, "6168206217830589414", 8},
  {2.8128770295629054307937622e+08, 5, "28128770295629", 9},
  {1.2432402721704129408891916e-16, 18, "124", -15},
  {1.9029513425246521158450529e-09, 7, "", -7},
  {1.0271448096688558267200468e-23, 15, "", -15},
  {7.8473175243699988641310483e+03, 5, "784731752", 4},
  {3.1872596427191661834716797e+10, 19, "31872596427191661834716796875", 11},
  {5.3780981968865104896555037e-08, 11, "5378", -7},
  {9.8498787750156814575195312e+10, 8, "9849878775015681458", 11},
  {1.4030851406093728335787520e-13, 1, "", -1},
  {1.2227358743461744228220311e-01, 18, "122273587434617442", 0},
  {5.9268774591621579020284116e+04, 8, "5926877459162", 5},
  {2.4793865694729607577600000e+20, 6, "247938656947296075776", 21},
  {4.7990014168031692982760249e-12, 2, "", -2},
  {4.5087617118406190780135824e-11, 10, "", -10},
  {1.7421478477378697727844063e-11, 6, "", -6},
  {4.8915664034836598205582384e-18, 11, "", -11},
  {1.1780400266007420084882086e-23, 15, "", -15},
  {1.6870325478270968919227138e-15, 2, "", -2},
  {8.7281502932926517855987367e-23, 11, "", -11},
  {2.2884776379589556682958573e+01, 10, "228847763796", 2},
  {3.5516703846597533177580943e-18, 13, "", -13},
  {1.7654335627421022536509554e+02, 7, "1765433563", 3},
  {2.0589461322258685383480921e-22, 7, "", -7},
  {2.0278395922275064465986113e-15, 9, "", -9},
  {9.8723085677409957634964219e-16, 13, "", -13},
  {8.8978597826060764480748944e-04, 1, "", -1},
  {7.4910018893298699918317956e-10, 12, "749", -9},
  {1.1323037301153671680000000e+18, 6, "1132303730115367168", 19},
  {1.1087161683658862113952637e+09, 11, "11087161683658862114", 10},
  {1.3911621744333076640032232e+05, 16, "1391162174433307664003", 6},
  {4.0839125080966199748218060e+06, 5, "40839125081", 7},
  {1.9606066509069592070889636e-07, 12, "196061", -6},
  {1.5311439914297465625000000e+14, 4, "1531143991429746563", 15},
  {3.0745562003712179274961879e-16, 15, "", -15},
  {5.9182820652660443616621677e-02, 15, "5918282065266", -1},
  {3.5820991439042029091335506e-09, 20, "35820991439", -8},
  {2.8001440236639930590124728e-07, 12, "280014", -6},
  {8.2095163826595941948895231e-17, 11, "", -11},
  {1.0462076732370262106996961e+04, 4, "104620767", 5},
  {2.1015028277305291571200000e+20, 13, "210150282773052915712", 21},
  {7.9108958136523635864257812e+10, 11, "7910895813652363586426", 11},
  {3.9248585502831074218750000e+12, 7, "39248585502831074219", 13},
  {9.3047018057221637399022416e-24, 20, "", -20},
  {4.9503557184988134957465674e-16, 9, "", -9},
  {6.9107368415163792363387074e+00, 9, "6910736842", 1},
  {3.1342442467109995050122961e+04, 9, "3134244246711", 5},
  {1.6838501775663118564807519e+01, 20, "1683850177566311856481", 2},
  {1.9244383863574714355468750e+12, 18, "1924438386357471435546875", 13},
  {5.7725942751075572446353963e-18, 2, "", -2},
  {2.0765690258181111857993528e+03, 15, "2076569025818111186", 4},
  {1.1337082001164316348057408e-21, 4, "", -4},
  {3.7483282208355707460285155e-12, 20, "374832822", -11},
  {1.2597924904451202019117773e+05, 0, "125979", 6},
  {1.9225014100945666793128467e-21, 17, "", -17},
  {4.4013428521741142578125000e+12, 14, "44013428521741142578125", 13},
  {4.7592388680195922851562500e+11, 12, "475923886801959228515625", 12},
  {6.4256391970932371914386749e+06, 16, "64256391970932371914387", 7},
  {1.1616349845824123535156250e+12, 15, "1161634984582412353515625", 13},
  {6.6587785049504254857311025e+03, 9, "665877850495", 4},
  {1.9865411366498944698832929e+05, 2, "19865411", 6},
  {2.8420813271355781120000000e+18, 20, "2842081327135578112", 19},
  {1.3277531727275097448032513e-21, 15, "", -15},
  {2.0998203991596050000000000e+14, 6, "2099820399159605", 15},
  {1.3524084219552943389886651e-05, 8, "1352", -4},
  {2.5237290327550697838887572e+04, 3, "2523729", 5},
  {3.2272855788993783889785786e-19, 16, "", -16},
  {4.3178334523766881227493286e+08, 4, "4317833452377", 9},
  {4.2367172387769733177265152e+02, 18, "423671723877697331773", 3},
  {2.4456944980592253988750853e-21, 14, "", -14},
  {2.1169489079511639127717526e-03, 16, "21169489079512", -2},
  {1.5489571400491134074004480e-24, 10, "", -10},
  {1.7220647873958388671875000e+13, 5, "1722064787395838867", 14},
  {1.0206964502099305502902382e-02, 10, "102069645", -1},
  {1.4692473591886451840400696e+08, 0, "146924736", 9},
  {5.6122658880695011033210052e-15, 11, "", -11},
  {9.4619560122038425000000000e+14, 12, "94619560122038425", 15},
  {1.3267686788157230616301652e-15, 0, "", 0},
  {2.5405776113147377154996760e-07, 0, "", 0},
  {1.6870633053747409006293004e-12, 14, "169", -11},
  {2.4339331957770942373591237e-11, 2, "", -2},
  {2.7251331317140659200000000e+18, 9, "272513313171406592", 19},
  {1.4745721247549522558983881e+03, 5, "147457212", 4},
  {1.6310849534291504824068397e+04, 3, "1631085", 5},
  {7.3579273940507216796875000e+12, 0, "7357927394051", 13},
  {3.8189808105897963047027588e+07, 20, "3818980810589796304702758789", 8},
  {2.0403734258855272960000000e+18, 7, "2040373425885527296", 19},
  {2.3205445698996153986795622e-10, 13, "2321", -9},
  {3.1634802781840187311172485e+08, 14, "31634802781840187311172", 9},
  {8.1846076782639687556687634e-22, 8, "", -8},
  {2.2114791164075040000000000e+15, 17, "2211479116407504", 16},
  {1.1117820772595465086853028e-22, 16, "", -16},
  {2.5656022772353180999590933e-08, 7, "", -7},
  {3.4277867681277426892272331e-02, 12, "34277867681", -1},
  {1.1704380464137219238281250e+11, 1, "1170438046414", 12},
  {7.5812565604483460759107590e-10, 15, "758126", -9},
  {3.2601995785833879359927323e+00, 11, "326019957858", 1},
  {9.0817664731825756034767906e-15, 2, "", -2},
  {2.8514942747879550408400148e-12, 10, "", -10},
  {1.1819441852351456608005977e-11, 3, "", -3},
  {2.5572003545119365019999691e-01, 16, "2557200354511937", 0},
  {8.2421265649618301131519415e-25, 15, "", -15},
  {5.3049604117412132263183594e+10, 5, "5304960411741213", 11},
  {3.1938912345051261901855469e+10, 6, "31938912345051262", 11},
  {1.4145857257379148453438638e-15, 20, "141459", -14},
  {2.7321236317752337455749512e+09, 4, "27321236317752", 10},
  {6.3884581656068824000000000e+16, 18, "63884581656068824", 17},
  {5.0059038204548120114602375e-23, 8, "", -8},
  {3.3374093488052238665002563e-06, 15, "3337409349", -5},
  {1.1126875719941743360000000e+18, 7, "1112687571994174336", 19},
  {2.7380727625214009712806273e+00, 3, "2738", 1},
  {2.3380957977895974479312544e-11, 9, "", -9},
  {7.5563445575808892026543617e+06, 0, "7556345", 7},
  {4.5415111560631618952896831e-17, 12, "", -12},
  {1.0877212611081946147528754e-01, 17, "10877212611081946", 0},
  {6.2027973457680580139160156e+10, 5, "6202797345768058", 11},
  {1.0145629533529786948931051e-03, 19, "10145629533529787", -2},
  {4.9068763301408879762277593e-01, 20, "49068763301408879762", 0},
  {1.2209563964581424604562067e-16, 15, "", -15},
  {7.8512421267433200508150029e-16, 9, "", -9},
  {6.2628337384739173889160156e+10, 5, "6262833738473917", 11},
  {7.8029396011096155643463135e+08, 17, "78029396011096155643463135", 9},
  {4.1500054516500764132830517e-24, 14, "", -14},
  {2.5747787495220065992401562e-22, 8, "", -8},
  {2.7735450082442895700719402e-08, 10, "277", -7},
  {4.6710200944819679687500000e+13, 16, "467102009448196796875", 14},
  {1.7318401921969324755955222e-04, 11, "17318402", -3},
  {2.6481827191249915000000000e+15, 4, "26481827191249915", 16},
  {4.9657494395923854944092958e-18, 18, "5", -17},
  {4.3587689402154241943359375e+11, 8, "43587689402154241943", 12},
  {3.5693430074197888183593750e+11, 6, "356934300741978882", 12},
  {4.8200899078695280640000000e+18, 11, "4820089907869528064", 19},
  {1.1137337013717951882328279e-18, 11, "", -11},
  {3.8003160380796490292283689e-10, 8, "", -8},
  {1.1123312406647725001486953e-12, 16, "11123", -11},
  {1.7627849247210385920000000e+18, 13, "1762784924721038592", 19},
  {4.1506661806301520000000000e+16, 7, "4150666180630152", 17},
  {2.6542469078324287414550781e+10, 18, "2654246907832428741455078125", 11},
  {1.9842762307183963434934881e-07, 13, "1984276", -6},
  {7.7216774981643875435111113e+03, 8, "772167749816", 4},
  {2.2070768508129175176440617e-22, 12, "", -12},
  {1.3300181449746911205723587e-06, 12, "1330018", -5},
  {1.8760807162080267440629200e-01, 12, "187608071621", 0},
  {5.8329271306603886620978372e-03, 13, "58329271307", -2},
  {1.0461419821490735443960771e-23, 3, "", -3},
  {1.4425558186148927637409995e-12, 17, "144256", -11},
  {4.9075730589327463033221753e-20, 4, "", -4},
  {3.3613604571076814409025246e+02, 15, "336136045710768144", 3},
  {9.2396216869695706463971874e+01, 12, "92396216869696", 2},
  {2.0624824024189908902551154e-08, 3, "", -3},
  {2.4406788319975281087437224e-01, 10, "2440678832", 0},
  {6.5796363624089336395263672e+09, 18, "6579636362408933639526367188", 10},
  {5.0476242812366716948755402e-23, 16, "", -16},
  {3.7378184374911222923954304e-06, 1, "", -1},
  {3.6178678921348133683200000e+20, 11, "361786789213481336832", 21},
  {8.7935443929167480468750000e+10, 19, "8793544392916748046875", 11},
  {5.2963867137771299333397074e-25, 13, "", -13},
  {1.1553362240671134486547089e+01, 4, "115534", 2},
  {2.1559473544294178282143548e+01, 10, "215594735443", 2},
  {8.3287701603143894672393799e+08, 10, "8328770160314389467", 9},
  {2.1496565131480622558593750e+12, 14, "2149656513148062255859375", 13},
  {1.2317125113064230745862915e+01, 8, "1231712511", 2},
  {2.4856287376698529278939986e+00, 1, "25", 1},
  {1.3268568440574302426938213e-16, 5, "", -5},
  {1.1701126085975115064482625e-13, 17, "11701", -12},
  {9.4728026543727544844407037e-06, 14, "947280265", -5},
  {4.4462706770292452685694891e-10, 8, "", -8},
  {1.7465387491642539979608274e-10, 19, "1746538749", -9},
  {6.6454598975170214400000000e+17, 13, "664545989751702144", 18},
  {2.1460880052379312249139615e-19, 17, "", -17},
  {5.1290813173250968069380475e-23, 20, "", -20},
  {2.1492171279940228907929841e-09, 16, "21492171", -8},
  {1.2104162691003724004937556e-09, 18, "1210416269", -8},
  {8.4251793656164402031466606e-17, 6, "", -6},
  {2.8408442509101437117857714e-03, 12, "2840844251", -2},
  {1.6277826392595563102084097e-21, 7, "", -7},
  {5.2848752421467696000000000e+16, 18, "52848752421467696", 17},
  {1.2932513821506566155165559e-07, 16, "1293251382", -6},
  {9.5655561474696886539459229e+08, 8, "95655561474696887", 9},
  {4.8838777561042233600000000e+17, 15, "488387775610422336", 18},
  {9.4428304179498450300185531e-21, 5, "", -5},
  {3.5303613481749689526623115e+03, 2, "353036", 4},
  {1.8960290225659471161634428e+03, 11, "189602902256595", 4},
  {2.2202394454266687466490365e-20, 20, "2", -19},
  {1.7147855743239479124895297e+03, 16, "17147855743239479125", 4},
  {2.5829562714991052052937448e+05, 6, "25829562715", 6},
  {4.3553699576153308153152466e+07, 14, "4355369957615330815315", 8},
  {2.4143214300010180295430473e+02, 8, "241432143", 3},
  {9.7577244536479320787327456e-21, 16, "", -16},
  {3.5366312344050289868800000e+20, 13, "353663123440502898688", 21},
  {5.5227668838660681771557392e-01, 14, "55227668838661", 0},
  {3.8904938873663661515434868e-09, 3, "", -3},
  {3.8730914828317262232303619e+07, 5, "3873091482832", 8},
  {2.2514249017382560825526403e-10, 1, "", -1},
  {5.4239222829707693781558966e-09, 11, "542", -8},
  {3.4013327857399168014526367e+09, 5, "340133278573992", 10},
  {3.7451871549780577484800000e+20, 12, "374518715497805774848", 21},
  {5.3842289168149093750000000e+13, 16, "5384228916814909375", 14},
  {3.3792566436514274090219944e-18, 6, "", -6},
  {1.0284197637697821019573203e-23, 15, "", -15},
  {4.0013933931071694641954631e-22, 1,