% Rust documentation

<!-- Completely hide the TOC and the section numbers -->
<style type="text/css">
#TOC { display: none; }
.header-section-number { display: none; }
li {list-style-type: none; }
</style>

* [The Rust tutorial](tutorial.html)  (* [PDF](tutorial.pdf))
* [The Rust reference manual](rust.html) (* [PDF](rust.pdf))

# Guides

* [Pointers](guide-pointers.html)
* [References and Lifetimes](guide-lifetimes.html)
* [Containers and Iterators](guide-container.html)
* [Tasks and Communication](guide-tasks.html)
* [Foreign Function Interface](guide-ffi.html)
* [Writing Safe Unsafe and Low-Level Code](guide-unsafe.html)
* [Macros](guide-macros.html)
* [Testing](guide-testing.html)
* [Rust's Runtime](guide-runtime.html)

# Libraries

* [The standard library, `std`](std/index.html)

<!-- force the two lists to be separate -->

* [The `arena` allocation library](arena/index.html)
* [The `collections` library](collections/index.html)
* [The `flate` compression library](flate/index.html)
* [The `fourcc` four-character code library](fourcc/index.html)
* [The `getopts` argument parsing library](getopts/index.html)
* [The `glob` file path matching library](glob/index.html)
* [The `green` M:N runtime library](green/index.html)
* [The `hexfloat` library for hexadecimal floating-point literals](hexfloat/index.html)
* [The `native` 1:1 threading runtime](native/index.html)
* [The `num` arbitrary precision numerics library](num/index.html)
* [The `rand` library for random numbers and distributions](rand/index.html)
* [The `rustc` compiler](rustc/index.html)
* [The `rustuv` M:N I/O library](rustuv/index.html)
* [The `semver` version collation library](semver/index.html)
* [The `serialize` value encoding/decoding library](serialize/index.html)
* [The `sync` library for concurrency-enabled mechanisms and primitives](sync/index.html)
* [The `syntax` library, the Rust parser](syntax/index.html)
* [The `term` terminal-handling library](term/index.html)
* [The `test` library containing the unit-testing & micro-benchmark framework](test/index.html)
* [The `time` library](time/index.html)
* [The `uuid` 128-bit universally unique identifier library](uuid/index.html)
* [The `url` library](url/index.html)
* [The `workcache` library](workcache/index.html)
* [The `log` library](log/index.html)

# Tooling

* [The `rustdoc` manual](rustdoc.html)

# FAQs

* [Language FAQ](complement-lang-faq.html)
* [Project FAQ](complement-project-faq.html)
* [Code cheatsheet](complement-cheatsheet.html) - "How do I do X?"
* [How to submit a bug report](complement-bugreport.html)

# External resources

* The Rust [IRC channel](http://chat.mibbit.com/?server=irc.mozilla.org&channel=%23rust) - `#rust` on irc.mozilla.org
* The Rust community on [Reddit](http://reddit.com/r/rust)
* The Rust [wiki](http://github.com/mozilla/rust/wiki)
