Writing Documentation
=====================

Luigi uses [Sphinx](http://sphinx-doc.org/) to generated documentation. Sphinx
can be installed via `pip install sphinx` after which `html` docs can be
generated by running `make html` in the directory containing this file.

Sphinx uses ReStructuredText (RST) markup. There's a good
[quickstart](http://docutils.sourceforge.net/docs/user/rst/quickstart.html)
describing the syntax. We also use the sphinx [autodoc](http://sphinx-
doc.org/ext/autodoc.html) functionality to parse docstrings. For examples of
cross-referencing modules/libraries/classes and for documentatingfunction/method
arguments, see docs on [the python domain](http://sphinx-doc.org/domains.html#the-python-domain).

API Documentation
-----------------

API Documentation is auto-generated with the sphinx [autosummary](http://sphinx-
doc.org/ext/autosummary.html) extension. This requires stub files (stored in
`doc/api`) which describe all the modules and packages in luigi. Thus, if any
new packages or modules are introduced, you need to regenerate those files. To
do so, go to the root of the repository and run: `sphinx-apidoc -o doc/api -T
luigi` then commit the changes to `doc/api`.
