module Juvix.Compiler.Reg.Keywords
  ( module Juvix.Compiler.Reg.Keywords,
    module Juvix.Compiler.Tree.Keywords.Base,
    module Juvix.Data.Keyword.All,
  )
where

import Juvix.Compiler.Tree.Keywords.Base
import Juvix.Data.Keyword.All
  ( kwAdd_,
    kwAlloc,
    kwArgsNum,
    kwAtoi,
    kwBr,
    kwCAlloc,
    kwCCall,
    kwCCallTail,
    kwCExtend,
    kwCall,
    kwCallTail,
    kwCase,
    kwDefault,
    kwDiv_,
    kwDollar,
    kwDump,
    kwEcOp,
    kwEq,
    kwEq_,
    kwFail,
    kwFieldAdd,
    kwFieldDiv,
    kwFieldMul,
    kwFieldSub,
    kwIf,
    kwLe_,
    kwLive,
    kwLt_,
    kwMod_,
    kwMul_,
    kwNop,
    kwPoseidon,
    kwPrealloc,
    kwRandomEcPoint,
    kwRet,
    kwShow,
    kwStrcat,
    kwSub_,
    kwTrace,
  )
import Juvix.Prelude

allKeywordStrings :: HashSet Text
allKeywordStrings = keywordsStrings allKeywords

allKeywords :: [Keyword]
allKeywords =
  baseKeywords
    ++ [ kwNop,
         kwAdd_,
         kwSub_,
         kwMul_,
         kwDiv_,
         kwMod_,
         kwLt_,
         kwLe_,
         kwEq_,
         kwFieldAdd,
         kwFieldDiv,
         kwFieldMul,
         kwFieldSub,
         kwStrcat,
         kwEcOp,
         kwEq,
         kwIf,
         kwShow,
         kwAtoi,
         kwTrace,
         kwDump,
         kwPrealloc,
         kwAlloc,
         kwCAlloc,
         kwCExtend,
         kwCall,
         kwCallTail,
         kwLive,
         kwCCall,
         kwCCallTail,
         kwRet,
         kwBr,
         kwCase,
         kwFail,
         kwArgsNum,
         kwPoseidon,
         kwRandomEcPoint
       ]
