---
id: react-native
title: Usage with React Native
---

Tanstack Form is headless and it should support React Native out-of-the-box without needing any additional configuration.

Here is an example:

```tsx
<form.Field
  name="age"
  validators={{
    onChange: val => val < 13 ? "You must be 13 to make an account" : undefined
  }}
>
  {field => (
    <>
      <Text>Age:</Text>
      <TextInput value={field.state.value} onChangeText={handleChange} />
      {
        field.state.meta.errors
          ? <Text>{field.state.meta.errors.join(', ')}</Text>
          : null
      }
    </>
  )}
</form.Field>
```
