/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.Date;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.DateTimeCalc;
import mondrian.calc.DimensionCalc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.VoidCalc;
import mondrian.calc.impl.AbstractCalc;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;

public abstract class GenericCalc
extends AbstractCalc
implements TupleCalc,
StringCalc,
IntegerCalc,
DoubleCalc,
BooleanCalc,
DateTimeCalc,
VoidCalc,
MemberCalc,
LevelCalc,
HierarchyCalc,
DimensionCalc {
    protected GenericCalc(Exp exp) {
        super(exp, null);
    }

    protected GenericCalc(Exp exp, Calc[] calcs) {
        super(exp, calcs);
    }

    @Override
    public Member[] evaluateTuple(Evaluator evaluator) {
        return (Member[])this.evaluate(evaluator);
    }

    private String msg(TypeEnum expectedType, Object o) {
        TypeEnum actualType = GenericCalc.actualType(o);
        return "Expected value of type " + (Object)((Object)expectedType) + "; got value '" + o + "' (" + (actualType == null ? o.getClass() : actualType) + ")";
    }

    private static TypeEnum actualType(Object o) {
        if (o == null) {
            return TypeEnum.NULL;
        }
        if (o instanceof String) {
            return TypeEnum.STRING;
        }
        if (o instanceof Boolean) {
            return TypeEnum.BOOLEAN;
        }
        if (o instanceof Number) {
            return TypeEnum.NUMERIC;
        }
        if (o instanceof Date) {
            return TypeEnum.DATETIME;
        }
        if (o instanceof Member) {
            return TypeEnum.MEMBER;
        }
        if (o instanceof Level) {
            return TypeEnum.LEVEL;
        }
        if (o instanceof Hierarchy) {
            return TypeEnum.HIERARCHY;
        }
        if (o instanceof Dimension) {
            return TypeEnum.DIMENSION;
        }
        return null;
    }

    @Override
    public String evaluateString(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        try {
            return (String)o;
        }
        catch (ClassCastException e) {
            throw evaluator.newEvalException(null, this.msg(TypeEnum.STRING, o));
        }
    }

    @Override
    public int evaluateInteger(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        try {
            Number number = (Number)o;
            return number == null ? -2147483647 : number.intValue();
        }
        catch (ClassCastException e) {
            throw evaluator.newEvalException(null, this.msg(TypeEnum.NUMERIC, o));
        }
    }

    @Override
    public double evaluateDouble(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        try {
            Number number = (Number)o;
            return GenericCalc.numberToDouble(number);
        }
        catch (ClassCastException e) {
            throw evaluator.newEvalException(null, this.msg(TypeEnum.NUMERIC, o));
        }
    }

    public static double numberToDouble(Number number) {
        return number == null ? 1.2345E-8 : number.doubleValue();
    }

    @Override
    public boolean evaluateBoolean(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        try {
            return (Boolean)o;
        }
        catch (ClassCastException e) {
            throw evaluator.newEvalException(null, this.msg(TypeEnum.BOOLEAN, o));
        }
    }

    @Override
    public Date evaluateDateTime(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        try {
            return (Date)o;
        }
        catch (ClassCastException e) {
            throw evaluator.newEvalException(null, this.msg(TypeEnum.DATETIME, o));
        }
    }

    @Override
    public void evaluateVoid(Evaluator evaluator) {
        Object result = this.evaluate(evaluator);
        assert (result == null);
    }

    @Override
    public Member evaluateMember(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        try {
            return (Member)o;
        }
        catch (ClassCastException e) {
            throw evaluator.newEvalException(null, this.msg(TypeEnum.MEMBER, o));
        }
    }

    @Override
    public Level evaluateLevel(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        try {
            return (Level)o;
        }
        catch (ClassCastException e) {
            throw evaluator.newEvalException(null, this.msg(TypeEnum.LEVEL, o));
        }
    }

    @Override
    public Hierarchy evaluateHierarchy(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        try {
            return (Hierarchy)o;
        }
        catch (ClassCastException e) {
            throw evaluator.newEvalException(null, this.msg(TypeEnum.HIERARCHY, o));
        }
    }

    @Override
    public Dimension evaluateDimension(Evaluator evaluator) {
        Object o = this.evaluate(evaluator);
        try {
            return (Dimension)o;
        }
        catch (ClassCastException e) {
            throw evaluator.newEvalException(null, this.msg(TypeEnum.DIMENSION, o));
        }
    }

    private static enum TypeEnum {
        NULL,
        BOOLEAN,
        STRING,
        NUMERIC,
        DATETIME,
        MEMBER,
        LEVEL,
        HIERARCHY,
        DIMENSION;

    }
}

