/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.HashMap;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.util.ArrayStack;

public class QueryTiming {
    private boolean enabled;
    private final ArrayStack<TimingInfo> currentTimings = new ArrayStack();
    private final HashMap<String, Integer> currentTimingDepth = new HashMap();
    private final Map<String, DurationCount> timings = new HashMap<String, DurationCount>();
    private final Map<String, DurationCount> fullTimings = new HashMap<String, DurationCount>();

    public void init(boolean enabled) {
        this.enabled = enabled;
        this.currentTimings.clear();
        this.timings.clear();
        this.fullTimings.clear();
    }

    public void done() {
    }

    public final void markStart(String name) {
        if (this.enabled) {
            this.markStartInternal(name);
        }
    }

    public final void markEnd(String name) {
        if (this.enabled) {
            long tstamp = System.currentTimeMillis();
            this.markEndInternal(name, tstamp);
        }
    }

    public final synchronized void markFull(String name, long duration) {
        if (this.enabled) {
            this.markFullInternal(name, duration);
        }
    }

    private void markStartInternal(String name) {
        this.currentTimings.push(new TimingInfo(name));
        Integer depth = this.currentTimingDepth.get(name);
        if (depth == null) {
            this.currentTimingDepth.put(name, 1);
        } else {
            this.currentTimingDepth.put(name, depth + 1);
        }
    }

    private void markEndInternal(String name, long tstamp) {
        if (this.currentTimings.isEmpty() || !this.currentTimings.peek().name.equals(name)) {
            throw new IllegalStateException("end but no start for " + name);
        }
        TimingInfo finished = this.currentTimings.pop();
        assert (finished.name.equals(name));
        finished.markEnd(tstamp);
        DurationCount dc = this.timings.get(finished.name);
        if (dc == null) {
            dc = new DurationCount();
            this.timings.put(finished.name, dc);
        }
        ++dc.count;
        Integer depth = this.currentTimingDepth.get(name);
        if (depth == 1) {
            dc.duration += finished.endTime - finished.startTime;
        }
        this.currentTimingDepth.put(name, depth - 1);
    }

    private void markFullInternal(String name, long duration) {
        DurationCount p = this.fullTimings.get(name);
        if (p == null) {
            p = new DurationCount();
            this.fullTimings.put(name, p);
        }
        ++p.count;
        p.duration += duration;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Query Timing (Cumulative):");
        for (Map.Entry<String, DurationCount> entry : this.timings.entrySet()) {
            sb.append(Util.nl);
            sb.append(entry.getKey()).append(" invoked ").append(entry.getValue().count).append(" times for total of ").append(entry.getValue().duration).append("ms.  (Avg. ").append(entry.getValue().duration / entry.getValue().count).append("ms/invocation)");
        }
        for (Map.Entry<String, DurationCount> entry : this.fullTimings.entrySet()) {
            if (sb.length() > 0) {
                sb.append(Util.nl);
            }
            sb.append(entry.getKey()).append(" invoked ").append(entry.getValue().count).append(" times for total of ").append(entry.getValue().duration).append("ms.  (Avg. ").append(entry.getValue().duration / entry.getValue().count).append("ms/invocation)");
        }
        sb.append(Util.nl);
        return sb.toString();
    }

    private static class DurationCount {
        long duration;
        long count;

        private DurationCount() {
        }
    }

    private static class TimingInfo {
        private final String name;
        private final long startTime;
        private long endTime;

        private TimingInfo(String name) {
            this.name = name;
            this.startTime = System.currentTimeMillis();
        }

        private void markEnd(long tstamp) {
            this.endTime = tstamp;
        }
    }
}

