/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.List;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.server.Execution;
import mondrian.server.Statement;
import org.apache.logging.log4j.Logger;

public abstract class ResultBase
implements Result {
    protected final Execution execution;
    protected final Statement statement;
    protected final Query query;
    protected final Axis[] axes;
    protected Axis slicerAxis;

    protected ResultBase(Execution execution, Axis[] axes) {
        this.execution = execution;
        this.statement = execution.getMondrianStatement();
        this.query = this.statement.getQuery();
        assert (this.query != null);
        this.axes = axes == null ? new Axis[this.query.getAxes().length] : axes;
    }

    protected abstract Logger getLogger();

    @Override
    public Query getQuery() {
        return this.statement.getQuery();
    }

    @Override
    public Axis[] getAxes() {
        return this.axes;
    }

    @Override
    public Axis getSlicerAxis() {
        return this.slicerAxis;
    }

    @Override
    public void print(PrintWriter pw) {
        for (int i = -1; i < this.axes.length; ++i) {
            pw.println("Axis #" + (i + 1) + ":");
            this.printAxis(pw, i < 0 ? this.slicerAxis : this.axes[i]);
        }
        int[] pos = new int[this.axes.length];
        this.printRows(pw, this.axes.length - 1, pos);
    }

    private void printRows(PrintWriter pw, int axis, int[] pos) {
        if (axis < 0) {
            this.printCell(pw, pos);
        } else {
            Axis _axis = this.axes[axis];
            List<Position> positions = _axis.getPositions();
            for (int i = 0; i < positions.size(); ++i) {
                pos[axis] = i;
                if (axis == 0) {
                    int row = axis + 1 < pos.length ? pos[axis + 1] : 0;
                    pw.print("Row #" + row + ": ");
                }
                this.printRows(pw, axis - 1, pos);
                if (axis != 0) continue;
                pw.println();
            }
        }
    }

    private void printAxis(PrintWriter pw, Axis axis) {
        List<Position> positions = axis.getPositions();
        for (Position position : positions) {
            boolean firstTime = true;
            pw.print("{");
            for (Member member : position) {
                if (member.getDimension().isHighCardinality()) {
                    pw.println(" -- High cardinality dimension --}");
                    return;
                }
                if (!firstTime) {
                    pw.print(", ");
                }
                pw.print(member.getUniqueName());
                firstTime = false;
            }
            pw.println("}");
        }
    }

    private void printCell(PrintWriter pw, int[] pos) {
        Cell cell = this.getCell(pos);
        pw.print(cell.getFormattedValue());
    }

    public Member getMember(int[] pos, Hierarchy hierarchy) {
        for (int i = -1; i < this.axes.length; ++i) {
            Axis axis = this.slicerAxis;
            int index = 0;
            if (i >= 0) {
                axis = this.axes[i];
                index = pos[i];
            }
            List<Position> positions = axis.getPositions();
            Position position = positions.get(index);
            for (Member member : position) {
                if (member.getHierarchy() != hierarchy) continue;
                return member;
            }
        }
        return hierarchy.getHierarchy().getDefaultMember();
    }

    public Execution getExecution() {
        return this.execution;
    }

    @Override
    public void close() {
    }
}

