/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

class TupleItemFunDef
extends FunDefBase {
    static final TupleItemFunDef instance = new TupleItemFunDef();

    private TupleItemFunDef() {
        super("Item", "Returns a member from the tuple specified in <Tuple>. The member to be returned is specified by the zero-based position of the member in the set in <Index>.", "mmtn");
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        return MemberType.Unknown;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Type type = call.getArg(0).getType();
        if (type instanceof MemberType) {
            final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
            final IntegerCalc indexCalc = compiler.compileInteger(call.getArg(1));
            return new AbstractMemberCalc(call, new Calc[]{memberCalc, indexCalc}){

                @Override
                public Member evaluateMember(Evaluator evaluator) {
                    Member member = memberCalc.evaluateMember(evaluator);
                    int index = indexCalc.evaluateInteger(evaluator);
                    if (index != 0) {
                        return null;
                    }
                    return member;
                }
            };
        }
        final TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
        final IntegerCalc indexCalc = compiler.compileInteger(call.getArg(1));
        return new AbstractMemberCalc(call, new Calc[]{tupleCalc, indexCalc}){
            final Member[] nullTupleMembers;
            {
                super(exp, calcs);
                this.nullTupleMembers = FunUtil.makeNullTuple((TupleType)tupleCalc.getType());
            }

            @Override
            public Member evaluateMember(Evaluator evaluator) {
                Member[] members = tupleCalc.evaluateTuple(evaluator);
                assert (members == null || members.length == this.nullTupleMembers.length);
                int index = indexCalc.evaluateInteger(evaluator);
                if (members == null) {
                    return this.nullTupleMembers[index];
                }
                if (index >= members.length || index < 0) {
                    return null;
                }
                return members[index];
            }
        };
    }
}

