/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.sort;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.sort.Sorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

abstract class MemberComparator
implements Comparator<Member> {
    private static final Logger LOGGER = LogManager.getLogger(MemberComparator.class);
    final Evaluator evaluator;
    final Calc exp;
    private final int descMask;
    private final Map<Member, Object> valueMap;

    MemberComparator(Evaluator evaluator, Calc exp, boolean desc) {
        this.evaluator = evaluator;
        this.exp = exp;
        this.descMask = desc ? -1 : 1;
        this.valueMap = new HashMap<Member, Object>();
    }

    private int maybeNegate(int c) {
        return this.descMask * c;
    }

    protected Object eval(Member m) {
        Object val = this.valueMap.get(m);
        if (val == null) {
            this.evaluator.setContext(m);
            val = this.exp.evaluate(this.evaluator);
            if (val == null) {
                val = Util.nullValue;
            }
            this.valueMap.put(m, val);
        }
        return val;
    }

    Comparator<Member> wrap() {
        MemberComparator comparator = this;
        if (LOGGER.isDebugEnabled()) {
            return (m1, m2) -> {
                int c = comparator.compare(m1, m2);
                LOGGER.debug("compare " + m1.getUniqueName() + "(" + this.eval((Member)m1) + "), " + m2.getUniqueName() + "(" + this.eval((Member)m2) + ") yields " + c);
                return c;
            };
        }
        return this;
    }

    void preloadValues(Map<Member, Object> map) {
        this.valueMap.putAll(map);
    }

    void preloadValues(Collection<Member> members) {
        for (Member m : members) {
            this.eval(m);
        }
    }

    protected final int compareByValue(Member m1, Member m2) {
        int c = Sorter.compareValues(this.eval(m1), this.eval(m2));
        return this.maybeNegate(c);
    }

    protected final int compareHierarchicallyButSiblingsByValue(Member m1, Member m2) {
        Member prev2;
        Member prev1;
        if (Util.equals(m1, m2)) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!Util.equals(m1, m2 = m2.getParentMember())) continue;
                return -1;
            }
            if (depth1 > depth2) {
                if (!Util.equals(m1 = m1.getParentMember(), m2)) continue;
                return 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (Util.equals(m1 = m1.getParentMember(), m2 = m2.getParentMember())) break;
        }
        int c = this.compareByValue(prev1, prev2);
        if (c != 0) {
            return c;
        }
        c = Sorter.compareSiblingMembers(prev1, prev2);
        return c;
    }

    static class HierarchicalMemberComparator
    extends MemberComparator {
        HierarchicalMemberComparator(Evaluator evaluator, Calc exp, boolean desc) {
            super(evaluator, exp, desc);
        }

        @Override
        public int compare(Member m1, Member m2) {
            return this.compareHierarchicallyButSiblingsByValue(m1, m2);
        }
    }

    static class BreakMemberComparator
    extends MemberComparator {
        BreakMemberComparator(Evaluator evaluator, Calc exp, boolean desc) {
            super(evaluator, exp, desc);
        }

        @Override
        public final int compare(Member m1, Member m2) {
            return this.compareByValue(m1, m2);
        }
    }
}

