/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun.sort;

import com.google.common.annotations.VisibleForTesting;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import mondrian.calc.Calc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Util;
import mondrian.olap.fun.MemberOrderKeyFunDef;
import mondrian.olap.fun.sort.HierarchicalTupleComparator;
import mondrian.olap.fun.sort.HierarchicalTupleKeyComparator;
import mondrian.olap.fun.sort.HierarchizeComparator;
import mondrian.olap.fun.sort.HierarchizeTupleComparator;
import mondrian.olap.fun.sort.MemberComparator;
import mondrian.olap.fun.sort.OrderKey;
import mondrian.olap.fun.sort.Quicksorter;
import mondrian.olap.fun.sort.SortKeySpec;
import mondrian.olap.fun.sort.TupleExpMemoComparator;
import mondrian.olap.type.ScalarType;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapUtil;
import mondrian.server.Execution;
import mondrian.util.CancellationChecker;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eigenbase.xom.XOMUtil;

public class Sorter {
    private static final String SORT_TIMING_NAME = "Sort";
    private static final String SORT_EVAL_TIMING_NAME = "EvalForSort";
    private static final Logger LOGGER = LogManager.getLogger(Sorter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<Member, Object> evaluateMembers(Evaluator evaluator, Calc exp, Iterable<Member> memberIter, List<Member> memberList, boolean parentsToo) {
        int savepoint = evaluator.savepoint();
        try {
            assert (exp.getType() instanceof ScalarType);
            HashMap<Member, Object> mapMemberToValue = new HashMap<Member, Object>();
            for (Member member : memberIter) {
                if (memberList != null) {
                    memberList.add(member);
                }
                do {
                    evaluator.setContext(member);
                    Object result = exp.evaluate(evaluator);
                    if (result == null) {
                        result = Util.nullValue;
                    }
                    mapMemberToValue.put(member, result);
                } while (parentsToo && (member = member.getParentMember()) != null && !mapMemberToValue.containsKey(member));
            }
            HashMap<Member, Object> hashMap = mapMemberToValue;
            return hashMap;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<List<Member>, Object> evaluateTuples(Evaluator evaluator, Calc exp, TupleList tuples) {
        int savepoint = evaluator.savepoint();
        try {
            assert (exp.getType() instanceof ScalarType);
            HashMap<List, Object> mapMemberToValue = new HashMap<List, Object>();
            for (List tuple : tuples) {
                evaluator.setContext(tuple);
                Object result = exp.evaluate(evaluator);
                if (result == null) {
                    result = Util.nullValue;
                }
                mapMemberToValue.put(tuple, result);
            }
            HashMap<List, Object> hashMap = mapMemberToValue;
            return hashMap;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Member> sortMembers(Evaluator evaluator, Iterable<Member> memberIter, List<Member> memberList, Calc exp, boolean desc, boolean brk) {
        if (memberList != null && memberList.size() <= 1) {
            return memberList;
        }
        evaluator.getTiming().markStart(SORT_EVAL_TIMING_NAME);
        boolean timingEval = true;
        boolean timingSort = false;
        try {
            Map<Member, Object> mapMemberToValue;
            boolean parentsToo;
            boolean bl = parentsToo = !brk;
            if (memberList == null) {
                memberList = new ArrayList<Member>();
                mapMemberToValue = Sorter.evaluateMembers(evaluator, exp, memberIter, memberList, parentsToo);
            } else {
                mapMemberToValue = Sorter.evaluateMembers(evaluator, exp, memberIter, null, parentsToo);
            }
            MemberComparator comp = brk ? new MemberComparator.BreakMemberComparator(evaluator, exp, desc) : new MemberComparator.HierarchicalMemberComparator(evaluator, exp, desc);
            comp.preloadValues(mapMemberToValue);
            evaluator.getTiming().markEnd(SORT_EVAL_TIMING_NAME);
            timingEval = false;
            evaluator.getTiming().markStart(SORT_TIMING_NAME);
            timingSort = true;
            Collections.sort(memberList, comp.wrap());
            List<Member> list = memberList;
            return list;
        }
        finally {
            if (timingEval) {
                evaluator.getTiming().markEnd(SORT_EVAL_TIMING_NAME);
            } else if (timingSort) {
                evaluator.getTiming().markEnd(SORT_TIMING_NAME);
            }
        }
    }

    public static boolean listEquals(List<Member> a1, List<Member> a2) {
        for (int i = 0; i < a1.size(); ++i) {
            if (Objects.equals(a1.get(i), a2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static List<Member> sortMembers(Evaluator evaluator, Iterable<Member> memberIter, List<Member> memberList, List<SortKeySpec> keySpecList) {
        if (memberList != null && memberList.size() <= 1) {
            return memberList;
        }
        if (memberList == null) {
            memberList = new ArrayList<Member>();
            for (Member member : memberIter) {
                memberList.add(member);
            }
            if (memberList.size() <= 1) {
                return memberList;
            }
        }
        ComparatorChain chain = new ComparatorChain();
        for (SortKeySpec key : keySpecList) {
            boolean brk = key.getDirection().brk;
            MemberComparator comp = brk ? new MemberComparator.BreakMemberComparator(evaluator, key.getKey(), key.getDirection().descending) : new MemberComparator.HierarchicalMemberComparator(evaluator, key.getKey(), key.getDirection().descending);
            comp.preloadValues(memberList);
            chain.addComparator(comp.wrap(), false);
        }
        memberList.sort((Comparator<Member>)chain);
        return memberList;
    }

    public static TupleList sortTuples(Evaluator evaluator, TupleIterable tupleIterable, TupleList tupleList, Calc exp, boolean desc, boolean brk, int arity) {
        Comparator<List<Member>> comparator;
        TupleList tupleArrayList;
        if (tupleList == null) {
            TupleCursor cursor = tupleIterable.tupleCursor();
            tupleArrayList = Sorter.iterableToList(evaluator, cursor);
            if (tupleArrayList.size() <= 1) {
                return new DelegatingTupleList(tupleIterable.getArity(), tupleArrayList);
            }
        } else {
            if (tupleList.size() <= 1) {
                return tupleList;
            }
            tupleArrayList = tupleList;
        }
        List[] tuples = tupleArrayList.toArray(new List[tupleArrayList.size()]);
        DelegatingTupleList result = new DelegatingTupleList(tupleIterable.getArity(), Arrays.asList(tuples));
        if (brk) {
            comparator = new TupleExpMemoComparator.BreakTupleComparator(evaluator, exp, arity);
            if (desc) {
                comparator = Collections.reverseOrder(comparator);
            }
        } else {
            comparator = new HierarchicalTupleComparator(evaluator, exp, arity, desc);
        }
        Arrays.sort(tuples, comparator);
        Sorter.logTuples(tupleList, "Sorter.sortTuples");
        return result;
    }

    private static TupleList iterableToList(Evaluator evaluator, TupleCursor cursor) {
        TupleList tupleArrayList = TupleCollections.createList(cursor.getArity());
        int currentIteration = 0;
        Execution execution = evaluator.getQuery().getStatement().getCurrentExecution();
        while (cursor.forward()) {
            CancellationChecker.checkCancelOrTimeout(currentIteration++, execution);
            tupleArrayList.addCurrent(cursor);
        }
        return tupleArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Member> partiallySortMembers(Evaluator evaluator, List<Member> list, Calc exp, int limit, boolean desc) {
        assert (!list.isEmpty());
        assert (limit <= list.size());
        evaluator.getTiming().markStart(SORT_EVAL_TIMING_NAME);
        boolean timingEval = true;
        boolean timingSort = false;
        try {
            MemberComparator.BreakMemberComparator comp = new MemberComparator.BreakMemberComparator(evaluator, exp, desc);
            Map<Member, Object> valueMap = Sorter.evaluateMembers(evaluator, exp, list, null, false);
            evaluator.getTiming().markEnd(SORT_EVAL_TIMING_NAME);
            timingEval = false;
            evaluator.getTiming().markStart(SORT_TIMING_NAME);
            timingSort = true;
            comp.preloadValues(valueMap);
            List<Member> list2 = Sorter.stablePartialSort(list, comp.wrap(), limit);
            return list2;
        }
        finally {
            if (timingEval) {
                evaluator.getTiming().markEnd(SORT_EVAL_TIMING_NAME);
            } else if (timingSort) {
                evaluator.getTiming().markEnd(SORT_TIMING_NAME);
            }
        }
    }

    public static TupleList sortTuples(Evaluator evaluator, TupleIterable tupleIter, TupleList tupleList, List<SortKeySpec> keySpecList, int arity) {
        if (tupleList == null) {
            tupleList = Sorter.iterableToList(evaluator, tupleIter.tupleCursor());
        }
        if (tupleList.size() <= 1) {
            return tupleList;
        }
        ComparatorChain chain = new ComparatorChain();
        for (SortKeySpec key : keySpecList) {
            Sorter.applySortSpecToComparator(evaluator, arity, chain, key);
        }
        tupleList.sort(chain);
        Sorter.logTuples(tupleList, "Sorter.sortTuples");
        return tupleList;
    }

    @VisibleForTesting
    static void applySortSpecToComparator(Evaluator evaluator, int arity, ComparatorChain chain, SortKeySpec key) {
        boolean brk = key.getDirection().brk;
        boolean orderByKey = key.getKey().isWrapperFor(MemberOrderKeyFunDef.CalcImpl.class);
        boolean direction = key.getDirection().descending;
        if (brk) {
            TupleExpMemoComparator.BreakTupleComparator comp = new TupleExpMemoComparator.BreakTupleComparator(evaluator, key.getKey(), arity);
            chain.addComparator((Comparator)comp, direction);
        } else if (orderByKey) {
            HierarchicalTupleKeyComparator comp = new HierarchicalTupleKeyComparator(evaluator, key.getKey(), arity);
            chain.addComparator((Comparator)comp, direction);
        } else {
            HierarchicalTupleComparator comp = new HierarchicalTupleComparator(evaluator, key.getKey(), arity, direction);
            chain.addComparator((Comparator)comp, false);
        }
    }

    private static void logTuples(TupleList tupleList, String description) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(description + ": ");
            for (List tuple : tupleList) {
                sb.append("\n");
                sb.append(tuple.toString());
            }
            LOGGER.debug(sb.toString());
        }
    }

    public static List<List<Member>> partiallySortTuples(Evaluator evaluator, TupleList list, Calc exp, int limit, boolean desc) {
        assert (!list.isEmpty());
        assert (limit <= list.size());
        Comparator<List<Member>> comp = new TupleExpMemoComparator.BreakTupleComparator(evaluator, exp, list.getArity());
        if (desc) {
            comp = Collections.reverseOrder(comp);
        }
        return Sorter.stablePartialSort(list, comp, limit);
    }

    public static void hierarchizeMemberList(List<Member> memberList, boolean post) {
        if (memberList.size() <= 1) {
            return;
        }
        Dimension dimension = memberList.get(0).getDimension();
        if (dimension.isHighCardinality()) {
            LOGGER.warn(MondrianResource.instance().HighCardinalityInDimension.str(dimension.getUniqueName()));
            return;
        }
        HierarchizeComparator comparator = new HierarchizeComparator(post);
        memberList.sort(comparator);
    }

    public static TupleList hierarchizeTupleList(TupleList tupleList, boolean post) {
        if (tupleList.isEmpty()) {
            TupleCollections.emptyList(tupleList.getArity());
        }
        TupleList fixedList = tupleList.fix();
        if (tupleList.getArity() == 1) {
            Sorter.hierarchizeMemberList((List<Member>)fixedList.slice(0), post);
            return fixedList;
        }
        HierarchizeTupleComparator comparator = new HierarchizeTupleComparator(fixedList.getArity(), post);
        fixedList.sort(comparator);
        Sorter.logTuples(fixedList, "hierarchizeTupleList");
        return fixedList;
    }

    public static int compareValues(double d1, double d2) {
        if (Double.isNaN(d1)) {
            if (d2 == Double.POSITIVE_INFINITY) {
                return -1;
            }
            if (Double.isNaN(d2)) {
                return 0;
            }
            return 1;
        }
        if (Double.isNaN(d2)) {
            if (d1 == Double.POSITIVE_INFINITY) {
                return 1;
            }
            return -1;
        }
        if (d1 == d2) {
            return 0;
        }
        if (d1 == 1.2345E-8) {
            if (d2 == Double.NEGATIVE_INFINITY) {
                return 1;
            }
            return -1;
        }
        if (d2 == 1.2345E-8) {
            if (d1 == Double.NEGATIVE_INFINITY) {
                return -1;
            }
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        return 1;
    }

    public static int compareValues(Object value0, Object value1) {
        if (value0 == value1) {
            return 0;
        }
        if (value0 == null) {
            return -1;
        }
        if (value1 == null) {
            return 1;
        }
        if (value0 == RolapUtil.valueNotReadyException) {
            return -1;
        }
        if (value1 == RolapUtil.valueNotReadyException) {
            return 1;
        }
        if (value0 == Util.nullValue) {
            return -1;
        }
        if (value1 == Util.nullValue) {
            return 1;
        }
        if (value0 instanceof String) {
            return ((String)value0).compareToIgnoreCase((String)value1);
        }
        if (value0 instanceof Number) {
            return Sorter.compareValues(((Number)value0).doubleValue(), ((Number)value1).doubleValue());
        }
        if (value0 instanceof Date) {
            return ((Date)value0).compareTo((Date)value1);
        }
        if (value0 instanceof OrderKey) {
            return ((OrderKey)value0).compareTo(value1);
        }
        throw Util.newInternal("cannot compare " + value0);
    }

    public static Double box(double d) {
        return d == 1.2345E-8 ? null : Double.valueOf(d);
    }

    public static Integer box(int n) {
        return n == -2147483647 ? null : Integer.valueOf(n);
    }

    public static int compareHierarchically(Member m1, Member m2, boolean post) {
        Member prev2;
        Member prev1;
        if (Util.equals(m1 = Sorter.unwrapLimitedRollupMember(m1), m2 = Sorter.unwrapLimitedRollupMember(m2))) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!Util.equals(m1, m2 = m2.getParentMember())) continue;
                return post ? 1 : -1;
            }
            if (depth1 > depth2) {
                if (!Util.equals(m1 = m1.getParentMember(), m2)) continue;
                return post ? -1 : 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (Util.equals(m1 = Sorter.unwrapLimitedRollupMember(m1.getParentMember()), m2 = Sorter.unwrapLimitedRollupMember(m2.getParentMember()))) break;
        }
        int c = Sorter.compareSiblingMembers(prev1, prev2);
        assert (c != 0) : "Members " + prev1 + ", " + prev2 + " are not equal, but compare returned 0.";
        return c;
    }

    private static Member unwrapLimitedRollupMember(Member m) {
        if (m instanceof RolapHierarchy.LimitedRollupMember) {
            return ((RolapHierarchy.LimitedRollupMember)m).member;
        }
        return m;
    }

    public static int compareSiblingMembers(Member m1, Member m2) {
        int ordinal2;
        boolean calculated1 = m1.isCalculatedInQuery();
        boolean calculated2 = m2.isCalculatedInQuery();
        if (calculated1) {
            if (!calculated2) {
                return 1;
            }
        } else if (calculated2) {
            return -1;
        }
        Comparable k1 = m1.getOrderKey();
        Comparable k2 = m2.getOrderKey();
        if (k1 != null && k2 != null) {
            return k1.compareTo(k2);
        }
        int ordinal1 = m1.getOrdinal();
        return ordinal1 == (ordinal2 = m2.getOrdinal()) ? m1.compareTo(m2) : (ordinal1 < ordinal2 ? -1 : 1);
    }

    static <T> void partialSort(T[] items, Comparator<T> comp, int limit) {
        if (comp == null) {
            comp = ComparatorUtils.naturalComparator();
        }
        new Quicksorter<T>(items, comp).partialSort(limit);
    }

    public static <T> List<T> stablePartialSort(List<T> list, Comparator<T> comp, int limit) {
        return Sorter.stablePartialSort(list, comp, limit, 0);
    }

    public static <T> List<T> stablePartialSort(List<T> list, Comparator<T> comp, int limit, int algorithm) {
        assert (limit <= list.size());
        assert (!list.isEmpty());
        block6: while (true) {
            switch (algorithm) {
                case 0: {
                    float ratio = (float)limit / (float)list.size();
                    if ((double)ratio <= 0.05) {
                        algorithm = 4;
                        continue block6;
                    }
                    if ((double)ratio <= 0.35) {
                        algorithm = 2;
                        continue block6;
                    }
                    algorithm = 1;
                    continue block6;
                }
                case 1: {
                    return Sorter.stablePartialSortArray(list, comp, limit);
                }
                case 2: {
                    return Sorter.stablePartialSortMarc(list, comp, limit);
                }
                case 4: {
                    return Sorter.stablePartialSortJulian(list, comp, limit);
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public static <T> List<T> stablePartialSortArray(List<T> list, Comparator<T> comp, int limit) {
        ArrayList<T> list2 = new ArrayList<T>(list);
        list2.sort(comp);
        return list2.subList(0, limit);
    }

    public static <T> List<T> stablePartialSortMarc(List<T> list, Comparator<T> comp, int limit) {
        assert (limit >= 0);
        int n = list.size();
        final ObjIntPair[] pairs = new ObjIntPair[n];
        int i = 0;
        for (T item : list) {
            pairs[i] = new ObjIntPair<T>(item, i);
            ++i;
        }
        Comparator pairComp = (x, y) -> {
            int val = comp.compare(x.t, y.t);
            if (val == 0) {
                val = x.i - y.i;
            }
            return val;
        };
        final int length = Math.min(limit, n);
        Sorter.partialSort(pairs, pairComp, length);
        return new AbstractList<T>(){

            @Override
            public T get(int index) {
                return pairs[index].t;
            }

            @Override
            public int size() {
                return length;
            }
        };
    }

    public static <T> List<T> stablePartialSortJulian(List<T> list, Comparator<T> comp, int limit) {
        Comparator comp2 = (o1, o2) -> {
            int c = comp.compare(o1.t, o2.t);
            if (c == 0) {
                c = Util.compare(o1.i, o2.i);
            }
            return -c;
        };
        int filled = 0;
        PriorityQueue<ObjIntPair<T>> queue = new PriorityQueue<ObjIntPair<T>>(limit, comp2);
        for (T element : list) {
            ObjIntPair<T> item;
            if (filled < limit) {
                queue.offer(new ObjIntPair<T>(element, filled++));
                continue;
            }
            ObjIntPair head = (ObjIntPair)queue.element();
            if (comp.compare(element, head.t) > 0 || comp2.compare(item = new ObjIntPair<T>(element, filled++), head) < 0) continue;
            ObjIntPair poll = (ObjIntPair)queue.remove();
            XOMUtil.discard((Object)poll);
            queue.offer(item);
        }
        int n = queue.size();
        Object[] elements = new Object[n];
        while (n > 0) {
            elements[--n] = ((ObjIntPair)queue.poll()).t;
        }
        assert (queue.isEmpty());
        return Arrays.asList(elements);
    }

    public static class ObjIntPair<T> {
        final T t;
        final int i;

        public ObjIntPair(T t, int i) {
            this.t = t;
            this.i = i;
        }

        public int hashCode() {
            return Util.hash(this.i, this.t);
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof ObjIntPair && this.i == ((ObjIntPair)obj).i && Util.equals(this.t, ((ObjIntPair)obj).t);
        }

        public String toString() {
            return "<" + this.t + ", " + this.i + ">";
        }
    }

    public static enum Flag {
        ASC(false, false),
        DESC(true, false),
        BASC(false, true),
        BDESC(true, true);

        public final boolean descending;
        public final boolean brk;

        private Flag(boolean descending, boolean brk) {
            this.descending = descending;
            this.brk = brk;
        }

        public static String[] getNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (Flag flags : (Flag[])Flag.class.getEnumConstants()) {
                names.add(flags.name());
            }
            return names.toArray(new String[names.size()]);
        }
    }
}

