/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.NonEmptyCrossJoinFunDef;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.TupleConstraint;

public class RolapNativeCrossJoin
extends RolapNativeSet {
    public RolapNativeCrossJoin() {
        super.setEnabled(MondrianProperties.instance().EnableNativeCrossJoin.get());
    }

    @Override
    protected boolean restrictMemberTypes() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        RolapCube cube = evaluator.getCube();
        List<CrossJoinArg[]> allArgs = this.crossJoinArgFactory().checkCrossJoin(evaluator, fun, args, false);
        if (allArgs == null || allArgs.isEmpty() || allArgs.get(0) == null) {
            this.alertCrossJoinNonNative(evaluator, fun, "arguments not supported");
            return null;
        }
        CrossJoinArg[] cjArgs = allArgs.get(0);
        int countNonNativeInputArg = 0;
        for (CrossJoinArg arg : cjArgs) {
            if (!(arg instanceof MemberListCrossJoinArg)) continue;
            CrossJoinArg cjArg = (MemberListCrossJoinArg)arg;
            if (((MemberListCrossJoinArg)cjArg).hasAllMember() || ((MemberListCrossJoinArg)cjArg).isEmptyCrossJoinArg()) {
                ++countNonNativeInputArg;
            }
            if (!((MemberListCrossJoinArg)cjArg).hasCalcMembers()) continue;
            countNonNativeInputArg = cjArgs.length;
            break;
        }
        if (countNonNativeInputArg == cjArgs.length) {
            this.alertCrossJoinNonNative(evaluator, fun, "either all arguments contain the ALL member, or empty member lists, or one has a calculated member");
            return null;
        }
        if (this.isPreferInterpreter(cjArgs, true)) {
            return null;
        }
        ArrayList<RolapLevel> levels = new ArrayList<RolapLevel>();
        for (CrossJoinArg cjArg : cjArgs) {
            RolapLevel level = cjArg.getLevel();
            if (level == null) continue;
            levels.add(level);
        }
        if (SqlConstraintUtils.measuresConflictWithMembers(evaluator.getQuery().getMeasuresMembers(), cjArgs)) {
            this.alertCrossJoinNonNative(evaluator, fun, "One or more calculated measures conflict with crossjoin args");
            return null;
        }
        if (cube.isVirtual() && !evaluator.getQuery().nativeCrossJoinVirtualCube()) {
            this.alertCrossJoinNonNative(evaluator, fun, "not all functions on [Measures] dimension supported");
            return null;
        }
        if (!NonEmptyCrossJoinConstraint.isValidContext(evaluator, false, levels.toArray(new RolapLevel[levels.size()]), this.restrictMemberTypes())) {
            this.alertCrossJoinNonNative(evaluator, fun, "Slicer context does not support native crossjoin.");
            return null;
        }
        if (!evaluator.isNonEmpty()) {
            return null;
        }
        LOGGER.debug("using native crossjoin");
        int savepoint = evaluator.savepoint();
        try {
            this.overrideContext(evaluator, cjArgs, null);
            CrossJoinArg[] cargs = this.combineArgs(allArgs);
            TupleConstraint constraint = this.buildConstraint(evaluator, fun, cargs);
            SchemaReader schemaReader = evaluator.getSchemaReader();
            RolapNativeSet.SetEvaluator setEvaluator = new RolapNativeSet.SetEvaluator(cjArgs, schemaReader, constraint);
            return setEvaluator;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    private Set<Member> getCJArgMembers(CrossJoinArg[] cjArgs) {
        HashSet<Member> members = new HashSet<Member>();
        for (CrossJoinArg arg : cjArgs) {
            if (arg.getMembers() == null) continue;
            members.addAll(arg.getMembers());
        }
        return members;
    }

    CrossJoinArg[] combineArgs(List<CrossJoinArg[]> allArgs) {
        CrossJoinArg[] predicateArgs;
        CrossJoinArg[] cjArgs = allArgs.get(0);
        if (allArgs.size() == 2 && (predicateArgs = allArgs.get(1)) != null) {
            return Util.appendArrays(cjArgs, new CrossJoinArg[][]{predicateArgs});
        }
        return cjArgs;
    }

    private TupleConstraint buildConstraint(RolapEvaluator evaluator, FunDef fun, CrossJoinArg[] cargs) {
        CrossJoinArg[] myArgs = this.safeToConstrainByOtherAxes(fun) ? this.buildArgs(evaluator, cargs) : cargs;
        return new NonEmptyCrossJoinConstraint(myArgs, evaluator);
    }

    private CrossJoinArg[] buildArgs(RolapEvaluator evaluator, CrossJoinArg[] cargs) {
        Set<CrossJoinArg> joinArgs = this.crossJoinArgFactory().buildConstraintFromAllAxes(evaluator);
        joinArgs.addAll(Arrays.asList(cargs));
        return joinArgs.toArray(new CrossJoinArg[joinArgs.size()]);
    }

    private boolean safeToConstrainByOtherAxes(FunDef fun) {
        return !(fun instanceof NonEmptyCrossJoinFunDef);
    }

    private void alertCrossJoinNonNative(RolapEvaluator evaluator, FunDef fun, String reason) {
        if (!(fun instanceof NonEmptyCrossJoinFunDef)) {
            return;
        }
        if (!evaluator.getQuery().shouldAlertForNonNative(fun)) {
            return;
        }
        RolapUtil.alertNonNative("NonEmptyCrossJoin", reason);
    }

    static class NonEmptyCrossJoinConstraint
    extends RolapNativeSet.SetConstraint {
        NonEmptyCrossJoinConstraint(CrossJoinArg[] args, RolapEvaluator evaluator) {
            super(args, evaluator, false);
        }

        public RolapMember findMember(Object key) {
            for (CrossJoinArg arg : this.args) {
                if (!(arg instanceof MemberListCrossJoinArg)) continue;
                MemberListCrossJoinArg crossJoinArg = (MemberListCrossJoinArg)arg;
                List<RolapMember> memberList = crossJoinArg.getMembers();
                for (RolapMember rolapMember : memberList) {
                    if (!key.equals(rolapMember.getKey())) continue;
                    return rolapMember;
                }
            }
            return null;
        }
    }
}

