/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.List;
import java.util.Set;
import mondrian.olap.Evaluator;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.rolap.ChildByNameConstraint;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.DefaultTupleConstraint;
import mondrian.rolap.DescendantsConstraint;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.CrossJoinArgFactory;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

public class SqlConstraintFactory {
    static boolean enabled;
    private static final SqlConstraintFactory instance;

    private SqlConstraintFactory() {
    }

    private boolean enabled(Evaluator context) {
        if (context != null) {
            return enabled && context.nativeEnabled();
        }
        return enabled;
    }

    public static SqlConstraintFactory instance() {
        SqlConstraintFactory.setNativeNonEmptyValue();
        return instance;
    }

    public static void setNativeNonEmptyValue() {
        enabled = MondrianProperties.instance().EnableNativeNonEmpty.get();
    }

    public MemberChildrenConstraint getMemberChildrenConstraint(Evaluator context) {
        if (!this.enabled(context) || !SqlContextConstraint.isValidContext(context, false)) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new SqlContextConstraint((RolapEvaluator)context, false);
    }

    public TupleConstraint getLevelMembersConstraint(Evaluator context) {
        return this.getLevelMembersConstraint(context, null);
    }

    public TupleConstraint getLevelMembersConstraint(Evaluator context, Level[] levels) {
        Set<CrossJoinArg> joinArgs;
        assert (levels == null || levels.length == 1) : "Multi-element Level arrays are not expected here.";
        if (this.useDefaultTupleConstraint(context, levels)) {
            return DefaultTupleConstraint.instance();
        }
        if (context.isNonEmpty() && (joinArgs = new CrossJoinArgFactory(false).buildConstraintFromAllAxes((RolapEvaluator)context)).size() > 0) {
            return new RolapNativeCrossJoin.NonEmptyCrossJoinConstraint(joinArgs.toArray(new CrossJoinArg[joinArgs.size()]), (RolapEvaluator)context);
        }
        return new SqlContextConstraint((RolapEvaluator)context, false);
    }

    private boolean useDefaultTupleConstraint(Evaluator context, Level[] levels) {
        if (context == null) {
            return true;
        }
        if (!this.enabled(context)) {
            return true;
        }
        if (!SqlContextConstraint.isValidContext(context, false, levels, false)) {
            return true;
        }
        int threshold = MondrianProperties.instance().LevelPreCacheThreshold.get();
        if (threshold <= 0) {
            return false;
        }
        if (levels != null) {
            long totalCard = 1L;
            for (Level level : levels) {
                if ((totalCard *= (long)this.getLevelCardinality((RolapLevel)level)) <= (long)threshold) continue;
                return false;
            }
        }
        return true;
    }

    public MemberChildrenConstraint getChildByNameConstraint(RolapMember parent, Id.NameSegment childName) {
        if (this.useDefaultMemberChildrenConstraint(parent)) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new ChildByNameConstraint(childName);
    }

    public MemberChildrenConstraint getChildrenByNamesConstraint(RolapMember parent, List<Id.NameSegment> childNames) {
        if (this.useDefaultMemberChildrenConstraint(parent)) {
            return DefaultMemberChildrenConstraint.instance();
        }
        return new ChildByNameConstraint(childNames);
    }

    private boolean useDefaultMemberChildrenConstraint(RolapMember parent) {
        int threshold = MondrianProperties.instance().LevelPreCacheThreshold.get();
        return !enabled || parent.getHierarchy().isRagged() || !this.isDegenerate(parent.getLevel()) && threshold > 0 && this.getChildLevelCardinality(parent) < threshold;
    }

    private boolean isDegenerate(Level level) {
        if (level instanceof RolapCubeLevel) {
            RolapCubeHierarchy hier = (RolapCubeHierarchy)level.getHierarchy();
            return hier.isUsingCubeFact();
        }
        return false;
    }

    private int getChildLevelCardinality(RolapMember parent) {
        RolapLevel level = (RolapLevel)parent.getLevel().getChildLevel();
        if (level == null) {
            return Integer.MAX_VALUE;
        }
        return this.getLevelCardinality(level);
    }

    private int getLevelCardinality(RolapLevel level) {
        return this.getSchemaReader(level).getLevelCardinality(level, true, true);
    }

    private SchemaReader getSchemaReader(RolapLevel level) {
        return level.getHierarchy().getRolapSchema().getSchemaReader();
    }

    public TupleConstraint getDescendantsConstraint(List<RolapMember> parentMembers, MemberChildrenConstraint mcc) {
        return new DescendantsConstraint(parentMembers, mcc);
    }

    static {
        instance = new SqlConstraintFactory();
    }
}

