/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.TupleList;
import mondrian.olap.Access;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.HighCardSqlTupleReader;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.SqlTupleReader;
import mondrian.rolap.TupleReader;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.MemberKeyConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.monitor.SqlStatementEvent;
import mondrian.spi.Dialect;
import mondrian.util.CancellationChecker;
import mondrian.util.CreationException;
import mondrian.util.ObjectFactory;
import mondrian.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eigenbase.util.property.StringProperty;

class SqlMemberSource
implements MemberReader,
TupleReader.MemberBuilder {
    private static final Logger LOGGER = LogManager.getLogger(SqlMemberSource.class);
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private final RolapHierarchy hierarchy;
    private final DataSource dataSource;
    private MemberCache cache;
    private int lastOrdinal = 0;
    private boolean assignOrderKeys;
    private Map<Object, Object> valuePool;

    SqlMemberSource(RolapHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.dataSource = hierarchy.getRolapSchema().getInternalConnection().getDataSource();
        this.assignOrderKeys = MondrianProperties.instance().CompareSiblingsByOrderKey.get();
        this.valuePool = ValuePoolFactoryFactory.getValuePoolFactory().create(this);
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean setCache(MemberCache cache) {
        this.cache = cache;
        return true;
    }

    @Override
    public int getMemberCount() {
        RolapLevel[] levels = (RolapLevel[])this.hierarchy.getLevels();
        int count = 0;
        for (RolapLevel level : levels) {
            count += this.getLevelMemberCount(level);
        }
        return count;
    }

    @Override
    public RolapMember substitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember desubstitute(RolapMember member) {
        return member;
    }

    @Override
    public RolapMember getMemberByKey(RolapLevel level, List<Comparable> keyValues) {
        if (level.isAll()) {
            return null;
        }
        ArrayList<Dialect.Datatype> datatypeList = new ArrayList<Dialect.Datatype>();
        ArrayList<MondrianDef.Expression> columnList = new ArrayList<MondrianDef.Expression>();
        RolapLevel x = level;
        while (true) {
            columnList.add(x.getKeyExp());
            datatypeList.add(x.getDatatype());
            if (x.isUnique()) break;
            x = (RolapLevel)x.getParentLevel();
        }
        List<RolapMember> list = this.getMembersInLevel(level, new MemberKeyConstraint(columnList, datatypeList, keyValues));
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        throw Util.newError("More than one member in level " + level + " with key " + keyValues);
    }

    @Override
    public RolapMember lookupMember(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getLevelMemberCount(RolapLevel level) {
        if (level.isAll()) {
            return 1;
        }
        return this.getMemberCount(level, this.dataSource);
    }

    private int getMemberCount(RolapLevel level, DataSource dataSource) {
        boolean[] mustCount = new boolean[1];
        String sql = this.makeLevelMemberCountSql(level, dataSource, mustCount);
        try (SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, new Locus(Locus.peek().execution, "SqlMemberSource.getLevelMemberCount", "while counting members of level '" + level));){
            int count;
            ResultSet resultSet = stmt.getResultSet();
            if (!mustCount[0]) {
                Util.assertTrue(resultSet.next());
                ++stmt.rowCount;
                count = resultSet.getInt(1);
            } else {
                ResultSetMetaData rmd = resultSet.getMetaData();
                int nColumns = rmd.getColumnCount();
                String[] colStrings = new String[nColumns];
                count = 0;
                while (resultSet.next()) {
                    ++stmt.rowCount;
                    boolean isEqual = true;
                    for (int i = 0; i < nColumns; ++i) {
                        String colStr = resultSet.getString(i + 1);
                        if (!Util.equals(colStr, colStrings[i])) {
                            isEqual = false;
                        }
                        colStrings[i] = colStr;
                    }
                    if (isEqual) continue;
                    ++count;
                }
            }
            int n = count;
            return n;
        }
    }

    private String makeLevelMemberCountSql(RolapLevel level, DataSource dataSource, boolean[] mustCount) {
        RolapLevel[] levels;
        mustCount[0] = false;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, "while generating query to count members in level " + level);
        int levelDepth = level.getDepth();
        if (levelDepth == (levels = (RolapLevel[])this.hierarchy.getLevels()).length) {
            sqlQuery.addSelect("count(*)", null);
            this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
            return sqlQuery.toString();
        }
        if (!sqlQuery.getDialect().allowsFromQuery()) {
            int i;
            ArrayList<String> columnList = new ArrayList<String>();
            int columnCount = 0;
            for (i = levelDepth; i >= 0; --i) {
                RolapLevel level2 = levels[i];
                if (level2.isAll()) continue;
                if (columnCount > 0 && !sqlQuery.getDialect().allowsCompoundCountDistinct()) {
                    mustCount[0] = true;
                }
                this.hierarchy.addToFrom(sqlQuery, level2.getKeyExp());
                String keyExp = level2.getKeyExp().getExpression(sqlQuery);
                columnList.add(keyExp);
                if (level2.isUnique()) break;
                ++columnCount;
            }
            if (mustCount[0]) {
                for (String colDef : columnList) {
                    String exp = sqlQuery.getDialect().generateCountExpression(colDef);
                    sqlQuery.addSelect(exp, null);
                    sqlQuery.addOrderBy(exp, true, false, true);
                }
            } else {
                i = 0;
                StringBuilder sb = new StringBuilder();
                for (String colDef : columnList) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    ++i;
                    sb.append(sqlQuery.getDialect().generateCountExpression(colDef));
                }
                sqlQuery.addSelect("count(DISTINCT " + sb.toString() + ")", null);
            }
            return sqlQuery.toString();
        }
        sqlQuery.setDistinct(true);
        for (int i = levelDepth; i >= 0; --i) {
            RolapLevel level2 = levels[i];
            if (level2.isAll()) continue;
            MondrianDef.Expression keyExp = level2.getKeyExp();
            this.hierarchy.addToFrom(sqlQuery, keyExp);
            sqlQuery.addSelect(keyExp.getExpression(sqlQuery), null);
            if (level2.isUnique()) break;
        }
        SqlQuery outerQuery = SqlQuery.newQuery(dataSource, "while generating query to count members in level " + level);
        outerQuery.addSelect("count(*)", null);
        boolean failIfExists = true;
        outerQuery.addFrom(sqlQuery, "init", failIfExists);
        return outerQuery.toString();
    }

    @Override
    public List<RolapMember> getMembers() {
        return this.getMembers(this.dataSource);
    }

    private List<RolapMember> getMembers(DataSource dataSource) {
        Pair<String, List<SqlStatement.Type>> pair = this.makeKeysSql(dataSource);
        String sql = (String)pair.left;
        List types = (List)pair.right;
        RolapLevel[] levels = (RolapLevel[])this.hierarchy.getLevels();
        try (SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, types, 0, 0, new SqlStatement.StatementLocus(null, "SqlMemberSource.getMembers", "while building member cache", SqlStatementEvent.Purpose.TUPLES, 0), -1, -1, null);){
            List<SqlStatement.Accessor> accessors = stmt.getAccessors();
            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
            HashMap<MemberKey, RolapMember> map = new HashMap<MemberKey, RolapMember>();
            RolapMember root = null;
            if (this.hierarchy.hasAll()) {
                root = this.hierarchy.getAllMember();
                list.add(root);
            }
            int limit = MondrianProperties.instance().ResultLimit.get();
            ResultSet resultSet = stmt.getResultSet();
            Execution execution = Locus.peek().execution;
            while (resultSet.next()) {
                CancellationChecker.checkCancelOrTimeout(++stmt.rowCount, execution);
                if (limit > 0 && limit < stmt.rowCount) {
                    throw stmt.handle(MondrianResource.instance().MemberFetchLimitExceeded.ex(limit));
                }
                int column = 0;
                RolapMember member = root;
                for (RolapLevel level : levels) {
                    RolapProperty[] properties;
                    RolapMember parent;
                    MemberKey key;
                    if (level.isAll()) continue;
                    Comparable<?> value = accessors.get(column).get();
                    if (value == null) {
                        value = RolapUtil.sqlNullValue;
                    }
                    if ((member = (RolapMember)map.get(key = new MemberKey(parent = member, value))) == null) {
                        RolapMemberBase memberBase = new RolapMemberBase(parent, level, value);
                        memberBase.setOrdinal(this.lastOrdinal++);
                        member = memberBase;
                        if (value == RolapUtil.sqlNullValue) {
                            this.addAsOldestSibling(list, member);
                        } else {
                            list.add(member);
                        }
                        map.put(key, member);
                    }
                    ++column;
                    if (!level.getOrdinalExp().equals(level.getKeyExp())) {
                        if (this.assignOrderKeys) {
                            Object orderKey = accessors.get(column).get();
                            this.setOrderKey((RolapMemberBase)member, orderKey);
                        }
                        ++column;
                    }
                    for (RolapProperty property : properties = level.getProperties()) {
                        member.setProperty(property.getName(), accessors.get(column).get());
                        ++column;
                    }
                }
            }
            ArrayList<RolapMember> arrayList = list;
            return arrayList;
        }
    }

    private void setOrderKey(RolapMemberBase member, Object orderKey) {
        if (orderKey != null && !(orderKey instanceof Comparable)) {
            orderKey = orderKey.toString();
        }
        member.setOrderKey((Comparable)orderKey);
    }

    private void addAsOldestSibling(List<RolapMember> list, RolapMember member) {
        RolapMember sibling;
        int i = list.size();
        while (--i >= 0 && (sibling = list.get(i)).getParentMember() == member.getParentMember()) {
        }
        list.add(i + 1, member);
    }

    private Pair<String, List<SqlStatement.Type>> makeKeysSql(DataSource dataSource) {
        RolapLevel[] levels;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, "while generating query to retrieve members of " + this.hierarchy);
        for (RolapLevel level : levels = (RolapLevel[])this.hierarchy.getLevels()) {
            RolapProperty[] properties;
            if (level.isAll()) continue;
            MondrianDef.Expression keyExp = level.getKeyExp();
            this.hierarchy.addToFrom(sqlQuery, keyExp);
            String expString = keyExp.getExpression(sqlQuery);
            String keyAlias = sqlQuery.addSelectGroupBy(expString, null);
            if (!keyExp.equals(level.getOrdinalExp())) {
                MondrianDef.Expression ordinalExp = level.getOrdinalExp();
                this.hierarchy.addToFrom(sqlQuery, ordinalExp);
                String ordinalExpString = ordinalExp.getExpression(sqlQuery);
                String orderAlias = sqlQuery.addSelectGroupBy(ordinalExpString, null);
                sqlQuery.addOrderBy(ordinalExpString, orderAlias, true, false, true, true);
            } else {
                sqlQuery.addOrderBy(expString, keyAlias, true, false, true, true);
            }
            for (RolapProperty property : properties = level.getProperties()) {
                MondrianDef.Expression propExpr = property.getExp();
                this.hierarchy.addToFrom(sqlQuery, propExpr);
                String propStringExpr = propExpr.getExpression(sqlQuery);
                String propAlias = sqlQuery.addSelect(propStringExpr, null);
                if (sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
                sqlQuery.addGroupBy(propStringExpr, propAlias);
            }
        }
        return sqlQuery.toSqlAndTypes();
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        return this.getMembersInLevel(level, constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, TupleConstraint constraint) {
        SqlTupleReader tupleReader;
        if (level.isAll()) {
            return Collections.singletonList(this.hierarchy.getAllMember());
        }
        Dimension dimension = level.getDimension();
        boolean isHighCardinality = dimension.isHighCardinality();
        SqlTupleReader sqlTupleReader = tupleReader = isHighCardinality ? new HighCardSqlTupleReader(constraint) : new SqlTupleReader(constraint);
        if (isHighCardinality) {
            LOGGER.warn(MondrianResource.instance().HighCardinalityInDimension.str(dimension.getUniqueName()));
        }
        tupleReader.addLevelMembers(level, this, null);
        TupleList tupleList = tupleReader.readMembers(this.dataSource, null, null);
        assert (tupleList.getArity() == 1);
        return Util.cast(tupleList.slice(0));
    }

    @Override
    public MemberCache getMemberCache() {
        return this.cache;
    }

    @Override
    public Object getMemberCacheLock() {
        return this.cache;
    }

    @Override
    public List<RolapMember> getRootMembers() {
        return this.getMembersInLevel((RolapLevel)this.hierarchy.getLevels()[0]);
    }

    Pair<String, List<SqlStatement.Type>> makeChildMemberSql(RolapMember member, DataSource dataSource, MemberChildrenConstraint constraint) {
        RolapProperty[] properties;
        String orderBy;
        SqlQuery sqlQuery = SqlQuery.newQuery(dataSource, "while generating query to retrieve children of member " + member);
        AggStar aggStar = SqlMemberSource.chooseAggStar(constraint, member);
        constraint.addMemberConstraint(sqlQuery, null, aggStar, member);
        RolapLevel level = (RolapLevel)member.getLevel().getChildLevel();
        boolean levelCollapsed = aggStar != null && SqlMemberSource.isLevelCollapsed(aggStar, (RolapCubeLevel)level);
        boolean multipleCols = SqlMemberSource.levelContainsMultipleColumns(level);
        if (levelCollapsed && !multipleCols) {
            RolapStar.Column starColumn = ((RolapCubeLevel)level).getStarKeyColumn();
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            String q = aggColumn.generateExprString(sqlQuery);
            String qAlias = sqlQuery.addSelectGroupBy(q, starColumn.getInternalType());
            sqlQuery.addOrderBy(q, qAlias, true, false, true, true);
            aggColumn.getTable().addToFrom(sqlQuery, false, true);
            return sqlQuery.toSqlAndTypes();
        }
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String q = level.getKeyExp().getExpression(sqlQuery);
        String idAlias = sqlQuery.addSelectGroupBy(q, level.getInternalType());
        constraint.addLevelConstraint(sqlQuery, null, aggStar, level);
        if (levelCollapsed) {
            RolapStar.Column starColumn = ((RolapCubeLevel)level).getStarKeyColumn();
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            RolapStar.Condition condition = new RolapStar.Condition(level.getKeyExp(), aggColumn.getExpression());
            sqlQuery.addWhere(condition.toString(sqlQuery));
            this.hierarchy.addToFromInverse(sqlQuery, level.getKeyExp());
            boolean isUnique = level.isUnique();
            for (RolapCubeLevel parentLevel = (RolapCubeLevel)level.getParentLevel(); parentLevel != null && !parentLevel.isAll() && !isUnique; parentLevel = parentLevel.getParentLevel()) {
                this.hierarchy.addToFromInverse(sqlQuery, parentLevel.getKeyExp());
                starColumn = parentLevel.getStarKeyColumn();
                bitPos = starColumn.getBitPosition();
                aggColumn = aggStar.lookupColumn(bitPos);
                condition = new RolapStar.Condition(parentLevel.getKeyExp(), aggColumn.getExpression());
                sqlQuery.addWhere(condition.toString(sqlQuery));
            }
        }
        if (level.hasCaptionColumn()) {
            MondrianDef.Expression captionExp = level.getCaptionExp();
            if (!levelCollapsed) {
                this.hierarchy.addToFrom(sqlQuery, captionExp);
            }
            String captionSql = captionExp.getExpression(sqlQuery);
            sqlQuery.addSelectGroupBy(captionSql, null);
        }
        if (!levelCollapsed) {
            this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        }
        if (!(orderBy = level.getOrdinalExp().getExpression(sqlQuery)).equals(q)) {
            String orderAlias = sqlQuery.addSelectGroupBy(orderBy, null);
            sqlQuery.addOrderBy(orderBy, orderAlias, true, false, true, true);
        } else {
            sqlQuery.addOrderBy(q, idAlias, true, false, true, true);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            if (!levelCollapsed) {
                this.hierarchy.addToFrom(sqlQuery, exp);
            }
            String s = exp.getExpression(sqlQuery);
            String alias = sqlQuery.addSelect(s, property.getType().getInternalType());
            if (sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
            sqlQuery.addGroupBy(s, alias);
        }
        return sqlQuery.toSqlAndTypes();
    }

    private static AggStar chooseAggStar(MemberChildrenConstraint constraint, RolapMember member) {
        RolapStar.Column[] columns;
        if (!MondrianProperties.instance().UseAggregates.get() || !(constraint instanceof SqlContextConstraint)) {
            return null;
        }
        SqlContextConstraint contextConstraint = (SqlContextConstraint)constraint;
        Evaluator evaluator = contextConstraint.getEvaluator();
        RolapCube cube = (RolapCube)evaluator.getCube();
        RolapStar star = cube.getStar();
        int starColumnCount = star.getColumnCount();
        BitKey measureBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        BitKey levelBitKey = BitKey.Factory.makeBitKey(starColumnCount);
        Member[] members = SqlConstraintUtils.expandSupportedCalculatedMembers(Arrays.asList(evaluator.getNonAllMembers()), evaluator).getMembersArray();
        if (!(members[0] instanceof RolapBaseCubeMeasure)) {
            return null;
        }
        RolapBaseCubeMeasure measure = (RolapBaseCubeMeasure)members[0];
        int bitPosition = ((RolapStar.Measure)measure.getStarMeasure()).getBitPosition();
        RolapCubeLevel childLevel = (RolapCubeLevel)member.getLevel().getChildLevel();
        RolapStar.Column column = childLevel.getStarKeyColumn();
        CellRequest request = RolapAggregationManager.makeRequest(members);
        if (request == null) {
            return null;
        }
        for (RolapStar.Column column1 : columns = request.getConstrainedColumns()) {
            levelBitKey.set(column1.getBitPosition());
        }
        levelBitKey.set(column.getBitPosition());
        measureBitKey.set(bitPosition);
        RolapUtil.constraintBitkeyForLimitedMembers(evaluator, members, cube, levelBitKey);
        return AggregationManager.findAgg(star, levelBitKey, measureBitKey, new boolean[]{false});
    }

    public static boolean levelContainsMultipleColumns(RolapLevel level) {
        RolapProperty[] properties;
        if (level.isAll()) {
            return false;
        }
        MondrianDef.Expression keyExp = level.getKeyExp();
        MondrianDef.Expression ordinalExp = level.getOrdinalExp();
        MondrianDef.Expression captionExp = level.getCaptionExp();
        if (!keyExp.equals(ordinalExp)) {
            return true;
        }
        if (captionExp != null && !keyExp.equals(captionExp)) {
            return true;
        }
        for (RolapProperty property : properties = level.getProperties()) {
            if (property.getExp().equals(keyExp)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLevelCollapsed(AggStar aggStar, RolapCubeLevel level) {
        boolean levelCollapsed = false;
        if (level.isAll()) {
            return levelCollapsed;
        }
        RolapStar.Column starColumn = level.getStarKeyColumn();
        int bitPos = starColumn.getBitPosition();
        AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
        if (aggColumn.getTable() instanceof AggStar.FactTable) {
            levelCollapsed = true;
        }
        return levelCollapsed;
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMembers, children, constraint);
    }

    @Override
    public Map<? extends Member, Access> getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint mcc) {
        RolapLevel childLevel = this.getCommonChildLevelForDescendants(parentMembers);
        if (childLevel != null) {
            TupleConstraint lmc = this.sqlConstraintFactory.getDescendantsConstraint(parentMembers, mcc);
            List<RolapMember> list = this.getMembersInLevel(childLevel, lmc);
            children.addAll(list);
            return Util.toNullValuesMap(children);
        }
        for (RolapMember parentMember : parentMembers) {
            this.getMemberChildren(parentMember, children, mcc);
        }
        return Util.toNullValuesMap(children);
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        this.getMemberChildren(parentMember, children, constraint);
    }

    @Override
    public Map<? extends Member, Access> getMemberChildren(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        if (!parentMember.isAll() && parentMember.isCalculated() && !parentMember.getLevel().isParentChild()) {
            return Util.toNullValuesMap(Collections.emptyList());
        }
        this.getMemberChildren2(parentMember, children, constraint);
        return Util.toNullValuesMap(children);
    }

    private RolapLevel getCommonChildLevelForDescendants(List<RolapMember> parents) {
        if (parents.size() < 2) {
            return null;
        }
        RolapLevel parentLevel = null;
        RolapLevel childLevel = null;
        for (RolapMember member : parents) {
            if (member.isCalculated()) {
                return null;
            }
            if (parentLevel == null) {
                parentLevel = member.getLevel();
                if (parentLevel.isParentChild()) {
                    return null;
                }
                childLevel = (RolapLevel)parentLevel.getChildLevel();
                if (childLevel == null) {
                    return null;
                }
                if (!childLevel.isParentChild()) continue;
                return null;
            }
            if (parentLevel == member.getLevel()) continue;
            return null;
        }
        return childLevel;
    }

    private void getMemberChildren2(RolapMember parentMember, List<RolapMember> children, MemberChildrenConstraint constraint) {
        RolapLevel childLevel;
        boolean parentChild;
        Pair<String, List<SqlStatement.Type>> pair;
        RolapLevel parentLevel = parentMember.getLevel();
        if (parentLevel.isParentChild()) {
            pair = this.makeChildMemberSqlPC(parentMember);
            parentChild = true;
            childLevel = parentLevel;
        } else {
            childLevel = (RolapLevel)parentLevel.getChildLevel();
            if (childLevel == null) {
                return;
            }
            if (childLevel.isParentChild()) {
                pair = this.makeChildMemberSql_PCRoot(parentMember);
                parentChild = true;
            } else {
                pair = this.makeChildMemberSql(parentMember, this.dataSource, constraint);
                parentChild = false;
            }
        }
        String sql = (String)pair.left;
        int startChildrenSize = children.size();
        HashMap<RolapMember, Object> rolapToOrdinalMap = new HashMap<RolapMember, Object>();
        List types = (List)pair.right;
        try (SqlStatement stmt = RolapUtil.executeQuery(this.dataSource, sql, types, 0, 0, new SqlStatement.StatementLocus(Locus.peek().execution, "SqlMemberSource.getMemberChildren", "while building member cache", SqlStatementEvent.Purpose.TUPLES, 0), -1, -1, null);){
            int limit = MondrianProperties.instance().ResultLimit.get();
            boolean checkCacheStatus = true;
            List<SqlStatement.Accessor> accessors = stmt.getAccessors();
            ResultSet resultSet = stmt.getResultSet();
            RolapMember parentMember2 = RolapUtil.strip(parentMember);
            Execution execution = Locus.peek().execution;
            while (resultSet.next()) {
                Object ordinal;
                Object prevValue;
                CancellationChecker.checkCancelOrTimeout(++stmt.rowCount, execution);
                if (limit > 0 && limit < stmt.rowCount) {
                    throw MondrianResource.instance().MemberFetchLimitExceeded.ex(limit);
                }
                Comparable<?> value = accessors.get(0).get();
                if (value == null) {
                    value = RolapUtil.sqlNullValue;
                }
                int columnOffset = 1;
                Object captionValue = childLevel.hasCaptionColumn() ? accessors.get(columnOffset++).get() : null;
                Object key = this.cache.makeKey(parentMember2, value);
                RolapMember member = this.cache.getMember(key, checkCacheStatus);
                checkCacheStatus = false;
                if (member == null) {
                    member = this.makeMember(parentMember2, childLevel, value, captionValue, parentChild, stmt, key, columnOffset);
                }
                if (value == RolapUtil.sqlNullValue) {
                    children.toArray();
                    this.addAsOldestSibling(children, member);
                } else {
                    children.add(member);
                }
                if (childLevel.getOrdinalExp().equals(childLevel.getKeyExp()) || (prevValue = rolapToOrdinalMap.put(member, ordinal = accessors.get(columnOffset).get())) == null || Util.equals(prevValue, ordinal)) continue;
                LOGGER.error("Column expression for " + member.getUniqueName() + " is inconsistent with ordinal or caption expression. It should have 1:1 relationship");
            }
        }
    }

    @Override
    public RolapMember makeMember(RolapMember parentMember, RolapLevel childLevel, Object value, Object captionValue, boolean parentChild, SqlStatement stmt, Object key, int columnOffset) throws SQLException {
        RolapLevel rolapChildLevel = childLevel instanceof RolapCubeLevel ? ((RolapCubeLevel)childLevel).getRolapLevel() : childLevel;
        RolapMemberBase member = new RolapMemberBase(parentMember, rolapChildLevel, value);
        if (!childLevel.getOrdinalExp().equals(childLevel.getKeyExp())) {
            member.setOrdinal(this.lastOrdinal++);
        }
        if (captionValue != null) {
            member.setCaptionValue(captionValue);
        }
        if (parentChild) {
            member = childLevel.hasClosedPeer() ? new RolapParentChildMember(parentMember, rolapChildLevel, value, member) : new RolapParentChildMemberNoClosure(parentMember, rolapChildLevel, value, member);
        }
        RolapProperty[] properties = childLevel.getProperties();
        List<SqlStatement.Accessor> accessors = stmt.getAccessors();
        if (!childLevel.getOrdinalExp().equals(childLevel.getKeyExp())) {
            if (this.assignOrderKeys) {
                Object orderKey = accessors.get(columnOffset).get();
                this.setOrderKey(member, orderKey);
            }
            ++columnOffset;
        }
        for (int j = 0; j < properties.length; ++j) {
            RolapProperty property = properties[j];
            member.setProperty(property.getName(), this.getPooledValue(accessors.get(columnOffset + j).get()));
        }
        this.cache.putMember(key, member);
        return member;
    }

    @Override
    public RolapMember allMember() {
        RolapHierarchy rolapHierarchy = this.hierarchy instanceof RolapCubeHierarchy ? ((RolapCubeHierarchy)this.hierarchy).getRolapHierarchy() : this.hierarchy;
        return rolapHierarchy.getAllMember();
    }

    private Object getPooledValue(Object incoming) {
        if (this.valuePool == null) {
            return incoming;
        }
        Object ret = this.valuePool.get(incoming);
        if (ret != null) {
            return ret;
        }
        this.valuePool.put(incoming, incoming);
        return incoming;
    }

    private Pair<String, List<SqlStatement.Type>> makeChildMemberSql_PCRoot(RolapMember member) {
        SqlQuery sqlQuery = SqlQuery.newQuery(this.dataSource, "while generating query to retrieve children of parent/child hierarchy member " + member);
        Util.assertTrue(member.isAll(), "In the current implementation, parent/child hierarchies must have only one level (plus the 'All' level).");
        RolapLevel level = (RolapLevel)member.getLevel().getChildLevel();
        Util.assertTrue(!level.isAll(), "all level cannot be parent-child");
        Util.assertTrue(level.isUnique(), "parent-child level '" + level + "' must be unique");
        this.hierarchy.addToFrom(sqlQuery, level.getParentExp());
        String parentId = level.getParentExp().getExpression(sqlQuery);
        StringBuilder condition = new StringBuilder(64);
        condition.append(parentId);
        if (level.getNullParentValue() == null || level.getNullParentValue().equalsIgnoreCase("NULL")) {
            condition.append(" IS NULL");
        } else {
            try {
                Util.discard((double)Double.parseDouble(level.getNullParentValue()));
                condition.append(" = ");
                condition.append(level.getNullParentValue());
            }
            catch (NumberFormatException e) {
                condition.append(" = ");
                Util.singleQuoteString(level.getNullParentValue(), condition);
            }
        }
        sqlQuery.addWhere(condition.toString());
        this.addLevel(sqlQuery, level, true);
        return sqlQuery.toSqlAndTypes();
    }

    private void addLevel(SqlQuery sqlQuery, RolapLevel level, boolean group) {
        RolapProperty[] properties;
        MondrianDef.Expression key = level.getKeyExp();
        MondrianDef.Expression order = level.getOrdinalExp();
        this.hierarchy.addToFrom(sqlQuery, key);
        this.hierarchy.addToFrom(sqlQuery, order);
        String keySql = key.getExpression(sqlQuery);
        String keyAlias = group ? sqlQuery.addSelectGroupBy(keySql, level.getInternalType()) : sqlQuery.addSelect(keySql, level.getInternalType());
        String orderSql = order.getExpression(sqlQuery);
        if (!orderSql.equals(keySql)) {
            String orderAlias = group ? sqlQuery.addSelectGroupBy(orderSql, null) : sqlQuery.addSelect(orderSql, null);
            sqlQuery.addOrderBy(orderSql, orderAlias, true, false, true, true);
        } else {
            sqlQuery.addOrderBy(keySql, keyAlias, true, false, true, true);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            String alias = sqlQuery.addSelect(s, null);
            if (!group || sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
            sqlQuery.addGroupBy(s, alias);
        }
    }

    private Pair<String, List<SqlStatement.Type>> makeChildMemberSqlPC(RolapMember member) {
        RolapProperty[] properties;
        SqlQuery sqlQuery = SqlQuery.newQuery(this.dataSource, "while generating query to retrieve children of parent/child hierarchy member " + member);
        RolapLevel level = member.getLevel();
        Util.assertTrue(!level.isAll(), "all level cannot be parent-child");
        Util.assertTrue(level.isUnique(), "parent-child level '" + level + "' must be unique");
        this.hierarchy.addToFrom(sqlQuery, level.getParentExp());
        String parentId = level.getParentExp().getExpression(sqlQuery);
        StringBuilder buf = new StringBuilder();
        sqlQuery.getDialect().quote(buf, member.getKey(), level.getDatatype());
        sqlQuery.addWhere(parentId, " = ", buf.toString());
        this.hierarchy.addToFrom(sqlQuery, level.getKeyExp());
        String childId = level.getKeyExp().getExpression(sqlQuery);
        String idAlias = sqlQuery.addSelectGroupBy(childId, level.getInternalType());
        this.hierarchy.addToFrom(sqlQuery, level.getOrdinalExp());
        String orderBy = level.getOrdinalExp().getExpression(sqlQuery);
        if (!orderBy.equals(childId)) {
            String orderAlias = sqlQuery.addSelectGroupBy(orderBy, null);
            sqlQuery.addOrderBy(orderBy, orderAlias, true, false, true, true);
        } else {
            sqlQuery.addOrderBy(childId, idAlias, true, false, true, true);
        }
        for (RolapProperty property : properties = level.getProperties()) {
            MondrianDef.Expression exp = property.getExp();
            this.hierarchy.addToFrom(sqlQuery, exp);
            String s = exp.getExpression(sqlQuery);
            String alias = sqlQuery.addSelect(s, null);
            if (sqlQuery.getDialect().allowsSelectNotInGroupBy() && property.dependsOnLevelValue()) continue;
            sqlQuery.addGroupBy(s, alias);
        }
        return sqlQuery.toSqlAndTypes();
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> memberList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return this;
    }

    @Override
    public RolapMember getDefaultMember() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        throw new UnsupportedOperationException();
    }

    public static final class ValuePoolFactoryFactory
    extends ObjectFactory.Singleton<ValuePoolFactory> {
        private static final ValuePoolFactoryFactory factory = new ValuePoolFactoryFactory();

        public static ValuePoolFactory getValuePoolFactory() {
            return (ValuePoolFactory)factory.getObject();
        }

        private ValuePoolFactoryFactory() {
            super(ValuePoolFactory.class);
        }

        @Override
        protected StringProperty getStringProperty() {
            return MondrianProperties.instance().SqlMemberSourceValuePoolFactoryClass;
        }

        @Override
        protected ValuePoolFactory getDefault(Class[] parameterTypes, Object[] parameterValues) throws CreationException {
            return new NullValuePoolFactory();
        }
    }

    public static final class NullValuePoolFactory
    implements ValuePoolFactory {
        @Override
        public Map<Object, Object> create(SqlMemberSource source) {
            return null;
        }
    }

    public static interface ValuePoolFactory {
        public Map<Object, Object> create(SqlMemberSource var1);
    }

    private static class RolapParentChildMemberNoClosure
    extends RolapParentChildMember {
        public RolapParentChildMemberNoClosure(RolapMember parentMember, RolapLevel childLevel, Object value, RolapMember dataMember) {
            super(parentMember, childLevel, value, dataMember);
        }

        @Override
        protected boolean computeCalculated(Member.MemberType memberType) {
            return true;
        }

        @Override
        public Exp getExpression() {
            return this.getHierarchy().getAggregateChildrenExpression();
        }

        @Override
        public boolean isParentChildPhysicalMember() {
            return true;
        }
    }

    private static class RolapParentChildMember
    extends RolapMemberBase {
        private final RolapMember dataMember;
        private int depth = 0;

        public RolapParentChildMember(RolapMember parentMember, RolapLevel childLevel, Object value, RolapMember dataMember) {
            super(parentMember, childLevel, value);
            this.dataMember = dataMember;
            this.depth = parentMember != null ? parentMember.getDepth() + 1 : 0;
        }

        @Override
        public Member getDataMember() {
            return this.dataMember;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public int getOrdinal() {
            return this.dataMember.getOrdinal();
        }
    }
}

