/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import mondrian.rolap.CellKey;
import mondrian.rolap.agg.AbstractSegmentBody;
import mondrian.util.Pair;

class SparseSegmentBody
extends AbstractSegmentBody {
    private static final long serialVersionUID = -6684830985364895836L;
    final CellKey[] keys;
    final Object[] data;

    SparseSegmentBody(Map<CellKey, Object> dataToSave, List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        super(axes);
        this.keys = new CellKey[dataToSave.size()];
        this.data = new Object[dataToSave.size()];
        int i = 0;
        for (Map.Entry<CellKey, Object> entry : dataToSave.entrySet()) {
            this.keys[i] = entry.getKey();
            this.data[i] = entry.getValue();
            ++i;
        }
    }

    @Override
    protected int getSize() {
        return this.keys.length;
    }

    @Override
    protected Object getObject(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<CellKey, Object> getValueMap() {
        HashMap<CellKey, Object> map = new HashMap<CellKey, Object>(this.keys.length * 3 / 2);
        for (int i = 0; i < this.keys.length; ++i) {
            map.put(this.keys[i], this.data[i]);
        }
        return map;
    }
}

