/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi;

import java.util.regex.Pattern;

public class DialectUtil {
    private static final Pattern UNICODE_CASE_FLAG_IN_JAVA_REG_EXP_PATTERN = Pattern.compile("\\|\\(\\?u\\)");
    private static final String EMPTY = "";

    public static String cleanUnicodeAwareCaseFlag(String javaRegExp) {
        String cleaned = javaRegExp;
        if (cleaned != null && DialectUtil.isUnicodeCaseFlagInRegExp(cleaned)) {
            cleaned = UNICODE_CASE_FLAG_IN_JAVA_REG_EXP_PATTERN.matcher(cleaned).replaceAll(EMPTY);
        }
        return cleaned;
    }

    private static boolean isUnicodeCaseFlagInRegExp(String javaRegExp) {
        return UNICODE_CASE_FLAG_IN_JAVA_REG_EXP_PATTERN.matcher(javaRegExp).find();
    }
}

