/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Properties;
import mondrian.util.ClassResolver;
import mondrian.util.CreationException;
import org.eigenbase.util.property.StringProperty;

public abstract class ObjectFactory<V> {
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private final Class<V> interfaceClass;

    protected ObjectFactory(Class<V> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    protected final V getObject() throws CreationException {
        return this.getObject(System.getProperties());
    }

    protected final V getObject(Properties props) throws CreationException {
        return this.getObject(props, EMPTY_CLASS_ARRAY, EMPTY_OBJECT_ARRAY);
    }

    protected final V getObject(Class[] parameterTypes, Object[] parameterValues) throws CreationException {
        return this.getObject(System.getProperties(), parameterTypes, parameterValues);
    }

    protected V getObject(Properties props, Class[] parameterTypes, Object[] parameterValues) throws CreationException {
        String className = this.getClassName();
        if (className != null) {
            return this.getObject(className, parameterTypes, parameterValues);
        }
        String propClassName = this.getClassName(props);
        return propClassName != null ? this.getObject(propClassName, parameterTypes, parameterValues) : this.getDefault(parameterTypes, parameterValues);
    }

    protected V getObject(String className, Class[] parameterTypes, Object[] parameterValues) throws CreationException {
        try {
            Class genericClass = ClassResolver.INSTANCE.forName(className, true);
            if (InvocationHandler.class.isAssignableFrom(genericClass)) {
                Constructor constructor = genericClass.getConstructor(parameterTypes);
                InvocationHandler handler = (InvocationHandler)constructor.newInstance(parameterValues);
                return (V)Proxy.newProxyInstance(genericClass.getClassLoader(), new Class[]{this.interfaceClass}, handler);
            }
            Class<V> specificClass = genericClass.asSubclass(this.interfaceClass);
            Constructor<V> constructor = specificClass.getConstructor(parameterTypes);
            return constructor.newInstance(parameterValues);
        }
        catch (Exception exc) {
            throw new CreationException("Error creating object of type \"" + this.interfaceClass.getName() + "\"", exc);
        }
    }

    protected String getClassName() {
        return null;
    }

    protected String getClassName(Properties props) {
        StringProperty stringProp = this.getStringProperty();
        String className = stringProp.get();
        return className != null ? className : (props == null ? null : props.getProperty(stringProp.getPath()));
    }

    protected abstract StringProperty getStringProperty();

    protected abstract V getDefault(Class[] var1, Object[] var2) throws CreationException;

    public Object removeContext() {
        return null;
    }

    public void restoreContext(Object context) {
    }

    public static interface Context {
    }

    public static abstract class Singleton<T>
    extends ObjectFactory<T> {
        protected T singleInstance;
        protected T testSingleInstance;

        protected Singleton(Class<T> interfaceClass) {
            super(interfaceClass);
        }

        @Override
        protected T getObject(Properties props, Class[] parameterTypes, Object[] parameterValues) throws CreationException {
            String className = this.getClassName();
            if (className != null) {
                if (this.testSingleInstance == null) {
                    this.testSingleInstance = this.getTestObject(className, parameterTypes, parameterValues);
                }
                return this.testSingleInstance;
            }
            if (this.singleInstance == null) {
                String propClassName = this.getClassName(props);
                this.singleInstance = propClassName != null ? this.getObject(propClassName, parameterTypes, parameterValues) : this.getDefault(parameterTypes, parameterValues);
            }
            return this.singleInstance;
        }

        protected T getTestObject(String className, Class[] parameterTypes, Object[] parameterValues) throws CreationException {
            return (T)this.getObject(className, parameterTypes, parameterValues);
        }
    }
}

