/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import mondrian.olap.Util;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.impl.DefaultXmlaServlet;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.olap4j.OlapConnection;
import org.olap4j.OlapWrapper;

public class Olap4jXmlaServlet
extends DefaultXmlaServlet {
    private static final Logger LOGGER = LogManager.getLogger(Olap4jXmlaServlet.class);
    private static final String OLAP_DRIVER_CLASS_NAME_PARAM = "OlapDriverClassName";
    private static final String OLAP_DRIVER_CONNECTION_STRING_PARAM = "OlapDriverConnectionString";
    private static final String OLAP_DRIVER_CONNECTION_PROPERTIES_PREFIX = "OlapDriverConnectionProperty.";
    private static final String OLAP_DRIVER_PRECONFIGURED_DISCOVER_DATASOURCES_RESPONSE = "OlapDriverUsePreConfiguredDiscoverDatasourcesResponse";
    private static final String OLAP_DRIVER_IDLE_CONNECTIONS_TIMEOUT_MINUTES = "OlapDriverIdleConnectionsTimeoutMinutes";
    private static final String OLAP_DRIVER_PRECONFIGURED_DISCOVER_DATASOURCES_PREFIX = "OlapDriverDiscoverDatasources.";
    private static final String JDBC_USER = "user";
    private static final String JDBC_PASSWORD = "password";
    private static final int DEFAULT_IDLE_CONNECTIONS_TIMEOUT_MS = 300000;
    private static final String OLAP_DRIVER_MAX_NUM_CONNECTIONS_PER_USER = "OlapDriverMaxNumConnectionsPerUser";

    private static <T> T unwrap(Connection connection, Class<T> clazz) throws SQLException {
        try {
            Class<?> wrapperClass = Class.forName("java.sql.Wrapper");
            if (wrapperClass.isInstance(connection)) {
                Method unwrapMethod = wrapperClass.getMethod("unwrap", new Class[0]);
                return clazz.cast(unwrapMethod.invoke((Object)connection, clazz));
            }
        }
        catch (ClassNotFoundException wrapperClass) {
        }
        catch (NoSuchMethodException wrapperClass) {
        }
        catch (InvocationTargetException wrapperClass) {
        }
        catch (IllegalAccessException wrapperClass) {
            // empty catch block
        }
        if (connection instanceof OlapWrapper) {
            OlapWrapper olapWrapper = (OlapWrapper)connection;
            return (T)olapWrapper.unwrap(clazz);
        }
        throw new SQLException("not an instance");
    }

    @Override
    protected XmlaHandler.ConnectionFactory createConnectionFactory(ServletConfig servletConfig) throws ServletException {
        String olap4jDriverClassName = servletConfig.getInitParameter(OLAP_DRIVER_CLASS_NAME_PARAM);
        String olap4jDriverConnectionString = servletConfig.getInitParameter(OLAP_DRIVER_CONNECTION_STRING_PARAM);
        String olap4jUsePreConfiguredDiscoverDatasourcesRes = servletConfig.getInitParameter(OLAP_DRIVER_PRECONFIGURED_DISCOVER_DATASOURCES_RESPONSE);
        boolean hardcodedDiscoverDatasources = olap4jUsePreConfiguredDiscoverDatasourcesRes != null && Boolean.parseBoolean(olap4jUsePreConfiguredDiscoverDatasourcesRes);
        String idleConnTimeoutStr = servletConfig.getInitParameter(OLAP_DRIVER_IDLE_CONNECTIONS_TIMEOUT_MINUTES);
        int idleConnectionsCleanupTimeoutMs = idleConnTimeoutStr != null ? Integer.parseInt(idleConnTimeoutStr) * 60 * 1000 : 300000;
        String maxNumConnPerUserStr = servletConfig.getInitParameter(OLAP_DRIVER_MAX_NUM_CONNECTIONS_PER_USER);
        int maxNumConnectionsPerUser = maxNumConnPerUserStr != null ? Integer.parseInt(maxNumConnPerUserStr) : 1;
        try {
            Map<String, String> connectionProperties = Olap4jXmlaServlet.getOlap4jConnectionProperties(servletConfig, OLAP_DRIVER_CONNECTION_PROPERTIES_PREFIX);
            Map<String, Object> ddhcRes = hardcodedDiscoverDatasources ? Olap4jXmlaServlet.getDiscoverDatasourcesPreConfiguredResponse(servletConfig) : null;
            return new Olap4jPoolingConnectionFactory(olap4jDriverClassName, olap4jDriverConnectionString, connectionProperties, idleConnectionsCleanupTimeoutMs, maxNumConnectionsPerUser, ddhcRes);
        }
        catch (Exception ex) {
            String msg = "Exception [" + ex + "] while trying to create olap4j connection to [" + olap4jDriverConnectionString + "] using driver [" + olap4jDriverClassName + "]";
            LOGGER.error(msg, (Throwable)ex);
            throw new ServletException(msg, (Throwable)ex);
        }
    }

    private static Map<String, Object> getDiscoverDatasourcesPreConfiguredResponse(ServletConfig servletConfig) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Olap4jXmlaServlet.foo(map, "DataSourceName", servletConfig, "dataSourceName");
        Olap4jXmlaServlet.foo(map, "DataSourceDescription", servletConfig, "dataSourceDescription");
        Olap4jXmlaServlet.foo(map, "URL", servletConfig, "url");
        Olap4jXmlaServlet.foo(map, "DataSourceInfo", servletConfig, "dataSourceInfo");
        Olap4jXmlaServlet.foo(map, "ProviderName", servletConfig, "providerName");
        Olap4jXmlaServlet.foo(map, "ProviderType", servletConfig, "providerType");
        Olap4jXmlaServlet.foo(map, "AuthenticationMode", servletConfig, "authenticationMode");
        return map;
    }

    private static void foo(Map<String, Object> map, String targetProp, ServletConfig servletConfig, String sourceProp) {
        String value = servletConfig.getInitParameter(OLAP_DRIVER_PRECONFIGURED_DISCOVER_DATASOURCES_PREFIX + sourceProp);
        map.put(targetProp, value);
    }

    private static Map<String, String> getOlap4jConnectionProperties(ServletConfig servletConfig, String prefix) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        Enumeration en = servletConfig.getInitParameterNames();
        while (en.hasMoreElements()) {
            String paramName = (String)en.nextElement();
            if (!paramName.startsWith(prefix)) continue;
            String paramValue = servletConfig.getInitParameter(paramName);
            String prefixRemovedParamName = paramName.substring(prefix.length());
            options.put(prefixRemovedParamName, paramValue);
        }
        Map<String, String> systemProps = Util.toMap(System.getProperties());
        for (Map.Entry<String, String> entry : systemProps.entrySet()) {
            String sk = entry.getKey();
            if (!sk.startsWith(prefix)) continue;
            String value = entry.getValue();
            String prefixRemovedKey = sk.substring(prefix.length());
            options.put(prefixRemovedKey, value);
        }
        return options;
    }

    private static OlapConnection createDelegatingOlapConnection(final Connection connection, final OlapConnection olapConnection) {
        return (OlapConnection)Proxy.newProxyInstance(olapConnection.getClass().getClassLoader(), new Class[]{OlapConnection.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("unwrap".equals(method.getName()) || OlapConnection.class.isAssignableFrom(method.getDeclaringClass())) {
                    return method.invoke((Object)olapConnection, args);
                }
                return method.invoke((Object)connection, args);
            }
        });
    }

    private static class Olap4jPoolingConnectionFactory
    implements XmlaHandler.ConnectionFactory {
        private final String olap4jDriverConnectionString;
        private final Properties connProperties;
        private final Map<String, Object> discoverDatasourcesResponse;
        private final String olap4jDriverClassName;
        private final Map<String, BasicDataSource> datasourcesPool = new HashMap<String, BasicDataSource>();
        private final int idleConnectionsCleanupTimeoutMs;
        private final int maxPerUserConnectionCount;

        public Olap4jPoolingConnectionFactory(String olap4jDriverClassName, String olap4jDriverConnectionString, Map<String, String> connectionProperties, int idleConnectionsCleanupTimeoutMs, int maxPerUserConnectionCount, Map<String, Object> discoverDatasourcesResponse) throws ClassNotFoundException {
            Class.forName(olap4jDriverClassName);
            this.maxPerUserConnectionCount = maxPerUserConnectionCount;
            this.idleConnectionsCleanupTimeoutMs = idleConnectionsCleanupTimeoutMs;
            this.olap4jDriverClassName = olap4jDriverClassName;
            this.olap4jDriverConnectionString = olap4jDriverConnectionString;
            this.connProperties = new Properties();
            this.connProperties.putAll(connectionProperties);
            this.discoverDatasourcesResponse = discoverDatasourcesResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OlapConnection getConnection(String catalog, String schema, String roleName, Properties props) throws SQLException {
            BasicDataSource bds;
            String user = props.getProperty(Olap4jXmlaServlet.JDBC_USER);
            String pwd = props.getProperty(Olap4jXmlaServlet.JDBC_PASSWORD);
            String dataSourceKey = user + "_" + pwd;
            Map<String, BasicDataSource> map = this.datasourcesPool;
            synchronized (map) {
                bds = this.datasourcesPool.get(dataSourceKey);
                if (bds == null) {
                    bds = new BasicDataSource(){
                        {
                            this.connectionProperties.putAll((Map<?, ?>)connProperties);
                        }
                    };
                    bds.setDefaultReadOnly(true);
                    bds.setDriverClassName(this.olap4jDriverClassName);
                    bds.setPassword(pwd);
                    bds.setUsername(user);
                    bds.setUrl(this.olap4jDriverConnectionString);
                    bds.setPoolPreparedStatements(false);
                    bds.setMaxIdle(this.maxPerUserConnectionCount);
                    bds.setMaxActive(this.maxPerUserConnectionCount);
                    bds.setMinEvictableIdleTimeMillis((long)this.idleConnectionsCleanupTimeoutMs);
                    bds.setAccessToUnderlyingConnectionAllowed(true);
                    bds.setInitialSize(1);
                    bds.setTimeBetweenEvictionRunsMillis(60000L);
                    if (catalog != null) {
                        bds.setDefaultCatalog(catalog);
                    }
                    this.datasourcesPool.put(dataSourceKey, bds);
                }
            }
            Connection connection = bds.getConnection();
            DelegatingConnection dc = (DelegatingConnection)connection;
            Connection underlyingOlapConnection = dc.getInnermostDelegate();
            OlapConnection olapConnection = (OlapConnection)Olap4jXmlaServlet.unwrap(underlyingOlapConnection, OlapConnection.class);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Obtained connection object [" + olapConnection + "] (ext pool wrapper " + connection + ") for key " + dataSourceKey);
            }
            if (catalog != null) {
                olapConnection.setCatalog(catalog);
            }
            if (schema != null) {
                olapConnection.setSchema(schema);
            }
            if (roleName != null) {
                olapConnection.setRoleName(roleName);
            }
            return Olap4jXmlaServlet.createDelegatingOlapConnection(connection, olapConnection);
        }

        @Override
        public Map<String, Object> getPreConfiguredDiscoverDatasourcesResponse() {
            return this.discoverDatasourcesResponse;
        }
    }
}

