import { CommonModule } from '@angular/common'
import { ChangeDetectionStrategy, Component, HostBinding, input, model } from '@angular/core'
import { MatIconModule } from '@angular/material/icon'

@Component({
  standalone: true,
  changeDetection: ChangeDetectionStrategy.OnPush,
  selector: 'ngm-drawer',
  templateUrl: './drawer.component.html',
  styleUrls: ['./drawer.component.scss'],
  imports: [CommonModule, MatIconModule]
})
export class NgmDrawerComponent {
  readonly opened = model<boolean>()
  // readonly mode = input<'over' | 'push' | 'side'>('side')

  @HostBinding('class.opened')
  get _opened() {
    return this.opened()
  }

  // @HostBinding('class.over')
  // get _over() {
  //   return this.mode() === 'over'
  // }

  toggle() {
    this.opened.update((opened) => !opened)
  }
}
