/* Generated By:JavaCC: Do not edit this line. MdxParserImpl.java */
package mondrian.parser;

import java.util.*;
import java.io.StringReader;
import java.math.BigDecimal;

import mondrian.olap.*;
import mondrian.mdx.*;
import mondrian.parser.*;
import mondrian.resource.MondrianResource;
import mondrian.server.Statement;

/**
 * MDX parser, generated from MdxParser.jj.
 *
 * <p>The public wrapper for this parser is {@link JavaccParserValidatorImpl}.
 *
 * @author jhyde
 * @since Dec 14, 2010
 */
@SuppressWarnings({
    "ConstantIfStatement",
    "UnnecessarySemicolon",
    "UnnecessaryLabelOnBreakStatement",
    "RedundantIfStatement"
})
public class MdxParserImpl implements MdxParserImplConstants {
    private MdxParserValidator.QueryPartFactory factory;
    private Statement statement;
    private FunTable funTable;
    private boolean strictValidation;

    public MdxParserImpl(
        MdxParserValidator.QueryPartFactory factory,
        Statement statement,
        String queryString,
        boolean debug,
        FunTable funTable,
        boolean strictValidation)
    {
        this(new StringReader(term(queryString)));
        this.factory = factory;
        this.statement = statement;
        this.funTable = funTable;
        this.strictValidation = strictValidation;
    }

    private static String term(String s) {
        return s.endsWith("\u005cn") ? s : (s + "\u005cn");
    }

    public void setTabSize(int tabSize) {
        jj_input_stream.setTabSize(tabSize);
    }

    Exp recursivelyParseExp(String s) throws ParseException {
        MdxParserImpl parser =
            new MdxParserImpl(
                factory,
                statement,
                s,
                false,
                funTable,
                strictValidation);
        return parser.expression();
    }

    static Id[] toIdArray(List<Id> idList) {
        if (idList == null || idList.size() == 0) {
            return EmptyIdArray;
        } else {
            return idList.toArray(new Id[idList.size()]);
        }
    }

    static Exp[] toExpArray(List<Exp> expList) {
        if (expList == null || expList.size() == 0) {
            return EmptyExpArray;
        } else {
            return expList.toArray(new Exp[expList.size()]);
        }
    }

    static Formula[] toFormulaArray(List<Formula> formulaList) {
        if (formulaList == null || formulaList.size() == 0) {
            return EmptyFormulaArray;
        } else {
            return formulaList.toArray(new Formula[formulaList.size()]);
        }
    }

    static MemberProperty[] toMemberPropertyArray(List<MemberProperty> mpList) {
        if (mpList == null || mpList.size() == 0) {
            return EmptyMemberPropertyArray;
        } else {
            return mpList.toArray(new MemberProperty[mpList.size()]);
        }
    }

    static QueryPart[] toQueryPartArray(List<QueryPart> qpList) {
        if (qpList == null || qpList.size() == 0) {
            return EmptyQueryPartArray;
        } else {
            return qpList.toArray(new QueryPart[qpList.size()]);
        }
    }

    static QueryAxis[] toQueryAxisArray(List<QueryAxis> qpList) {
        if (qpList == null || qpList.size() == 0) {
            return EmptyQueryAxisArray;
        } else {
            return qpList.toArray(new QueryAxis[qpList.size()]);
        }
    }

    private static final MemberProperty[] EmptyMemberPropertyArray =
        new MemberProperty[0];
    private static final Exp[] EmptyExpArray = new Exp[0];
    private static final Formula[] EmptyFormulaArray = new Formula[0];
    private static final Id[] EmptyIdArray = new Id[0];
    private static final QueryPart[] EmptyQueryPartArray = new QueryPart[0];
    private static final QueryAxis[] EmptyQueryAxisArray = new QueryAxis[0];

    private static final String DQ = '"' + "";
    private static final String DQDQ = DQ + DQ;

    private static String stripQuotes(
        String s, String prefix, String suffix, String quoted)
    {
        assert s.startsWith(prefix) && s.endsWith(suffix);
        s = s.substring(prefix.length(), s.length() - suffix.length());
        s = Util.replace(s, quoted, suffix);
        return s;
    }

    private Exp createCall(
        Exp left,
        Id.Segment segment,
        List<Exp> argList)
    {
        final String name = segment instanceof Id.NameSegment
            ? ((Id.NameSegment) segment).name
            : null;
        if (argList != null) {
            if (left != null) {
                // Method syntax: "x.foo(arg1, arg2)" or "x.foo()"
                argList.add(0, left);
                return new UnresolvedFunCall(
                    name, Syntax.Method, toExpArray(argList));
            } else {
                // Function syntax: "foo(arg1, arg2)" or "foo()"
                return new UnresolvedFunCall(
                    name, Syntax.Function, toExpArray(argList));
            }
        } else {
            // Member syntax: "foo.bar"
            // or property syntax: "foo.RESERVED_WORD"
            Syntax syntax;
            boolean call = false;
            switch (segment.quoting) {
            case UNQUOTED:
                syntax = Syntax.Property;
                call = funTable.isProperty(name);
                break;
            case QUOTED:
                syntax = Syntax.QuotedProperty;
                break;
            default:
                syntax = Syntax.AmpersandQuotedProperty;
                break;
            }
            if (left instanceof Id && !call) {
                return ((Id) left).append(segment);
            } else if (left == null) {
                return new Id(segment);
            } else {
                return new UnresolvedFunCall(
                    name, syntax, new Exp[] {left});
            }
        }
    }

// ----------------------------------------------------------------------------
// Entry points
  final public QueryPart statementEof() throws ParseException {
    QueryPart qp;
    qp = statement();
    jj_consume_token(0);
        {if (true) return qp;}
    throw new Error("Missing return statement in function");
  }

  final public Exp expressionEof() throws ParseException {
    Exp e;
    e = expression();
    jj_consume_token(0);
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// Elements
//
//
// <identifier> ::= <regularIdentifier> | <delimitedIdentifier>
  final public Id.Segment identifier() throws ParseException {
    Id.Segment segment;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIMENSION:
    case PROPERTIES:
    case ID:
    case QUOTED_ID:
      segment = nameSegment();
      break;
    case AMP_QUOTED_ID:
    case AMP_UNQUOTED_ID:
      segment = keyIdentifier();
      break;
    default:
      jj_la1[0] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return segment;}
    throw new Error("Missing return statement in function");
  }

  final public Id.NameSegment nameSegment() throws ParseException {
    String id;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIMENSION:
    case PROPERTIES:
      id = keyword();
        // Allow a non-reserved keyword to be converted back into an identifier
        // if it is not in a context where it is meaningful.
        {if (true) return new Id.NameSegment(id, Id.Quoting.UNQUOTED);}
      break;
    case ID:
      jj_consume_token(ID);
        {if (true) return new Id.NameSegment(token.image, Id.Quoting.UNQUOTED);}
      break;
    case QUOTED_ID:
      jj_consume_token(QUOTED_ID);
        {if (true) return new Id.NameSegment(
            stripQuotes(token.image, "[", "]", "]]"),
            Id.Quoting.QUOTED);}
      break;
    default:
      jj_la1[1] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// for example '&foo&[1]&bar' in '[x].&foo&[1]&bar.[y]'
  final public Id.KeySegment keyIdentifier() throws ParseException {
    List<Id.NameSegment> list = new ArrayList<Id.NameSegment>();
    Id.NameSegment key;
    label_1:
    while (true) {
      key = ampId();
            list.add(key);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AMP_QUOTED_ID:
      case AMP_UNQUOTED_ID:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_1;
      }
    }
        {if (true) return new Id.KeySegment(list);}
    throw new Error("Missing return statement in function");
  }

  final public Id.NameSegment ampId() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AMP_QUOTED_ID:
      jj_consume_token(AMP_QUOTED_ID);
        {if (true) return new Id.NameSegment(
            stripQuotes(token.image, "&[", "]", "]]"),
            Id.Quoting.QUOTED);}
      break;
    case AMP_UNQUOTED_ID:
      jj_consume_token(AMP_UNQUOTED_ID);
        {if (true) return new Id.NameSegment(
            token.image.substring(1),
            Id.Quoting.UNQUOTED);}
      break;
    default:
      jj_la1[3] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

// a keyword (unlike a reserved word) can be converted back into an
// identifier in some contexts
  final public String keyword() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIMENSION:
      jj_consume_token(DIMENSION);
        {if (true) return "Dimension";}
      break;
    case PROPERTIES:
      jj_consume_token(PROPERTIES);
        {if (true) return "Properties";}
      break;
    default:
      jj_la1[4] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Id compoundId() throws ParseException {
    Id.Segment i;
    List<Id.Segment> list = new ArrayList<Id.Segment>();
    i = identifier();
        list.add(i);
    label_2:
    while (true) {
      if (jj_2_1(2147483647)) {
        ;
      } else {
        break label_2;
      }
      jj_consume_token(DOT);
      i = identifier();
            list.add(i);
    }
        {if (true) return new Id(list);}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// Expressions
  final public Exp unaliasedExpression() throws ParseException {
    Exp x, y;
    x = term5();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
      case XOR:
      case COLON:
        ;
        break;
      default:
        jj_la1[5] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        jj_consume_token(OR);
        y = term5();
            x = new UnresolvedFunCall("OR", Syntax.Infix, new Exp[] {x, y});
        break;
      case XOR:
        jj_consume_token(XOR);
        y = term5();
            x = new UnresolvedFunCall("XOR", Syntax.Infix, new Exp[] {x, y});
        break;
      case COLON:
        jj_consume_token(COLON);
        y = term5();
            x = new UnresolvedFunCall(":", Syntax.Infix, new Exp[] {x, y});
        break;
      default:
        jj_la1[6] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public Exp term5() throws ParseException {
    Exp x, y;
    x = term4();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[7] = jj_gen;
        break label_4;
      }
      jj_consume_token(AND);
      y = term4();
            x = new UnresolvedFunCall("AND", Syntax.Infix, new Exp[] {x, y});
    }
        {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public Exp term4() throws ParseException {
    Exp x;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
    case CAST:
    case DIMENSION:
    case NULL:
    case PROPERTIES:
    case EXISTING:
    case LBRACE:
    case LPAREN:
    case MINUS:
    case PLUS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case SINGLE_QUOTED_STRING:
    case DOUBLE_QUOTED_STRING:
    case ID:
    case QUOTED_ID:
      x = term3();
        {if (true) return x;}
      break;
    case NOT:
      jj_consume_token(NOT);
      x = term4();
        {if (true) return new UnresolvedFunCall("NOT", Syntax.Prefix, new Exp[] {x});}
      break;
    default:
      jj_la1[8] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Exp term3() throws ParseException {
    Exp x, y;
    Token op;
    x = term2();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case IN:
      case IS:
      case MATCHES:
      case NOT:
      case EQ:
      case GE:
      case GT:
      case LE:
      case LT:
      case NE:
        ;
        break;
      default:
        jj_la1[9] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ:
      case GE:
      case GT:
      case LE:
      case LT:
      case NE:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ:
          jj_consume_token(EQ);
                   op = token;
          break;
        case NE:
          jj_consume_token(NE);
                    op = token;
          break;
        case LT:
          jj_consume_token(LT);
                    op = token;
          break;
        case GT:
          jj_consume_token(GT);
                    op = token;
          break;
        case LE:
          jj_consume_token(LE);
                    op = token;
          break;
        case GE:
          jj_consume_token(GE);
                    op = token;
          break;
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        y = term2();
            x = new UnresolvedFunCall(op.image, Syntax.Infix, new Exp[] {x, y});
        break;
      default:
        jj_la1[11] = jj_gen;
        if (jj_2_2(2)) {
          jj_consume_token(IS);
          jj_consume_token(NULL);
            x = new UnresolvedFunCall("IS NULL", Syntax.Postfix, new Exp[] {x});
        } else if (jj_2_3(2)) {
          jj_consume_token(IS);
          y = term2();
            x = new UnresolvedFunCall("IS", Syntax.Infix, new Exp[] {x, y});
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case IS:
            jj_consume_token(IS);
            jj_consume_token(EMPTY);
            x = new UnresolvedFunCall(
                "IS EMPTY", Syntax.Postfix, new Exp[] {x});
            break;
          case MATCHES:
            jj_consume_token(MATCHES);
            y = term2();
            x = new UnresolvedFunCall("MATCHES", Syntax.Infix, new Exp[] {x, y});
            break;
          default:
            jj_la1[12] = jj_gen;
            if (jj_2_4(2)) {
              jj_consume_token(NOT);
              jj_consume_token(MATCHES);
              y = term2();
            x = new UnresolvedFunCall(
                "NOT", Syntax.Prefix, new Exp[] {
                    new UnresolvedFunCall(
                        "MATCHES", Syntax.Infix, new Exp[] {x, y})});
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case IN:
                jj_consume_token(IN);
                y = term2();
            x = new UnresolvedFunCall("IN", Syntax.Infix, new Exp[] {x, y});
                break;
              case NOT:
                jj_consume_token(NOT);
                jj_consume_token(IN);
                y = term2();
            x = new UnresolvedFunCall(
                "NOT", Syntax.Prefix, new Exp[] {
                    new UnresolvedFunCall(
                        "IN", Syntax.Infix, new Exp[] {x, y})});
                break;
              default:
                jj_la1[13] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    }
        {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public Exp term2() throws ParseException {
    Exp x, y;
    x = term();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONCAT:
      case MINUS:
      case PLUS:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        y = term();
            x = new UnresolvedFunCall("+", Syntax.Infix, new Exp[] {x, y});
        break;
      case MINUS:
        jj_consume_token(MINUS);
        y = term();
            x = new UnresolvedFunCall("-", Syntax.Infix, new Exp[] {x, y});
        break;
      case CONCAT:
        jj_consume_token(CONCAT);
        y = term();
            x = new UnresolvedFunCall("||", Syntax.Infix, new Exp[] {x, y});
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public Exp term() throws ParseException {
    Exp x, y;
    x = factor();
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
      case SOLIDUS:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_7;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASTERISK:
        jj_consume_token(ASTERISK);
        y = factor();
            x = new UnresolvedFunCall("*", Syntax.Infix, new Exp[] {x, y});
        break;
      case SOLIDUS:
        jj_consume_token(SOLIDUS);
        y = factor();
            x = new UnresolvedFunCall("/", Syntax.Infix, new Exp[] {x, y});
        break;
      default:
        jj_la1[17] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
        {if (true) return x;}
    throw new Error("Missing return statement in function");
  }

  final public Exp factor() throws ParseException {
    Exp p;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
    case CAST:
    case DIMENSION:
    case NULL:
    case PROPERTIES:
    case LBRACE:
    case LPAREN:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case SINGLE_QUOTED_STRING:
    case DOUBLE_QUOTED_STRING:
    case ID:
    case QUOTED_ID:
      p = primary();
        {if (true) return p;}
      break;
    case PLUS:
      jj_consume_token(PLUS);
      p = primary();
        {if (true) return p;}
      break;
    case MINUS:
      jj_consume_token(MINUS);
      p = primary();
        {if (true) return new UnresolvedFunCall("-", Syntax.Prefix, new Exp[] {p});}
      break;
    case EXISTING:
      jj_consume_token(EXISTING);
      p = primary();
        {if (true) return new UnresolvedFunCall("Existing", Syntax.Prefix, new Exp[] {p});}
      break;
    default:
      jj_la1[18] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Exp primary() throws ParseException {
    Exp e;
    e = atom();
    label_8:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
        ;
        break;
      default:
        jj_la1[19] = jj_gen;
        break label_8;
      }
      jj_consume_token(DOT);
      e = segmentOrFuncall(e);
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public Exp segmentOrFuncall(Exp left) throws ParseException {
    Id.Segment segment;
    List<Exp> argList = null;
    segment = identifier();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPAREN:
      jj_consume_token(LPAREN);
      if (jj_2_5(2147483647)) {
                argList = Collections.emptyList();
      } else {
        argList = expOrEmptyList();
      }
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[20] = jj_gen;
      ;
    }
        {if (true) return createCall(left, segment, argList);}
    throw new Error("Missing return statement in function");
  }

  final public Literal numericLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DECIMAL_NUMERIC_LITERAL:
      jj_consume_token(DECIMAL_NUMERIC_LITERAL);
        {if (true) return Literal.create(new BigDecimal(token.image));}
      break;
    case UNSIGNED_INTEGER_LITERAL:
      jj_consume_token(UNSIGNED_INTEGER_LITERAL);
        {if (true) return Literal.create(new BigDecimal(token.image));}
      break;
    case APPROX_NUMERIC_LITERAL:
      jj_consume_token(APPROX_NUMERIC_LITERAL);
        {if (true) return Literal.create(new BigDecimal(token.image));}
      break;
    default:
      jj_la1[21] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Exp atom() throws ParseException {
    Exp e;
    Id.NameSegment segment;
    List<Exp> lis;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SINGLE_QUOTED_STRING:
      jj_consume_token(SINGLE_QUOTED_STRING);
        {if (true) return Literal.createString(stripQuotes(token.image, "'", "'", "''"));}
      break;
    case DOUBLE_QUOTED_STRING:
      jj_consume_token(DOUBLE_QUOTED_STRING);
        {if (true) return Literal.createString(stripQuotes(token.image, DQ, DQ, DQDQ));}
      break;
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      e = numericLiteral();
        {if (true) return e;}
      break;
    case NULL:
      jj_consume_token(NULL);
        {if (true) return Literal.nullValue;}
      break;
    case CAST:
      jj_consume_token(CAST);
      jj_consume_token(LPAREN);
      e = unaliasedExpression();
      jj_consume_token(AS);
      segment = nameSegment();
      jj_consume_token(RPAREN);
        {if (true) return new UnresolvedFunCall(
            "CAST", Syntax.Cast, new Exp[] {
                e,
                Literal.createSymbol(segment.name)});}
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      lis = expList();
      jj_consume_token(RPAREN);
        // Whereas ([Sales],[Time]) and () are tuples, ([Sales]) and (5)
        // are just expressions.
        {if (true) return new UnresolvedFunCall(
            "()", Syntax.Parentheses, toExpArray(lis));}
      break;
    case LBRACE:
      jj_consume_token(LBRACE);
      if (jj_2_6(2147483647)) {
            lis = Collections.emptyList();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case CASE:
        case CAST:
        case DIMENSION:
        case NOT:
        case NULL:
        case PROPERTIES:
        case EXISTING:
        case LBRACE:
        case LPAREN:
        case MINUS:
        case PLUS:
        case UNSIGNED_INTEGER_LITERAL:
        case APPROX_NUMERIC_LITERAL:
        case DECIMAL_NUMERIC_LITERAL:
        case SINGLE_QUOTED_STRING:
        case DOUBLE_QUOTED_STRING:
        case ID:
        case QUOTED_ID:
          lis = expList();
          break;
        default:
          jj_la1[22] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      jj_consume_token(RBRACE);
        {if (true) return new UnresolvedFunCall(
            "{}", Syntax.Braces, toExpArray(lis));}
      break;
    case CASE:
      e = caseExpression();
        {if (true) return e;}
      break;
    case DIMENSION:
    case PROPERTIES:
    case ID:
    case QUOTED_ID:
      // Function call "foo(a, b)" or "whiz!bang!foo(a, b)".
          // Properties "x.PROP" and methods "exp.meth(a)" are in primary().
          segment = nameSegment();
      label_9:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case BANG:
          ;
          break;
        default:
          jj_la1[23] = jj_gen;
          break label_9;
        }
        jj_consume_token(BANG);
        segment = nameSegment();

      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPAREN:
        jj_consume_token(LPAREN);
        if (jj_2_7(2147483647)) {
                lis = Collections.emptyList();
        } else {
          lis = expOrEmptyList();
        }
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[24] = jj_gen;
                      lis = null;
      }
        {if (true) return createCall(null, segment, lis);}
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Exp caseExpression() throws ParseException {
    Exp e, e2;
    List<Exp> list = new ArrayList<Exp>();
    boolean match = false;
    jj_consume_token(CASE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
    case CAST:
    case DIMENSION:
    case NOT:
    case NULL:
    case PROPERTIES:
    case EXISTING:
    case LBRACE:
    case LPAREN:
    case MINUS:
    case PLUS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case SINGLE_QUOTED_STRING:
    case DOUBLE_QUOTED_STRING:
    case ID:
    case QUOTED_ID:
      e = expression();
            match = true;
            list.add(e);
      break;
    default:
      jj_la1[26] = jj_gen;
      ;
    }
    label_10:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case WHEN:
        ;
        break;
      default:
        jj_la1[27] = jj_gen;
        break label_10;
      }
      jj_consume_token(WHEN);
      e = expression();
      jj_consume_token(THEN);
      e2 = expression();
            list.add(e);
            list.add(e2);
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ELSE:
      jj_consume_token(ELSE);
      e = expression();
            list.add(e);
      break;
    default:
      jj_la1[28] = jj_gen;
      ;
    }
    jj_consume_token(END);
        if (match) {
            {if (true) return new UnresolvedFunCall(
                "_CaseMatch", Syntax.Case, toExpArray(list));}
        } else {
            {if (true) return new UnresolvedFunCall(
                "_CaseTest", Syntax.Case, toExpArray(list));}
        }
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// Member Value Expression
  final public Exp expression() throws ParseException {
    Exp e;
    Id.Segment i;
    e = unaliasedExpression();
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AS:
        ;
        break;
      default:
        jj_la1[29] = jj_gen;
        break label_11;
      }
      jj_consume_token(AS);
      i = identifier();
            Id id = new Id(i);
            e = new UnresolvedFunCall("AS", Syntax.Infix, new Exp[] {e, id});
    }
        {if (true) return e;}
    throw new Error("Missing return statement in function");
  }

  final public Exp expressionOrEmpty() throws ParseException {
    Exp e;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
    case CAST:
    case DIMENSION:
    case NOT:
    case NULL:
    case PROPERTIES:
    case EXISTING:
    case LBRACE:
    case LPAREN:
    case MINUS:
    case PLUS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case SINGLE_QUOTED_STRING:
    case DOUBLE_QUOTED_STRING:
    case ID:
    case QUOTED_ID:
      e = expression();
        {if (true) return e;}
      break;
    default:
      jj_la1[30] = jj_gen;
        {if (true) return new UnresolvedFunCall("", Syntax.Empty, new Exp[] {});}
    }
    throw new Error("Missing return statement in function");
  }

// Comma-separated list of expressions, some of which may be empty. Used
// for functions.
  final public List<Exp> expOrEmptyList() throws ParseException {
    Exp e;
    List<Exp> list = new LinkedList<Exp>();
    e = expressionOrEmpty();
        list.add(e);
    label_12:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[31] = jj_gen;
        break label_12;
      }
      jj_consume_token(COMMA);
      e = expressionOrEmpty();
            list.add(e);
    }
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

// List of expressions, none of which may be empty.
  final public List<Exp> expList() throws ParseException {
    Exp e;
    List<Exp> list = new LinkedList<Exp>();
    e = expression();
        list.add(e);
    label_13:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[32] = jj_gen;
        break label_13;
      }
      jj_consume_token(COMMA);
      e = expression();
            list.add(e);
    }
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

// ----------------------------------------------------------------------------
// MDX Statement
//
// <statement> ::= <selectStatement>
//                   | <drillthroughStatement>
//                   | <explainStatement>
//
// <selectStatement> ::= [WITH <formulaSpecification>]
//                         SELECT [<axisSpecification>
//                                [, <axisSpecification>...]]
//                         FROM [<cubeSpecification>]
//                         [WHERE <slicerSpecification>]
//                         [<cellProps>]
//
// <drillthroughStatment> ::=
//     DRILLTHROUGH
//     [ MAXROWS <count> ]
//     [ FIRSTROWSET <count> ]
//     <selectStatement>
//     [ RETURN <memberOrAttribute> [, <memberOrAttribute>...] ]
//
// <explainStatement> ::=
//     EXPLAIN PLAN FOR ( <selectStatement> | <drillthroughStatement> )
//
  final public QueryPart statement() throws ParseException {
    QueryPart qp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case WITH:
      qp = selectStatement();
      break;
    case DRILLTHROUGH:
      qp = drillthroughStatement();
      break;
    case EXPLAIN:
      qp = explainStatement();
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return qp;}
    throw new Error("Missing return statement in function");
  }

  final public QueryPart selectOrDrillthroughStatement() throws ParseException {
    QueryPart qp;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case WITH:
      qp = selectStatement();
        {if (true) return qp;}
      break;
    case DRILLTHROUGH:
      qp = drillthroughStatement();
        {if (true) return qp;}
      break;
    default:
      jj_la1[34] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public Query selectStatement() throws ParseException {
     Formula e;
     List<Formula> f = new ArrayList<Formula>();
     Exp w = null;
     QueryAxis i;
     List<QueryAxis> a = new ArrayList<QueryAxis>();
     Id c, p;
     List<QueryPart> cellPropList = new ArrayList<QueryPart>();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WITH:
      jj_consume_token(WITH);
      label_14:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MEMBER:
          e = memberSpecification();
               f.add(e);
          break;
        case SET:
          e = setSpecification();
               f.add(e);
          break;
        default:
          jj_la1[35] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MEMBER:
        case SET:
          ;
          break;
        default:
          jj_la1[36] = jj_gen;
          break label_14;
        }
      }
      break;
    default:
      jj_la1[37] = jj_gen;
      ;
    }
    jj_consume_token(SELECT);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CASE:
    case CAST:
    case DIMENSION:
    case NON:
    case NOT:
    case NULL:
    case PROPERTIES:
    case EXISTING:
    case LBRACE:
    case LPAREN:
    case MINUS:
    case PLUS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
    case SINGLE_QUOTED_STRING:
    case DOUBLE_QUOTED_STRING:
    case ID:
    case QUOTED_ID:
      i = axisSpecification();
            a.add(i);
      label_15:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[38] = jj_gen;
          break label_15;
        }
        jj_consume_token(COMMA);
        i = axisSpecification();
                a.add(i);
      }
      break;
    default:
      jj_la1[39] = jj_gen;
      ;
    }
    jj_consume_token(FROM);
    c = compoundId();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHERE:
      jj_consume_token(WHERE);
      w = expression();
      break;
    default:
      jj_la1[40] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CELL:
    case PROPERTIES:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CELL:
        jj_consume_token(CELL);
        break;
      default:
        jj_la1[41] = jj_gen;
        ;
      }
      jj_consume_token(PROPERTIES);
      p = compoundId();
            cellPropList.add(new CellProperty(p.getSegments()));
      label_16:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[42] = jj_gen;
          break label_16;
        }
        jj_consume_token(COMMA);
        p = compoundId();
                cellPropList.add(new CellProperty(p.getSegments()));
      }
      break;
    default:
      jj_la1[43] = jj_gen;
      ;
    }
        // We want 'Sales', not '[Sales]', and can't handle 'Schema.Sales'
        // yet.
        String cubeName = ((Id.NameSegment) c.getElement(0)).name;
        {if (true) return factory.makeQuery(
            statement,
            toFormulaArray(f),
            toQueryAxisArray(a),
            cubeName,
            w,
            toQueryPartArray(cellPropList),
            strictValidation);}
    throw new Error("Missing return statement in function");
  }

//
// <memberSpecification> ::= MEMBER <member_name> AS <valueExpression>
//                                 [, <solveOrderSpecification>]
//                                 [, <memberPropertyDefinition>...]
  final public Formula memberSpecification() throws ParseException {
    Id m;
    Exp e;
    List<MemberProperty> l = new ArrayList<MemberProperty>();
    MemberProperty mp;
    jj_consume_token(MEMBER);
    m = compoundId();
    jj_consume_token(AS);
    e = formulaExpression();
    label_17:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[44] = jj_gen;
        break label_17;
      }
      jj_consume_token(COMMA);
      mp = memberPropertyDefinition();
            l.add(mp);
    }
        {if (true) return new Formula(m, e, toMemberPropertyArray(l));}
    throw new Error("Missing return statement in function");
  }

  final public Exp formulaExpression() throws ParseException {
    Exp e;
    if (jj_2_8(2147483647)) {
      jj_consume_token(SINGLE_QUOTED_STRING);
        // Support archaic syntax "WITH MEMBER m AS ' <expr> ' ...";
        // "WITH MEMBER m AS <expr>" is now preferred.
        {if (true) return recursivelyParseExp(stripQuotes(token.image, "'", "'", "''"));}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CASE:
      case CAST:
      case DIMENSION:
      case NOT:
      case NULL:
      case PROPERTIES:
      case EXISTING:
      case LBRACE:
      case LPAREN:
      case MINUS:
      case PLUS:
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
      case SINGLE_QUOTED_STRING:
      case DOUBLE_QUOTED_STRING:
      case ID:
      case QUOTED_ID:
        e = unaliasedExpression();
        {if (true) return e;}
        break;
      default:
        jj_la1[45] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public MemberProperty memberPropertyDefinition() throws ParseException {
    Id.NameSegment id;
    Exp e;
    id = nameSegment();
    jj_consume_token(EQ);
    e = expression();
        {if (true) return new MemberProperty(id.name, e);}
    throw new Error("Missing return statement in function");
  }

  final public Formula setSpecification() throws ParseException {
    Id n;
    Exp e;
    jj_consume_token(SET);
    n = compoundId();
    jj_consume_token(AS);
    e = formulaExpression();
        {if (true) return new Formula(n, e);}
    throw new Error("Missing return statement in function");
  }

// <axisSpecification> ::= [NON EMPTY] <set> [<dimProps>] ON <axis_name>
  final public QueryAxis axisSpecification() throws ParseException {
    boolean nonEmpty = false;
    Exp e;
    List<Id> dp = new ArrayList<Id>();
    AxisOrdinal axis;
    Literal n;
    Id p;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NON:
      jj_consume_token(NON);
      jj_consume_token(EMPTY);
            nonEmpty = true;
      break;
    default:
      jj_la1[46] = jj_gen;
      ;
    }
    e = expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DIMENSION:
    case PROPERTIES:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DIMENSION:
        jj_consume_token(DIMENSION);
        break;
      default:
        jj_la1[47] = jj_gen;
        ;
      }
      jj_consume_token(PROPERTIES);
      p = compoundId();
            dp.add(p);
      label_18:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[48] = jj_gen;
          break label_18;
        }
        jj_consume_token(COMMA);
        p = compoundId();
                dp.add(p);
      }
      break;
    default:
      jj_la1[49] = jj_gen;
      ;
    }
    jj_consume_token(ON);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case COLUMNS:
      jj_consume_token(COLUMNS);
            axis = AxisOrdinal.StandardAxisOrdinal.COLUMNS;
      break;
    case ROWS:
      jj_consume_token(ROWS);
            axis= AxisOrdinal.StandardAxisOrdinal.ROWS;
      break;
    case PAGES:
      jj_consume_token(PAGES);
            axis = AxisOrdinal.StandardAxisOrdinal.PAGES;
      break;
    case SECTIONS:
      jj_consume_token(SECTIONS);
            axis = AxisOrdinal.StandardAxisOrdinal.SECTIONS;
      break;
    case CHAPTERS:
      jj_consume_token(CHAPTERS);
            axis = AxisOrdinal.StandardAxisOrdinal.CHAPTERS;
      break;
    case AXIS:
    case UNSIGNED_INTEGER_LITERAL:
    case APPROX_NUMERIC_LITERAL:
    case DECIMAL_NUMERIC_LITERAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNSIGNED_INTEGER_LITERAL:
      case APPROX_NUMERIC_LITERAL:
      case DECIMAL_NUMERIC_LITERAL:
        n = numericLiteral();
        break;
      case AXIS:
        jj_consume_token(AXIS);
        jj_consume_token(LPAREN);
        n = numericLiteral();
        jj_consume_token(RPAREN);
        break;
      default:
        jj_la1[50] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            // AxisOrdinal values go from -2 to 4 for standard axis, but higher
            // ordinals are allowed. The negative values represent special
            // cases, so are ignored.
            Number number = (Number) n.getValue();
            if (number.doubleValue() < 0
                || number.doubleValue() != number.intValue())
            {
                {if (true) throw MondrianResource.instance().InvalidAxis.ex(
                    number.doubleValue());}
            }

            axis = AxisOrdinal.StandardAxisOrdinal.forLogicalOrdinal(
                number.intValue());
      break;
    default:
      jj_la1[51] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return new QueryAxis(
            nonEmpty, e, axis,
            QueryAxis.SubtotalVisibility.Undefined,
            toIdArray(dp));}
    throw new Error("Missing return statement in function");
  }

  final public QueryPart drillthroughStatement() throws ParseException {
    int m = 0, f = 0;
    List<Exp> rl = null;
    Query s;
    jj_consume_token(DRILLTHROUGH);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MAXROWS:
      jj_consume_token(MAXROWS);
      jj_consume_token(UNSIGNED_INTEGER_LITERAL);
            m = Integer.valueOf(token.image);
      break;
    default:
      jj_la1[52] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case FIRSTROWSET:
      jj_consume_token(FIRSTROWSET);
      jj_consume_token(UNSIGNED_INTEGER_LITERAL);
            f = Integer.valueOf(token.image);
      break;
    default:
      jj_la1[53] = jj_gen;
      ;
    }
    s = selectStatement();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case RETURN:
      jj_consume_token(RETURN);
      rl = returnItemList();
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
        {if (true) return factory.makeDrillThrough(s, m, f, rl);}
    throw new Error("Missing return statement in function");
  }

  final public List<Exp> returnItemList() throws ParseException {
    List<Exp> list = new ArrayList<Exp>();
    Id i;
    i = returnItem();
        list.add(i);
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[55] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      i = returnItem();
            list.add(i);
    }
        {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public Id returnItem() throws ParseException {
    Id i;
    // TODO: allow NAME(id) etc.
        i = compoundId();
        {if (true) return i;}
    throw new Error("Missing return statement in function");
  }

  final public QueryPart explainStatement() throws ParseException {
    QueryPart qp;
    jj_consume_token(EXPLAIN);
    jj_consume_token(PLAN);
    jj_consume_token(FOR);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SELECT:
    case WITH:
      qp = selectStatement();
      break;
    case DRILLTHROUGH:
      qp = drillthroughStatement();
      break;
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
        {if (true) return factory.makeExplain(qp);}
    throw new Error("Missing return statement in function");
  }

  private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_3(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(2, xla); }
  }

  private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_4(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(3, xla); }
  }

  private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_5(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(4, xla); }
  }

  private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_6(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(5, xla); }
  }

  private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_7(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(6, xla); }
  }

  private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_8(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(7, xla); }
  }

  private boolean jj_3R_46() {
    if (jj_scan_token(QUOTED_ID)) return true;
    return false;
  }

  private boolean jj_3R_45() {
    if (jj_scan_token(ID)) return true;
    return false;
  }

  private boolean jj_3_8() {
    if (jj_scan_token(SINGLE_QUOTED_STRING)) return true;
    return false;
  }

  private boolean jj_3R_40() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_44()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_44() {
    if (jj_3R_47()) return true;
    return false;
  }

  private boolean jj_3_1() {
    if (jj_scan_token(DOT)) return true;
    return false;
  }

  private boolean jj_3_4() {
    if (jj_scan_token(NOT)) return true;
    if (jj_scan_token(MATCHES)) return true;
    return false;
  }

  private boolean jj_3R_37() {
    if (jj_3R_40()) return true;
    return false;
  }

  private boolean jj_3_6() {
    if (jj_scan_token(RBRACE)) return true;
    return false;
  }

  private boolean jj_3_3() {
    if (jj_scan_token(IS)) return true;
    if (jj_3R_20()) return true;
    return false;
  }

  private boolean jj_3R_27() {
    if (jj_3R_28()) return true;
    return false;
  }

  private boolean jj_3R_36() {
    if (jj_3R_39()) return true;
    return false;
  }

  private boolean jj_3_2() {
    if (jj_scan_token(IS)) return true;
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_26() {
    if (jj_scan_token(EXISTING)) return true;
    return false;
  }

  private boolean jj_3R_25() {
    if (jj_scan_token(MINUS)) return true;
    return false;
  }

  private boolean jj_3R_35() {
    if (jj_scan_token(LBRACE)) return true;
    return false;
  }

  private boolean jj_3R_24() {
    if (jj_scan_token(PLUS)) return true;
    return false;
  }

  private boolean jj_3R_49() {
    if (jj_scan_token(PROPERTIES)) return true;
    return false;
  }

  private boolean jj_3R_23() {
    if (jj_3R_27()) return true;
    return false;
  }

  private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_23()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) {
    jj_scanpos = xsp;
    if (jj_3R_25()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    }
    }
    }
    return false;
  }

  private boolean jj_3R_48() {
    if (jj_scan_token(DIMENSION)) return true;
    return false;
  }

  private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_48()) {
    jj_scanpos = xsp;
    if (jj_3R_49()) return true;
    }
    return false;
  }

  private boolean jj_3R_34() {
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  private boolean jj_3R_33() {
    if (jj_scan_token(CAST)) return true;
    return false;
  }

  private boolean jj_3R_32() {
    if (jj_scan_token(NULL)) return true;
    return false;
  }

  private boolean jj_3R_31() {
    if (jj_3R_38()) return true;
    return false;
  }

  private boolean jj_3R_21() {
    if (jj_3R_22()) return true;
    return false;
  }

  private boolean jj_3R_30() {
    if (jj_scan_token(DOUBLE_QUOTED_STRING)) return true;
    return false;
  }

  private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_29()) {
    jj_scanpos = xsp;
    if (jj_3R_30()) {
    jj_scanpos = xsp;
    if (jj_3R_31()) {
    jj_scanpos = xsp;
    if (jj_3R_32()) {
    jj_scanpos = xsp;
    if (jj_3R_33()) {
    jj_scanpos = xsp;
    if (jj_3R_34()) {
    jj_scanpos = xsp;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) {
    jj_scanpos = xsp;
    if (jj_3R_37()) return true;
    }
    }
    }
    }
    }
    }
    }
    }
    return false;
  }

  private boolean jj_3R_29() {
    if (jj_scan_token(SINGLE_QUOTED_STRING)) return true;
    return false;
  }

  private boolean jj_3R_43() {
    if (jj_scan_token(APPROX_NUMERIC_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_42() {
    if (jj_scan_token(UNSIGNED_INTEGER_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_39() {
    if (jj_scan_token(CASE)) return true;
    return false;
  }

  private boolean jj_3_5() {
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  private boolean jj_3R_38() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) {
    jj_scanpos = xsp;
    if (jj_3R_43()) return true;
    }
    }
    return false;
  }

  private boolean jj_3R_41() {
    if (jj_scan_token(DECIMAL_NUMERIC_LITERAL)) return true;
    return false;
  }

  private boolean jj_3R_20() {
    if (jj_3R_21()) return true;
    return false;
  }

  private boolean jj_3_7() {
    if (jj_scan_token(RPAREN)) return true;
    return false;
  }

  /** Generated Token Manager. */
  public MdxParserImplTokenManager token_source;
  SimpleCharStream jj_input_stream;
  /** Current token. */
  public Token token;
  /** Next token. */
  public Token jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  private int jj_gen;
  final private int[] jj_la1 = new int[57];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static {
      jj_la1_init_0();
      jj_la1_init_1();
      jj_la1_init_2();
   }
   private static void jj_la1_init_0() {
      jj_la1_0 = new int[] {0x40000200,0x40000200,0x0,0x0,0x40000200,0x8000000,0x8000000,0x2,0x43000230,0x11c0000,0x0,0x0,0x180000,0x1040000,0x0,0x0,0x0,0x0,0x42000230,0x0,0x0,0x0,0x43000230,0x0,0x0,0x42000230,0x43000230,0x0,0x800,0x4,0x43000230,0x0,0x0,0x4400,0x400,0x400000,0x400000,0x0,0x0,0x43800230,0x0,0x40,0x0,0x40000040,0x0,0x43000230,0x800000,0x200,0x0,0x40000200,0x8,0x10000188,0x200000,0x8000,0x80000000,0x0,0x400,};
   }
   private static void jj_la1_init_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x0,0x2000080,0x2000080,0x0,0x200,0xe0000000,0xe0000000,0xe0000000,0x0,0x0,0x8000000,0x8000000,0x800000,0x800000,0x200,0x10000000,0x0,0x0,0x200,0x1000000,0x0,0x0,0x200,0x20,0x0,0x0,0x200,0x4000000,0x4000000,0x104,0x104,0x8,0x8,0x100,0x4000000,0x200,0x40,0x0,0x4000000,0x0,0x4000000,0x200,0x0,0x0,0x4000000,0x0,0x0,0x3,0x0,0x0,0x0,0x4000000,0x104,};
   }
   private static void jj_la1_init_2() {
      jj_la1_2 = new int[] {0x1e0000,0x60000,0x180000,0x180000,0x0,0x0,0x0,0x0,0x6dc55,0x2a,0x2a,0x2a,0x0,0x0,0x50,0x50,0x200,0x200,0x6dc55,0x0,0x4,0x1c00,0x6dc55,0x0,0x4,0x6dc05,0x6dc55,0x0,0x0,0x0,0x6dc55,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6dc55,0x0,0x0,0x0,0x0,0x0,0x6dc55,0x0,0x0,0x0,0x0,0x1c00,0x1c00,0x0,0x0,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[8];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  /** Constructor with InputStream. */
  public MdxParserImpl(java.io.InputStream stream) {
     this(stream, null);
  }
  /** Constructor with InputStream and supplied encoding */
  public MdxParserImpl(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source = new MdxParserImplTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  /** Reinitialise. */
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { throw new RuntimeException(e); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor. */
  public MdxParserImpl(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new MdxParserImplTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Constructor with generated Token Manager. */
  public MdxParserImpl(MdxParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  /** Reinitialise. */
  public void ReInit(MdxParserImplTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 57; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }


/** Get the next Token. */
  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

/** Get the specific Token. */
  final public Token getToken(int index) {
    Token t = token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.List<int[]> jj_expentries = new java.util.ArrayList<int[]>();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      jj_entries_loop: for (java.util.Iterator<?> it = jj_expentries.iterator(); it.hasNext();) {
        int[] oldentry = (int[])(it.next());
        if (oldentry.length == jj_expentry.length) {
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              continue jj_entries_loop;
            }
          }
          jj_expentries.add(jj_expentry);
          break jj_entries_loop;
        }
      }
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  /** Generate ParseException. */
  public ParseException generateParseException() {
    jj_expentries.clear();
    boolean[] la1tokens = new boolean[87];
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 57; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 87; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.add(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = jj_expentries.get(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  /** Enable tracing. */
  final public void enable_tracing() {
  }

  /** Disable tracing. */
  final public void disable_tracing() {
  }

  private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 8; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
