/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.ResultStyle;
import mondrian.mdx.NamedSetExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;

public abstract class AbstractCalc
implements Calc {
    private final Calc[] calcs;
    protected final Type type;
    protected final Exp exp;

    protected AbstractCalc(Exp exp, Calc[] calcs) {
        assert (exp != null);
        this.exp = exp;
        this.calcs = calcs;
        this.type = exp.getType();
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        return iface.cast(this);
    }

    @Override
    public void accept(CalcWriter calcWriter) {
        calcWriter.visitCalc(this, this.getName(), this.getArguments(), this.getCalcs());
    }

    protected String getName() {
        String name = this.lastSegment(this.getClass());
        if (AbstractCalc.isDigits(name)) {
            if (this.exp instanceof ResolvedFunCall) {
                ResolvedFunCall funCall = (ResolvedFunCall)this.exp;
                name = funCall.getFunDef().getName();
            } else if (this.exp instanceof NamedSetExpr) {
                NamedSetExpr nse = (NamedSetExpr)this.exp;
                name = nse.getNamedSet().getName();
            }
        }
        return name;
    }

    private String lastSegment(Class clazz) {
        int dollar;
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        int dotDollar = Math.max(dot, dollar = name.lastIndexOf(36));
        if (dotDollar >= 0) {
            return name.substring(dotDollar + 1);
        }
        return name;
    }

    private static boolean isDigits(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if ("0123456789".indexOf(c) >= 0) continue;
            return false;
        }
        return true;
    }

    public Calc[] getCalcs() {
        return this.calcs;
    }

    @Override
    public boolean dependsOn(Hierarchy hierarchy) {
        return AbstractCalc.anyDepends(this.getCalcs(), hierarchy);
    }

    public static boolean anyDepends(Calc[] calcs, Hierarchy hierarchy) {
        for (Calc calc : calcs) {
            if (calc == null || !calc.dependsOn(hierarchy)) continue;
            return true;
        }
        return false;
    }

    public static boolean anyDependsButFirst(Calc[] calcs, Hierarchy hierarchy) {
        if (calcs.length == 0) {
            return false;
        }
        if (calcs[0].dependsOn(hierarchy)) {
            return true;
        }
        if (calcs[0].getType().usesHierarchy(hierarchy, true)) {
            return false;
        }
        for (int i = 1; i < calcs.length; ++i) {
            Calc calc = calcs[i];
            if (calc == null || !calc.dependsOn(hierarchy)) continue;
            return true;
        }
        return false;
    }

    public static boolean butDepends(Calc[] calcs, Hierarchy hierarchy) {
        boolean result = true;
        for (Calc calc : calcs) {
            if (calc == null) continue;
            if (calc.dependsOn(hierarchy)) {
                return true;
            }
            if (!calc.getType().usesHierarchy(hierarchy, true)) continue;
            result = false;
        }
        return result;
    }

    protected final Map<String, Object> getArguments() {
        LinkedHashMap<String, Object> argumentMap = new LinkedHashMap<String, Object>();
        this.collectArguments(argumentMap);
        return argumentMap;
    }

    protected void collectArguments(Map<String, Object> arguments) {
        arguments.put("name", this.getName());
        arguments.put("class", this.getClass());
        arguments.put("type", this.getType());
        arguments.put("resultStyle", (Object)this.getResultStyle());
    }

    public static Evaluator simplifyEvaluator(Calc calc, Evaluator evaluator) {
        if (evaluator.isNonEmpty()) {
            return evaluator;
        }
        int changeCount = 0;
        Evaluator ev = evaluator;
        List<RolapHierarchy> hierarchies = ((RolapEvaluator)evaluator).getCube().getHierarchies();
        for (RolapHierarchy hierarchy : hierarchies) {
            Member unconstrainedMember;
            Member member = ev.getContext(hierarchy);
            if (member.isAll() || calc.dependsOn(hierarchy) || member == (unconstrainedMember = member.getHierarchy().getDefaultMember())) continue;
            if (changeCount++ == 0) {
                ev = evaluator.push();
            }
            ev.setContext(unconstrainedMember);
        }
        return ev;
    }

    @Override
    public ResultStyle getResultStyle() {
        return ResultStyle.VALUE;
    }
}

