/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import mondrian.calc.Calc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.Type;

public class MemberArrayValueCalc
extends GenericCalc {
    private final MemberCalc[] memberCalcs;
    private final Member[] members;
    private final boolean nullCheck;

    MemberArrayValueCalc(Exp exp, MemberCalc[] memberCalcs, boolean nullCheck) {
        super(exp);
        this.nullCheck = nullCheck;
        Type type = exp.getType();
        assert (type instanceof ScalarType) : exp;
        this.memberCalcs = memberCalcs;
        this.members = new Member[memberCalcs.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Evaluator evaluator) {
        int savepoint = evaluator.savepoint();
        try {
            Object result;
            for (int i = 0; i < this.memberCalcs.length; ++i) {
                MemberCalc memberCalc = this.memberCalcs[i];
                Member member = memberCalc.evaluateMember(evaluator);
                if (member == null || member.isNull()) {
                    Object var6_8 = null;
                    return var6_8;
                }
                evaluator.setContext(member);
                this.members[i] = member;
            }
            if (this.nullCheck && evaluator.needToReturnNullForUnrelatedDimension(this.members)) {
                Object i = null;
                return i;
            }
            Object object = result = evaluator.evaluateCurrent();
            return object;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    @Override
    public Calc[] getCalcs() {
        return this.memberCalcs;
    }

    @Override
    public boolean dependsOn(Hierarchy hierarchy) {
        if (super.dependsOn(hierarchy)) {
            return true;
        }
        for (MemberCalc memberCalc : this.memberCalcs) {
            if (!memberCalc.getType().usesHierarchy(hierarchy, true)) continue;
            return false;
        }
        return true;
    }
}

