/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.UnionRoleImpl;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoleImpl
implements Role {
    private boolean mutable = true;
    private final Map<Schema, Access> schemaGrants = new HashMap<Schema, Access>();
    private final Map<Cube, Access> cubeGrants = new HashMap<Cube, Access>();
    private final Map<Dimension, Access> dimensionGrants = new HashMap<Dimension, Access>();
    private final Map<Hierarchy, HierarchyAccessImpl> hierarchyGrants = new HashMap<Hierarchy, HierarchyAccessImpl>();
    private static final Logger LOGGER = LogManager.getLogger(RoleImpl.class);
    private final List<Object[]> hashCache = new ArrayList<Object[]>();
    private int hash = 0;

    public int hashCode() {
        if (this.hash == 0) {
            int tmpHash = 7;
            for (Object[] obj : this.hashCache) {
                tmpHash = Util.hash(tmpHash, obj);
            }
            this.hash = tmpHash;
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleImpl)) {
            return false;
        }
        RoleImpl r = (RoleImpl)obj;
        return r.hashCache.equals(this.hashCache);
    }

    protected RoleImpl clone() {
        RoleImpl role = new RoleImpl();
        role.mutable = this.mutable;
        role.schemaGrants.putAll(this.schemaGrants);
        role.cubeGrants.putAll(this.cubeGrants);
        role.dimensionGrants.putAll(this.dimensionGrants);
        role.hashCache.addAll(this.hashCache);
        for (Map.Entry<Hierarchy, HierarchyAccessImpl> entry : this.hierarchyGrants.entrySet()) {
            role.hierarchyGrants.put(entry.getKey(), (HierarchyAccessImpl)entry.getValue().clone());
        }
        return role;
    }

    public RoleImpl makeMutableClone() {
        RoleImpl role = this.clone();
        role.mutable = true;
        return role;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void grant(Schema schema, Access access) {
        assert (schema != null);
        assert (this.isMutable());
        this.schemaGrants.put(schema, access);
        this.hashCache.add(new Object[]{schema.getId(), access.name()});
        this.hash = 0;
    }

    @Override
    public Access getAccess(Schema schema) {
        assert (schema != null);
        Access schemaAccess = this.schemaGrants.get(schema);
        if (schemaAccess == null) {
            return Access.CUSTOM;
        }
        return schemaAccess;
    }

    private static Access toAccess(Access access) {
        return access == null ? Access.NONE : access;
    }

    public void grant(Cube cube, Access access) {
        Util.assertPrecondition(cube != null, "cube != null");
        assert (access == Access.ALL || access == Access.NONE || access == Access.CUSTOM);
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        LOGGER.trace("Grant " + (Object)((Object)access) + " on cube " + cube.getName());
        this.cubeGrants.put(cube, access);
        Access schemaAccess = this.getAccess(cube.getSchema());
        if (schemaAccess == Access.NONE) {
            LOGGER.trace("Cascading grant " + (Object)((Object)Access.CUSTOM) + " on schema " + cube.getSchema().getName());
            this.grant(cube.getSchema(), Access.CUSTOM);
        }
        this.hashCache.add(new Object[]{cube.getClass().getName(), cube.getName(), access.name()});
        this.hash = 0;
    }

    @Override
    public Access getAccess(Cube cube) {
        assert (cube != null);
        Access access = this.cubeGrants.get(cube);
        if (access != null) {
            LOGGER.trace("Access level " + (Object)((Object)access) + " granted to cube " + cube.getName());
            return access;
        }
        access = this.schemaGrants.get(cube.getSchema());
        if (access == Access.ALL) {
            LOGGER.trace("Access level " + (Object)((Object)access) + " granted to cube " + cube.getName() + " because of the grant to schema " + cube.getSchema().getName());
            return Access.ALL;
        }
        LOGGER.trace("Access denided to cube" + cube.getName());
        return Access.NONE;
    }

    public void grant(Dimension dimension, Access access) {
        assert (dimension != null);
        assert (access == Access.ALL || access == Access.NONE || access == Access.CUSTOM);
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        LOGGER.trace("Grant " + (Object)((Object)access) + " on dimension " + dimension.getUniqueName());
        this.dimensionGrants.put(dimension, access);
        this.hashCache.add(new Object[]{dimension.getClass().getName(), dimension.getName(), access.name()});
        this.hash = 0;
    }

    @Override
    public Access getAccess(Dimension dimension) {
        assert (dimension != null);
        Access access = this.getDimensionGrant(dimension);
        if (access == Access.CUSTOM) {
            boolean canAccess = false;
            for (Hierarchy hierarchy : dimension.getHierarchies()) {
                HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(hierarchy);
                if (hierarchyAccess == null || hierarchyAccess.access == Access.NONE) continue;
                canAccess = true;
            }
            if (canAccess) {
                LOGGER.trace("Access level " + (Object)((Object)access) + " granted to dimension " + dimension.getUniqueName() + " because of the grant to one of its hierarchy.");
                return Access.CUSTOM;
            }
            LOGGER.trace("Access denided to dimension " + dimension.getUniqueName() + " because there are no hierarchies accessible.");
            return Access.NONE;
        }
        if (access != null) {
            LOGGER.trace("Access level " + (Object)((Object)access) + " granted to dimension " + dimension.getUniqueName() + " because of explicit access rights.");
            return access;
        }
        access = this.checkDimensionAccessByCubeInheritance(dimension);
        if (access != Access.NONE) {
            LOGGER.trace("Access level " + (Object)((Object)access) + " granted to dimension " + dimension.getUniqueName() + " because of the grant to its parent cube.");
            return access;
        }
        switch (this.getAccess(dimension.getSchema())) {
            case ALL: {
                LOGGER.trace("Access level ALL  granted to dimension " + dimension.getUniqueName() + " because of the grant to schema " + dimension.getSchema().getName());
                return Access.ALL;
            }
            case ALL_DIMENSIONS: {
                if (access != Access.NONE) {
                    return Access.ALL;
                }
                return Access.NONE;
            }
        }
        LOGGER.trace("Access denided to dimension " + dimension.getUniqueName() + " because of the access level of schema " + dimension.getSchema().getName());
        return Access.NONE;
    }

    private Access getDimensionGrant(Dimension dimension) {
        if (dimension.isMeasures()) {
            for (Dimension key : this.dimensionGrants.keySet()) {
                if (key != dimension) continue;
                return this.dimensionGrants.get(key);
            }
            return null;
        }
        return this.dimensionGrants.get(dimension);
    }

    private Access checkDimensionAccessByCubeInheritance(Dimension dimension) {
        assert (!this.dimensionGrants.containsKey(dimension) || dimension.isMeasures());
        for (Map.Entry<Cube, Access> cubeGrant : this.cubeGrants.entrySet()) {
            Dimension[] dimensions;
            Access access = RoleImpl.toAccess(cubeGrant.getValue());
            if (access == Access.NONE || access == Access.CUSTOM) continue;
            for (Dimension dimension1 : dimensions = cubeGrant.getKey().getDimensions()) {
                if (dimension == dimension1) {
                    return cubeGrant.getValue();
                }
                if (dimension instanceof RolapCubeDimension && dimension.equals(dimension1) && !((RolapCubeDimension)dimension1).getCube().equals(cubeGrant.getKey()) || !(cubeGrant.getKey() instanceof RolapCube) || !((RolapCube)cubeGrant.getKey()).isVirtual() || !dimension.equals(dimension1)) continue;
                return cubeGrant.getValue();
            }
        }
        return Access.NONE;
    }

    public void grant(Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel, Role.RollupPolicy rollupPolicy) {
        assert (hierarchy != null);
        assert (access != null);
        assert (access == Access.CUSTOM || topLevel == null && bottomLevel == null);
        assert (topLevel == null || topLevel.getHierarchy() == hierarchy);
        assert (bottomLevel == null || bottomLevel.getHierarchy() == hierarchy);
        assert (this.isMutable());
        assert (rollupPolicy != null);
        LOGGER.trace("Granting access " + (Object)((Object)access) + " on hierarchy " + hierarchy.getUniqueName());
        this.hierarchyGrants.put(hierarchy, new HierarchyAccessImpl(this, hierarchy, access, topLevel, bottomLevel, rollupPolicy));
        Access dimAccess = RoleImpl.toAccess(this.dimensionGrants.get(hierarchy.getDimension()));
        if (dimAccess == Access.NONE) {
            LOGGER.trace("Cascading grant CUSTOM on dimension " + hierarchy.getDimension().getUniqueName() + " because of the grant to hierarchy" + hierarchy.getUniqueName());
            this.grant(hierarchy.getDimension(), Access.CUSTOM);
        }
        this.hashCache.add(new Object[]{hierarchy.getClass().getName(), hierarchy.getName(), access.name()});
        this.hash = 0;
    }

    @Override
    public Access getAccess(Hierarchy hierarchy) {
        assert (hierarchy != null);
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(hierarchy);
        if (hierarchyAccess != null) {
            LOGGER.trace("Access level " + (Object)((Object)hierarchyAccess.access) + " granted to dimension " + hierarchy.getUniqueName());
            return hierarchyAccess.access;
        }
        Access access = this.getAccess(hierarchy.getDimension());
        if (access == Access.ALL) {
            LOGGER.trace("Access level ALL  granted to hierarchy " + hierarchy.getUniqueName() + " because of the grant to dimension " + hierarchy.getDimension().getUniqueName());
            return Access.ALL;
        }
        LOGGER.trace("Access denided to hierarchy " + hierarchy.getUniqueName());
        return Access.NONE;
    }

    @Override
    public Role.HierarchyAccess getAccessDetails(Hierarchy hierarchy) {
        Access dimAccess;
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        if (this.hierarchyGrants.containsKey(hierarchy)) {
            return this.hierarchyGrants.get(hierarchy);
        }
        Access schemaGrant = this.schemaGrants.get(hierarchy.getDimension().getSchema());
        Access hierarchyAccess = schemaGrant != null ? (schemaGrant == Access.ALL ? Access.ALL : ((dimAccess = this.getAccess(hierarchy.getDimension())) == Access.ALL ? Access.ALL : Access.NONE)) : Access.ALL;
        return new HierarchyAccessImpl(this, hierarchy, hierarchyAccess, null, null, Role.RollupPolicy.HIDDEN);
    }

    @Override
    public Access getAccess(Level level) {
        assert (level != null);
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(level.getHierarchy());
        if (hierarchyAccess != null && hierarchyAccess.access != Access.NONE && RoleImpl.checkLevelIsOkWithRestrictions(hierarchyAccess, level)) {
            LOGGER.trace("Access level " + (Object)((Object)hierarchyAccess.access) + " granted to level " + level.getUniqueName() + " because of the grant to hierarchy " + level.getHierarchy().getUniqueName());
            return hierarchyAccess.access;
        }
        Access access = this.getAccess(level.getDimension());
        LOGGER.trace("Access level " + (Object)((Object)access) + " granted to level " + level.getUniqueName() + " because of the grant to dimension " + level.getDimension().getUniqueName());
        return access;
    }

    private static boolean checkLevelIsOkWithRestrictions(HierarchyAccessImpl hierarchyAccess, Level level) {
        if (level.getDepth() < hierarchyAccess.topLevel.getDepth()) {
            return false;
        }
        return level.getDepth() <= hierarchyAccess.bottomLevel.getDepth();
    }

    public void grant(Member member, Access access) {
        Util.assertPrecondition(member != null, "member != null");
        assert (this.isMutable());
        assert (this.getAccess(member.getHierarchy()) == Access.CUSTOM);
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        assert (hierarchyAccess != null);
        assert (hierarchyAccess.access == Access.CUSTOM);
        hierarchyAccess.grant(this, member, access);
        this.hashCache.add(new Object[]{member.getClass().getName(), member.getName(), access.name()});
        this.hash = 0;
    }

    @Override
    public Access getAccess(Member member) {
        assert (member != null);
        if (member.isCalculatedInQuery()) {
            return Access.ALL;
        }
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        if (hierarchyAccess != null) {
            return hierarchyAccess.getAccess(member);
        }
        Access access = this.getAccess(member.getLevel());
        LOGGER.trace("Access level " + (Object)((Object)access) + " granted to level " + member.getUniqueName() + " because of the grant to level " + member.getLevel().getUniqueName());
        return access;
    }

    @Override
    public Access getAccess(NamedSet set) {
        Util.assertPrecondition(set != null, "set != null");
        LOGGER.trace("Access level ALL  granted to NamedSet " + set.getUniqueName() + " because I said so.");
        return Access.ALL;
    }

    @Override
    public boolean canAccess(OlapElement olapElement) {
        Util.assertPrecondition(olapElement != null, "olapElement != null");
        if (olapElement instanceof Member) {
            return this.getAccess((Member)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Level) {
            return this.getAccess((Level)olapElement) != Access.NONE;
        }
        if (olapElement instanceof NamedSet) {
            return this.getAccess((NamedSet)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Hierarchy) {
            return this.getAccess((Hierarchy)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Cube) {
            return this.getAccess((Cube)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Dimension) {
            return this.getAccess((Dimension)olapElement) != Access.NONE;
        }
        return false;
    }

    public static Role.HierarchyAccess createAllAccess(Hierarchy hierarchy) {
        return new HierarchyAccessImpl(Util.createRootRole(hierarchy.getDimension().getSchema()), hierarchy, Access.ALL, null, null, Role.RollupPolicy.FULL);
    }

    public static Role union(List<Role> roleList) {
        assert (roleList.size() > 0);
        return new UnionRoleImpl(roleList);
    }

    static class CachingHierarchyAccess
    extends DelegatingHierarchyAccess {
        private final Map<Member, Access> memberAccessMap = new WeakHashMap<Member, Access>();
        private Role.RollupPolicy rollupPolicy;
        private Map<Member, Boolean> inaccessibleDescendantsMap = new WeakHashMap<Member, Boolean>();
        private Integer topLevelDepth;
        private Integer bottomLevelDepth;

        public CachingHierarchyAccess(Role.HierarchyAccess hierarchyAccess) {
            super(hierarchyAccess);
        }

        @Override
        public Access getAccess(Member member) {
            Access access = this.memberAccessMap.get(member);
            if (access != null) {
                return access;
            }
            access = this.hierarchyAccess.getAccess(member);
            this.memberAccessMap.put(member, access);
            return access;
        }

        @Override
        public int getTopLevelDepth() {
            if (this.topLevelDepth == null) {
                this.topLevelDepth = this.hierarchyAccess.getTopLevelDepth();
            }
            return this.topLevelDepth;
        }

        @Override
        public int getBottomLevelDepth() {
            if (this.bottomLevelDepth == null) {
                this.bottomLevelDepth = this.hierarchyAccess.getBottomLevelDepth();
            }
            return this.bottomLevelDepth;
        }

        @Override
        public Role.RollupPolicy getRollupPolicy() {
            if (this.rollupPolicy == null) {
                this.rollupPolicy = this.hierarchyAccess.getRollupPolicy();
            }
            return this.rollupPolicy;
        }

        @Override
        public boolean hasInaccessibleDescendants(Member member) {
            Boolean b = this.inaccessibleDescendantsMap.get(member);
            if (b == null) {
                b = this.hierarchyAccess.hasInaccessibleDescendants(member);
                this.inaccessibleDescendantsMap.put(member, b);
            }
            return b;
        }
    }

    public static abstract class DelegatingHierarchyAccess
    implements Role.AllHierarchyAccess {
        protected final Role.HierarchyAccess hierarchyAccess;

        public DelegatingHierarchyAccess(Role.HierarchyAccess hierarchyAccess) {
            assert (hierarchyAccess != null);
            this.hierarchyAccess = hierarchyAccess;
        }

        @Override
        public Access getAccess(Member member) {
            return this.hierarchyAccess.getAccess(member);
        }

        @Override
        public int getTopLevelDepth() {
            return this.hierarchyAccess.getTopLevelDepth();
        }

        @Override
        public int getBottomLevelDepth() {
            return this.hierarchyAccess.getBottomLevelDepth();
        }

        @Override
        public Role.RollupPolicy getRollupPolicy() {
            return this.hierarchyAccess.getRollupPolicy();
        }

        @Override
        public boolean hasInaccessibleDescendants(Member member) {
            return this.hierarchyAccess.hasInaccessibleDescendants(member);
        }

        @Override
        public Access getAccess() {
            if (this.hierarchyAccess instanceof Role.AllHierarchyAccess) {
                return ((Role.AllHierarchyAccess)this.hierarchyAccess).getAccess();
            }
            throw Util.newInternal("Unsupported operation. Should implement AllHierarchyAccess.");
        }
    }

    private static class MemberAccess {
        private final Member member;
        private final Access access;
        private final Map<String, Boolean> parentsCache = new WeakHashMap<String, Boolean>();

        public MemberAccess(Member member, Access access) {
            this.member = member;
            this.access = access;
        }

        private boolean isSubGrant(Member parentMember) {
            if (this.parentsCache.containsKey(parentMember.getUniqueName())) {
                return this.parentsCache.get(parentMember.getUniqueName());
            }
            for (Member m = this.member; m != null; m = m.getParentMember()) {
                if (!m.equals(parentMember)) continue;
                this.parentsCache.put(parentMember.getUniqueName(), Boolean.TRUE);
                return true;
            }
            if (MondrianProperties.instance().EnableRolapCubeMemberCache.get()) {
                this.parentsCache.put(parentMember.getUniqueName(), Boolean.FALSE);
            }
            return false;
        }

        public String toString() {
            return "MemberAccess{" + this.member.getUniqueName() + " : " + this.access.toString() + "}";
        }
    }

    private static class HierarchyAccessImpl
    implements Role.AllHierarchyAccess {
        private final Hierarchy hierarchy;
        private final Level topLevel;
        private final Access access;
        private final Level bottomLevel;
        private final Map<String, MemberAccess> memberGrants = new HashMap<String, MemberAccess>();
        private final Role.RollupPolicy rollupPolicy;
        private final Role role;

        HierarchyAccessImpl(Role role, Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel, Role.RollupPolicy rollupPolicy) {
            assert (role != null);
            assert (hierarchy != null);
            assert (access != null);
            assert (rollupPolicy != null);
            this.role = role;
            this.hierarchy = hierarchy;
            this.access = access;
            this.rollupPolicy = rollupPolicy;
            this.topLevel = topLevel == null ? hierarchy.getLevels()[0] : topLevel;
            this.bottomLevel = bottomLevel == null ? hierarchy.getLevels()[hierarchy.getLevels().length - 1] : bottomLevel;
        }

        public Role.HierarchyAccess clone() {
            HierarchyAccessImpl hierarchyAccess = new HierarchyAccessImpl(this.role, this.hierarchy, this.access, this.topLevel, this.bottomLevel, this.rollupPolicy);
            hierarchyAccess.memberGrants.putAll(this.memberGrants);
            return hierarchyAccess;
        }

        void grant(RoleImpl role, Member member, Access access) {
            Member m;
            MemberAccess mAccess;
            Util.assertTrue(member.getHierarchy() == this.hierarchy);
            Iterator<MemberAccess> memberIter = this.memberGrants.values().iterator();
            while (memberIter.hasNext()) {
                mAccess = memberIter.next();
                if (!mAccess.member.isChildOrEqualTo(member)) continue;
                LOGGER.trace("Member grant " + mAccess + " removed because a grant on " + member.getUniqueName() + " overrides it.");
                memberIter.remove();
            }
            LOGGER.trace("Granting access " + (Object)((Object)access) + " on member " + member.getUniqueName());
            this.memberGrants.put(member.getUniqueName(), new MemberAccess(member, access));
            if (access == Access.NONE) {
                for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    Access parentAccess;
                    mAccess = this.memberGrants.get(m.getUniqueName());
                    Access access2 = parentAccess = mAccess == null ? null : mAccess.access;
                    if (parentAccess == Access.NONE && RoleImpl.checkLevelIsOkWithRestrictions(this, m.getLevel())) {
                        LOGGER.trace("Cascading grant CUSTOM on member " + m.getUniqueName() + " because of the grant to member " + member.getUniqueName());
                        this.memberGrants.put(m.getUniqueName(), new MemberAccess(m, Access.CUSTOM));
                    }
                    if (parentAccess != null && parentAccess != Access.ALL || !RoleImpl.checkLevelIsOkWithRestrictions(this, m.getLevel())) continue;
                    LOGGER.trace("Cascading grant RESTRICTED on member " + m.getUniqueName() + " because of the grant to member " + member.getUniqueName());
                    this.memberGrants.put(m.getUniqueName(), new MemberAccess(m, Access.RESTRICTED));
                }
            } else {
                for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    Access parentAccess;
                    if (!RoleImpl.checkLevelIsOkWithRestrictions(this, m.getLevel()) || (parentAccess = RoleImpl.toAccess((mAccess = this.memberGrants.get(m.getUniqueName())) == null ? null : mAccess.access)) != Access.NONE) continue;
                    LOGGER.trace("Cascading grant CUSTOM on member " + m.getUniqueName() + " because of the grant to member " + member.getUniqueName());
                    this.memberGrants.put(m.getUniqueName(), new MemberAccess(m, Access.CUSTOM));
                }
                Access hierarchyAccess = role.getAccess(member.getLevel().getHierarchy());
                if (hierarchyAccess == Access.NONE) {
                    LOGGER.trace("Cascading grant CUSTOM on hierarchy " + this.hierarchy.getUniqueName() + " because of the grant to member " + member.getUniqueName());
                    role.grant(this.hierarchy, Access.CUSTOM, this.topLevel, this.bottomLevel, this.rollupPolicy);
                }
            }
        }

        @Override
        public Access getAccess() {
            return this.access;
        }

        @Override
        public Access getAccess(Member member) {
            Access access;
            if (this.access != Access.CUSTOM) {
                return this.access;
            }
            MemberAccess mAccess = this.memberGrants.get(member.getUniqueName());
            Access access2 = access = mAccess == null ? null : mAccess.access;
            if (access == Access.NONE) {
                LOGGER.trace("Access level " + (Object)((Object)Access.NONE) + " granted to member " + member.getUniqueName() + " because it is explicitly denided.");
                return Access.NONE;
            }
            if (access == Access.ALL || access == Access.CUSTOM) {
                LOGGER.trace("Access level " + (Object)((Object)access) + " granted to member " + member.getUniqueName());
                return access;
            }
            if (access == Access.RESTRICTED) {
                LOGGER.trace("Access level " + (Object)((Object)Access.CUSTOM) + " granted to member " + member.getUniqueName() + " because it was RESTRICTED. ");
                return Access.CUSTOM;
            }
            if (!RoleImpl.checkLevelIsOkWithRestrictions(this, member.getLevel())) {
                LOGGER.trace("Access denided to member " + member.getUniqueName() + " because its level " + member.getLevel().getUniqueName() + " is out of the permitted bounds of between " + this.topLevel.getUniqueName() + " and " + this.bottomLevel.getUniqueName());
                return Access.NONE;
            }
            for (Member m = member.getParentMember(); m != null; m = m.getParentMember()) {
                Access parentAccess;
                MemberAccess pAccess = this.memberGrants.get(m.getUniqueName());
                Access access3 = parentAccess = pAccess == null ? null : pAccess.access;
                if (parentAccess == null) continue;
                if (parentAccess == Access.NONE || parentAccess == Access.CUSTOM) {
                    LOGGER.trace("Access denided to member " + member.getUniqueName() + " because its parent " + m.getUniqueName() + " is of access level " + (Object)((Object)parentAccess));
                    return Access.NONE;
                }
                LOGGER.trace("Access level ALL granted to member " + member.getUniqueName() + " because its parent " + m.getUniqueName() + " is of access level " + (Object)((Object)parentAccess));
                return Access.ALL;
            }
            access = this.role.getAccess(member.getLevel());
            if (access == Access.ALL) {
                LOGGER.trace("Access ALL granted to member " + member.getUniqueName() + " because its level " + member.getLevel().getUniqueName() + " is of access level ALL");
                return Access.ALL;
            }
            if (this.memberGrants.size() == 0) {
                LOGGER.trace("Access level ALL granted to member " + member.getUniqueName() + " because it lies between the permitted level bounds and there are no explicit member grants defined in hierarchy " + member.getHierarchy().getUniqueName());
                return Access.ALL;
            }
            LOGGER.trace("Access denided to member " + member.getUniqueName() + " because none of its parents allow access to it.");
            return Access.NONE;
        }

        @Override
        public final int getTopLevelDepth() {
            return this.topLevel.getDepth();
        }

        @Override
        public final int getBottomLevelDepth() {
            return this.bottomLevel.getDepth();
        }

        @Override
        public Role.RollupPolicy getRollupPolicy() {
            return this.rollupPolicy;
        }

        @Override
        public boolean hasInaccessibleDescendants(Member member) {
            for (MemberAccess access : this.memberGrants.values()) {
                switch (access.access) {
                    case NONE: 
                    case CUSTOM: {
                        if (!access.isSubGrant(member)) break;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

