/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;

class CaseMatchFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    private CaseMatchFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        ArrayList<Calc> calcList = new ArrayList<Calc>();
        final Calc valueCalc = compiler.compileScalar(args[0], true);
        calcList.add(valueCalc);
        int matchCount = (args.length - 1) / 2;
        final Calc[] matchCalcs = new Calc[matchCount];
        final Calc[] exprCalcs = new Calc[matchCount];
        int j = 1;
        for (int i = 0; i < exprCalcs.length; ++i) {
            matchCalcs[i] = compiler.compileScalar(args[j++], true);
            calcList.add(matchCalcs[i]);
            exprCalcs[i] = compiler.compile(args[j++]);
            calcList.add(exprCalcs[i]);
        }
        final ConstantCalc defaultCalc = args.length % 2 == 0 ? compiler.compile(args[args.length - 1]) : ConstantCalc.constantNull(call.getType());
        calcList.add(defaultCalc);
        final Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
        return new GenericCalc(call){

            @Override
            public Object evaluate(Evaluator evaluator) {
                Object value = valueCalc.evaluate(evaluator);
                for (int i = 0; i < matchCalcs.length; ++i) {
                    Object match = matchCalcs[i].evaluate(evaluator);
                    if (!match.equals(value)) continue;
                    return exprCalcs[i].evaluate(evaluator);
                }
                return defaultCalc.evaluate(evaluator);
            }

            @Override
            public Calc[] getCalcs() {
                return calcs;
            }
        };
    }

    private static class ResolverImpl
    extends ResolverBase {
        private ResolverImpl() {
            super("_CaseMatch", "Case <Expression> When <Expression> Then <Expression> [...] [Else <Expression>] End", "Evaluates various expressions, and returns the corresponding expression for the first which matches a particular value.", Syntax.Case);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (args.length < 3) {
                return null;
            }
            int valueType = args[0].getCategory();
            int returnType = args[2].getCategory();
            int j = 0;
            int clauseCount = (args.length - 1) / 2;
            int mismatchingArgs = 0;
            if (!validator.canConvert(j, args[j++], valueType, conversions)) {
                ++mismatchingArgs;
            }
            for (int i = 0; i < clauseCount; ++i) {
                if (!validator.canConvert(j, args[j++], valueType, conversions)) {
                    ++mismatchingArgs;
                }
                if (validator.canConvert(j, args[j++], returnType, conversions)) continue;
                ++mismatchingArgs;
            }
            if (j < args.length && !validator.canConvert(j, args[j++], returnType, conversions)) {
                ++mismatchingArgs;
            }
            Util.assertTrue(j == args.length);
            if (mismatchingArgs != 0) {
                return null;
            }
            FunDef dummy = ResolverImpl.createDummyFunDef(this, returnType, args);
            return new CaseMatchFunDef(dummy);
        }

        @Override
        public boolean requiresExpression(int k) {
            return true;
        }
    }
}

