/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.type.Type;

public class ExistingFunDef
extends FunDefBase {
    static final ExistingFunDef instance = new ExistingFunDef();

    protected ExistingFunDef() {
        super("Existing", "Existing <Set>", "Forces the set to be evaluated within the current context.", "Pxx");
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        return args[0].getType();
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final IterCalc setArg = compiler.compileIter(call.getArg(0));
        final Type myType = call.getArg(0).getType();
        return new AbstractListCalc(call, new Calc[]{setArg}){

            @Override
            public boolean dependsOn(Hierarchy hierarchy) {
                return myType.usesHierarchy(hierarchy, false);
            }

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                TupleIterable setTuples = setArg.evaluateIterable(evaluator);
                TupleList result = TupleCollections.createList(setTuples.getArity());
                List<Member> contextMembers = Arrays.asList(evaluator.getMembers());
                List argDims = null;
                List contextDims = ExistingFunDef.getHierarchies(contextMembers);
                for (List tuple : setTuples) {
                    if (argDims == null) {
                        argDims = ExistingFunDef.getHierarchies(tuple);
                    }
                    if (!FunUtil.existsInTuple(tuple, contextMembers, argDims, contextDims, evaluator)) continue;
                    result.add(tuple);
                }
                return result;
            }
        };
    }

    private static List<Hierarchy> getHierarchies(List<Member> members) {
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>(members.size());
        for (Member member : members) {
            hierarchies.add(member.getHierarchy());
        }
        return hierarchies;
    }
}

