/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.LevelExpr;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Annotation;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.HierarchyCurrentMemberFunDef;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.fun.ParenthesesFunDef;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.fun.sort.OrderKey;
import mondrian.olap.fun.sort.Sorter;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapUtil;
import mondrian.server.Execution;
import mondrian.util.CancellationChecker;
import mondrian.util.ConcatenableList;
import mondrian.util.IdentifierParser;
import org.olap4j.impl.IdentifierParser;

public class FunUtil
extends Util {
    static final String[] emptyStringArray = new String[0];
    public static final NullMember NullMember = new NullMember();
    public static final double DoubleNull = 1.2345E-8;
    public static final double DoubleEmpty = -1.2345E-8;
    public static final int IntegerNull = -2147483647;
    public static final boolean BooleanNull = false;

    public static RuntimeException newEvalException(FunDef funDef, String message) {
        Util.discard((Object)funDef);
        return new MondrianEvaluationException(message);
    }

    public static RuntimeException newEvalException(Throwable throwable) {
        return new MondrianEvaluationException(throwable.getClass().getName() + ": " + throwable.getMessage());
    }

    public static RuntimeException newEvalException(String message, Throwable throwable) {
        return new MondrianEvaluationException(message + ": " + Util.getErrorMessage(throwable));
    }

    public static void checkIterListResultStyles(Calc calc) {
        switch (calc.getResultStyle()) {
            case ITERABLE: 
            case LIST: 
            case MUTABLE_LIST: {
                break;
            }
            default: {
                throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, calc.getResultStyle());
            }
        }
    }

    public static void checkListResultStyles(Calc calc) {
        switch (calc.getResultStyle()) {
            case LIST: 
            case MUTABLE_LIST: {
                break;
            }
            default: {
                throw ResultStyleException.generateBadType(ResultStyle.LIST_MUTABLELIST, calc.getResultStyle());
            }
        }
    }

    static String getLiteralArg(ResolvedFunCall call, int i, String defaultValue, String[] allowedValues) {
        if (i >= call.getArgCount()) {
            if (defaultValue == null) {
                throw FunUtil.newEvalException(call.getFunDef(), "Required argument is missing");
            }
            return defaultValue;
        }
        Exp arg = call.getArg(i);
        if (!(arg instanceof Literal) || arg.getCategory() != 11) {
            throw FunUtil.newEvalException(call.getFunDef(), "Expected a symbol, found '" + arg + "'");
        }
        String s = (String)((Literal)arg).getValue();
        StringBuilder sb = new StringBuilder(64);
        for (int j = 0; j < allowedValues.length; ++j) {
            String allowedValue = allowedValues[j];
            if (allowedValue.equalsIgnoreCase(s)) {
                return allowedValue;
            }
            if (j > 0) {
                sb.append(", ");
            }
            sb.append(allowedValue);
        }
        throw FunUtil.newEvalException(call.getFunDef(), "Allowed values are: {" + sb + "}");
    }

    static <E extends Enum<E>> E getLiteralArg(ResolvedFunCall call, int i, E defaultValue, Class<E> allowedValues) {
        if (i >= call.getArgCount()) {
            if (defaultValue == null) {
                throw FunUtil.newEvalException(call.getFunDef(), "Required argument is missing");
            }
            return defaultValue;
        }
        Exp arg = call.getArg(i);
        if (!(arg instanceof Literal) || arg.getCategory() != 11) {
            throw FunUtil.newEvalException(call.getFunDef(), "Expected a symbol, found '" + arg + "'");
        }
        String s = (String)((Literal)arg).getValue();
        for (Enum e : (Enum[])allowedValues.getEnumConstants()) {
            if (!e.name().equalsIgnoreCase(s)) continue;
            return (E)e;
        }
        StringBuilder buf = new StringBuilder(64);
        int k = 0;
        for (Enum e : (Enum[])allowedValues.getEnumConstants()) {
            if (k++ > 0) {
                buf.append(", ");
            }
            buf.append(e.name());
        }
        throw FunUtil.newEvalException(call.getFunDef(), "Allowed values are: {" + buf + "}");
    }

    static void checkCompatible(Exp left, Exp right, FunDef funDef) {
        Type rightType;
        Type leftType = TypeUtil.stripSetType(left.getType());
        if (!TypeUtil.isUnionCompatible(leftType, rightType = TypeUtil.stripSetType(right.getType()))) {
            throw FunUtil.newEvalException(funDef, "Expressions must have the same hierarchy");
        }
    }

    static void addUnique(TupleList left, TupleList right, Set<List<Member>> set) {
        assert (left != null);
        assert (right != null);
        if (right.isEmpty()) {
            return;
        }
        int n = right.size();
        for (int i = 0; i < n; ++i) {
            List o = (List)right.get(i);
            if (!set.add(o)) continue;
            left.add(o);
        }
    }

    public static Hierarchy getDimensionDefaultHierarchy(Dimension dimension) {
        Hierarchy[] hierarchies = dimension.getHierarchies();
        if (hierarchies.length == 1) {
            return hierarchies[0];
        }
        if (MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return null;
        }
        for (Hierarchy hierarchy : hierarchies) {
            if (hierarchy.getName() != null && !hierarchy.getUniqueName().equals(dimension.getUniqueName())) continue;
            return hierarchy;
        }
        return null;
    }

    static List<Member> addMembers(SchemaReader schemaReader, List<Member> members, Hierarchy hierarchy) {
        for (Level level : schemaReader.getHierarchyLevels(hierarchy)) {
            FunUtil.addMembers(schemaReader, members, level);
        }
        return members;
    }

    static List<Member> addMembers(SchemaReader schemaReader, List<Member> members, Level level) {
        List<Member> levelMembers = schemaReader.getLevelMembers(level, true);
        members.addAll(levelMembers);
        return members;
    }

    static List<Member> removeCalculatedMembers(List<Member> memberList) {
        ArrayList<Member> clone = new ArrayList<Member>();
        for (Member member : memberList) {
            if (member.isCalculated() && !member.isParentChildPhysicalMember()) continue;
            clone.add(member);
        }
        return clone;
    }

    static TupleList removeCalculatedMembers(TupleList memberList) {
        if (memberList.getArity() == 1) {
            return new UnaryTupleList(FunUtil.removeCalculatedMembers((List<Member>)memberList.slice(0)));
        }
        TupleList clone = memberList.cloneList(memberList.size());
        block0: for (List members : memberList) {
            for (Member member : members) {
                if (!member.isCalculated() || member.isParentChildPhysicalMember()) continue;
                continue block0;
            }
            clone.add(members);
        }
        return clone;
    }

    public static boolean isAncestorOf(Member m0, Member m1, boolean strict) {
        if (strict) {
            if (m1 == null) {
                return false;
            }
            m1 = m1.getParentMember();
        }
        while (m1 != null) {
            if (m1.equals(m0)) {
                return true;
            }
            m1 = m1.getParentMember();
        }
        return false;
    }

    public static int compareValues(double d1, double d2) {
        if (Double.isNaN(d1)) {
            if (d2 == Double.POSITIVE_INFINITY) {
                return -1;
            }
            if (Double.isNaN(d2)) {
                return 0;
            }
            return 1;
        }
        if (Double.isNaN(d2)) {
            if (d1 == Double.POSITIVE_INFINITY) {
                return 1;
            }
            return -1;
        }
        if (d1 == d2) {
            return 0;
        }
        if (d1 == 1.2345E-8) {
            if (d2 == Double.NEGATIVE_INFINITY) {
                return 1;
            }
            return -1;
        }
        if (d2 == 1.2345E-8) {
            if (d1 == Double.NEGATIVE_INFINITY) {
                return -1;
            }
            return 1;
        }
        if (d1 < d2) {
            return -1;
        }
        return 1;
    }

    public static int compareValues(Object value0, Object value1) {
        if (value0 == value1) {
            return 0;
        }
        if (value0 == null) {
            return -1;
        }
        if (value1 == null) {
            return 1;
        }
        if (value0 == RolapUtil.valueNotReadyException) {
            return -1;
        }
        if (value1 == RolapUtil.valueNotReadyException) {
            return 1;
        }
        if (value0 == Util.nullValue) {
            return -1;
        }
        if (value1 == Util.nullValue) {
            return 1;
        }
        if (value0 instanceof String) {
            return ((String)value0).compareToIgnoreCase((String)value1);
        }
        if (value0 instanceof Number) {
            return FunUtil.compareValues(((Number)value0).doubleValue(), ((Number)value1).doubleValue());
        }
        if (value0 instanceof Date) {
            return ((Date)value0).compareTo((Date)value1);
        }
        if (value0 instanceof OrderKey) {
            return ((OrderKey)value0).compareTo(value1);
        }
        throw Util.newInternal("cannot compare " + value0);
    }

    static void toPercent(TupleList members, Map<List<Member>, Object> mapMemberToValue) {
        Object o;
        List key;
        int i;
        double total = 0.0;
        int memberCount = members.size();
        for (i = 0; i < memberCount; ++i) {
            key = (List)members.get(i);
            o = mapMemberToValue.get(key);
            if (!(o instanceof Number)) continue;
            total += ((Number)o).doubleValue();
        }
        for (i = 0; i < memberCount; ++i) {
            key = (List)members.get(i);
            o = mapMemberToValue.get(key);
            if (!(o instanceof Number)) continue;
            double d = ((Number)o).doubleValue();
            mapMemberToValue.put(key, d / total * 100.0);
        }
    }

    public static Syntax decodeSyntacticType(String flags) {
        char c = flags.charAt(0);
        switch (c) {
            case 'p': {
                return Syntax.Property;
            }
            case 'f': {
                return Syntax.Function;
            }
            case 'm': {
                return Syntax.Method;
            }
            case 'i': {
                return Syntax.Infix;
            }
            case 'P': {
                return Syntax.Prefix;
            }
            case 'Q': {
                return Syntax.Postfix;
            }
            case 'I': {
                return Syntax.Internal;
            }
        }
        throw FunUtil.newInternal("unknown syntax code '" + c + "' in string '" + flags + "'");
    }

    public static int decodeReturnCategory(String flags) {
        int returnCategory = FunUtil.decodeCategory(flags, 1);
        if ((returnCategory & 0x1F) != returnCategory) {
            throw FunUtil.newInternal("bad return code flag in flags '" + flags + "'");
        }
        return returnCategory;
    }

    public static int decodeCategory(String flags, int offset) {
        char c = flags.charAt(offset);
        switch (c) {
            case 'a': {
                return 1;
            }
            case 'd': {
                return 2;
            }
            case 'h': {
                return 3;
            }
            case 'l': {
                return 4;
            }
            case 'b': {
                return 5;
            }
            case 'm': {
                return 6;
            }
            case 'N': {
                return 71;
            }
            case 'n': {
                return 7;
            }
            case 'I': {
                return 79;
            }
            case 'i': {
                return 15;
            }
            case 'x': {
                return 8;
            }
            case '#': {
                return 73;
            }
            case 'S': {
                return 9;
            }
            case 't': {
                return 10;
            }
            case 'v': {
                return 13;
            }
            case 'y': {
                return 11;
            }
            case 'U': {
                return 16;
            }
            case 'e': {
                return 17;
            }
            case 'D': {
                return 18;
            }
        }
        throw FunUtil.newInternal("unknown type code '" + c + "' in string '" + flags + "'");
    }

    public static int[] decodeParameterCategories(String flags) {
        int[] parameterCategories = new int[flags.length() - 2];
        for (int i = 0; i < parameterCategories.length; ++i) {
            parameterCategories[i] = FunUtil.decodeCategory(flags, i + 2);
        }
        return parameterCategories;
    }

    public static Double box(double d) {
        return d == 1.2345E-8 ? null : Double.valueOf(d);
    }

    public static Integer box(int n) {
        return n == -2147483647 ? null : Integer.valueOf(n);
    }

    static double percentile(Evaluator evaluator, TupleList members, Calc exp, double p) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double[] asArray = new double[sw.v.size()];
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = (Double)sw.v.get(i);
        }
        Arrays.sort(asArray);
        int length = asArray.length;
        if (length == 1) {
            return asArray[0];
        }
        if (p <= 0.0) {
            return asArray[0];
        }
        if (p >= 1.0) {
            return asArray[length - 1];
        }
        if (length == 1) {
            return asArray[0];
        }
        if (p == 0.5) {
            if ((length & 1) == 1) {
                return asArray[length >> 1];
            }
            return (asArray[(length >> 1) - 1] + asArray[length >> 1]) / 2.0;
        }
        double rank = (double)(length - 1) * p + 1.0;
        int integerPart = (int)Math.floor(rank);
        assert (integerPart >= 1);
        double decimalPart = rank - (double)integerPart;
        assert (decimalPart >= 0.0);
        assert (decimalPart <= 1.0);
        int indexForFormula = integerPart - 1;
        double percentile = asArray[indexForFormula] + (asArray[indexForFormula + 1] - asArray[indexForFormula]) * decimalPart;
        return percentile;
    }

    protected static double quartile(Evaluator evaluator, TupleList members, Calc exp, int range) {
        assert (range >= 1 && range <= 3);
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double[] asArray = new double[sw.v.size()];
        for (int i = 0; i < asArray.length; ++i) {
            asArray[i] = (Double)sw.v.get(i);
        }
        Arrays.sort(asArray);
        double dm = 0.25 * (double)asArray.length * (double)range;
        int median = (int)Math.floor(dm);
        return dm == (double)median && median < asArray.length - 1 ? (asArray[median] + asArray[median + 1]) / 2.0 : asArray[median];
    }

    public static Object min(Evaluator evaluator, TupleList members, Calc calc) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, calc);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        int size = sw.v.size();
        if (size == 0) {
            return Util.nullValue;
        }
        Double min = ((Number)sw.v.get(0)).doubleValue();
        for (int i = 1; i < size; ++i) {
            Double iValue = ((Number)sw.v.get(i)).doubleValue();
            if (!(iValue < min)) continue;
            min = iValue;
        }
        return min;
    }

    public static Object max(Evaluator evaluator, TupleList members, Calc exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        int size = sw.v.size();
        if (size == 0) {
            return Util.nullValue;
        }
        Double max = ((Number)sw.v.get(0)).doubleValue();
        for (int i = 1; i < size; ++i) {
            Double iValue = ((Number)sw.v.get(i)).doubleValue();
            if (!(iValue > max)) continue;
            max = iValue;
        }
        return max;
    }

    static Object var(Evaluator evaluator, TupleList members, Calc exp, boolean biased) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        return FunUtil._var(sw, biased);
    }

    private static Object _var(SetWrapper sw, boolean biased) {
        if (sw.errorCount > 0) {
            return new Double(Double.NaN);
        }
        if (sw.v.size() == 0) {
            return Util.nullValue;
        }
        double stdev = 0.0;
        double avg = FunUtil._avg(sw);
        for (int i = 0; i < sw.v.size(); ++i) {
            stdev += Math.pow(((Number)sw.v.get(i)).doubleValue() - avg, 2.0);
        }
        int n = sw.v.size();
        if (!biased) {
            --n;
        }
        return new Double(stdev / (double)n);
    }

    static double correlation(Evaluator evaluator, TupleList memberList, Calc exp1, Calc exp2) {
        SetWrapper sw1 = FunUtil.evaluateSet(evaluator, (TupleIterable)memberList, exp1);
        SetWrapper sw2 = FunUtil.evaluateSet(evaluator, (TupleIterable)memberList, exp2);
        Object covar = FunUtil._covariance(sw1, sw2, false);
        Object var1 = FunUtil._var(sw1, false);
        Object var2 = FunUtil._var(sw2, false);
        return ((Number)covar).doubleValue() / Math.sqrt(((Number)var1).doubleValue() * ((Number)var2).doubleValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object covariance(Evaluator evaluator, TupleList members, Calc exp1, Calc exp2, boolean biased) {
        SetWrapper sw2;
        SetWrapper sw1;
        int savepoint = evaluator.savepoint();
        try {
            sw1 = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp1);
        }
        finally {
            evaluator.restore(savepoint);
        }
        try {
            sw2 = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp2);
        }
        finally {
            evaluator.restore(savepoint);
        }
        return FunUtil._covariance(sw1, sw2, biased);
    }

    private static Object _covariance(SetWrapper sw1, SetWrapper sw2, boolean biased) {
        if (sw1.v.size() != sw2.v.size()) {
            return Util.nullValue;
        }
        double avg1 = FunUtil._avg(sw1);
        double avg2 = FunUtil._avg(sw2);
        double covar = 0.0;
        for (int i = 0; i < sw1.v.size(); ++i) {
            double diff1 = ((Number)sw1.v.get(i)).doubleValue() - avg1;
            double diff2 = ((Number)sw2.v.get(i)).doubleValue() - avg2;
            covar += diff1 * diff2;
        }
        int n = sw1.v.size();
        if (!biased) {
            --n;
        }
        return new Double(covar / (double)n);
    }

    static Object stdev(Evaluator evaluator, TupleList members, Calc exp, boolean biased) {
        Object o = FunUtil.var(evaluator, members, exp, biased);
        return o instanceof Double ? new Double(Math.sqrt(((Number)o).doubleValue())) : o;
    }

    public static Object avg(Evaluator evaluator, TupleList members, Calc calc) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, calc);
        return sw.errorCount > 0 ? new Double(Double.NaN) : (sw.v.size() == 0 ? Util.nullValue : new Double(FunUtil._avg(sw)));
    }

    private static double _avg(SetWrapper sw) {
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Number)sw.v.get(i)).doubleValue();
        }
        return sum / (double)sw.v.size();
    }

    public static Object sum(Evaluator evaluator, TupleList members, Calc exp) {
        double d = FunUtil.sumDouble(evaluator, members, exp);
        return d == 1.2345E-8 ? Util.nullValue : new Double(d);
    }

    public static double sumDouble(Evaluator evaluator, TupleList members, Calc exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, (TupleIterable)members, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Number)sw.v.get(i)).doubleValue();
        }
        return sum;
    }

    public static double sumDouble(Evaluator evaluator, TupleIterable iterable, Calc exp) {
        SetWrapper sw = FunUtil.evaluateSet(evaluator, iterable, exp);
        if (sw.errorCount > 0) {
            return Double.NaN;
        }
        if (sw.v.size() == 0) {
            return 1.2345E-8;
        }
        double sum = 0.0;
        for (int i = 0; i < sw.v.size(); ++i) {
            sum += ((Number)sw.v.get(i)).doubleValue();
        }
        return sum;
    }

    public static int count(Evaluator evaluator, TupleIterable iterable, boolean includeEmpty) {
        if (iterable == null) {
            return 0;
        }
        if (includeEmpty) {
            if (iterable instanceof TupleList) {
                return ((TupleList)iterable).size();
            }
            int retval = 0;
            TupleCursor cursor = iterable.tupleCursor();
            while (cursor.forward()) {
                ++retval;
            }
            return retval;
        }
        int retval = 0;
        TupleCursor cursor = iterable.tupleCursor();
        while (cursor.forward()) {
            cursor.setContext(evaluator);
            if (evaluator.currentIsEmpty()) continue;
            ++retval;
        }
        return retval;
    }

    static SetWrapper evaluateSet(Evaluator evaluator, TupleIterable members, Calc calc) {
        assert (members != null);
        assert (calc != null);
        assert (calc.getType() instanceof ScalarType);
        SetWrapper retval = new SetWrapper();
        TupleCursor cursor = members.tupleCursor();
        int currentIteration = 0;
        Execution execution = evaluator.getQuery().getStatement().getCurrentExecution();
        while (cursor.forward()) {
            CancellationChecker.checkCancelOrTimeout(currentIteration++, execution);
            cursor.setContext(evaluator);
            Object o = calc.evaluate(evaluator);
            if (o == null || o == Util.nullValue) {
                ++retval.nullCount;
                continue;
            }
            if (o == RolapUtil.valueNotReadyException) {
                ++retval.errorCount;
                continue;
            }
            if (o instanceof Number) {
                retval.v.add(((Number)o).doubleValue());
                continue;
            }
            retval.v.add(o);
        }
        return retval;
    }

    static SetWrapper[] evaluateSet(Evaluator evaluator, TupleList list, DoubleCalc[] calcs) {
        Util.assertPrecondition(calcs != null, "calcs != null");
        SetWrapper[] retvals = new SetWrapper[calcs.length];
        for (int i = 0; i < calcs.length; ++i) {
            retvals[i] = new SetWrapper();
        }
        TupleCursor cursor = list.tupleCursor();
        int currentIteration = 0;
        Execution execution = evaluator.getQuery().getStatement().getCurrentExecution();
        while (cursor.forward()) {
            CancellationChecker.checkCancelOrTimeout(currentIteration++, execution);
            cursor.setContext(evaluator);
            for (int i = 0; i < calcs.length; ++i) {
                DoubleCalc calc = calcs[i];
                SetWrapper retval = retvals[i];
                double o = calc.evaluateDouble(evaluator);
                if (o == 1.2345E-8) {
                    ++retval.nullCount;
                    retval.v.add(null);
                    continue;
                }
                retval.v.add(o);
            }
        }
        return retvals;
    }

    static List<Member> periodsToDate(Evaluator evaluator, Level level, Member member) {
        Member m;
        if (member == null) {
            member = evaluator.getContext(level.getHierarchy());
        }
        for (m = member; m != null && m.getLevel() != level; m = m.getParentMember()) {
        }
        ArrayList<Member> members = new ArrayList<Member>();
        if (m != null) {
            SchemaReader reader = evaluator.getSchemaReader();
            m = Util.getFirstDescendantOnLevel(reader, m, member.getLevel());
            reader.getMemberRange(level, m, member, members);
        }
        return members;
    }

    static List<Member> memberRange(Evaluator evaluator, Member startMember, Member endMember) {
        Level level = startMember.getLevel();
        FunUtil.assertTrue(level == endMember.getLevel());
        ArrayList<Member> members = new ArrayList<Member>();
        evaluator.getSchemaReader().getMemberRange(level, startMember, endMember, members);
        if (members.isEmpty()) {
            evaluator.getSchemaReader().getMemberRange(level, endMember, startMember, members);
        }
        return members;
    }

    static Member cousin(SchemaReader schemaReader, Member member, Member ancestorMember) {
        if (ancestorMember.isNull()) {
            return ancestorMember;
        }
        if (member.getHierarchy() != ancestorMember.getHierarchy()) {
            throw MondrianResource.instance().CousinHierarchyMismatch.ex(member.getUniqueName(), ancestorMember.getUniqueName());
        }
        if (member.getLevel().getDepth() < ancestorMember.getLevel().getDepth()) {
            return member.getHierarchy().getNullMember();
        }
        Member cousin = FunUtil.cousin2(schemaReader, member, ancestorMember);
        if (cousin == null) {
            cousin = member.getHierarchy().getNullMember();
        }
        return cousin;
    }

    private static Member cousin2(SchemaReader schemaReader, Member member1, Member member2) {
        if (member1.getLevel() == member2.getLevel()) {
            return member2;
        }
        Member uncle = FunUtil.cousin2(schemaReader, member1.getParentMember(), member2);
        if (uncle == null) {
            return null;
        }
        int ordinal = Util.getMemberOrdinalInParent(schemaReader, member1);
        List<Member> cousins = schemaReader.getMemberChildren(uncle);
        if (cousins.size() <= ordinal) {
            return null;
        }
        return cousins.get(ordinal);
    }

    static Member ancestor(Evaluator evaluator, Member member, int distance, Level targetLevel) {
        if (targetLevel != null && member.getHierarchy() != targetLevel.getHierarchy()) {
            throw MondrianResource.instance().MemberNotInLevelHierarchy.ex(member.getUniqueName(), targetLevel.getUniqueName());
        }
        if (distance == 0) {
            return member;
        }
        if (distance < 0) {
            return member.getHierarchy().getNullMember();
        }
        ArrayList<Member> ancestors = new ArrayList<Member>();
        SchemaReader schemaReader = evaluator.getSchemaReader();
        schemaReader.getMemberAncestors(member, ancestors);
        Member result = member.getHierarchy().getNullMember();
        for (int i = 0; i < ancestors.size(); ++i) {
            Member ancestorMember = (Member)ancestors.get(i);
            if (targetLevel != null) {
                if (ancestorMember.getLevel() != targetLevel) continue;
                if (schemaReader.isVisible(ancestorMember)) {
                    result = ancestorMember;
                    break;
                }
                result = member.getHierarchy().getNullMember();
                break;
            }
            if (!schemaReader.isVisible(ancestorMember) || --distance != 0) continue;
            result = ancestorMember;
            break;
        }
        return result;
    }

    public static int compareHierarchically(Member m1, Member m2, boolean post) {
        Member prev2;
        Member prev1;
        if (FunUtil.equals(m1 = FunUtil.unwrapLimitedRollupMember(m1), m2 = FunUtil.unwrapLimitedRollupMember(m2))) {
            return 0;
        }
        while (true) {
            int depth2;
            int depth1;
            if ((depth1 = m1.getDepth()) < (depth2 = m2.getDepth())) {
                if (!FunUtil.equals(m1, m2 = m2.getParentMember())) continue;
                return post ? 1 : -1;
            }
            if (depth1 > depth2) {
                if (!FunUtil.equals(m1 = m1.getParentMember(), m2)) continue;
                return post ? -1 : 1;
            }
            prev1 = m1;
            prev2 = m2;
            if (FunUtil.equals(m1 = FunUtil.unwrapLimitedRollupMember(m1.getParentMember()), m2 = FunUtil.unwrapLimitedRollupMember(m2.getParentMember()))) break;
        }
        int c = FunUtil.compareSiblingMembers(prev1, prev2);
        assert (c != 0) : "Members " + prev1 + ", " + prev2 + " are not equal, but compare returned 0.";
        return c;
    }

    private static Member unwrapLimitedRollupMember(Member m) {
        if (m instanceof RolapHierarchy.LimitedRollupMember) {
            return ((RolapHierarchy.LimitedRollupMember)m).member;
        }
        return m;
    }

    public static int compareSiblingMembers(Member m1, Member m2) {
        int ordinal2;
        boolean calculated1 = m1.isCalculatedInQuery();
        boolean calculated2 = m2.isCalculatedInQuery();
        if (calculated1) {
            if (!calculated2) {
                return 1;
            }
        } else if (calculated2) {
            return -1;
        }
        Comparable k1 = m1.getOrderKey();
        Comparable k2 = m2.getOrderKey();
        if (k1 != null && k2 != null) {
            return k1.compareTo(k2);
        }
        int ordinal1 = m1.getOrdinal();
        return ordinal1 == (ordinal2 = m2.getOrdinal()) ? m1.compareTo(m2) : (ordinal1 < ordinal2 ? -1 : 1);
    }

    public static boolean tupleContainsNullMember(Member[] tuple) {
        for (Member member : tuple) {
            if (!member.isNull()) continue;
            return true;
        }
        return false;
    }

    public static boolean tupleContainsNullMember(List<Member> tuple) {
        for (Member member : tuple) {
            if (!member.isNull()) continue;
            return true;
        }
        return false;
    }

    public static Member[] makeNullTuple(TupleType tupleType) {
        Type[] elementTypes = tupleType.elementTypes;
        Member[] members = new Member[elementTypes.length];
        for (int i = 0; i < elementTypes.length; ++i) {
            MemberType type = (MemberType)elementTypes[i];
            members[i] = FunUtil.makeNullMember(type);
        }
        return members;
    }

    static Member makeNullMember(MemberType memberType) {
        Hierarchy hierarchy = memberType.getHierarchy();
        if (hierarchy == null) {
            return NullMember;
        }
        return hierarchy.getNullMember();
    }

    public static FunDef resolveFunArgs(Validator validator, FunDef funDef, Exp[] args, Exp[] newArgs, String name, Syntax syntax) {
        for (int i = 0; i < args.length; ++i) {
            newArgs[i] = validator.validate(args[i], false);
        }
        if (funDef == null || validator.alwaysResolveFunDef()) {
            funDef = validator.getDef(newArgs, name, syntax);
        }
        FunUtil.checkNativeCompatible(validator, funDef, newArgs);
        return funDef;
    }

    private static void checkNativeCompatible(Validator validator, FunDef funDef, Exp[] args) {
        int[] paramCategories;
        Query query = validator.getQuery();
        if (!(funDef instanceof SetFunDef) && !(funDef instanceof ParenthesesFunDef) && query != null && query.nativeCrossJoinVirtualCube() && (paramCategories = funDef.getParameterCategories()).length > 0) {
            int cat0 = paramCategories[0];
            Exp arg0 = args[0];
            switch (cat0) {
                case 2: 
                case 3: {
                    if (!(arg0 instanceof DimensionExpr) || !((DimensionExpr)arg0).getDimension().isMeasures() || funDef instanceof HierarchyCurrentMemberFunDef) break;
                    query.setVirtualCubeNonNativeCrossJoin();
                    break;
                }
                case 6: {
                    if (!(arg0 instanceof MemberExpr) || !((MemberExpr)arg0).getMember().isMeasure() || !FunUtil.isMemberOrSet(funDef.getReturnCategory())) break;
                    query.setVirtualCubeNonNativeCrossJoin();
                }
            }
        }
    }

    private static boolean isMemberOrSet(int category) {
        return category == 6 || category == 8;
    }

    static void appendTuple(StringBuilder buf, Member[] members) {
        buf.append("(");
        for (int j = 0; j < members.length; ++j) {
            if (j > 0) {
                buf.append(", ");
            }
            Member member = members[j];
            buf.append(member.getUniqueName());
        }
        buf.append(")");
    }

    static boolean equalTuple(Member[] members0, Member[] members1) {
        int count = members0.length;
        if (count != members1.length) {
            return false;
        }
        block0: for (int i = 0; i < count; ++i) {
            Member member0 = members0[i];
            if (member0.equals(members1[i])) continue;
            for (int j = 0; j < count; ++j) {
                if (i != j && member0.equals(members1[j])) continue block0;
            }
            return false;
        }
        return true;
    }

    static FunDef createDummyFunDef(Resolver resolver, int returnCategory, Exp[] args) {
        int[] argCategories = ExpBase.getTypes(args);
        return new FunDefBase(resolver, returnCategory, argCategories){};
    }

    public static List<Member> getNonEmptyMemberChildren(Evaluator evaluator, Member member) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            return sr.getMemberChildren(member, evaluator);
        }
        return sr.getMemberChildren(member);
    }

    public static Map<Member, Access> getNonEmptyMemberChildrenWithDetails(Evaluator evaluator, Member member) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            return sr.getMemberChildrenWithDetails(member, evaluator);
        }
        return sr.getMemberChildrenWithDetails(member, null);
    }

    static List<Member> getNonEmptyLevelMembers(Evaluator evaluator, Level level, boolean includeCalcMembers) {
        SchemaReader sr = evaluator.getSchemaReader();
        if (evaluator.isNonEmpty()) {
            List<Member> members = sr.getLevelMembers(level, evaluator);
            if (includeCalcMembers) {
                return FunUtil.addLevelCalculatedMembers(sr, level, members);
            }
            return members;
        }
        return sr.getLevelMembers(level, includeCalcMembers);
    }

    static TupleList levelMembers(Level level, Evaluator evaluator, boolean includeCalcMembers) {
        List<Member> memberList = FunUtil.getNonEmptyLevelMembers(evaluator, level, includeCalcMembers);
        if (!includeCalcMembers) {
            memberList = FunUtil.removeCalculatedMembers(memberList);
        }
        ArrayList<Member> memberListClone = new ArrayList<Member>(memberList);
        UnaryTupleList tupleList = new UnaryTupleList(memberListClone);
        return Sorter.hierarchizeTupleList(tupleList, false);
    }

    static TupleList hierarchyMembers(Hierarchy hierarchy, Evaluator evaluator, boolean includeCalcMembers) {
        UnaryTupleList tupleList = new UnaryTupleList();
        Iterable memberList = tupleList.slice(0);
        if (evaluator.isNonEmpty()) {
            for (Level level : hierarchy.getLevels()) {
                List<Member> members = FunUtil.getNonEmptyLevelMembers(evaluator, level, includeCalcMembers);
                memberList.addAll(members);
            }
        } else {
            List<Member> memberList1 = FunUtil.addMembers(evaluator.getSchemaReader(), new ConcatenableList<Member>(), hierarchy);
            if (includeCalcMembers) {
                memberList.addAll(memberList1);
            } else {
                for (Member member1 : memberList1) {
                    if (member1.isCalculated() && !member1.isParentChildPhysicalMember()) continue;
                    memberList.add(member1);
                }
            }
        }
        return Sorter.hierarchizeTupleList(tupleList, false);
    }

    static TupleList parseTupleList(Evaluator evaluator, String string, List<Hierarchy> hierarchies) {
        IdentifierParser.TupleListBuilder builder = new IdentifierParser.TupleListBuilder(evaluator.getSchemaReader(), evaluator.getCube(), hierarchies);
        IdentifierParser.parseTupleList((IdentifierParser.Builder)builder, (String)string);
        return builder.tupleList;
    }

    private static int parseTuple(Evaluator evaluator, String string, int i, final Member[] members, List<Hierarchy> hierarchies) {
        IdentifierParser.TupleBuilder builder = new IdentifierParser.TupleBuilder(evaluator.getSchemaReader(), evaluator.getCube(), hierarchies){

            @Override
            public void tupleComplete() {
                super.tupleComplete();
                this.memberList.toArray(members);
            }
        };
        return IdentifierParser.parseTuple((IdentifierParser.Builder)builder, (String)string, (int)i);
    }

    static Member[] parseTuple(Evaluator evaluator, String string, List<Hierarchy> hierarchies) {
        Member[] members = new Member[hierarchies.size()];
        int i = FunUtil.parseTuple(evaluator, string, 0, members, hierarchies);
        if (FunUtil.tupleContainsNullMember(members)) {
            return null;
        }
        return members;
    }

    static List<Member> parseMemberList(Evaluator evaluator, String string, Hierarchy hierarchy) {
        IdentifierParser.MemberListBuilder builder = new IdentifierParser.MemberListBuilder(evaluator.getSchemaReader(), evaluator.getCube(), hierarchy);
        IdentifierParser.parseMemberList((IdentifierParser.Builder)builder, (String)string);
        return builder.memberList;
    }

    private static int parseMember(Evaluator evaluator, String string, int i, final Member[] members, Hierarchy hierarchy) {
        IdentifierParser.MemberListBuilder builder = new IdentifierParser.MemberListBuilder(evaluator.getSchemaReader(), evaluator.getCube(), hierarchy){

            @Override
            public void memberComplete() {
                members[0] = this.resolveMember((Hierarchy)this.hierarchyList.get(0));
                this.segmentList.clear();
            }
        };
        return IdentifierParser.parseMember((IdentifierParser.Builder)builder, (String)string, (int)i);
    }

    static Member parseMember(Evaluator evaluator, String string, Hierarchy hierarchy) {
        Member[] members = new Member[]{null};
        int i = FunUtil.parseMember(evaluator, string, 0, members, hierarchy);
        Member member = members[0];
        if (member == null) {
            throw MondrianResource.instance().MdxChildObjectNotFound.ex(string, evaluator.getCube().getQualifiedName());
        }
        return member;
    }

    public static boolean worthCaching(Exp exp) {
        ResolvedFunCall call;
        if (exp instanceof Literal) {
            return false;
        }
        if (exp instanceof MemberExpr || exp instanceof LevelExpr || exp instanceof HierarchyExpr || exp instanceof DimensionExpr) {
            return false;
        }
        if (exp instanceof ResolvedFunCall && (call = (ResolvedFunCall)exp).getFunDef() instanceof SetFunDef) {
            for (Exp setArg : call.getArgs()) {
                if (!FunUtil.worthCaching(setArg)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static boolean existsInTuple(List<Member> leftTuple, List<Member> rightTuple, List<Hierarchy> leftHierarchies, List<Hierarchy> rightHierarchies, Evaluator eval) {
        ArrayList<Member> checkedMembers = new ArrayList<Member>();
        for (Member leftMember : leftTuple) {
            Member rightMember = FunUtil.getCorrespondingMember(leftMember, rightTuple, rightHierarchies, eval);
            checkedMembers.add(rightMember);
            if (leftMember.isOnSameHierarchyChain(rightMember)) continue;
            return false;
        }
        for (Member rightMember : rightTuple) {
            Member leftMember;
            if (checkedMembers.contains(rightMember) || (leftMember = FunUtil.getCorrespondingMember(rightMember, leftTuple, leftHierarchies, eval)).isOnSameHierarchyChain(rightMember)) continue;
            return false;
        }
        return true;
    }

    private static boolean isOnSameHierarchyChain(Member mA, Member mB) {
        return FunUtil.isAncestorOf(mA, mB, false) || FunUtil.isAncestorOf(mB, mA, false);
    }

    private static Member getCorrespondingMember(Member member, List<Member> tuple, List<Hierarchy> tupleHierarchies, Evaluator eval) {
        assert (tuple.size() == tupleHierarchies.size());
        int dimPos = tupleHierarchies.indexOf(member.getHierarchy());
        if (dimPos >= 0) {
            return tuple.get(dimPos);
        }
        if (eval != null) {
            return eval.getContext(member.getHierarchy());
        }
        return member.getHierarchy().getDefaultMember();
    }

    private static class NullMember
    implements Member {
        private NullMember() {
        }

        @Override
        public Member getParentMember() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Level getLevel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hierarchy getHierarchy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParentUniqueName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Member.MemberType getMemberType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isParentChildLeaf() {
            return false;
        }

        @Override
        public boolean isParentChildPhysicalMember() {
            return false;
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAll() {
            return false;
        }

        @Override
        public boolean isMeasure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public boolean isChildOrEqualTo(Member member) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCalculated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEvaluated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getSolveOrder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Exp getExpression() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Member> getAncestorMembers() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCalculatedInQuery() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getPropertyValue(String propertyName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getPropertyValue(String propertyName, boolean matchCase) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPropertyFormattedValue(String propertyName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setProperty(String name, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Property[] getProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getOrdinal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Comparable getOrderKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHidden() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDepth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Member getDataMember() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUniqueName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOnSameHierarchyChain(Member otherMember) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getQualifiedName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCaption() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getLocalized(OlapElement.LocalizedProperty prop, Locale locale) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isVisible() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Dimension getDimension() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Annotation> getAnnotationMap() {
            throw new UnsupportedOperationException();
        }

        public int compareTo(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }
    }

    public static class DescendingValueComparator
    implements Comparator {
        static final DescendingValueComparator instance = new DescendingValueComparator();

        public int compare(Object o1, Object o2) {
            return -FunUtil.compareValues(o1, o2);
        }
    }

    static class SetWrapper {
        List v = new ArrayList();
        public int errorCount = 0;
        public int nullCount = 0;

        SetWrapper() {
        }
    }
}

