/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.fun.FunDefBase;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eigenbase.util.property.StringProperty;

public class HierarchyCurrentMemberFunDef
extends FunDefBase {
    private static final Logger LOGGER = LogManager.getLogger(HierarchyCurrentMemberFunDef.class);
    static final HierarchyCurrentMemberFunDef instance = new HierarchyCurrentMemberFunDef();

    private HierarchyCurrentMemberFunDef() {
        super("CurrentMember", "Returns the current member along a hierarchy during an iteration.", "pmh");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
        Hierarchy hierarchy = hierarchyCalc.getType().getHierarchy();
        if (hierarchy != null) {
            return new FixedCalcImpl((Exp)call, hierarchy);
        }
        return new CalcImpl((Exp)call, hierarchyCalc);
    }

    private static void validateSlicerMembers(Hierarchy hierarchy, Evaluator evaluator) {
        if (evaluator instanceof RolapEvaluator) {
            StringProperty alertProperty = MondrianProperties.instance().CurrentMemberWithCompoundSlicerAlert;
            String alertValue = alertProperty.get();
            if (alertValue.equalsIgnoreCase(Level.OFF.toString())) {
                return;
            }
            RolapEvaluator rev = (RolapEvaluator)evaluator;
            Map<Hierarchy, Set<Member>> map = rev.getSlicerMembersByHierarchy();
            Set<Member> members = map.get(hierarchy);
            if (members != null && members.size() > 1) {
                MondrianException exception = MondrianResource.instance().CurrentMemberWithCompoundSlicer.ex(hierarchy.getUniqueName());
                if (alertValue.equalsIgnoreCase(Level.WARN.toString())) {
                    LOGGER.warn(exception.getMessage());
                } else if (alertValue.equalsIgnoreCase(Level.ERROR.toString())) {
                    throw MondrianResource.instance().CurrentMemberWithCompoundSlicer.ex(hierarchy.getUniqueName());
                }
            }
        }
    }

    public static class FixedCalcImpl
    extends AbstractMemberCalc {
        private final RolapHierarchy hierarchy;

        public FixedCalcImpl(Exp exp, Hierarchy hierarchy) {
            super(exp, new Calc[0]);
            assert (hierarchy != null);
            this.hierarchy = (RolapHierarchy)hierarchy;
        }

        @Override
        protected String getName() {
            return "CurrentMemberFixed";
        }

        @Override
        public Member evaluateMember(Evaluator evaluator) {
            HierarchyCurrentMemberFunDef.validateSlicerMembers(this.hierarchy, evaluator);
            return evaluator.getContext(this.hierarchy);
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return this.hierarchy == hierarchy;
        }

        @Override
        public void collectArguments(Map<String, Object> arguments) {
            arguments.put("hierarchy", this.hierarchy);
            super.collectArguments(arguments);
        }
    }

    public static class CalcImpl
    extends AbstractMemberCalc {
        private final HierarchyCalc hierarchyCalc;

        public CalcImpl(Exp exp, HierarchyCalc hierarchyCalc) {
            super(exp, new Calc[]{hierarchyCalc});
            this.hierarchyCalc = hierarchyCalc;
        }

        @Override
        protected String getName() {
            return "CurrentMember";
        }

        @Override
        public Member evaluateMember(Evaluator evaluator) {
            Hierarchy hierarchy = this.hierarchyCalc.evaluateHierarchy(evaluator);
            HierarchyCurrentMemberFunDef.validateSlicerMembers(hierarchy, evaluator);
            return evaluator.getContext(hierarchy);
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return this.hierarchyCalc.getType().usesHierarchy(hierarchy, false);
        }
    }
}

