/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Util;
import mondrian.olap.fun.MultiResolver;

public class ReflectiveMultiResolver
extends MultiResolver {
    private final Constructor constructor;
    private final String[] reservedWords;

    public ReflectiveMultiResolver(String name, String signature, String description, String[] signatures, Class clazz) {
        this(name, signature, description, signatures, clazz, null);
    }

    public ReflectiveMultiResolver(String name, String signature, String description, String[] signatures, Class clazz, String[] reservedWords) {
        super(name, signature, description, signatures);
        try {
            this.constructor = clazz.getConstructor(FunDef.class);
        }
        catch (NoSuchMethodException e) {
            throw Util.newInternal(e, "Error while registering resolver class " + clazz);
        }
        this.reservedWords = reservedWords;
    }

    @Override
    protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
        try {
            return (FunDef)this.constructor.newInstance(dummyFunDef);
        }
        catch (InstantiationException e) {
            throw Util.newInternal(e, "Error while instantiating FunDef '" + this.getSignature() + "'");
        }
        catch (IllegalAccessException e) {
            throw Util.newInternal(e, "Error while instantiating FunDef '" + this.getSignature() + "'");
        }
        catch (InvocationTargetException e) {
            throw Util.newInternal(e, "Error while instantiating FunDef '" + this.getSignature() + "'");
        }
    }

    @Override
    public String[] getReservedWords() {
        if (this.reservedWords != null) {
            return this.reservedWords;
        }
        return super.getReservedWords();
    }
}

