/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;

class XtdFunDef
extends FunDefBase {
    private final LevelType levelType;
    static final ResolverImpl MtdResolver = new ResolverImpl("Mtd", "Mtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Month.", new String[]{"fx", "fxm"}, LevelType.TimeMonths);
    static final ResolverImpl QtdResolver = new ResolverImpl("Qtd", "Qtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Quarter.", new String[]{"fx", "fxm"}, LevelType.TimeQuarters);
    static final ResolverImpl WtdResolver = new ResolverImpl("Wtd", "Wtd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Week.", new String[]{"fx", "fxm"}, LevelType.TimeWeeks);
    static final ResolverImpl YtdResolver = new ResolverImpl("Ytd", "Ytd([<Member>])", "A shortcut function for the PeriodsToDate function that specifies the level to be Year.", new String[]{"fx", "fxm"}, LevelType.TimeYears);
    private static final String TIMING_NAME = XtdFunDef.class.getSimpleName();

    public XtdFunDef(FunDef dummyFunDef, LevelType levelType) {
        super(dummyFunDef);
        this.levelType = levelType;
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 0) {
            RolapHierarchy defaultTimeHierarchy = ((RolapCube)validator.getQuery().getCube()).getTimeHierarchy(this.getName());
            return new SetType(MemberType.forHierarchy(defaultTimeHierarchy));
        }
        Type type = args[0].getType();
        if (type.getDimension().getDimensionType() != DimensionType.TimeDimension) {
            throw MondrianResource.instance().TimeArgNeeded.ex(this.getName());
        }
        return super.getResultType(validator, args);
    }

    private Level getLevel(Evaluator evaluator) {
        switch (this.levelType) {
            case TimeYears: {
                return evaluator.getCube().getYearLevel();
            }
            case TimeQuarters: {
                return evaluator.getCube().getQuarterLevel();
            }
            case TimeMonths: {
                return evaluator.getCube().getMonthLevel();
            }
            case TimeWeeks: {
                return evaluator.getCube().getWeekLevel();
            }
            case TimeDays: {
                return evaluator.getCube().getWeekLevel();
            }
        }
        throw Util.badValue(this.levelType);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final Level level = this.getLevel(compiler.getEvaluator());
        switch (call.getArgCount()) {
            case 0: {
                return new AbstractListCalc(call, new Calc[0]){

                    @Override
                    public TupleList evaluateList(Evaluator evaluator) {
                        evaluator.getTiming().markStart(TIMING_NAME);
                        try {
                            UnaryTupleList unaryTupleList = new UnaryTupleList(FunUtil.periodsToDate(evaluator, level, null));
                            return unaryTupleList;
                        }
                        finally {
                            evaluator.getTiming().markEnd(TIMING_NAME);
                        }
                    }

                    @Override
                    public boolean dependsOn(Hierarchy hierarchy) {
                        return hierarchy.getDimension().getDimensionType() == DimensionType.TimeDimension;
                    }
                };
            }
        }
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new AbstractListCalc(call, new Calc[]{memberCalc}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                evaluator.getTiming().markStart(TIMING_NAME);
                try {
                    UnaryTupleList unaryTupleList = new UnaryTupleList(FunUtil.periodsToDate(evaluator, level, memberCalc.evaluateMember(evaluator)));
                    return unaryTupleList;
                }
                finally {
                    evaluator.getTiming().markEnd(TIMING_NAME);
                }
            }
        };
    }

    private static class ResolverImpl
    extends MultiResolver {
        private final LevelType levelType;

        public ResolverImpl(String name, String signature, String description, String[] signatures, LevelType levelType) {
            super(name, signature, description, signatures);
            this.levelType = levelType;
        }

        @Override
        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new XtdFunDef(dummyFunDef, this.levelType);
        }
    }
}

