/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.util.ByteString;
import mondrian.util.StringKey;

class ConnectionKey
extends StringKey {
    private ConnectionKey(String s) {
        super(s);
    }

    static ConnectionKey create(String connectionUuidStr, DataSource dataSource, String catalogUrl, String connectionKey, String jdbcUser, String dataSourceStr) {
        String s;
        if (connectionUuidStr != null && connectionUuidStr.length() != 0) {
            s = connectionUuidStr;
        } else {
            StringBuilder buf = new StringBuilder(100);
            if (dataSource != null) {
                ConnectionKey.attributeValue(buf, "jvm", Util.JVM_INSTANCE_UUID);
                ConnectionKey.attributeValue(buf, "dataSource", System.identityHashCode(dataSource));
            } else {
                ConnectionKey.attributeValue(buf, "connectionKey", connectionKey);
                ConnectionKey.attributeValue(buf, "catalogUrl", catalogUrl);
                ConnectionKey.attributeValue(buf, "jdbcUser", jdbcUser);
                ConnectionKey.attributeValue(buf, "dataSourceStr", dataSourceStr);
            }
            s = new ByteString(Util.digestMd5(buf.toString())).toString();
        }
        return new ConnectionKey(s);
    }

    static void attributeValue(StringBuilder buf, String attribute, Object value) {
        if (value == null) {
            return;
        }
        if (buf.length() > 0) {
            buf.append(';');
        }
        buf.append(attribute).append('=');
        Util.quoteForMdx(buf, value.toString());
    }
}

