/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.sql.SqlQuery;

public class MemberTuplePredicate
implements StarPredicate {
    private final Bound[] bounds;
    private final List<RolapStar.Column> columnList;
    private BitKey columnBitKey;

    public MemberTuplePredicate(RolapCube baseCube, RolapMember lower, boolean lowerStrict, RolapMember upper, boolean upperStrict) {
        this.columnBitKey = null;
        this.columnList = this.computeColumnList(lower != null ? lower : upper, baseCube);
        if (lower == null) {
            assert (upper != null);
            this.bounds = new Bound[]{new Bound(upper, upperStrict ? RelOp.LT : RelOp.LE)};
        } else {
            this.bounds = upper == null ? new Bound[]{new Bound(lower, lowerStrict ? RelOp.GT : RelOp.GE)} : new Bound[]{new Bound(lower, lowerStrict ? RelOp.GT : RelOp.GE), new Bound(upper, upperStrict ? RelOp.LT : RelOp.LE)};
        }
    }

    public MemberTuplePredicate(RolapCube baseCube, RolapCubeMember member) {
        this.columnList = this.computeColumnList(member, baseCube);
        this.bounds = new Bound[]{new Bound(member, RelOp.EQ)};
    }

    public int hashCode() {
        return this.columnList.hashCode() * 31 + Arrays.hashCode(this.bounds) * 31;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MemberTuplePredicate) {
            MemberTuplePredicate that = (MemberTuplePredicate)obj;
            return this.columnList.equals(that.columnList) && Arrays.equals(this.bounds, that.bounds);
        }
        return false;
    }

    private List<RolapStar.Column> computeColumnList(RolapMember member, RolapCube baseCube) {
        ArrayList<RolapStar.Column> columnList = new ArrayList<RolapStar.Column>();
        while (true) {
            RolapLevel level = member.getLevel();
            RolapStar.Column column = null;
            if (level instanceof RolapCubeLevel) {
                column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
            } else {
                new Exception().printStackTrace();
            }
            if (this.columnBitKey == null) {
                this.columnBitKey = BitKey.Factory.makeBitKey(column.getStar().getColumnCount());
                this.columnBitKey.clear();
            }
            this.columnBitKey.set(column.getBitPosition());
            columnList.add(0, column);
            if (level.isUnique()) {
                return columnList;
            }
            member = member.getParentMember();
        }
    }

    @Override
    public List<RolapStar.Column> getConstrainedColumnList() {
        return this.columnList;
    }

    @Override
    public BitKey getConstrainedColumnBitKey() {
        return this.columnBitKey;
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StarPredicate minus(StarPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StarPredicate or(StarPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StarPredicate and(StarPredicate predicate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        for (Bound bound : this.bounds) {
            block7: for (int k = 0; k < bound.values.length; ++k) {
                Object value = valueList.get(k);
                if (value == WILDCARD) {
                    return false;
                }
                Object boundValue = bound.values[k];
                RelOp relOp = bound.relOps[k];
                int c = Util.compareKey(value, boundValue);
                switch (relOp) {
                    case GT: {
                        if (c > 0) continue block7;
                        return false;
                    }
                    case GE: {
                        if (c > 0) {
                            return true;
                        }
                        if (c == 0) continue block7;
                        return false;
                    }
                    case LT: {
                        if (c < 0) continue block7;
                        return false;
                    }
                    case LE: {
                        if (c < 0) {
                            return true;
                        }
                        if (c == 0) continue block7;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    @Override
    public void describe(StringBuilder buf) {
        int k = 0;
        for (Bound bound : this.bounds) {
            if (k++ > 0) {
                buf.append(" AND ");
            }
            buf.append(bound.relOps[bound.relOps.length - 1].getOp());
            buf.append(' ');
            buf.append(bound.member);
        }
    }

    @Override
    public void toSql(SqlQuery sqlQuery, StringBuilder buf) {
        throw Util.needToImplement(this);
    }

    private static class Bound {
        private final RolapMember member;
        private final Object[] values;
        private final RelOp[] relOps;

        Bound(RolapMember member, RelOp relOp) {
            this.member = member;
            ArrayList<Object> valueList = new ArrayList<Object>();
            ArrayList<RelOp> relOpList = new ArrayList<RelOp>();
            while (true) {
                valueList.add(0, member.getKey());
                relOpList.add(0, relOp);
                if (member.getLevel().isUnique()) break;
                member = member.getParentMember();
                relOp = relOp.desctrict();
            }
            this.values = valueList.toArray(new Object[valueList.size()]);
            this.relOps = relOpList.toArray(new RelOp[relOpList.size()]);
        }

        public int hashCode() {
            int h = this.member.hashCode();
            h = h * 31 + Arrays.hashCode(this.values);
            h = h * 31 + Arrays.hashCode((Object[])this.relOps);
            return h;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Bound) {
                Bound that = (Bound)obj;
                return this.member.equals(that.member) && Arrays.equals(this.values, that.values) && Arrays.equals((Object[])this.relOps, (Object[])that.relOps);
            }
            return false;
        }
    }

    private static enum RelOp {
        LT("<"),
        LE("<="),
        GT(">"),
        GE(">="),
        EQ("=");

        private final String op;

        private RelOp(String op) {
            this.op = op;
        }

        String getOp() {
            return this.op;
        }

        public RelOp desctrict() {
            switch (this) {
                case GT: {
                    return GE;
                }
                case LT: {
                    return LE;
                }
            }
            return this;
        }
    }
}

