/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import mondrian.olap.CacheControl;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.CacheControlImpl;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SchemaKey;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.SegmentBuilder;
import mondrian.rolap.agg.SegmentCacheWorker;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.cache.MemorySegmentCache;
import mondrian.rolap.cache.SegmentCacheIndex;
import mondrian.rolap.cache.SegmentCacheIndexImpl;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.monitor.CellCacheEvent;
import mondrian.server.monitor.CellCacheSegmentCreateEvent;
import mondrian.server.monitor.CellCacheSegmentDeleteEvent;
import mondrian.server.monitor.Monitor;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentCache;
import mondrian.spi.SegmentColumn;
import mondrian.spi.SegmentHeader;
import mondrian.util.BlockingHashMap;
import mondrian.util.MDCUtil;
import mondrian.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SegmentCacheManager {
    private final Handler handler = new Handler();
    private final Actor actor;
    public final Thread thread;
    private final Set<String> starFactTablesToSync;
    public final ExecutorService cacheExecutor;
    public final ExecutorService sqlExecutor;
    public final List<SegmentCacheWorker> segmentCacheWorkers;
    public final SegmentCache compositeCache;
    private final SegmentCacheIndexRegistry indexRegistry;
    private static final Logger LOGGER = LogManager.getLogger(AggregationManager.class);
    private final MondrianServer server;

    public SegmentCacheManager(MondrianServer server) {
        this.cacheExecutor = Util.getExecutorService(MondrianProperties.instance().SegmentCacheManagerNumberCacheThreads.get(), MondrianProperties.instance().SegmentCacheManagerNumberCacheThreads.get(), 1L, "mondrian.rolap.agg.SegmentCacheManager$cacheExecutor", (r, executor) -> {
            throw MondrianResource.instance().SegmentCacheLimitReached.ex();
        });
        this.sqlExecutor = Util.getExecutorService(MondrianProperties.instance().SegmentCacheManagerNumberSqlThreads.get(), MondrianProperties.instance().SegmentCacheManagerNumberSqlThreads.get(), 1L, "mondrian.rolap.agg.SegmentCacheManager$sqlExecutor", (r, executor) -> {
            throw MondrianResource.instance().SqlQueryLimitReached.ex();
        });
        this.segmentCacheWorkers = new CopyOnWriteArrayList<SegmentCacheWorker>();
        this.server = server;
        this.actor = new Actor();
        this.thread = new Thread((Runnable)this.actor, "mondrian.rolap.agg.SegmentCacheManager$ACTOR");
        this.thread.setDaemon(true);
        this.thread.start();
        this.indexRegistry = new SegmentCacheIndexRegistry();
        if (!MondrianProperties.instance().DisableLocalSegmentCache.get() && !MondrianProperties.instance().DisableCaching.get()) {
            MemorySegmentCache cache = new MemorySegmentCache();
            this.segmentCacheWorkers.add(new SegmentCacheWorker(cache, this.thread));
        }
        List<SegmentCache> externalCache = SegmentCacheWorker.initCache();
        for (SegmentCache cache : externalCache) {
            this.segmentCacheWorkers.add(new SegmentCacheWorker(cache, this.thread));
            cache.addListener(new AsyncCacheListener(this, server));
        }
        this.compositeCache = new CompositeSegmentCache(this.segmentCacheWorkers);
        List<SegmentHeader> headers = this.compositeCache.getSegmentHeaders();
        this.starFactTablesToSync = new HashSet<String>();
        for (SegmentHeader header : headers) {
            this.starFactTablesToSync.add(header.rolapStarFactTableName);
        }
    }

    public boolean loadCacheForStar(RolapStar star) {
        String starFactTableAlias = star.getFactTable().getAlias();
        if (this.starFactTablesToSync.remove(starFactTableAlias)) {
            SegmentCacheIndex index = this.indexRegistry.getIndex(star);
            for (SegmentHeader header : this.compositeCache.getSegmentHeaders()) {
                if (!header.rolapStarFactTableName.equals(starFactTableAlias) || index == null) continue;
                index.add(header, null, false);
                this.server.getMonitor().sendEvent(new CellCacheSegmentCreateEvent(System.currentTimeMillis(), this.server.getId(), 0, 0L, 0L, header.getConstrainedColumns().size(), 0, CellCacheEvent.Source.EXTERNAL));
            }
            return true;
        }
        return false;
    }

    public <T> T execute(Command<T> command) {
        return this.actor.execute(this.handler, command);
    }

    public SegmentCacheIndexRegistry getIndexRegistry() {
        return this.indexRegistry;
    }

    public void loadSucceeded(RolapStar star, SegmentHeader header, SegmentBody body) {
        Locus locus = Locus.peek();
        this.actor.event(this.handler, new SegmentLoadSucceededEvent(System.currentTimeMillis(), locus.getServer().getMonitor(), locus.getServer().getId(), locus.execution.getMondrianStatement().getMondrianConnection().getId(), locus.execution.getMondrianStatement().getId(), locus.execution.getId(), star, header, body));
    }

    public void loadFailed(RolapStar star, SegmentHeader header, Throwable throwable) {
        Locus locus = Locus.peek();
        this.actor.event(this.handler, new SegmentLoadFailedEvent(System.currentTimeMillis(), locus.getServer().getMonitor(), locus.getServer().getId(), locus.execution.getMondrianStatement().getMondrianConnection().getId(), locus.execution.getMondrianStatement().getId(), locus.execution.getId(), star, header, throwable));
    }

    public void remove(RolapStar star, SegmentHeader header) {
        Locus locus = Locus.peek();
        this.actor.event(this.handler, new SegmentRemoveEvent(System.currentTimeMillis(), locus.getServer().getMonitor(), locus.getServer().getId(), locus.execution.getMondrianStatement().getMondrianConnection().getId(), locus.execution.getMondrianStatement().getId(), locus.execution.getId(), this, star, header));
    }

    public void externalSegmentCreated(SegmentHeader header, MondrianServer server) {
        if (MondrianProperties.instance().DisableCaching.get()) {
            return;
        }
        this.actor.event(this.handler, new ExternalSegmentCreatedEvent(System.currentTimeMillis(), server.getMonitor(), server.getId(), 0, 0L, 0L, this, header));
    }

    public void externalSegmentDeleted(SegmentHeader header, MondrianServer server) {
        if (MondrianProperties.instance().DisableCaching.get()) {
            return;
        }
        this.actor.event(this.handler, new ExternalSegmentDeletedEvent(System.currentTimeMillis(), server.getMonitor(), server.getId(), 0, 0L, 0L, this, header));
    }

    public void printCacheState(CacheControl.CellRegion region, PrintWriter pw, Locus locus) {
        this.actor.execute(this.handler, new PrintCacheStateCommand(region, pw, locus));
    }

    public void shutdown() {
        this.execute(new ShutdownCommand());
        this.cacheExecutor.shutdown();
        this.sqlExecutor.shutdown();
    }

    public SegmentBuilder.SegmentConverter getConverter(RolapStar star, SegmentHeader header) {
        return this.indexRegistry.getIndex(star).getConverter(header.schemaName, header.schemaChecksum, header.cubeName, header.rolapStarFactTableName, header.measureName, header.compoundPredicates);
    }

    public SegmentWithData peek(CellRequest request) {
        PeekResponse response = this.execute(new PeekCommand(request, Locus.peek()));
        for (SegmentHeader segmentHeader : response.headerMap.keySet()) {
            SegmentBuilder.SegmentConverter converter;
            SegmentBody body = this.compositeCache.get(segmentHeader);
            if (body == null || (converter = response.converterMap.get(SegmentCacheIndexImpl.makeConverterKey(segmentHeader))) == null) continue;
            return converter.convert(segmentHeader, body);
        }
        for (Map.Entry entry : response.headerMap.entrySet()) {
            Future bodyFuture = (Future)entry.getValue();
            if (bodyFuture == null) continue;
            SegmentBody body = (SegmentBody)Util.safeGet(bodyFuture, "Waiting for segment to load");
            SegmentHeader header = (SegmentHeader)entry.getKey();
            SegmentBuilder.SegmentConverter converter = response.converterMap.get(SegmentCacheIndexImpl.makeConverterKey(header));
            if (converter == null) continue;
            return converter.convert(header, body);
        }
        return null;
    }

    static RolapStar getStar(SegmentHeader header) {
        for (RolapSchema schema : RolapSchema.getRolapSchemas()) {
            if (!schema.getChecksum().equals(header.schemaChecksum)) continue;
            return schema.getStar(header.rolapStarFactTableName);
        }
        return null;
    }

    public static final class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    public class SegmentCacheIndexRegistry {
        private final Map<SchemaKey, SegmentCacheIndex> indexes = Collections.synchronizedMap(new HashMap());

        public SegmentCacheIndex getIndex(RolapStar star) {
            SegmentCacheIndex index;
            LOGGER.trace("SegmentCacheManager.SegmentCacheIndexRegistry.getIndex:" + System.identityHashCode(star));
            if (!this.indexes.containsKey(star.getSchema().getKey())) {
                index = new SegmentCacheIndexImpl(SegmentCacheManager.this.thread);
                LOGGER.trace("SegmentCacheManager.SegmentCacheIndexRegistry.getIndex:Creating New Index " + System.identityHashCode(index));
                this.indexes.put(star.getSchema().getKey(), index);
            }
            index = this.indexes.get(star.getSchema().getKey());
            LOGGER.trace("SegmentCacheManager.SegmentCacheIndexRegistry.getIndex:Returning Index " + System.identityHashCode(index));
            return index;
        }

        private SegmentCacheIndex getIndex(SegmentHeader header) {
            RolapStar star = SegmentCacheManager.getStar(header);
            if (star == null) {
                return null;
            }
            return this.getIndex(star);
        }

        public void cancelExecutionSegments(Execution exec) {
            for (SegmentCacheIndex index : this.indexes.values()) {
                index.cancel(exec);
            }
        }
    }

    private static class PeekResponse {
        public final Map<SegmentHeader, Future<SegmentBody>> headerMap;
        public final Map<List, SegmentBuilder.SegmentConverter> converterMap;

        public PeekResponse(Map<SegmentHeader, Future<SegmentBody>> headerMap, Map<List, SegmentBuilder.SegmentConverter> converterMap) {
            this.headerMap = headerMap;
            this.converterMap = converterMap;
        }
    }

    private class PeekCommand
    extends Command<PeekResponse> {
        private final CellRequest request;
        private final Locus locus;

        public PeekCommand(CellRequest request, Locus locus) {
            this.request = request;
            this.locus = locus;
        }

        @Override
        public PeekResponse call() {
            RolapStar.Measure measure = this.request.getMeasure();
            RolapStar star = measure.getStar();
            RolapSchema schema = star.getSchema();
            AggregationKey key = new AggregationKey(this.request);
            List<SegmentHeader> headers = SegmentCacheManager.this.indexRegistry.getIndex(star).locate(schema.getName(), schema.getChecksum(), measure.getCubeName(), measure.getName(), star.getFactTable().getAlias(), this.request.getConstrainedColumnsBitKey(), this.request.getMappedCellValues(), this.request.getCompoundPredicateStrings());
            HashMap<SegmentHeader, Future<SegmentBody>> headerMap = new HashMap<SegmentHeader, Future<SegmentBody>>();
            HashMap<List, SegmentBuilder.SegmentConverter> converterMap = new HashMap<List, SegmentBuilder.SegmentConverter>();
            for (SegmentHeader header : headers) {
                Future<SegmentBody> bodyFuture = SegmentCacheManager.this.indexRegistry.getIndex(star).getFuture(this.locus.execution, header);
                if (bodyFuture == null) continue;
                if (star.getChangeListener() != null && star.getChangeListener().isAggregationChanged(key)) {
                    SegmentCacheManager.this.indexRegistry.getIndex(star).remove(header);
                    MDCUtil mdc = new MDCUtil();
                    Util.safeGet(SegmentCacheManager.this.cacheExecutor.submit(() -> {
                        mdc.setContextMap();
                        try {
                            SegmentCacheManager.this.compositeCache.remove(header);
                        }
                        catch (Exception e) {
                            LOGGER.warn("remove header failed: " + header, (Throwable)e);
                        }
                    }), "SegmentCacheManager.peek");
                    continue;
                }
                converterMap.put(SegmentCacheIndexImpl.makeConverterKey(header), SegmentCacheManager.this.getConverter(star, header));
                headerMap.put(header, bodyFuture);
            }
            return new PeekResponse(headerMap, converterMap);
        }

        @Override
        public Locus getLocus() {
            return this.locus;
        }
    }

    static class CompositeSegmentCache
    implements SegmentCache {
        final List<SegmentCacheWorker> workers;

        public CompositeSegmentCache(List<SegmentCacheWorker> workers) {
            this.workers = workers;
        }

        @Override
        public SegmentBody get(SegmentHeader header) {
            for (SegmentCacheWorker worker : this.workers) {
                SegmentBody body = worker.get(header);
                if (body == null) continue;
                return body;
            }
            return null;
        }

        @Override
        public List<SegmentHeader> getSegmentHeaders() {
            if (MondrianProperties.instance().DisableCaching.get()) {
                return Collections.emptyList();
            }
            switch (this.workers.size()) {
                case 0: {
                    return Collections.emptyList();
                }
                case 1: {
                    return this.workers.get(0).getSegmentHeaders();
                }
            }
            ArrayList<SegmentHeader> list = new ArrayList<SegmentHeader>();
            HashSet<SegmentHeader> set = new HashSet<SegmentHeader>();
            for (SegmentCacheWorker worker : this.workers) {
                for (SegmentHeader header : worker.getSegmentHeaders()) {
                    if (!set.add(header)) continue;
                    list.add(header);
                }
            }
            return list;
        }

        @Override
        public boolean put(SegmentHeader header, SegmentBody body) {
            if (MondrianProperties.instance().DisableCaching.get()) {
                return true;
            }
            for (SegmentCacheWorker worker : this.workers) {
                worker.put(header, body);
            }
            return true;
        }

        @Override
        public boolean remove(SegmentHeader header) {
            boolean result = false;
            for (SegmentCacheWorker worker : this.workers) {
                if (!worker.remove(header)) continue;
                result = true;
            }
            return result;
        }

        @Override
        public void tearDown() {
            for (SegmentCacheWorker worker : this.workers) {
                worker.shutdown();
            }
        }

        @Override
        public void addListener(SegmentCache.SegmentCacheListener listener) {
            for (SegmentCacheWorker worker : this.workers) {
                worker.cache.addListener(listener);
            }
        }

        @Override
        public void removeListener(SegmentCache.SegmentCacheListener listener) {
            for (SegmentCacheWorker worker : this.workers) {
                worker.cache.removeListener(listener);
            }
        }

        @Override
        public boolean supportsRichIndex() {
            for (SegmentCacheWorker worker : this.workers) {
                if (worker.supportsRichIndex()) continue;
                return false;
            }
            return true;
        }
    }

    private static class AsyncCacheListener
    implements SegmentCache.SegmentCacheListener {
        private final SegmentCacheManager cacheMgr;
        private final MondrianServer server;

        public AsyncCacheListener(SegmentCacheManager cacheMgr, MondrianServer server) {
            this.cacheMgr = cacheMgr;
            this.server = server;
        }

        @Override
        public void handle(final SegmentCache.SegmentCacheListener.SegmentCacheEvent e) {
            if (e.isLocal()) {
                return;
            }
            Locus.execute(Execution.NONE, "AsyncCacheListener.handle", () -> {
                Command<Void> command;
                final Locus locus = Locus.peek();
                switch (e.getEventType()) {
                    case ENTRY_CREATED: {
                        command = new Command<Void>(){

                            @Override
                            public Void call() {
                                cacheMgr.externalSegmentCreated(e.getSource(), server);
                                return null;
                            }

                            @Override
                            public Locus getLocus() {
                                return locus;
                            }
                        };
                        break;
                    }
                    case ENTRY_DELETED: {
                        command = new Command<Void>(){

                            @Override
                            public Void call() {
                                cacheMgr.externalSegmentDeleted(e.getSource(), server);
                                return null;
                            }

                            @Override
                            public Locus getLocus() {
                                return locus;
                            }
                        };
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                this.cacheMgr.execute(command);
                return null;
            });
        }
    }

    private static class ExternalSegmentDeletedEvent
    extends Event {
        private final SegmentCacheManager cacheMgr;
        private final SegmentHeader header;
        private final long timestamp;
        private final Monitor monitor;
        private final int serverId;
        private final int connectionId;
        private final long statementId;
        private final long executionId;

        public ExternalSegmentDeletedEvent(long timestamp, Monitor monitor, int serverId, int connectionId, long statementId, long executionId, SegmentCacheManager cacheMgr, SegmentHeader header) {
            this.timestamp = timestamp;
            this.monitor = monitor;
            this.serverId = serverId;
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.executionId = executionId;
            assert (header != null);
            assert (cacheMgr != null);
            this.cacheMgr = cacheMgr;
            this.header = header;
        }

        @Override
        public void acceptWithoutResponse(Visitor visitor) {
            visitor.visit(this);
        }
    }

    private static class ExternalSegmentCreatedEvent
    extends Event {
        private final SegmentCacheManager cacheMgr;
        private final SegmentHeader header;
        private final long timestamp;
        private final Monitor monitor;
        private final int serverId;
        private final int connectionId;
        private final long statementId;
        private final long executionId;

        public ExternalSegmentCreatedEvent(long timestamp, Monitor monitor, int serverId, int connectionId, long statementId, long executionId, SegmentCacheManager cacheMgr, SegmentHeader header) {
            this.timestamp = timestamp;
            this.monitor = monitor;
            this.serverId = serverId;
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.executionId = executionId;
            assert (header != null);
            assert (cacheMgr != null);
            this.cacheMgr = cacheMgr;
            this.header = header;
        }

        @Override
        public void acceptWithoutResponse(Visitor visitor) {
            visitor.visit(this);
        }
    }

    private static class SegmentRemoveEvent
    extends Event {
        private final SegmentHeader header;
        private final long timestamp;
        private final Monitor monitor;
        private final int serverId;
        private final int connectionId;
        private final long statementId;
        private final long executionId;
        private final RolapStar star;
        private final SegmentCacheManager cacheMgr;

        public SegmentRemoveEvent(long timestamp, Monitor monitor, int serverId, int connectionId, long statementId, long executionId, SegmentCacheManager cacheMgr, RolapStar star, SegmentHeader header) {
            this.timestamp = timestamp;
            this.monitor = monitor;
            this.serverId = serverId;
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.executionId = executionId;
            this.cacheMgr = cacheMgr;
            this.star = star;
            assert (header != null);
            this.header = header;
        }

        @Override
        public void acceptWithoutResponse(Visitor visitor) {
            visitor.visit(this);
        }
    }

    private static class SegmentLoadFailedEvent
    extends Event {
        private final SegmentHeader header;
        private final Throwable throwable;
        private final long timestamp;
        private final RolapStar star;
        private final Monitor monitor;
        private final int serverId;
        private final int connectionId;
        private final long statementId;
        private final long executionId;

        public SegmentLoadFailedEvent(long timestamp, Monitor monitor, int serverId, int connectionId, long statementId, long executionId, RolapStar star, SegmentHeader header, Throwable throwable) {
            this.timestamp = timestamp;
            this.monitor = monitor;
            this.serverId = serverId;
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.executionId = executionId;
            this.star = star;
            this.throwable = throwable;
            assert (header != null);
            this.header = header;
        }

        @Override
        public void acceptWithoutResponse(Visitor visitor) {
            visitor.visit(this);
        }
    }

    private static class SegmentLoadSucceededEvent
    extends Event {
        private final SegmentHeader header;
        private final SegmentBody body;
        private final long timestamp;
        private final RolapStar star;
        private final int serverId;
        private final int connectionId;
        private final long statementId;
        private final long executionId;
        private final Monitor monitor;

        public SegmentLoadSucceededEvent(long timestamp, Monitor monitor, int serverId, int connectionId, long statementId, long executionId, RolapStar star, SegmentHeader header, SegmentBody body) {
            this.timestamp = timestamp;
            this.monitor = monitor;
            this.serverId = serverId;
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.executionId = executionId;
            assert (header != null);
            assert (star != null);
            this.star = star;
            this.header = header;
            this.body = body;
        }

        @Override
        public void acceptWithoutResponse(Visitor visitor) {
            visitor.visit(this);
        }
    }

    private static class Actor
    implements Runnable {
        private final BlockingQueue<Pair<Handler, Message>> eventQueue = new ArrayBlockingQueue<Pair<Handler, Message>>(1000);
        private final BlockingHashMap<Command<?>, Pair<Object, Throwable>> responseMap = new BlockingHashMap(1000);
        private final AtomicBoolean shuttingDown = new AtomicBoolean(false);

        private Actor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                try {
                    while (true) {
                        Pair<Handler, Message> entry = this.eventQueue.take();
                        Handler handler = (Handler)entry.left;
                        Message message = (Message)entry.right;
                        message.setContextMap();
                        try {
                            if (message instanceof Command) {
                                Command command = (Command)message;
                                try {
                                    Locus.push(command.getLocus());
                                    Object result = command.call();
                                    this.responseMap.put(command, Pair.of(result, null));
                                    continue block12;
                                }
                                catch (PleaseShutdownException e) {
                                    this.shutDownAndDrainQueue(command);
                                    return;
                                }
                                catch (Exception e) {
                                    this.responseMap.put(command, Pair.of(null, e));
                                    continue block12;
                                }
                                finally {
                                    Locus.pop(command.getLocus());
                                    continue block12;
                                }
                            }
                            Event event = (Event)message;
                            event.acceptWithoutResponse(handler);
                            RolapUtil.MONITOR_LOGGER.debug((Object)message);
                            continue block12;
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage(), (Throwable)e);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    break;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    break;
                }
            }
        }

        private void shutDownAndDrainQueue(Command<?> command) {
            LOGGER.trace("Shutting down and draining event queue");
            this.shuttingDown.set(true);
            this.responseMap.put(command, Pair.of(null, null));
            ArrayList pendingQueue = new ArrayList(this.eventQueue.size());
            this.eventQueue.drainTo(pendingQueue);
            for (Pair queueElement : pendingQueue) {
                if (!(queueElement.getValue() instanceof Command)) continue;
                this.responseMap.put((Command)queueElement.getValue(), Pair.of(null, Util.newError("Actor queue already shut down")));
            }
        }

        <T> T execute(Handler handler, Command<T> command) {
            if (this.shuttingDown.get()) {
                throw Util.newError("Command submitted after shutdown " + command);
            }
            try {
                this.eventQueue.put(Pair.of(handler, command));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Util.newError(e, "Exception while executing " + command);
            }
            try {
                Pair<Object, Throwable> pair = this.responseMap.get(command);
                if (pair.right != null) {
                    if (pair.right instanceof RuntimeException) {
                        throw (RuntimeException)pair.right;
                    }
                    if (pair.right instanceof Error) {
                        throw (Error)pair.right;
                    }
                    throw new IllegalStateException((Throwable)pair.right);
                }
                return (T)pair.left;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Util.newError(e, "Exception while executing " + command);
            }
        }

        public void event(Handler handler, Event event) {
            if (this.shuttingDown.get()) {
                throw Util.newError("Event submitted after shutdown " + event);
            }
            try {
                this.eventQueue.put(Pair.of(handler, event));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Util.newError(e, "Exception while executing " + event);
            }
        }
    }

    private static abstract class Event
    implements Message {
        private final MDCUtil mdc = new MDCUtil();

        private Event() {
        }

        abstract void acceptWithoutResponse(Visitor var1);

        @Override
        public void setContextMap() {
            this.mdc.setContextMap();
        }
    }

    private static class ShutdownCommand
    extends Command<String> {
        private ShutdownCommand() {
        }

        @Override
        public String call() throws Exception {
            throw new PleaseShutdownException();
        }

        @Override
        public Locus getLocus() {
            return null;
        }
    }

    private static class PleaseShutdownException
    extends RuntimeException {
        private PleaseShutdownException() {
        }
    }

    public static class FlushResult {
        public final List<Callable<Boolean>> tasks;

        public FlushResult(List<Callable<Boolean>> tasks) {
            this.tasks = tasks;
        }
    }

    private class PrintCacheStateCommand
    extends Command<Void> {
        private final PrintWriter pw;
        private final Locus locus;
        private final CacheControl.CellRegion region;

        public PrintCacheStateCommand(CacheControl.CellRegion region, PrintWriter pw, Locus locus) {
            this.region = region;
            this.pw = pw;
            this.locus = locus;
        }

        @Override
        public Void call() {
            List<RolapStar> starList = CacheControlImpl.getStarList(this.region);
            starList.sort(Comparator.comparing(o -> o.getFactTable().getAlias()));
            for (RolapStar star : starList) {
                SegmentCacheManager.this.indexRegistry.getIndex(star).printCacheState(this.pw);
            }
            return null;
        }

        @Override
        public Locus getLocus() {
            return this.locus;
        }
    }

    public static final class FlushCommand
    extends Command<FlushResult> {
        private final CacheControl.CellRegion region;
        private final CacheControlImpl cacheControlImpl;
        private final Locus locus;
        private final SegmentCacheManager cacheMgr;

        public FlushCommand(Locus locus, SegmentCacheManager mgr, CacheControl.CellRegion region, CacheControlImpl cacheControlImpl) {
            this.locus = locus;
            this.cacheMgr = mgr;
            this.region = region;
            this.cacheControlImpl = cacheControlImpl;
        }

        @Override
        public Locus getLocus() {
            return this.locus;
        }

        @Override
        public FlushResult call() {
            List<Member> measures = CacheControlImpl.findMeasures(this.region);
            SegmentColumn[] flushRegion = CacheControlImpl.findAxisValues(this.region);
            List<RolapStar> starList = CacheControlImpl.getStarList(this.region);
            List<SegmentHeader> headers = this.getIntersectingHeaders(measures, flushRegion);
            if (flushRegion.length == 0) {
                this.clearAllSegmentsForRegionsMeasures(starList, headers);
                return new FlushResult(Collections.emptyList());
            }
            return this.getFlushResult(flushRegion, starList, headers);
        }

        private FlushResult getFlushResult(SegmentColumn[] flushRegion, List<RolapStar> starList, List<SegmentHeader> headers) {
            ArrayList<Callable<Boolean>> callableList = new ArrayList<Callable<Boolean>>();
            for (SegmentHeader header : headers) {
                if (!header.canConstrain(flushRegion)) {
                    this.cacheControlImpl.trace("discard segment - it cannot be constrained and maintain consistency:\n" + header.getDescription());
                    for (RolapStar star : starList) {
                        this.cacheMgr.indexRegistry.getIndex(star).remove(header);
                    }
                    continue;
                }
                SegmentHeader newHeader = header.constrain(flushRegion);
                for (RolapStar star : starList) {
                    SegmentCacheIndex index = this.cacheMgr.indexRegistry.getIndex(star);
                    index.update(header, newHeader);
                }
                this.clearCacheWorkers(callableList, header, newHeader);
            }
            return new FlushResult(callableList);
        }

        private void clearCacheWorkers(List<Callable<Boolean>> callableList, SegmentHeader header, SegmentHeader newHeader) {
            for (SegmentCacheWorker worker : this.cacheMgr.segmentCacheWorkers) {
                MDCUtil mdc = new MDCUtil();
                callableList.add(() -> {
                    boolean existed;
                    mdc.setContextMap();
                    if (worker.supportsRichIndex()) {
                        SegmentBody sb = worker.get(header);
                        existed = worker.remove(header);
                        if (sb != null) {
                            worker.put(newHeader, sb);
                        }
                    } else {
                        existed = worker.remove(header);
                    }
                    return existed;
                });
            }
        }

        private void clearAllSegmentsForRegionsMeasures(List<RolapStar> starList, List<SegmentHeader> headers) {
            for (SegmentHeader header : headers) {
                for (RolapStar star : starList) {
                    this.cacheMgr.indexRegistry.getIndex(star).remove(header);
                }
                this.cacheControlImpl.trace("discard segment - it cannot be constrained and maintain consistency:\n" + header.getDescription());
                MDCUtil mdc = new MDCUtil();
                Future<?> task = this.cacheMgr.cacheExecutor.submit(() -> {
                    mdc.setContextMap();
                    try {
                        this.cacheMgr.compositeCache.remove(header);
                    }
                    catch (Exception e) {
                        LOGGER.warn("remove header failed: " + header, (Throwable)e);
                    }
                });
                Util.safeGet(task, "SegmentCacheManager.flush");
            }
        }

        private List<SegmentHeader> getIntersectingHeaders(List<Member> measures, SegmentColumn[] flushRegion) {
            ArrayList<SegmentHeader> headers = new ArrayList<SegmentHeader>();
            for (Member member : measures) {
                if (!(member instanceof RolapStoredMeasure)) continue;
                RolapStoredMeasure storedMeasure = (RolapStoredMeasure)member;
                RolapStar star = storedMeasure.getCube().getStar();
                SegmentCacheIndex index = this.cacheMgr.indexRegistry.getIndex(star);
                headers.addAll(index.intersectRegion(member.getDimension().getSchema().getName(), ((RolapSchema)member.getDimension().getSchema()).getChecksum(), storedMeasure.getCube().getName(), storedMeasure.getName(), storedMeasure.getCube().getStar().getFactTable().getAlias(), flushRegion));
                if (!this.cacheControlImpl.isTraceEnabled()) continue;
                headers.sort(Comparator.comparing(SegmentHeader::getUniqueID));
            }
            return headers;
        }
    }

    public static abstract class Command<T>
    implements Message {
        private final MDCUtil mdc = new MDCUtil();

        public abstract Locus getLocus();

        public abstract T call() throws Exception;

        @Override
        public void setContextMap() {
            this.mdc.setContextMap();
        }
    }

    static interface Message {
        public void setContextMap();
    }

    private class Handler
    implements Visitor {
        private Handler() {
        }

        @Override
        public void visit(SegmentLoadSucceededEvent event) {
            SegmentCacheManager.this.indexRegistry.getIndex(event.star).loadSucceeded(event.header, event.body);
            event.monitor.sendEvent(new CellCacheSegmentCreateEvent(event.timestamp, event.serverId, event.connectionId, event.statementId, event.executionId, event.header.getConstrainedColumns().size(), event.body == null ? 0 : event.body.getValueMap().size(), CellCacheEvent.Source.SQL));
        }

        @Override
        public void visit(SegmentLoadFailedEvent event) {
            SegmentCacheManager.this.indexRegistry.getIndex(event.star).loadFailed(event.header, event.throwable);
        }

        @Override
        public void visit(SegmentRemoveEvent event) {
            SegmentCacheManager.this.indexRegistry.getIndex(event.star).remove(event.header);
            event.monitor.sendEvent(new CellCacheSegmentDeleteEvent(event.timestamp, event.serverId, event.connectionId, event.statementId, event.executionId, event.header.getConstrainedColumns().size(), CellCacheEvent.Source.CACHE_CONTROL));
            MDCUtil mdc = new MDCUtil();
            Future<?> future = ((SegmentRemoveEvent)event).cacheMgr.cacheExecutor.submit(() -> {
                mdc.setContextMap();
                try {
                    ((SegmentRemoveEvent)event).cacheMgr.compositeCache.remove(event.header);
                }
                catch (Exception e) {
                    LOGGER.warn("remove header failed: " + event.header, (Throwable)e);
                }
            });
            Util.safeGet(future, "SegmentCacheManager.segmentremoved");
        }

        @Override
        public void visit(ExternalSegmentCreatedEvent event) {
            SegmentCacheIndex index = event.cacheMgr.indexRegistry.getIndex(event.header);
            if (index == null) {
                LOGGER.debug("SegmentCacheManager.Handler.visitExternalCreated:No index found for external SegmentHeader:" + event.header);
                return;
            }
            RolapStar star = SegmentCacheManager.getStar(event.header);
            if (star == null) {
                return;
            }
            index.add(event.header, SegmentCacheManager.this.getConverter(star, event.header), false);
            event.monitor.sendEvent(new CellCacheSegmentCreateEvent(event.timestamp, event.serverId, event.connectionId, event.statementId, event.executionId, event.header.getConstrainedColumns().size(), 0, CellCacheEvent.Source.EXTERNAL));
        }

        @Override
        public void visit(ExternalSegmentDeletedEvent event) {
            SegmentCacheIndex index = event.cacheMgr.indexRegistry.getIndex(event.header);
            if (index == null) {
                LOGGER.debug("SegmentCacheManager.Handler.visitExternalDeleted:No index found for external SegmentHeader:" + event.header);
                return;
            }
            index.remove(event.header);
            event.monitor.sendEvent(new CellCacheSegmentDeleteEvent(event.timestamp, event.serverId, event.connectionId, event.statementId, event.executionId, event.header.getConstrainedColumns().size(), CellCacheEvent.Source.EXTERNAL));
        }
    }

    public static interface Visitor {
        public void visit(SegmentLoadSucceededEvent var1);

        public void visit(SegmentLoadFailedEvent var1);

        public void visit(SegmentRemoveEvent var1);

        public void visit(ExternalSegmentCreatedEvent var1);

        public void visit(ExternalSegmentDeletedEvent var1);
    }
}

