/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.olap4j.MondrianOlap4jDriver;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapSchema;
import mondrian.server.MondrianServerRegistry;
import mondrian.server.Repository;
import mondrian.server.RepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.tui.XmlaSupport;
import mondrian.util.ClassResolver;
import mondrian.util.LockBox;
import mondrian.util.Pair;
import mondrian.xmla.DataSourcesConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapWrapper;
import org.olap4j.impl.Olap4jUtil;

public class FileRepository
implements Repository {
    private static final Object SERVER_INFO_LOCK = new Object();
    private final RepositoryContentFinder repositoryContentFinder;
    private static final Logger LOGGER = LogManager.getLogger(MondrianServer.class);
    private static final ScheduledExecutorService executorService = Util.getScheduledExecutorService(1, "mondrian.server.DynamicContentFinder$executorService");
    private ServerInfo serverInfo;
    private final CatalogLocator locator;
    private static final Set<FileRepository> instances;
    private AtomicBoolean shutdown = new AtomicBoolean(false);

    public FileRepository(RepositoryContentFinder repositoryContentFinder, CatalogLocator locator) {
        this.repositoryContentFinder = repositoryContentFinder;
        this.locator = locator;
        assert (repositoryContentFinder != null);
        instances.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearServerInfo() {
        Object object = SERVER_INFO_LOCK;
        synchronized (object) {
            this.serverInfo = null;
        }
    }

    @Override
    public List<Map<String, Object>> getDatabases(RolapConnection connection) {
        ArrayList<Map<String, Object>> propsList = new ArrayList<Map<String, Object>>();
        for (DatabaseInfo dsInfo : this.getServerInfo().datasourceMap.values()) {
            propsList.add(dsInfo.properties);
        }
        return propsList;
    }

    @Override
    public OlapConnection getConnection(MondrianServer server, String databaseName, String catalogName, String roleName, Properties props) throws SQLException {
        DatabaseInfo datasourceInfo;
        ServerInfo serverInfo = this.getServerInfo();
        if (databaseName == null) {
            if (serverInfo.datasourceMap.size() == 0) {
                throw new OlapException("No databases configured on this server");
            }
            datasourceInfo = (DatabaseInfo)serverInfo.datasourceMap.values().iterator().next();
        } else {
            datasourceInfo = (DatabaseInfo)serverInfo.datasourceMap.get(databaseName);
            if (datasourceInfo == null) {
                for (DatabaseInfo infos : serverInfo.datasourceMap.values()) {
                    Util.PropertyList pl = Util.parseConnectString((String)infos.properties.get("DataSourceInfo"));
                    pl.remove(RolapConnectionProperties.Jdbc.name());
                    pl.remove(RolapConnectionProperties.JdbcUser.name());
                    pl.remove(RolapConnectionProperties.JdbcPassword.name());
                    if (!pl.toString().equals(databaseName)) continue;
                    datasourceInfo = infos;
                }
            }
        }
        if (datasourceInfo == null) {
            throw Util.newError("Unknown database '" + databaseName + "'");
        }
        if (catalogName == null) {
            if (datasourceInfo.catalogMap.size() == 0) {
                throw new OlapException("No catalogs in the database named " + datasourceInfo.name);
            }
            for (CatalogInfo catalogInfo : datasourceInfo.catalogMap.values()) {
                try {
                    return this.getConnection(catalogInfo, server, roleName, props);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed getting connection. Skipping", (Throwable)e);
                }
            }
        } else {
            CatalogInfo namedCatalogInfo = datasourceInfo.catalogMap.get(catalogName);
            if (namedCatalogInfo == null) {
                throw Util.newError("Unknown catalog '" + catalogName + "'");
            }
            return this.getConnection(namedCatalogInfo, server, roleName, props);
        }
        throw Util.newError("No suitable connection found");
    }

    OlapConnection getConnection(CatalogInfo catalogInfo, MondrianServer server, String roleName, Properties props) throws SQLException {
        String connectString = catalogInfo.olap4jConnectString;
        LockBox.Entry entry = MondrianServerRegistry.INSTANCE.lockBox.register(server);
        Properties properties = new Properties();
        properties.setProperty(RolapConnectionProperties.Instance.name(), entry.getMoniker());
        if (roleName != null) {
            properties.setProperty(RolapConnectionProperties.Role.name(), roleName);
        }
        properties.putAll((Map<?, ?>)props);
        try {
            ClassResolver.INSTANCE.forName(MondrianOlap4jDriver.class.getName(), true);
        }
        catch (ClassNotFoundException e) {
            throw new OlapException("Cannot find mondrian olap4j driver.");
        }
        Connection connection = DriverManager.getConnection(connectString, properties);
        return (OlapConnection)((OlapWrapper)connection).unwrap(OlapConnection.class);
    }

    @Override
    public void shutdown() {
        if (!this.shutdown.getAndSet(true)) {
            instances.remove(this);
            this.repositoryContentFinder.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerInfo getServerInfo() {
        Object object = SERVER_INFO_LOCK;
        synchronized (object) {
            if (this.serverInfo != null) {
                return this.serverInfo;
            }
            String content = this.getRepositoryContentFinder().getContent();
            DataSourcesConfig.DataSources xmlDataSources = XmlaSupport.parseDataSources(content, LOGGER);
            ServerInfo serverInfo = new ServerInfo();
            for (DataSourcesConfig.DataSource xmlDataSource : xmlDataSources.dataSources) {
                Map dsPropsMap = Olap4jUtil.mapOf((Object)"DataSourceName", (Object)xmlDataSource.getDataSourceName(), (Object[])new Object[]{"DataSourceDescription", xmlDataSource.getDataSourceDescription(), "URL", xmlDataSource.getURL(), "DataSourceInfo", xmlDataSource.getDataSourceInfo(), "ProviderName", xmlDataSource.getProviderName(), "ProviderType", xmlDataSource.providerType, "AuthenticationMode", xmlDataSource.authenticationMode});
                DatabaseInfo databaseInfo = new DatabaseInfo(xmlDataSource.name, dsPropsMap);
                serverInfo.datasourceMap.put(xmlDataSource.name, databaseInfo);
                for (DataSourcesConfig.Catalog xmlCatalog : xmlDataSource.catalogs.catalogs) {
                    if (databaseInfo.catalogMap.containsKey(xmlCatalog.name)) {
                        throw Util.newError("more than one DataSource object has name '" + xmlCatalog.name + "'");
                    }
                    String connectString = xmlCatalog.dataSourceInfo != null ? xmlCatalog.dataSourceInfo : xmlDataSource.dataSourceInfo;
                    Util.PropertyList connectProperties = Util.parseConnectString(connectString);
                    if (connectProperties.get(RolapConnectionProperties.Catalog.name()) == null) {
                        connectString = connectString + ";" + RolapConnectionProperties.Catalog.name() + "=" + xmlCatalog.definition;
                    }
                    CatalogInfo catalogInfo = new CatalogInfo(xmlCatalog.name, connectString, this.locator);
                    databaseInfo.catalogMap.put(xmlCatalog.name, catalogInfo);
                }
            }
            this.serverInfo = serverInfo;
            return serverInfo;
        }
    }

    @Override
    public List<String> getCatalogNames(RolapConnection connection, String databaseName) {
        return new ArrayList<String>(((DatabaseInfo)((ServerInfo)this.getServerInfo()).datasourceMap.get((Object)databaseName)).catalogMap.keySet());
    }

    @Override
    public List<String> getDatabaseNames(RolapConnection connection) {
        return new ArrayList<String>(this.getServerInfo().datasourceMap.keySet());
    }

    @Override
    public Map<String, RolapSchema> getRolapSchemas(RolapConnection connection, String databaseName, String catalogName) {
        RolapSchema schema = ((DatabaseInfo)((ServerInfo)this.getServerInfo()).datasourceMap.get((Object)databaseName)).catalogMap.get(catalogName).getRolapSchema();
        return Collections.singletonMap(schema.getName(), schema);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    RepositoryContentFinder getRepositoryContentFinder() {
        return this.repositoryContentFinder;
    }

    static {
        Pair<Long, TimeUnit> interval = Util.parseInterval(String.valueOf(MondrianProperties.instance().XmlaSchemaRefreshInterval.get()), TimeUnit.MILLISECONDS);
        executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (FileRepository next : instances) {
                    next.clearServerInfo();
                }
            }
        }, 0L, (Long)interval.left, (TimeUnit)((Object)interval.right));
        instances = Collections.newSetFromMap(new WeakHashMap());
    }

    static class CatalogInfo {
        private final String connectString;
        private final String olap4jConnectString;
        private final CatalogLocator locator;

        CatalogInfo(String name, String connectString, CatalogLocator locator) {
            this.connectString = connectString;
            this.locator = locator;
            this.olap4jConnectString = connectString.startsWith("jdbc:") ? connectString : "jdbc:mondrian:" + connectString;
        }

        private RolapSchema getRolapSchema() {
            try (RolapConnection rolapConnection = null;){
                rolapConnection = (RolapConnection)mondrian.olap.DriverManager.getConnection(this.connectString, this.locator);
                RolapSchema rolapSchema = rolapConnection.getSchema();
                return rolapSchema;
            }
        }
    }

    static class DatabaseInfo {
        private final String name;
        private final Map<String, Object> properties;
        Map<String, CatalogInfo> catalogMap = new HashMap<String, CatalogInfo>();

        DatabaseInfo(String name, Map<String, Object> properties) {
            this.name = name;
            this.properties = properties;
        }

        Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    static class ServerInfo {
        private Map<String, DatabaseInfo> datasourceMap = new HashMap<String, DatabaseInfo>();

        ServerInfo() {
        }

        Map<String, DatabaseInfo> getDatasourceMap() {
            return this.datasourceMap;
        }
    }
}

