/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mondrian.olap.Util;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.spi.DialectUtil;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class SnowflakeDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(SnowflakeDialect.class, Dialect.DatabaseProduct.SNOWFLAKE);

    public SnowflakeDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public String getQuoteIdentifierString() {
        return "\"";
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, null, false);
    }

    @Override
    public void quoteStringLiteral(StringBuilder buf, String s) {
        Util.singleQuoteString(s.replaceAll("\\\\", "\\\\\\\\"), buf);
    }

    @Override
    public boolean allowsOrderByAlias() {
        return true;
    }

    @Override
    public boolean allowsSelectNotInGroupBy() {
        return false;
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public SqlStatement.Type getType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int scale = metaData.getScale(columnIndex + 1);
        int columnType = metaData.getColumnType(columnIndex + 1);
        if ((columnType == 2 || columnType == 3) && scale != 0) {
            this.logTypeInfo(metaData, columnIndex, SqlStatement.Type.DECIMAL);
            return SqlStatement.Type.DECIMAL;
        }
        return super.getType(metaData, columnIndex);
    }

    @Override
    public String generateRegularExpression(String source, String javaRegex) {
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        javaRegex = DialectUtil.cleanUnicodeAwareCaseFlag(javaRegex);
        javaRegex = javaRegex.replace("\\Q", "");
        javaRegex = javaRegex.replace("\\E", "");
        StringBuilder mappedFlags = new StringBuilder();
        String[][] mapping = new String[][]{{"c", "c"}, {"i", "i"}, {"m", "m"}, {"s", "s"}};
        javaRegex = this.extractEmbeddedFlags(javaRegex, mapping, mappedFlags);
        StringBuilder sb = new StringBuilder();
        sb.append(" RLIKE ( ");
        sb.append(source);
        sb.append(", ");
        this.quoteStringLiteral(sb, javaRegex);
        if (mappedFlags.length() > 0) {
            sb.append(", ");
            this.quoteStringLiteral(sb, mappedFlags.toString());
        }
        sb.append(")");
        return sb.toString();
    }
}

