/*
 * Decompiled with CFR 0.152.
 */
package mondrian.tui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;

public class NamespaceContextImpl
implements NamespaceContext {
    private final Map<String, String> prefixUriMap;

    public NamespaceContextImpl(Map<String, String> prefixUriMap) {
        if (prefixUriMap == null) {
            throw new IllegalArgumentException("Must define map");
        }
        this.prefixUriMap = Collections.unmodifiableMap(prefixUriMap);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix cannot be null.");
        }
        return this.prefixUriMap.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Iterator iter = this.getPrefixes(namespaceURI);
        return iter.hasNext() ? (String)iter.next() : null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if (namespaceURI == null) {
            throw new IllegalArgumentException("Namespace URI cannot be null.");
        }
        ArrayList<String> uris = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.prefixUriMap.entrySet()) {
            if (!namespaceURI.equals(entry.getValue())) continue;
            uris.add(entry.getKey());
        }
        return uris.iterator();
    }
}

