/*
// This java file was automatically generated
// from XOM model 'mondrian'
// on Tue Nov 08 19:46:48 UTC 2022
// Do not edit this file by hand.
*/

package mondrian.olap;
import mondrian.rolap.sql.SqlQuery;
/**
 * This is the XML model for Mondrian schemas.
 * Revision is $Id$
 * <p>This class was generated from XOM model 'mondrian' on Tue Nov 08 19:46:48 UTC 2022
 */
public class MondrianDef {

	public static java.lang.Class getXMLDefClass()
	{
		return MondrianDef.class;
	}

	public static String[] _elements = {
		"Schema",
		"CubeDimension",
		"Cube",
		"VirtualCube",
		"CubeUsages",
		"CubeUsage",
		"VirtualCubeDimension",
		"VirtualCubeMeasure",
		"DimensionUsage",
		"Dimension",
		"Hierarchy",
		"Level",
		"Closure",
		"Property",
		"Measure",
		"CalculatedMember",
		"CalculatedMemberProperty",
		"NamedSet",
		"Formula",
		"MemberReaderParameter",
		"RelationOrJoin",
		"Relation",
		"View",
		"SQL",
		"Join",
		"Table",
		"Hint",
		"InlineTable",
		"ColumnDefs",
		"ColumnDef",
		"Rows",
		"Row",
		"Value",
		"AggTable",
		"AggName",
		"AggPattern",
		"AggExclude",
		"AggColumnName",
		"AggFactCount",
		"AggMeasureFactCount",
		"AggIgnoreColumn",
		"AggForeignKey",
		"AggLevel",
		"AggLevelProperty",
		"AggMeasure",
		"Expression",
		"Column",
		"ExpressionView",
		"KeyExpression",
		"ParentExpression",
		"OrdinalExpression",
		"NameExpression",
		"CaptionExpression",
		"MeasureExpression",
		"Role",
		"Grant",
		"SchemaGrant",
		"CubeGrant",
		"DimensionGrant",
		"HierarchyGrant",
		"MemberGrant",
		"Union",
		"RoleUsage",
		"UserDefinedFunction",
		"Parameter",
		"Annotations",
		"Annotation",
		"Script",
		"ElementFormatter",
		"CellFormatter",
		"MemberFormatter",
		"PropertyFormatter"
	};

	/**
	 * A schema is a collection of cubes and virtual cubes.
	 * It can also contain shared dimensions (for use by those
	 * cubes), named sets, roles, and declarations of
	 * user-defined functions.
	 */
	public static class Schema extends org.eigenbase.xom.ElementDef
	{
		public Schema()
		{
		}

		public Schema(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				measuresCaption = (String)_parser.getAttribute("measuresCaption", "String", null, null, false);
				defaultRole = (String)_parser.getAttribute("defaultRole", "String", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				_tempArray = _parser.getArray(Parameter.class, 0, 0);
				parameters = new Parameter[_tempArray.length];
				for (int _i = 0; _i < parameters.length; _i++)
					parameters[_i] = (Parameter)_tempArray[_i];
				_tempArray = _parser.getArray(Dimension.class, 0, 0);
				dimensions = new Dimension[_tempArray.length];
				for (int _i = 0; _i < dimensions.length; _i++)
					dimensions[_i] = (Dimension)_tempArray[_i];
				_tempArray = _parser.getArray(Cube.class, 0, 0);
				cubes = new Cube[_tempArray.length];
				for (int _i = 0; _i < cubes.length; _i++)
					cubes[_i] = (Cube)_tempArray[_i];
				_tempArray = _parser.getArray(VirtualCube.class, 0, 0);
				virtualCubes = new VirtualCube[_tempArray.length];
				for (int _i = 0; _i < virtualCubes.length; _i++)
					virtualCubes[_i] = (VirtualCube)_tempArray[_i];
				_tempArray = _parser.getArray(NamedSet.class, 0, 0);
				namedSets = new NamedSet[_tempArray.length];
				for (int _i = 0; _i < namedSets.length; _i++)
					namedSets[_i] = (NamedSet)_tempArray[_i];
				_tempArray = _parser.getArray(Role.class, 0, 0);
				roles = new Role[_tempArray.length];
				for (int _i = 0; _i < roles.length; _i++)
					roles[_i] = (Role)_tempArray[_i];
				_tempArray = _parser.getArray(UserDefinedFunction.class, 0, 0);
				userDefinedFunctions = new UserDefinedFunction[_tempArray.length];
				for (int _i = 0; _i < userDefinedFunctions.length; _i++)
					userDefinedFunctions[_i] = (UserDefinedFunction)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String description;  // optional attribute
		public String measuresCaption;  // optional attribute
		public String defaultRole;  // optional attribute

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element
		/**
		 * This schema's parameter definitions.
		 */
		public Parameter[] parameters;  //optional array
		/**
		 * Shared dimensions in this schema.
		 */
		public Dimension[] dimensions;  //optional array
		/**
		 * Cubes in this schema.
		 */
		public Cube[] cubes;  //optional array
		/**
		 * Virtual cubes in this schema.
		 */
		public VirtualCube[] virtualCubes;  //optional array
		/**
		 * Named sets in this schema.
		 */
		public NamedSet[] namedSets;  //optional array
		/**
		 * Roles in this schema.
		 */
		public Role[] roles;  //optional array
		/**
		 * Declarations of user-defined functions in this schema.
		 */
		public UserDefinedFunction[] userDefinedFunctions;  //optional array

		public String getName()
		{
			return "Schema";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "measuresCaption", measuresCaption, _indent+1);
			displayAttribute(_out, "defaultRole", defaultRole, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElementArray(_out, "parameters", parameters, _indent+1);
			displayElementArray(_out, "dimensions", dimensions, _indent+1);
			displayElementArray(_out, "cubes", cubes, _indent+1);
			displayElementArray(_out, "virtualCubes", virtualCubes, _indent+1);
			displayElementArray(_out, "namedSets", namedSets, _indent+1);
			displayElementArray(_out, "roles", roles, _indent+1);
			displayElementArray(_out, "userDefinedFunctions", userDefinedFunctions, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Schema", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("description", description)
				.add("measuresCaption", measuresCaption)
				.add("defaultRole", defaultRole)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElementArray(_out, parameters);
			displayXMLElementArray(_out, dimensions);
			displayXMLElementArray(_out, cubes);
			displayXMLElementArray(_out, virtualCubes);
			displayXMLElementArray(_out, namedSets);
			displayXMLElementArray(_out, roles);
			displayXMLElementArray(_out, userDefinedFunctions);
			_out.endTag("Schema");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Schema _cother = (Schema)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("measuresCaption", measuresCaption, _cother.measuresCaption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("defaultRole", defaultRole, _cother.defaultRole, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("parameters", parameters, _cother.parameters, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("dimensions", dimensions, _cother.dimensions, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("cubes", cubes, _cother.cubes, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("virtualCubes", virtualCubes, _cother.virtualCubes, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("namedSets", namedSets, _cother.namedSets, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("roles", roles, _cother.roles, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("userDefinedFunctions", userDefinedFunctions, _cother.userDefinedFunctions, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
Cube getCube(String cubeName) {
                for (int i = 0; i < cubes.length; i++) {
                    if (cubes[i].name.equals(cubeName)) {
                        return cubes[i];
                    }
                }
                throw Util.newInternal("Cannot find cube '" + cubeName + "'");
            }
            Dimension getPublicDimension(String dimensionName) {
                for (int i = 0; i < dimensions.length; i++) {
                    if (dimensions[i].name.equals(dimensionName)) {
                        return dimensions[i];
                    }
                }
                throw Util.newInternal(
                    "Cannot find public dimension '" + dimensionName + "'");
            }
		// END pass-through code block ---
	}

	/**
	 * A CubeDimension is either a usage of a Dimension ('shared
	 * dimension', in MSOLAP parlance), or a 'private dimension'.
	 */
	public static abstract class CubeDimension extends org.eigenbase.xom.ElementDef
	{
		public CubeDimension()
		{
		}

		public CubeDimension(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				foreignKey = (String)_parser.getAttribute("foreignKey", "String", null, null, false);
				highCardinality = (Boolean)_parser.getAttribute("highCardinality", "Boolean", "false", null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String caption;  // optional attribute
		public Boolean visible;  // attribute default: true
		public String description;  // optional attribute
		public String foreignKey;  // optional attribute
		public Boolean highCardinality;  // attribute default: false

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element

		public String getName()
		{
			return "CubeDimension";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "foreignKey", foreignKey, _indent+1);
			displayAttribute(_out, "highCardinality", highCardinality, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("CubeDimension", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("caption", caption)
				.add("visible", visible)
				.add("description", description)
				.add("foreignKey", foreignKey)
				.add("highCardinality", highCardinality)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			_out.endTag("CubeDimension");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			CubeDimension _cother = (CubeDimension)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("visible", visible, _cother.visible, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("foreignKey", foreignKey, _cother.foreignKey, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("highCardinality", highCardinality, _cother.highCardinality, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
/**
             * Looks up the base dimension of this dimension. If this is a
             * usage of a shared dimension, returns the referenced dimension;
             * otherwise returns the dimension itself.
             *
             * <p>Never returns null; if the dimension cannot be
             * found, throws an error.
             *
             * @param schema Schema, never null
             * @pre schema != null
             * @post return != null
             */
            public abstract Dimension getDimension(Schema schema);
		// END pass-through code block ---
	}

	/**
	 * Definition of a cube.
	 */
	public static class Cube extends org.eigenbase.xom.ElementDef
	{
		public Cube()
		{
		}

		public Cube(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				defaultMeasure = (String)_parser.getAttribute("defaultMeasure", "String", null, null, false);
				cache = (Boolean)_parser.getAttribute("cache", "Boolean", "true", null, false);
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				fact = (Relation)_parser.getElement(Relation.class, true);
				_tempArray = _parser.getArray(CubeDimension.class, 0, 0);
				dimensions = new CubeDimension[_tempArray.length];
				for (int _i = 0; _i < dimensions.length; _i++)
					dimensions[_i] = (CubeDimension)_tempArray[_i];
				_tempArray = _parser.getArray(Measure.class, 0, 0);
				measures = new Measure[_tempArray.length];
				for (int _i = 0; _i < measures.length; _i++)
					measures[_i] = (Measure)_tempArray[_i];
				_tempArray = _parser.getArray(CalculatedMember.class, 0, 0);
				calculatedMembers = new CalculatedMember[_tempArray.length];
				for (int _i = 0; _i < calculatedMembers.length; _i++)
					calculatedMembers[_i] = (CalculatedMember)_tempArray[_i];
				_tempArray = _parser.getArray(NamedSet.class, 0, 0);
				namedSets = new NamedSet[_tempArray.length];
				for (int _i = 0; _i < namedSets.length; _i++)
					namedSets[_i] = (NamedSet)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String caption;  // optional attribute
		public Boolean visible;  // attribute default: true
		public String description;  // optional attribute
		public String defaultMeasure;  // optional attribute
		public Boolean cache;  // attribute default: true
		public Boolean enabled;  // attribute default: true

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element
		/**
		 * The fact table is the source of all measures in this cube. If
		 * this is a Table and the schema name is not
		 * present, table name is left unqualified.
		 */
		public Relation fact;  //required element
		/**
		 */
		public CubeDimension[] dimensions;  //optional array
		/**
		 */
		public Measure[] measures;  //optional array
		/**
		 * Calculated members in this cube.
		 */
		public CalculatedMember[] calculatedMembers;  //optional array
		/**
		 * Named sets in this cube.
		 */
		public NamedSet[] namedSets;  //optional array

		public String getName()
		{
			return "Cube";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "defaultMeasure", defaultMeasure, _indent+1);
			displayAttribute(_out, "cache", cache, _indent+1);
			displayAttribute(_out, "enabled", enabled, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElement(_out, "fact", (org.eigenbase.xom.ElementDef) fact, _indent+1);
			displayElementArray(_out, "dimensions", dimensions, _indent+1);
			displayElementArray(_out, "measures", measures, _indent+1);
			displayElementArray(_out, "calculatedMembers", calculatedMembers, _indent+1);
			displayElementArray(_out, "namedSets", namedSets, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Cube", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("caption", caption)
				.add("visible", visible)
				.add("description", description)
				.add("defaultMeasure", defaultMeasure)
				.add("cache", cache)
				.add("enabled", enabled)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) fact);
			displayXMLElementArray(_out, dimensions);
			displayXMLElementArray(_out, measures);
			displayXMLElementArray(_out, calculatedMembers);
			displayXMLElementArray(_out, namedSets);
			_out.endTag("Cube");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Cube _cother = (Cube)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("visible", visible, _cother.visible, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("defaultMeasure", defaultMeasure, _cother.defaultMeasure, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("cache", cache, _cother.cache, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("enabled", enabled, _cother.enabled, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementDiff("fact", fact, _cother.fact, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("dimensions", dimensions, _cother.dimensions, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("measures", measures, _cother.measures, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("calculatedMembers", calculatedMembers, _cother.calculatedMembers, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("namedSets", namedSets, _cother.namedSets, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public boolean isEnabled() {
                return enabled.booleanValue();
            }
            Dimension getDimension(Schema xmlSchema, String dimensionName) {
                for (int i = 0; i < dimensions.length; i++) {
                    if (dimensions[i].name.equals(dimensionName)) {
                        return dimensions[i].getDimension(xmlSchema);
                    }
                }
                throw Util.newInternal(
                    "Cannot find dimension '" + dimensionName + "' in cube '" +
                    name + "'");
            }
		// END pass-through code block ---
	}

	/**
	 * A VirtualCube is a set of dimensions and
	 * measures gleaned from other cubes.
	 */
	public static class VirtualCube extends org.eigenbase.xom.ElementDef
	{
		public VirtualCube()
		{
		}

		public VirtualCube(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
				name = (String)_parser.getAttribute("name", "String", null, null, false);
				defaultMeasure = (String)_parser.getAttribute("defaultMeasure", "String", null, null, false);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				cubeUsage = (CubeUsages)_parser.getElement(CubeUsages.class, false);
				_tempArray = _parser.getArray(VirtualCubeDimension.class, 0, 0);
				dimensions = new VirtualCubeDimension[_tempArray.length];
				for (int _i = 0; _i < dimensions.length; _i++)
					dimensions[_i] = (VirtualCubeDimension)_tempArray[_i];
				_tempArray = _parser.getArray(VirtualCubeMeasure.class, 0, 0);
				measures = new VirtualCubeMeasure[_tempArray.length];
				for (int _i = 0; _i < measures.length; _i++)
					measures[_i] = (VirtualCubeMeasure)_tempArray[_i];
				_tempArray = _parser.getArray(CalculatedMember.class, 0, 0);
				calculatedMembers = new CalculatedMember[_tempArray.length];
				for (int _i = 0; _i < calculatedMembers.length; _i++)
					calculatedMembers[_i] = (CalculatedMember)_tempArray[_i];
				_tempArray = _parser.getArray(NamedSet.class, 0, 0);
				namedSets = new NamedSet[_tempArray.length];
				for (int _i = 0; _i < namedSets.length; _i++)
					namedSets[_i] = (NamedSet)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public Boolean enabled;  // attribute default: true
		public String name;  // optional attribute
		public String defaultMeasure;  // optional attribute
		public String caption;  // optional attribute
		public Boolean visible;  // attribute default: true
		public String description;  // optional attribute

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element
		/**
		 */
		public CubeUsages cubeUsage;  //optional element
		/**
		 */
		public VirtualCubeDimension[] dimensions;  //optional array
		/**
		 */
		public VirtualCubeMeasure[] measures;  //optional array
		/**
		 * Calculated members that belong to this virtual cube.
		 * (Calculated members inherited from other cubes should not be
		 * in this list.)
		 */
		public CalculatedMember[] calculatedMembers;  //optional array
		/**
		 * Named sets in this cube.
		 */
		public NamedSet[] namedSets;  //optional array

		public String getName()
		{
			return "VirtualCube";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "enabled", enabled, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "defaultMeasure", defaultMeasure, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElement(_out, "cubeUsage", (org.eigenbase.xom.ElementDef) cubeUsage, _indent+1);
			displayElementArray(_out, "dimensions", dimensions, _indent+1);
			displayElementArray(_out, "measures", measures, _indent+1);
			displayElementArray(_out, "calculatedMembers", calculatedMembers, _indent+1);
			displayElementArray(_out, "namedSets", namedSets, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("VirtualCube", new org.eigenbase.xom.XMLAttrVector()
				.add("enabled", enabled)
				.add("name", name)
				.add("defaultMeasure", defaultMeasure)
				.add("caption", caption)
				.add("visible", visible)
				.add("description", description)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) cubeUsage);
			displayXMLElementArray(_out, dimensions);
			displayXMLElementArray(_out, measures);
			displayXMLElementArray(_out, calculatedMembers);
			displayXMLElementArray(_out, namedSets);
			_out.endTag("VirtualCube");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			VirtualCube _cother = (VirtualCube)_other;
			boolean _diff = displayAttributeDiff("enabled", enabled, _cother.enabled, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("defaultMeasure", defaultMeasure, _cother.defaultMeasure, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("visible", visible, _cother.visible, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementDiff("cubeUsage", cubeUsage, _cother.cubeUsage, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("dimensions", dimensions, _cother.dimensions, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("measures", measures, _cother.measures, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("calculatedMembers", calculatedMembers, _cother.calculatedMembers, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("namedSets", namedSets, _cother.namedSets, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public boolean isEnabled() {
                return enabled.booleanValue();
            }
		// END pass-through code block ---
	}

	/**
	 * List of base cubes used by the virtual cube.
	 */
	public static class CubeUsages extends org.eigenbase.xom.ElementDef
	{
		public CubeUsages()
		{
		}

		public CubeUsages(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(CubeUsage.class, 1, 0);
				cubeUsages = new CubeUsage[_tempArray.length];
				for (int _i = 0; _i < cubeUsages.length; _i++)
					cubeUsages[_i] = (CubeUsage)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}


		/**
		 */
		public CubeUsage[] cubeUsages;  //min 1

		public String getName()
		{
			return "CubeUsages";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "cubeUsages", cubeUsages, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("CubeUsages", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, cubeUsages);
			_out.endTag("CubeUsages");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			CubeUsages _cother = (CubeUsages)_other;
			boolean _diff = displayElementArrayDiff("cubeUsages", cubeUsages, _cother.cubeUsages, _out, _indent+1);
			return _diff;
		}
	}

	public static class CubeUsage extends org.eigenbase.xom.ElementDef
	{
		public CubeUsage()
		{
		}

		public CubeUsage(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				cubeName = (String)_parser.getAttribute("cubeName", "String", null, null, true);
				ignoreUnrelatedDimensions = (Boolean)_parser.getAttribute("ignoreUnrelatedDimensions", "Boolean", "false", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String cubeName;  // required attribute
		public Boolean ignoreUnrelatedDimensions;  // attribute default: false


		public String getName()
		{
			return "CubeUsage";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "cubeName", cubeName, _indent+1);
			displayAttribute(_out, "ignoreUnrelatedDimensions", ignoreUnrelatedDimensions, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("CubeUsage", new org.eigenbase.xom.XMLAttrVector()
				.add("cubeName", cubeName)
				.add("ignoreUnrelatedDimensions", ignoreUnrelatedDimensions)
				);
			_out.endTag("CubeUsage");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			CubeUsage _cother = (CubeUsage)_other;
			boolean _diff = displayAttributeDiff("cubeName", cubeName, _cother.cubeName, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("ignoreUnrelatedDimensions", ignoreUnrelatedDimensions, _cother.ignoreUnrelatedDimensions, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * A VirtualCubeDimension is a usage of a Dimension in a VirtualCube.
	 */
	public static class VirtualCubeDimension extends CubeDimension
	{
		public VirtualCubeDimension()
		{
		}

		public VirtualCubeDimension(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				cubeName = (String)_parser.getAttribute("cubeName", "String", null, null, false);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				foreignKey = (String)_parser.getAttribute("foreignKey", "String", null, null, false);
				highCardinality = (Boolean)_parser.getAttribute("highCardinality", "Boolean", "false", null, false);
				name = (String)_parser.getAttribute("name", "String", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String cubeName;  // optional attribute


		public String getName()
		{
			return "VirtualCubeDimension";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "cubeName", cubeName, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "foreignKey", foreignKey, _indent+1);
			displayAttribute(_out, "highCardinality", highCardinality, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("VirtualCubeDimension", new org.eigenbase.xom.XMLAttrVector()
				.add("cubeName", cubeName)
				.add("caption", caption)
				.add("visible", visible)
				.add("description", description)
				.add("foreignKey", foreignKey)
				.add("highCardinality", highCardinality)
				.add("name", name)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			_out.endTag("VirtualCubeDimension");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			VirtualCubeDimension _cother = (VirtualCubeDimension)_other;
			boolean _diff = displayAttributeDiff("cubeName", cubeName, _cother.cubeName, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
// implement CubeDimension
            public Dimension getDimension(Schema schema) {
                Util.assertPrecondition(schema != null, "schema != null");
                if (cubeName == null) {
                    return schema.getPublicDimension(name);
                } else {
                    Cube cube = schema.getCube(cubeName);
                    return cube.getDimension(schema, name);
                }
            }
		// END pass-through code block ---
	}

	/**
	 * A VirtualCubeMeasure is a usage of a Measure in a VirtualCube.
	 */
	public static class VirtualCubeMeasure extends org.eigenbase.xom.ElementDef
	{
		public VirtualCubeMeasure()
		{
		}

		public VirtualCubeMeasure(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				cubeName = (String)_parser.getAttribute("cubeName", "String", null, null, false);
				name = (String)_parser.getAttribute("name", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String cubeName;  // optional attribute
		public String name;  // optional attribute
		public Boolean visible;  // optional attribute

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element

		public String getName()
		{
			return "VirtualCubeMeasure";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "cubeName", cubeName, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("VirtualCubeMeasure", new org.eigenbase.xom.XMLAttrVector()
				.add("cubeName", cubeName)
				.add("name", name)
				.add("visible", visible)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			_out.endTag("VirtualCubeMeasure");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			VirtualCubeMeasure _cother = (VirtualCubeMeasure)_other;
			boolean _diff = displayAttributeDiff("cubeName", cubeName, _cother.cubeName, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("visible", visible, _cother.visible, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * A DimensionUsage is usage of a shared
	 * Dimension within the context of a cube.
	 */
	public static class DimensionUsage extends CubeDimension
	{
		public DimensionUsage()
		{
		}

		public DimensionUsage(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				source = (String)_parser.getAttribute("source", "String", null, null, true);
				level = (String)_parser.getAttribute("level", "String", null, null, false);
				usagePrefix = (String)_parser.getAttribute("usagePrefix", "String", null, null, false);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				foreignKey = (String)_parser.getAttribute("foreignKey", "String", null, null, false);
				highCardinality = (Boolean)_parser.getAttribute("highCardinality", "Boolean", "false", null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String source;  // required attribute
		public String level;  // optional attribute
		public String usagePrefix;  // optional attribute


		public String getName()
		{
			return "DimensionUsage";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "source", source, _indent+1);
			displayAttribute(_out, "level", level, _indent+1);
			displayAttribute(_out, "usagePrefix", usagePrefix, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "foreignKey", foreignKey, _indent+1);
			displayAttribute(_out, "highCardinality", highCardinality, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("DimensionUsage", new org.eigenbase.xom.XMLAttrVector()
				.add("source", source)
				.add("level", level)
				.add("usagePrefix", usagePrefix)
				.add("name", name)
				.add("caption", caption)
				.add("visible", visible)
				.add("description", description)
				.add("foreignKey", foreignKey)
				.add("highCardinality", highCardinality)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			_out.endTag("DimensionUsage");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			DimensionUsage _cother = (DimensionUsage)_other;
			boolean _diff = displayAttributeDiff("source", source, _cother.source, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("level", level, _cother.level, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("usagePrefix", usagePrefix, _cother.usagePrefix, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
// implement CubeDimension
            public Dimension getDimension(Schema schema) {
                Util.assertPrecondition(schema != null, "schema != null");
                for (int i = 0; i < schema.dimensions.length; i++) {
                    if (schema.dimensions[i].name.equals(source)) {
                        return schema.dimensions[i];
                    }
                }
                throw Util.newInternal(
                    "Cannot find shared dimension '" + source + "'");
            }
		// END pass-through code block ---
	}

	/**
	 * A Dimension is a collection of hierarchies. There are
	 * two kinds: a public dimension belongs to a
	 * Schema, and be used by several cubes; a
	 * private dimension belongs to a
	 * Cube. The foreignKey field is only
	 * applicable to private dimensions.
	 */
	public static class Dimension extends CubeDimension
	{
		public Dimension()
		{
		}

		public Dimension(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				type = (String)_parser.getAttribute("type", "String", null, _type_values, false);
				usagePrefix = (String)_parser.getAttribute("usagePrefix", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
				foreignKey = (String)_parser.getAttribute("foreignKey", "String", null, null, false);
				highCardinality = (Boolean)_parser.getAttribute("highCardinality", "Boolean", "false", null, false);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				_tempArray = _parser.getArray(Hierarchy.class, 0, 0);
				hierarchies = new Hierarchy[_tempArray.length];
				for (int _i = 0; _i < hierarchies.length; _i++)
					hierarchies[_i] = (Hierarchy)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		/** Allowable values for {@link #type}. */
		public static final String[] _type_values = {"StandardDimension", "TimeDimension"};
		public String type;  // optional attribute
		public String usagePrefix;  // optional attribute

		/**
		 */
		public Hierarchy[] hierarchies;  //optional array

		public String getName()
		{
			return "Dimension";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "type", type, _indent+1);
			displayAttribute(_out, "usagePrefix", usagePrefix, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayAttribute(_out, "foreignKey", foreignKey, _indent+1);
			displayAttribute(_out, "highCardinality", highCardinality, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElementArray(_out, "hierarchies", hierarchies, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Dimension", new org.eigenbase.xom.XMLAttrVector()
				.add("type", type)
				.add("usagePrefix", usagePrefix)
				.add("visible", visible)
				.add("foreignKey", foreignKey)
				.add("highCardinality", highCardinality)
				.add("name", name)
				.add("caption", caption)
				.add("description", description)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElementArray(_out, hierarchies);
			_out.endTag("Dimension");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Dimension _cother = (Dimension)_other;
			boolean _diff = displayAttributeDiff("type", type, _cother.type, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("usagePrefix", usagePrefix, _cother.usagePrefix, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("hierarchies", hierarchies, _cother.hierarchies, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
// implement CubeDimension
            public Dimension getDimension(Schema schema) {
                Util.assertPrecondition(schema != null, "schema != null");
                return this;
            }

            // Return the dimension's enumerated type.
            public DimensionType getDimensionType() {
                if (type == null) {
                    return null; //DimensionType.StandardDimension;
                } else {
                    return DimensionType.valueOf(type);
                }
            }
		// END pass-through code block ---
	}

	/**
	 * Defines a hierarchy.
	 * You must specify at most one <Relation>
	 * or memberReaderClass. If you specify none, the
	 * hierarchy is assumed to come from the same fact table of the
	 * current cube.
	 */
	public static class Hierarchy extends org.eigenbase.xom.ElementDef
	{
		public Hierarchy()
		{
		}

		public Hierarchy(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				name = (String)_parser.getAttribute("name", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
				hasAll = (Boolean)_parser.getAttribute("hasAll", "Boolean", null, null, true);
				allMemberName = (String)_parser.getAttribute("allMemberName", "String", null, null, false);
				allMemberCaption = (String)_parser.getAttribute("allMemberCaption", "String", null, null, false);
				allLevelName = (String)_parser.getAttribute("allLevelName", "String", null, null, false);
				primaryKey = (String)_parser.getAttribute("primaryKey", "String", null, null, false);
				primaryKeyTable = (String)_parser.getAttribute("primaryKeyTable", "String", null, null, false);
				defaultMember = (String)_parser.getAttribute("defaultMember", "String", null, null, false);
				memberReaderClass = (String)_parser.getAttribute("memberReaderClass", "String", null, null, false);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				uniqueKeyLevelName = (String)_parser.getAttribute("uniqueKeyLevelName", "String", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				relation = (RelationOrJoin)_parser.getElement(RelationOrJoin.class, false);
				_tempArray = _parser.getArray(Level.class, 0, 0);
				levels = new Level[_tempArray.length];
				for (int _i = 0; _i < levels.length; _i++)
					levels[_i] = (Level)_tempArray[_i];
				_tempArray = _parser.getArray(MemberReaderParameter.class, 0, 0);
				memberReaderParameters = new MemberReaderParameter[_tempArray.length];
				for (int _i = 0; _i < memberReaderParameters.length; _i++)
					memberReaderParameters[_i] = (MemberReaderParameter)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // optional attribute
		public Boolean visible;  // attribute default: true
		public Boolean hasAll;  // required attribute
		public String allMemberName;  // optional attribute
		public String allMemberCaption;  // optional attribute
		public String allLevelName;  // optional attribute
		public String primaryKey;  // optional attribute
		public String primaryKeyTable;  // optional attribute
		public String defaultMember;  // optional attribute
		public String memberReaderClass;  // optional attribute
		public String caption;  // optional attribute
		public String description;  // optional attribute
		public String uniqueKeyLevelName;  // optional attribute

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element
		/**
		 * The {@link MondrianDef.Table table},
		 * {@link MondrianDef.Join set of tables},
		 * {@link MondrianDef.View SQL statement}, or
		 * {@link MondrianDef.InlineTable inline table}
		 * which populates this hierarchy.
		 */
		public RelationOrJoin relation;  //optional element
		/**
		 */
		public Level[] levels;  //optional array
		public MemberReaderParameter[] memberReaderParameters;  //optional array

		public String getName()
		{
			return "Hierarchy";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayAttribute(_out, "hasAll", hasAll, _indent+1);
			displayAttribute(_out, "allMemberName", allMemberName, _indent+1);
			displayAttribute(_out, "allMemberCaption", allMemberCaption, _indent+1);
			displayAttribute(_out, "allLevelName", allLevelName, _indent+1);
			displayAttribute(_out, "primaryKey", primaryKey, _indent+1);
			displayAttribute(_out, "primaryKeyTable", primaryKeyTable, _indent+1);
			displayAttribute(_out, "defaultMember", defaultMember, _indent+1);
			displayAttribute(_out, "memberReaderClass", memberReaderClass, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "uniqueKeyLevelName", uniqueKeyLevelName, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElement(_out, "relation", (org.eigenbase.xom.ElementDef) relation, _indent+1);
			displayElementArray(_out, "levels", levels, _indent+1);
			displayElementArray(_out, "memberReaderParameters", memberReaderParameters, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Hierarchy", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("visible", visible)
				.add("hasAll", hasAll)
				.add("allMemberName", allMemberName)
				.add("allMemberCaption", allMemberCaption)
				.add("allLevelName", allLevelName)
				.add("primaryKey", primaryKey)
				.add("primaryKeyTable", primaryKeyTable)
				.add("defaultMember", defaultMember)
				.add("memberReaderClass", memberReaderClass)
				.add("caption", caption)
				.add("description", description)
				.add("uniqueKeyLevelName", uniqueKeyLevelName)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) relation);
			displayXMLElementArray(_out, levels);
			displayXMLElementArray(_out, memberReaderParameters);
			_out.endTag("Hierarchy");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Hierarchy _cother = (Hierarchy)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("visible", visible, _cother.visible, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("hasAll", hasAll, _cother.hasAll, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("allMemberName", allMemberName, _cother.allMemberName, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("allMemberCaption", allMemberCaption, _cother.allMemberCaption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("allLevelName", allLevelName, _cother.allLevelName, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("primaryKey", primaryKey, _cother.primaryKey, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("primaryKeyTable", primaryKeyTable, _cother.primaryKeyTable, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("defaultMember", defaultMember, _cother.defaultMember, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("memberReaderClass", memberReaderClass, _cother.memberReaderClass, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("uniqueKeyLevelName", uniqueKeyLevelName, _cother.uniqueKeyLevelName, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementDiff("relation", relation, _cother.relation, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("levels", levels, _cother.levels, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("memberReaderParameters", memberReaderParameters, _cother.memberReaderParameters, _out, _indent+1);
			return _diff;
		}
	}

	public static class Level extends org.eigenbase.xom.ElementDef
	{
		public Level()
		{
		}

		public Level(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				approxRowCount = (String)_parser.getAttribute("approxRowCount", "String", null, null, false);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", "true", null, false);
				table = (String)_parser.getAttribute("table", "String", null, null, false);
				column = (String)_parser.getAttribute("column", "String", null, null, false);
				nameColumn = (String)_parser.getAttribute("nameColumn", "String", null, null, false);
				ordinalColumn = (String)_parser.getAttribute("ordinalColumn", "String", null, null, false);
				parentColumn = (String)_parser.getAttribute("parentColumn", "String", null, null, false);
				nullParentValue = (String)_parser.getAttribute("nullParentValue", "String", null, null, false);
				type = (String)_parser.getAttribute("type", "String", "String", _type_values, false);
				internalType = (String)_parser.getAttribute("internalType", "String", null, _internalType_values, false);
				uniqueMembers = (Boolean)_parser.getAttribute("uniqueMembers", "Boolean", "false", null, false);
				levelType = (String)_parser.getAttribute("levelType", "String", "Regular", _levelType_values, false);
				hideMemberIf = (String)_parser.getAttribute("hideMemberIf", "String", "Never", _hideMemberIf_values, false);
				formatter = (String)_parser.getAttribute("formatter", "String", null, null, false);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				captionColumn = (String)_parser.getAttribute("captionColumn", "String", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				keyExp = (KeyExpression)_parser.getElement(KeyExpression.class, false);
				nameExp = (NameExpression)_parser.getElement(NameExpression.class, false);
				captionExp = (CaptionExpression)_parser.getElement(CaptionExpression.class, false);
				ordinalExp = (OrdinalExpression)_parser.getElement(OrdinalExpression.class, false);
				parentExp = (ParentExpression)_parser.getElement(ParentExpression.class, false);
				memberFormatter = (MemberFormatter)_parser.getElement(MemberFormatter.class, false);
				closure = (Closure)_parser.getElement(Closure.class, false);
				_tempArray = _parser.getArray(Property.class, 0, 0);
				properties = new Property[_tempArray.length];
				for (int _i = 0; _i < properties.length; _i++)
					properties[_i] = (Property)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String approxRowCount;  // optional attribute
		public String name;  // required attribute
		public Boolean visible;  // attribute default: true
		public String table;  // optional attribute
		public String column;  // optional attribute
		public String nameColumn;  // optional attribute
		public String ordinalColumn;  // optional attribute
		public String parentColumn;  // optional attribute
		public String nullParentValue;  // optional attribute
		/** Allowable values for {@link #type}. */
		public static final String[] _type_values = {"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};
		public String type;  // attribute default: String
		/** Allowable values for {@link #internalType}. */
		public static final String[] _internalType_values = {"int", "long", "Object", "String"};
		public String internalType;  // optional attribute
		public Boolean uniqueMembers;  // attribute default: false
		/** Allowable values for {@link #levelType}. */
		public static final String[] _levelType_values = {"Regular", "TimeYears", "TimeHalfYears", "TimeHalfYear", "TimeQuarters", "TimeMonths", "TimeWeeks", "TimeDays", "TimeHours", "TimeMinutes", "TimeSeconds", "TimeUndefined"};
		public String levelType;  // attribute default: Regular
		/** Allowable values for {@link #hideMemberIf}. */
		public static final String[] _hideMemberIf_values = {"Never", "IfBlankName", "IfParentsName"};
		public String hideMemberIf;  // attribute default: Never
		public String formatter;  // optional attribute
		public String caption;  // optional attribute
		public String description;  // optional attribute
		public String captionColumn;  // optional attribute

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element
		/**
		 * The SQL expression used to populate this level's key.
		 */
		public KeyExpression keyExp;  //optional element
		/**
		 * The SQL expression used to populate this level's name. If not
		 * specified, the level's key is used.
		 */
		public NameExpression nameExp;  //optional element
		/**
		 * The SQL expression used to populate this level's caption. If not
		 * specified, the level's name is used.
		 */
		public CaptionExpression captionExp;  //optional element
		/**
		 * The SQL expression used to populate this level's ordinal.
		 */
		public OrdinalExpression ordinalExp;  //optional element
		/**
		 * The SQL expression used to join to the parent member in a
		 * parent-child hierarchy.
		 */
		public ParentExpression parentExp;  //optional element
		/**
		 * Member formatter.
		 */
		public MemberFormatter memberFormatter;  //optional element
		public Closure closure;  //optional element
		public Property[] properties;  //optional array

		public String getName()
		{
			return "Level";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "approxRowCount", approxRowCount, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayAttribute(_out, "table", table, _indent+1);
			displayAttribute(_out, "column", column, _indent+1);
			displayAttribute(_out, "nameColumn", nameColumn, _indent+1);
			displayAttribute(_out, "ordinalColumn", ordinalColumn, _indent+1);
			displayAttribute(_out, "parentColumn", parentColumn, _indent+1);
			displayAttribute(_out, "nullParentValue", nullParentValue, _indent+1);
			displayAttribute(_out, "type", type, _indent+1);
			displayAttribute(_out, "internalType", internalType, _indent+1);
			displayAttribute(_out, "uniqueMembers", uniqueMembers, _indent+1);
			displayAttribute(_out, "levelType", levelType, _indent+1);
			displayAttribute(_out, "hideMemberIf", hideMemberIf, _indent+1);
			displayAttribute(_out, "formatter", formatter, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "captionColumn", captionColumn, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElement(_out, "keyExp", (org.eigenbase.xom.ElementDef) keyExp, _indent+1);
			displayElement(_out, "nameExp", (org.eigenbase.xom.ElementDef) nameExp, _indent+1);
			displayElement(_out, "captionExp", (org.eigenbase.xom.ElementDef) captionExp, _indent+1);
			displayElement(_out, "ordinalExp", (org.eigenbase.xom.ElementDef) ordinalExp, _indent+1);
			displayElement(_out, "parentExp", (org.eigenbase.xom.ElementDef) parentExp, _indent+1);
			displayElement(_out, "memberFormatter", (org.eigenbase.xom.ElementDef) memberFormatter, _indent+1);
			displayElement(_out, "closure", (org.eigenbase.xom.ElementDef) closure, _indent+1);
			displayElementArray(_out, "properties", properties, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Level", new org.eigenbase.xom.XMLAttrVector()
				.add("approxRowCount", approxRowCount)
				.add("name", name)
				.add("visible", visible)
				.add("table", table)
				.add("column", column)
				.add("nameColumn", nameColumn)
				.add("ordinalColumn", ordinalColumn)
				.add("parentColumn", parentColumn)
				.add("nullParentValue", nullParentValue)
				.add("type", type)
				.add("internalType", internalType)
				.add("uniqueMembers", uniqueMembers)
				.add("levelType", levelType)
				.add("hideMemberIf", hideMemberIf)
				.add("formatter", formatter)
				.add("caption", caption)
				.add("description", description)
				.add("captionColumn", captionColumn)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) keyExp);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) nameExp);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) captionExp);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) ordinalExp);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) parentExp);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) memberFormatter);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) closure);
			displayXMLElementArray(_out, properties);
			_out.endTag("Level");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Level _cother = (Level)_other;
			boolean _diff = displayAttributeDiff("approxRowCount", approxRowCount, _cother.approxRowCount, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("visible", visible, _cother.visible, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("table", table, _cother.table, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("column", column, _cother.column, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("nameColumn", nameColumn, _cother.nameColumn, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("ordinalColumn", ordinalColumn, _cother.ordinalColumn, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("parentColumn", parentColumn, _cother.parentColumn, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("nullParentValue", nullParentValue, _cother.nullParentValue, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("type", type, _cother.type, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("internalType", internalType, _cother.internalType, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("uniqueMembers", uniqueMembers, _cother.uniqueMembers, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("levelType", levelType, _cother.levelType, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("hideMemberIf", hideMemberIf, _cother.hideMemberIf, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("formatter", formatter, _cother.formatter, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("captionColumn", captionColumn, _cother.captionColumn, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementDiff("keyExp", keyExp, _cother.keyExp, _out, _indent+1);
			_diff = _diff && displayElementDiff("nameExp", nameExp, _cother.nameExp, _out, _indent+1);
			_diff = _diff && displayElementDiff("captionExp", captionExp, _cother.captionExp, _out, _indent+1);
			_diff = _diff && displayElementDiff("ordinalExp", ordinalExp, _cother.ordinalExp, _out, _indent+1);
			_diff = _diff && displayElementDiff("parentExp", parentExp, _cother.parentExp, _out, _indent+1);
			_diff = _diff && displayElementDiff("memberFormatter", memberFormatter, _cother.memberFormatter, _out, _indent+1);
			_diff = _diff && displayElementDiff("closure", closure, _cother.closure, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("properties", properties, _cother.properties, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public Expression getKeyExp() {
                if (keyExp != null) {
                    return keyExp;
                } else if (column != null) {
                    return new Column(table, column);
                } else {
                    return null;
                }
            }

            public Expression getNameExp() {
                if (nameExp != null) {
                    return nameExp;
                } else if (nameColumn != null && !Util.equals(nameColumn, column)) {
                    return new Column(table, nameColumn);
                } else {
                    return null;
                }
            }

            public Expression getCaptionExp() {
                if (captionExp != null) {
                    return captionExp;
                } else if (captionColumn != null) {
                    return new Column(table, captionColumn);
                } else {
                    return null;
                }
            }

            public Expression getOrdinalExp() {
                if (ordinalExp != null) {
                    return ordinalExp;
                } else if (ordinalColumn != null) {
                    return new Column(table, ordinalColumn);
                } else {
                    return null;
                }
            }

            public Expression getParentExp() {
                if (parentExp != null) {
                    return parentExp;
                } else if (parentColumn != null) {
                    return new Column(table, parentColumn);
                } else {
                    return null;
                }
            }

            public Expression getPropertyExp(int i) {
                return new Column(table, properties[i].column);
            }

            public mondrian.spi.Dialect.Datatype getDatatype() {
                return mondrian.spi.Dialect.Datatype.valueOf(type);
            }
		// END pass-through code block ---
	}

	/**
	 * Specifies the transitive closure of a parent-child hierarchy.
	 * Optional, but recommended for better performance.
	 * The closure is provided as a set of (parent/child) pairs:
	 * since it is the transitive closure these are actually (ancestor/descendant) pairs.
	 */
	public static class Closure extends org.eigenbase.xom.ElementDef
	{
		public Closure()
		{
		}

		public Closure(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				parentColumn = (String)_parser.getAttribute("parentColumn", "String", null, null, true);
				childColumn = (String)_parser.getAttribute("childColumn", "String", null, null, true);
				table = (Table)_parser.getElement(Table.class, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String parentColumn;  // required attribute
		public String childColumn;  // required attribute

		public Table table;  //required element

		public String getName()
		{
			return "Closure";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "parentColumn", parentColumn, _indent+1);
			displayAttribute(_out, "childColumn", childColumn, _indent+1);
			displayElement(_out, "table", (org.eigenbase.xom.ElementDef) table, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Closure", new org.eigenbase.xom.XMLAttrVector()
				.add("parentColumn", parentColumn)
				.add("childColumn", childColumn)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) table);
			_out.endTag("Closure");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Closure _cother = (Closure)_other;
			boolean _diff = displayAttributeDiff("parentColumn", parentColumn, _cother.parentColumn, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("childColumn", childColumn, _cother.childColumn, _out, _indent+1);
			_diff = _diff && displayElementDiff("table", table, _cother.table, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Member property.
	 */
	public static class Property extends org.eigenbase.xom.ElementDef
	{
		public Property()
		{
		}

		public Property(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, false);
				column = (String)_parser.getAttribute("column", "String", null, null, false);
				type = (String)_parser.getAttribute("type", "String", "String", _type_values, false);
				formatter = (String)_parser.getAttribute("formatter", "String", null, null, false);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				dependsOnLevelValue = (Boolean)_parser.getAttribute("dependsOnLevelValue", "Boolean", null, null, false);
				propertyFormatter = (PropertyFormatter)_parser.getElement(PropertyFormatter.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // optional attribute
		public String column;  // optional attribute
		/** Allowable values for {@link #type}. */
		public static final String[] _type_values = {"String", "Numeric", "Integer", "Long", "Boolean", "Date", "Time", "Timestamp"};
		public String type;  // attribute default: String
		public String formatter;  // optional attribute
		public String caption;  // optional attribute
		public String description;  // optional attribute
		public Boolean dependsOnLevelValue;  // optional attribute

		/**
		 * Property formatter.
		 */
		public PropertyFormatter propertyFormatter;  //optional element

		public String getName()
		{
			return "Property";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "column", column, _indent+1);
			displayAttribute(_out, "type", type, _indent+1);
			displayAttribute(_out, "formatter", formatter, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "dependsOnLevelValue", dependsOnLevelValue, _indent+1);
			displayElement(_out, "propertyFormatter", (org.eigenbase.xom.ElementDef) propertyFormatter, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Property", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("column", column)
				.add("type", type)
				.add("formatter", formatter)
				.add("caption", caption)
				.add("description", description)
				.add("dependsOnLevelValue", dependsOnLevelValue)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) propertyFormatter);
			_out.endTag("Property");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Property _cother = (Property)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("column", column, _cother.column, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("type", type, _cother.type, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("formatter", formatter, _cother.formatter, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("dependsOnLevelValue", dependsOnLevelValue, _cother.dependsOnLevelValue, _out, _indent+1);
			_diff = _diff && displayElementDiff("propertyFormatter", propertyFormatter, _cother.propertyFormatter, _out, _indent+1);
			return _diff;
		}
	}

	public static class Measure extends org.eigenbase.xom.ElementDef
	{
		public Measure()
		{
		}

		public Measure(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				column = (String)_parser.getAttribute("column", "String", null, null, false);
				datatype = (String)_parser.getAttribute("datatype", "String", null, _datatype_values, false);
				formatString = (String)_parser.getAttribute("formatString", "String", null, null, false);
				aggregator = (String)_parser.getAttribute("aggregator", "String", null, null, true);
				formatter = (String)_parser.getAttribute("formatter", "String", null, null, false);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				measureExp = (MeasureExpression)_parser.getElement(MeasureExpression.class, false);
				cellFormatter = (CellFormatter)_parser.getElement(CellFormatter.class, false);
				_tempArray = _parser.getArray(CalculatedMemberProperty.class, 0, 0);
				memberProperties = new CalculatedMemberProperty[_tempArray.length];
				for (int _i = 0; _i < memberProperties.length; _i++)
					memberProperties[_i] = (CalculatedMemberProperty)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String column;  // optional attribute
		/** Allowable values for {@link #datatype}. */
		public static final String[] _datatype_values = {"String", "Numeric", "Integer"};
		public String datatype;  // optional attribute
		public String formatString;  // optional attribute
		public String aggregator;  // required attribute
		public String formatter;  // optional attribute
		public String caption;  // optional attribute
		public String description;  // optional attribute
		public Boolean visible;  // optional attribute

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element
		/**
		 * The SQL expression used to calculate a measure.
		 * Must be specified if a source column is not specified.
		 */
		public MeasureExpression measureExp;  //optional element
		/**
		 * Cell formatter.
		 */
		public CellFormatter cellFormatter;  //optional element
		public CalculatedMemberProperty[] memberProperties;  //optional array

		public String getName()
		{
			return "Measure";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "column", column, _indent+1);
			displayAttribute(_out, "datatype", datatype, _indent+1);
			displayAttribute(_out, "formatString", formatString, _indent+1);
			displayAttribute(_out, "aggregator", aggregator, _indent+1);
			displayAttribute(_out, "formatter", formatter, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElement(_out, "measureExp", (org.eigenbase.xom.ElementDef) measureExp, _indent+1);
			displayElement(_out, "cellFormatter", (org.eigenbase.xom.ElementDef) cellFormatter, _indent+1);
			displayElementArray(_out, "memberProperties", memberProperties, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Measure", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("column", column)
				.add("datatype", datatype)
				.add("formatString", formatString)
				.add("aggregator", aggregator)
				.add("formatter", formatter)
				.add("caption", caption)
				.add("description", description)
				.add("visible", visible)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) measureExp);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) cellFormatter);
			displayXMLElementArray(_out, memberProperties);
			_out.endTag("Measure");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Measure _cother = (Measure)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("column", column, _cother.column, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("datatype", datatype, _cother.datatype, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("formatString", formatString, _cother.formatString, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("aggregator", aggregator, _cother.aggregator, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("formatter", formatter, _cother.formatter, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("visible", visible, _cother.visible, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementDiff("measureExp", measureExp, _cother.measureExp, _out, _indent+1);
			_diff = _diff && displayElementDiff("cellFormatter", cellFormatter, _cother.cellFormatter, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("memberProperties", memberProperties, _cother.memberProperties, _out, _indent+1);
			return _diff;
		}
	}

	public static class CalculatedMember extends org.eigenbase.xom.ElementDef
	{
		public CalculatedMember()
		{
		}

		public CalculatedMember(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				formatString = (String)_parser.getAttribute("formatString", "String", null, null, false);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				formula = (String)_parser.getAttribute("formula", "String", null, null, false);
				dimension = (String)_parser.getAttribute("dimension", "String", null, null, false);
				hierarchy = (String)_parser.getAttribute("hierarchy", "String", null, null, false);
				parent = (String)_parser.getAttribute("parent", "String", null, null, false);
				visible = (Boolean)_parser.getAttribute("visible", "Boolean", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				formulaElement = (Formula)_parser.getElement(Formula.class, false);
				cellFormatter = (CellFormatter)_parser.getElement(CellFormatter.class, false);
				_tempArray = _parser.getArray(CalculatedMemberProperty.class, 0, 0);
				memberProperties = new CalculatedMemberProperty[_tempArray.length];
				for (int _i = 0; _i < memberProperties.length; _i++)
					memberProperties[_i] = (CalculatedMemberProperty)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String formatString;  // optional attribute
		public String caption;  // optional attribute
		public String description;  // optional attribute
		public String formula;  // optional attribute
		public String dimension;  // optional attribute
		public String hierarchy;  // optional attribute
		public String parent;  // optional attribute
		public Boolean visible;  // optional attribute

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element
		/**
		 * MDX expression which gives the value of this member.
		 */
		public Formula formulaElement;  //optional element
		/**
		 * Cell formatter.
		 */
		public CellFormatter cellFormatter;  //optional element
		public CalculatedMemberProperty[] memberProperties;  //optional array

		public String getName()
		{
			return "CalculatedMember";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "formatString", formatString, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "formula", formula, _indent+1);
			displayAttribute(_out, "dimension", dimension, _indent+1);
			displayAttribute(_out, "hierarchy", hierarchy, _indent+1);
			displayAttribute(_out, "parent", parent, _indent+1);
			displayAttribute(_out, "visible", visible, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElement(_out, "formulaElement", (org.eigenbase.xom.ElementDef) formulaElement, _indent+1);
			displayElement(_out, "cellFormatter", (org.eigenbase.xom.ElementDef) cellFormatter, _indent+1);
			displayElementArray(_out, "memberProperties", memberProperties, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("CalculatedMember", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("formatString", formatString)
				.add("caption", caption)
				.add("description", description)
				.add("formula", formula)
				.add("dimension", dimension)
				.add("hierarchy", hierarchy)
				.add("parent", parent)
				.add("visible", visible)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) formulaElement);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) cellFormatter);
			displayXMLElementArray(_out, memberProperties);
			_out.endTag("CalculatedMember");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			CalculatedMember _cother = (CalculatedMember)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("formatString", formatString, _cother.formatString, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("formula", formula, _cother.formula, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("dimension", dimension, _cother.dimension, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("hierarchy", hierarchy, _cother.hierarchy, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("parent", parent, _cother.parent, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("visible", visible, _cother.visible, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementDiff("formulaElement", formulaElement, _cother.formulaElement, _out, _indent+1);
			_diff = _diff && displayElementDiff("cellFormatter", cellFormatter, _cother.cellFormatter, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("memberProperties", memberProperties, _cother.memberProperties, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
/**
              * Returns the formula, looking for a sub-element called
              * "Formula" first, then looking for an attribute called
              * "formula".
              */
            public String getFormula() {
                if (formulaElement != null) {
                    return formulaElement.cdata;
                } else {
                    return formula;
                }
            }
            /**
              * Returns the format string, looking for a property called
              * "FORMAT_STRING" first, then looking for an attribute called
              * "formatString".
              */
            public String getFormatString() {
                for (CalculatedMemberProperty prop : memberProperties) {
                    if (prop.name.equals(
                        mondrian.olap.Property.FORMAT_STRING.name))
                    {
                        return prop.value;
                    }
                }
                return formatString;
            }
		// END pass-through code block ---
	}

	/**
	 * Property of a calculated member defined against a cube.
	 * It must have either an expression or a value.
	 */
	public static class CalculatedMemberProperty extends org.eigenbase.xom.ElementDef
	{
		public CalculatedMemberProperty()
		{
		}

		public CalculatedMemberProperty(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				expression = (String)_parser.getAttribute("expression", "String", null, null, false);
				value = (String)_parser.getAttribute("value", "String", null, null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String caption;  // optional attribute
		public String description;  // optional attribute
		public String expression;  // optional attribute
		public String value;  // optional attribute


		public String getName()
		{
			return "CalculatedMemberProperty";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "expression", expression, _indent+1);
			displayAttribute(_out, "value", value, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("CalculatedMemberProperty", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("caption", caption)
				.add("description", description)
				.add("expression", expression)
				.add("value", value)
				);
			_out.endTag("CalculatedMemberProperty");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			CalculatedMemberProperty _cother = (CalculatedMemberProperty)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("expression", expression, _cother.expression, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("value", value, _cother.value, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * <p>Defines a named set which can be used in queries in the
	 * same way as a set defined using a WITH SET clause.</p>
	 * <p>A named set can be defined against a particular cube,
	 * or can be global to a schema. If it is defined against a
	 * cube, it is only available to queries which use that cube.</p>
	 * <p>A named set defined against a cube is not inherited by
	 * a virtual cubes defined against that cube. (But you can
	 * define a named set against a virtual cube.)</p>
	 * <p>A named set defined against a schema is available in
	 * all cubes and virtual cubes in that schema. However, it is
	 * only valid if the cube contains dimensions with the names
	 * required to make the formula valid.</p>
	 */
	public static class NamedSet extends org.eigenbase.xom.ElementDef
	{
		public NamedSet()
		{
		}

		public NamedSet(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				caption = (String)_parser.getAttribute("caption", "String", null, null, false);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				formula = (String)_parser.getAttribute("formula", "String", null, null, false);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				formulaElement = (Formula)_parser.getElement(Formula.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String caption;  // optional attribute
		public String description;  // optional attribute
		public String formula;  // optional attribute

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element
		/**
		 * MDX expression which gives the value of this set.
		 */
		public Formula formulaElement;  //optional element

		public String getName()
		{
			return "NamedSet";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "caption", caption, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "formula", formula, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElement(_out, "formulaElement", (org.eigenbase.xom.ElementDef) formulaElement, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("NamedSet", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("caption", caption)
				.add("description", description)
				.add("formula", formula)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) formulaElement);
			_out.endTag("NamedSet");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			NamedSet _cother = (NamedSet)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("caption", caption, _cother.caption, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("formula", formula, _cother.formula, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementDiff("formulaElement", formulaElement, _cother.formulaElement, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
/**
              * Returns the formula, looking for a sub-element called
              * "Formula" first, then looking for an attribute called
              * "formula".
              */
            public String getFormula() {
                if (formulaElement != null) {
                    return formulaElement.cdata;
                } else {
                    return formula;
                }
            }
		// END pass-through code block ---
	}

	public static class Formula extends org.eigenbase.xom.ElementDef
	{
		public Formula()
		{
		}

		public Formula(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				cdata = _parser.getText();
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}


		public String cdata;  // All text goes here
		public String getName()
		{
			return "Formula";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayString(_out, "cdata", cdata, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Formula", new org.eigenbase.xom.XMLAttrVector()
				);
			_out.cdata(cdata);
			_out.endTag("Formula");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Formula _cother = (Formula)_other;
			boolean _diff = displayStringDiff("cdata", cdata, _cother.cdata, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Not used
	 */
	public static class MemberReaderParameter extends org.eigenbase.xom.ElementDef
	{
		public MemberReaderParameter()
		{
		}

		public MemberReaderParameter(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, false);
				value = (String)_parser.getAttribute("value", "String", null, null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // optional attribute
		public String value;  // optional attribute


		public String getName()
		{
			return "MemberReaderParameter";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "value", value, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("MemberReaderParameter", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("value", value)
				);
			_out.endTag("MemberReaderParameter");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			MemberReaderParameter _cother = (MemberReaderParameter)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("value", value, _cother.value, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * A table or a join
	 */
	public static abstract class RelationOrJoin extends org.eigenbase.xom.ElementDef
	{
		public RelationOrJoin()
		{
		}

		public RelationOrJoin(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
		}



		public String getName()
		{
			return "RelationOrJoin";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("RelationOrJoin", new org.eigenbase.xom.XMLAttrVector()
				);
			_out.endTag("RelationOrJoin");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			return true;
		}
		// BEGIN pass-through code block ---
public abstract Relation find(String seekAlias);
            public boolean equals(Object o) {
                return this == o;
            }
            public int hashCode() {
                return System.identityHashCode(this);
            }
		// END pass-through code block ---
	}

	/**
	 * A table, inline table or view
	 */
	public static abstract class Relation extends RelationOrJoin
	{
		public Relation()
		{
		}

		public Relation(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
		}



		public String getName()
		{
			return "Relation";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Relation", new org.eigenbase.xom.XMLAttrVector()
				);
			_out.endTag("Relation");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			return true;
		}
		// BEGIN pass-through code block ---
public abstract String getAlias();
		// END pass-through code block ---
	}

	/**
	 * A collection of SQL statements, one per dialect.
	 */
	public static class View extends Relation
	{
		public View()
		{
		}

		public View(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				alias = (String)_parser.getAttribute("alias", "String", null, null, true);
				_tempArray = _parser.getArray(SQL.class, 1, 0);
				selects = new SQL[_tempArray.length];
				for (int _i = 0; _i < selects.length; _i++)
					selects[_i] = (SQL)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String alias;  // required attribute

		public SQL[] selects;  //min 1

		public String getName()
		{
			return "View";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "alias", alias, _indent+1);
			displayElementArray(_out, "selects", selects, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("View", new org.eigenbase.xom.XMLAttrVector()
				.add("alias", alias)
				);
			displayXMLElementArray(_out, selects);
			_out.endTag("View");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			View _cother = (View)_other;
			boolean _diff = displayAttributeDiff("alias", alias, _cother.alias, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("selects", selects, _cother.selects, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
/**
             * Copy constructor.
             */
            public View(View view) {
                this.alias = view.alias;
                this.selects = view.selects.clone();
            }
            public String toString() {
                return selects[0].cdata;
            }

            public View find(String seekAlias) {
                if (seekAlias.equals(alias)) {
                    return this;
                } else {
                    return null;
                }
            }

            public String getAlias() {
                return alias;
            }

            public SqlQuery.CodeSet getCodeSet() {
                return SQL.toCodeSet(selects);
            }

            public void addCode(String dialect, String code) {
                if (selects == null) {
                    selects = new SQL[1];
                } else {
                    SQL[] olds = selects;
                    selects = new SQL[olds.length + 1];
                    System.arraycopy(olds, 0, selects, 0, olds.length);
                }
                SQL sql = new SQL();
                sql.dialect = dialect;
                sql.cdata = code;
                selects[selects.length - 1] = sql;
            }

            public boolean equals(Object o) {
                if (o instanceof View) {
                    View that = (View) o;
                    if (!Util.equals(this.alias, that.alias)) {
                        return false;
                    }
                    if (this.selects == null || that.selects == null || this.selects.length != that.selects.length) {
                        return false;
                    }
                    for (int i = 0; i < selects.length; i++) {
                        if (!Util.equals(this.selects[i].dialect, that.selects[i].dialect)
                            || !Util.equals(this.selects[i].cdata, that.selects[i].cdata))
                        {
                            return false;
                        }
                    }
                    return true;
                } else {
                    return false;
                }
            }
		// END pass-through code block ---
	}

	public static class SQL extends org.eigenbase.xom.ElementDef
	{
		public SQL()
		{
		}

		public SQL(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				dialect = (String)_parser.getAttribute("dialect", "String", "generic", null, true);
				cdata = _parser.getText();
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String dialect;  // attribute default: generic

		public String cdata;  // All text goes here
		public String getName()
		{
			return "SQL";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "dialect", dialect, _indent+1);
			displayString(_out, "cdata", cdata, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("SQL", new org.eigenbase.xom.XMLAttrVector()
				.add("dialect", dialect)
				);
			_out.cdata(cdata);
			_out.endTag("SQL");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			SQL _cother = (SQL)_other;
			boolean _diff = displayAttributeDiff("dialect", dialect, _cother.dialect, _out, _indent+1);
			_diff = _diff && displayStringDiff("cdata", cdata, _cother.cdata, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public int hashCode() {
                return dialect.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof SQL)) {
                    return false;
                }
                SQL that = (SQL) obj;
                return this.dialect.equals(that.dialect) &&
                        Util.equals(this.cdata, that.cdata);
            }

            /**
             * Converts an array of SQL to a
             * {@link mondrian.rolap.sql.SqlQuery.CodeSet} object.
             */
            public static SqlQuery.CodeSet toCodeSet(SQL[] sqls) {
                SqlQuery.CodeSet codeSet = new SqlQuery.CodeSet();
                for (SQL sql : sqls) {
                    codeSet.put(sql.dialect, sql.cdata);
                }
                return codeSet;
            }
		// END pass-through code block ---
	}

	public static class Join extends RelationOrJoin
	{
		public Join()
		{
		}

		public Join(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				leftAlias = (String)_parser.getAttribute("leftAlias", "String", null, null, false);
				leftKey = (String)_parser.getAttribute("leftKey", "String", null, null, true);
				rightAlias = (String)_parser.getAttribute("rightAlias", "String", null, null, false);
				rightKey = (String)_parser.getAttribute("rightKey", "String", null, null, true);
				left = (RelationOrJoin)_parser.getElement(RelationOrJoin.class, true);
				right = (RelationOrJoin)_parser.getElement(RelationOrJoin.class, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String leftAlias;  // optional attribute
		public String leftKey;  // required attribute
		public String rightAlias;  // optional attribute
		public String rightKey;  // required attribute

		public RelationOrJoin left;  //required element
		public RelationOrJoin right;  //required element

		public String getName()
		{
			return "Join";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "leftAlias", leftAlias, _indent+1);
			displayAttribute(_out, "leftKey", leftKey, _indent+1);
			displayAttribute(_out, "rightAlias", rightAlias, _indent+1);
			displayAttribute(_out, "rightKey", rightKey, _indent+1);
			displayElement(_out, "left", (org.eigenbase.xom.ElementDef) left, _indent+1);
			displayElement(_out, "right", (org.eigenbase.xom.ElementDef) right, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Join", new org.eigenbase.xom.XMLAttrVector()
				.add("leftAlias", leftAlias)
				.add("leftKey", leftKey)
				.add("rightAlias", rightAlias)
				.add("rightKey", rightKey)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) left);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) right);
			_out.endTag("Join");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Join _cother = (Join)_other;
			boolean _diff = displayAttributeDiff("leftAlias", leftAlias, _cother.leftAlias, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("leftKey", leftKey, _cother.leftKey, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("rightAlias", rightAlias, _cother.rightAlias, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("rightKey", rightKey, _cother.rightKey, _out, _indent+1);
			_diff = _diff && displayElementDiff("left", left, _cother.left, _out, _indent+1);
			_diff = _diff && displayElementDiff("right", right, _cother.right, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
/** Convenience constructor. */
            public Join(
                String leftAlias,
                String leftKey,
                RelationOrJoin left,
                String rightAlias, 
                String rightKey,
                RelationOrJoin right)
            {
                this.leftAlias = leftAlias;
                this.leftKey = leftKey;
                this.left = left;
                this.rightAlias = rightAlias;
                this.rightKey = rightKey;
                this.right = right;
            }
            /**
              * Returns the alias of the left join key, defaulting to left's
              * alias if left is a table.
              */
            public String getLeftAlias() {
                if (leftAlias != null) {
                    return leftAlias;
                }
                if (left instanceof Relation) {
                    return ((Relation) left).getAlias();
                }
                throw Util.newInternal(
                    "alias is required because " + left + " is not a table");
            }
            /**
              * Returns the alias of the right join key, defaulting to right's
              * alias if right is a table.
              */
            public String getRightAlias() {
                if (rightAlias != null) {
                    return rightAlias;
                }
                if (right instanceof Relation) {
                    return ((Relation) right).getAlias();
                }
                if (right instanceof Join) {
                    return ((Join) right).getLeftAlias();
                }
                throw Util.newInternal(
                    "alias is required because " + right + " is not a table");
            }
            public String toString() {
                return "(" + left + ") join (" + right + ") on " +
                    leftAlias + "." + leftKey + " = " +
                    rightAlias + "." + rightKey;
            }
            public Relation find(String seekAlias) {
                Relation relation = left.find(seekAlias);
                if (relation == null) {
                    relation = right.find(seekAlias);
                }
                return relation;
            }
		// END pass-through code block ---
	}

	public static class Table extends Relation
	{
		public Table()
		{
		}

		public Table(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				schema = (String)_parser.getAttribute("schema", "String", null, null, false);
				alias = (String)_parser.getAttribute("alias", "String", null, null, false);
				filter = (SQL)_parser.getElement(SQL.class, false);
				_tempArray = _parser.getArray(AggExclude.class, 0, 0);
				aggExcludes = new AggExclude[_tempArray.length];
				for (int _i = 0; _i < aggExcludes.length; _i++)
					aggExcludes[_i] = (AggExclude)_tempArray[_i];
				_tempArray = _parser.getArray(AggTable.class, 0, 0);
				aggTables = new AggTable[_tempArray.length];
				for (int _i = 0; _i < aggTables.length; _i++)
					aggTables[_i] = (AggTable)_tempArray[_i];
				_tempArray = _parser.getArray(Hint.class, 0, 0);
				tableHints = new Hint[_tempArray.length];
				for (int _i = 0; _i < tableHints.length; _i++)
					tableHints[_i] = (Hint)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String schema;  // optional attribute
		public String alias;  // optional attribute

		/**
		 * The SQL WHERE clause expression to be appended to any select statement
		 */
		public SQL filter;  //optional element
		public AggExclude[] aggExcludes;  //optional array
		public AggTable[] aggTables;  //optional array
		/**
		 * Table optimization hints; may be ignored by dialect.
		 */
		public Hint[] tableHints;  //optional array

		public String getName()
		{
			return "Table";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "schema", schema, _indent+1);
			displayAttribute(_out, "alias", alias, _indent+1);
			displayElement(_out, "filter", (org.eigenbase.xom.ElementDef) filter, _indent+1);
			displayElementArray(_out, "aggExcludes", aggExcludes, _indent+1);
			displayElementArray(_out, "aggTables", aggTables, _indent+1);
			displayElementArray(_out, "tableHints", tableHints, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Table", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("schema", schema)
				.add("alias", alias)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) filter);
			displayXMLElementArray(_out, aggExcludes);
			displayXMLElementArray(_out, aggTables);
			displayXMLElementArray(_out, tableHints);
			_out.endTag("Table");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Table _cother = (Table)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("schema", schema, _cother.schema, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("alias", alias, _cother.alias, _out, _indent+1);
			_diff = _diff && displayElementDiff("filter", filter, _cother.filter, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("aggExcludes", aggExcludes, _cother.aggExcludes, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("aggTables", aggTables, _cother.aggTables, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("tableHints", tableHints, _cother.tableHints, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
private java.util.Map<String,String> hintMap;
            /** Convenience constructor. */
            public Table(Table table) {
                this(table.schema, table.name, table.alias, table.tableHints);
            }
            public Table(String schema, String name, String alias, Hint[] tablehints) {
                this();
                this.schema = schema;
                this.name = name;
                this.alias = alias;
                this.hintMap = buildHintMap(tablehints);
            }

            public Table(Table tbl, String possibleName) {
                this(tbl.schema, tbl.name, possibleName, tbl.tableHints);
                
                // Remake the filter with the new alias
                if (tbl.filter != null) {
                    this.filter = new SQL();
                    this.filter.dialect = tbl.filter.dialect;
                     if (tbl.filter.cdata != null) {
                        this.filter.cdata =
                            tbl.filter.cdata.replace(
                                tbl.alias == null
                                    ? tbl.name
                                    : tbl.alias,
                                possibleName);
                    }
                }
            }
            
            private java.util.Map<String,String> buildHintMap(Hint[] th) {
                java.util.Map<String,String> h =
                    new java.util.HashMap<String,String>();
                if (th != null) {
                    for (int i = 0; i < th.length; i++) {
                        h.put(th[i].type, th[i].cdata);
                    }
                }
                return h;
            }
            /** Returns the alias or, if it is null, the table name. */
            public String getAlias() {
                return (alias != null) ? alias : name;
            }
            public String toString() {
                return (schema == null) ?
                    name :
                    schema + "." + name;
            }
            public Table find(String seekAlias) {
                return seekAlias.equals(name) ? this :
                    (alias != null) && seekAlias.equals(alias) ? this :
                    null;
            }
            public boolean equals(Object o) {
                if (o instanceof Table) {
                    Table that = (Table) o;
                    return this.name.equals(that.name) &&
                        Util.equals(this.alias, that.alias) &&
                        Util.equals(this.schema, that.schema);
                } else {
                    return false;
                }
            }
            public int hashCode() {
                return toString().hashCode();
            }
            public String getFilter() {
                return (filter == null) ? null : filter.cdata;
            }
            public AggExclude[] getAggExcludes() {
                return aggExcludes;
            }
            public AggTable[] getAggTables() {
                return aggTables;
            }
            public java.util.Map<String,String> getHintMap() {
                if (hintMap == null) {
                    hintMap = buildHintMap(this.tableHints);
                }
                return hintMap;
            }
		// END pass-through code block ---
	}

	/**
	 * Dialect-specific table optimization hints.
	 */
	public static class Hint extends org.eigenbase.xom.ElementDef
	{
		public Hint()
		{
		}

		public Hint(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				type = (String)_parser.getAttribute("type", "String", null, null, true);
				cdata = _parser.getText();
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String type;  // required attribute

		public String cdata;  // All text goes here
		public String getName()
		{
			return "Hint";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "type", type, _indent+1);
			displayString(_out, "cdata", cdata, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Hint", new org.eigenbase.xom.XMLAttrVector()
				.add("type", type)
				);
			_out.cdata(cdata);
			_out.endTag("Hint");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Hint _cother = (Hint)_other;
			boolean _diff = displayAttributeDiff("type", type, _cother.type, _out, _indent+1);
			_diff = _diff && displayStringDiff("cdata", cdata, _cother.cdata, _out, _indent+1);
			return _diff;
		}
	}

	public static class InlineTable extends Relation
	{
		public InlineTable()
		{
		}

		public InlineTable(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				alias = (String)_parser.getAttribute("alias", "String", null, null, false);
				columnDefs = (ColumnDefs)_parser.getElement(ColumnDefs.class, true);
				rows = (Rows)_parser.getElement(Rows.class, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String alias;  // optional attribute

		public ColumnDefs columnDefs;  //required element
		public Rows rows;  //required element

		public String getName()
		{
			return "InlineTable";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "alias", alias, _indent+1);
			displayElement(_out, "columnDefs", (org.eigenbase.xom.ElementDef) columnDefs, _indent+1);
			displayElement(_out, "rows", (org.eigenbase.xom.ElementDef) rows, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("InlineTable", new org.eigenbase.xom.XMLAttrVector()
				.add("alias", alias)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) columnDefs);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) rows);
			_out.endTag("InlineTable");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			InlineTable _cother = (InlineTable)_other;
			boolean _diff = displayAttributeDiff("alias", alias, _cother.alias, _out, _indent+1);
			_diff = _diff && displayElementDiff("columnDefs", columnDefs, _cother.columnDefs, _out, _indent+1);
			_diff = _diff && displayElementDiff("rows", rows, _cother.rows, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
/** Convenience constructor. */
            public InlineTable(InlineTable inlineTable) {
                this.alias = inlineTable.alias;
                this.columnDefs = new ColumnDefs();
                this.columnDefs.array = inlineTable.columnDefs.array.clone();
                this.rows = new Rows();
                this.rows.array = inlineTable.rows.array.clone();
            }
            public String getAlias() {
                return alias;
            }
            public String toString() {
                return "<inline data>";
            }
            public InlineTable find(String seekAlias) {
                return seekAlias.equals(this.alias) ? this : null;
            }
            public boolean equals(Object o) {
                if (o instanceof InlineTable) {
                    InlineTable that = (InlineTable) o;
                    return this.alias.equals(that.alias);
                } else {
                    return false;
                }
            }
            public int hashCode() {
                return toString().hashCode();
            }
		// END pass-through code block ---
	}

	/**
	 * Holder for an array of ColumnDef elements
	 */
	public static class ColumnDefs extends org.eigenbase.xom.ElementDef
	{
		public ColumnDefs()
		{
		}

		public ColumnDefs(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(ColumnDef.class, 0, 0);
				array = new ColumnDef[_tempArray.length];
				for (int _i = 0; _i < array.length; _i++)
					array[_i] = (ColumnDef)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}


		public ColumnDef[] array;  //optional array

		public String getName()
		{
			return "ColumnDefs";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "array", array, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("ColumnDefs", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, array);
			_out.endTag("ColumnDefs");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			ColumnDefs _cother = (ColumnDefs)_other;
			boolean _diff = displayElementArrayDiff("array", array, _cother.array, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Column definition for an inline table.
	 */
	public static class ColumnDef extends org.eigenbase.xom.ElementDef
	{
		public ColumnDef()
		{
		}

		public ColumnDef(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				type = (String)_parser.getAttribute("type", "String", null, _type_values, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		/** Allowable values for {@link #type}. */
		public static final String[] _type_values = {"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};
		public String type;  // required attribute


		public String getName()
		{
			return "ColumnDef";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "type", type, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("ColumnDef", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("type", type)
				);
			_out.endTag("ColumnDef");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			ColumnDef _cother = (ColumnDef)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("type", type, _cother.type, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Holder for an array of Row elements
	 */
	public static class Rows extends org.eigenbase.xom.ElementDef
	{
		public Rows()
		{
		}

		public Rows(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(Row.class, 0, 0);
				array = new Row[_tempArray.length];
				for (int _i = 0; _i < array.length; _i++)
					array[_i] = (Row)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}


		public Row[] array;  //optional array

		public String getName()
		{
			return "Rows";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "array", array, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Rows", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, array);
			_out.endTag("Rows");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Rows _cother = (Rows)_other;
			boolean _diff = displayElementArrayDiff("array", array, _cother.array, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Row definition for an inline table.
	 * Must have one Column for each ColumnDef in the InlineTable.
	 */
	public static class Row extends org.eigenbase.xom.ElementDef
	{
		public Row()
		{
		}

		public Row(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(Value.class, 0, 0);
				values = new Value[_tempArray.length];
				for (int _i = 0; _i < values.length; _i++)
					values[_i] = (Value)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}


		public Value[] values;  //optional array

		public String getName()
		{
			return "Row";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "values", values, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Row", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, values);
			_out.endTag("Row");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Row _cother = (Row)_other;
			boolean _diff = displayElementArrayDiff("values", values, _cother.values, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Column value for an inline table.
	 * The CDATA holds the value of the column.
	 */
	public static class Value extends org.eigenbase.xom.ElementDef
	{
		public Value()
		{
		}

		public Value(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				column = (String)_parser.getAttribute("column", "String", null, null, true);
				cdata = _parser.getText();
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String column;  // required attribute

		public String cdata;  // All text goes here
		public String getName()
		{
			return "Value";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "column", column, _indent+1);
			displayString(_out, "cdata", cdata, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Value", new org.eigenbase.xom.XMLAttrVector()
				.add("column", column)
				);
			_out.cdata(cdata);
			_out.endTag("Value");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Value _cother = (Value)_other;
			boolean _diff = displayAttributeDiff("column", column, _cother.column, _out, _indent+1);
			_diff = _diff && displayStringDiff("cdata", cdata, _cother.cdata, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * A definition of an aggregate table for a base fact table.
	 * This aggregate table must be in the same schema as the
	 * base fact table.
	 */
	public static abstract class AggTable extends org.eigenbase.xom.ElementDef
	{
		public AggTable()
		{
		}

		public AggTable(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
				factcount = (AggFactCount)_parser.getElement(AggFactCount.class, true);
				_tempArray = _parser.getArray(AggMeasureFactCount.class, 0, 0);
				measuresfactcount = new AggMeasureFactCount[_tempArray.length];
				for (int _i = 0; _i < measuresfactcount.length; _i++)
					measuresfactcount[_i] = (AggMeasureFactCount)_tempArray[_i];
				_tempArray = _parser.getArray(AggIgnoreColumn.class, 0, 0);
				ignoreColumns = new AggIgnoreColumn[_tempArray.length];
				for (int _i = 0; _i < ignoreColumns.length; _i++)
					ignoreColumns[_i] = (AggIgnoreColumn)_tempArray[_i];
				_tempArray = _parser.getArray(AggForeignKey.class, 0, 0);
				foreignKeys = new AggForeignKey[_tempArray.length];
				for (int _i = 0; _i < foreignKeys.length; _i++)
					foreignKeys[_i] = (AggForeignKey)_tempArray[_i];
				_tempArray = _parser.getArray(AggMeasure.class, 0, 0);
				measures = new AggMeasure[_tempArray.length];
				for (int _i = 0; _i < measures.length; _i++)
					measures[_i] = (AggMeasure)_tempArray[_i];
				_tempArray = _parser.getArray(AggLevel.class, 0, 0);
				levels = new AggLevel[_tempArray.length];
				for (int _i = 0; _i < levels.length; _i++)
					levels[_i] = (AggLevel)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public Boolean ignorecase;  // attribute default: true

		/**
		 * What does the fact_count column look like.
		 */
		public AggFactCount factcount;  //required element
		/**
		 * What does the fact_count for specific measure column look like.
		 */
		public AggMeasureFactCount[] measuresfactcount;  //optional array
		public AggIgnoreColumn[] ignoreColumns;  //optional array
		public AggForeignKey[] foreignKeys;  //optional array
		public AggMeasure[] measures;  //optional array
		public AggLevel[] levels;  //optional array

		public String getName()
		{
			return "AggTable";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "ignorecase", ignorecase, _indent+1);
			displayElement(_out, "factcount", (org.eigenbase.xom.ElementDef) factcount, _indent+1);
			displayElementArray(_out, "measuresfactcount", measuresfactcount, _indent+1);
			displayElementArray(_out, "ignoreColumns", ignoreColumns, _indent+1);
			displayElementArray(_out, "foreignKeys", foreignKeys, _indent+1);
			displayElementArray(_out, "measures", measures, _indent+1);
			displayElementArray(_out, "levels", levels, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggTable", new org.eigenbase.xom.XMLAttrVector()
				.add("ignorecase", ignorecase)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) factcount);
			displayXMLElementArray(_out, measuresfactcount);
			displayXMLElementArray(_out, ignoreColumns);
			displayXMLElementArray(_out, foreignKeys);
			displayXMLElementArray(_out, measures);
			displayXMLElementArray(_out, levels);
			_out.endTag("AggTable");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggTable _cother = (AggTable)_other;
			boolean _diff = displayAttributeDiff("ignorecase", ignorecase, _cother.ignorecase, _out, _indent+1);
			_diff = _diff && displayElementDiff("factcount", factcount, _cother.factcount, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("measuresfactcount", measuresfactcount, _cother.measuresfactcount, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("ignoreColumns", ignoreColumns, _cother.ignoreColumns, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("foreignKeys", foreignKeys, _cother.foreignKeys, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("measures", measures, _cother.measures, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("levels", levels, _cother.levels, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public boolean isIgnoreCase() {
                return ignorecase.booleanValue();
            }
            public AggFactCount getAggFactCount() {
                return factcount;
            }

            public AggMeasureFactCount[] getMeasuresFactCount() {
                return measuresfactcount;
            }

            public AggIgnoreColumn[] getAggIgnoreColumns() {
                return ignoreColumns;
            }
            public AggForeignKey[] getAggForeignKeys() {
                return foreignKeys;
            }
            public AggMeasure[] getAggMeasures() {
                return measures;
            }
            public AggLevel[] getAggLevels() {
                return levels;
            }
		// END pass-through code block ---
	}

	public static class AggName extends AggTable
	{
		public AggName()
		{
		}

		public AggName(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				approxRowCount = (String)_parser.getAttribute("approxRowCount", "String", null, null, false);
				ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
				factcount = (AggFactCount)_parser.getElement(AggFactCount.class, true);
				_tempArray = _parser.getArray(AggMeasureFactCount.class, 0, 0);
				measuresfactcount = new AggMeasureFactCount[_tempArray.length];
				for (int _i = 0; _i < measuresfactcount.length; _i++)
					measuresfactcount[_i] = (AggMeasureFactCount)_tempArray[_i];
				_tempArray = _parser.getArray(AggIgnoreColumn.class, 0, 0);
				ignoreColumns = new AggIgnoreColumn[_tempArray.length];
				for (int _i = 0; _i < ignoreColumns.length; _i++)
					ignoreColumns[_i] = (AggIgnoreColumn)_tempArray[_i];
				_tempArray = _parser.getArray(AggForeignKey.class, 0, 0);
				foreignKeys = new AggForeignKey[_tempArray.length];
				for (int _i = 0; _i < foreignKeys.length; _i++)
					foreignKeys[_i] = (AggForeignKey)_tempArray[_i];
				_tempArray = _parser.getArray(AggMeasure.class, 0, 0);
				measures = new AggMeasure[_tempArray.length];
				for (int _i = 0; _i < measures.length; _i++)
					measures[_i] = (AggMeasure)_tempArray[_i];
				_tempArray = _parser.getArray(AggLevel.class, 0, 0);
				levels = new AggLevel[_tempArray.length];
				for (int _i = 0; _i < levels.length; _i++)
					levels[_i] = (AggLevel)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String approxRowCount;  // optional attribute


		public String getName()
		{
			return "AggName";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "approxRowCount", approxRowCount, _indent+1);
			displayAttribute(_out, "ignorecase", ignorecase, _indent+1);
			displayElement(_out, "factcount", (org.eigenbase.xom.ElementDef) factcount, _indent+1);
			displayElementArray(_out, "measuresfactcount", measuresfactcount, _indent+1);
			displayElementArray(_out, "ignoreColumns", ignoreColumns, _indent+1);
			displayElementArray(_out, "foreignKeys", foreignKeys, _indent+1);
			displayElementArray(_out, "measures", measures, _indent+1);
			displayElementArray(_out, "levels", levels, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggName", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("approxRowCount", approxRowCount)
				.add("ignorecase", ignorecase)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) factcount);
			displayXMLElementArray(_out, measuresfactcount);
			displayXMLElementArray(_out, ignoreColumns);
			displayXMLElementArray(_out, foreignKeys);
			displayXMLElementArray(_out, measures);
			displayXMLElementArray(_out, levels);
			_out.endTag("AggName");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggName _cother = (AggName)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("approxRowCount", approxRowCount, _cother.approxRowCount, _out, _indent+1);
			_diff = _diff && displayElementDiff("factcount", factcount, _cother.factcount, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("measuresfactcount", measuresfactcount, _cother.measuresfactcount, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("ignoreColumns", ignoreColumns, _cother.ignoreColumns, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("foreignKeys", foreignKeys, _cother.foreignKeys, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("measures", measures, _cother.measures, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("levels", levels, _cother.levels, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getNameAttribute() {
                return name;
            }
            public String getApproxRowCountAttribute() {
                return approxRowCount;
            }
		// END pass-through code block ---
	}

	public static class AggPattern extends AggTable
	{
		public AggPattern()
		{
		}

		public AggPattern(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				pattern = (String)_parser.getAttribute("pattern", "String", null, null, true);
				ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
				factcount = (AggFactCount)_parser.getElement(AggFactCount.class, true);
				_tempArray = _parser.getArray(AggMeasureFactCount.class, 0, 0);
				measuresfactcount = new AggMeasureFactCount[_tempArray.length];
				for (int _i = 0; _i < measuresfactcount.length; _i++)
					measuresfactcount[_i] = (AggMeasureFactCount)_tempArray[_i];
				_tempArray = _parser.getArray(AggIgnoreColumn.class, 0, 0);
				ignoreColumns = new AggIgnoreColumn[_tempArray.length];
				for (int _i = 0; _i < ignoreColumns.length; _i++)
					ignoreColumns[_i] = (AggIgnoreColumn)_tempArray[_i];
				_tempArray = _parser.getArray(AggForeignKey.class, 0, 0);
				foreignKeys = new AggForeignKey[_tempArray.length];
				for (int _i = 0; _i < foreignKeys.length; _i++)
					foreignKeys[_i] = (AggForeignKey)_tempArray[_i];
				_tempArray = _parser.getArray(AggMeasure.class, 0, 0);
				measures = new AggMeasure[_tempArray.length];
				for (int _i = 0; _i < measures.length; _i++)
					measures[_i] = (AggMeasure)_tempArray[_i];
				_tempArray = _parser.getArray(AggLevel.class, 0, 0);
				levels = new AggLevel[_tempArray.length];
				for (int _i = 0; _i < levels.length; _i++)
					levels[_i] = (AggLevel)_tempArray[_i];
				_tempArray = _parser.getArray(AggExclude.class, 0, 0);
				excludes = new AggExclude[_tempArray.length];
				for (int _i = 0; _i < excludes.length; _i++)
					excludes[_i] = (AggExclude)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String pattern;  // required attribute

		public AggExclude[] excludes;  //optional array

		public String getName()
		{
			return "AggPattern";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "pattern", pattern, _indent+1);
			displayAttribute(_out, "ignorecase", ignorecase, _indent+1);
			displayElement(_out, "factcount", (org.eigenbase.xom.ElementDef) factcount, _indent+1);
			displayElementArray(_out, "measuresfactcount", measuresfactcount, _indent+1);
			displayElementArray(_out, "ignoreColumns", ignoreColumns, _indent+1);
			displayElementArray(_out, "foreignKeys", foreignKeys, _indent+1);
			displayElementArray(_out, "measures", measures, _indent+1);
			displayElementArray(_out, "levels", levels, _indent+1);
			displayElementArray(_out, "excludes", excludes, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggPattern", new org.eigenbase.xom.XMLAttrVector()
				.add("pattern", pattern)
				.add("ignorecase", ignorecase)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) factcount);
			displayXMLElementArray(_out, measuresfactcount);
			displayXMLElementArray(_out, ignoreColumns);
			displayXMLElementArray(_out, foreignKeys);
			displayXMLElementArray(_out, measures);
			displayXMLElementArray(_out, levels);
			displayXMLElementArray(_out, excludes);
			_out.endTag("AggPattern");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggPattern _cother = (AggPattern)_other;
			boolean _diff = displayAttributeDiff("pattern", pattern, _cother.pattern, _out, _indent+1);
			_diff = _diff && displayElementDiff("factcount", factcount, _cother.factcount, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("measuresfactcount", measuresfactcount, _cother.measuresfactcount, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("ignoreColumns", ignoreColumns, _cother.ignoreColumns, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("foreignKeys", foreignKeys, _cother.foreignKeys, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("measures", measures, _cother.measures, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("levels", levels, _cother.levels, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("excludes", excludes, _cother.excludes, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getPattern() {
                return pattern;
            }
            public AggExclude[] getAggExcludes() {
                return excludes;
            }
		// END pass-through code block ---
	}

	public static class AggExclude extends org.eigenbase.xom.ElementDef
	{
		public AggExclude()
		{
		}

		public AggExclude(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				pattern = (String)_parser.getAttribute("pattern", "String", null, null, false);
				name = (String)_parser.getAttribute("name", "String", null, null, false);
				ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String pattern;  // optional attribute
		public String name;  // optional attribute
		public Boolean ignorecase;  // attribute default: true


		public String getName()
		{
			return "AggExclude";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "pattern", pattern, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "ignorecase", ignorecase, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggExclude", new org.eigenbase.xom.XMLAttrVector()
				.add("pattern", pattern)
				.add("name", name)
				.add("ignorecase", ignorecase)
				);
			_out.endTag("AggExclude");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggExclude _cother = (AggExclude)_other;
			boolean _diff = displayAttributeDiff("pattern", pattern, _cother.pattern, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("ignorecase", ignorecase, _cother.ignorecase, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getNameAttribute() {
                return name;
            }
            public String getPattern() {
                return pattern;
            }
            public boolean isIgnoreCase() {
                return ignorecase.booleanValue();
            }
		// END pass-through code block ---
	}

	public static abstract class AggColumnName extends org.eigenbase.xom.ElementDef
	{
		public AggColumnName()
		{
		}

		public AggColumnName(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				column = (String)_parser.getAttribute("column", "String", null, null, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String column;  // required attribute


		public String getName()
		{
			return "AggColumnName";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "column", column, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggColumnName", new org.eigenbase.xom.XMLAttrVector()
				.add("column", column)
				);
			_out.endTag("AggColumnName");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggColumnName _cother = (AggColumnName)_other;
			boolean _diff = displayAttributeDiff("column", column, _cother.column, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getColumnName() {
                return column;
            }
		// END pass-through code block ---
	}

	public static class AggFactCount extends AggColumnName
	{
		public AggFactCount()
		{
		}

		public AggFactCount(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				column = (String)_parser.getAttribute("column", "String", null, null, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "AggFactCount";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "column", column, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggFactCount", new org.eigenbase.xom.XMLAttrVector()
				.add("column", column)
				);
			_out.endTag("AggFactCount");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggFactCount _cother = (AggFactCount)_other;
			return true;
		}
	}

	public static class AggMeasureFactCount extends AggColumnName
	{
		public AggMeasureFactCount()
		{
		}

		public AggMeasureFactCount(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				factColumn = (String)_parser.getAttribute("factColumn", "String", null, null, true);
				column = (String)_parser.getAttribute("column", "String", null, null, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String factColumn;  // required attribute


		public String getName()
		{
			return "AggMeasureFactCount";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "factColumn", factColumn, _indent+1);
			displayAttribute(_out, "column", column, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggMeasureFactCount", new org.eigenbase.xom.XMLAttrVector()
				.add("factColumn", factColumn)
				.add("column", column)
				);
			_out.endTag("AggMeasureFactCount");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggMeasureFactCount _cother = (AggMeasureFactCount)_other;
			boolean _diff = displayAttributeDiff("factColumn", factColumn, _cother.factColumn, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getFactColumn() {
            return factColumn;
            }
		// END pass-through code block ---
	}

	public static class AggIgnoreColumn extends AggColumnName
	{
		public AggIgnoreColumn()
		{
		}

		public AggIgnoreColumn(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				column = (String)_parser.getAttribute("column", "String", null, null, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "AggIgnoreColumn";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "column", column, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggIgnoreColumn", new org.eigenbase.xom.XMLAttrVector()
				.add("column", column)
				);
			_out.endTag("AggIgnoreColumn");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggIgnoreColumn _cother = (AggIgnoreColumn)_other;
			return true;
		}
	}

	/**
	 * The name of the column mapping from base fact table foreign key
	 * to aggregate table foreign key.
	 */
	public static class AggForeignKey extends org.eigenbase.xom.ElementDef
	{
		public AggForeignKey()
		{
		}

		public AggForeignKey(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				factColumn = (String)_parser.getAttribute("factColumn", "String", null, null, true);
				aggColumn = (String)_parser.getAttribute("aggColumn", "String", null, null, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String factColumn;  // required attribute
		public String aggColumn;  // required attribute


		public String getName()
		{
			return "AggForeignKey";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "factColumn", factColumn, _indent+1);
			displayAttribute(_out, "aggColumn", aggColumn, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggForeignKey", new org.eigenbase.xom.XMLAttrVector()
				.add("factColumn", factColumn)
				.add("aggColumn", aggColumn)
				);
			_out.endTag("AggForeignKey");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggForeignKey _cother = (AggForeignKey)_other;
			boolean _diff = displayAttributeDiff("factColumn", factColumn, _cother.factColumn, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("aggColumn", aggColumn, _cother.aggColumn, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getFactFKColumnName() {
                return factColumn;
            }
            public String getAggregateFKColumnName() {
                return aggColumn;
            }
		// END pass-through code block ---
	}

	public static class AggLevel extends org.eigenbase.xom.ElementDef
	{
		public AggLevel()
		{
		}

		public AggLevel(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				column = (String)_parser.getAttribute("column", "String", null, null, true);
				ordinalColumn = (String)_parser.getAttribute("ordinalColumn", "String", null, null, false);
				captionColumn = (String)_parser.getAttribute("captionColumn", "String", null, null, false);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				nameColumn = (String)_parser.getAttribute("nameColumn", "String", null, null, false);
				collapsed = (Boolean)_parser.getAttribute("collapsed", "Boolean", "true", null, false);
				_tempArray = _parser.getArray(AggLevelProperty.class, 0, 0);
				properties = new AggLevelProperty[_tempArray.length];
				for (int _i = 0; _i < properties.length; _i++)
					properties[_i] = (AggLevelProperty)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String column;  // required attribute
		public String ordinalColumn;  // optional attribute
		public String captionColumn;  // optional attribute
		public String name;  // required attribute
		public String nameColumn;  // optional attribute
		public Boolean collapsed;  // attribute default: true

		public AggLevelProperty[] properties;  //optional array

		public String getName()
		{
			return "AggLevel";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "column", column, _indent+1);
			displayAttribute(_out, "ordinalColumn", ordinalColumn, _indent+1);
			displayAttribute(_out, "captionColumn", captionColumn, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "nameColumn", nameColumn, _indent+1);
			displayAttribute(_out, "collapsed", collapsed, _indent+1);
			displayElementArray(_out, "properties", properties, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggLevel", new org.eigenbase.xom.XMLAttrVector()
				.add("column", column)
				.add("ordinalColumn", ordinalColumn)
				.add("captionColumn", captionColumn)
				.add("name", name)
				.add("nameColumn", nameColumn)
				.add("collapsed", collapsed)
				);
			displayXMLElementArray(_out, properties);
			_out.endTag("AggLevel");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggLevel _cother = (AggLevel)_other;
			boolean _diff = displayAttributeDiff("column", column, _cother.column, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("ordinalColumn", ordinalColumn, _cother.ordinalColumn, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("captionColumn", captionColumn, _cother.captionColumn, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("nameColumn", nameColumn, _cother.nameColumn, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("collapsed", collapsed, _cother.collapsed, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("properties", properties, _cother.properties, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getNameAttribute() {
                return name;
            }
            public String getColumnName() {
                return column;
            }
            public boolean isCollapsed() {
                return collapsed;
            }
		// END pass-through code block ---
	}

	/**
	 * Member property.
	 */
	public static class AggLevelProperty extends org.eigenbase.xom.ElementDef
	{
		public AggLevelProperty()
		{
		}

		public AggLevelProperty(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, false);
				column = (String)_parser.getAttribute("column", "String", null, null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // optional attribute
		public String column;  // optional attribute


		public String getName()
		{
			return "AggLevelProperty";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "column", column, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggLevelProperty", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("column", column)
				);
			_out.endTag("AggLevelProperty");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggLevelProperty _cother = (AggLevelProperty)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("column", column, _cother.column, _out, _indent+1);
			return _diff;
		}
	}

	public static class AggMeasure extends org.eigenbase.xom.ElementDef
	{
		public AggMeasure()
		{
		}

		public AggMeasure(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				column = (String)_parser.getAttribute("column", "String", null, null, true);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				rollupType = (String)_parser.getAttribute("rollupType", "String", null, null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String column;  // required attribute
		public String name;  // required attribute
		public String rollupType;  // optional attribute


		public String getName()
		{
			return "AggMeasure";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "column", column, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "rollupType", rollupType, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("AggMeasure", new org.eigenbase.xom.XMLAttrVector()
				.add("column", column)
				.add("name", name)
				.add("rollupType", rollupType)
				);
			_out.endTag("AggMeasure");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			AggMeasure _cother = (AggMeasure)_other;
			boolean _diff = displayAttributeDiff("column", column, _cother.column, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("rollupType", rollupType, _cother.rollupType, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String getNameAttribute() {
                return name;
            }
            public String getColumn() {
                return column;
            }
            public String getRollupType() {
                return rollupType;
            }
		// END pass-through code block ---
	}

	public interface Expression extends org.eigenbase.xom.NodeDef
	{
		// BEGIN pass-through code block ---
public abstract String getExpression(SqlQuery query);
            public abstract String getGenericExpression();
            public abstract String getTableAlias();
		// END pass-through code block ---
	}

	public static class Column extends org.eigenbase.xom.ElementDef implements Expression
	{
		public Column()
		{
		}

		public Column(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				table = (String)_parser.getAttribute("table", "String", null, null, false);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String table;  // optional attribute
		public String name;  // required attribute


		public String getName()
		{
			return "Column";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "table", table, _indent+1);
			displayAttribute(_out, "name", name, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Column", new org.eigenbase.xom.XMLAttrVector()
				.add("table", table)
				.add("name", name)
				);
			_out.endTag("Column");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Column _cother = (Column)_other;
			boolean _diff = displayAttributeDiff("table", table, _cother.table, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
private String genericExpression;

            /** Convenience constructor. */
            public Column(String table, String name) {
                this();
                Util.assertTrue(name != null);
                this.table = table;
                this.name = name;
                this.genericExpression = table == null ? name : (table + "." + name);
            }

            public String getExpression(SqlQuery query) {
                return query.getDialect().quoteIdentifier(table, name);
            }

            public String getGenericExpression() {
                return genericExpression;
            }

            public String getColumnName() {
                return name;
            }
            public String getTableAlias() {
                return table;
            }
            public int hashCode() {
                return name.hashCode() ^ (table==null ? 0 : table.hashCode());
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Column)) {
                    return false;
                }
                Column that = (Column) obj;
                return this.name.equals(that.name) &&
                        Util.equals(this.table, that.table);
            }
		// END pass-through code block ---
	}

	/**
	 * A collection of SQL expressions, one per dialect.
	 */
	public static abstract class ExpressionView extends org.eigenbase.xom.ElementDef implements Expression
	{
		public ExpressionView()
		{
		}

		public ExpressionView(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(SQL.class, 1, 0);
				expressions = new SQL[_tempArray.length];
				for (int _i = 0; _i < expressions.length; _i++)
					expressions[_i] = (SQL)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}


		public SQL[] expressions;  //min 1

		public String getName()
		{
			return "ExpressionView";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "expressions", expressions, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("ExpressionView", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, expressions);
			_out.endTag("ExpressionView");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			ExpressionView _cother = (ExpressionView)_other;
			boolean _diff = displayElementArrayDiff("expressions", expressions, _cother.expressions, _out, _indent+1);
			return _diff;
		}
		// BEGIN pass-through code block ---
public String toString() {
                return expressions[0].cdata;
            }

            public String getExpression(SqlQuery query) {
                return SQL.toCodeSet(expressions).chooseQuery(query.getDialect());
            }

            public String getGenericExpression() {
                for (int i = 0; i < expressions.length; i++) {
                    if (expressions[i].dialect.equals("generic")) {
                        return expressions[i].cdata;
                    }
                }
                return expressions[0].cdata;
            }

            public String getTableAlias() {
                return null;
            }

            public int hashCode() {
                int h = 17;
                for (int i = 0; i < expressions.length; i++) {
                    h = 37 * h + expressions[i].hashCode();
                }
                return h;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof ExpressionView)) {
                    return false;
                }
                ExpressionView that = (ExpressionView) obj;
                if (this.expressions.length != that.expressions.length) {
                    return false;
                }
                for (int i = 0; i < expressions.length; i++) {
                    if (! this.expressions[i].equals(that.expressions[i])) {
                        return false;
                    }
                }
                return true;
            }
		// END pass-through code block ---
	}

	public static class KeyExpression extends ExpressionView
	{
		public KeyExpression()
		{
		}

		public KeyExpression(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(SQL.class, 1, 0);
				expressions = new SQL[_tempArray.length];
				for (int _i = 0; _i < expressions.length; _i++)
					expressions[_i] = (SQL)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "KeyExpression";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "expressions", expressions, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("KeyExpression", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, expressions);
			_out.endTag("KeyExpression");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			KeyExpression _cother = (KeyExpression)_other;
			boolean _diff = displayElementArrayDiff("expressions", expressions, _cother.expressions, _out, _indent+1);
			return _diff;
		}
	}

	public static class ParentExpression extends ExpressionView
	{
		public ParentExpression()
		{
		}

		public ParentExpression(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(SQL.class, 1, 0);
				expressions = new SQL[_tempArray.length];
				for (int _i = 0; _i < expressions.length; _i++)
					expressions[_i] = (SQL)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "ParentExpression";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "expressions", expressions, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("ParentExpression", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, expressions);
			_out.endTag("ParentExpression");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			ParentExpression _cother = (ParentExpression)_other;
			boolean _diff = displayElementArrayDiff("expressions", expressions, _cother.expressions, _out, _indent+1);
			return _diff;
		}
	}

	public static class OrdinalExpression extends ExpressionView
	{
		public OrdinalExpression()
		{
		}

		public OrdinalExpression(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(SQL.class, 1, 0);
				expressions = new SQL[_tempArray.length];
				for (int _i = 0; _i < expressions.length; _i++)
					expressions[_i] = (SQL)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "OrdinalExpression";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "expressions", expressions, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("OrdinalExpression", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, expressions);
			_out.endTag("OrdinalExpression");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			OrdinalExpression _cother = (OrdinalExpression)_other;
			boolean _diff = displayElementArrayDiff("expressions", expressions, _cother.expressions, _out, _indent+1);
			return _diff;
		}
	}

	public static class NameExpression extends ExpressionView
	{
		public NameExpression()
		{
		}

		public NameExpression(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(SQL.class, 1, 0);
				expressions = new SQL[_tempArray.length];
				for (int _i = 0; _i < expressions.length; _i++)
					expressions[_i] = (SQL)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "NameExpression";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "expressions", expressions, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("NameExpression", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, expressions);
			_out.endTag("NameExpression");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			NameExpression _cother = (NameExpression)_other;
			boolean _diff = displayElementArrayDiff("expressions", expressions, _cother.expressions, _out, _indent+1);
			return _diff;
		}
	}

	public static class CaptionExpression extends ExpressionView
	{
		public CaptionExpression()
		{
		}

		public CaptionExpression(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(SQL.class, 1, 0);
				expressions = new SQL[_tempArray.length];
				for (int _i = 0; _i < expressions.length; _i++)
					expressions[_i] = (SQL)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "CaptionExpression";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "expressions", expressions, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("CaptionExpression", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, expressions);
			_out.endTag("CaptionExpression");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			CaptionExpression _cother = (CaptionExpression)_other;
			boolean _diff = displayElementArrayDiff("expressions", expressions, _cother.expressions, _out, _indent+1);
			return _diff;
		}
	}

	public static class MeasureExpression extends ExpressionView
	{
		public MeasureExpression()
		{
		}

		public MeasureExpression(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(SQL.class, 1, 0);
				expressions = new SQL[_tempArray.length];
				for (int _i = 0; _i < expressions.length; _i++)
					expressions[_i] = (SQL)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "MeasureExpression";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "expressions", expressions, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("MeasureExpression", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, expressions);
			_out.endTag("MeasureExpression");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			MeasureExpression _cother = (MeasureExpression)_other;
			boolean _diff = displayElementArrayDiff("expressions", expressions, _cother.expressions, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * A role defines an access-control profile. It has a series of grants
	 * (or denials) for schema elements.
	 */
	public static class Role extends org.eigenbase.xom.ElementDef
	{
		public Role()
		{
		}

		public Role(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				annotations = (Annotations)_parser.getElement(Annotations.class, false);
				_tempArray = _parser.getArray(SchemaGrant.class, 0, 0);
				schemaGrants = new SchemaGrant[_tempArray.length];
				for (int _i = 0; _i < schemaGrants.length; _i++)
					schemaGrants[_i] = (SchemaGrant)_tempArray[_i];
				union = (Union)_parser.getElement(Union.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute

		/**
		 * Contains values of user-defined properties.
		 */
		public Annotations annotations;  //optional element
		public SchemaGrant[] schemaGrants;  //optional array
		public Union union;  //optional element

		public String getName()
		{
			return "Role";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayElement(_out, "annotations", (org.eigenbase.xom.ElementDef) annotations, _indent+1);
			displayElementArray(_out, "schemaGrants", schemaGrants, _indent+1);
			displayElement(_out, "union", (org.eigenbase.xom.ElementDef) union, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Role", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) annotations);
			displayXMLElementArray(_out, schemaGrants);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) union);
			_out.endTag("Role");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Role _cother = (Role)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayElementDiff("annotations", annotations, _cother.annotations, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("schemaGrants", schemaGrants, _cother.schemaGrants, _out, _indent+1);
			_diff = _diff && displayElementDiff("union", union, _cother.union, _out, _indent+1);
			return _diff;
		}
	}

	public interface Grant extends org.eigenbase.xom.NodeDef
	{
	}

	/**
	 * Grants (or denies) this role access to this schema.
	 * access may be "all", "all_dimensions", "custom"
	 * or "none".
	 * If access is "all_dimensions", the role has access
	 * to all dimensions but still needs explicit access to cubes.
	 * If access is "custom", no access will be inherited by
	 * cubes for which no explicit rule is set.
	 * If access is "all_dimensions", an implicut access is
	 * given to all dimensions of the schema's cubes, provided the cube's
	 * access attribute is either "custom" or "all".
	 * See mondrian.olap.Role#grant(mondrian.olap.Schema,int).
	 */
	public static class SchemaGrant extends org.eigenbase.xom.ElementDef implements Grant
	{
		public SchemaGrant()
		{
		}

		public SchemaGrant(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
				_tempArray = _parser.getArray(CubeGrant.class, 0, 0);
				cubeGrants = new CubeGrant[_tempArray.length];
				for (int _i = 0; _i < cubeGrants.length; _i++)
					cubeGrants[_i] = (CubeGrant)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		/** Allowable values for {@link #access}. */
		public static final String[] _access_values = {"all", "custom", "none", "all_dimensions"};
		public String access;  // required attribute

		public CubeGrant[] cubeGrants;  //optional array

		public String getName()
		{
			return "SchemaGrant";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "access", access, _indent+1);
			displayElementArray(_out, "cubeGrants", cubeGrants, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("SchemaGrant", new org.eigenbase.xom.XMLAttrVector()
				.add("access", access)
				);
			displayXMLElementArray(_out, cubeGrants);
			_out.endTag("SchemaGrant");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			SchemaGrant _cother = (SchemaGrant)_other;
			boolean _diff = displayElementArrayDiff("cubeGrants", cubeGrants, _cother.cubeGrants, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Grants (or denies) this role access to a cube.
	 * access may be "all", "custom", or "none".
	 * If access is "custom", no access will be inherited
	 * by the dimensions of this cube, unless the parent SchemaGrant is
	 * set to "ALL_DIMENSIONS".
	 * See mondrian.olap.Role#grant(mondrian.olap.Cube,int).
	 */
	public static class CubeGrant extends org.eigenbase.xom.ElementDef implements Grant
	{
		public CubeGrant()
		{
		}

		public CubeGrant(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				cube = (String)_parser.getAttribute("cube", "String", null, null, true);
				access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
				_tempArray = _parser.getArray(DimensionGrant.class, 0, 0);
				dimensionGrants = new DimensionGrant[_tempArray.length];
				for (int _i = 0; _i < dimensionGrants.length; _i++)
					dimensionGrants[_i] = (DimensionGrant)_tempArray[_i];
				_tempArray = _parser.getArray(HierarchyGrant.class, 0, 0);
				hierarchyGrants = new HierarchyGrant[_tempArray.length];
				for (int _i = 0; _i < hierarchyGrants.length; _i++)
					hierarchyGrants[_i] = (HierarchyGrant)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		/** Allowable values for {@link #access}. */
		public static final String[] _access_values = {"all", "custom", "none", "all_dimensions"};
		public String access;  // required attribute
		public String cube;  // required attribute

		public DimensionGrant[] dimensionGrants;  //optional array
		public HierarchyGrant[] hierarchyGrants;  //optional array

		public String getName()
		{
			return "CubeGrant";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "cube", cube, _indent+1);
			displayAttribute(_out, "access", access, _indent+1);
			displayElementArray(_out, "dimensionGrants", dimensionGrants, _indent+1);
			displayElementArray(_out, "hierarchyGrants", hierarchyGrants, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("CubeGrant", new org.eigenbase.xom.XMLAttrVector()
				.add("cube", cube)
				.add("access", access)
				);
			displayXMLElementArray(_out, dimensionGrants);
			displayXMLElementArray(_out, hierarchyGrants);
			_out.endTag("CubeGrant");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			CubeGrant _cother = (CubeGrant)_other;
			boolean _diff = displayAttributeDiff("cube", cube, _cother.cube, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("dimensionGrants", dimensionGrants, _cother.dimensionGrants, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("hierarchyGrants", hierarchyGrants, _cother.hierarchyGrants, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Grants (or denies) this role access to a dimension.
	 * access may be "all", "custom" or "none".
	 * Note that a role is implicitly given access to a dimension when it
	 * is given "ALL" acess to a cube.
	 * If access is "custom", no access will be inherited
	 * by the hierarchies of this dimension.
	 * If the parent schema access is "ALL_DIMENSIONS",
	 * this timension will inherit access "ALL".
	 * See also the "all_dimensions" option of the "SchemaGrant" element.
	 * See mondrian.olap.Role#grant(mondrian.olap.Dimension,int).
	 */
	public static class DimensionGrant extends org.eigenbase.xom.ElementDef implements Grant
	{
		public DimensionGrant()
		{
		}

		public DimensionGrant(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
				access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		/** Allowable values for {@link #access}. */
		public static final String[] _access_values = {"all", "custom", "none", "all_dimensions"};
		public String access;  // required attribute
		public String dimension;  // required attribute


		public String getName()
		{
			return "DimensionGrant";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "dimension", dimension, _indent+1);
			displayAttribute(_out, "access", access, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("DimensionGrant", new org.eigenbase.xom.XMLAttrVector()
				.add("dimension", dimension)
				.add("access", access)
				);
			_out.endTag("DimensionGrant");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			DimensionGrant _cother = (DimensionGrant)_other;
			boolean _diff = displayAttributeDiff("dimension", dimension, _cother.dimension, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Grants (or denies) this role access to a hierarchy.
	 * access may be "all", "custom" or "none".
	 * If access is "custom", you may also specify the
	 * attributes topLevel, bottomLevel, and
	 * the member grants.
	 * If access is "custom", the child levels of this
	 * hierarchy will not inherit access rights from this hierarchy,
	 * should there be no explicit rules defined for the said child level.
	 * See mondrian.olap.Role#grant(mondrian.olap.Hierarchy, int, mondrian.olap.Level).
	 */
	public static class HierarchyGrant extends org.eigenbase.xom.ElementDef implements Grant
	{
		public HierarchyGrant()
		{
		}

		public HierarchyGrant(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				hierarchy = (String)_parser.getAttribute("hierarchy", "String", null, null, true);
				topLevel = (String)_parser.getAttribute("topLevel", "String", null, null, false);
				bottomLevel = (String)_parser.getAttribute("bottomLevel", "String", null, null, false);
				rollupPolicy = (String)_parser.getAttribute("rollupPolicy", "String", null, null, false);
				access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
				_tempArray = _parser.getArray(MemberGrant.class, 0, 0);
				memberGrants = new MemberGrant[_tempArray.length];
				for (int _i = 0; _i < memberGrants.length; _i++)
					memberGrants[_i] = (MemberGrant)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		/** Allowable values for {@link #access}. */
		public static final String[] _access_values = {"all", "custom", "none", "all_dimensions"};
		public String access;  // required attribute
		public String hierarchy;  // required attribute
		public String topLevel;  // optional attribute
		public String bottomLevel;  // optional attribute
		public String rollupPolicy;  // optional attribute

		public MemberGrant[] memberGrants;  //optional array

		public String getName()
		{
			return "HierarchyGrant";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "hierarchy", hierarchy, _indent+1);
			displayAttribute(_out, "topLevel", topLevel, _indent+1);
			displayAttribute(_out, "bottomLevel", bottomLevel, _indent+1);
			displayAttribute(_out, "rollupPolicy", rollupPolicy, _indent+1);
			displayAttribute(_out, "access", access, _indent+1);
			displayElementArray(_out, "memberGrants", memberGrants, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("HierarchyGrant", new org.eigenbase.xom.XMLAttrVector()
				.add("hierarchy", hierarchy)
				.add("topLevel", topLevel)
				.add("bottomLevel", bottomLevel)
				.add("rollupPolicy", rollupPolicy)
				.add("access", access)
				);
			displayXMLElementArray(_out, memberGrants);
			_out.endTag("HierarchyGrant");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			HierarchyGrant _cother = (HierarchyGrant)_other;
			boolean _diff = displayAttributeDiff("hierarchy", hierarchy, _cother.hierarchy, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("topLevel", topLevel, _cother.topLevel, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("bottomLevel", bottomLevel, _cother.bottomLevel, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("rollupPolicy", rollupPolicy, _cother.rollupPolicy, _out, _indent+1);
			_diff = _diff && displayElementArrayDiff("memberGrants", memberGrants, _cother.memberGrants, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Grants (or denies) this role access to a member.
	 * The children of this member inherit that access.
	 * You can implicitly see a member if you can see any of its children.
	 * See mondrian.olap.Role#grant(mondrian.olap.Member,int).
	 */
	public static class MemberGrant extends org.eigenbase.xom.ElementDef
	{
		public MemberGrant()
		{
		}

		public MemberGrant(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				member = (String)_parser.getAttribute("member", "String", null, null, true);
				access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String member;  // required attribute
		/** Allowable values for {@link #access}. */
		public static final String[] _access_values = {"all", "none"};
		public String access;  // required attribute


		public String getName()
		{
			return "MemberGrant";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "member", member, _indent+1);
			displayAttribute(_out, "access", access, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("MemberGrant", new org.eigenbase.xom.XMLAttrVector()
				.add("member", member)
				.add("access", access)
				);
			_out.endTag("MemberGrant");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			MemberGrant _cother = (MemberGrant)_other;
			boolean _diff = displayAttributeDiff("member", member, _cother.member, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("access", access, _cother.access, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Body of a Role definition which defines a Role to be the union
	 * of several Roles. The RoleUsage elements must refer to Roles that
	 * have been declared earlier in this schema file.
	 */
	public static class Union extends org.eigenbase.xom.ElementDef
	{
		public Union()
		{
		}

		public Union(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(RoleUsage.class, 0, 0);
				roleUsages = new RoleUsage[_tempArray.length];
				for (int _i = 0; _i < roleUsages.length; _i++)
					roleUsages[_i] = (RoleUsage)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}


		public RoleUsage[] roleUsages;  //optional array

		public String getName()
		{
			return "Union";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "roleUsages", roleUsages, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Union", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, roleUsages);
			_out.endTag("Union");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Union _cother = (Union)_other;
			boolean _diff = displayElementArrayDiff("roleUsages", roleUsages, _cother.roleUsages, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Usage of a Role in a union Role.
	 */
	public static class RoleUsage extends org.eigenbase.xom.ElementDef
	{
		public RoleUsage()
		{
		}

		public RoleUsage(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				roleName = (String)_parser.getAttribute("roleName", "String", null, null, true);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String roleName;  // required attribute


		public String getName()
		{
			return "RoleUsage";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "roleName", roleName, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("RoleUsage", new org.eigenbase.xom.XMLAttrVector()
				.add("roleName", roleName)
				);
			_out.endTag("RoleUsage");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			RoleUsage _cother = (RoleUsage)_other;
			boolean _diff = displayAttributeDiff("roleName", roleName, _cother.roleName, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * A UserDefinedFunction is a function which
	 * extends the MDX language. It must be implemented by a Java
	 * class which implements the interface
	 * mondrian.spi.UserDefinedFunction.
	 */
	public static class UserDefinedFunction extends org.eigenbase.xom.ElementDef
	{
		public UserDefinedFunction()
		{
		}

		public UserDefinedFunction(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				className = (String)_parser.getAttribute("className", "String", null, null, false);
				script = (Script)_parser.getElement(Script.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String className;  // optional attribute

		/**
		 * Script to implement this user-defined function.
		 * Either the "Script" element or the "className" attribute
		 * must be specified.
		 */
		public Script script;  //optional element

		public String getName()
		{
			return "UserDefinedFunction";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "className", className, _indent+1);
			displayElement(_out, "script", (org.eigenbase.xom.ElementDef) script, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("UserDefinedFunction", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("className", className)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) script);
			_out.endTag("UserDefinedFunction");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			UserDefinedFunction _cother = (UserDefinedFunction)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("className", className, _cother.className, _out, _indent+1);
			_diff = _diff && displayElementDiff("script", script, _cother.script, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * A Parameter defines a schema parameter.
	 * It can be referenced from an MDX statement using the ParamRef
	 * function and, if not final, its value can be overridden.
	 */
	public static class Parameter extends org.eigenbase.xom.ElementDef
	{
		public Parameter()
		{
		}

		public Parameter(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				description = (String)_parser.getAttribute("description", "String", null, null, false);
				type = (String)_parser.getAttribute("type", "String", "String", _type_values, true);
				modifiable = (Boolean)_parser.getAttribute("modifiable", "Boolean", "true", null, false);
				defaultValue = (String)_parser.getAttribute("defaultValue", "String", null, null, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute
		public String description;  // optional attribute
		/** Allowable values for {@link #type}. */
		public static final String[] _type_values = {"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp", "Member"};
		public String type;  // attribute default: String
		public Boolean modifiable;  // attribute default: true
		public String defaultValue;  // optional attribute


		public String getName()
		{
			return "Parameter";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayAttribute(_out, "description", description, _indent+1);
			displayAttribute(_out, "type", type, _indent+1);
			displayAttribute(_out, "modifiable", modifiable, _indent+1);
			displayAttribute(_out, "defaultValue", defaultValue, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Parameter", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				.add("description", description)
				.add("type", type)
				.add("modifiable", modifiable)
				.add("defaultValue", defaultValue)
				);
			_out.endTag("Parameter");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Parameter _cother = (Parameter)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("description", description, _cother.description, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("type", type, _cother.type, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("modifiable", modifiable, _cother.modifiable, _out, _indent+1);
			_diff = _diff && displayAttributeDiff("defaultValue", defaultValue, _cother.defaultValue, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Holder for an array of Annotation elements
	 */
	public static class Annotations extends org.eigenbase.xom.ElementDef
	{
		public Annotations()
		{
		}

		public Annotations(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				org.eigenbase.xom.NodeDef[] _tempArray;
				_tempArray = _parser.getArray(Annotation.class, 0, 0);
				array = new Annotation[_tempArray.length];
				for (int _i = 0; _i < array.length; _i++)
					array[_i] = (Annotation)_tempArray[_i];
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}


		public Annotation[] array;  //optional array

		public String getName()
		{
			return "Annotations";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayElementArray(_out, "array", array, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Annotations", new org.eigenbase.xom.XMLAttrVector()
				);
			displayXMLElementArray(_out, array);
			_out.endTag("Annotations");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Annotations _cother = (Annotations)_other;
			boolean _diff = displayElementArrayDiff("array", array, _cother.array, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * User-defined property value.
	 */
	public static class Annotation extends org.eigenbase.xom.ElementDef
	{
		public Annotation()
		{
		}

		public Annotation(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				name = (String)_parser.getAttribute("name", "String", null, null, true);
				cdata = _parser.getText();
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String name;  // required attribute

		public String cdata;  // All text goes here
		public String getName()
		{
			return "Annotation";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "name", name, _indent+1);
			displayString(_out, "cdata", cdata, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Annotation", new org.eigenbase.xom.XMLAttrVector()
				.add("name", name)
				);
			_out.cdata(cdata);
			_out.endTag("Annotation");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Annotation _cother = (Annotation)_other;
			boolean _diff = displayAttributeDiff("name", name, _cother.name, _out, _indent+1);
			_diff = _diff && displayStringDiff("cdata", cdata, _cother.cdata, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Script fragment to implement an SPI such as user-defined function,
	 * member formatter, cell formatter.
	 */
	public static class Script extends org.eigenbase.xom.ElementDef
	{
		public Script()
		{
		}

		public Script(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				language = (String)_parser.getAttribute("language", "String", "JavaScript", null, false);
				cdata = _parser.getText();
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String language;  // attribute default: JavaScript

		public String cdata;  // All text goes here
		public String getName()
		{
			return "Script";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "language", language, _indent+1);
			displayString(_out, "cdata", cdata, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("Script", new org.eigenbase.xom.XMLAttrVector()
				.add("language", language)
				);
			_out.cdata(cdata);
			_out.endTag("Script");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			Script _cother = (Script)_other;
			boolean _diff = displayAttributeDiff("language", language, _cother.language, _out, _indent+1);
			_diff = _diff && displayStringDiff("cdata", cdata, _cother.cdata, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Abstract type just in order to avoid duplication.
	 */
	public static abstract class ElementFormatter extends org.eigenbase.xom.ElementDef
	{
		public ElementFormatter()
		{
		}

		public ElementFormatter(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				className = (String)_parser.getAttribute("className", "String", null, null, false);
				script = (Script)_parser.getElement(Script.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}

		public String className;  // optional attribute

		/**
		 * Script to implement this formatter.
		 * Either the "Script" element or the "className" attribute
		 * must be specified.
		 */
		public Script script;  //optional element

		public String getName()
		{
			return "ElementFormatter";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "className", className, _indent+1);
			displayElement(_out, "script", (org.eigenbase.xom.ElementDef) script, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("ElementFormatter", new org.eigenbase.xom.XMLAttrVector()
				.add("className", className)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) script);
			_out.endTag("ElementFormatter");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			ElementFormatter _cother = (ElementFormatter)_other;
			boolean _diff = displayAttributeDiff("className", className, _cother.className, _out, _indent+1);
			_diff = _diff && displayElementDiff("script", script, _cother.script, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Plugin that formats the values of cells.
	 * It must be implemented by a Java
	 * class which implements the interface
	 * mondrian.spi.CellFormatter,
	 * or by a script.
	 */
	public static class CellFormatter extends ElementFormatter
	{
		public CellFormatter()
		{
		}

		public CellFormatter(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				className = (String)_parser.getAttribute("className", "String", null, null, false);
				script = (Script)_parser.getElement(Script.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "CellFormatter";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "className", className, _indent+1);
			displayElement(_out, "script", (org.eigenbase.xom.ElementDef) script, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("CellFormatter", new org.eigenbase.xom.XMLAttrVector()
				.add("className", className)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) script);
			_out.endTag("CellFormatter");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			CellFormatter _cother = (CellFormatter)_other;
			boolean _diff = displayElementDiff("script", script, _cother.script, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Plugin that formats members.
	 * It must be implemented by a Java
	 * class which implements the interface
	 * mondrian.spi.MemberFormatter,
	 * or by a script.
	 */
	public static class MemberFormatter extends ElementFormatter
	{
		public MemberFormatter()
		{
		}

		public MemberFormatter(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				className = (String)_parser.getAttribute("className", "String", null, null, false);
				script = (Script)_parser.getElement(Script.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "MemberFormatter";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "className", className, _indent+1);
			displayElement(_out, "script", (org.eigenbase.xom.ElementDef) script, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("MemberFormatter", new org.eigenbase.xom.XMLAttrVector()
				.add("className", className)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) script);
			_out.endTag("MemberFormatter");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			MemberFormatter _cother = (MemberFormatter)_other;
			boolean _diff = displayElementDiff("script", script, _cother.script, _out, _indent+1);
			return _diff;
		}
	}

	/**
	 * Plugin that formats properties.
	 * It must be implemented by a Java
	 * class which implements the interface
	 * mondrian.spi.PropertyFormatter,
	 * or by a script.
	 */
	public static class PropertyFormatter extends ElementFormatter
	{
		public PropertyFormatter()
		{
		}

		public PropertyFormatter(org.eigenbase.xom.DOMWrapper _def)
			throws org.eigenbase.xom.XOMException
		{
			try {
				org.eigenbase.xom.DOMElementParser _parser = new org.eigenbase.xom.DOMElementParser(_def, "", MondrianDef.class);
				className = (String)_parser.getAttribute("className", "String", null, null, false);
				script = (Script)_parser.getElement(Script.class, false);
			} catch(org.eigenbase.xom.XOMException _ex) {
				throw new org.eigenbase.xom.XOMException("In " + getName() + ": " + _ex.getMessage());
			}
		}



		public String getName()
		{
			return "PropertyFormatter";
		}

		public void display(java.io.PrintWriter _out, int _indent)
		{
			_out.println(getName());
			displayAttribute(_out, "className", className, _indent+1);
			displayElement(_out, "script", (org.eigenbase.xom.ElementDef) script, _indent+1);
		}
		public void displayXML(org.eigenbase.xom.XMLOutput _out, int _indent)
		{
			_out.beginTag("PropertyFormatter", new org.eigenbase.xom.XMLAttrVector()
				.add("className", className)
				);
			displayXMLElement(_out, (org.eigenbase.xom.ElementDef) script);
			_out.endTag("PropertyFormatter");
		}
		public boolean displayDiff(org.eigenbase.xom.ElementDef _other, java.io.PrintWriter _out, int _indent)
		{
			PropertyFormatter _cother = (PropertyFormatter)_other;
			boolean _diff = displayElementDiff("script", script, _cother.script, _out, _indent+1);
			return _diff;
		}
	}


}
