// Css attributes from tailwindcss
export const BackdropFilterEnum = {
  'blur-sm': 'blur(4px)',
  blur: 'blur(8px)',
  'blur-md': 'blur(12px)',
  'blur-lg': 'blur(16px)',
  'blur-xl': 'blur(24px)',
  'blur-2xl': 'blur(40px)',
  'blur-3xl': 'blur(64px)',
  'brightness-50': 'brightness(.5)',
  'brightness-75': 'brightness(.75)',
  'brightness-100': 'brightness(1)',
  'brightness-125': 'brightness(1.25)',
  'brightness-150': 'brightness(1.5)',
  'brightness-200': 'brightness(2)',
  'contrast-0': 'contrast(0)',
  'contrast-50': 'contrast(.5)',
  'contrast-75': 'contrast(.75)',
  'contrast-100': 'contrast(1)',
  'contrast-125': 'contrast(1.25)',
  'contrast-150': 'contrast(1.5)',
  'contrast-200': 'contrast(2)',
  'grayscale-0': 'grayscale(0)',
  grayscale: 'grayscale(100%)',
  'hue-rotate-0': 'hue-rotate(0deg)',
  'hue-rotate-15': 'hue-rotate(15deg)',
  'hue-rotate-30': 'hue-rotate(30deg)',
  'hue-rotate-60': 'hue-rotate(60deg)',
  'hue-rotate-90': 'hue-rotate(90deg)',
  'hue-rotate-180': 'hue-rotate(180deg)',
  'invert-0': 'invert(0)',
  invert: 'invert(100%)',
  'opacity-10': 'opacity(0.1)',
  'saturate-50': 'saturate(.5)',
  'sepia-0': 'sepia(0)',
  sepia: 'sepia(100%)'
}

export const FilterEnum = {
  'blur-none': 'blur(0)',
  'blur-sm': 'blur(4px)',
  blur: 'blur(8px)',
  'blur-md': 'blur(12px)',
  'blur-lg': 'blur(16px)',
  'blur-xl': 'blur(24px)',
  'blur-2xl': 'blur(40px)',
  'blur-3xl': 'blur(64px)',
  'brightness-0': 'brightness(0)',
  'brightness-50': 'brightness(.5)',
  'brightness-75': 'brightness(.75)',
  'brightness-90': 'brightness(.9)',
  'brightness-95': 'brightness(.95)',
  'brightness-100': 'brightness(1)',
  'brightness-105': 'brightness(1.05)',
  'brightness-110': 'brightness(1.1)',
  'brightness-125': 'brightness(1.25)',
  'brightness-150': 'brightness(1.5)',
  'brightness-200': 'brightness(2)',
  'contrast-0': 'contrast(0)',
  'contrast-50': 'contrast(.5)',
  'contrast-75': 'contrast(.75)',
  'contrast-100': 'contrast(1)',
  'contrast-125': 'contrast(1.25)',
  'contrast-150': 'contrast(1.5)',
  'contrast-200': 'contrast(2)',
  'drop-shadow-sm': 'drop-shadow(0 1px 1px rgb(0 0 0 / 0.05))',
  'drop-shadow': 'drop-shadow(0 1px 2px rgb(0 0 0 / 0.1)) drop-shadow(0 1px 1px rgb(0 0 0 / 0.06))',
  'drop-shadow-md': 'drop-shadow(0 4px 3px rgb(0 0 0 / 0.07)) drop-shadow(0 2px 2px rgb(0 0 0 / 0.06))',
  'drop-shadow-lg': 'drop-shadow(0 10px 8px rgb(0 0 0 / 0.04)) drop-shadow(0 4px 3px rgb(0 0 0 / 0.1))',
  'drop-shadow-xl': 'drop-shadow(0 20px 13px rgb(0 0 0 / 0.03)) drop-shadow(0 8px 5px rgb(0 0 0 / 0.08))',
  'drop-shadow-2xl': 'drop-shadow(0 25px 25px rgb(0 0 0 / 0.15))',
  'drop-shadow-none': 'drop-shadow(0 0 #0000)',
  'grayscale-0': 'grayscale(0)',
  grayscale: 'grayscale(100%)',
  'hue-rotate-0': 'hue-rotate(0deg)',
  'hue-rotate-15': 'hue-rotate(15deg)',
  'hue-rotate-30': 'hue-rotate(30deg)',
  'hue-rotate-60': 'hue-rotate(60deg)',
  'hue-rotate-90': 'hue-rotate(90deg)',
  'hue-rotate-180': 'hue-rotate(180deg)',
  'invert-0': 'invert(0)',
  invert: 'invert(100%)',
  'saturate-0': 'saturate(0)',
  'saturate-50': 'saturate(.5)',
  'saturate-100': 'saturate(1)',
  'saturate-150': 'saturate(1.5)',
  'saturate-200': 'saturate(2)',
  'sepia-0': 'sepia(0)',
  sepia: 'sepia(100%)'
}
