import { TimeGranularity } from "@metad/ocap-core";

export const TIME_GRANULARITY_SEQUENCES = {
  0: [TimeGranularity.Year, TimeGranularity.Month],
  1: [TimeGranularity.Year, TimeGranularity.Quarter, TimeGranularity.Month],
  2: [TimeGranularity.Year, TimeGranularity.Month, TimeGranularity.Day],
  3: [TimeGranularity.Year, TimeGranularity.Quarter, TimeGranularity.Month, TimeGranularity.Day],
}

export const PERIODS = [
  {
    name: '1W',
    granularity: TimeGranularity.Day,
    lookBack: 7
  },
  {
    name: '1M',
    granularity: TimeGranularity.Day,
    lookBack: 30
  },
  {
    name: '3M',
    granularity: TimeGranularity.Day,
    lookBack: 90
  },
  {
    name: '6M',
    granularity: TimeGranularity.Day,
    lookBack: 180
  },
  {
    name: '1Y',
    granularity: TimeGranularity.Month,
    lookBack: 12
  },
  {
    name: '2Y',
    granularity: TimeGranularity.Month,
    lookBack: 24
  },
  {
    name: '3Y',
    granularity: TimeGranularity.Month,
    lookBack: 36
  },
  {
    name: '4Y',
    granularity: TimeGranularity.Month,
    lookBack: 48
  },
  {
    name: '5Y',
    granularity: TimeGranularity.Month,
    lookBack: 60
  }
]